import{s as ls,o as is,n as as}from"../chunks/scheduler.aec39e6a.js";import{S as os,i as ps,e as i,s as a,c as M,h as rs,a as o,d as s,b as l,f as ts,g as d,j as p,k as ss,l as Ms,m as n,n as c,t as m,o as u,p as h}from"../chunks/index.4ee0a2d0.js";import{T as ns}from"../chunks/Tip.e2132029.js";import{C as ds,H as je,E as cs}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.2422a08e.js";import{C as J}from"../chunks/CodeBlock.27357de2.js";function ms(Te){let r,T='<a href="https://github.com/aws/sagemaker-python-sdk" rel="nofollow">SageMaker Python SDK v3 has been recently released</a>, so unless specified otherwise, all the documentation and tutorials are still using the <a href="https://github.com/aws/sagemaker-python-sdk/tree/master-v2" rel="nofollow">SageMaker Python SDK v2</a>. We are actively working on updating all the tutorials and examples, but in the meantime make sure to install the SageMaker SDK as <code>pip install &quot;sagemaker&lt;3.0.0&quot;</code>.';return{c(){r=i("p"),r.innerHTML=T},l(y){r=o(y,"P",{"data-svelte-h":!0}),p(r)!=="svelte-1rh974s"&&(r.innerHTML=T)},m(y,w){n(y,r,w)},p:as,d(y){y&&s(r)}}}function us(Te){let r,T='📍 Find the complete example on GitHub <a href="https://github.com/huggingface/hub-docs/tree/main/notebooks/sagemaker-sdk/fine-tune-embedding-models/sagemaker-notebook.ipynb" rel="nofollow">here</a>!';return{c(){r=i("p"),r.innerHTML=T},l(y){r=o(y,"P",{"data-svelte-h":!0}),p(r)!=="svelte-as3ump"&&(r.innerHTML=T)},m(y,w){n(y,r,w)},p:as,d(y){y&&s(r)}}}function hs(Te){let r,T,y,w,U,ge,b,Ue,f,Ut='Embedding models are crucial for successful RAG applications, but they’re often trained on general knowledge, which limits their effectiveness for company or domain specific adoption. Customizing embedding for your domain specific data can significantly boost the retrieval performance of your RAG Application. With the new release of <a href="https://huggingface.co/blog/train-sentence-transformers" rel="nofollow">Sentence Transformers 3</a> and the <a href="https://huggingface.co/blog/sagemaker-huggingface-embedding" rel="nofollow">Hugging Face Embedding Container</a>, it’s easier than ever to fine-tune and deploy embedding models.',be,I,bt='In this example, we’ll show you how to fine-tune and deploy a custom embedding model on Amazon SageMaker using the new Hugging Face Embedding Container. We’ll use the <a href="https://huggingface.co/blog/train-sentence-transformers" rel="nofollow">Sentence Transformers 3</a> library to fine-tune a model on a custom dataset and deploy it on Amazon SageMaker for inference. We will fine-tune <a href="https://huggingface.co/BAAI/bge-base-en-v1.5" rel="nofollow">BAAI/bge-base-en-v1.5</a> for financial RAG applications using a synthetic dataset from the <a href="https://stocklight.com/stocks/us/nasdaq-nvda/nvidia/annual-reports/nasdaq-nvda-2023-10K-23668751.pdf" rel="nofollow">2023_10 NVIDIA SEC Filing</a>.',fe,Z,ft='<li><a href="#2-setup-development-environment">Setup development environment</a></li> <li><a href="#3-create-and-prepare-the-dataset">Create and prepare the dataset</a></li> <li><a href="#3-fine-tune-embedding-model-on-amazon-sagemaker">Fine-tune Embedding model on Amazon SageMaker</a></li> <li><a href="#4-deploy--test-fine-tuned-embedding-model-on-amazon-sagemaker">Deploy &amp; Test fine-tuned Embedding Model on Amazon SageMaker</a></li>',Ie,C,It="<strong>What is new with Sentence Transformers 3?</strong>",Ze,W,Zt="Sentence Transformers v3 introduces a new trainer that makes it easier to fine-tune and train embedding models. This update includes enhanced components like diverse datasets, updated loss functions, and a streamlined training process, improving the efficiency and flexibility of model development.",Ce,G,Ct="<strong>What is the Hugging Face Embedding Container?</strong>",We,B,Wt='The Hugging Face Embedding Container is a new purpose-built Inference Container to easily deploy Embedding Models in a secure and managed environment. The DLC is powered by <a href="https://github.com/huggingface/text-embeddings-inference" rel="nofollow">Text Embedding Inference (TEI)</a> a blazing fast and memory efficient solution for deploying and serving Embedding Models. TEI enables high-performance extraction for the most popular models, including FlagEmbedding, Ember, GTE and E5. TEI implements many features such as:',Ge,k,Gt="<em>Note: This blog was created and validated on <code>ml.g5.xlarge</code> for training and <code>ml.c6i.2xlarge</code> for inference instance.</em>",Be,v,ke,R,Bt="Our first step is to install Hugging Face Libraries we need on the client to correctly prepare our dataset and start our training/evaluations jobs.",ve,H,Re,j,He,z,kt='If you are going to use Sagemaker in a local environment. You need access to an IAM Role with the required permissions for Sagemaker. You can find <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html" rel="nofollow">here</a> more about it.',ze,X,Xe,_,_e,V,vt="An embedding dataset typically consists of text pairs (question, answer/context) or triplets that represent relationships or similarities between sentences. The dataset format you choose or have available will also impact the loss function you can use. Common formats for embedding datasets:",Ve,Y,Rt="<li><strong>Positive Pair</strong>: Text Pairs of related sentences (query, context | query, answer), suitable for tasks like similarity or semantic search, example datasets: <code>sentence-transformers/sentence-compression</code>, <code>sentence-transformers/natural-questions</code>.</li> <li><strong>Triplets</strong>: Text triplets consisting of (anchor, positive, negative), example datasets <code>sentence-transformers/quora-duplicates</code>, <code>nirantk/triplets</code>.</li> <li><strong>Pair with Similarity Score</strong>: Sentence pairs with a similarity score indicating how related they are, example datasets: <code>sentence-transformers/stsb</code>, <code>PhilipMay/stsb_multi_mt</code></li>",Ye,N,Ht='Learn more at <a href="https://sbert.net/docs/sentence_transformer/dataset_overview.html" rel="nofollow">Dataset Overview</a>.',Ne,$,zt='We are going to use <a href="https://huggingface.co/datasets/philschmid/finanical-rag-embedding-dataset" rel="nofollow">philschmid/finanical-rag-embedding-dataset</a>, which includes 7,000 positive text pairs of questions and corresponding context from the <a href="https://stocklight.com/stocks/us/nasdaq-nvda/nvidia/annual-reports/nasdaq-nvda-2023-10K-23668751.pdf" rel="nofollow">2023_10 NVIDIA SEC Filing</a>.',$e,S,Xt="The dataset has the following format",Se,F,Fe,E,_t='We are going to use the <a href="https://huggingface.co/docs/datasets/filesystems" rel="nofollow">FileSystem integration</a> to upload our dataset to S3. We are using the <code>sess.default_bucket()</code>, adjust this if you want to store the dataset in a different S3 bucket. We will use the S3 path later in our training script.',Ee,A,Ae,Q,Qe,x,Vt=`We are now ready to fine-tune our model. We will use the <a href="https://www.sbert.net/docs/package_reference/sentence_transformer/trainer.html" rel="nofollow">SentenceTransformerTrainer</a> from <code>sentence-transformers</code> to fine-tune our model. The <code>SentenceTransformerTrainer</code> makes it straightfoward to supervise fine-tune open Embedding Models, as it is a subclass of the <code>Trainer</code> from the <code>transformers</code>. We prepared a script <a href="assets/run_mnr.py">run_mnr.py</a> which will loads the dataset from disk, prepare the model, tokenizer and start the training.
The <code>SentenceTransformerTrainer</code> makes it straightfoward to supervise fine-tune open Embedding supporting:`,xe,q,Yt="<li><strong>Integrated Components</strong>: Combines datasets, loss functions, and evaluators into a unified training framework.</li> <li><strong>Flexible Data Handling</strong>: Supports various data formats and easy integration with Hugging Face datasets.</li> <li><strong>Versatile Loss Functions</strong>: Offers multiple loss functions for different training tasks.</li> <li><strong>Multi-Dataset Training</strong>: Facilitates simultaneous training with multiple datasets and different loss functions.</li> <li><strong>Seamless Integration</strong>: Easy saving, loading, and sharing of models within the Hugging Face ecosystem.</li>",qe,L,Nt="In order to create a sagemaker training job we need an <code>HuggingFace</code> Estimator. The Estimator handles end-to-end Amazon SageMaker training and deployment tasks. The Estimator manages the infrastructure use. Amazon SagMaker takes care of starting and managing all the required ec2 instances for us, provides the correct huggingface container, uploads the provided scripts and downloads the data from our S3 bucket into the container at <code>/opt/ml/input/data</code>. Then, it starts the training job by running.",Le,P,$t="Note: Make sure that you include the <code>requirements.txt</code> in the <code>source_dir</code> if you are using a custom training script. We recommend to just clone the whole repository.",Pe,D,St="Lets first define our trainings parameter. Those are passed as cli arguments to our training script. We are going to use the <code>BAAI/bge-base-en-v1.5</code> model, which is a pre-trained model on a large corpus of English text. We will use the <code>MultipleNegativesRankingLoss</code> in combination with the <code>MatryoshkaLoss</code>. This approach allows us to leverage the efficiency and flexibility of Matryoshka embeddings, enabling different embedding dimensions to be utilized without significant performance trade-offs. The <code>MultipleNegativesRankingLoss</code> is a great loss function if you only have positive pairs as it adds in batch negative samples to the loss function to have per sample n-1 negative samples.",De,K,Ke,O,Ft="We can now start our training job, with the <code>.fit()</code> method passing our S3 path to the training script.",Oe,ee,et,te,Et="In our example the training BGE Base with Flash Attention 2 (SDPA) for 3 epochs with a dataset of 6,3k train samples and 700 eval samples took 645 seconds (~10minutes) on a <code>ml.g5.xlarge</code> (1.2575 $/h) or ~$5.",tt,se,st,ne,At='We are going to use the <a href="https://huggingface.co/blog/sagemaker-huggingface-embedding#what-is-the-hugging-face-embedding-container" rel="nofollow">Hugging Face Embedding Container</a> a purpose-built Inference  Container to easily deploy Embedding Models in a secure and managed environment. The DLC is powered by Text Embedding Inference (TEI) a blazing fast and memory efficient solution for deploying and serving Embedding Models.',nt,ae,Qt="To retrieve the new Hugging Face Embedding Container in Amazon SageMaker, we can use the <code>get_huggingface_llm_image_uri</code> method provided by the sagemaker SDK. This method allows us to retrieve the URI for the desired Hugging Face Embedding Container. Important to note is that TEI has 2 different versions for cpu and gpu, so we create a helper function to retrieve the correct image uri based on the instance type.",at,le,lt,ie,xt="We can now create a <code>HuggingFaceModel</code> using the container uri and the S3 path to our model. We also need to set our TEI configuration.",it,oe,ot,pe,qt="After we have created the <code>HuggingFaceModel</code> we can deploy it to Amazon SageMaker using the deploy method. We will deploy the model with the <code>ml.c6i.2xlarge</code> instance type.",pt,re,rt,Me,Lt="SageMaker will now create our endpoint and deploy the model to it. This can take ~5 minutes. After our endpoint is deployed we can run inference on it. We will use the <code>predict</code> method from the predictor to run inference on our endpoint.",Mt,de,dt,ce,Pt="We trained our model with the Matryoshka Loss means that the semantic meaning is frontloaded. To use the different mathryshoka dimension we need to manually truncate our embeddings manually. Below is an example on how you would truncate the embeddings to 256 dimension, which is 1/3 of the original size. If we check our training logs we can see that the NDCG metric for 768 is <code>0.823</code> and for 256 <code>0.818</code> meaning we preserve &gt; 99% accuracy.",ct,me,mt,ue,Dt="Awesome! 🚀 Now that we can generate embeddings and integrate your endpoint into your RAG application.",ut,he,Kt="To clean up, we can delete the model and endpoint.",ht,ye,yt,Jt,Tt,g,wt,Je,jt,we,gt;return U=new ds({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),b=new je({props:{title:"Fine-tune and deploy embedding models with Amazon SageMaker",local:"fine-tune-and-deploy-embedding-models-with-amazon-sagemaker",headingTag:"h1"}}),v=new je({props:{title:"1. Setup Development Environment",local:"1-setup-development-environment",headingTag:"h2"}}),H=new J({props:{code:"IXBpcCUyMGluc3RhbGwlMjB0cmFuc2Zvcm1lcnMlMjAlMjJkYXRhc2V0cyU1QnMzJTVEJTNEJTNEMi4xOC4wJTIyJTIwJTIyc2FnZW1ha2VyJTNDMy4wLjAlMjIlMjAlMjJodWdnaW5nZmFjZV9odWIlNUJjbGklNUQlMjIlMjAtLXVwZ3JhZGUlMjAtLXF1aWV0",highlighted:'!pip install transformers <span class="hljs-string">&quot;datasets[s3]==2.18.0&quot;</span> <span class="hljs-string">&quot;sagemaker&lt;3.0.0&quot;</span> <span class="hljs-string">&quot;huggingface_hub[cli]&quot;</span> --upgrade --quiet',wrap:!1}}),j=new ns({props:{warning:!0,$$slots:{default:[ms]},$$scope:{ctx:Te}}}),X=new J({props:{code:"aW1wb3J0JTIwc2FnZW1ha2VyJTBBaW1wb3J0JTIwYm90bzMlMEFzZXNzJTIwJTNEJTIwc2FnZW1ha2VyLlNlc3Npb24oKSUwQSUyMyUyMHNhZ2VtYWtlciUyMHNlc3Npb24lMjBidWNrZXQlMjAtJTNFJTIwdXNlZCUyMGZvciUyMHVwbG9hZGluZyUyMGRhdGElMkMlMjBtb2RlbHMlMjBhbmQlMjBsb2dzJTBBJTIzJTIwc2FnZW1ha2VyJTIwd2lsbCUyMGF1dG9tYXRpY2FsbHklMjBjcmVhdGUlMjB0aGlzJTIwYnVja2V0JTIwaWYlMjBpdCUyMG5vdCUyMGV4aXN0cyUwQXNhZ2VtYWtlcl9zZXNzaW9uX2J1Y2tldCUzRE5vbmUlMEFpZiUyMHNhZ2VtYWtlcl9zZXNzaW9uX2J1Y2tldCUyMGlzJTIwTm9uZSUyMGFuZCUyMHNlc3MlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBzZXQlMjB0byUyMGRlZmF1bHQlMjBidWNrZXQlMjBpZiUyMGElMjBidWNrZXQlMjBuYW1lJTIwaXMlMjBub3QlMjBnaXZlbiUwQSUyMCUyMCUyMCUyMHNhZ2VtYWtlcl9zZXNzaW9uX2J1Y2tldCUyMCUzRCUyMHNlc3MuZGVmYXVsdF9idWNrZXQoKSUwQSUwQXRyeSUzQSUwQSUyMCUyMCUyMCUyMHJvbGUlMjAlM0QlMjBzYWdlbWFrZXIuZ2V0X2V4ZWN1dGlvbl9yb2xlKCklMEFleGNlcHQlMjBWYWx1ZUVycm9yJTNBJTBBJTIwJTIwJTIwJTIwaWFtJTIwJTNEJTIwYm90bzMuY2xpZW50KCdpYW0nKSUwQSUyMCUyMCUyMCUyMHJvbGUlMjAlM0QlMjBpYW0uZ2V0X3JvbGUoUm9sZU5hbWUlM0Qnc2FnZW1ha2VyX2V4ZWN1dGlvbl9yb2xlJyklNUInUm9sZSclNUQlNUInQXJuJyU1RCUwQSUwQXNlc3MlMjAlM0QlMjBzYWdlbWFrZXIuU2Vzc2lvbihkZWZhdWx0X2J1Y2tldCUzRHNhZ2VtYWtlcl9zZXNzaW9uX2J1Y2tldCklMEElMEFwcmludChmJTIyc2FnZW1ha2VyJTIwcm9sZSUyMGFybiUzQSUyMCU3QnJvbGUlN0QlMjIpJTBBcHJpbnQoZiUyMnNhZ2VtYWtlciUyMGJ1Y2tldCUzQSUyMCU3QnNlc3MuZGVmYXVsdF9idWNrZXQoKSU3RCUyMiklMEFwcmludChmJTIyc2FnZW1ha2VyJTIwc2Vzc2lvbiUyMHJlZ2lvbiUzQSUyMCU3QnNlc3MuYm90b19yZWdpb25fbmFtZSU3RCUyMik=",highlighted:`<span class="hljs-keyword">import</span> sagemaker
<span class="hljs-keyword">import</span> boto3
sess = sagemaker.Session()
<span class="hljs-comment"># sagemaker session bucket -&gt; used for uploading data, models and logs</span>
<span class="hljs-comment"># sagemaker will automatically create this bucket if it not exists</span>
sagemaker_session_bucket=<span class="hljs-literal">None</span>
<span class="hljs-keyword">if</span> sagemaker_session_bucket <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">and</span> sess <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
    <span class="hljs-comment"># set to default bucket if a bucket name is not given</span>
    sagemaker_session_bucket = sess.default_bucket()

<span class="hljs-keyword">try</span>:
    role = sagemaker.get_execution_role()
<span class="hljs-keyword">except</span> ValueError:
    iam = boto3.client(<span class="hljs-string">&#x27;iam&#x27;</span>)
    role = iam.get_role(RoleName=<span class="hljs-string">&#x27;sagemaker_execution_role&#x27;</span>)[<span class="hljs-string">&#x27;Role&#x27;</span>][<span class="hljs-string">&#x27;Arn&#x27;</span>]

sess = sagemaker.Session(default_bucket=sagemaker_session_bucket)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;sagemaker role arn: <span class="hljs-subst">{role}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;sagemaker bucket: <span class="hljs-subst">{sess.default_bucket()}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;sagemaker session region: <span class="hljs-subst">{sess.boto_region_name}</span>&quot;</span>)`,wrap:!1}}),_=new je({props:{title:"2. Create and prepare the dataset",local:"2-create-and-prepare-the-dataset",headingTag:"h2"}}),F=new J({props:{code:"JTdCJTIycXVlc3Rpb24lMjIlM0ElMjAlMjIlM0NxdWVzdGlvbiUzRSUyMiUyQyUyMCUyMmNvbnRleHQlMjIlM0ElMjAlMjIlM0NyZWxldmFudCUyMGNvbnRleHQlMjB0byUyMGFuc3dlciUzRSUyMiU3RCUwQSU3QiUyMnF1ZXN0aW9uJTIyJTNBJTIwJTIyJTNDcXVlc3Rpb24lM0UlMjIlMkMlMjAlMjJjb250ZXh0JTIyJTNBJTIwJTIyJTNDcmVsZXZhbnQlMjBjb250ZXh0JTIwdG8lMjBhbnN3ZXIlM0UlMjIlN0QlMEElN0IlMjJxdWVzdGlvbiUyMiUzQSUyMCUyMiUzQ3F1ZXN0aW9uJTNFJTIyJTJDJTIwJTIyY29udGV4dCUyMiUzQSUyMCUyMiUzQ3JlbGV2YW50JTIwY29udGV4dCUyMHRvJTIwYW5zd2VyJTNFJTIyJTdE",highlighted:`<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;question&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;question&gt;&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;context&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;relevant context to answer&gt;&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;question&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;question&gt;&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;context&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;relevant context to answer&gt;&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;question&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;question&gt;&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;context&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;relevant context to answer&gt;&quot;</span><span class="hljs-punctuation">}</span>`,wrap:!1}}),A=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># Load dataset from the hub</span>
dataset = load_dataset(<span class="hljs-string">&quot;philschmid/finanical-rag-embedding-dataset&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
input_path = <span class="hljs-string">f&#x27;s3://<span class="hljs-subst">{sess.default_bucket()}</span>/datasets/rag-embedding&#x27;</span>

<span class="hljs-comment"># rename columns</span>
dataset = dataset.rename_column(<span class="hljs-string">&quot;question&quot;</span>, <span class="hljs-string">&quot;anchor&quot;</span>)
dataset = dataset.rename_column(<span class="hljs-string">&quot;context&quot;</span>, <span class="hljs-string">&quot;positive&quot;</span>)

<span class="hljs-comment"># Add an id column to the dataset</span>
dataset = dataset.add_column(<span class="hljs-string">&quot;id&quot;</span>, <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(dataset)))

<span class="hljs-comment"># split dataset into a 10% test set</span>
dataset = dataset.train_test_split(test_size=<span class="hljs-number">0.1</span>)

<span class="hljs-comment"># save train_dataset to s3 using our SageMaker session</span>

<span class="hljs-comment"># save datasets to s3</span>
dataset[<span class="hljs-string">&quot;train&quot;</span>].to_json(<span class="hljs-string">f&quot;<span class="hljs-subst">{input_path}</span>/train/dataset.json&quot;</span>, orient=<span class="hljs-string">&quot;records&quot;</span>)
train_dataset_s3_path = <span class="hljs-string">f&quot;<span class="hljs-subst">{input_path}</span>/train/dataset.json&quot;</span>
dataset[<span class="hljs-string">&quot;test&quot;</span>].to_json(<span class="hljs-string">f&quot;<span class="hljs-subst">{input_path}</span>/test/dataset.json&quot;</span>, orient=<span class="hljs-string">&quot;records&quot;</span>)
test_dataset_s3_path = <span class="hljs-string">f&quot;<span class="hljs-subst">{input_path}</span>/test/dataset.json&quot;</span>

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Training data uploaded to:&quot;</span>)
<span class="hljs-built_in">print</span>(train_dataset_s3_path)
<span class="hljs-built_in">print</span>(test_dataset_s3_path)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;https://s3.console.aws.amazon.com/s3/buckets/<span class="hljs-subst">{sess.default_bucket()}</span>/?region=<span class="hljs-subst">{sess.boto_region_name}</span>&amp;prefix=<span class="hljs-subst">{input_path.split(<span class="hljs-string">&#x27;/&#x27;</span>, <span class="hljs-number">3</span>)[-<span class="hljs-number">1</span>]}</span>/&quot;</span>)`,wrap:!1}}),Q=new je({props:{title:"3. Fine-tune Embedding model on Amazon SageMaker",local:"3-fine-tune-embedding-model-on-amazon-sagemaker",headingTag:"h2"}}),K=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface <span class="hljs-keyword">import</span> HuggingFace

<span class="hljs-comment"># define Training Job Name </span>
job_name = <span class="hljs-string">f&#x27;bge-base-exp1&#x27;</span>

<span class="hljs-comment"># define hyperparameters, which are passed into the training job</span>
training_arguments = {
  <span class="hljs-string">&quot;model_id&quot;</span>: <span class="hljs-string">&quot;BAAI/bge-base-en-v1.5&quot;</span>, <span class="hljs-comment"># model id from the hub</span>
  <span class="hljs-string">&quot;train_dataset_path&quot;</span>: <span class="hljs-string">&quot;/opt/ml/input/data/train/&quot;</span>, <span class="hljs-comment"># path inside the container where the training data is stored</span>
  <span class="hljs-string">&quot;test_dataset_path&quot;</span>: <span class="hljs-string">&quot;/opt/ml/input/data/test/&quot;</span>, <span class="hljs-comment"># path inside the container where the test data is stored</span>
  <span class="hljs-string">&quot;num_train_epochs&quot;</span>: <span class="hljs-number">3</span>, <span class="hljs-comment"># number of training epochs</span>
  <span class="hljs-string">&quot;learning_rate&quot;</span>: <span class="hljs-number">2e-5</span>, <span class="hljs-comment"># learning rate</span>
}

<span class="hljs-comment"># create the Estimator</span>
huggingface_estimator = HuggingFace(
    entry_point          = <span class="hljs-string">&#x27;run_mnr.py&#x27;</span>,      <span class="hljs-comment"># train script</span>
    source_dir           = <span class="hljs-string">&#x27;scripts&#x27;</span>,         <span class="hljs-comment"># directory which includes all the files needed for training</span>
    instance_type        = <span class="hljs-string">&#x27;ml.g5.xlarge&#x27;</span>,    <span class="hljs-comment"># instances type used for the training job</span>
    instance_count       = <span class="hljs-number">1</span>,                 <span class="hljs-comment"># the number of instances used for training</span>
    max_run              = <span class="hljs-number">2</span>*<span class="hljs-number">24</span>*<span class="hljs-number">60</span>*<span class="hljs-number">60</span>,        <span class="hljs-comment"># maximum runtime in seconds (days * hours * minutes * seconds)</span>
    base_job_name        = job_name,          <span class="hljs-comment"># the name of the training job</span>
    role                 = role,              <span class="hljs-comment"># Iam role used in training job to access AWS ressources, e.g. S3</span>
    transformers_version = <span class="hljs-string">&#x27;4.36.0&#x27;</span>,          <span class="hljs-comment"># the transformers version used in the training job</span>
    pytorch_version      = <span class="hljs-string">&#x27;2.1.0&#x27;</span>,           <span class="hljs-comment"># the pytorch_version version used in the training job</span>
    py_version           = <span class="hljs-string">&#x27;py310&#x27;</span>,           <span class="hljs-comment"># the python version used in the training job</span>
    hyperparameters      =  training_arguments,
    disable_output_compression = <span class="hljs-literal">True</span>,        <span class="hljs-comment"># not compress output to save training time and cost</span>
    environment  = {
        <span class="hljs-string">&quot;HUGGINGFACE_HUB_CACHE&quot;</span>: <span class="hljs-string">&quot;/tmp/.cache&quot;</span>, <span class="hljs-comment"># set env variable to cache models in /tmp</span>
    }, 
)`,wrap:!1}}),ee=new J({props:{code:"JTIzJTIwZGVmaW5lJTIwYSUyMGRhdGElMjBpbnB1dCUyMGRpY3RvbmFyeSUyMHdpdGglMjBvdXIlMjB1cGxvYWRlZCUyMHMzJTIwdXJpcyUwQWRhdGElMjAlM0QlMjAlN0IlMEElMjAlMjAndHJhaW4nJTNBJTIwdHJhaW5fZGF0YXNldF9zM19wYXRoJTJDJTBBJTIwJTIwJ3Rlc3QnJTNBJTIwdGVzdF9kYXRhc2V0X3MzX3BhdGglMkMlMEElMjAlMjAlN0QlMEElMEElMjMlMjBzdGFydGluZyUyMHRoZSUyMHRyYWluJTIwam9iJTIwd2l0aCUyMG91ciUyMHVwbG9hZGVkJTIwZGF0YXNldHMlMjBhcyUyMGlucHV0JTBBaHVnZ2luZ2ZhY2VfZXN0aW1hdG9yLmZpdChkYXRhJTJDJTIwd2FpdCUzRFRydWUp",highlighted:`<span class="hljs-comment"># define a data input dictonary with our uploaded s3 uris</span>
data = {
  <span class="hljs-string">&#x27;train&#x27;</span>: train_dataset_s3_path,
  <span class="hljs-string">&#x27;test&#x27;</span>: test_dataset_s3_path,
  }

<span class="hljs-comment"># starting the train job with our uploaded datasets as input</span>
huggingface_estimator.fit(data, wait=<span class="hljs-literal">True</span>)`,wrap:!1}}),se=new je({props:{title:"4. Deploy & Test fine-tuned Embedding Model on Amazon SageMaker",local:"4-deploy--test-fine-tuned-embedding-model-on-amazon-sagemaker",headingTag:"h2"}}),le=new J({props:{code:"ZnJvbSUyMHNhZ2VtYWtlci5odWdnaW5nZmFjZSUyMGltcG9ydCUyMGdldF9odWdnaW5nZmFjZV9sbG1faW1hZ2VfdXJpJTBBJTBBJTIzJTIwcmV0cmlldmUlMjB0aGUlMjBpbWFnZSUyMHVyaSUyMGJhc2VkJTIwb24lMjBpbnN0YW5jZSUyMHR5cGUlMEFkZWYlMjBnZXRfaW1hZ2VfdXJpKGluc3RhbmNlX3R5cGUpJTNBJTBBJTIwJTIwa2V5JTIwJTNEJTIwJTIyaHVnZ2luZ2ZhY2UtdGVpJTIyJTIwaWYlMjBpbnN0YW5jZV90eXBlLnN0YXJ0c3dpdGgoJTIybWwuZyUyMiklMjBvciUyMGluc3RhbmNlX3R5cGUuc3RhcnRzd2l0aCglMjJtbC5wJTIyKSUyMGVsc2UlMjAlMjJodWdnaW5nZmFjZS10ZWktY3B1JTIyJTBBJTIwJTIwcmV0dXJuJTIwZ2V0X2h1Z2dpbmdmYWNlX2xsbV9pbWFnZV91cmkoa2V5JTJDJTIwdmVyc2lvbiUzRCUyMjEuNC4wJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface <span class="hljs-keyword">import</span> get_huggingface_llm_image_uri

<span class="hljs-comment"># retrieve the image uri based on instance type</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_image_uri</span>(<span class="hljs-params">instance_type</span>):
  key = <span class="hljs-string">&quot;huggingface-tei&quot;</span> <span class="hljs-keyword">if</span> instance_type.startswith(<span class="hljs-string">&quot;ml.g&quot;</span>) <span class="hljs-keyword">or</span> instance_type.startswith(<span class="hljs-string">&quot;ml.p&quot;</span>) <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;huggingface-tei-cpu&quot;</span>
  <span class="hljs-keyword">return</span> get_huggingface_llm_image_uri(key, version=<span class="hljs-string">&quot;1.4.0&quot;</span>)`,wrap:!1}}),oe=new J({props:{code:"ZnJvbSUyMHNhZ2VtYWtlci5odWdnaW5nZmFjZSUyMGltcG9ydCUyMEh1Z2dpbmdGYWNlTW9kZWwlMEElMEElMjMlMjBzYWdlbWFrZXIlMjBjb25maWclMEFpbnN0YW5jZV90eXBlJTIwJTNEJTIwJTIybWwuYzZpLjJ4bGFyZ2UlMjIlMEElMEElMjMlMjBjcmVhdGUlMjBIdWdnaW5nRmFjZU1vZGVsJTIwd2l0aCUyMHRoZSUyMGltYWdlJTIwdXJpJTBBZW1iX21vZGVsJTIwJTNEJTIwSHVnZ2luZ0ZhY2VNb2RlbCglMEElMjAlMjByb2xlJTNEcm9sZSUyQyUwQSUyMCUyMGltYWdlX3VyaSUzRGdldF9pbWFnZV91cmkoaW5zdGFuY2VfdHlwZSklMkMlMEElMjAlMjBtb2RlbF9kYXRhJTNEaHVnZ2luZ2ZhY2VfZXN0aW1hdG9yLm1vZGVsX2RhdGElMkMlMEElMjAlMjBlbnYlM0QlN0InSEZfTU9ERUxfSUQnJTNBJTIwJTIyJTJGb3B0JTJGbWwlMkZtb2RlbCUyMiU3RCUyMCUyMCUyMCUyMCUyMCUyMyUyMFBhdGglMjB0byUyMHRoZSUyMG1vZGVsJTIwaW4lMjB0aGUlMjBjb250YWluZXIlMEEp",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface <span class="hljs-keyword">import</span> HuggingFaceModel

<span class="hljs-comment"># sagemaker config</span>
instance_type = <span class="hljs-string">&quot;ml.c6i.2xlarge&quot;</span>

<span class="hljs-comment"># create HuggingFaceModel with the image uri</span>
emb_model = HuggingFaceModel(
  role=role,
  image_uri=get_image_uri(instance_type),
  model_data=huggingface_estimator.model_data,
  env={<span class="hljs-string">&#x27;HF_MODEL_ID&#x27;</span>: <span class="hljs-string">&quot;/opt/ml/model&quot;</span>}     <span class="hljs-comment"># Path to the model in the container</span>
)`,wrap:!1}}),re=new J({props:{code:"JTIzJTIwRGVwbG95JTIwbW9kZWwlMjB0byUyMGFuJTIwZW5kcG9pbnQlMEFlbWIlMjAlM0QlMjBlbWJfbW9kZWwuZGVwbG95KCUwQSUyMCUyMGluaXRpYWxfaW5zdGFuY2VfY291bnQlM0QxJTJDJTBBJTIwJTIwaW5zdGFuY2VfdHlwZSUzRGluc3RhbmNlX3R5cGUlMkMlMEEp",highlighted:`<span class="hljs-comment"># Deploy model to an endpoint</span>
emb = emb_model.deploy(
  initial_instance_count=<span class="hljs-number">1</span>,
  instance_type=instance_type,
)`,wrap:!1}}),de=new J({props:{code:"ZGF0YSUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMmlucHV0cyUyMiUzQSUyMCUyMnRoZSUyMG1lc21lcml6aW5nJTIwcGVyZm9ybWFuY2VzJTIwb2YlMjB0aGUlMjBsZWFkcyUyMGtlZXAlMjB0aGUlMjBmaWxtJTIwZ3JvdW5kZWQlMjBhbmQlMjBrZWVwJTIwdGhlJTIwYXVkaWVuY2UlMjByaXZldGVkJTIwLiUyMiUyQyUwQSU3RCUwQSUyMCUwQXJlcyUyMCUzRCUyMGVtYi5wcmVkaWN0KGRhdGElM0RkYXRhKSUwQSUyMCUwQSUyMCUwQSUyMyUyMHByaW50JTIwc29tZSUyMHJlc3VsdHMlMEFwcmludChmJTIybGVuZ3RoJTIwb2YlMjBlbWJlZGRpbmdzJTNBJTIwJTdCbGVuKHJlcyU1QjAlNUQpJTdEJTIyKSUwQXByaW50KGYlMjJmaXJzdCUyMDEwJTIwZWxlbWVudHMlMjBvZiUyMGVtYmVkZGluZ3MlM0ElMjAlN0JyZXMlNUIwJTVEJTVCJTNBMTAlNUQlN0QlMjIp",highlighted:`data = {
  <span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;the mesmerizing performances of the leads keep the film grounded and keep the audience riveted .&quot;</span>,
}
 
res = emb.predict(data=data)
 
 
<span class="hljs-comment"># print some results</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;length of embeddings: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(res[<span class="hljs-number">0</span>])}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;first 10 elements of embeddings: <span class="hljs-subst">{res[<span class="hljs-number">0</span>][:<span class="hljs-number">10</span>]}</span>&quot;</span>)`,wrap:!1}}),me=new J({props:{code:"ZGF0YSUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMmlucHV0cyUyMiUzQSUyMCUyMnRoZSUyMG1lc21lcml6aW5nJTIwcGVyZm9ybWFuY2VzJTIwb2YlMjB0aGUlMjBsZWFkcyUyMGtlZXAlMjB0aGUlMjBmaWxtJTIwZ3JvdW5kZWQlMjBhbmQlMjBrZWVwJTIwdGhlJTIwYXVkaWVuY2UlMjByaXZldGVkJTIwLiUyMiUyQyUwQSU3RCUwQSUyMCUwQXJlcyUyMCUzRCUyMGVtYi5wcmVkaWN0KGRhdGElM0RkYXRhKSUwQSUyMCUwQSUyMyUyMHRydW5jYXRlJTIwZW1iZWRkaW5ncyUyMHRvJTIwbWF0cnlvc2hrYSUyMGRpbWVuc2lvbnMlMEFkaW0lMjAlM0QlMjAyNTYlMEFyZXMlMjAlM0QlMjByZXMlNUIwJTVEJTVCMCUzQWRpbSU1RCUwQSUyMCUwQSUyMyUyMHByaW50JTIwc29tZSUyMHJlc3VsdHMlMEFwcmludChmJTIybGVuZ3RoJTIwb2YlMjBlbWJlZGRpbmdzJTNBJTIwJTdCbGVuKHJlcyklN0QlMjIp",highlighted:`data = {
  <span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;the mesmerizing performances of the leads keep the film grounded and keep the audience riveted .&quot;</span>,
}
 
res = emb.predict(data=data)
 
<span class="hljs-comment"># truncate embeddings to matryoshka dimensions</span>
dim = <span class="hljs-number">256</span>
res = res[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>:dim]
 
<span class="hljs-comment"># print some results</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;length of embeddings: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(res)}</span>&quot;</span>)`,wrap:!1}}),ye=new J({props:{code:"ZW1iLmRlbGV0ZV9tb2RlbCgpJTBBZW1iLmRlbGV0ZV9lbmRwb2ludCgp",highlighted:`emb.delete_model()
emb.delete_endpoint()`,wrap:!1}}),g=new ns({props:{$$slots:{default:[us]},$$scope:{ctx:Te}}}),Je=new cs({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/sagemaker/source/examples/sagemaker-sdk-fine-tune-embedding-models.mdx"}}),{c(){r=i("meta"),T=a(),y=i("p"),w=a(),M(U.$$.fragment),ge=a(),M(b.$$.fragment),Ue=a(),f=i("p"),f.innerHTML=Ut,be=a(),I=i("p"),I.innerHTML=bt,fe=a(),Z=i("ol"),Z.innerHTML=ft,Ie=a(),C=i("p"),C.innerHTML=It,Ze=a(),W=i("p"),W.textContent=Zt,Ce=a(),G=i("p"),G.innerHTML=Ct,We=a(),B=i("p"),B.innerHTML=Wt,Ge=a(),k=i("p"),k.innerHTML=Gt,Be=a(),M(v.$$.fragment),ke=a(),R=i("p"),R.textContent=Bt,ve=a(),M(H.$$.fragment),Re=a(),M(j.$$.fragment),He=a(),z=i("p"),z.innerHTML=kt,ze=a(),M(X.$$.fragment),Xe=a(),M(_.$$.fragment),_e=a(),V=i("p"),V.textContent=vt,Ve=a(),Y=i("ul"),Y.innerHTML=Rt,Ye=a(),N=i("p"),N.innerHTML=Ht,Ne=a(),$=i("p"),$.innerHTML=zt,$e=a(),S=i("p"),S.textContent=Xt,Se=a(),M(F.$$.fragment),Fe=a(),E=i("p"),E.innerHTML=_t,Ee=a(),M(A.$$.fragment),Ae=a(),M(Q.$$.fragment),Qe=a(),x=i("p"),x.innerHTML=Vt,xe=a(),q=i("ul"),q.innerHTML=Yt,qe=a(),L=i("p"),L.innerHTML=Nt,Le=a(),P=i("p"),P.innerHTML=$t,Pe=a(),D=i("p"),D.innerHTML=St,De=a(),M(K.$$.fragment),Ke=a(),O=i("p"),O.innerHTML=Ft,Oe=a(),M(ee.$$.fragment),et=a(),te=i("p"),te.innerHTML=Et,tt=a(),M(se.$$.fragment),st=a(),ne=i("p"),ne.innerHTML=At,nt=a(),ae=i("p"),ae.innerHTML=Qt,at=a(),M(le.$$.fragment),lt=a(),ie=i("p"),ie.innerHTML=xt,it=a(),M(oe.$$.fragment),ot=a(),pe=i("p"),pe.innerHTML=qt,pt=a(),M(re.$$.fragment),rt=a(),Me=i("p"),Me.innerHTML=Lt,Mt=a(),M(de.$$.fragment),dt=a(),ce=i("p"),ce.innerHTML=Pt,ct=a(),M(me.$$.fragment),mt=a(),ue=i("p"),ue.textContent=Dt,ut=a(),he=i("p"),he.textContent=Kt,ht=a(),M(ye.$$.fragment),yt=a(),Jt=i("hr"),Tt=a(),M(g.$$.fragment),wt=a(),M(Je.$$.fragment),jt=a(),we=i("p"),this.h()},l(e){const t=rs("svelte-u9bgzb",document.head);r=o(t,"META",{name:!0,content:!0}),t.forEach(s),T=l(e),y=o(e,"P",{}),ts(y).forEach(s),w=l(e),d(U.$$.fragment,e),ge=l(e),d(b.$$.fragment,e),Ue=l(e),f=o(e,"P",{"data-svelte-h":!0}),p(f)!=="svelte-hjugkj"&&(f.innerHTML=Ut),be=l(e),I=o(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-1rdpwjk"&&(I.innerHTML=bt),fe=l(e),Z=o(e,"OL",{"data-svelte-h":!0}),p(Z)!=="svelte-jw6fjl"&&(Z.innerHTML=ft),Ie=l(e),C=o(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-z40gay"&&(C.innerHTML=It),Ze=l(e),W=o(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-qpk058"&&(W.textContent=Zt),Ce=l(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-9kfhp3"&&(G.innerHTML=Ct),We=l(e),B=o(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-1dotmv1"&&(B.innerHTML=Wt),Ge=l(e),k=o(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-1awmlx3"&&(k.innerHTML=Gt),Be=l(e),d(v.$$.fragment,e),ke=l(e),R=o(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1ajxiw0"&&(R.textContent=Bt),ve=l(e),d(H.$$.fragment,e),Re=l(e),d(j.$$.fragment,e),He=l(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-s0u97w"&&(z.innerHTML=kt),ze=l(e),d(X.$$.fragment,e),Xe=l(e),d(_.$$.fragment,e),_e=l(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-16i0yfq"&&(V.textContent=vt),Ve=l(e),Y=o(e,"UL",{"data-svelte-h":!0}),p(Y)!=="svelte-1hfoafx"&&(Y.innerHTML=Rt),Ye=l(e),N=o(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-qoe0pu"&&(N.innerHTML=Ht),Ne=l(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-qdb1uz"&&($.innerHTML=zt),$e=l(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1b5uozi"&&(S.textContent=Xt),Se=l(e),d(F.$$.fragment,e),Fe=l(e),E=o(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1kr3vm9"&&(E.innerHTML=_t),Ee=l(e),d(A.$$.fragment,e),Ae=l(e),d(Q.$$.fragment,e),Qe=l(e),x=o(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-1eaaz3g"&&(x.innerHTML=Vt),xe=l(e),q=o(e,"UL",{"data-svelte-h":!0}),p(q)!=="svelte-1kxt6cj"&&(q.innerHTML=Yt),qe=l(e),L=o(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-16cenvv"&&(L.innerHTML=Nt),Le=l(e),P=o(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-6mgwni"&&(P.innerHTML=$t),Pe=l(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-br5gpt"&&(D.innerHTML=St),De=l(e),d(K.$$.fragment,e),Ke=l(e),O=o(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-18e42pb"&&(O.innerHTML=Ft),Oe=l(e),d(ee.$$.fragment,e),et=l(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-1esotj9"&&(te.innerHTML=Et),tt=l(e),d(se.$$.fragment,e),st=l(e),ne=o(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-18uw3dz"&&(ne.innerHTML=At),nt=l(e),ae=o(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-1ei5h4z"&&(ae.innerHTML=Qt),at=l(e),d(le.$$.fragment,e),lt=l(e),ie=o(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-1b88wn2"&&(ie.innerHTML=xt),it=l(e),d(oe.$$.fragment,e),ot=l(e),pe=o(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-1gpwlux"&&(pe.innerHTML=qt),pt=l(e),d(re.$$.fragment,e),rt=l(e),Me=o(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-1670aas"&&(Me.innerHTML=Lt),Mt=l(e),d(de.$$.fragment,e),dt=l(e),ce=o(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-n8rhlf"&&(ce.innerHTML=Pt),ct=l(e),d(me.$$.fragment,e),mt=l(e),ue=o(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-ezaoag"&&(ue.textContent=Dt),ut=l(e),he=o(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-100mxno"&&(he.textContent=Kt),ht=l(e),d(ye.$$.fragment,e),yt=l(e),Jt=o(e,"HR",{}),Tt=l(e),d(g.$$.fragment,e),wt=l(e),d(Je.$$.fragment,e),jt=l(e),we=o(e,"P",{}),ts(we).forEach(s),this.h()},h(){ss(r,"name","hf:doc:metadata"),ss(r,"content",ys)},m(e,t){Ms(document.head,r),n(e,T,t),n(e,y,t),n(e,w,t),c(U,e,t),n(e,ge,t),c(b,e,t),n(e,Ue,t),n(e,f,t),n(e,be,t),n(e,I,t),n(e,fe,t),n(e,Z,t),n(e,Ie,t),n(e,C,t),n(e,Ze,t),n(e,W,t),n(e,Ce,t),n(e,G,t),n(e,We,t),n(e,B,t),n(e,Ge,t),n(e,k,t),n(e,Be,t),c(v,e,t),n(e,ke,t),n(e,R,t),n(e,ve,t),c(H,e,t),n(e,Re,t),c(j,e,t),n(e,He,t),n(e,z,t),n(e,ze,t),c(X,e,t),n(e,Xe,t),c(_,e,t),n(e,_e,t),n(e,V,t),n(e,Ve,t),n(e,Y,t),n(e,Ye,t),n(e,N,t),n(e,Ne,t),n(e,$,t),n(e,$e,t),n(e,S,t),n(e,Se,t),c(F,e,t),n(e,Fe,t),n(e,E,t),n(e,Ee,t),c(A,e,t),n(e,Ae,t),c(Q,e,t),n(e,Qe,t),n(e,x,t),n(e,xe,t),n(e,q,t),n(e,qe,t),n(e,L,t),n(e,Le,t),n(e,P,t),n(e,Pe,t),n(e,D,t),n(e,De,t),c(K,e,t),n(e,Ke,t),n(e,O,t),n(e,Oe,t),c(ee,e,t),n(e,et,t),n(e,te,t),n(e,tt,t),c(se,e,t),n(e,st,t),n(e,ne,t),n(e,nt,t),n(e,ae,t),n(e,at,t),c(le,e,t),n(e,lt,t),n(e,ie,t),n(e,it,t),c(oe,e,t),n(e,ot,t),n(e,pe,t),n(e,pt,t),c(re,e,t),n(e,rt,t),n(e,Me,t),n(e,Mt,t),c(de,e,t),n(e,dt,t),n(e,ce,t),n(e,ct,t),c(me,e,t),n(e,mt,t),n(e,ue,t),n(e,ut,t),n(e,he,t),n(e,ht,t),c(ye,e,t),n(e,yt,t),n(e,Jt,t),n(e,Tt,t),c(g,e,t),n(e,wt,t),c(Je,e,t),n(e,jt,t),n(e,we,t),gt=!0},p(e,[t]){const Ot={};t&2&&(Ot.$$scope={dirty:t,ctx:e}),j.$set(Ot);const es={};t&2&&(es.$$scope={dirty:t,ctx:e}),g.$set(es)},i(e){gt||(m(U.$$.fragment,e),m(b.$$.fragment,e),m(v.$$.fragment,e),m(H.$$.fragment,e),m(j.$$.fragment,e),m(X.$$.fragment,e),m(_.$$.fragment,e),m(F.$$.fragment,e),m(A.$$.fragment,e),m(Q.$$.fragment,e),m(K.$$.fragment,e),m(ee.$$.fragment,e),m(se.$$.fragment,e),m(le.$$.fragment,e),m(oe.$$.fragment,e),m(re.$$.fragment,e),m(de.$$.fragment,e),m(me.$$.fragment,e),m(ye.$$.fragment,e),m(g.$$.fragment,e),m(Je.$$.fragment,e),gt=!0)},o(e){u(U.$$.fragment,e),u(b.$$.fragment,e),u(v.$$.fragment,e),u(H.$$.fragment,e),u(j.$$.fragment,e),u(X.$$.fragment,e),u(_.$$.fragment,e),u(F.$$.fragment,e),u(A.$$.fragment,e),u(Q.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),u(se.$$.fragment,e),u(le.$$.fragment,e),u(oe.$$.fragment,e),u(re.$$.fragment,e),u(de.$$.fragment,e),u(me.$$.fragment,e),u(ye.$$.fragment,e),u(g.$$.fragment,e),u(Je.$$.fragment,e),gt=!1},d(e){e&&(s(T),s(y),s(w),s(ge),s(Ue),s(f),s(be),s(I),s(fe),s(Z),s(Ie),s(C),s(Ze),s(W),s(Ce),s(G),s(We),s(B),s(Ge),s(k),s(Be),s(ke),s(R),s(ve),s(Re),s(He),s(z),s(ze),s(Xe),s(_e),s(V),s(Ve),s(Y),s(Ye),s(N),s(Ne),s($),s($e),s(S),s(Se),s(Fe),s(E),s(Ee),s(Ae),s(Qe),s(x),s(xe),s(q),s(qe),s(L),s(Le),s(P),s(Pe),s(D),s(De),s(Ke),s(O),s(Oe),s(et),s(te),s(tt),s(st),s(ne),s(nt),s(ae),s(at),s(lt),s(ie),s(it),s(ot),s(pe),s(pt),s(rt),s(Me),s(Mt),s(dt),s(ce),s(ct),s(mt),s(ue),s(ut),s(he),s(ht),s(yt),s(Jt),s(Tt),s(wt),s(jt),s(we)),s(r),h(U,e),h(b,e),h(v,e),h(H,e),h(j,e),h(X,e),h(_,e),h(F,e),h(A,e),h(Q,e),h(K,e),h(ee,e),h(se,e),h(le,e),h(oe,e),h(re,e),h(de,e),h(me,e),h(ye,e),h(g,e),h(Je,e)}}}const ys='{"title":"Fine-tune and deploy embedding models with Amazon SageMaker","local":"fine-tune-and-deploy-embedding-models-with-amazon-sagemaker","sections":[{"title":"1. Setup Development Environment","local":"1-setup-development-environment","sections":[],"depth":2},{"title":"2. Create and prepare the dataset","local":"2-create-and-prepare-the-dataset","sections":[],"depth":2},{"title":"3. Fine-tune Embedding model on Amazon SageMaker","local":"3-fine-tune-embedding-model-on-amazon-sagemaker","sections":[],"depth":2},{"title":"4. Deploy & Test fine-tuned Embedding Model on Amazon SageMaker","local":"4-deploy--test-fine-tuned-embedding-model-on-amazon-sagemaker","sections":[],"depth":2}],"depth":1}';function Js(Te){return is(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bs extends os{constructor(r){super(),ps(this,r,Js,hs,ls,{})}}export{bs as component};
