import{s as Kt,o as el,n as Ot}from"../chunks/scheduler.aec39e6a.js";import{S as tl,i as ll,e as o,s as n,c as u,h as sl,a as i,d as l,b as a,f as Yt,g as c,j as p,k as Dt,l as nl,m as s,n as r,t as m,o as h,p as d}from"../chunks/index.4ee0a2d0.js";import{T as Pt}from"../chunks/Tip.e2132029.js";import{C as al,H as ye,E as ol}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.2422a08e.js";import{C as j}from"../chunks/CodeBlock.27357de2.js";function il(de){let M,y='<a href="https://github.com/aws/sagemaker-python-sdk" rel="nofollow">SageMaker Python SDK v3 has been recently released</a>, so unless specified otherwise, all the documentation and tutorials are still using the <a href="https://github.com/aws/sagemaker-python-sdk/tree/master-v2" rel="nofollow">SageMaker Python SDK v2</a>. We are actively working on updating all the tutorials and examples, but in the meantime make sure to install the SageMaker SDK as <code>pip install &quot;sagemaker&lt;3.0.0&quot;</code>.';return{c(){M=o("p"),M.innerHTML=y},l(T){M=i(T,"P",{"data-svelte-h":!0}),p(M)!=="svelte-1rh974s"&&(M.innerHTML=y)},m(T,J){s(T,M,J)},p:Ot,d(T){T&&l(M)}}}function pl(de){let M,y='📍 Find the complete example on GitHub <a href="https://github.com/huggingface/hub-docs/tree/main/notebooks/sagemaker-sdk/deploy-llama-3-3-70b-inferentia2/sagemaker-notebook.ipynb" rel="nofollow">here</a>!';return{c(){M=o("p"),M.innerHTML=y},l(T){M=i(T,"P",{"data-svelte-h":!0}),p(M)!=="svelte-8vujry"&&(M.innerHTML=y)},m(T,J){s(T,M,J)},p:Ot,d(T){T&&l(M)}}}function Ml(de){let M,y,T,J,f,je,U,Je,w,Tt='In this tutorial you will learn how to deploy <a href="https://huggingface.co/meta-llama/Llama-3.3-70B-Instruct" rel="nofollow">/meta-llama/Llama-3.3-70B-Instruct</a> model on AWS Inferentia2 with Hugging Face Optimum on Amazon SageMaker. We are going to use the Hugging Face TGI Neuron Container, a purpose-built Inference Container to easily deploy LLMs on AWS Inferentia2 powered by<a href="https://huggingface.co/docs/text-generation-inference/index" rel="nofollow">Text Generation Inference</a> and <a href="https://huggingface.co/docs/optimum-neuron/index" rel="nofollow">Optimum Neuron</a>.',ge,b,yt="We will cover how to:",Ie,C,jt='<li><a href="#1-setup-development-environment">Setup development environment</a></li> <li><a href="#2-retrieve-the-new-hugging-face-tgi-neuron-dlc">Retrieve the new Hugging Face TGI Neuron DLC</a></li> <li><a href="#3-deploy-llama-33-70b-to-inferentia2">Deploy Llama 3.3 70B to inferentia2</a></li> <li><a href="#4-clean-up">Clean up</a></li>',fe,N,Jt="Lets get started! 🚀",Ue,q,gt='<a href="https://aws.amazon.com/ec2/instance-types/inf2/" rel="nofollow">AWS inferentia (Inf2)</a> are purpose-built EC2 for deep learning (DL) inference workloads. Here are the different instances of the Inferentia2 family.',we,B,It="<thead><tr><th>instance size</th> <th>accelerators</th> <th>Neuron Cores</th> <th>accelerator memory</th> <th>vCPU</th> <th>CPU Memory</th> <th>on-demand price ($/h)</th></tr></thead> <tbody><tr><td>inf2.xlarge</td> <td>1</td> <td>2</td> <td>32</td> <td>4</td> <td>16</td> <td>0.76</td></tr> <tr><td>inf2.8xlarge</td> <td>1</td> <td>2</td> <td>32</td> <td>32</td> <td>128</td> <td>1.97</td></tr> <tr><td>inf2.24xlarge</td> <td>6</td> <td>12</td> <td>192</td> <td>96</td> <td>384</td> <td>6.49</td></tr> <tr><td>inf2.48xlarge</td> <td>12</td> <td>24</td> <td>384</td> <td>192</td> <td>768</td> <td>12.98</td></tr></tbody>",be,E,Ce,A,ft="For this tutorial, we are going to use a Notebook Instance in Amazon SageMaker with the Python 3 (ipykernel) and the <code>sagemaker</code> python SDK to deploy Llama 3.3 70B to a SageMaker inference endpoint.",Ne,Z,Ut="Make sur you have the latest version of the SageMaker SDK installed.",qe,x,Be,g,Ee,W,wt="Then, instantiate the sagemaker role and session.",Ae,v,Ze,k,xe,$,bt='The latest Hugging Face TGI Neuron DLCs can be used to run inference on AWS Inferentia2. You can use the <code>get_huggingface_llm_image_uri</code> method of the <code>sagemaker</code> SDK to retrieve the appropriate Hugging Face TGI Neuron DLC URI based on your desired <code>backend</code>, <code>session</code>, <code>region</code>, and <code>version</code>. You can find the latest version of the container <a href="https://huggingface.co/docs/optimum-neuron/containers" rel="nofollow">here</a>, if not yet added to the SageMaker SDK.',We,S,Ct="At the time of the tutorial, the latest version of the container is not yet added to the Sagemaker SDK so we will not use <code>get_huggingface_llm_image_uri</code>.",ve,_,ke,z,$e,G,Nt=`At the time of writing, <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/v2.6.0/general/arch/neuron-features/dynamic-shapes.html#neuron-dynamic-shapes" rel="nofollow">AWS Inferentia2 does not support dynamic shapes for inference</a>, which means that we need to specify our sequence length and batch size ahead of time.
To make it easier for customers to utilize the full power of Inferentia2, we created a <a href="https://huggingface.co/docs/optimum-neuron/guides/cache_system" rel="nofollow">neuron model cache</a>, which contains pre-compiled configurations for the most popular LLMs, including Llama 3.3 70B.`,Se,V,qt='This means we don’t need to compile the model ourselves, but we can use the pre-compiled model from the cache. You can find compiled/cached configurations on the <a href="https://huggingface.co/aws-neuron/optimum-neuron-cache/tree/main/inference-cache-config" rel="nofollow">Hugging Face Hub</a>. If your desired configuration is not yet cached, you can compile it yourself using the <a href="https://huggingface.co/docs/optimum-neuron/guides/export_model" rel="nofollow">Optimum CLI</a> or open a request at the <a href="https://huggingface.co/aws-neuron/optimum-neuron-cache/discussions" rel="nofollow">Cache repository</a>.',_e,Q,Bt="<strong>Deploying Llama 3.3 70B to a SageMaker Endpoint</strong>",ze,H,Et="Before deploying the model to Amazon SageMaker, we must define the TGI Neuron endpoint configuration. We need to make sure the following additional parameters are defined:",Ge,L,At="<li><code>HF_NUM_CORES</code>: Number of Neuron Cores used for the compilation.</li> <li><code>HF_BATCH_SIZE</code>: The batch size that was used to compile the model.</li> <li><code>HF_SEQUENCE_LENGTH</code>: The sequence length that was used to compile the model.</li> <li><code>HF_AUTO_CAST_TYPE</code>: The auto cast type that was used to compile the model.</li>",Ve,X,Zt="We still need to define traditional TGI parameters with:",Qe,F,xt="<li><code>HF_MODEL_ID</code>: The Hugging Face model ID.</li> <li><code>HF_TOKEN</code>: The Hugging Face API token to access gated models.</li> <li><code>MAX_BATCH_SIZE</code>: The maximum batch size that the model can handle, equal to the batch size used for compilation.</li> <li><code>MAX_INPUT_TOKEN</code>: The maximum input length that the model can handle.</li> <li><code>MAX_TOTAL_TOKENS</code>: The maximum total tokens the model can generate, equal to the sequence length used for compilation.</li>",He,R,Wt="Optionnaly, you can configure the endpoint to support chat templates:",Le,Y,vt="<li><code>MESSAGES_API_ENABLED</code>: Enable Messages API</li>",Xe,D,kt="<strong>Select the right instance type</strong>",Fe,P,$t='Llama 3.3 70B is a large model and requires a lot of memory. We are going to use the <code>inf2.48xlarge</code> instance type, which has 192 vCPUs and 384 GB of accelerator memory. The <code>inf2.48xlarge</code> instance comes with 12 Inferentia2 accelerators that include 24 Neuron Cores. If you want to find the cached configurations for Llama 3.3 70B, you can find them <a href="https://huggingface.co/aws-neuron/optimum-neuron-cache/blob/main/inference-cache-config/llama3-70b.json#L16" rel="nofollow">here</a>. In our case we will use a batch size of 4 and a sequence length of 4096.',Re,O,St='Before we can deploy Llama 3.3 70B to Inferentia2, we need to make sure we have the necessary permissions to access the model. You can request access to the model <a href="https://huggingface.co/meta-llama/Llama-3.3-70B-Instruct" rel="nofollow">here</a> and create a User access token following this <a href="https://huggingface.co/docs/hub/en/security-tokens" rel="nofollow">guide</a>.',Ye,K,_t="After that we can create our endpoint configuration and deploy the model to Amazon SageMaker. We will deploy the endpoint with the Messages API enabled, so that it is fully compatible with the OpenAI Chat Completion API.",De,ee,Pe,te,zt="After we have created the <code>HuggingFaceModel</code> we can deploy it to Amazon SageMaker using the <code>deploy</code> method. We will deploy the model with the <code>ml.inf2.48xlarge</code> instance type. TGI will automatically distribute and shard the model across all Inferentia devices.",Oe,le,Ke,se,Gt="SageMaker will now create our endpoint and deploy the model to it. It takes around 30 minutes for deployment.",et,ne,Vt="After our endpoint is deployed we can run inference on it. We will use the <code>predict</code> method from the <code>predictor</code> to run inference on our endpoint.",tt,ae,Qt="The endpoint supports the Messages API, which is fully compatible with the OpenAI Chat Completion API. The Messages API allows us to interact with the model in a conversational way. We can define the role of the message and the content. The role can be either <code>system</code>,<code>assistant</code> or <code>user</code>. The <code>system</code> role is used to provide context to the model and the <code>user</code> role is used to ask questions or provide input to the model.",lt,oe,Ht='Parameters can be defined as in the <code>parameters</code> attribute of the payload. Check out the chat completion <a href="https://platform.openai.com/docs/api-reference/chat/create" rel="nofollow">documentation</a> to find supported parameters.',st,ie,nt,pe,at,Me,Lt="Okay lets test it.",ot,ue,it,ce,pt,re,Xt="To clean up, we can delete the model and endpoint.",Mt,me,ut,ct,rt,I,mt,he,ht,Te,dt;return f=new al({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),U=new ye({props:{title:"Deploy Llama 3.3 70B on AWS Inferentia2",local:"deploy-llama-33-70b-on-aws-inferentia2",headingTag:"h1"}}),E=new ye({props:{title:"1. Setup development environment",local:"1-setup-development-environment",headingTag:"h2"}}),x=new j({props:{code:"IXBpcCUyMGluc3RhbGwlMjAnc2FnZW1ha2VyJTNDMy4wLjAnJTIwLS11cGdyYWRlJTIwLS1xdWlldA==",highlighted:'!pip install <span class="hljs-string">&#x27;sagemaker&lt;3.0.0&#x27;</span> --upgrade --quiet',wrap:!1}}),g=new Pt({props:{warning:!0,$$slots:{default:[il]},$$scope:{ctx:de}}}),v=new j({props:{code:"aW1wb3J0JTIwc2FnZW1ha2VyJTBBaW1wb3J0JTIwYm90bzMlMEFzZXNzJTIwJTNEJTIwc2FnZW1ha2VyLlNlc3Npb24oKSUwQSUyMyUyMHNhZ2VtYWtlciUyMHNlc3Npb24lMjBidWNrZXQlMjAtJTNFJTIwdXNlZCUyMGZvciUyMHVwbG9hZGluZyUyMGRhdGElMkMlMjBtb2RlbHMlMjBhbmQlMjBsb2dzJTBBJTIzJTIwc2FnZW1ha2VyJTIwd2lsbCUyMGF1dG9tYXRpY2FsbHklMjBjcmVhdGUlMjB0aGlzJTIwYnVja2V0JTIwaWYlMjBpdCUyMG5vdCUyMGV4aXN0cyUwQXNhZ2VtYWtlcl9zZXNzaW9uX2J1Y2tldCUzRE5vbmUlMEFpZiUyMHNhZ2VtYWtlcl9zZXNzaW9uX2J1Y2tldCUyMGlzJTIwTm9uZSUyMGFuZCUyMHNlc3MlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBzZXQlMjB0byUyMGRlZmF1bHQlMjBidWNrZXQlMjBpZiUyMGElMjBidWNrZXQlMjBuYW1lJTIwaXMlMjBub3QlMjBnaXZlbiUwQSUyMCUyMCUyMCUyMHNhZ2VtYWtlcl9zZXNzaW9uX2J1Y2tldCUyMCUzRCUyMHNlc3MuZGVmYXVsdF9idWNrZXQoKSUwQSUwQXRyeSUzQSUwQSUyMCUyMCUyMCUyMHJvbGUlMjAlM0QlMjBzYWdlbWFrZXIuZ2V0X2V4ZWN1dGlvbl9yb2xlKCklMEFleGNlcHQlMjBWYWx1ZUVycm9yJTNBJTBBJTIwJTIwJTIwJTIwaWFtJTIwJTNEJTIwYm90bzMuY2xpZW50KCdpYW0nKSUwQSUyMCUyMCUyMCUyMHJvbGUlMjAlM0QlMjBpYW0uZ2V0X3JvbGUoUm9sZU5hbWUlM0Qnc2FnZW1ha2VyX2V4ZWN1dGlvbl9yb2xlJyklNUInUm9sZSclNUQlNUInQXJuJyU1RCUwQSUwQXNlc3MlMjAlM0QlMjBzYWdlbWFrZXIuU2Vzc2lvbihkZWZhdWx0X2J1Y2tldCUzRHNhZ2VtYWtlcl9zZXNzaW9uX2J1Y2tldCklMEElMEFwcmludChmJTIyc2FnZW1ha2VyJTIwcm9sZSUyMGFybiUzQSUyMCU3QnJvbGUlN0QlMjIpJTBBcHJpbnQoZiUyMnNhZ2VtYWtlciUyMHNlc3Npb24lMjByZWdpb24lM0ElMjAlN0JzZXNzLmJvdG9fcmVnaW9uX25hbWUlN0QlMjIp",highlighted:`<span class="hljs-keyword">import</span> sagemaker
<span class="hljs-keyword">import</span> boto3
sess = sagemaker.Session()
<span class="hljs-comment"># sagemaker session bucket -&gt; used for uploading data, models and logs</span>
<span class="hljs-comment"># sagemaker will automatically create this bucket if it not exists</span>
sagemaker_session_bucket=<span class="hljs-literal">None</span>
<span class="hljs-keyword">if</span> sagemaker_session_bucket <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">and</span> sess <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
    <span class="hljs-comment"># set to default bucket if a bucket name is not given</span>
    sagemaker_session_bucket = sess.default_bucket()

<span class="hljs-keyword">try</span>:
    role = sagemaker.get_execution_role()
<span class="hljs-keyword">except</span> ValueError:
    iam = boto3.client(<span class="hljs-string">&#x27;iam&#x27;</span>)
    role = iam.get_role(RoleName=<span class="hljs-string">&#x27;sagemaker_execution_role&#x27;</span>)[<span class="hljs-string">&#x27;Role&#x27;</span>][<span class="hljs-string">&#x27;Arn&#x27;</span>]

sess = sagemaker.Session(default_bucket=sagemaker_session_bucket)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;sagemaker role arn: <span class="hljs-subst">{role}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;sagemaker session region: <span class="hljs-subst">{sess.boto_region_name}</span>&quot;</span>)`,wrap:!1}}),k=new ye({props:{title:"2. Retrieve the latest Hugging Face TGI Neuron DLC",local:"2-retrieve-the-latest-hugging-face-tgi-neuron-dlc",headingTag:"h2"}}),_=new j({props:{code:"JTIzJTIwcHVsbGVkJTIwZnJvbSUyMGh0dHBzJTNBJTJGJTJGZ2l0aHViLmNvbSUyRmF3cyUyRnNhZ2VtYWtlci1weXRob24tc2RrJTJGYmxvYiUyRm1hc3RlciUyRnNyYyUyRnNhZ2VtYWtlciUyRmltYWdlX3VyaV9jb25maWclMkZodWdnaW5nZmFjZS1sbG0tbmV1cm9ueC5qc29uJTBBYWNjb3VudF9pZF9kaWN0JTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyYXAtbm9ydGhlYXN0LTElMjIlM0ElMjAlMjI3NjMxMDQzNTE4ODQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhcC1zb3V0aC0xJTIyJTNBJTIwJTIyNzYzMTA0MzUxODg0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyYXAtc291dGgtMiUyMiUzQSUyMCUyMjc3MjE1MzE1ODQ1MiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmFwLXNvdXRoZWFzdC0xJTIyJTNBJTIwJTIyNzYzMTA0MzUxODg0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyYXAtc291dGhlYXN0LTIlMjIlM0ElMjAlMjI3NjMxMDQzNTE4ODQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhcC1zb3V0aGVhc3QtNCUyMiUzQSUyMCUyMjQ1NzQ0NzI3NDMyMiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmFwLXNvdXRoZWFzdC01JTIyJTNBJTIwJTIyNTUwMjI1NDMzNDYyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyYXAtc291dGhlYXN0LTclMjIlM0ElMjAlMjI1OTAxODM4MTM0MzclMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJjbi1ub3J0aC0xJTIyJTNBJTIwJTIyNzI3ODk3NDcxODA3JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyY24tbm9ydGh3ZXN0LTElMjIlM0ElMjAlMjI3Mjc4OTc0NzE4MDclMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJldS1jZW50cmFsLTElMjIlM0ElMjAlMjI3NjMxMDQzNTE4ODQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJldS1jZW50cmFsLTIlMjIlM0ElMjAlMjIzODA0MjA4MDk2ODglMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJldS1zb3V0aC0yJTIyJTNBJTIwJTIyNTAzMjI3Mzc2Nzg1JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyZXUtd2VzdC0xJTIyJTNBJTIwJTIyNzYzMTA0MzUxODg0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyZXUtd2VzdC0zJTIyJTNBJTIwJTIyNzYzMTA0MzUxODg0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyaWwtY2VudHJhbC0xJTIyJTNBJTIwJTIyNzgwNTQzMDIyMTI2JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIybXgtY2VudHJhbC0xJTIyJTNBJTIyNjM3NDIzMjM5OTQyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyc2EtZWFzdC0xJTIyJTNBJTIwJTIyNzYzMTA0MzUxODg0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydXMtZWFzdC0xJTIyJTNBJTIwJTIyNzYzMTA0MzUxODg0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydXMtZWFzdC0yJTIyJTNBJTIwJTIyNzYzMTA0MzUxODg0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydXMtZ292LWVhc3QtMSUyMiUzQSUyMCUyMjQ0NjA0NTA4NjQxMiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMnVzLWdvdi13ZXN0LTElMjIlM0ElMjAlMjI0NDIzODY3NDQzNTMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJ1cy13ZXN0LTIlMjIlM0ElMjAlMjI3NjMxMDQzNTE4ODQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJjYS13ZXN0LTElMjIlM0ElMjAlMjIyMDQ1MzgxNDM1NzIlMjIlMEElN0QlMEElMEFyZWdpb24lMjAlM0QlMjBib3RvMy5TZXNzaW9uKCkucmVnaW9uX25hbWUlMEFsbG1faW1hZ2UlMjAlM0QlMjBmJTIyJTdCYWNjb3VudF9pZF9kaWN0JTVCcmVnaW9uJTVEJTdELmRrci5lY3IuJTdCcmVnaW9uJTdELmFtYXpvbmF3cy5jb20lMkZodWdnaW5nZmFjZS1weXRvcmNoLXRnaS1pbmZlcmVuY2UlM0EyLjEuMi1vcHRpbXVtMC4wLjI4LW5ldXJvbngtcHkzMTAtdWJ1bnR1MjIuMDQlMjI=",highlighted:`<span class="hljs-comment"># pulled from https://github.com/aws/sagemaker-python-sdk/blob/master/src/sagemaker/image_uri_config/huggingface-llm-neuronx.json</span>
account_id_dict= {
    <span class="hljs-string">&quot;ap-northeast-1&quot;</span>: <span class="hljs-string">&quot;763104351884&quot;</span>,
    <span class="hljs-string">&quot;ap-south-1&quot;</span>: <span class="hljs-string">&quot;763104351884&quot;</span>,
    <span class="hljs-string">&quot;ap-south-2&quot;</span>: <span class="hljs-string">&quot;772153158452&quot;</span>,
    <span class="hljs-string">&quot;ap-southeast-1&quot;</span>: <span class="hljs-string">&quot;763104351884&quot;</span>,
    <span class="hljs-string">&quot;ap-southeast-2&quot;</span>: <span class="hljs-string">&quot;763104351884&quot;</span>,
    <span class="hljs-string">&quot;ap-southeast-4&quot;</span>: <span class="hljs-string">&quot;457447274322&quot;</span>,
    <span class="hljs-string">&quot;ap-southeast-5&quot;</span>: <span class="hljs-string">&quot;550225433462&quot;</span>,
    <span class="hljs-string">&quot;ap-southeast-7&quot;</span>: <span class="hljs-string">&quot;590183813437&quot;</span>,
    <span class="hljs-string">&quot;cn-north-1&quot;</span>: <span class="hljs-string">&quot;727897471807&quot;</span>,
    <span class="hljs-string">&quot;cn-northwest-1&quot;</span>: <span class="hljs-string">&quot;727897471807&quot;</span>,
    <span class="hljs-string">&quot;eu-central-1&quot;</span>: <span class="hljs-string">&quot;763104351884&quot;</span>,
    <span class="hljs-string">&quot;eu-central-2&quot;</span>: <span class="hljs-string">&quot;380420809688&quot;</span>,
    <span class="hljs-string">&quot;eu-south-2&quot;</span>: <span class="hljs-string">&quot;503227376785&quot;</span>,
    <span class="hljs-string">&quot;eu-west-1&quot;</span>: <span class="hljs-string">&quot;763104351884&quot;</span>,
    <span class="hljs-string">&quot;eu-west-3&quot;</span>: <span class="hljs-string">&quot;763104351884&quot;</span>,
    <span class="hljs-string">&quot;il-central-1&quot;</span>: <span class="hljs-string">&quot;780543022126&quot;</span>,
    <span class="hljs-string">&quot;mx-central-1&quot;</span>:<span class="hljs-string">&quot;637423239942&quot;</span>,
    <span class="hljs-string">&quot;sa-east-1&quot;</span>: <span class="hljs-string">&quot;763104351884&quot;</span>,
    <span class="hljs-string">&quot;us-east-1&quot;</span>: <span class="hljs-string">&quot;763104351884&quot;</span>,
    <span class="hljs-string">&quot;us-east-2&quot;</span>: <span class="hljs-string">&quot;763104351884&quot;</span>,
    <span class="hljs-string">&quot;us-gov-east-1&quot;</span>: <span class="hljs-string">&quot;446045086412&quot;</span>,
    <span class="hljs-string">&quot;us-gov-west-1&quot;</span>: <span class="hljs-string">&quot;442386744353&quot;</span>,
    <span class="hljs-string">&quot;us-west-2&quot;</span>: <span class="hljs-string">&quot;763104351884&quot;</span>,
    <span class="hljs-string">&quot;ca-west-1&quot;</span>: <span class="hljs-string">&quot;204538143572&quot;</span>
}

region = boto3.Session().region_name
llm_image = <span class="hljs-string">f&quot;<span class="hljs-subst">{account_id_dict[region]}</span>.dkr.ecr.<span class="hljs-subst">{region}</span>.amazonaws.com/huggingface-pytorch-tgi-inference:2.1.2-optimum0.0.28-neuronx-py310-ubuntu22.04&quot;</span>`,wrap:!1}}),z=new ye({props:{title:"3. Deploy Llama 3.3 70B to Inferentia2",local:"3-deploy-llama-33-70b-to-inferentia2",headingTag:"h2"}}),ee=new j({props:{code:"ZnJvbSUyMHNhZ2VtYWtlci5odWdnaW5nZmFjZSUyMGltcG9ydCUyMEh1Z2dpbmdGYWNlTW9kZWwlMEElMEElMjMlMjBzYWdlbWFrZXIlMjBjb25maWclMEFpbnN0YW5jZV90eXBlJTIwJTNEJTIwJTIybWwuaW5mMi40OHhsYXJnZSUyMiUwQWhlYWx0aF9jaGVja190aW1lb3V0JTNEMzYwMCUyMCUyMyUyMGFkZGl0aW9uYWwlMjB0aW1lJTIwdG8lMjBsb2FkJTIwdGhlJTIwbW9kZWwlMEF2b2x1bWVfc2l6ZSUzRDUxMiUyMCUyMyUyMHNpemUlMjBpbiUyMEdCJTIwb2YlMjB0aGUlMjBFQlMlMjB2b2x1bWUlMEElMEElMjMlMjBEZWZpbmUlMjBNb2RlbCUyMGFuZCUyMEVuZHBvaW50JTIwY29uZmlndXJhdGlvbiUyMHBhcmFtZXRlciUwQWNvbmZpZyUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMkhGX01PREVMX0lEJTIyJTNBJTIwJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy03MEItSW5zdHJ1Y3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJIRl9OVU1fQ09SRVMlMjIlM0ElMjAlMjIyNCUyMiUyQyUyMCUyMyUyMG51bWJlciUyMG9mJTIwbmV1cm9uJTIwY29yZXMlMEElMjAlMjAlMjAlMjAlMjJIRl9BVVRPX0NBU1RfVFlQRSUyMiUzQSUyMCUyMmJmMTYlMjIlMkMlMjAlMjAlMjMlMjBkdHlwZSUyMG9mJTIwdGhlJTIwbW9kZWwlMEElMjAlMjAlMjAlMjAlMjJNQVhfQkFUQ0hfU0laRSUyMiUzQSUyMCUyMjQlMjIlMkMlMjAlMjMlMjBtYXglMjBiYXRjaCUyMHNpemUlMjBmb3IlMjB0aGUlMjBtb2RlbCUwQSUyMCUyMCUyMCUyMCUyMk1BWF9JTlBVVF9UT0tFTlMlMjIlM0ElMjAlMjI0MDAwJTIyJTJDJTIwJTIzJTIwbWF4JTIwbGVuZ3RoJTIwb2YlMjBpbnB1dCUyMHRleHQlMEElMjAlMjAlMjAlMjAlMjJNQVhfVE9UQUxfVE9LRU5TJTIyJTNBJTIwJTIyNDA5NiUyMiUyQyUyMCUyMyUyMG1heCUyMGxlbmd0aCUyMG9mJTIwZ2VuZXJhdGVkJTIwdGV4dCUwQSUyMCUyMCUyMCUyMCUyMk1FU1NBR0VTX0FQSV9FTkFCTEVEJTIyJTNBJTIwJTIydHJ1ZSUyMiUyQyUyMCUyMyUyMEVuYWJsZSUyMHRoZSUyMG1lc3NhZ2VzJTIwQVBJJTBBJTIwJTIwJTIwJTIwJTIySEZfVE9LRU4lMjIlM0ElMjAlMjIlM0NSRVBMQUNFJTIwV0lUSCUyMFlPVVIlMjBUT0tFTiUzRSUyMiUyQyUwQSU3RCUwQSUwQWFzc2VydCUyMGNvbmZpZyU1QiUyMkhGX1RPS0VOJTIyJTVEJTIwISUzRCUyMCUyMiUzQ1JFUExBQ0UlMjBXSVRIJTIwWU9VUiUyMFRPS0VOJTNFJTIyJTJDJTIwJTIyUGxlYXNlJTIwcmVwbGFjZSUyMCclM0NSRVBMQUNFJTIwV0lUSCUyMFlPVVIlMjBUT0tFTiUzRSclMjB3aXRoJTIweW91ciUyMEh1Z2dpbmclMjBGYWNlJTIwSHViJTIwQVBJJTIwdG9rZW4lMjIlMEElMEElMEElMjMlMjBjcmVhdGUlMjBIdWdnaW5nRmFjZU1vZGVsJTIwd2l0aCUyMHRoZSUyMGltYWdlJTIwdXJpJTBBbGxtX21vZGVsJTIwJTNEJTIwSHVnZ2luZ0ZhY2VNb2RlbCglMEElMjAlMjByb2xlJTNEcm9sZSUyQyUwQSUyMCUyMGltYWdlX3VyaSUzRGxsbV9pbWFnZSUyQyUwQSUyMCUyMGVudiUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface <span class="hljs-keyword">import</span> HuggingFaceModel

<span class="hljs-comment"># sagemaker config</span>
instance_type = <span class="hljs-string">&quot;ml.inf2.48xlarge&quot;</span>
health_check_timeout=<span class="hljs-number">3600</span> <span class="hljs-comment"># additional time to load the model</span>
volume_size=<span class="hljs-number">512</span> <span class="hljs-comment"># size in GB of the EBS volume</span>

<span class="hljs-comment"># Define Model and Endpoint configuration parameter</span>
config = {
    <span class="hljs-string">&quot;HF_MODEL_ID&quot;</span>: <span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>,
    <span class="hljs-string">&quot;HF_NUM_CORES&quot;</span>: <span class="hljs-string">&quot;24&quot;</span>, <span class="hljs-comment"># number of neuron cores</span>
    <span class="hljs-string">&quot;HF_AUTO_CAST_TYPE&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>,  <span class="hljs-comment"># dtype of the model</span>
    <span class="hljs-string">&quot;MAX_BATCH_SIZE&quot;</span>: <span class="hljs-string">&quot;4&quot;</span>, <span class="hljs-comment"># max batch size for the model</span>
    <span class="hljs-string">&quot;MAX_INPUT_TOKENS&quot;</span>: <span class="hljs-string">&quot;4000&quot;</span>, <span class="hljs-comment"># max length of input text</span>
    <span class="hljs-string">&quot;MAX_TOTAL_TOKENS&quot;</span>: <span class="hljs-string">&quot;4096&quot;</span>, <span class="hljs-comment"># max length of generated text</span>
    <span class="hljs-string">&quot;MESSAGES_API_ENABLED&quot;</span>: <span class="hljs-string">&quot;true&quot;</span>, <span class="hljs-comment"># Enable the messages API</span>
    <span class="hljs-string">&quot;HF_TOKEN&quot;</span>: <span class="hljs-string">&quot;&lt;REPLACE WITH YOUR TOKEN&gt;&quot;</span>,
}

<span class="hljs-keyword">assert</span> config[<span class="hljs-string">&quot;HF_TOKEN&quot;</span>] != <span class="hljs-string">&quot;&lt;REPLACE WITH YOUR TOKEN&gt;&quot;</span>, <span class="hljs-string">&quot;Please replace &#x27;&lt;REPLACE WITH YOUR TOKEN&gt;&#x27; with your Hugging Face Hub API token&quot;</span>


<span class="hljs-comment"># create HuggingFaceModel with the image uri</span>
llm_model = HuggingFaceModel(
  role=role,
  image_uri=llm_image,
  env=config
)`,wrap:!1}}),le=new j({props:{code:"JTIzJTIwZGVhY3RpdmF0ZSUyMHdhcm5pbmclMjBzaW5jZSUyMG1vZGVsJTIwaXMlMjBjb21waWxlZCUwQWxsbV9tb2RlbC5faXNfY29tcGlsZWRfbW9kZWwlMjAlM0QlMjBUcnVlJTBBJTBBbGxtJTIwJTNEJTIwbGxtX21vZGVsLmRlcGxveSglMEElMjAlMjBpbml0aWFsX2luc3RhbmNlX2NvdW50JTNEMSUyQyUwQSUyMCUyMGluc3RhbmNlX3R5cGUlM0RpbnN0YW5jZV90eXBlJTJDJTBBJTIwJTIwY29udGFpbmVyX3N0YXJ0dXBfaGVhbHRoX2NoZWNrX3RpbWVvdXQlM0RoZWFsdGhfY2hlY2tfdGltZW91dCUyQyUwQSUyMCUyMHZvbHVtZV9zaXplJTNEdm9sdW1lX3NpemUlMEEp",highlighted:`<span class="hljs-comment"># deactivate warning since model is compiled</span>
llm_model._is_compiled_model = <span class="hljs-literal">True</span>

llm = llm_model.deploy(
  initial_instance_count=<span class="hljs-number">1</span>,
  instance_type=instance_type,
  container_startup_health_check_timeout=health_check_timeout,
  volume_size=volume_size
)`,wrap:!1}}),ie=new j({props:{code:"JTdCJTBBJTIwJTIwJTIybWVzc2FnZXMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjAlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGElMjBoZWxwZnVsJTIwYXNzaXN0YW50LiUyMiUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMCUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoYXQlMjBpcyUyMGRlZXAlMjBsZWFybmluZyUzRiUyMiUyMCU3RCUwQSUyMCUyMCU1RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;messages&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-punctuation">{</span> <span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;system&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span> <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-punctuation">{</span> <span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;What is deep learning?&quot;</span> <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),pe=new j({props:{code:"JTIzJTIwUHJvbXB0JTIwdG8lMjBnZW5lcmF0ZSUwQW1lc3NhZ2VzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIwJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGFzc2lzdGFudC4lMjIlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjAlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjBkZWVwJTIwbGVhcm5pbmclMjBpbiUyMG9uZSUyMHNlbnRlbmNlJTNGJTIyJTIwJTdEJTBBJTVEJTBBJTBBJTIzJTIwR2VuZXJhdGlvbiUyMGFyZ3VtZW50cyUyMGh0dHBzJTNBJTJGJTJGcGxhdGZvcm0ub3BlbmFpLmNvbSUyRmRvY3MlMkZhcGktcmVmZXJlbmNlJTJGY2hhdCUyRmNyZWF0ZSUwQXBhcmFtZXRlcnMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJtYXhfdG9rZW5zJTIyJTNBMTAwJTJDJTBBJTdE",highlighted:`<span class="hljs-comment"># Prompt to generate</span>
messages=[
    { <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span> },
    { <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is deep learning in one sentence?&quot;</span> }
]

<span class="hljs-comment"># Generation arguments https://platform.openai.com/docs/api-reference/chat/create</span>
parameters = {
    <span class="hljs-string">&quot;max_tokens&quot;</span>:<span class="hljs-number">100</span>,
}`,wrap:!1}}),ue=new j({props:{code:"Y2hhdCUyMCUzRCUyMGxsbS5wcmVkaWN0KCU3QiUyMm1lc3NhZ2VzJTIyJTIwJTNBbWVzc2FnZXMlMkMlMjAqKnBhcmFtZXRlcnMlMkMlMjJzdGVhbSUyMiUzQVRydWUlN0QpJTBBJTBBcHJpbnQoY2hhdCU1QiUyMmNob2ljZXMlMjIlNUQlNUIwJTVEJTVCJTIybWVzc2FnZSUyMiU1RCU1QiUyMmNvbnRlbnQlMjIlNUQuc3RyaXAoKSk=",highlighted:`chat = llm.predict({<span class="hljs-string">&quot;messages&quot;</span> :messages, **parameters,<span class="hljs-string">&quot;steam&quot;</span>:<span class="hljs-literal">True</span>})

<span class="hljs-built_in">print</span>(chat[<span class="hljs-string">&quot;choices&quot;</span>][<span class="hljs-number">0</span>][<span class="hljs-string">&quot;message&quot;</span>][<span class="hljs-string">&quot;content&quot;</span>].strip())`,wrap:!1}}),ce=new ye({props:{title:"4. Clean up",local:"4-clean-up",headingTag:"h2"}}),me=new j({props:{code:"bGxtLmRlbGV0ZV9tb2RlbCgpJTBBbGxtLmRlbGV0ZV9lbmRwb2ludCgp",highlighted:`llm.delete_model()
llm.delete_endpoint()`,wrap:!1}}),I=new Pt({props:{$$slots:{default:[pl]},$$scope:{ctx:de}}}),he=new ol({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/sagemaker/source/examples/sagemaker-sdk-deploy-llama-3-3-70b-inferentia2.mdx"}}),{c(){M=o("meta"),y=n(),T=o("p"),J=n(),u(f.$$.fragment),je=n(),u(U.$$.fragment),Je=n(),w=o("p"),w.innerHTML=Tt,ge=n(),b=o("p"),b.textContent=yt,Ie=n(),C=o("ol"),C.innerHTML=jt,fe=n(),N=o("p"),N.textContent=Jt,Ue=n(),q=o("p"),q.innerHTML=gt,we=n(),B=o("table"),B.innerHTML=It,be=n(),u(E.$$.fragment),Ce=n(),A=o("p"),A.innerHTML=ft,Ne=n(),Z=o("p"),Z.textContent=Ut,qe=n(),u(x.$$.fragment),Be=n(),u(g.$$.fragment),Ee=n(),W=o("p"),W.textContent=wt,Ae=n(),u(v.$$.fragment),Ze=n(),u(k.$$.fragment),xe=n(),$=o("p"),$.innerHTML=bt,We=n(),S=o("p"),S.innerHTML=Ct,ve=n(),u(_.$$.fragment),ke=n(),u(z.$$.fragment),$e=n(),G=o("p"),G.innerHTML=Nt,Se=n(),V=o("p"),V.innerHTML=qt,_e=n(),Q=o("p"),Q.innerHTML=Bt,ze=n(),H=o("p"),H.textContent=Et,Ge=n(),L=o("ul"),L.innerHTML=At,Ve=n(),X=o("p"),X.textContent=Zt,Qe=n(),F=o("ul"),F.innerHTML=xt,He=n(),R=o("p"),R.textContent=Wt,Le=n(),Y=o("ul"),Y.innerHTML=vt,Xe=n(),D=o("p"),D.innerHTML=kt,Fe=n(),P=o("p"),P.innerHTML=$t,Re=n(),O=o("p"),O.innerHTML=St,Ye=n(),K=o("p"),K.textContent=_t,De=n(),u(ee.$$.fragment),Pe=n(),te=o("p"),te.innerHTML=zt,Oe=n(),u(le.$$.fragment),Ke=n(),se=o("p"),se.textContent=Gt,et=n(),ne=o("p"),ne.innerHTML=Vt,tt=n(),ae=o("p"),ae.innerHTML=Qt,lt=n(),oe=o("p"),oe.innerHTML=Ht,st=n(),u(ie.$$.fragment),nt=n(),u(pe.$$.fragment),at=n(),Me=o("p"),Me.textContent=Lt,ot=n(),u(ue.$$.fragment),it=n(),u(ce.$$.fragment),pt=n(),re=o("p"),re.textContent=Xt,Mt=n(),u(me.$$.fragment),ut=n(),ct=o("hr"),rt=n(),u(I.$$.fragment),mt=n(),u(he.$$.fragment),ht=n(),Te=o("p"),this.h()},l(e){const t=sl("svelte-u9bgzb",document.head);M=i(t,"META",{name:!0,content:!0}),t.forEach(l),y=a(e),T=i(e,"P",{}),Yt(T).forEach(l),J=a(e),c(f.$$.fragment,e),je=a(e),c(U.$$.fragment,e),Je=a(e),w=i(e,"P",{"data-svelte-h":!0}),p(w)!=="svelte-18ykppc"&&(w.innerHTML=Tt),ge=a(e),b=i(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-df2280"&&(b.textContent=yt),Ie=a(e),C=i(e,"OL",{"data-svelte-h":!0}),p(C)!=="svelte-ouxi3x"&&(C.innerHTML=jt),fe=a(e),N=i(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-fedw35"&&(N.textContent=Jt),Ue=a(e),q=i(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1q2zsrn"&&(q.innerHTML=gt),we=a(e),B=i(e,"TABLE",{"data-svelte-h":!0}),p(B)!=="svelte-1tmwmqe"&&(B.innerHTML=It),be=a(e),c(E.$$.fragment,e),Ce=a(e),A=i(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1e6mm58"&&(A.innerHTML=ft),Ne=a(e),Z=i(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-gxxxnf"&&(Z.textContent=Ut),qe=a(e),c(x.$$.fragment,e),Be=a(e),c(g.$$.fragment,e),Ee=a(e),W=i(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-k2b9z7"&&(W.textContent=wt),Ae=a(e),c(v.$$.fragment,e),Ze=a(e),c(k.$$.fragment,e),xe=a(e),$=i(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-150z9km"&&($.innerHTML=bt),We=a(e),S=i(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-183iqes"&&(S.innerHTML=Ct),ve=a(e),c(_.$$.fragment,e),ke=a(e),c(z.$$.fragment,e),$e=a(e),G=i(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-w7lp5p"&&(G.innerHTML=Nt),Se=a(e),V=i(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1kijx5w"&&(V.innerHTML=qt),_e=a(e),Q=i(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-prnhqf"&&(Q.innerHTML=Bt),ze=a(e),H=i(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1lo8mr8"&&(H.textContent=Et),Ge=a(e),L=i(e,"UL",{"data-svelte-h":!0}),p(L)!=="svelte-19xkqok"&&(L.innerHTML=At),Ve=a(e),X=i(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-7y1w5l"&&(X.textContent=Zt),Qe=a(e),F=i(e,"UL",{"data-svelte-h":!0}),p(F)!=="svelte-21hz0o"&&(F.innerHTML=xt),He=a(e),R=i(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-ba46xn"&&(R.textContent=Wt),Le=a(e),Y=i(e,"UL",{"data-svelte-h":!0}),p(Y)!=="svelte-i1wt4y"&&(Y.innerHTML=vt),Xe=a(e),D=i(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1qiwbk5"&&(D.innerHTML=kt),Fe=a(e),P=i(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1px60yi"&&(P.innerHTML=$t),Re=a(e),O=i(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-1mh0xpb"&&(O.innerHTML=St),Ye=a(e),K=i(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-dbarld"&&(K.textContent=_t),De=a(e),c(ee.$$.fragment,e),Pe=a(e),te=i(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-eb49q4"&&(te.innerHTML=zt),Oe=a(e),c(le.$$.fragment,e),Ke=a(e),se=i(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-hs5wbn"&&(se.textContent=Gt),et=a(e),ne=i(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-1popn9h"&&(ne.innerHTML=Vt),tt=a(e),ae=i(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-7vzs06"&&(ae.innerHTML=Qt),lt=a(e),oe=i(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-gr6587"&&(oe.innerHTML=Ht),st=a(e),c(ie.$$.fragment,e),nt=a(e),c(pe.$$.fragment,e),at=a(e),Me=i(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-1pq3qhh"&&(Me.textContent=Lt),ot=a(e),c(ue.$$.fragment,e),it=a(e),c(ce.$$.fragment,e),pt=a(e),re=i(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-100mxno"&&(re.textContent=Xt),Mt=a(e),c(me.$$.fragment,e),ut=a(e),ct=i(e,"HR",{}),rt=a(e),c(I.$$.fragment,e),mt=a(e),c(he.$$.fragment,e),ht=a(e),Te=i(e,"P",{}),Yt(Te).forEach(l),this.h()},h(){Dt(M,"name","hf:doc:metadata"),Dt(M,"content",ul)},m(e,t){nl(document.head,M),s(e,y,t),s(e,T,t),s(e,J,t),r(f,e,t),s(e,je,t),r(U,e,t),s(e,Je,t),s(e,w,t),s(e,ge,t),s(e,b,t),s(e,Ie,t),s(e,C,t),s(e,fe,t),s(e,N,t),s(e,Ue,t),s(e,q,t),s(e,we,t),s(e,B,t),s(e,be,t),r(E,e,t),s(e,Ce,t),s(e,A,t),s(e,Ne,t),s(e,Z,t),s(e,qe,t),r(x,e,t),s(e,Be,t),r(g,e,t),s(e,Ee,t),s(e,W,t),s(e,Ae,t),r(v,e,t),s(e,Ze,t),r(k,e,t),s(e,xe,t),s(e,$,t),s(e,We,t),s(e,S,t),s(e,ve,t),r(_,e,t),s(e,ke,t),r(z,e,t),s(e,$e,t),s(e,G,t),s(e,Se,t),s(e,V,t),s(e,_e,t),s(e,Q,t),s(e,ze,t),s(e,H,t),s(e,Ge,t),s(e,L,t),s(e,Ve,t),s(e,X,t),s(e,Qe,t),s(e,F,t),s(e,He,t),s(e,R,t),s(e,Le,t),s(e,Y,t),s(e,Xe,t),s(e,D,t),s(e,Fe,t),s(e,P,t),s(e,Re,t),s(e,O,t),s(e,Ye,t),s(e,K,t),s(e,De,t),r(ee,e,t),s(e,Pe,t),s(e,te,t),s(e,Oe,t),r(le,e,t),s(e,Ke,t),s(e,se,t),s(e,et,t),s(e,ne,t),s(e,tt,t),s(e,ae,t),s(e,lt,t),s(e,oe,t),s(e,st,t),r(ie,e,t),s(e,nt,t),r(pe,e,t),s(e,at,t),s(e,Me,t),s(e,ot,t),r(ue,e,t),s(e,it,t),r(ce,e,t),s(e,pt,t),s(e,re,t),s(e,Mt,t),r(me,e,t),s(e,ut,t),s(e,ct,t),s(e,rt,t),r(I,e,t),s(e,mt,t),r(he,e,t),s(e,ht,t),s(e,Te,t),dt=!0},p(e,[t]){const Ft={};t&2&&(Ft.$$scope={dirty:t,ctx:e}),g.$set(Ft);const Rt={};t&2&&(Rt.$$scope={dirty:t,ctx:e}),I.$set(Rt)},i(e){dt||(m(f.$$.fragment,e),m(U.$$.fragment,e),m(E.$$.fragment,e),m(x.$$.fragment,e),m(g.$$.fragment,e),m(v.$$.fragment,e),m(k.$$.fragment,e),m(_.$$.fragment,e),m(z.$$.fragment,e),m(ee.$$.fragment,e),m(le.$$.fragment,e),m(ie.$$.fragment,e),m(pe.$$.fragment,e),m(ue.$$.fragment,e),m(ce.$$.fragment,e),m(me.$$.fragment,e),m(I.$$.fragment,e),m(he.$$.fragment,e),dt=!0)},o(e){h(f.$$.fragment,e),h(U.$$.fragment,e),h(E.$$.fragment,e),h(x.$$.fragment,e),h(g.$$.fragment,e),h(v.$$.fragment,e),h(k.$$.fragment,e),h(_.$$.fragment,e),h(z.$$.fragment,e),h(ee.$$.fragment,e),h(le.$$.fragment,e),h(ie.$$.fragment,e),h(pe.$$.fragment,e),h(ue.$$.fragment,e),h(ce.$$.fragment,e),h(me.$$.fragment,e),h(I.$$.fragment,e),h(he.$$.fragment,e),dt=!1},d(e){e&&(l(y),l(T),l(J),l(je),l(Je),l(w),l(ge),l(b),l(Ie),l(C),l(fe),l(N),l(Ue),l(q),l(we),l(B),l(be),l(Ce),l(A),l(Ne),l(Z),l(qe),l(Be),l(Ee),l(W),l(Ae),l(Ze),l(xe),l($),l(We),l(S),l(ve),l(ke),l($e),l(G),l(Se),l(V),l(_e),l(Q),l(ze),l(H),l(Ge),l(L),l(Ve),l(X),l(Qe),l(F),l(He),l(R),l(Le),l(Y),l(Xe),l(D),l(Fe),l(P),l(Re),l(O),l(Ye),l(K),l(De),l(Pe),l(te),l(Oe),l(Ke),l(se),l(et),l(ne),l(tt),l(ae),l(lt),l(oe),l(st),l(nt),l(at),l(Me),l(ot),l(it),l(pt),l(re),l(Mt),l(ut),l(ct),l(rt),l(mt),l(ht),l(Te)),l(M),d(f,e),d(U,e),d(E,e),d(x,e),d(g,e),d(v,e),d(k,e),d(_,e),d(z,e),d(ee,e),d(le,e),d(ie,e),d(pe,e),d(ue,e),d(ce,e),d(me,e),d(I,e),d(he,e)}}}const ul='{"title":"Deploy Llama 3.3 70B on AWS Inferentia2","local":"deploy-llama-33-70b-on-aws-inferentia2","sections":[{"title":"1. Setup development environment","local":"1-setup-development-environment","sections":[],"depth":2},{"title":"2. Retrieve the latest Hugging Face TGI Neuron DLC","local":"2-retrieve-the-latest-hugging-face-tgi-neuron-dlc","sections":[],"depth":2},{"title":"3. Deploy Llama 3.3 70B to Inferentia2","local":"3-deploy-llama-33-70b-to-inferentia2","sections":[],"depth":2},{"title":"4. Clean up","local":"4-clean-up","sections":[],"depth":2}],"depth":1}';function cl(de){return el(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class yl extends tl{constructor(M){super(),ll(this,M,cl,Ml,Kt,{})}}export{yl as component};
