import{s as $t,o as Ht,n as Ct}from"../chunks/scheduler.aec39e6a.js";import{S as Vt,i as St,e as i,s as a,c as d,h as Nt,a as o,d as l,b as s,f as Bt,g as p,j as m,k as It,l as Rt,m as n,n as c,t as M,o as h,p as u}from"../chunks/index.4ee0a2d0.js";import{T as vt}from"../chunks/Tip.e2132029.js";import{C as Yt,H as me,E as Ft}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.2422a08e.js";import{C as f}from"../chunks/CodeBlock.27357de2.js";function _t(de){let r,g='<a href="https://github.com/aws/sagemaker-python-sdk" rel="nofollow">SageMaker Python SDK v3 has been recently released</a>, so unless specified otherwise, all the documentation and tutorials are still using the <a href="https://github.com/aws/sagemaker-python-sdk/tree/master-v2" rel="nofollow">SageMaker Python SDK v2</a>. We are actively working on updating all the tutorials and examples, but in the meantime make sure to install the SageMaker SDK as <code>pip install &quot;sagemaker&lt;3.0.0&quot;</code>.';return{c(){r=i("p"),r.innerHTML=g},l(y){r=o(y,"P",{"data-svelte-h":!0}),m(r)!=="svelte-1rh974s"&&(r.innerHTML=g)},m(y,b){n(y,r,b)},p:Ct,d(y){y&&l(r)}}}function Xt(de){let r,g='📍 Find the complete example on GitHub <a href="https://github.com/huggingface/hub-docs/tree/main/notebooks/sagemaker-sdk/deploy-embedding-models/sagemaker-notebook.ipynb" rel="nofollow">here</a>!';return{c(){r=i("p"),r.innerHTML=g},l(y){r=o(y,"P",{"data-svelte-h":!0}),m(r)!=="svelte-17nt2nn"&&(r.innerHTML=g)},m(y,b){n(y,r,b)},p:Ct,d(y){y&&l(r)}}}function xt(de){let r,g,y,b,U,ce,T,Me,j,at='This is an example on how to deploy the open Embedding Models, like <a href="https://huggingface.co/Snowflake/snowflake-arctic-embed-l" rel="nofollow">Snowflake/snowflake-arctic-embed-l</a>, <a href="https://huggingface.co/BAAI/bge-large-en-v1.5" rel="nofollow">BAAI/bge-large-en-v1.5</a> or <a href="https://huggingface.co/sentence-transformers/all-MiniLM-L6-v2" rel="nofollow">sentence-transformers/all-MiniLM-L6-v2</a> to Amazon SageMaker for inference using the new Hugging Face Embedding Inference Container. We will deploy the <a href="https://huggingface.co/Snowflake/snowflake-arctic-embed-m" rel="nofollow">Snowflake/snowflake-arctic-embed-m</a> one of the best open Embedding Models for retrieval and ranking on the <a href="https://huggingface.co/spaces/mteb/leaderboard" rel="nofollow">MTEB Leaderboard</a>.',he,Z,st="The example covers:",ue,k,it='<li><a href="#1-setup-development-environment">Setup development environment</a></li> <li><a href="#2-retrieve-the-new-hugging-face-embedding-container">Retrieve the new Hugging Face Embedding Container</a></li> <li><a href="#3-deploy-snowflake-arctic-to-amazon-sagemaker">Deploy Snowflake Arctic to Amazon SageMaker</a></li> <li><a href="#4-run-and-evaluate-inference-performance">Run and evaluate Inference performance</a></li> <li><a href="#5-delete-model-and-endpoint">Delete model and endpoint</a></li>',ye,W,ge,G,ot='The Hugging Face Embedding DLC is a new purpose-built Inference Container to easily deploy Embedding Models in a secure and managed environment. The DLC is powered by <a href="https://github.com/huggingface/text-embeddings-inference" rel="nofollow">Text Embedding Inference (TEI)</a> a blazing fast and memory efficient solution for deploying and serving Embedding Models. TEI enables high-performance extraction for the most popular models, including FlagEmbedding, Ember, GTE and E5. TEI implements many features such as:',fe,B,rt="<li>No model graph compilation step</li> <li>Small docker images and fast boot times</li> <li>Token based dynamic batching</li> <li>Optimized transformers code for inference using Flash Attention, Candle and cuBLASLt</li> <li>Safetensors weight loading</li> <li>Production ready (distributed tracing with Open Telemetry, Prometheus metrics)</li>",be,I,mt="TEI supports the following model architectures",we,v,dt='<li>BERT/CamemBERT, e.g. <a href="https://huggingface.co/BAAI/bge-large-en-v1.5" rel="nofollow">BAAI/bge-large-en-v1.5</a> or <a href="https://huggingface.co/Snowflake/snowflake-arctic-embed-m" rel="nofollow">Snowflake/snowflake-arctic-embed-m</a></li> <li>RoBERTa, <a href="https://huggingface.co/sentence-transformers/all-roberta-large-v1" rel="nofollow">sentence-transformers/all-roberta-large-v1</a></li> <li>XLM-RoBERTa, e.g. <a href="https://huggingface.co/sentence-transformers/paraphrase-xlm-r-multilingual-v1" rel="nofollow">sentence-transformers/paraphrase-xlm-r-multilingual-v1</a></li> <li>NomicBert, e.g. <a href="https://huggingface.co/jinaai/jina-embeddings-v2-base-en" rel="nofollow">jinaai/jina-embeddings-v2-base-en</a></li> <li>JinaBert, e.g. <a href="https://huggingface.co/nomic-ai/nomic-embed-text-v1.5" rel="nofollow">nomic-ai/nomic-embed-text-v1.5</a></li>',Je,C,pt="Lets get started!",Ue,$,Te,H,ct="We are going to use the <code>sagemaker</code> python SDK to deploy Snowflake Arctic to Amazon SageMaker. We need to make sure to have an AWS account configured and the <code>sagemaker</code> python SDK installed.",je,V,Ze,w,ke,S,Mt='If you are going to use Sagemaker in a local environment. You need access to an IAM Role with the required permissions for Sagemaker. You can find <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html" rel="nofollow">here</a> more about it.',We,N,Ge,R,Be,Y,ht="Compared to deploying regular Hugging Face models we first need to retrieve the container uri and provide it to our <code>HuggingFaceModel</code> model class with a <code>image_uri</code> pointing to the image. To retrieve the new Hugging Face Embedding Container in Amazon SageMaker, we can use the <code>get_huggingface_llm_image_uri</code> method provided by the <code>sagemaker</code> SDK. This method allows us to retrieve the URI for the desired Hugging Face Embedding Container. Important to note is that TEI has 2 different versions for cpu and gpu, so we create a helper function to retrieve the correct image uri based on the instance type.",Ie,F,ve,_,Ce,X,ut='To deploy  <a href="https://huggingface.co/Snowflake/snowflake-arctic-embed-m" rel="nofollow">Snowflake/snowflake-arctic-embed-m</a> to Amazon SageMaker we create a <code>HuggingFaceModel</code> model class and define our endpoint configuration including the <code>HF_MODEL_ID</code>, <code>instance_type</code> etc. We will use a <code>c6i.2xlarge</code> instance type, which has 4 Intel Ice-Lake vCPUs, 8GB of memory and costs around $0.204 per hour.',$e,x,He,z,yt="After we have created the <code>HuggingFaceModel</code> we can deploy it to Amazon SageMaker using the <code>deploy</code> method. We will deploy the model with the <code>ml.c6i.2xlarge</code> instance type.",Ve,E,Se,Q,gt="SageMaker will now create our endpoint and deploy the model to it. This can takes  ~5 minutes.",Ne,A,Re,L,ft="After our endpoint is deployed we can run inference on it. We will use the <code>predict</code> method from the <code>predictor</code> to run inference on our endpoint.",Ye,q,Fe,P,bt="Awesome we can now generate embeddings with our model, Lets test the performance of our model.",_e,D,wt="We will send 3,900 requests to our endpoint use threading with 10 concurrent threads. We will measure the average latency and throughput of our endpoint. We are going to sent an input of 256 tokens to have a total of ~1 Million tokens. We decided to use 256 tokens as input length to find the balance between shorter and longer inputs.",Xe,K,Jt="Note: When running the load test, the requests are sent from europe and the endpoint is deployed in us-east-1. This adds a network overhead to it.",xe,O,ze,ee,Ut="Sending 3,900 requests or embedding 1 million tokens took around 841 seconds. This means we can run around ~5 requests per second. But keep in mind that includes the network latency from europe to us-east-1. When we inspect the latency of the endpoint through cloudwatch we can see that latency for our Embeddings model is 2s at 10 concurrent requests. This is very impressive for a small & old CPU instance, which cost ~150$ per month. You can deploy the model to a GPU instance to get faster inference times.",Ee,te,Tt="<em>Note: We ran the same test on a <code>ml.g5.xlarge</code> with 1x NVIDIA A10G GPU. Embedding 1 million tokens took around 30 seconds. This means we can run around ~130 requests per second. The latency for the endpoint is 4ms at 10 concurrent requests. The <code>ml.g5.xlarge</code> costs around $1.408 per hour on Amazon SageMaker.</em>",Qe,le,jt="GPU instance are much faster than CPU instances, but they are also more expensive. If you want to bulk process embeddings, you can use a GPU instance. If you want to run a small endpoint with low costs, you can use a CPU instance. We plan to work on a dedicated benchmark for the Hugging Face Embedding DLC in the future.",Ae,ne,Le,ae,Zt='<img src="https://raw.githubusercontent.com/huggingface/hub-docs/refs/heads/main/docs/sagemaker/notebooks/sagemaker-sdk/deploy-embedding-models/assets/cw.png" alt="cw"/>',qe,se,Pe,ie,kt="To clean up, we can delete the model and endpoint",De,oe,Ke,Oe,et,J,tt,re,lt,pe,nt;return U=new Yt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),T=new me({props:{title:"How to deploy Embedding Models to Amazon SageMaker using new Hugging Face Embedding DLC",local:"how-to-deploy-embedding-models-to-amazon-sagemaker-using-new-hugging-face-embedding-dlc",headingTag:"h1"}}),W=new me({props:{title:"What is Hugging Face Embedding DLC?",local:"what-is-hugging-face-embedding-dlc",headingTag:"h2"}}),$=new me({props:{title:"1. Setup development environment",local:"1-setup-development-environment",headingTag:"h2"}}),V=new f({props:{code:"IXBpcCUyMGluc3RhbGwlMjAlMjJzYWdlbWFrZXIlM0MzLjAuMCUyMiUyMC0tdXBncmFkZSUyMC0tcXVpZXQ=",highlighted:'!pip install <span class="hljs-string">&quot;sagemaker&lt;3.0.0&quot;</span> --upgrade --quiet',wrap:!1}}),w=new vt({props:{warning:!0,$$slots:{default:[_t]},$$scope:{ctx:de}}}),N=new f({props:{code:"aW1wb3J0JTIwc2FnZW1ha2VyJTBBaW1wb3J0JTIwYm90bzMlMEFzZXNzJTIwJTNEJTIwc2FnZW1ha2VyLlNlc3Npb24oKSUwQSUyMyUyMHNhZ2VtYWtlciUyMHNlc3Npb24lMjBidWNrZXQlMjAtJTNFJTIwdXNlZCUyMGZvciUyMHVwbG9hZGluZyUyMGRhdGElMkMlMjBtb2RlbHMlMjBhbmQlMjBsb2dzJTBBJTIzJTIwc2FnZW1ha2VyJTIwd2lsbCUyMGF1dG9tYXRpY2FsbHklMjBjcmVhdGUlMjB0aGlzJTIwYnVja2V0JTIwaWYlMjBpdCUyMG5vdCUyMGV4aXN0cyUwQXNhZ2VtYWtlcl9zZXNzaW9uX2J1Y2tldCUzRE5vbmUlMEFpZiUyMHNhZ2VtYWtlcl9zZXNzaW9uX2J1Y2tldCUyMGlzJTIwTm9uZSUyMGFuZCUyMHNlc3MlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBzZXQlMjB0byUyMGRlZmF1bHQlMjBidWNrZXQlMjBpZiUyMGElMjBidWNrZXQlMjBuYW1lJTIwaXMlMjBub3QlMjBnaXZlbiUwQSUyMCUyMCUyMCUyMHNhZ2VtYWtlcl9zZXNzaW9uX2J1Y2tldCUyMCUzRCUyMHNlc3MuZGVmYXVsdF9idWNrZXQoKSUwQSUwQXRyeSUzQSUwQSUyMCUyMCUyMCUyMHJvbGUlMjAlM0QlMjBzYWdlbWFrZXIuZ2V0X2V4ZWN1dGlvbl9yb2xlKCklMEFleGNlcHQlMjBWYWx1ZUVycm9yJTNBJTBBJTIwJTIwJTIwJTIwaWFtJTIwJTNEJTIwYm90bzMuY2xpZW50KCdpYW0nKSUwQSUyMCUyMCUyMCUyMHJvbGUlMjAlM0QlMjBpYW0uZ2V0X3JvbGUoUm9sZU5hbWUlM0Qnc2FnZW1ha2VyX2V4ZWN1dGlvbl9yb2xlJyklNUInUm9sZSclNUQlNUInQXJuJyU1RCUwQSUwQXNlc3MlMjAlM0QlMjBzYWdlbWFrZXIuU2Vzc2lvbihkZWZhdWx0X2J1Y2tldCUzRHNhZ2VtYWtlcl9zZXNzaW9uX2J1Y2tldCklMEElMEFwcmludChmJTIyc2FnZW1ha2VyJTIwcm9sZSUyMGFybiUzQSUyMCU3QnJvbGUlN0QlMjIpJTBBcHJpbnQoZiUyMnNhZ2VtYWtlciUyMHNlc3Npb24lMjByZWdpb24lM0ElMjAlN0JzZXNzLmJvdG9fcmVnaW9uX25hbWUlN0QlMjIp",highlighted:`<span class="hljs-keyword">import</span> sagemaker
<span class="hljs-keyword">import</span> boto3
sess = sagemaker.Session()
<span class="hljs-comment"># sagemaker session bucket -&gt; used for uploading data, models and logs</span>
<span class="hljs-comment"># sagemaker will automatically create this bucket if it not exists</span>
sagemaker_session_bucket=<span class="hljs-literal">None</span>
<span class="hljs-keyword">if</span> sagemaker_session_bucket <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">and</span> sess <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
    <span class="hljs-comment"># set to default bucket if a bucket name is not given</span>
    sagemaker_session_bucket = sess.default_bucket()

<span class="hljs-keyword">try</span>:
    role = sagemaker.get_execution_role()
<span class="hljs-keyword">except</span> ValueError:
    iam = boto3.client(<span class="hljs-string">&#x27;iam&#x27;</span>)
    role = iam.get_role(RoleName=<span class="hljs-string">&#x27;sagemaker_execution_role&#x27;</span>)[<span class="hljs-string">&#x27;Role&#x27;</span>][<span class="hljs-string">&#x27;Arn&#x27;</span>]

sess = sagemaker.Session(default_bucket=sagemaker_session_bucket)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;sagemaker role arn: <span class="hljs-subst">{role}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;sagemaker session region: <span class="hljs-subst">{sess.boto_region_name}</span>&quot;</span>)`,wrap:!1}}),R=new me({props:{title:"2. Retrieve the new Hugging Face Embedding Container",local:"2-retrieve-the-new-hugging-face-embedding-container",headingTag:"h2"}}),F=new f({props:{code:"ZnJvbSUyMHNhZ2VtYWtlci5odWdnaW5nZmFjZSUyMGltcG9ydCUyMGdldF9odWdnaW5nZmFjZV9sbG1faW1hZ2VfdXJpJTBBJTBBJTIzJTIwcmV0cmlldmUlMjB0aGUlMjBpbWFnZSUyMHVyaSUyMGJhc2VkJTIwb24lMjBpbnN0YW5jZSUyMHR5cGUlMEFkZWYlMjBnZXRfaW1hZ2VfdXJpKGluc3RhbmNlX3R5cGUpJTNBJTBBJTIwJTIwa2V5JTIwJTNEJTIwJTIyaHVnZ2luZ2ZhY2UtdGVpJTIyJTIwaWYlMjBpbnN0YW5jZV90eXBlLnN0YXJ0c3dpdGgoJTIybWwuZyUyMiklMjBvciUyMGluc3RhbmNlX3R5cGUuc3RhcnRzd2l0aCglMjJtbC5wJTIyKSUyMGVsc2UlMjAlMjJodWdnaW5nZmFjZS10ZWktY3B1JTIyJTBBJTIwJTIwcmV0dXJuJTIwZ2V0X2h1Z2dpbmdmYWNlX2xsbV9pbWFnZV91cmkoa2V5JTJDJTIwdmVyc2lvbiUzRCUyMjEuNC4wJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface <span class="hljs-keyword">import</span> get_huggingface_llm_image_uri

<span class="hljs-comment"># retrieve the image uri based on instance type</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_image_uri</span>(<span class="hljs-params">instance_type</span>):
  key = <span class="hljs-string">&quot;huggingface-tei&quot;</span> <span class="hljs-keyword">if</span> instance_type.startswith(<span class="hljs-string">&quot;ml.g&quot;</span>) <span class="hljs-keyword">or</span> instance_type.startswith(<span class="hljs-string">&quot;ml.p&quot;</span>) <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;huggingface-tei-cpu&quot;</span>
  <span class="hljs-keyword">return</span> get_huggingface_llm_image_uri(key, version=<span class="hljs-string">&quot;1.4.0&quot;</span>)`,wrap:!1}}),_=new me({props:{title:"3. Deploy Snowflake Arctic to Amazon SageMaker",local:"3-deploy-snowflake-arctic-to-amazon-sagemaker",headingTag:"h2"}}),x=new f({props:{code:"aW1wb3J0JTIwanNvbiUwQWZyb20lMjBzYWdlbWFrZXIuaHVnZ2luZ2ZhY2UlMjBpbXBvcnQlMjBIdWdnaW5nRmFjZU1vZGVsJTBBJTBBJTIzJTIwc2FnZW1ha2VyJTIwY29uZmlnJTBBaW5zdGFuY2VfdHlwZSUyMCUzRCUyMCUyMm1sLmc1LnhsYXJnZSUyMiUwQSUwQSUyMyUyMERlZmluZSUyME1vZGVsJTIwYW5kJTIwRW5kcG9pbnQlMjBjb25maWd1cmF0aW9uJTIwcGFyYW1ldGVyJTBBY29uZmlnJTIwJTNEJTIwJTdCJTBBJTIwJTIwJ0hGX01PREVMX0lEJyUzQSUyMCUyMlNub3dmbGFrZSUyRnNub3dmbGFrZS1hcmN0aWMtZW1iZWQtbSUyMiUyQyUyMCUyMyUyMG1vZGVsX2lkJTIwZnJvbSUyMGhmLmNvJTJGbW9kZWxzJTBBJTdEJTBBJTBBJTIzJTIwY3JlYXRlJTIwSHVnZ2luZ0ZhY2VNb2RlbCUyMHdpdGglMjB0aGUlMjBpbWFnZSUyMHVyaSUwQWVtYl9tb2RlbCUyMCUzRCUyMEh1Z2dpbmdGYWNlTW9kZWwoJTBBJTIwJTIwcm9sZSUzRHJvbGUlMkMlMEElMjAlMjBpbWFnZV91cmklM0RnZXRfaW1hZ2VfdXJpKGluc3RhbmNlX3R5cGUpJTJDJTBBJTIwJTIwZW52JTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> json
<span class="hljs-keyword">from</span> sagemaker.huggingface <span class="hljs-keyword">import</span> HuggingFaceModel

<span class="hljs-comment"># sagemaker config</span>
instance_type = <span class="hljs-string">&quot;ml.g5.xlarge&quot;</span>

<span class="hljs-comment"># Define Model and Endpoint configuration parameter</span>
config = {
  <span class="hljs-string">&#x27;HF_MODEL_ID&#x27;</span>: <span class="hljs-string">&quot;Snowflake/snowflake-arctic-embed-m&quot;</span>, <span class="hljs-comment"># model_id from hf.co/models</span>
}

<span class="hljs-comment"># create HuggingFaceModel with the image uri</span>
emb_model = HuggingFaceModel(
  role=role,
  image_uri=get_image_uri(instance_type),
  env=config
)`,wrap:!1}}),E=new f({props:{code:"JTIzJTIwRGVwbG95JTIwbW9kZWwlMjB0byUyMGFuJTIwZW5kcG9pbnQlMEElMjMlMjBodHRwcyUzQSUyRiUyRnNhZ2VtYWtlci5yZWFkdGhlZG9jcy5pbyUyRmVuJTJGc3RhYmxlJTJGYXBpJTJGaW5mZXJlbmNlJTJGbW9kZWwuaHRtbCUyM3NhZ2VtYWtlci5tb2RlbC5Nb2RlbC5kZXBsb3klMEFlbWIlMjAlM0QlMjBlbWJfbW9kZWwuZGVwbG95KCUwQSUyMCUyMGluaXRpYWxfaW5zdGFuY2VfY291bnQlM0QxJTJDJTBBJTIwJTIwaW5zdGFuY2VfdHlwZSUzRGluc3RhbmNlX3R5cGUlMkMlMEEp",highlighted:`<span class="hljs-comment"># Deploy model to an endpoint</span>
<span class="hljs-comment"># https://sagemaker.readthedocs.io/en/stable/api/inference/model.html#sagemaker.model.Model.deploy</span>
emb = emb_model.deploy(
  initial_instance_count=<span class="hljs-number">1</span>,
  instance_type=instance_type,
)`,wrap:!1}}),A=new me({props:{title:"4. Run and evaluate Inference performance",local:"4-run-and-evaluate-inference-performance",headingTag:"h2"}}),q=new f({props:{code:"ZGF0YSUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMmlucHV0cyUyMiUzQSUyMCUyMnRoZSUyMG1lc21lcml6aW5nJTIwcGVyZm9ybWFuY2VzJTIwb2YlMjB0aGUlMjBsZWFkcyUyMGtlZXAlMjB0aGUlMjBmaWxtJTIwZ3JvdW5kZWQlMjBhbmQlMjBrZWVwJTIwdGhlJTIwYXVkaWVuY2UlMjByaXZldGVkJTIwLiUyMiUyQyUwQSU3RCUwQSUyMCUwQXJlcyUyMCUzRCUyMGVtYi5wcmVkaWN0KGRhdGElM0RkYXRhKSUwQSUyMCUwQSUyMCUwQSUyMyUyMHByaW50JTIwc29tZSUyMHJlc3VsdHMlMEFwcmludChmJTIybGVuZ3RoJTIwb2YlMjBlbWJlZGRpbmdzJTNBJTIwJTdCbGVuKHJlcyU1QjAlNUQpJTdEJTIyKSUwQXByaW50KGYlMjJmaXJzdCUyMDEwJTIwZWxlbWVudHMlMjBvZiUyMGVtYmVkZGluZ3MlM0ElMjAlN0JyZXMlNUIwJTVEJTVCJTNBMTAlNUQlN0QlMjIp",highlighted:`data = {
  <span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;the mesmerizing performances of the leads keep the film grounded and keep the audience riveted .&quot;</span>,
}
 
res = emb.predict(data=data)
 
 
<span class="hljs-comment"># print some results</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;length of embeddings: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(res[<span class="hljs-number">0</span>])}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;first 10 elements of embeddings: <span class="hljs-subst">{res[<span class="hljs-number">0</span>][:<span class="hljs-number">10</span>]}</span>&quot;</span>)`,wrap:!1}}),O=new f({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> threading
<span class="hljs-keyword">import</span> time
number_of_threads = <span class="hljs-number">10</span>
number_of_requests = <span class="hljs-built_in">int</span>(<span class="hljs-number">3900</span> // number_of_threads)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;number of threads: <span class="hljs-subst">{number_of_threads}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;number of requests per thread: <span class="hljs-subst">{number_of_requests}</span>&quot;</span>)
 
<span class="hljs-keyword">def</span> <span class="hljs-title function_">send_rquests</span>():
    <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(number_of_requests):
        <span class="hljs-comment"># input counted at https://huggingface.co/spaces/Xenova/the-tokenizer-playground for 100 tokens</span>
        emb.predict(data={<span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;Hugging Face is a company and a popular platform in the field of natural language processing (NLP) and machine learning. They are known for their contributions to the development of state-of-the-art models for various NLP tasks and for providing a platform that facilitates the sharing and usage of pre-trained models. One of the key offerings from Hugging Face is the Transformers library, which is an open-source library for working with a variety of pre-trained transformer models, including those for text generation, translation, summarization, question answering, and more. The library is widely used in the research and development of NLP applications and is supported by a large and active community. Hugging Face also provides a model hub where users can discover, share, and download pre-trained models. Additionally, they offer tools and frameworks to make it easier for developers to integrate and use these models in their own projects. The company has played a significant role in advancing the field of NLP and making cutting-edge models more accessible to the broader community. Hugging Face also provides a model hub where users can discover, share, and download pre-trained models. Additionally, they offer tools and frameworks to make it easier for developers and ma&quot;</span>})
 
<span class="hljs-comment"># Create multiple threads</span>
threads = [threading.Thread(target=send_rquests) <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(number_of_threads) ]
<span class="hljs-comment"># start all threads</span>
start = time.time()
[t.start() <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> threads]
<span class="hljs-comment"># wait for all threads to finish</span>
[t.join() <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> threads]
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;total time: <span class="hljs-subst">{<span class="hljs-built_in">round</span>(time.time() - start)}</span> seconds&quot;</span>)`,wrap:!1}}),ne=new f({props:{code:"cHJpbnQoZiUyMmh0dHBzJTNBJTJGJTJGY29uc29sZS5hd3MuYW1hem9uLmNvbSUyRmNsb3Vkd2F0Y2glMkZob21lJTNGcmVnaW9uJTNEJTdCc2Vzcy5ib3RvX3JlZ2lvbl9uYW1lJTdEJTIzbWV0cmljc1YyJTNBZ3JhcGglM0R+KG1ldHJpY3N+KH4ofidBV1MqMmZTYWdlTWFrZXJ+J01vZGVsTGF0ZW5jeX4nRW5kcG9pbnROYW1lficlN0JlbWIuZW5kcG9pbnRfbmFtZSU3RH4nVmFyaWFudE5hbWV+J0FsbFRyYWZmaWMpKX52aWV3fid0aW1lU2VyaWVzfnN0YWNrZWR+ZmFsc2V+cmVnaW9uficlN0JzZXNzLmJvdG9fcmVnaW9uX25hbWUlN0R+c3RhcnR+Jy1QVDVNfmVuZH4nUDBEfnN0YXR+J0F2ZXJhZ2V+cGVyaW9kfjMwKSUzQnF1ZXJ5JTNEficqN2JBV1MqMmZTYWdlTWFrZXIqMmNFbmRwb2ludE5hbWUqMmNWYXJpYW50TmFtZSo3ZCoyMCU3QmVtYi5lbmRwb2ludF9uYW1lJTdEJTIyKQ==",highlighted:'<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;https://console.aws.amazon.com/cloudwatch/home?region=<span class="hljs-subst">{sess.boto_region_name}</span>#metricsV2:graph=~(metrics~(~(~&#x27;AWS*2fSageMaker~&#x27;ModelLatency~&#x27;EndpointName~&#x27;<span class="hljs-subst">{emb.endpoint_name}</span>~&#x27;VariantName~&#x27;AllTraffic))~view~&#x27;timeSeries~stacked~false~region~&#x27;<span class="hljs-subst">{sess.boto_region_name}</span>~start~&#x27;-PT5M~end~&#x27;P0D~stat~&#x27;Average~period~30);query=~&#x27;*7bAWS*2fSageMaker*2cEndpointName*2cVariantName*7d*20<span class="hljs-subst">{emb.endpoint_name}</span>&quot;</span>)',wrap:!1}}),se=new me({props:{title:"5. Delete model and endpoint",local:"5-delete-model-and-endpoint",headingTag:"h2"}}),oe=new f({props:{code:"ZW1iLmRlbGV0ZV9tb2RlbCgpJTBBZW1iLmRlbGV0ZV9lbmRwb2ludCgp",highlighted:`emb.delete_model()
emb.delete_endpoint()`,wrap:!1}}),J=new vt({props:{$$slots:{default:[Xt]},$$scope:{ctx:de}}}),re=new Ft({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/sagemaker/source/examples/sagemaker-sdk-deploy-embedding-models.mdx"}}),{c(){r=i("meta"),g=a(),y=i("p"),b=a(),d(U.$$.fragment),ce=a(),d(T.$$.fragment),Me=a(),j=i("p"),j.innerHTML=at,he=a(),Z=i("p"),Z.textContent=st,ue=a(),k=i("ol"),k.innerHTML=it,ye=a(),d(W.$$.fragment),ge=a(),G=i("p"),G.innerHTML=ot,fe=a(),B=i("ul"),B.innerHTML=rt,be=a(),I=i("p"),I.textContent=mt,we=a(),v=i("ul"),v.innerHTML=dt,Je=a(),C=i("p"),C.textContent=pt,Ue=a(),d($.$$.fragment),Te=a(),H=i("p"),H.innerHTML=ct,je=a(),d(V.$$.fragment),Ze=a(),d(w.$$.fragment),ke=a(),S=i("p"),S.innerHTML=Mt,We=a(),d(N.$$.fragment),Ge=a(),d(R.$$.fragment),Be=a(),Y=i("p"),Y.innerHTML=ht,Ie=a(),d(F.$$.fragment),ve=a(),d(_.$$.fragment),Ce=a(),X=i("p"),X.innerHTML=ut,$e=a(),d(x.$$.fragment),He=a(),z=i("p"),z.innerHTML=yt,Ve=a(),d(E.$$.fragment),Se=a(),Q=i("p"),Q.textContent=gt,Ne=a(),d(A.$$.fragment),Re=a(),L=i("p"),L.innerHTML=ft,Ye=a(),d(q.$$.fragment),Fe=a(),P=i("p"),P.textContent=bt,_e=a(),D=i("p"),D.textContent=wt,Xe=a(),K=i("p"),K.textContent=Jt,xe=a(),d(O.$$.fragment),ze=a(),ee=i("p"),ee.textContent=Ut,Ee=a(),te=i("p"),te.innerHTML=Tt,Qe=a(),le=i("p"),le.textContent=jt,Ae=a(),d(ne.$$.fragment),Le=a(),ae=i("p"),ae.innerHTML=Zt,qe=a(),d(se.$$.fragment),Pe=a(),ie=i("p"),ie.textContent=kt,De=a(),d(oe.$$.fragment),Ke=a(),Oe=i("hr"),et=a(),d(J.$$.fragment),tt=a(),d(re.$$.fragment),lt=a(),pe=i("p"),this.h()},l(e){const t=Nt("svelte-u9bgzb",document.head);r=o(t,"META",{name:!0,content:!0}),t.forEach(l),g=s(e),y=o(e,"P",{}),Bt(y).forEach(l),b=s(e),p(U.$$.fragment,e),ce=s(e),p(T.$$.fragment,e),Me=s(e),j=o(e,"P",{"data-svelte-h":!0}),m(j)!=="svelte-107ao9g"&&(j.innerHTML=at),he=s(e),Z=o(e,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-1fk91jb"&&(Z.textContent=st),ue=s(e),k=o(e,"OL",{"data-svelte-h":!0}),m(k)!=="svelte-t9j2qn"&&(k.innerHTML=it),ye=s(e),p(W.$$.fragment,e),ge=s(e),G=o(e,"P",{"data-svelte-h":!0}),m(G)!=="svelte-1g12ipz"&&(G.innerHTML=ot),fe=s(e),B=o(e,"UL",{"data-svelte-h":!0}),m(B)!=="svelte-13nwd7v"&&(B.innerHTML=rt),be=s(e),I=o(e,"P",{"data-svelte-h":!0}),m(I)!=="svelte-dbg7bd"&&(I.textContent=mt),we=s(e),v=o(e,"UL",{"data-svelte-h":!0}),m(v)!=="svelte-1qk5wei"&&(v.innerHTML=dt),Je=s(e),C=o(e,"P",{"data-svelte-h":!0}),m(C)!=="svelte-6zk712"&&(C.textContent=pt),Ue=s(e),p($.$$.fragment,e),Te=s(e),H=o(e,"P",{"data-svelte-h":!0}),m(H)!=="svelte-ivso52"&&(H.innerHTML=ct),je=s(e),p(V.$$.fragment,e),Ze=s(e),p(w.$$.fragment,e),ke=s(e),S=o(e,"P",{"data-svelte-h":!0}),m(S)!=="svelte-s0u97w"&&(S.innerHTML=Mt),We=s(e),p(N.$$.fragment,e),Ge=s(e),p(R.$$.fragment,e),Be=s(e),Y=o(e,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-aifr08"&&(Y.innerHTML=ht),Ie=s(e),p(F.$$.fragment,e),ve=s(e),p(_.$$.fragment,e),Ce=s(e),X=o(e,"P",{"data-svelte-h":!0}),m(X)!=="svelte-1nrpwhp"&&(X.innerHTML=ut),$e=s(e),p(x.$$.fragment,e),He=s(e),z=o(e,"P",{"data-svelte-h":!0}),m(z)!=="svelte-rq9vzg"&&(z.innerHTML=yt),Ve=s(e),p(E.$$.fragment,e),Se=s(e),Q=o(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-fhd04v"&&(Q.textContent=gt),Ne=s(e),p(A.$$.fragment,e),Re=s(e),L=o(e,"P",{"data-svelte-h":!0}),m(L)!=="svelte-u88v21"&&(L.innerHTML=ft),Ye=s(e),p(q.$$.fragment,e),Fe=s(e),P=o(e,"P",{"data-svelte-h":!0}),m(P)!=="svelte-mxy82q"&&(P.textContent=bt),_e=s(e),D=o(e,"P",{"data-svelte-h":!0}),m(D)!=="svelte-mcpcg9"&&(D.textContent=wt),Xe=s(e),K=o(e,"P",{"data-svelte-h":!0}),m(K)!=="svelte-4wtzg0"&&(K.textContent=Jt),xe=s(e),p(O.$$.fragment,e),ze=s(e),ee=o(e,"P",{"data-svelte-h":!0}),m(ee)!=="svelte-1fbhrxg"&&(ee.textContent=Ut),Ee=s(e),te=o(e,"P",{"data-svelte-h":!0}),m(te)!=="svelte-1gr1muv"&&(te.innerHTML=Tt),Qe=s(e),le=o(e,"P",{"data-svelte-h":!0}),m(le)!=="svelte-1bwshbf"&&(le.textContent=jt),Ae=s(e),p(ne.$$.fragment,e),Le=s(e),ae=o(e,"P",{"data-svelte-h":!0}),m(ae)!=="svelte-kooosy"&&(ae.innerHTML=Zt),qe=s(e),p(se.$$.fragment,e),Pe=s(e),ie=o(e,"P",{"data-svelte-h":!0}),m(ie)!=="svelte-1y233zi"&&(ie.textContent=kt),De=s(e),p(oe.$$.fragment,e),Ke=s(e),Oe=o(e,"HR",{}),et=s(e),p(J.$$.fragment,e),tt=s(e),p(re.$$.fragment,e),lt=s(e),pe=o(e,"P",{}),Bt(pe).forEach(l),this.h()},h(){It(r,"name","hf:doc:metadata"),It(r,"content",zt)},m(e,t){Rt(document.head,r),n(e,g,t),n(e,y,t),n(e,b,t),c(U,e,t),n(e,ce,t),c(T,e,t),n(e,Me,t),n(e,j,t),n(e,he,t),n(e,Z,t),n(e,ue,t),n(e,k,t),n(e,ye,t),c(W,e,t),n(e,ge,t),n(e,G,t),n(e,fe,t),n(e,B,t),n(e,be,t),n(e,I,t),n(e,we,t),n(e,v,t),n(e,Je,t),n(e,C,t),n(e,Ue,t),c($,e,t),n(e,Te,t),n(e,H,t),n(e,je,t),c(V,e,t),n(e,Ze,t),c(w,e,t),n(e,ke,t),n(e,S,t),n(e,We,t),c(N,e,t),n(e,Ge,t),c(R,e,t),n(e,Be,t),n(e,Y,t),n(e,Ie,t),c(F,e,t),n(e,ve,t),c(_,e,t),n(e,Ce,t),n(e,X,t),n(e,$e,t),c(x,e,t),n(e,He,t),n(e,z,t),n(e,Ve,t),c(E,e,t),n(e,Se,t),n(e,Q,t),n(e,Ne,t),c(A,e,t),n(e,Re,t),n(e,L,t),n(e,Ye,t),c(q,e,t),n(e,Fe,t),n(e,P,t),n(e,_e,t),n(e,D,t),n(e,Xe,t),n(e,K,t),n(e,xe,t),c(O,e,t),n(e,ze,t),n(e,ee,t),n(e,Ee,t),n(e,te,t),n(e,Qe,t),n(e,le,t),n(e,Ae,t),c(ne,e,t),n(e,Le,t),n(e,ae,t),n(e,qe,t),c(se,e,t),n(e,Pe,t),n(e,ie,t),n(e,De,t),c(oe,e,t),n(e,Ke,t),n(e,Oe,t),n(e,et,t),c(J,e,t),n(e,tt,t),c(re,e,t),n(e,lt,t),n(e,pe,t),nt=!0},p(e,[t]){const Wt={};t&2&&(Wt.$$scope={dirty:t,ctx:e}),w.$set(Wt);const Gt={};t&2&&(Gt.$$scope={dirty:t,ctx:e}),J.$set(Gt)},i(e){nt||(M(U.$$.fragment,e),M(T.$$.fragment,e),M(W.$$.fragment,e),M($.$$.fragment,e),M(V.$$.fragment,e),M(w.$$.fragment,e),M(N.$$.fragment,e),M(R.$$.fragment,e),M(F.$$.fragment,e),M(_.$$.fragment,e),M(x.$$.fragment,e),M(E.$$.fragment,e),M(A.$$.fragment,e),M(q.$$.fragment,e),M(O.$$.fragment,e),M(ne.$$.fragment,e),M(se.$$.fragment,e),M(oe.$$.fragment,e),M(J.$$.fragment,e),M(re.$$.fragment,e),nt=!0)},o(e){h(U.$$.fragment,e),h(T.$$.fragment,e),h(W.$$.fragment,e),h($.$$.fragment,e),h(V.$$.fragment,e),h(w.$$.fragment,e),h(N.$$.fragment,e),h(R.$$.fragment,e),h(F.$$.fragment,e),h(_.$$.fragment,e),h(x.$$.fragment,e),h(E.$$.fragment,e),h(A.$$.fragment,e),h(q.$$.fragment,e),h(O.$$.fragment,e),h(ne.$$.fragment,e),h(se.$$.fragment,e),h(oe.$$.fragment,e),h(J.$$.fragment,e),h(re.$$.fragment,e),nt=!1},d(e){e&&(l(g),l(y),l(b),l(ce),l(Me),l(j),l(he),l(Z),l(ue),l(k),l(ye),l(ge),l(G),l(fe),l(B),l(be),l(I),l(we),l(v),l(Je),l(C),l(Ue),l(Te),l(H),l(je),l(Ze),l(ke),l(S),l(We),l(Ge),l(Be),l(Y),l(Ie),l(ve),l(Ce),l(X),l($e),l(He),l(z),l(Ve),l(Se),l(Q),l(Ne),l(Re),l(L),l(Ye),l(Fe),l(P),l(_e),l(D),l(Xe),l(K),l(xe),l(ze),l(ee),l(Ee),l(te),l(Qe),l(le),l(Ae),l(Le),l(ae),l(qe),l(Pe),l(ie),l(De),l(Ke),l(Oe),l(et),l(tt),l(lt),l(pe)),l(r),u(U,e),u(T,e),u(W,e),u($,e),u(V,e),u(w,e),u(N,e),u(R,e),u(F,e),u(_,e),u(x,e),u(E,e),u(A,e),u(q,e),u(O,e),u(ne,e),u(se,e),u(oe,e),u(J,e),u(re,e)}}}const zt='{"title":"How to deploy Embedding Models to Amazon SageMaker using new Hugging Face Embedding DLC","local":"how-to-deploy-embedding-models-to-amazon-sagemaker-using-new-hugging-face-embedding-dlc","sections":[{"title":"What is Hugging Face Embedding DLC?","local":"what-is-hugging-face-embedding-dlc","sections":[],"depth":2},{"title":"1. Setup development environment","local":"1-setup-development-environment","sections":[],"depth":2},{"title":"2. Retrieve the new Hugging Face Embedding Container","local":"2-retrieve-the-new-hugging-face-embedding-container","sections":[],"depth":2},{"title":"3. Deploy Snowflake Arctic to Amazon SageMaker","local":"3-deploy-snowflake-arctic-to-amazon-sagemaker","sections":[],"depth":2},{"title":"4. Run and evaluate Inference performance","local":"4-run-and-evaluate-inference-performance","sections":[],"depth":2},{"title":"5. Delete model and endpoint","local":"5-delete-model-and-endpoint","sections":[],"depth":2}],"depth":1}';function Et(de){return Ht(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Dt extends Vt{constructor(r){super(),St(this,r,Et,xt,$t,{})}}export{Dt as component};
