import{s as re,b as ye,n as me,o as ce}from"../chunks/scheduler.aec39e6a.js";import{S as de,i as ue,e as M,s as a,c as o,h as je,a as i,d as l,b as n,f as St,g as p,j as d,k as U,l as he,m as s,n as r,t as y,o as m,p as c}from"../chunks/index.4ee0a2d0.js";import{C as Ue,H as et,E as ge}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.2422a08e.js";import{C as j}from"../chunks/CodeBlock.27357de2.js";function Je(qt){let h,at,lt,nt,g,Mt,J,it,b,xt="The get started guide will show you how to quickly use Hugging Face on Amazon SageMaker with the SDK. Learn how to fine-tune and deploy a pretrained 🤗 Transformers model on SageMaker for a binary text classification task.",ot,u,Et,pt,f,Qt='📓 Open the <a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/01_getting_started_pytorch/sagemaker-notebook.ipynb" rel="nofollow">sagemaker-notebook.ipynb file</a> to follow along!',rt,w,yt,T,Lt='Get started by installing the necessary Hugging Face libraries and SageMaker. You will also need to install <a href="https://pytorch.org/get-started/locally/" rel="nofollow">PyTorch</a> if you don’t already have it installed. If you run this example in SageMaker Studio, it is already installed in the notebook kernel!',mt,C,ct,k,Pt='<p>[!WARNING][SageMaker Python SDK v3 has been recently released](<a href="https://github.com/aws/sagemaker-python-sdk" rel="nofollow">https://github.com/aws/sagemaker-python-sdk</a>), so unless specified otherwise, all the documentation and tutorials are still using the <a href="https://github.com/aws/sagemaker-python-sdk/tree/master-v2" rel="nofollow">SageMaker Python SDK v2</a>. We are actively working on updating all the tutorials and examples, but in the meantime make sure to install the SageMaker SDK as <code>pip install &quot;sagemaker&lt;3.0.0&quot;</code>.</p>',dt,A,Dt='If you want to run this example in <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio.html" rel="nofollow">SageMaker Studio</a>, upgrade <a href="https://ipywidgets.readthedocs.io/en/latest/" rel="nofollow">ipywidgets</a> for the 🤗 Datasets library and restart the kernel:',ut,I,jt,Z,Kt='Next, you should set up your environment: a SageMaker session and an S3 bucket. The S3 bucket will store data, models, and logs. You will need access to an <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html" rel="nofollow">IAM execution role</a> with the required permissions.',ht,$,Ot='If you are planning on using SageMaker in a local environment, you need to provide the <code>role</code> yourself. Learn more about how to set this up <a href="https://huggingface.co/docs/sagemaker/train#installation-and-setup" rel="nofollow">here</a>.',Ut,B,te="⚠️ The execution role is only available when you run a notebook within SageMaker. If you try to run <code>get_execution_role</code> in a notebook not on SageMaker, you will get a region error.",gt,X,Jt,W,bt,_,ee='The 🤗 Datasets library makes it easy to download and preprocess a dataset for training. Download and tokenize the <a href="https://huggingface.co/datasets/imdb" rel="nofollow">IMDb</a> dataset:',ft,z,wt,G,Tt,N,le='Next, upload the preprocessed dataset to your S3 session bucket with 🤗 Datasets S3 <a href="https://huggingface.co/docs/datasets/filesystems.html" rel="nofollow">filesystem</a> implementation:',Ct,Y,kt,R,At,F,se="Create a Hugging Face Estimator to handle end-to-end SageMaker training and deployment. The most important parameters to pay attention to are:",It,V,ae='<li><code>entry_point</code> refers to the fine-tuning script which you can find in <a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/01_getting_started_pytorch/scripts/train.py" rel="nofollow">train.py file</a>.</li> <li><code>instance_type</code> refers to the SageMaker instance that will be launched. Take a look <a href="https://aws.amazon.com/sagemaker/pricing/" rel="nofollow">here</a> for a complete list of instance types.</li> <li><code>hyperparameters</code> refers to the training hyperparameters the model will be fine-tuned with.</li>',Zt,H,$t,v,ne="Begin training with one line of code:",Bt,S,Xt,q,Wt,x,Me="Once the training job is complete, deploy your fine-tuned model by calling <code>deploy()</code> with the number of instances and instance type:",_t,E,zt,Q,ie="Call <code>predict()</code> on your data:",Gt,L,Nt,P,oe="After running your request, delete the endpoint:",Yt,D,Rt,K,Ft,O,pe="Congratulations, you’ve just fine-tuned and deployed a pretrained 🤗 Transformers model on SageMaker for binary text classification! 🎉",Vt,tt,Ht,st,vt;return g=new Ue({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),J=new et({props:{title:"Train and deploy a Hugging Face model on Amazon SageMaker with the SDK",local:"train-and-deploy-a-hugging-face-model-on-amazon-sagemaker-with-the-sdk",headingTag:"h1"}}),w=new et({props:{title:"Installation and setup",local:"installation-and-setup",headingTag:"h2"}}),C=new j({props:{code:"cGlwJTIwaW5zdGFsbCUyMCUyMnNhZ2VtYWtlciUzQzMuMC4wJTIyJTIwJTIydHJhbnNmb3JtZXJzJTNEJTNENC4yNi4xJTIyJTIwJTIyZGF0YXNldHMlNUJzMyU1RCUzRCUzRDIuMTAuMSUyMiUyMC0tdXBncmFkZQ==",highlighted:'pip install <span class="hljs-string">&quot;sagemaker&lt;3.0.0&quot;</span> <span class="hljs-string">&quot;transformers==4.26.1&quot;</span> <span class="hljs-string">&quot;datasets[s3]==2.10.1&quot;</span> --upgrade',wrap:!1}}),I=new j({props:{code:"JTI1JTI1Y2FwdHVyZSUwQWltcG9ydCUyMElQeXRob24lMEEhY29uZGElMjBpbnN0YWxsJTIwLWMlMjBjb25kYS1mb3JnZSUyMGlweXdpZGdldHMlMjAteSUwQUlQeXRob24uQXBwbGljYXRpb24uaW5zdGFuY2UoKS5rZXJuZWwuZG9fc2h1dGRvd24oVHJ1ZSk=",highlighted:`%%capture
<span class="hljs-keyword">import</span> IPython
!conda install -c conda-forge ipywidgets -y
IPython.Application.instance().kernel.do_shutdown(<span class="hljs-literal">True</span>)`,wrap:!1}}),X=new j({props:{code:"aW1wb3J0JTIwc2FnZW1ha2VyJTBBJTBBc2VzcyUyMCUzRCUyMHNhZ2VtYWtlci5TZXNzaW9uKCklMEFzYWdlbWFrZXJfc2Vzc2lvbl9idWNrZXQlMjAlM0QlMjBOb25lJTBBaWYlMjBzYWdlbWFrZXJfc2Vzc2lvbl9idWNrZXQlMjBpcyUyME5vbmUlMjBhbmQlMjBzZXNzJTIwaXMlMjBub3QlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwc2FnZW1ha2VyX3Nlc3Npb25fYnVja2V0JTIwJTNEJTIwc2Vzcy5kZWZhdWx0X2J1Y2tldCgpJTBBJTBBcm9sZSUyMCUzRCUyMHNhZ2VtYWtlci5nZXRfZXhlY3V0aW9uX3JvbGUoKSUwQXNlc3MlMjAlM0QlMjBzYWdlbWFrZXIuU2Vzc2lvbihkZWZhdWx0X2J1Y2tldCUzRHNhZ2VtYWtlcl9zZXNzaW9uX2J1Y2tldCk=",highlighted:`<span class="hljs-keyword">import</span> sagemaker

sess = sagemaker.Session()
sagemaker_session_bucket = <span class="hljs-literal">None</span>
<span class="hljs-keyword">if</span> sagemaker_session_bucket <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">and</span> sess <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
    sagemaker_session_bucket = sess.default_bucket()

role = sagemaker.get_execution_role()
sess = sagemaker.Session(default_bucket=sagemaker_session_bucket)`,wrap:!1}}),W=new et({props:{title:"Preprocess",local:"preprocess",headingTag:"h2"}}),z=new j({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEElMjMlMjBsb2FkJTIwZGF0YXNldCUwQXRyYWluX2RhdGFzZXQlMkMlMjB0ZXN0X2RhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaW1kYiUyMiUyQyUyMHNwbGl0JTNEJTVCJTIydHJhaW4lMjIlMkMlMjAlMjJ0ZXN0JTIyJTVEKSUwQSUwQSUyMyUyMGxvYWQlMjB0b2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQlMjIpJTBBJTBBJTIzJTIwY3JlYXRlJTIwdG9rZW5pemF0aW9uJTIwZnVuY3Rpb24lMEFkZWYlMjB0b2tlbml6ZShiYXRjaCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjB0b2tlbml6ZXIoYmF0Y2glNUIlMjJ0ZXh0JTIyJTVEJTJDJTIwcGFkZGluZyUzRCUyMm1heF9sZW5ndGglMjIlMkMlMjB0cnVuY2F0aW9uJTNEVHJ1ZSklMEElMEElMjMlMjB0b2tlbml6ZSUyMHRyYWluJTIwYW5kJTIwdGVzdCUyMGRhdGFzZXRzJTBBdHJhaW5fZGF0YXNldCUyMCUzRCUyMHRyYWluX2RhdGFzZXQubWFwKHRva2VuaXplJTJDJTIwYmF0Y2hlZCUzRFRydWUpJTBBdGVzdF9kYXRhc2V0JTIwJTNEJTIwdGVzdF9kYXRhc2V0Lm1hcCh0b2tlbml6ZSUyQyUyMGJhdGNoZWQlM0RUcnVlKSUwQSUwQSUyMyUyMHNldCUyMGRhdGFzZXQlMjBmb3JtYXQlMjBmb3IlMjBQeVRvcmNoJTBBdHJhaW5fZGF0YXNldCUyMCUzRCUyMCUyMHRyYWluX2RhdGFzZXQucmVuYW1lX2NvbHVtbiglMjJsYWJlbCUyMiUyQyUyMCUyMmxhYmVscyUyMiklMEF0cmFpbl9kYXRhc2V0LnNldF9mb3JtYXQoJTIydG9yY2glMjIlMkMlMjBjb2x1bW5zJTNEJTVCJTIyaW5wdXRfaWRzJTIyJTJDJTIwJTIyYXR0ZW50aW9uX21hc2slMjIlMkMlMjAlMjJsYWJlbHMlMjIlNUQpJTBBdGVzdF9kYXRhc2V0JTIwJTNEJTIwdGVzdF9kYXRhc2V0LnJlbmFtZV9jb2x1bW4oJTIybGFiZWwlMjIlMkMlMjAlMjJsYWJlbHMlMjIpJTBBdGVzdF9kYXRhc2V0LnNldF9mb3JtYXQoJTIydG9yY2glMjIlMkMlMjBjb2x1bW5zJTNEJTVCJTIyaW5wdXRfaWRzJTIyJTJDJTIwJTIyYXR0ZW50aW9uX21hc2slMjIlMkMlMjAlMjJsYWJlbHMlMjIlNUQp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-comment"># load dataset</span>
train_dataset, test_dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=[<span class="hljs-string">&quot;train&quot;</span>, <span class="hljs-string">&quot;test&quot;</span>])

<span class="hljs-comment"># load tokenizer</span>
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilbert-base-uncased&quot;</span>)

<span class="hljs-comment"># create tokenization function</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize</span>(<span class="hljs-params">batch</span>):
    <span class="hljs-keyword">return</span> tokenizer(batch[<span class="hljs-string">&quot;text&quot;</span>], padding=<span class="hljs-string">&quot;max_length&quot;</span>, truncation=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># tokenize train and test datasets</span>
train_dataset = train_dataset.<span class="hljs-built_in">map</span>(tokenize, batched=<span class="hljs-literal">True</span>)
test_dataset = test_dataset.<span class="hljs-built_in">map</span>(tokenize, batched=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># set dataset format for PyTorch</span>
train_dataset =  train_dataset.rename_column(<span class="hljs-string">&quot;label&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>)
train_dataset.set_format(<span class="hljs-string">&quot;torch&quot;</span>, columns=[<span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>])
test_dataset = test_dataset.rename_column(<span class="hljs-string">&quot;label&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>)
test_dataset.set_format(<span class="hljs-string">&quot;torch&quot;</span>, columns=[<span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>])`,wrap:!1}}),G=new et({props:{title:"Upload dataset to S3 bucket",local:"upload-dataset-to-s3-bucket",headingTag:"h2"}}),Y=new j({props:{code:"JTIzJTIwc2F2ZSUyMHRyYWluX2RhdGFzZXQlMjB0byUyMHMzJTBBdHJhaW5pbmdfaW5wdXRfcGF0aCUyMCUzRCUyMGYnczMlM0ElMkYlMkYlN0JzZXNzLmRlZmF1bHRfYnVja2V0KCklN0QlMkYlN0JzM19wcmVmaXglN0QlMkZ0cmFpbiclMEF0cmFpbl9kYXRhc2V0LnNhdmVfdG9fZGlzayh0cmFpbmluZ19pbnB1dF9wYXRoKSUwQSUwQSUyMyUyMHNhdmUlMjB0ZXN0X2RhdGFzZXQlMjB0byUyMHMzJTBBdGVzdF9pbnB1dF9wYXRoJTIwJTNEJTIwZidzMyUzQSUyRiUyRiU3QnNlc3MuZGVmYXVsdF9idWNrZXQoKSU3RCUyRiU3QnMzX3ByZWZpeCU3RCUyRnRlc3QnJTBBdGVzdF9kYXRhc2V0LnNhdmVfdG9fZGlzayh0ZXN0X2lucHV0X3BhdGgp",highlighted:`<span class="hljs-comment"># save train_dataset to s3</span>
training_input_path = <span class="hljs-string">f&#x27;s3://<span class="hljs-subst">{sess.default_bucket()}</span>/<span class="hljs-subst">{s3_prefix}</span>/train&#x27;</span>
train_dataset.save_to_disk(training_input_path)

<span class="hljs-comment"># save test_dataset to s3</span>
test_input_path = <span class="hljs-string">f&#x27;s3://<span class="hljs-subst">{sess.default_bucket()}</span>/<span class="hljs-subst">{s3_prefix}</span>/test&#x27;</span>
test_dataset.save_to_disk(test_input_path)`,wrap:!1}}),R=new et({props:{title:"Start a training job",local:"start-a-training-job",headingTag:"h2"}}),H=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface <span class="hljs-keyword">import</span> HuggingFace

hyperparameters={
    <span class="hljs-string">&quot;epochs&quot;</span>: <span class="hljs-number">1</span>,                                       <span class="hljs-comment"># number of training epochs</span>
    <span class="hljs-string">&quot;train_batch_size&quot;</span>: <span class="hljs-number">32</span>,                            <span class="hljs-comment"># training batch size</span>
    <span class="hljs-string">&quot;model_name&quot;</span>:<span class="hljs-string">&quot;distilbert/distilbert-base-uncased&quot;</span>  <span class="hljs-comment"># name of pretrained model</span>
}

huggingface_estimator = HuggingFace(
    entry_point=<span class="hljs-string">&quot;train.py&quot;</span>,                 <span class="hljs-comment"># fine-tuning script to use in training job</span>
    source_dir=<span class="hljs-string">&quot;./scripts&quot;</span>,                 <span class="hljs-comment"># directory where fine-tuning script is stored</span>
    instance_type=<span class="hljs-string">&quot;ml.p3.2xlarge&quot;</span>,          <span class="hljs-comment"># instance type</span>
    instance_count=<span class="hljs-number">1</span>,                       <span class="hljs-comment"># number of instances</span>
    role=role,                              <span class="hljs-comment"># IAM role used in training job to access AWS resources (S3)</span>
    transformers_version=<span class="hljs-string">&quot;4.36&quot;</span>,             <span class="hljs-comment"># Transformers version</span>
    pytorch_version=<span class="hljs-string">&quot;2.1.0&quot;</span>,                  <span class="hljs-comment"># PyTorch version</span>
    py_version=<span class="hljs-string">&quot;py310&quot;</span>,                      <span class="hljs-comment"># Python version</span>
    hyperparameters=hyperparameters         <span class="hljs-comment"># hyperparameters to use in training job</span>
)`,wrap:!1}}),S=new j({props:{code:"aHVnZ2luZ2ZhY2VfZXN0aW1hdG9yLmZpdCglN0IlMjJ0cmFpbiUyMiUzQSUyMHRyYWluaW5nX2lucHV0X3BhdGglMkMlMjAlMjJ0ZXN0JTIyJTNBJTIwdGVzdF9pbnB1dF9wYXRoJTdEKQ==",highlighted:'huggingface_estimator.fit({<span class="hljs-string">&quot;train&quot;</span>: training_input_path, <span class="hljs-string">&quot;test&quot;</span>: test_input_path})',wrap:!1}}),q=new et({props:{title:"Deploy model",local:"deploy-model",headingTag:"h2"}}),E=new j({props:{code:"cHJlZGljdG9yJTIwJTNEJTIwaHVnZ2luZ2ZhY2VfZXN0aW1hdG9yLmRlcGxveShpbml0aWFsX2luc3RhbmNlX2NvdW50JTNEMSUyQyUyMm1sLmc0ZG4ueGxhcmdlJTIyKQ==",highlighted:'predictor = huggingface_estimator.deploy(initial_instance_count=<span class="hljs-number">1</span>,<span class="hljs-string">&quot;ml.g4dn.xlarge&quot;</span>)',wrap:!1}}),L=new j({props:{code:"c2VudGltZW50X2lucHV0JTIwJTNEJTIwJTdCJTIyaW5wdXRzJTIyJTNBJTIwJTIySXQlMjBmZWVscyUyMGxpa2UlMjBhJTIwY3VydGFpbiUyMGNsb3NpbmcuLi50aGVyZSUyMHdhcyUyMGFuJTIwZWxlZ2FuY2UlMjBpbiUyMHRoZSUyMHdheSUyMHRoZXklMjBtb3ZlZCUyMHRvd2FyZCUyMGNvbmNsdXNpb24uJTIwTm8lMjBmYW4lMjBpcyUyMGdvaW5nJTIwdG8lMjB3YXRjaCUyMGFuZCUyMGZlZWwlMjBzaG9ydC1jaGFuZ2VkLiUyMiU3RCUwQSUwQXByZWRpY3Rvci5wcmVkaWN0KHNlbnRpbWVudF9pbnB1dCk=",highlighted:`sentiment_input = {<span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;It feels like a curtain closing...there was an elegance in the way they moved toward conclusion. No fan is going to watch and feel short-changed.&quot;</span>}

predictor.predict(sentiment_input)`,wrap:!1}}),D=new j({props:{code:"cHJlZGljdG9yLmRlbGV0ZV9lbmRwb2ludCgp",highlighted:"predictor.delete_endpoint()",wrap:!1}}),K=new et({props:{title:"What’s next?",local:"whats-next",headingTag:"h2"}}),tt=new ge({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/sagemaker/source/tutorials/sagemaker-sdk/sagemaker-sdk-quickstart.md"}}),{c(){h=M("meta"),at=a(),lt=M("p"),nt=a(),o(g.$$.fragment),Mt=a(),o(J.$$.fragment),it=a(),b=M("p"),b.textContent=xt,ot=a(),u=M("iframe"),pt=a(),f=M("p"),f.innerHTML=Qt,rt=a(),o(w.$$.fragment),yt=a(),T=M("p"),T.innerHTML=Lt,mt=a(),o(C.$$.fragment),ct=a(),k=M("blockquote"),k.innerHTML=Pt,dt=a(),A=M("p"),A.innerHTML=Dt,ut=a(),o(I.$$.fragment),jt=a(),Z=M("p"),Z.innerHTML=Kt,ht=a(),$=M("p"),$.innerHTML=Ot,Ut=a(),B=M("p"),B.innerHTML=te,gt=a(),o(X.$$.fragment),Jt=a(),o(W.$$.fragment),bt=a(),_=M("p"),_.innerHTML=ee,ft=a(),o(z.$$.fragment),wt=a(),o(G.$$.fragment),Tt=a(),N=M("p"),N.innerHTML=le,Ct=a(),o(Y.$$.fragment),kt=a(),o(R.$$.fragment),At=a(),F=M("p"),F.textContent=se,It=a(),V=M("ul"),V.innerHTML=ae,Zt=a(),o(H.$$.fragment),$t=a(),v=M("p"),v.textContent=ne,Bt=a(),o(S.$$.fragment),Xt=a(),o(q.$$.fragment),Wt=a(),x=M("p"),x.innerHTML=Me,_t=a(),o(E.$$.fragment),zt=a(),Q=M("p"),Q.innerHTML=ie,Gt=a(),o(L.$$.fragment),Nt=a(),P=M("p"),P.textContent=oe,Yt=a(),o(D.$$.fragment),Rt=a(),o(K.$$.fragment),Ft=a(),O=M("p"),O.textContent=pe,Vt=a(),o(tt.$$.fragment),Ht=a(),st=M("p"),this.h()},l(t){const e=je("svelte-u9bgzb",document.head);h=i(e,"META",{name:!0,content:!0}),e.forEach(l),at=n(t),lt=i(t,"P",{}),St(lt).forEach(l),nt=n(t),p(g.$$.fragment,t),Mt=n(t),p(J.$$.fragment,t),it=n(t),b=i(t,"P",{"data-svelte-h":!0}),d(b)!=="svelte-w5bkwl"&&(b.textContent=xt),ot=n(t),u=i(t,"IFRAME",{width:!0,height:!0,src:!0,title:!0,frameborder:!0,allow:!0}),St(u).forEach(l),pt=n(t),f=i(t,"P",{"data-svelte-h":!0}),d(f)!=="svelte-mi6lna"&&(f.innerHTML=Qt),rt=n(t),p(w.$$.fragment,t),yt=n(t),T=i(t,"P",{"data-svelte-h":!0}),d(T)!=="svelte-198besl"&&(T.innerHTML=Lt),mt=n(t),p(C.$$.fragment,t),ct=n(t),k=i(t,"BLOCKQUOTE",{"data-svelte-h":!0}),d(k)!=="svelte-p7runb"&&(k.innerHTML=Pt),dt=n(t),A=i(t,"P",{"data-svelte-h":!0}),d(A)!=="svelte-yozy2b"&&(A.innerHTML=Dt),ut=n(t),p(I.$$.fragment,t),jt=n(t),Z=i(t,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-1sllt2f"&&(Z.innerHTML=Kt),ht=n(t),$=i(t,"P",{"data-svelte-h":!0}),d($)!=="svelte-tg9h77"&&($.innerHTML=Ot),Ut=n(t),B=i(t,"P",{"data-svelte-h":!0}),d(B)!=="svelte-y9vgbx"&&(B.innerHTML=te),gt=n(t),p(X.$$.fragment,t),Jt=n(t),p(W.$$.fragment,t),bt=n(t),_=i(t,"P",{"data-svelte-h":!0}),d(_)!=="svelte-b8daui"&&(_.innerHTML=ee),ft=n(t),p(z.$$.fragment,t),wt=n(t),p(G.$$.fragment,t),Tt=n(t),N=i(t,"P",{"data-svelte-h":!0}),d(N)!=="svelte-nm384r"&&(N.innerHTML=le),Ct=n(t),p(Y.$$.fragment,t),kt=n(t),p(R.$$.fragment,t),At=n(t),F=i(t,"P",{"data-svelte-h":!0}),d(F)!=="svelte-16p4w97"&&(F.textContent=se),It=n(t),V=i(t,"UL",{"data-svelte-h":!0}),d(V)!=="svelte-1bnefx4"&&(V.innerHTML=ae),Zt=n(t),p(H.$$.fragment,t),$t=n(t),v=i(t,"P",{"data-svelte-h":!0}),d(v)!=="svelte-b865q9"&&(v.textContent=ne),Bt=n(t),p(S.$$.fragment,t),Xt=n(t),p(q.$$.fragment,t),Wt=n(t),x=i(t,"P",{"data-svelte-h":!0}),d(x)!=="svelte-twh61n"&&(x.innerHTML=Me),_t=n(t),p(E.$$.fragment,t),zt=n(t),Q=i(t,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-19s4ndj"&&(Q.innerHTML=ie),Gt=n(t),p(L.$$.fragment,t),Nt=n(t),P=i(t,"P",{"data-svelte-h":!0}),d(P)!=="svelte-l180zc"&&(P.textContent=oe),Yt=n(t),p(D.$$.fragment,t),Rt=n(t),p(K.$$.fragment,t),Ft=n(t),O=i(t,"P",{"data-svelte-h":!0}),d(O)!=="svelte-g7jk9r"&&(O.textContent=pe),Vt=n(t),p(tt.$$.fragment,t),Ht=n(t),st=i(t,"P",{}),St(st).forEach(l),this.h()},h(){U(h,"name","hf:doc:metadata"),U(h,"content",be),U(u,"width","560"),U(u,"height","315"),ye(u.src,Et="https://www.youtube.com/embed/pYqjCzoyWyo")||U(u,"src",Et),U(u,"title","YouTube video player"),U(u,"frameborder","0"),U(u,"allow","accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"),u.allowFullscreen=""},m(t,e){he(document.head,h),s(t,at,e),s(t,lt,e),s(t,nt,e),r(g,t,e),s(t,Mt,e),r(J,t,e),s(t,it,e),s(t,b,e),s(t,ot,e),s(t,u,e),s(t,pt,e),s(t,f,e),s(t,rt,e),r(w,t,e),s(t,yt,e),s(t,T,e),s(t,mt,e),r(C,t,e),s(t,ct,e),s(t,k,e),s(t,dt,e),s(t,A,e),s(t,ut,e),r(I,t,e),s(t,jt,e),s(t,Z,e),s(t,ht,e),s(t,$,e),s(t,Ut,e),s(t,B,e),s(t,gt,e),r(X,t,e),s(t,Jt,e),r(W,t,e),s(t,bt,e),s(t,_,e),s(t,ft,e),r(z,t,e),s(t,wt,e),r(G,t,e),s(t,Tt,e),s(t,N,e),s(t,Ct,e),r(Y,t,e),s(t,kt,e),r(R,t,e),s(t,At,e),s(t,F,e),s(t,It,e),s(t,V,e),s(t,Zt,e),r(H,t,e),s(t,$t,e),s(t,v,e),s(t,Bt,e),r(S,t,e),s(t,Xt,e),r(q,t,e),s(t,Wt,e),s(t,x,e),s(t,_t,e),r(E,t,e),s(t,zt,e),s(t,Q,e),s(t,Gt,e),r(L,t,e),s(t,Nt,e),s(t,P,e),s(t,Yt,e),r(D,t,e),s(t,Rt,e),r(K,t,e),s(t,Ft,e),s(t,O,e),s(t,Vt,e),r(tt,t,e),s(t,Ht,e),s(t,st,e),vt=!0},p:me,i(t){vt||(y(g.$$.fragment,t),y(J.$$.fragment,t),y(w.$$.fragment,t),y(C.$$.fragment,t),y(I.$$.fragment,t),y(X.$$.fragment,t),y(W.$$.fragment,t),y(z.$$.fragment,t),y(G.$$.fragment,t),y(Y.$$.fragment,t),y(R.$$.fragment,t),y(H.$$.fragment,t),y(S.$$.fragment,t),y(q.$$.fragment,t),y(E.$$.fragment,t),y(L.$$.fragment,t),y(D.$$.fragment,t),y(K.$$.fragment,t),y(tt.$$.fragment,t),vt=!0)},o(t){m(g.$$.fragment,t),m(J.$$.fragment,t),m(w.$$.fragment,t),m(C.$$.fragment,t),m(I.$$.fragment,t),m(X.$$.fragment,t),m(W.$$.fragment,t),m(z.$$.fragment,t),m(G.$$.fragment,t),m(Y.$$.fragment,t),m(R.$$.fragment,t),m(H.$$.fragment,t),m(S.$$.fragment,t),m(q.$$.fragment,t),m(E.$$.fragment,t),m(L.$$.fragment,t),m(D.$$.fragment,t),m(K.$$.fragment,t),m(tt.$$.fragment,t),vt=!1},d(t){t&&(l(at),l(lt),l(nt),l(Mt),l(it),l(b),l(ot),l(u),l(pt),l(f),l(rt),l(yt),l(T),l(mt),l(ct),l(k),l(dt),l(A),l(ut),l(jt),l(Z),l(ht),l($),l(Ut),l(B),l(gt),l(Jt),l(bt),l(_),l(ft),l(wt),l(Tt),l(N),l(Ct),l(kt),l(At),l(F),l(It),l(V),l(Zt),l($t),l(v),l(Bt),l(Xt),l(Wt),l(x),l(_t),l(zt),l(Q),l(Gt),l(Nt),l(P),l(Yt),l(Rt),l(Ft),l(O),l(Vt),l(Ht),l(st)),l(h),c(g,t),c(J,t),c(w,t),c(C,t),c(I,t),c(X,t),c(W,t),c(z,t),c(G,t),c(Y,t),c(R,t),c(H,t),c(S,t),c(q,t),c(E,t),c(L,t),c(D,t),c(K,t),c(tt,t)}}}const be='{"title":"Train and deploy a Hugging Face model on Amazon SageMaker with the SDK","local":"train-and-deploy-a-hugging-face-model-on-amazon-sagemaker-with-the-sdk","sections":[{"title":"Installation and setup","local":"installation-and-setup","sections":[],"depth":2},{"title":"Preprocess","local":"preprocess","sections":[],"depth":2},{"title":"Upload dataset to S3 bucket","local":"upload-dataset-to-s3-bucket","sections":[],"depth":2},{"title":"Start a training job","local":"start-a-training-job","sections":[],"depth":2},{"title":"Deploy model","local":"deploy-model","sections":[],"depth":2},{"title":"What’s next?","local":"whats-next","sections":[],"depth":2}],"depth":1}';function fe(qt){return ce(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ae extends de{constructor(h){super(),ue(this,h,fe,Je,re,{})}}export{Ae as component};
