import{s as Jn,b as ys,n as fn,o as bn}from"../chunks/scheduler.aec39e6a.js";import{S as gn,i as In,e as M,s as n,c as r,h as Cn,a as o,d as t,b as a,f as cl,g as p,j as i,k as U,l as Zn,m as s,n as y,t as d,o as m,p as c}from"../chunks/index.4ee0a2d0.js";import{C as kn,H as h,E as Bn}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.2422a08e.js";import{C as u}from"../chunks/CodeBlock.27357de2.js";function Gn(ds){let J,ul,dl,Ul,g,jl,I,Tl,C,ms="Deploying a 🤗 Transformers models in SageMaker for inference is as easy as:",wl,Z,hl,k,cs='This guide will show you how to deploy models with zero-code using the <a href="https://github.com/aws/sagemaker-huggingface-inference-toolkit" rel="nofollow">Inference Toolkit</a>. The Inference Toolkit builds on top of the <a href="https://huggingface.co/docs/transformers/main_classes/pipelines" rel="nofollow"><code>pipeline</code> feature</a> from 🤗 Transformers. Learn how to:',Jl,B,us='<li><a href="#installation-and-setup">Install and setup the Inference Toolkit</a>.</li> <li><a href="#deploy-a-transformer-model-trained-in-sagemaker">Deploy a 🤗 Transformers model trained in SageMaker</a>.</li> <li><a href="#deploy-a-model-from-the-hub">Deploy a 🤗 Transformers model from the Hugging Face [model Hub](https://huggingface.co/models)</a>.</li> <li><a href="#run-batch-transform-with-transformers-and-sagemaker">Run a Batch Transform Job using 🤗 Transformers and Amazon SageMaker</a>.</li> <li><a href="#user-defined-code-and-modules">Create a custom inference module</a>.</li>',fl,G,bl,W,Us='Before deploying a 🤗 Transformers model to SageMaker, you need to sign up for an AWS account. If you don’t have an AWS account yet, learn more <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/gs-set-up.html" rel="nofollow">here</a>.',gl,A,js="Once you have an AWS account, get started using one of the following:",Il,v,Ts='<li><a href="https://docs.aws.amazon.com/sagemaker/latest/dg/gs-studio-onboard.html" rel="nofollow">SageMaker Studio</a></li> <li><a href="https://docs.aws.amazon.com/sagemaker/latest/dg/gs-console.html" rel="nofollow">SageMaker notebook instance</a></li> <li>Local environment</li>',Cl,$,ws='To start training locally, you need to setup an appropriate <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html" rel="nofollow">IAM role</a>.',Zl,S,hs="Upgrade to the latest <code>sagemaker</code> version.",kl,_,Bl,H,Js='<p>[!WARNING][SageMaker Python SDK v3 has been recently released](<a href="https://github.com/aws/sagemaker-python-sdk" rel="nofollow">https://github.com/aws/sagemaker-python-sdk</a>), so unless specified otherwise, all the documentation and tutorials are still using the <a href="https://github.com/aws/sagemaker-python-sdk/tree/master-v2" rel="nofollow">SageMaker Python SDK v2</a>. We are actively working on updating all the tutorials and examples, but in the meantime make sure to install the SageMaker SDK as <code>pip install &quot;sagemaker&lt;3.0.0&quot;</code>.</p>',Gl,R,fs="<strong>SageMaker environment</strong>",Wl,x,bs="Setup your SageMaker environment as shown below:",Al,E,vl,V,gs="<em>Note: The execution role is only available when running a notebook within SageMaker. If you run <code>get_execution_role</code> in a notebook not on SageMaker, expect a <code>region</code> error.</em>",$l,z,Is="<strong>Local environment</strong>",Sl,N,Cs="Setup your local environment as shown below:",_l,Y,Hl,F,Rl,j,Zs,xl,X,ks="There are two ways to deploy your Hugging Face model trained in SageMaker:",El,Q,Bs="<li>Deploy it after your training has finished.</li> <li>Deploy your saved model at a later time from S3 with the <code>model_data</code>.</li>",Vl,L,Gs='📓 Open the <a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/10_deploy_model_from_s3/deploy_transformer_model_from_s3.ipynb" rel="nofollow">deploy_transformer_model_from_s3.ipynb notebook</a> for an example of how to deploy a model from S3 to SageMaker for inference.',zl,q,Nl,P,Ws="To deploy your model directly after training, ensure all required files are saved in your training script, including the tokenizer and the model.",Yl,D,As="If you use the Hugging Face <code>Trainer</code>, you can pass your tokenizer as an argument to the <code>Trainer</code>. It will be automatically saved when you call <code>trainer.save_model()</code>.",Fl,K,Xl,O,vs="After you run your request you can delete the endpoint as shown:",Ql,ee,Ll,le,ql,te,$s="If you’ve already trained your model and want to deploy it at a later time, use the <code>model_data</code> argument to specify the location of your tokenizer and model weights.",Pl,se,Dl,ne,Ss="After you run our request, you can delete the endpoint again with:",Kl,ae,Ol,Me,et,oe,_s="For later deployment, you can create a <code>model.tar.gz</code> file that contains all the required files, such as:",lt,ie,Hs="<li><code>pytorch_model.bin</code></li> <li><code>tf_model.h5</code></li> <li><code>tokenizer.json</code></li> <li><code>tokenizer_config.json</code></li>",tt,re,Rs="For example, your file should look like this:",st,pe,nt,ye,xs="Create your own <code>model.tar.gz</code> from a model from the 🤗 Hub:",at,de,Es="<li>Download a model:</li>",Mt,me,ot,f,Vs="<li>Create a <code>tar</code> file:</li>",it,ce,rt,b,zs="<li>Upload <code>model.tar.gz</code> to S3:</li>",pt,ue,yt,Ue,Ns="Now you can provide the S3 URI to the <code>model_data</code> argument to deploy your model later.",dt,je,mt,T,Ys,ct,Te,Fs="To deploy a model directly from the 🤗 Hub to SageMaker, define two environment variables when you create a <code>HuggingFaceModel</code>:",ut,we,Xs='<li><code>HF_MODEL_ID</code> defines the model ID which is automatically loaded from <a href="http://huggingface.co/models" rel="nofollow">huggingface.co/models</a> when you create a SageMaker endpoint. Access 10,000+ models on he 🤗 Hub through this environment variable.</li> <li><code>HF_TASK</code> defines the task for the 🤗 Transformers <code>pipeline</code>. A complete list of tasks can be found <a href="https://huggingface.co/docs/transformers/main_classes/pipelines" rel="nofollow">here</a>.</li>',Ut,he,Qs='<p>⚠️ ** Pipelines are not optimized for parallelism (multi-threading) and tend to consume a lot of RAM. For example, on a GPU-based instance, the pipeline operates on a single vCPU. When this vCPU becomes saturated with the inference requests preprocessing, it can create a bottleneck, preventing the GPU from being fully utilized for model inference. Learn more <a href="https://huggingface.co/docs/transformers/en/pipeline_webserver#using-pipelines-for-a-webserver" rel="nofollow">here</a></p>',jt,Je,Tt,fe,Ls="After you run our request, you can delete the endpoint again with:",wt,be,ht,ge,qs='📓 Open the <a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/11_deploy_model_from_hf_hub/deploy_transformer_model_from_hf_hub.ipynb" rel="nofollow">deploy_transformer_model_from_hf_hub.ipynb notebook</a> for an example of how to deploy a model from the 🤗 Hub to SageMaker for inference.',Jt,Ie,ft,w,Ps,bt,Ce,Ds='After training a model, you can use <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works-batch.html" rel="nofollow">SageMaker batch transform</a> to perform inference with the model. Batch transform accepts your inference data as an S3 URI  and then SageMaker will take care of downloading the data, running the prediction, and uploading the results to S3. For more details about batch transform, take a look <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform.html" rel="nofollow">here</a>.',gt,Ze,Ks="⚠️ The Hugging Face Inference DLC currently only supports <code>.jsonl</code> for batch transform due to the complex structure of textual data.",It,ke,Os="<em>Note: Make sure your <code>inputs</code> fit the <code>max_length</code> of the model during preprocessing.</em>",Ct,Be,en='If you trained a model using the Hugging Face Estimator, call the <code>transformer()</code> method to create a transform job for a model based on the training job (see <a href="https://sagemaker.readthedocs.io/en/stable/overview.html#sagemaker-batch-transform" rel="nofollow">here</a> for more details):',Zt,Ge,kt,We,ln="If you want to run your batch transform job later or with a model from the 🤗 Hub, create a <code>HuggingFaceModel</code> instance and then call the <code>transformer()</code> method:",Bt,Ae,Gt,ve,tn="The <code>input.jsonl</code> looks like this:",Wt,$e,At,Se,sn='📓 Open the <a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/12_batch_transform_inference/sagemaker-notebook.ipynb" rel="nofollow">sagemaker-notebook.ipynb notebook</a> for an example of how to run a batch transform job for inference.',vt,_e,$t,He,nn='If you are interested in using a high-performance serving container for LLMs, you can use the Hugging Face TGI container. This utilizes the <a href="https://github.com/huggingface/text-generation-inference" rel="nofollow">Text Generation Inference</a> library. A list of compatible models can be found <a href="https://huggingface.co/docs/text-generation-inference/supported_models#supported-models" rel="nofollow">here</a>.',St,Re,an="First, make sure that the latest version of SageMaker SDK is installed:",_t,xe,Ht,Ee,Mn="Then, we import the SageMaker Python SDK and instantiate a sagemaker_session to find the current region and execution role.",Rt,Ve,xt,ze,on="Next we retrieve the LLM image URI. We use the helper function get_huggingface_llm_image_uri() to generate the appropriate image URI for the Hugging Face Large Language Model (LLM) inference. The function takes a required parameter backend and several optional parameters. The backend specifies the type of backend to use for the model:  “huggingface” refers to using Hugging Face TGI backend.",Et,Ne,Vt,Ye,rn="Now that we have the image uri, the next step is to configure the model object. We specify a unique name, the image_uri for the managed TGI container, and the execution role for the endpoint. Additionally, we specify a number of environment variables including the <code>HF_MODEL_ID</code> which corresponds to the model from the HuggingFace Hub that will be deployed, and the <code>HF_TASK</code> which configures the inference task to be performed by the model.",zt,Fe,pn="You should also define <code>SM_NUM_GPUS</code>, which specifies the tensor parallelism degree of the model. Tensor parallelism can be used to split the model across multiple GPUs, which is necessary when working with LLMs that are too big for a single GPU. To learn more about tensor parallelism with inference, see our previous blog post. Here, you should set <code>SM_NUM_GPUS</code> to the number of available GPUs on your selected instance type. For example, in this tutorial, we set <code>SM_NUM_GPUS</code> to 4 because our selected instance type ml.g4dn.12xlarge has 4 available GPUs.",Nt,Xe,yn="Note that you can optionally reduce the memory and computational footprint of the model by setting the <code>HF_MODEL_QUANTIZE</code> environment variable to <code>true</code>, but this lower weight precision could affect the quality of the output for some models.",Yt,Qe,Ft,Le,dn="Next, we invoke the deploy method to deploy the model.",Xt,qe,Qt,Pe,mn="Once the model is deployed, we can invoke it to generate text. We pass an input prompt and run the predict method to generate a text response from the LLM running in the TGI container.",Lt,De,qt,Ke,cn="We receive the following auto-generated text response:",Pt,Oe,Dt,el,un="Once we are done experimenting, we delete the endpoint and the model resources.",Kt,ll,Ot,tl,es,sl,Un='The Hugging Face Inference Toolkit allows the user to override the default methods of the <code>HuggingFaceHandlerService</code>. You will need to create a folder named <code>code/</code> with an <code>inference.py</code> file in it. See <a href="#create-a-model-artifact-for-deployment">here</a> for more details on how to archive your model artifacts. For example:',ls,nl,ts,al,jn="The <code>inference.py</code> file contains your custom inference module, and the <code>requirements.txt</code> file contains additional dependencies that should be added. The custom module can override the following methods:",ss,Ml,Tn=`<li><code>model_fn(model_dir)</code> overrides the default method for loading a model. The return value <code>model</code> will be used in <code>predict</code> for predictions. <code>predict</code> receives argument the <code>model_dir</code>, the path to your unzipped <code>model.tar.gz</code>.</li> <li><code>transform_fn(model, data, content_type, accept_type)</code> overrides the default transform function with your custom implementation. You will need to implement your own <code>preprocess</code>, <code>predict</code> and <code>postprocess</code> steps in the <code>transform_fn</code>. This method can’t be combined with <code>input_fn</code>, <code>predict_fn</code> or <code>output_fn</code> mentioned below.</li> <li><code>input_fn(input_data, content_type)</code> overrides the default method for preprocessing. The return value <code>data</code> will be used in <code>predict</code> for predictions. The inputs are:
<ul><li><code>input_data</code> is the raw body of your request.</li> <li><code>content_type</code> is the content type from the request header.</li></ul></li> <li><code>predict_fn(processed_data, model)</code> overrides the default method for predictions. The return value <code>predictions</code> will be used in <code>postprocess</code>. The input is <code>processed_data</code>, the result from <code>preprocess</code>.</li> <li><code>output_fn(prediction, accept)</code> overrides the default method for postprocessing. The return value <code>result</code> will be the response of your request (e.g.<code>JSON</code>). The inputs are:
<ul><li><code>predictions</code> is the result from <code>predict</code>.</li> <li><code>accept</code> is the return accept type from the HTTP Request, e.g. <code>application/json</code>.</li></ul></li>`,ns,ol,wn="Here is an example of a custom inference module with <code>model_fn</code>, <code>input_fn</code>, <code>predict_fn</code>, and <code>output_fn</code>:",as,il,Ms,rl,hn="Customize your inference module with only <code>model_fn</code> and <code>transform_fn</code>:",os,pl,is,yl,rs,ml,ps;return g=new kn({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),I=new h({props:{title:"Deploy models to Amazon SageMaker",local:"deploy-models-to-amazon-sagemaker",headingTag:"h1"}}),Z=new u({props:{code:"ZnJvbSUyMHNhZ2VtYWtlci5odWdnaW5nZmFjZSUyMGltcG9ydCUyMEh1Z2dpbmdGYWNlTW9kZWwlMEElMEElMjMlMjBjcmVhdGUlMjBIdWdnaW5nJTIwRmFjZSUyME1vZGVsJTIwQ2xhc3MlMjBhbmQlMjBkZXBsb3klMjBpdCUyMGFzJTIwU2FnZU1ha2VyJTIwZW5kcG9pbnQlMEFodWdnaW5nZmFjZV9tb2RlbCUyMCUzRCUyMEh1Z2dpbmdGYWNlTW9kZWwoLi4uKS5kZXBsb3koKQ==",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface <span class="hljs-keyword">import</span> HuggingFaceModel

<span class="hljs-comment"># create Hugging Face Model Class and deploy it as SageMaker endpoint</span>
huggingface_model = HuggingFaceModel(...).deploy()`,wrap:!1}}),G=new h({props:{title:"Installation and setup",local:"installation-and-setup",headingTag:"h2"}}),_=new u({props:{code:"cGlwJTIwaW5zdGFsbCUyMCdzYWdlbWFrZXIlM0MzLjAuMCc=",highlighted:'pip install <span class="hljs-string">&#x27;sagemaker&lt;3.0.0&#x27;</span>',wrap:!1}}),E=new u({props:{code:"aW1wb3J0JTIwc2FnZW1ha2VyJTBBc2VzcyUyMCUzRCUyMHNhZ2VtYWtlci5TZXNzaW9uKCklMEFyb2xlJTIwJTNEJTIwc2FnZW1ha2VyLmdldF9leGVjdXRpb25fcm9sZSgp",highlighted:`<span class="hljs-keyword">import</span> sagemaker
sess = sagemaker.Session()
role = sagemaker.get_execution_role()`,wrap:!1}}),Y=new u({props:{code:"aW1wb3J0JTIwc2FnZW1ha2VyJTBBaW1wb3J0JTIwYm90bzMlMEElMEFpYW1fY2xpZW50JTIwJTNEJTIwYm90bzMuY2xpZW50KCdpYW0nKSUwQXJvbGUlMjAlM0QlMjBpYW1fY2xpZW50LmdldF9yb2xlKFJvbGVOYW1lJTNEJ3JvbGUtbmFtZS1vZi15b3VyLWlhbS1yb2xlLXdpdGgtcmlnaHQtcGVybWlzc2lvbnMnKSU1QidSb2xlJyU1RCU1QidBcm4nJTVEJTBBc2VzcyUyMCUzRCUyMHNhZ2VtYWtlci5TZXNzaW9uKCk=",highlighted:`<span class="hljs-keyword">import</span> sagemaker
<span class="hljs-keyword">import</span> boto3

iam_client = boto3.client(<span class="hljs-string">&#x27;iam&#x27;</span>)
role = iam_client.get_role(RoleName=<span class="hljs-string">&#x27;role-name-of-your-iam-role-with-right-permissions&#x27;</span>)[<span class="hljs-string">&#x27;Role&#x27;</span>][<span class="hljs-string">&#x27;Arn&#x27;</span>]
sess = sagemaker.Session()`,wrap:!1}}),F=new h({props:{title:"Deploy a 🤗 Transformers model trained in SageMaker",local:"deploy-a--transformers-model-trained-in-sagemaker",headingTag:"h2"}}),q=new h({props:{title:"Deploy after training",local:"deploy-after-training",headingTag:"h3"}}),K=new u({props:{code:"ZnJvbSUyMHNhZ2VtYWtlci5odWdnaW5nZmFjZSUyMGltcG9ydCUyMEh1Z2dpbmdGYWNlJTBBJTBBJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIwcHNldWRvJTIwY29kZSUyMHN0YXJ0JTIwJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTBBJTBBJTIzJTIwY3JlYXRlJTIwSHVnZ2luZyUyMEZhY2UlMjBFc3RpbWF0b3IlMjBmb3IlMjB0cmFpbmluZyUwQWh1Z2dpbmdmYWNlX2VzdGltYXRvciUyMCUzRCUyMEh1Z2dpbmdGYWNlKC4uLi4pJTBBJTBBJTIzJTIwc3RhcnQlMjB0aGUlMjB0cmFpbiUyMGpvYiUyMHdpdGglMjBvdXIlMjB1cGxvYWRlZCUyMGRhdGFzZXRzJTIwYXMlMjBpbnB1dCUwQWh1Z2dpbmdmYWNlX2VzdGltYXRvci5maXQoLi4uKSUwQSUwQSUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMHBzZXVkbyUyMGNvZGUlMjBlbmQlMjAlMjMlMjMlMjMlMjMlMjMlMjMlMjMlMjMlMjMlMjMlMjMlMjMlMEElMEElMjMlMjBkZXBsb3klMjBtb2RlbCUyMHRvJTIwU2FnZU1ha2VyJTIwSW5mZXJlbmNlJTBBcHJlZGljdG9yJTIwJTNEJTIwaGZfZXN0aW1hdG9yLmRlcGxveShpbml0aWFsX2luc3RhbmNlX2NvdW50JTNEMSUyQyUyMGluc3RhbmNlX3R5cGUlM0QlMjJtbC5tNS54bGFyZ2UlMjIpJTBBJTBBJTIzJTIwZXhhbXBsZSUyMHJlcXVlc3QlM0ElMjB5b3UlMjBhbHdheXMlMjBuZWVkJTIwdG8lMjBkZWZpbmUlMjAlMjJpbnB1dHMlMjIlMEFkYXRhJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyQ2FtZXJhJTIwLSUyMFlvdSUyMGFyZSUyMGF3YXJkZWQlMjBhJTIwU2lQaXglMjBEaWdpdGFsJTIwQ2FtZXJhISUyMGNhbGwlMjAwOTA2MTIyMTA2NiUyMGZyb20lMjBsYW5kbGluZS4lMjBEZWxpdmVyeSUyMHdpdGhpbiUyMDI4JTIwZGF5cy4lMjIlMEElN0QlMEElMEElMjMlMjByZXF1ZXN0JTBBcHJlZGljdG9yLnByZWRpY3QoZGF0YSk=",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface <span class="hljs-keyword">import</span> HuggingFace

<span class="hljs-comment">############ pseudo code start ############</span>

<span class="hljs-comment"># create Hugging Face Estimator for training</span>
huggingface_estimator = HuggingFace(....)

<span class="hljs-comment"># start the train job with our uploaded datasets as input</span>
huggingface_estimator.fit(...)

<span class="hljs-comment">############ pseudo code end ############</span>

<span class="hljs-comment"># deploy model to SageMaker Inference</span>
predictor = hf_estimator.deploy(initial_instance_count=<span class="hljs-number">1</span>, instance_type=<span class="hljs-string">&quot;ml.m5.xlarge&quot;</span>)

<span class="hljs-comment"># example request: you always need to define &quot;inputs&quot;</span>
data = {
   <span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;Camera - You are awarded a SiPix Digital Camera! call 09061221066 from landline. Delivery within 28 days.&quot;</span>
}

<span class="hljs-comment"># request</span>
predictor.predict(data)`,wrap:!1}}),ee=new u({props:{code:"JTIzJTIwZGVsZXRlJTIwZW5kcG9pbnQlMEFwcmVkaWN0b3IuZGVsZXRlX2VuZHBvaW50KCk=",highlighted:`<span class="hljs-comment"># delete endpoint</span>
predictor.delete_endpoint()`,wrap:!1}}),le=new h({props:{title:"Deploy with model_data",local:"deploy-with-modeldata",headingTag:"h3"}}),se=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface.model <span class="hljs-keyword">import</span> HuggingFaceModel

<span class="hljs-comment"># create Hugging Face Model Class</span>
huggingface_model = HuggingFaceModel(
   model_data=<span class="hljs-string">&quot;s3://models/my-bert-model/model.tar.gz&quot;</span>,  <span class="hljs-comment"># path to your trained SageMaker model</span>
   role=role,                                            <span class="hljs-comment"># IAM role with permissions to create an endpoint</span>
   transformers_version=<span class="hljs-string">&quot;4.26&quot;</span>,                           <span class="hljs-comment"># Transformers version used</span>
   pytorch_version=<span class="hljs-string">&quot;1.13&quot;</span>,                                <span class="hljs-comment"># PyTorch version used</span>
   py_version=<span class="hljs-string">&#x27;py39&#x27;</span>,                                    <span class="hljs-comment"># Python version used</span>
)

<span class="hljs-comment"># deploy model to SageMaker Inference</span>
predictor = huggingface_model.deploy(
   initial_instance_count=<span class="hljs-number">1</span>,
   instance_type=<span class="hljs-string">&quot;ml.m5.xlarge&quot;</span>
)

<span class="hljs-comment"># example request: you always need to define &quot;inputs&quot;</span>
data = {
   <span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;Camera - You are awarded a SiPix Digital Camera! call 09061221066 from landline. Delivery within 28 days.&quot;</span>
}

<span class="hljs-comment"># request</span>
predictor.predict(data)`,wrap:!1}}),ae=new u({props:{code:"JTIzJTIwZGVsZXRlJTIwZW5kcG9pbnQlMEFwcmVkaWN0b3IuZGVsZXRlX2VuZHBvaW50KCk=",highlighted:`<span class="hljs-comment"># delete endpoint</span>
predictor.delete_endpoint()`,wrap:!1}}),Me=new h({props:{title:"Create a model artifact for deployment",local:"create-a-model-artifact-for-deployment",headingTag:"h3"}}),pe=new u({props:{code:"bW9kZWwudGFyLmd6JTJGJTBBJTdDLSUyMHB5dG9yY2hfbW9kZWwuYmluJTBBJTdDLSUyMHZvY2FiLnR4dCUwQSU3Qy0lMjB0b2tlbml6ZXJfY29uZmlnLmpzb24lMEElN0MtJTIwY29uZmlnLmpzb24lMEElN0MtJTIwc3BlY2lhbF90b2tlbnNfbWFwLmpzb24=",highlighted:`model.tar.gz/
|- pytorch_model.bin
|- vocab.txt
|- tokenizer_config.json
|- config.json
|- special_tokens_map.json`,wrap:!1}}),me=new u({props:{code:"Z2l0JTIweGV0JTIwaW5zdGFsbCUwQWdpdCUyMGNsb25lJTIwZ2l0JTQwaGYuY28lM0ElN0JyZXBvc2l0b3J5JTdE",highlighted:`git xet install
git <span class="hljs-built_in">clone</span> git@hf.co:{repository}`,wrap:!1}}),ce=new u({props:{code:"Y2QlMjAlN0JyZXBvc2l0b3J5JTdEJTBBdGFyJTIwemN2ZiUyMG1vZGVsLnRhci5neiUyMCo=",highlighted:`<span class="hljs-built_in">cd</span> {repository}
tar zcvf model.tar.gz *`,wrap:!1}}),ue=new u({props:{code:"YXdzJTIwczMlMjBjcCUyMG1vZGVsLnRhci5neiUyMCUzQ3MzJTNBJTJGJTJGJTdCbXktczMtcGF0aCU3RCUzRQ==",highlighted:'aws s3 <span class="hljs-built_in">cp</span> model.tar.gz &lt;s3://{my-s3-path}&gt;',wrap:!1}}),je=new h({props:{title:"Deploy a model from the 🤗 Hub",local:"deploy-a-model-from-the--hub",headingTag:"h2"}}),Je=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface.model <span class="hljs-keyword">import</span> HuggingFaceModel

<span class="hljs-comment"># Hub model configuration &lt;https://huggingface.co/models&gt;</span>
hub = {
  <span class="hljs-string">&#x27;HF_MODEL_ID&#x27;</span>:<span class="hljs-string">&#x27;distilbert-base-uncased-distilled-squad&#x27;</span>, <span class="hljs-comment"># model_id from hf.co/models</span>
  <span class="hljs-string">&#x27;HF_TASK&#x27;</span>:<span class="hljs-string">&#x27;question-answering&#x27;</span>                           <span class="hljs-comment"># NLP task you want to use for predictions</span>
}

<span class="hljs-comment"># create Hugging Face Model Class</span>
huggingface_model = HuggingFaceModel(
   env=hub,                                                <span class="hljs-comment"># configuration for loading model from Hub</span>
   role=role,                                              <span class="hljs-comment"># IAM role with permissions to create an endpoint</span>
   transformers_version=<span class="hljs-string">&quot;4.26&quot;</span>,                             <span class="hljs-comment"># Transformers version used</span>
   pytorch_version=<span class="hljs-string">&quot;1.13&quot;</span>,                                  <span class="hljs-comment"># PyTorch version used</span>
   py_version=<span class="hljs-string">&#x27;py39&#x27;</span>,                                      <span class="hljs-comment"># Python version used</span>
)

<span class="hljs-comment"># deploy model to SageMaker Inference</span>
predictor = huggingface_model.deploy(
   initial_instance_count=<span class="hljs-number">1</span>,
   instance_type=<span class="hljs-string">&quot;ml.m5.xlarge&quot;</span>
)

<span class="hljs-comment"># example request: you always need to define &quot;inputs&quot;</span>
data = {
<span class="hljs-string">&quot;inputs&quot;</span>: {
	<span class="hljs-string">&quot;question&quot;</span>: <span class="hljs-string">&quot;What is used for inference?&quot;</span>,
	<span class="hljs-string">&quot;context&quot;</span>: <span class="hljs-string">&quot;My Name is Philipp and I live in Nuremberg. This model is used with sagemaker for inference.&quot;</span>
	}
}

<span class="hljs-comment"># request</span>
predictor.predict(data)`,wrap:!1}}),be=new u({props:{code:"JTIzJTIwZGVsZXRlJTIwZW5kcG9pbnQlMEFwcmVkaWN0b3IuZGVsZXRlX2VuZHBvaW50KCk=",highlighted:`<span class="hljs-comment"># delete endpoint</span>
predictor.delete_endpoint()`,wrap:!1}}),Ie=new h({props:{title:"Run batch transform with 🤗 Transformers and SageMaker",local:"run-batch-transform-with--transformers-and-sagemaker",headingTag:"h2"}}),Ge=new u({props:{code:"YmF0Y2hfam9iJTIwJTNEJTIwaHVnZ2luZ2ZhY2VfZXN0aW1hdG9yLnRyYW5zZm9ybWVyKCUwQSUyMCUyMCUyMCUyMGluc3RhbmNlX2NvdW50JTNEMSUyQyUwQSUyMCUyMCUyMCUyMGluc3RhbmNlX3R5cGUlM0QnbWwucDMuMnhsYXJnZSclMkMlMEElMjAlMjAlMjAlMjBzdHJhdGVneSUzRCdTaW5nbGVSZWNvcmQnKSUwQSUwQSUwQWJhdGNoX2pvYi50cmFuc2Zvcm0oJTBBJTIwJTIwJTIwJTIwZGF0YSUzRCdzMyUzQSUyRiUyRnMzLXVyaS10by1iYXRjaC1kYXRhJyUyQyUwQSUyMCUyMCUyMCUyMGNvbnRlbnRfdHlwZSUzRCdhcHBsaWNhdGlvbiUyRmpzb24nJTJDJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwc3BsaXRfdHlwZSUzRCdMaW5lJyk=",highlighted:`batch_job = huggingface_estimator.transformer(
    instance_count=<span class="hljs-number">1</span>,
    instance_type=<span class="hljs-string">&#x27;ml.p3.2xlarge&#x27;</span>,
    strategy=<span class="hljs-string">&#x27;SingleRecord&#x27;</span>)


batch_job.transform(
    data=<span class="hljs-string">&#x27;s3://s3-uri-to-batch-data&#x27;</span>,
    content_type=<span class="hljs-string">&#x27;application/json&#x27;</span>,    
    split_type=<span class="hljs-string">&#x27;Line&#x27;</span>)`,wrap:!1}}),Ae=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface.model <span class="hljs-keyword">import</span> HuggingFaceModel

<span class="hljs-comment"># Hub model configuration &lt;https://huggingface.co/models&gt;</span>
hub = {
	<span class="hljs-string">&#x27;HF_MODEL_ID&#x27;</span>:<span class="hljs-string">&#x27;distilbert/distilbert-base-uncased-finetuned-sst-2-english&#x27;</span>,
	<span class="hljs-string">&#x27;HF_TASK&#x27;</span>:<span class="hljs-string">&#x27;text-classification&#x27;</span>
}

<span class="hljs-comment"># create Hugging Face Model Class</span>
huggingface_model = HuggingFaceModel(
   env=hub,                                                <span class="hljs-comment"># configuration for loading model from Hub</span>
   role=role,                                              <span class="hljs-comment"># IAM role with permissions to create an endpoint</span>
   transformers_version=<span class="hljs-string">&quot;4.26&quot;</span>,                             <span class="hljs-comment"># Transformers version used</span>
   pytorch_version=<span class="hljs-string">&quot;1.13&quot;</span>,                                  <span class="hljs-comment"># PyTorch version used</span>
   py_version=<span class="hljs-string">&#x27;py39&#x27;</span>,                                      <span class="hljs-comment"># Python version used</span>
)

<span class="hljs-comment"># create transformer to run a batch job</span>
batch_job = huggingface_model.transformer(
    instance_count=<span class="hljs-number">1</span>,
    instance_type=<span class="hljs-string">&#x27;ml.p3.2xlarge&#x27;</span>,
    strategy=<span class="hljs-string">&#x27;SingleRecord&#x27;</span>
)

<span class="hljs-comment"># starts batch transform job and uses S3 data as input</span>
batch_job.transform(
    data=<span class="hljs-string">&#x27;s3://sagemaker-s3-demo-test/samples/input.jsonl&#x27;</span>,
    content_type=<span class="hljs-string">&#x27;application/json&#x27;</span>,    
    split_type=<span class="hljs-string">&#x27;Line&#x27;</span>
)`,wrap:!1}}),$e=new u({props:{code:"JTdCJTIyaW5wdXRzJTIyJTNBJTIydGhpcyUyMG1vdmllJTIwaXMlMjB0ZXJyaWJsZSUyMiU3RCUwQSU3QiUyMmlucHV0cyUyMiUzQSUyMnRoaXMlMjBtb3ZpZSUyMGlzJTIwYW1hemluZyUyMiU3RCUwQSU3QiUyMmlucHV0cyUyMiUzQSUyMlNhZ2VNYWtlciUyMGlzJTIwcHJldHR5JTIwY29vbCUyMiU3RCUwQSU3QiUyMmlucHV0cyUyMiUzQSUyMlNhZ2VNYWtlciUyMGlzJTIwcHJldHR5JTIwY29vbCUyMiU3RCUwQSU3QiUyMmlucHV0cyUyMiUzQSUyMnRoaXMlMjBtb3ZpZSUyMGlzJTIwdGVycmlibGUlMjIlN0QlMEElN0IlMjJpbnB1dHMlMjIlM0ElMjJ0aGlzJTIwbW92aWUlMjBpcyUyMGFtYXppbmclMjIlN0Q=",highlighted:`<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span><span class="hljs-string">&quot;this movie is terrible&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span><span class="hljs-string">&quot;this movie is amazing&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span><span class="hljs-string">&quot;SageMaker is pretty cool&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span><span class="hljs-string">&quot;SageMaker is pretty cool&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span><span class="hljs-string">&quot;this movie is terrible&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span><span class="hljs-string">&quot;this movie is amazing&quot;</span><span class="hljs-punctuation">}</span>`,wrap:!1}}),_e=new h({props:{title:"Deploy an LLM to SageMaker using TGI",local:"deploy-an-llm-to-sagemaker-using-tgi",headingTag:"h2"}}),xe=new u({props:{code:"cGlwJTIwaW5zdGFsbCUyMHNhZ2VtYWtlciUzRSUzRDIuMjMxLjA=",highlighted:"pip install sagemaker&gt;=2.231.0",wrap:!1}}),Ve=new u({props:{code:"aW1wb3J0JTIwc2FnZW1ha2VyJTBBZnJvbSUyMHNhZ2VtYWtlci5odWdnaW5nZmFjZSUyMGltcG9ydCUyMEh1Z2dpbmdGYWNlTW9kZWwlMkMlMjBnZXRfaHVnZ2luZ2ZhY2VfbGxtX2ltYWdlX3VyaSUwQWltcG9ydCUyMHRpbWUlMEElMEFzYWdlbWFrZXJfc2Vzc2lvbiUyMCUzRCUyMHNhZ2VtYWtlci5TZXNzaW9uKCklMEFyZWdpb24lMjAlM0QlMjBzYWdlbWFrZXJfc2Vzc2lvbi5ib3RvX3JlZ2lvbl9uYW1lJTBBcm9sZSUyMCUzRCUyMHNhZ2VtYWtlci5nZXRfZXhlY3V0aW9uX3JvbGUoKQ==",highlighted:`<span class="hljs-keyword">import</span> sagemaker
<span class="hljs-keyword">from</span> sagemaker.huggingface <span class="hljs-keyword">import</span> HuggingFaceModel, get_huggingface_llm_image_uri
<span class="hljs-keyword">import</span> time

sagemaker_session = sagemaker.Session()
region = sagemaker_session.boto_region_name
role = sagemaker.get_execution_role()`,wrap:!1}}),Ne=new u({props:{code:"aW1hZ2VfdXJpJTIwJTNEJTIwZ2V0X2h1Z2dpbmdmYWNlX2xsbV9pbWFnZV91cmkoJTBBJTIwJTIwYmFja2VuZCUzRCUyMmh1Z2dpbmdmYWNlJTIyJTJDJTBBJTIwJTIwcmVnaW9uJTNEcmVnaW9uJTBBKQ==",highlighted:`image_uri = get_huggingface_llm_image_uri(
  backend=<span class="hljs-string">&quot;huggingface&quot;</span>,
  region=region
)`,wrap:!1}}),Qe=new u({props:{code:"bW9kZWxfbmFtZSUyMCUzRCUyMCUyMmxsYW1hLTMtMS04Yi1pbnN0cnVjdCUyMiUyMCUyQiUyMHRpbWUuc3RyZnRpbWUoJTIyJTI1WS0lMjVtLSUyNWQtJTI1SC0lMjVNLSUyNVMlMjIlMkMlMjB0aW1lLmdtdGltZSgpKSUwQSUwQWh1YiUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCdIRl9NT0RFTF9JRCclM0EnbWV0YS1sbGFtYSUyRkxsYW1hLTMuMS04Qi1JbnN0cnVjdCclMkMlMEElMjAlMjAlMjAlMjAnU01fTlVNX0dQVVMnJTNBJzEnJTJDJTBBJTA5J0hVR0dJTkdfRkFDRV9IVUJfVE9LRU4nJTNBJTIwJyUzQ1JFUExBQ0UlMjBXSVRIJTIwWU9VUiUyMFRPS0VOJTNFJyUyQyUwQSU3RCUwQSUwQWFzc2VydCUyMGh1YiU1QidIVUdHSU5HX0ZBQ0VfSFVCX1RPS0VOJyU1RCUyMCElM0QlMjAnJTNDUkVQTEFDRSUyMFdJVEglMjBZT1VSJTIwVE9LRU4lM0UnJTJDJTIwJTIyWW91JTIwaGF2ZSUyMHRvJTIwcHJvdmlkZSUyMGElMjB0b2tlbi4lMjIlMEElMEElMEFtb2RlbCUyMCUzRCUyMEh1Z2dpbmdGYWNlTW9kZWwoJTBBJTIwJTIwJTIwJTIwbmFtZSUzRG1vZGVsX25hbWUlMkMlMEElMjAlMjAlMjAlMjBlbnYlM0RodWIlMkMlMEElMjAlMjAlMjAlMjByb2xlJTNEcm9sZSUyQyUwQSUyMCUyMCUyMCUyMGltYWdlX3VyaSUzRGltYWdlX3VyaSUwQSk=",highlighted:`model_name = <span class="hljs-string">&quot;llama-3-1-8b-instruct&quot;</span> + time.strftime(<span class="hljs-string">&quot;%Y-%m-%d-%H-%M-%S&quot;</span>, time.gmtime())

hub = {
    <span class="hljs-string">&#x27;HF_MODEL_ID&#x27;</span>:<span class="hljs-string">&#x27;meta-llama/Llama-3.1-8B-Instruct&#x27;</span>,
    <span class="hljs-string">&#x27;SM_NUM_GPUS&#x27;</span>:<span class="hljs-string">&#x27;1&#x27;</span>,
	<span class="hljs-string">&#x27;HUGGING_FACE_HUB_TOKEN&#x27;</span>: <span class="hljs-string">&#x27;&lt;REPLACE WITH YOUR TOKEN&gt;&#x27;</span>,
}

<span class="hljs-keyword">assert</span> hub[<span class="hljs-string">&#x27;HUGGING_FACE_HUB_TOKEN&#x27;</span>] != <span class="hljs-string">&#x27;&lt;REPLACE WITH YOUR TOKEN&gt;&#x27;</span>, <span class="hljs-string">&quot;You have to provide a token.&quot;</span>


model = HuggingFaceModel(
    name=model_name,
    env=hub,
    role=role,
    image_uri=image_uri
)`,wrap:!1}}),qe=new u({props:{code:"cHJlZGljdG9yJTIwJTNEJTIwbW9kZWwuZGVwbG95KCUwQSUyMCUyMGluaXRpYWxfaW5zdGFuY2VfY291bnQlM0QxJTJDJTBBJTIwJTIwaW5zdGFuY2VfdHlwZSUzRCUyMm1sLmc1LjJ4bGFyZ2UlMjIlMkMlMEElMjAlMjBlbmRwb2ludF9uYW1lJTNEbW9kZWxfbmFtZSUwQSk=",highlighted:`predictor = model.deploy(
  initial_instance_count=<span class="hljs-number">1</span>,
  instance_type=<span class="hljs-string">&quot;ml.g5.2xlarge&quot;</span>,
  endpoint_name=model_name
)`,wrap:!1}}),De=new u({props:{code:"aW5wdXRfZGF0YSUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMmlucHV0cyUyMiUzQSUyMCUyMlRoZSUyMGRpYW1vbmRiYWNrJTIwdGVycmFwaW4lMjB3YXMlMjB0aGUlMjBmaXJzdCUyMHJlcHRpbGUlMjB0byUyMiUyQyUwQSUyMCUyMCUyMnBhcmFtZXRlcnMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJkb19zYW1wbGUlMjIlM0ElMjBUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIybWF4X25ld190b2tlbnMlMjIlM0ElMjAxMDAlMkMlMEElMjAlMjAlMjAlMjAlMjJ0ZW1wZXJhdHVyZSUyMiUzQSUyMDAuNyUyQyUwQSUyMCUyMCUyMCUyMCUyMndhdGVybWFyayUyMiUzQSUyMFRydWUlMEElMjAlMjAlN0QlMEElN0QlMEElMEFwcmVkaWN0b3IucHJlZGljdChpbnB1dF9kYXRhKQ==",highlighted:`input_data = {
  <span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;The diamondback terrapin was the first reptile to&quot;</span>,
  <span class="hljs-string">&quot;parameters&quot;</span>: {
    <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">True</span>,
    <span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">100</span>,
    <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.7</span>,
    <span class="hljs-string">&quot;watermark&quot;</span>: <span class="hljs-literal">True</span>
  }
}

predictor.predict(input_data)`,wrap:!1}}),Oe=new u({props:{code:"JTVCJTdCJ2dlbmVyYXRlZF90ZXh0JyUzQSUyMCdUaGUlMjBkaWFtb25kYmFjayUyMHRlcnJhcGluJTIwd2FzJTIwdGhlJTIwZmlyc3QlMjByZXB0aWxlJTIwdG8lMjBtYWtlJTIwdGhlJTIwbGlzdCUyQyUyMGZvbGxvd2VkJTIwYnklMjB0aGUlMjBBbWVyaWNhbiUyMGFsbGlnYXRvciUyQyUyMHRoZSUyMEFtZXJpY2FuJTIwY3JvY29kaWxlJTJDJTIwYW5kJTIwdGhlJTIwQW1lcmljYW4lMjBib3glMjB0dXJ0bGUuJTIwVGhlJTIwcG9sZWNhdCUyQyUyMGElMjBmZXJyZXQtbGlrZSUyMGFuaW1hbCUyQyUyMGFuZCUyMHRoZSUyMHNrdW5rJTIwcm91bmRlZCUyMG91dCUyMHRoZSUyMGxpc3QlMkMlMjBib3RoJTIwaGF2aW5nJTIwZ2FpbmVkJTIwdGhlaXIlMjBzbG90cyUyMGJlY2F1c2UlMjB0aGV5JTIwaGF2ZSUyMHByb3ZlbiUyMHRvJTIwYmUlMjBwYXJ0aWN1bGFybHklMjBkYW5nZXJvdXMlMjB0byUyMGh1bWFucy4lNUNuJTVDbkNhbGlmb3JuaWFucyUyMGFsc28lMjBzZWVtZWQlMjB0byUyMGFwcHJlY2lhdGUlMjB0aGUlMjBuZXclMjBsaXN0JTJDJTIwanVkZ2luZyUyMGJ5JTIwdGhlJTIwY29tbWVudHMlMjBsZWZ0JTIwYWZ0ZXIlMjB0aGUlMjBlbGVjdGlvbi4lNUNuJTVDbiVFMiU4MCU5Q1RoaXMlMjBpcyUyMGZhbnRhc3RpYyUyQyVFMiU4MCU5RCUyMG9uZSUyMGNvbW1lbnRlciUyMGRlY2xhcmVkLiU1Q24lNUNuJUUyJTgwJTlDQ2FsaWZvcm5pYSUyMGlzJTIwYSUyMHZlcnknJTdEJTVE",highlighted:'[{<span class="hljs-string">&#x27;generated_text&#x27;</span>: <span class="hljs-string">&#x27;The diamondback terrapin was the first reptile to make the list, followed by the American alligator, the American crocodile, and the American box turtle. The polecat, a ferret-like animal, and the skunk rounded out the list, both having gained their slots because they have proven to be particularly dangerous to humans.\\n\\nCalifornians also seemed to appreciate the new list, judging by the comments left after the election.\\n\\n“This is fantastic,” one commenter declared.\\n\\n“California is a very&#x27;</span>}]',wrap:!1}}),ll=new u({props:{code:"cHJlZGljdG9yLmRlbGV0ZV9tb2RlbCgpJTBBcHJlZGljdG9yLmRlbGV0ZV9lbmRwb2ludCgp",highlighted:`predictor.delete_model()
predictor.delete_endpoint()`,wrap:!1}}),tl=new h({props:{title:"User defined code and modules",local:"user-defined-code-and-modules",headingTag:"h2"}}),nl=new u({props:{code:"bW9kZWwudGFyLmd6JTJGJTBBJTdDLSUyMHB5dG9yY2hfbW9kZWwuYmluJTBBJTdDLSUyMC4uLi4lMEElN0MtJTIwY29kZSUyRiUwQSUyMCUyMCU3Qy0lMjBpbmZlcmVuY2UucHklMEElMjAlMjAlN0MtJTIwcmVxdWlyZW1lbnRzLnR4dCUyMA==",highlighted:`model.tar.gz/
|- pytorch_model.bin
|- ....
|- code/
  |- inference.py
  |- requirements.txt `,wrap:!1}}),il=new u({props:{code:"ZnJvbSUyMHNhZ2VtYWtlcl9odWdnaW5nZmFjZV9pbmZlcmVuY2VfdG9vbGtpdCUyMGltcG9ydCUyMGRlY29kZXJfZW5jb2RlciUwQSUwQWRlZiUyMG1vZGVsX2ZuKG1vZGVsX2RpciklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBpbXBsZW1lbnQlMjBjdXN0b20lMjBjb2RlJTIwdG8lMjBsb2FkJTIwdGhlJTIwbW9kZWwlMEElMjAlMjAlMjAlMjBsb2FkZWRfbW9kZWwlMjAlM0QlMjAuLi4lMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBsb2FkZWRfbW9kZWwlMjAlMEElMEFkZWYlMjBpbnB1dF9mbihpbnB1dF9kYXRhJTJDJTIwY29udGVudF90eXBlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMGRlY29kZSUyMHRoZSUyMGlucHV0JTIwZGF0YSUyMCUyMChlLmcuJTIwSlNPTiUyMHN0cmluZyUyMC0lM0UlMjBkaWN0KSUwQSUyMCUyMCUyMCUyMGRhdGElMjAlM0QlMjBkZWNvZGVyX2VuY29kZXIuZGVjb2RlKGlucHV0X2RhdGElMkMlMjBjb250ZW50X3R5cGUpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZGF0YSUwQSUwQWRlZiUyMHByZWRpY3RfZm4oZGF0YSUyQyUyMG1vZGVsKSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMGNhbGwlMjB5b3VyJTIwY3VzdG9tJTIwbW9kZWwlMjB3aXRoJTIwdGhlJTIwZGF0YSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbChkYXRhJTIwJTJDJTIwLi4uJTIwKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHByZWRpY3Rpb25zJTBBJTBBZGVmJTIwb3V0cHV0X2ZuKHByZWRpY3Rpb24lMkMlMjBhY2NlcHQpJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwY29udmVydCUyMHRoZSUyMG1vZGVsJTIwb3V0cHV0JTIwdG8lMjB0aGUlMjBkZXNpcmVkJTIwb3V0cHV0JTIwZm9ybWF0JTIwKGUuZy4lMjBkaWN0JTIwLSUzRSUyMEpTT04lMjBzdHJpbmcpJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjBkZWNvZGVyX2VuY29kZXIuZW5jb2RlKHByZWRpY3Rpb24lMkMlMjBhY2NlcHQpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwcmVzcG9uc2U=",highlighted:`<span class="hljs-keyword">from</span> sagemaker_huggingface_inference_toolkit <span class="hljs-keyword">import</span> decoder_encoder

<span class="hljs-keyword">def</span> <span class="hljs-title function_">model_fn</span>(<span class="hljs-params">model_dir</span>):
    <span class="hljs-comment"># implement custom code to load the model</span>
    loaded_model = ...
    
    <span class="hljs-keyword">return</span> loaded_model 

<span class="hljs-keyword">def</span> <span class="hljs-title function_">input_fn</span>(<span class="hljs-params">input_data, content_type</span>):
    <span class="hljs-comment"># decode the input data  (e.g. JSON string -&gt; dict)</span>
    data = decoder_encoder.decode(input_data, content_type)
    <span class="hljs-keyword">return</span> data

<span class="hljs-keyword">def</span> <span class="hljs-title function_">predict_fn</span>(<span class="hljs-params">data, model</span>):
    <span class="hljs-comment"># call your custom model with the data</span>
    outputs = model(data , ... )
    <span class="hljs-keyword">return</span> predictions

<span class="hljs-keyword">def</span> <span class="hljs-title function_">output_fn</span>(<span class="hljs-params">prediction, accept</span>):
    <span class="hljs-comment"># convert the model output to the desired output format (e.g. dict -&gt; JSON string)</span>
    response = decoder_encoder.encode(prediction, accept)
    <span class="hljs-keyword">return</span> response`,wrap:!1}}),pl=new u({props:{code:"ZnJvbSUyMHNhZ2VtYWtlcl9odWdnaW5nZmFjZV9pbmZlcmVuY2VfdG9vbGtpdCUyMGltcG9ydCUyMGRlY29kZXJfZW5jb2RlciUwQSUwQWRlZiUyMG1vZGVsX2ZuKG1vZGVsX2RpciklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBpbXBsZW1lbnQlMjBjdXN0b20lMjBjb2RlJTIwdG8lMjBsb2FkJTIwdGhlJTIwbW9kZWwlMEElMjAlMjAlMjAlMjBsb2FkZWRfbW9kZWwlMjAlM0QlMjAuLi4lMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBsb2FkZWRfbW9kZWwlMjAlMEElMEFkZWYlMjB0cmFuc2Zvcm1fZm4obW9kZWwlMkMlMjBpbnB1dF9kYXRhJTJDJTIwY29udGVudF90eXBlJTJDJTIwYWNjZXB0KSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMyUyMGRlY29kZSUyMHRoZSUyMGlucHV0JTIwZGF0YSUyMChlLmcuJTIwSlNPTiUyMHN0cmluZyUyMC0lM0UlMjBkaWN0KSUwQSUyMCUyMCUyMCUyMGRhdGElMjAlM0QlMjBkZWNvZGVyX2VuY29kZXIuZGVjb2RlKGlucHV0X2RhdGElMkMlMjBjb250ZW50X3R5cGUpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwY2FsbCUyMHlvdXIlMjBjdXN0b20lMjBtb2RlbCUyMHdpdGglMjB0aGUlMjBkYXRhJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGRhdGElMjAlMkMlMjAuLi4lMjApJTIwJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwY29udmVydCUyMHRoZSUyMG1vZGVsJTIwb3V0cHV0JTIwdG8lMjB0aGUlMjBkZXNpcmVkJTIwb3V0cHV0JTIwZm9ybWF0JTIwKGUuZy4lMjBkaWN0JTIwLSUzRSUyMEpTT04lMjBzdHJpbmcpJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjBkZWNvZGVyX2VuY29kZXIuZW5jb2RlKG91dHB1dCUyQyUyMGFjY2VwdCklMEElMEElMjAlMjAlMjAlMjByZXR1cm4lMjByZXNwb25zZQ==",highlighted:`<span class="hljs-keyword">from</span> sagemaker_huggingface_inference_toolkit <span class="hljs-keyword">import</span> decoder_encoder

<span class="hljs-keyword">def</span> <span class="hljs-title function_">model_fn</span>(<span class="hljs-params">model_dir</span>):
    <span class="hljs-comment"># implement custom code to load the model</span>
    loaded_model = ...
    
    <span class="hljs-keyword">return</span> loaded_model 

<span class="hljs-keyword">def</span> <span class="hljs-title function_">transform_fn</span>(<span class="hljs-params">model, input_data, content_type, accept</span>):
     <span class="hljs-comment"># decode the input data (e.g. JSON string -&gt; dict)</span>
    data = decoder_encoder.decode(input_data, content_type)

    <span class="hljs-comment"># call your custom model with the data</span>
    outputs = model(data , ... ) 

    <span class="hljs-comment"># convert the model output to the desired output format (e.g. dict -&gt; JSON string)</span>
    response = decoder_encoder.encode(output, accept)

    <span class="hljs-keyword">return</span> response`,wrap:!1}}),yl=new Bn({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/sagemaker/source/tutorials/sagemaker-sdk/deploy-sagemaker-sdk.md"}}),{c(){J=M("meta"),ul=n(),dl=M("p"),Ul=n(),r(g.$$.fragment),jl=n(),r(I.$$.fragment),Tl=n(),C=M("p"),C.textContent=ms,wl=n(),r(Z.$$.fragment),hl=n(),k=M("p"),k.innerHTML=cs,Jl=n(),B=M("ul"),B.innerHTML=us,fl=n(),r(G.$$.fragment),bl=n(),W=M("p"),W.innerHTML=Us,gl=n(),A=M("p"),A.textContent=js,Il=n(),v=M("ul"),v.innerHTML=Ts,Cl=n(),$=M("p"),$.innerHTML=ws,Zl=n(),S=M("p"),S.innerHTML=hs,kl=n(),r(_.$$.fragment),Bl=n(),H=M("blockquote"),H.innerHTML=Js,Gl=n(),R=M("p"),R.innerHTML=fs,Wl=n(),x=M("p"),x.textContent=bs,Al=n(),r(E.$$.fragment),vl=n(),V=M("p"),V.innerHTML=gs,$l=n(),z=M("p"),z.innerHTML=Is,Sl=n(),N=M("p"),N.textContent=Cs,_l=n(),r(Y.$$.fragment),Hl=n(),r(F.$$.fragment),Rl=n(),j=M("iframe"),xl=n(),X=M("p"),X.textContent=ks,El=n(),Q=M("ul"),Q.innerHTML=Bs,Vl=n(),L=M("p"),L.innerHTML=Gs,zl=n(),r(q.$$.fragment),Nl=n(),P=M("p"),P.textContent=Ws,Yl=n(),D=M("p"),D.innerHTML=As,Fl=n(),r(K.$$.fragment),Xl=n(),O=M("p"),O.textContent=vs,Ql=n(),r(ee.$$.fragment),Ll=n(),r(le.$$.fragment),ql=n(),te=M("p"),te.innerHTML=$s,Pl=n(),r(se.$$.fragment),Dl=n(),ne=M("p"),ne.textContent=Ss,Kl=n(),r(ae.$$.fragment),Ol=n(),r(Me.$$.fragment),et=n(),oe=M("p"),oe.innerHTML=_s,lt=n(),ie=M("ul"),ie.innerHTML=Hs,tt=n(),re=M("p"),re.textContent=Rs,st=n(),r(pe.$$.fragment),nt=n(),ye=M("p"),ye.innerHTML=xs,at=n(),de=M("ol"),de.innerHTML=Es,Mt=n(),r(me.$$.fragment),ot=n(),f=M("ol"),f.innerHTML=Vs,it=n(),r(ce.$$.fragment),rt=n(),b=M("ol"),b.innerHTML=zs,pt=n(),r(ue.$$.fragment),yt=n(),Ue=M("p"),Ue.innerHTML=Ns,dt=n(),r(je.$$.fragment),mt=n(),T=M("iframe"),ct=n(),Te=M("p"),Te.innerHTML=Fs,ut=n(),we=M("ul"),we.innerHTML=Xs,Ut=n(),he=M("blockquote"),he.innerHTML=Qs,jt=n(),r(Je.$$.fragment),Tt=n(),fe=M("p"),fe.textContent=Ls,wt=n(),r(be.$$.fragment),ht=n(),ge=M("p"),ge.innerHTML=qs,Jt=n(),r(Ie.$$.fragment),ft=n(),w=M("iframe"),bt=n(),Ce=M("p"),Ce.innerHTML=Ds,gt=n(),Ze=M("p"),Ze.innerHTML=Ks,It=n(),ke=M("p"),ke.innerHTML=Os,Ct=n(),Be=M("p"),Be.innerHTML=en,Zt=n(),r(Ge.$$.fragment),kt=n(),We=M("p"),We.innerHTML=ln,Bt=n(),r(Ae.$$.fragment),Gt=n(),ve=M("p"),ve.innerHTML=tn,Wt=n(),r($e.$$.fragment),At=n(),Se=M("p"),Se.innerHTML=sn,vt=n(),r(_e.$$.fragment),$t=n(),He=M("p"),He.innerHTML=nn,St=n(),Re=M("p"),Re.textContent=an,_t=n(),r(xe.$$.fragment),Ht=n(),Ee=M("p"),Ee.textContent=Mn,Rt=n(),r(Ve.$$.fragment),xt=n(),ze=M("p"),ze.textContent=on,Et=n(),r(Ne.$$.fragment),Vt=n(),Ye=M("p"),Ye.innerHTML=rn,zt=n(),Fe=M("p"),Fe.innerHTML=pn,Nt=n(),Xe=M("p"),Xe.innerHTML=yn,Yt=n(),r(Qe.$$.fragment),Ft=n(),Le=M("p"),Le.textContent=dn,Xt=n(),r(qe.$$.fragment),Qt=n(),Pe=M("p"),Pe.textContent=mn,Lt=n(),r(De.$$.fragment),qt=n(),Ke=M("p"),Ke.textContent=cn,Pt=n(),r(Oe.$$.fragment),Dt=n(),el=M("p"),el.textContent=un,Kt=n(),r(ll.$$.fragment),Ot=n(),r(tl.$$.fragment),es=n(),sl=M("p"),sl.innerHTML=Un,ls=n(),r(nl.$$.fragment),ts=n(),al=M("p"),al.innerHTML=jn,ss=n(),Ml=M("ul"),Ml.innerHTML=Tn,ns=n(),ol=M("p"),ol.innerHTML=wn,as=n(),r(il.$$.fragment),Ms=n(),rl=M("p"),rl.innerHTML=hn,os=n(),r(pl.$$.fragment),is=n(),r(yl.$$.fragment),rs=n(),ml=M("p"),this.h()},l(e){const l=Cn("svelte-u9bgzb",document.head);J=o(l,"META",{name:!0,content:!0}),l.forEach(t),ul=a(e),dl=o(e,"P",{}),cl(dl).forEach(t),Ul=a(e),p(g.$$.fragment,e),jl=a(e),p(I.$$.fragment,e),Tl=a(e),C=o(e,"P",{"data-svelte-h":!0}),i(C)!=="svelte-ywypfi"&&(C.textContent=ms),wl=a(e),p(Z.$$.fragment,e),hl=a(e),k=o(e,"P",{"data-svelte-h":!0}),i(k)!=="svelte-lx9xk7"&&(k.innerHTML=cs),Jl=a(e),B=o(e,"UL",{"data-svelte-h":!0}),i(B)!=="svelte-lmxuwx"&&(B.innerHTML=us),fl=a(e),p(G.$$.fragment,e),bl=a(e),W=o(e,"P",{"data-svelte-h":!0}),i(W)!=="svelte-uia7yx"&&(W.innerHTML=Us),gl=a(e),A=o(e,"P",{"data-svelte-h":!0}),i(A)!=="svelte-14pz1nf"&&(A.textContent=js),Il=a(e),v=o(e,"UL",{"data-svelte-h":!0}),i(v)!=="svelte-nu9uzs"&&(v.innerHTML=Ts),Cl=a(e),$=o(e,"P",{"data-svelte-h":!0}),i($)!=="svelte-10vylvb"&&($.innerHTML=ws),Zl=a(e),S=o(e,"P",{"data-svelte-h":!0}),i(S)!=="svelte-183wm56"&&(S.innerHTML=hs),kl=a(e),p(_.$$.fragment,e),Bl=a(e),H=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),i(H)!=="svelte-p7runb"&&(H.innerHTML=Js),Gl=a(e),R=o(e,"P",{"data-svelte-h":!0}),i(R)!=="svelte-aqpf90"&&(R.innerHTML=fs),Wl=a(e),x=o(e,"P",{"data-svelte-h":!0}),i(x)!=="svelte-1n86nit"&&(x.textContent=bs),Al=a(e),p(E.$$.fragment,e),vl=a(e),V=o(e,"P",{"data-svelte-h":!0}),i(V)!=="svelte-bmcgfj"&&(V.innerHTML=gs),$l=a(e),z=o(e,"P",{"data-svelte-h":!0}),i(z)!=="svelte-12o7543"&&(z.innerHTML=Is),Sl=a(e),N=o(e,"P",{"data-svelte-h":!0}),i(N)!=="svelte-qjt50s"&&(N.textContent=Cs),_l=a(e),p(Y.$$.fragment,e),Hl=a(e),p(F.$$.fragment,e),Rl=a(e),j=o(e,"IFRAME",{width:!0,height:!0,src:!0,title:!0,frameborder:!0,allow:!0}),cl(j).forEach(t),xl=a(e),X=o(e,"P",{"data-svelte-h":!0}),i(X)!=="svelte-gux9y"&&(X.textContent=ks),El=a(e),Q=o(e,"UL",{"data-svelte-h":!0}),i(Q)!=="svelte-g9t1l6"&&(Q.innerHTML=Bs),Vl=a(e),L=o(e,"P",{"data-svelte-h":!0}),i(L)!=="svelte-1kzoo7i"&&(L.innerHTML=Gs),zl=a(e),p(q.$$.fragment,e),Nl=a(e),P=o(e,"P",{"data-svelte-h":!0}),i(P)!=="svelte-1bnjjtb"&&(P.textContent=Ws),Yl=a(e),D=o(e,"P",{"data-svelte-h":!0}),i(D)!=="svelte-qrjq9z"&&(D.innerHTML=As),Fl=a(e),p(K.$$.fragment,e),Xl=a(e),O=o(e,"P",{"data-svelte-h":!0}),i(O)!=="svelte-1704hsx"&&(O.textContent=vs),Ql=a(e),p(ee.$$.fragment,e),Ll=a(e),p(le.$$.fragment,e),ql=a(e),te=o(e,"P",{"data-svelte-h":!0}),i(te)!=="svelte-xplu1m"&&(te.innerHTML=$s),Pl=a(e),p(se.$$.fragment,e),Dl=a(e),ne=o(e,"P",{"data-svelte-h":!0}),i(ne)!=="svelte-10df72h"&&(ne.textContent=Ss),Kl=a(e),p(ae.$$.fragment,e),Ol=a(e),p(Me.$$.fragment,e),et=a(e),oe=o(e,"P",{"data-svelte-h":!0}),i(oe)!=="svelte-1bx7pn1"&&(oe.innerHTML=_s),lt=a(e),ie=o(e,"UL",{"data-svelte-h":!0}),i(ie)!=="svelte-1yevczk"&&(ie.innerHTML=Hs),tt=a(e),re=o(e,"P",{"data-svelte-h":!0}),i(re)!=="svelte-1fj2qwz"&&(re.textContent=Rs),st=a(e),p(pe.$$.fragment,e),nt=a(e),ye=o(e,"P",{"data-svelte-h":!0}),i(ye)!=="svelte-6vx79s"&&(ye.innerHTML=xs),at=a(e),de=o(e,"OL",{"data-svelte-h":!0}),i(de)!=="svelte-1oe4mbx"&&(de.innerHTML=Es),Mt=a(e),p(me.$$.fragment,e),ot=a(e),f=o(e,"OL",{start:!0,"data-svelte-h":!0}),i(f)!=="svelte-1dpsw5r"&&(f.innerHTML=Vs),it=a(e),p(ce.$$.fragment,e),rt=a(e),b=o(e,"OL",{start:!0,"data-svelte-h":!0}),i(b)!=="svelte-1jup9fl"&&(b.innerHTML=zs),pt=a(e),p(ue.$$.fragment,e),yt=a(e),Ue=o(e,"P",{"data-svelte-h":!0}),i(Ue)!=="svelte-fiqqyd"&&(Ue.innerHTML=Ns),dt=a(e),p(je.$$.fragment,e),mt=a(e),T=o(e,"IFRAME",{width:!0,height:!0,src:!0,title:!0,frameborder:!0,allow:!0}),cl(T).forEach(t),ct=a(e),Te=o(e,"P",{"data-svelte-h":!0}),i(Te)!=="svelte-1rqi6h3"&&(Te.innerHTML=Fs),ut=a(e),we=o(e,"UL",{"data-svelte-h":!0}),i(we)!=="svelte-24bif2"&&(we.innerHTML=Xs),Ut=a(e),he=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),i(he)!=="svelte-1me1jis"&&(he.innerHTML=Qs),jt=a(e),p(Je.$$.fragment,e),Tt=a(e),fe=o(e,"P",{"data-svelte-h":!0}),i(fe)!=="svelte-10df72h"&&(fe.textContent=Ls),wt=a(e),p(be.$$.fragment,e),ht=a(e),ge=o(e,"P",{"data-svelte-h":!0}),i(ge)!=="svelte-116ugu4"&&(ge.innerHTML=qs),Jt=a(e),p(Ie.$$.fragment,e),ft=a(e),w=o(e,"IFRAME",{width:!0,height:!0,src:!0,title:!0,frameborder:!0,allow:!0}),cl(w).forEach(t),bt=a(e),Ce=o(e,"P",{"data-svelte-h":!0}),i(Ce)!=="svelte-6zcket"&&(Ce.innerHTML=Ds),gt=a(e),Ze=o(e,"P",{"data-svelte-h":!0}),i(Ze)!=="svelte-11i511d"&&(Ze.innerHTML=Ks),It=a(e),ke=o(e,"P",{"data-svelte-h":!0}),i(ke)!=="svelte-1aa5m67"&&(ke.innerHTML=Os),Ct=a(e),Be=o(e,"P",{"data-svelte-h":!0}),i(Be)!=="svelte-h98oit"&&(Be.innerHTML=en),Zt=a(e),p(Ge.$$.fragment,e),kt=a(e),We=o(e,"P",{"data-svelte-h":!0}),i(We)!=="svelte-1ttbskl"&&(We.innerHTML=ln),Bt=a(e),p(Ae.$$.fragment,e),Gt=a(e),ve=o(e,"P",{"data-svelte-h":!0}),i(ve)!=="svelte-1pml3h7"&&(ve.innerHTML=tn),Wt=a(e),p($e.$$.fragment,e),At=a(e),Se=o(e,"P",{"data-svelte-h":!0}),i(Se)!=="svelte-1uayvx5"&&(Se.innerHTML=sn),vt=a(e),p(_e.$$.fragment,e),$t=a(e),He=o(e,"P",{"data-svelte-h":!0}),i(He)!=="svelte-oqngf7"&&(He.innerHTML=nn),St=a(e),Re=o(e,"P",{"data-svelte-h":!0}),i(Re)!=="svelte-kb3ib5"&&(Re.textContent=an),_t=a(e),p(xe.$$.fragment,e),Ht=a(e),Ee=o(e,"P",{"data-svelte-h":!0}),i(Ee)!=="svelte-1alenu9"&&(Ee.textContent=Mn),Rt=a(e),p(Ve.$$.fragment,e),xt=a(e),ze=o(e,"P",{"data-svelte-h":!0}),i(ze)!=="svelte-wr9zty"&&(ze.textContent=on),Et=a(e),p(Ne.$$.fragment,e),Vt=a(e),Ye=o(e,"P",{"data-svelte-h":!0}),i(Ye)!=="svelte-pyh7bd"&&(Ye.innerHTML=rn),zt=a(e),Fe=o(e,"P",{"data-svelte-h":!0}),i(Fe)!=="svelte-w1qvv3"&&(Fe.innerHTML=pn),Nt=a(e),Xe=o(e,"P",{"data-svelte-h":!0}),i(Xe)!=="svelte-2gsa94"&&(Xe.innerHTML=yn),Yt=a(e),p(Qe.$$.fragment,e),Ft=a(e),Le=o(e,"P",{"data-svelte-h":!0}),i(Le)!=="svelte-1dpe0gw"&&(Le.textContent=dn),Xt=a(e),p(qe.$$.fragment,e),Qt=a(e),Pe=o(e,"P",{"data-svelte-h":!0}),i(Pe)!=="svelte-16le46z"&&(Pe.textContent=mn),Lt=a(e),p(De.$$.fragment,e),qt=a(e),Ke=o(e,"P",{"data-svelte-h":!0}),i(Ke)!=="svelte-v1a1yw"&&(Ke.textContent=cn),Pt=a(e),p(Oe.$$.fragment,e),Dt=a(e),el=o(e,"P",{"data-svelte-h":!0}),i(el)!=="svelte-1vaiyhh"&&(el.textContent=un),Kt=a(e),p(ll.$$.fragment,e),Ot=a(e),p(tl.$$.fragment,e),es=a(e),sl=o(e,"P",{"data-svelte-h":!0}),i(sl)!=="svelte-1ryqcdi"&&(sl.innerHTML=Un),ls=a(e),p(nl.$$.fragment,e),ts=a(e),al=o(e,"P",{"data-svelte-h":!0}),i(al)!=="svelte-1jy9y33"&&(al.innerHTML=jn),ss=a(e),Ml=o(e,"UL",{"data-svelte-h":!0}),i(Ml)!=="svelte-7ouasn"&&(Ml.innerHTML=Tn),ns=a(e),ol=o(e,"P",{"data-svelte-h":!0}),i(ol)!=="svelte-d9i7vl"&&(ol.innerHTML=wn),as=a(e),p(il.$$.fragment,e),Ms=a(e),rl=o(e,"P",{"data-svelte-h":!0}),i(rl)!=="svelte-1cih48j"&&(rl.innerHTML=hn),os=a(e),p(pl.$$.fragment,e),is=a(e),p(yl.$$.fragment,e),rs=a(e),ml=o(e,"P",{}),cl(ml).forEach(t),this.h()},h(){U(J,"name","hf:doc:metadata"),U(J,"content",Wn),U(j,"width","700"),U(j,"height","394"),ys(j.src,Zs="https://www.youtube.com/embed/pfBGgSGnYLs")||U(j,"src",Zs),U(j,"title","YouTube video player"),U(j,"frameborder","0"),U(j,"allow","accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"),j.allowFullscreen="",U(f,"start","2"),U(b,"start","3"),U(T,"width","700"),U(T,"height","394"),ys(T.src,Ys="https://www.youtube.com/embed/l9QZuazbzWM")||U(T,"src",Ys),U(T,"title","YouTube video player"),U(T,"frameborder","0"),U(T,"allow","accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"),T.allowFullscreen="",U(w,"width","700"),U(w,"height","394"),ys(w.src,Ps="https://www.youtube.com/embed/lnTixz0tUBg")||U(w,"src",Ps),U(w,"title","YouTube video player"),U(w,"frameborder","0"),U(w,"allow","accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"),w.allowFullscreen=""},m(e,l){Zn(document.head,J),s(e,ul,l),s(e,dl,l),s(e,Ul,l),y(g,e,l),s(e,jl,l),y(I,e,l),s(e,Tl,l),s(e,C,l),s(e,wl,l),y(Z,e,l),s(e,hl,l),s(e,k,l),s(e,Jl,l),s(e,B,l),s(e,fl,l),y(G,e,l),s(e,bl,l),s(e,W,l),s(e,gl,l),s(e,A,l),s(e,Il,l),s(e,v,l),s(e,Cl,l),s(e,$,l),s(e,Zl,l),s(e,S,l),s(e,kl,l),y(_,e,l),s(e,Bl,l),s(e,H,l),s(e,Gl,l),s(e,R,l),s(e,Wl,l),s(e,x,l),s(e,Al,l),y(E,e,l),s(e,vl,l),s(e,V,l),s(e,$l,l),s(e,z,l),s(e,Sl,l),s(e,N,l),s(e,_l,l),y(Y,e,l),s(e,Hl,l),y(F,e,l),s(e,Rl,l),s(e,j,l),s(e,xl,l),s(e,X,l),s(e,El,l),s(e,Q,l),s(e,Vl,l),s(e,L,l),s(e,zl,l),y(q,e,l),s(e,Nl,l),s(e,P,l),s(e,Yl,l),s(e,D,l),s(e,Fl,l),y(K,e,l),s(e,Xl,l),s(e,O,l),s(e,Ql,l),y(ee,e,l),s(e,Ll,l),y(le,e,l),s(e,ql,l),s(e,te,l),s(e,Pl,l),y(se,e,l),s(e,Dl,l),s(e,ne,l),s(e,Kl,l),y(ae,e,l),s(e,Ol,l),y(Me,e,l),s(e,et,l),s(e,oe,l),s(e,lt,l),s(e,ie,l),s(e,tt,l),s(e,re,l),s(e,st,l),y(pe,e,l),s(e,nt,l),s(e,ye,l),s(e,at,l),s(e,de,l),s(e,Mt,l),y(me,e,l),s(e,ot,l),s(e,f,l),s(e,it,l),y(ce,e,l),s(e,rt,l),s(e,b,l),s(e,pt,l),y(ue,e,l),s(e,yt,l),s(e,Ue,l),s(e,dt,l),y(je,e,l),s(e,mt,l),s(e,T,l),s(e,ct,l),s(e,Te,l),s(e,ut,l),s(e,we,l),s(e,Ut,l),s(e,he,l),s(e,jt,l),y(Je,e,l),s(e,Tt,l),s(e,fe,l),s(e,wt,l),y(be,e,l),s(e,ht,l),s(e,ge,l),s(e,Jt,l),y(Ie,e,l),s(e,ft,l),s(e,w,l),s(e,bt,l),s(e,Ce,l),s(e,gt,l),s(e,Ze,l),s(e,It,l),s(e,ke,l),s(e,Ct,l),s(e,Be,l),s(e,Zt,l),y(Ge,e,l),s(e,kt,l),s(e,We,l),s(e,Bt,l),y(Ae,e,l),s(e,Gt,l),s(e,ve,l),s(e,Wt,l),y($e,e,l),s(e,At,l),s(e,Se,l),s(e,vt,l),y(_e,e,l),s(e,$t,l),s(e,He,l),s(e,St,l),s(e,Re,l),s(e,_t,l),y(xe,e,l),s(e,Ht,l),s(e,Ee,l),s(e,Rt,l),y(Ve,e,l),s(e,xt,l),s(e,ze,l),s(e,Et,l),y(Ne,e,l),s(e,Vt,l),s(e,Ye,l),s(e,zt,l),s(e,Fe,l),s(e,Nt,l),s(e,Xe,l),s(e,Yt,l),y(Qe,e,l),s(e,Ft,l),s(e,Le,l),s(e,Xt,l),y(qe,e,l),s(e,Qt,l),s(e,Pe,l),s(e,Lt,l),y(De,e,l),s(e,qt,l),s(e,Ke,l),s(e,Pt,l),y(Oe,e,l),s(e,Dt,l),s(e,el,l),s(e,Kt,l),y(ll,e,l),s(e,Ot,l),y(tl,e,l),s(e,es,l),s(e,sl,l),s(e,ls,l),y(nl,e,l),s(e,ts,l),s(e,al,l),s(e,ss,l),s(e,Ml,l),s(e,ns,l),s(e,ol,l),s(e,as,l),y(il,e,l),s(e,Ms,l),s(e,rl,l),s(e,os,l),y(pl,e,l),s(e,is,l),y(yl,e,l),s(e,rs,l),s(e,ml,l),ps=!0},p:fn,i(e){ps||(d(g.$$.fragment,e),d(I.$$.fragment,e),d(Z.$$.fragment,e),d(G.$$.fragment,e),d(_.$$.fragment,e),d(E.$$.fragment,e),d(Y.$$.fragment,e),d(F.$$.fragment,e),d(q.$$.fragment,e),d(K.$$.fragment,e),d(ee.$$.fragment,e),d(le.$$.fragment,e),d(se.$$.fragment,e),d(ae.$$.fragment,e),d(Me.$$.fragment,e),d(pe.$$.fragment,e),d(me.$$.fragment,e),d(ce.$$.fragment,e),d(ue.$$.fragment,e),d(je.$$.fragment,e),d(Je.$$.fragment,e),d(be.$$.fragment,e),d(Ie.$$.fragment,e),d(Ge.$$.fragment,e),d(Ae.$$.fragment,e),d($e.$$.fragment,e),d(_e.$$.fragment,e),d(xe.$$.fragment,e),d(Ve.$$.fragment,e),d(Ne.$$.fragment,e),d(Qe.$$.fragment,e),d(qe.$$.fragment,e),d(De.$$.fragment,e),d(Oe.$$.fragment,e),d(ll.$$.fragment,e),d(tl.$$.fragment,e),d(nl.$$.fragment,e),d(il.$$.fragment,e),d(pl.$$.fragment,e),d(yl.$$.fragment,e),ps=!0)},o(e){m(g.$$.fragment,e),m(I.$$.fragment,e),m(Z.$$.fragment,e),m(G.$$.fragment,e),m(_.$$.fragment,e),m(E.$$.fragment,e),m(Y.$$.fragment,e),m(F.$$.fragment,e),m(q.$$.fragment,e),m(K.$$.fragment,e),m(ee.$$.fragment,e),m(le.$$.fragment,e),m(se.$$.fragment,e),m(ae.$$.fragment,e),m(Me.$$.fragment,e),m(pe.$$.fragment,e),m(me.$$.fragment,e),m(ce.$$.fragment,e),m(ue.$$.fragment,e),m(je.$$.fragment,e),m(Je.$$.fragment,e),m(be.$$.fragment,e),m(Ie.$$.fragment,e),m(Ge.$$.fragment,e),m(Ae.$$.fragment,e),m($e.$$.fragment,e),m(_e.$$.fragment,e),m(xe.$$.fragment,e),m(Ve.$$.fragment,e),m(Ne.$$.fragment,e),m(Qe.$$.fragment,e),m(qe.$$.fragment,e),m(De.$$.fragment,e),m(Oe.$$.fragment,e),m(ll.$$.fragment,e),m(tl.$$.fragment,e),m(nl.$$.fragment,e),m(il.$$.fragment,e),m(pl.$$.fragment,e),m(yl.$$.fragment,e),ps=!1},d(e){e&&(t(ul),t(dl),t(Ul),t(jl),t(Tl),t(C),t(wl),t(hl),t(k),t(Jl),t(B),t(fl),t(bl),t(W),t(gl),t(A),t(Il),t(v),t(Cl),t($),t(Zl),t(S),t(kl),t(Bl),t(H),t(Gl),t(R),t(Wl),t(x),t(Al),t(vl),t(V),t($l),t(z),t(Sl),t(N),t(_l),t(Hl),t(Rl),t(j),t(xl),t(X),t(El),t(Q),t(Vl),t(L),t(zl),t(Nl),t(P),t(Yl),t(D),t(Fl),t(Xl),t(O),t(Ql),t(Ll),t(ql),t(te),t(Pl),t(Dl),t(ne),t(Kl),t(Ol),t(et),t(oe),t(lt),t(ie),t(tt),t(re),t(st),t(nt),t(ye),t(at),t(de),t(Mt),t(ot),t(f),t(it),t(rt),t(b),t(pt),t(yt),t(Ue),t(dt),t(mt),t(T),t(ct),t(Te),t(ut),t(we),t(Ut),t(he),t(jt),t(Tt),t(fe),t(wt),t(ht),t(ge),t(Jt),t(ft),t(w),t(bt),t(Ce),t(gt),t(Ze),t(It),t(ke),t(Ct),t(Be),t(Zt),t(kt),t(We),t(Bt),t(Gt),t(ve),t(Wt),t(At),t(Se),t(vt),t($t),t(He),t(St),t(Re),t(_t),t(Ht),t(Ee),t(Rt),t(xt),t(ze),t(Et),t(Vt),t(Ye),t(zt),t(Fe),t(Nt),t(Xe),t(Yt),t(Ft),t(Le),t(Xt),t(Qt),t(Pe),t(Lt),t(qt),t(Ke),t(Pt),t(Dt),t(el),t(Kt),t(Ot),t(es),t(sl),t(ls),t(ts),t(al),t(ss),t(Ml),t(ns),t(ol),t(as),t(Ms),t(rl),t(os),t(is),t(rs),t(ml)),t(J),c(g,e),c(I,e),c(Z,e),c(G,e),c(_,e),c(E,e),c(Y,e),c(F,e),c(q,e),c(K,e),c(ee,e),c(le,e),c(se,e),c(ae,e),c(Me,e),c(pe,e),c(me,e),c(ce,e),c(ue,e),c(je,e),c(Je,e),c(be,e),c(Ie,e),c(Ge,e),c(Ae,e),c($e,e),c(_e,e),c(xe,e),c(Ve,e),c(Ne,e),c(Qe,e),c(qe,e),c(De,e),c(Oe,e),c(ll,e),c(tl,e),c(nl,e),c(il,e),c(pl,e),c(yl,e)}}}const Wn='{"title":"Deploy models to Amazon SageMaker","local":"deploy-models-to-amazon-sagemaker","sections":[{"title":"Installation and setup","local":"installation-and-setup","sections":[],"depth":2},{"title":"Deploy a 🤗 Transformers model trained in SageMaker","local":"deploy-a--transformers-model-trained-in-sagemaker","sections":[{"title":"Deploy after training","local":"deploy-after-training","sections":[],"depth":3},{"title":"Deploy with model_data","local":"deploy-with-modeldata","sections":[],"depth":3},{"title":"Create a model artifact for deployment","local":"create-a-model-artifact-for-deployment","sections":[],"depth":3}],"depth":2},{"title":"Deploy a model from the 🤗 Hub","local":"deploy-a-model-from-the--hub","sections":[],"depth":2},{"title":"Run batch transform with 🤗 Transformers and SageMaker","local":"run-batch-transform-with--transformers-and-sagemaker","sections":[],"depth":2},{"title":"Deploy an LLM to SageMaker using TGI","local":"deploy-an-llm-to-sagemaker-using-tgi","sections":[],"depth":2},{"title":"User defined code and modules","local":"user-defined-code-and-modules","sections":[],"depth":2}],"depth":1}';function An(ds){return bn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Hn extends gn{constructor(J){super(),In(this,J,An,Gn,Jn,{})}}export{Hn as component};
