import{s as Yt,n as Lt,o as $t}from"../chunks/scheduler.56725da7.js";import{S as zt,i as Ht,e as M,s as a,c as p,h as qt,a as i,d as e,b as n,f as kt,g as T,j as o,k as vt,l as Dt,m as s,n as r,t as m,o as U,p as J}from"../chunks/index.18a26576.js";import{C as Pt}from"../chunks/CopyLLMTxtMenu.afed97b6.js";import{C as y}from"../chunks/CodeBlock.328a828a.js";import{H as rl}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.56586e0c.js";function Ot(rt){let u,Jl,ml,yl,d,ul,c,dl,j,mt="This tutorial shows how to fine-tune the Llama 3.1 model on AWS Trainium accelerators using optimum-neuron.",cl,w,Ut='<strong>This is based on the <a href="https://github.com/huggingface/optimum-neuron/tree/main/examples/training/llama" rel="nofollow">Llama 3.1 fine-tuning example script</a>.</strong>',jl,h,wl,b,Jt="We’ll use a <code>trn1.32xlarge</code> instance with 16 Trainium Accelerators (32 Neuron Cores) and the Hugging Face Neuron Deep Learning AMI.",hl,f,yt="The Hugging Face AMI includes all required libraries pre-installed:",bl,I,ut="<li><code>datasets</code>, <code>transformers</code>, <code>optimum-neuron</code></li> <li>Neuron SDK packages</li> <li>No additional environment setup needed</li>",fl,R,dt='To create your instance, follow the guide <a href="https://huggingface.co/docs/optimum-neuron/ec2-setup" rel="nofollow">here</a>.',Il,Z,ct='<strong>Model Access:</strong> The Llama 3.1 model is gated and requires access approval. You can request access at <a href="https://huggingface.co/meta-llama/Llama-3.1-8B" rel="nofollow">meta-llama/Llama-3.1-8B</a>. Once approved, make sure to authenticate with the Hugging Face Hub:',Rl,E,Zl,C,El,g,jt='We’ll use the <a href="https://huggingface.co/datasets/databricks/databricks-dolly-15k" rel="nofollow">Dolly</a> dataset, an open source dataset of instruction-following records on categories outlined in the <a href="https://arxiv.org/abs/2203.02155" rel="nofollow">InstructGPT paper</a>, including brainstorming, classification, closed QA, generation, information extraction, open QA, and summarization.',Cl,B,gl,W,wt="To load the dataset we use the <code>load_dataset()</code> method from the <code>datasets</code> library.",Bl,_,Wl,V,ht="To instruct fine-tune our model we need to convert our structured examples into collection of tasks described via instructions. We define our formatting function to preprocess the dataset.",_l,F,bt="The dataset should be structured with input-output pairs, where each input is a prompt and the output is the expected response from the model.",Vl,N,Fl,G,ft='Note: this function is well-defined in the <a href="https://github.com/huggingface/optimum-neuron/blob/main/examples/training/llama/finetune_llama.py" rel="nofollow">Python script</a> to run this tutorial.',Nl,X,Gl,Q,It='For standard PyTorch fine-tuning, you’d typically use <a href="https://github.com/huggingface/peft" rel="nofollow">PEFT</a> with LoRA adapters and the <a href="https://huggingface.co/docs/trl/en/sft_trainer" rel="nofollow"><code>SFTTrainer</code></a>.',Xl,S,Rt="On AWS Trainium, <code>optimum-neuron</code> provides <code>NeuronSFTTrainer</code> as a drop-in replacement.",Ql,A,Zt=`<strong>Distributed Training on Trainium:</strong>
Since Llama 3.1 8B doesn’t fit on a single accelerator, we use distributed training techniques:`,Sl,x,Et="<li>Data Parallel (DDP)</li> <li>Tensor Parallelism</li>",Al,k,Ct="Model loading and LoRA configuration work similarly to other accelerators.",xl,v,gt="Combining all the pieces together, and assuming the dataset has already been loaded, we can write the following code to fine-tune Llama 3.1 on AWS Trainium:",kl,Y,vl,L,Bt='📝 <strong>Complete script available:</strong> All steps above are combined in a ready-to-use script <a href="https://github.com/huggingface/optimum-neuron/blob/main/examples/training/llama/finetune_llama.py" rel="nofollow">finetune_llama.py</a>.',Yl,$,Wt="To launch training, just run the following command in your AWS Trainium instance:",Ll,z,$l,H,_t='🔧 <strong>Single command execution:</strong> The complete bash training script <a href="https://github.com/huggingface/optimum-neuron/blob/main/examples/training/llama/finetune_llama.sh" rel="nofollow">finetune_llama.sh</a> is available:',zl,q,Hl,D,ql,P,Vt="Optimum Neuron saves model shards separately during distributed training. These need to be consolidated before use.",Dl,O,Ft="Use the Optimum CLI to consolidate:",Pl,K,Ol,ll,Nt="This will create an <code>adapter_model.safetensors</code> file, the LoRA adapter weights that we trained in the previous step. We can now reload the model and merge it, so it can be loaded for evaluation:",Kl,tl,lt,el,Gt="Once this step is done, it is possible to test the model with a new prompt.",tt,sl,Xt="You have successfully created a fine-tuned model from Llama 3.1!",et,al,st,nl,Qt="Share your fine-tuned model with the community by uploading it to the Hugging Face Hub.",at,Ml,St="<strong>Step 1: Authentication</strong>",nt,il,Mt,ol,At="<strong>Step 2: Upload your model</strong>",it,pl,ot,Tl,xt="🎉 <strong>Your fine-tuned Llama 3.1 model is now available on the Hub for others to use!</strong>",pt,Ul,Tt;return d=new Pt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),c=new rl({props:{title:"🚀 Instruction Fine-Tuning of Llama 3.1 8B with LoRA",local:"-instruction-fine-tuning-of-llama-31-8b-with-lora",headingTag:"h1"}}),h=new rl({props:{title:"1. 🛠️ Setup AWS Environment",local:"1--setup-aws-environment",headingTag:"h2"}}),E=new y({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),C=new rl({props:{title:"2. 📊 Load and Prepare the Dataset",local:"2--load-and-prepare-the-dataset",headingTag:"h2"}}),B=new y({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5zdHJ1Y3Rpb24lMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjB3b3JsZCUyMG9mJTIwd2FyY3JhZnQlMjIlMkMlMEElMjAlMjAlMjJjb250ZXh0JTIyJTNBJTIwJTIyJTIyJTJDJTBBJTIwJTIwJTIycmVzcG9uc2UlMjIlM0ElMjAoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV29ybGQlMjBvZiUyMHdhcmNyYWZ0JTIwaXMlMjBhJTIwbWFzc2l2ZSUyMG9ubGluZSUyMG11bHRpJTIwcGxheWVyJTIwcm9sZSUyMHBsYXlpbmclMjBnYW1lLiUyMCUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkl0JTIwd2FzJTIwcmVsZWFzZWQlMjBpbiUyMDIwMDQlMjBieSUyMGJpemFycmUlMjBlbnRlcnRhaW5tZW50JTIyJTBBJTIwJTIwJTIwJTIwKSUwQSU3RA==",highlighted:`{
  <span class="hljs-comment">&quot;instruction&quot;</span>: <span class="hljs-comment">&quot;What is world of warcraft&quot;</span>,
  <span class="hljs-comment">&quot;context&quot;</span>: <span class="hljs-comment">&quot;&quot;</span>,
  <span class="hljs-comment">&quot;response&quot;</span>: (
        <span class="hljs-comment">&quot;World of warcraft is a massive online multi player role playing game. &quot;</span>
        <span class="hljs-comment">&quot;It was released in 2004 by bizarre entertainment&quot;</span>
    )
}`,wrap:!1}}),_=new y({props:{code:"ZnJvbSUyMHJhbmRvbSUyMGltcG9ydCUyMHJhbmRyYW5nZSUwQSUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQSUwQSUyMyUyMExvYWQlMjBkYXRhc2V0JTIwZnJvbSUyMHRoZSUyMGh1YiUwQWRhdGFzZXRfaWQlMjAlM0QlMjAlMjJkYXRhYnJpY2tzJTJGZGF0YWJyaWNrcy1kb2xseS0xNWslMjIlMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KGRhdGFzZXRfaWQlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQWRhdGFzZXRfc2l6ZSUyMCUzRCUyMGxlbihkYXRhc2V0KSUwQXByaW50KGYlMjJkYXRhc2V0JTIwc2l6ZSUzQSUyMCU3QmRhdGFzZXRfc2l6ZSU3RCUyMiklMEElMjMlMjBkYXRhc2V0JTIwc2l6ZSUzQSUyMDE1MDEx",highlighted:`<span class="hljs-keyword">from</span> random <span class="hljs-keyword">import</span> randrange

<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset


<span class="hljs-comment"># Load dataset from the hub</span>
dataset_id = <span class="hljs-string">&quot;databricks/databricks-dolly-15k&quot;</span>
dataset = load_dataset(dataset_id, split=<span class="hljs-string">&quot;train&quot;</span>)

dataset_size = <span class="hljs-built_in">len</span>(dataset)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;dataset size: <span class="hljs-subst">{dataset_size}</span>&quot;</span>)
<span class="hljs-comment"># dataset size: 15011</span>`,wrap:!1}}),N=new y({props:{code:"ZGVmJTIwZm9ybWF0X2RvbGx5KGV4YW1wbGUlMkMlMjB0b2tlbml6ZXIpJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyRm9ybWF0JTIwRG9sbHklMjBkYXRhc2V0JTIwZXhhbXBsZXMlMjB1c2luZyUyMHRoZSUyMHRva2VuaXplcidzJTIwY2hhdCUyMHRlbXBsYXRlLiUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMHVzZXJfY29udGVudCUyMCUzRCUyMGV4YW1wbGUlNUIlMjJpbnN0cnVjdGlvbiUyMiU1RCUwQSUyMCUyMCUyMCUyMGlmJTIwbGVuKGV4YW1wbGUlNUIlMjJjb250ZXh0JTIyJTVEKSUyMCUzRSUyMDAlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB1c2VyX2NvbnRlbnQlMjAlMkIlM0QlMjBmJTIyJTVDbiU1Q25Db250ZXh0JTNBJTIwJTdCZXhhbXBsZSU1Qidjb250ZXh0JyU1RCU3RCUyMiUwQSUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJDdXR0aW5nJTIwS25vd2xlZGdlJTIwRGF0ZSUzQSUyMERlY2VtYmVyJTIwMjAyMyU1Q25Ub2RheSUyMERhdGUlM0ElMjAyOSUyMEp1bCUyMDIwMjUlNUNuJTVDbllvdSUyMGFyZSUyMGElMjBoZWxwZnVsJTIwYXNzaXN0YW50JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwdXNlcl9jb250ZW50JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjBleGFtcGxlJTVCJTIycmVzcG9uc2UlMjIlNUQlN0QlMkMlMEElMjAlMjAlMjAlMjAlNUQlMEElMEElMjAlMjAlMjAlMjByZXR1cm4lMjB0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZShtZXNzYWdlcyUyQyUyMHRva2VuaXplJTNERmFsc2Up",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">format_dolly</span>(<span class="hljs-params">example, tokenizer</span>):
    <span class="hljs-string">&quot;&quot;&quot;Format Dolly dataset examples using the tokenizer&#x27;s chat template.&quot;&quot;&quot;</span>
    user_content = example[<span class="hljs-string">&quot;instruction&quot;</span>]
    <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(example[<span class="hljs-string">&quot;context&quot;</span>]) &gt; <span class="hljs-number">0</span>:
        user_content += <span class="hljs-string">f&quot;\\n\\nContext: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;context&#x27;</span>]}</span>&quot;</span>

    messages = [
        {
            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
            <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Cutting Knowledge Date: December 2023\\nToday Date: 29 Jul 2025\\n\\nYou are a helpful assistant&quot;</span>,
        },
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: user_content},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: example[<span class="hljs-string">&quot;response&quot;</span>]},
    ]

    <span class="hljs-keyword">return</span> tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>)`,wrap:!1}}),X=new rl({props:{title:"3. 🎯 Fine-tune Llama 3.1 with NeuronSFTTrainer and PEFT",local:"3--fine-tune-llama-31-with-neuronsfttrainer-and-peft",headingTag:"h2"}}),Y=new y({props:{code:"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",highlighted:`model_id = <span class="hljs-string">&quot;meta-llama/Llama-3.1-8B&quot;</span>

<span class="hljs-comment"># Define the training arguments</span>
output_dir = <span class="hljs-string">&quot;Llama-3.1-8B-finetuned&quot;</span>
training_args = NeuronTrainingArguments(
    output_dir=output_dir,
    num_train_epochs=<span class="hljs-number">3</span>,
    do_train=<span class="hljs-literal">True</span>,
    max_steps=-<span class="hljs-number">1</span>,  <span class="hljs-comment"># -1 means train until the end of the dataset</span>
    per_device_train_batch_size=<span class="hljs-number">1</span>,
    gradient_accumulation_steps=<span class="hljs-number">16</span>,
    learning_rate=<span class="hljs-number">1e-4</span>,
    bf16=<span class="hljs-literal">True</span>,  
    tensor_parallel_size=<span class="hljs-number">8</span>,
    logging_steps=<span class="hljs-number">1</span>,
    warmup_steps=<span class="hljs-number">5</span>,
    async_save=<span class="hljs-literal">True</span>,
    overwrite_output_dir=<span class="hljs-literal">True</span>,
)

<span class="hljs-comment"># Load the model with the NeuronModelForCausalLM class.</span>
<span class="hljs-comment"># It will load the model with a custom modeling specifically designed for AWS Trainium.</span>
trn_config = training_args.trn_config
dtype = torch.bfloat16 <span class="hljs-keyword">if</span> training_args.bf16 <span class="hljs-keyword">else</span> torch.float32
model = NeuronModelForCausalLM.from_pretrained(
    model_id,
    trn_config,
    dtype=dtype,
    <span class="hljs-comment"># Use FlashAttention2 for better performance and to be able to use larger sequence lengths.</span>
    attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>,
)

lora_config = LoraConfig(
    r=<span class="hljs-number">64</span>,
    lora_alpha=<span class="hljs-number">128</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    target_modules=[<span class="hljs-string">&quot;embed_tokens&quot;</span>, <span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>, <span class="hljs-string">&quot;o_proj&quot;</span>, <span class="hljs-string">&quot;gate_proj&quot;</span>, <span class="hljs-string">&quot;up_proj&quot;</span>, <span class="hljs-string">&quot;down_proj&quot;</span>],
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

<span class="hljs-comment"># Converting the NeuronTrainingArguments to a dictionary to feed them to the NeuronSFTConfig.</span>
args = training_args.to_dict()

sft_config = NeuronSFTConfig(
    max_length=<span class="hljs-number">2048</span>,
    packing=<span class="hljs-literal">True</span>,
    **args,
)

tokenizer = AutoTokenizer.from_pretrained(model_id)
tokenizer.pad_token = <span class="hljs-string">&quot;&lt;|finetune_right_pad_id|&gt;&quot;</span>

<span class="hljs-comment"># Set chat template for Llama 3.1 format</span>
tokenizer.chat_template = (
    <span class="hljs-string">&quot;{% for message in messages %}&quot;</span>
    <span class="hljs-string">&quot;{% if message[&#x27;role&#x27;] == &#x27;system&#x27; %}&quot;</span>
    <span class="hljs-string">&quot;&lt;|begin_of_text|&gt;&lt;|start_header_id|&gt;system&lt;|end_header_id|&gt;\\n\\n{{ message[&#x27;content&#x27;] }}&lt;|eot_id|&gt;&quot;</span>
    <span class="hljs-string">&quot;{% elif message[&#x27;role&#x27;] == &#x27;user&#x27; %}&quot;</span>
    <span class="hljs-string">&quot;&lt;|start_header_id|&gt;user&lt;|end_header_id|&gt;\\n\\n{{ message[&#x27;content&#x27;] }}&lt;|eot_id|&gt;&quot;</span>
    <span class="hljs-string">&quot;{% elif message[&#x27;role&#x27;] == &#x27;assistant&#x27; %}&quot;</span>
    <span class="hljs-string">&quot;&lt;|start_header_id|&gt;assistant&lt;|end_header_id|&gt;\\n\\n{{ message[&#x27;content&#x27;] }}&lt;|eot_id|&gt;&quot;</span>
    <span class="hljs-string">&quot;{% endif %}&quot;</span>
    <span class="hljs-string">&quot;{% endfor %}&quot;</span>
    <span class="hljs-string">&quot;{% if add_generation_prompt %}&quot;</span>
    <span class="hljs-string">&quot;&lt;|start_header_id|&gt;assistant&lt;|end_header_id|&gt;\\n\\n&quot;</span>
    <span class="hljs-string">&quot;{% endif %}&quot;</span>
)

<span class="hljs-comment"># The NeuronSFTTrainer will use \`format_dolly\` to format the dataset and \`lora_config\` to apply LoRA on the</span>
<span class="hljs-comment"># model.</span>
trainer = NeuronSFTTrainer(
    args=sft_config,
    model=model,
    peft_config=lora_config,
    processing_class=tokenizer,
    train_dataset=dataset,
    formatting_func=<span class="hljs-keyword">lambda</span> example: format_dolly(example, tokenizer),
)
trainer.train()`,wrap:!1}}),z=new y({props:{code:"JTIzJTIwRmxhZ3MlMjBmb3IlMjBOZXVyb24lMjBjb21waWxhdGlvbiUwQWV4cG9ydCUyME5FVVJPTl9DQ19GTEFHUyUzRCUyMi0tbW9kZWwtdHlwZSUyMHRyYW5zZm9ybWVyJTIwLS1yZXRyeV9mYWlsZWRfY29tcGlsYXRpb24lMjIlMEFleHBvcnQlMjBORVVST05fRlVTRV9TT0ZUTUFYJTNEMSUwQWV4cG9ydCUyME5FVVJPTl9SVF9BU1lOQ19FWEVDX01BWF9JTkZMSUdIVF9SRVFVRVNUUyUzRDMlMjAlMjMlMjBBc3luYyUyMFJ1bnRpbWUlMEFleHBvcnQlMjBNQUxMT0NfQVJFTkFfTUFYJTNENjQlMjAlMjMlMjBIb3N0JTIwT09NJTIwbWl0aWdhdGlvbiUwQSUwQSUyMyUyMFZhcmlhYmxlcyUyMGZvciUyMHRyYWluaW5nJTBBUFJPQ0VTU0VTX1BFUl9OT0RFJTNEMzIlMEFOVU1fRVBPQ0hTJTNEMyUwQVRQX0RFR1JFRSUzRDglMEFCUyUzRDElMEFHUkFESUVOVF9BQ0NVTVVMQVRJT05fU1RFUFMlM0QxNiUwQUxPR0dJTkdfU1RFUFMlM0QxJTBBTU9ERUxfTkFNRSUzRCUyMm1ldGEtbGxhbWElMkZMbGFtYS0zLjEtOEIlMjIlMjAlMjMlMjBDaGFuZ2UlMjB0aGlzJTIwdG8lMjB0aGUlMjBkZXNpcmVkJTIwbW9kZWwlMjBuYW1lJTBBT1VUUFVUX0RJUiUzRCUyMiUyNChlY2hvJTIwJTI0TU9ERUxfTkFNRSUyMCU3QyUyMGN1dCUyMC1kJyUyRiclMjAtZjIpLWZpbmV0dW5lZCUyMiUwQURJU1RSSUJVVEVEX0FSR1MlM0QlMjItLW5wcm9jX3Blcl9ub2RlJTIwJTI0UFJPQ0VTU0VTX1BFUl9OT0RFJTIyJTBBJTBBaWYlMjAlNUIlMjAlMjIlMjRORVVST05fRVhUUkFDVF9HUkFQSFNfT05MWSUyMiUyMCUzRCUyMCUyMjElMjIlMjAlNUQlM0IlMjB0aGVuJTBBJTIwJTIwJTIwJTIwTUFYX1NURVBTJTNENSUwQWVsc2UlMEElMjAlMjAlMjAlMjBNQVhfU1RFUFMlM0QtMSUwQWZpJTBBJTBBdG9yY2hydW4lMjAtLW5wcm9jX3Blcl9ub2RlJTIwJTI0UFJPQ0VTU0VTX1BFUl9OT0RFJTIwZmluZXR1bmVfbGxhbWEucHklMjAlNUMlMEElMjAlMjAtLW1vZGVsX2lkJTIwJTI0TU9ERUxfTkFNRSUyMCU1QyUwQSUyMCUyMC0tbnVtX3RyYWluX2Vwb2NocyUyMCUyNE5VTV9FUE9DSFMlMjAlNUMlMEElMjAlMjAtLWRvX3RyYWluJTIwJTVDJTBBJTIwJTIwLS1tYXhfc3RlcHMlMjAlMjRNQVhfU1RFUFMlMjAlNUMlMEElMjAlMjAtLXBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUyMCUyNEJTJTIwJTVDJTBBJTIwJTIwLS1ncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlMjAlMjRHUkFESUVOVF9BQ0NVTVVMQVRJT05fU1RFUFMlMjAlNUMlMEElMjAlMjAtLWxlYXJuaW5nX3JhdGUlMjAxZS00JTIwJTVDJTBBJTIwJTIwLS1iZjE2JTIwJTVDJTBBJTIwJTIwLS10ZW5zb3JfcGFyYWxsZWxfc2l6ZSUyMCUyNFRQX0RFR1JFRSUyMCU1QyUwQSUyMCUyMC0tYXN5bmNfc2F2ZSUyMCU1QyUwQSUyMCUyMC0td2FybXVwX3N0ZXBzJTIwNSUyMCU1QyUwQSUyMCUyMC0tbG9nZ2luZ19zdGVwcyUyMCUyNExPR0dJTkdfU1RFUFMlMjAlNUMlMEElMjAlMjAtLW91dHB1dF9kaXIlMjAlMjRPVVRQVVRfRElSJTIwJTVDJTBBJTIwJTIwLS1vdmVyd3JpdGVfb3V0cHV0X2Rpcg==",highlighted:`<span class="hljs-comment"># Flags for Neuron compilation</span>
<span class="hljs-built_in">export</span> NEURON_CC_FLAGS=<span class="hljs-string">&quot;--model-type transformer --retry_failed_compilation&quot;</span>
<span class="hljs-built_in">export</span> NEURON_FUSE_SOFTMAX=1
<span class="hljs-built_in">export</span> NEURON_RT_ASYNC_EXEC_MAX_INFLIGHT_REQUESTS=3 <span class="hljs-comment"># Async Runtime</span>
<span class="hljs-built_in">export</span> MALLOC_ARENA_MAX=64 <span class="hljs-comment"># Host OOM mitigation</span>

<span class="hljs-comment"># Variables for training</span>
PROCESSES_PER_NODE=32
NUM_EPOCHS=3
TP_DEGREE=8
BS=1
GRADIENT_ACCUMULATION_STEPS=16
LOGGING_STEPS=1
MODEL_NAME=<span class="hljs-string">&quot;meta-llama/Llama-3.1-8B&quot;</span> <span class="hljs-comment"># Change this to the desired model name</span>
OUTPUT_DIR=<span class="hljs-string">&quot;<span class="hljs-subst">$(echo $MODEL_NAME | cut -d&#x27;/&#x27; -f2)</span>-finetuned&quot;</span>
DISTRIBUTED_ARGS=<span class="hljs-string">&quot;--nproc_per_node <span class="hljs-variable">$PROCESSES_PER_NODE</span>&quot;</span>

<span class="hljs-keyword">if</span> [ <span class="hljs-string">&quot;<span class="hljs-variable">$NEURON_EXTRACT_GRAPHS_ONLY</span>&quot;</span> = <span class="hljs-string">&quot;1&quot;</span> ]; <span class="hljs-keyword">then</span>
    MAX_STEPS=5
<span class="hljs-keyword">else</span>
    MAX_STEPS=-1
<span class="hljs-keyword">fi</span>

torchrun --nproc_per_node <span class="hljs-variable">$PROCESSES_PER_NODE</span> finetune_llama.py \\
  --model_id <span class="hljs-variable">$MODEL_NAME</span> \\
  --num_train_epochs <span class="hljs-variable">$NUM_EPOCHS</span> \\
  --do_train \\
  --max_steps <span class="hljs-variable">$MAX_STEPS</span> \\
  --per_device_train_batch_size <span class="hljs-variable">$BS</span> \\
  --gradient_accumulation_steps <span class="hljs-variable">$GRADIENT_ACCUMULATION_STEPS</span> \\
  --learning_rate 1e-4 \\
  --bf16 \\
  --tensor_parallel_size <span class="hljs-variable">$TP_DEGREE</span> \\
  --async_save \\
  --warmup_steps 5 \\
  --logging_steps <span class="hljs-variable">$LOGGING_STEPS</span> \\
  --output_dir <span class="hljs-variable">$OUTPUT_DIR</span> \\
  --overwrite_output_dir`,wrap:!1}}),q=new y({props:{code:"LiUyRmZpbmV0dW5lX2xsYW1hLnNo",highlighted:"./finetune_llama.sh",wrap:!1}}),D=new rl({props:{title:"4. 🔄 Consolidate and Test the Fine-Tuned Model",local:"4--consolidate-and-test-the-fine-tuned-model",headingTag:"h2"}}),K=new y({props:{code:"b3B0aW11bS1jbGklMjBuZXVyb24lMjBjb25zb2xpZGF0ZSUyMExsYW1hLTMuMS04Qi1maW5ldHVuZWQlMjBMbGFtYS0zLjEtOEItZmluZXR1bmVkJTJGYWRhcHRlcl9kZWZhdWx0",highlighted:"optimum-cli neuron consolidate Llama-3.1-8B-finetuned Llama-3.1-8B-finetuned/adapter_default",wrap:!1}}),tl=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjBwZWZ0JTIwaW1wb3J0JTIwUGVmdE1vZGVsJTJDJTIwUGVmdENvbmZpZyUwQSUwQSUwQU1PREVMX05BTUUlMjAlM0QlMjAlMjJtZXRhLWxsYW1hJTJGTGxhbWEtMy4xLThCJTIyJTBBQURBUFRFUl9QQVRIJTIwJTNEJTIwJTIyTGxhbWEtMy4xLThCLWZpbmV0dW5lZCUyRmFkYXB0ZXJfZGVmYXVsdCUyMiUwQU1FUkdFRF9NT0RFTF9QQVRIJTIwJTNEJTIwJTIyTGxhbWEtMy4xLThCLWRvbGx5JTIyJTBBJTBBJTIzJTIwTG9hZCUyMGJhc2UlMjBtb2RlbCUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKE1PREVMX05BTUUpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoTU9ERUxfTkFNRSklMEElMEElMjMlMjBMb2FkJTIwYWRhcHRlciUyMGNvbmZpZ3VyYXRpb24lMjBhbmQlMjBtb2RlbCUwQWFkYXB0ZXJfY29uZmlnJTIwJTNEJTIwUGVmdENvbmZpZy5mcm9tX3ByZXRyYWluZWQoQURBUFRFUl9QQVRIKSUwQWZpbmV0dW5lZF9tb2RlbCUyMCUzRCUyMFBlZnRNb2RlbC5mcm9tX3ByZXRyYWluZWQobW9kZWwlMkMlMjBBREFQVEVSX1BBVEglMkMlMjBjb25maWclM0RhZGFwdGVyX2NvbmZpZyklMEElMEFwcmludCglMjJTYXZpbmclMjB0b2tlbml6ZXIlMjIpJTBBdG9rZW5pemVyLnNhdmVfcHJldHJhaW5lZChNRVJHRURfTU9ERUxfUEFUSCklMEFwcmludCglMjJTYXZpbmclMjBtb2RlbCUyMiklMEFmaW5ldHVuZWRfbW9kZWwlMjAlM0QlMjBmaW5ldHVuZWRfbW9kZWwubWVyZ2VfYW5kX3VubG9hZCgpJTBBZmluZXR1bmVkX21vZGVsLnNhdmVfcHJldHJhaW5lZChNRVJHRURfTU9ERUxfUEFUSCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel, PeftConfig


MODEL_NAME = <span class="hljs-string">&quot;meta-llama/Llama-3.1-8B&quot;</span>
ADAPTER_PATH = <span class="hljs-string">&quot;Llama-3.1-8B-finetuned/adapter_default&quot;</span>
MERGED_MODEL_PATH = <span class="hljs-string">&quot;Llama-3.1-8B-dolly&quot;</span>

<span class="hljs-comment"># Load base model</span>
model = AutoModelForCausalLM.from_pretrained(MODEL_NAME)
tokenizer = AutoTokenizer.from_pretrained(MODEL_NAME)

<span class="hljs-comment"># Load adapter configuration and model</span>
adapter_config = PeftConfig.from_pretrained(ADAPTER_PATH)
finetuned_model = PeftModel.from_pretrained(model, ADAPTER_PATH, config=adapter_config)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Saving tokenizer&quot;</span>)
tokenizer.save_pretrained(MERGED_MODEL_PATH)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Saving model&quot;</span>)
finetuned_model = finetuned_model.merge_and_unload()
finetuned_model.save_pretrained(MERGED_MODEL_PATH)`,wrap:!1}}),al=new rl({props:{title:"5. 🤗 Push to Hugging Face Hub",local:"5--push-to-hugging-face-hub",headingTag:"h2"}}),il=new y({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),pl=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQU1FUkdFRF9NT0RFTF9QQVRIJTIwJTNEJTIwJTIyTGxhbWEtMy4xLThCLWRvbGx5JTIyJTBBSFVCX01PREVMX05BTUUlMjAlM0QlMjAlMjJ5b3VyLXVzZXJuYW1lJTJGbGxhbWEzLjEtOGItZG9sbHklMjIlMEElMEElMjMlMjBMb2FkJTIwYW5kJTIwcHVzaCUyMHRva2VuaXplciUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKE1FUkdFRF9NT0RFTF9QQVRIKSUwQXRva2VuaXplci5wdXNoX3RvX2h1YihIVUJfTU9ERUxfTkFNRSklMEElMEElMjMlMjBMb2FkJTIwYW5kJTIwcHVzaCUyMG1vZGVsJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoTUVSR0VEX01PREVMX1BBVEgpJTBBbW9kZWwucHVzaF90b19odWIoSFVCX01PREVMX05BTUUp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

MERGED_MODEL_PATH = <span class="hljs-string">&quot;Llama-3.1-8B-dolly&quot;</span>
HUB_MODEL_NAME = <span class="hljs-string">&quot;your-username/llama3.1-8b-dolly&quot;</span>

<span class="hljs-comment"># Load and push tokenizer</span>
tokenizer = AutoTokenizer.from_pretrained(MERGED_MODEL_PATH)
tokenizer.push_to_hub(HUB_MODEL_NAME)

<span class="hljs-comment"># Load and push model</span>
model = AutoModelForCausalLM.from_pretrained(MERGED_MODEL_PATH)
model.push_to_hub(HUB_MODEL_NAME)`,wrap:!1}}),{c(){u=M("meta"),Jl=a(),ml=M("p"),yl=a(),p(d.$$.fragment),ul=a(),p(c.$$.fragment),dl=a(),j=M("p"),j.textContent=mt,cl=a(),w=M("p"),w.innerHTML=Ut,jl=a(),p(h.$$.fragment),wl=a(),b=M("p"),b.innerHTML=Jt,hl=a(),f=M("p"),f.textContent=yt,bl=a(),I=M("ul"),I.innerHTML=ut,fl=a(),R=M("p"),R.innerHTML=dt,Il=a(),Z=M("p"),Z.innerHTML=ct,Rl=a(),p(E.$$.fragment),Zl=a(),p(C.$$.fragment),El=a(),g=M("p"),g.innerHTML=jt,Cl=a(),p(B.$$.fragment),gl=a(),W=M("p"),W.innerHTML=wt,Bl=a(),p(_.$$.fragment),Wl=a(),V=M("p"),V.textContent=ht,_l=a(),F=M("p"),F.textContent=bt,Vl=a(),p(N.$$.fragment),Fl=a(),G=M("p"),G.innerHTML=ft,Nl=a(),p(X.$$.fragment),Gl=a(),Q=M("p"),Q.innerHTML=It,Xl=a(),S=M("p"),S.innerHTML=Rt,Ql=a(),A=M("p"),A.innerHTML=Zt,Sl=a(),x=M("ul"),x.innerHTML=Et,Al=a(),k=M("p"),k.textContent=Ct,xl=a(),v=M("p"),v.textContent=gt,kl=a(),p(Y.$$.fragment),vl=a(),L=M("p"),L.innerHTML=Bt,Yl=a(),$=M("p"),$.textContent=Wt,Ll=a(),p(z.$$.fragment),$l=a(),H=M("p"),H.innerHTML=_t,zl=a(),p(q.$$.fragment),Hl=a(),p(D.$$.fragment),ql=a(),P=M("p"),P.textContent=Vt,Dl=a(),O=M("p"),O.textContent=Ft,Pl=a(),p(K.$$.fragment),Ol=a(),ll=M("p"),ll.innerHTML=Nt,Kl=a(),p(tl.$$.fragment),lt=a(),el=M("p"),el.textContent=Gt,tt=a(),sl=M("p"),sl.textContent=Xt,et=a(),p(al.$$.fragment),st=a(),nl=M("p"),nl.textContent=Qt,at=a(),Ml=M("p"),Ml.innerHTML=St,nt=a(),p(il.$$.fragment),Mt=a(),ol=M("p"),ol.innerHTML=At,it=a(),p(pl.$$.fragment),ot=a(),Tl=M("p"),Tl.innerHTML=xt,pt=a(),Ul=M("p"),this.h()},l(l){const t=qt("svelte-u9bgzb",document.head);u=i(t,"META",{name:!0,content:!0}),t.forEach(e),Jl=n(l),ml=i(l,"P",{}),kt(ml).forEach(e),yl=n(l),T(d.$$.fragment,l),ul=n(l),T(c.$$.fragment,l),dl=n(l),j=i(l,"P",{"data-svelte-h":!0}),o(j)!=="svelte-1mnesz9"&&(j.textContent=mt),cl=n(l),w=i(l,"P",{"data-svelte-h":!0}),o(w)!=="svelte-1e1022f"&&(w.innerHTML=Ut),jl=n(l),T(h.$$.fragment,l),wl=n(l),b=i(l,"P",{"data-svelte-h":!0}),o(b)!=="svelte-43r1bv"&&(b.innerHTML=Jt),hl=n(l),f=i(l,"P",{"data-svelte-h":!0}),o(f)!=="svelte-1ktungo"&&(f.textContent=yt),bl=n(l),I=i(l,"UL",{"data-svelte-h":!0}),o(I)!=="svelte-1efvabb"&&(I.innerHTML=ut),fl=n(l),R=i(l,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1gchww4"&&(R.innerHTML=dt),Il=n(l),Z=i(l,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-9yn5gx"&&(Z.innerHTML=ct),Rl=n(l),T(E.$$.fragment,l),Zl=n(l),T(C.$$.fragment,l),El=n(l),g=i(l,"P",{"data-svelte-h":!0}),o(g)!=="svelte-12qhil6"&&(g.innerHTML=jt),Cl=n(l),T(B.$$.fragment,l),gl=n(l),W=i(l,"P",{"data-svelte-h":!0}),o(W)!=="svelte-25b86y"&&(W.innerHTML=wt),Bl=n(l),T(_.$$.fragment,l),Wl=n(l),V=i(l,"P",{"data-svelte-h":!0}),o(V)!=="svelte-w0b2m2"&&(V.textContent=ht),_l=n(l),F=i(l,"P",{"data-svelte-h":!0}),o(F)!=="svelte-1w4wk9l"&&(F.textContent=bt),Vl=n(l),T(N.$$.fragment,l),Fl=n(l),G=i(l,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1y9evj3"&&(G.innerHTML=ft),Nl=n(l),T(X.$$.fragment,l),Gl=n(l),Q=i(l,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-1iw1mwz"&&(Q.innerHTML=It),Xl=n(l),S=i(l,"P",{"data-svelte-h":!0}),o(S)!=="svelte-dh3p5f"&&(S.innerHTML=Rt),Ql=n(l),A=i(l,"P",{"data-svelte-h":!0}),o(A)!=="svelte-17bz54a"&&(A.innerHTML=Zt),Sl=n(l),x=i(l,"UL",{"data-svelte-h":!0}),o(x)!=="svelte-1iqb34b"&&(x.innerHTML=Et),Al=n(l),k=i(l,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1xxdciy"&&(k.textContent=Ct),xl=n(l),v=i(l,"P",{"data-svelte-h":!0}),o(v)!=="svelte-nfzf7p"&&(v.textContent=gt),kl=n(l),T(Y.$$.fragment,l),vl=n(l),L=i(l,"P",{"data-svelte-h":!0}),o(L)!=="svelte-jkg1sh"&&(L.innerHTML=Bt),Yl=n(l),$=i(l,"P",{"data-svelte-h":!0}),o($)!=="svelte-pvqso5"&&($.textContent=Wt),Ll=n(l),T(z.$$.fragment,l),$l=n(l),H=i(l,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1mvw2gf"&&(H.innerHTML=_t),zl=n(l),T(q.$$.fragment,l),Hl=n(l),T(D.$$.fragment,l),ql=n(l),P=i(l,"P",{"data-svelte-h":!0}),o(P)!=="svelte-46jexq"&&(P.textContent=Vt),Dl=n(l),O=i(l,"P",{"data-svelte-h":!0}),o(O)!=="svelte-9a9g75"&&(O.textContent=Ft),Pl=n(l),T(K.$$.fragment,l),Ol=n(l),ll=i(l,"P",{"data-svelte-h":!0}),o(ll)!=="svelte-1cigzjn"&&(ll.innerHTML=Nt),Kl=n(l),T(tl.$$.fragment,l),lt=n(l),el=i(l,"P",{"data-svelte-h":!0}),o(el)!=="svelte-vght15"&&(el.textContent=Gt),tt=n(l),sl=i(l,"P",{"data-svelte-h":!0}),o(sl)!=="svelte-1s2sm2h"&&(sl.textContent=Xt),et=n(l),T(al.$$.fragment,l),st=n(l),nl=i(l,"P",{"data-svelte-h":!0}),o(nl)!=="svelte-a60mly"&&(nl.textContent=Qt),at=n(l),Ml=i(l,"P",{"data-svelte-h":!0}),o(Ml)!=="svelte-z9yml0"&&(Ml.innerHTML=St),nt=n(l),T(il.$$.fragment,l),Mt=n(l),ol=i(l,"P",{"data-svelte-h":!0}),o(ol)!=="svelte-h2brza"&&(ol.innerHTML=At),it=n(l),T(pl.$$.fragment,l),ot=n(l),Tl=i(l,"P",{"data-svelte-h":!0}),o(Tl)!=="svelte-1okzo1f"&&(Tl.innerHTML=xt),pt=n(l),Ul=i(l,"P",{}),kt(Ul).forEach(e),this.h()},h(){vt(u,"name","hf:doc:metadata"),vt(u,"content",Kt)},m(l,t){Dt(document.head,u),s(l,Jl,t),s(l,ml,t),s(l,yl,t),r(d,l,t),s(l,ul,t),r(c,l,t),s(l,dl,t),s(l,j,t),s(l,cl,t),s(l,w,t),s(l,jl,t),r(h,l,t),s(l,wl,t),s(l,b,t),s(l,hl,t),s(l,f,t),s(l,bl,t),s(l,I,t),s(l,fl,t),s(l,R,t),s(l,Il,t),s(l,Z,t),s(l,Rl,t),r(E,l,t),s(l,Zl,t),r(C,l,t),s(l,El,t),s(l,g,t),s(l,Cl,t),r(B,l,t),s(l,gl,t),s(l,W,t),s(l,Bl,t),r(_,l,t),s(l,Wl,t),s(l,V,t),s(l,_l,t),s(l,F,t),s(l,Vl,t),r(N,l,t),s(l,Fl,t),s(l,G,t),s(l,Nl,t),r(X,l,t),s(l,Gl,t),s(l,Q,t),s(l,Xl,t),s(l,S,t),s(l,Ql,t),s(l,A,t),s(l,Sl,t),s(l,x,t),s(l,Al,t),s(l,k,t),s(l,xl,t),s(l,v,t),s(l,kl,t),r(Y,l,t),s(l,vl,t),s(l,L,t),s(l,Yl,t),s(l,$,t),s(l,Ll,t),r(z,l,t),s(l,$l,t),s(l,H,t),s(l,zl,t),r(q,l,t),s(l,Hl,t),r(D,l,t),s(l,ql,t),s(l,P,t),s(l,Dl,t),s(l,O,t),s(l,Pl,t),r(K,l,t),s(l,Ol,t),s(l,ll,t),s(l,Kl,t),r(tl,l,t),s(l,lt,t),s(l,el,t),s(l,tt,t),s(l,sl,t),s(l,et,t),r(al,l,t),s(l,st,t),s(l,nl,t),s(l,at,t),s(l,Ml,t),s(l,nt,t),r(il,l,t),s(l,Mt,t),s(l,ol,t),s(l,it,t),r(pl,l,t),s(l,ot,t),s(l,Tl,t),s(l,pt,t),s(l,Ul,t),Tt=!0},p:Lt,i(l){Tt||(m(d.$$.fragment,l),m(c.$$.fragment,l),m(h.$$.fragment,l),m(E.$$.fragment,l),m(C.$$.fragment,l),m(B.$$.fragment,l),m(_.$$.fragment,l),m(N.$$.fragment,l),m(X.$$.fragment,l),m(Y.$$.fragment,l),m(z.$$.fragment,l),m(q.$$.fragment,l),m(D.$$.fragment,l),m(K.$$.fragment,l),m(tl.$$.fragment,l),m(al.$$.fragment,l),m(il.$$.fragment,l),m(pl.$$.fragment,l),Tt=!0)},o(l){U(d.$$.fragment,l),U(c.$$.fragment,l),U(h.$$.fragment,l),U(E.$$.fragment,l),U(C.$$.fragment,l),U(B.$$.fragment,l),U(_.$$.fragment,l),U(N.$$.fragment,l),U(X.$$.fragment,l),U(Y.$$.fragment,l),U(z.$$.fragment,l),U(q.$$.fragment,l),U(D.$$.fragment,l),U(K.$$.fragment,l),U(tl.$$.fragment,l),U(al.$$.fragment,l),U(il.$$.fragment,l),U(pl.$$.fragment,l),Tt=!1},d(l){l&&(e(Jl),e(ml),e(yl),e(ul),e(dl),e(j),e(cl),e(w),e(jl),e(wl),e(b),e(hl),e(f),e(bl),e(I),e(fl),e(R),e(Il),e(Z),e(Rl),e(Zl),e(El),e(g),e(Cl),e(gl),e(W),e(Bl),e(Wl),e(V),e(_l),e(F),e(Vl),e(Fl),e(G),e(Nl),e(Gl),e(Q),e(Xl),e(S),e(Ql),e(A),e(Sl),e(x),e(Al),e(k),e(xl),e(v),e(kl),e(vl),e(L),e(Yl),e($),e(Ll),e($l),e(H),e(zl),e(Hl),e(ql),e(P),e(Dl),e(O),e(Pl),e(Ol),e(ll),e(Kl),e(lt),e(el),e(tt),e(sl),e(et),e(st),e(nl),e(at),e(Ml),e(nt),e(Mt),e(ol),e(it),e(ot),e(Tl),e(pt),e(Ul)),e(u),J(d,l),J(c,l),J(h,l),J(E,l),J(C,l),J(B,l),J(_,l),J(N,l),J(X,l),J(Y,l),J(z,l),J(q,l),J(D,l),J(K,l),J(tl,l),J(al,l),J(il,l),J(pl,l)}}}const Kt='{"title":"🚀 Instruction Fine-Tuning of Llama 3.1 8B with LoRA","local":"-instruction-fine-tuning-of-llama-31-8b-with-lora","sections":[{"title":"1. 🛠️ Setup AWS Environment","local":"1--setup-aws-environment","sections":[],"depth":2},{"title":"2. 📊 Load and Prepare the Dataset","local":"2--load-and-prepare-the-dataset","sections":[],"depth":2},{"title":"3. 🎯 Fine-tune Llama 3.1 with NeuronSFTTrainer and PEFT","local":"3--fine-tune-llama-31-with-neuronsfttrainer-and-peft","sections":[],"depth":2},{"title":"4. 🔄 Consolidate and Test the Fine-Tuned Model","local":"4--consolidate-and-test-the-fine-tuned-model","sections":[],"depth":2},{"title":"5. 🤗 Push to Hugging Face Hub","local":"5--push-to-hugging-face-hub","sections":[],"depth":2}],"depth":1}';function le(rt){return $t(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Me extends zt{constructor(u){super(),Ht(this,u,le,Ot,Yt,{})}}export{Me as component};
