import{s as Bl,o as Zl,n as Wl}from"../chunks/scheduler.56725da7.js";import{S as Hl,i as Nl,e as u,s as i,c as o,h as kl,a as h,d as l,b as s,f as Il,g as a,j as d,k as Gl,l as Ll,m as n,n as r,t as m,o as p,p as c}from"../chunks/index.18a26576.js";import{T as Yl}from"../chunks/Tip.5b941656.js";import{C as Fl}from"../chunks/CopyLLMTxtMenu.afed97b6.js";import{C as y}from"../chunks/CodeBlock.328a828a.js";import{H as f}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.56586e0c.js";function xl(ke){let M,w="<strong>Important Limitation</strong>: Models like <code>NeuronModelForSequenceClassification</code>, <code>NeuronModelForQuestionAnswering</code>, etc. use a different compilation path that doesn’t integrate with the cache system. Only <code>NeuronModelForCausalLM</code> and training workflows support caching.";return{c(){M=u("p"),M.innerHTML=w},l($){M=h($,"P",{"data-svelte-h":!0}),d(M)!=="svelte-15db3yp"&&(M.innerHTML=w)},m($,He){n($,M,He)},p:Wl,d($){$&&l(M)}}}function _l(ke){let M,w,$,He,T,Le,b,Ye,j,Fe,U,qt=`<strong>Problem</strong>: Neuron compilation takes 30-60 minutes for large models
<strong>Solution</strong>: Download pre-compiled models in seconds`,xe,J,Ot="The cache system stores compiled Neuron models on HuggingFace Hub, eliminating recompilation time for your team. When you train or load a model, the system automatically checks for cached versions before starting the expensive compilation process.",_e,v,Dt="<strong>Key Benefits:</strong>",Ve,C,Kt="<li><strong>Time savings</strong>: download compiled models in seconds vs. hours of compilation</li> <li><strong>Team collaboration</strong>: share compiled models across team members and instances</li> <li><strong>Cost reduction</strong>: avoid repeated compilation costs on cloud instances</li> <li><strong>Automatic operation</strong>: works transparently with existing code</li>",Se,I,Xe,G,Ee,B,Qe,Z,Re,W,ze,H,el="That’s it! The cache works automatically for supported model classes.",Pe,N,Ae,k,tl="<thead><tr><th>Model Class</th> <th>Cache Support</th> <th>Use Case</th> <th>Notes</th></tr></thead> <tbody><tr><td><code>NeuronTrainer</code></td> <td>✅ Full</td> <td>Training</td> <td>Auto download + upload during training</td></tr> <tr><td><code>NeuronModelForCausalLM</code></td> <td>✅ Full</td> <td>Inference</td> <td>Auto download for inference</td></tr> <tr><td>Other <code>NeuronModelForXXX</code></td> <td>❌ None</td> <td>Inference</td> <td>Use different export mechanism, no cache integration</td></tr></tbody>",qe,g,Oe,L,De,Y,ll="The cache system operates on two levels to minimize compilation time:",Ke,F,nl="<strong>Cache Priority</strong> (fastest to slowest):",et,x,il="<li><strong>Local cache</strong> → instant access from <code>/var/tmp/neuron-compile-cache</code></li> <li><strong>Hub cache</strong> → download in seconds from HuggingFace Hub</li> <li><strong>Compile from scratch</strong> → 30-60 minutes for large models</li>",tt,_,sl="<strong>What Gets Cached</strong>: the system caches <strong>NEFF files</strong> (Neuron Executable File Format) - the compiled binary artifacts that run on Neuron cores, not the original model files.",lt,V,ol="<strong>Cache Identification</strong>: each cached compilation gets a unique hash based on:",nt,S,al="<li><strong>Model factors</strong>: architecture, precision (fp16/bf16), input shapes, task type</li> <li><strong>Compilation factors</strong>: NeuronX compiler version, number of cores, optimization flags</li> <li><strong>Environment factors</strong>: model checkpoint revision, Optimum Neuron version</li>",it,X,rl="This means even small changes to your setup may require recompilation, but identical configurations will always hit the cache.",st,E,ot,Q,ml="The default public cache (<code>aws-neuron/optimum-neuron-cache</code>) is <strong>read-only</strong> for users - you can download cached models but cannot upload your own compilations. This public cache only contains models compiled by the Optimum team for common configurations.",at,R,pl="For most use cases, you’ll want to create a <strong>private cache repository</strong> where you can store your own compiled models.",rt,z,cl="<strong>Why private cache?</strong>",mt,P,ul="<li><strong>Upload your compilations</strong>: store models you compile for team reuse</li> <li><strong>Private models</strong>: keep proprietary model compilations secure</li> <li><strong>Team collaboration</strong>: share compiled artifacts across team members and CI/CD</li> <li><strong>Custom configurations</strong>: cache models with your specific batch sizes, sequence lengths, etc.</li>",pt,A,ct,q,ut,O,ht,D,dt,K,hl="<strong>Prerequisites:</strong>",ft,ee,dl="<li>Login: <code>huggingface-cli login</code></li> <li>write access to cache repository</li>",Mt,te,yt,le,$t,ne,gt,ie,wt,se,fl="If you do not use the <code>NeuronTrainer</code> class, you can still leverage the cache system in your custom training loops. This is useful when you need more control over the training process or when integrating with custom training frameworks while still benefiting from cached compilations.",Tt,oe,Ml="<strong>When to use this approach:</strong>",bt,ae,yl="<li>custom training loops that don’t fit the <code>NeuronTrainer</code> pattern</li> <li>advanced optimization scenarios requiring fine-grained control</li>",jt,re,$l="<strong>Note</strong>: For most use cases, <code>NeuronTrainer</code> handles caching automatically and is the recommended approach.",Ut,me,Jt,pe,vt,ce,gl="The inference cache includes a <strong>registry</strong> that lets you search for compatible pre-compiled models before attempting compilation. This is especially useful for inference where you want to avoid compilation altogether.",Ct,ue,It,he,wl="<strong>Important</strong>: Finding entries doesn’t guarantee cache hits. Your exact configuration must match the cached parameters, including compiler version and model revision.",Gt,de,Bt,fe,Tl="The cache system works seamlessly in automated environments:",Zt,Me,bl="<strong>Environment Variables</strong>: use <code>CUSTOM_CACHE_REPO</code> to specify cache repository in CI workflows",Wt,ye,Ht,$e,jl="<strong>Authentication</strong>: ensure your CI environment has access to your private cache repository:",Nt,ge,Ul="<li>Set <code>HF_TOKEN</code> environment variable with appropriate read/write permissions</li> <li>For GitHub Actions, store as a repository secret</li>",kt,we,Jl="<strong>Best Practices</strong>:",Lt,Te,vl="<li>use separate cache repositories for different environments (dev/staging/prod)</li> <li>consider cache repository permissions when setting up automated workflows</li> <li>monitor cache repository size in long-running CI workflows</li>",Yt,be,Ft,je,xt,Ue,_t,Je,Vt,ve,St,Ce,Xt,Ie,Et,Ge,Qt,Be,Rt,Ze,zt,We,Pt,Ne,At;return T=new Fl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),b=new f({props:{title:"Neuron Model Cache",local:"neuron-model-cache",headingTag:"h1"}}),j=new f({props:{title:"Why Use the Cache?",local:"why-use-the-cache",headingTag:"h2"}}),I=new f({props:{title:"Quick Start",local:"quick-start",headingTag:"h2"}}),G=new f({props:{title:"Training",local:"training",headingTag:"h3"}}),B=new y({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uVHJhaW5lciUwQSUwQSUyMyUyMENhY2hlJTIwd29ya3MlMjBhdXRvbWF0aWNhbGx5JTIwLSUyMG5vJTIwY29uZmlndXJhdGlvbiUyMG5lZWRlZCUwQXRyYWluZXIlMjAlM0QlMjBOZXVyb25UcmFpbmVyKG1vZGVsJTNEbW9kZWwlMkMlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyklMEF0cmFpbmVyLnRyYWluKCklMjAlMjAlMjMlMjBEb3dubG9hZHMlMjBjYWNoZWQlMjBtb2RlbHMlMjBpZiUyMGF2YWlsYWJsZQ==",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronTrainer

<span class="hljs-comment"># Cache works automatically - no configuration needed</span>
trainer = NeuronTrainer(model=model, args=training_args)
trainer.train()  <span class="hljs-comment"># Downloads cached models if available</span>`,wrap:!1}}),Z=new f({props:{title:"Inference",local:"inference",headingTag:"h3"}}),W=new y({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uTW9kZWxGb3JDYXVzYWxMTSUwQSUwQSUyMyUyMENhY2hlJTIwd29ya3MlMjBhdXRvbWF0aWNhbGx5JTBBbW9kZWwlMjAlM0QlMjBOZXVyb25Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJtb2RlbF9pZCUyMik=",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForCausalLM

<span class="hljs-comment"># Cache works automatically</span>
model = NeuronModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;model_id&quot;</span>)`,wrap:!1}}),N=new f({props:{title:"Supported Models",local:"supported-models",headingTag:"h2"}}),g=new Yl({props:{warning:!0,$$slots:{default:[xl]},$$scope:{ctx:ke}}}),L=new f({props:{title:"How It Works",local:"how-it-works",headingTag:"h2"}}),E=new f({props:{title:"Private Cache Setup",local:"private-cache-setup",headingTag:"h2"}}),A=new f({props:{title:"Method 1: CLI Setup (Recommended)",local:"method-1-cli-setup-recommended",headingTag:"h3"}}),q=new y({props:{code:"JTIzJTIwQ3JlYXRlJTIwcHJpdmF0ZSUyMGNhY2hlJTIwcmVwb3NpdG9yeSUwQW9wdGltdW0tY2xpJTIwbmV1cm9uJTIwY2FjaGUlMjBjcmVhdGUlMEElMEElMjMlMjBTZXQlMjBhcyUyMGRlZmF1bHQlMjBjYWNoZSUwQW9wdGltdW0tY2xpJTIwbmV1cm9uJTIwY2FjaGUlMjBzZXQlMjB5b3VyLW9yZyUyRnlvdXItY2FjaGUtbmFtZQ==",highlighted:`<span class="hljs-comment"># Create private cache repository</span>
optimum-cli neuron cache create

<span class="hljs-comment"># Set as default cache</span>
optimum-cli neuron cache <span class="hljs-built_in">set</span> your-org/your-cache-name`,wrap:!1}}),O=new f({props:{title:"Method 2: Environment Variable",local:"method-2-environment-variable",headingTag:"h3"}}),D=new y({props:{code:"JTIzJTIwVXNlJTIwZm9yJTIwc2luZ2xlJTIwdHJhaW5pbmclMjBydW4lMEFDVVNUT01fQ0FDSEVfUkVQTyUzRCUyMnlvdXItb3JnJTJGeW91ci1jYWNoZSUyMiUyMHB5dGhvbiUyMHRyYWluLnB5JTBBJTBBJTIzJTIwT3IlMjBleHBvcnQlMjBmb3IlMjBzZXNzaW9uJTBBZXhwb3J0JTIwQ1VTVE9NX0NBQ0hFX1JFUE8lM0QlMjJ5b3VyLW9yZyUyRnlvdXItY2FjaGUlMjI=",highlighted:`<span class="hljs-comment"># Use for single training run</span>
CUSTOM_CACHE_REPO=<span class="hljs-string">&quot;your-org/your-cache&quot;</span> python train.py

<span class="hljs-comment"># Or export for session</span>
<span class="hljs-built_in">export</span> CUSTOM_CACHE_REPO=<span class="hljs-string">&quot;your-org/your-cache&quot;</span>`,wrap:!1}}),te=new f({props:{title:"CLI Commands",local:"cli-commands",headingTag:"h2"}}),le=new y({props:{code:"JTIzJTIwQ3JlYXRlJTIwbmV3JTIwY2FjaGUlMjByZXBvc2l0b3J5JTBBb3B0aW11bS1jbGklMjBuZXVyb24lMjBjYWNoZSUyMGNyZWF0ZSUyMCU1Qi1uJTIwTkFNRSU1RCUyMCU1Qi0tcHVibGljJTVEJTBBJTBBJTIzJTIwU2V0JTIwZGVmYXVsdCUyMGNhY2hlJTIwcmVwb3NpdG9yeSUwQW9wdGltdW0tY2xpJTIwbmV1cm9uJTIwY2FjaGUlMjBzZXQlMjBSRVBPX05BTUUlMEElMEElMjMlMjBTZWFyY2glMjBmb3IlMjBjYWNoZWQlMjBtb2RlbHMlMEFvcHRpbXVtLWNsaSUyMG5ldXJvbiUyMGNhY2hlJTIwbG9va3VwJTIwTU9ERUxfSUQlMEElMEElMjMlMjBTeW5jJTIwbG9jYWwlMjBjYWNoZSUyMHdpdGglMjBIdWIlMEFvcHRpbXVtLWNsaSUyMG5ldXJvbiUyMGNhY2hlJTIwc3luY2hyb25pemU=",highlighted:`<span class="hljs-comment"># Create new cache repository</span>
optimum-cli neuron cache create [-n NAME] [--public]

<span class="hljs-comment"># Set default cache repository</span>
optimum-cli neuron cache <span class="hljs-built_in">set</span> REPO_NAME

<span class="hljs-comment"># Search for cached models</span>
optimum-cli neuron cache lookup MODEL_ID

<span class="hljs-comment"># Sync local cache with Hub</span>
optimum-cli neuron cache synchronize`,wrap:!1}}),ne=new f({props:{title:"Advanced Usage",local:"advanced-usage",headingTag:"h2"}}),ie=new f({props:{title:"Use the Cache in Training Loops",local:"use-the-cache-in-training-loops",headingTag:"h3"}}),me=new y({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uLmNhY2hlJTIwaW1wb3J0JTIwaHViX25ldXJvbnhfY2FjaGUlMkMlMjBzeW5jaHJvbml6ZV9odWJfY2FjaGUlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24uY2FjaGUuZW50cmllcyUyMGltcG9ydCUyMFNpbmdsZU1vZGVsQ2FjaGVFbnRyeSUwQWZyb20lMjBvcHRpbXVtLm5ldXJvbi5jYWNoZS50cmFpbmluZyUyMGltcG9ydCUyMHBhdGNoX25ldXJvbl9jY193cmFwcGVyJTBBJTBBJTIzJTIwQ3JlYXRlJTIwY2FjaGUlMjBlbnRyeSUwQWNhY2hlX2VudHJ5JTIwJTNEJTIwU2luZ2xlTW9kZWxDYWNoZUVudHJ5KG1vZGVsX2lkJTJDJTIwdGFzayUyQyUyMGNvbmZpZyUyQyUyMG5ldXJvbl9jb25maWcpJTBBJTBBJTIzJTIwVGhlJTIwTmV1cm9uWCUyMGNvbXBpbGVyJTIwd2lsbCUyMHVzZSUyMHRoZSUyMEh1Z2dpbmclMjBGYWNlJTIwSHViJTIwY2FjaGUlMjBzeXN0ZW0lMEF3aXRoJTIwcGF0Y2hfbmV1cm9uX2NjX3dyYXBwZXIoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFRoZSUyMGNvbXBpbGVyJTIwd2lsbCUyMGNoZWNrJTIwdGhlJTIwc3BlY2lmaWVkJTIwcmVtb3RlJTIwY2FjaGUlMjBmb3IlMjBwcmUtY29tcGlsZWQlMjBORUZGJTIwZmlsZXMlMEElMjAlMjAlMjAlMjB3aXRoJTIwaHViX25ldXJvbnhfY2FjaGUoZW50cnklM0RjYWNoZV9lbnRyeSUyQyUyMGNhY2hlX3JlcG9faWQlM0QlMjJteS1vcmclMkZjYWNoZSUyMiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyMHRyYWluaW5nX2xvb3AoKSUyMCUyMCUyMyUyMFdpbGwlMjB1c2UlMjBzcGVjaWZpZWQlMjBjYWNoZSUwQSUwQSUyMyUyMFN5bmNocm9uaXplJTIwbG9jYWwlMjBjYWNoZSUyMHdpdGglMjBIdWIlMEFzeW5jaHJvbml6ZV9odWJfY2FjaGUoY2FjaGVfcmVwb19pZCUzRCUyMm15LW9yZyUyRmNhY2hlJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron.cache <span class="hljs-keyword">import</span> hub_neuronx_cache, synchronize_hub_cache
<span class="hljs-keyword">from</span> optimum.neuron.cache.entries <span class="hljs-keyword">import</span> SingleModelCacheEntry
<span class="hljs-keyword">from</span> optimum.neuron.cache.training <span class="hljs-keyword">import</span> patch_neuron_cc_wrapper

<span class="hljs-comment"># Create cache entry</span>
cache_entry = SingleModelCacheEntry(model_id, task, config, neuron_config)

<span class="hljs-comment"># The NeuronX compiler will use the Hugging Face Hub cache system</span>
<span class="hljs-keyword">with</span> patch_neuron_cc_wrapper():
    <span class="hljs-comment"># The compiler will check the specified remote cache for pre-compiled NEFF files</span>
    <span class="hljs-keyword">with</span> hub_neuronx_cache(entry=cache_entry, cache_repo_id=<span class="hljs-string">&quot;my-org/cache&quot;</span>):
        model = training_loop()  <span class="hljs-comment"># Will use specified cache</span>

<span class="hljs-comment"># Synchronize local cache with Hub</span>
synchronize_hub_cache(cache_repo_id=<span class="hljs-string">&quot;my-org/cache&quot;</span>)`,wrap:!1}}),pe=new f({props:{title:"Cache Lookup",local:"cache-lookup",headingTag:"h3"}}),ue=new y({props:{code:"b3B0aW11bS1jbGklMjBuZXVyb24lMjBjYWNoZSUyMGxvb2t1cCUyMG1ldGEtbGxhbWElMkZMbGFtYS0yLTdiLWNoYXQtaGY=",highlighted:"optimum-cli neuron cache lookup meta-llama/Llama-2-7b-chat-hf",wrap:!1}}),de=new f({props:{title:"CI/CD Integration",local:"cicd-integration",headingTag:"h2"}}),ye=new y({props:{code:"JTIzJTIwSW4lMjB5b3VyJTIwQ0klMjBjb25maWd1cmF0aW9uJTBBQ1VTVE9NX0NBQ0hFX1JFUE8lM0QlMjJ5b3VyLW9yZyUyRnlvdXItY2FjaGUlMjIlMjBweXRob24lMjB0cmFpbi5weQ==",highlighted:`<span class="hljs-comment"># In your CI configuration</span>
CUSTOM_CACHE_REPO=<span class="hljs-string">&quot;your-org/your-cache&quot;</span> python train.py`,wrap:!1}}),be=new f({props:{title:"Troubleshooting",local:"troubleshooting",headingTag:"h2"}}),je=new f({props:{title:"“Cache repository does not exist”",local:"cache-repository-does-not-exist",headingTag:"h3"}}),Ue=new y({props:{code:"Rml4JTNBJTIwQ2hlY2slMjByZXBvc2l0b3J5JTIwbmFtZSUyMGFuZCUyMGxvZ2luJTIwc3RhdHVzJTBBJUUyJTg2JTkyJTIwaHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4lMEElRTIlODYlOTIlMjBWZXJpZnklMjByZXBvJTIwZm9ybWF0JTNBJTIwb3JnJTJGcmVwby1uYW1l",highlighted:`Fix: Check repository name and login status
→ huggingface-cli login
→ Verify repo format: org/repo-name`,wrap:!1}}),Je=new f({props:{title:"“Graph will be recompiled”",local:"graph-will-be-recompiled",headingTag:"h3"}}),ve=new y({props:{code:"Q2F1c2UlM0ElMjBObyUyMGNhY2hlZCUyMG1vZGVsJTIwbWF0Y2hlcyUyMHlvdXIlMjBleGFjdCUyMGNvbmZpZ3VyYXRpb24lMEFGaXglM0ElMjBVc2UlMjBsb29rdXAlMjB0byUyMGZpbmQlMjBjb21wYXRpYmxlJTIwY29uZmlndXJhdGlvbnMlMEElRTIlODYlOTIlMjBvcHRpbXVtLWNsaSUyMG5ldXJvbiUyMGNhY2hlJTIwbG9va3VwJTIwTU9ERUxfSUQ=",highlighted:`Cause: No cached model matches your exact configuration
Fix: Use lookup to find compatible configurations
→ optimum-cli neuron cache lookup MODEL_ID`,wrap:!1}}),Ce=new f({props:{title:"Cache not uploading during training",local:"cache-not-uploading-during-training",headingTag:"h3"}}),Ie=new y({props:{code:"Q2F1c2UlM0ElMjBObyUyMHdyaXRlJTIwcGVybWlzc2lvbnMlMjB0byUyMGNhY2hlJTIwcmVwb3NpdG9yeSUwQUZpeCUzQSUyMFZlcmlmeSUyMGFjY2VzcyUyMGFuZCUyMGF1dGhlbnRpY2F0aW9uJTBBJUUyJTg2JTkyJTIwaHVnZ2luZ2ZhY2UtY2xpJTIwd2hvYW1pJTBBJUUyJTg2JTkyJTIwQ2hlY2slMjBjYWNoZSUyMHJlcG8lMjBwZXJtaXNzaW9ucw==",highlighted:`Cause: No write permissions to cache repository
Fix: Verify access and authentication
→ huggingface-cli whoami
→ Check cache repo permissions`,wrap:!1}}),Ge=new f({props:{title:"Slow downloads",local:"slow-downloads",headingTag:"h3"}}),Be=new y({props:{code:"Q2F1c2UlM0ElMjBMYXJnZSUyMGNvbXBpbGVkJTIwbW9kZWxzJTIwKEdCcyklMjBkb3dubG9hZGluZyUwQUZpeCUzQSUyMEVuc3VyZSUyMGdvb2QlMjBpbnRlcm5ldCUyMGNvbm5lY3Rpb24lMEElRTIlODYlOTIlMjBNb25pdG9yJTIwbG9ncyUyMGZvciUyMGRvd25sb2FkJTIwcHJvZ3Jlc3M=",highlighted:`Cause: Large compiled models (GBs) downloading
Fix: Ensure good internet connection
→ Monitor logs for download progress`,wrap:!1}}),Ze=new f({props:{title:"Clear corrupted local cache",local:"clear-corrupted-local-cache",headingTag:"h3"}}),We=new y({props:{code:"cm0lMjAtcmYlMjAlMkZ2YXIlMkZ0bXAlMkZuZXVyb24tY29tcGlsZS1jYWNoZSUyRio=",highlighted:'<span class="hljs-built_in">rm</span> -rf /var/tmp/neuron-compile-cache/*',wrap:!1}}),{c(){M=u("meta"),w=i(),$=u("p"),He=i(),o(T.$$.fragment),Le=i(),o(b.$$.fragment),Ye=i(),o(j.$$.fragment),Fe=i(),U=u("p"),U.innerHTML=qt,xe=i(),J=u("p"),J.textContent=Ot,_e=i(),v=u("p"),v.innerHTML=Dt,Ve=i(),C=u("ul"),C.innerHTML=Kt,Se=i(),o(I.$$.fragment),Xe=i(),o(G.$$.fragment),Ee=i(),o(B.$$.fragment),Qe=i(),o(Z.$$.fragment),Re=i(),o(W.$$.fragment),ze=i(),H=u("p"),H.textContent=el,Pe=i(),o(N.$$.fragment),Ae=i(),k=u("table"),k.innerHTML=tl,qe=i(),o(g.$$.fragment),Oe=i(),o(L.$$.fragment),De=i(),Y=u("p"),Y.textContent=ll,Ke=i(),F=u("p"),F.innerHTML=nl,et=i(),x=u("ol"),x.innerHTML=il,tt=i(),_=u("p"),_.innerHTML=sl,lt=i(),V=u("p"),V.innerHTML=ol,nt=i(),S=u("ul"),S.innerHTML=al,it=i(),X=u("p"),X.textContent=rl,st=i(),o(E.$$.fragment),ot=i(),Q=u("p"),Q.innerHTML=ml,at=i(),R=u("p"),R.innerHTML=pl,rt=i(),z=u("p"),z.innerHTML=cl,mt=i(),P=u("ul"),P.innerHTML=ul,pt=i(),o(A.$$.fragment),ct=i(),o(q.$$.fragment),ut=i(),o(O.$$.fragment),ht=i(),o(D.$$.fragment),dt=i(),K=u("p"),K.innerHTML=hl,ft=i(),ee=u("ul"),ee.innerHTML=dl,Mt=i(),o(te.$$.fragment),yt=i(),o(le.$$.fragment),$t=i(),o(ne.$$.fragment),gt=i(),o(ie.$$.fragment),wt=i(),se=u("p"),se.innerHTML=fl,Tt=i(),oe=u("p"),oe.innerHTML=Ml,bt=i(),ae=u("ul"),ae.innerHTML=yl,jt=i(),re=u("p"),re.innerHTML=$l,Ut=i(),o(me.$$.fragment),Jt=i(),o(pe.$$.fragment),vt=i(),ce=u("p"),ce.innerHTML=gl,Ct=i(),o(ue.$$.fragment),It=i(),he=u("p"),he.innerHTML=wl,Gt=i(),o(de.$$.fragment),Bt=i(),fe=u("p"),fe.textContent=Tl,Zt=i(),Me=u("p"),Me.innerHTML=bl,Wt=i(),o(ye.$$.fragment),Ht=i(),$e=u("p"),$e.innerHTML=jl,Nt=i(),ge=u("ul"),ge.innerHTML=Ul,kt=i(),we=u("p"),we.innerHTML=Jl,Lt=i(),Te=u("ul"),Te.innerHTML=vl,Yt=i(),o(be.$$.fragment),Ft=i(),o(je.$$.fragment),xt=i(),o(Ue.$$.fragment),_t=i(),o(Je.$$.fragment),Vt=i(),o(ve.$$.fragment),St=i(),o(Ce.$$.fragment),Xt=i(),o(Ie.$$.fragment),Et=i(),o(Ge.$$.fragment),Qt=i(),o(Be.$$.fragment),Rt=i(),o(Ze.$$.fragment),zt=i(),o(We.$$.fragment),Pt=i(),Ne=u("p"),this.h()},l(e){const t=kl("svelte-u9bgzb",document.head);M=h(t,"META",{name:!0,content:!0}),t.forEach(l),w=s(e),$=h(e,"P",{}),Il($).forEach(l),He=s(e),a(T.$$.fragment,e),Le=s(e),a(b.$$.fragment,e),Ye=s(e),a(j.$$.fragment,e),Fe=s(e),U=h(e,"P",{"data-svelte-h":!0}),d(U)!=="svelte-1ne5jqk"&&(U.innerHTML=qt),xe=s(e),J=h(e,"P",{"data-svelte-h":!0}),d(J)!=="svelte-10mqjfi"&&(J.textContent=Ot),_e=s(e),v=h(e,"P",{"data-svelte-h":!0}),d(v)!=="svelte-1c3q00"&&(v.innerHTML=Dt),Ve=s(e),C=h(e,"UL",{"data-svelte-h":!0}),d(C)!=="svelte-qr4kj2"&&(C.innerHTML=Kt),Se=s(e),a(I.$$.fragment,e),Xe=s(e),a(G.$$.fragment,e),Ee=s(e),a(B.$$.fragment,e),Qe=s(e),a(Z.$$.fragment,e),Re=s(e),a(W.$$.fragment,e),ze=s(e),H=h(e,"P",{"data-svelte-h":!0}),d(H)!=="svelte-jto7nf"&&(H.textContent=el),Pe=s(e),a(N.$$.fragment,e),Ae=s(e),k=h(e,"TABLE",{"data-svelte-h":!0}),d(k)!=="svelte-1fyprry"&&(k.innerHTML=tl),qe=s(e),a(g.$$.fragment,e),Oe=s(e),a(L.$$.fragment,e),De=s(e),Y=h(e,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-1q5edhc"&&(Y.textContent=ll),Ke=s(e),F=h(e,"P",{"data-svelte-h":!0}),d(F)!=="svelte-extx4"&&(F.innerHTML=nl),et=s(e),x=h(e,"OL",{"data-svelte-h":!0}),d(x)!=="svelte-13m01m6"&&(x.innerHTML=il),tt=s(e),_=h(e,"P",{"data-svelte-h":!0}),d(_)!=="svelte-1f7xr5v"&&(_.innerHTML=sl),lt=s(e),V=h(e,"P",{"data-svelte-h":!0}),d(V)!=="svelte-16epk2o"&&(V.innerHTML=ol),nt=s(e),S=h(e,"UL",{"data-svelte-h":!0}),d(S)!=="svelte-u7un7n"&&(S.innerHTML=al),it=s(e),X=h(e,"P",{"data-svelte-h":!0}),d(X)!=="svelte-1ifb4sf"&&(X.textContent=rl),st=s(e),a(E.$$.fragment,e),ot=s(e),Q=h(e,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-3n33pg"&&(Q.innerHTML=ml),at=s(e),R=h(e,"P",{"data-svelte-h":!0}),d(R)!=="svelte-1yed0md"&&(R.innerHTML=pl),rt=s(e),z=h(e,"P",{"data-svelte-h":!0}),d(z)!=="svelte-cdnk1d"&&(z.innerHTML=cl),mt=s(e),P=h(e,"UL",{"data-svelte-h":!0}),d(P)!=="svelte-walclc"&&(P.innerHTML=ul),pt=s(e),a(A.$$.fragment,e),ct=s(e),a(q.$$.fragment,e),ut=s(e),a(O.$$.fragment,e),ht=s(e),a(D.$$.fragment,e),dt=s(e),K=h(e,"P",{"data-svelte-h":!0}),d(K)!=="svelte-18p63as"&&(K.innerHTML=hl),ft=s(e),ee=h(e,"UL",{"data-svelte-h":!0}),d(ee)!=="svelte-168ncg2"&&(ee.innerHTML=dl),Mt=s(e),a(te.$$.fragment,e),yt=s(e),a(le.$$.fragment,e),$t=s(e),a(ne.$$.fragment,e),gt=s(e),a(ie.$$.fragment,e),wt=s(e),se=h(e,"P",{"data-svelte-h":!0}),d(se)!=="svelte-141w8az"&&(se.innerHTML=fl),Tt=s(e),oe=h(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-1paop45"&&(oe.innerHTML=Ml),bt=s(e),ae=h(e,"UL",{"data-svelte-h":!0}),d(ae)!=="svelte-e0aew4"&&(ae.innerHTML=yl),jt=s(e),re=h(e,"P",{"data-svelte-h":!0}),d(re)!=="svelte-rti9w"&&(re.innerHTML=$l),Ut=s(e),a(me.$$.fragment,e),Jt=s(e),a(pe.$$.fragment,e),vt=s(e),ce=h(e,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-phsox0"&&(ce.innerHTML=gl),Ct=s(e),a(ue.$$.fragment,e),It=s(e),he=h(e,"P",{"data-svelte-h":!0}),d(he)!=="svelte-101fp4q"&&(he.innerHTML=wl),Gt=s(e),a(de.$$.fragment,e),Bt=s(e),fe=h(e,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-1q4kquv"&&(fe.textContent=Tl),Zt=s(e),Me=h(e,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-1rwaldf"&&(Me.innerHTML=bl),Wt=s(e),a(ye.$$.fragment,e),Ht=s(e),$e=h(e,"P",{"data-svelte-h":!0}),d($e)!=="svelte-1t0yadi"&&($e.innerHTML=jl),Nt=s(e),ge=h(e,"UL",{"data-svelte-h":!0}),d(ge)!=="svelte-130w3q8"&&(ge.innerHTML=Ul),kt=s(e),we=h(e,"P",{"data-svelte-h":!0}),d(we)!=="svelte-120tdf7"&&(we.innerHTML=Jl),Lt=s(e),Te=h(e,"UL",{"data-svelte-h":!0}),d(Te)!=="svelte-bp9m1l"&&(Te.innerHTML=vl),Yt=s(e),a(be.$$.fragment,e),Ft=s(e),a(je.$$.fragment,e),xt=s(e),a(Ue.$$.fragment,e),_t=s(e),a(Je.$$.fragment,e),Vt=s(e),a(ve.$$.fragment,e),St=s(e),a(Ce.$$.fragment,e),Xt=s(e),a(Ie.$$.fragment,e),Et=s(e),a(Ge.$$.fragment,e),Qt=s(e),a(Be.$$.fragment,e),Rt=s(e),a(Ze.$$.fragment,e),zt=s(e),a(We.$$.fragment,e),Pt=s(e),Ne=h(e,"P",{}),Il(Ne).forEach(l),this.h()},h(){Gl(M,"name","hf:doc:metadata"),Gl(M,"content",Vl)},m(e,t){Ll(document.head,M),n(e,w,t),n(e,$,t),n(e,He,t),r(T,e,t),n(e,Le,t),r(b,e,t),n(e,Ye,t),r(j,e,t),n(e,Fe,t),n(e,U,t),n(e,xe,t),n(e,J,t),n(e,_e,t),n(e,v,t),n(e,Ve,t),n(e,C,t),n(e,Se,t),r(I,e,t),n(e,Xe,t),r(G,e,t),n(e,Ee,t),r(B,e,t),n(e,Qe,t),r(Z,e,t),n(e,Re,t),r(W,e,t),n(e,ze,t),n(e,H,t),n(e,Pe,t),r(N,e,t),n(e,Ae,t),n(e,k,t),n(e,qe,t),r(g,e,t),n(e,Oe,t),r(L,e,t),n(e,De,t),n(e,Y,t),n(e,Ke,t),n(e,F,t),n(e,et,t),n(e,x,t),n(e,tt,t),n(e,_,t),n(e,lt,t),n(e,V,t),n(e,nt,t),n(e,S,t),n(e,it,t),n(e,X,t),n(e,st,t),r(E,e,t),n(e,ot,t),n(e,Q,t),n(e,at,t),n(e,R,t),n(e,rt,t),n(e,z,t),n(e,mt,t),n(e,P,t),n(e,pt,t),r(A,e,t),n(e,ct,t),r(q,e,t),n(e,ut,t),r(O,e,t),n(e,ht,t),r(D,e,t),n(e,dt,t),n(e,K,t),n(e,ft,t),n(e,ee,t),n(e,Mt,t),r(te,e,t),n(e,yt,t),r(le,e,t),n(e,$t,t),r(ne,e,t),n(e,gt,t),r(ie,e,t),n(e,wt,t),n(e,se,t),n(e,Tt,t),n(e,oe,t),n(e,bt,t),n(e,ae,t),n(e,jt,t),n(e,re,t),n(e,Ut,t),r(me,e,t),n(e,Jt,t),r(pe,e,t),n(e,vt,t),n(e,ce,t),n(e,Ct,t),r(ue,e,t),n(e,It,t),n(e,he,t),n(e,Gt,t),r(de,e,t),n(e,Bt,t),n(e,fe,t),n(e,Zt,t),n(e,Me,t),n(e,Wt,t),r(ye,e,t),n(e,Ht,t),n(e,$e,t),n(e,Nt,t),n(e,ge,t),n(e,kt,t),n(e,we,t),n(e,Lt,t),n(e,Te,t),n(e,Yt,t),r(be,e,t),n(e,Ft,t),r(je,e,t),n(e,xt,t),r(Ue,e,t),n(e,_t,t),r(Je,e,t),n(e,Vt,t),r(ve,e,t),n(e,St,t),r(Ce,e,t),n(e,Xt,t),r(Ie,e,t),n(e,Et,t),r(Ge,e,t),n(e,Qt,t),r(Be,e,t),n(e,Rt,t),r(Ze,e,t),n(e,zt,t),r(We,e,t),n(e,Pt,t),n(e,Ne,t),At=!0},p(e,[t]){const Cl={};t&2&&(Cl.$$scope={dirty:t,ctx:e}),g.$set(Cl)},i(e){At||(m(T.$$.fragment,e),m(b.$$.fragment,e),m(j.$$.fragment,e),m(I.$$.fragment,e),m(G.$$.fragment,e),m(B.$$.fragment,e),m(Z.$$.fragment,e),m(W.$$.fragment,e),m(N.$$.fragment,e),m(g.$$.fragment,e),m(L.$$.fragment,e),m(E.$$.fragment,e),m(A.$$.fragment,e),m(q.$$.fragment,e),m(O.$$.fragment,e),m(D.$$.fragment,e),m(te.$$.fragment,e),m(le.$$.fragment,e),m(ne.$$.fragment,e),m(ie.$$.fragment,e),m(me.$$.fragment,e),m(pe.$$.fragment,e),m(ue.$$.fragment,e),m(de.$$.fragment,e),m(ye.$$.fragment,e),m(be.$$.fragment,e),m(je.$$.fragment,e),m(Ue.$$.fragment,e),m(Je.$$.fragment,e),m(ve.$$.fragment,e),m(Ce.$$.fragment,e),m(Ie.$$.fragment,e),m(Ge.$$.fragment,e),m(Be.$$.fragment,e),m(Ze.$$.fragment,e),m(We.$$.fragment,e),At=!0)},o(e){p(T.$$.fragment,e),p(b.$$.fragment,e),p(j.$$.fragment,e),p(I.$$.fragment,e),p(G.$$.fragment,e),p(B.$$.fragment,e),p(Z.$$.fragment,e),p(W.$$.fragment,e),p(N.$$.fragment,e),p(g.$$.fragment,e),p(L.$$.fragment,e),p(E.$$.fragment,e),p(A.$$.fragment,e),p(q.$$.fragment,e),p(O.$$.fragment,e),p(D.$$.fragment,e),p(te.$$.fragment,e),p(le.$$.fragment,e),p(ne.$$.fragment,e),p(ie.$$.fragment,e),p(me.$$.fragment,e),p(pe.$$.fragment,e),p(ue.$$.fragment,e),p(de.$$.fragment,e),p(ye.$$.fragment,e),p(be.$$.fragment,e),p(je.$$.fragment,e),p(Ue.$$.fragment,e),p(Je.$$.fragment,e),p(ve.$$.fragment,e),p(Ce.$$.fragment,e),p(Ie.$$.fragment,e),p(Ge.$$.fragment,e),p(Be.$$.fragment,e),p(Ze.$$.fragment,e),p(We.$$.fragment,e),At=!1},d(e){e&&(l(w),l($),l(He),l(Le),l(Ye),l(Fe),l(U),l(xe),l(J),l(_e),l(v),l(Ve),l(C),l(Se),l(Xe),l(Ee),l(Qe),l(Re),l(ze),l(H),l(Pe),l(Ae),l(k),l(qe),l(Oe),l(De),l(Y),l(Ke),l(F),l(et),l(x),l(tt),l(_),l(lt),l(V),l(nt),l(S),l(it),l(X),l(st),l(ot),l(Q),l(at),l(R),l(rt),l(z),l(mt),l(P),l(pt),l(ct),l(ut),l(ht),l(dt),l(K),l(ft),l(ee),l(Mt),l(yt),l($t),l(gt),l(wt),l(se),l(Tt),l(oe),l(bt),l(ae),l(jt),l(re),l(Ut),l(Jt),l(vt),l(ce),l(Ct),l(It),l(he),l(Gt),l(Bt),l(fe),l(Zt),l(Me),l(Wt),l(Ht),l($e),l(Nt),l(ge),l(kt),l(we),l(Lt),l(Te),l(Yt),l(Ft),l(xt),l(_t),l(Vt),l(St),l(Xt),l(Et),l(Qt),l(Rt),l(zt),l(Pt),l(Ne)),l(M),c(T,e),c(b,e),c(j,e),c(I,e),c(G,e),c(B,e),c(Z,e),c(W,e),c(N,e),c(g,e),c(L,e),c(E,e),c(A,e),c(q,e),c(O,e),c(D,e),c(te,e),c(le,e),c(ne,e),c(ie,e),c(me,e),c(pe,e),c(ue,e),c(de,e),c(ye,e),c(be,e),c(je,e),c(Ue,e),c(Je,e),c(ve,e),c(Ce,e),c(Ie,e),c(Ge,e),c(Be,e),c(Ze,e),c(We,e)}}}const Vl='{"title":"Neuron Model Cache","local":"neuron-model-cache","sections":[{"title":"Why Use the Cache?","local":"why-use-the-cache","sections":[],"depth":2},{"title":"Quick Start","local":"quick-start","sections":[{"title":"Training","local":"training","sections":[],"depth":3},{"title":"Inference","local":"inference","sections":[],"depth":3}],"depth":2},{"title":"Supported Models","local":"supported-models","sections":[],"depth":2},{"title":"How It Works","local":"how-it-works","sections":[],"depth":2},{"title":"Private Cache Setup","local":"private-cache-setup","sections":[{"title":"Method 1: CLI Setup (Recommended)","local":"method-1-cli-setup-recommended","sections":[],"depth":3},{"title":"Method 2: Environment Variable","local":"method-2-environment-variable","sections":[],"depth":3}],"depth":2},{"title":"CLI Commands","local":"cli-commands","sections":[],"depth":2},{"title":"Advanced Usage","local":"advanced-usage","sections":[{"title":"Use the Cache in Training Loops","local":"use-the-cache-in-training-loops","sections":[],"depth":3},{"title":"Cache Lookup","local":"cache-lookup","sections":[],"depth":3}],"depth":2},{"title":"CI/CD Integration","local":"cicd-integration","sections":[],"depth":2},{"title":"Troubleshooting","local":"troubleshooting","sections":[{"title":"“Cache repository does not exist”","local":"cache-repository-does-not-exist","sections":[],"depth":3},{"title":"“Graph will be recompiled”","local":"graph-will-be-recompiled","sections":[],"depth":3},{"title":"Cache not uploading during training","local":"cache-not-uploading-during-training","sections":[],"depth":3},{"title":"Slow downloads","local":"slow-downloads","sections":[],"depth":3},{"title":"Clear corrupted local cache","local":"clear-corrupted-local-cache","sections":[],"depth":3}],"depth":2}],"depth":1}';function Sl(ke){return Zl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Al extends Hl{constructor(M){super(),Nl(this,M,Sl,_l,Bl,{})}}export{Al as component};
