# 🤗 Optimum Neuron

🤗 Optimum Neuron is the interface between the 🤗 Transformers library and AWS Accelerators including [AWS Trainium](https://aws.amazon.com/machine-learning/trainium/?nc1=h_ls) and [AWS Inferentia](https://aws.amazon.com/machine-learning/inferentia/?nc1=h_ls).
It provides a set of tools enabling easy model loading, training and inference on single- and multi-Accelerator settings for different downstream tasks.
The list of officially validated models and tasks is available [here](https://huggingface.co/docs/optimum-neuron/package_reference/configuration#supported-architectures).

  
    
      
        Tutorials
      
      
        Learn the basics and become familiar with training & deploying transformers on AWS Trainium and AWS Inferentia.
        Start here if you are using 🤗 Optimum Neuron for the first time!
      
    
    
      
        How-to guides
      
      
        Practical guides to help you achieve a specific goal. Take a look at these guides to learn how to use 🤗 Optimum
        Neuron to solve real-world problems.
      
    
    
      
        Reference
      
      Technical descriptions of how the classes and methods of 🤗 Optimum Neuron work.
    
    
      
        White Paper 
      
      To learn more about how Optimum Neuron and AWS Inferentia and Trainium are being used by companies, read the White Paper.
      
    
  
