import{s as Yt,n as Ht,o as $t}from"../chunks/scheduler.56725da7.js";import{S as Lt,i as zt,e as M,s as a,c as p,h as qt,a as i,d as e,b as n,f as kt,g as T,j as o,k as vt,l as Dt,m as s,n as U,t as r,o as m,p as J}from"../chunks/index.18a26576.js";import{C as Pt}from"../chunks/CopyLLMTxtMenu.a324ec7c.js";import{C as u}from"../chunks/CodeBlock.38a850f9.js";import{H as Ul}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.54a4b6d4.js";function Ot(Ut){let y,Jl,rl,ul,c,yl,d,cl,h,rt="This tutorial shows how to fine-tune the Llama 3.1 model on AWS Trainium accelerators using optimum-neuron.",dl,j,mt='<strong>This is based on the <a href="https://github.com/huggingface/optimum-neuron/tree/main/examples/training/llama" rel="nofollow">Llama 3.1 fine-tuning example script</a>.</strong>',hl,w,jl,f,Jt="We’ll use a <code>trn1.32xlarge</code> instance with 16 Trainium Accelerators (32 Neuron Cores) and the Hugging Face Neuron Deep Learning AMI.",wl,b,ut="The Hugging Face AMI includes all required libraries pre-installed:",fl,I,yt="<li><code>datasets</code>, <code>transformers</code>, <code>optimum-neuron</code></li> <li>Neuron SDK packages</li> <li>No additional environment setup needed</li>",bl,R,ct='To create your instance, follow the guide <a href="https://huggingface.co/docs/optimum-neuron/ec2-setup" rel="nofollow">here</a>.',Il,C,dt='<strong>Model Access:</strong> The Llama 3.1 model is gated and requires access approval. You can request access at <a href="https://huggingface.co/meta-llama/Llama-3.1-8B" rel="nofollow">meta-llama/Llama-3.1-8B</a>. Once approved, make sure to authenticate with the Hugging Face Hub:',Rl,E,Cl,Z,El,g,ht='We’ll use the <a href="https://huggingface.co/datasets/databricks/databricks-dolly-15k" rel="nofollow">Dolly</a> dataset, an open source dataset of instruction-following records on categories outlined in the <a href="https://arxiv.org/abs/2203.02155" rel="nofollow">InstructGPT paper</a>, including brainstorming, classification, closed QA, generation, information extraction, open QA, and summarization.',Zl,B,gl,V,jt="To load the dataset we use the <code>load_dataset()</code> method from the <code>datasets</code> library.",Bl,_,Vl,W,wt="To instruct fine-tune our model we need to convert our structured examples into collection of tasks described via instructions. We define our formatting function to preprocess the dataset.",_l,G,ft="The dataset should be structured with input-output pairs, where each input is a prompt and the output is the expected response from the model.",Wl,N,Gl,F,bt='Note: this function is well-defined in the <a href="https://github.com/huggingface/optimum-neuron/blob/main/examples/training/llama/finetune_llama.py" rel="nofollow">Python script</a> to run this tutorial.',Nl,X,Fl,S,It='For standard PyTorch fine-tuning, you’d typically use <a href="https://github.com/huggingface/peft" rel="nofollow">PEFT</a> with LoRA adapters and the <a href="https://huggingface.co/docs/trl/en/sft_trainer" rel="nofollow"><code>SFTTrainer</code></a>.',Xl,Q,Rt="On AWS Trainium, <code>optimum-neuron</code> provides <code>NeuronSFTTrainer</code> as a drop-in replacement.",Sl,A,Ct=`<strong>Distributed Training on Trainium:</strong>
Since Llama 3.1 8B doesn’t fit on a single accelerator, we use distributed training techniques:`,Ql,x,Et="<li>Data Parallel (DDP)</li> <li>Tensor Parallelism</li>",Al,k,Zt="Model loading and LoRA configuration work similarly to other accelerators.",xl,v,gt="Combining all the pieces together, and assuming the dataset has already been loaded, we can write the following code to fine-tune Llama 3.1 on AWS Trainium:",kl,Y,vl,H,Bt='📝 <strong>Complete script available:</strong> All steps above are combined in a ready-to-use script <a href="https://github.com/huggingface/optimum-neuron/blob/main/examples/training/llama/finetune_llama.py" rel="nofollow">finetune_llama.py</a>.',Yl,$,Vt="To launch training, just run the following command in your AWS Trainium instance:",Hl,L,$l,z,_t='🔧 <strong>Single command execution:</strong> The complete bash training script <a href="https://github.com/huggingface/optimum-neuron/blob/main/examples/training/llama/finetune_llama.sh" rel="nofollow">finetune_llama.sh</a> is available:',Ll,q,zl,D,ql,P,Wt="Optimum Neuron saves model shards separately during distributed training. These need to be consolidated before use.",Dl,O,Gt="Use the Optimum CLI to consolidate:",Pl,K,Ol,ll,Nt="This will create an <code>adapter_model.safetensors</code> file, the LoRA adapter weights that we trained in the previous step. We can now reload the model and merge it, so it can be loaded for evaluation:",Kl,tl,lt,el,Ft="Once this step is done, it is possible to test the model with a new prompt.",tt,sl,Xt="You have successfully created a fine-tuned model from Llama 3.1!",et,al,st,nl,St="Share your fine-tuned model with the community by uploading it to the Hugging Face Hub.",at,Ml,Qt="<strong>Step 1: Authentication</strong>",nt,il,Mt,ol,At="<strong>Step 2: Upload your model</strong>",it,pl,ot,Tl,xt="🎉 <strong>Your fine-tuned Llama 3.1 model is now available on the Hub for others to use!</strong>",pt,ml,Tt;return c=new Pt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),d=new Ul({props:{title:"🚀 Instruction Fine-Tuning of Llama 3.1 8B with LoRA",local:"-instruction-fine-tuning-of-llama-31-8b-with-lora",headingTag:"h1"}}),w=new Ul({props:{title:"1. 🛠️ Setup AWS Environment",local:"1--setup-aws-environment",headingTag:"h2"}}),E=new u({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),Z=new Ul({props:{title:"2. 📊 Load and Prepare the Dataset",local:"2--load-and-prepare-the-dataset",headingTag:"h2"}}),B=new u({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5zdHJ1Y3Rpb24lMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjB3b3JsZCUyMG9mJTIwd2FyY3JhZnQlMjIlMkMlMEElMjAlMjAlMjJjb250ZXh0JTIyJTNBJTIwJTIyJTIyJTJDJTBBJTIwJTIwJTIycmVzcG9uc2UlMjIlM0ElMjAoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV29ybGQlMjBvZiUyMHdhcmNyYWZ0JTIwaXMlMjBhJTIwbWFzc2l2ZSUyMG9ubGluZSUyMG11bHRpJTIwcGxheWVyJTIwcm9sZSUyMHBsYXlpbmclMjBnYW1lLiUyMCUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkl0JTIwd2FzJTIwcmVsZWFzZWQlMjBpbiUyMDIwMDQlMjBieSUyMGJpemFycmUlMjBlbnRlcnRhaW5tZW50JTIyJTBBJTIwJTIwJTIwJTIwKSUwQSU3RA==",highlighted:`{
  <span class="hljs-comment">&quot;instruction&quot;</span>: <span class="hljs-comment">&quot;What is world of warcraft&quot;</span>,
  <span class="hljs-comment">&quot;context&quot;</span>: <span class="hljs-comment">&quot;&quot;</span>,
  <span class="hljs-comment">&quot;response&quot;</span>: (
        <span class="hljs-comment">&quot;World of warcraft is a massive online multi player role playing game. &quot;</span>
        <span class="hljs-comment">&quot;It was released in 2004 by bizarre entertainment&quot;</span>
    )
}`,wrap:!1}}),_=new u({props:{code:"ZnJvbSUyMHJhbmRvbSUyMGltcG9ydCUyMHJhbmRyYW5nZSUwQSUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQSUwQSUyMyUyMExvYWQlMjBkYXRhc2V0JTIwZnJvbSUyMHRoZSUyMGh1YiUwQWRhdGFzZXRfaWQlMjAlM0QlMjAlMjJkYXRhYnJpY2tzJTJGZGF0YWJyaWNrcy1kb2xseS0xNWslMjIlMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KGRhdGFzZXRfaWQlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQWRhdGFzZXRfc2l6ZSUyMCUzRCUyMGxlbihkYXRhc2V0KSUwQXByaW50KGYlMjJkYXRhc2V0JTIwc2l6ZSUzQSUyMCU3QmRhdGFzZXRfc2l6ZSU3RCUyMiklMEElMjMlMjBkYXRhc2V0JTIwc2l6ZSUzQSUyMDE1MDEx",highlighted:`<span class="hljs-keyword">from</span> random <span class="hljs-keyword">import</span> randrange

<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset


<span class="hljs-comment"># Load dataset from the hub</span>
dataset_id = <span class="hljs-string">&quot;databricks/databricks-dolly-15k&quot;</span>
dataset = load_dataset(dataset_id, split=<span class="hljs-string">&quot;train&quot;</span>)

dataset_size = <span class="hljs-built_in">len</span>(dataset)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;dataset size: <span class="hljs-subst">{dataset_size}</span>&quot;</span>)
<span class="hljs-comment"># dataset size: 15011</span>`,wrap:!1}}),N=new u({props:{code:"ZGVmJTIwZm9ybWF0X2RvbGx5KGV4YW1wbGUlMkMlMjB0b2tlbml6ZXIpJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyRm9ybWF0JTIwRG9sbHklMjBkYXRhc2V0JTIwZXhhbXBsZXMlMjB1c2luZyUyMHRoZSUyMHRva2VuaXplcidzJTIwY2hhdCUyMHRlbXBsYXRlLiUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMHVzZXJfY29udGVudCUyMCUzRCUyMGV4YW1wbGUlNUIlMjJpbnN0cnVjdGlvbiUyMiU1RCUwQSUyMCUyMCUyMCUyMGlmJTIwbGVuKGV4YW1wbGUlNUIlMjJjb250ZXh0JTIyJTVEKSUyMCUzRSUyMDAlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB1c2VyX2NvbnRlbnQlMjAlMkIlM0QlMjBmJTIyJTVDbiU1Q25Db250ZXh0JTNBJTIwJTdCZXhhbXBsZSU1Qidjb250ZXh0JyU1RCU3RCUyMiUwQSUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJDdXR0aW5nJTIwS25vd2xlZGdlJTIwRGF0ZSUzQSUyMERlY2VtYmVyJTIwMjAyMyU1Q25Ub2RheSUyMERhdGUlM0ElMjAyOSUyMEp1bCUyMDIwMjUlNUNuJTVDbllvdSUyMGFyZSUyMGElMjBoZWxwZnVsJTIwYXNzaXN0YW50JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwdXNlcl9jb250ZW50JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjBleGFtcGxlJTVCJTIycmVzcG9uc2UlMjIlNUQlN0QlMkMlMEElMjAlMjAlMjAlMjAlNUQlMEElMEElMjAlMjAlMjAlMjByZXR1cm4lMjB0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZShtZXNzYWdlcyUyQyUyMHRva2VuaXplJTNERmFsc2Up",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">format_dolly</span>(<span class="hljs-params">example, tokenizer</span>):
    <span class="hljs-string">&quot;&quot;&quot;Format Dolly dataset examples using the tokenizer&#x27;s chat template.&quot;&quot;&quot;</span>
    user_content = example[<span class="hljs-string">&quot;instruction&quot;</span>]
    <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(example[<span class="hljs-string">&quot;context&quot;</span>]) &gt; <span class="hljs-number">0</span>:
        user_content += <span class="hljs-string">f&quot;\\n\\nContext: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;context&#x27;</span>]}</span>&quot;</span>

    messages = [
        {
            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
            <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Cutting Knowledge Date: December 2023\\nToday Date: 29 Jul 2025\\n\\nYou are a helpful assistant&quot;</span>,
        },
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: user_content},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: example[<span class="hljs-string">&quot;response&quot;</span>]},
    ]

    <span class="hljs-keyword">return</span> tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>)`,wrap:!1}}),X=new Ul({props:{title:"3. 🎯 Fine-tune Llama 3.1 with NeuronSFTTrainer and PEFT",local:"3--fine-tune-llama-31-with-neuronsfttrainer-and-peft",headingTag:"h2"}}),Y=new u({props:{code:"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",highlighted:`model_id = <span class="hljs-string">&quot;meta-llama/Llama-3.1-8B&quot;</span>

<span class="hljs-comment"># Define the training arguments</span>
output_dir = <span class="hljs-string">&quot;Llama-3.1-8B-finetuned&quot;</span>
training_args = NeuronTrainingArguments(
    output_dir=output_dir,
    num_train_epochs=<span class="hljs-number">3</span>,
    do_train=<span class="hljs-literal">True</span>,
    max_steps=-<span class="hljs-number">1</span>,  <span class="hljs-comment"># -1 means train until the end of the dataset</span>
    per_device_train_batch_size=<span class="hljs-number">1</span>,
    gradient_accumulation_steps=<span class="hljs-number">16</span>,
    learning_rate=<span class="hljs-number">1e-4</span>,
    bf16=<span class="hljs-literal">True</span>,  
    tensor_parallel_size=<span class="hljs-number">8</span>,
    logging_steps=<span class="hljs-number">1</span>,
    warmup_steps=<span class="hljs-number">5</span>,
    async_save=<span class="hljs-literal">True</span>,
    overwrite_output_dir=<span class="hljs-literal">True</span>,
)

<span class="hljs-comment"># Load the model with the NeuronModelForCausalLM class.</span>
<span class="hljs-comment"># It will load the model with a custom modeling specifically designed for AWS Trainium.</span>
trn_config = training_args.trn_config
dtype = torch.bfloat16 <span class="hljs-keyword">if</span> training_args.bf16 <span class="hljs-keyword">else</span> torch.float32
model = NeuronModelForCausalLM.from_pretrained(
    model_id,
    trn_config,
    torch_dtype=dtype,
    <span class="hljs-comment"># Use FlashAttention2 for better performance and to be able to use larger sequence lengths.</span>
    attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>,
)

lora_config = LoraConfig(
    r=<span class="hljs-number">64</span>,
    lora_alpha=<span class="hljs-number">128</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    target_modules=[<span class="hljs-string">&quot;embed_tokens&quot;</span>, <span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>, <span class="hljs-string">&quot;o_proj&quot;</span>, <span class="hljs-string">&quot;gate_proj&quot;</span>, <span class="hljs-string">&quot;up_proj&quot;</span>, <span class="hljs-string">&quot;down_proj&quot;</span>],
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

<span class="hljs-comment"># Converting the NeuronTrainingArguments to a dictionary to feed them to the NeuronSFTConfig.</span>
args = training_args.to_dict()

sft_config = NeuronSFTConfig(
    max_seq_length=<span class="hljs-number">2048</span>,
    packing=<span class="hljs-literal">True</span>,
    **args,
)

tokenizer = AutoTokenizer.from_pretrained(model_id)
tokenizer.pad_token = <span class="hljs-string">&quot;&lt;|finetune_right_pad_id|&gt;&quot;</span>

<span class="hljs-comment"># Set chat template for Llama 3.1 format</span>
tokenizer.chat_template = (
    <span class="hljs-string">&quot;{% for message in messages %}&quot;</span>
    <span class="hljs-string">&quot;{% if message[&#x27;role&#x27;] == &#x27;system&#x27; %}&quot;</span>
    <span class="hljs-string">&quot;&lt;|begin_of_text|&gt;&lt;|start_header_id|&gt;system&lt;|end_header_id|&gt;\\n\\n{{ message[&#x27;content&#x27;] }}&lt;|eot_id|&gt;&quot;</span>
    <span class="hljs-string">&quot;{% elif message[&#x27;role&#x27;] == &#x27;user&#x27; %}&quot;</span>
    <span class="hljs-string">&quot;&lt;|start_header_id|&gt;user&lt;|end_header_id|&gt;\\n\\n{{ message[&#x27;content&#x27;] }}&lt;|eot_id|&gt;&quot;</span>
    <span class="hljs-string">&quot;{% elif message[&#x27;role&#x27;] == &#x27;assistant&#x27; %}&quot;</span>
    <span class="hljs-string">&quot;&lt;|start_header_id|&gt;assistant&lt;|end_header_id|&gt;\\n\\n{{ message[&#x27;content&#x27;] }}&lt;|eot_id|&gt;&quot;</span>
    <span class="hljs-string">&quot;{% endif %}&quot;</span>
    <span class="hljs-string">&quot;{% endfor %}&quot;</span>
    <span class="hljs-string">&quot;{% if add_generation_prompt %}&quot;</span>
    <span class="hljs-string">&quot;&lt;|start_header_id|&gt;assistant&lt;|end_header_id|&gt;\\n\\n&quot;</span>
    <span class="hljs-string">&quot;{% endif %}&quot;</span>
)

<span class="hljs-comment"># The NeuronSFTTrainer will use \`format_dolly\` to format the dataset and \`lora_config\` to apply LoRA on the</span>
<span class="hljs-comment"># model.</span>
trainer = NeuronSFTTrainer(
    args=sft_config,
    model=model,
    peft_config=lora_config,
    tokenizer=tokenizer,
    train_dataset=dataset,
    formatting_func=<span class="hljs-keyword">lambda</span> example: format_dolly(example, tokenizer),
)
trainer.train()`,wrap:!1}}),L=new u({props:{code:"JTIzJTIwRmxhZ3MlMjBmb3IlMjBOZXVyb24lMjBjb21waWxhdGlvbiUwQWV4cG9ydCUyME5FVVJPTl9DQ19GTEFHUyUzRCUyMi0tbW9kZWwtdHlwZSUyMHRyYW5zZm9ybWVyJTIwLS1yZXRyeV9mYWlsZWRfY29tcGlsYXRpb24lMjIlMEFleHBvcnQlMjBORVVST05fRlVTRV9TT0ZUTUFYJTNEMSUwQWV4cG9ydCUyME5FVVJPTl9SVF9BU1lOQ19FWEVDX01BWF9JTkZMSUdIVF9SRVFVRVNUUyUzRDMlMjAlMjMlMjBBc3luYyUyMFJ1bnRpbWUlMEFleHBvcnQlMjBNQUxMT0NfQVJFTkFfTUFYJTNENjQlMjAlMjMlMjBIb3N0JTIwT09NJTIwbWl0aWdhdGlvbiUwQSUwQSUyMyUyMFZhcmlhYmxlcyUyMGZvciUyMHRyYWluaW5nJTBBUFJPQ0VTU0VTX1BFUl9OT0RFJTNEMzIlMEFOVU1fRVBPQ0hTJTNEMyUwQVRQX0RFR1JFRSUzRDglMEFCUyUzRDElMEFHUkFESUVOVF9BQ0NVTVVMQVRJT05fU1RFUFMlM0QxNiUwQUxPR0dJTkdfU1RFUFMlM0QxJTBBTU9ERUxfTkFNRSUzRCUyMm1ldGEtbGxhbWElMkZMbGFtYS0zLjEtOEIlMjIlMjAlMjMlMjBDaGFuZ2UlMjB0aGlzJTIwdG8lMjB0aGUlMjBkZXNpcmVkJTIwbW9kZWwlMjBuYW1lJTBBT1VUUFVUX0RJUiUzRCUyMiUyNChlY2hvJTIwJTI0TU9ERUxfTkFNRSUyMCU3QyUyMGN1dCUyMC1kJyUyRiclMjAtZjIpLWZpbmV0dW5lZCUyMiUwQURJU1RSSUJVVEVEX0FSR1MlM0QlMjItLW5wcm9jX3Blcl9ub2RlJTIwJTI0UFJPQ0VTU0VTX1BFUl9OT0RFJTIyJTBBJTBBaWYlMjAlNUIlMjAlMjIlMjRORVVST05fRVhUUkFDVF9HUkFQSFNfT05MWSUyMiUyMCUzRCUyMCUyMjElMjIlMjAlNUQlM0IlMjB0aGVuJTBBJTIwJTIwJTIwJTIwTUFYX1NURVBTJTNENSUwQWVsc2UlMEElMjAlMjAlMjAlMjBNQVhfU1RFUFMlM0QtMSUwQWZpJTBBJTBBdG9yY2hydW4lMjAtLW5wcm9jX3Blcl9ub2RlJTIwJTI0UFJPQ0VTU0VTX1BFUl9OT0RFJTIwZmluZXR1bmVfbGxhbWEucHklMjAlNUMlMEElMjAlMjAtLW1vZGVsX2lkJTIwJTI0TU9ERUxfTkFNRSUyMCU1QyUwQSUyMCUyMC0tbnVtX3RyYWluX2Vwb2NocyUyMCUyNE5VTV9FUE9DSFMlMjAlNUMlMEElMjAlMjAtLWRvX3RyYWluJTIwJTVDJTBBJTIwJTIwLS1tYXhfc3RlcHMlMjAlMjRNQVhfU1RFUFMlMjAlNUMlMEElMjAlMjAtLXBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUyMCUyNEJTJTIwJTVDJTBBJTIwJTIwLS1ncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlMjAlMjRHUkFESUVOVF9BQ0NVTVVMQVRJT05fU1RFUFMlMjAlNUMlMEElMjAlMjAtLWxlYXJuaW5nX3JhdGUlMjAxZS00JTIwJTVDJTBBJTIwJTIwLS1iZjE2JTIwJTVDJTBBJTIwJTIwLS10ZW5zb3JfcGFyYWxsZWxfc2l6ZSUyMCUyNFRQX0RFR1JFRSUyMCU1QyUwQSUyMCUyMC0tYXN5bmNfc2F2ZSUyMCU1QyUwQSUyMCUyMC0td2FybXVwX3N0ZXBzJTIwNSUyMCU1QyUwQSUyMCUyMC0tbG9nZ2luZ19zdGVwcyUyMCUyNExPR0dJTkdfU1RFUFMlMjAlNUMlMEElMjAlMjAtLW91dHB1dF9kaXIlMjAlMjRPVVRQVVRfRElSJTIwJTVDJTBBJTIwJTIwLS1vdmVyd3JpdGVfb3V0cHV0X2Rpcg==",highlighted:`<span class="hljs-comment"># Flags for Neuron compilation</span>
<span class="hljs-built_in">export</span> NEURON_CC_FLAGS=<span class="hljs-string">&quot;--model-type transformer --retry_failed_compilation&quot;</span>
<span class="hljs-built_in">export</span> NEURON_FUSE_SOFTMAX=1
<span class="hljs-built_in">export</span> NEURON_RT_ASYNC_EXEC_MAX_INFLIGHT_REQUESTS=3 <span class="hljs-comment"># Async Runtime</span>
<span class="hljs-built_in">export</span> MALLOC_ARENA_MAX=64 <span class="hljs-comment"># Host OOM mitigation</span>

<span class="hljs-comment"># Variables for training</span>
PROCESSES_PER_NODE=32
NUM_EPOCHS=3
TP_DEGREE=8
BS=1
GRADIENT_ACCUMULATION_STEPS=16
LOGGING_STEPS=1
MODEL_NAME=<span class="hljs-string">&quot;meta-llama/Llama-3.1-8B&quot;</span> <span class="hljs-comment"># Change this to the desired model name</span>
OUTPUT_DIR=<span class="hljs-string">&quot;<span class="hljs-subst">$(echo $MODEL_NAME | cut -d&#x27;/&#x27; -f2)</span>-finetuned&quot;</span>
DISTRIBUTED_ARGS=<span class="hljs-string">&quot;--nproc_per_node <span class="hljs-variable">$PROCESSES_PER_NODE</span>&quot;</span>

<span class="hljs-keyword">if</span> [ <span class="hljs-string">&quot;<span class="hljs-variable">$NEURON_EXTRACT_GRAPHS_ONLY</span>&quot;</span> = <span class="hljs-string">&quot;1&quot;</span> ]; <span class="hljs-keyword">then</span>
    MAX_STEPS=5
<span class="hljs-keyword">else</span>
    MAX_STEPS=-1
<span class="hljs-keyword">fi</span>

torchrun --nproc_per_node <span class="hljs-variable">$PROCESSES_PER_NODE</span> finetune_llama.py \\
  --model_id <span class="hljs-variable">$MODEL_NAME</span> \\
  --num_train_epochs <span class="hljs-variable">$NUM_EPOCHS</span> \\
  --do_train \\
  --max_steps <span class="hljs-variable">$MAX_STEPS</span> \\
  --per_device_train_batch_size <span class="hljs-variable">$BS</span> \\
  --gradient_accumulation_steps <span class="hljs-variable">$GRADIENT_ACCUMULATION_STEPS</span> \\
  --learning_rate 1e-4 \\
  --bf16 \\
  --tensor_parallel_size <span class="hljs-variable">$TP_DEGREE</span> \\
  --async_save \\
  --warmup_steps 5 \\
  --logging_steps <span class="hljs-variable">$LOGGING_STEPS</span> \\
  --output_dir <span class="hljs-variable">$OUTPUT_DIR</span> \\
  --overwrite_output_dir`,wrap:!1}}),q=new u({props:{code:"LiUyRmZpbmV0dW5lX2xsYW1hLnNo",highlighted:"./finetune_llama.sh",wrap:!1}}),D=new Ul({props:{title:"4. 🔄 Consolidate and Test the Fine-Tuned Model",local:"4--consolidate-and-test-the-fine-tuned-model",headingTag:"h2"}}),K=new u({props:{code:"b3B0aW11bS1jbGklMjBuZXVyb24lMjBjb25zb2xpZGF0ZSUyMExsYW1hLTMuMS04Qi1maW5ldHVuZWQlMjBMbGFtYS0zLjEtOEItZmluZXR1bmVkJTJGYWRhcHRlcl9kZWZhdWx0",highlighted:"optimum-cli neuron consolidate Llama-3.1-8B-finetuned Llama-3.1-8B-finetuned/adapter_default",wrap:!1}}),tl=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjBwZWZ0JTIwaW1wb3J0JTIwUGVmdE1vZGVsJTJDJTIwUGVmdENvbmZpZyUwQSUwQSUwQU1PREVMX05BTUUlMjAlM0QlMjAlMjJtZXRhLWxsYW1hJTJGTGxhbWEtMy4xLThCJTIyJTBBQURBUFRFUl9QQVRIJTIwJTNEJTIwJTIyTGxhbWEtMy4xLThCLWZpbmV0dW5lZCUyRmFkYXB0ZXJfZGVmYXVsdCUyMiUwQU1FUkdFRF9NT0RFTF9QQVRIJTIwJTNEJTIwJTIyTGxhbWEtMy4xLThCLWRvbGx5JTIyJTBBJTBBJTIzJTIwTG9hZCUyMGJhc2UlMjBtb2RlbCUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKE1PREVMX05BTUUpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoTU9ERUxfTkFNRSklMEElMEElMjMlMjBMb2FkJTIwYWRhcHRlciUyMGNvbmZpZ3VyYXRpb24lMjBhbmQlMjBtb2RlbCUwQWFkYXB0ZXJfY29uZmlnJTIwJTNEJTIwUGVmdENvbmZpZy5mcm9tX3ByZXRyYWluZWQoQURBUFRFUl9QQVRIKSUwQWZpbmV0dW5lZF9tb2RlbCUyMCUzRCUyMFBlZnRNb2RlbC5mcm9tX3ByZXRyYWluZWQobW9kZWwlMkMlMjBBREFQVEVSX1BBVEglMkMlMjBjb25maWclM0RhZGFwdGVyX2NvbmZpZyklMEElMEFwcmludCglMjJTYXZpbmclMjB0b2tlbml6ZXIlMjIpJTBBdG9rZW5pemVyLnNhdmVfcHJldHJhaW5lZChNRVJHRURfTU9ERUxfUEFUSCklMEFwcmludCglMjJTYXZpbmclMjBtb2RlbCUyMiklMEFmaW5ldHVuZWRfbW9kZWwlMjAlM0QlMjBmaW5ldHVuZWRfbW9kZWwubWVyZ2VfYW5kX3VubG9hZCgpJTBBZmluZXR1bmVkX21vZGVsLnNhdmVfcHJldHJhaW5lZChNRVJHRURfTU9ERUxfUEFUSCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel, PeftConfig


MODEL_NAME = <span class="hljs-string">&quot;meta-llama/Llama-3.1-8B&quot;</span>
ADAPTER_PATH = <span class="hljs-string">&quot;Llama-3.1-8B-finetuned/adapter_default&quot;</span>
MERGED_MODEL_PATH = <span class="hljs-string">&quot;Llama-3.1-8B-dolly&quot;</span>

<span class="hljs-comment"># Load base model</span>
model = AutoModelForCausalLM.from_pretrained(MODEL_NAME)
tokenizer = AutoTokenizer.from_pretrained(MODEL_NAME)

<span class="hljs-comment"># Load adapter configuration and model</span>
adapter_config = PeftConfig.from_pretrained(ADAPTER_PATH)
finetuned_model = PeftModel.from_pretrained(model, ADAPTER_PATH, config=adapter_config)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Saving tokenizer&quot;</span>)
tokenizer.save_pretrained(MERGED_MODEL_PATH)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Saving model&quot;</span>)
finetuned_model = finetuned_model.merge_and_unload()
finetuned_model.save_pretrained(MERGED_MODEL_PATH)`,wrap:!1}}),al=new Ul({props:{title:"5. 🤗 Push to Hugging Face Hub",local:"5--push-to-hugging-face-hub",headingTag:"h2"}}),il=new u({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),pl=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQU1FUkdFRF9NT0RFTF9QQVRIJTIwJTNEJTIwJTIyTGxhbWEtMy4xLThCLWRvbGx5JTIyJTBBSFVCX01PREVMX05BTUUlMjAlM0QlMjAlMjJ5b3VyLXVzZXJuYW1lJTJGbGxhbWEzLjEtOGItZG9sbHklMjIlMEElMEElMjMlMjBMb2FkJTIwYW5kJTIwcHVzaCUyMHRva2VuaXplciUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKE1FUkdFRF9NT0RFTF9QQVRIKSUwQXRva2VuaXplci5wdXNoX3RvX2h1YihIVUJfTU9ERUxfTkFNRSklMEElMEElMjMlMjBMb2FkJTIwYW5kJTIwcHVzaCUyMG1vZGVsJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoTUVSR0VEX01PREVMX1BBVEgpJTBBbW9kZWwucHVzaF90b19odWIoSFVCX01PREVMX05BTUUp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

MERGED_MODEL_PATH = <span class="hljs-string">&quot;Llama-3.1-8B-dolly&quot;</span>
HUB_MODEL_NAME = <span class="hljs-string">&quot;your-username/llama3.1-8b-dolly&quot;</span>

<span class="hljs-comment"># Load and push tokenizer</span>
tokenizer = AutoTokenizer.from_pretrained(MERGED_MODEL_PATH)
tokenizer.push_to_hub(HUB_MODEL_NAME)

<span class="hljs-comment"># Load and push model</span>
model = AutoModelForCausalLM.from_pretrained(MERGED_MODEL_PATH)
model.push_to_hub(HUB_MODEL_NAME)`,wrap:!1}}),{c(){y=M("meta"),Jl=a(),rl=M("p"),ul=a(),p(c.$$.fragment),yl=a(),p(d.$$.fragment),cl=a(),h=M("p"),h.textContent=rt,dl=a(),j=M("p"),j.innerHTML=mt,hl=a(),p(w.$$.fragment),jl=a(),f=M("p"),f.innerHTML=Jt,wl=a(),b=M("p"),b.textContent=ut,fl=a(),I=M("ul"),I.innerHTML=yt,bl=a(),R=M("p"),R.innerHTML=ct,Il=a(),C=M("p"),C.innerHTML=dt,Rl=a(),p(E.$$.fragment),Cl=a(),p(Z.$$.fragment),El=a(),g=M("p"),g.innerHTML=ht,Zl=a(),p(B.$$.fragment),gl=a(),V=M("p"),V.innerHTML=jt,Bl=a(),p(_.$$.fragment),Vl=a(),W=M("p"),W.textContent=wt,_l=a(),G=M("p"),G.textContent=ft,Wl=a(),p(N.$$.fragment),Gl=a(),F=M("p"),F.innerHTML=bt,Nl=a(),p(X.$$.fragment),Fl=a(),S=M("p"),S.innerHTML=It,Xl=a(),Q=M("p"),Q.innerHTML=Rt,Sl=a(),A=M("p"),A.innerHTML=Ct,Ql=a(),x=M("ul"),x.innerHTML=Et,Al=a(),k=M("p"),k.textContent=Zt,xl=a(),v=M("p"),v.textContent=gt,kl=a(),p(Y.$$.fragment),vl=a(),H=M("p"),H.innerHTML=Bt,Yl=a(),$=M("p"),$.textContent=Vt,Hl=a(),p(L.$$.fragment),$l=a(),z=M("p"),z.innerHTML=_t,Ll=a(),p(q.$$.fragment),zl=a(),p(D.$$.fragment),ql=a(),P=M("p"),P.textContent=Wt,Dl=a(),O=M("p"),O.textContent=Gt,Pl=a(),p(K.$$.fragment),Ol=a(),ll=M("p"),ll.innerHTML=Nt,Kl=a(),p(tl.$$.fragment),lt=a(),el=M("p"),el.textContent=Ft,tt=a(),sl=M("p"),sl.textContent=Xt,et=a(),p(al.$$.fragment),st=a(),nl=M("p"),nl.textContent=St,at=a(),Ml=M("p"),Ml.innerHTML=Qt,nt=a(),p(il.$$.fragment),Mt=a(),ol=M("p"),ol.innerHTML=At,it=a(),p(pl.$$.fragment),ot=a(),Tl=M("p"),Tl.innerHTML=xt,pt=a(),ml=M("p"),this.h()},l(l){const t=qt("svelte-u9bgzb",document.head);y=i(t,"META",{name:!0,content:!0}),t.forEach(e),Jl=n(l),rl=i(l,"P",{}),kt(rl).forEach(e),ul=n(l),T(c.$$.fragment,l),yl=n(l),T(d.$$.fragment,l),cl=n(l),h=i(l,"P",{"data-svelte-h":!0}),o(h)!=="svelte-1mnesz9"&&(h.textContent=rt),dl=n(l),j=i(l,"P",{"data-svelte-h":!0}),o(j)!=="svelte-1e1022f"&&(j.innerHTML=mt),hl=n(l),T(w.$$.fragment,l),jl=n(l),f=i(l,"P",{"data-svelte-h":!0}),o(f)!=="svelte-43r1bv"&&(f.innerHTML=Jt),wl=n(l),b=i(l,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1ktungo"&&(b.textContent=ut),fl=n(l),I=i(l,"UL",{"data-svelte-h":!0}),o(I)!=="svelte-1efvabb"&&(I.innerHTML=yt),bl=n(l),R=i(l,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1gchww4"&&(R.innerHTML=ct),Il=n(l),C=i(l,"P",{"data-svelte-h":!0}),o(C)!=="svelte-9yn5gx"&&(C.innerHTML=dt),Rl=n(l),T(E.$$.fragment,l),Cl=n(l),T(Z.$$.fragment,l),El=n(l),g=i(l,"P",{"data-svelte-h":!0}),o(g)!=="svelte-12qhil6"&&(g.innerHTML=ht),Zl=n(l),T(B.$$.fragment,l),gl=n(l),V=i(l,"P",{"data-svelte-h":!0}),o(V)!=="svelte-25b86y"&&(V.innerHTML=jt),Bl=n(l),T(_.$$.fragment,l),Vl=n(l),W=i(l,"P",{"data-svelte-h":!0}),o(W)!=="svelte-w0b2m2"&&(W.textContent=wt),_l=n(l),G=i(l,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1w4wk9l"&&(G.textContent=ft),Wl=n(l),T(N.$$.fragment,l),Gl=n(l),F=i(l,"P",{"data-svelte-h":!0}),o(F)!=="svelte-1y9evj3"&&(F.innerHTML=bt),Nl=n(l),T(X.$$.fragment,l),Fl=n(l),S=i(l,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1iw1mwz"&&(S.innerHTML=It),Xl=n(l),Q=i(l,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-dh3p5f"&&(Q.innerHTML=Rt),Sl=n(l),A=i(l,"P",{"data-svelte-h":!0}),o(A)!=="svelte-17bz54a"&&(A.innerHTML=Ct),Ql=n(l),x=i(l,"UL",{"data-svelte-h":!0}),o(x)!=="svelte-1iqb34b"&&(x.innerHTML=Et),Al=n(l),k=i(l,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1xxdciy"&&(k.textContent=Zt),xl=n(l),v=i(l,"P",{"data-svelte-h":!0}),o(v)!=="svelte-nfzf7p"&&(v.textContent=gt),kl=n(l),T(Y.$$.fragment,l),vl=n(l),H=i(l,"P",{"data-svelte-h":!0}),o(H)!=="svelte-jkg1sh"&&(H.innerHTML=Bt),Yl=n(l),$=i(l,"P",{"data-svelte-h":!0}),o($)!=="svelte-pvqso5"&&($.textContent=Vt),Hl=n(l),T(L.$$.fragment,l),$l=n(l),z=i(l,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1mvw2gf"&&(z.innerHTML=_t),Ll=n(l),T(q.$$.fragment,l),zl=n(l),T(D.$$.fragment,l),ql=n(l),P=i(l,"P",{"data-svelte-h":!0}),o(P)!=="svelte-46jexq"&&(P.textContent=Wt),Dl=n(l),O=i(l,"P",{"data-svelte-h":!0}),o(O)!=="svelte-9a9g75"&&(O.textContent=Gt),Pl=n(l),T(K.$$.fragment,l),Ol=n(l),ll=i(l,"P",{"data-svelte-h":!0}),o(ll)!=="svelte-1cigzjn"&&(ll.innerHTML=Nt),Kl=n(l),T(tl.$$.fragment,l),lt=n(l),el=i(l,"P",{"data-svelte-h":!0}),o(el)!=="svelte-vght15"&&(el.textContent=Ft),tt=n(l),sl=i(l,"P",{"data-svelte-h":!0}),o(sl)!=="svelte-1s2sm2h"&&(sl.textContent=Xt),et=n(l),T(al.$$.fragment,l),st=n(l),nl=i(l,"P",{"data-svelte-h":!0}),o(nl)!=="svelte-a60mly"&&(nl.textContent=St),at=n(l),Ml=i(l,"P",{"data-svelte-h":!0}),o(Ml)!=="svelte-z9yml0"&&(Ml.innerHTML=Qt),nt=n(l),T(il.$$.fragment,l),Mt=n(l),ol=i(l,"P",{"data-svelte-h":!0}),o(ol)!=="svelte-h2brza"&&(ol.innerHTML=At),it=n(l),T(pl.$$.fragment,l),ot=n(l),Tl=i(l,"P",{"data-svelte-h":!0}),o(Tl)!=="svelte-1okzo1f"&&(Tl.innerHTML=xt),pt=n(l),ml=i(l,"P",{}),kt(ml).forEach(e),this.h()},h(){vt(y,"name","hf:doc:metadata"),vt(y,"content",Kt)},m(l,t){Dt(document.head,y),s(l,Jl,t),s(l,rl,t),s(l,ul,t),U(c,l,t),s(l,yl,t),U(d,l,t),s(l,cl,t),s(l,h,t),s(l,dl,t),s(l,j,t),s(l,hl,t),U(w,l,t),s(l,jl,t),s(l,f,t),s(l,wl,t),s(l,b,t),s(l,fl,t),s(l,I,t),s(l,bl,t),s(l,R,t),s(l,Il,t),s(l,C,t),s(l,Rl,t),U(E,l,t),s(l,Cl,t),U(Z,l,t),s(l,El,t),s(l,g,t),s(l,Zl,t),U(B,l,t),s(l,gl,t),s(l,V,t),s(l,Bl,t),U(_,l,t),s(l,Vl,t),s(l,W,t),s(l,_l,t),s(l,G,t),s(l,Wl,t),U(N,l,t),s(l,Gl,t),s(l,F,t),s(l,Nl,t),U(X,l,t),s(l,Fl,t),s(l,S,t),s(l,Xl,t),s(l,Q,t),s(l,Sl,t),s(l,A,t),s(l,Ql,t),s(l,x,t),s(l,Al,t),s(l,k,t),s(l,xl,t),s(l,v,t),s(l,kl,t),U(Y,l,t),s(l,vl,t),s(l,H,t),s(l,Yl,t),s(l,$,t),s(l,Hl,t),U(L,l,t),s(l,$l,t),s(l,z,t),s(l,Ll,t),U(q,l,t),s(l,zl,t),U(D,l,t),s(l,ql,t),s(l,P,t),s(l,Dl,t),s(l,O,t),s(l,Pl,t),U(K,l,t),s(l,Ol,t),s(l,ll,t),s(l,Kl,t),U(tl,l,t),s(l,lt,t),s(l,el,t),s(l,tt,t),s(l,sl,t),s(l,et,t),U(al,l,t),s(l,st,t),s(l,nl,t),s(l,at,t),s(l,Ml,t),s(l,nt,t),U(il,l,t),s(l,Mt,t),s(l,ol,t),s(l,it,t),U(pl,l,t),s(l,ot,t),s(l,Tl,t),s(l,pt,t),s(l,ml,t),Tt=!0},p:Ht,i(l){Tt||(r(c.$$.fragment,l),r(d.$$.fragment,l),r(w.$$.fragment,l),r(E.$$.fragment,l),r(Z.$$.fragment,l),r(B.$$.fragment,l),r(_.$$.fragment,l),r(N.$$.fragment,l),r(X.$$.fragment,l),r(Y.$$.fragment,l),r(L.$$.fragment,l),r(q.$$.fragment,l),r(D.$$.fragment,l),r(K.$$.fragment,l),r(tl.$$.fragment,l),r(al.$$.fragment,l),r(il.$$.fragment,l),r(pl.$$.fragment,l),Tt=!0)},o(l){m(c.$$.fragment,l),m(d.$$.fragment,l),m(w.$$.fragment,l),m(E.$$.fragment,l),m(Z.$$.fragment,l),m(B.$$.fragment,l),m(_.$$.fragment,l),m(N.$$.fragment,l),m(X.$$.fragment,l),m(Y.$$.fragment,l),m(L.$$.fragment,l),m(q.$$.fragment,l),m(D.$$.fragment,l),m(K.$$.fragment,l),m(tl.$$.fragment,l),m(al.$$.fragment,l),m(il.$$.fragment,l),m(pl.$$.fragment,l),Tt=!1},d(l){l&&(e(Jl),e(rl),e(ul),e(yl),e(cl),e(h),e(dl),e(j),e(hl),e(jl),e(f),e(wl),e(b),e(fl),e(I),e(bl),e(R),e(Il),e(C),e(Rl),e(Cl),e(El),e(g),e(Zl),e(gl),e(V),e(Bl),e(Vl),e(W),e(_l),e(G),e(Wl),e(Gl),e(F),e(Nl),e(Fl),e(S),e(Xl),e(Q),e(Sl),e(A),e(Ql),e(x),e(Al),e(k),e(xl),e(v),e(kl),e(vl),e(H),e(Yl),e($),e(Hl),e($l),e(z),e(Ll),e(zl),e(ql),e(P),e(Dl),e(O),e(Pl),e(Ol),e(ll),e(Kl),e(lt),e(el),e(tt),e(sl),e(et),e(st),e(nl),e(at),e(Ml),e(nt),e(Mt),e(ol),e(it),e(ot),e(Tl),e(pt),e(ml)),e(y),J(c,l),J(d,l),J(w,l),J(E,l),J(Z,l),J(B,l),J(_,l),J(N,l),J(X,l),J(Y,l),J(L,l),J(q,l),J(D,l),J(K,l),J(tl,l),J(al,l),J(il,l),J(pl,l)}}}const Kt='{"title":"🚀 Instruction Fine-Tuning of Llama 3.1 8B with LoRA","local":"-instruction-fine-tuning-of-llama-31-8b-with-lora","sections":[{"title":"1. 🛠️ Setup AWS Environment","local":"1--setup-aws-environment","sections":[],"depth":2},{"title":"2. 📊 Load and Prepare the Dataset","local":"2--load-and-prepare-the-dataset","sections":[],"depth":2},{"title":"3. 🎯 Fine-tune Llama 3.1 with NeuronSFTTrainer and PEFT","local":"3--fine-tune-llama-31-with-neuronsfttrainer-and-peft","sections":[],"depth":2},{"title":"4. 🔄 Consolidate and Test the Fine-Tuned Model","local":"4--consolidate-and-test-the-fine-tuned-model","sections":[],"depth":2},{"title":"5. 🤗 Push to Hugging Face Hub","local":"5--push-to-hugging-face-hub","sections":[],"depth":2}],"depth":1}';function le(Ut){return $t(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Me extends Lt{constructor(y){super(),zt(this,y,le,Ot,Yt,{})}}export{Me as component};
