import{s as Xe,o as Re,n as Ge}from"../chunks/scheduler.56725da7.js";import{S as Ne,i as xe,e as M,s as l,c as i,h as Qe,a as y,d as n,b as a,f as ke,g as m,j as b,k as ze,l as He,m as s,n as c,t as p,o as d,p as u}from"../chunks/index.18a26576.js";import{T as Ye}from"../chunks/Tip.5b941656.js";import{C as Fe}from"../chunks/CopyLLMTxtMenu.a324ec7c.js";import{C as P}from"../chunks/CodeBlock.38a850f9.js";import{H as j}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.54a4b6d4.js";function Ee(K){let r,Z="<strong>Caveat</strong>",T,h,J="Since compiled models with dynamic batching enabled only accept input tensors with the same batch size, we cannot set <code>dynamic_batch_size=True</code> if the input texts and images have different batch sizes. And as <code>NeuronModelForSentenceTransformers</code> class pads the inputs to the batch sizes (<code>text_batch_size</code> and <code>image_batch_size</code>) used during the compilation, you could use relatively larger batch sizes during the compilation for flexibility with the trade-off of compute.",U,f,g="eg. if you want to encode 3 or 4 or 5 texts and 1 image, you could set <code>text_batch_size = 5 = max(3, 4, 5)</code> and <code>image_batch_size = 1</code> during the compilation.";return{c(){r=M("p"),r.innerHTML=Z,T=l(),h=M("p"),h.innerHTML=J,U=l(),f=M("p"),f.innerHTML=g},l(o){r=y(o,"P",{"data-svelte-h":!0}),b(r)!=="svelte-6rj1id"&&(r.innerHTML=Z),T=a(o),h=y(o,"P",{"data-svelte-h":!0}),b(h)!=="svelte-1nmpr7n"&&(h.innerHTML=J),U=a(o),f=y(o,"P",{"data-svelte-h":!0}),b(f)!=="svelte-7gdj48"&&(f.innerHTML=g)},m(o,w){s(o,r,w),s(o,T,w),s(o,h,w),s(o,U,w),s(o,f,w)},p:Ge,d(o){o&&(n(r),n(T),n(h),n(U),n(f))}}}function Le(K){let r,Z,T,h,J,U,f,g,o,w,$,je='<em>There is a notebook version of that tutorial <a href="https://github.com/huggingface/optimum-neuron/blob/main/notebooks/sentence-transformers/getting-started.ipynb" rel="nofollow">here</a>.</em>',O,B,Ze='This guide explains how to compile, load, and use <a href="https://www.sbert.net/" rel="nofollow">Sentence Transformers (SBERT)</a> models on AWS Inferentia2 with Optimum Neuron, enabling efficient calculation of embeddings. Sentence Transformers are powerful models for generating sentence embeddings. You can use this Sentence Transformers to compute sentence / text embeddings for more than 100 languages. These embeddings can then be compared e.g. with cosine-similarity to find sentences with a similar meaning. This can be useful for semantic textual similarity, semantic search, or paraphrase mining.',ee,_,te,I,ge="First, you need to convert your Sentence Transformers model to a format compatible with AWS Inferentia2. You can compile Sentence Transformers models with Optimum Neuron using the <code>optimum-cli</code> or <code>NeuronModelForSentenceTransformers</code> class. Below you will find an example for both approaches. We have to make sure <code>sentence-transformers</code> is installed. That’s only needed for exporting the model.",ne,V,se,C,$e="Here we will use the <code>NeuronModelForSentenceTransformers</code>, which can be used to convert any Sentence Transformers model to a format compatible with AWS Inferentia2 or load already converted models. When exporting models with the <code>NeuronModelForSentenceTransformers</code> you need to set <code>export=True</code> and define the input shape and batch size. The input shape is defined by the <code>sequence_length</code> and the batch size by <code>batch_size</code>.",le,S,ae,v,Be="Here we will use the <code>optimum-cli</code> to convert the model. Similar to the <code>NeuronModelForSentenceTransformers</code> we need to define our input shape and batch size. The input shape is defined by the <code>sequence_length</code> and the batch size by <code>batch_size</code>. The <code>optimum-cli</code> will automatically convert the model to a format compatible with AWS Inferentia2 and save it to the specified output directory.",oe,k,re,z,ie,X,_e="Once we have a compiled Sentence Transformers model, which we either exported ourselves or is available on the Hugging Face Hub, we can load it and run inference. For loading the model we can use the <code>NeuronModelForSentenceTransformers</code> class, which is an abstraction layer for the <code>SentenceTransformer</code> class. The <code>NeuronModelForSentenceTransformers</code> class will automatically pad the input to the specified <code>sequence_length</code> and run inference on AWS Inferentia2.",me,R,ce,G,pe,N,Ie='For deploying these models in a production environment, refer to the <a href="https://www.philschmid.de/inferentia2-embeddings" rel="nofollow">Amazon SageMaker Blog</a>.',de,x,ue,Q,Me,H,Ve="You can compile CLIP models with Optimum Neuron either by using the <code>optimum-cli</code> or <code>NeuronModelForSentenceTransformers</code> class. Adopt one approach that you prefer:",ye,Y,Ce="<li>With the Optimum CLI</li>",fe,F,be,E,Se="<li>With the <code>NeuronModelForSentenceTransformers</code> class</li>",he,L,Te,q,Je,A,we,W,Ue,D,We;return J=new Fe({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),f=new j({props:{title:"Sentence Transformers on AWS Inferentia with Optimum Neuron",local:"sentence-transformers-on-aws-inferentia-with-optimum-neuron",headingTag:"h1"}}),o=new j({props:{title:"Text Models",local:"text-models",headingTag:"h2"}}),_=new j({props:{title:"Convert Sentence Transformers model to AWS Inferentia2",local:"convert-sentence-transformers-model-to-aws-inferentia2",headingTag:"h3"}}),V=new P({props:{code:"cGlwJTIwaW5zdGFsbCUyMHNlbnRlbmNlLXRyYW5zZm9ybWVycw==",highlighted:"pip install sentence-transformers",wrap:!1}}),S=new P({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uTW9kZWxGb3JTZW50ZW5jZVRyYW5zZm9ybWVycyUwQSUwQSUyMyUyMFNlbnRlbmNlJTIwVHJhbnNmb3JtZXJzJTIwbW9kZWwlMjBmcm9tJTIwSHVnZ2luZ0ZhY2UlMEFtb2RlbF9pZCUyMCUzRCUyMCUyMkJBQUklMkZiZ2Utc21hbGwtZW4tdjEuNSUyMiUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyc2VxdWVuY2VfbGVuZ3RoJTIyJTNBJTIwMzg0JTdEJTIwJTIwJTIzJTIwbWFuZGF0b3J5JTIwc2hhcGVzJTBBJTBBJTIzJTIwTG9hZCUyMFRyYW5zZm9ybWVycyUyMG1vZGVsJTIwYW5kJTIwZXhwb3J0JTIwaXQlMjB0byUyMEFXUyUyMEluZmVyZW50aWEyJTBBbW9kZWwlMjAlM0QlMjBOZXVyb25Nb2RlbEZvclNlbnRlbmNlVHJhbnNmb3JtZXJzLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMGV4cG9ydCUzRFRydWUlMkMlMjAqKmlucHV0X3NoYXBlcyklMEElMEElMjMlMjBTYXZlJTIwbW9kZWwlMjB0byUyMGRpc2slMEFtb2RlbC5zYXZlX3ByZXRyYWluZWQoJTIyYmdlX2VtYl9pbmYyJTJGJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForSentenceTransformers

<span class="hljs-comment"># Sentence Transformers model from HuggingFace</span>
model_id = <span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;sequence_length&quot;</span>: <span class="hljs-number">384</span>}  <span class="hljs-comment"># mandatory shapes</span>

<span class="hljs-comment"># Load Transformers model and export it to AWS Inferentia2</span>
model = NeuronModelForSentenceTransformers.from_pretrained(model_id, export=<span class="hljs-literal">True</span>, **input_shapes)

<span class="hljs-comment"># Save model to disk</span>
model.save_pretrained(<span class="hljs-string">&quot;bge_emb_inf2/&quot;</span>)`,wrap:!1}}),k=new P({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAtbSUyMEJBQUklMkZiZ2Utc21hbGwtZW4tdjEuNSUyMC0tc2VxdWVuY2VfbGVuZ3RoJTIwMzg0JTIwLS1iYXRjaF9zaXplJTIwMSUyMC0tdGFzayUyMGZlYXR1cmUtZXh0cmFjdGlvbiUyMGJnZV9lbWJfaW5mMiUyRg==",highlighted:'optimum-cli <span class="hljs-built_in">export</span> neuron -m BAAI/bge-small-en-v1.5 --sequence_length 384 --batch_size 1 --task feature-extraction bge_emb_inf2/',wrap:!1}}),z=new j({props:{title:"Load compiled Sentence Transformers model and run inference",local:"load-compiled-sentence-transformers-model-and-run-inference",headingTag:"h3"}}),R=new P({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uTW9kZWxGb3JTZW50ZW5jZVRyYW5zZm9ybWVycyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvVG9rZW5pemVyJTBBJTBBbW9kZWxfaWRfb3JfcGF0aCUyMCUzRCUyMCUyMmJnZV9lbWJfaW5mMiUyRiUyMiUwQXRva2VuaXplcl9pZCUyMCUzRCUyMCUyMkJBQUklMkZiZ2Utc21hbGwtZW4tdjEuNSUyMiUwQSUwQSUyMyUyMExvYWQlMjBtb2RlbCUyMGFuZCUyMHRva2VuaXplciUwQW1vZGVsJTIwJTNEJTIwTmV1cm9uTW9kZWxGb3JTZW50ZW5jZVRyYW5zZm9ybWVycy5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWRfb3JfcGF0aCklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCh0b2tlbml6ZXJfaWQpJTBBJTBBJTIzJTIwUnVuJTIwaW5mZXJlbmNlJTBBcHJvbXB0JTIwJTNEJTIwJTIySSUyMGxpa2UlMjB0byUyMGVhdCUyMGFwcGxlcyUyMiUwQWVuY29kZWRfaW5wdXQlMjAlM0QlMjB0b2tlbml6ZXIocHJvbXB0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QncHQnKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmVuY29kZWRfaW5wdXQpJTBBJTBBdG9rZW5fZW1iZWRkaW5ncyUyMCUzRCUyMG91dHB1dHMudG9rZW5fZW1iZWRkaW5ncyUwQXNlbnRlbmNlX2VtYmVkZGluZyUyMCUzRCUyMG91dHB1dHMuc2VudGVuY2VfZW1iZWRkaW5nJTBBJTBBcHJpbnQoZiUyMnRva2VuJTIwZW1iZWRkaW5ncyUzQSUyMCU3QnRva2VuX2VtYmVkZGluZ3Muc2hhcGUlN0QlMjIpJTIwJTIzJTIwdG9yY2guU2l6ZSglNUIxJTJDJTIwNyUyQyUyMDM4NCU1RCklMEFwcmludChmJTIyc2VudGVuY2VfZW1iZWRkaW5nJTNBJTIwJTdCc2VudGVuY2VfZW1iZWRkaW5nLnNoYXBlJTdEJTIyKSUyMCUyMyUyMHRvcmNoLlNpemUoJTVCMSUyQyUyMDM4NCU1RCk=",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForSentenceTransformers
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

model_id_or_path = <span class="hljs-string">&quot;bge_emb_inf2/&quot;</span>
tokenizer_id = <span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>

<span class="hljs-comment"># Load model and tokenizer</span>
model = NeuronModelForSentenceTransformers.from_pretrained(model_id_or_path)
tokenizer = AutoTokenizer.from_pretrained(tokenizer_id)

<span class="hljs-comment"># Run inference</span>
prompt = <span class="hljs-string">&quot;I like to eat apples&quot;</span>
encoded_input = tokenizer(prompt, return_tensors=<span class="hljs-string">&#x27;pt&#x27;</span>)
outputs = model(**encoded_input)

token_embeddings = outputs.token_embeddings
sentence_embedding = outputs.sentence_embedding

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;token embeddings: <span class="hljs-subst">{token_embeddings.shape}</span>&quot;</span>) <span class="hljs-comment"># torch.Size([1, 7, 384])</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;sentence_embedding: <span class="hljs-subst">{sentence_embedding.shape}</span>&quot;</span>) <span class="hljs-comment"># torch.Size([1, 384])</span>`,wrap:!1}}),G=new j({props:{title:"Production Usage",local:"production-usage",headingTag:"h3"}}),x=new j({props:{title:"CLIP",local:"clip",headingTag:"h2"}}),Q=new j({props:{title:"Compile CLIP for AWS Inferentia2",local:"compile-clip-for-aws-inferentia2",headingTag:"h3"}}),F=new P({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAtbSUyMHNlbnRlbmNlLXRyYW5zZm9ybWVycyUyRmNsaXAtVmlULUItMzIlMjAtLXNlcXVlbmNlX2xlbmd0aCUyMDY0JTIwLS10ZXh0X2JhdGNoX3NpemUlMjAzJTIwLS1pbWFnZV9iYXRjaF9zaXplJTIwMSUyMC0tbnVtX2NoYW5uZWxzJTIwMyUyMC0taGVpZ2h0JTIwMjI0JTIwLS13aWR0aCUyMDIyNCUyMC0tdGFzayUyMGZlYXR1cmUtZXh0cmFjdGlvbiUyMC0tc3ViZm9sZGVyJTIwMF9DTElQTW9kZWwlMjBjbGlwX2VtYiUyRg==",highlighted:'optimum-cli <span class="hljs-built_in">export</span> neuron -m sentence-transformers/clip-ViT-B-32 --sequence_length 64 --text_batch_size 3 --image_batch_size 1 --num_channels 3 --height 224 --width 224 --task feature-extraction --subfolder 0_CLIPModel clip_emb/',wrap:!1}}),L=new P({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uTW9kZWxGb3JTZW50ZW5jZVRyYW5zZm9ybWVycyUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyc2VudGVuY2UtdHJhbnNmb3JtZXJzJTJGY2xpcC1WaVQtQi0zMiUyMiUwQSUwQSUyMyUyMGNvbmZpZ3MlMjBmb3IlMjBjb21waWxpbmclMjBtb2RlbCUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMm51bV9jaGFubmVscyUyMiUzQSUyMDMlMkMlMEElMjAlMjAlMjAlMjAlMjJoZWlnaHQlMjIlM0ElMjAyMjQlMkMlMEElMjAlMjAlMjAlMjAlMjJ3aWR0aCUyMiUzQSUyMDIyNCUyQyUwQSUyMCUyMCUyMCUyMCUyMnRleHRfYmF0Y2hfc2l6ZSUyMiUzQSUyMDMlMkMlMEElMjAlMjAlMjAlMjAlMjJpbWFnZV9iYXRjaF9zaXplJTIyJTNBJTIwMSUyQyUwQSUyMCUyMCUyMCUyMCUyMnNlcXVlbmNlX2xlbmd0aCUyMiUzQSUyMDY0JTJDJTBBJTdEJTBBJTBBZW1iX21vZGVsJTIwJTNEJTIwTmV1cm9uTW9kZWxGb3JTZW50ZW5jZVRyYW5zZm9ybWVycy5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMjBzdWJmb2xkZXIlM0QlMjIwX0NMSVBNb2RlbCUyMiUyQyUyMGV4cG9ydCUzRFRydWUlMkMlMjBsaWJyYXJ5X25hbWUlM0QlMjJzZW50ZW5jZV90cmFuc2Zvcm1lcnMlMjIlMkMlMjBkeW5hbWljX2JhdGNoX3NpemUlM0RGYWxzZSUyQyUyMCoqaW5wdXRfc2hhcGVzJTBBKSUwQSUwQSUyMyUyMFNhdmUlMjBsb2NhbGx5JTIwb3IlMjB1cGxvYWQlMjB0byUyMHRoZSUyMEh1Z2dpbmdGYWNlJTIwSHViJTBBc2F2ZV9kaXJlY3RvcnklMjAlM0QlMjAlMjJjbGlwX2VtYiUyRiUyMiUwQWVtYl9tb2RlbC5zYXZlX3ByZXRyYWluZWQoc2F2ZV9kaXJlY3Rvcnkp",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForSentenceTransformers

model_id = <span class="hljs-string">&quot;sentence-transformers/clip-ViT-B-32&quot;</span>

<span class="hljs-comment"># configs for compiling model</span>
input_shapes = {
    <span class="hljs-string">&quot;num_channels&quot;</span>: <span class="hljs-number">3</span>,
    <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">224</span>,
    <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">224</span>,
    <span class="hljs-string">&quot;text_batch_size&quot;</span>: <span class="hljs-number">3</span>,
    <span class="hljs-string">&quot;image_batch_size&quot;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&quot;sequence_length&quot;</span>: <span class="hljs-number">64</span>,
}

emb_model = NeuronModelForSentenceTransformers.from_pretrained(
    model_id, subfolder=<span class="hljs-string">&quot;0_CLIPModel&quot;</span>, export=<span class="hljs-literal">True</span>, library_name=<span class="hljs-string">&quot;sentence_transformers&quot;</span>, dynamic_batch_size=<span class="hljs-literal">False</span>, **input_shapes
)

<span class="hljs-comment"># Save locally or upload to the HuggingFace Hub</span>
save_directory = <span class="hljs-string">&quot;clip_emb/&quot;</span>
emb_model.save_pretrained(save_directory)`,wrap:!1}}),q=new j({props:{title:"Load compiled Sentence Transformers model and run inference",local:"load-compiled-sentence-transformers-model-and-run-inference",headingTag:"h3"}}),A=new P({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHNlbnRlbmNlX3RyYW5zZm9ybWVycyUyMGltcG9ydCUyMHV0aWwlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQ0xJUFByb2Nlc3NvciUwQSUwQWZyb20lMjBvcHRpbXVtLm5ldXJvbiUyMGltcG9ydCUyME5ldXJvbk1vZGVsRm9yU2VudGVuY2VUcmFuc2Zvcm1lcnMlMEElMEFzYXZlX2RpcmVjdG9yeSUyMCUzRCUyMCUyMmNsaXBfZW1iJTIyJTBBZW1iX21vZGVsJTIwJTNEJTIwTmV1cm9uTW9kZWxGb3JTZW50ZW5jZVRyYW5zZm9ybWVycy5mcm9tX3ByZXRyYWluZWQoc2F2ZV9kaXJlY3RvcnkpJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQ0xJUFByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoc2F2ZV9kaXJlY3RvcnkpJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMHRleHQlM0QlNUIlMjJUd28lMjBkb2dzJTIwaW4lMjB0aGUlMjBzbm93JTIyJTJDJTIwJ0ElMjBjYXQlMjBvbiUyMGElMjB0YWJsZSclMkMlMjAnQSUyMHBpY3R1cmUlMjBvZiUyMExvbmRvbiUyMGF0JTIwbmlnaHQnJTVEJTJDJTIwaW1hZ2VzJTNESW1hZ2Uub3BlbiglMjJ0d29fZG9nc19pbl9zbm93LmpwZyUyMiklMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwcGFkZGluZyUzRFRydWUlMEEpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMGVtYl9tb2RlbCgqKmlucHV0cyklMEElMEElMEElMjMlMjBDb21wdXRlJTIwY29zaW5lJTIwc2ltaWxhcml0aWVzJTBBY29zX3Njb3JlcyUyMCUzRCUyMHV0aWwuY29zX3NpbShvdXRwdXRzLmltYWdlX2VtYmVkcyUyQyUyMG91dHB1dHMudGV4dF9lbWJlZHMpJTBBcHJpbnQoY29zX3Njb3JlcyklMEElMEElMjMlMjB0ZW5zb3IoJTVCJTVCMC4zMDcyJTJDJTIwMC4xMDE2JTJDJTIwMC4xMDk1JTVEJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> sentence_transformers <span class="hljs-keyword">import</span> util
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPProcessor

<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForSentenceTransformers

save_directory = <span class="hljs-string">&quot;clip_emb&quot;</span>
emb_model = NeuronModelForSentenceTransformers.from_pretrained(save_directory)

processor = CLIPProcessor.from_pretrained(save_directory)
inputs = processor(
    text=[<span class="hljs-string">&quot;Two dogs in the snow&quot;</span>, <span class="hljs-string">&#x27;A cat on a table&#x27;</span>, <span class="hljs-string">&#x27;A picture of London at night&#x27;</span>], images=Image.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;two_dogs_in_snow.jpg&quot;</span>), return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>
)

outputs = emb_model(**inputs)


<span class="hljs-comment"># Compute cosine similarities</span>
cos_scores = util.cos_sim(outputs.image_embeds, outputs.text_embeds)
<span class="hljs-built_in">print</span>(cos_scores)

<span class="hljs-comment"># tensor([[0.3072, 0.1016, 0.1095]])</span>`,wrap:!1}}),W=new Ye({props:{$$slots:{default:[Ee]},$$scope:{ctx:K}}}),{c(){r=M("meta"),Z=l(),T=M("p"),h=l(),i(J.$$.fragment),U=l(),i(f.$$.fragment),g=l(),i(o.$$.fragment),w=l(),$=M("p"),$.innerHTML=je,O=l(),B=M("p"),B.innerHTML=Ze,ee=l(),i(_.$$.fragment),te=l(),I=M("p"),I.innerHTML=ge,ne=l(),i(V.$$.fragment),se=l(),C=M("p"),C.innerHTML=$e,le=l(),i(S.$$.fragment),ae=l(),v=M("p"),v.innerHTML=Be,oe=l(),i(k.$$.fragment),re=l(),i(z.$$.fragment),ie=l(),X=M("p"),X.innerHTML=_e,me=l(),i(R.$$.fragment),ce=l(),i(G.$$.fragment),pe=l(),N=M("p"),N.innerHTML=Ie,de=l(),i(x.$$.fragment),ue=l(),i(Q.$$.fragment),Me=l(),H=M("p"),H.innerHTML=Ve,ye=l(),Y=M("ul"),Y.innerHTML=Ce,fe=l(),i(F.$$.fragment),be=l(),E=M("ul"),E.innerHTML=Se,he=l(),i(L.$$.fragment),Te=l(),i(q.$$.fragment),Je=l(),i(A.$$.fragment),we=l(),i(W.$$.fragment),Ue=l(),D=M("p"),this.h()},l(e){const t=Qe("svelte-u9bgzb",document.head);r=y(t,"META",{name:!0,content:!0}),t.forEach(n),Z=a(e),T=y(e,"P",{}),ke(T).forEach(n),h=a(e),m(J.$$.fragment,e),U=a(e),m(f.$$.fragment,e),g=a(e),m(o.$$.fragment,e),w=a(e),$=y(e,"P",{"data-svelte-h":!0}),b($)!=="svelte-z9n49l"&&($.innerHTML=je),O=a(e),B=y(e,"P",{"data-svelte-h":!0}),b(B)!=="svelte-12xwboz"&&(B.innerHTML=Ze),ee=a(e),m(_.$$.fragment,e),te=a(e),I=y(e,"P",{"data-svelte-h":!0}),b(I)!=="svelte-120k6s"&&(I.innerHTML=ge),ne=a(e),m(V.$$.fragment,e),se=a(e),C=y(e,"P",{"data-svelte-h":!0}),b(C)!=="svelte-1q2dvn9"&&(C.innerHTML=$e),le=a(e),m(S.$$.fragment,e),ae=a(e),v=y(e,"P",{"data-svelte-h":!0}),b(v)!=="svelte-reiugv"&&(v.innerHTML=Be),oe=a(e),m(k.$$.fragment,e),re=a(e),m(z.$$.fragment,e),ie=a(e),X=y(e,"P",{"data-svelte-h":!0}),b(X)!=="svelte-4dcngh"&&(X.innerHTML=_e),me=a(e),m(R.$$.fragment,e),ce=a(e),m(G.$$.fragment,e),pe=a(e),N=y(e,"P",{"data-svelte-h":!0}),b(N)!=="svelte-qum7z"&&(N.innerHTML=Ie),de=a(e),m(x.$$.fragment,e),ue=a(e),m(Q.$$.fragment,e),Me=a(e),H=y(e,"P",{"data-svelte-h":!0}),b(H)!=="svelte-1op5j1e"&&(H.innerHTML=Ve),ye=a(e),Y=y(e,"UL",{"data-svelte-h":!0}),b(Y)!=="svelte-1f07ihj"&&(Y.innerHTML=Ce),fe=a(e),m(F.$$.fragment,e),be=a(e),E=y(e,"UL",{"data-svelte-h":!0}),b(E)!=="svelte-676unf"&&(E.innerHTML=Se),he=a(e),m(L.$$.fragment,e),Te=a(e),m(q.$$.fragment,e),Je=a(e),m(A.$$.fragment,e),we=a(e),m(W.$$.fragment,e),Ue=a(e),D=y(e,"P",{}),ke(D).forEach(n),this.h()},h(){ze(r,"name","hf:doc:metadata"),ze(r,"content",qe)},m(e,t){He(document.head,r),s(e,Z,t),s(e,T,t),s(e,h,t),c(J,e,t),s(e,U,t),c(f,e,t),s(e,g,t),c(o,e,t),s(e,w,t),s(e,$,t),s(e,O,t),s(e,B,t),s(e,ee,t),c(_,e,t),s(e,te,t),s(e,I,t),s(e,ne,t),c(V,e,t),s(e,se,t),s(e,C,t),s(e,le,t),c(S,e,t),s(e,ae,t),s(e,v,t),s(e,oe,t),c(k,e,t),s(e,re,t),c(z,e,t),s(e,ie,t),s(e,X,t),s(e,me,t),c(R,e,t),s(e,ce,t),c(G,e,t),s(e,pe,t),s(e,N,t),s(e,de,t),c(x,e,t),s(e,ue,t),c(Q,e,t),s(e,Me,t),s(e,H,t),s(e,ye,t),s(e,Y,t),s(e,fe,t),c(F,e,t),s(e,be,t),s(e,E,t),s(e,he,t),c(L,e,t),s(e,Te,t),c(q,e,t),s(e,Je,t),c(A,e,t),s(e,we,t),c(W,e,t),s(e,Ue,t),s(e,D,t),We=!0},p(e,[t]){const ve={};t&2&&(ve.$$scope={dirty:t,ctx:e}),W.$set(ve)},i(e){We||(p(J.$$.fragment,e),p(f.$$.fragment,e),p(o.$$.fragment,e),p(_.$$.fragment,e),p(V.$$.fragment,e),p(S.$$.fragment,e),p(k.$$.fragment,e),p(z.$$.fragment,e),p(R.$$.fragment,e),p(G.$$.fragment,e),p(x.$$.fragment,e),p(Q.$$.fragment,e),p(F.$$.fragment,e),p(L.$$.fragment,e),p(q.$$.fragment,e),p(A.$$.fragment,e),p(W.$$.fragment,e),We=!0)},o(e){d(J.$$.fragment,e),d(f.$$.fragment,e),d(o.$$.fragment,e),d(_.$$.fragment,e),d(V.$$.fragment,e),d(S.$$.fragment,e),d(k.$$.fragment,e),d(z.$$.fragment,e),d(R.$$.fragment,e),d(G.$$.fragment,e),d(x.$$.fragment,e),d(Q.$$.fragment,e),d(F.$$.fragment,e),d(L.$$.fragment,e),d(q.$$.fragment,e),d(A.$$.fragment,e),d(W.$$.fragment,e),We=!1},d(e){e&&(n(Z),n(T),n(h),n(U),n(g),n(w),n($),n(O),n(B),n(ee),n(te),n(I),n(ne),n(se),n(C),n(le),n(ae),n(v),n(oe),n(re),n(ie),n(X),n(me),n(ce),n(pe),n(N),n(de),n(ue),n(Me),n(H),n(ye),n(Y),n(fe),n(be),n(E),n(he),n(Te),n(Je),n(we),n(Ue),n(D)),n(r),u(J,e),u(f,e),u(o,e),u(_,e),u(V,e),u(S,e),u(k,e),u(z,e),u(R,e),u(G,e),u(x,e),u(Q,e),u(F,e),u(L,e),u(q,e),u(A,e),u(W,e)}}}const qe='{"title":"Sentence Transformers on AWS Inferentia with Optimum Neuron","local":"sentence-transformers-on-aws-inferentia-with-optimum-neuron","sections":[{"title":"Text Models","local":"text-models","sections":[{"title":"Convert Sentence Transformers model to AWS Inferentia2","local":"convert-sentence-transformers-model-to-aws-inferentia2","sections":[],"depth":3},{"title":"Load compiled Sentence Transformers model and run inference","local":"load-compiled-sentence-transformers-model-and-run-inference","sections":[],"depth":3},{"title":"Production Usage","local":"production-usage","sections":[],"depth":3}],"depth":2},{"title":"CLIP","local":"clip","sections":[{"title":"Compile CLIP for AWS Inferentia2","local":"compile-clip-for-aws-inferentia2","sections":[],"depth":3},{"title":"Load compiled Sentence Transformers model and run inference","local":"load-compiled-sentence-transformers-model-and-run-inference","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ae(K){return Re(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class nt extends Ne{constructor(r){super(),xe(this,r,Ae,Le,Xe,{})}}export{nt as component};
