import{s as at,n as rt,o as ot}from"../chunks/scheduler.7da89386.js";import{S as yt,i as pt,g as n,s as M,r as o,A as Tt,h as a,f as t,c as s,j as st,u as y,x as r,k as nt,y as Ut,a as i,v as p,d as T,t as U,w as c}from"../chunks/index.0b7befd3.js";import{C as d}from"../chunks/CodeBlock.c5b6371f.js";import{H as m,E as ct}from"../chunks/getInferenceSnippets.6ead4bda.js";function dt($l){let w,fe,Ie,he,C,be,J,El=`A kernel can provide layers in addition to kernel functions. A layer from
the Hub can replace the <code>forward</code> method of an existing layer for a certain
device type. This makes it possible to provide more performant kernels for
existing layers.`,Ae,u,Rl=`See <a href="kernel-requirements.md">Kernel requirements</a> for more information the
requirements of Hub layers.`,ke,I,ge,j,$e,f,vl=`A layer can be made extensible with the <code>use_kernel_forward_from_hub</code>
decorator. For example:`,Ee,h,Re,b,Nl=`The decorator does not change the behavior of the class — it annotates
the class with the given name (here <code>SiluAndMul</code>). The <code>kernelize</code> function
described below uses this name to look up kernels for the layer.`,ve,A,Ne,k,_l=`An existing layer that does not (yet) have the <code>use_kernel_forward_from_hub</code>
decorator can be made extensible using the <code>replace_kernel_forward_from_hub</code>
function:`,_e,g,Be,$,Bl=`<strong>Warning:</strong> we strongly recommend using layers with a decorator, since
it signifies that the maintainer intends to keep the <code>forward</code> signature
compatible with layers from the hub.`,Ge,E,Ze,R,Gl=`A model will not use Hub kernels by default, even if it contains extensible
layers. To enable the use of Hub kernels in the model, it needs to be
‘kernelized’ using the <code>kernelize</code> function. This function traverses the
model graph and replaces the <code>forward</code> methods of extensible layers for which
Hub kernels are registered. <code>kernelize</code> can be used as follows:`,Le,v,He,N,Zl=`The <code>kernelize</code> function modifies the model in-place, the model itself is
returned as a convenience. The <code>mode</code> specifies that the model will be used
in inference. Similarly, you can ask <code>kernelize</code> to prepare the model for
training:`,We,_,Se,B,Ll=`A model that is kernelized for training can also be used for inference, but
not the other way around. If you want to change the mode of the kernelized
model, you can just run <code>kernelize</code> on the model again with the new mode.`,xe,G,Hl=`If you want to compile a model with <code>torch.compile</code>, this should be indicated
in the mode as well. You can do this by combining <code>Mode.INFERENCE</code> or
<code>Mode.TRAINING</code> with <code>Mode.TORCH_COMPILE</code> using the set union (<code>|</code>) operator:`,Qe,Z,Ve,L,Wl=`When the <code>mode</code> argument is not specified,
<code>Mode.TRAINING | Mode.TORCH_COMPILE</code> is used as the default. This mode
aligns most closely with pure PyTorch layers which also support training
and <code>torch.compile</code>. However, to select the most performant kernels, it
is often good to make the mode specific as possible.`,Xe,H,Fe,W,Sl=`Kernels can be registered per device type. For instance, separate <code>cuda</code> and
<code>metal</code> kernels could be registered for the name <code>SiluAndMul</code>. By default,
<code>kernelize</code> will try to infer the device type from the model’s parameters.
You can pass the device type to <code>kernelize</code> if the device type cannot be
inferred (e.g. because the model has no parameters):`,ze,S,qe,x,Ye,Q,xl=`If the <code>TRAINING</code> and/or <code>TORCH_COMPILE</code> modes are used, but a registered
kernel does not support backward passes or <code>torch.compile</code> respectively,
<code>kernelize</code> will fall back to the original, non-kernelized, layer. You
can let <code>kernelize</code> raise an exception instead by using <code>use_fallback=False</code>:`,Pe,V,Oe,X,Ql="This can be useful if you want to guarantee that Hub kernels are used.",Ke,F,De,z,Vl=`The kernels that are used are logged at the <code>INFO</code> level by <code>kernelize</code>.
See the <a href="https://docs.python.org/3/library/logging.html" rel="nofollow">Python logging</a>
documentation for information on how to configure logging.`,el,q,ll,Y,Xl=`<code>kernelize</code> relies on kernel mappings to find Hub kernels for layers.
Kernel mappings map a kernel name such as <code>SiluAndMul</code> to a kernel on
the Hub. For example:`,tl,P,il,O,Fl="You can register such a mapping using <code>register_kernel_mapping</code>:",Ml,K,sl,D,zl=`This will register the kernel mapping in the current context, which is
normally global. It is recommended to scope the mapping to where it is
used with the <code>use_kernel_mapping</code> context manager:`,nl,ee,al,le,ql=`This ensures that the mapping is not active anymore outside the
<code>with</code>-scope.`,rl,te,ol,ie,Yl=`You might want to register two different kernels for a particular layer,
where one kernel is optimized for a specific mode. You can do so by
registering layer repositories for specific modes. For example:`,yl,Me,pl,se,Pl=`The <code>kernelize</code> function will attempt to use the following registered
kernels for a given mode:`,Tl,ne,Ol=`<li><code>INFERENCE</code>: <code>INFERENCE</code> → <code>INFERENCE | TORCH_COMPILE</code> → <code>TRAINING</code> →
<code>TRAINING | TORCH_COMPILE</code> → <code>FALLBACK</code></li> <li><code>INFERENCE | TORCH_COMPILE</code>: <code>INFERENCE | TORCH_COMPILE</code> →
<code>TRAINING | TORCH_COMPILE</code> → <code>FALLBACK</code></li> <li><code>TRAINING</code>: <code>TRAINING</code> → <code>TRAINING | TORCH_COMPILE</code> → <code>FALLBACK</code></li> <li><code>TRAINING | TORCH_COMPILE</code>: <code>TRAINING | TORCH_COMPILE</code> → <code>FALLBACK</code></li>`,Ul,ae,Kl=`<code>Mode.FALLBACK</code> is a special mode that is used when no other mode matches. It
is also used when a kernel is registered without a mode, as described in the
previous section.`,cl,re,dl,oe,Dl=`In this case, both <code>Mode.INFERENCE | Mode.TORCH_COMPILE</code> and
<code>Mode.TRAINING | Mode.TORCH_COMPILE</code> will use the <code>Mode.FALLBACK</code> kernel,
since the other kernels do not support <code>torch.compile</code>.`,ml,ye,wl,pe,et=`Some kernels only work with newer CUDA architectures. For instance, some
kernels require capability 9.0 for the TMA unit on Hopper GPUs. <code>kernels</code>
supports registering layers for a range of CUDA capabilities. To do so,
you need to register the layer for a <code>Device</code> with type <code>cuda</code> and
set the supported range of CUDA capabilities with using <code>CUDAProperties</code>:`,Cl,Te,Jl,Ue,lt="Capabilities behave as follows:",ul,ce,tt=`<li><p>The minimum and maximum capabilities are inclusive.</p></li> <li><p>When a new kernel is registered with the same min/max capabilities as
an existing kernel, the new kernel will replace the old kernel.</p></li> <li><p>When there are multiple kernels that support a capability, the kernel
with the smaller capability interval will be used. E.g. given:</p> <ul><li><code>KernelA</code> with <code>min_capability=80</code> and <code>max_capability=89</code>;</li> <li><code>KernelB</code> with <code>min_capability=75</code> and <code>max_capability=89</code>;</li> <li><code>kernelize</code> runs on a system with capability 8.6.</li></ul> <p>Then <code>KernelA</code> will be used because the interval 80..89 is smaller
than 75..89. The motivation is that kernels with smaller ranges
tend to be more optimized for a specific set of GPUs. <strong>This behavior
might still change in the future.</strong></p></li>`,Il,de,jl,me,it=`Registering kernels for the ROCm architecture follows the exact same
pattern as CUDA kernels, using <code>min_capability</code> and <code>max_capability</code> to restrict
a kernel to a range of ROCm capabilities.`,fl,we,hl,Ce,Mt=`The <code>LocalLayerRepository</code> class is provided to load a repository from
a local directory. For example:`,bl,Je,Al,ue,kl,je,gl;return C=new m({props:{title:"Layers",local:"layers",headingTag:"h1"}}),I=new m({props:{title:"Making a layer extensible with kernels from the hub",local:"making-a-layer-extensible-with-kernels-from-the-hub",headingTag:"h2"}}),j=new m({props:{title:"Using a decorator",local:"using-a-decorator",headingTag:"h3"}}),h=new d({props:{code:"JTQwdXNlX2tlcm5lbF9mb3J3YXJkX2Zyb21faHViKCUyMlNpbHVBbmRNdWwlMjIpJTBBY2xhc3MlMjBTaWx1QW5kTXVsKG5uLk1vZHVsZSklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBmb3J3YXJkKHNlbGYlMkMlMjBpbnB1dCUzQSUyMHRvcmNoLlRlbnNvciklMjAtJTNFJTIwdG9yY2guVGVuc29yJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZCUyMCUzRCUyMGlucHV0LnNoYXBlJTVCLTElNUQlMjAlMkYlMkYlMjAyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwRi5zaWx1KGlucHV0JTVCLi4uJTJDJTIwJTNBZCU1RCklMjAqJTIwaW5wdXQlNUIuLi4lMkMlMjBkJTNBJTVE",highlighted:`<span class="hljs-meta">@use_kernel_forward_from_hub(<span class="hljs-params"><span class="hljs-string">&quot;SiluAndMul&quot;</span></span>)</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">SiluAndMul</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, <span class="hljs-built_in">input</span>: torch.Tensor</span>) -&gt; torch.Tensor:
        d = <span class="hljs-built_in">input</span>.shape[-<span class="hljs-number">1</span>] // <span class="hljs-number">2</span>
        <span class="hljs-keyword">return</span> F.silu(<span class="hljs-built_in">input</span>[..., :d]) * <span class="hljs-built_in">input</span>[..., d:]`,wrap:!1}}),A=new m({props:{title:"External layers",local:"external-layers",headingTag:"h3"}}),g=new d({props:{code:"ZnJvbSUyMHNvbWVsaWJyYXJ5JTIwaW1wb3J0JTIwU2lsdUFuZE11bCUwQSUwQXJlcGxhY2Vfa2VybmVsX2ZvcndhcmRfZnJvbV9odWIoU2lsdUFuZE11bCUyQyUyMCUyMlNpbHVBbmRNdWwlMjIp",highlighted:`<span class="hljs-keyword">from</span> somelibrary <span class="hljs-keyword">import</span> SiluAndMul

replace_kernel_forward_from_hub(SiluAndMul, <span class="hljs-string">&quot;SiluAndMul&quot;</span>)`,wrap:!1}}),E=new m({props:{title:"Kernelizing a model",local:"kernelizing-a-model",headingTag:"h2"}}),v=new d({props:{code:"bW9kZWwlMjAlM0QlMjBNeU1vZGVsKC4uLiklMEFtb2RlbCUyMCUzRCUyMGtlcm5lbGl6ZShtb2RlbCUyQyUyMG1vZGUlM0RNb2RlLklORkVSRU5DRSk=",highlighted:`model = MyModel(...)
model = kernelize(model, mode=Mode.INFERENCE)`,wrap:!1}}),_=new d({props:{code:"bW9kZWwlMjAlM0QlMjBNeU1vZGVsKC4uLiklMEFtb2RlbCUyMCUzRCUyMGtlcm5lbGl6ZShtb2RlbCUyQyUyMG1vZGUlM0RNb2RlLlRSQUlOSU5HKQ==",highlighted:`model = MyModel(...)
model = kernelize(model, mode=Mode.TRAINING)`,wrap:!1}}),Z=new d({props:{code:"bW9kZWwlMjAlM0QlMjBNeU1vZGVsKC4uLiklMEElMEElMjMlMjBJbmZlcmVuY2UlMEFtb2RlbCUyMCUzRCUyMGtlcm5lbGl6ZShtb2RlbCUyQyUyMG1vZGUlM0RNb2RlLklORkVSRU5DRSUyMCU3QyUyME1vZGUuVE9SQ0hfQ09NUElMRSklMEElMEElMjMlMjBUcmFpbmluZyUwQW1vZGVsJTIwJTNEJTIwa2VybmVsaXplKG1vZGVsJTJDJTIwbW9kZSUzRE1vZGUuVFJBSU5JTkclMjAlN0MlMjBNb2RlLlRPUkNIX0NPTVBJTEUp",highlighted:`model = MyModel(...)

<span class="hljs-comment"># Inference</span>
model = kernelize(model, mode=Mode.INFERENCE | Mode.TORCH_COMPILE)

<span class="hljs-comment"># Training</span>
model = kernelize(model, mode=Mode.TRAINING | Mode.TORCH_COMPILE)`,wrap:!1}}),H=new m({props:{title:"Kernel device",local:"kernel-device",headingTag:"h3"}}),S=new d({props:{code:"bW9kZWwlMjAlM0QlMjBNeU1vZGVsKC4uLiklMEFtb2RlbCUyMCUzRCUyMGtlcm5lbGl6ZShtb2RlbCUyQyUyMGRldmljZSUzRCUyMmN1ZGElMjIlMkMlMjBtb2RlJTNETW9kZS5JTkZFUkVOQ0Up",highlighted:`model = MyModel(...)
model = kernelize(model, device=<span class="hljs-string">&quot;cuda&quot;</span>, mode=Mode.INFERENCE)`,wrap:!1}}),x=new m({props:{title:"Fallback forward",local:"fallback-forward",headingTag:"h3"}}),V=new d({props:{code:"bW9kZWwlMjAlM0QlMjBNeU1vZGVsKC4uLiklMEFtb2RlbCUyMCUzRCUyMGtlcm5lbGl6ZShtb2RlbCUyQyUyMG1vZGUlM0RNb2RlLklORkVSRU5DRSUyMCU3QyUyME1vZGUuVE9SQ0hfQ09NUElMRSUyQyUyMHVzZV9mYWxsYmFjayUzREZhbHNlKQ==",highlighted:`model = MyModel(...)
model = kernelize(model, mode=Mode.INFERENCE | Mode.TORCH_COMPILE, use_fallback=<span class="hljs-literal">False</span>)`,wrap:!1}}),F=new m({props:{title:"Inspecting kernels which kernels are used",local:"inspecting-kernels-which-kernels-are-used",headingTag:"h3"}}),q=new m({props:{title:"Registering a hub kernel for a layer",local:"registering-a-hub-kernel-for-a-layer",headingTag:"h2"}}),P=new d({props:{code:"a2VybmVsX2xheWVyX21hcHBpbmclMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJTaWx1QW5kTXVsJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY3VkYSUyMiUzQSUyMExheWVyUmVwb3NpdG9yeSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIya2VybmVscy1jb21tdW5pdHklMkZhY3RpdmF0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGF5ZXJfbmFtZSUzRCUyMlNpbHVBbmRNdWwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9jbSUyMiUzQSUyMExheWVyUmVwb3NpdG9yeSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIya2VybmVscy1jb21tdW5pdHklMkZhY3RpdmF0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGF5ZXJfbmFtZSUzRCUyMlNpbHVBbmRNdWwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTdE",highlighted:`kernel_layer_mapping = {
    <span class="hljs-string">&quot;SiluAndMul&quot;</span>: {
        <span class="hljs-string">&quot;cuda&quot;</span>: LayerRepository(
            repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
            layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
        ),
        <span class="hljs-string">&quot;rocm&quot;</span>: LayerRepository(
            repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
            layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
        )
    }
}`,wrap:!1}}),K=new d({props:{code:"cmVnaXN0ZXJfa2VybmVsX21hcHBpbmcoa2VybmVsX2xheWVyX21hcHBpbmcp",highlighted:"register_kernel_mapping(kernel_layer_mapping)",wrap:!1}}),ee=new d({props:{code:"d2l0aCUyMHVzZV9rZXJuZWxfbWFwcGluZyhrZXJuZWxfbGF5ZXJfbWFwcGluZyklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBVc2UlMjB0aGUlMjBsYXllciUyMGZvciUyMHdoaWNoJTIwdGhlJTIwbWFwcGluZyUyMGlzJTIwYXBwbGllZC4lMEElMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyMGtlcm5lbGl6ZShtb2RlbCk=",highlighted:`<span class="hljs-keyword">with</span> use_kernel_mapping(kernel_layer_mapping):
    <span class="hljs-comment"># Use the layer for which the mapping is applied.</span>
    model = kernelize(model)`,wrap:!1}}),te=new m({props:{title:"Registering kernels for specific modes",local:"registering-kernels-for-specific-modes",headingTag:"h3"}}),Me=new d({props:{code:"a2VybmVsX2xheWVyX21hcHBpbmclMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJTaWx1QW5kTXVsJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY3VkYSUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyME1vZGUuSU5GRVJFTkNFJTNBJTIwTGF5ZXJSZXBvc2l0b3J5KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJrZXJuZWxzLWNvbW11bml0eSUyRmFjdGl2YXRpb24taW5mZXJlbmNlLW9wdGltaXplZCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxheWVyX25hbWUlM0QlMjJTaWx1QW5kTXVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyME1vZGUuVFJBSU5JTkclMjAlN0MlMjBNb2RlLlRPUkNIX0NPTVBJTEUlM0ElMjBMYXllclJlcG9zaXRvcnkoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMmtlcm5lbHMtY29tbXVuaXR5JTJGYWN0aXZhdGlvbi10cmFpbmluZy1vcHRpbWl6ZWQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYXllcl9uYW1lJTNEJTIyU2lsdUFuZE11bCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEElN0Q=",highlighted:`kernel_layer_mapping = {
    <span class="hljs-string">&quot;SiluAndMul&quot;</span>: {
        <span class="hljs-string">&quot;cuda&quot;</span>: {
          Mode.INFERENCE: LayerRepository(
              repo_id=<span class="hljs-string">&quot;kernels-community/activation-inference-optimized&quot;</span>,
              layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
          ),
          Mode.TRAINING | Mode.TORCH_COMPILE: LayerRepository(
              repo_id=<span class="hljs-string">&quot;kernels-community/activation-training-optimized&quot;</span>,
              layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
          ),
      }
    }
}`,wrap:!1}}),re=new d({props:{code:"a2VybmVsX2xheWVyX21hcHBpbmclMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJTaWx1QW5kTXVsJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY3VkYSUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyME1vZGUuRkFMTEJBQ0slM0ElMjBMYXllclJlcG9zaXRvcnkoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMmtlcm5lbHMtY29tbXVuaXR5JTJGYWN0aXZhdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxheWVyX25hbWUlM0QlMjJTaWx1QW5kTXVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyME1vZGUuSU5GRVJFTkNFJTNBJTIwTGF5ZXJSZXBvc2l0b3J5KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJrZXJuZWxzLWNvbW11bml0eSUyRmFjdGl2YXRpb24taW5mZXJlbmNlLW9wdGltaXplZCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxheWVyX25hbWUlM0QlMjJTaWx1QW5kTXVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyME1vZGUuVFJBSU5JTkclM0ElMjBMYXllclJlcG9zaXRvcnkoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMmtlcm5lbHMtY29tbXVuaXR5JTJGYWN0aXZhdGlvbi10cmFpbmluZy1vcHRpbWl6ZWQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYXllcl9uYW1lJTNEJTIyU2lsdUFuZE11bCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEElN0Q=",highlighted:`kernel_layer_mapping = {
    <span class="hljs-string">&quot;SiluAndMul&quot;</span>: {
        <span class="hljs-string">&quot;cuda&quot;</span>: {
            Mode.FALLBACK: LayerRepository(
                repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
                layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
            ),
            Mode.INFERENCE: LayerRepository(
                repo_id=<span class="hljs-string">&quot;kernels-community/activation-inference-optimized&quot;</span>,
                layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
            ),
            Mode.TRAINING: LayerRepository(
                repo_id=<span class="hljs-string">&quot;kernels-community/activation-training-optimized&quot;</span>,
                layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
            ),
        }
    }
}`,wrap:!1}}),ye=new m({props:{title:"Registering kernels for specific CUDA capabilities",local:"registering-kernels-for-specific-cuda-capabilities",headingTag:"h3"}}),Te=new d({props:{code:"a2VybmVsX2xheWVyX21hcHBpbmclMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJTaWx1QW5kTXVsJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwRGV2aWNlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHR5cGUlM0QlMjJjdWRhJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvcGVydGllcyUzRENVREFQcm9wZXJ0aWVzKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1pbl9jYXBhYmlsaXR5JTNENzUlMkMlMjBtYXhfY2FwYWJpbGl0eSUzRDg5JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklM0ElMjBMYXllclJlcG9zaXRvcnkoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMmtlcm5lbHMtY29tbXVuaXR5JTJGYWN0aXZhdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxheWVyX25hbWUlM0QlMjJTaWx1QW5kTXVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMERldmljZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0eXBlJTNEJTIyY3VkYSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb3BlcnRpZXMlM0RDVURBUHJvcGVydGllcyglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtaW5fY2FwYWJpbGl0eSUzRDkwJTJDJTIwbWF4X2NhcGFiaWxpdHklM0RzeXMubWF4c2l6ZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTNBJTIwTGF5ZXJSZXBvc2l0b3J5KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJrZXJuZWxzLWNvbW11bml0eSUyRmFjdGl2YXRpb24taG9wcGVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGF5ZXJfbmFtZSUzRCUyMlNpbHVBbmRNdWwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTdE",highlighted:`kernel_layer_mapping = {
    <span class="hljs-string">&quot;SiluAndMul&quot;</span>: {
        Device(
            <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;cuda&quot;</span>,
            properties=CUDAProperties(
                min_capability=<span class="hljs-number">75</span>, max_capability=<span class="hljs-number">89</span>
            ),
        ): LayerRepository(
            repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
            layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
        ),
        Device(
            <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;cuda&quot;</span>,
            properties=CUDAProperties(
                min_capability=<span class="hljs-number">90</span>, max_capability=sys.maxsize
            ),
        ): LayerRepository(
            repo_id=<span class="hljs-string">&quot;kernels-community/activation-hopper&quot;</span>,
            layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
        ),
    }
}`,wrap:!1}}),de=new m({props:{title:"Registering kernels for specific ROCm capabilities",local:"registering-kernels-for-specific-rocm-capabilities",headingTag:"h3"}}),we=new m({props:{title:"Loading from a local repository for testing",local:"loading-from-a-local-repository-for-testing",headingTag:"h3"}}),Je=new d({props:{code:"d2l0aCUyMHVzZV9rZXJuZWxfbWFwcGluZyglMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJTaWx1QW5kTXVsJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY3VkYSUyMiUzQSUyMExvY2FsTGF5ZXJSZXBvc2l0b3J5KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlcG9fcGF0aCUzRCUyMiUyRmhvbWUlMkZkYW5pZWwlMkZrZXJuZWxzJTJGYWN0aXZhdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhY2thZ2VfbmFtZSUzRCUyMmFjdGl2YXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYXllcl9uYW1lJTNEJTIyU2lsdUFuZE11bCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjBpbmhlcml0X21hcHBpbmclM0RGYWxzZSUyQyUwQSklM0ElMEElMjAlMjAlMjAlMjBrZXJuZWxpemUobGluZWFyJTJDJTIwbW9kZSUzRE1vZGUuSU5GRVJFTkNFKQ==",highlighted:`<span class="hljs-keyword">with</span> use_kernel_mapping(
    {
        <span class="hljs-string">&quot;SiluAndMul&quot;</span>: {
            <span class="hljs-string">&quot;cuda&quot;</span>: LocalLayerRepository(
                repo_path=<span class="hljs-string">&quot;/home/daniel/kernels/activation&quot;</span>,
                package_name=<span class="hljs-string">&quot;activation&quot;</span>,
                layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
            )
        }
    },
    inherit_mapping=<span class="hljs-literal">False</span>,
):
    kernelize(linear, mode=Mode.INFERENCE)`,wrap:!1}}),ue=new ct({props:{source:"https://github.com/huggingface/kernels/blob/main/docs/source/layers.md"}}),{c(){w=n("meta"),fe=M(),Ie=n("p"),he=M(),o(C.$$.fragment),be=M(),J=n("p"),J.innerHTML=El,Ae=M(),u=n("p"),u.innerHTML=Rl,ke=M(),o(I.$$.fragment),ge=M(),o(j.$$.fragment),$e=M(),f=n("p"),f.innerHTML=vl,Ee=M(),o(h.$$.fragment),Re=M(),b=n("p"),b.innerHTML=Nl,ve=M(),o(A.$$.fragment),Ne=M(),k=n("p"),k.innerHTML=_l,_e=M(),o(g.$$.fragment),Be=M(),$=n("p"),$.innerHTML=Bl,Ge=M(),o(E.$$.fragment),Ze=M(),R=n("p"),R.innerHTML=Gl,Le=M(),o(v.$$.fragment),He=M(),N=n("p"),N.innerHTML=Zl,We=M(),o(_.$$.fragment),Se=M(),B=n("p"),B.innerHTML=Ll,xe=M(),G=n("p"),G.innerHTML=Hl,Qe=M(),o(Z.$$.fragment),Ve=M(),L=n("p"),L.innerHTML=Wl,Xe=M(),o(H.$$.fragment),Fe=M(),W=n("p"),W.innerHTML=Sl,ze=M(),o(S.$$.fragment),qe=M(),o(x.$$.fragment),Ye=M(),Q=n("p"),Q.innerHTML=xl,Pe=M(),o(V.$$.fragment),Oe=M(),X=n("p"),X.textContent=Ql,Ke=M(),o(F.$$.fragment),De=M(),z=n("p"),z.innerHTML=Vl,el=M(),o(q.$$.fragment),ll=M(),Y=n("p"),Y.innerHTML=Xl,tl=M(),o(P.$$.fragment),il=M(),O=n("p"),O.innerHTML=Fl,Ml=M(),o(K.$$.fragment),sl=M(),D=n("p"),D.innerHTML=zl,nl=M(),o(ee.$$.fragment),al=M(),le=n("p"),le.innerHTML=ql,rl=M(),o(te.$$.fragment),ol=M(),ie=n("p"),ie.textContent=Yl,yl=M(),o(Me.$$.fragment),pl=M(),se=n("p"),se.innerHTML=Pl,Tl=M(),ne=n("ul"),ne.innerHTML=Ol,Ul=M(),ae=n("p"),ae.innerHTML=Kl,cl=M(),o(re.$$.fragment),dl=M(),oe=n("p"),oe.innerHTML=Dl,ml=M(),o(ye.$$.fragment),wl=M(),pe=n("p"),pe.innerHTML=et,Cl=M(),o(Te.$$.fragment),Jl=M(),Ue=n("p"),Ue.textContent=lt,ul=M(),ce=n("ul"),ce.innerHTML=tt,Il=M(),o(de.$$.fragment),jl=M(),me=n("p"),me.innerHTML=it,fl=M(),o(we.$$.fragment),hl=M(),Ce=n("p"),Ce.innerHTML=Mt,bl=M(),o(Je.$$.fragment),Al=M(),o(ue.$$.fragment),kl=M(),je=n("p"),this.h()},l(e){const l=Tt("svelte-u9bgzb",document.head);w=a(l,"META",{name:!0,content:!0}),l.forEach(t),fe=s(e),Ie=a(e,"P",{}),st(Ie).forEach(t),he=s(e),y(C.$$.fragment,e),be=s(e),J=a(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-178x673"&&(J.innerHTML=El),Ae=s(e),u=a(e,"P",{"data-svelte-h":!0}),r(u)!=="svelte-v68zn9"&&(u.innerHTML=Rl),ke=s(e),y(I.$$.fragment,e),ge=s(e),y(j.$$.fragment,e),$e=s(e),f=a(e,"P",{"data-svelte-h":!0}),r(f)!=="svelte-1jd41lf"&&(f.innerHTML=vl),Ee=s(e),y(h.$$.fragment,e),Re=s(e),b=a(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-tily1x"&&(b.innerHTML=Nl),ve=s(e),y(A.$$.fragment,e),Ne=s(e),k=a(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1hj9ahw"&&(k.innerHTML=_l),_e=s(e),y(g.$$.fragment,e),Be=s(e),$=a(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-13coke1"&&($.innerHTML=Bl),Ge=s(e),y(E.$$.fragment,e),Ze=s(e),R=a(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-stkx9y"&&(R.innerHTML=Gl),Le=s(e),y(v.$$.fragment,e),He=s(e),N=a(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1mdicvi"&&(N.innerHTML=Zl),We=s(e),y(_.$$.fragment,e),Se=s(e),B=a(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-xhc5xj"&&(B.innerHTML=Ll),xe=s(e),G=a(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-195gdzl"&&(G.innerHTML=Hl),Qe=s(e),y(Z.$$.fragment,e),Ve=s(e),L=a(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1pcqrau"&&(L.innerHTML=Wl),Xe=s(e),y(H.$$.fragment,e),Fe=s(e),W=a(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-808tau"&&(W.innerHTML=Sl),ze=s(e),y(S.$$.fragment,e),qe=s(e),y(x.$$.fragment,e),Ye=s(e),Q=a(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-yu926d"&&(Q.innerHTML=xl),Pe=s(e),y(V.$$.fragment,e),Oe=s(e),X=a(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1lkusth"&&(X.textContent=Ql),Ke=s(e),y(F.$$.fragment,e),De=s(e),z=a(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-161p6z8"&&(z.innerHTML=Vl),el=s(e),y(q.$$.fragment,e),ll=s(e),Y=a(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1r5il31"&&(Y.innerHTML=Xl),tl=s(e),y(P.$$.fragment,e),il=s(e),O=a(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1mzc83p"&&(O.innerHTML=Fl),Ml=s(e),y(K.$$.fragment,e),sl=s(e),D=a(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-p5ro9n"&&(D.innerHTML=zl),nl=s(e),y(ee.$$.fragment,e),al=s(e),le=a(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-z3xuuf"&&(le.innerHTML=ql),rl=s(e),y(te.$$.fragment,e),ol=s(e),ie=a(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1ed3b6y"&&(ie.textContent=Yl),yl=s(e),y(Me.$$.fragment,e),pl=s(e),se=a(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-sek2d8"&&(se.innerHTML=Pl),Tl=s(e),ne=a(e,"UL",{"data-svelte-h":!0}),r(ne)!=="svelte-ewhtf4"&&(ne.innerHTML=Ol),Ul=s(e),ae=a(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-m4furw"&&(ae.innerHTML=Kl),cl=s(e),y(re.$$.fragment,e),dl=s(e),oe=a(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1oi4pcx"&&(oe.innerHTML=Dl),ml=s(e),y(ye.$$.fragment,e),wl=s(e),pe=a(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-1wl92tu"&&(pe.innerHTML=et),Cl=s(e),y(Te.$$.fragment,e),Jl=s(e),Ue=a(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-1k7nbkd"&&(Ue.textContent=lt),ul=s(e),ce=a(e,"UL",{"data-svelte-h":!0}),r(ce)!=="svelte-xyngc6"&&(ce.innerHTML=tt),Il=s(e),y(de.$$.fragment,e),jl=s(e),me=a(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1q9vv7t"&&(me.innerHTML=it),fl=s(e),y(we.$$.fragment,e),hl=s(e),Ce=a(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-qa4iob"&&(Ce.innerHTML=Mt),bl=s(e),y(Je.$$.fragment,e),Al=s(e),y(ue.$$.fragment,e),kl=s(e),je=a(e,"P",{}),st(je).forEach(t),this.h()},h(){nt(w,"name","hf:doc:metadata"),nt(w,"content",mt)},m(e,l){Ut(document.head,w),i(e,fe,l),i(e,Ie,l),i(e,he,l),p(C,e,l),i(e,be,l),i(e,J,l),i(e,Ae,l),i(e,u,l),i(e,ke,l),p(I,e,l),i(e,ge,l),p(j,e,l),i(e,$e,l),i(e,f,l),i(e,Ee,l),p(h,e,l),i(e,Re,l),i(e,b,l),i(e,ve,l),p(A,e,l),i(e,Ne,l),i(e,k,l),i(e,_e,l),p(g,e,l),i(e,Be,l),i(e,$,l),i(e,Ge,l),p(E,e,l),i(e,Ze,l),i(e,R,l),i(e,Le,l),p(v,e,l),i(e,He,l),i(e,N,l),i(e,We,l),p(_,e,l),i(e,Se,l),i(e,B,l),i(e,xe,l),i(e,G,l),i(e,Qe,l),p(Z,e,l),i(e,Ve,l),i(e,L,l),i(e,Xe,l),p(H,e,l),i(e,Fe,l),i(e,W,l),i(e,ze,l),p(S,e,l),i(e,qe,l),p(x,e,l),i(e,Ye,l),i(e,Q,l),i(e,Pe,l),p(V,e,l),i(e,Oe,l),i(e,X,l),i(e,Ke,l),p(F,e,l),i(e,De,l),i(e,z,l),i(e,el,l),p(q,e,l),i(e,ll,l),i(e,Y,l),i(e,tl,l),p(P,e,l),i(e,il,l),i(e,O,l),i(e,Ml,l),p(K,e,l),i(e,sl,l),i(e,D,l),i(e,nl,l),p(ee,e,l),i(e,al,l),i(e,le,l),i(e,rl,l),p(te,e,l),i(e,ol,l),i(e,ie,l),i(e,yl,l),p(Me,e,l),i(e,pl,l),i(e,se,l),i(e,Tl,l),i(e,ne,l),i(e,Ul,l),i(e,ae,l),i(e,cl,l),p(re,e,l),i(e,dl,l),i(e,oe,l),i(e,ml,l),p(ye,e,l),i(e,wl,l),i(e,pe,l),i(e,Cl,l),p(Te,e,l),i(e,Jl,l),i(e,Ue,l),i(e,ul,l),i(e,ce,l),i(e,Il,l),p(de,e,l),i(e,jl,l),i(e,me,l),i(e,fl,l),p(we,e,l),i(e,hl,l),i(e,Ce,l),i(e,bl,l),p(Je,e,l),i(e,Al,l),p(ue,e,l),i(e,kl,l),i(e,je,l),gl=!0},p:rt,i(e){gl||(T(C.$$.fragment,e),T(I.$$.fragment,e),T(j.$$.fragment,e),T(h.$$.fragment,e),T(A.$$.fragment,e),T(g.$$.fragment,e),T(E.$$.fragment,e),T(v.$$.fragment,e),T(_.$$.fragment,e),T(Z.$$.fragment,e),T(H.$$.fragment,e),T(S.$$.fragment,e),T(x.$$.fragment,e),T(V.$$.fragment,e),T(F.$$.fragment,e),T(q.$$.fragment,e),T(P.$$.fragment,e),T(K.$$.fragment,e),T(ee.$$.fragment,e),T(te.$$.fragment,e),T(Me.$$.fragment,e),T(re.$$.fragment,e),T(ye.$$.fragment,e),T(Te.$$.fragment,e),T(de.$$.fragment,e),T(we.$$.fragment,e),T(Je.$$.fragment,e),T(ue.$$.fragment,e),gl=!0)},o(e){U(C.$$.fragment,e),U(I.$$.fragment,e),U(j.$$.fragment,e),U(h.$$.fragment,e),U(A.$$.fragment,e),U(g.$$.fragment,e),U(E.$$.fragment,e),U(v.$$.fragment,e),U(_.$$.fragment,e),U(Z.$$.fragment,e),U(H.$$.fragment,e),U(S.$$.fragment,e),U(x.$$.fragment,e),U(V.$$.fragment,e),U(F.$$.fragment,e),U(q.$$.fragment,e),U(P.$$.fragment,e),U(K.$$.fragment,e),U(ee.$$.fragment,e),U(te.$$.fragment,e),U(Me.$$.fragment,e),U(re.$$.fragment,e),U(ye.$$.fragment,e),U(Te.$$.fragment,e),U(de.$$.fragment,e),U(we.$$.fragment,e),U(Je.$$.fragment,e),U(ue.$$.fragment,e),gl=!1},d(e){e&&(t(fe),t(Ie),t(he),t(be),t(J),t(Ae),t(u),t(ke),t(ge),t($e),t(f),t(Ee),t(Re),t(b),t(ve),t(Ne),t(k),t(_e),t(Be),t($),t(Ge),t(Ze),t(R),t(Le),t(He),t(N),t(We),t(Se),t(B),t(xe),t(G),t(Qe),t(Ve),t(L),t(Xe),t(Fe),t(W),t(ze),t(qe),t(Ye),t(Q),t(Pe),t(Oe),t(X),t(Ke),t(De),t(z),t(el),t(ll),t(Y),t(tl),t(il),t(O),t(Ml),t(sl),t(D),t(nl),t(al),t(le),t(rl),t(ol),t(ie),t(yl),t(pl),t(se),t(Tl),t(ne),t(Ul),t(ae),t(cl),t(dl),t(oe),t(ml),t(wl),t(pe),t(Cl),t(Jl),t(Ue),t(ul),t(ce),t(Il),t(jl),t(me),t(fl),t(hl),t(Ce),t(bl),t(Al),t(kl),t(je)),t(w),c(C,e),c(I,e),c(j,e),c(h,e),c(A,e),c(g,e),c(E,e),c(v,e),c(_,e),c(Z,e),c(H,e),c(S,e),c(x,e),c(V,e),c(F,e),c(q,e),c(P,e),c(K,e),c(ee,e),c(te,e),c(Me,e),c(re,e),c(ye,e),c(Te,e),c(de,e),c(we,e),c(Je,e),c(ue,e)}}}const mt='{"title":"Layers","local":"layers","sections":[{"title":"Making a layer extensible with kernels from the hub","local":"making-a-layer-extensible-with-kernels-from-the-hub","sections":[{"title":"Using a decorator","local":"using-a-decorator","sections":[],"depth":3},{"title":"External layers","local":"external-layers","sections":[],"depth":3}],"depth":2},{"title":"Kernelizing a model","local":"kernelizing-a-model","sections":[{"title":"Kernel device","local":"kernel-device","sections":[],"depth":3},{"title":"Fallback forward","local":"fallback-forward","sections":[],"depth":3},{"title":"Inspecting kernels which kernels are used","local":"inspecting-kernels-which-kernels-are-used","sections":[],"depth":3}],"depth":2},{"title":"Registering a hub kernel for a layer","local":"registering-a-hub-kernel-for-a-layer","sections":[{"title":"Registering kernels for specific modes","local":"registering-kernels-for-specific-modes","sections":[],"depth":3},{"title":"Registering kernels for specific CUDA capabilities","local":"registering-kernels-for-specific-cuda-capabilities","sections":[],"depth":3},{"title":"Registering kernels for specific ROCm capabilities","local":"registering-kernels-for-specific-rocm-capabilities","sections":[],"depth":3},{"title":"Loading from a local repository for testing","local":"loading-from-a-local-repository-for-testing","sections":[],"depth":3}],"depth":2}],"depth":1}';function wt($l){return ot(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class jt extends yt{constructor(w){super(),pt(this,w,wt,dt,at,{})}}export{jt as component};
