import{s as Et,f as lt,n as Ht,o as Wt}from"../chunks/scheduler.37c15a92.js";import{S as Rt,i as Lt,g as i,s as a,r as y,A as Qt,h as p,f as l,c as n,j as re,u as m,x as o,k as r,y as St,a as s,v as d,d as w,t as T,w as j}from"../chunks/index.2bf4358c.js";import{C as st}from"../chunks/CodeBlock.4f5fc1ad.js";import{D as Vt}from"../chunks/DocNotebookDropdown.d9dfeb24.js";import{H as ie,E as Nt}from"../chunks/EditOnGithub.8916dc7c.js";function Xt(at){let J,Me,pe,ue,h,ce,f,ye,U,nt="在本节中，我们将仔细研究 <code>Interface</code> 类，并了解用于创建其的主要参数。",me,b,de,I,it="您会注意到 <code>Interface</code> 类有 3 个必需参数：",we,C,pt="<code>Interface(fn, inputs, outputs, ...)</code>",Te,v,ot="这些参数是：",je,k,rt="<li><code>fn</code>: 由 Gradio 接口包装的预测函数。 该函数可以接受一个或多个参数并返回一个或多个值</li> <li><code>inputs</code>: 输入组件类型。 Gradio 提供了许多预构建的组件，例如<code>&quot;image&quot;</code> 或<code>&quot;mic&quot;</code>。</li> <li><code>outputs</code>: 输出组件类型。 同样，Gradio 提供了许多预构建的组件，例如 <code>“图像”</code>或“标签”`。</li>",Je,g,Mt='有关组件的完整列表，<a href="https://gradio.app/docs" rel="nofollow">请参阅 Gradio 文档</a>。 每个预构建的组件都可以通过实例化该组件对应的类来定制。',he,A,ut=`例如，正如我们在 <a href="/course/chapter9/2">上一节</a> 中看到的，您可以传入一个 <code>Textbox(lines=7, label=&quot;Prompt&quot;)</code> 组件来创建一个包含 7 行和一个标签的文本框，而不是将 <code>&quot;textbox&quot;</code> 传递给 <code>inputs</code> 参数。
让我们看另一个例子，这次是一个 <code>Audio</code> 组件。`,fe,x,Ue,$,ct=`如前所述，Gradio 提供了许多不同的输入和输出。
因此，让我们构建一个适用于音频的“接口”。`,be,G,yt="在这个例子中，我们将构建一个音频到音频的函数，它需要一个音频文件并简单地反转它。",Ie,q,mt="我们将使用 <code>Audio</code> 组件作为输入。 使用 <code>Audio</code> 组件时，您可以指定希望音频的 <code>source</code> 是用户上传的文件还是用户录制声音的麦克风。 在这种情况下，让我们将其设置为“麦克风”。 只是为了好玩，我们会在我们的“音频”中添加一个标签，上面写着“在这里说话……”。",Ce,B,dt="此外，我们希望将音频作为 numpy 数组接收，以便我们可以轻松地“反转”它。 所以我们将 <code>&quot;type&quot;</code> 设置为 <code>&quot;numpy&quot;</code>，它会传递输入data 作为 (<code>sample_rate</code>, <code>data</code>) 的元组进入我们的函数。",ve,Z,wt="我们还将使用 <code>Audio</code> 输出组件，它可以自动将具有采样率和 numpy 数据数组的元组渲染为可播放的音频文件。 在这种情况下，我们不需要进行任何自定义，因此我们将使用字符串快捷方式“audio”。",ke,_,ge,E,Tt=`上面的代码会产生一个类似下面的界面（如果你的浏览器没有
询问您的麦克风权限， <a href="https://huggingface.co/spaces/course-demos/audio-reverse" target="_blank">open the demo in  a separate tab</a>.)`,Ae,M,jt,xe,H,Jt="您现在应该能够录制自己的声音并听到自己在反向说话 - 怪异 👻!",$e,W,Ge,R,ht="假设我们有一个更复杂的函数，有多个输入和输出。在下面的示例中，我们有一个接受下拉索引、滑块值和数字的函数，并返回一个音调的音频样本。",qe,L,ft="看看我们如何传递输入和输出组件列表，看看你能不能跟上正在发生的事情。",Be,Q,Ut="这里的关键是当你通过时：",Ze,S,bt="<li>输入组件列表，每个组件依次对应一个参数。</li> <li>输出组件列表，每个组件对应一个返回值。</li>",_e,V,It="下面的代码片段显示了三个输入组件如何与 <code>generate_tone()</code> 函数的三个参数对齐：",Ee,N,He,u,Ct,We,X,Re,Y,vt=`到目前为止，我们已经使用了<code>launch()</code>方法来启动界面，但是我们
还没有真正讨论过它的作用。`,Le,z,kt="默认情况下，<code>launch()</code> 方法将在 Web 服务器中启动演示正在本地运行。 如果您在 Jupyter 或 Colab 笔记本中运行代码，那么Gradio 会将演示 GUI 嵌入到笔记本中，以便您轻松使用它。",Qe,P,gt="您可以通过不同的参数自定义 <code>launch()</code> 的行为：",Se,F,At="<li><code>inline</code> - whether to display the interface inline on Python notebooks.</li> <li><code>inbrowser</code> - whether to automatically launch the interface in a new tab on the default browser.</li> <li><code>share</code> - whether to create a publicly shareable link from your computer for the interface. Kind of like a Google Drive link!</li>",Ve,D,xt="我们将在下一节中更详细地介绍 <code>share</code> 参数！",Ne,K,Xe,O,$t=`让我们构建一个界面，让您演示 <strong>speech-recognition</strong> 模型。
为了让它变得有趣，我们将接受 <em>or</em> 麦克风输入或上传的文件。`,Ye,ee,Gt='像往常一样，我们将使用 🤗 Transformers 中的 <code>pipeline()</code> 函数加载我们的语音识别模型。如果您需要快速复习，您可以返回 <a href="/course/chapter1/3">第 1 章中的那个部分</a>。 接下来，我们将实现一个 <code>transcribe_audio()</code> 函数来处理音频并返回转录。 最后，我们将把这个函数包装在一个 <code>Interface</code> 中，其中 <code>Audio</code> 组件用于输入，只有文本用于输出。 总而言之，此应用程序的代码如下：',ze,te,Pe,le,qt='如果您的浏览器没有要求您提供麦克风权限，<a href="https://huggingface.co/spaces/course-demos/audio-reverse" target="_blank">open the demo in a separate tab</a>.',Fe,c,Bt,De,se,Zt=`就是这样！ 您现在可以使用此界面来转录音频。 注意这里
通过将 <code>optional</code> 参数作为 <code>True</code> 传递，我们允许用户
提供麦克风或音频文件（或两者都不提供，但这会返回错误消息）。`,Ke,ae,_t="继续看看如何与他人分享您的界面！",Oe,ne,et,oe,tt;return h=new ie({props:{title:"了解接口类",local:"了解接口类",headingTag:"h1"}}),f=new Vt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/chapter9/section3.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/chapter9/section3.ipynb"}]}}),b=new ie({props:{title:"如何创建接口",local:"如何创建接口",headingTag:"h2"}}),x=new ie({props:{title:"一个带音频的简单示例",local:"一个带音频的简单示例",headingTag:"h2"}}),_=new st({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQSUwQWRlZiUyMHJldmVyc2VfYXVkaW8oYXVkaW8pJTNBJTBBJTIwJTIwJTIwJTIwc3IlMkMlMjBkYXRhJTIwJTNEJTIwYXVkaW8lMEElMjAlMjAlMjAlMjByZXZlcnNlZF9hdWRpbyUyMCUzRCUyMChzciUyQyUyMG5wLmZsaXB1ZChkYXRhKSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjByZXZlcnNlZF9hdWRpbyUwQSUwQSUwQW1pYyUyMCUzRCUyMGdyLkF1ZGlvKHNvdXJjZSUzRCUyMm1pY3JvcGhvbmUlMjIlMkMlMjB0eXBlJTNEJTIybnVtcHklMjIlMkMlMjBsYWJlbCUzRCUyMlNwZWFrJTIwaGVyZS4uLiUyMiklMEFnci5JbnRlcmZhY2UocmV2ZXJzZV9hdWRpbyUyQyUyMG1pYyUyQyUyMCUyMmF1ZGlvJTIyKS5sYXVuY2goKQ==",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr


<span class="hljs-keyword">def</span> <span class="hljs-title function_">reverse_audio</span>(<span class="hljs-params">audio</span>):
    sr, data = audio
    reversed_audio = (sr, np.flipud(data))
    <span class="hljs-keyword">return</span> reversed_audio


mic = gr.Audio(source=<span class="hljs-string">&quot;microphone&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;numpy&quot;</span>, label=<span class="hljs-string">&quot;Speak here...&quot;</span>)
gr.Interface(reverse_audio, mic, <span class="hljs-string">&quot;audio&quot;</span>).launch()`,wrap:!1}}),W=new ie({props:{title:"处理多个输入和输出",local:"处理多个输入和输出",headingTag:"h2"}}),N=new st({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQW5vdGVzJTIwJTNEJTIwJTVCJTIyQyUyMiUyQyUyMCUyMkMlMjMlMjIlMkMlMjAlMjJEJTIyJTJDJTIwJTIyRCUyMyUyMiUyQyUyMCUyMkUlMjIlMkMlMjAlMjJGJTIyJTJDJTIwJTIyRiUyMyUyMiUyQyUyMCUyMkclMjIlMkMlMjAlMjJHJTIzJTIyJTJDJTIwJTIyQSUyMiUyQyUyMCUyMkElMjMlMjIlMkMlMjAlMjJCJTIyJTVEJTBBJTBBJTBBZGVmJTIwZ2VuZXJhdGVfdG9uZShub3RlJTJDJTIwb2N0YXZlJTJDJTIwZHVyYXRpb24pJTNBJTBBJTIwJTIwJTIwJTIwc3IlMjAlM0QlMjA0ODAwMCUwQSUyMCUyMCUyMCUyMGE0X2ZyZXElMkMlMjB0b25lc19mcm9tX2E0JTIwJTNEJTIwNDQwJTJDJTIwMTIlMjAqJTIwKG9jdGF2ZSUyMC0lMjA0KSUyMCUyQiUyMChub3RlJTIwLSUyMDkpJTBBJTIwJTIwJTIwJTIwZnJlcXVlbmN5JTIwJTNEJTIwYTRfZnJlcSUyMColMjAyJTIwKiolMjAodG9uZXNfZnJvbV9hNCUyMCUyRiUyMDEyKSUwQSUyMCUyMCUyMCUyMGR1cmF0aW9uJTIwJTNEJTIwaW50KGR1cmF0aW9uKSUwQSUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwbnAubGluc3BhY2UoMCUyQyUyMGR1cmF0aW9uJTJDJTIwZHVyYXRpb24lMjAqJTIwc3IpJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjAoMjAwMDAlMjAqJTIwbnAuc2luKGF1ZGlvJTIwKiUyMCgyJTIwKiUyMG5wLnBpJTIwKiUyMGZyZXF1ZW5jeSkpKS5hc3R5cGUobnAuaW50MTYpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwKHNyJTJDJTIwYXVkaW8pJTBBJTBBJTBBZ3IuSW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMGdlbmVyYXRlX3RvbmUlMkMlMEElMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5Ecm9wZG93bihub3RlcyUyQyUyMHR5cGUlM0QlMjJpbmRleCUyMiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5TbGlkZXIobWluaW11bSUzRDQlMkMlMjBtYXhpbXVtJTNENiUyQyUyMHN0ZXAlM0QxKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdyLlRleHRib3godHlwZSUzRCUyMm51bWJlciUyMiUyQyUyMHZhbHVlJTNEMSUyQyUyMGxhYmVsJTNEJTIyRHVyYXRpb24lMjBpbiUyMHNlY29uZHMlMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyYXVkaW8lMjIlMkMlMEEpLmxhdW5jaCgp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

notes = [<span class="hljs-string">&quot;C&quot;</span>, <span class="hljs-string">&quot;C#&quot;</span>, <span class="hljs-string">&quot;D&quot;</span>, <span class="hljs-string">&quot;D#&quot;</span>, <span class="hljs-string">&quot;E&quot;</span>, <span class="hljs-string">&quot;F&quot;</span>, <span class="hljs-string">&quot;F#&quot;</span>, <span class="hljs-string">&quot;G&quot;</span>, <span class="hljs-string">&quot;G#&quot;</span>, <span class="hljs-string">&quot;A&quot;</span>, <span class="hljs-string">&quot;A#&quot;</span>, <span class="hljs-string">&quot;B&quot;</span>]


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_tone</span>(<span class="hljs-params">note, octave, duration</span>):
    sr = <span class="hljs-number">48000</span>
    a4_freq, tones_from_a4 = <span class="hljs-number">440</span>, <span class="hljs-number">12</span> * (octave - <span class="hljs-number">4</span>) + (note - <span class="hljs-number">9</span>)
    frequency = a4_freq * <span class="hljs-number">2</span> ** (tones_from_a4 / <span class="hljs-number">12</span>)
    duration = <span class="hljs-built_in">int</span>(duration)
    audio = np.linspace(<span class="hljs-number">0</span>, duration, duration * sr)
    audio = (<span class="hljs-number">20000</span> * np.sin(audio * (<span class="hljs-number">2</span> * np.pi * frequency))).astype(np.int16)
    <span class="hljs-keyword">return</span> (sr, audio)


gr.Interface(
    generate_tone,
    [
        gr.Dropdown(notes, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;index&quot;</span>),
        gr.Slider(minimum=<span class="hljs-number">4</span>, maximum=<span class="hljs-number">6</span>, step=<span class="hljs-number">1</span>),
        gr.Textbox(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;number&quot;</span>, value=<span class="hljs-number">1</span>, label=<span class="hljs-string">&quot;Duration in seconds&quot;</span>),
    ],
    <span class="hljs-string">&quot;audio&quot;</span>,
).launch()`,wrap:!1}}),X=new ie({props:{title:"launch() 方法",local:"launch() 方法",headingTag:"h3"}}),K=new ie({props:{title:"✏️ 让我们应用它！",local:"✏️ 让我们应用它！",headingTag:"h2"}}),te=new st({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQW1vZGVsJTIwJTNEJTIwcGlwZWxpbmUoJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiklMEElMEElMEFkZWYlMjB0cmFuc2NyaWJlX2F1ZGlvKG1pYyUzRE5vbmUlMkMlMjBmaWxlJTNETm9uZSklM0ElMEElMjAlMjAlMjAlMjBpZiUyMG1pYyUyMGlzJTIwbm90JTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwbWljJTBBJTIwJTIwJTIwJTIwZWxpZiUyMGZpbGUlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhdWRpbyUyMCUzRCUyMGZpbGUlMEElMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIyWW91JTIwbXVzdCUyMGVpdGhlciUyMHByb3ZpZGUlMjBhJTIwbWljJTIwcmVjb3JkaW5nJTIwb3IlMjBhJTIwZmlsZSUyMiUwQSUyMCUyMCUyMCUyMHRyYW5zY3JpcHRpb24lMjAlM0QlMjBtb2RlbChhdWRpbyklNUIlMjJ0ZXh0JTIyJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdHJhbnNjcmlwdGlvbiUwQSUwQSUwQWdyLkludGVyZmFjZSglMEElMjAlMjAlMjAlMjBmbiUzRHRyYW5zY3JpYmVfYXVkaW8lMkMlMEElMjAlMjAlMjAlMjBpbnB1dHMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5BdWRpbyhzb3VyY2UlM0QlMjJtaWNyb3Bob25lJTIyJTJDJTIwdHlwZSUzRCUyMmZpbGVwYXRoJTIyJTJDJTIwb3B0aW9uYWwlM0RUcnVlKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdyLkF1ZGlvKHNvdXJjZSUzRCUyMnVwbG9hZCUyMiUyQyUyMHR5cGUlM0QlMjJmaWxlcGF0aCUyMiUyQyUyMG9wdGlvbmFsJTNEVHJ1ZSklMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRzJTNEJTIydGV4dCUyMiUyQyUwQSkubGF1bmNoKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

model = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">transcribe_audio</span>(<span class="hljs-params">mic=<span class="hljs-literal">None</span>, file=<span class="hljs-literal">None</span></span>):
    <span class="hljs-keyword">if</span> mic <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
        audio = mic
    <span class="hljs-keyword">elif</span> file <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
        audio = file
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;You must either provide a mic recording or a file&quot;</span>
    transcription = model(audio)[<span class="hljs-string">&quot;text&quot;</span>]
    <span class="hljs-keyword">return</span> transcription


gr.Interface(
    fn=transcribe_audio,
    inputs=[
        gr.Audio(source=<span class="hljs-string">&quot;microphone&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>, optional=<span class="hljs-literal">True</span>),
        gr.Audio(source=<span class="hljs-string">&quot;upload&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>, optional=<span class="hljs-literal">True</span>),
    ],
    outputs=<span class="hljs-string">&quot;text&quot;</span>,
).launch()`,wrap:!1}}),ne=new Nt({props:{source:"https://github.com/huggingface/course/blob/main/chapters/zh-CN/chapter9/3.mdx"}}),{c(){J=i("meta"),Me=a(),pe=i("p"),ue=a(),y(h.$$.fragment),ce=a(),y(f.$$.fragment),ye=a(),U=i("p"),U.innerHTML=nt,me=a(),y(b.$$.fragment),de=a(),I=i("p"),I.innerHTML=it,we=a(),C=i("p"),C.innerHTML=pt,Te=a(),v=i("p"),v.textContent=ot,je=a(),k=i("ul"),k.innerHTML=rt,Je=a(),g=i("p"),g.innerHTML=Mt,he=a(),A=i("p"),A.innerHTML=ut,fe=a(),y(x.$$.fragment),Ue=a(),$=i("p"),$.textContent=ct,be=a(),G=i("p"),G.textContent=yt,Ie=a(),q=i("p"),q.innerHTML=mt,Ce=a(),B=i("p"),B.innerHTML=dt,ve=a(),Z=i("p"),Z.innerHTML=wt,ke=a(),y(_.$$.fragment),ge=a(),E=i("p"),E.innerHTML=Tt,Ae=a(),M=i("iframe"),xe=a(),H=i("p"),H.textContent=Jt,$e=a(),y(W.$$.fragment),Ge=a(),R=i("p"),R.textContent=ht,qe=a(),L=i("p"),L.textContent=ft,Be=a(),Q=i("p"),Q.textContent=Ut,Ze=a(),S=i("ul"),S.innerHTML=bt,_e=a(),V=i("p"),V.innerHTML=It,Ee=a(),y(N.$$.fragment),He=a(),u=i("iframe"),We=a(),y(X.$$.fragment),Re=a(),Y=i("p"),Y.innerHTML=vt,Le=a(),z=i("p"),z.innerHTML=kt,Qe=a(),P=i("p"),P.innerHTML=gt,Se=a(),F=i("ul"),F.innerHTML=At,Ve=a(),D=i("p"),D.innerHTML=xt,Ne=a(),y(K.$$.fragment),Xe=a(),O=i("p"),O.innerHTML=$t,Ye=a(),ee=i("p"),ee.innerHTML=Gt,ze=a(),y(te.$$.fragment),Pe=a(),le=i("p"),le.innerHTML=qt,Fe=a(),c=i("iframe"),De=a(),se=i("p"),se.innerHTML=Zt,Ke=a(),ae=i("p"),ae.textContent=_t,Oe=a(),y(ne.$$.fragment),et=a(),oe=i("p"),this.h()},l(e){const t=Qt("svelte-u9bgzb",document.head);J=p(t,"META",{name:!0,content:!0}),t.forEach(l),Me=n(e),pe=p(e,"P",{}),re(pe).forEach(l),ue=n(e),m(h.$$.fragment,e),ce=n(e),m(f.$$.fragment,e),ye=n(e),U=p(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-1r83vyn"&&(U.innerHTML=nt),me=n(e),m(b.$$.fragment,e),de=n(e),I=p(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1mws9sp"&&(I.innerHTML=it),we=n(e),C=p(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-5xxju6"&&(C.innerHTML=pt),Te=n(e),v=p(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-qroyi9"&&(v.textContent=ot),je=n(e),k=p(e,"UL",{"data-svelte-h":!0}),o(k)!=="svelte-1twsoft"&&(k.innerHTML=rt),Je=n(e),g=p(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-1t5t5p8"&&(g.innerHTML=Mt),he=n(e),A=p(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1tefdh6"&&(A.innerHTML=ut),fe=n(e),m(x.$$.fragment,e),Ue=n(e),$=p(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-t3uzcb"&&($.textContent=ct),be=n(e),G=p(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1sgf8zz"&&(G.textContent=yt),Ie=n(e),q=p(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-1rswhy1"&&(q.innerHTML=mt),Ce=n(e),B=p(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-1fdqmpu"&&(B.innerHTML=dt),ve=n(e),Z=p(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-8hx4e2"&&(Z.innerHTML=wt),ke=n(e),m(_.$$.fragment,e),ge=n(e),E=p(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-19ylxec"&&(E.innerHTML=Tt),Ae=n(e),M=p(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),re(M).forEach(l),xe=n(e),H=p(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-h0th4"&&(H.textContent=Jt),$e=n(e),m(W.$$.fragment,e),Ge=n(e),R=p(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1hjkmrj"&&(R.textContent=ht),qe=n(e),L=p(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-j36y51"&&(L.textContent=ft),Be=n(e),Q=p(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-1imk4s5"&&(Q.textContent=Ut),Ze=n(e),S=p(e,"UL",{"data-svelte-h":!0}),o(S)!=="svelte-1spg63n"&&(S.innerHTML=bt),_e=n(e),V=p(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-pubjjy"&&(V.innerHTML=It),Ee=n(e),m(N.$$.fragment,e),He=n(e),u=p(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),re(u).forEach(l),We=n(e),m(X.$$.fragment,e),Re=n(e),Y=p(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-17ffrgx"&&(Y.innerHTML=vt),Le=n(e),z=p(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-hzvwvn"&&(z.innerHTML=kt),Qe=n(e),P=p(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-f8llzq"&&(P.innerHTML=gt),Se=n(e),F=p(e,"UL",{"data-svelte-h":!0}),o(F)!=="svelte-f1qyss"&&(F.innerHTML=At),Ve=n(e),D=p(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-bqa4yo"&&(D.innerHTML=xt),Ne=n(e),m(K.$$.fragment,e),Xe=n(e),O=p(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-14w6266"&&(O.innerHTML=$t),Ye=n(e),ee=p(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-1h31kni"&&(ee.innerHTML=Gt),ze=n(e),m(te.$$.fragment,e),Pe=n(e),le=p(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-s290pj"&&(le.innerHTML=qt),Fe=n(e),c=p(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),re(c).forEach(l),De=n(e),se=p(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-17xiolg"&&(se.innerHTML=Zt),Ke=n(e),ae=p(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-1thcljn"&&(ae.textContent=_t),Oe=n(e),m(ne.$$.fragment,e),et=n(e),oe=p(e,"P",{}),re(oe).forEach(l),this.h()},h(){r(J,"name","hf:doc:metadata"),r(J,"content",Yt),lt(M.src,jt="https://course-demos-audio-reverse.hf.space")||r(M,"src",jt),r(M,"frameborder","0"),r(M,"height","250"),r(M,"title","Gradio app"),r(M,"class","container p-0 flex-grow space-iframe"),r(M,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),r(M,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),lt(u.src,Ct="https://course-demos-generate-tone.hf.space")||r(u,"src",Ct),r(u,"frameborder","0"),r(u,"height","450"),r(u,"title","Gradio app"),r(u,"class","container p-0 flex-grow space-iframe"),r(u,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),r(u,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),lt(c.src,Bt="https://course-demos-asr.hf.space")||r(c,"src",Bt),r(c,"frameborder","0"),r(c,"height","550"),r(c,"title","Gradio app"),r(c,"class","container p-0 flex-grow space-iframe"),r(c,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),r(c,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads")},m(e,t){St(document.head,J),s(e,Me,t),s(e,pe,t),s(e,ue,t),d(h,e,t),s(e,ce,t),d(f,e,t),s(e,ye,t),s(e,U,t),s(e,me,t),d(b,e,t),s(e,de,t),s(e,I,t),s(e,we,t),s(e,C,t),s(e,Te,t),s(e,v,t),s(e,je,t),s(e,k,t),s(e,Je,t),s(e,g,t),s(e,he,t),s(e,A,t),s(e,fe,t),d(x,e,t),s(e,Ue,t),s(e,$,t),s(e,be,t),s(e,G,t),s(e,Ie,t),s(e,q,t),s(e,Ce,t),s(e,B,t),s(e,ve,t),s(e,Z,t),s(e,ke,t),d(_,e,t),s(e,ge,t),s(e,E,t),s(e,Ae,t),s(e,M,t),s(e,xe,t),s(e,H,t),s(e,$e,t),d(W,e,t),s(e,Ge,t),s(e,R,t),s(e,qe,t),s(e,L,t),s(e,Be,t),s(e,Q,t),s(e,Ze,t),s(e,S,t),s(e,_e,t),s(e,V,t),s(e,Ee,t),d(N,e,t),s(e,He,t),s(e,u,t),s(e,We,t),d(X,e,t),s(e,Re,t),s(e,Y,t),s(e,Le,t),s(e,z,t),s(e,Qe,t),s(e,P,t),s(e,Se,t),s(e,F,t),s(e,Ve,t),s(e,D,t),s(e,Ne,t),d(K,e,t),s(e,Xe,t),s(e,O,t),s(e,Ye,t),s(e,ee,t),s(e,ze,t),d(te,e,t),s(e,Pe,t),s(e,le,t),s(e,Fe,t),s(e,c,t),s(e,De,t),s(e,se,t),s(e,Ke,t),s(e,ae,t),s(e,Oe,t),d(ne,e,t),s(e,et,t),s(e,oe,t),tt=!0},p:Ht,i(e){tt||(w(h.$$.fragment,e),w(f.$$.fragment,e),w(b.$$.fragment,e),w(x.$$.fragment,e),w(_.$$.fragment,e),w(W.$$.fragment,e),w(N.$$.fragment,e),w(X.$$.fragment,e),w(K.$$.fragment,e),w(te.$$.fragment,e),w(ne.$$.fragment,e),tt=!0)},o(e){T(h.$$.fragment,e),T(f.$$.fragment,e),T(b.$$.fragment,e),T(x.$$.fragment,e),T(_.$$.fragment,e),T(W.$$.fragment,e),T(N.$$.fragment,e),T(X.$$.fragment,e),T(K.$$.fragment,e),T(te.$$.fragment,e),T(ne.$$.fragment,e),tt=!1},d(e){e&&(l(Me),l(pe),l(ue),l(ce),l(ye),l(U),l(me),l(de),l(I),l(we),l(C),l(Te),l(v),l(je),l(k),l(Je),l(g),l(he),l(A),l(fe),l(Ue),l($),l(be),l(G),l(Ie),l(q),l(Ce),l(B),l(ve),l(Z),l(ke),l(ge),l(E),l(Ae),l(M),l(xe),l(H),l($e),l(Ge),l(R),l(qe),l(L),l(Be),l(Q),l(Ze),l(S),l(_e),l(V),l(Ee),l(He),l(u),l(We),l(Re),l(Y),l(Le),l(z),l(Qe),l(P),l(Se),l(F),l(Ve),l(D),l(Ne),l(Xe),l(O),l(Ye),l(ee),l(ze),l(Pe),l(le),l(Fe),l(c),l(De),l(se),l(Ke),l(ae),l(Oe),l(et),l(oe)),l(J),j(h,e),j(f,e),j(b,e),j(x,e),j(_,e),j(W,e),j(N,e),j(X,e),j(K,e),j(te,e),j(ne,e)}}}const Yt='{"title":"了解接口类","local":"了解接口类","sections":[{"title":"如何创建接口","local":"如何创建接口","sections":[],"depth":2},{"title":"一个带音频的简单示例","local":"一个带音频的简单示例","sections":[],"depth":2},{"title":"处理多个输入和输出","local":"处理多个输入和输出","sections":[{"title":"launch() 方法","local":"launch() 方法","sections":[],"depth":3}],"depth":2},{"title":"✏️ 让我们应用它！","local":"✏️ 让我们应用它！","sections":[],"depth":2}],"depth":1}';function zt(at){return Wt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class el extends Rt{constructor(J){super(),Lt(this,J,zt,Xt,Et,{})}}export{el as component};
