import{s as Vn,o as _n,n as qn}from"../chunks/scheduler.37c15a92.js";import{S as Bn,i as An,g as i,s as l,r as p,A as Zn,h as r,f as n,c as a,j as In,u,x as J,k as zn,y as Xn,a as t,v as o,d as c,t as m,w as M}from"../chunks/index.2bf4358c.js";import{T as Nn}from"../chunks/Tip.363c041f.js";import{Y as En}from"../chunks/Youtube.1e50a667.js";import{C as d}from"../chunks/CodeBlock.4e987730.js";import{C as Gn}from"../chunks/CourseFloatingBanner.6add7356.js";import{H as Ls,E as Wn}from"../chunks/getInferenceSnippets.7bb25a7f.js";function Hn(_e){let y,T="⚠️ Entraîner un <em>tokenizer</em> n’est pas la même chose qu’entraîner un modèle ! L’entraînement du modèle utilise la descente de gradient stochastique pour réduire un peu plus la perte à chaque batch. Il est par nature aléatoire (ce qui signifie que vous devez définir des graines pour obtenir les mêmes résultats lorsque vous effectuez deux fois le même entraînement). Entraîner un <em>tokenizer</em> est un processus statistique qui identifie les meilleurs sous-mots à choisir pour un corpus donné. Les règles exactes utilisées pour les choisir dépendent de l’algorithme de tokénisation. Le processus est déterministe, ce qui signifie que vous obtenez toujours les mêmes résultats lorsque vous vous entraînez avec le même algorithme sur le même corpus.";return{c(){y=i("p"),y.innerHTML=T},l(j){y=r(j,"P",{"data-svelte-h":!0}),J(y)!=="svelte-1nhpa41"&&(y.innerHTML=T)},m(j,ze){t(j,y,ze)},p:qn,d(j){j&&n(y)}}}function Dn(_e){let y,T,j,ze,x,qe,f,Be,U,Ps='Si un modèle de langue n’est pas disponible dans la langue qui vous intéresse ou si votre corpus est très différent de celui sur lequel votre modèle de langue a été entraîné, vous voudrez très probablement réentraîner le modèle à partir de zéro en utilisant un <em>tokenizer</em> adapté à vos données. Pour ce faire, vous devrez entraîner un nouveau <em>tokenizer</em> sur votre jeu de données. Mais qu’est-ce que cela signifie exactement ? Lorsque nous avons examiné pour la première fois les <em>tokenizers</em> dans le <a href="/course/fr/chapter2">chapitre 2</a>, nous avons vu que la plupart des <em>transformers</em> utilisent un <em>algorithme de tokenisation en sous-mots</em>. Pour identifier les sous-mots qui sont intéressants et qui apparaissent le plus fréquemment dans un corpus donné, le <em>tokenizer</em> doit examiner attentivement tous les textes du corpus. C’est un processus que nous appelons <em>entraînement</em>. Les règles exactes qui régissent cet apprentissage dépendent du type de <em>tokenizer</em> utilisé. Nous passerons en revue les trois principaux algorithmes plus loin dans ce chapitre.',Ae,g,Ze,h,Xe,w,Ne,b,Fs="Il y a une API très simple dans 🤗 <em>Transformers</em> que vous pouvez utiliser pour entraîner un nouveau <em>tokenizer</em> avec les mêmes caractéristiques qu’un déjà existant : <code>AutoTokenizer.train_new_from_iterator()</code>. Pour illustrer cela, disons que nous voulons entraîner GPT-2 à partir de zéro mais dans une langue autre que l’anglais. Notre première tâche est de rassembler des batchs de données dans cette langue dans un corpus d’entraînement. Pour avoir des exemples que tout le monde puisse comprendre, nous n’utiliserons pas ici une langue comme le russe ou le chinois mais plutôt une langue anglaise spécialisée : le langage Python.",Ee,v,Ks='La bibliothèque <a href="https://github.com/huggingface/datasets" rel="nofollow">🤗 <em>Datasets</em></a> peut nous aider à assembler un corpus de code source Python. Nous allons utiliser la fonction habituelle <code>load_dataset()</code> pour télécharger et mettre en cache le jeu de données <a href="https://huggingface.co/datasets/code_search_net" rel="nofollow">CodeSearchNet</a>. Ce jeu de données a été créé pour le <a href="https://wandb.ai/github/CodeSearchNet/benchmark" rel="nofollow">CodeSearchNet challenge</a> et contient des millions de fonctions provenant de bibliothèques open source sur GitHub dans plusieurs langages de programmation. Ici, nous allons charger la partie Python de ce jeu de données :',Ge,C,We,$,Os="Nous pouvons jeter un coup d’œil au jeu d’entraînement pour voir quelles sont les colonnes auxquelles nous avons accès :",He,Q,De,k,Re,I,en="Nous pouvons voir que le jeu de données sépare les chaînes de documents du code et suggère une tokenization des deux. Ici, nous utiliserons simplement la colonne <code>whole_func_string</code> pour entraîner notre <em>tokenizer</em>. Nous pouvons regarder un exemple de la façon suivante :",Ye,z,Se,V,sn="qui nous affiche ce qui suit :",Le,_,Pe,q,nn="La première chose à faire est de transformer le jeu de données en un <em>itérateur</em> de listes de textes. Par exemple, une liste de listes de textes. L’utilisation de listes de textes permet à notre <em>tokenizer</em> d’aller plus vite (l’entraînement a alors lieu sur des batchs de textes au lieu de traiter des textes un par un). Et le fait que ce soit un itérateur permet d’éviter d’avoir tout en mémoire en même temps. Si votre corpus est énorme, vous voudrez profiter du fait que 🤗 <em>Datasets</em> ne charge pas tout en RAM mais stocke les éléments du jeu de données sur le disque.",Fe,B,tn="Faire ce qui suit créerait une liste de listes de 1 000 textes chacune mais chargerait tout en mémoire :",Ke,A,Oe,Z,ln="En utilisant un générateur, nous pouvons éviter que Python ne charge quoi que ce soit en mémoire à moins que cela soit réellement nécessaire. Pour créer un tel générateur, il suffit de remplacer les crochets par des parenthèses :",es,X,ss,N,an="Cette ligne de code ne récupère aucun élément du jeu de données. Elle crée simplement un objet que vous pouvez utiliser dans une boucle <code>for</code> Python. Les textes ne seront chargés que lorsque vous en aurez besoin (c’est-à-dire lorsque vous serez à l’étape de la boucle <code>for</code> qui les requiert) et seulement 1 000 textes à la fois. De cette façon, vous n’épuiserez pas toute votre mémoire, même si vous traitez un énorme jeu de données.",ns,E,rn="Le problème avec un objet générateur est qu’il ne peut être utilisé qu’une seule fois. Ainsi, au lieu que cet objet nous donne deux fois la liste des 10 premiers chiffres :",ts,G,ls,W,pn="on les reçoit une fois et ensuite une liste vide :",as,H,is,D,un="C’est pourquoi nous définissons une fonction qui renvoie un générateur à la place :",rs,R,ps,Y,on="Vous pouvez également définir votre générateur à l’intérieur d’une boucle <code>for</code> en utilisant l’instruction <code>yield</code> :",us,S,os,L,cn="qui produit exactement le même générateur que précédemment mais  permet d’utiliser une logique plus complexe que celle que vous pouvez utiliser dans une compréhension de liste.",cs,P,ms,F,mn="Maintenant que nous avons notre corpus sous la forme d’un itérateur de batchs de textes, nous sommes prêts à entraîner un nouveau <em>tokenizer</em>. Pour ce faire, nous devons d’abord charger le <em>tokenizer</em> que nous voulons coupler avec notre modèle (ici, le GPT-2) :",Ms,K,Js,O,Mn="Même si nous allons entraîner un nouveau <em>tokenizer</em>, c’est une bonne idée de faire ça pour éviter de partir entièrement de zéro. De cette façon, nous n’aurons pas à spécifier l’algorithme de tokénisation ou les jetons spéciaux que nous voulons utiliser. Notre nouveau <em>tokenizer</em> sera exactement le même que celui du GPT-2. La seule chose qui changera sera le vocabulaire qui sera déterminé lors de l’entraînement sur notre corpus.",ds,ee,Jn="Voyons d’abord comment ce <em>tokenizer</em> traiterait un exemple de fonction :",ys,se,js,ne,hs,te,dn="Ce <em>tokenizer</em> possède quelques symboles spéciaux, comme <code>Ġ</code> et <code>Ċ</code>, qui désignent respectivement les espaces et les retours à la ligne. Comme on peut le voir, ce n’est pas très efficace. Le <em>tokenizer</em> renvoie des jetons individuels pour chaque espace alors qu’il pourrait regrouper ceux des indentations (puisqu’avoir des ensembles de quatre ou huit espaces est très courant dans du code). Il divise également le nom de la fonction de façon un peu bizarre car pas habitué à voir des mots avec le caractère <code>_</code>.",Ts,le,yn="Entraînons un nouveau <em>tokenizer</em> et voyons s’il résout ces problèmes. Pour cela, nous allons utiliser la méthode <code>train_new_from_iterator()</code> :",xs,ae,fs,ie,jn="Cette commande peut prendre un peu de temps si votre corpus est très grand. Pour ce jeu de données de 1,6 Go de textes, elle est très rapide (1 minute 16 secondes sur un CPU AMD Ryzen 9 3900X avec 12 cœurs).",Us,re,hn='Notez que <code>AutoTokenizer.train_new_from_iterator()</code> ne fonctionne que si le <em>tokenizer</em> que vous utilisez est un <em>tokenizer</em> « rapide ». Comme vous le verrez dans la section suivante, la bibliothèque 🤗 <em>Transformers</em> contient deux types de <em>tokenizers</em> : certains sont écrits en pur Python et d’autres (les rapides) sont soutenus par la bibliothèque 🤗 <em>Tokenizers</em> qui est écrite dans le langage <a href="https://www.rust-lang.org" rel="nofollow">Rust</a>. Python est le langage le plus souvent utilisé pour les applications de science des données et d’apprentissage profond, mais lorsque quelque chose doit être parallélisé pour être rapide, il faut que cela soit écrit dans un autre langage. Par exemple, les multiplications matricielles qui sont au cœur du calcul du modèle sont écrites en CUDA, une bibliothèque en C optimisée pour les GPUs.',gs,pe,Tn='Entraîner un tout nouveau <em>tokenizer</em> en Python pur est atrocement lent, c’est pourquoi nous avons développé la bibliothèque 🤗 <em>Tokenizers</em>. Notez que, tout comme vous n’avez pas eu à apprendre le langage CUDA pour pouvoir exécuter votre modèle sur un batch d’entrées sur un GPU, vous n’aurez pas besoin d’apprendre Rust pour utiliser un <em>tokenizer</em> rapide. La bibliothèque 🤗 <em>Tokenizers</em> fournit des liaisons Python pour de nombreuses méthodes qui appellent en interne un morceau de code en Rust. Par exemple, pour paralléliser l’entraînement de votre nouveau <em>tokenizer</em> ou, comme nous l’avons vu dans le <a href="/course/fr/chapter3">chapitre 3</a>, la tokenisation d’un lot d’entrées.',ws,ue,xn='La plupart des <em>transformers</em> ont un <em>tokenizer</em> rapide de disponible. Il y a quelques exceptions que vous pouvez vérifier <a href="https://huggingface.co/transformers/#supported-frameworks" rel="nofollow">ici</a>. S’il est disponible, l’API <code>AutoTokenizer</code> sélectionne toujours pour vous le <em>tokenizer</em> rapide. Dans la prochaine section, nous allons jeter un coup d’oeil à certaines des autres caractéristiques spéciales des <em>tokenizers</em> rapides, qui seront très utiles pour des tâches comme la classification de <em>tokens</em> et la réponse aux questions. Mais avant cela, essayons notre tout nouveau <em>tokenizer</em> sur l’exemple précédent :',bs,oe,vs,ce,Cs,me,fn="Ici, nous voyons à nouveau les symboles spéciaux <code>Ġ</code> et <code>Ċ</code> qui indiquent les espaces et les retours à la ligne. Nous pouvons également voir que notre <em>tokenizer</em> a appris certains <em>tokens</em> qui sont très spécifiques à un corpus de fonctions Python. Par exemple, il y a un token <code>ĊĠĠĠ</code> qui représente une indentation et un <em>token</em> <code>Ġ&quot;&quot;&quot;</code> qui représente les trois guillemets qui commencent une <em>docstring</em>. Le <em>tokenizer</em> divise également correctement le nom de la fonction sur <code>_</code>. Il s’agit d’une représentation assez compacte. En comparaison, l’utilisation du <em>tokenizer</em> en anglais « simple » sur le même exemple nous donnera une phrase plus longue :",$s,Me,Qs,Je,ks,de,Un="Prenons un autre exemple :",Is,ye,zs,je,Vs,he,gn="En plus du <em>token</em> correspondant à une indentation, on peut également voir ici un <em>token</em> pour une double indentation : <code>ĊĠĠĠĠĠĠĠĠĠ</code>. Les mots spéciaux de Python comme <code>class</code>, <code>init</code>, <code>call</code>, <code>self</code>, et <code>return</code> sont tous tokenizés comme un seul <em>token</em>. Nous pouvons voir qu’en plus de séparer sur <code>_</code> et <code>.</code> le tokenizer sépare correctement même les noms en minuscules. Par exemple <code>LinearLayer</code> est tokenisé comme <code>[&quot;ĠLinear&quot;, &quot;Layer&quot;]</code>.",_s,Te,qs,xe,wn="Pour être sûr de pouvoir l’utiliser plus tard, nous devons sauvegarder notre nouveau <em>tokenizer</em>. Comme pour les modèles, ceci est fait avec la méthode <code>save_pretrained()</code> :",Bs,fe,As,Ue,bn="Cela créera un nouveau dossier nommé <em>code-search-net-tokenizer</em> contenant tous les fichiers dont le <em>tokenizer</em> a besoin pour être rechargé. Si vous souhaitez partager ce <em>tokenizer</em> avec vos collègues et amis, vous pouvez le télécharger sur le <em>Hub</em> en vous connectant à votre compte. Si vous travaillez dans un <em>notebook</em>, il existe une fonction pratique pour vous aider à le faire :",Zs,ge,Xs,we,vn="Cela affichera un <em>widget</em> où vous pourrez entrer vos identifiants de connexion à Hugging Face. Si vous ne travaillez pas sur un ordinateur portable, tapez simplement la ligne suivante dans votre terminal :",Ns,be,Es,ve,Cn="Une fois connecté, vous pouvez pousser votre <em>tokenizer</em> en exécutant la commande suivante :",Gs,Ce,Ws,$e,$n="Cela créera un nouveau dépôt dans votre espace avec le nom <code>code-search-net-tokenizer</code> contenant le fichier <em>tokenizer</em>. Vous pouvez ensuite charger le <em>tokenizer</em> de n’importe où avec la méthode <code>from_pretrained()</code> :",Hs,Qe,Ds,ke,Qn='Vous êtes maintenant prêt à entraîner un modèle de langue à partir de zéro et à le <em>finetuner</em> sur votre tâche ! Nous verrons cela dans le <a href="/course/fr/chapter7">chapitre 7</a>, mais d’abord, dans le reste de ce chapitre, nous allons examiner de plus près les <em>tokenizers</em> rapides et explorer en détail ce qui se passe lorsque nous appelons la méthode <code>train_new_from_iterator()</code>.',Rs,Ie,Ys,Ve,Ss;return x=new Ls({props:{title:"Entraîner un nouveau <i> tokenizer </i> à partir d’un ancien",local:"entraîner-un-nouveau-i-tokenizer-i-à-partir-dun-ancien",headingTag:"h1"}}),f=new Gn({props:{chapter:6,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"English",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter6/section2.ipynb"},{label:"Français",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/fr/chapter6/section2.ipynb"},{label:"English",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter6/section2.ipynb"},{label:"Français",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/fr/chapter6/section2.ipynb"}]}}),g=new En({props:{id:"DJimQynXZsQ"}}),h=new Nn({props:{warning:!0,$$slots:{default:[Hn]},$$scope:{ctx:_e}}}),w=new Ls({props:{title:"Assemblage d’un corpus",local:"assemblage-dun-corpus",headingTag:"h2"}}),C=new d({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBJTIzJTIwQ2VsYSUyMHBldXQlMjBwcmVuZHJlJTIwcXVlbHF1ZXMlMjBtaW51dGVzJTIwYWxvcnMlMjBwcmVuZXolMjB1biUyMHRoJUMzJUE5JTIwb3UlMjB1biUyMGNhZiVDMyVBOSUyMHBlbmRhbnQlMjBxdWUlMjB2b3VzJTIwcGF0aWVudGV6JTIwISUwQXJhd19kYXRhc2V0cyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJjb2RlX3NlYXJjaF9uZXQlMjIlMkMlMjAlMjJweXRob24lMjIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># Cela peut prendre quelques minutes alors prenez un thé ou un café pendant que vous patientez !</span>
raw_datasets = load_dataset(<span class="hljs-string">&quot;code_search_net&quot;</span>, <span class="hljs-string">&quot;python&quot;</span>)`,wrap:!1}}),Q=new d({props:{code:"cmF3X2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQ=",highlighted:'raw_datasets[<span class="hljs-string">&quot;train&quot;</span>]',wrap:!1}}),k=new d({props:{code:"RGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QidyZXBvc2l0b3J5X25hbWUnJTJDJTIwJ2Z1bmNfcGF0aF9pbl9yZXBvc2l0b3J5JyUyQyUyMCdmdW5jX25hbWUnJTJDJTIwJ3dob2xlX2Z1bmNfc3RyaW5nJyUyQyUyMCdsYW5ndWFnZSclMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAnZnVuY19jb2RlX3N0cmluZyclMkMlMjAnZnVuY19jb2RlX3Rva2VucyclMkMlMjAnZnVuY19kb2N1bWVudGF0aW9uX3N0cmluZyclMkMlMjAnZnVuY19kb2N1bWVudGF0aW9uX3Rva2VucyclMkMlMjAnc3BsaXRfbmFtZSclMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAnZnVuY19jb2RlX3VybCclMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjBudW1fcm93cyUzQSUyMDQxMjE3OCUwQSU3RCk=",highlighted:`Dataset({
    features: [<span class="hljs-string">&#x27;repository_name&#x27;</span>, <span class="hljs-string">&#x27;func_path_in_repository&#x27;</span>, <span class="hljs-string">&#x27;func_name&#x27;</span>, <span class="hljs-string">&#x27;whole_func_string&#x27;</span>, <span class="hljs-string">&#x27;language&#x27;</span>, 
      <span class="hljs-string">&#x27;func_code_string&#x27;</span>, <span class="hljs-string">&#x27;func_code_tokens&#x27;</span>, <span class="hljs-string">&#x27;func_documentation_string&#x27;</span>, <span class="hljs-string">&#x27;func_documentation_tokens&#x27;</span>, <span class="hljs-string">&#x27;split_name&#x27;</span>, 
      <span class="hljs-string">&#x27;func_code_url&#x27;</span>
    ],
    num_rows: <span class="hljs-number">412178</span>
})`,wrap:!1}}),z=new d({props:{code:"cHJpbnQocmF3X2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlNUIxMjM0NTYlNUQlNUIlMjJ3aG9sZV9mdW5jX3N0cmluZyUyMiU1RCk=",highlighted:'<span class="hljs-built_in">print</span>(raw_datasets[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">123456</span>][<span class="hljs-string">&quot;whole_func_string&quot;</span>])',wrap:!1}}),_=new d({props:{code:"ZGVmJTIwaGFuZGxlX3NpbXBsZV9yZXNwb25zZXMoJTBBJTIwJTIwJTIwJTIwJTIwJTIwc2VsZiUyQyUyMHRpbWVvdXRfbXMlM0ROb25lJTJDJTIwaW5mb19jYiUzRERFRkFVTFRfTUVTU0FHRV9DQUxMQkFDSyklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJBY2NlcHRzJTIwbm9ybWFsJTIwcmVzcG9uc2VzJTIwZnJvbSUyMHRoZSUyMGRldmljZS4lMEElMEElMjAlMjAlMjAlMjBBcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGltZW91dF9tcyUzQSUyMFRpbWVvdXQlMjBpbiUyMG1pbGxpc2Vjb25kcyUyMHRvJTIwd2FpdCUyMGZvciUyMGVhY2glMjByZXNwb25zZS4lMEElMjAlMjAlMjAlMjAlMjAlMjBpbmZvX2NiJTNBJTIwT3B0aW9uYWwlMjBjYWxsYmFjayUyMGZvciUyMHRleHQlMjBzZW50JTIwZnJvbSUyMHRoZSUyMGJvb3Rsb2FkZXIuJTBBJTBBJTIwJTIwJTIwJTIwUmV0dXJucyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyME9LQVklMjBwYWNrZXQncyUyMG1lc3NhZ2UuJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc2VsZi5fYWNjZXB0X3Jlc3BvbnNlcygnT0tBWSclMkMlMjBpbmZvX2NiJTJDJTIwdGltZW91dF9tcyUzRHRpbWVvdXRfbXMp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">handle_simple_responses</span>(<span class="hljs-params">
      self, timeout_ms=<span class="hljs-literal">None</span>, info_cb=DEFAULT_MESSAGE_CALLBACK</span>):
    <span class="hljs-string">&quot;&quot;&quot;Accepts normal responses from the device.

    Args:
      timeout_ms: Timeout in milliseconds to wait for each response.
      info_cb: Optional callback for text sent from the bootloader.

    Returns:
      OKAY packet&#x27;s message.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> self._accept_responses(<span class="hljs-string">&#x27;OKAY&#x27;</span>, info_cb, timeout_ms=timeout_ms)`,wrap:!1}}),A=new d({props:{code:"JTIzJTIwTmUlMjBkJUMzJUE5Y29tbWVudGV6JTIwcGFzJTIwbGElMjBsaWduZSUyMHN1aXZhbnRlJTIwJUMzJUEwJTIwbW9pbnMlMjBxdWUlMjB2b3RyZSUyMGpldSUyMGRlJTIwZG9ubiVDMyVBOWVzJTIwc29pdCUyMHBldGl0JTIwISUwQSUyMyUyMHRyYWluaW5nX2NvcnB1cyUyMCUzRCUyMCU1QnJhd19kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVEJTVCaSUzQSUyMGklMjAlMkIlMjAxMDAwJTVEJTVCJTIyd2hvbGVfZnVuY19zdHJpbmclMjIlNUQlMjBmb3IlMjBpJTIwaW4lMjByYW5nZSgwJTJDJTIwbGVuKHJhd19kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVEKSUyQyUyMDEwMDApJTVE",highlighted:`<span class="hljs-comment"># Ne décommentez pas la ligne suivante à moins que votre jeu de données soit petit !</span>
<span class="hljs-comment"># training_corpus = [raw_datasets[&quot;train&quot;][i: i + 1000][&quot;whole_func_string&quot;] for i in range(0, len(raw_datasets[&quot;train&quot;]), 1000)]</span>`,wrap:!1}}),X=new d({props:{code:"dHJhaW5pbmdfY29ycHVzJTIwJTNEJTIwKCUwQSUyMCUyMCUyMCUyMHJhd19kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVEJTVCaSUyMCUzQSUyMGklMjAlMkIlMjAxMDAwJTVEJTVCJTIyd2hvbGVfZnVuY19zdHJpbmclMjIlNUQlMEElMjAlMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZSgwJTJDJTIwbGVuKHJhd19kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVEKSUyQyUyMDEwMDApJTBBKQ==",highlighted:`training_corpus = (
    raw_datasets[<span class="hljs-string">&quot;train&quot;</span>][i : i + <span class="hljs-number">1000</span>][<span class="hljs-string">&quot;whole_func_string&quot;</span>]
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(raw_datasets[<span class="hljs-string">&quot;train&quot;</span>]), <span class="hljs-number">1000</span>)
)`,wrap:!1}}),G=new d({props:{code:"Z2VuJTIwJTNEJTIwKGklMjBmb3IlMjBpJTIwaW4lMjByYW5nZSgxMCkpJTBBcHJpbnQobGlzdChnZW4pKSUwQXByaW50KGxpc3QoZ2VuKSk=",highlighted:`gen = (i <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">10</span>))
<span class="hljs-built_in">print</span>(<span class="hljs-built_in">list</span>(gen))
<span class="hljs-built_in">print</span>(<span class="hljs-built_in">list</span>(gen))`,wrap:!1}}),H=new d({props:{code:"JTVCMCUyQyUyMDElMkMlMjAyJTJDJTIwMyUyQyUyMDQlMkMlMjA1JTJDJTIwNiUyQyUyMDclMkMlMjA4JTJDJTIwOSU1RCUwQSU1QiU1RA==",highlighted:`[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>]
[]`,wrap:!1}}),R=new d({props:{code:"ZGVmJTIwZ2V0X3RyYWluaW5nX2NvcnB1cygpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJhd19kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVEJTVCaSUyMCUzQSUyMGklMjAlMkIlMjAxMDAwJTVEJTVCJTIyd2hvbGVfZnVuY19zdHJpbmclMjIlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZSgwJTJDJTIwbGVuKHJhd19kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVEKSUyQyUyMDEwMDApJTBBJTIwJTIwJTIwJTIwKSUwQSUwQSUwQXRyYWluaW5nX2NvcnB1cyUyMCUzRCUyMGdldF90cmFpbmluZ19jb3JwdXMoKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_training_corpus</span>():
    <span class="hljs-keyword">return</span> (
        raw_datasets[<span class="hljs-string">&quot;train&quot;</span>][i : i + <span class="hljs-number">1000</span>][<span class="hljs-string">&quot;whole_func_string&quot;</span>]
        <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(raw_datasets[<span class="hljs-string">&quot;train&quot;</span>]), <span class="hljs-number">1000</span>)
    )


training_corpus = get_training_corpus()`,wrap:!1}}),S=new d({props:{code:"ZGVmJTIwZ2V0X3RyYWluaW5nX2NvcnB1cygpJTNBJTBBJTIwJTIwJTIwJTIwZGF0YXNldCUyMCUzRCUyMHJhd19kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwc3RhcnRfaWR4JTIwaW4lMjByYW5nZSgwJTJDJTIwbGVuKGRhdGFzZXQpJTJDJTIwMTAwMCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzYW1wbGVzJTIwJTNEJTIwZGF0YXNldCU1QnN0YXJ0X2lkeCUyMCUzQSUyMHN0YXJ0X2lkeCUyMCUyQiUyMDEwMDAlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB5aWVsZCUyMHNhbXBsZXMlNUIlMjJ3aG9sZV9mdW5jX3N0cmluZyUyMiU1RA==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_training_corpus</span>():
    dataset = raw_datasets[<span class="hljs-string">&quot;train&quot;</span>]
    <span class="hljs-keyword">for</span> start_idx <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(dataset), <span class="hljs-number">1000</span>):
        samples = dataset[start_idx : start_idx + <span class="hljs-number">1000</span>]
        <span class="hljs-keyword">yield</span> samples[<span class="hljs-string">&quot;whole_func_string&quot;</span>]`,wrap:!1}}),P=new Ls({props:{title:"Entraînement d’un nouveau <i> tokenizer </i>",local:"entraînement-dun-nouveau-i-tokenizer-i",headingTag:"h2"}}),K=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEFvbGRfdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

old_tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)`,wrap:!1}}),se=new d({props:{code:"ZXhhbXBsZSUyMCUzRCUyMCcnJ2RlZiUyMGFkZF9udW1iZXJzKGElMkMlMjBiKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkFkZCUyMHRoZSUyMHR3byUyMG51bWJlcnMlMjAlNjBhJTYwJTIwYW5kJTIwJTYwYiU2MC4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBhJTIwJTJCJTIwYicnJyUwQSUwQXRva2VucyUyMCUzRCUyMG9sZF90b2tlbml6ZXIudG9rZW5pemUoZXhhbXBsZSklMEF0b2tlbnM=",highlighted:`example = <span class="hljs-string">&#x27;&#x27;&#x27;def add_numbers(a, b):
    &quot;&quot;&quot;Add the two numbers \`a\` and \`b\`.&quot;&quot;&quot;
    return a + b&#x27;&#x27;&#x27;</span>

tokens = old_tokenizer.tokenize(example)
tokens`,wrap:!1}}),ne=new d({props:{code:"JTVCJ2RlZiclMkMlMjAnJUM0JUEwYWRkJyUyQyUyMCdfJyUyQyUyMCduJyUyQyUyMCd1bWJlcnMnJTJDJTIwJygnJTJDJTIwJ2EnJTJDJTIwJyUyQyclMkMlMjAnJUM0JUEwYiclMkMlMjAnKSUzQSclMkMlMjAnJUM0JThBJyUyQyUyMCclQzQlQTAnJTJDJTIwJyVDNCVBMCclMkMlMjAnJUM0JUEwJyUyQyUyMCclQzQlQTAlMjIlMjIlMjInJTJDJTIwJ0FkZCclMkMlMjAnJUM0JUEwdGhlJyUyQyUyMCclQzQlQTB0d28nJTJDJTBBJTIwJyVDNCVBMG51bWJlcnMnJTJDJTIwJyVDNCVBMCU2MCclMkMlMjAnYSclMkMlMjAnJTYwJyUyQyUyMCclQzQlQTBhbmQnJTJDJTIwJyVDNCVBMCU2MCclMkMlMjAnYiclMkMlMjAnJTYwJyUyQyUyMCcuJTIyJyUyQyUyMCclMjIlMjInJTJDJTIwJyVDNCU4QSclMkMlMjAnJUM0JUEwJyUyQyUyMCclQzQlQTAnJTJDJTIwJyVDNCVBMCclMkMlMjAnJUM0JUEwcmV0dXJuJyUyQyUyMCclQzQlQTBhJyUyQyUyMCclQzQlQTAlMkInJTJDJTIwJyVDNCVBMGInJTVE",highlighted:'[<span class="hljs-string">&#x27;def&#x27;</span>, <span class="hljs-string">&#x27;Ġadd&#x27;</span>, <span class="hljs-string">&#x27;_&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;umbers&#x27;</span>, <span class="hljs-string">&#x27;(&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;Ġb&#x27;</span>, <span class="hljs-string">&#x27;):&#x27;</span>, <span class="hljs-string">&#x27;Ċ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&quot;&quot;&quot;&#x27;</span>, <span class="hljs-string">&#x27;Add&#x27;</span>, <span class="hljs-string">&#x27;Ġthe&#x27;</span>, <span class="hljs-string">&#x27;Ġtwo&#x27;</span>,\n <span class="hljs-string">&#x27;Ġnumbers&#x27;</span>, <span class="hljs-string">&#x27;Ġ`&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;`&#x27;</span>, <span class="hljs-string">&#x27;Ġand&#x27;</span>, <span class="hljs-string">&#x27;Ġ`&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>, <span class="hljs-string">&#x27;`&#x27;</span>, <span class="hljs-string">&#x27;.&quot;&#x27;</span>, <span class="hljs-string">&#x27;&quot;&quot;&#x27;</span>, <span class="hljs-string">&#x27;Ċ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġreturn&#x27;</span>, <span class="hljs-string">&#x27;Ġa&#x27;</span>, <span class="hljs-string">&#x27;Ġ+&#x27;</span>, <span class="hljs-string">&#x27;Ġb&#x27;</span>]',wrap:!1}}),ae=new d({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwb2xkX3Rva2VuaXplci50cmFpbl9uZXdfZnJvbV9pdGVyYXRvcih0cmFpbmluZ19jb3JwdXMlMkMlMjA1MjAwMCk=",highlighted:'tokenizer = old_tokenizer.train_new_from_iterator(training_corpus, <span class="hljs-number">52000</span>)',wrap:!1}}),oe=new d({props:{code:"dG9rZW5zJTIwJTNEJTIwdG9rZW5pemVyLnRva2VuaXplKGV4YW1wbGUpJTBBdG9rZW5z",highlighted:`tokens = tokenizer.tokenize(example)
tokens`,wrap:!1}}),ce=new d({props:{code:"JTVCJ2RlZiclMkMlMjAnJUM0JUEwYWRkJyUyQyUyMCdfJyUyQyUyMCdudW1iZXJzJyUyQyUyMCcoJyUyQyUyMCdhJyUyQyUyMCclMkMnJTJDJTIwJyVDNCVBMGInJTJDJTIwJyklM0EnJTJDJTIwJyVDNCU4QSVDNCVBMCVDNCVBMCVDNCVBMCclMkMlMjAnJUM0JUEwJTIyJTIyJTIyJyUyQyUyMCdBZGQnJTJDJTIwJyVDNCVBMHRoZSclMkMlMjAnJUM0JUEwdHdvJyUyQyUyMCclQzQlQTBudW1iZXJzJyUyQyUyMCclQzQlQTAlNjAnJTJDJTBBJTIwJ2EnJTJDJTIwJyU2MCclMkMlMjAnJUM0JUEwYW5kJyUyQyUyMCclQzQlQTAlNjAnJTJDJTIwJ2InJTJDJTIwJyU2MC4lMjIlMjIlMjInJTJDJTIwJyVDNCU4QSVDNCVBMCVDNCVBMCVDNCVBMCclMkMlMjAnJUM0JUEwcmV0dXJuJyUyQyUyMCclQzQlQTBhJyUyQyUyMCclQzQlQTAlMkInJTJDJTIwJyVDNCVBMGInJTVE",highlighted:'[<span class="hljs-string">&#x27;def&#x27;</span>, <span class="hljs-string">&#x27;Ġadd&#x27;</span>, <span class="hljs-string">&#x27;_&#x27;</span>, <span class="hljs-string">&#x27;numbers&#x27;</span>, <span class="hljs-string">&#x27;(&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;Ġb&#x27;</span>, <span class="hljs-string">&#x27;):&#x27;</span>, <span class="hljs-string">&#x27;ĊĠĠĠ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&quot;&quot;&quot;&#x27;</span>, <span class="hljs-string">&#x27;Add&#x27;</span>, <span class="hljs-string">&#x27;Ġthe&#x27;</span>, <span class="hljs-string">&#x27;Ġtwo&#x27;</span>, <span class="hljs-string">&#x27;Ġnumbers&#x27;</span>, <span class="hljs-string">&#x27;Ġ`&#x27;</span>,\n <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;`&#x27;</span>, <span class="hljs-string">&#x27;Ġand&#x27;</span>, <span class="hljs-string">&#x27;Ġ`&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>, <span class="hljs-string">&#x27;`.&quot;&quot;&quot;&#x27;</span>, <span class="hljs-string">&#x27;ĊĠĠĠ&#x27;</span>, <span class="hljs-string">&#x27;Ġreturn&#x27;</span>, <span class="hljs-string">&#x27;Ġa&#x27;</span>, <span class="hljs-string">&#x27;Ġ+&#x27;</span>, <span class="hljs-string">&#x27;Ġb&#x27;</span>]',wrap:!1}}),Me=new d({props:{code:"cHJpbnQobGVuKHRva2VucykpJTBBcHJpbnQobGVuKG9sZF90b2tlbml6ZXIudG9rZW5pemUoZXhhbXBsZSkpKQ==",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-built_in">len</span>(tokens))
<span class="hljs-built_in">print</span>(<span class="hljs-built_in">len</span>(old_tokenizer.tokenize(example)))`,wrap:!1}}),Je=new d({props:{code:"MjclMEEzNg==",highlighted:`<span class="hljs-number">27</span>
<span class="hljs-number">36</span>`,wrap:!1}}),ye=new d({props:{code:"ZXhhbXBsZSUyMCUzRCUyMCUyMiUyMiUyMmNsYXNzJTIwTGluZWFyTGF5ZXIoKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBpbnB1dF9zaXplJTJDJTIwb3V0cHV0X3NpemUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi53ZWlnaHQlMjAlM0QlMjB0b3JjaC5yYW5kbihpbnB1dF9zaXplJTJDJTIwb3V0cHV0X3NpemUpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5iaWFzJTIwJTNEJTIwdG9yY2guemVyb3Mob3V0cHV0X3NpemUpJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19jYWxsX18oc2VsZiUyQyUyMHgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIweCUyMCU0MCUyMHNlbGYud2VpZ2h0cyUyMCUyQiUyMHNlbGYuYmlhcyUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQXRva2VuaXplci50b2tlbml6ZShleGFtcGxlKQ==",highlighted:`example = <span class="hljs-string">&quot;&quot;&quot;class LinearLayer():
    def __init__(self, input_size, output_size):
        self.weight = torch.randn(input_size, output_size)
        self.bias = torch.zeros(output_size)

    def __call__(self, x):
        return x @ self.weights + self.bias
    &quot;&quot;&quot;</span>
tokenizer.tokenize(example)`,wrap:!1}}),je=new d({props:{code:"JTVCJ2NsYXNzJyUyQyUyMCclQzQlQTBMaW5lYXInJTJDJTIwJ0xheWVyJyUyQyUyMCcoKSUzQSclMkMlMjAnJUM0JThBJUM0JUEwJUM0JUEwJUM0JUEwJyUyQyUyMCclQzQlQTBkZWYnJTJDJTIwJyVDNCVBMF9fJyUyQyUyMCdpbml0JyUyQyUyMCdfXygnJTJDJTIwJ3NlbGYnJTJDJTIwJyUyQyclMkMlMjAnJUM0JUEwaW5wdXQnJTJDJTIwJ18nJTJDJTIwJ3NpemUnJTJDJTIwJyUyQyclMkMlMEElMjAnJUM0JUEwb3V0cHV0JyUyQyUyMCdfJyUyQyUyMCdzaXplJyUyQyUyMCcpJTNBJyUyQyUyMCclQzQlOEElQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAnJTJDJTIwJyVDNCVBMHNlbGYnJTJDJTIwJy4nJTJDJTIwJ3dlaWdodCclMkMlMjAnJUM0JUEwJTNEJyUyQyUyMCclQzQlQTB0b3JjaCclMkMlMjAnLiclMkMlMjAncmFuZG4nJTJDJTIwJygnJTJDJTIwJ2lucHV0JyUyQyUyMCdfJyUyQyUwQSUyMCdzaXplJyUyQyUyMCclMkMnJTJDJTIwJyVDNCVBMG91dHB1dCclMkMlMjAnXyclMkMlMjAnc2l6ZSclMkMlMjAnKSclMkMlMjAnJUM0JThBJUM0JUEwJUM0JUEwJUM0JUEwJUM0JUEwJUM0JUEwJUM0JUEwJUM0JUEwJyUyQyUyMCclQzQlQTBzZWxmJyUyQyUyMCcuJyUyQyUyMCdiaWFzJyUyQyUyMCclQzQlQTAlM0QnJTJDJTIwJyVDNCVBMHRvcmNoJyUyQyUyMCcuJyUyQyUyMCd6ZXJvcyclMkMlMjAnKCclMkMlMEElMjAnb3V0cHV0JyUyQyUyMCdfJyUyQyUyMCdzaXplJyUyQyUyMCcpJyUyQyUyMCclQzQlOEElQzQlOEElQzQlQTAlQzQlQTAlQzQlQTAnJTJDJTIwJyVDNCVBMGRlZiclMkMlMjAnJUM0JUEwX18nJTJDJTIwJ2NhbGwnJTJDJTIwJ19fKCclMkMlMjAnc2VsZiclMkMlMjAnJTJDJyUyQyUyMCclQzQlQTB4JyUyQyUyMCcpJTNBJyUyQyUyMCclQzQlOEElQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAnJTJDJTBBJTIwJyVDNCVBMHJldHVybiclMkMlMjAnJUM0JUEweCclMkMlMjAnJUM0JUEwJTQwJyUyQyUyMCclQzQlQTBzZWxmJyUyQyUyMCcuJyUyQyUyMCd3ZWlnaHRzJyUyQyUyMCclQzQlQTAlMkInJTJDJTIwJyVDNCVBMHNlbGYnJTJDJTIwJy4nJTJDJTIwJ2JpYXMnJTJDJTIwJyVDNCU4QSVDNCVBMCVDNCVBMCVDNCVBMCVDNCVBMCclNUQ=",highlighted:`[<span class="hljs-string">&#x27;class&#x27;</span>, <span class="hljs-string">&#x27;ĠLinear&#x27;</span>, <span class="hljs-string">&#x27;Layer&#x27;</span>, <span class="hljs-string">&#x27;():&#x27;</span>, <span class="hljs-string">&#x27;ĊĠĠĠ&#x27;</span>, <span class="hljs-string">&#x27;Ġdef&#x27;</span>, <span class="hljs-string">&#x27;Ġ__&#x27;</span>, <span class="hljs-string">&#x27;init&#x27;</span>, <span class="hljs-string">&#x27;__(&#x27;</span>, <span class="hljs-string">&#x27;self&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;Ġinput&#x27;</span>, <span class="hljs-string">&#x27;_&#x27;</span>, <span class="hljs-string">&#x27;size&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>,
 <span class="hljs-string">&#x27;Ġoutput&#x27;</span>, <span class="hljs-string">&#x27;_&#x27;</span>, <span class="hljs-string">&#x27;size&#x27;</span>, <span class="hljs-string">&#x27;):&#x27;</span>, <span class="hljs-string">&#x27;ĊĠĠĠĠĠĠĠ&#x27;</span>, <span class="hljs-string">&#x27;Ġself&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;weight&#x27;</span>, <span class="hljs-string">&#x27;Ġ=&#x27;</span>, <span class="hljs-string">&#x27;Ġtorch&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;randn&#x27;</span>, <span class="hljs-string">&#x27;(&#x27;</span>, <span class="hljs-string">&#x27;input&#x27;</span>, <span class="hljs-string">&#x27;_&#x27;</span>,
 <span class="hljs-string">&#x27;size&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;Ġoutput&#x27;</span>, <span class="hljs-string">&#x27;_&#x27;</span>, <span class="hljs-string">&#x27;size&#x27;</span>, <span class="hljs-string">&#x27;)&#x27;</span>, <span class="hljs-string">&#x27;ĊĠĠĠĠĠĠĠ&#x27;</span>, <span class="hljs-string">&#x27;Ġself&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;bias&#x27;</span>, <span class="hljs-string">&#x27;Ġ=&#x27;</span>, <span class="hljs-string">&#x27;Ġtorch&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;zeros&#x27;</span>, <span class="hljs-string">&#x27;(&#x27;</span>,
 <span class="hljs-string">&#x27;output&#x27;</span>, <span class="hljs-string">&#x27;_&#x27;</span>, <span class="hljs-string">&#x27;size&#x27;</span>, <span class="hljs-string">&#x27;)&#x27;</span>, <span class="hljs-string">&#x27;ĊĊĠĠĠ&#x27;</span>, <span class="hljs-string">&#x27;Ġdef&#x27;</span>, <span class="hljs-string">&#x27;Ġ__&#x27;</span>, <span class="hljs-string">&#x27;call&#x27;</span>, <span class="hljs-string">&#x27;__(&#x27;</span>, <span class="hljs-string">&#x27;self&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;Ġx&#x27;</span>, <span class="hljs-string">&#x27;):&#x27;</span>, <span class="hljs-string">&#x27;ĊĠĠĠĠĠĠĠ&#x27;</span>,
 <span class="hljs-string">&#x27;Ġreturn&#x27;</span>, <span class="hljs-string">&#x27;Ġx&#x27;</span>, <span class="hljs-string">&#x27;Ġ@&#x27;</span>, <span class="hljs-string">&#x27;Ġself&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;weights&#x27;</span>, <span class="hljs-string">&#x27;Ġ+&#x27;</span>, <span class="hljs-string">&#x27;Ġself&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;bias&#x27;</span>, <span class="hljs-string">&#x27;ĊĠĠĠĠ&#x27;</span>]`,wrap:!1}}),Te=new Ls({props:{title:"Sauvegarde du <i> tokenizer </i>",local:"sauvegarde-du-i-tokenizer-i",headingTag:"h2"}}),fe=new d({props:{code:"dG9rZW5pemVyLnNhdmVfcHJldHJhaW5lZCglMjJjb2RlLXNlYXJjaC1uZXQtdG9rZW5pemVyJTIyKQ==",highlighted:'tokenizer.save_pretrained(<span class="hljs-string">&quot;code-search-net-tokenizer&quot;</span>)',wrap:!1}}),ge=new d({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),be=new d({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),Ce=new d({props:{code:"dG9rZW5pemVyLnB1c2hfdG9faHViKCUyMmNvZGUtc2VhcmNoLW5ldC10b2tlbml6ZXIlMjIp",highlighted:'tokenizer.push_to_hub(<span class="hljs-string">&quot;code-search-net-tokenizer&quot;</span>)',wrap:!1}}),Qe=new d({props:{code:"JTIzJTIwUmVtcGxhY2V6JTIwJTIyaHVnZ2luZ2ZhY2UtY291cnNlJTIyJTIwY2ktZGVzc291cyUyMHBhciUyMHZvdHJlJTIwZXNwYWNlJTIwciVDMyVBOWVsJTIwcG91ciUyMHV0aWxpc2VyJTIwdm90cmUlMjBwcm9wcmUlMjB0b2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJodWdnaW5nZmFjZS1jb3Vyc2UlMkZjb2RlLXNlYXJjaC1uZXQtdG9rZW5pemVyJTIyKQ==",highlighted:`<span class="hljs-comment"># Remplacez &quot;huggingface-course&quot; ci-dessous par votre espace réel pour utiliser votre propre tokenizer</span>
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;huggingface-course/code-search-net-tokenizer&quot;</span>)`,wrap:!1}}),Ie=new Wn({props:{source:"https://github.com/huggingface/course/blob/main/chapters/fr/chapter6/2.mdx"}}),{c(){y=i("meta"),T=l(),j=i("p"),ze=l(),p(x.$$.fragment),qe=l(),p(f.$$.fragment),Be=l(),U=i("p"),U.innerHTML=Ps,Ae=l(),p(g.$$.fragment),Ze=l(),p(h.$$.fragment),Xe=l(),p(w.$$.fragment),Ne=l(),b=i("p"),b.innerHTML=Fs,Ee=l(),v=i("p"),v.innerHTML=Ks,Ge=l(),p(C.$$.fragment),We=l(),$=i("p"),$.textContent=Os,He=l(),p(Q.$$.fragment),De=l(),p(k.$$.fragment),Re=l(),I=i("p"),I.innerHTML=en,Ye=l(),p(z.$$.fragment),Se=l(),V=i("p"),V.textContent=sn,Le=l(),p(_.$$.fragment),Pe=l(),q=i("p"),q.innerHTML=nn,Fe=l(),B=i("p"),B.textContent=tn,Ke=l(),p(A.$$.fragment),Oe=l(),Z=i("p"),Z.textContent=ln,es=l(),p(X.$$.fragment),ss=l(),N=i("p"),N.innerHTML=an,ns=l(),E=i("p"),E.textContent=rn,ts=l(),p(G.$$.fragment),ls=l(),W=i("p"),W.textContent=pn,as=l(),p(H.$$.fragment),is=l(),D=i("p"),D.textContent=un,rs=l(),p(R.$$.fragment),ps=l(),Y=i("p"),Y.innerHTML=on,us=l(),p(S.$$.fragment),os=l(),L=i("p"),L.textContent=cn,cs=l(),p(P.$$.fragment),ms=l(),F=i("p"),F.innerHTML=mn,Ms=l(),p(K.$$.fragment),Js=l(),O=i("p"),O.innerHTML=Mn,ds=l(),ee=i("p"),ee.innerHTML=Jn,ys=l(),p(se.$$.fragment),js=l(),p(ne.$$.fragment),hs=l(),te=i("p"),te.innerHTML=dn,Ts=l(),le=i("p"),le.innerHTML=yn,xs=l(),p(ae.$$.fragment),fs=l(),ie=i("p"),ie.textContent=jn,Us=l(),re=i("p"),re.innerHTML=hn,gs=l(),pe=i("p"),pe.innerHTML=Tn,ws=l(),ue=i("p"),ue.innerHTML=xn,bs=l(),p(oe.$$.fragment),vs=l(),p(ce.$$.fragment),Cs=l(),me=i("p"),me.innerHTML=fn,$s=l(),p(Me.$$.fragment),Qs=l(),p(Je.$$.fragment),ks=l(),de=i("p"),de.textContent=Un,Is=l(),p(ye.$$.fragment),zs=l(),p(je.$$.fragment),Vs=l(),he=i("p"),he.innerHTML=gn,_s=l(),p(Te.$$.fragment),qs=l(),xe=i("p"),xe.innerHTML=wn,Bs=l(),p(fe.$$.fragment),As=l(),Ue=i("p"),Ue.innerHTML=bn,Zs=l(),p(ge.$$.fragment),Xs=l(),we=i("p"),we.innerHTML=vn,Ns=l(),p(be.$$.fragment),Es=l(),ve=i("p"),ve.innerHTML=Cn,Gs=l(),p(Ce.$$.fragment),Ws=l(),$e=i("p"),$e.innerHTML=$n,Hs=l(),p(Qe.$$.fragment),Ds=l(),ke=i("p"),ke.innerHTML=Qn,Rs=l(),p(Ie.$$.fragment),Ys=l(),Ve=i("p"),this.h()},l(e){const s=Zn("svelte-u9bgzb",document.head);y=r(s,"META",{name:!0,content:!0}),s.forEach(n),T=a(e),j=r(e,"P",{}),In(j).forEach(n),ze=a(e),u(x.$$.fragment,e),qe=a(e),u(f.$$.fragment,e),Be=a(e),U=r(e,"P",{"data-svelte-h":!0}),J(U)!=="svelte-h6p3z9"&&(U.innerHTML=Ps),Ae=a(e),u(g.$$.fragment,e),Ze=a(e),u(h.$$.fragment,e),Xe=a(e),u(w.$$.fragment,e),Ne=a(e),b=r(e,"P",{"data-svelte-h":!0}),J(b)!=="svelte-3a8ahh"&&(b.innerHTML=Fs),Ee=a(e),v=r(e,"P",{"data-svelte-h":!0}),J(v)!=="svelte-1bb56lo"&&(v.innerHTML=Ks),Ge=a(e),u(C.$$.fragment,e),We=a(e),$=r(e,"P",{"data-svelte-h":!0}),J($)!=="svelte-1fp73ub"&&($.textContent=Os),He=a(e),u(Q.$$.fragment,e),De=a(e),u(k.$$.fragment,e),Re=a(e),I=r(e,"P",{"data-svelte-h":!0}),J(I)!=="svelte-qlite4"&&(I.innerHTML=en),Ye=a(e),u(z.$$.fragment,e),Se=a(e),V=r(e,"P",{"data-svelte-h":!0}),J(V)!=="svelte-5ljnps"&&(V.textContent=sn),Le=a(e),u(_.$$.fragment,e),Pe=a(e),q=r(e,"P",{"data-svelte-h":!0}),J(q)!=="svelte-1vx3fum"&&(q.innerHTML=nn),Fe=a(e),B=r(e,"P",{"data-svelte-h":!0}),J(B)!=="svelte-zpov33"&&(B.textContent=tn),Ke=a(e),u(A.$$.fragment,e),Oe=a(e),Z=r(e,"P",{"data-svelte-h":!0}),J(Z)!=="svelte-128wl1g"&&(Z.textContent=ln),es=a(e),u(X.$$.fragment,e),ss=a(e),N=r(e,"P",{"data-svelte-h":!0}),J(N)!=="svelte-akpd54"&&(N.innerHTML=an),ns=a(e),E=r(e,"P",{"data-svelte-h":!0}),J(E)!=="svelte-128xrzf"&&(E.textContent=rn),ts=a(e),u(G.$$.fragment,e),ls=a(e),W=r(e,"P",{"data-svelte-h":!0}),J(W)!=="svelte-17tsik7"&&(W.textContent=pn),as=a(e),u(H.$$.fragment,e),is=a(e),D=r(e,"P",{"data-svelte-h":!0}),J(D)!=="svelte-vat3n0"&&(D.textContent=un),rs=a(e),u(R.$$.fragment,e),ps=a(e),Y=r(e,"P",{"data-svelte-h":!0}),J(Y)!=="svelte-1yy0u8j"&&(Y.innerHTML=on),us=a(e),u(S.$$.fragment,e),os=a(e),L=r(e,"P",{"data-svelte-h":!0}),J(L)!=="svelte-k8aiy2"&&(L.textContent=cn),cs=a(e),u(P.$$.fragment,e),ms=a(e),F=r(e,"P",{"data-svelte-h":!0}),J(F)!=="svelte-1qktmfg"&&(F.innerHTML=mn),Ms=a(e),u(K.$$.fragment,e),Js=a(e),O=r(e,"P",{"data-svelte-h":!0}),J(O)!=="svelte-ck2ga4"&&(O.innerHTML=Mn),ds=a(e),ee=r(e,"P",{"data-svelte-h":!0}),J(ee)!=="svelte-4abjsh"&&(ee.innerHTML=Jn),ys=a(e),u(se.$$.fragment,e),js=a(e),u(ne.$$.fragment,e),hs=a(e),te=r(e,"P",{"data-svelte-h":!0}),J(te)!=="svelte-88e5us"&&(te.innerHTML=dn),Ts=a(e),le=r(e,"P",{"data-svelte-h":!0}),J(le)!=="svelte-1179w4l"&&(le.innerHTML=yn),xs=a(e),u(ae.$$.fragment,e),fs=a(e),ie=r(e,"P",{"data-svelte-h":!0}),J(ie)!=="svelte-kor19t"&&(ie.textContent=jn),Us=a(e),re=r(e,"P",{"data-svelte-h":!0}),J(re)!=="svelte-139x0nq"&&(re.innerHTML=hn),gs=a(e),pe=r(e,"P",{"data-svelte-h":!0}),J(pe)!=="svelte-1hv5grb"&&(pe.innerHTML=Tn),ws=a(e),ue=r(e,"P",{"data-svelte-h":!0}),J(ue)!=="svelte-1qq2t5z"&&(ue.innerHTML=xn),bs=a(e),u(oe.$$.fragment,e),vs=a(e),u(ce.$$.fragment,e),Cs=a(e),me=r(e,"P",{"data-svelte-h":!0}),J(me)!=="svelte-1stp3zo"&&(me.innerHTML=fn),$s=a(e),u(Me.$$.fragment,e),Qs=a(e),u(Je.$$.fragment,e),ks=a(e),de=r(e,"P",{"data-svelte-h":!0}),J(de)!=="svelte-wslgg9"&&(de.textContent=Un),Is=a(e),u(ye.$$.fragment,e),zs=a(e),u(je.$$.fragment,e),Vs=a(e),he=r(e,"P",{"data-svelte-h":!0}),J(he)!=="svelte-eqlvs6"&&(he.innerHTML=gn),_s=a(e),u(Te.$$.fragment,e),qs=a(e),xe=r(e,"P",{"data-svelte-h":!0}),J(xe)!=="svelte-1hhex8"&&(xe.innerHTML=wn),Bs=a(e),u(fe.$$.fragment,e),As=a(e),Ue=r(e,"P",{"data-svelte-h":!0}),J(Ue)!=="svelte-1pu5z8g"&&(Ue.innerHTML=bn),Zs=a(e),u(ge.$$.fragment,e),Xs=a(e),we=r(e,"P",{"data-svelte-h":!0}),J(we)!=="svelte-brnmsg"&&(we.innerHTML=vn),Ns=a(e),u(be.$$.fragment,e),Es=a(e),ve=r(e,"P",{"data-svelte-h":!0}),J(ve)!=="svelte-vzsbv1"&&(ve.innerHTML=Cn),Gs=a(e),u(Ce.$$.fragment,e),Ws=a(e),$e=r(e,"P",{"data-svelte-h":!0}),J($e)!=="svelte-14y6ub0"&&($e.innerHTML=$n),Hs=a(e),u(Qe.$$.fragment,e),Ds=a(e),ke=r(e,"P",{"data-svelte-h":!0}),J(ke)!=="svelte-oen3da"&&(ke.innerHTML=Qn),Rs=a(e),u(Ie.$$.fragment,e),Ys=a(e),Ve=r(e,"P",{}),In(Ve).forEach(n),this.h()},h(){zn(y,"name","hf:doc:metadata"),zn(y,"content",Rn)},m(e,s){Xn(document.head,y),t(e,T,s),t(e,j,s),t(e,ze,s),o(x,e,s),t(e,qe,s),o(f,e,s),t(e,Be,s),t(e,U,s),t(e,Ae,s),o(g,e,s),t(e,Ze,s),o(h,e,s),t(e,Xe,s),o(w,e,s),t(e,Ne,s),t(e,b,s),t(e,Ee,s),t(e,v,s),t(e,Ge,s),o(C,e,s),t(e,We,s),t(e,$,s),t(e,He,s),o(Q,e,s),t(e,De,s),o(k,e,s),t(e,Re,s),t(e,I,s),t(e,Ye,s),o(z,e,s),t(e,Se,s),t(e,V,s),t(e,Le,s),o(_,e,s),t(e,Pe,s),t(e,q,s),t(e,Fe,s),t(e,B,s),t(e,Ke,s),o(A,e,s),t(e,Oe,s),t(e,Z,s),t(e,es,s),o(X,e,s),t(e,ss,s),t(e,N,s),t(e,ns,s),t(e,E,s),t(e,ts,s),o(G,e,s),t(e,ls,s),t(e,W,s),t(e,as,s),o(H,e,s),t(e,is,s),t(e,D,s),t(e,rs,s),o(R,e,s),t(e,ps,s),t(e,Y,s),t(e,us,s),o(S,e,s),t(e,os,s),t(e,L,s),t(e,cs,s),o(P,e,s),t(e,ms,s),t(e,F,s),t(e,Ms,s),o(K,e,s),t(e,Js,s),t(e,O,s),t(e,ds,s),t(e,ee,s),t(e,ys,s),o(se,e,s),t(e,js,s),o(ne,e,s),t(e,hs,s),t(e,te,s),t(e,Ts,s),t(e,le,s),t(e,xs,s),o(ae,e,s),t(e,fs,s),t(e,ie,s),t(e,Us,s),t(e,re,s),t(e,gs,s),t(e,pe,s),t(e,ws,s),t(e,ue,s),t(e,bs,s),o(oe,e,s),t(e,vs,s),o(ce,e,s),t(e,Cs,s),t(e,me,s),t(e,$s,s),o(Me,e,s),t(e,Qs,s),o(Je,e,s),t(e,ks,s),t(e,de,s),t(e,Is,s),o(ye,e,s),t(e,zs,s),o(je,e,s),t(e,Vs,s),t(e,he,s),t(e,_s,s),o(Te,e,s),t(e,qs,s),t(e,xe,s),t(e,Bs,s),o(fe,e,s),t(e,As,s),t(e,Ue,s),t(e,Zs,s),o(ge,e,s),t(e,Xs,s),t(e,we,s),t(e,Ns,s),o(be,e,s),t(e,Es,s),t(e,ve,s),t(e,Gs,s),o(Ce,e,s),t(e,Ws,s),t(e,$e,s),t(e,Hs,s),o(Qe,e,s),t(e,Ds,s),t(e,ke,s),t(e,Rs,s),o(Ie,e,s),t(e,Ys,s),t(e,Ve,s),Ss=!0},p(e,[s]){const kn={};s&2&&(kn.$$scope={dirty:s,ctx:e}),h.$set(kn)},i(e){Ss||(c(x.$$.fragment,e),c(f.$$.fragment,e),c(g.$$.fragment,e),c(h.$$.fragment,e),c(w.$$.fragment,e),c(C.$$.fragment,e),c(Q.$$.fragment,e),c(k.$$.fragment,e),c(z.$$.fragment,e),c(_.$$.fragment,e),c(A.$$.fragment,e),c(X.$$.fragment,e),c(G.$$.fragment,e),c(H.$$.fragment,e),c(R.$$.fragment,e),c(S.$$.fragment,e),c(P.$$.fragment,e),c(K.$$.fragment,e),c(se.$$.fragment,e),c(ne.$$.fragment,e),c(ae.$$.fragment,e),c(oe.$$.fragment,e),c(ce.$$.fragment,e),c(Me.$$.fragment,e),c(Je.$$.fragment,e),c(ye.$$.fragment,e),c(je.$$.fragment,e),c(Te.$$.fragment,e),c(fe.$$.fragment,e),c(ge.$$.fragment,e),c(be.$$.fragment,e),c(Ce.$$.fragment,e),c(Qe.$$.fragment,e),c(Ie.$$.fragment,e),Ss=!0)},o(e){m(x.$$.fragment,e),m(f.$$.fragment,e),m(g.$$.fragment,e),m(h.$$.fragment,e),m(w.$$.fragment,e),m(C.$$.fragment,e),m(Q.$$.fragment,e),m(k.$$.fragment,e),m(z.$$.fragment,e),m(_.$$.fragment,e),m(A.$$.fragment,e),m(X.$$.fragment,e),m(G.$$.fragment,e),m(H.$$.fragment,e),m(R.$$.fragment,e),m(S.$$.fragment,e),m(P.$$.fragment,e),m(K.$$.fragment,e),m(se.$$.fragment,e),m(ne.$$.fragment,e),m(ae.$$.fragment,e),m(oe.$$.fragment,e),m(ce.$$.fragment,e),m(Me.$$.fragment,e),m(Je.$$.fragment,e),m(ye.$$.fragment,e),m(je.$$.fragment,e),m(Te.$$.fragment,e),m(fe.$$.fragment,e),m(ge.$$.fragment,e),m(be.$$.fragment,e),m(Ce.$$.fragment,e),m(Qe.$$.fragment,e),m(Ie.$$.fragment,e),Ss=!1},d(e){e&&(n(T),n(j),n(ze),n(qe),n(Be),n(U),n(Ae),n(Ze),n(Xe),n(Ne),n(b),n(Ee),n(v),n(Ge),n(We),n($),n(He),n(De),n(Re),n(I),n(Ye),n(Se),n(V),n(Le),n(Pe),n(q),n(Fe),n(B),n(Ke),n(Oe),n(Z),n(es),n(ss),n(N),n(ns),n(E),n(ts),n(ls),n(W),n(as),n(is),n(D),n(rs),n(ps),n(Y),n(us),n(os),n(L),n(cs),n(ms),n(F),n(Ms),n(Js),n(O),n(ds),n(ee),n(ys),n(js),n(hs),n(te),n(Ts),n(le),n(xs),n(fs),n(ie),n(Us),n(re),n(gs),n(pe),n(ws),n(ue),n(bs),n(vs),n(Cs),n(me),n($s),n(Qs),n(ks),n(de),n(Is),n(zs),n(Vs),n(he),n(_s),n(qs),n(xe),n(Bs),n(As),n(Ue),n(Zs),n(Xs),n(we),n(Ns),n(Es),n(ve),n(Gs),n(Ws),n($e),n(Hs),n(Ds),n(ke),n(Rs),n(Ys),n(Ve)),n(y),M(x,e),M(f,e),M(g,e),M(h,e),M(w,e),M(C,e),M(Q,e),M(k,e),M(z,e),M(_,e),M(A,e),M(X,e),M(G,e),M(H,e),M(R,e),M(S,e),M(P,e),M(K,e),M(se,e),M(ne,e),M(ae,e),M(oe,e),M(ce,e),M(Me,e),M(Je,e),M(ye,e),M(je,e),M(Te,e),M(fe,e),M(ge,e),M(be,e),M(Ce,e),M(Qe,e),M(Ie,e)}}}const Rn='{"title":"Entraîner un nouveau <i> tokenizer </i> à partir d’un ancien","local":"entraîner-un-nouveau-i-tokenizer-i-à-partir-dun-ancien","sections":[{"title":"Assemblage d’un corpus","local":"assemblage-dun-corpus","sections":[],"depth":2},{"title":"Entraînement d’un nouveau <i> tokenizer </i>","local":"entraînement-dun-nouveau-i-tokenizer-i","sections":[],"depth":2},{"title":"Sauvegarde du <i> tokenizer </i>","local":"sauvegarde-du-i-tokenizer-i","sections":[],"depth":2}],"depth":1}';function Yn(_e){return _n(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class st extends Bn{constructor(y){super(),An(this,y,Yn,Dn,Vn,{})}}export{st as component};
