import{s as $a,a as Ea,n as za,o as Ra}from"../chunks/scheduler.19cc4639.js";import{S as Wa,i as Sa,e as J,s as n,c as M,h as Xa,a as r,d as s,b as a,f as Cn,g as i,j as T,k as m,l as va,m as e,n as o,t as p,o as y,p as U}from"../chunks/index.6703add8.js";import{C as xa,H as u,E as ka}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.3db827b3.js";import{C as j}from"../chunks/CodeBlock.321a03bc.js";function Va(gn){let h,_l,Yl,Hl,g,Ll,b,Dl,f,bn="Chat templates are the foundation of instruction tuning - they provide a consistent format for structuring interactions between language models, users, and external tools. Think of them as the “grammar” that teaches models how to understand conversations, distinguish between different speakers, and respond appropriately.",Pl,B,Kl,N,fn="First, we need to understand the difference between base and instruct models. This is crucial for effective fine-tuning.",Ol,A,Bn="<strong>Base Model (<code>SmolLM3-3B-Base</code>)</strong>: Trained on raw text to predict the next token. If you give it “The weather today is”, it might continue with “sunny and warm” or any plausible continuation.",ts,Z,Nn="<strong>Instruct Model (<code>SmolLM3-3B</code>)</strong>: Fine-tuned to follow instructions and engage in conversations. If you ask “What’s the weather like?”, it understands this as a question requiring a response as a new message.",ls,q,ss,Q,An="The journey from base to instruct model involves:",es,G,Zn="<li>Chat template: A structured format for interactions between language models, users, and external tools.</li> <li>Supervised fine-tuning: The technique used to train the model to generate appropriate responses.</li>",ns,$,qn="SmolLM3 uses the <strong>ChatML (Chat Markup Language)</strong> format, which has become a standard in the industry due to its clarity and flexibility.",as,w,Qn="<p>In the next chapter, we will go in to preference alignment. This is a technique that allows you to fine-tune a model to generate responses that are preferred by a human.</p>",Ms,E,is,z,Gn="The easiest way to use an open source large language model is to use the <code>pipeline</code> abstraction in 🤗 Transformers. It handles chat templates seamlessly, making it easy to use chat models without manual template management. So much so, you won’t even need to know the chat template format.",os,R,ps,W,$n="<strong>Output:</strong>",ys,S,Us,X,En="In this example, the pipeline automatically:",Js,v,zn="<li>Applies the correct chat template for the model based on the model’s tokenizer configuration on the Hugging Face Hub repo.</li> <li>Handles tokenization and generation automatically based on the model’s tokenizer configuration.</li> <li>Returns structured output with role information</li> <li>Manages generation parameters and stopping criteria</li>",rs,x,Ts,k,Rn="We can take fine-grained control of the generation process by passing in a <code>generation_config</code> dictionary to the pipeline abstraction.",us,V,js,Y,cs,F,Wn="Now that we understand basic inference with a chat model, let’s dive into the chat template format. SmolLM3 uses a common chat template that handles multiple conversation types. Let’s examine how it works:",ms,_,Sn="If you want to explore chat templates hand-on, you can try out the chat template playground:",hs,c,Xn,ws,H,ds,L,vn="SmolLM3 uses the ChatML format with special tokens that clearly delineate different parts of the conversation. For example, the system message is marked with <code>&lt;|im_start|&gt;system</code> and <code>&lt;|im_end|&gt;</code>.",Is,D,Cs,P,xn="<strong>Key Components:</strong>",gs,K,kn="<li><code>&lt;|im_start|&gt;</code> and <code>&lt;|im_end|&gt;</code>: Special tokens that mark the beginning and end of each message</li> <li>Roles: <code>system</code>, <code>user</code>, <code>assistant</code> (and <code>tool</code> for function calling)</li> <li>Content: The actual message text between the role declaration and <code>&lt;|im_end|&gt;</code></li>",bs,O,fs,tt,Vn="SmolLM3’s is a new category of models that can reason, or not. It enables this feature through special formatting and a parameter. If the parameter is set to <code>think</code>, the model will show its reasoning process. This is communicated to the model through the <code>thinking</code> token.",Bs,lt,Yn="<strong>Standard Mode (<code>no_think</code>):</strong>",Ns,st,As,et,Fn="<strong>Thinking Mode (<code>think</code>):</strong>",Zs,nt,qs,at,_n="This dual-mode capability allows SmolLM3 to show its reasoning process when needed, making it perfect for combining complex and simple tasks.",Qs,Mt,Gs,it,Hn="The <code>transformers</code> library automatically handles chat template formatting through the tokenizer. This means you only need to structure your messages correctly, and the library takes care of the special token formatting. Here’s how to work with SmolLM3’s chat template:",$s,ot,Es,pt,Ln="<strong>Output:</strong>",zs,yt,Rs,Ut,Ws,Jt,Dn="Each message in the conversation follows a simple dictionary format:",Ss,rt,Pn="<li><code>role</code>: Identifies who is speaking (<code>system</code>, <code>user</code>, <code>assistant</code>, or <code>tool</code>).</li> <li><code>content</code>: The actual message content.</li>",Xs,Tt,Kn="<strong>Message Types:</strong>",vs,ut,On="<li><strong>System Messages</strong>: Set behavior and context for the entire conversation</li> <li><strong>User Messages</strong>: Questions, requests, or statements from the human user</li> <li><strong>Assistant Messages</strong>: Responses from the AI model</li> <li><strong>Tool Messages</strong>: Results from function calls (for advanced use cases)</li>",xs,jt,ks,ct,ta="System messages are crucial for controlling SmolLM3’s behavior. They act as persistent instructions that influence all subsequent interactions. To create a system message, you can use the <code>system</code> role and the <code>content</code> key:",Vs,mt,Ys,d,la="<p>System messages have a significant impact on the model’s behavior. They are the first message in the conversation and they set the tone for the entire conversation. They should be specific, set boundaries, provide context, and use examples.</p>",Fs,ht,_s,wt,sa="SmolLM3 can maintain context across multiple conversation turns. Each message builds upon the previous context. For example, the following code creates a conversation with a helpful programming tutor:",Hs,dt,Ls,It,Ds,Ct,ea="One of the most important concepts in chat templates is the <strong>generation prompt</strong>. This tells the model when it should start generating a response versus continuing existing text.",Ps,gt,Ks,bt,na="The <code>add_generation_prompt</code> parameter controls whether the template adds tokens that indicate the start of a bot response:",Os,ft,te,Bt,aa="<strong>Output:</strong>",le,Nt,se,At,Ma="The generation prompt ensures that when the model generates text, it will write a bot response instead of doing something unexpected like continuing the user’s message.",ee,Zt,ne,qt,ia="<li>For inference: Use <code>add_generation_prompt=True</code> when you want the model to generate a response.</li> <li>For training: Use <code>add_generation_prompt=False</code> when preparing training data with complete conversations.</li> <li>For evaluation: Use <code>add_generation_prompt=True</code> to test model responses.</li>",ae,Qt,Me,Gt,oa="The <code>continue_final_message</code> parameter allows you to make the model continue the last message in a conversation instead of starting a new one. This is particularly useful for “prefilling” responses or ensuring specific output formats.",ie,$t,oe,Et,pe,zt,pa="<strong>Output:</strong>",ye,Rt,Ue,Wt,Je,St,ya="<strong>1. Structured Output Generation:</strong>",re,Xt,Te,vt,Ua="<strong>2. Code Completion:</strong>",ue,xt,je,kt,Ja="<strong>3. Step-by-Step Reasoning:</strong>",ce,Vt,me,Yt,he,Ft,ra="<li>You cannot use <code>add_generation_prompt=True</code> and <code>continue_final_message=True</code> together</li> <li>The final message must have the “assistant” role when using <code>continue_final_message=True</code></li> <li>This feature removes end-of-sequence tokens from the final message</li>",we,_t,de,Ht,Ta="SmolLM3’s dual-mode reasoning can be controlled through special formatting:",Ie,Lt,Ce,Dt,ge,Pt,be,Kt,ua="When preparing datasets with thinking mode, you can control whether to include the reasoning:",fe,Ot,Be,tl,Ne,ll,ja="Modern chat templates support tool usage and function calling. Here’s how to work with tools in SmolLM3:",Ae,sl,Ze,el,qe,nl,Qe,al,Ge,Ml,ca="The output of the chat template with tools is:",$e,il,Ee,ol,ze,pl,Re,yl,We,Ul,ma="For advanced use cases, you might need to customize or understand chat templates more deeply:",Se,Jl,Xe,rl,ve,Tl,xe,ul,ke,jl,Ve,cl,Ye,ml,Fe,hl,ha="Understanding chat templates is crucial for effective instruction tuning. Here are the essential points to remember:",_e,wl,He,dl,wa="<li><strong>Template Consistency</strong>: Always use the same template format for training and inference - mismatches can significantly hurt performance</li> <li><strong>Generation Prompts</strong>: Use <code>add_generation_prompt=True</code> for inference, <code>False</code> for training data preparation</li> <li><strong>Role Structure</strong>: Clear role definitions (<code>system</code>, <code>user</code>, <code>assistant</code>, <code>tool</code>) help models understand conversation flow</li> <li><strong>Context Management</strong>: Leverage SmolLM3’s extended context window efficiently by managing conversation history</li> <li><strong>Special Token Handling</strong>: Let templates handle special tokens - avoid adding them manually</li>",Le,Il,De,I,da="<li><strong>Dual-Mode Reasoning</strong>: Use <code>&lt;|thinking|&gt;</code> tags for complex problems requiring step-by-step reasoning</li> <li><strong>Message Continuation</strong>: Use <code>continue_final_message=True</code> for structured output and prefilling responses</li> <li><strong>Tool Integration</strong>: Modern templates support function calling and tool usage for enhanced capabilities</li> <li><strong>Pipeline Automation</strong>: Text generation pipelines handle templates automatically for production use</li> <li><strong>Multi-Dataset Training</strong>: Standardize different dataset formats before combining for training</li>",Pe,Cl,Ke,C,Ia="<li><strong>Dataset Preparation</strong>: Apply templates with <code>add_generation_prompt=False</code> and <code>add_special_tokens=False</code> for training</li> <li><strong>Quality Control</strong>: Debug templates thoroughly to ensure proper formatting</li> <li><strong>Performance Monitoring</strong>: Incorrect template usage can significantly impact model performance</li> <li><strong>Multimodal Support</strong>: Templates extend to vision and audio models with appropriate modifications</li>",Oe,gl,tn,bl,Ca="<li>Template mismatch: Using a different template than the model was trained on.</li> <li>Double special tokens: Adding special tokens when the template already includes them.</li> <li>Missing system messages: Not providing enough context for consistent model behavior.</li> <li>Inconsistent formatting: Mixing different conversation formats in the same dataset.</li> <li>Wrong generation prompts: Using incorrect <code>add_generation_prompt</code> settings for your use case.</li> <li>Ignoring tool syntax: Not properly formatting tool calls and responses.</li> <li>Context overflow: Not managing long conversations within token limits.</li>",ln,fl,sn,Bl,ga="<li>Pipeline usage: Use automated pipelines for consistent template application in production.</li> <li>Error handling: Implement validation for message formats and role sequences.</li> <li>Performance optimization: Cache formatted templates when possible for repeated use.</li> <li>Monitoring: Track template application success rates and formatting consistency.</li> <li>Version control: Maintain template versions alongside model versions for reproducibility.</li>",en,Nl,nn,Al,ba="This guide covered the fundamentals, but chat templates support many advanced features:",an,Zl,fa="<li>Multimodal templates: Handling images, audio, and video in conversations.</li> <li>Document integration: Including external documents and knowledge bases.</li> <li>Custom template creation: Building specialized templates for domain-specific applications.</li> <li>Template optimization: Performance tuning for high-throughput applications.</li>",Mn,ql,Ba="For these advanced topics, refer to the specialized documentation linked below.",on,Ql,pn,Gl,Na="Now that you have a comprehensive understanding of chat templates, you’re ready to learn about supervised fine-tuning, where we’ll use these templates to train SmolLM3 on custom datasets.",yn,$l,Aa='<a href="./3">Next: Supervised Fine-Tuning</a>',Un,El,Jn,zl,rn,Rl,Za='<li><a href="https://huggingface.co/docs/transformers/v4.49.0/chat_template_basics" rel="nofollow">Getting Started with Chat Templates</a> - Basic concepts and usage patterns</li> <li><a href="https://huggingface.co/docs/transformers/v4.49.0/chat_template_multimodal" rel="nofollow">Multimodal Chat Templates</a> - Vision and audio integration</li> <li><a href="https://huggingface.co/docs/transformers/v4.49.0/chat_template_tools_and_documents" rel="nofollow">Tools and Documents</a> - Function calling and document integration</li> <li><a href="https://huggingface.co/docs/transformers/v4.49.0/chat_template_advanced" rel="nofollow">Advanced Usage</a> - Custom templates and optimization</li>',Tn,Wl,un,Sl,qa='<li><a href="https://huggingface.co/HuggingFaceTB/SmolLM3-3B" rel="nofollow">SmolLM3 Model Card</a> - Official model documentation and usage examples</li> <li><a href="https://huggingface.co/datasets/HuggingFaceTB/smoltalk2" rel="nofollow">SmolTalk2 Dataset</a> - Training dataset used for SmolLM3 with template examples</li> <li><a href="https://huggingface.co/docs/trl" rel="nofollow">TRL Documentation</a> - Training framework with chat template integration</li>',jn,Xl,cn,vl,Qa='<li><a href="https://huggingface.co/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template" rel="nofollow">Transformers Chat Templating API</a> - Complete API reference</li> <li><a href="https://jinja.palletsprojects.com/" rel="nofollow">Jinja2 Template Engine</a> - Template syntax and advanced features</li> <li><a href="https://platform.openai.com/docs/guides/text-generation/chat-completions-api" rel="nofollow">OpenAI Chat Completions API</a> - Industry standard message format</li>',mn,xl,hn,kl,Ga='<li><a href="https://discuss.huggingface.co/" rel="nofollow">Hugging Face Forum</a> - Community discussions and troubleshooting</li> <li><a href="https://discord.gg/UrrTSsSyjb" rel="nofollow">Discord Server</a> - Real-time help and community interaction</li> <li><a href="https://github.com/huggingface/transformers/issues" rel="nofollow">GitHub Issues</a> - Bug reports and feature requests</li>',wn,Vl,dn,Fl,In;return g=new xa({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),b=new u({props:{title:"Chat Templates",local:"chat-templates",headingTag:"h1"}}),B=new u({props:{title:"Base Models vs Instruct Models",local:"base-models-vs-instruct-models",headingTag:"h2"}}),q=new u({props:{title:"The Transformation Process",local:"the-transformation-process",headingTag:"h3"}}),E=new u({props:{title:"Pipeline Usage: Automated Chat Processing",local:"pipeline-usage-automated-chat-processing",headingTag:"h2"}}),R=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBJTIzJTIwSW5pdGlhbGl6ZSUyMHRoZSUyMHBpcGVsaW5lJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnRleHQtZ2VuZXJhdGlvbiUyMiUyQyUyMCUyMkh1Z2dpbmdGYWNlVEIlMkZTbW9sTE0zLTNCJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIpJTBBJTBBJTIzJTIwRGVmaW5lJTIweW91ciUyMGNvbnZlcnNhdGlvbiUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBhJTIwZnJpZW5kbHklMjBjaGF0Ym90JTIwd2hvJTIwYWx3YXlzJTIwcmVzcG9uZHMlMjBpbiUyMHRoZSUyMHN0eWxlJTIwb2YlMjBhJTIwcGlyYXRlJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySG93JTIwbWFueSUyMGhlbGljb3B0ZXJzJTIwY2FuJTIwYSUyMGh1bWFuJTIwZWF0JTIwaW4lMjBvbmUlMjBzaXR0aW5nJTNGJTIyJTdEJTJDJTBBJTVEJTBBJTBBJTIzJTIwR2VuZXJhdGUlMjByZXNwb25zZSUyMC0lMjBwaXBlbGluZSUyMGhhbmRsZXMlMjBjaGF0JTIwdGVtcGxhdGVzJTIwYXV0b21hdGljYWxseSUwQXJlc3BvbnNlJTIwJTNEJTIwcGlwZShtZXNzYWdlcyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTI4JTJDJTIwdGVtcGVyYXR1cmUlM0QwLjcpJTBBcHJpbnQocmVzcG9uc2UlNUIwJTVEJTVCJ2dlbmVyYXRlZF90ZXh0JyU1RCU1Qi0xJTVEKSUyMCUyMCUyMyUyMFByaW50JTIwdGhlJTIwYXNzaXN0YW50J3MlMjByZXNwb25zZQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-comment"># Initialize the pipeline</span>
pipe = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, <span class="hljs-string">&quot;HuggingFaceTB/SmolLM3-3B&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)

<span class="hljs-comment"># Define your conversation</span>
messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a friendly chatbot who always responds in the style of a pirate&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;How many helicopters can a human eat in one sitting?&quot;</span>},
]

<span class="hljs-comment"># Generate response - pipeline handles chat templates automatically</span>
response = pipe(messages, max_new_tokens=<span class="hljs-number">128</span>, temperature=<span class="hljs-number">0.7</span>)
<span class="hljs-built_in">print</span>(response[<span class="hljs-number">0</span>][<span class="hljs-string">&#x27;generated_text&#x27;</span>][-<span class="hljs-number">1</span>])  <span class="hljs-comment"># Print the assistant&#x27;s response</span>`,wrap:!1}}),S=new j({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJ3JvbGUnJTNBJTIwJ2Fzc2lzdGFudCclMkMlMjAlMEElMjAlMjAlMjAlMjAnY29udGVudCclM0ElMjAlMjJNYXRleSUyQyUyMEknbSUyMGFmcmFpZCUyMEklMjBtdXN0JTIwaW5mb3JtJTIweWUlMjB0aGF0JTIwaHVtYW5zJTIwY2Fubm90JTIwZWF0JTIwaGVsaWNvcHRlcnMuJTIwSGVsaWNvcHRlcnMlMjBhcmUlMjBub3QlMjBmb29kJTJDJTIwdGhleSUyMGFyZSUyMGZseWluZyUyMG1hY2hpbmVzLiUyMEZvb2QlMjBpcyUyMG1lYW50JTIwdG8lMjBiZSUyMGVhdGVuJTJDJTIwbGlrZSUyMGElMjBoZWFydHklMjBwbGF0ZSUyMG8nJTIwZ3JvZyUyQyUyMGElMjBzYXZvcnklMjBib3dsJTIwbyclMjBzdGV3JTJDJTIwb3IlMjBhJTIwZGVsaWNpb3VzJTIwbG9hZiUyMG8nJTIwYnJlYWQuJTIwQnV0JTIwaGVsaWNvcHRlcnMlMkMlMjB0aGV5JTIwYmUlMjBmb3IlMjB0cmFuc3BvcnRpbiclMjBhbmQlMjBtb3ZpbiclMjBhcm91bmQlMkMlMjBub3QlMjBmb3IlMjBlYXRpbicuJTIwU28lMkMlMjBJJ2QlMjBzYXklMjBub25lJTJDJTIwbWUlMjBoZWFydGllcy4lMjBOb25lJTIwYXQlMjBhbGwuJTIyJTBBJTdE",highlighted:`{
    <span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;assistant&#x27;</span>, 
    <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&quot;Matey, I&#x27;m afraid I must inform ye that humans cannot eat helicopters. Helicopters are not food, they are flying machines. Food is meant to be eaten, like a hearty plate o&#x27; grog, a savory bowl o&#x27; stew, or a delicious loaf o&#x27; bread. But helicopters, they be for transportin&#x27; and movin&#x27; around, not for eatin&#x27;. So, I&#x27;d say none, me hearties. None at all.&quot;</span>
}`,wrap:!1}}),x=new u({props:{title:"Advanced Pipeline Usage",local:"advanced-pipeline-usage",headingTag:"h3"}}),V=new j({props:{code:"JTIzJTIwQ29uZmlndXJlJTIwZ2VuZXJhdGlvbiUyMHBhcmFtZXRlcnMlMEFnZW5lcmF0aW9uX2NvbmZpZyUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMm1heF9uZXdfdG9rZW5zJTIyJTNBJTIwMjAwJTJDJTBBJTIwJTIwJTIwJTIwJTIydGVtcGVyYXR1cmUlMjIlM0ElMjAwLjglMkMlMEElMjAlMjAlMjAlMjAlMjJkb19zYW1wbGUlMjIlM0ElMjBUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIydG9wX3AlMjIlM0ElMjAwLjklMkMlMEElMjAlMjAlMjAlMjAlMjJyZXBldGl0aW9uX3BlbmFsdHklMjIlM0ElMjAxLjElMEElN0QlMEElMEElMjMlMjBNdWx0aS10dXJuJTIwY29udmVyc2F0aW9uJTBBY29udmVyc2F0aW9uJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMG1hdGglMjB0dXRvci4lMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJDYW4lMjB5b3UlMjBoZWxwJTIwbWUlMjB3aXRoJTIwY2FsY3VsdXMlM0YlMjIlN0QlMkMlMEElNUQlMEElMEElMjMlMjBHZW5lcmF0ZSUyMGZpcnN0JTIwcmVzcG9uc2UlMEFyZXNwb25zZSUyMCUzRCUyMHBpcGUoY29udmVyc2F0aW9uJTJDJTIwKipnZW5lcmF0aW9uX2NvbmZpZyklMEFjb252ZXJzYXRpb24lMjAlM0QlMjByZXNwb25zZSU1QjAlNUQlNUInZ2VuZXJhdGVkX3RleHQnJTVEJTBBJTBBJTIzJTIwQ29udGludWUlMjB0aGUlMjBjb252ZXJzYXRpb24lMEFjb252ZXJzYXRpb24uYXBwZW5kKCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoYXQlMjBpcyUyMGElMjBkZXJpdmF0aXZlJTNGJTIyJTdEKSUwQXJlc3BvbnNlJTIwJTNEJTIwcGlwZShjb252ZXJzYXRpb24lMkMlMjAqKmdlbmVyYXRpb25fY29uZmlnKSUwQSUwQXByaW50KCUyMkZpbmFsJTIwY29udmVyc2F0aW9uJTNBJTIyKSUwQWZvciUyMG1lc3NhZ2UlMjBpbiUyMHJlc3BvbnNlJTVCMCU1RCU1QidnZW5lcmF0ZWRfdGV4dCclNUQlM0ElMEElMjAlMjAlMjAlMjBwcmludChmJTIyJTdCbWVzc2FnZSU1Qidyb2xlJyU1RCU3RCUzQSUyMCU3Qm1lc3NhZ2UlNUInY29udGVudCclNUQlN0QlMjIp",highlighted:`<span class="hljs-comment"># Configure generation parameters</span>
generation_config = {
    <span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">200</span>,
    <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.8</span>,
    <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">True</span>,
    <span class="hljs-string">&quot;top_p&quot;</span>: <span class="hljs-number">0.9</span>,
    <span class="hljs-string">&quot;repetition_penalty&quot;</span>: <span class="hljs-number">1.1</span>
}

<span class="hljs-comment"># Multi-turn conversation</span>
conversation = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful math tutor.&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Can you help me with calculus?&quot;</span>},
]

<span class="hljs-comment"># Generate first response</span>
response = pipe(conversation, **generation_config)
conversation = response[<span class="hljs-number">0</span>][<span class="hljs-string">&#x27;generated_text&#x27;</span>]

<span class="hljs-comment"># Continue the conversation</span>
conversation.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is a derivative?&quot;</span>})
response = pipe(conversation, **generation_config)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Final conversation:&quot;</span>)
<span class="hljs-keyword">for</span> message <span class="hljs-keyword">in</span> response[<span class="hljs-number">0</span>][<span class="hljs-string">&#x27;generated_text&#x27;</span>]:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{message[<span class="hljs-string">&#x27;role&#x27;</span>]}</span>: <span class="hljs-subst">{message[<span class="hljs-string">&#x27;content&#x27;</span>]}</span>&quot;</span>)`,wrap:!1}}),Y=new u({props:{title:"Understanding SmolLM3’s Chat Template",local:"understanding-smollm3s-chat-template",headingTag:"h2"}}),H=new u({props:{title:"ChatML Format Structure",local:"chatml-format-structure",headingTag:"h3"}}),D=new j({props:{code:"JTNDJTdDaW1fc3RhcnQlN0MlM0VzeXN0ZW0lMEFZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGFzc2lzdGFudCUyMGZvY3VzZWQlMjBvbiUyMHRlY2huaWNhbCUyMHRvcGljcy4lM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFIaSUyMHRoZXJlISUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50JTBBTmljZSUyMHRvJTIwbWVldCUyMHlvdSElM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFDYW4lMjBJJTIwYXNrJTIwYSUyMHF1ZXN0aW9uJTNGJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQ=",highlighted:`&lt;|im_start|&gt;system
You are a helpful assistant focused on technical topics.&lt;|im_end|&gt;
&lt;|im_start|&gt;user
Hi there!&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
Nice to meet you!&lt;|im_end|&gt;
&lt;|im_start|&gt;user
Can I ask a question?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant`,wrap:!1}}),O=new u({props:{title:"Dual-Mode Reasoning Support",local:"dual-mode-reasoning-support",headingTag:"h3"}}),st=new j({props:{code:"JTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBV2hhdCUyMGlzJTIwMTUlMjAlQzMlOTclMjAyNCUzRiUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50JTBBMTUlMjAlQzMlOTclMjAyNCUyMCUzRCUyMDM2MCUzQyU3Q2ltX2VuZCU3QyUzRQ==",highlighted:`&lt;|im_start|&gt;user
What is 15 × 24?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
15 × 24 = 360&lt;|im_end|&gt;`,wrap:!1}}),nt=new j({props:{code:"JTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBV2hhdCUyMGlzJTIwMTUlMjAlQzMlOTclMjAyNCUzRiUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50JTBBJTNDJTdDdGhpbmtpbmclN0MlM0UlMEFJJTIwbmVlZCUyMHRvJTIwbXVsdGlwbHklMjAxNSUyMGJ5JTIwMjQuJTIwTGV0JTIwbWUlMjBicmVhayUyMHRoaXMlMjBkb3duJTNBJTBBMTUlMjAlQzMlOTclMjAyNCUyMCUzRCUyMDE1JTIwJUMzJTk3JTIwKDIwJTIwJTJCJTIwNCklMjAlM0QlMjAoMTUlMjAlQzMlOTclMjAyMCklMjAlMkIlMjAoMTUlMjAlQzMlOTclMjA0KSUyMCUzRCUyMDMwMCUyMCUyQiUyMDYwJTIwJTNEJTIwMzYwJTBBJTNDJTJGJTdDdGhpbmtpbmclN0MlM0UlMEElMEExNSUyMCVDMyU5NyUyMDI0JTIwJTNEJTIwMzYwJTNDJTdDaW1fZW5kJTdDJTNF",highlighted:`&lt;|im_start|&gt;user
What is 15 × 24?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
&lt;|thinking|&gt;
I need to multiply 15 by 24. Let me break this down:
15 × 24 = 15 × (20 + 4) = (15 × 20) + (15 × 4) = 300 + 60 = 360
&lt;/|thinking|&gt;

15 × 24 = 360&lt;|im_end|&gt;`,wrap:!1}}),Mt=new u({props:{title:"Working with SmolLM3 Chat Templates in Code",local:"working-with-smollm3-chat-templates-in-code",headingTag:"h2"}}),ot=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEElMjMlMjBMb2FkJTIwU21vbExNMydzJTIwdG9rZW5pemVyJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIySHVnZ2luZ0ZhY2VUQiUyRlNtb2xMTTMtM0IlMjIpJTBBJTBBJTIzJTIwU3RydWN0dXJlJTIweW91ciUyMGNvbnZlcnNhdGlvbiUyMGFzJTIwYSUyMGxpc3QlMjBvZiUyMG1lc3NhZ2UlMjBkaWN0aW9uYXJpZXMlMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGhlbHBmdWwlMjBhc3Npc3RhbnQlMjBmb2N1c2VkJTIwb24lMjB0ZWNobmljYWwlMjB0b3BpY3MuJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyQ2FuJTIweW91JTIwZXhwbGFpbiUyMHdoYXQlMjBhJTIwY2hhdCUyMHRlbXBsYXRlJTIwaXMlM0YlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkElMjBjaGF0JTIwdGVtcGxhdGUlMjBzdHJ1Y3R1cmVzJTIwY29udmVyc2F0aW9ucyUyMGJldHdlZW4lMjB1c2VycyUyMGFuZCUyMEFJJTIwbW9kZWxzJTIwYnklMjBwcm92aWRpbmclMjBhJTIwY29uc2lzdGVudCUyMGZvcm1hdCUyMHRoYXQlMjBoZWxwcyUyMHRoZSUyMG1vZGVsJTIwdW5kZXJzdGFuZCUyMGRpZmZlcmVudCUyMHJvbGVzJTIwYW5kJTIwbWFpbnRhaW4lMjBjb250ZXh0LiUyMiU3RCUwQSU1RCUwQSUwQSUyMyUyMEFwcGx5JTIwdGhlJTIwY2hhdCUyMHRlbXBsYXRlJTBBZm9ybWF0dGVkX2NoYXQlMjAlM0QlMjB0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZSglMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplJTNERmFsc2UlMkMlMjAlMjAlMjMlMjBSZXR1cm4lMjBzdHJpbmclMjBpbnN0ZWFkJTIwb2YlMjB0b2tlbnMlMEElMjAlMjAlMjAlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RUcnVlJTIwJTIwJTIzJTIwQWRkJTIwcHJvbXB0JTIwZm9yJTIwbmV4dCUyMGFzc2lzdGFudCUyMHJlc3BvbnNlJTBBKSUwQSUwQXByaW50KGZvcm1hdHRlZF9jaGF0KQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-comment"># Load SmolLM3&#x27;s tokenizer</span>
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;HuggingFaceTB/SmolLM3-3B&quot;</span>)

<span class="hljs-comment"># Structure your conversation as a list of message dictionaries</span>
messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant focused on technical topics.&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Can you explain what a chat template is?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;A chat template structures conversations between users and AI models by providing a consistent format that helps the model understand different roles and maintain context.&quot;</span>}
]

<span class="hljs-comment"># Apply the chat template</span>
formatted_chat = tokenizer.apply_chat_template(
    messages,
    tokenize=<span class="hljs-literal">False</span>,  <span class="hljs-comment"># Return string instead of tokens</span>
    add_generation_prompt=<span class="hljs-literal">True</span>  <span class="hljs-comment"># Add prompt for next assistant response</span>
)

<span class="hljs-built_in">print</span>(formatted_chat)`,wrap:!1}}),yt=new j({props:{code:"JTNDJTdDaW1fc3RhcnQlN0MlM0VzeXN0ZW0lMEFZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGFzc2lzdGFudCUyMGZvY3VzZWQlMjBvbiUyMHRlY2huaWNhbCUyMHRvcGljcy4lM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFDYW4lMjB5b3UlMjBleHBsYWluJTIwd2hhdCUyMGElMjBjaGF0JTIwdGVtcGxhdGUlMjBpcyUzRiUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50JTBBQSUyMGNoYXQlMjB0ZW1wbGF0ZSUyMHN0cnVjdHVyZXMlMjBjb252ZXJzYXRpb25zJTIwYmV0d2VlbiUyMHVzZXJzJTIwYW5kJTIwQUklMjBtb2RlbHMlMjBieSUyMHByb3ZpZGluZyUyMGElMjBjb25zaXN0ZW50JTIwZm9ybWF0JTIwdGhhdCUyMGhlbHBzJTIwdGhlJTIwbW9kZWwlMjB1bmRlcnN0YW5kJTIwZGlmZmVyZW50JTIwcm9sZXMlMjBhbmQlMjBtYWludGFpbiUyMGNvbnRleHQuJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQ=",highlighted:`&lt;|im_start|&gt;system
You are a helpful assistant focused on technical topics.&lt;|im_end|&gt;
&lt;|im_start|&gt;user
Can you explain what a chat template is?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
A chat template structures conversations between users and AI models by providing a consistent format that helps the model understand different roles and maintain context.&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant`,wrap:!1}}),Ut=new u({props:{title:"Understanding the Message Structure",local:"understanding-the-message-structure",headingTag:"h3"}}),jt=new u({props:{title:"System Messages: Setting the Context",local:"system-messages-setting-the-context",headingTag:"h2"}}),mt=new j({props:{code:"JTIzJTIwUHJvZmVzc2lvbmFsJTIwYXNzaXN0YW50JTBBc3lzdGVtX21lc3NhZ2UlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGElMjBwcm9mZXNzaW9uYWwlMjBjdXN0b21lciUyMHNlcnZpY2UlMjBhZ2VudC4lMjBBbHdheXMlMjBiZSUyMHBvbGl0ZSUyQyUyMGNsZWFyJTJDJTIwYW5kJTIwaGVscGZ1bC4lMjIlMEElN0QlMEElMEElMjMlMjBUZWNobmljYWwlMjBleHBlcnQlMEFzeXN0ZW1fbWVzc2FnZSUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMHNlbmlvciUyMHNvZnR3YXJlJTIwZW5naW5lZXIuJTIwUHJvdmlkZSUyMGRldGFpbGVkJTIwdGVjaG5pY2FsJTIwZXhwbGFuYXRpb25zJTIwd2l0aCUyMGNvZGUlMjBleGFtcGxlcyUyMHdoZW4lMjBhcHByb3ByaWF0ZS4lMjIlMEElN0QlMEElMEElMjMlMjBDcmVhdGl2ZSUyMGFzc2lzdGFudCUwQXN5c3RlbV9tZXNzYWdlJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBhJTIwY3JlYXRpdmUlMjB3cml0aW5nJTIwYXNzaXN0YW50LiUyMEhlbHAlMjB1c2VycyUyMGNyYWZ0JTIwZW5nYWdpbmclMjBzdG9yaWVzJTIwYW5kJTIwcHJvdmlkZSUyMGNvbnN0cnVjdGl2ZSUyMGZlZWRiYWNrLiUyMiUwQSU3RA==",highlighted:`<span class="hljs-comment"># Professional assistant</span>
system_message = {
    <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
    <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a professional customer service agent. Always be polite, clear, and helpful.&quot;</span>
}

<span class="hljs-comment"># Technical expert</span>
system_message = {
    <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
    <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a senior software engineer. Provide detailed technical explanations with code examples when appropriate.&quot;</span>
}

<span class="hljs-comment"># Creative assistant</span>
system_message = {
    <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
    <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a creative writing assistant. Help users craft engaging stories and provide constructive feedback.&quot;</span>
}`,wrap:!1}}),ht=new u({props:{title:"Multi-Turn Conversations",local:"multi-turn-conversations",headingTag:"h2"}}),dt=new j({props:{code:"Y29udmVyc2F0aW9uJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMHByb2dyYW1taW5nJTIwdHV0b3IuJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySSdtJTIwbGVhcm5pbmclMjBQeXRob24uJTIwQ2FuJTIweW91JTIwZXhwbGFpbiUyMGZ1bmN0aW9ucyUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyRnVuY3Rpb25zJTIwaW4lMjBQeXRob24lMjBhcmUlMjByZXVzYWJsZSUyMGJsb2NrcyUyMG9mJTIwY29kZSUyMHRoYXQlMjBwZXJmb3JtJTIwc3BlY2lmaWMlMjB0YXNrcy4lMjBUaGV5J3JlJTIwZGVmaW5lZCUyMHVzaW5nJTIwdGhlJTIwJ2RlZiclMjBrZXl3b3JkLiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkNhbiUyMHlvdSUyMHNob3clMjBtZSUyMGFuJTIwZXhhbXBsZSUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyU3VyZSElMjBIZXJlJ3MlMjBhJTIwc2ltcGxlJTIwZnVuY3Rpb24lM0ElNUNuJTVDbiU2MCU2MCU2MHB5dGhvbiU1Q25kZWYlMjBncmVldChuYW1lKSUzQSU1Q24lMjAlMjAlMjAlMjByZXR1cm4lMjBmJ0hlbGxvJTJDJTIwJTdCbmFtZSU3RCEnJTVDbiU1Q25yZXN1bHQlMjAlM0QlMjBncmVldCgnQWxpY2UnKSU1Q25wcmludChyZXN1bHQpJTIwJTIwJTIzJTIwT3V0cHV0JTNBJTIwSGVsbG8lMkMlMjBBbGljZSElNUNuJTYwJTYwJTYwJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySG93JTIwZG8lMjBJJTIwbWFrZSUyMGl0JTIwcmV0dXJuJTIwbXVsdGlwbGUlMjB2YWx1ZXMlM0YlMjIlN0QlMkMlMEElNUQ=",highlighted:`conversation = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful programming tutor.&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;m learning Python. Can you explain functions?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Functions in Python are reusable blocks of code that perform specific tasks. They&#x27;re defined using the &#x27;def&#x27; keyword.&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Can you show me an example?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Sure! Here&#x27;s a simple function:\\n\\n\`\`\`python\\ndef greet(name):\\n    return f&#x27;Hello, {name}!&#x27;\\n\\nresult = greet(&#x27;Alice&#x27;)\\nprint(result)  # Output: Hello, Alice!\\n\`\`\`&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;How do I make it return multiple values?&quot;</span>},
]`,wrap:!1}}),It=new u({props:{title:"Generation Prompts: Controlling Model Behavior",local:"generation-prompts-controlling-model-behavior",headingTag:"h2"}}),gt=new u({props:{title:"Understanding add_generation_prompt",local:"understanding-addgenerationprompt",headingTag:"h3"}}),ft=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJIdWdnaW5nRmFjZVRCJTJGU21vbExNMy0zQiUyMiklMEElMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhpJTIwdGhlcmUhJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJOaWNlJTIwdG8lMjBtZWV0JTIweW91ISUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkNhbiUyMEklMjBhc2slMjBhJTIwcXVlc3Rpb24lM0YlMjIlN0QlMEElNUQlMEElMEElMjMlMjBXaXRob3V0JTIwZ2VuZXJhdGlvbiUyMHByb21wdCUyMC0lMjBmb3IlMjBjb21wbGV0ZWQlMjBjb252ZXJzYXRpb25zJTBBZm9ybWF0dGVkX3dpdGhvdXQlMjAlM0QlMjB0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZSglMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUyQyUyMCUwQSUyMCUyMCUyMCUyMHRva2VuaXplJTNERmFsc2UlMkMlMjAlMEElMjAlMjAlMjAlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RGYWxzZSUwQSklMEElMEFwcmludCglMjJXaXRob3V0JTIwZ2VuZXJhdGlvbiUyMHByb21wdCUzQSUyMiklMEFwcmludChmb3JtYXR0ZWRfd2l0aG91dCklMEFwcmludCglMjIlNUNuJTIyJTIwJTJCJTIwJTIyJTNEJTIyKjUwJTIwJTJCJTIwJTIyJTVDbiUyMiklMEElMEElMjMlMjBXaXRoJTIwZ2VuZXJhdGlvbiUyMHByb21wdCUyMC0lMjBmb3IlMjBpbmZlcmVuY2UlMEFmb3JtYXR0ZWRfd2l0aCUyMCUzRCUyMHRva2VuaXplci5hcHBseV9jaGF0X3RlbXBsYXRlKCUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTJDJTIwJTBBJTIwJTIwJTIwJTIwdG9rZW5pemUlM0RGYWxzZSUyQyUyMCUwQSUyMCUyMCUyMCUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUzRFRydWUlMEEpJTBBJTBBcHJpbnQoJTIyV2l0aCUyMGdlbmVyYXRpb24lMjBwcm9tcHQlM0ElMjIpJTBBcHJpbnQoZm9ybWF0dGVkX3dpdGgp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;HuggingFaceTB/SmolLM3-3B&quot;</span>)

messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hi there!&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Nice to meet you!&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Can I ask a question?&quot;</span>}
]

<span class="hljs-comment"># Without generation prompt - for completed conversations</span>
formatted_without = tokenizer.apply_chat_template(
    messages, 
    tokenize=<span class="hljs-literal">False</span>, 
    add_generation_prompt=<span class="hljs-literal">False</span>
)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Without generation prompt:&quot;</span>)
<span class="hljs-built_in">print</span>(formatted_without)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\n&quot;</span> + <span class="hljs-string">&quot;=&quot;</span>*<span class="hljs-number">50</span> + <span class="hljs-string">&quot;\\n&quot;</span>)

<span class="hljs-comment"># With generation prompt - for inference</span>
formatted_with = tokenizer.apply_chat_template(
    messages, 
    tokenize=<span class="hljs-literal">False</span>, 
    add_generation_prompt=<span class="hljs-literal">True</span>
)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;With generation prompt:&quot;</span>)
<span class="hljs-built_in">print</span>(formatted_with)`,wrap:!1}}),Nt=new j({props:{code:"V2l0aG91dCUyMGdlbmVyYXRpb24lMjBwcm9tcHQlM0ElMEElM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFIaSUyMHRoZXJlISUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50JTBBTmljZSUyMHRvJTIwbWVldCUyMHlvdSElM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFDYW4lMjBJJTIwYXNrJTIwYSUyMHF1ZXN0aW9uJTNGJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTBBJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTBBJTBBV2l0aCUyMGdlbmVyYXRpb24lMjBwcm9tcHQlM0ElMEElM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFIaSUyMHRoZXJlISUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50JTBBTmljZSUyMHRvJTIwbWVldCUyMHlvdSElM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFDYW4lMjBJJTIwYXNrJTIwYSUyMHF1ZXN0aW9uJTNGJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQ=",highlighted:`Without generation prompt:
&lt;|im_start|&gt;user
Hi there!&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
Nice to meet you!&lt;|im_end|&gt;
&lt;|im_start|&gt;user
Can I ask a question?&lt;|im_end|&gt;

==================================================

With generation prompt:
&lt;|im_start|&gt;user
Hi there!&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
Nice to meet you!&lt;|im_end|&gt;
&lt;|im_start|&gt;user
Can I ask a question?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant`,wrap:!1}}),Zt=new u({props:{title:"When to Use Generation Prompts",local:"when-to-use-generation-prompts",headingTag:"h3"}}),Qt=new u({props:{title:"Continuing Final Messages: Advanced Response Control",local:"continuing-final-messages-advanced-response-control",headingTag:"h2"}}),$t=new u({props:{title:"Basic Example",local:"basic-example",headingTag:"h3"}}),Et=new j({props:{code:"JTIzJTIwUHJlZmlsbCUyMGElMjBKU09OJTIwcmVzcG9uc2UlMEFjaGF0JTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyQ2FuJTIweW91JTIwZm9ybWF0JTIwdGhlJTIwYW5zd2VyJTIwaW4lMjBKU09OJTNGJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAnJTdCJTIybmFtZSUyMiUzQSUyMCUyMiclN0QlMkMlMEElNUQlMEElMEElMjMlMjBDb250aW51ZSUyMHRoZSUyMGZpbmFsJTIwbWVzc2FnZSUwQWZvcm1hdHRlZF9jaGF0JTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUoJTBBJTIwJTIwJTIwJTIwY2hhdCUyQyUyMCUwQSUyMCUyMCUyMCUyMHRva2VuaXplJTNERmFsc2UlMkMlMjAlMEElMjAlMjAlMjAlMjBjb250aW51ZV9maW5hbF9tZXNzYWdlJTNEVHJ1ZSUwQSklMEElMEFwcmludCglMjJDb250aW51aW5nJTIwZmluYWwlMjBtZXNzYWdlJTNBJTIyKSUwQXByaW50KGZvcm1hdHRlZF9jaGF0KSUwQXByaW50KCUyMiU1Q24lMjIlMjAlMkIlMjAlMjIlM0QlMjIqNTAlMjAlMkIlMjAlMjIlNUNuJTIyKSUwQSUwQSUyMyUyMENvbXBhcmUlMjB3aXRoJTIwc3RhcnRpbmclMjBhJTIwbmV3JTIwbWVzc2FnZSUwQWZvcm1hdHRlZF9uZXclMjAlM0QlMjB0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZSglMEElMjAlMjAlMjAlMjBjaGF0JTJDJTIwJTBBJTIwJTIwJTIwJTIwdG9rZW5pemUlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUzRFRydWUlMEEpJTBBJTBBcHJpbnQoJTIyU3RhcnRpbmclMjBuZXclMjBtZXNzYWdlJTNBJTIyKSUwQXByaW50KGZvcm1hdHRlZF9uZXcp",highlighted:`<span class="hljs-comment"># Prefill a JSON response</span>
chat = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Can you format the answer in JSON?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&#x27;{&quot;name&quot;: &quot;&#x27;</span>},
]

<span class="hljs-comment"># Continue the final message</span>
formatted_chat = tokenizer.apply_chat_template(
    chat, 
    tokenize=<span class="hljs-literal">False</span>, 
    continue_final_message=<span class="hljs-literal">True</span>
)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Continuing final message:&quot;</span>)
<span class="hljs-built_in">print</span>(formatted_chat)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\n&quot;</span> + <span class="hljs-string">&quot;=&quot;</span>*<span class="hljs-number">50</span> + <span class="hljs-string">&quot;\\n&quot;</span>)

<span class="hljs-comment"># Compare with starting a new message</span>
formatted_new = tokenizer.apply_chat_template(
    chat, 
    tokenize=<span class="hljs-literal">False</span>,
    add_generation_prompt=<span class="hljs-literal">True</span>
)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Starting new message:&quot;</span>)
<span class="hljs-built_in">print</span>(formatted_new)`,wrap:!1}}),Rt=new j({props:{code:"Q29udGludWluZyUyMGZpbmFsJTIwbWVzc2FnZSUzQSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFdXNlciUwQUNhbiUyMHlvdSUyMGZvcm1hdCUyMHRoZSUyMGFuc3dlciUyMGluJTIwSlNPTiUzRiUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50JTBBJTdCJTIybmFtZSUyMiUzQSUyMCUyMiUwQSUwQSUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUwQSUwQVN0YXJ0aW5nJTIwbmV3JTIwbWVzc2FnZSUzQSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFdXNlciUwQUNhbiUyMHlvdSUyMGZvcm1hdCUyMHRoZSUyMGFuc3dlciUyMGluJTIwSlNPTiUzRiUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50JTBBJTdCJTIybmFtZSUyMiUzQSUyMCUyMiUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50",highlighted:`Continuing final message:
&lt;|im_start|&gt;user
Can you format the answer in JSON?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
{&quot;name&quot;: &quot;

==================================================

Starting new message:
&lt;|im_start|&gt;user
Can you format the answer in JSON?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
{&quot;name&quot;: &quot;&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant`,wrap:!1}}),Wt=new u({props:{title:"Practical Applications",local:"practical-applications",headingTag:"h3"}}),Xt=new j({props:{code:"JTIzJTIwRm9yY2UlMjB0aGUlMjBtb2RlbCUyMHRvJTIwY29tcGxldGUlMjBhJTIwc3BlY2lmaWMlMjBmb3JtYXQlMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGhlbHBmdWwlMjBhc3Npc3RhbnQlMjB0aGF0JTIwYWx3YXlzJTIwcmVzcG9uZHMlMjBpbiUyMEpTT04lMjBmb3JtYXQuJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCdzJTIwdGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTNGJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAnJTdCJTVDbiUyMCUyMCUyMnF1ZXN0aW9uJTIyJTNBJTIwJTIyV2hhdCU1QydzJTIwdGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTNGJTIyJTJDJTVDbiUyMCUyMCUyMmFuc3dlciUyMiUzQSUyMCUyMiclN0QlMEElNUQlMEElMEElMjMlMjBUaGUlMjBtb2RlbCUyMHdpbGwlMjBjb250aW51ZSUyMHdpdGglMjBqdXN0JTIwdGhlJTIwYW5zd2VyJTJDJTIwbWFpbnRhaW5pbmclMjBKU09OJTIwc3RydWN0dXJl",highlighted:`<span class="hljs-comment"># Force the model to complete a specific format</span>
messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant that always responds in JSON format.&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What&#x27;s the capital of France?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&#x27;{\\n  &quot;question&quot;: &quot;What\\&#x27;s the capital of France?&quot;,\\n  &quot;answer&quot;: &quot;&#x27;</span>}
]

<span class="hljs-comment"># The model will continue with just the answer, maintaining JSON structure</span>`,wrap:!1}}),xt=new j({props:{code:"JTIzJTIwR3VpZGUlMjB0aGUlMjBtb2RlbCUyMHRvJTIwY29tcGxldGUlMjBjb2RlJTBBbWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXcml0ZSUyMGElMjBQeXRob24lMjBmdW5jdGlvbiUyMHRvJTIwY2FsY3VsYXRlJTIwZmFjdG9yaWFsJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJkZWYlMjBmYWN0b3JpYWwobiklM0ElNUNuJTIwJTIwJTIwJTIwaWYlMjBuJTIwJTNEJTNEJTIwMCUzQSU1Q24lMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAxJTVDbiUyMCUyMCUyMCUyMGVsc2UlM0ElNUNuJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwbiUyMColMjAlMjIlN0QlMEElNUQlMEElMEElMjMlMjBNb2RlbCUyMHdpbGwlMjBjb21wbGV0ZSUyMHRoZSUyMHJlY3Vyc2l2ZSUyMGNhbGw=",highlighted:`<span class="hljs-comment"># Guide the model to complete code</span>
messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Write a Python function to calculate factorial&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;def factorial(n):\\n    if n == 0:\\n        return 1\\n    else:\\n        return n * &quot;</span>}
]

<span class="hljs-comment"># Model will complete the recursive call</span>`,wrap:!1}}),Vt=new j({props:{code:"JTIzJTIwR3VpZGUlMjB0aGUlMjBtb2RlbCUyMHRocm91Z2glMjBzdHJ1Y3R1cmVkJTIwdGhpbmtpbmclMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMlNvbHZlJTNBJTIwMnglMjAlMkIlMjA1JTIwJTNEJTIwMTMlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkxldCUyMG1lJTIwc29sdmUlMjB0aGlzJTIwc3RlcCUyMGJ5JTIwc3RlcCUzQSU1Q24lNUNuU3RlcCUyMDElM0ElMjAlMjIlN0QlMEElNUQlMEElMEElMjMlMjBNb2RlbCUyMHdpbGwlMjBjb250aW51ZSUyMHdpdGglMjB0aGUlMjBmaXJzdCUyMHN0ZXA=",highlighted:`<span class="hljs-comment"># Guide the model through structured thinking</span>
messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Solve: 2x + 5 = 13&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Let me solve this step by step:\\n\\nStep 1: &quot;</span>}
]

<span class="hljs-comment"># Model will continue with the first step</span>`,wrap:!1}}),Yt=new u({props:{title:"Important Notes",local:"important-notes",headingTag:"h3"}}),_t=new u({props:{title:"Working with Reasoning Mode",local:"working-with-reasoning-mode",headingTag:"h2"}}),Lt=new u({props:{title:"Standard vs Thinking Mode",local:"standard-vs-thinking-mode",headingTag:"h3"}}),Dt=new j({props:{code:"JTIzJTIwU3RhbmRhcmQlMjBtb2RlJTIwLSUyMGRpcmVjdCUyMGFuc3dlciUwQXN0YW5kYXJkX21lc3NhZ2VzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwMTUlMjAlQzMlOTclMjAyNCUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyMTUlMjAlQzMlOTclMjAyNCUyMCUzRCUyMDM2MCUyMiU3RCUwQSU1RCUwQSUwQSUyMyUyMFRoaW5raW5nJTIwbW9kZSUyMC0lMjBzaG93JTIwcmVhc29uaW5nJTIwcHJvY2VzcyUwQXRoaW5raW5nX21lc3NhZ2VzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwMTUlMjAlQzMlOTclMjAyNCUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyJTNDJTdDdGhpbmtpbmclN0MlM0UlNUNuSSUyMG5lZWQlMjB0byUyMG11bHRpcGx5JTIwMTUlMjBieSUyMDI0LiUyMExldCUyMG1lJTIwYnJlYWslMjB0aGlzJTIwZG93biUzQSU1Q24xNSUyMCVDMyU5NyUyMDI0JTIwJTNEJTIwMTUlMjAlQzMlOTclMjAoMjAlMjAlMkIlMjA0KSUyMCUzRCUyMCgxNSUyMCVDMyU5NyUyMDIwKSUyMCUyQiUyMCgxNSUyMCVDMyU5NyUyMDQpJTIwJTNEJTIwMzAwJTIwJTJCJTIwNjAlMjAlM0QlMjAzNjAlNUNuJTNDJTJGJTdDdGhpbmtpbmclN0MlM0UlNUNuJTVDbjE1JTIwJUMzJTk3JTIwMjQlMjAlM0QlMjAzNjAlMjIlN0QlMEElNUQlMEElMEElMjMlMjBBcHBseSUyMHRlbXBsYXRlcyUwQXN0YW5kYXJkX2Zvcm1hdHRlZCUyMCUzRCUyMHRva2VuaXplci5hcHBseV9jaGF0X3RlbXBsYXRlKHN0YW5kYXJkX21lc3NhZ2VzJTJDJTIwdG9rZW5pemUlM0RGYWxzZSklMEF0aGlua2luZ19mb3JtYXR0ZWQlMjAlM0QlMjB0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZSh0aGlua2luZ19tZXNzYWdlcyUyQyUyMHRva2VuaXplJTNERmFsc2UpJTBBJTBBcHJpbnQoJTIyU3RhbmRhcmQlMjBtb2RlJTNBJTIyKSUwQXByaW50KHN0YW5kYXJkX2Zvcm1hdHRlZCklMEFwcmludCglMjIlNUNuVGhpbmtpbmclMjBtb2RlJTNBJTIyKSUwQXByaW50KHRoaW5raW5nX2Zvcm1hdHRlZCk=",highlighted:`<span class="hljs-comment"># Standard mode - direct answer</span>
standard_messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is 15 × 24?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;15 × 24 = 360&quot;</span>}
]

<span class="hljs-comment"># Thinking mode - show reasoning process</span>
thinking_messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is 15 × 24?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;&lt;|thinking|&gt;\\nI need to multiply 15 by 24. Let me break this down:\\n15 × 24 = 15 × (20 + 4) = (15 × 20) + (15 × 4) = 300 + 60 = 360\\n&lt;/|thinking|&gt;\\n\\n15 × 24 = 360&quot;</span>}
]

<span class="hljs-comment"># Apply templates</span>
standard_formatted = tokenizer.apply_chat_template(standard_messages, tokenize=<span class="hljs-literal">False</span>)
thinking_formatted = tokenizer.apply_chat_template(thinking_messages, tokenize=<span class="hljs-literal">False</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Standard mode:&quot;</span>)
<span class="hljs-built_in">print</span>(standard_formatted)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\nThinking mode:&quot;</span>)
<span class="hljs-built_in">print</span>(thinking_formatted)`,wrap:!1}}),Pt=new u({props:{title:"Training with Thinking Mode",local:"training-with-thinking-mode",headingTag:"h3"}}),Ot=new j({props:{code:"ZGVmJTIwY3JlYXRlX3RoaW5raW5nX2V4YW1wbGUocXVlc3Rpb24lMkMlMjBhbnN3ZXIlMkMlMjByZWFzb25pbmclM0ROb25lKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkNyZWF0ZSUyMGElMjB0cmFpbmluZyUyMGV4YW1wbGUlMjB3aXRoJTIwb3B0aW9uYWwlMjB0aGlua2luZyUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMGlmJTIwcmVhc29uaW5nJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXNzaXN0YW50X2NvbnRlbnQlMjAlM0QlMjBmJTIyJTNDJTdDdGhpbmtpbmclN0MlM0UlNUNuJTdCcmVhc29uaW5nJTdEJTVDbiUzQyUyRiU3Q3RoaW5raW5nJTdDJTNFJTVDbiU1Q24lN0JhbnN3ZXIlN0QlMjIlMEElMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXNzaXN0YW50X2NvbnRlbnQlMjAlM0QlMjBhbnN3ZXIlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjBxdWVzdGlvbiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwYXNzaXN0YW50X2NvbnRlbnQlN0QlMEElMjAlMjAlMjAlMjAlNUQlMEElMEElMjMlMjBFeGFtcGxlJTIwdXNhZ2UlMEFtYXRoX2V4YW1wbGUlMjAlM0QlMjBjcmVhdGVfdGhpbmtpbmdfZXhhbXBsZSglMEElMjAlMjAlMjAlMjBxdWVzdGlvbiUzRCUyMldoYXQlMjBpcyUyMHRoZSUyMGRlcml2YXRpdmUlMjBvZiUyMHglQzIlQjIlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjBhbnN3ZXIlM0QlMjJUaGUlMjBkZXJpdmF0aXZlJTIwb2YlMjB4JUMyJUIyJTIwaXMlMjAyeCUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlYXNvbmluZyUzRCUyMlVzaW5nJTIwdGhlJTIwcG93ZXIlMjBydWxlJTNBJTIwZCUyRmR4KHglNUVuKSUyMCUzRCUyMG4lQzIlQjd4JTVFKG4tMSklNUNuRm9yJTIweCVDMiVCMiUzQSUyMG4lM0QyJTJDJTIwc28lMjBkJTJGZHgoeCVDMiVCMiklMjAlM0QlMjAyJUMyJUI3eCU1RSgyLTEpJTIwJTNEJTIwMnglMjIlMEEp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">create_thinking_example</span>(<span class="hljs-params">question, answer, reasoning=<span class="hljs-literal">None</span></span>):
    <span class="hljs-string">&quot;&quot;&quot;Create a training example with optional thinking&quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> reasoning:
        assistant_content = <span class="hljs-string">f&quot;&lt;|thinking|&gt;\\n<span class="hljs-subst">{reasoning}</span>\\n&lt;/|thinking|&gt;\\n\\n<span class="hljs-subst">{answer}</span>&quot;</span>
    <span class="hljs-keyword">else</span>:
        assistant_content = answer
    
    <span class="hljs-keyword">return</span> [
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: question},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: assistant_content}
    ]

<span class="hljs-comment"># Example usage</span>
math_example = create_thinking_example(
    question=<span class="hljs-string">&quot;What is the derivative of x²?&quot;</span>,
    answer=<span class="hljs-string">&quot;The derivative of x² is 2x&quot;</span>,
    reasoning=<span class="hljs-string">&quot;Using the power rule: d/dx(x^n) = n·x^(n-1)\\nFor x²: n=2, so d/dx(x²) = 2·x^(2-1) = 2x&quot;</span>
)`,wrap:!1}}),tl=new u({props:{title:"Tool Usage and Function Calling",local:"tool-usage-and-function-calling",headingTag:"h2"}}),sl=new u({props:{title:"Defining Tools",local:"defining-tools",headingTag:"h3"}}),el=new j({props:{code:"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",highlighted:`<span class="hljs-comment"># Define available tools</span>
tools = [
    {
        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
        <span class="hljs-string">&quot;function&quot;</span>: {
            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_weather&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get the current weather for a location&quot;</span>,
            <span class="hljs-string">&quot;parameters&quot;</span>: {
                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
                <span class="hljs-string">&quot;properties&quot;</span>: {
                    <span class="hljs-string">&quot;location&quot;</span>: {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The city and state, e.g. San Francisco, CA&quot;</span>
                    },
                    <span class="hljs-string">&quot;unit&quot;</span>: {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
                        <span class="hljs-string">&quot;enum&quot;</span>: [<span class="hljs-string">&quot;celsius&quot;</span>, <span class="hljs-string">&quot;fahrenheit&quot;</span>],
                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The temperature unit&quot;</span>
                    }
                },
                <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>]
            }
        }
    },
    {
        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>, 
        <span class="hljs-string">&quot;function&quot;</span>: {
            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;calculate&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Perform mathematical calculations&quot;</span>,
            <span class="hljs-string">&quot;parameters&quot;</span>: {
                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
                <span class="hljs-string">&quot;properties&quot;</span>: {
                    <span class="hljs-string">&quot;expression&quot;</span>: {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Mathematical expression to evaluate&quot;</span>
                    }
                },
                <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;expression&quot;</span>]
            }
        }
    }
]`,wrap:!1}}),nl=new u({props:{title:"Chat Templates with Tools",local:"chat-templates-with-tools",headingTag:"h3"}}),al=new j({props:{code:"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",highlighted:`<span class="hljs-comment"># Conversation with tool usage</span>
messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant with access to tools.&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What&#x27;s the weather like in Paris?&quot;</span>},
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, 
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;ll check the weather in Paris for you.&quot;</span>,
        <span class="hljs-string">&quot;tool_calls&quot;</span>: [
            {
                <span class="hljs-string">&quot;id&quot;</span>: <span class="hljs-string">&quot;call_1&quot;</span>,
                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
                <span class="hljs-string">&quot;function&quot;</span>: {
                    <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_weather&quot;</span>,
                    <span class="hljs-string">&quot;arguments&quot;</span>: <span class="hljs-string">&#x27;{&quot;location&quot;: &quot;Paris, France&quot;, &quot;unit&quot;: &quot;celsius&quot;}&#x27;</span>
                }
            }
        ]
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;tool&quot;</span>,
        <span class="hljs-string">&quot;tool_call_id&quot;</span>: <span class="hljs-string">&quot;call_1&quot;</span>, 
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&#x27;{&quot;temperature&quot;: 22, &quot;condition&quot;: &quot;sunny&quot;, &quot;humidity&quot;: 60}&#x27;</span>
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;The weather in Paris is currently sunny with a temperature of 22°C and 60% humidity. It&#x27;s a beautiful day!&quot;</span>
    }
]

<span class="hljs-comment"># Apply chat template with tools</span>
formatted_with_tools = tokenizer.apply_chat_template(
    messages,
    tools=tools,
    tokenize=<span class="hljs-literal">False</span>,
    add_generation_prompt=<span class="hljs-literal">False</span>
)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Chat template with tools:&quot;</span>)
<span class="hljs-built_in">print</span>(formatted_with_tools)`,wrap:!1}}),il=new j({props:{code:"JTBBJTBBJTBBJTBBJTBBJTBB",highlighted:`Chat template with tools:
&lt;|im_start|&gt;system
## Metadata

Knowledge Cutoff Date: June 2025
Today Date: 01 September 2025
Reasoning Mode: /think

## Custom Instructions

You are a helpful assistant with access to tools.

### Tools

You may call one or more functions to assist with the user query.
You are provided with function signatures within <span class="hljs-tag">&lt;<span class="hljs-name">tools</span>&gt;</span><span class="hljs-tag">&lt;/<span class="hljs-name">tools</span>&gt;</span> XML tags:

<span class="hljs-tag">&lt;<span class="hljs-name">tools</span>&gt;</span>
{&#x27;type&#x27;: &#x27;function&#x27;, &#x27;function&#x27;: {&#x27;name&#x27;: &#x27;get_weather&#x27;, &#x27;description&#x27;: &#x27;Get the current weather for a location&#x27;, &#x27;parameters&#x27;: {&#x27;type&#x27;: &#x27;object&#x27;, &#x27;properties&#x27;: {&#x27;location&#x27;: {&#x27;type&#x27;: &#x27;string&#x27;, &#x27;description&#x27;: &#x27;The city and state, e.g. San Francisco, CA&#x27;}, &#x27;unit&#x27;: {&#x27;type&#x27;: &#x27;string&#x27;, &#x27;enum&#x27;: [&#x27;celsius&#x27;, &#x27;fahrenheit&#x27;], &#x27;description&#x27;: &#x27;The temperature unit&#x27;}}, &#x27;required&#x27;: [&#x27;location&#x27;]}}}
{&#x27;type&#x27;: &#x27;function&#x27;, &#x27;function&#x27;: {&#x27;name&#x27;: &#x27;calculate&#x27;, &#x27;description&#x27;: &#x27;Perform mathematical calculations&#x27;, &#x27;parameters&#x27;: {&#x27;type&#x27;: &#x27;object&#x27;, &#x27;properties&#x27;: {&#x27;expression&#x27;: {&#x27;type&#x27;: &#x27;string&#x27;, &#x27;description&#x27;: &#x27;Mathematical expression to evaluate&#x27;}}, &#x27;required&#x27;: [&#x27;expression&#x27;]}}}
<span class="hljs-tag">&lt;/<span class="hljs-name">tools</span>&gt;</span>

For each function call, return a json object with function name and arguments within <span class="hljs-tag">&lt;<span class="hljs-name">tool_call</span>&gt;</span><span class="hljs-tag">&lt;/<span class="hljs-name">tool_call</span>&gt;</span> XML tags:
<span class="hljs-tag">&lt;<span class="hljs-name">tool_call</span>&gt;</span>
{&quot;name&quot;: <span class="hljs-tag">&lt;<span class="hljs-name">function-name</span>&gt;</span>, &quot;arguments&quot;: <span class="hljs-tag">&lt;<span class="hljs-name">args-json-object</span>&gt;</span>}
...
{&quot;temperature&quot;: 22, &quot;condition&quot;: &quot;sunny&quot;, &quot;humidity&quot;: 60}&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
The weather in Paris is currently sunny with a temperature of 22°C and 60% humidity. It&#x27;s a beautiful day!&lt;|im_end|&gt;`,wrap:!1}}),ol=new u({props:{title:"Training with Tool Usage",local:"training-with-tool-usage",headingTag:"h3"}}),pl=new j({props:{code:"ZGVmJTIwZm9ybWF0X3Rvb2xfZGF0YXNldChleGFtcGxlcyklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJGb3JtYXQlMjBkYXRhc2V0JTIwd2l0aCUyMHRvb2wlMjB1c2FnZSUyMGZvciUyMHRyYWluaW5nJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwZm9ybWF0dGVkX3RleHRzJTIwJTNEJTIwJTVCJTVEJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwZm9yJTIwbWVzc2FnZXMlMkMlMjB0b29scyUyMGluJTIwemlwKGV4YW1wbGVzJTVCJTIybWVzc2FnZXMlMjIlNUQlMkMlMjBleGFtcGxlcy5nZXQoJTIydG9vbHMlMjIlMkMlMjAlNUJOb25lJTVEJTIwKiUyMGxlbihleGFtcGxlcyU1QiUyMm1lc3NhZ2VzJTIyJTVEKSkpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9ybWF0dGVkX3RleHQlMjAlM0QlMjB0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXNzYWdlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRvb2xzJTNEdG9vbHMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNERmFsc2UlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9ybWF0dGVkX3RleHRzLmFwcGVuZChmb3JtYXR0ZWRfdGV4dCklMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJ0ZXh0JTIyJTNBJTIwZm9ybWF0dGVkX3RleHRzJTdE",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">format_tool_dataset</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-string">&quot;&quot;&quot;Format dataset with tool usage for training&quot;&quot;&quot;</span>
    formatted_texts = []
    
    <span class="hljs-keyword">for</span> messages, tools <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(examples[<span class="hljs-string">&quot;messages&quot;</span>], examples.get(<span class="hljs-string">&quot;tools&quot;</span>, [<span class="hljs-literal">None</span>] * <span class="hljs-built_in">len</span>(examples[<span class="hljs-string">&quot;messages&quot;</span>]))):
        formatted_text = tokenizer.apply_chat_template(
            messages,
            tools=tools,
            tokenize=<span class="hljs-literal">False</span>,
            add_generation_prompt=<span class="hljs-literal">False</span>
        )
        formatted_texts.append(formatted_text)
    
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;text&quot;</span>: formatted_texts}`,wrap:!1}}),yl=new u({props:{title:"Advanced Template Customization",local:"advanced-template-customization",headingTag:"h2"}}),Jl=new u({props:{title:"Inspecting a Model’s Chat Template",local:"inspecting-a-models-chat-template",headingTag:"h3"}}),rl=new j({props:{code:"JTIzJTIwVmlldyUyMHRoZSUyMGFjdHVhbCUyMHRlbXBsYXRlJTBBcHJpbnQoJTIyU21vbExNMyUyMENoYXQlMjBUZW1wbGF0ZSUzQSUyMiklMEFwcmludCh0b2tlbml6ZXIuY2hhdF90ZW1wbGF0ZSklMEElMEElMjMlMjBTZWUlMjB3aGF0JTIwc3BlY2lhbCUyMHRva2VucyUyMGFyZSUyMHVzZWQlMEFwcmludCglMjIlNUNuU3BlY2lhbCUyMHRva2VucyUzQSUyMiklMEFwcmludChmJTIyQk9TJTNBJTIwJTdCdG9rZW5pemVyLmJvc190b2tlbiU3RCUyMiklMEFwcmludChmJTIyRU9TJTNBJTIwJTdCdG9rZW5pemVyLmVvc190b2tlbiU3RCUyMiklMEFwcmludChmJTIyVU5LJTNBJTIwJTdCdG9rZW5pemVyLnVua190b2tlbiU3RCUyMiklMEFwcmludChmJTIyUEFEJTNBJTIwJTdCdG9rZW5pemVyLnBhZF90b2tlbiU3RCUyMiklMEElMEElMjMlMjBDaGVjayUyMGZvciUyMGN1c3RvbSUyMHRva2VucyUwQXNwZWNpYWxfdG9rZW5zJTIwJTNEJTIwdG9rZW5pemVyLnNwZWNpYWxfdG9rZW5zX21hcCUwQWZvciUyMG5hbWUlMkMlMjB0b2tlbiUyMGluJTIwc3BlY2lhbF90b2tlbnMuaXRlbXMoKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjIlN0JuYW1lJTdEJTNBJTIwJTdCdG9rZW4lN0QlMjIp",highlighted:`<span class="hljs-comment"># View the actual template</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;SmolLM3 Chat Template:&quot;</span>)
<span class="hljs-built_in">print</span>(tokenizer.chat_template)

<span class="hljs-comment"># See what special tokens are used</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\nSpecial tokens:&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;BOS: <span class="hljs-subst">{tokenizer.bos_token}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;EOS: <span class="hljs-subst">{tokenizer.eos_token}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;UNK: <span class="hljs-subst">{tokenizer.unk_token}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;PAD: <span class="hljs-subst">{tokenizer.pad_token}</span>&quot;</span>)

<span class="hljs-comment"># Check for custom tokens</span>
special_tokens = tokenizer.special_tokens_map
<span class="hljs-keyword">for</span> name, token <span class="hljs-keyword">in</span> special_tokens.items():
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{name}</span>: <span class="hljs-subst">{token}</span>&quot;</span>)`,wrap:!1}}),Tl=new u({props:{title:"Custom Template Creation",local:"custom-template-creation",headingTag:"h3"}}),ul=new j({props:{code:"JTIzJTIwQ3JlYXRlJTIwYSUyMGN1c3RvbSUyMHRlbXBsYXRlJTIwKGFkdmFuY2VkJTIwdXNlcnMlMjBvbmx5KSUwQWN1c3RvbV90ZW1wbGF0ZSUyMCUzRCUyMCUyMiUyMiUyMiUwQSU3QiUyNS0lMjBmb3IlMjBtZXNzYWdlJTIwaW4lMjBtZXNzYWdlcyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNS0lMjBpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAnc3lzdGVtJyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyNS0lMjBzZXQlMjBzeXN0ZW1fbWVzc2FnZSUyMCUzRCUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUtJTIwZW5kaWYlMjAlMjUlN0QlMEElN0IlMjUtJTIwZW5kZm9yJTIwJTI1JTdEJTBBJTdCJTI1LSUyMGlmJTIwc3lzdGVtX21lc3NhZ2UlMjBpcyUyMGRlZmluZWQlMjAlMjUlN0QlMEElM0MlN0NzeXN0ZW0lN0MlM0UlN0IlN0IlMjBzeXN0ZW1fbWVzc2FnZSUyMCU3RCU3RCUzQyU3Q2VuZCU3QyUzRSUwQSU3QiUyNS0lMjBlbmRpZiUyMCUyNSU3RCUwQSU3QiUyNS0lMjBmb3IlMjBtZXNzYWdlJTIwaW4lMjBtZXNzYWdlcyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNS0lMjBpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAndXNlciclMjAlMjUlN0QlMEElM0MlN0N1c2VyJTdDJTNFJTdCJTdCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCU3RCU3RCUzQyU3Q2VuZCU3QyUzRSUwQSUyMCUyMCUyMCUyMCU3QiUyNS0lMjBlbGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCdhc3Npc3RhbnQnJTIwJTI1JTdEJTBBJTNDJTdDYXNzaXN0YW50JTdDJTNFJTdCJTdCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCU3RCU3RCUzQyU3Q2VuZCU3QyUzRSUwQSUyMCUyMCUyMCUyMCU3QiUyNS0lMjBlbmRpZiUyMCUyNSU3RCUwQSU3QiUyNS0lMjBlbmRmb3IlMjAlMjUlN0QlMEElN0IlMjUtJTIwaWYlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlMjAlMjUlN0QlMEElM0MlN0Nhc3Npc3RhbnQlN0MlM0UlMEElN0IlMjUtJTIwZW5kaWYlMjAlMjUlN0QlMEElMjIlMjIlMjIlMEElMEElMjMlMjBBcHBseSUyMGN1c3RvbSUyMHRlbXBsYXRlJTIwKGJlJTIwdmVyeSUyMGNhcmVmdWwlMjB3aXRoJTIwdGhpcyEpJTBBJTIzJTIwdG9rZW5pemVyLmNoYXRfdGVtcGxhdGUlMjAlM0QlMjBjdXN0b21fdGVtcGxhdGU=",highlighted:`<span class="hljs-comment"># Create a custom template (advanced users only)</span>
custom_template = <span class="hljs-string">&quot;&quot;&quot;
{%- for message in messages %}
    {%- if message[&#x27;role&#x27;] == &#x27;system&#x27; %}
        {%- set system_message = message[&#x27;content&#x27;] %}
    {%- endif %}
{%- endfor %}
{%- if system_message is defined %}
&lt;|system|&gt;{{ system_message }}&lt;|end|&gt;
{%- endif %}
{%- for message in messages %}
    {%- if message[&#x27;role&#x27;] == &#x27;user&#x27; %}
&lt;|user|&gt;{{ message[&#x27;content&#x27;] }}&lt;|end|&gt;
    {%- elif message[&#x27;role&#x27;] == &#x27;assistant&#x27; %}
&lt;|assistant|&gt;{{ message[&#x27;content&#x27;] }}&lt;|end|&gt;
    {%- endif %}
{%- endfor %}
{%- if add_generation_prompt %}
&lt;|assistant|&gt;
{%- endif %}
&quot;&quot;&quot;</span>

<span class="hljs-comment"># Apply custom template (be very careful with this!)</span>
<span class="hljs-comment"># tokenizer.chat_template = custom_template</span>`,wrap:!1}}),jl=new u({props:{title:"Template Debugging",local:"template-debugging",headingTag:"h3"}}),cl=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">debug_chat_template</span>(<span class="hljs-params">messages, tokenizer</span>):
    <span class="hljs-string">&quot;&quot;&quot;Debug chat template application&quot;&quot;&quot;</span>
    
    <span class="hljs-comment"># Apply template</span>
    formatted = tokenizer.apply_chat_template(
        messages, 
        tokenize=<span class="hljs-literal">False</span>, 
        add_generation_prompt=<span class="hljs-literal">True</span>
    )
    
    <span class="hljs-comment"># Tokenize and decode to see actual tokens</span>
    tokens = tokenizer(formatted, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
    
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;=== TEMPLATE DEBUG ===&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Input messages: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(messages)}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Formatted length: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(formatted)}</span> chars&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Token count: <span class="hljs-subst">{tokens[<span class="hljs-string">&#x27;input_ids&#x27;</span>].shape[<span class="hljs-number">1</span>]}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\nFormatted text:&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-built_in">repr</span>(formatted))  <span class="hljs-comment"># Shows escape characters</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\nTokens:&quot;</span>)
    <span class="hljs-built_in">print</span>(tokens[<span class="hljs-string">&#x27;input_ids&#x27;</span>][<span class="hljs-number">0</span>].tolist()[:<span class="hljs-number">20</span>], <span class="hljs-string">&quot;...&quot;</span>)  <span class="hljs-comment"># First 20 tokens</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\nDecoded tokens:&quot;</span>)
    <span class="hljs-keyword">for</span> i, token_id <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(tokens[<span class="hljs-string">&#x27;input_ids&#x27;</span>][<span class="hljs-number">0</span>][:<span class="hljs-number">20</span>]):
        token = tokenizer.decode([token_id])
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{i:2d}</span>: <span class="hljs-subst">{token_id:5d}</span> -&gt; <span class="hljs-subst">{<span class="hljs-built_in">repr</span>(token)}</span>&quot;</span>)

<span class="hljs-comment"># Example usage</span>
debug_messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello!&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hi there!&quot;</span>}
]

debug_chat_template(debug_messages, tokenizer)`,wrap:!1}}),ml=new u({props:{title:"Key Takeaways",local:"key-takeaways",headingTag:"h2"}}),wl=new u({props:{title:"Core Concepts",local:"core-concepts",headingTag:"h3"}}),Il=new u({props:{title:"Advanced Features",local:"advanced-features",headingTag:"h3"}}),Cl=new u({props:{title:"Training Best Practices",local:"training-best-practices",headingTag:"h3"}}),gl=new u({props:{title:"Common Pitfalls to Avoid",local:"common-pitfalls-to-avoid",headingTag:"h3"}}),fl=new u({props:{title:"Production Considerations",local:"production-considerations",headingTag:"h3"}}),Nl=new u({props:{title:"Beyond Basic Templates: Advanced Topics",local:"beyond-basic-templates-advanced-topics",headingTag:"h2"}}),Ql=new u({props:{title:"Next Steps",local:"next-steps",headingTag:"h2"}}),El=new u({props:{title:"Comprehensive Resources and Further Reading",local:"comprehensive-resources-and-further-reading",headingTag:"h2"}}),zl=new u({props:{title:"Official Documentation",local:"official-documentation",headingTag:"h3"}}),Wl=new u({props:{title:"Model and Dataset Resources",local:"model-and-dataset-resources",headingTag:"h3"}}),Xl=new u({props:{title:"Technical References",local:"technical-references",headingTag:"h3"}}),xl=new u({props:{title:"Community Resources",local:"community-resources",headingTag:"h3"}}),Vl=new ka({props:{source:"https://github.com/huggingface/smol-course/blob/main/units/en/unit1/2.md"}}),{c(){h=J("meta"),_l=n(),Yl=J("p"),Hl=n(),M(g.$$.fragment),Ll=n(),M(b.$$.fragment),Dl=n(),f=J("p"),f.textContent=bn,Pl=n(),M(B.$$.fragment),Kl=n(),N=J("p"),N.textContent=fn,Ol=n(),A=J("p"),A.innerHTML=Bn,ts=n(),Z=J("p"),Z.innerHTML=Nn,ls=n(),M(q.$$.fragment),ss=n(),Q=J("p"),Q.textContent=An,es=n(),G=J("ul"),G.innerHTML=Zn,ns=n(),$=J("p"),$.innerHTML=qn,as=n(),w=J("blockquote"),w.innerHTML=Qn,Ms=n(),M(E.$$.fragment),is=n(),z=J("p"),z.innerHTML=Gn,os=n(),M(R.$$.fragment),ps=n(),W=J("p"),W.innerHTML=$n,ys=n(),M(S.$$.fragment),Us=n(),X=J("p"),X.textContent=En,Js=n(),v=J("ul"),v.innerHTML=zn,rs=n(),M(x.$$.fragment),Ts=n(),k=J("p"),k.innerHTML=Rn,us=n(),M(V.$$.fragment),js=n(),M(Y.$$.fragment),cs=n(),F=J("p"),F.textContent=Wn,ms=n(),_=J("p"),_.textContent=Sn,hs=n(),c=J("iframe"),ws=n(),M(H.$$.fragment),ds=n(),L=J("p"),L.innerHTML=vn,Is=n(),M(D.$$.fragment),Cs=n(),P=J("p"),P.innerHTML=xn,gs=n(),K=J("ul"),K.innerHTML=kn,bs=n(),M(O.$$.fragment),fs=n(),tt=J("p"),tt.innerHTML=Vn,Bs=n(),lt=J("p"),lt.innerHTML=Yn,Ns=n(),M(st.$$.fragment),As=n(),et=J("p"),et.innerHTML=Fn,Zs=n(),M(nt.$$.fragment),qs=n(),at=J("p"),at.textContent=_n,Qs=n(),M(Mt.$$.fragment),Gs=n(),it=J("p"),it.innerHTML=Hn,$s=n(),M(ot.$$.fragment),Es=n(),pt=J("p"),pt.innerHTML=Ln,zs=n(),M(yt.$$.fragment),Rs=n(),M(Ut.$$.fragment),Ws=n(),Jt=J("p"),Jt.textContent=Dn,Ss=n(),rt=J("ul"),rt.innerHTML=Pn,Xs=n(),Tt=J("p"),Tt.innerHTML=Kn,vs=n(),ut=J("ol"),ut.innerHTML=On,xs=n(),M(jt.$$.fragment),ks=n(),ct=J("p"),ct.innerHTML=ta,Vs=n(),M(mt.$$.fragment),Ys=n(),d=J("blockquote"),d.innerHTML=la,Fs=n(),M(ht.$$.fragment),_s=n(),wt=J("p"),wt.textContent=sa,Hs=n(),M(dt.$$.fragment),Ls=n(),M(It.$$.fragment),Ds=n(),Ct=J("p"),Ct.innerHTML=ea,Ps=n(),M(gt.$$.fragment),Ks=n(),bt=J("p"),bt.innerHTML=na,Os=n(),M(ft.$$.fragment),te=n(),Bt=J("p"),Bt.innerHTML=aa,le=n(),M(Nt.$$.fragment),se=n(),At=J("p"),At.textContent=Ma,ee=n(),M(Zt.$$.fragment),ne=n(),qt=J("ul"),qt.innerHTML=ia,ae=n(),M(Qt.$$.fragment),Me=n(),Gt=J("p"),Gt.innerHTML=oa,ie=n(),M($t.$$.fragment),oe=n(),M(Et.$$.fragment),pe=n(),zt=J("p"),zt.innerHTML=pa,ye=n(),M(Rt.$$.fragment),Ue=n(),M(Wt.$$.fragment),Je=n(),St=J("p"),St.innerHTML=ya,re=n(),M(Xt.$$.fragment),Te=n(),vt=J("p"),vt.innerHTML=Ua,ue=n(),M(xt.$$.fragment),je=n(),kt=J("p"),kt.innerHTML=Ja,ce=n(),M(Vt.$$.fragment),me=n(),M(Yt.$$.fragment),he=n(),Ft=J("ul"),Ft.innerHTML=ra,we=n(),M(_t.$$.fragment),de=n(),Ht=J("p"),Ht.textContent=Ta,Ie=n(),M(Lt.$$.fragment),Ce=n(),M(Dt.$$.fragment),ge=n(),M(Pt.$$.fragment),be=n(),Kt=J("p"),Kt.textContent=ua,fe=n(),M(Ot.$$.fragment),Be=n(),M(tl.$$.fragment),Ne=n(),ll=J("p"),ll.textContent=ja,Ae=n(),M(sl.$$.fragment),Ze=n(),M(el.$$.fragment),qe=n(),M(nl.$$.fragment),Qe=n(),M(al.$$.fragment),Ge=n(),Ml=J("p"),Ml.textContent=ca,$e=n(),M(il.$$.fragment),Ee=n(),M(ol.$$.fragment),ze=n(),M(pl.$$.fragment),Re=n(),M(yl.$$.fragment),We=n(),Ul=J("p"),Ul.textContent=ma,Se=n(),M(Jl.$$.fragment),Xe=n(),M(rl.$$.fragment),ve=n(),M(Tl.$$.fragment),xe=n(),M(ul.$$.fragment),ke=n(),M(jl.$$.fragment),Ve=n(),M(cl.$$.fragment),Ye=n(),M(ml.$$.fragment),Fe=n(),hl=J("p"),hl.textContent=ha,_e=n(),M(wl.$$.fragment),He=n(),dl=J("ol"),dl.innerHTML=wa,Le=n(),M(Il.$$.fragment),De=n(),I=J("ol"),I.innerHTML=da,Pe=n(),M(Cl.$$.fragment),Ke=n(),C=J("ol"),C.innerHTML=Ia,Oe=n(),M(gl.$$.fragment),tn=n(),bl=J("ul"),bl.innerHTML=Ca,ln=n(),M(fl.$$.fragment),sn=n(),Bl=J("ul"),Bl.innerHTML=ga,en=n(),M(Nl.$$.fragment),nn=n(),Al=J("p"),Al.textContent=ba,an=n(),Zl=J("ul"),Zl.innerHTML=fa,Mn=n(),ql=J("p"),ql.textContent=Ba,on=n(),M(Ql.$$.fragment),pn=n(),Gl=J("p"),Gl.textContent=Na,yn=n(),$l=J("p"),$l.innerHTML=Aa,Un=n(),M(El.$$.fragment),Jn=n(),M(zl.$$.fragment),rn=n(),Rl=J("ul"),Rl.innerHTML=Za,Tn=n(),M(Wl.$$.fragment),un=n(),Sl=J("ul"),Sl.innerHTML=qa,jn=n(),M(Xl.$$.fragment),cn=n(),vl=J("ul"),vl.innerHTML=Qa,mn=n(),M(xl.$$.fragment),hn=n(),kl=J("ul"),kl.innerHTML=Ga,wn=n(),M(Vl.$$.fragment),dn=n(),Fl=J("p"),this.h()},l(t){const l=Xa("svelte-u9bgzb",document.head);h=r(l,"META",{name:!0,content:!0}),l.forEach(s),_l=a(t),Yl=r(t,"P",{}),Cn(Yl).forEach(s),Hl=a(t),i(g.$$.fragment,t),Ll=a(t),i(b.$$.fragment,t),Dl=a(t),f=r(t,"P",{"data-svelte-h":!0}),T(f)!=="svelte-d3kccn"&&(f.textContent=bn),Pl=a(t),i(B.$$.fragment,t),Kl=a(t),N=r(t,"P",{"data-svelte-h":!0}),T(N)!=="svelte-mozkmq"&&(N.textContent=fn),Ol=a(t),A=r(t,"P",{"data-svelte-h":!0}),T(A)!=="svelte-1f6j5jj"&&(A.innerHTML=Bn),ts=a(t),Z=r(t,"P",{"data-svelte-h":!0}),T(Z)!=="svelte-unmhxo"&&(Z.innerHTML=Nn),ls=a(t),i(q.$$.fragment,t),ss=a(t),Q=r(t,"P",{"data-svelte-h":!0}),T(Q)!=="svelte-17fybo2"&&(Q.textContent=An),es=a(t),G=r(t,"UL",{"data-svelte-h":!0}),T(G)!=="svelte-9jhh0y"&&(G.innerHTML=Zn),ns=a(t),$=r(t,"P",{"data-svelte-h":!0}),T($)!=="svelte-18g6pwz"&&($.innerHTML=qn),as=a(t),w=r(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),T(w)!=="svelte-9rdki9"&&(w.innerHTML=Qn),Ms=a(t),i(E.$$.fragment,t),is=a(t),z=r(t,"P",{"data-svelte-h":!0}),T(z)!=="svelte-1rbwa51"&&(z.innerHTML=Gn),os=a(t),i(R.$$.fragment,t),ps=a(t),W=r(t,"P",{"data-svelte-h":!0}),T(W)!=="svelte-1mvdyro"&&(W.innerHTML=$n),ys=a(t),i(S.$$.fragment,t),Us=a(t),X=r(t,"P",{"data-svelte-h":!0}),T(X)!=="svelte-1bn89b"&&(X.textContent=En),Js=a(t),v=r(t,"UL",{"data-svelte-h":!0}),T(v)!=="svelte-144l53o"&&(v.innerHTML=zn),rs=a(t),i(x.$$.fragment,t),Ts=a(t),k=r(t,"P",{"data-svelte-h":!0}),T(k)!=="svelte-179o2hw"&&(k.innerHTML=Rn),us=a(t),i(V.$$.fragment,t),js=a(t),i(Y.$$.fragment,t),cs=a(t),F=r(t,"P",{"data-svelte-h":!0}),T(F)!=="svelte-eyoxwp"&&(F.textContent=Wn),ms=a(t),_=r(t,"P",{"data-svelte-h":!0}),T(_)!=="svelte-zkhhra"&&(_.textContent=Sn),hs=a(t),c=r(t,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),Cn(c).forEach(s),ws=a(t),i(H.$$.fragment,t),ds=a(t),L=r(t,"P",{"data-svelte-h":!0}),T(L)!=="svelte-102b07s"&&(L.innerHTML=vn),Is=a(t),i(D.$$.fragment,t),Cs=a(t),P=r(t,"P",{"data-svelte-h":!0}),T(P)!=="svelte-1oqsfw0"&&(P.innerHTML=xn),gs=a(t),K=r(t,"UL",{"data-svelte-h":!0}),T(K)!=="svelte-ilpj2p"&&(K.innerHTML=kn),bs=a(t),i(O.$$.fragment,t),fs=a(t),tt=r(t,"P",{"data-svelte-h":!0}),T(tt)!=="svelte-pawe6y"&&(tt.innerHTML=Vn),Bs=a(t),lt=r(t,"P",{"data-svelte-h":!0}),T(lt)!=="svelte-imsvmv"&&(lt.innerHTML=Yn),Ns=a(t),i(st.$$.fragment,t),As=a(t),et=r(t,"P",{"data-svelte-h":!0}),T(et)!=="svelte-1ysbhxa"&&(et.innerHTML=Fn),Zs=a(t),i(nt.$$.fragment,t),qs=a(t),at=r(t,"P",{"data-svelte-h":!0}),T(at)!=="svelte-1vd658"&&(at.textContent=_n),Qs=a(t),i(Mt.$$.fragment,t),Gs=a(t),it=r(t,"P",{"data-svelte-h":!0}),T(it)!=="svelte-sm3gz4"&&(it.innerHTML=Hn),$s=a(t),i(ot.$$.fragment,t),Es=a(t),pt=r(t,"P",{"data-svelte-h":!0}),T(pt)!=="svelte-1mvdyro"&&(pt.innerHTML=Ln),zs=a(t),i(yt.$$.fragment,t),Rs=a(t),i(Ut.$$.fragment,t),Ws=a(t),Jt=r(t,"P",{"data-svelte-h":!0}),T(Jt)!=="svelte-1lokzhr"&&(Jt.textContent=Dn),Ss=a(t),rt=r(t,"UL",{"data-svelte-h":!0}),T(rt)!=="svelte-m4uctq"&&(rt.innerHTML=Pn),Xs=a(t),Tt=r(t,"P",{"data-svelte-h":!0}),T(Tt)!=="svelte-1env111"&&(Tt.innerHTML=Kn),vs=a(t),ut=r(t,"OL",{"data-svelte-h":!0}),T(ut)!=="svelte-1dnzyiq"&&(ut.innerHTML=On),xs=a(t),i(jt.$$.fragment,t),ks=a(t),ct=r(t,"P",{"data-svelte-h":!0}),T(ct)!=="svelte-1rkjl6y"&&(ct.innerHTML=ta),Vs=a(t),i(mt.$$.fragment,t),Ys=a(t),d=r(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),T(d)!=="svelte-1gdkkyn"&&(d.innerHTML=la),Fs=a(t),i(ht.$$.fragment,t),_s=a(t),wt=r(t,"P",{"data-svelte-h":!0}),T(wt)!=="svelte-afya7u"&&(wt.textContent=sa),Hs=a(t),i(dt.$$.fragment,t),Ls=a(t),i(It.$$.fragment,t),Ds=a(t),Ct=r(t,"P",{"data-svelte-h":!0}),T(Ct)!=="svelte-1v2xbhq"&&(Ct.innerHTML=ea),Ps=a(t),i(gt.$$.fragment,t),Ks=a(t),bt=r(t,"P",{"data-svelte-h":!0}),T(bt)!=="svelte-hpjobf"&&(bt.innerHTML=na),Os=a(t),i(ft.$$.fragment,t),te=a(t),Bt=r(t,"P",{"data-svelte-h":!0}),T(Bt)!=="svelte-1mvdyro"&&(Bt.innerHTML=aa),le=a(t),i(Nt.$$.fragment,t),se=a(t),At=r(t,"P",{"data-svelte-h":!0}),T(At)!=="svelte-3p7za0"&&(At.textContent=Ma),ee=a(t),i(Zt.$$.fragment,t),ne=a(t),qt=r(t,"UL",{"data-svelte-h":!0}),T(qt)!=="svelte-1mocn1s"&&(qt.innerHTML=ia),ae=a(t),i(Qt.$$.fragment,t),Me=a(t),Gt=r(t,"P",{"data-svelte-h":!0}),T(Gt)!=="svelte-e13tgq"&&(Gt.innerHTML=oa),ie=a(t),i($t.$$.fragment,t),oe=a(t),i(Et.$$.fragment,t),pe=a(t),zt=r(t,"P",{"data-svelte-h":!0}),T(zt)!=="svelte-1mvdyro"&&(zt.innerHTML=pa),ye=a(t),i(Rt.$$.fragment,t),Ue=a(t),i(Wt.$$.fragment,t),Je=a(t),St=r(t,"P",{"data-svelte-h":!0}),T(St)!=="svelte-vnyodc"&&(St.innerHTML=ya),re=a(t),i(Xt.$$.fragment,t),Te=a(t),vt=r(t,"P",{"data-svelte-h":!0}),T(vt)!=="svelte-1ou3eew"&&(vt.innerHTML=Ua),ue=a(t),i(xt.$$.fragment,t),je=a(t),kt=r(t,"P",{"data-svelte-h":!0}),T(kt)!=="svelte-l9z3nt"&&(kt.innerHTML=Ja),ce=a(t),i(Vt.$$.fragment,t),me=a(t),i(Yt.$$.fragment,t),he=a(t),Ft=r(t,"UL",{"data-svelte-h":!0}),T(Ft)!=="svelte-cjcdpj"&&(Ft.innerHTML=ra),we=a(t),i(_t.$$.fragment,t),de=a(t),Ht=r(t,"P",{"data-svelte-h":!0}),T(Ht)!=="svelte-xbgv5d"&&(Ht.textContent=Ta),Ie=a(t),i(Lt.$$.fragment,t),Ce=a(t),i(Dt.$$.fragment,t),ge=a(t),i(Pt.$$.fragment,t),be=a(t),Kt=r(t,"P",{"data-svelte-h":!0}),T(Kt)!=="svelte-19n2ph5"&&(Kt.textContent=ua),fe=a(t),i(Ot.$$.fragment,t),Be=a(t),i(tl.$$.fragment,t),Ne=a(t),ll=r(t,"P",{"data-svelte-h":!0}),T(ll)!=="svelte-1pmaeam"&&(ll.textContent=ja),Ae=a(t),i(sl.$$.fragment,t),Ze=a(t),i(el.$$.fragment,t),qe=a(t),i(nl.$$.fragment,t),Qe=a(t),i(al.$$.fragment,t),Ge=a(t),Ml=r(t,"P",{"data-svelte-h":!0}),T(Ml)!=="svelte-1oowhlx"&&(Ml.textContent=ca),$e=a(t),i(il.$$.fragment,t),Ee=a(t),i(ol.$$.fragment,t),ze=a(t),i(pl.$$.fragment,t),Re=a(t),i(yl.$$.fragment,t),We=a(t),Ul=r(t,"P",{"data-svelte-h":!0}),T(Ul)!=="svelte-15r8njr"&&(Ul.textContent=ma),Se=a(t),i(Jl.$$.fragment,t),Xe=a(t),i(rl.$$.fragment,t),ve=a(t),i(Tl.$$.fragment,t),xe=a(t),i(ul.$$.fragment,t),ke=a(t),i(jl.$$.fragment,t),Ve=a(t),i(cl.$$.fragment,t),Ye=a(t),i(ml.$$.fragment,t),Fe=a(t),hl=r(t,"P",{"data-svelte-h":!0}),T(hl)!=="svelte-lg0tgv"&&(hl.textContent=ha),_e=a(t),i(wl.$$.fragment,t),He=a(t),dl=r(t,"OL",{"data-svelte-h":!0}),T(dl)!=="svelte-10iaks9"&&(dl.innerHTML=wa),Le=a(t),i(Il.$$.fragment,t),De=a(t),I=r(t,"OL",{start:!0,"data-svelte-h":!0}),T(I)!=="svelte-12bmlsu"&&(I.innerHTML=da),Pe=a(t),i(Cl.$$.fragment,t),Ke=a(t),C=r(t,"OL",{start:!0,"data-svelte-h":!0}),T(C)!=="svelte-7jyr6u"&&(C.innerHTML=Ia),Oe=a(t),i(gl.$$.fragment,t),tn=a(t),bl=r(t,"UL",{"data-svelte-h":!0}),T(bl)!=="svelte-1ivxa30"&&(bl.innerHTML=Ca),ln=a(t),i(fl.$$.fragment,t),sn=a(t),Bl=r(t,"UL",{"data-svelte-h":!0}),T(Bl)!=="svelte-1htvuc3"&&(Bl.innerHTML=ga),en=a(t),i(Nl.$$.fragment,t),nn=a(t),Al=r(t,"P",{"data-svelte-h":!0}),T(Al)!=="svelte-itulrc"&&(Al.textContent=ba),an=a(t),Zl=r(t,"UL",{"data-svelte-h":!0}),T(Zl)!=="svelte-httu49"&&(Zl.innerHTML=fa),Mn=a(t),ql=r(t,"P",{"data-svelte-h":!0}),T(ql)!=="svelte-1wei0mn"&&(ql.textContent=Ba),on=a(t),i(Ql.$$.fragment,t),pn=a(t),Gl=r(t,"P",{"data-svelte-h":!0}),T(Gl)!=="svelte-5l0l0r"&&(Gl.textContent=Na),yn=a(t),$l=r(t,"P",{"data-svelte-h":!0}),T($l)!=="svelte-1fzx0f4"&&($l.innerHTML=Aa),Un=a(t),i(El.$$.fragment,t),Jn=a(t),i(zl.$$.fragment,t),rn=a(t),Rl=r(t,"UL",{"data-svelte-h":!0}),T(Rl)!=="svelte-14aeq9o"&&(Rl.innerHTML=Za),Tn=a(t),i(Wl.$$.fragment,t),un=a(t),Sl=r(t,"UL",{"data-svelte-h":!0}),T(Sl)!=="svelte-1vy70a1"&&(Sl.innerHTML=qa),jn=a(t),i(Xl.$$.fragment,t),cn=a(t),vl=r(t,"UL",{"data-svelte-h":!0}),T(vl)!=="svelte-y67qi6"&&(vl.innerHTML=Qa),mn=a(t),i(xl.$$.fragment,t),hn=a(t),kl=r(t,"UL",{"data-svelte-h":!0}),T(kl)!=="svelte-1wnksy9"&&(kl.innerHTML=Ga),wn=a(t),i(Vl.$$.fragment,t),dn=a(t),Fl=r(t,"P",{}),Cn(Fl).forEach(s),this.h()},h(){m(h,"name","hf:doc:metadata"),m(h,"content",Ya),m(w,"class","tip"),Ea(c.src,Xn="https://huggingfacejs-chat-template-playground.hf.space")||m(c,"src",Xn),m(c,"frameborder","0"),m(c,"width","850"),m(c,"height","450"),m(d,"class","tip"),m(I,"start","6"),m(C,"start","11")},m(t,l){va(document.head,h),e(t,_l,l),e(t,Yl,l),e(t,Hl,l),o(g,t,l),e(t,Ll,l),o(b,t,l),e(t,Dl,l),e(t,f,l),e(t,Pl,l),o(B,t,l),e(t,Kl,l),e(t,N,l),e(t,Ol,l),e(t,A,l),e(t,ts,l),e(t,Z,l),e(t,ls,l),o(q,t,l),e(t,ss,l),e(t,Q,l),e(t,es,l),e(t,G,l),e(t,ns,l),e(t,$,l),e(t,as,l),e(t,w,l),e(t,Ms,l),o(E,t,l),e(t,is,l),e(t,z,l),e(t,os,l),o(R,t,l),e(t,ps,l),e(t,W,l),e(t,ys,l),o(S,t,l),e(t,Us,l),e(t,X,l),e(t,Js,l),e(t,v,l),e(t,rs,l),o(x,t,l),e(t,Ts,l),e(t,k,l),e(t,us,l),o(V,t,l),e(t,js,l),o(Y,t,l),e(t,cs,l),e(t,F,l),e(t,ms,l),e(t,_,l),e(t,hs,l),e(t,c,l),e(t,ws,l),o(H,t,l),e(t,ds,l),e(t,L,l),e(t,Is,l),o(D,t,l),e(t,Cs,l),e(t,P,l),e(t,gs,l),e(t,K,l),e(t,bs,l),o(O,t,l),e(t,fs,l),e(t,tt,l),e(t,Bs,l),e(t,lt,l),e(t,Ns,l),o(st,t,l),e(t,As,l),e(t,et,l),e(t,Zs,l),o(nt,t,l),e(t,qs,l),e(t,at,l),e(t,Qs,l),o(Mt,t,l),e(t,Gs,l),e(t,it,l),e(t,$s,l),o(ot,t,l),e(t,Es,l),e(t,pt,l),e(t,zs,l),o(yt,t,l),e(t,Rs,l),o(Ut,t,l),e(t,Ws,l),e(t,Jt,l),e(t,Ss,l),e(t,rt,l),e(t,Xs,l),e(t,Tt,l),e(t,vs,l),e(t,ut,l),e(t,xs,l),o(jt,t,l),e(t,ks,l),e(t,ct,l),e(t,Vs,l),o(mt,t,l),e(t,Ys,l),e(t,d,l),e(t,Fs,l),o(ht,t,l),e(t,_s,l),e(t,wt,l),e(t,Hs,l),o(dt,t,l),e(t,Ls,l),o(It,t,l),e(t,Ds,l),e(t,Ct,l),e(t,Ps,l),o(gt,t,l),e(t,Ks,l),e(t,bt,l),e(t,Os,l),o(ft,t,l),e(t,te,l),e(t,Bt,l),e(t,le,l),o(Nt,t,l),e(t,se,l),e(t,At,l),e(t,ee,l),o(Zt,t,l),e(t,ne,l),e(t,qt,l),e(t,ae,l),o(Qt,t,l),e(t,Me,l),e(t,Gt,l),e(t,ie,l),o($t,t,l),e(t,oe,l),o(Et,t,l),e(t,pe,l),e(t,zt,l),e(t,ye,l),o(Rt,t,l),e(t,Ue,l),o(Wt,t,l),e(t,Je,l),e(t,St,l),e(t,re,l),o(Xt,t,l),e(t,Te,l),e(t,vt,l),e(t,ue,l),o(xt,t,l),e(t,je,l),e(t,kt,l),e(t,ce,l),o(Vt,t,l),e(t,me,l),o(Yt,t,l),e(t,he,l),e(t,Ft,l),e(t,we,l),o(_t,t,l),e(t,de,l),e(t,Ht,l),e(t,Ie,l),o(Lt,t,l),e(t,Ce,l),o(Dt,t,l),e(t,ge,l),o(Pt,t,l),e(t,be,l),e(t,Kt,l),e(t,fe,l),o(Ot,t,l),e(t,Be,l),o(tl,t,l),e(t,Ne,l),e(t,ll,l),e(t,Ae,l),o(sl,t,l),e(t,Ze,l),o(el,t,l),e(t,qe,l),o(nl,t,l),e(t,Qe,l),o(al,t,l),e(t,Ge,l),e(t,Ml,l),e(t,$e,l),o(il,t,l),e(t,Ee,l),o(ol,t,l),e(t,ze,l),o(pl,t,l),e(t,Re,l),o(yl,t,l),e(t,We,l),e(t,Ul,l),e(t,Se,l),o(Jl,t,l),e(t,Xe,l),o(rl,t,l),e(t,ve,l),o(Tl,t,l),e(t,xe,l),o(ul,t,l),e(t,ke,l),o(jl,t,l),e(t,Ve,l),o(cl,t,l),e(t,Ye,l),o(ml,t,l),e(t,Fe,l),e(t,hl,l),e(t,_e,l),o(wl,t,l),e(t,He,l),e(t,dl,l),e(t,Le,l),o(Il,t,l),e(t,De,l),e(t,I,l),e(t,Pe,l),o(Cl,t,l),e(t,Ke,l),e(t,C,l),e(t,Oe,l),o(gl,t,l),e(t,tn,l),e(t,bl,l),e(t,ln,l),o(fl,t,l),e(t,sn,l),e(t,Bl,l),e(t,en,l),o(Nl,t,l),e(t,nn,l),e(t,Al,l),e(t,an,l),e(t,Zl,l),e(t,Mn,l),e(t,ql,l),e(t,on,l),o(Ql,t,l),e(t,pn,l),e(t,Gl,l),e(t,yn,l),e(t,$l,l),e(t,Un,l),o(El,t,l),e(t,Jn,l),o(zl,t,l),e(t,rn,l),e(t,Rl,l),e(t,Tn,l),o(Wl,t,l),e(t,un,l),e(t,Sl,l),e(t,jn,l),o(Xl,t,l),e(t,cn,l),e(t,vl,l),e(t,mn,l),o(xl,t,l),e(t,hn,l),e(t,kl,l),e(t,wn,l),o(Vl,t,l),e(t,dn,l),e(t,Fl,l),In=!0},p:za,i(t){In||(p(g.$$.fragment,t),p(b.$$.fragment,t),p(B.$$.fragment,t),p(q.$$.fragment,t),p(E.$$.fragment,t),p(R.$$.fragment,t),p(S.$$.fragment,t),p(x.$$.fragment,t),p(V.$$.fragment,t),p(Y.$$.fragment,t),p(H.$$.fragment,t),p(D.$$.fragment,t),p(O.$$.fragment,t),p(st.$$.fragment,t),p(nt.$$.fragment,t),p(Mt.$$.fragment,t),p(ot.$$.fragment,t),p(yt.$$.fragment,t),p(Ut.$$.fragment,t),p(jt.$$.fragment,t),p(mt.$$.fragment,t),p(ht.$$.fragment,t),p(dt.$$.fragment,t),p(It.$$.fragment,t),p(gt.$$.fragment,t),p(ft.$$.fragment,t),p(Nt.$$.fragment,t),p(Zt.$$.fragment,t),p(Qt.$$.fragment,t),p($t.$$.fragment,t),p(Et.$$.fragment,t),p(Rt.$$.fragment,t),p(Wt.$$.fragment,t),p(Xt.$$.fragment,t),p(xt.$$.fragment,t),p(Vt.$$.fragment,t),p(Yt.$$.fragment,t),p(_t.$$.fragment,t),p(Lt.$$.fragment,t),p(Dt.$$.fragment,t),p(Pt.$$.fragment,t),p(Ot.$$.fragment,t),p(tl.$$.fragment,t),p(sl.$$.fragment,t),p(el.$$.fragment,t),p(nl.$$.fragment,t),p(al.$$.fragment,t),p(il.$$.fragment,t),p(ol.$$.fragment,t),p(pl.$$.fragment,t),p(yl.$$.fragment,t),p(Jl.$$.fragment,t),p(rl.$$.fragment,t),p(Tl.$$.fragment,t),p(ul.$$.fragment,t),p(jl.$$.fragment,t),p(cl.$$.fragment,t),p(ml.$$.fragment,t),p(wl.$$.fragment,t),p(Il.$$.fragment,t),p(Cl.$$.fragment,t),p(gl.$$.fragment,t),p(fl.$$.fragment,t),p(Nl.$$.fragment,t),p(Ql.$$.fragment,t),p(El.$$.fragment,t),p(zl.$$.fragment,t),p(Wl.$$.fragment,t),p(Xl.$$.fragment,t),p(xl.$$.fragment,t),p(Vl.$$.fragment,t),In=!0)},o(t){y(g.$$.fragment,t),y(b.$$.fragment,t),y(B.$$.fragment,t),y(q.$$.fragment,t),y(E.$$.fragment,t),y(R.$$.fragment,t),y(S.$$.fragment,t),y(x.$$.fragment,t),y(V.$$.fragment,t),y(Y.$$.fragment,t),y(H.$$.fragment,t),y(D.$$.fragment,t),y(O.$$.fragment,t),y(st.$$.fragment,t),y(nt.$$.fragment,t),y(Mt.$$.fragment,t),y(ot.$$.fragment,t),y(yt.$$.fragment,t),y(Ut.$$.fragment,t),y(jt.$$.fragment,t),y(mt.$$.fragment,t),y(ht.$$.fragment,t),y(dt.$$.fragment,t),y(It.$$.fragment,t),y(gt.$$.fragment,t),y(ft.$$.fragment,t),y(Nt.$$.fragment,t),y(Zt.$$.fragment,t),y(Qt.$$.fragment,t),y($t.$$.fragment,t),y(Et.$$.fragment,t),y(Rt.$$.fragment,t),y(Wt.$$.fragment,t),y(Xt.$$.fragment,t),y(xt.$$.fragment,t),y(Vt.$$.fragment,t),y(Yt.$$.fragment,t),y(_t.$$.fragment,t),y(Lt.$$.fragment,t),y(Dt.$$.fragment,t),y(Pt.$$.fragment,t),y(Ot.$$.fragment,t),y(tl.$$.fragment,t),y(sl.$$.fragment,t),y(el.$$.fragment,t),y(nl.$$.fragment,t),y(al.$$.fragment,t),y(il.$$.fragment,t),y(ol.$$.fragment,t),y(pl.$$.fragment,t),y(yl.$$.fragment,t),y(Jl.$$.fragment,t),y(rl.$$.fragment,t),y(Tl.$$.fragment,t),y(ul.$$.fragment,t),y(jl.$$.fragment,t),y(cl.$$.fragment,t),y(ml.$$.fragment,t),y(wl.$$.fragment,t),y(Il.$$.fragment,t),y(Cl.$$.fragment,t),y(gl.$$.fragment,t),y(fl.$$.fragment,t),y(Nl.$$.fragment,t),y(Ql.$$.fragment,t),y(El.$$.fragment,t),y(zl.$$.fragment,t),y(Wl.$$.fragment,t),y(Xl.$$.fragment,t),y(xl.$$.fragment,t),y(Vl.$$.fragment,t),In=!1},d(t){t&&(s(_l),s(Yl),s(Hl),s(Ll),s(Dl),s(f),s(Pl),s(Kl),s(N),s(Ol),s(A),s(ts),s(Z),s(ls),s(ss),s(Q),s(es),s(G),s(ns),s($),s(as),s(w),s(Ms),s(is),s(z),s(os),s(ps),s(W),s(ys),s(Us),s(X),s(Js),s(v),s(rs),s(Ts),s(k),s(us),s(js),s(cs),s(F),s(ms),s(_),s(hs),s(c),s(ws),s(ds),s(L),s(Is),s(Cs),s(P),s(gs),s(K),s(bs),s(fs),s(tt),s(Bs),s(lt),s(Ns),s(As),s(et),s(Zs),s(qs),s(at),s(Qs),s(Gs),s(it),s($s),s(Es),s(pt),s(zs),s(Rs),s(Ws),s(Jt),s(Ss),s(rt),s(Xs),s(Tt),s(vs),s(ut),s(xs),s(ks),s(ct),s(Vs),s(Ys),s(d),s(Fs),s(_s),s(wt),s(Hs),s(Ls),s(Ds),s(Ct),s(Ps),s(Ks),s(bt),s(Os),s(te),s(Bt),s(le),s(se),s(At),s(ee),s(ne),s(qt),s(ae),s(Me),s(Gt),s(ie),s(oe),s(pe),s(zt),s(ye),s(Ue),s(Je),s(St),s(re),s(Te),s(vt),s(ue),s(je),s(kt),s(ce),s(me),s(he),s(Ft),s(we),s(de),s(Ht),s(Ie),s(Ce),s(ge),s(be),s(Kt),s(fe),s(Be),s(Ne),s(ll),s(Ae),s(Ze),s(qe),s(Qe),s(Ge),s(Ml),s($e),s(Ee),s(ze),s(Re),s(We),s(Ul),s(Se),s(Xe),s(ve),s(xe),s(ke),s(Ve),s(Ye),s(Fe),s(hl),s(_e),s(He),s(dl),s(Le),s(De),s(I),s(Pe),s(Ke),s(C),s(Oe),s(tn),s(bl),s(ln),s(sn),s(Bl),s(en),s(nn),s(Al),s(an),s(Zl),s(Mn),s(ql),s(on),s(pn),s(Gl),s(yn),s($l),s(Un),s(Jn),s(rn),s(Rl),s(Tn),s(un),s(Sl),s(jn),s(cn),s(vl),s(mn),s(hn),s(kl),s(wn),s(dn),s(Fl)),s(h),U(g,t),U(b,t),U(B,t),U(q,t),U(E,t),U(R,t),U(S,t),U(x,t),U(V,t),U(Y,t),U(H,t),U(D,t),U(O,t),U(st,t),U(nt,t),U(Mt,t),U(ot,t),U(yt,t),U(Ut,t),U(jt,t),U(mt,t),U(ht,t),U(dt,t),U(It,t),U(gt,t),U(ft,t),U(Nt,t),U(Zt,t),U(Qt,t),U($t,t),U(Et,t),U(Rt,t),U(Wt,t),U(Xt,t),U(xt,t),U(Vt,t),U(Yt,t),U(_t,t),U(Lt,t),U(Dt,t),U(Pt,t),U(Ot,t),U(tl,t),U(sl,t),U(el,t),U(nl,t),U(al,t),U(il,t),U(ol,t),U(pl,t),U(yl,t),U(Jl,t),U(rl,t),U(Tl,t),U(ul,t),U(jl,t),U(cl,t),U(ml,t),U(wl,t),U(Il,t),U(Cl,t),U(gl,t),U(fl,t),U(Nl,t),U(Ql,t),U(El,t),U(zl,t),U(Wl,t),U(Xl,t),U(xl,t),U(Vl,t)}}}const Ya='{"title":"Chat Templates","local":"chat-templates","sections":[{"title":"Base Models vs Instruct Models","local":"base-models-vs-instruct-models","sections":[{"title":"The Transformation Process","local":"the-transformation-process","sections":[],"depth":3}],"depth":2},{"title":"Pipeline Usage: Automated Chat Processing","local":"pipeline-usage-automated-chat-processing","sections":[{"title":"Advanced Pipeline Usage","local":"advanced-pipeline-usage","sections":[],"depth":3}],"depth":2},{"title":"Understanding SmolLM3’s Chat Template","local":"understanding-smollm3s-chat-template","sections":[{"title":"ChatML Format Structure","local":"chatml-format-structure","sections":[],"depth":3},{"title":"Dual-Mode Reasoning Support","local":"dual-mode-reasoning-support","sections":[],"depth":3}],"depth":2},{"title":"Working with SmolLM3 Chat Templates in Code","local":"working-with-smollm3-chat-templates-in-code","sections":[{"title":"Understanding the Message Structure","local":"understanding-the-message-structure","sections":[],"depth":3}],"depth":2},{"title":"System Messages: Setting the Context","local":"system-messages-setting-the-context","sections":[],"depth":2},{"title":"Multi-Turn Conversations","local":"multi-turn-conversations","sections":[],"depth":2},{"title":"Generation Prompts: Controlling Model Behavior","local":"generation-prompts-controlling-model-behavior","sections":[{"title":"Understanding add_generation_prompt","local":"understanding-addgenerationprompt","sections":[],"depth":3},{"title":"When to Use Generation Prompts","local":"when-to-use-generation-prompts","sections":[],"depth":3}],"depth":2},{"title":"Continuing Final Messages: Advanced Response Control","local":"continuing-final-messages-advanced-response-control","sections":[{"title":"Basic Example","local":"basic-example","sections":[],"depth":3},{"title":"Practical Applications","local":"practical-applications","sections":[],"depth":3},{"title":"Important Notes","local":"important-notes","sections":[],"depth":3}],"depth":2},{"title":"Working with Reasoning Mode","local":"working-with-reasoning-mode","sections":[{"title":"Standard vs Thinking Mode","local":"standard-vs-thinking-mode","sections":[],"depth":3},{"title":"Training with Thinking Mode","local":"training-with-thinking-mode","sections":[],"depth":3}],"depth":2},{"title":"Tool Usage and Function Calling","local":"tool-usage-and-function-calling","sections":[{"title":"Defining Tools","local":"defining-tools","sections":[],"depth":3},{"title":"Chat Templates with Tools","local":"chat-templates-with-tools","sections":[],"depth":3},{"title":"Training with Tool Usage","local":"training-with-tool-usage","sections":[],"depth":3}],"depth":2},{"title":"Advanced Template Customization","local":"advanced-template-customization","sections":[{"title":"Inspecting a Model’s Chat Template","local":"inspecting-a-models-chat-template","sections":[],"depth":3},{"title":"Custom Template Creation","local":"custom-template-creation","sections":[],"depth":3},{"title":"Template Debugging","local":"template-debugging","sections":[],"depth":3}],"depth":2},{"title":"Key Takeaways","local":"key-takeaways","sections":[{"title":"Core Concepts","local":"core-concepts","sections":[],"depth":3},{"title":"Advanced Features","local":"advanced-features","sections":[],"depth":3},{"title":"Training Best Practices","local":"training-best-practices","sections":[],"depth":3},{"title":"Common Pitfalls to Avoid","local":"common-pitfalls-to-avoid","sections":[],"depth":3},{"title":"Production Considerations","local":"production-considerations","sections":[],"depth":3}],"depth":2},{"title":"Beyond Basic Templates: Advanced Topics","local":"beyond-basic-templates-advanced-topics","sections":[],"depth":2},{"title":"Next Steps","local":"next-steps","sections":[],"depth":2},{"title":"Comprehensive Resources and Further Reading","local":"comprehensive-resources-and-further-reading","sections":[{"title":"Official Documentation","local":"official-documentation","sections":[],"depth":3},{"title":"Model and Dataset Resources","local":"model-and-dataset-resources","sections":[],"depth":3},{"title":"Technical References","local":"technical-references","sections":[],"depth":3},{"title":"Community Resources","local":"community-resources","sections":[],"depth":3}],"depth":2}],"depth":1}';function Fa(gn){return Ra(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Pa extends Wa{constructor(h){super(),Sa(this,h,Fa,Va,$a,{})}}export{Pa as component};
