import{s as ya,n as Ma,o as Ta}from"../chunks/scheduler.85c25b89.js";import{S as wa,i as Ca,g as r,s as o,r as p,A as Ua,h as i,f as t,c as l,j as v,u as g,x as d,k as b,y as n,a as s,v as u,d as h,t as _,w as f}from"../chunks/index.c142fe32.js";import{D as M}from"../chunks/Docstring.d3e0bcd1.js";import{C as Gt}from"../chunks/CodeBlock.a5e95a57.js";import{H as ue,E as $a}from"../chunks/EditOnGithub.a592e7aa.js";function Ja(Ht){let U,qe,Ne,Ae,k,Le,N,Qt='<a href="https://huggingface.co/papers/2405.14734" rel="nofollow">Simple Preference Optimization</a> (SimPO) by Yu Meng, Mengzhou Xia, and Danqi Chen proposes a simpler and more effective preference optimization algorithm than DPO without using a reference model. The key designs in SimPO are (1) using length-normalized log likelihood as the implicit reward, and (2) incorporating a target reward margin in the Bradley-Terry ranking objective.',ze,F,Wt='The official code can be found at <a href="https://github.com/princeton-nlp/SimPO" rel="nofollow">princeton-nlp/SimPO</a>.',Be,q,Ee,A,Vt='The SimPO trainer expects a format identical to the <a href="https://huggingface.co/docs/trl/trainer#trl.DPOTrainer" rel="nofollow">DPO trainer</a>, which should include three entries. These entries should be named as follows:',De,L,Zt="<li><code>prompt</code></li> <li><code>chosen</code></li> <li><code>rejected</code></li>",Ge,z,Rt="for example:",He,B,Qe,E,Yt="where the <code>prompt</code> contains the context inputs, <code>chosen</code> contains the corresponding chosen responses and <code>rejected</code> contains the corresponding negative (rejected) responses. Note that a prompt can have multiple responses and this is reflected in the entries being repeated in the dictionary’s value arrays.",We,D,Ve,G,Xt="The SimPO trainer expects a model of <code>AutoModelForCausalLM</code>.",Ze,H,Re,Q,Kt="For a detailed example have a look at the <code>examples/scripts/simpo.py</code> script. At a high level we need to initialize the <code>SimPOTrainer</code> with a <code>model</code> we wish to train. <strong>Note that SimPOTrainer eliminates the need to use the reference model, simplifying the optimization process.</strong>",Ye,W,Xe,V,ea="After this, one can then call:",Ke,Z,et,R,tt,Y,ta="While training and evaluating we record the following reward metrics:",at,X,aa="<li><code>rewards/chosen</code>: the mean log probabilities of the policy model for the chosen responses scaled by beta</li> <li><code>rewards/rejected</code>: the mean log probabilities of the policy model for the rejected responses scaled by beta</li> <li><code>rewards/accuracies</code>: mean of how often the chosen rewards are &gt; than the corresponding rejected rewards</li> <li><code>rewards/margins</code>: the mean difference between the chosen and corresponding rejected rewards</li>",nt,K,ot,m,ee,ft,he,na="Initialize SimPOTrainer.",vt,$,te,bt,_e,oa=`Llama tokenizer does satisfy <code>enc(a + b) = enc(a) + enc(b)</code>.
It does ensure <code>enc(a + b) = enc(a) + enc(a + b)[len(enc(a)):]</code>.
Reference:
<a href="https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257" rel="nofollow">https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257</a>`,yt,w,ae,Mt,fe,la="Run the given model on the given batch of inputs, concatenating the chosen and rejected inputs together.",Tt,ve,ra="We do this to avoid doing two forward passes, because it’s faster for FSDP.",wt,J,ne,Ct,be,ia="Concatenate the chosen and rejected inputs into a single tensor.",Ut,C,oe,$t,ye,sa=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,Jt,Me,ma="Works both with or without labels.",xt,x,le,Ot,Te,da="Compute the log probabilities of the given labels under the given logits.",It,O,re,jt,we,ca="Compute the SimPO loss and other metrics for the given batch of inputs for train or test.",Pt,I,ie,St,Ce,pa="Generate samples from the model and reference model for the given batch of inputs.",kt,j,se,Nt,Ue,ga="Log <code>logs</code> on the various objects watching training, including stored metrics.",Ft,P,me,qt,$e,ua="Compute the SimPO loss for a batch of policy model log probabilities.",At,y,de,Lt,Je,ha="Tokenize a single row from a SimPO specific dataset.",zt,xe,_a=`At this stage, we don’t convert to PyTorch tensors yet; we just handle the truncation
in case the prompt + chosen or prompt + rejected responses is/are too long. First
we truncate the prompt; if we’re still too long, we truncate the chosen/rejected.`,Bt,Oe,fa=`We also create the labels for the chosen/rejected responses, which are of length equal to
the sum of the length of the prompt and the chosen/rejected response, with
label_pad_token_id  for the prompt tokens.`,lt,ce,rt,T,pe,Et,Ie,va='SimPOConfig collects all training arguments related to the <a href="/docs/trl/pr_1725/en/simpo_trainer#trl.SimPOTrainer">SimPOTrainer</a> class.',Dt,je,ba=`Using <code>HfArgumentParser</code> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,it,ge,st,Fe,mt;return k=new ue({props:{title:"SimPO Trainer",local:"simpo-trainer",headingTag:"h1"}}),q=new ue({props:{title:"Expected dataset format",local:"expected-dataset-format",headingTag:"h2"}}),B=new Gt({props:{code:"c2ltcG9fZGF0YXNldF9kaWN0JTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycHJvbXB0JTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaGVsbG8lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJob3clMjBhcmUlMjB5b3UlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJXaGF0JTIwaXMlMjB5b3VyJTIwbmFtZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoYXQlMjBpcyUyMHlvdXIlMjBuYW1lJTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2hpY2glMjBpcyUyMHRoZSUyMGJlc3QlMjBwcm9ncmFtbWluZyUyMGxhbmd1YWdlJTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2hpY2glMjBpcyUyMHRoZSUyMGJlc3QlMjBwcm9ncmFtbWluZyUyMGxhbmd1YWdlJTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2hpY2glMjBpcyUyMHRoZSUyMGJlc3QlMjBwcm9ncmFtbWluZyUyMGxhbmd1YWdlJTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyY2hvc2VuJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaGklMjBuaWNlJTIwdG8lMjBtZWV0JTIweW91JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySSUyMGFtJTIwZmluZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMk15JTIwbmFtZSUyMGlzJTIwTWFyeSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMk15JTIwbmFtZSUyMGlzJTIwTWFyeSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMlB5dGhvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMlB5dGhvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkphdmElMjIlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJyZWplY3RlZCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmxlYXZlJTIwbWUlMjBhbG9uZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkklMjBhbSUyMG5vdCUyMGZpbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJXaGF0cyUyMGl0JTIwdG8lMjB5b3UlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJJJTIwZG9udCUyMGhhdmUlMjBhJTIwbmFtZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkphdmFzY3JpcHQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJDJTJCJTJCJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyQyUyQiUyQiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSU3RA==",highlighted:`simpo_dataset_dict = {
    <span class="hljs-string">&quot;prompt&quot;</span>: [
        <span class="hljs-string">&quot;hello&quot;</span>,
        <span class="hljs-string">&quot;how are you&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
    ],
    <span class="hljs-string">&quot;chosen&quot;</span>: [
        <span class="hljs-string">&quot;hi nice to meet you&quot;</span>,
        <span class="hljs-string">&quot;I am fine&quot;</span>,
        <span class="hljs-string">&quot;My name is Mary&quot;</span>,
        <span class="hljs-string">&quot;My name is Mary&quot;</span>,
        <span class="hljs-string">&quot;Python&quot;</span>,
        <span class="hljs-string">&quot;Python&quot;</span>,
        <span class="hljs-string">&quot;Java&quot;</span>,
    ],
    <span class="hljs-string">&quot;rejected&quot;</span>: [
        <span class="hljs-string">&quot;leave me alone&quot;</span>,
        <span class="hljs-string">&quot;I am not fine&quot;</span>,
        <span class="hljs-string">&quot;Whats it to you?&quot;</span>,
        <span class="hljs-string">&quot;I dont have a name&quot;</span>,
        <span class="hljs-string">&quot;Javascript&quot;</span>,
        <span class="hljs-string">&quot;C++&quot;</span>,
        <span class="hljs-string">&quot;C++&quot;</span>,
    ],
}`,wrap:!1}}),D=new ue({props:{title:"Expected model format",local:"expected-model-format",headingTag:"h2"}}),H=new ue({props:{title:"Using the SimPOTrainer",local:"using-the-simpotrainer",headingTag:"h2"}}),W=new Gt({props:{code:"c2ltcG9fY29uZmlnJTIwJTNEJTIwU2ltUE9Db25maWcoJTBBJTIwJTIwJTIwJTIwYmV0YSUzRDIuNSUyQyUwQSUyMCUyMCUyMCUyMGdhbW1hX2JldGFfcmF0aW8lM0QwLjI1JTJDJTIwJTIzJTIwcmF0aW8lMjBiZXR3ZWVuJTIwdGFyZ2V0JTIwcmV3YXJkJTIwbWFyZ2luJTIwKGdhbW1hKSUyMGFuZCUyMGJldGElMEEpJTBBJTBBc2ltcG9fdHJhaW5lciUyMCUzRCUyMFNpbVBPVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0RzaW1wb19jb25maWclMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdHJhaW5fZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSk=",highlighted:`simpo_config = SimPOConfig(
    beta=<span class="hljs-number">2.5</span>,
    gamma_beta_ratio=<span class="hljs-number">0.25</span>, <span class="hljs-comment"># ratio between target reward margin (gamma) and beta</span>
)

simpo_trainer = SimPOTrainer(
    model,
    args=simpo_config,
    train_dataset=train_dataset,
    tokenizer=tokenizer,
)`,wrap:!1}}),Z=new Gt({props:{code:"c2ltcG9fdHJhaW5lci50cmFpbigp",highlighted:"simpo_trainer.train()",wrap:!1}}),R=new ue({props:{title:"Logging",local:"logging",headingTag:"h2"}}),K=new ue({props:{title:"SimPOTrainer",local:"trl.SimPOTrainer",headingTag:"h2"}}),ee=new M({props:{name:"class trl.SimPOTrainer",anchor:"trl.SimPOTrainer",parameters:[{name:"model",val:": Union = None"},{name:"args",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"}],parametersDescription:[{anchor:"trl.SimPOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.SimPOTrainer.args",description:`<strong>args</strong> (<code>SimPOConfig</code>) &#x2014;
The SimPO config arguments to use for training.`,name:"args"},{anchor:"trl.SimPOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.SimPOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.SimPOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.SimPOTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizerBase</code>) &#x2014;
The tokenizer to use for training. This argument is required if you want to use the default data collator.`,name:"tokenizer"},{anchor:"trl.SimPOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.SimPOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.SimPOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.SimPOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.SimPOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.SimPOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"}],source:"https://github.com/huggingface/trl/blob/vr_1725/trl/trainer/simpo_trainer.py#L57"}}),te=new M({props:{name:"build_tokenized_answer",anchor:"trl.SimPOTrainer.build_tokenized_answer",parameters:[{name:"prompt",val:""},{name:"answer",val:""}],source:"https://github.com/huggingface/trl/blob/vr_1725/trl/trainer/simpo_trainer.py#L316"}}),ae=new M({props:{name:"concatenated_forward",anchor:"trl.SimPOTrainer.concatenated_forward",parameters:[{name:"model",val:": Module"},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/vr_1725/trl/trainer/simpo_trainer.py#L612"}}),ne=new M({props:{name:"concatenated_inputs",anchor:"trl.SimPOTrainer.concatenated_inputs",parameters:[{name:"batch",val:": Dict"},{name:"is_encoder_decoder",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = 0"},{name:"device",val:": Optional = None"}],source:"https://github.com/huggingface/trl/blob/vr_1725/trl/trainer/simpo_trainer.py#L512",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary containing the concatenated inputs under the key ‘concatenated_input_ids’.</p>
`}}),oe=new M({props:{name:"evaluation_loop",anchor:"trl.SimPOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": Optional = None"},{name:"ignore_keys",val:": Optional = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/vr_1725/trl/trainer/simpo_trainer.py#L843"}}),le=new M({props:{name:"get_batch_logps",anchor:"trl.SimPOTrainer.get_batch_logps",parameters:[{name:"logits",val:": FloatTensor"},{name:"labels",val:": LongTensor"},{name:"label_pad_token_id",val:": int = -100"},{name:"is_encoder_decoder",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/vr_1725/trl/trainer/simpo_trainer.py#L666",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape ((batch_size,), (batch_size,)) containing the sum of log probabilities of the given labels under the given logits.</p>
`}}),re=new M({props:{name:"get_batch_loss_metrics",anchor:"trl.SimPOTrainer.get_batch_loss_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"},{name:"train_eval",val:": Literal = 'train'"}],source:"https://github.com/huggingface/trl/blob/vr_1725/trl/trainer/simpo_trainer.py#L699"}}),ie=new M({props:{name:"get_batch_samples",anchor:"trl.SimPOTrainer.get_batch_samples",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/vr_1725/trl/trainer/simpo_trainer.py#L778"}}),se=new M({props:{name:"log",anchor:"trl.SimPOTrainer.log",parameters:[{name:"logs",val:": Dict"}],parametersDescription:[{anchor:"trl.SimPOTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/trl/blob/vr_1725/trl/trainer/simpo_trainer.py#L891"}}),me=new M({props:{name:"simpo_loss",anchor:"trl.SimPOTrainer.simpo_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"}],source:"https://github.com/huggingface/trl/blob/vr_1725/trl/trainer/simpo_trainer.py#L574",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards).
The losses tensor contains the SimPO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of three tensors</p>
`}}),de=new M({props:{name:"tokenize_row",anchor:"trl.SimPOTrainer.tokenize_row",parameters:[{name:"feature",val:""},{name:"model",val:": Union = None"}],source:"https://github.com/huggingface/trl/blob/vr_1725/trl/trainer/simpo_trainer.py#L366"}}),ce=new ue({props:{title:"SimPOConfig",local:"trl.SimPOConfig",headingTag:"h2"}}),pe=new M({props:{name:"class trl.SimPOConfig",anchor:"trl.SimPOConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"eval_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"torch_empty_cache_steps",val:": Optional = None"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Union = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"restore_callback_states_from_checkpoint",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = None"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": Optional = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Union = None"},{name:"deepspeed",val:": Union = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Union = None"},{name:"ddp_find_unused_parameters",val:": Optional = None"},{name:"ddp_bucket_cap_mb",val:": Optional = None"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Union = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"evaluation_strategy",val:": Union = None"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"optim_target_modules",val:": Union = None"},{name:"batch_eval_metrics",val:": bool = False"},{name:"eval_on_start",val:": bool = False"},{name:"use_liger_kernel",val:": Optional = False"},{name:"eval_use_gather_object",val:": Optional = False"},{name:"beta",val:": float = 2.0"},{name:"gamma_beta_ratio",val:": float = 0.25"},{name:"sft_weight",val:": float = 0.0"},{name:"label_smoothing",val:": float = 0.0"},{name:"loss_type",val:": Literal = 'sigmoid'"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": Optional = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"max_length",val:": Optional = None"},{name:"max_prompt_length",val:": Optional = None"},{name:"max_completion_length",val:": Optional = None"},{name:"max_target_length",val:": Optional = None"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"disable_dropout",val:": bool = True"},{name:"generate_during_eval",val:": bool = False"},{name:"dataset_num_proc",val:": Optional = None"},{name:"model_init_kwargs",val:": Optional = None"}],parametersDescription:[{anchor:"trl.SimPOConfig.beta",description:`<strong>beta</strong> (<code>float</code>, <em>optional</em>, defaults to <code>2.0</code>) &#x2014;
Beta factor in SimPO loss.`,name:"beta"},{anchor:"trl.SimPOConfig.gamma_beta_ratio",description:`<strong>gamma_beta_ratio</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.25</code>) &#x2014;
Ratio between the target reward margin (gamma) and beta in SimPO loss.`,name:"gamma_beta_ratio"},{anchor:"trl.SimPOConfig.sft_weight",description:`<strong>sft_weight</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.0</code>) &#x2014;
SFT loss weight added to the SimPO loss (0.0 is not using SFT).`,name:"sft_weight"},{anchor:"trl.SimPOConfig.label_smoothing",description:`<strong>label_smoothing</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.0</code>) &#x2014;
Label smoothing factor.`,name:"label_smoothing"},{anchor:"trl.SimPOConfig.loss_type",description:`<strong>loss_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;sigmoid&quot;</code>) &#x2014;
Type of loss to use. Possible values are:</p>
<ul>
<li><code>&quot;sigmoid&quot;</code>: sigmoid loss from the original <a href="https://huggingface.co/papers/2305.18290" rel="nofollow">DPO</a> paper.</li>
<li><code>&quot;hinge&quot;</code>: hinge loss on the normalized likelihood from the <a href="https://huggingface.co/papers/2305.10425" rel="nofollow">SLiC</a> paper.</li>
</ul>`,name:"loss_type"},{anchor:"trl.SimPOConfig.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to <code>-100</code>) &#x2014;
Label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.SimPOConfig.padding_value",description:`<strong>padding_value</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Padding value if it is different to the tokenizer&#x2019;s pad_token_id.`,name:"padding_value"},{anchor:"trl.SimPOConfig.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;keep_end&quot;</code>) &#x2014;
Truncation mode to use, either <code>&quot;keep_end&quot;</code> or <code>&quot;keep_start&quot;</code>. This argument is required if you want to use the default data collator.`,name:"truncation_mode"},{anchor:"trl.SimPOConfig.max_length",description:`<strong>max_length</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Maximum length of the sequences in the batch. This argument is required if you want to use the default
data collator.`,name:"max_length"},{anchor:"trl.SimPOConfig.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.SimPOConfig.max_completion_length",description:`<strong>max_completion_length</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Maximum length of the target. This argument is required if you want to use the default data collator
and your model is an encoder-decoder.`,name:"max_completion_length"},{anchor:"trl.SimPOConfig.max_target_length",description:`<strong>max_target_length</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Maximum length of the target. This argument is required if you want to use the default data collator
and your model is an encoder-decoder.`,name:"max_target_length"},{anchor:"trl.SimPOConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>Optional[bool]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If no model is provided, we need to know if the model_init returns an encoder-decoder.`,name:"is_encoder_decoder"},{anchor:"trl.SimPOConfig.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to disable dropouts in <code>model</code>.`,name:"disable_dropout"},{anchor:"trl.SimPOConfig.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to sample and log generations during evaluation step.`,name:"generate_during_eval"},{anchor:"trl.SimPOConfig.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Number of processes to use for processing the datasets.`,name:"dataset_num_proc"},{anchor:"trl.SimPOConfig.model_init_kwargs",description:`<strong>model_init_kwargs</strong> (<code>Optional[Dict[str, Any]]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Dict of optional kwargs to pass when instantiating the model from a string`,name:"model_init_kwargs"}],source:"https://github.com/huggingface/trl/blob/vr_1725/trl/trainer/simpo_config.py#L20"}}),ge=new $a({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/simpo_trainer.mdx"}}),{c(){U=r("meta"),qe=o(),Ne=r("p"),Ae=o(),p(k.$$.fragment),Le=o(),N=r("p"),N.innerHTML=Qt,ze=o(),F=r("p"),F.innerHTML=Wt,Be=o(),p(q.$$.fragment),Ee=o(),A=r("p"),A.innerHTML=Vt,De=o(),L=r("ul"),L.innerHTML=Zt,Ge=o(),z=r("p"),z.textContent=Rt,He=o(),p(B.$$.fragment),Qe=o(),E=r("p"),E.innerHTML=Yt,We=o(),p(D.$$.fragment),Ve=o(),G=r("p"),G.innerHTML=Xt,Ze=o(),p(H.$$.fragment),Re=o(),Q=r("p"),Q.innerHTML=Kt,Ye=o(),p(W.$$.fragment),Xe=o(),V=r("p"),V.textContent=ea,Ke=o(),p(Z.$$.fragment),et=o(),p(R.$$.fragment),tt=o(),Y=r("p"),Y.textContent=ta,at=o(),X=r("ul"),X.innerHTML=aa,nt=o(),p(K.$$.fragment),ot=o(),m=r("div"),p(ee.$$.fragment),ft=o(),he=r("p"),he.textContent=na,vt=o(),$=r("div"),p(te.$$.fragment),bt=o(),_e=r("p"),_e.innerHTML=oa,yt=o(),w=r("div"),p(ae.$$.fragment),Mt=o(),fe=r("p"),fe.textContent=la,Tt=o(),ve=r("p"),ve.textContent=ra,wt=o(),J=r("div"),p(ne.$$.fragment),Ct=o(),be=r("p"),be.textContent=ia,Ut=o(),C=r("div"),p(oe.$$.fragment),$t=o(),ye=r("p"),ye.innerHTML=sa,Jt=o(),Me=r("p"),Me.textContent=ma,xt=o(),x=r("div"),p(le.$$.fragment),Ot=o(),Te=r("p"),Te.textContent=da,It=o(),O=r("div"),p(re.$$.fragment),jt=o(),we=r("p"),we.textContent=ca,Pt=o(),I=r("div"),p(ie.$$.fragment),St=o(),Ce=r("p"),Ce.textContent=pa,kt=o(),j=r("div"),p(se.$$.fragment),Nt=o(),Ue=r("p"),Ue.innerHTML=ga,Ft=o(),P=r("div"),p(me.$$.fragment),qt=o(),$e=r("p"),$e.textContent=ua,At=o(),y=r("div"),p(de.$$.fragment),Lt=o(),Je=r("p"),Je.textContent=ha,zt=o(),xe=r("p"),xe.textContent=_a,Bt=o(),Oe=r("p"),Oe.textContent=fa,lt=o(),p(ce.$$.fragment),rt=o(),T=r("div"),p(pe.$$.fragment),Et=o(),Ie=r("p"),Ie.innerHTML=va,Dt=o(),je=r("p"),je.innerHTML=ba,it=o(),p(ge.$$.fragment),st=o(),Fe=r("p"),this.h()},l(e){const a=Ua("svelte-u9bgzb",document.head);U=i(a,"META",{name:!0,content:!0}),a.forEach(t),qe=l(e),Ne=i(e,"P",{}),v(Ne).forEach(t),Ae=l(e),g(k.$$.fragment,e),Le=l(e),N=i(e,"P",{"data-svelte-h":!0}),d(N)!=="svelte-6eisf0"&&(N.innerHTML=Qt),ze=l(e),F=i(e,"P",{"data-svelte-h":!0}),d(F)!=="svelte-987iu0"&&(F.innerHTML=Wt),Be=l(e),g(q.$$.fragment,e),Ee=l(e),A=i(e,"P",{"data-svelte-h":!0}),d(A)!=="svelte-rhhxzl"&&(A.innerHTML=Vt),De=l(e),L=i(e,"UL",{"data-svelte-h":!0}),d(L)!=="svelte-17vxuta"&&(L.innerHTML=Zt),Ge=l(e),z=i(e,"P",{"data-svelte-h":!0}),d(z)!=="svelte-1gl9mvz"&&(z.textContent=Rt),He=l(e),g(B.$$.fragment,e),Qe=l(e),E=i(e,"P",{"data-svelte-h":!0}),d(E)!=="svelte-74izzd"&&(E.innerHTML=Yt),We=l(e),g(D.$$.fragment,e),Ve=l(e),G=i(e,"P",{"data-svelte-h":!0}),d(G)!=="svelte-34e9qr"&&(G.innerHTML=Xt),Ze=l(e),g(H.$$.fragment,e),Re=l(e),Q=i(e,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-1yxxcit"&&(Q.innerHTML=Kt),Ye=l(e),g(W.$$.fragment,e),Xe=l(e),V=i(e,"P",{"data-svelte-h":!0}),d(V)!=="svelte-6gmkyr"&&(V.textContent=ea),Ke=l(e),g(Z.$$.fragment,e),et=l(e),g(R.$$.fragment,e),tt=l(e),Y=i(e,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-132s7j9"&&(Y.textContent=ta),at=l(e),X=i(e,"UL",{"data-svelte-h":!0}),d(X)!=="svelte-r3mtou"&&(X.innerHTML=aa),nt=l(e),g(K.$$.fragment,e),ot=l(e),m=i(e,"DIV",{class:!0});var c=v(m);g(ee.$$.fragment,c),ft=l(c),he=i(c,"P",{"data-svelte-h":!0}),d(he)!=="svelte-1ex0spb"&&(he.textContent=na),vt=l(c),$=i(c,"DIV",{class:!0});var dt=v($);g(te.$$.fragment,dt),bt=l(dt),_e=i(dt,"P",{"data-svelte-h":!0}),d(_e)!=="svelte-mcz8nm"&&(_e.innerHTML=oa),dt.forEach(t),yt=l(c),w=i(c,"DIV",{class:!0});var Pe=v(w);g(ae.$$.fragment,Pe),Mt=l(Pe),fe=i(Pe,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-16i1nac"&&(fe.textContent=la),Tt=l(Pe),ve=i(Pe,"P",{"data-svelte-h":!0}),d(ve)!=="svelte-tgti68"&&(ve.textContent=ra),Pe.forEach(t),wt=l(c),J=i(c,"DIV",{class:!0});var ct=v(J);g(ne.$$.fragment,ct),Ct=l(ct),be=i(ct,"P",{"data-svelte-h":!0}),d(be)!=="svelte-1cvsgkk"&&(be.textContent=ia),ct.forEach(t),Ut=l(c),C=i(c,"DIV",{class:!0});var Se=v(C);g(oe.$$.fragment,Se),$t=l(Se),ye=i(Se,"P",{"data-svelte-h":!0}),d(ye)!=="svelte-8qlty5"&&(ye.innerHTML=sa),Jt=l(Se),Me=i(Se,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-1tyo99t"&&(Me.textContent=ma),Se.forEach(t),xt=l(c),x=i(c,"DIV",{class:!0});var pt=v(x);g(le.$$.fragment,pt),Ot=l(pt),Te=i(pt,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-4nmimv"&&(Te.textContent=da),pt.forEach(t),It=l(c),O=i(c,"DIV",{class:!0});var gt=v(O);g(re.$$.fragment,gt),jt=l(gt),we=i(gt,"P",{"data-svelte-h":!0}),d(we)!=="svelte-1619teu"&&(we.textContent=ca),gt.forEach(t),Pt=l(c),I=i(c,"DIV",{class:!0});var ut=v(I);g(ie.$$.fragment,ut),St=l(ut),Ce=i(ut,"P",{"data-svelte-h":!0}),d(Ce)!=="svelte-18uwvbi"&&(Ce.textContent=pa),ut.forEach(t),kt=l(c),j=i(c,"DIV",{class:!0});var ht=v(j);g(se.$$.fragment,ht),Nt=l(ht),Ue=i(ht,"P",{"data-svelte-h":!0}),d(Ue)!=="svelte-nqksfz"&&(Ue.innerHTML=ga),ht.forEach(t),Ft=l(c),P=i(c,"DIV",{class:!0});var _t=v(P);g(me.$$.fragment,_t),qt=l(_t),$e=i(_t,"P",{"data-svelte-h":!0}),d($e)!=="svelte-1jir03k"&&($e.textContent=ua),_t.forEach(t),At=l(c),y=i(c,"DIV",{class:!0});var S=v(y);g(de.$$.fragment,S),Lt=l(S),Je=i(S,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-1u4obef"&&(Je.textContent=ha),zt=l(S),xe=i(S,"P",{"data-svelte-h":!0}),d(xe)!=="svelte-1mn1gnw"&&(xe.textContent=_a),Bt=l(S),Oe=i(S,"P",{"data-svelte-h":!0}),d(Oe)!=="svelte-1xvpyih"&&(Oe.textContent=fa),S.forEach(t),c.forEach(t),lt=l(e),g(ce.$$.fragment,e),rt=l(e),T=i(e,"DIV",{class:!0});var ke=v(T);g(pe.$$.fragment,ke),Et=l(ke),Ie=i(ke,"P",{"data-svelte-h":!0}),d(Ie)!=="svelte-1mnkl40"&&(Ie.innerHTML=va),Dt=l(ke),je=i(ke,"P",{"data-svelte-h":!0}),d(je)!=="svelte-1xl7jqc"&&(je.innerHTML=ba),ke.forEach(t),it=l(e),g(ge.$$.fragment,e),st=l(e),Fe=i(e,"P",{}),v(Fe).forEach(t),this.h()},h(){b(U,"name","hf:doc:metadata"),b(U,"content",xa),b($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(m,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,a){n(document.head,U),s(e,qe,a),s(e,Ne,a),s(e,Ae,a),u(k,e,a),s(e,Le,a),s(e,N,a),s(e,ze,a),s(e,F,a),s(e,Be,a),u(q,e,a),s(e,Ee,a),s(e,A,a),s(e,De,a),s(e,L,a),s(e,Ge,a),s(e,z,a),s(e,He,a),u(B,e,a),s(e,Qe,a),s(e,E,a),s(e,We,a),u(D,e,a),s(e,Ve,a),s(e,G,a),s(e,Ze,a),u(H,e,a),s(e,Re,a),s(e,Q,a),s(e,Ye,a),u(W,e,a),s(e,Xe,a),s(e,V,a),s(e,Ke,a),u(Z,e,a),s(e,et,a),u(R,e,a),s(e,tt,a),s(e,Y,a),s(e,at,a),s(e,X,a),s(e,nt,a),u(K,e,a),s(e,ot,a),s(e,m,a),u(ee,m,null),n(m,ft),n(m,he),n(m,vt),n(m,$),u(te,$,null),n($,bt),n($,_e),n(m,yt),n(m,w),u(ae,w,null),n(w,Mt),n(w,fe),n(w,Tt),n(w,ve),n(m,wt),n(m,J),u(ne,J,null),n(J,Ct),n(J,be),n(m,Ut),n(m,C),u(oe,C,null),n(C,$t),n(C,ye),n(C,Jt),n(C,Me),n(m,xt),n(m,x),u(le,x,null),n(x,Ot),n(x,Te),n(m,It),n(m,O),u(re,O,null),n(O,jt),n(O,we),n(m,Pt),n(m,I),u(ie,I,null),n(I,St),n(I,Ce),n(m,kt),n(m,j),u(se,j,null),n(j,Nt),n(j,Ue),n(m,Ft),n(m,P),u(me,P,null),n(P,qt),n(P,$e),n(m,At),n(m,y),u(de,y,null),n(y,Lt),n(y,Je),n(y,zt),n(y,xe),n(y,Bt),n(y,Oe),s(e,lt,a),u(ce,e,a),s(e,rt,a),s(e,T,a),u(pe,T,null),n(T,Et),n(T,Ie),n(T,Dt),n(T,je),s(e,it,a),u(ge,e,a),s(e,st,a),s(e,Fe,a),mt=!0},p:Ma,i(e){mt||(h(k.$$.fragment,e),h(q.$$.fragment,e),h(B.$$.fragment,e),h(D.$$.fragment,e),h(H.$$.fragment,e),h(W.$$.fragment,e),h(Z.$$.fragment,e),h(R.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),h(te.$$.fragment,e),h(ae.$$.fragment,e),h(ne.$$.fragment,e),h(oe.$$.fragment,e),h(le.$$.fragment,e),h(re.$$.fragment,e),h(ie.$$.fragment,e),h(se.$$.fragment,e),h(me.$$.fragment,e),h(de.$$.fragment,e),h(ce.$$.fragment,e),h(pe.$$.fragment,e),h(ge.$$.fragment,e),mt=!0)},o(e){_(k.$$.fragment,e),_(q.$$.fragment,e),_(B.$$.fragment,e),_(D.$$.fragment,e),_(H.$$.fragment,e),_(W.$$.fragment,e),_(Z.$$.fragment,e),_(R.$$.fragment,e),_(K.$$.fragment,e),_(ee.$$.fragment,e),_(te.$$.fragment,e),_(ae.$$.fragment,e),_(ne.$$.fragment,e),_(oe.$$.fragment,e),_(le.$$.fragment,e),_(re.$$.fragment,e),_(ie.$$.fragment,e),_(se.$$.fragment,e),_(me.$$.fragment,e),_(de.$$.fragment,e),_(ce.$$.fragment,e),_(pe.$$.fragment,e),_(ge.$$.fragment,e),mt=!1},d(e){e&&(t(qe),t(Ne),t(Ae),t(Le),t(N),t(ze),t(F),t(Be),t(Ee),t(A),t(De),t(L),t(Ge),t(z),t(He),t(Qe),t(E),t(We),t(Ve),t(G),t(Ze),t(Re),t(Q),t(Ye),t(Xe),t(V),t(Ke),t(et),t(tt),t(Y),t(at),t(X),t(nt),t(ot),t(m),t(lt),t(rt),t(T),t(it),t(st),t(Fe)),t(U),f(k,e),f(q,e),f(B,e),f(D,e),f(H,e),f(W,e),f(Z,e),f(R,e),f(K,e),f(ee),f(te),f(ae),f(ne),f(oe),f(le),f(re),f(ie),f(se),f(me),f(de),f(ce,e),f(pe),f(ge,e)}}}const xa='{"title":"SimPO Trainer","local":"simpo-trainer","sections":[{"title":"Expected dataset format","local":"expected-dataset-format","sections":[],"depth":2},{"title":"Expected model format","local":"expected-model-format","sections":[],"depth":2},{"title":"Using the SimPOTrainer","local":"using-the-simpotrainer","sections":[],"depth":2},{"title":"Logging","local":"logging","sections":[],"depth":2},{"title":"SimPOTrainer","local":"trl.SimPOTrainer","sections":[],"depth":2},{"title":"SimPOConfig","local":"trl.SimPOConfig","sections":[],"depth":2}],"depth":1}';function Oa(Ht){return Ta(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Na extends wa{constructor(U){super(),Ca(this,U,Oa,Ja,ya,{})}}export{Na as component};
