import{s as Ue,n as Ie,o as je}from"../chunks/scheduler.d6170356.js";import{S as _e,i as xe,g as i,s,r as m,A as Le,h as o,f as l,c as a,j as Je,u as r,x as p,k as re,y as Ze,a as n,v as c,d as u,t as g,w as h}from"../chunks/index.fcd4cc08.js";import{C as ce}from"../chunks/CodeBlock.7b16bdef.js";import{H as P,E as ke}from"../chunks/EditOnGithub.da2b595c.js";function We(ue){let f,X,V,S,b,Q,w,ge='<a href="https://github.com/mlfoundations/open_clip" rel="nofollow">OpenCLIP</a> is an open-source implementation of OpenAI’s CLIP.',G,y,z,$,he='You can find OpenCLIP models by filtering at the left of the <a href="https://huggingface.co/models?library=open_clip&amp;sort=trending" rel="nofollow">models page</a>.',B,T,fe='OpenCLIP models hosted on the Hub have a model card with useful information about the models. Thanks to OpenCLIP Hugging Face Hub integration, you can load OpenCLIP models with a few lines of code. You can also deploy these models using <a href="https://huggingface.co/inference-endpoints" rel="nofollow">Inference Endpoints</a>.',R,C,A,J,de=`To get started, you can follow the <a href="https://github.com/mlfoundations/open_clip#usage" rel="nofollow">OpenCLIP installation guide</a>.
You can also use the following one-line install through pip:`,N,U,F,I,O,j,Me="All OpenCLIP models can easily be loaded from the Hub:",K,_,q,x,be='Once loaded, you can encode the image and text to do <a href="https://huggingface.co/tasks/zero-shot-image-classification" rel="nofollow">zero-shot image classification</a>:',D,L,ee,Z,we="It outputs the probability of each possible class:",te,k,le,W,ye="If you want to load a specific OpenCLIP model, you can click <code>Use in OpenCLIP</code> in the model card and you will be given a working snippet!",ne,d,$e='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/openclip_repo_light.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/openclip_repo.png"/>',se,M,Te='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/openclip_snippet_light.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/openclip_snippet.png"/>',ae,v,ie,H,Ce='<li>OpenCLIP <a href="https://github.com/mlfoundations/open_clip" rel="nofollow">repository</a></li> <li>OpenCLIP <a href="https://github.com/mlfoundations/open_clip/tree/main/docs" rel="nofollow">docs</a></li> <li>OpenCLIP <a href="https://huggingface.co/models?library=open_clip&amp;sort=trending" rel="nofollow">models in the Hub</a></li>',oe,Y,pe,E,me;return b=new P({props:{title:"Using OpenCLIP at Hugging Face",local:"using-openclip-at-hugging-face",headingTag:"h1"}}),y=new P({props:{title:"Exploring OpenCLIP on the Hub",local:"exploring-openclip-on-the-hub",headingTag:"h2"}}),C=new P({props:{title:"Installation",local:"installation",headingTag:"h2"}}),U=new ce({props:{code:"JTI0JTIwcGlwJTIwaW5zdGFsbCUyMG9wZW5fY2xpcF90b3JjaA==",highlighted:'$ pip <span class="hljs-keyword">install</span> open_clip_torch',wrap:!1}}),I=new P({props:{title:"Using existing models",local:"using-existing-models",headingTag:"h2"}}),_=new ce({props:{code:"aW1wb3J0JTIwb3Blbl9jbGlwJTBBJTBBbW9kZWwlMkMlMjBwcmVwcm9jZXNzJTIwJTNEJTIwb3Blbl9jbGlwLmNyZWF0ZV9tb2RlbF9mcm9tX3ByZXRyYWluZWQoJ2hmLWh1YiUzQWxhaW9uJTJGQ0xJUC1WaVQtZy0xNC1sYWlvbjJCLXMxMkItYjQySycpJTBBdG9rZW5pemVyJTIwJTNEJTIwb3Blbl9jbGlwLmdldF90b2tlbml6ZXIoJ2hmLWh1YiUzQWxhaW9uJTJGQ0xJUC1WaVQtZy0xNC1sYWlvbjJCLXMxMkItYjQySycp",highlighted:`<span class="hljs-keyword">import</span> open_clip

model, preprocess = open_clip.create_model_from_pretrained(<span class="hljs-string">&#x27;hf-hub:laion/CLIP-ViT-g-14-laion2B-s12B-b42K&#x27;</span>)
tokenizer = open_clip.get_tokenizer(<span class="hljs-string">&#x27;hf-hub:laion/CLIP-ViT-g-14-laion2B-s12B-b42K&#x27;</span>)`,wrap:!1}}),L=new ce({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEElMEF1cmwlMjAlM0QlMjAnaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyclMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFpbWFnZSUyMCUzRCUyMHByZXByb2Nlc3MoaW1hZ2UpLnVuc3F1ZWV6ZSgwKSUwQXRleHQlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIyYSUyMGRpYWdyYW0lMjIlMkMlMjAlMjJhJTIwZG9nJTIyJTJDJTIwJTIyYSUyMGNhdCUyMiU1RCklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTJDJTIwdG9yY2guY3VkYS5hbXAuYXV0b2Nhc3QoKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlX2ZlYXR1cmVzJTIwJTNEJTIwbW9kZWwuZW5jb2RlX2ltYWdlKGltYWdlKSUwQSUyMCUyMCUyMCUyMHRleHRfZmVhdHVyZXMlMjAlM0QlMjBtb2RlbC5lbmNvZGVfdGV4dCh0ZXh0KSUwQSUyMCUyMCUyMCUyMGltYWdlX2ZlYXR1cmVzJTIwJTJGJTNEJTIwaW1hZ2VfZmVhdHVyZXMubm9ybShkaW0lM0QtMSUyQyUyMGtlZXBkaW0lM0RUcnVlKSUwQSUyMCUyMCUyMCUyMHRleHRfZmVhdHVyZXMlMjAlMkYlM0QlMjB0ZXh0X2ZlYXR1cmVzLm5vcm0oZGltJTNELTElMkMlMjBrZWVwZGltJTNEVHJ1ZSklMEElMEElMjAlMjAlMjAlMjB0ZXh0X3Byb2JzJTIwJTNEJTIwKDEwMC4wJTIwKiUyMGltYWdlX2ZlYXR1cmVzJTIwJTQwJTIwdGV4dF9mZWF0dXJlcy5UKS5zb2Z0bWF4KGRpbSUzRC0xKSUwQSUwQXByaW50KCUyMkxhYmVsJTIwcHJvYnMlM0ElMjIlMkMlMjB0ZXh0X3Byb2JzKSUyMA==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

url = <span class="hljs-string">&#x27;http://images.cocodataset.org/val2017/000000039769.jpg&#x27;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
image = preprocess(image).unsqueeze(<span class="hljs-number">0</span>)
text = tokenizer([<span class="hljs-string">&quot;a diagram&quot;</span>, <span class="hljs-string">&quot;a dog&quot;</span>, <span class="hljs-string">&quot;a cat&quot;</span>])

<span class="hljs-keyword">with</span> torch.no_grad(), torch.cuda.amp.autocast():
    image_features = model.encode_image(image)
    text_features = model.encode_text(text)
    image_features /= image_features.norm(dim=-<span class="hljs-number">1</span>, keepdim=<span class="hljs-literal">True</span>)
    text_features /= text_features.norm(dim=-<span class="hljs-number">1</span>, keepdim=<span class="hljs-literal">True</span>)

    text_probs = (<span class="hljs-number">100.0</span> * image_features @ text_features.T).softmax(dim=-<span class="hljs-number">1</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Label probs:&quot;</span>, text_probs) `,wrap:!1}}),k=new ce({props:{code:"TGFiZWwlMjBwcm9icyUzQSUyMHRlbnNvciglNUIlNUIwLjAwMjAlMkMlMjAwLjAwMzQlMkMlMjAwLjk5NDYlNUQlNUQp",highlighted:"Label probs: tensor([[0.0020, 0.0034, 0.9946]])",wrap:!1}}),v=new P({props:{title:"Additional resources",local:"additional-resources",headingTag:"h2"}}),Y=new ke({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/hub/open_clip.md"}}),{c(){f=i("meta"),X=s(),V=i("p"),S=s(),m(b.$$.fragment),Q=s(),w=i("p"),w.innerHTML=ge,G=s(),m(y.$$.fragment),z=s(),$=i("p"),$.innerHTML=he,B=s(),T=i("p"),T.innerHTML=fe,R=s(),m(C.$$.fragment),A=s(),J=i("p"),J.innerHTML=de,N=s(),m(U.$$.fragment),F=s(),m(I.$$.fragment),O=s(),j=i("p"),j.textContent=Me,K=s(),m(_.$$.fragment),q=s(),x=i("p"),x.innerHTML=be,D=s(),m(L.$$.fragment),ee=s(),Z=i("p"),Z.textContent=we,te=s(),m(k.$$.fragment),le=s(),W=i("p"),W.innerHTML=ye,ne=s(),d=i("div"),d.innerHTML=$e,se=s(),M=i("div"),M.innerHTML=Te,ae=s(),m(v.$$.fragment),ie=s(),H=i("ul"),H.innerHTML=Ce,oe=s(),m(Y.$$.fragment),pe=s(),E=i("p"),this.h()},l(e){const t=Le("svelte-u9bgzb",document.head);f=o(t,"META",{name:!0,content:!0}),t.forEach(l),X=a(e),V=o(e,"P",{}),Je(V).forEach(l),S=a(e),r(b.$$.fragment,e),Q=a(e),w=o(e,"P",{"data-svelte-h":!0}),p(w)!=="svelte-1gvreai"&&(w.innerHTML=ge),G=a(e),r(y.$$.fragment,e),z=a(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-5du578"&&($.innerHTML=he),B=a(e),T=o(e,"P",{"data-svelte-h":!0}),p(T)!=="svelte-1s055da"&&(T.innerHTML=fe),R=a(e),r(C.$$.fragment,e),A=a(e),J=o(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-8hku74"&&(J.innerHTML=de),N=a(e),r(U.$$.fragment,e),F=a(e),r(I.$$.fragment,e),O=a(e),j=o(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-c4y4yi"&&(j.textContent=Me),K=a(e),r(_.$$.fragment,e),q=a(e),x=o(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-bfy175"&&(x.innerHTML=be),D=a(e),r(L.$$.fragment,e),ee=a(e),Z=o(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-162gbom"&&(Z.textContent=we),te=a(e),r(k.$$.fragment,e),le=a(e),W=o(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1vnus6m"&&(W.innerHTML=ye),ne=a(e),d=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(d)!=="svelte-qq7za1"&&(d.innerHTML=$e),se=a(e),M=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(M)!=="svelte-1btvat9"&&(M.innerHTML=Te),ae=a(e),r(v.$$.fragment,e),ie=a(e),H=o(e,"UL",{"data-svelte-h":!0}),p(H)!=="svelte-hsv1q9"&&(H.innerHTML=Ce),oe=a(e),r(Y.$$.fragment,e),pe=a(e),E=o(e,"P",{}),Je(E).forEach(l),this.h()},h(){re(f,"name","hf:doc:metadata"),re(f,"content",ve),re(d,"class","flex justify-center"),re(M,"class","flex justify-center")},m(e,t){Ze(document.head,f),n(e,X,t),n(e,V,t),n(e,S,t),c(b,e,t),n(e,Q,t),n(e,w,t),n(e,G,t),c(y,e,t),n(e,z,t),n(e,$,t),n(e,B,t),n(e,T,t),n(e,R,t),c(C,e,t),n(e,A,t),n(e,J,t),n(e,N,t),c(U,e,t),n(e,F,t),c(I,e,t),n(e,O,t),n(e,j,t),n(e,K,t),c(_,e,t),n(e,q,t),n(e,x,t),n(e,D,t),c(L,e,t),n(e,ee,t),n(e,Z,t),n(e,te,t),c(k,e,t),n(e,le,t),n(e,W,t),n(e,ne,t),n(e,d,t),n(e,se,t),n(e,M,t),n(e,ae,t),c(v,e,t),n(e,ie,t),n(e,H,t),n(e,oe,t),c(Y,e,t),n(e,pe,t),n(e,E,t),me=!0},p:Ie,i(e){me||(u(b.$$.fragment,e),u(y.$$.fragment,e),u(C.$$.fragment,e),u(U.$$.fragment,e),u(I.$$.fragment,e),u(_.$$.fragment,e),u(L.$$.fragment,e),u(k.$$.fragment,e),u(v.$$.fragment,e),u(Y.$$.fragment,e),me=!0)},o(e){g(b.$$.fragment,e),g(y.$$.fragment,e),g(C.$$.fragment,e),g(U.$$.fragment,e),g(I.$$.fragment,e),g(_.$$.fragment,e),g(L.$$.fragment,e),g(k.$$.fragment,e),g(v.$$.fragment,e),g(Y.$$.fragment,e),me=!1},d(e){e&&(l(X),l(V),l(S),l(Q),l(w),l(G),l(z),l($),l(B),l(T),l(R),l(A),l(J),l(N),l(F),l(O),l(j),l(K),l(q),l(x),l(D),l(ee),l(Z),l(te),l(le),l(W),l(ne),l(d),l(se),l(M),l(ae),l(ie),l(H),l(oe),l(pe),l(E)),l(f),h(b,e),h(y,e),h(C,e),h(U,e),h(I,e),h(_,e),h(L,e),h(k,e),h(v,e),h(Y,e)}}}const ve='{"title":"Using OpenCLIP at Hugging Face","local":"using-openclip-at-hugging-face","sections":[{"title":"Exploring OpenCLIP on the Hub","local":"exploring-openclip-on-the-hub","sections":[],"depth":2},{"title":"Installation","local":"installation","sections":[],"depth":2},{"title":"Using existing models","local":"using-existing-models","sections":[],"depth":2},{"title":"Additional resources","local":"additional-resources","sections":[],"depth":2}],"depth":1}';function He(ue){return je(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xe extends _e{constructor(f){super(),xe(this,f,He,We,Ue,{})}}export{Xe as component};
