import{s as Ne,f as We,n as Re,o as Ee}from"../chunks/scheduler.f6b352c8.js";import{S as Fe,i as Ve,g as i,s as n,r as h,A as Ae,h as p,f as e,c as a,j as Ss,u,x as o,k as Ls,y as Ps,a as l,v as r,d as c,t as M,w as y}from"../chunks/index.7f38e934.js";import{C as w}from"../chunks/CodeBlock.2a338b68.js";import{H as Os}from"../chunks/Heading.333929c4.js";import{E as Qe}from"../chunks/EditOnGithub.c3245a01.js";function ze(Ds){let j,Ct,$t,vt,d,xt,T,Ks,Xt,b,te="This course is framework-agnostic because we want to <strong>focus on the concepts of AI agents and avoid getting bogged down in the specifics of a particular framework</strong>.",Zt,J,se="Also, we want students to be able to use the concepts they learn in this course in their own projects, using any framework they like.",qt,f,ee="Therefore, for this Unit 1, we will use a dummy agent library and a simple serverless API to access our LLM engine.",Yt,U,le="You probably wouldn’t use these in production, but they will serve as a good <strong>starting point for understanding how agents work</strong>.",Nt,g,ne="After this section, you’ll be ready to <strong>create a simple Agent</strong> using <code>smolagents</code>",Wt,B,ae="And in the following Units we will also use other AI Agent libraries like <code>LangGraph</code>, <code>LangChain</code>, and <code>LlamaIndex</code>.",Rt,I,ie="To keep things simple we will use a simple Python function as a Tool and Agent.",Et,_,pe="We will use built-in Python packages like <code>datetime</code> and <code>os</code> so that you can try it out in any environment.",Ft,k,oe='You can follow the process <a href="https://huggingface.co/agents-course/notebooks/blob/main/dummy_agent_library.ipynb" rel="nofollow">in this notebook</a> and <strong>run the code yourself</strong>.',Vt,$,At,G,he="In the Hugging Face ecosystem, there is a convenient feature called Serverless API that allows you to easily run inference on many models. There’s no installation or deployment required.",Qt,C,zt,v,Lt,x,ue="output:",Ht,X,St,Z,re="As seen in the LLM section, if we just do decoding, <strong>the model will only stop when it predicts an EOS token</strong>, and this does not happen here because this is a conversational (chat) model and <strong>we didn’t apply the chat template it expects</strong>.",Pt,q,ce='If we now add the special tokens related to the <a href="https://huggingface.co/meta-llama/Llama-3.2-3B-Instruct">Llama-3.2-3B-Instruct model</a> that we’re using, the behavior changes and it now produces the expected EOS.',Ot,Y,Dt,N,Me="output:",Kt,W,ts,R,ye="Using the “chat” method is a much more convenient and reliable way to apply chat templates:",ss,E,es,F,we="output:",ls,V,ns,A,je="The chat method is the RECOMMENDED method to use in order to ensure a smooth transition between models, but since this notebook is only educational, we will keep using the “text_generation” method to understand the details.",as,Q,is,z,me="In the previous sections, we saw that the core of an agent library is to append information in the system prompt.",ps,L,de="This system prompt is a bit more complex than the one we saw earlier, but it already contains:",os,H,Te="<li><strong>Information about the tools</strong></li> <li><strong>Cycle instructions</strong> (Thought → Action → Observation)</li>",hs,S,us,P,be="Since we are running the “text_generation” method, we need to apply the prompt manually:",rs,O,cs,D,Je="We can also do it like this, which is what happens inside the <code>chat</code> method :",Ms,K,ys,tt,fe="The prompt now is :",ws,st,js,et,Ue="Let’s decode!",ms,lt,ds,nt,ge="output:",Ts,at,bs,it,Be=`{
“action”: “get_weather”,
“action”: {“location”: “London”}
}`,Js,pt,fs,ot,Ie="Do you see the issue?",Us,m,kt,_e=`The answer was hallucinated by the model. We need to stop to actually execute the function!
Let’s now stop on “Observation” so that we don’t hallucinate the actual function response`,Hs,ht,gs,ut,ke="print(output)",Bs,rt,Is,ct,$e="Action:",_s,Mt,ks,yt,Ge=`Thought: I will check the weather in London.
Observation:`,$s,wt,Ce=`Much Better!
Let’s now create a dummy get weather function.  In a real situation, you would likely call an API.`,Gs,jt,Cs,mt,ve="output:",vs,dt,xs,Tt,xe="Let’s concatenate the base prompt, the completion until function execution and the result of the function as an Observation and resume generation.",Xs,bt,Zs,Jt,Xe="Here is the new prompt:",qs,ft,Ys,Ut,Ze="Output:",Ns,gt,Ws,Rs,Es,Bt,qe="We learned how we can create Agents from scratch using Python code, and we <strong>saw just how tedious that process can be</strong>. Fortunately, many Agent libraries simplify this work by handling much of the heavy lifting for you.",Fs,It,Ye="Now, we’re ready <strong>to create our first real Agent</strong> using the <code>smolagents</code> library.",Vs,_t,As,Gt,Qs;return d=new Os({props:{title:"Dummy Agent Library",local:"dummy-agent-library",headingTag:"h1"}}),$=new Os({props:{title:"Serverless API",local:"serverless-api",headingTag:"h2"}}),C=new w({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwSW5mZXJlbmNlQ2xpZW50JTBBJTBBJTIzJTIzJTIwWW91JTIwbmVlZCUyMGElMjB0b2tlbiUyMGZyb20lMjBodHRwcyUzQSUyRiUyRmhmLmNvJTJGc2V0dGluZ3MlMkZ0b2tlbnMuJTIwSWYlMjB5b3UlMjBydW4lMjB0aGlzJTIwb24lMjBHb29nbGUlMjBDb2xhYiUyQyUyMHlvdSUyMGNhbiUyMHNldCUyMGl0JTIwdXAlMjBpbiUyMHRoZSUyMCUyMnNldHRpbmdzJTIyJTIwdGFiJTIwdW5kZXIlMjAlMjJzZWNyZXRzJTIyLiUyME1ha2UlMjBzdXJlJTIwdG8lMjBjYWxsJTIwaXQlMjAlMjJIRl9UT0tFTiUyMiUwQW9zLmVudmlyb24lNUIlMjJIRl9UT0tFTiUyMiU1RCUzRCUyMmhmX3h4eHh4eHh4eHh4eHh4JTIyJTBBJTBBY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCUyMm1ldGEtbGxhbWElMkZMbGFtYS0zLjItM0ItSW5zdHJ1Y3QlMjIpJTBBJTIzJTIwaWYlMjB0aGUlMjBvdXRwdXRzJTIwZm9yJTIwbmV4dCUyMGNlbGxzJTIwYXJlJTIwd3JvbmclMkMlMjB0aGUlMjBmcmVlJTIwbW9kZWwlMjBtYXklMjBiZSUyMG92ZXJsb2FkZWQuJTIwWW91JTIwY2FuJTIwYWxzbyUyMHVzZSUyMHRoaXMlMjBwdWJsaWMlMjBlbmRwb2ludCUyMHRoYXQlMjBjb250YWlucyUyMExsYW1hLTMuMi0zQi1JbnN0cnVjdCUwQSUyMyUyMGNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMjJodHRwcyUzQSUyRiUyRmpjMjZtd2cyMjhta2o4ZHcudXMtZWFzdC0xLmF3cy5lbmRwb2ludHMuaHVnZ2luZ2ZhY2UuY2xvdWQlMjIp",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

<span class="hljs-comment">## You need a token from https://hf.co/settings/tokens. If you run this on Google Colab, you can set it up in the &quot;settings&quot; tab under &quot;secrets&quot;. Make sure to call it &quot;HF_TOKEN&quot;</span>
os.environ[<span class="hljs-string">&quot;HF_TOKEN&quot;</span>]=<span class="hljs-string">&quot;hf_xxxxxxxxxxxxxx&quot;</span>

client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Llama-3.2-3B-Instruct&quot;</span>)
<span class="hljs-comment"># if the outputs for next cells are wrong, the free model may be overloaded. You can also use this public endpoint that contains Llama-3.2-3B-Instruct</span>
<span class="hljs-comment"># client = InferenceClient(&quot;https://jc26mwg228mkj8dw.us-east-1.aws.endpoints.huggingface.cloud&quot;)</span>`,wrap:!1}}),v=new w({props:{code:"b3V0cHV0JTIwJTNEJTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMEElMjAlMjAlMjAlMjAlMjJUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMiUyQyUwQSUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNEMTAwJTJDJTBBKSUwQSUwQXByaW50KG91dHB1dCk=",highlighted:`output = client.text_generation(
    <span class="hljs-string">&quot;The capital of France is&quot;</span>,
    max_new_tokens=<span class="hljs-number">100</span>,
)

<span class="hljs-built_in">print</span>(output)`,wrap:!1}}),X=new w({props:{code:"UGFyaXMuJTIwVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjBQYXJpcy4lMjBUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMFBhcmlzLiUyMFRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwUGFyaXMuJTIwVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjBQYXJpcy4lMjBUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMFBhcmlzLiUyMFRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwUGFyaXMuJTIwVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjBQYXJpcy4lMjBUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMFBhcmlzLiUyMFRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwUGFyaXMuJTIwVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjBQYXJpcy4lMjBUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMFBhcmlzLiUyMFRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwUGFyaXMuJTIwVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjBQYXJpcy4lMjBUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMFBhcmlzLg==",highlighted:'Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris.',wrap:!1}}),Y=new w({props:{code:"cHJvbXB0JTNEJTIyJTIyJTIyJTNDJTdDYmVnaW5fb2ZfdGV4dCU3QyUzRSUzQyU3Q3N0YXJ0X2hlYWRlcl9pZCU3QyUzRXVzZXIlM0MlN0NlbmRfaGVhZGVyX2lkJTdDJTNFJTBBVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlM0MlN0Nlb3RfaWQlN0MlM0UlM0MlN0NzdGFydF9oZWFkZXJfaWQlN0MlM0Vhc3Npc3RhbnQlM0MlN0NlbmRfaGVhZGVyX2lkJTdDJTNFJTIyJTIyJTIyJTBBb3V0cHV0JTIwJTNEJTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMEElMjAlMjAlMjAlMjBwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDEwMCUyQyUwQSklMEElMEFwcmludChvdXRwdXQp",highlighted:`prompt=<span class="hljs-string">&quot;&quot;&quot;&lt;|begin_of_text|&gt;&lt;|start_header_id|&gt;user&lt;|end_header_id|&gt;
The capital of France is&lt;|eot_id|&gt;&lt;|start_header_id|&gt;assistant&lt;|end_header_id|&gt;&quot;&quot;&quot;</span>
output = client.text_generation(
    prompt,
    max_new_tokens=<span class="hljs-number">100</span>,
)

<span class="hljs-built_in">print</span>(output)`,wrap:!1}}),W=new w({props:{code:"VGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjBQYXJpcy4=",highlighted:'The capital of France <span class="hljs-keyword">is</span> Paris.',wrap:!1}}),E=new w({props:{code:"b3V0cHV0JTIwJTNEJTIwY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjBzdHJlYW0lM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMG1heF90b2tlbnMlM0QxMDI0JTJDJTBBKSUwQXByaW50KG91dHB1dC5jaG9pY2VzJTVCMCU1RC5tZXNzYWdlLmNvbnRlbnQp",highlighted:`output = client.chat.completions.create(
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;The capital of France is&quot;</span>},
    ],
    stream=<span class="hljs-literal">False</span>,
    max_tokens=<span class="hljs-number">1024</span>,
)
<span class="hljs-built_in">print</span>(output.choices[<span class="hljs-number">0</span>].message.content)`,wrap:!1}}),V=new w({props:{code:"UGFyaXMu",highlighted:"Paris.",wrap:!1}}),Q=new Os({props:{title:"Dummy Agent",local:"dummy-agent",headingTag:"h2"}}),S=new w({props:{code:"JTBBJTBBJTBBJTBBJTBBJTBBJTBBJTBBKHRoaXMlMjBUaG91Z2h0JTJGQWN0aW9uJTJGT2JzZXJ2YXRpb24lMjBjYW4lMjByZXBlYXQlMjBOJTIwdGltZXMlMkMlMjB5b3UlMjBzaG91bGQlMjB0YWtlJTIwc2V2ZXJhbCUyMHN0ZXBzJTIwd2hlbiUyMG5lZWRlZC4lMjBUaGUlMjAlMjRKU09OX0JMT0IlMjBtdXN0JTIwYmUlMjBmb3JtYXR0ZWQlMjBhcyUyMG1hcmtkb3duJTIwYW5kJTIwb25seSUyMHVzZSUyMGElMjBTSU5HTEUlMjBhY3Rpb24lMjBhdCUyMGElMjB0aW1lLiklMEElMEElMEE=",highlighted:`Answer the following questions as best you can. You have access to the following tools:

get_weather: Get the current weather in a given location

The way you <span class="hljs-keyword">use</span> the tools is by specifying a json blob.
Specifically, <span class="hljs-keyword">this</span> json should have an \`action\` key (<span class="hljs-keyword">with</span> the name of the tool to <span class="hljs-keyword">use</span>) <span class="hljs-keyword">and</span> an \`action_input\` key (<span class="hljs-keyword">with</span> the <span class="hljs-keyword">input</span> to the tool going here).

The only values that should be in the <span class="hljs-string">&quot;action&quot;</span> field are:
get_weather: Get the current weather in a given location, args: {<span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}}
example <span class="hljs-keyword">use</span> : 

{{
  <span class="hljs-string">&quot;action&quot;</span>: <span class="hljs-string">&quot;get_weather&quot;</span>,
  <span class="hljs-string">&quot;action_input&quot;</span>: {<span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;New York&quot;</span>}
}}

ALWAYS <span class="hljs-keyword">use</span> the following format:

Question: the <span class="hljs-keyword">input</span> question you must answer
Thought: you should <span class="hljs-keyword">always</span> think about one action to take. Only one action at a <span class="hljs-keyword">time</span> in <span class="hljs-keyword">this</span> format:
Action:

$JSON_BLOB (<span class="hljs-keyword">inside</span> markdown <span class="hljs-keyword">cell</span>)

Observation: the result of the action. This Observation is <span class="hljs-keyword">unique</span>, complete, <span class="hljs-keyword">and</span> the source of truth.
... (<span class="hljs-keyword">this</span> Thought/Action/Observation can <span class="hljs-keyword">repeat</span> N times, you should take several steps when needed. The $JSON_BLOB must be formatted as markdown <span class="hljs-keyword">and</span> only <span class="hljs-keyword">use</span> a SINGLE action at a <span class="hljs-keyword">time</span>.)

You must <span class="hljs-keyword">always</span> <span class="hljs-keyword">end</span> your <span class="hljs-keyword">output</span> <span class="hljs-keyword">with</span> the following format:

Thought: I now know the <span class="hljs-keyword">final</span> answer
Final Answer: the <span class="hljs-keyword">final</span> answer to the original <span class="hljs-keyword">input</span> question

Now <span class="hljs-keyword">begin</span>! Reminder to ALWAYS <span class="hljs-keyword">use</span> the exact characters \`Final Answer:\` when you provide a definitive answer.`,wrap:!1}}),O=new w({props:{code:"cHJvbXB0JTNEZiUyMiUyMiUyMiUzQyU3Q2JlZ2luX29mX3RleHQlN0MlM0UlM0MlN0NzdGFydF9oZWFkZXJfaWQlN0MlM0VzeXN0ZW0lM0MlN0NlbmRfaGVhZGVyX2lkJTdDJTNFJTBBJTdCU1lTVEVNX1BST01QVCU3RCUwQSUzQyU3Q2VvdF9pZCU3QyUzRSUzQyU3Q3N0YXJ0X2hlYWRlcl9pZCU3QyUzRXVzZXIlM0MlN0NlbmRfaGVhZGVyX2lkJTdDJTNFJTBBV2hhdCdzJTIwdGhlJTIwd2VhdGhlciUyMGluJTIwTG9uZG9uJTIwJTNGJTBBJTNDJTdDZW90X2lkJTdDJTNFJTNDJTdDc3RhcnRfaGVhZGVyX2lkJTdDJTNFYXNzaXN0YW50JTNDJTdDZW5kX2hlYWRlcl9pZCU3QyUzRSUwQSUyMiUyMiUyMg==",highlighted:`<span class="hljs-attr">prompt</span>=f<span class="hljs-string">&quot;&quot;&quot;&lt;|begin_of_text|&gt;&lt;|start_header_id|&gt;system&lt;|end_header_id|&gt;
{SYSTEM_PROMPT}
&lt;|eot_id|&gt;&lt;|start_header_id|&gt;user&lt;|end_header_id|&gt;
What&#x27;s the weather in London ?
&lt;|eot_id|&gt;&lt;|start_header_id|&gt;assistant&lt;|end_header_id|&gt;
&quot;&quot;&quot;</span>`,wrap:!1}}),K=new w({props:{code:"bWVzc2FnZXMlM0QlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMFNZU1RFTV9QUk9NUFQlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0J3MlMjB0aGUlMjB3ZWF0aGVyJTIwaW4lMjBMb25kb24lMjAlM0YlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlNUQlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1ldGEtbGxhbWElMkZMbGFtYS0zLjItM0ItSW5zdHJ1Y3QlMjIpJTBBJTBBdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzREZhbHNlJTJDYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSk=",highlighted:`messages=[
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: SYSTEM_PROMPT},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What&#x27;s the weather in London ?&quot;</span>},
    ]
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-3.2-3B-Instruct&quot;</span>)

tokenizer.apply_chat_template(messages, <span class="hljs-keyword">tokenize</span>=<span class="hljs-keyword">False</span>,add_generation_prompt=<span class="hljs-keyword">True</span>)`,wrap:!1}}),st=new w({props:{code:"JTBBJTBBJTBBJTBBJTBBJTBBJTBBJTBBKHRoaXMlMjBUaG91Z2h0JTJGQWN0aW9uJTJGT2JzZXJ2YXRpb24lMjBjYW4lMjByZXBlYXQlMjBOJTIwdGltZXMlMkMlMjB5b3UlMjBzaG91bGQlMjB0YWtlJTIwc2V2ZXJhbCUyMHN0ZXBzJTIwd2hlbiUyMG5lZWRlZC4lMjBUaGUlMjAlMjRKU09OX0JMT0IlMjBtdXN0JTIwYmUlMjBmb3JtYXR0ZWQlMjBhcyUyMG1hcmtkb3duJTIwYW5kJTIwb25seSUyMHVzZSUyMGElMjBTSU5HTEUlMjBhY3Rpb24lMjBhdCUyMGElMjB0aW1lLiklMEElMEElMEE=",highlighted:`&lt;|<span class="hljs-type">begin_of_text</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;system</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;
Answer</span> the following questions <span class="hljs-built_in">as</span> best you can. You have access to the following tools:

get_weather: Get the current weather <span class="hljs-built_in">in</span> a given location

The way you use the tools is <span class="hljs-built_in">by</span> specifying a json blob.
Specifically, this json should have an \`action\` key (<span class="hljs-built_in">with</span> the name of the tool to use) and a \`action_input\` key (<span class="hljs-built_in">with</span> the input to the tool going here).

The only values that should be <span class="hljs-built_in">in</span> the <span class="hljs-string">&quot;action&quot;</span> <span class="hljs-built_in">field</span> are:
get_weather: Get the current weather <span class="hljs-built_in">in</span> a given location, args: {<span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}}
example use : 

{{
  <span class="hljs-string">&quot;action&quot;</span>: <span class="hljs-string">&quot;get_weather&quot;</span>,
  <span class="hljs-string">&quot;action_input&quot;</span>: {<span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;New York&quot;</span>}
}}

ALWAYS use the following format:

Question: the input question you must answer
Thought: you should always think about one action to take. Only one action <span class="hljs-built_in">at</span> a <span class="hljs-built_in">time</span> <span class="hljs-built_in">in</span> this format:
Action:

$JSON_BLOB (inside markdown cell)

Observation: the result of the action. This Observation is unique, complete, and the source of truth.
... (this Thought/Action/Observation can <span class="hljs-built_in">repeat</span> N times, you should take several steps when needed. The $JSON_BLOB must be formatted <span class="hljs-built_in">as</span> markdown and only use a SINGLE action <span class="hljs-built_in">at</span> a <span class="hljs-built_in">time</span>.)

You must always <span class="hljs-keyword">end</span> your output <span class="hljs-built_in">with</span> the following format:

Thought: I now know the final answer
Final Answer: the final answer to the original input question

Now begin! Reminder to ALWAYS use the <span class="hljs-built_in">exact</span> characters \`Final Answer:\` when you provide a definitive answer. 
&lt;|<span class="hljs-type">eot_id</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;user</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;
What</span>&#x27;s the weather <span class="hljs-built_in">in</span> London ?
&lt;|<span class="hljs-type">eot_id</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;assistant</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;</span>`,wrap:!1}}),lt=new w({props:{code:"b3V0cHV0JTIwJTNEJTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMEElMjAlMjAlMjAlMjBwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDIwMCUyQyUwQSklMEElMEFwcmludChvdXRwdXQp",highlighted:`output = client.text_generation(
    prompt,
    max_new_tokens=<span class="hljs-number">200</span>,
)

<span class="hljs-built_in">print</span>(output)`,wrap:!1}}),at=new w({props:{code:"QWN0aW9uJTNB",highlighted:'<span class="hljs-symbol">Action:</span>',wrap:!1}}),pt=new w({props:{code:"VGhvdWdodCUzQSUyMEklMjB3aWxsJTIwY2hlY2slMjB0aGUlMjB3ZWF0aGVyJTIwaW4lMjBMb25kb24uJTBBT2JzZXJ2YXRpb24lM0ElMjBUaGUlMjBjdXJyZW50JTIwd2VhdGhlciUyMGluJTIwTG9uZG9uJTIwaXMlMjBtb3N0bHklMjBjbG91ZHklMjB3aXRoJTIwYSUyMGhpZ2glMjBvZiUyMDEyJUMyJUIwQyUyMGFuZCUyMGElMjBsb3clMjBvZiUyMDglQzIlQjBDLg==",highlighted:`Thought: I will<span class="hljs-built_in"> check </span>the weather in London.
Observation: The current weather in London is mostly cloudy with a high of 12°C<span class="hljs-built_in"> and </span>a low of 8°C.`,wrap:!1}}),ht=new w({props:{code:"b3V0cHV0JTIwJTNEJTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMEElMjAlMjAlMjAlMjBwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDIwMCUyQyUwQSUyMCUyMCUyMCUyMHN0b3AlM0QlNUIlMjJPYnNlcnZhdGlvbiUzQSUyMiU1RCUyMCUyMyUyMExldCdzJTIwc3RvcCUyMGJlZm9yZSUyMGFueSUyMGFjdHVhbCUyMGZ1bmN0aW9uJTIwaXMlMjBjYWxsZWQlMEEp",highlighted:`output = client.text_generation(
    prompt,
    max_new_tokens=<span class="hljs-number">200</span>,
    stop=[<span class="hljs-string">&quot;Observation:&quot;</span>] <span class="hljs-comment"># Let&#x27;s stop before any actual function is called</span>
)`,wrap:!1}}),rt=new w({props:{code:"b3V0cHV0JTNB",highlighted:'<span class="hljs-symbol">output:</span>',wrap:!1}}),Mt=new w({props:{code:"JTdCJTBBJTIwJTIwJTIyYWN0aW9uJTIyJTNBJTIwJTIyZ2V0X3dlYXRoZXIlMjIlMkMlMEElMjAlMjAlMjJhY3Rpb24lMjIlM0ElMjAlN0IlMjJsb2NhdGlvbiUyMiUzQSUyMCUyMkxvbmRvbiUyMiU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;action&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;get_weather&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;action&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;location&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;London&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),jt=new w({props:{code:"JTIzRHVtbXklMjBmdW5jdGlvbiUwQWRlZiUyMGdldF93ZWF0aGVyKGxvY2F0aW9uKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGYlMjJ0aGUlMjB3ZWF0aGVyJTIwaW4lMjAlN0Jsb2NhdGlvbiU3RCUyMGlzJTIwc3VubnklMjB3aXRoJTIwbG93JTIwdGVtcGVyYXR1cmVzLiUyMCU1Q24lMjIlMEElMEFnZXRfd2VhdGhlcignTG9uZG9uJyk=",highlighted:`<span class="hljs-comment">#Dummy function</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_weather</span>(<span class="hljs-params">location</span>):
    <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;the weather in <span class="hljs-subst">{location}</span> is sunny with low temperatures. \\n&quot;</span>

get_weather(<span class="hljs-string">&#x27;London&#x27;</span>)`,wrap:!1}}),dt=new w({props:{code:"J3RoZSUyMHdlYXRoZXIlMjBpbiUyMExvbmRvbiUyMGlzJTIwc3VubnklMjB3aXRoJTIwbG93JTIwdGVtcGVyYXR1cmVzLiUyMCU1Q24n",highlighted:'<span class="hljs-symbol">&#x27;the</span> weather <span class="hljs-keyword">in</span> London <span class="hljs-keyword">is</span> sunny <span class="hljs-keyword">with</span> low temperatures. \\n&#x27;',wrap:!1}}),bt=new w({props:{code:"bmV3X3Byb21wdCUzRHByb21wdCUyQm91dHB1dCUyQmdldF93ZWF0aGVyKCdMb25kb24nKSUwQWZpbmFsX291dHB1dCUyMCUzRCUyMGNsaWVudC50ZXh0X2dlbmVyYXRpb24oJTBBJTIwJTIwJTIwJTIwbmV3X3Byb21wdCUyQyUwQSUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNEMjAwJTJDJTBBKSUwQSUwQXByaW50KGZpbmFsX291dHB1dCk=",highlighted:`new_prompt=prompt+output+get_weather(<span class="hljs-string">&#x27;London&#x27;</span>)
final_output = client.text_generation(
    new_prompt,
    max_new_tokens=<span class="hljs-number">200</span>,
)

<span class="hljs-built_in">print</span>(final_output)`,wrap:!1}}),ft=new w({props:{code:"JTBBJTBBJTBBJTBBJTBBJTBBJTBBJTBBKHRoaXMlMjBUaG91Z2h0JTJGQWN0aW9uJTJGT2JzZXJ2YXRpb24lMjBjYW4lMjByZXBlYXQlMjBOJTIwdGltZXMlMkMlMjB5b3UlMjBzaG91bGQlMjB0YWtlJTIwc2V2ZXJhbCUyMHN0ZXBzJTIwd2hlbiUyMG5lZWRlZC4lMjBUaGUlMjAlMjRKU09OX0JMT0IlMjBtdXN0JTIwYmUlMjBmb3JtYXR0ZWQlMjBhcyUyMG1hcmtkb3duJTIwYW5kJTIwb25seSUyMHVzZSUyMGElMjBTSU5HTEUlMjBhY3Rpb24lMjBhdCUyMGElMjB0aW1lLiklMEElMEElMEElMEE=",highlighted:`&lt;|<span class="hljs-type">begin_of_text</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;system</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;
    Answer</span> the following questions <span class="hljs-built_in">as</span> best you can. You have access to the following tools:

get_weather: Get the current weather <span class="hljs-built_in">in</span> a given location

The way you use the tools is <span class="hljs-built_in">by</span> specifying a json blob.
Specifically, this json should have a \`action\` key (<span class="hljs-built_in">with</span> the name of the tool to use) and a \`action_input\` key (<span class="hljs-built_in">with</span> the input to the tool going here).

The only values that should be <span class="hljs-built_in">in</span> the <span class="hljs-string">&quot;action&quot;</span> <span class="hljs-built_in">field</span> are:
get_weather: Get the current weather <span class="hljs-built_in">in</span> a given location, args: {<span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}}
example use : 

{{
  <span class="hljs-string">&quot;action&quot;</span>: <span class="hljs-string">&quot;get_weather&quot;</span>,
  <span class="hljs-string">&quot;action_input&quot;</span>: {<span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;New York&quot;</span>}
}}

ALWAYS use the following format:

Question: the input question you must answer
Thought: you should always think about one action to take. Only one action <span class="hljs-built_in">at</span> a <span class="hljs-built_in">time</span> <span class="hljs-built_in">in</span> this format:
Action:

$JSON_BLOB (inside markdown cell)

Observation: the result of the action. This Observation is unique, complete, and the source of truth.
... (this Thought/Action/Observation can <span class="hljs-built_in">repeat</span> N times, you should take several steps when needed. The $JSON_BLOB must be formatted <span class="hljs-built_in">as</span> markdown and only use a SINGLE action <span class="hljs-built_in">at</span> a <span class="hljs-built_in">time</span>.)

You must always <span class="hljs-keyword">end</span> your output <span class="hljs-built_in">with</span> the following format:

Thought: I now know the final answer
Final Answer: the final answer to the original input question

Now begin! Reminder to ALWAYS use the <span class="hljs-built_in">exact</span> characters \`Final Answer:\` when you provide a definitive answer. 
&lt;|<span class="hljs-type">eot_id</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;user</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;
What</span>&#x27;s the weather <span class="hljs-built_in">in</span> London ?
&lt;|<span class="hljs-type">eot_id</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;assistant</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;

Action</span>:
\`\`\`
{
  <span class="hljs-string">&quot;action&quot;</span>: <span class="hljs-string">&quot;get_weather&quot;</span>,
  <span class="hljs-string">&quot;action&quot;</span>: {<span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>: <span class="hljs-string">&quot;London&quot;</span>}
}
\`\`\`
Thought: I will check the weather <span class="hljs-built_in">in</span> London.
Observation:the weather <span class="hljs-built_in">in</span> London is sunny <span class="hljs-built_in">with</span> low temperatures. `,wrap:!1}}),gt=new w({props:{code:"RmluYWwlMjBBbnN3ZXIlM0ElMjBUaGUlMjB3ZWF0aGVyJTIwaW4lMjBMb25kb24lMjBpcyUyMHN1bm55JTIwd2l0aCUyMGxvdyUyMHRlbXBlcmF0dXJlcy4=",highlighted:'<span class="hljs-keyword">Final</span> Answer: The weather <span class="hljs-keyword">in</span> London <span class="hljs-keyword">is</span> sunny <span class="hljs-keyword">with</span> low temperatures.',wrap:!1}}),_t=new Qe({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit1/dummy-agent-library.mdx"}}),{c(){j=i("meta"),Ct=n(),$t=i("p"),vt=n(),h(d.$$.fragment),xt=n(),T=i("img"),Xt=n(),b=i("p"),b.innerHTML=te,Zt=n(),J=i("p"),J.textContent=se,qt=n(),f=i("p"),f.textContent=ee,Yt=n(),U=i("p"),U.innerHTML=le,Nt=n(),g=i("p"),g.innerHTML=ne,Wt=n(),B=i("p"),B.innerHTML=ae,Rt=n(),I=i("p"),I.textContent=ie,Et=n(),_=i("p"),_.innerHTML=pe,Ft=n(),k=i("p"),k.innerHTML=oe,Vt=n(),h($.$$.fragment),At=n(),G=i("p"),G.textContent=he,Qt=n(),h(C.$$.fragment),zt=n(),h(v.$$.fragment),Lt=n(),x=i("p"),x.textContent=ue,Ht=n(),h(X.$$.fragment),St=n(),Z=i("p"),Z.innerHTML=re,Pt=n(),q=i("p"),q.innerHTML=ce,Ot=n(),h(Y.$$.fragment),Dt=n(),N=i("p"),N.textContent=Me,Kt=n(),h(W.$$.fragment),ts=n(),R=i("p"),R.textContent=ye,ss=n(),h(E.$$.fragment),es=n(),F=i("p"),F.textContent=we,ls=n(),h(V.$$.fragment),ns=n(),A=i("p"),A.textContent=je,as=n(),h(Q.$$.fragment),is=n(),z=i("p"),z.textContent=me,ps=n(),L=i("p"),L.textContent=de,os=n(),H=i("ol"),H.innerHTML=Te,hs=n(),h(S.$$.fragment),us=n(),P=i("p"),P.textContent=be,rs=n(),h(O.$$.fragment),cs=n(),D=i("p"),D.innerHTML=Je,Ms=n(),h(K.$$.fragment),ys=n(),tt=i("p"),tt.textContent=fe,ws=n(),h(st.$$.fragment),js=n(),et=i("p"),et.textContent=Ue,ms=n(),h(lt.$$.fragment),ds=n(),nt=i("p"),nt.textContent=ge,Ts=n(),h(at.$$.fragment),bs=n(),it=i("p"),it.textContent=Be,Js=n(),h(pt.$$.fragment),fs=n(),ot=i("p"),ot.textContent=Ie,Us=n(),m=i("blockquote"),kt=i("p"),kt.textContent=_e,Hs=n(),h(ht.$$.fragment),gs=n(),ut=i("p"),ut.textContent=ke,Bs=n(),h(rt.$$.fragment),Is=n(),ct=i("p"),ct.textContent=$e,_s=n(),h(Mt.$$.fragment),ks=n(),yt=i("p"),yt.textContent=Ge,$s=n(),wt=i("p"),wt.textContent=Ce,Gs=n(),h(jt.$$.fragment),Cs=n(),mt=i("p"),mt.textContent=ve,vs=n(),h(dt.$$.fragment),xs=n(),Tt=i("p"),Tt.textContent=xe,Xs=n(),h(bt.$$.fragment),Zs=n(),Jt=i("p"),Jt.textContent=Xe,qs=n(),h(ft.$$.fragment),Ys=n(),Ut=i("p"),Ut.textContent=Ze,Ns=n(),h(gt.$$.fragment),Ws=n(),Rs=i("hr"),Es=n(),Bt=i("p"),Bt.innerHTML=qe,Fs=n(),It=i("p"),It.innerHTML=Ye,Vs=n(),h(_t.$$.fragment),As=n(),Gt=i("p"),this.h()},l(t){const s=Ae("svelte-u9bgzb",document.head);j=p(s,"META",{name:!0,content:!0}),s.forEach(e),Ct=a(t),$t=p(t,"P",{}),Ss($t).forEach(e),vt=a(t),u(d.$$.fragment,t),xt=a(t),T=p(t,"IMG",{src:!0,alt:!0}),Xt=a(t),b=p(t,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1rwfam6"&&(b.innerHTML=te),Zt=a(t),J=p(t,"P",{"data-svelte-h":!0}),o(J)!=="svelte-1pvln0h"&&(J.textContent=se),qt=a(t),f=p(t,"P",{"data-svelte-h":!0}),o(f)!=="svelte-17n0axy"&&(f.textContent=ee),Yt=a(t),U=p(t,"P",{"data-svelte-h":!0}),o(U)!=="svelte-1ssvh5p"&&(U.innerHTML=le),Nt=a(t),g=p(t,"P",{"data-svelte-h":!0}),o(g)!=="svelte-r0w337"&&(g.innerHTML=ne),Wt=a(t),B=p(t,"P",{"data-svelte-h":!0}),o(B)!=="svelte-9snja6"&&(B.innerHTML=ae),Rt=a(t),I=p(t,"P",{"data-svelte-h":!0}),o(I)!=="svelte-scmak8"&&(I.textContent=ie),Et=a(t),_=p(t,"P",{"data-svelte-h":!0}),o(_)!=="svelte-10qtj1b"&&(_.innerHTML=pe),Ft=a(t),k=p(t,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1fa85bb"&&(k.innerHTML=oe),Vt=a(t),u($.$$.fragment,t),At=a(t),G=p(t,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1y7mhy7"&&(G.textContent=he),Qt=a(t),u(C.$$.fragment,t),zt=a(t),u(v.$$.fragment,t),Lt=a(t),x=p(t,"P",{"data-svelte-h":!0}),o(x)!=="svelte-1wueeet"&&(x.textContent=ue),Ht=a(t),u(X.$$.fragment,t),St=a(t),Z=p(t,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-14l0pz9"&&(Z.innerHTML=re),Pt=a(t),q=p(t,"P",{"data-svelte-h":!0}),o(q)!=="svelte-1891xc3"&&(q.innerHTML=ce),Ot=a(t),u(Y.$$.fragment,t),Dt=a(t),N=p(t,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1wueeet"&&(N.textContent=Me),Kt=a(t),u(W.$$.fragment,t),ts=a(t),R=p(t,"P",{"data-svelte-h":!0}),o(R)!=="svelte-10i9u01"&&(R.textContent=ye),ss=a(t),u(E.$$.fragment,t),es=a(t),F=p(t,"P",{"data-svelte-h":!0}),o(F)!=="svelte-1wueeet"&&(F.textContent=we),ls=a(t),u(V.$$.fragment,t),ns=a(t),A=p(t,"P",{"data-svelte-h":!0}),o(A)!=="svelte-o9oayq"&&(A.textContent=je),as=a(t),u(Q.$$.fragment,t),is=a(t),z=p(t,"P",{"data-svelte-h":!0}),o(z)!=="svelte-xr84ar"&&(z.textContent=me),ps=a(t),L=p(t,"P",{"data-svelte-h":!0}),o(L)!=="svelte-1m7y210"&&(L.textContent=de),os=a(t),H=p(t,"OL",{"data-svelte-h":!0}),o(H)!=="svelte-27sevg"&&(H.innerHTML=Te),hs=a(t),u(S.$$.fragment,t),us=a(t),P=p(t,"P",{"data-svelte-h":!0}),o(P)!=="svelte-1jc27vd"&&(P.textContent=be),rs=a(t),u(O.$$.fragment,t),cs=a(t),D=p(t,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1letw4p"&&(D.innerHTML=Je),Ms=a(t),u(K.$$.fragment,t),ys=a(t),tt=p(t,"P",{"data-svelte-h":!0}),o(tt)!=="svelte-u9o4sn"&&(tt.textContent=fe),ws=a(t),u(st.$$.fragment,t),js=a(t),et=p(t,"P",{"data-svelte-h":!0}),o(et)!=="svelte-18yryy0"&&(et.textContent=Ue),ms=a(t),u(lt.$$.fragment,t),ds=a(t),nt=p(t,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-1wueeet"&&(nt.textContent=ge),Ts=a(t),u(at.$$.fragment,t),bs=a(t),it=p(t,"P",{"data-svelte-h":!0}),o(it)!=="svelte-1u60rex"&&(it.textContent=Be),Js=a(t),u(pt.$$.fragment,t),fs=a(t),ot=p(t,"P",{"data-svelte-h":!0}),o(ot)!=="svelte-azbr52"&&(ot.textContent=Ie),Us=a(t),m=p(t,"BLOCKQUOTE",{});var zs=Ss(m);kt=p(zs,"P",{"data-svelte-h":!0}),o(kt)!=="svelte-eu81gr"&&(kt.textContent=_e),Hs=a(zs),u(ht.$$.fragment,zs),zs.forEach(e),gs=a(t),ut=p(t,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-1yqfqub"&&(ut.textContent=ke),Bs=a(t),u(rt.$$.fragment,t),Is=a(t),ct=p(t,"P",{"data-svelte-h":!0}),o(ct)!=="svelte-a5d62w"&&(ct.textContent=$e),_s=a(t),u(Mt.$$.fragment,t),ks=a(t),yt=p(t,"P",{"data-svelte-h":!0}),o(yt)!=="svelte-1s2rtg2"&&(yt.textContent=Ge),$s=a(t),wt=p(t,"P",{"data-svelte-h":!0}),o(wt)!=="svelte-1ndvzyl"&&(wt.textContent=Ce),Gs=a(t),u(jt.$$.fragment,t),Cs=a(t),mt=p(t,"P",{"data-svelte-h":!0}),o(mt)!=="svelte-1wueeet"&&(mt.textContent=ve),vs=a(t),u(dt.$$.fragment,t),xs=a(t),Tt=p(t,"P",{"data-svelte-h":!0}),o(Tt)!=="svelte-18w5bdv"&&(Tt.textContent=xe),Xs=a(t),u(bt.$$.fragment,t),Zs=a(t),Jt=p(t,"P",{"data-svelte-h":!0}),o(Jt)!=="svelte-smcbfz"&&(Jt.textContent=Xe),qs=a(t),u(ft.$$.fragment,t),Ys=a(t),Ut=p(t,"P",{"data-svelte-h":!0}),o(Ut)!=="svelte-1wuxk0l"&&(Ut.textContent=Ze),Ns=a(t),u(gt.$$.fragment,t),Ws=a(t),Rs=p(t,"HR",{}),Es=a(t),Bt=p(t,"P",{"data-svelte-h":!0}),o(Bt)!=="svelte-1qq5buo"&&(Bt.innerHTML=qe),Fs=a(t),It=p(t,"P",{"data-svelte-h":!0}),o(It)!=="svelte-1ef9lfw"&&(It.innerHTML=Ye),Vs=a(t),u(_t.$$.fragment,t),As=a(t),Gt=p(t,"P",{}),Ss(Gt).forEach(e),this.h()},h(){Ls(j,"name","hf:doc:metadata"),Ls(j,"content",Le),We(T.src,Ks="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/whiteboard-unit1sub3DONE.jpg")||Ls(T,"src",Ks),Ls(T,"alt","Unit 1 planning")},m(t,s){Ps(document.head,j),l(t,Ct,s),l(t,$t,s),l(t,vt,s),r(d,t,s),l(t,xt,s),l(t,T,s),l(t,Xt,s),l(t,b,s),l(t,Zt,s),l(t,J,s),l(t,qt,s),l(t,f,s),l(t,Yt,s),l(t,U,s),l(t,Nt,s),l(t,g,s),l(t,Wt,s),l(t,B,s),l(t,Rt,s),l(t,I,s),l(t,Et,s),l(t,_,s),l(t,Ft,s),l(t,k,s),l(t,Vt,s),r($,t,s),l(t,At,s),l(t,G,s),l(t,Qt,s),r(C,t,s),l(t,zt,s),r(v,t,s),l(t,Lt,s),l(t,x,s),l(t,Ht,s),r(X,t,s),l(t,St,s),l(t,Z,s),l(t,Pt,s),l(t,q,s),l(t,Ot,s),r(Y,t,s),l(t,Dt,s),l(t,N,s),l(t,Kt,s),r(W,t,s),l(t,ts,s),l(t,R,s),l(t,ss,s),r(E,t,s),l(t,es,s),l(t,F,s),l(t,ls,s),r(V,t,s),l(t,ns,s),l(t,A,s),l(t,as,s),r(Q,t,s),l(t,is,s),l(t,z,s),l(t,ps,s),l(t,L,s),l(t,os,s),l(t,H,s),l(t,hs,s),r(S,t,s),l(t,us,s),l(t,P,s),l(t,rs,s),r(O,t,s),l(t,cs,s),l(t,D,s),l(t,Ms,s),r(K,t,s),l(t,ys,s),l(t,tt,s),l(t,ws,s),r(st,t,s),l(t,js,s),l(t,et,s),l(t,ms,s),r(lt,t,s),l(t,ds,s),l(t,nt,s),l(t,Ts,s),r(at,t,s),l(t,bs,s),l(t,it,s),l(t,Js,s),r(pt,t,s),l(t,fs,s),l(t,ot,s),l(t,Us,s),l(t,m,s),Ps(m,kt),Ps(m,Hs),r(ht,m,null),l(t,gs,s),l(t,ut,s),l(t,Bs,s),r(rt,t,s),l(t,Is,s),l(t,ct,s),l(t,_s,s),r(Mt,t,s),l(t,ks,s),l(t,yt,s),l(t,$s,s),l(t,wt,s),l(t,Gs,s),r(jt,t,s),l(t,Cs,s),l(t,mt,s),l(t,vs,s),r(dt,t,s),l(t,xs,s),l(t,Tt,s),l(t,Xs,s),r(bt,t,s),l(t,Zs,s),l(t,Jt,s),l(t,qs,s),r(ft,t,s),l(t,Ys,s),l(t,Ut,s),l(t,Ns,s),r(gt,t,s),l(t,Ws,s),l(t,Rs,s),l(t,Es,s),l(t,Bt,s),l(t,Fs,s),l(t,It,s),l(t,Vs,s),r(_t,t,s),l(t,As,s),l(t,Gt,s),Qs=!0},p:Re,i(t){Qs||(c(d.$$.fragment,t),c($.$$.fragment,t),c(C.$$.fragment,t),c(v.$$.fragment,t),c(X.$$.fragment,t),c(Y.$$.fragment,t),c(W.$$.fragment,t),c(E.$$.fragment,t),c(V.$$.fragment,t),c(Q.$$.fragment,t),c(S.$$.fragment,t),c(O.$$.fragment,t),c(K.$$.fragment,t),c(st.$$.fragment,t),c(lt.$$.fragment,t),c(at.$$.fragment,t),c(pt.$$.fragment,t),c(ht.$$.fragment,t),c(rt.$$.fragment,t),c(Mt.$$.fragment,t),c(jt.$$.fragment,t),c(dt.$$.fragment,t),c(bt.$$.fragment,t),c(ft.$$.fragment,t),c(gt.$$.fragment,t),c(_t.$$.fragment,t),Qs=!0)},o(t){M(d.$$.fragment,t),M($.$$.fragment,t),M(C.$$.fragment,t),M(v.$$.fragment,t),M(X.$$.fragment,t),M(Y.$$.fragment,t),M(W.$$.fragment,t),M(E.$$.fragment,t),M(V.$$.fragment,t),M(Q.$$.fragment,t),M(S.$$.fragment,t),M(O.$$.fragment,t),M(K.$$.fragment,t),M(st.$$.fragment,t),M(lt.$$.fragment,t),M(at.$$.fragment,t),M(pt.$$.fragment,t),M(ht.$$.fragment,t),M(rt.$$.fragment,t),M(Mt.$$.fragment,t),M(jt.$$.fragment,t),M(dt.$$.fragment,t),M(bt.$$.fragment,t),M(ft.$$.fragment,t),M(gt.$$.fragment,t),M(_t.$$.fragment,t),Qs=!1},d(t){t&&(e(Ct),e($t),e(vt),e(xt),e(T),e(Xt),e(b),e(Zt),e(J),e(qt),e(f),e(Yt),e(U),e(Nt),e(g),e(Wt),e(B),e(Rt),e(I),e(Et),e(_),e(Ft),e(k),e(Vt),e(At),e(G),e(Qt),e(zt),e(Lt),e(x),e(Ht),e(St),e(Z),e(Pt),e(q),e(Ot),e(Dt),e(N),e(Kt),e(ts),e(R),e(ss),e(es),e(F),e(ls),e(ns),e(A),e(as),e(is),e(z),e(ps),e(L),e(os),e(H),e(hs),e(us),e(P),e(rs),e(cs),e(D),e(Ms),e(ys),e(tt),e(ws),e(js),e(et),e(ms),e(ds),e(nt),e(Ts),e(bs),e(it),e(Js),e(fs),e(ot),e(Us),e(m),e(gs),e(ut),e(Bs),e(Is),e(ct),e(_s),e(ks),e(yt),e($s),e(wt),e(Gs),e(Cs),e(mt),e(vs),e(xs),e(Tt),e(Xs),e(Zs),e(Jt),e(qs),e(Ys),e(Ut),e(Ns),e(Ws),e(Rs),e(Es),e(Bt),e(Fs),e(It),e(Vs),e(As),e(Gt)),e(j),y(d,t),y($,t),y(C,t),y(v,t),y(X,t),y(Y,t),y(W,t),y(E,t),y(V,t),y(Q,t),y(S,t),y(O,t),y(K,t),y(st,t),y(lt,t),y(at,t),y(pt,t),y(ht),y(rt,t),y(Mt,t),y(jt,t),y(dt,t),y(bt,t),y(ft,t),y(gt,t),y(_t,t)}}}const Le='{"title":"Dummy Agent Library","local":"dummy-agent-library","sections":[{"title":"Serverless API","local":"serverless-api","sections":[],"depth":2},{"title":"Dummy Agent","local":"dummy-agent","sections":[],"depth":2}],"depth":1}';function He(Ds){return Ee(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class tl extends Fe{constructor(j){super(),Ve(this,j,He,ze,Ne,{})}}export{tl as component};
