import{s as qe,f as Ze,n as Ne,o as Ye}from"../chunks/scheduler.f6b352c8.js";import{S as Ee,i as Re,g as i,s as n,r as h,A as We,h as p,f as e,c as a,j as Hs,u,x as o,k as Vs,y as Ss,a as l,v as r,d as c,t as M,w as y}from"../chunks/index.7f38e934.js";import{C as w}from"../chunks/CodeBlock.2a338b68.js";import{H as zs}from"../chunks/Heading.333929c4.js";import{E as Ae}from"../chunks/EditOnGithub.c3245a01.js";function Fe(Ps){let j,Gt,$t,Ct,d,vt,T,Os,xt,J,Ds="This course is framework agnostic because we want to <strong>focus on the concepts of AI agents and avoid getting bogged down in the specifics of a particular framework</strong>.",Xt,b,Ks="Also, we want students to be able to use the concepts they learn in this course in their own projects, using any framework they like.",qt,f,te="Therefore, for this Unit 1, we will use a dummy agent library and a simple serverless API to access our LLM engine.",Zt,g,se="You probably wouldn’t use these in production, but they will serve as a good <strong>starting point for understanding how agents work</strong>.",Nt,U,ee="After this section, you’ll be ready to <strong>create a simple Agent</strong> using <code>smolagents</code>",Yt,B,le="And in the following Units we will also use other AI Agent libraries like <code>LangGraph</code>, <code>LangChain</code>, and <code>LlamaIndex</code>.",Et,I,ne="To keep things simple we will use a simple Python function as a Tool and Agent.",Rt,_,ae="We will use built-in Python packages like <code>datetime</code> and <code>os</code> so that you can try it out in any environment.",Wt,$,ie='You can follow the process <a href="https://huggingface.co/agents-course/notebooks/blob/main/dummy_agent_library.ipynb" rel="nofollow">in this notebook</a> and <strong>run the code yourself</strong>.',At,k,Ft,G,pe="In the Hugging Face ecosystem, there is a convenient feature called Serverless API that allows you to easily run inference on many models. There’s no installation or deployment required.",Qt,C,Vt,v,Lt,x,oe="output:",Ht,X,St,q,he="As seen in the LLM section, if we just do decoding, <strong>the model will only stop when it predicts an EOS token</strong>, and this does not happen here because this is a conversational (chat) model and <strong>we didn’t apply the chat template it expects</strong>.",zt,Z,ue='If we now add the special tokens related to the <a href="https://huggingface.co/meta-llama/Llama-3.2-3B-Instruct">Llama-3.2-3B-Instruct model</a> that we’re using, the behavior changes and it now produces the expected EOS.',Pt,N,Ot,Y,re="output:",Dt,E,Kt,R,ce="Using the “chat” method is a much more convenient and reliable way to apply chat templates:",ts,W,ss,A,Me="output:",es,F,ls,Q,ye="The chat method is the RECOMMENDED method to use in order to ensure a smooth transition between models, but since this notebook is only educational, we will keep using the “text_generation” method to understand the details.",ns,V,as,L,we="In the previous sections, we saw that the core of an agent library is to append information in the system prompt.",is,H,je="This system prompt is a bit more complex than the one we saw earlier, but it already contains:",ps,S,me="<li><strong>Information about the tools</strong></li> <li><strong>Cycle instructions</strong> (Thought → Action → Observation)</li>",os,z,hs,P,de="Since we are running the “text_generation” method, we need to apply the prompt manually:",us,O,rs,D,Te="We can also do it like this, which is what happens inside the <code>chat</code> method :",cs,K,Ms,tt,Je="The prompt now is :",ys,st,ws,et,be="Let’s decode!",js,lt,ms,nt,fe="output:",ds,at,Ts,it,ge=`{
“action”: “get_weather”,
“action”: {“location”: “London”}
}`,Js,pt,bs,ot,Ue="Do you see the issue?",fs,m,_t,Be=`The answer was hallucinated by the model. We need to stop to actually execute the function!
Let’s now stop on “Observation” so that we don’t hallucinate the actual function response`,Ls,ht,gs,ut,Ie="print(output)",Us,rt,Bs,ct,_e="Action:",Is,Mt,_s,yt,$e=`Thought: I will check the weather in London.
Observation:`,$s,wt,ks,jt,ke="output:",Gs,mt,Cs,dt,Ge="Let’s concatenate the base prompt, the completion until function execution and the result of the function as an Observation and resume generation.",vs,Tt,xs,Jt,Ce="Here is the new prompt:",Xs,bt,qs,ft,ve="Output:",Zs,gt,Ns,Ys,Es,Ut,xe="We learned how we can create Agents from scratch using Python code, and we <strong>saw just how tedious that process can be</strong>. Fortunately, many Agent libraries simplify this work by handling much of the heavy lifting for you.",Rs,Bt,Xe="Now, we’re ready <strong>to create our first real Agent</strong> using the <code>smolagents</code> library.",Ws,It,As,kt,Fs;return d=new zs({props:{title:"Dummy Agent Library",local:"dummy-agent-library",headingTag:"h1"}}),k=new zs({props:{title:"Serverless API",local:"serverless-api",headingTag:"h2"}}),C=new w({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwSW5mZXJlbmNlQ2xpZW50JTBBJTBBJTIzJTIzJTIwWW91JTIwbmVlZCUyMGElMjB0b2tlbiUyMGZyb20lMjBodHRwcyUzQSUyRiUyRmhmLmNvJTJGc2V0dGluZ3MlMkZ0b2tlbnMuJTIwSWYlMjB5b3UlMjBydW4lMjB0aGlzJTIwb24lMjBHb29nbGUlMjBDb2xhYiUyQyUyMHlvdSUyMGNhbiUyMHNldCUyMGl0JTIwdXAlMjBpbiUyMHRoZSUyMCUyMnNldHRpbmdzJTIyJTIwdGFiJTIwdW5kZXIlMjAlMjJzZWNyZXRzJTIyLiUyME1ha2UlMjBzdXJlJTIwdG8lMjBjYWxsJTIwaXQlMjAlMjJIRl9UT0tFTiUyMiUwQW9zLmVudmlyb24lNUIlMjJIRl9UT0tFTiUyMiU1RCUzRCUyMmhmX3h4eHh4eHh4eHh4eHh4JTIyJTBBJTBBY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCUyMm1ldGEtbGxhbWElMkZMbGFtYS0zLjItM0ItSW5zdHJ1Y3QlMjIp",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

<span class="hljs-comment">## You need a token from https://hf.co/settings/tokens. If you run this on Google Colab, you can set it up in the &quot;settings&quot; tab under &quot;secrets&quot;. Make sure to call it &quot;HF_TOKEN&quot;</span>
os.environ[<span class="hljs-string">&quot;HF_TOKEN&quot;</span>]=<span class="hljs-string">&quot;hf_xxxxxxxxxxxxxx&quot;</span>

client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Llama-3.2-3B-Instruct&quot;</span>)`,wrap:!1}}),v=new w({props:{code:"b3V0cHV0JTIwJTNEJTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMEElMjAlMjAlMjAlMjAlMjJUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMiUyQyUwQSUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNEMTAwJTJDJTBBKSUwQSUwQXByaW50KG91dHB1dCk=",highlighted:`output = client.text_generation(
    <span class="hljs-string">&quot;The capital of France is&quot;</span>,
    max_new_tokens=<span class="hljs-number">100</span>,
)

<span class="hljs-built_in">print</span>(output)`,wrap:!1}}),X=new w({props:{code:"UGFyaXMuJTIwVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjBQYXJpcy4lMjBUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMFBhcmlzLiUyMFRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwUGFyaXMuJTIwVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjBQYXJpcy4lMjBUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMFBhcmlzLiUyMFRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwUGFyaXMuJTIwVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjBQYXJpcy4lMjBUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMFBhcmlzLiUyMFRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwUGFyaXMuJTIwVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjBQYXJpcy4lMjBUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMFBhcmlzLiUyMFRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwUGFyaXMuJTIwVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjBQYXJpcy4lMjBUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMFBhcmlzLg==",highlighted:'Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris.',wrap:!1}}),N=new w({props:{code:"cHJvbXB0JTNEJTIyJTIyJTIyJTNDJTdDYmVnaW5fb2ZfdGV4dCU3QyUzRSUzQyU3Q3N0YXJ0X2hlYWRlcl9pZCU3QyUzRXVzZXIlM0MlN0NlbmRfaGVhZGVyX2lkJTdDJTNFJTBBVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlM0MlN0Nlb3RfaWQlN0MlM0UlM0MlN0NzdGFydF9oZWFkZXJfaWQlN0MlM0Vhc3Npc3RhbnQlM0MlN0NlbmRfaGVhZGVyX2lkJTdDJTNFJTIyJTIyJTIyJTBBb3V0cHV0JTIwJTNEJTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMEElMjAlMjAlMjAlMjBwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDEwMCUyQyUwQSklMEElMEFwcmludChvdXRwdXQp",highlighted:`prompt=<span class="hljs-string">&quot;&quot;&quot;&lt;|begin_of_text|&gt;&lt;|start_header_id|&gt;user&lt;|end_header_id|&gt;
The capital of France is&lt;|eot_id|&gt;&lt;|start_header_id|&gt;assistant&lt;|end_header_id|&gt;&quot;&quot;&quot;</span>
output = client.text_generation(
    prompt,
    max_new_tokens=<span class="hljs-number">100</span>,
)

<span class="hljs-built_in">print</span>(output)`,wrap:!1}}),E=new w({props:{code:"VGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjBQYXJpcy4=",highlighted:'The capital of France <span class="hljs-keyword">is</span> Paris.',wrap:!1}}),W=new w({props:{code:"b3V0cHV0JTIwJTNEJTIwY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjBzdHJlYW0lM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMG1heF90b2tlbnMlM0QxMDI0JTJDJTBBKQ==",highlighted:`output = client.chat.completions.create(
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;The capital of France is&quot;</span>},
    ],
    stream=<span class="hljs-literal">False</span>,
    max_tokens=<span class="hljs-number">1024</span>,
)`,wrap:!1}}),F=new w({props:{code:"UGFyaXMu",highlighted:"Paris.",wrap:!1}}),V=new zs({props:{title:"Dummy Agent",local:"dummy-agent",headingTag:"h2"}}),z=new w({props:{code:"JTBBJTBBJTBBJTBBJTBBJTBBJTBBJTBBKHRoaXMlMjBUaG91Z2h0JTJGQWN0aW9uJTJGT2JzZXJ2YXRpb24lMjBjYW4lMjByZXBlYXQlMjBOJTIwdGltZXMlMkMlMjB5b3UlMjBzaG91bGQlMjB0YWtlJTIwc2V2ZXJhbCUyMHN0ZXBzJTIwd2hlbiUyMG5lZWRlZC4lMjBUaGUlMjAlMjRKU09OX0JMT0IlMjBtdXN0JTIwYmUlMjBmb3JtYXR0ZWQlMjBhcyUyMG1hcmtkb3duJTIwYW5kJTIwb25seSUyMHVzZSUyMGElMjBTSU5HTEUlMjBhY3Rpb24lMjBhdCUyMGElMjB0aW1lLiklMEElMEElMEE=",highlighted:`Answer the following questions as best you can. You have access to the following tools:

get_weather: Get the current weather in a given location

The way you <span class="hljs-keyword">use</span> the tools is by specifying a json blob.
Specifically, <span class="hljs-keyword">this</span> json should have a \`action\` key (<span class="hljs-keyword">with</span> the name of the tool to <span class="hljs-keyword">use</span>) <span class="hljs-keyword">and</span> a \`action_input\` key (<span class="hljs-keyword">with</span> the <span class="hljs-keyword">input</span> to the tool going here).

The only values that should be in the <span class="hljs-string">&quot;action&quot;</span> field are:
get_weather: Get the current weather in a given location, args: {<span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}}
example <span class="hljs-keyword">use</span> : 

{{
  <span class="hljs-string">&quot;action&quot;</span>: <span class="hljs-string">&quot;get_weather&quot;</span>,
  <span class="hljs-string">&quot;action_input&quot;</span>: {<span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;New York&quot;</span>}
}}

ALWAYS <span class="hljs-keyword">use</span> the following format:

Question: the <span class="hljs-keyword">input</span> question you must answer
Thought: you should <span class="hljs-keyword">always</span> think about one action to take. Only one action at a <span class="hljs-keyword">time</span> in <span class="hljs-keyword">this</span> format:
Action:

$JSON_BLOB (<span class="hljs-keyword">inside</span> markdown <span class="hljs-keyword">cell</span>)

Observation: the result of the action. This Observation is <span class="hljs-keyword">unique</span>, complete, <span class="hljs-keyword">and</span> the source of truth.
... (<span class="hljs-keyword">this</span> Thought/Action/Observation can <span class="hljs-keyword">repeat</span> N times, you should take several steps when needed. The $JSON_BLOB must be formatted as markdown <span class="hljs-keyword">and</span> only <span class="hljs-keyword">use</span> a SINGLE action at a <span class="hljs-keyword">time</span>.)

You must <span class="hljs-keyword">always</span> <span class="hljs-keyword">end</span> your <span class="hljs-keyword">output</span> <span class="hljs-keyword">with</span> the following format:

Thought: I now know the <span class="hljs-keyword">final</span> answer
Final Answer: the <span class="hljs-keyword">final</span> answer to the original <span class="hljs-keyword">input</span> question

Now <span class="hljs-keyword">begin</span>! Reminder to ALWAYS <span class="hljs-keyword">use</span> the exact characters \`Final Answer:\` when you provide a definitive answer.`,wrap:!1}}),O=new w({props:{code:"cHJvbXB0JTNEZiUyMiUyMiUyMiUzQyU3Q2JlZ2luX29mX3RleHQlN0MlM0UlM0MlN0NzdGFydF9oZWFkZXJfaWQlN0MlM0VzeXN0ZW0lM0MlN0NlbmRfaGVhZGVyX2lkJTdDJTNFJTBBJTdCU1lTVEVNX1BST01QVCU3RCUwQSUzQyU3Q2VvdF9pZCU3QyUzRSUzQyU3Q3N0YXJ0X2hlYWRlcl9pZCU3QyUzRXVzZXIlM0MlN0NlbmRfaGVhZGVyX2lkJTdDJTNFJTBBV2hhdCdzJTIwdGhlJTIwd2VhdGhlciUyMGluJTIwTG9uZG9uJTIwJTNGJTBBJTNDJTdDZW90X2lkJTdDJTNFJTNDJTdDc3RhcnRfaGVhZGVyX2lkJTdDJTNFYXNzaXN0YW50JTNDJTdDZW5kX2hlYWRlcl9pZCU3QyUzRSUwQSUyMiUyMiUyMg==",highlighted:`<span class="hljs-attr">prompt</span>=f<span class="hljs-string">&quot;&quot;&quot;&lt;|begin_of_text|&gt;&lt;|start_header_id|&gt;system&lt;|end_header_id|&gt;
{SYSTEM_PROMPT}
&lt;|eot_id|&gt;&lt;|start_header_id|&gt;user&lt;|end_header_id|&gt;
What&#x27;s the weather in London ?
&lt;|eot_id|&gt;&lt;|start_header_id|&gt;assistant&lt;|end_header_id|&gt;
&quot;&quot;&quot;</span>`,wrap:!1}}),K=new w({props:{code:"bWVzc2FnZXMlM0QlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMFNZU1RFTV9QUk9NUFQlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0J3MlMjB0aGUlMjB3ZWF0aGVyJTIwaW4lMjBMb25kb24lMjAlM0YlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlNUQlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1ldGEtbGxhbWElMkZMbGFtYS0zLjItM0ItSW5zdHJ1Y3QlMjIpJTBBJTBBdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzREZhbHNlJTJDYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSk=",highlighted:`messages=[
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: SYSTEM_PROMPT},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What&#x27;s the weather in London ?&quot;</span>},
    ]
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-3.2-3B-Instruct&quot;</span>)

tokenizer.apply_chat_template(messages, <span class="hljs-keyword">tokenize</span>=<span class="hljs-keyword">False</span>,add_generation_prompt=<span class="hljs-keyword">True</span>)`,wrap:!1}}),st=new w({props:{code:"JTBBJTBBJTBBJTBBJTBBJTBBJTBBJTBBKHRoaXMlMjBUaG91Z2h0JTJGQWN0aW9uJTJGT2JzZXJ2YXRpb24lMjBjYW4lMjByZXBlYXQlMjBOJTIwdGltZXMlMkMlMjB5b3UlMjBzaG91bGQlMjB0YWtlJTIwc2V2ZXJhbCUyMHN0ZXBzJTIwd2hlbiUyMG5lZWRlZC4lMjBUaGUlMjAlMjRKU09OX0JMT0IlMjBtdXN0JTIwYmUlMjBmb3JtYXR0ZWQlMjBhcyUyMG1hcmtkb3duJTIwYW5kJTIwb25seSUyMHVzZSUyMGElMjBTSU5HTEUlMjBhY3Rpb24lMjBhdCUyMGElMjB0aW1lLiklMEElMEElMEE=",highlighted:`&lt;|<span class="hljs-type">begin_of_text</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;system</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;
Answer</span> the following questions <span class="hljs-built_in">as</span> best you can. You have access to the following tools:

get_weather: Get the current weather <span class="hljs-built_in">in</span> a given location

The way you use the tools is <span class="hljs-built_in">by</span> specifying a json blob.
Specifically, this json should have a \`action\` key (<span class="hljs-built_in">with</span> the name of the tool to use) and a \`action_input\` key (<span class="hljs-built_in">with</span> the input to the tool going here).

The only values that should be <span class="hljs-built_in">in</span> the <span class="hljs-string">&quot;action&quot;</span> <span class="hljs-built_in">field</span> are:
get_weather: Get the current weather <span class="hljs-built_in">in</span> a given location, args: {<span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}}
example use : 

{{
  <span class="hljs-string">&quot;action&quot;</span>: <span class="hljs-string">&quot;get_weather&quot;</span>,
  <span class="hljs-string">&quot;action_input&quot;</span>: {<span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;New York&quot;</span>}
}}

ALWAYS use the following format:

Question: the input question you must answer
Thought: you should always think about one action to take. Only one action <span class="hljs-built_in">at</span> a <span class="hljs-built_in">time</span> <span class="hljs-built_in">in</span> this format:
Action:

$JSON_BLOB (inside markdown cell)

Observation: the result of the action. This Observation is unique, complete, and the source of truth.
... (this Thought/Action/Observation can <span class="hljs-built_in">repeat</span> N times, you should take several steps when needed. The $JSON_BLOB must be formatted <span class="hljs-built_in">as</span> markdown and only use a SINGLE action <span class="hljs-built_in">at</span> a <span class="hljs-built_in">time</span>.)

You must always <span class="hljs-keyword">end</span> your output <span class="hljs-built_in">with</span> the following format:

Thought: I now know the final answer
Final Answer: the final answer to the original input question

Now begin! Reminder to ALWAYS use the <span class="hljs-built_in">exact</span> characters \`Final Answer:\` when you provide a definitive answer. 
&lt;|<span class="hljs-type">eot_id</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;user</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;
What</span>&#x27;s the weather <span class="hljs-built_in">in</span> London ?
&lt;|<span class="hljs-type">eot_id</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;assistant</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;</span>`,wrap:!1}}),lt=new w({props:{code:"b3V0cHV0JTIwJTNEJTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMEElMjAlMjAlMjAlMjBwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDIwMCUyQyUwQSklMEElMEFwcmludChvdXRwdXQp",highlighted:`output = client.text_generation(
    prompt,
    max_new_tokens=<span class="hljs-number">200</span>,
)

<span class="hljs-built_in">print</span>(output)`,wrap:!1}}),at=new w({props:{code:"QWN0aW9uJTNB",highlighted:'<span class="hljs-symbol">Action:</span>',wrap:!1}}),pt=new w({props:{code:"VGhvdWdodCUzQSUyMEklMjB3aWxsJTIwY2hlY2slMjB0aGUlMjB3ZWF0aGVyJTIwaW4lMjBMb25kb24uJTBBT2JzZXJ2YXRpb24lM0ElMjBUaGUlMjBjdXJyZW50JTIwd2VhdGhlciUyMGluJTIwTG9uZG9uJTIwaXMlMjBtb3N0bHklMjBjbG91ZHklMjB3aXRoJTIwYSUyMGhpZ2glMjBvZiUyMDEyJUMyJUIwQyUyMGFuZCUyMGElMjBsb3clMjBvZiUyMDglQzIlQjBDLg==",highlighted:`Thought: I will<span class="hljs-built_in"> check </span>the weather in London.
Observation: The current weather in London is mostly cloudy with a high of 12°C<span class="hljs-built_in"> and </span>a low of 8°C.`,wrap:!1}}),ht=new w({props:{code:"b3V0cHV0JTIwJTNEJTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMEElMjAlMjAlMjAlMjBwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDIwMCUyQyUwQSUyMCUyMCUyMCUyMHN0b3AlM0QlNUIlMjJPYnNlcnZhdGlvbiUzQSUyMiU1RCUyMCUyMyUyMExldCdzJTIwc3RvcCUyMGJlZm9yZSUyMGFueSUyMGFjdHVhbCUyMGZ1bmN0aW9uJTIwaXMlMjBjYWxsZWQlMEEp",highlighted:`output = client.text_generation(
    prompt,
    max_new_tokens=<span class="hljs-number">200</span>,
    stop=[<span class="hljs-string">&quot;Observation:&quot;</span>] <span class="hljs-comment"># Let&#x27;s stop before any actual function is called</span>
)`,wrap:!1}}),rt=new w({props:{code:"b3V0cHV0JTNB",highlighted:'<span class="hljs-symbol">output:</span>',wrap:!1}}),Mt=new w({props:{code:"JTdCJTBBJTIwJTIwJTIyYWN0aW9uJTIyJTNBJTIwJTIyZ2V0X3dlYXRoZXIlMjIlMkMlMEElMjAlMjAlMjJhY3Rpb24lMjIlM0ElMjAlN0IlMjJsb2NhdGlvbiUyMiUzQSUyMCUyMkxvbmRvbiUyMiU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;action&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;get_weather&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;action&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;location&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;London&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),wt=new w({props:{code:"TXVjaCUyMEJldHRlciElMjAlMEFMZXQncyUyMG5vdyUyMGNyZWF0ZSUyMGElMjBkdW1teSUyMGdldCUyMHdlYXRoZXIlMjBmdW5jdGlvbi4lMjAlMjBJbiUyMGElMjByZWFsJTIwc2l0dWF0aW9uJTJDJTIweW91JTIwY291bGQlMjBjYWxsJTIwYW5kJTIwQVBJLiUwQSUwQSU2MCU2MCU2MHB5dGhvbiUwQSUyM0R1bW15JTIwZnVuY3Rpb24lMEFkZWYlMjBnZXRfd2VhdGhlcihsb2NhdGlvbiklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBmJTIydGhlJTIwd2VhdGhlciUyMGluJTIwJTdCbG9jYXRpb24lN0QlMjBpcyUyMHN1bm55JTIwd2l0aCUyMGxvdyUyMHRlbXBlcmF0dXJlcy4lMjAlNUNuJTIyJTBBJTBBZ2V0X3dlYXRoZXIoJ0xvbmRvbicp",highlighted:`Much Better! 
<span class="hljs-keyword">Let</span><span class="hljs-comment">&#x27;s now create a dummy get weather function.  In a real situation, you could call and API.</span>

\`\`\`python
#Dummy <span class="hljs-keyword">function</span>
def get_weather(location):
    <span class="hljs-keyword">return</span> f<span class="hljs-string">&quot;the weather in {location} is sunny with low temperatures. \\n&quot;</span>

get_weather(<span class="hljs-comment">&#x27;London&#x27;)</span>`,wrap:!1}}),mt=new w({props:{code:"J3RoZSUyMHdlYXRoZXIlMjBpbiUyMExvbmRvbiUyMGlzJTIwc3VubnklMjB3aXRoJTIwbG93JTIwdGVtcGVyYXR1cmVzLiUyMCU1Q24n",highlighted:'<span class="hljs-symbol">&#x27;the</span> weather <span class="hljs-keyword">in</span> London <span class="hljs-keyword">is</span> sunny <span class="hljs-keyword">with</span> low temperatures. \\n&#x27;',wrap:!1}}),Tt=new w({props:{code:"bmV3X3Byb21wdCUzRHByb21wdCUyQm91dHB1dCUyQmdldF93ZWF0aGVyKCdMb25kb24nKSUwQWZpbmFsX291dHB1dCUyMCUzRCUyMGNsaWVudC50ZXh0X2dlbmVyYXRpb24oJTBBJTIwJTIwJTIwJTIwbmV3X3Byb21wdCUyQyUwQSUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNEMjAwJTJDJTBBKSUwQSUwQXByaW50KGZpbmFsX291dHB1dCk=",highlighted:`new_prompt=prompt+output+get_weather(<span class="hljs-string">&#x27;London&#x27;</span>)
final_output = client.text_generation(
    new_prompt,
    max_new_tokens=<span class="hljs-number">200</span>,
)

<span class="hljs-built_in">print</span>(final_output)`,wrap:!1}}),bt=new w({props:{code:"JTBBJTBBJTBBJTBBJTBBJTBBJTBBJTBBKHRoaXMlMjBUaG91Z2h0JTJGQWN0aW9uJTJGT2JzZXJ2YXRpb24lMjBjYW4lMjByZXBlYXQlMjBOJTIwdGltZXMlMkMlMjB5b3UlMjBzaG91bGQlMjB0YWtlJTIwc2V2ZXJhbCUyMHN0ZXBzJTIwd2hlbiUyMG5lZWRlZC4lMjBUaGUlMjAlMjRKU09OX0JMT0IlMjBtdXN0JTIwYmUlMjBmb3JtYXR0ZWQlMjBhcyUyMG1hcmtkb3duJTIwYW5kJTIwb25seSUyMHVzZSUyMGElMjBTSU5HTEUlMjBhY3Rpb24lMjBhdCUyMGElMjB0aW1lLiklMEElMEElMEElMEE=",highlighted:`&lt;|<span class="hljs-type">begin_of_text</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;system</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;
    Answer</span> the following questions <span class="hljs-built_in">as</span> best you can. You have access to the following tools:

get_weather: Get the current weather <span class="hljs-built_in">in</span> a given location

The way you use the tools is <span class="hljs-built_in">by</span> specifying a json blob.
Specifically, this json should have a \`action\` key (<span class="hljs-built_in">with</span> the name of the tool to use) and a \`action_input\` key (<span class="hljs-built_in">with</span> the input to the tool going here).

The only values that should be <span class="hljs-built_in">in</span> the <span class="hljs-string">&quot;action&quot;</span> <span class="hljs-built_in">field</span> are:
get_weather: Get the current weather <span class="hljs-built_in">in</span> a given location, args: {<span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}}
example use : 

{{
  <span class="hljs-string">&quot;action&quot;</span>: <span class="hljs-string">&quot;get_weather&quot;</span>,
  <span class="hljs-string">&quot;action_input&quot;</span>: {<span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;New York&quot;</span>}
}}

ALWAYS use the following format:

Question: the input question you must answer
Thought: you should always think about one action to take. Only one action <span class="hljs-built_in">at</span> a <span class="hljs-built_in">time</span> <span class="hljs-built_in">in</span> this format:
Action:

$JSON_BLOB (inside markdown cell)

Observation: the result of the action. This Observation is unique, complete, and the source of truth.
... (this Thought/Action/Observation can <span class="hljs-built_in">repeat</span> N times, you should take several steps when needed. The $JSON_BLOB must be formatted <span class="hljs-built_in">as</span> markdown and only use a SINGLE action <span class="hljs-built_in">at</span> a <span class="hljs-built_in">time</span>.)

You must always <span class="hljs-keyword">end</span> your output <span class="hljs-built_in">with</span> the following format:

Thought: I now know the final answer
Final Answer: the final answer to the original input question

Now begin! Reminder to ALWAYS use the <span class="hljs-built_in">exact</span> characters \`Final Answer:\` when you provide a definitive answer. 
&lt;|<span class="hljs-type">eot_id</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;user</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;
What</span>&#x27;s the weather <span class="hljs-built_in">in</span> London ?
&lt;|<span class="hljs-type">eot_id</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;assistant</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;

Action</span>:
\`\`\`
{
  <span class="hljs-string">&quot;action&quot;</span>: <span class="hljs-string">&quot;get_weather&quot;</span>,
  <span class="hljs-string">&quot;action&quot;</span>: {<span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>: <span class="hljs-string">&quot;London&quot;</span>}
}
\`\`\`
Thought: I will check the weather <span class="hljs-built_in">in</span> London.
Observation:the weather <span class="hljs-built_in">in</span> London is sunny <span class="hljs-built_in">with</span> low temperatures. `,wrap:!1}}),gt=new w({props:{code:"RmluYWwlMjBBbnN3ZXIlM0ElMjBUaGUlMjB3ZWF0aGVyJTIwaW4lMjBMb25kb24lMjBpcyUyMHN1bm55JTIwd2l0aCUyMGxvdyUyMHRlbXBlcmF0dXJlcy4=",highlighted:'<span class="hljs-keyword">Final</span> Answer: The weather <span class="hljs-keyword">in</span> London <span class="hljs-keyword">is</span> sunny <span class="hljs-keyword">with</span> low temperatures.',wrap:!1}}),It=new Ae({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit1/dummy-agent-library.mdx"}}),{c(){j=i("meta"),Gt=n(),$t=i("p"),Ct=n(),h(d.$$.fragment),vt=n(),T=i("img"),xt=n(),J=i("p"),J.innerHTML=Ds,Xt=n(),b=i("p"),b.textContent=Ks,qt=n(),f=i("p"),f.textContent=te,Zt=n(),g=i("p"),g.innerHTML=se,Nt=n(),U=i("p"),U.innerHTML=ee,Yt=n(),B=i("p"),B.innerHTML=le,Et=n(),I=i("p"),I.textContent=ne,Rt=n(),_=i("p"),_.innerHTML=ae,Wt=n(),$=i("p"),$.innerHTML=ie,At=n(),h(k.$$.fragment),Ft=n(),G=i("p"),G.textContent=pe,Qt=n(),h(C.$$.fragment),Vt=n(),h(v.$$.fragment),Lt=n(),x=i("p"),x.textContent=oe,Ht=n(),h(X.$$.fragment),St=n(),q=i("p"),q.innerHTML=he,zt=n(),Z=i("p"),Z.innerHTML=ue,Pt=n(),h(N.$$.fragment),Ot=n(),Y=i("p"),Y.textContent=re,Dt=n(),h(E.$$.fragment),Kt=n(),R=i("p"),R.textContent=ce,ts=n(),h(W.$$.fragment),ss=n(),A=i("p"),A.textContent=Me,es=n(),h(F.$$.fragment),ls=n(),Q=i("p"),Q.textContent=ye,ns=n(),h(V.$$.fragment),as=n(),L=i("p"),L.textContent=we,is=n(),H=i("p"),H.textContent=je,ps=n(),S=i("ol"),S.innerHTML=me,os=n(),h(z.$$.fragment),hs=n(),P=i("p"),P.textContent=de,us=n(),h(O.$$.fragment),rs=n(),D=i("p"),D.innerHTML=Te,cs=n(),h(K.$$.fragment),Ms=n(),tt=i("p"),tt.textContent=Je,ys=n(),h(st.$$.fragment),ws=n(),et=i("p"),et.textContent=be,js=n(),h(lt.$$.fragment),ms=n(),nt=i("p"),nt.textContent=fe,ds=n(),h(at.$$.fragment),Ts=n(),it=i("p"),it.textContent=ge,Js=n(),h(pt.$$.fragment),bs=n(),ot=i("p"),ot.textContent=Ue,fs=n(),m=i("blockquote"),_t=i("p"),_t.textContent=Be,Ls=n(),h(ht.$$.fragment),gs=n(),ut=i("p"),ut.textContent=Ie,Us=n(),h(rt.$$.fragment),Bs=n(),ct=i("p"),ct.textContent=_e,Is=n(),h(Mt.$$.fragment),_s=n(),yt=i("p"),yt.textContent=$e,$s=n(),h(wt.$$.fragment),ks=n(),jt=i("p"),jt.textContent=ke,Gs=n(),h(mt.$$.fragment),Cs=n(),dt=i("p"),dt.textContent=Ge,vs=n(),h(Tt.$$.fragment),xs=n(),Jt=i("p"),Jt.textContent=Ce,Xs=n(),h(bt.$$.fragment),qs=n(),ft=i("p"),ft.textContent=ve,Zs=n(),h(gt.$$.fragment),Ns=n(),Ys=i("hr"),Es=n(),Ut=i("p"),Ut.innerHTML=xe,Rs=n(),Bt=i("p"),Bt.innerHTML=Xe,Ws=n(),h(It.$$.fragment),As=n(),kt=i("p"),this.h()},l(t){const s=We("svelte-u9bgzb",document.head);j=p(s,"META",{name:!0,content:!0}),s.forEach(e),Gt=a(t),$t=p(t,"P",{}),Hs($t).forEach(e),Ct=a(t),u(d.$$.fragment,t),vt=a(t),T=p(t,"IMG",{src:!0,alt:!0}),xt=a(t),J=p(t,"P",{"data-svelte-h":!0}),o(J)!=="svelte-8i1n71"&&(J.innerHTML=Ds),Xt=a(t),b=p(t,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1pvln0h"&&(b.textContent=Ks),qt=a(t),f=p(t,"P",{"data-svelte-h":!0}),o(f)!=="svelte-17n0axy"&&(f.textContent=te),Zt=a(t),g=p(t,"P",{"data-svelte-h":!0}),o(g)!=="svelte-1ssvh5p"&&(g.innerHTML=se),Nt=a(t),U=p(t,"P",{"data-svelte-h":!0}),o(U)!=="svelte-r0w337"&&(U.innerHTML=ee),Yt=a(t),B=p(t,"P",{"data-svelte-h":!0}),o(B)!=="svelte-9snja6"&&(B.innerHTML=le),Et=a(t),I=p(t,"P",{"data-svelte-h":!0}),o(I)!=="svelte-scmak8"&&(I.textContent=ne),Rt=a(t),_=p(t,"P",{"data-svelte-h":!0}),o(_)!=="svelte-10qtj1b"&&(_.innerHTML=ae),Wt=a(t),$=p(t,"P",{"data-svelte-h":!0}),o($)!=="svelte-1fa85bb"&&($.innerHTML=ie),At=a(t),u(k.$$.fragment,t),Ft=a(t),G=p(t,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1y7mhy7"&&(G.textContent=pe),Qt=a(t),u(C.$$.fragment,t),Vt=a(t),u(v.$$.fragment,t),Lt=a(t),x=p(t,"P",{"data-svelte-h":!0}),o(x)!=="svelte-1wueeet"&&(x.textContent=oe),Ht=a(t),u(X.$$.fragment,t),St=a(t),q=p(t,"P",{"data-svelte-h":!0}),o(q)!=="svelte-14l0pz9"&&(q.innerHTML=he),zt=a(t),Z=p(t,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1891xc3"&&(Z.innerHTML=ue),Pt=a(t),u(N.$$.fragment,t),Ot=a(t),Y=p(t,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1wueeet"&&(Y.textContent=re),Dt=a(t),u(E.$$.fragment,t),Kt=a(t),R=p(t,"P",{"data-svelte-h":!0}),o(R)!=="svelte-10i9u01"&&(R.textContent=ce),ts=a(t),u(W.$$.fragment,t),ss=a(t),A=p(t,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1wueeet"&&(A.textContent=Me),es=a(t),u(F.$$.fragment,t),ls=a(t),Q=p(t,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-o9oayq"&&(Q.textContent=ye),ns=a(t),u(V.$$.fragment,t),as=a(t),L=p(t,"P",{"data-svelte-h":!0}),o(L)!=="svelte-xr84ar"&&(L.textContent=we),is=a(t),H=p(t,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1m7y210"&&(H.textContent=je),ps=a(t),S=p(t,"OL",{"data-svelte-h":!0}),o(S)!=="svelte-27sevg"&&(S.innerHTML=me),os=a(t),u(z.$$.fragment,t),hs=a(t),P=p(t,"P",{"data-svelte-h":!0}),o(P)!=="svelte-1jc27vd"&&(P.textContent=de),us=a(t),u(O.$$.fragment,t),rs=a(t),D=p(t,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1letw4p"&&(D.innerHTML=Te),cs=a(t),u(K.$$.fragment,t),Ms=a(t),tt=p(t,"P",{"data-svelte-h":!0}),o(tt)!=="svelte-u9o4sn"&&(tt.textContent=Je),ys=a(t),u(st.$$.fragment,t),ws=a(t),et=p(t,"P",{"data-svelte-h":!0}),o(et)!=="svelte-18yryy0"&&(et.textContent=be),js=a(t),u(lt.$$.fragment,t),ms=a(t),nt=p(t,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-1wueeet"&&(nt.textContent=fe),ds=a(t),u(at.$$.fragment,t),Ts=a(t),it=p(t,"P",{"data-svelte-h":!0}),o(it)!=="svelte-1u60rex"&&(it.textContent=ge),Js=a(t),u(pt.$$.fragment,t),bs=a(t),ot=p(t,"P",{"data-svelte-h":!0}),o(ot)!=="svelte-azbr52"&&(ot.textContent=Ue),fs=a(t),m=p(t,"BLOCKQUOTE",{});var Qs=Hs(m);_t=p(Qs,"P",{"data-svelte-h":!0}),o(_t)!=="svelte-eu81gr"&&(_t.textContent=Be),Ls=a(Qs),u(ht.$$.fragment,Qs),Qs.forEach(e),gs=a(t),ut=p(t,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-1yqfqub"&&(ut.textContent=Ie),Us=a(t),u(rt.$$.fragment,t),Bs=a(t),ct=p(t,"P",{"data-svelte-h":!0}),o(ct)!=="svelte-a5d62w"&&(ct.textContent=_e),Is=a(t),u(Mt.$$.fragment,t),_s=a(t),yt=p(t,"P",{"data-svelte-h":!0}),o(yt)!=="svelte-1s2rtg2"&&(yt.textContent=$e),$s=a(t),u(wt.$$.fragment,t),ks=a(t),jt=p(t,"P",{"data-svelte-h":!0}),o(jt)!=="svelte-1wueeet"&&(jt.textContent=ke),Gs=a(t),u(mt.$$.fragment,t),Cs=a(t),dt=p(t,"P",{"data-svelte-h":!0}),o(dt)!=="svelte-18w5bdv"&&(dt.textContent=Ge),vs=a(t),u(Tt.$$.fragment,t),xs=a(t),Jt=p(t,"P",{"data-svelte-h":!0}),o(Jt)!=="svelte-smcbfz"&&(Jt.textContent=Ce),Xs=a(t),u(bt.$$.fragment,t),qs=a(t),ft=p(t,"P",{"data-svelte-h":!0}),o(ft)!=="svelte-1wuxk0l"&&(ft.textContent=ve),Zs=a(t),u(gt.$$.fragment,t),Ns=a(t),Ys=p(t,"HR",{}),Es=a(t),Ut=p(t,"P",{"data-svelte-h":!0}),o(Ut)!=="svelte-1qq5buo"&&(Ut.innerHTML=xe),Rs=a(t),Bt=p(t,"P",{"data-svelte-h":!0}),o(Bt)!=="svelte-1ef9lfw"&&(Bt.innerHTML=Xe),Ws=a(t),u(It.$$.fragment,t),As=a(t),kt=p(t,"P",{}),Hs(kt).forEach(e),this.h()},h(){Vs(j,"name","hf:doc:metadata"),Vs(j,"content",Qe),Ze(T.src,Os="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/whiteboard-unit1sub3DONE.jpg")||Vs(T,"src",Os),Vs(T,"alt","Unit 1 planning")},m(t,s){Ss(document.head,j),l(t,Gt,s),l(t,$t,s),l(t,Ct,s),r(d,t,s),l(t,vt,s),l(t,T,s),l(t,xt,s),l(t,J,s),l(t,Xt,s),l(t,b,s),l(t,qt,s),l(t,f,s),l(t,Zt,s),l(t,g,s),l(t,Nt,s),l(t,U,s),l(t,Yt,s),l(t,B,s),l(t,Et,s),l(t,I,s),l(t,Rt,s),l(t,_,s),l(t,Wt,s),l(t,$,s),l(t,At,s),r(k,t,s),l(t,Ft,s),l(t,G,s),l(t,Qt,s),r(C,t,s),l(t,Vt,s),r(v,t,s),l(t,Lt,s),l(t,x,s),l(t,Ht,s),r(X,t,s),l(t,St,s),l(t,q,s),l(t,zt,s),l(t,Z,s),l(t,Pt,s),r(N,t,s),l(t,Ot,s),l(t,Y,s),l(t,Dt,s),r(E,t,s),l(t,Kt,s),l(t,R,s),l(t,ts,s),r(W,t,s),l(t,ss,s),l(t,A,s),l(t,es,s),r(F,t,s),l(t,ls,s),l(t,Q,s),l(t,ns,s),r(V,t,s),l(t,as,s),l(t,L,s),l(t,is,s),l(t,H,s),l(t,ps,s),l(t,S,s),l(t,os,s),r(z,t,s),l(t,hs,s),l(t,P,s),l(t,us,s),r(O,t,s),l(t,rs,s),l(t,D,s),l(t,cs,s),r(K,t,s),l(t,Ms,s),l(t,tt,s),l(t,ys,s),r(st,t,s),l(t,ws,s),l(t,et,s),l(t,js,s),r(lt,t,s),l(t,ms,s),l(t,nt,s),l(t,ds,s),r(at,t,s),l(t,Ts,s),l(t,it,s),l(t,Js,s),r(pt,t,s),l(t,bs,s),l(t,ot,s),l(t,fs,s),l(t,m,s),Ss(m,_t),Ss(m,Ls),r(ht,m,null),l(t,gs,s),l(t,ut,s),l(t,Us,s),r(rt,t,s),l(t,Bs,s),l(t,ct,s),l(t,Is,s),r(Mt,t,s),l(t,_s,s),l(t,yt,s),l(t,$s,s),r(wt,t,s),l(t,ks,s),l(t,jt,s),l(t,Gs,s),r(mt,t,s),l(t,Cs,s),l(t,dt,s),l(t,vs,s),r(Tt,t,s),l(t,xs,s),l(t,Jt,s),l(t,Xs,s),r(bt,t,s),l(t,qs,s),l(t,ft,s),l(t,Zs,s),r(gt,t,s),l(t,Ns,s),l(t,Ys,s),l(t,Es,s),l(t,Ut,s),l(t,Rs,s),l(t,Bt,s),l(t,Ws,s),r(It,t,s),l(t,As,s),l(t,kt,s),Fs=!0},p:Ne,i(t){Fs||(c(d.$$.fragment,t),c(k.$$.fragment,t),c(C.$$.fragment,t),c(v.$$.fragment,t),c(X.$$.fragment,t),c(N.$$.fragment,t),c(E.$$.fragment,t),c(W.$$.fragment,t),c(F.$$.fragment,t),c(V.$$.fragment,t),c(z.$$.fragment,t),c(O.$$.fragment,t),c(K.$$.fragment,t),c(st.$$.fragment,t),c(lt.$$.fragment,t),c(at.$$.fragment,t),c(pt.$$.fragment,t),c(ht.$$.fragment,t),c(rt.$$.fragment,t),c(Mt.$$.fragment,t),c(wt.$$.fragment,t),c(mt.$$.fragment,t),c(Tt.$$.fragment,t),c(bt.$$.fragment,t),c(gt.$$.fragment,t),c(It.$$.fragment,t),Fs=!0)},o(t){M(d.$$.fragment,t),M(k.$$.fragment,t),M(C.$$.fragment,t),M(v.$$.fragment,t),M(X.$$.fragment,t),M(N.$$.fragment,t),M(E.$$.fragment,t),M(W.$$.fragment,t),M(F.$$.fragment,t),M(V.$$.fragment,t),M(z.$$.fragment,t),M(O.$$.fragment,t),M(K.$$.fragment,t),M(st.$$.fragment,t),M(lt.$$.fragment,t),M(at.$$.fragment,t),M(pt.$$.fragment,t),M(ht.$$.fragment,t),M(rt.$$.fragment,t),M(Mt.$$.fragment,t),M(wt.$$.fragment,t),M(mt.$$.fragment,t),M(Tt.$$.fragment,t),M(bt.$$.fragment,t),M(gt.$$.fragment,t),M(It.$$.fragment,t),Fs=!1},d(t){t&&(e(Gt),e($t),e(Ct),e(vt),e(T),e(xt),e(J),e(Xt),e(b),e(qt),e(f),e(Zt),e(g),e(Nt),e(U),e(Yt),e(B),e(Et),e(I),e(Rt),e(_),e(Wt),e($),e(At),e(Ft),e(G),e(Qt),e(Vt),e(Lt),e(x),e(Ht),e(St),e(q),e(zt),e(Z),e(Pt),e(Ot),e(Y),e(Dt),e(Kt),e(R),e(ts),e(ss),e(A),e(es),e(ls),e(Q),e(ns),e(as),e(L),e(is),e(H),e(ps),e(S),e(os),e(hs),e(P),e(us),e(rs),e(D),e(cs),e(Ms),e(tt),e(ys),e(ws),e(et),e(js),e(ms),e(nt),e(ds),e(Ts),e(it),e(Js),e(bs),e(ot),e(fs),e(m),e(gs),e(ut),e(Us),e(Bs),e(ct),e(Is),e(_s),e(yt),e($s),e(ks),e(jt),e(Gs),e(Cs),e(dt),e(vs),e(xs),e(Jt),e(Xs),e(qs),e(ft),e(Zs),e(Ns),e(Ys),e(Es),e(Ut),e(Rs),e(Bt),e(Ws),e(As),e(kt)),e(j),y(d,t),y(k,t),y(C,t),y(v,t),y(X,t),y(N,t),y(E,t),y(W,t),y(F,t),y(V,t),y(z,t),y(O,t),y(K,t),y(st,t),y(lt,t),y(at,t),y(pt,t),y(ht),y(rt,t),y(Mt,t),y(wt,t),y(mt,t),y(Tt,t),y(bt,t),y(gt,t),y(It,t)}}}const Qe='{"title":"Dummy Agent Library","local":"dummy-agent-library","sections":[{"title":"Serverless API","local":"serverless-api","sections":[],"depth":2},{"title":"Dummy Agent","local":"dummy-agent","sections":[],"depth":2}],"depth":1}';function Ve(Ps){return Ye(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Oe extends Ee{constructor(j){super(),Re(this,j,Ve,Fe,qe,{})}}export{Oe as component};
