import{s as Yt,n as Ft,o as Ht}from"../chunks/scheduler.9f522b10.js";import{S as Qt,i as qt,g as i,s as a,r as p,A as Et,h as r,f as l,c as n,j as At,u as M,x as o,k as Wt,y as St,a as s,v as y,d as m,t as h,w as u}from"../chunks/index.192f26f8.js";import{C as H}from"../chunks/CodeBlock.ac496002.js";import{H as bt,E as Lt}from"../chunks/EditOnGithub.6d5e7de4.js";function Nt(Tt){let c,E,Q,S,d,L,w,gt=`In the <a href="quicktour">Quicktour</a>, we saw how to build and train a
tokenizer using text files, but we can actually use any Python Iterator.
In this section we’ll see a few different ways of training our
tokenizer.`,N,f,Ct=`For all the examples listed below, we’ll use the same <a href="/docs/tokenizers/pr_1607/en/api/tokenizer#tokenizers.Tokenizer">Tokenizer</a> and
<code>Trainer</code>, built as
following:`,P,U,K,j,kt=`This tokenizer is based on the <a href="/docs/tokenizers/pr_1607/en/api/models#tokenizers.models.Unigram">Unigram</a> model. It
takes care of normalizing the input using the NFKC Unicode normalization
method, and uses a <a href="/docs/tokenizers/pr_1607/en/api/pre-tokenizers#tokenizers.pre_tokenizers.ByteLevel">ByteLevel</a> pre-tokenizer with the corresponding decoder.`,D,J,It=`For more information on the components used here, you can check
<a href="components">here</a>.`,O,b,tt,T,$t=`As you probably guessed already, the easiest way to train our tokenizer
is by using a <code>List</code>{.interpreted-text role=“obj”}:`,et,g,lt,C,zt=`Easy, right? You can use anything working as an iterator here, be it a
<code>List</code>{.interpreted-text role=“obj”}, <code>Tuple</code>{.interpreted-text
role=“obj”}, or a <code>np.Array</code>{.interpreted-text role=“obj”}. Anything
works as long as it provides strings.`,st,k,at,I,Gt=`An awesome way to access one of the many datasets that exist out there
is by using the 🤗 Datasets library. For more information about it, you
should check <a href="https://huggingface.co/docs/datasets/" rel="nofollow">the official documentation
here</a>.`,nt,$,Xt="Let’s start by loading our dataset:",it,z,rt,G,Zt=`The next step is to build an iterator over this dataset. The easiest way
to do this is probably by using a generator:`,ot,X,pt,Z,vt=`As you can see here, for improved efficiency we can actually provide a
batch of examples used to train, instead of iterating over them one by
one. By doing so, we can expect performances very similar to those we
got while training directly from files.`,Mt,v,_t=`With our iterator ready, we just need to launch the training. In order
to improve the look of our progress bars, we can specify the total
length of the dataset:`,yt,_,mt,B,Bt="And that’s it!",ht,R,ut,x,Rt=`Since gzip files in Python can be used as iterators, it is extremely
simple to train on such files:`,ct,V,dt,A,xt=`Now if we wanted to train from multiple gzip files, it wouldn’t be much
harder:`,wt,W,ft,Y,Vt="And voilà!",Ut,F,jt,q,Jt;return d=new bt({props:{title:"Training from memory",local:"training-from-memory",headingTag:"h1"}}),U=new H({props:{code:"ZnJvbSUyMHRva2VuaXplcnMlMjBpbXBvcnQlMjBUb2tlbml6ZXIlMkMlMjBkZWNvZGVycyUyQyUyMG1vZGVscyUyQyUyMG5vcm1hbGl6ZXJzJTJDJTIwcHJlX3Rva2VuaXplcnMlMkMlMjB0cmFpbmVycyUwQXRva2VuaXplciUyMCUzRCUyMFRva2VuaXplcihtb2RlbHMuVW5pZ3JhbSgpKSUwQXRva2VuaXplci5ub3JtYWxpemVyJTIwJTNEJTIwbm9ybWFsaXplcnMuTkZLQygpJTBBdG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5CeXRlTGV2ZWwoKSUwQXRva2VuaXplci5kZWNvZGVyJTIwJTNEJTIwZGVjb2RlcnMuQnl0ZUxldmVsKCklMEF0cmFpbmVyJTIwJTNEJTIwdHJhaW5lcnMuVW5pZ3JhbVRyYWluZXIoJTBBJTIwJTIwJTIwJTIwdm9jYWJfc2l6ZSUzRDIwMDAwJTJDJTBBJTIwJTIwJTIwJTIwaW5pdGlhbF9hbHBoYWJldCUzRHByZV90b2tlbml6ZXJzLkJ5dGVMZXZlbC5hbHBoYWJldCgpJTJDJTBBJTIwJTIwJTIwJTIwc3BlY2lhbF90b2tlbnMlM0QlNUIlMjIlM0NQQUQlM0UlMjIlMkMlMjAlMjIlM0NCT1MlM0UlMjIlMkMlMjAlMjIlM0NFT1MlM0UlMjIlNUQlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> tokenizers <span class="hljs-keyword">import</span> Tokenizer, decoders, models, normalizers, pre_tokenizers, trainers
tokenizer = Tokenizer(models.Unigram())
tokenizer.normalizer = normalizers.NFKC()
tokenizer.pre_tokenizer = pre_tokenizers.ByteLevel()
tokenizer.decoder = decoders.ByteLevel()
trainer = trainers.UnigramTrainer(
    vocab_size=<span class="hljs-number">20000</span>,
    initial_alphabet=pre_tokenizers.ByteLevel.alphabet(),
    special_tokens=[<span class="hljs-string">&quot;&lt;PAD&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;BOS&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;EOS&gt;&quot;</span>],
)`,wrap:!1}}),b=new bt({props:{title:"The most basic way",local:"the-most-basic-way",headingTag:"h2"}}),g=new H({props:{code:"JTIzJTIwRmlyc3QlMjBmZXclMjBsaW5lcyUyMG9mJTIwdGhlJTIwJTIyWmVuJTIwb2YlMjBQeXRob24lMjIlMjBodHRwcyUzQSUyRiUyRnd3dy5weXRob24ub3JnJTJGZGV2JTJGcGVwcyUyRnBlcC0wMDIwJTJGJTBBZGF0YSUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMkJlYXV0aWZ1bCUyMGlzJTIwYmV0dGVyJTIwdGhhbiUyMHVnbHkuJTIyJTBBJTIwJTIwJTIwJTIwJTIyRXhwbGljaXQlMjBpcyUyMGJldHRlciUyMHRoYW4lMjBpbXBsaWNpdC4lMjIlMEElMjAlMjAlMjAlMjAlMjJTaW1wbGUlMjBpcyUyMGJldHRlciUyMHRoYW4lMjBjb21wbGV4LiUyMiUwQSUyMCUyMCUyMCUyMCUyMkNvbXBsZXglMjBpcyUyMGJldHRlciUyMHRoYW4lMjBjb21wbGljYXRlZC4lMjIlMEElMjAlMjAlMjAlMjAlMjJGbGF0JTIwaXMlMjBiZXR0ZXIlMjB0aGFuJTIwbmVzdGVkLiUyMiUwQSUyMCUyMCUyMCUyMCUyMlNwYXJzZSUyMGlzJTIwYmV0dGVyJTIwdGhhbiUyMGRlbnNlLiUyMiUwQSUyMCUyMCUyMCUyMCUyMlJlYWRhYmlsaXR5JTIwY291bnRzLiUyMiUwQSU1RCUwQXRva2VuaXplci50cmFpbl9mcm9tX2l0ZXJhdG9yKGRhdGElMkMlMjB0cmFpbmVyJTNEdHJhaW5lcik=",highlighted:`<span class="hljs-comment"># First few lines of the &quot;Zen of Python&quot; https://www.python.org/dev/peps/pep-0020/</span>
data = [
    <span class="hljs-string">&quot;Beautiful is better than ugly.&quot;</span>
    <span class="hljs-string">&quot;Explicit is better than implicit.&quot;</span>
    <span class="hljs-string">&quot;Simple is better than complex.&quot;</span>
    <span class="hljs-string">&quot;Complex is better than complicated.&quot;</span>
    <span class="hljs-string">&quot;Flat is better than nested.&quot;</span>
    <span class="hljs-string">&quot;Sparse is better than dense.&quot;</span>
    <span class="hljs-string">&quot;Readability counts.&quot;</span>
]
tokenizer.train_from_iterator(data, trainer=trainer)`,wrap:!1}}),k=new bt({props:{title:"Using the 🤗 Datasets library",local:"using-the--datasets-library",headingTag:"h2"}}),z=new H({props:{code:"aW1wb3J0JTIwZGF0YXNldHMlMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldHMubG9hZF9kYXRhc2V0KCUyMndpa2l0ZXh0JTIyJTJDJTIwJTIyd2lraXRleHQtMTAzLXJhdy12MSUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMkJ0ZXN0JTJCdmFsaWRhdGlvbiUyMik=",highlighted:`<span class="hljs-keyword">import</span> datasets
dataset = datasets.load_dataset(<span class="hljs-string">&quot;wikitext&quot;</span>, <span class="hljs-string">&quot;wikitext-103-raw-v1&quot;</span>, split=<span class="hljs-string">&quot;train+test+validation&quot;</span>)`,wrap:!1}}),X=new H({props:{code:"ZGVmJTIwYmF0Y2hfaXRlcmF0b3IoYmF0Y2hfc2l6ZSUzRDEwMDApJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwT25seSUyMGtlZXAlMjB0aGUlMjB0ZXh0JTIwY29sdW1uJTIwdG8lMjBhdm9pZCUyMGRlY29kaW5nJTIwdGhlJTIwcmVzdCUyMG9mJTIwdGhlJTIwY29sdW1ucyUyMHVubmVjZXNzYXJpbHklMEElMjAlMjAlMjAlMjB0b2tfZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuc2VsZWN0X2NvbHVtbnMoJTIydGV4dCUyMiklMEElMjAlMjAlMjAlMjBmb3IlMjBiYXRjaCUyMGluJTIwdG9rX2RhdGFzZXQuaXRlcihiYXRjaF9zaXplKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHlpZWxkJTIwYmF0Y2glNUIlMjJ0ZXh0JTIyJTVE",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">batch_iterator</span>(<span class="hljs-params">batch_size=<span class="hljs-number">1000</span></span>):
    <span class="hljs-comment"># Only keep the text column to avoid decoding the rest of the columns unnecessarily</span>
    tok_dataset = dataset.select_columns(<span class="hljs-string">&quot;text&quot;</span>)
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> tok_dataset.<span class="hljs-built_in">iter</span>(batch_size):
        <span class="hljs-keyword">yield</span> batch[<span class="hljs-string">&quot;text&quot;</span>]`,wrap:!1}}),_=new H({props:{code:"dG9rZW5pemVyLnRyYWluX2Zyb21faXRlcmF0b3IoYmF0Y2hfaXRlcmF0b3IoKSUyQyUyMHRyYWluZXIlM0R0cmFpbmVyJTJDJTIwbGVuZ3RoJTNEbGVuKGRhdGFzZXQpKQ==",highlighted:'tokenizer.train_from_iterator(batch_iterator(), trainer=trainer, length=<span class="hljs-built_in">len</span>(dataset))',wrap:!1}}),R=new bt({props:{title:"Using gzip files",local:"using-gzip-files",headingTag:"h2"}}),V=new H({props:{code:"aW1wb3J0JTIwZ3ppcCUwQXdpdGglMjBnemlwLm9wZW4oJTIyZGF0YSUyRm15LWZpbGUuMC5neiUyMiUyQyUyMCUyMnJ0JTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMHRva2VuaXplci50cmFpbl9mcm9tX2l0ZXJhdG9yKGYlMkMlMjB0cmFpbmVyJTNEdHJhaW5lcik=",highlighted:`<span class="hljs-keyword">import</span> gzip
<span class="hljs-keyword">with</span> gzip.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;data/my-file.0.gz&quot;</span>, <span class="hljs-string">&quot;rt&quot;</span>) <span class="hljs-keyword">as</span> f:
    tokenizer.train_from_iterator(f, trainer=trainer)`,wrap:!1}}),W=new H({props:{code:"ZmlsZXMlMjAlM0QlMjAlNUIlMjJkYXRhJTJGbXktZmlsZS4wLmd6JTIyJTJDJTIwJTIyZGF0YSUyRm15LWZpbGUuMS5neiUyMiUyQyUyMCUyMmRhdGElMkZteS1maWxlLjIuZ3olMjIlNUQlMEFkZWYlMjBnemlwX2l0ZXJhdG9yKCklM0ElMEElMjAlMjAlMjAlMjBmb3IlMjBwYXRoJTIwaW4lMjBmaWxlcyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdpdGglMjBnemlwLm9wZW4ocGF0aCUyQyUyMCUyMnJ0JTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMGxpbmUlMjBpbiUyMGYlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB5aWVsZCUyMGxpbmUlMEF0b2tlbml6ZXIudHJhaW5fZnJvbV9pdGVyYXRvcihnemlwX2l0ZXJhdG9yKCklMkMlMjB0cmFpbmVyJTNEdHJhaW5lcik=",highlighted:`files = [<span class="hljs-string">&quot;data/my-file.0.gz&quot;</span>, <span class="hljs-string">&quot;data/my-file.1.gz&quot;</span>, <span class="hljs-string">&quot;data/my-file.2.gz&quot;</span>]
<span class="hljs-keyword">def</span> <span class="hljs-title function_">gzip_iterator</span>():
    <span class="hljs-keyword">for</span> path <span class="hljs-keyword">in</span> files:
        <span class="hljs-keyword">with</span> gzip.<span class="hljs-built_in">open</span>(path, <span class="hljs-string">&quot;rt&quot;</span>) <span class="hljs-keyword">as</span> f:
            <span class="hljs-keyword">for</span> line <span class="hljs-keyword">in</span> f:
                <span class="hljs-keyword">yield</span> line
tokenizer.train_from_iterator(gzip_iterator(), trainer=trainer)`,wrap:!1}}),F=new Lt({props:{source:"https://github.com/huggingface/tokenizers/blob/main/docs/source-doc-builder/training_from_memory.mdx"}}),{c(){c=i("meta"),E=a(),Q=i("p"),S=a(),p(d.$$.fragment),L=a(),w=i("p"),w.innerHTML=gt,N=a(),f=i("p"),f.innerHTML=Ct,P=a(),p(U.$$.fragment),K=a(),j=i("p"),j.innerHTML=kt,D=a(),J=i("p"),J.innerHTML=It,O=a(),p(b.$$.fragment),tt=a(),T=i("p"),T.innerHTML=$t,et=a(),p(g.$$.fragment),lt=a(),C=i("p"),C.innerHTML=zt,st=a(),p(k.$$.fragment),at=a(),I=i("p"),I.innerHTML=Gt,nt=a(),$=i("p"),$.textContent=Xt,it=a(),p(z.$$.fragment),rt=a(),G=i("p"),G.textContent=Zt,ot=a(),p(X.$$.fragment),pt=a(),Z=i("p"),Z.textContent=vt,Mt=a(),v=i("p"),v.textContent=_t,yt=a(),p(_.$$.fragment),mt=a(),B=i("p"),B.textContent=Bt,ht=a(),p(R.$$.fragment),ut=a(),x=i("p"),x.textContent=Rt,ct=a(),p(V.$$.fragment),dt=a(),A=i("p"),A.textContent=xt,wt=a(),p(W.$$.fragment),ft=a(),Y=i("p"),Y.textContent=Vt,Ut=a(),p(F.$$.fragment),jt=a(),q=i("p"),this.h()},l(t){const e=Et("svelte-u9bgzb",document.head);c=r(e,"META",{name:!0,content:!0}),e.forEach(l),E=n(t),Q=r(t,"P",{}),At(Q).forEach(l),S=n(t),M(d.$$.fragment,t),L=n(t),w=r(t,"P",{"data-svelte-h":!0}),o(w)!=="svelte-zs4zcn"&&(w.innerHTML=gt),N=n(t),f=r(t,"P",{"data-svelte-h":!0}),o(f)!=="svelte-e1cshp"&&(f.innerHTML=Ct),P=n(t),M(U.$$.fragment,t),K=n(t),j=r(t,"P",{"data-svelte-h":!0}),o(j)!=="svelte-n4zs5e"&&(j.innerHTML=kt),D=n(t),J=r(t,"P",{"data-svelte-h":!0}),o(J)!=="svelte-1cm91fx"&&(J.innerHTML=It),O=n(t),M(b.$$.fragment,t),tt=n(t),T=r(t,"P",{"data-svelte-h":!0}),o(T)!=="svelte-800zef"&&(T.innerHTML=$t),et=n(t),M(g.$$.fragment,t),lt=n(t),C=r(t,"P",{"data-svelte-h":!0}),o(C)!=="svelte-2k2g93"&&(C.innerHTML=zt),st=n(t),M(k.$$.fragment,t),at=n(t),I=r(t,"P",{"data-svelte-h":!0}),o(I)!=="svelte-tt7so"&&(I.innerHTML=Gt),nt=n(t),$=r(t,"P",{"data-svelte-h":!0}),o($)!=="svelte-8j5br2"&&($.textContent=Xt),it=n(t),M(z.$$.fragment,t),rt=n(t),G=r(t,"P",{"data-svelte-h":!0}),o(G)!=="svelte-134xe8u"&&(G.textContent=Zt),ot=n(t),M(X.$$.fragment,t),pt=n(t),Z=r(t,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-18jpyth"&&(Z.textContent=vt),Mt=n(t),v=r(t,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1ha2c1s"&&(v.textContent=_t),yt=n(t),M(_.$$.fragment,t),mt=n(t),B=r(t,"P",{"data-svelte-h":!0}),o(B)!=="svelte-9wooxy"&&(B.textContent=Bt),ht=n(t),M(R.$$.fragment,t),ut=n(t),x=r(t,"P",{"data-svelte-h":!0}),o(x)!=="svelte-rvsukz"&&(x.textContent=Rt),ct=n(t),M(V.$$.fragment,t),dt=n(t),A=r(t,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1g7s20h"&&(A.textContent=xt),wt=n(t),M(W.$$.fragment,t),ft=n(t),Y=r(t,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-15ag4ju"&&(Y.textContent=Vt),Ut=n(t),M(F.$$.fragment,t),jt=n(t),q=r(t,"P",{}),At(q).forEach(l),this.h()},h(){Wt(c,"name","hf:doc:metadata"),Wt(c,"content",Pt)},m(t,e){St(document.head,c),s(t,E,e),s(t,Q,e),s(t,S,e),y(d,t,e),s(t,L,e),s(t,w,e),s(t,N,e),s(t,f,e),s(t,P,e),y(U,t,e),s(t,K,e),s(t,j,e),s(t,D,e),s(t,J,e),s(t,O,e),y(b,t,e),s(t,tt,e),s(t,T,e),s(t,et,e),y(g,t,e),s(t,lt,e),s(t,C,e),s(t,st,e),y(k,t,e),s(t,at,e),s(t,I,e),s(t,nt,e),s(t,$,e),s(t,it,e),y(z,t,e),s(t,rt,e),s(t,G,e),s(t,ot,e),y(X,t,e),s(t,pt,e),s(t,Z,e),s(t,Mt,e),s(t,v,e),s(t,yt,e),y(_,t,e),s(t,mt,e),s(t,B,e),s(t,ht,e),y(R,t,e),s(t,ut,e),s(t,x,e),s(t,ct,e),y(V,t,e),s(t,dt,e),s(t,A,e),s(t,wt,e),y(W,t,e),s(t,ft,e),s(t,Y,e),s(t,Ut,e),y(F,t,e),s(t,jt,e),s(t,q,e),Jt=!0},p:Ft,i(t){Jt||(m(d.$$.fragment,t),m(U.$$.fragment,t),m(b.$$.fragment,t),m(g.$$.fragment,t),m(k.$$.fragment,t),m(z.$$.fragment,t),m(X.$$.fragment,t),m(_.$$.fragment,t),m(R.$$.fragment,t),m(V.$$.fragment,t),m(W.$$.fragment,t),m(F.$$.fragment,t),Jt=!0)},o(t){h(d.$$.fragment,t),h(U.$$.fragment,t),h(b.$$.fragment,t),h(g.$$.fragment,t),h(k.$$.fragment,t),h(z.$$.fragment,t),h(X.$$.fragment,t),h(_.$$.fragment,t),h(R.$$.fragment,t),h(V.$$.fragment,t),h(W.$$.fragment,t),h(F.$$.fragment,t),Jt=!1},d(t){t&&(l(E),l(Q),l(S),l(L),l(w),l(N),l(f),l(P),l(K),l(j),l(D),l(J),l(O),l(tt),l(T),l(et),l(lt),l(C),l(st),l(at),l(I),l(nt),l($),l(it),l(rt),l(G),l(ot),l(pt),l(Z),l(Mt),l(v),l(yt),l(mt),l(B),l(ht),l(ut),l(x),l(ct),l(dt),l(A),l(wt),l(ft),l(Y),l(Ut),l(jt),l(q)),l(c),u(d,t),u(U,t),u(b,t),u(g,t),u(k,t),u(z,t),u(X,t),u(_,t),u(R,t),u(V,t),u(W,t),u(F,t)}}}const Pt='{"title":"Training from memory","local":"training-from-memory","sections":[{"title":"The most basic way","local":"the-most-basic-way","sections":[],"depth":2},{"title":"Using the 🤗 Datasets library","local":"using-the--datasets-library","sections":[],"depth":2},{"title":"Using gzip files","local":"using-gzip-files","sections":[],"depth":2}],"depth":1}';function Kt(Tt){return Ht(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class le extends Qt{constructor(c){super(),qt(this,c,Kt,Nt,Yt,{})}}export{le as component};
