import{s as fJ,o as _J,n as x}from"../chunks/scheduler.25b97de1.js";import{S as bJ,i as yJ,g as o,s as r,r as m,A as TJ,h as l,f as n,c as a,j as T,u as h,x as y,k as v,y as t,a as d,v as g,d as u,t as f,w as _}from"../chunks/index.d9030fc9.js";import{T as vr}from"../chunks/Tip.baa67368.js";import{D as M}from"../chunks/Docstring.ffac8efa.js";import{C as Z}from"../chunks/CodeBlock.e6cd0d95.js";import{E as C}from"../chunks/ExampleCodeBlock.22dfe688.js";import{H as ge,E as vJ}from"../chunks/EditOnGithub.91d95064.js";function MJ(j){let c,$=`This logits processor is exclusively compatible with
<a href="https://huggingface.co/docs/transformers/en/model_doc/bark" rel="nofollow">Bark</a>’s fine submodel. See the model documentation
for examples.`;return{c(){c=o("p"),c.innerHTML=$},l(b){c=l(b,"P",{"data-svelte-h":!0}),y(c)!=="svelte-nbt45a"&&(c.innerHTML=$)},m(b,p){d(b,c,p)},p:x,d(b){b&&n(c)}}}function wJ(j){let c,$=`This logits processor is exclusively compatible with
<a href="https://huggingface.co/docs/transformers/main/en/model_doc/musicgen" rel="nofollow">MusicGen</a>`;return{c(){c=o("p"),c.innerHTML=$},l(b){c=l(b,"P",{"data-svelte-h":!0}),y(c)!=="svelte-1uojnuk"&&(c.innerHTML=$)},m(b,p){d(b,c,p)},p:x,d(b){b&&n(c)}}}function kJ(j){let c,$="Examples:",b,p,w;return p=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtdXNpY2dlbi1zbWFsbCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoJTBBJTIwJTIwJTIwJTIwdGV4dCUzRCU1QiUyMjgwcyUyMHBvcCUyMHRyYWNrJTIwd2l0aCUyMGJhc3N5JTIwZHJ1bXMlMjBhbmQlMjBzeW50aCUyMiUyQyUyMCUyMjkwcyUyMHJvY2slMjBzb25nJTIwd2l0aCUyMGxvdWQlMjBndWl0YXJzJTIwYW5kJTIwaGVhdnklMjBkcnVtcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHBhZGRpbmclM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUwQSklMEFhdWRpb192YWx1ZXMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDI1Nik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MusicgenForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;80s pop track with bassy drums and synth&quot;</span>, <span class="hljs-string">&quot;90s rock song with loud guitars and heavy drums&quot;</span>],
<span class="hljs-meta">... </span>    padding=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_values = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, guidance_scale=<span class="hljs-number">3</span>, max_new_tokens=<span class="hljs-number">256</span>)`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,b=r(),m(p.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=$),b=a(s),h(p.$$.fragment,s)},m(s,k){d(s,c,k),d(s,b,k),g(p,s,k),w=!0},p:x,i(s){w||(u(p.$$.fragment,s),w=!0)},o(s){f(p.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(p,s)}}}function $J(j){let c,$="Examples:",b,p,w;return p=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkFsaWNlJTNBJTIwSSUyMGxvdmUlMjBjYXRzLiUyMFdoYXQlMjBkbyUyMHlvdSUyMGxvdmUlM0YlNUNuQm9iJTNBJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBXaXRoJTIwZ3JlZWR5JTIwZGVjb2RpbmclMkMlMjB3ZSUyMHNlZSUyMEJvYiUyMHJlcGVhdGluZyUyMEFsaWNlJ3MlMjBvcGluaW9uLiUyMElmJTIwQm9iJTIwd2FzJTIwYSUyMGNoYXRib3QlMkMlMjBpdCUyMHdvdWxkJTIwYmUlMjBhJTIwcG9vciUyMG9uZS4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBXaXRoJTIwdGhpcyUyMGxvZ2l0cyUyMHByb2Nlc3NvciUyQyUyMHdlJTIwY2FuJTIwcHJldmVudCUyMEJvYiUyMGZyb20lMjByZXBlYXRpbmclMjBBbGljZSdzJTIwb3Bpbmlvbi4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBlbmNvZGVyX25vX3JlcGVhdF9uZ3JhbV9zaXplJTNEMiklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Alice: I love cats. What do you love?\\nBob:&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With greedy decoding, we see Bob repeating Alice&#x27;s opinion. If Bob was a chatbot, it would be a poor one.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice: I love cats. What do you love?
Bob: I love cats. What do you

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With this logits processor, we can prevent Bob from repeating Alice&#x27;s opinion.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, encoder_no_repeat_ngram_size=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice: I love cats. What do you love?
Bob: My cats are very cute.`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,b=r(),m(p.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=$),b=a(s),h(p.$$.fragment,s)},m(s,k){d(s,c,k),d(s,b,k),g(p,s,k),w=!0},p:x,i(s){w||(u(p.$$.fragment,s),w=!0)},o(s){f(p.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(p,s)}}}function jJ(j){let c,$="Examples:",b,p,w;return p=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkFsaWNlJTIwYW5kJTIwQm9iLiUyMFRoZSUyMHRoaXJkJTIwbWVtYmVyJ3MlMjBuYW1lJTIwd2FzJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFnZW5fb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fb3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBXaXRoJTIwdGhlJTIwJTYwZW5jb2Rlcl9yZXBldGl0aW9uX3BlbmFsdHklNjAlMjBhcmd1bWVudCUyMHdlJTIwY2FuJTIwdHJpZ2dlciUyMHRoaXMlMjBsb2dpdHMlMjBwcm9jZXNzb3IlMjBpbiUyMCU2MGdlbmVyYXRlJTYwJTJDJTIwd2hpY2glMjBjYW4lMEElMjMlMjBwcm9tb3RlJTIwdGhlJTIwdXNlJTIwb2YlMjBwcm9tcHQlMjB0b2tlbnMlMjAoJTIyQm9iJTIyJTIwaW4lMjB0aGlzJTIwZXhhbXBsZSklMEFnZW5fb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBlbmNvZGVyX3JlcGV0aXRpb25fcGVuYWx0eSUzRDEuMiklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbl9vdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Alice and Bob. The third member&#x27;s name was&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice <span class="hljs-keyword">and</span> Bob. The third membe<span class="hljs-string">r&#x27;s name was not mentioned.

&gt;&gt;&gt; # With the \`encoder_repetition_penalty\` argument we can trigger this logits processor in \`generate\`, which can
&gt;&gt;&gt; # promote the use of prompt tokens (&quot;Bob&quot; in this example)
&gt;&gt;&gt; gen_out = model.generate(**inputs, encoder_repetition_penalty=1.2)
&gt;&gt;&gt; print(tokenizer.batch_decode(gen_out, skip_special_tokens=True)[0])
Alice and Bob. The third member&#x27;</span>s name was Bob. The third membe<span class="hljs-string">r&#x27;s name was Bob.</span>`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,b=r(),m(p.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=$),b=a(s),h(p.$$.fragment,s)},m(s,k){d(s,c,k),d(s,b,k),g(p,s,k),w=!0},p:x,i(s){w||(u(p.$$.fragment,s),w=!0)},o(s){f(p.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(p,s)}}}function xJ(j){let c,$="Examples:",b,p,w;return p=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMSklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyQSUyMHNlcXVlbmNlJTNBJTIwMSUyQyUyMDIlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFdpdGglMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGlzJTIwdW5leHBlY3RlZCUyMC0tJTIwc29tZXRpbWVzJTIwdG9vJTIwdW5leHBlY3RlZC4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwV2l0aCUyMGVwc2lsb24lMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGdldHMlMjByZXN0cmljdGVkJTIwdG8lMjBoaWdoLXByb2JhYmlsaXR5JTIwdG9rZW5zLiUyME5vdGUlMjB0aGF0JTIwdGhpcyUyMGlzJTIwc2ltaWxhciUyMHRvJTBBJTIzJTIwVG9wJTIwUCUyMHNhbXBsaW5nJTJDJTIwd2hpY2glMjByZXN0cmljdHMlMjB0b2tlbnMlMjBiYXNlZCUyMG9uJTIwdGhlaXIlMjBjdW11bGF0aXZlJTIwcHJvYmFiaWxpdHkuJTBBJTIzJTIwUHJvJTIwdGlwJTNBJTIwVGhlJTIwcGFwZXIlMjByZWNvbWVuZHMlMjB1c2luZyUyMCU2MGVwc2lsb25fY3V0b2ZmJTYwJTIwdmFsdWVzJTIwYmV0d2VlbiUyMDNlLTQlMjBhbmQlMjA5ZS00JTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUyMGVwc2lsb25fY3V0b2ZmJTNEMC4xKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span> | &lt; <span class="hljs-number">4</span> (left-hand pointer) ;
&lt;BLANKLINE&gt;
&lt;BLANKLINE&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With epsilon sampling, the output gets restricted to high-probability tokens. Note that this is similar to</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Top P sampling, which restricts tokens based on their cumulative probability.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: The paper recomends using \`epsilon_cutoff\` values between 3e-4 and 9e-4</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, epsilon_cutoff=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,b=r(),m(p.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=$),b=a(s),h(p.$$.fragment,s)},m(s,k){d(s,c,k),d(s,b,k),g(p,s,k),w=!0},p:x,i(s){w||(u(p.$$.fragment,s),w=!0)},o(s){f(p.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(p,s)}}}function JJ(j){let c,$="Examples:",b,p,w;return p=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMSklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyQSUyMHNlcXVlbmNlJTNBJTIwMSUyQyUyMDIlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFdpdGglMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGlzJTIwdW5leHBlY3RlZCUyMC0tJTIwc29tZXRpbWVzJTIwdG9vJTIwdW5leHBlY3RlZC4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwV2l0aCUyMGV0YSUyMHNhbXBsaW5nJTJDJTIwdGhlJTIwb3V0cHV0JTIwZ2V0cyUyMHJlc3RyaWN0ZWQlMjB0byUyMGhpZ2gtcHJvYmFiaWxpdHklMjB0b2tlbnMuJTIwWW91JTIwY2FuJTIwc2VlJTIwaXQlMjBhcyUyMGElMjBkeW5hbWljJTIwZm9ybSUyMG9mJTBBJTIzJTIwZXBzaWxvbiUyMHNhbXBsaW5nJTIwdGhhdCUyMGFkYXB0cyUyMGl0cyUyMGN1dG9mZiUyMHByb2JhYmlsaXR5JTIwYmFzZWQlMjBvbiUyMHRoZSUyMGVudHJvcHklMjAoaGlnaCUyMGVudHJvcHklMjAlM0QlMjBsb3dlciUyMGN1dG9mZikuJTBBJTIzJTIwUHJvJTIwdGlwJTNBJTIwVGhlJTIwcGFwZXIlMjByZWNvbWVuZHMlMjB1c2luZyUyMCU2MGV0YV9jdXRvZmYlNjAlMjB2YWx1ZXMlMjBiZXR3ZWVuJTIwM2UtNCUyMHRvJTIwNGUtMyUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjBldGFfY3V0b2ZmJTNEMC4xKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span> | &lt; <span class="hljs-number">4</span> (left-hand pointer) ;
&lt;BLANKLINE&gt;
&lt;BLANKLINE&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With eta sampling, the output gets restricted to high-probability tokens. You can see it as a dynamic form of</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># epsilon sampling that adapts its cutoff probability based on the entropy (high entropy = lower cutoff).</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: The paper recomends using \`eta_cutoff\` values between 3e-4 to 4e-3</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, eta_cutoff=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,b=r(),m(p.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=$),b=a(s),h(p.$$.fragment,s)},m(s,k){d(s,c,k),d(s,b,k),g(p,s,k),w=!0},p:x,i(s){w||(u(p.$$.fragment,s),w=!0)},o(s){f(p.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(p,s)}}}function UJ(j){let c,$="Examples:",b,p,w;return p=new Z({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;Just wanted to let you know, I&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Let&#x27;s consider that we want short sentences, so we limit \`max_length=30\`. However, we observe that the answer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># tends to end abruptly.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, temperature=<span class="hljs-number">0.9</span>, max_length=<span class="hljs-number">30</span>, pad_token_id=<span class="hljs-number">50256</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
Just wanted to let you know, I received a link to an ebook, the book How To Start A Social Network which was
published <span class="hljs-keyword">in</span> <span class="hljs-number">2010.</span> Although

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To promote the appearance of the EOS token at the right time, we add the \`exponential_decay_length_penalty =</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># (start_index, decay_factor)\`. Instead of cutting at max_tokens, the output comes to an end before and usually</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># with more meaning. What happens is that starting from \`start_index\` the EOS token score will be increased</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># by \`decay_factor\` exponentially. However, if you set a high decay factor, you may also end up with abruptly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># ending sequences.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    temperature=<span class="hljs-number">0.9</span>,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">30</span>,
<span class="hljs-meta">... </span>    pad_token_id=<span class="hljs-number">50256</span>,
<span class="hljs-meta">... </span>    exponential_decay_length_penalty=(<span class="hljs-number">15</span>, <span class="hljs-number">1.6</span>),
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
Just wanted to let you know, I received a link to an ebook, the book How To Start A Social Network
which&lt;|endoftext|&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With a small decay factor, you will have a higher chance of getting a meaningful sequence.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    temperature=<span class="hljs-number">0.9</span>,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">30</span>,
<span class="hljs-meta">... </span>    pad_token_id=<span class="hljs-number">50256</span>,
<span class="hljs-meta">... </span>    exponential_decay_length_penalty=(<span class="hljs-number">15</span>, <span class="hljs-number">1.01</span>),
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
Just wanted to let you know, I received a link to an ebook, the book How To Start A Social Network which was
published <span class="hljs-keyword">in</span> <span class="hljs-number">2010.</span>&lt;|endoftext|&gt;`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,b=r(),m(p.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=$),b=a(s),h(p.$$.fragment,s)},m(s,k){d(s,c,k),d(s,b,k),g(p,s,k),w=!0},p:x,i(s){w||(u(p.$$.fragment,s),w=!0)},o(s){f(p.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(p,s)}}}function ZJ(j){let c,$="Examples:",b,p,w;return p=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGZmxhbi10NS1zbWFsbCUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZmbGFuLXQ1LXNtYWxsJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJUcmFuc2xhdGUlMjBmcm9tJTIwRW5nbGlzaCUyMHRvJTIwR2VybWFuJTNBJTIwSSUyMGxvdmUlMjBjYXRzLiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwQnklMjBkZWZhdWx0JTJDJTIwaXQlMjBjb250aW51ZXMlMjBnZW5lcmF0aW5nJTIwYWNjb3JkaW5nJTIwdG8lMjB0aGUlMjBtb2RlbCdzJTIwbG9naXRzJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMpJTVCMCU1RCklMEElMEElMjMlMjBXZSUyMGNhbiUyMHVzZSUyMCU2MGZvcmNlZF9ib3NfdG9rZW5faWQlNjAlMjB0byUyMGZvcmNlJTIwdGhlJTIwc3RhcnQlMjBvZiUyMGdlbmVyYXRpb24lMjB3aXRoJTIwYW4lMjBlbmNvZGVyLWRlY29kZXIlMjBtb2RlbCUwQSUyMyUyMChpbmNsdWRpbmclMjBmb3JjaW5nJTIwaXQlMjB0byUyMGVuZCUyMHN0cmFpZ2h0JTIwYXdheSUyMHdpdGglMjBhbiUyMEVPUyUyMHRva2VuKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTAlMkMlMjBmb3JjZWRfYm9zX3Rva2VuX2lkJTNEdG9rZW5pemVyLmVvc190b2tlbl9pZCklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;google/flan-t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/flan-t5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Translate from English to German: I love cats.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, it continues generating according to the model&#x27;s logits</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
&lt;pad&gt; Ich liebe Kitty.&lt;/s&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can use \`forced_bos_token_id\` to force the start of generation with an encoder-decoder model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># (including forcing it to end straight away with an EOS token)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>, forced_bos_token_id=tokenizer.eos_token_id)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
&lt;pad&gt;&lt;/s&gt;`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,b=r(),m(p.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=$),b=a(s),h(p.$$.fragment,s)},m(s,k){d(s,c,k),d(s,b,k),g(p,s,k),w=!0},p:x,i(s){w||(u(p.$$.fragment,s),w=!0)},o(s){f(p.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(p,s)}}}function CJ(j){let c,$="Examples:",b,p,w;return p=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJBJTIwc2VxdWVuY2UlM0ElMjAxJTJDJTIwMiUyQyUyMDMlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMEJ5JTIwZGVmYXVsdCUyQyUyMGl0JTIwY29udGludWVzJTIwZ2VuZXJhdGluZyUyMGFjY29yZGluZyUyMHRvJTIwdGhlJTIwbW9kZWwncyUyMGxvZ2l0cyUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTApJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzKSU1QjAlNUQpJTBBJTBBJTIzJTIwJTYwZm9yY2VkX2Vvc190b2tlbl9pZCU2MCUyMGVuc3VyZXMlMjB0aGUlMjBnZW5lcmF0aW9uJTIwZW5kcyUyMHdpdGglMjBhJTIwRU9TJTIwdG9rZW4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEwJTJDJTIwZm9yY2VkX2Vvc190b2tlbl9pZCUzRHRva2VuaXplci5lb3NfdG9rZW5faWQpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzKSU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2, 3&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, it continues generating according to the model&#x27;s logits</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># \`forced_eos_token_id\` ensures the generation ends with a EOS token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>, forced_eos_token_id=tokenizer.eos_token_id)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>,&lt;|endoftext|&gt;`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,b=r(),m(p.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=$),b=a(s),h(p.$$.fragment,s)},m(s,k){d(s,c,k),d(s,b,k),g(p,s,k),w=!0},p:x,i(s){w||(u(p.$$.fragment,s),w=!0)},o(s){f(p.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(p,s)}}}function WJ(j){let c,$="Examples:",b,p,w;return p=new Z({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initialize the model and tokenizer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># A long text about the solar system</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;The Solar System is a gravitationally bound system comprising the Sun and the objects that orbit it, &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;either directly or indirectly. Of the objects that orbit the Sun directly, the largest are the eight &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;planets, with the remainder being smaller objects, such as the five dwarf planets and small Solar System &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;bodies. The Solar System formed 4.6 billion years ago from the gravitational collapse of a giant &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;interstellar molecular cloud.&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;summarize: &quot;</span> + text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate diverse summary</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs_diverse = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    num_beam_groups=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    diversity_penalty=<span class="hljs-number">10.0</span>,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>summaries_diverse = tokenizer.batch_decode(outputs_diverse, skip_special_tokens=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate non-diverse summary</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs_non_diverse = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>summary_non_diverse = tokenizer.batch_decode(outputs_non_diverse, skip_special_tokens=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`diversity_penalty\`, the resulting beams are much more diverse</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(summary_non_diverse)
[<span class="hljs-string">&#x27;the solar system formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets.&#x27;</span>,
<span class="hljs-string">&#x27;the Solar System formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets.&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(summaries_diverse)
[<span class="hljs-string">&#x27;the solar system formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets.&#x27;</span>,
<span class="hljs-string">&#x27;the solar system formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets. the rest of the objects are smaller objects, such as the five dwarf planets and small solar system bodies.&#x27;</span>]`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,b=r(),m(p.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=$),b=a(s),h(p.$$.fragment,s)},m(s,k){d(s,c,k),d(s,b,k),g(p,s,k),w=!0},p:x,i(s){w||(u(p.$$.fragment,s),w=!0)},o(s){f(p.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(p,s)}}}function BJ(j){let c,$="Examples:",b,p,w;return p=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZGlzdGlsYmVydCUyRmRpc3RpbGdwdDIlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZGlzdGlsYmVydCUyRmRpc3RpbGdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkElMjBzZXF1ZW5jZSUzQSUyMDElMkMlMjAyJTJDJTIwMyUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwQnklMjBkZWZhdWx0JTJDJTIwdGhlJTIwc2NvcmVzJTIwYXJlJTIwbm90JTIwbm9ybWFsaXplZCUyMC0tJTIwdGhlJTIwc3VtJTIwb2YlMjB0aGVpciUyMGV4cG9uZW50aWFscyUyMGlzJTIwTk9UJTIwYSUyMG5vcm1hbGl6ZWQlMjBwcm9iYWJpbGl0eSUwQSUyMyUyMGRpc3RyaWJ1dGlvbiUyQyUyMHN1bW1pbmclMjB0byUyMDElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjByZXR1cm5fZGljdF9pbl9nZW5lcmF0ZSUzRFRydWUlMkMlMjBvdXRwdXRfc2NvcmVzJTNEVHJ1ZSklMEFwcmludCh0b3JjaC5hbGxjbG9zZSh0b3JjaC5zdW0odG9yY2guZXhwKG91dHB1dHMuc2NvcmVzJTVCLTElNUQpKSUyQyUyMHRvcmNoLlRlbnNvcigoMS4wMDAlMkMpKSUyQyUyMHJ0b2wlM0QxZS00KSklMEElMEElMjMlMjBOb3JtYWxpemluZyUyMHRoZW0lMjBtYXklMjBoYXZlJTIwYSUyMHBvc2l0aXZlJTIwaW1wYWN0JTIwb24lMjBiZWFtJTIwbWV0aG9kcyUyQyUyMG9yJTIwd2hlbiUyMHVzaW5nJTIwdGhlJTIwc2NvcmVzJTIwb24lMjB5b3VyJTIwYXBwbGljYXRpb24lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjByZW5vcm1hbGl6ZV9sb2dpdHMlM0RUcnVlJTJDJTIwcmV0dXJuX2RpY3RfaW5fZ2VuZXJhdGUlM0RUcnVlJTJDJTIwb3V0cHV0X3Njb3JlcyUzRFRydWUpJTBBcHJpbnQodG9yY2guYWxsY2xvc2UodG9yY2guc3VtKHRvcmNoLmV4cChvdXRwdXRzLnNjb3JlcyU1Qi0xJTVEKSklMkMlMjB0b3JjaC5UZW5zb3IoKDEuMDAwJTJDKSklMkMlMjBydG9sJTNEMWUtNCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2, 3&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, the scores are not normalized -- the sum of their exponentials is NOT a normalized probability</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># distribution, summing to 1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(torch.allclose(torch.<span class="hljs-built_in">sum</span>(torch.exp(outputs.scores[-<span class="hljs-number">1</span>])), torch.Tensor((<span class="hljs-number">1.000</span>,)), rtol=<span class="hljs-number">1e-4</span>))
<span class="hljs-literal">False</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Normalizing them may have a positive impact on beam methods, or when using the scores on your application</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, renormalize_logits=<span class="hljs-literal">True</span>, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(torch.allclose(torch.<span class="hljs-built_in">sum</span>(torch.exp(outputs.scores[-<span class="hljs-number">1</span>])), torch.Tensor((<span class="hljs-number">1.000</span>,)), rtol=<span class="hljs-number">1e-4</span>))
<span class="hljs-literal">True</span>`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,b=r(),m(p.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=$),b=a(s),h(p.$$.fragment,s)},m(s,k){d(s,c,k),d(s,b,k),g(p,s,k),w=!0},p:x,i(s){w||(u(p.$$.fragment,s),w=!0)},o(s){f(p.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(p,s)}}}function zJ(j){let c,$="Examples:",b,p,w;return p=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkElMjBudW1iZXIlM0ElMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQWdlbl9vdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbl9vdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKSUwQSUwQSUyMyUyMHNldHRpbmclMjAlNjBtaW5fbGVuZ3RoJTYwJTIwdG8lMjBhJTIwdmFsdWUlMjBzbWFsbGVyJTIwdGhhbiUyMHRoZSUyMHVuY29udHJvbGxlZCUyMG91dHB1dCUyMGxlbmd0aCUyMGhhcyUyMG5vJTIwaW1wYWN0JTBBZ2VuX291dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWluX2xlbmd0aCUzRDMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fb3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBzZXR0aW5nJTIwYSUyMGxhcmdlciUyMCU2MG1pbl9sZW5ndGglNjAlMjB3aWxsJTIwZm9yY2UlMjB0aGUlMjBtb2RlbCUyMHRvJTIwZ2VuZXJhdGUlMjBiZXlvbmQlMjBpdHMlMjBuYXR1cmFsJTIwZW5kaW5nJTIwcG9pbnQlMkMlMjB3aGljaCUyMGlzJTIwbm90JTBBJTIzJTIwbmVjZXNzYXJpbHklMjBpbmNvcnJlY3QlMEFnZW5fb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtaW5fbGVuZ3RoJTNEMTApJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fb3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A number:&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># setting \`min_length\` to a value smaller than the uncontrolled output length has no impact</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs, min_length=<span class="hljs-number">3</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># setting a larger \`min_length\` will force the model to generate beyond its natural ending point, which is not</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># necessarily incorrect</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs, min_length=<span class="hljs-number">10</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one thousand, nine hundred <span class="hljs-keyword">and</span> ninety-four`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,b=r(),m(p.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=$),b=a(s),h(p.$$.fragment,s)},m(s,k){d(s,c,k),d(s,b,k),g(p,s,k),w=!0},p:x,i(s){w||(u(p.$$.fragment,s),w=!0)},o(s){f(p.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(p,s)}}}function IJ(j){let c,$="Examples:",b,p,w;return p=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkElMjBudW1iZXIlM0ElMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQWdlbl9vdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbl9vdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKSUwQSUwQSUyMyUyMHNldHRpbmclMjAlNjBtaW5fbmV3X3Rva2VucyU2MCUyMHdpbGwlMjBmb3JjZSUyMHRoZSUyMG1vZGVsJTIwdG8lMjBnZW5lcmF0ZSUyMGJleW9uZCUyMGl0cyUyMG5hdHVyYWwlMjBlbmRpbmclMjBwb2ludCUyQyUyMHdoaWNoJTIwaXMlMjBub3QlMEElMjMlMjBuZWNlc3NhcmlseSUyMGluY29ycmVjdCUwQWdlbl9vdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1pbl9uZXdfdG9rZW5zJTNEMiklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbl9vdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;A number:&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># setting \`min_new_tokens\` will force the model to generate beyond its natural ending point, which is not</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># necessarily incorrect</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs, min_new_tokens=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one thousand`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,b=r(),m(p.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=$),b=a(s),h(p.$$.fragment,s)},m(s,k){d(s,c,k),d(s,b,k),g(p,s,k),w=!0},p:x,i(s){w||(u(p.$$.fragment,s),w=!0)},o(s){f(p.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(p,s)}}}function VJ(j){let c,$="Examples:",b,p,w;return p=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMSklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyQSUyMHNlcXVlbmNlJTNBJTIwMSUyQyUyMDIlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFdpdGglMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGlzJTIwdW5leHBlY3RlZCUyMC0tJTIwc29tZXRpbWVzJTIwdG9vJTIwdW5leHBlY3RlZC4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwV2l0aCUyMCU2MG1pbl9wJTYwJTIwc2FtcGxpbmclMkMlMjB0aGUlMjBvdXRwdXQlMjBnZXRzJTIwcmVzdHJpY3RlZCUyMHRvJTIwaGlnaC1wcm9iYWJpbGl0eSUyMHRva2Vucy4lMEElMjMlMjBQcm8lMjB0aXAlM0ElMjBJbiUyMHByYWN0aWNlJTJDJTIwTExNcyUyMHVzZSUyMCU2MG1pbl9wJTYwJTIwaW4lMjB0aGUlMjAwLjAxLTAuMiUyMHJhbmdlLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjBtaW5fcCUzRDAuMSklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span> | &lt; <span class="hljs-number">4</span> (left-hand pointer) ;
&lt;BLANKLINE&gt;
&lt;BLANKLINE&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`min_p\` sampling, the output gets restricted to high-probability tokens.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: In practice, LLMs use \`min_p\` in the 0.01-0.2 range.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, min_p=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,b=r(),m(p.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=$),b=a(s),h(p.$$.fragment,s)},m(s,k){d(s,c,k),d(s,b,k),g(p,s,k),w=!0},p:x,i(s){w||(u(p.$$.fragment,s),w=!0)},o(s){f(p.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(p,s)}}}function GJ(j){let c,$=`In order to get the token ids of the words that should not appear in the generated text, make sure to set
<code>add_prefix_space=True</code> when initializing the tokenizer, and use <code>tokenizer(bad_words, add_special_tokens=False).input_ids</code>. The <code>add_prefix_space</code> argument is only supported for some slow tokenizers,
as fast tokenizers’ prefixing behaviours come from <code>pre tokenizers</code>. Read more
<a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">here</a>.`;return{c(){c=o("p"),c.innerHTML=$},l(b){c=l(b,"P",{"data-svelte-h":!0}),y(c)!=="svelte-15bvr1j"&&(c.innerHTML=$)},m(b,p){d(b,c,p)},p:x,d(b){b&&n(c)}}}function FJ(j){let c,$="Examples:",b,p,w;return p=new Z({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;In a word, the cake is a&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>output_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">5</span>, pad_token_id=tokenizer.eos_token_id)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(output_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
In a word, the cake <span class="hljs-keyword">is</span> a bit of a mess.

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Now let&#x27;s take the bad words out. Please note that the tokenizer is initialized differently</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_with_prefix_space = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>, add_prefix_space=<span class="hljs-literal">True</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">get_tokens_as_list</span>(<span class="hljs-params">word_list</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Converts a sequence of words into a list of tokens&quot;</span>
<span class="hljs-meta">... </span>    tokens_list = []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_list:
<span class="hljs-meta">... </span>        tokenized_word = tokenizer_with_prefix_space([word], add_special_tokens=<span class="hljs-literal">False</span>).input_ids[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>        tokens_list.append(tokenized_word)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> tokens_list


<span class="hljs-meta">&gt;&gt;&gt; </span>bad_words_ids = get_tokens_as_list(word_list=[<span class="hljs-string">&quot;mess&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>output_ids = model.generate(
<span class="hljs-meta">... </span>    inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">5</span>, bad_words_ids=bad_words_ids, pad_token_id=tokenizer.eos_token_id
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(output_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
In a word, the cake <span class="hljs-keyword">is</span> a bit of a surprise.`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,b=r(),m(p.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=$),b=a(s),h(p.$$.fragment,s)},m(s,k){d(s,c,k),d(s,b,k),g(p,s,k),w=!0},p:x,i(s){w||(u(p.$$.fragment,s),w=!0)},o(s){f(p.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(p,s)}}}function XJ(j){let c,$=`Use n-gram penalties with care. For instance, penalizing 2-grams (bigrams) in an article about the city of New York
might lead to undesirable outcomes where the city’s name appears only once in the entire text.
<a href="https://huggingface.co/blog/how-to-generate" rel="nofollow">Reference</a>`;return{c(){c=o("p"),c.innerHTML=$},l(b){c=l(b,"P",{"data-svelte-h":!0}),y(c)!=="svelte-5zfsi9"&&(c.innerHTML=$)},m(b,p){d(b,c,p)},p:x,d(b){b&&n(c)}}}function LJ(j){let c,$="Examples:",b,p,w;return p=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJUb2RheSUyMEklMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW91dHB1dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzKSUwQXByaW50KHRva2VuaXplci5kZWNvZGUob3V0cHV0JTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSklMEElMEElMjMlMjBOb3clMjBsZXQncyUyMGFkZCUyMG5ncmFtJTIwc2l6ZSUyMHVzaW5nJTIwJTYwbm9fcmVwZWF0X25ncmFtX3NpemUlNjAuJTIwVGhpcyUyMHN0b3BzJTIwdGhlJTIwcmVwZXRpdGlvbnMlMjAoJTIySSVFMiU4MCU5OW0lMjIpJTIwaW4lMjB0aGUlMjBvdXRwdXQuJTBBb3V0cHV0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBub19yZXBlYXRfbmdyYW1fc2l6ZSUzRDIpJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShvdXRwdXQlNUIwJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Today I&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>output = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Today I’m <span class="hljs-keyword">not</span> sure <span class="hljs-keyword">if</span> I’m going to be able to do it.

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Now let&#x27;s add ngram size using \`no_repeat_ngram_size\`. This stops the repetitions (&quot;I’m&quot;) in the output.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output = model.generate(**inputs, no_repeat_ngram_size=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Today I’m <span class="hljs-keyword">not</span> sure <span class="hljs-keyword">if</span> I can get a better understanding of the nature of this issue`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,b=r(),m(p.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=$),b=a(s),h(p.$$.fragment,s)},m(s,k){d(s,c,k),d(s,b,k),g(p,s,k),w=!0},p:x,i(s){w||(u(p.$$.fragment,s),w=!0)},o(s){f(p.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(p,s)}}}function RJ(j){let c,$="Examples:",b,p,w;return p=new Z({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Alice and Bob&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, it continues generating according to the model&#x27;s logits</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice <span class="hljs-keyword">and</span> Bob are friends

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can contrain it with \`prefix_allowed_tokens_fn\` to force a certain behavior based on a prefix.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># For instance, we can force an entire entity to be generated when its beginning is detected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>entity = tokenizer(<span class="hljs-string">&quot; Bob Marley&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids[<span class="hljs-number">0</span>]  <span class="hljs-comment"># 3 tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">prefix_allowed_tokens_fn</span>(<span class="hljs-params">batch_id, input_ids</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>    Attempts to generate &#x27;Bob Marley&#x27; when &#x27;Bob&#x27; is detected.
<span class="hljs-meta">... </span>    In this case, \`batch_id\` is not used, but you can set rules for each batch member.
<span class="hljs-meta">... </span>    &#x27;&#x27;&#x27;</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> input_ids[-<span class="hljs-number">1</span>] == entity[<span class="hljs-number">0</span>]:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> [entity[<span class="hljs-number">1</span>].item()]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">elif</span> input_ids[-<span class="hljs-number">2</span>] == entity[<span class="hljs-number">0</span>] <span class="hljs-keyword">and</span> input_ids[-<span class="hljs-number">1</span>] == entity[<span class="hljs-number">1</span>]:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> [entity[<span class="hljs-number">2</span>].item()]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> <span class="hljs-built_in">list</span>(<span class="hljs-built_in">range</span>(tokenizer.vocab_size))  <span class="hljs-comment"># If no match, allow all tokens</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">5</span>, prefix_allowed_tokens_fn=prefix_allowed_tokens_fn)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice <span class="hljs-keyword">and</span> Bob Marley`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,b=r(),m(p.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=$),b=a(s),h(p.$$.fragment,s)},m(s,k){d(s,c,k),d(s,b,k),g(p,s,k),w=!0},p:x,i(s){w||(u(p.$$.fragment,s),w=!0)},o(s){f(p.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(p,s)}}}function SJ(j){let c,$="Examples:",b,p,w;return p=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMHRoZSUyMG1vZGVsJTIwYW5kJTIwdG9rZW5pemVyJTIwZm9yJTIwaXQlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIySSdtJTIwbm90JTIwZ29pbmclMjB0byUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwVGhpcyUyMHNob3dzJTIwYSUyMG5vcm1hbCUyMGdlbmVyYXRlJTIwd2l0aG91dCUyMGFueSUyMHNwZWNpZmljJTIwcGFyYW1ldGVycyUwQXN1bW1hcnlfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShzdW1tYXJ5X2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwVGhpcyUyMGdlbmVyYXRlcyUyMGElMjBwZW5hbHR5JTIwZm9yJTIwcmVwZWF0ZWQlMjB0b2tlbnMlMEFwZW5hbGl6ZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjByZXBldGl0aW9uX3BlbmFsdHklM0QxLjEpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShwZW5hbGl6ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing the model and tokenizer for it</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;I&#x27;m not going to&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This shows a normal generate without any specific parameters</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>summary_ids = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(summary_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
I<span class="hljs-string">&#x27;m not going to be able to do that. I&#x27;</span>m going to be able to do that

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This generates a penalty for repeated tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>penalized_ids = model.generate(**inputs, repetition_penalty=<span class="hljs-number">1.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(penalized_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
I<span class="hljs-string">&#x27;m not going to be able to do that. I&#x27;</span>ll just have to go out <span class="hljs-keyword">and</span> play`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,b=r(),m(p.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=$),b=a(s),h(p.$$.fragment,s)},m(s,k){d(s,c,k),d(s,b,k),g(p,s,k),w=!0},p:x,i(s){w||(u(p.$$.fragment,s),w=!0)},o(s){f(p.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(p,s)}}}function NJ(j){let c,$=`In order to get the token ids of the sequences that you want to bias, make sure to set <code>add_prefix_space=True</code> when
initializing the tokenizer, and use <code>tokenizer(bad_words, add_special_tokens=False).input_ids</code>. The
<code>add_prefix_space</code> argument is only supported for some slow tokenizers, as fast tokenizers’ prefixing behaviours
come from <code>pre tokenizers</code>. Read more <a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">here</a>.`;return{c(){c=o("p"),c.innerHTML=$},l(b){c=l(b,"P",{"data-svelte-h":!0}),y(c)!=="svelte-16cusgy"&&(c.innerHTML=$)},m(b,p){d(b,c,p)},p:x,d(b){b&&n(c)}}}function HJ(j){let c,$="Examples:",b,p,w;return p=new Z({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;The full name of Donald is Donald&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>summary_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(summary_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald J. Trump Jr

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Now let&#x27;s control generation through a bias. Please note that the tokenizer is initialized differently!</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_with_prefix_space = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>, add_prefix_space=<span class="hljs-literal">True</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">get_tokens</span>(<span class="hljs-params">word</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> tokenizer_with_prefix_space([word], add_special_tokens=<span class="hljs-literal">False</span>).input_ids[<span class="hljs-number">0</span>]


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If we add a negative bias without beam search, it may become &quot;stuck&quot; in a prefix without good continuations</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_bias = [get_tokens(<span class="hljs-string">&quot;Trump&quot;</span>), -<span class="hljs-number">10.0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>biased_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, sequence_bias=sequence_bias)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(biased_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald J. Donald,

<span class="hljs-meta">&gt;&gt;&gt; </span>biased_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, num_beams=<span class="hljs-number">4</span>, sequence_bias=sequence_bias)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(biased_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald Rumsfeld,

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can also add a positive bias to nudge the model towards specific tokens or continuations</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_bias = [get_tokens(<span class="hljs-string">&quot;Donald Duck&quot;</span>), <span class="hljs-number">10.0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>biased_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, num_beams=<span class="hljs-number">4</span>, sequence_bias=sequence_bias)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(biased_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald Duck.`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,b=r(),m(p.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=$),b=a(s),h(p.$$.fragment,s)},m(s,k){d(s,c,k),d(s,b,k),g(p,s,k),w=!0},p:x,i(s){w||(u(p.$$.fragment,s),w=!0)},o(s){f(p.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(p,s)}}}function EJ(j){let c,$="Examples:",b,p,w;return p=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBXaGlzcGVyRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQW1vZGVsJTIwJTNEJTIwV2hpc3BlckZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQWRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoZHMlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwV2hpc3BlciUyMGhhcyUyMCU2MGJlZ2luX3N1cHByZXNzX3Rva2VucyU2MCUyMHNldCUyMGJ5JTIwZGVmYXVsdCUyMCglM0QlMjAlNjAlNUIyMjAlMkMlMjA1MDI1NiU1RCU2MCkuJTIwNTAyNTYlMjBpcyUyMHRoZSUyMEVPUyUyMHRva2VuJTJDJTIwc28lMjB0aGlzJTIwbWVhbnMlMEElMjMlMjBpdCUyMGNhbid0JTIwZ2VuZXJhdGUlMjBhbmQlMjBFT1MlMjB0b2tlbiUyMGluJTIwdGhlJTIwZmlyc3QlMjBpdGVyYXRpb24lMkMlMjBidXQlMjBpdCUyMGNhbiUyMGluJTIwdGhlJTIwb3RoZXJzLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMHJldHVybl9kaWN0X2luX2dlbmVyYXRlJTNEVHJ1ZSUyQyUyMG91dHB1dF9zY29yZXMlM0RUcnVlKSUwQXByaW50KG91dHB1dHMuc2NvcmVzJTVCMCU1RCU1QjAlMkMlMjA1MDI1NiU1RCklMEFwcmludChvdXRwdXRzLnNjb3JlcyU1Qi0xJTVEJTVCMCUyQyUyMDUwMjU2JTVEKSUyMCUyMCUyMyUyMGluJTIwb3RoZXIlMjBwbGFjZXMlMjB3ZSUyMGNhbiUyMHNlZSUyMHNvbWUlMjBwcm9iYWJpbGl0eSUyMG1hc3MlMjBmb3IlMjBFT1MlMEElMEElMjMlMjBJZiUyMHdlJTIwZGlzYWJsZSUyMCU2MGJlZ2luX3N1cHByZXNzX3Rva2VucyU2MCUyQyUyMHdlJTIwY2FuJTIwZ2VuZXJhdGUlMjBFT1MlMjBpbiUyMHRoZSUyMGZpcnN0JTIwaXRlcmF0aW9uLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjAqKmlucHV0cyUyQyUyMHJldHVybl9kaWN0X2luX2dlbmVyYXRlJTNEVHJ1ZSUyQyUyMG91dHB1dF9zY29yZXMlM0RUcnVlJTJDJTIwYmVnaW5fc3VwcHJlc3NfdG9rZW5zJTNETm9uZSUwQSklMEFwcmludChvdXRwdXRzLnNjb3JlcyU1QjAlNUQlNUIwJTJDJTIwNTAyNTYlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, WhisperForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = WhisperForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Whisper has \`begin_suppress_tokens\` set by default (= \`[220, 50256]\`). 50256 is the EOS token, so this means</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># it can&#x27;t generate and EOS token in the first iteration, but it can in the others.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>, <span class="hljs-number">50256</span>])
tensor(-inf)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[-<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">50256</span>])  <span class="hljs-comment"># in other places we can see some probability mass for EOS</span>
tensor(<span class="hljs-number">29.9010</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If we disable \`begin_suppress_tokens\`, we can generate EOS in the first iteration.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>, begin_suppress_tokens=<span class="hljs-literal">None</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>, <span class="hljs-number">50256</span>])
tensor(<span class="hljs-number">11.2027</span>)`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,b=r(),m(p.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=$),b=a(s),h(p.$$.fragment,s)},m(s,k){d(s,c,k),d(s,b,k),g(p,s,k),w=!0},p:x,i(s){w||(u(p.$$.fragment,s),w=!0)},o(s){f(p.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(p,s)}}}function qJ(j){let c,$="Examples:",b,p,w;return p=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBXaGlzcGVyRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQW1vZGVsJTIwJTNEJTIwV2hpc3BlckZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQWRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoZHMlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwV2hpc3BlciUyMGhhcyUyMGElMjBsb25nJTIwbGlzdCUyMG9mJTIwc3VwcHJlc3NlZCUyMHRva2Vucy4lMjBGb3IlMjBpbnN0YW5jZSUyQyUyMGluJTIwdGhpcyUyMGNhc2UlMkMlMjB0aGUlMjB0b2tlbiUyMDElMjBpcyUyMHN1cHByZXNzZWQlMjBieSUyMGRlZmF1bHQuJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwcmV0dXJuX2RpY3RfaW5fZ2VuZXJhdGUlM0RUcnVlJTJDJTIwb3V0cHV0X3Njb3JlcyUzRFRydWUpJTBBcHJpbnQob3V0cHV0cy5zY29yZXMlNUIxJTVEJTVCMCUyQyUyMDElNUQpJTIwJTIwJTIzJTIwMSUyMChhbmQlMjBub3QlMjAwKSUyMGlzJTIwdGhlJTIwZmlyc3QlMjBmcmVlbHklMjBnZW5lcmF0ZWQlMjB0b2tlbiUwQSUwQSUyMyUyMElmJTIwd2UlMjBkaXNhYmxlJTIwJTYwc3VwcHJlc3NfdG9rZW5zJTYwJTJDJTIwd2UlMjBjYW4lMjBnZW5lcmF0ZSUyMGl0LiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMHJldHVybl9kaWN0X2luX2dlbmVyYXRlJTNEVHJ1ZSUyQyUyMG91dHB1dF9zY29yZXMlM0RUcnVlJTJDJTIwc3VwcHJlc3NfdG9rZW5zJTNETm9uZSklMEFwcmludChvdXRwdXRzLnNjb3JlcyU1QjElNUQlNUIwJTJDJTIwMSU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, WhisperForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = WhisperForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Whisper has a long list of suppressed tokens. For instance, in this case, the token 1 is suppressed by default.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">1</span>])  <span class="hljs-comment"># 1 (and not 0) is the first freely generated token</span>
tensor(-inf)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If we disable \`suppress_tokens\`, we can generate it.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>, suppress_tokens=<span class="hljs-literal">None</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">1</span>])
tensor(<span class="hljs-number">6.0678</span>)`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,b=r(),m(p.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=$),b=a(s),h(p.$$.fragment,s)},m(s,k){d(s,c,k),d(s,b,k),g(p,s,k),w=!0},p:x,i(s){w||(u(p.$$.fragment,s),w=!0)},o(s){f(p.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(p,s)}}}function QJ(j){let c,$=`Make sure that <code>do_sample=True</code> is included in the <code>generate</code> arguments otherwise the temperature value won’t have
any effect.`;return{c(){c=o("p"),c.innerHTML=$},l(b){c=l(b,"P",{"data-svelte-h":!0}),y(c)!=="svelte-1byeoum"&&(c.innerHTML=$)},m(b,p){d(b,c,p)},p:x,d(b){b&&n(c)}}}function DJ(j){let c,$="Examples:",b,p,w;return p=new Z({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwc2V0X3NlZWQlMEElMEFzZXRfc2VlZCgwKSUyMCUyMCUyMyUyMGZvciUyMHJlcHJvZHVjaWJpbGl0eSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQW1vZGVsLmNvbmZpZy5wYWRfdG9rZW5faWQlMjAlM0QlMjBtb2RlbC5jb25maWcuZW9zX3Rva2VuX2lkJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkh1Z2dpbmclMjBGYWNlJTIwQ29tcGFueSUyMGlzJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBXaXRoJTIwdGVtcGVyYXR1cmUlM0QxLjAlMkMlMjB0aGUlMjBkZWZhdWx0JTJDJTIwd2UlMjBjb25zaXN0ZW50bHklMjBnZXQlMjByYW5kb20lMjBvdXRwdXRzJTIwZHVlJTIwdG8lMjByYW5kb20lMjBzYW1wbGluZy4lMEFnZW5lcmF0ZV9rd2FyZ3MlMjAlM0QlMjAlN0IlMjJtYXhfbmV3X3Rva2VucyUyMiUzQSUyMDEwJTJDJTIwJTIyZG9fc2FtcGxlJTIyJTNBJTIwVHJ1ZSUyQyUyMCUyMnRlbXBlcmF0dXJlJTIyJTNBJTIwMS4wJTJDJTIwJTIybnVtX3JldHVybl9zZXF1ZW5jZXMlMjIlM0ElMjAyJTdEJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwKipnZW5lcmF0ZV9rd2FyZ3MpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKSUwQSUwQSUyMyUyMEhvd2V2ZXIlMkMlMjB3aXRoJTIwdGVtcGVyYXR1cmUlMjBjbG9zZSUyMHRvJTIwMCUyQyUyMGl0JTIwYXBwcm94aW1hdGVzJTIwZ3JlZWR5JTIwZGVjb2RpbmclMjBzdHJhdGVnaWVzJTIwKGludmFyaWFudCklMEFnZW5lcmF0ZV9rd2FyZ3MlNUIlMjJ0ZW1wZXJhdHVyZSUyMiU1RCUyMCUzRCUyMDAuMDAwMSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMCoqZ2VuZXJhdGVfa3dhcmdzKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)  <span class="hljs-comment"># for reproducibility</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.pad_token_id = model.config.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Hugging Face Company is&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With temperature=1.0, the default, we consistently get random outputs due to random sampling.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_kwargs = {<span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">10</span>, <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">True</span>, <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">1.0</span>, <span class="hljs-string">&quot;num_return_sequences&quot;</span>: <span class="hljs-number">2</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, **generate_kwargs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;Hugging Face Company is one of these companies that is going to take a&#x27;</span>,
<span class="hljs-string">&quot;Hugging Face Company is a brand created by Brian A. O&#x27;Neil&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># However, with temperature close to 0, it approximates greedy decoding strategies (invariant)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_kwargs[<span class="hljs-string">&quot;temperature&quot;</span>] = <span class="hljs-number">0.0001</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, **generate_kwargs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;Hugging Face Company is a company that has been around for over 20 years&#x27;</span>,
<span class="hljs-string">&#x27;Hugging Face Company is a company that has been around for over 20 years&#x27;</span>]`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,b=r(),m(p.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=$),b=a(s),h(p.$$.fragment,s)},m(s,k){d(s,c,k),d(s,b,k),g(p,s,k),w=!0},p:x,i(s){w||(u(p.$$.fragment,s),w=!0)},o(s){f(p.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(p,s)}}}function YJ(j){let c,$="Examples:",b,p,w;return p=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMSklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyQSUyMHNlcXVlbmNlJTNBJTIwQSUyQyUyMEIlMkMlMjBDJTJDJTIwRCUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwV2l0aCUyMHNhbXBsaW5nJTJDJTIwdGhlJTIwb3V0cHV0JTIwaXMlMjB1bmV4cGVjdGVkJTIwLS0lMjBzb21ldGltZXMlMjB0b28lMjB1bmV4cGVjdGVkLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBXaXRoJTIwJTYwdG9wX2slNjAlMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGdldHMlMjByZXN0cmljdGVkJTIwdGhlJTIwayUyMG1vc3QlMjBsaWtlbHklMjB0b2tlbnMuJTBBJTIzJTIwUHJvJTIwdGlwJTNBJTIwSW4lMjBwcmFjdGljZSUyQyUyMExMTXMlMjB1c2UlMjAlNjB0b3BfayU2MCUyMGluJTIwdGhlJTIwNS01MCUyMHJhbmdlLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjB0b3BfayUzRDIpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: A, B, C, D&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: A, B, C, D, E — S — O, P — R

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`top_k\` sampling, the output gets restricted the k most likely tokens.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: In practice, LLMs use \`top_k\` in the 5-50 range.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, top_k=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: A, B, C, D, E, F, G, H, I`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,b=r(),m(p.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=$),b=a(s),h(p.$$.fragment,s)},m(s,k){d(s,c,k),d(s,b,k),g(p,s,k),w=!0},p:x,i(s){w||(u(p.$$.fragment,s),w=!0)},o(s){f(p.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(p,s)}}}function PJ(j){let c,$="Examples:",b,p,w;return p=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMSklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyQSUyMHNlcXVlbmNlJTNBJTIwMSUyQyUyMDIlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFdpdGglMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGlzJTIwdW5leHBlY3RlZCUyMC0tJTIwc29tZXRpbWVzJTIwdG9vJTIwdW5leHBlY3RlZC4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwV2l0aCUyMCU2MHRvcF9wJTYwJTIwc2FtcGxpbmclMkMlMjB0aGUlMjBvdXRwdXQlMjBnZXRzJTIwcmVzdHJpY3RlZCUyMHRvJTIwaGlnaC1wcm9iYWJpbGl0eSUyMHRva2Vucy4lMEElMjMlMjBQcm8lMjB0aXAlM0ElMjBJbiUyMHByYWN0aWNlJTJDJTIwTExNcyUyMHVzZSUyMCU2MHRvcF9wJTYwJTIwaW4lMjB0aGUlMjAwLjktMC45NSUyMHJhbmdlLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjB0b3BfcCUzRDAuMSklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span> | &lt; <span class="hljs-number">4</span> (left-hand pointer) ;
&lt;BLANKLINE&gt;
&lt;BLANKLINE&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`top_p\` sampling, the output gets restricted to high-probability tokens.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: In practice, LLMs use \`top_p\` in the 0.9-0.95 range.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, top_p=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,b=r(),m(p.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=$),b=a(s),h(p.$$.fragment,s)},m(s,k){d(s,c,k),d(s,b,k),g(p,s,k),w=!0},p:x,i(s){w||(u(p.$$.fragment,s),w=!0)},o(s){f(p.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(p,s)}}}function AJ(j){let c,$="Examples:",b,p,w;return p=new Z({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;1, 2, 3&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can see that greedy decoding produces a sequence of numbers</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>, <span class="hljs-number">10</span>,

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># For this particular seed, we can see that sampling produces nearly the same low-information (= low entropy)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># sequence</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">18</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span> <span class="hljs-keyword">and</span> <span class="hljs-number">10</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`typical_p\` set, the most obvious sequence is no longer produced, which may be good for your problem</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">18</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs, do_sample=<span class="hljs-literal">True</span>, typical_p=<span class="hljs-number">0.1</span>, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs.sequences, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span> <span class="hljs-keyword">and</span> <span class="hljs-number">5</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can see that the token corresponding to &quot;4&quot; (token 934) in the second position, the most likely token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># as seen with greedy decoding, was entirely blocked out</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">934</span>])
tensor(-inf)`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,b=r(),m(p.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=$),b=a(s),h(p.$$.fragment,s)},m(s,k){d(s,c,k),d(s,b,k),g(p,s,k),w=!0},p:x,i(s){w||(u(p.$$.fragment,s),w=!0)},o(s){f(p.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(p,s)}}}function OJ(j){let c,$="Examples:",b,p,w;return p=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJUb2RheSUyQyUyMGElMjBkcmFnb24lMjBmbGV3JTIwb3ZlciUyMFBhcmlzJTJDJTIwRnJhbmNlJTJDJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFvdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDEuNSklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQlMEElMEElMjMlMjB3aXRoJTIwYSUyMG5lZ2F0aXZlJTIwcHJvbXB0JTBBbmVnX2lucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJBJTIwdmVyeSUyMGhhcHB5JTIwZXZlbnQlMjBoYXBwZW5lZCUyQyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QyJTJDJTIwbmVnYXRpdmVfcHJvbXB0X2lkcyUzRG5lZ19pbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEJTBBJTBBJTIzJTIwd2l0aCUyMGElMjBwb3NpdGl2ZSUyMHByb21wdCUwQW5lZ19pbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIyQSUyMHZlcnklMjBoYXBweSUyMGV2ZW50JTIwaGFwcGVuZWQlMkMlMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEMCUyQyUyMG5lZ2F0aXZlX3Byb21wdF9pZHMlM0RuZWdfaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Today, a dragon flew over Paris, France,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], guidance_scale=<span class="hljs-number">1.5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;Today, a dragon flew over Paris, France, killing at least 50 people and injuring more than 100&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># with a negative prompt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>neg_inputs = tokenizer([<span class="hljs-string">&quot;A very happy event happened,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], guidance_scale=<span class="hljs-number">2</span>, negative_prompt_ids=neg_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;Today, a dragon flew over Paris, France, killing at least 130 people. French media reported that&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># with a positive prompt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>neg_inputs = tokenizer([<span class="hljs-string">&quot;A very happy event happened,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], guidance_scale=<span class="hljs-number">0</span>, negative_prompt_ids=neg_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Today, a dragon flew over Paris, France, and I&#x27;m very happy to be here. I&quot;</span>`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,b=r(),m(p.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=$),b=a(s),h(p.$$.fragment,s)},m(s,k){d(s,c,k),d(s,b,k),g(p,s,k),w=!0},p:x,i(s){w||(u(p.$$.fragment,s),w=!0)},o(s){f(p.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(p,s)}}}function KJ(j){let c,$="Examples:",b,p,w;return p=new Z({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMFdoaXNwZXJGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMkMlMjBHZW5lcmF0aW9uQ29uZmlnJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQW1vZGVsJTIwJTNEJTIwV2hpc3BlckZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQWRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoZHMlNUIzJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRfZmVhdHVyZXMlMjAlM0QlMjBpbnB1dHMuaW5wdXRfZmVhdHVyZXMlMEElMEElMjNEaXNwbGF5aW5nJTIwdGltZXN0YW1wcyUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMlM0RpbnB1dF9mZWF0dXJlcyUyQyUyMHJldHVybl90aW1lc3RhbXBzJTNEVHJ1ZSklMEF0cmFuc2NyaXB0aW9uJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwZGVjb2RlX3dpdGhfdGltZXN0YW1wcyUzRFRydWUpJTVCMCU1RCUwQXByaW50KCUyMlRyYW5zY3JpcHRpb24lM0ElMjIlMkMlMjB0cmFuc2NyaXB0aW9uKSUwQSUwQSUwQSUyM05vJTIwdGltZXN0YW1wcyUyMCUyNiUyMGNoYW5nZSUyMEVPUyUzQSUwQSUyM1RoaXMlMjBhbGxvd3MlMjB0aGUlMjB1c2VyJTIwdG8lMjBzZWxlY3QlMjBhJTIwc3BlY2lmaWMlMjB0b2tlbiUyMHRvJTIwdGVybWluYXRlJTIwdGhlJTIwc2VxdWVuY2UlMjBvbiUyQyUyMGluJTIwdGhpcyUyMGNhc2UlMjBpdCdzJTIwdGhlJTIwd29yZCUyMCUyMmNhbiUyMig0NjApJTBBbW9kZWwuZ2VuZXJhdGlvbl9jb25maWcuZW9zX3Rva2VuX2lkJTIwJTNEJTIwNDYwJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cyUzRGlucHV0X2ZlYXR1cmVzJTJDcmV0dXJuX3RpbWVzdGFtcHMlM0RGYWxzZSklMEF0cmFuc2NyaXB0aW9uJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCUwQXByaW50KCUyMlRyYW5zY3JpcHRpb24lM0ElMjIlMkMlMjB0cmFuc2NyaXB0aW9uKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, WhisperForConditionalGeneration, GenerationConfig
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = WhisperForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(ds[<span class="hljs-number">3</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_features = inputs.input_features

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment">#Displaying timestamps</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(inputs=input_features, return_timestamps=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(generated_ids, decode_with_timestamps=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Transcription:&quot;</span>, transcription)
Transcription: &lt;|startoftranscript|&gt;&lt;|<span class="hljs-number">0.00</span>|&gt; He has grave doubts whether Sir Frederick Layton<span class="hljs-string">&#x27;s work is really Greek after all, and can&lt;|6.44|&gt;&lt;|6.44|&gt; discover in it but little of rocky Ithaca.&lt;|9.44|&gt;&lt;|endoftext|&gt;


&gt;&gt;&gt; #No timestamps &amp; change EOS:
&gt;&gt;&gt; #This allows the user to select a specific token to terminate the sequence on, in this case it&#x27;</span>s the word <span class="hljs-string">&quot;can&quot;</span>(<span class="hljs-number">460</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.generation_config.eos_token_id = <span class="hljs-number">460</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(inputs=input_features,return_timestamps=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Transcription:&quot;</span>, transcription)
Transcription:  He has grave doubts whether Sir Frederick Layton<span class="hljs-string">&#x27;s work is really Greek after all and can</span>`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,b=r(),m(p.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=$),b=a(s),h(p.$$.fragment,s)},m(s,k){d(s,c,k),d(s,b,k),g(p,s,k),w=!0},p:x,i(s){w||(u(p.$$.fragment,s),w=!0)},o(s){f(p.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(p,s)}}}function eU(j){let c,$="Examples:",b,p,w;return p=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMFdhdGVybWFya2luZ0NvbmZpZyUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJBbGljZSUyMGFuZCUyMEJvYiUyMGFyZSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwbm9ybWFsJTIwZ2VuZXJhdGlvbiUwQW91dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCUyQyUyMG1heF9sZW5ndGglM0QyMCUyQyUyMGRvX3NhbXBsZSUzREZhbHNlKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCUwQSUwQSUyMyUyMHdhdGVybWFya2VkJTIwZ2VuZXJhdGlvbiUwQXdhdGVybWFya2luZ19jb25maWclMjAlM0QlMjBXYXRlcm1hcmtpbmdDb25maWcoYmlhcyUzRDIuNSUyQyUyMGNvbnRleHRfd2lkdGglM0QyJTJDJTIwc2VlZGluZ19zY2hlbWUlM0QlMjJzZWxmaGFzaCUyMiklMEFvdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQlMkMlMjB3YXRlcm1hcmtpbmdfY29uZmlnJTNEd2F0ZXJtYXJraW5nX2NvbmZpZyUyQyUyMG1heF9sZW5ndGglM0QyMCUyQyUyMGRvX3NhbXBsZSUzREZhbHNlKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCUwQSUwQSUyMyUyMHRvJTIwZGV0ZWN0JTIwd2F0ZXJtYXJrZWQlMjB0ZXh0JTIwdXNlJTIwdGhlJTIwV2F0ZXJtYXJrRGV0ZWN0b3IlMjBjbGFzcyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBXYXRlcm1hcmtEZXRlY3RvciUwQWRldGVjdG9yJTIwJTNEJTIwV2F0ZXJtYXJrRGV0ZWN0b3IobW9kZWxfY29uZmlnJTNEbW9kZWwuY29uZmlnJTJDJTIwZGV2aWNlJTNEJTIyY3B1JTIyJTJDJTIwd2F0ZXJtYXJraW5nX2NvbmZpZyUzRCUyMHdhdGVybWFya2luZ19jb25maWcpJTBBZGV0ZWN0aW9uX3ByZWRzJTIwJTNEJTIwZGV0ZWN0b3Iob3V0KSUwQWRldGVjdGlvbl9wcmVkcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, WatermarkingConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Alice and Bob are&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># normal generation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_length=<span class="hljs-number">20</span>, do_sample=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;Alice and Bob are both in the same room.\\n\\n&quot;I\\&#x27;m not sure if you\\&#x27;re&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># watermarked generation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>watermarking_config = WatermarkingConfig(bias=<span class="hljs-number">2.5</span>, context_width=<span class="hljs-number">2</span>, seeding_scheme=<span class="hljs-string">&quot;selfhash&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], watermarking_config=watermarking_config, max_length=<span class="hljs-number">20</span>, do_sample=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;Alice and Bob are both still alive and well and the story is pretty much a one-hour adventure&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># to detect watermarked text use the WatermarkDetector class</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> WatermarkDetector
<span class="hljs-meta">&gt;&gt;&gt; </span>detector = WatermarkDetector(model_config=model.config, device=<span class="hljs-string">&quot;cpu&quot;</span>, watermarking_config= watermarking_config)
<span class="hljs-meta">&gt;&gt;&gt; </span>detection_preds = detector(out)
<span class="hljs-meta">&gt;&gt;&gt; </span>detection_preds
array([ <span class="hljs-literal">True</span>])`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,b=r(),m(p.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=$),b=a(s),h(p.$$.fragment,s)},m(s,k){d(s,c,k),d(s,b,k),g(p,s,k),w=!0},p:x,i(s){w||(u(p.$$.fragment,s),w=!0)},o(s){f(p.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(p,s)}}}function tU(j){let c,$="Examples:",b,p,w;return p=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnBoaS0yJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnBoaS0yJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJUaGUlMjBiaWdnZXN0JTIwc3RhdGVzJTIwaW4lMjB0aGUlMjBVU0ElMjBieSUyMGxhbmQlMjBhcmVhJTNBJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFnZW5fb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fb3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBQYXNzaW5nJTIwb25lJTIwb3IlMjBtb3JlJTIwc3RvcCUyMHN0cmluZ3MlMjB3aWxsJTIwaGFsdCUyMGdlbmVyYXRpb24lMjBhZnRlciUyMHRob3NlJTIwc3RyaW5ncyUyMGFyZSUyMGVtaXR0ZWQlMEElMjMlMjBOb3RlJTIwdGhhdCUyMGdlbmVyYXRpbmclMjB3aXRoJTIwc3RvcCUyMHN0cmluZ3MlMjByZXF1aXJlcyUyMHlvdSUyMHRvJTIwcGFzcyUyMHRoZSUyMHRva2VuaXplciUyMHRvbyUwQWdlbl9vdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMHN0b3Bfc3RyaW5ncyUzRCU1QiUyMlRleGFzJTIyJTVEJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuX291dCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;microsoft/phi-2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;microsoft/phi-2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;The biggest states in the USA by land area:&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The biggest states <span class="hljs-keyword">in</span> the USA by land area:
- Alaska
- Texas
- California

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Passing one or more stop strings will halt generation after those strings are emitted</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Note that generating with stop strings requires you to pass the tokenizer too</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs, stop_strings=[<span class="hljs-string">&quot;Texas&quot;</span>], tokenizer=tokenizer)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The biggest states <span class="hljs-keyword">in</span> the USA by land area:
- Alaska
- Texas`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,b=r(),m(p.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=$),b=a(s),h(p.$$.fragment,s)},m(s,k){d(s,c,k),d(s,b,k),g(p,s,k),w=!0},p:x,i(s){w||(u(p.$$.fragment,s),w=!0)},o(s){f(p.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(p,s)}}}function sU(j){let c,$;return c=new Z({props:{code:"Y29tcGxldGVkJTIwJTNEJTIwRmFsc2UlMEF3aGlsZSUyMG5vdCUyMGNvbXBsZXRlZCUzQSUwQSUyMCUyMCUyMCUyMF8lMkMlMjBjb21wbGV0ZWQlMjAlM0QlMjBjb25zdHJhaW50LnVwZGF0ZShjb25zdHJhaW50LmFkdmFuY2UoKSk=",highlighted:`completed = <span class="hljs-literal">False</span>
<span class="hljs-keyword">while</span> <span class="hljs-keyword">not</span> completed:
    _, completed = constraint.update(constraint.advance())`,wrap:!1}}),{c(){m(c.$$.fragment)},l(b){h(c.$$.fragment,b)},m(b,p){g(c,b,p),$=!0},p:x,i(b){$||(u(c.$$.fragment,b),$=!0)},o(b){f(c.$$.fragment,b),$=!1},d(b){_(c,b)}}}function nU(j){let c,$="The API for the streamer classes is still under development and may change in the future.";return{c(){c=o("p"),c.textContent=$},l(b){c=l(b,"P",{"data-svelte-h":!0}),y(c)!=="svelte-gv2g1g"&&(c.textContent=$)},m(b,p){d(b,c,p)},p:x,d(b){b&&n(c)}}}function rU(j){let c,$="Examples:",b,p,w;return p=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMFRleHRTdHJlYW1lciUwQSUwQXRvayUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRvayglNUIlMjJBbiUyMGluY3JlYXNpbmclMjBzZXF1ZW5jZSUzQSUyMG9uZSUyQyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBc3RyZWFtZXIlMjAlM0QlMjBUZXh0U3RyZWFtZXIodG9rKSUwQSUwQSUyMyUyMERlc3BpdGUlMjByZXR1cm5pbmclMjB0aGUlMjB1c3VhbCUyMG91dHB1dCUyQyUyMHRoZSUyMHN0cmVhbWVyJTIwd2lsbCUyMGFsc28lMjBwcmludCUyMHRoZSUyMGdlbmVyYXRlZCUyMHRleHQlMjB0byUyMHN0ZG91dC4lMEFfJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBzdHJlYW1lciUzRHN0cmVhbWVyJTJDJTIwbWF4X25ld190b2tlbnMlM0QyMCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, TextStreamer

<span class="hljs-meta">&gt;&gt;&gt; </span>tok = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tok([<span class="hljs-string">&quot;An increasing sequence: one,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>streamer = TextStreamer(tok)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Despite returning the usual output, the streamer will also print the generated text to stdout.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>_ = model.generate(**inputs, streamer=streamer, max_new_tokens=<span class="hljs-number">20</span>)
An increasing sequence: one, two, three, four, five, six, seven, eight, nine, ten, eleven,`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,b=r(),m(p.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=$),b=a(s),h(p.$$.fragment,s)},m(s,k){d(s,c,k),d(s,b,k),g(p,s,k),w=!0},p:x,i(s){w||(u(p.$$.fragment,s),w=!0)},o(s){f(p.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(p,s)}}}function aU(j){let c,$="The API for the streamer classes is still under development and may change in the future.";return{c(){c=o("p"),c.textContent=$},l(b){c=l(b,"P",{"data-svelte-h":!0}),y(c)!=="svelte-gv2g1g"&&(c.textContent=$)},m(b,p){d(b,c,p)},p:x,d(b){b&&n(c)}}}function oU(j){let c,$="Examples:",b,p,w;return p=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMFRleHRJdGVyYXRvclN0cmVhbWVyJTBBZnJvbSUyMHRocmVhZGluZyUyMGltcG9ydCUyMFRocmVhZCUwQSUwQXRvayUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRvayglNUIlMjJBbiUyMGluY3JlYXNpbmclMjBzZXF1ZW5jZSUzQSUyMG9uZSUyQyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBc3RyZWFtZXIlMjAlM0QlMjBUZXh0SXRlcmF0b3JTdHJlYW1lcih0b2spJTBBJTBBJTIzJTIwUnVuJTIwdGhlJTIwZ2VuZXJhdGlvbiUyMGluJTIwYSUyMHNlcGFyYXRlJTIwdGhyZWFkJTJDJTIwc28lMjB0aGF0JTIwd2UlMjBjYW4lMjBmZXRjaCUyMHRoZSUyMGdlbmVyYXRlZCUyMHRleHQlMjBpbiUyMGElMjBub24tYmxvY2tpbmclMjB3YXkuJTBBZ2VuZXJhdGlvbl9rd2FyZ3MlMjAlM0QlMjBkaWN0KGlucHV0cyUyQyUyMHN0cmVhbWVyJTNEc3RyZWFtZXIlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDIwKSUwQXRocmVhZCUyMCUzRCUyMFRocmVhZCh0YXJnZXQlM0Rtb2RlbC5nZW5lcmF0ZSUyQyUyMGt3YXJncyUzRGdlbmVyYXRpb25fa3dhcmdzKSUwQXRocmVhZC5zdGFydCgpJTBBZ2VuZXJhdGVkX3RleHQlMjAlM0QlMjAlMjIlMjIlMEFmb3IlMjBuZXdfdGV4dCUyMGluJTIwc3RyZWFtZXIlM0ElMEElMjAlMjAlMjAlMjBnZW5lcmF0ZWRfdGV4dCUyMCUyQiUzRCUyMG5ld190ZXh0JTBBZ2VuZXJhdGVkX3RleHQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, TextIteratorStreamer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> threading <span class="hljs-keyword">import</span> Thread

<span class="hljs-meta">&gt;&gt;&gt; </span>tok = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tok([<span class="hljs-string">&quot;An increasing sequence: one,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>streamer = TextIteratorStreamer(tok)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Run the generation in a separate thread, so that we can fetch the generated text in a non-blocking way.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_kwargs = <span class="hljs-built_in">dict</span>(inputs, streamer=streamer, max_new_tokens=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>thread = Thread(target=model.generate, kwargs=generation_kwargs)
<span class="hljs-meta">&gt;&gt;&gt; </span>thread.start()
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = <span class="hljs-string">&quot;&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> new_text <span class="hljs-keyword">in</span> streamer:
<span class="hljs-meta">... </span>    generated_text += new_text
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text
<span class="hljs-string">&#x27;An increasing sequence: one, two, three, four, five, six, seven, eight, nine, ten, eleven,&#x27;</span>`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,b=r(),m(p.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=$),b=a(s),h(p.$$.fragment,s)},m(s,k){d(s,c,k),d(s,b,k),g(p,s,k),w=!0},p:x,i(s){w||(u(p.$$.fragment,s),w=!0)},o(s){f(p.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(p,s)}}}function lU(j){let c,$="Example:",b,p,w;return p=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMER5bmFtaWNDYWNoZSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMlF3ZW4lMkZRd2VuMi0wLjVCLUluc3RydWN0JTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMlF3ZW4lMkZRd2VuMi0wLjVCLUluc3RydWN0JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcih0ZXh0JTNEJTIyTXklMjBuYW1lJTIwaXMlMjBRd2VuMiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwUHJlcGFyZSUyMGElMjBjYWNoZSUyMGNsYXNzJTIwYW5kJTIwcGFzcyUyMGl0JTIwdG8lMjBtb2RlbCdzJTIwZm9yd2FyZCUwQXBhc3Rfa2V5X3ZhbHVlcyUyMCUzRCUyMER5bmFtaWNDYWNoZSgpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwcGFzdF9rZXlfdmFsdWVzJTNEcGFzdF9rZXlfdmFsdWVzJTJDJTIwdXNlX2NhY2hlJTNEVHJ1ZSklMEFvdXRwdXRzLnBhc3Rfa2V5X3ZhbHVlcyUyMCUyMyUyMGFjY2VzcyUyMGNhY2hlJTIwZmlsbGVkJTIwd2l0aCUyMGtleSUyRnZhbHVlcyUyMGZyb20lMjBnZW5lcmF0aW9u",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, DynamicCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is Qwen2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = DynamicCache()
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>
DynamicCache()`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,b=r(),m(p.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-11lpom8"&&(c.textContent=$),b=a(s),h(p.$$.fragment,s)},m(s,k){d(s,c,k),d(s,b,k),g(p,s,k),w=!0},p:x,i(s){w||(u(p.$$.fragment,s),w=!0)},o(s){f(p.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(p,s)}}}function cU(j){let c,$="Example:",b,p,w;return p=new Z({props:{code:"JTIzJTIwUnVuJTIwcGlwJTIwaW5zdGFsbCUyMHF1YW50byUyMGZpcnN0JTIwaWYlMjB5b3UlMjBkb24ndCUyMGhhdmUlMjBpdCUyMHlldCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvVG9rZW5pemVyJTJDJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBRdWFudG9RdWFudGl6ZWRDYWNoZSUyQyUyMFF1YW50aXplZENhY2hlQ29uZmlnJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyUXdlbiUyRlF3ZW4yLTAuNUItSW5zdHJ1Y3QlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyUXdlbiUyRlF3ZW4yLTAuNUItSW5zdHJ1Y3QlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHRleHQlM0QlMjJNeSUyMG5hbWUlMjBpcyUyMFF3ZW4yJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBQcmVwYXJlJTIwYSUyMGNhY2hlJTIwY2xhc3MlMjBhbmQlMjBwYXNzJTIwaXQlMjB0byUyMG1vZGVsJ3MlMjBmb3J3YXJkJTBBY2FjaGVfY29uZmlnJTIwJTNEJTIwUXVhbnRpemVkQ2FjaGVDb25maWcobmJpdHMlM0Q0KSUwQXBhc3Rfa2V5X3ZhbHVlcyUyMCUzRCUyMFF1YW50b1F1YW50aXplZENhY2hlKGNhY2hlX2NvbmZpZyUzRGNhY2hlX2NvbmZpZyklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBwYXN0X2tleV92YWx1ZXMlM0RwYXN0X2tleV92YWx1ZXMlMkMlMjB1c2VfY2FjaGUlM0RUcnVlKSUwQW91dHB1dHMucGFzdF9rZXlfdmFsdWVzJTIwJTIzJTIwYWNjZXNzJTIwY2FjaGUlMjBmaWxsZWQlMjB3aXRoJTIwa2V5JTJGdmFsdWVzJTIwZnJvbSUyMGdlbmVyYXRpb24=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Run pip install quanto first if you don&#x27;t have it yet</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, QuantoQuantizedCache, QuantizedCacheConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is Qwen2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>cache_config = QuantizedCacheConfig(nbits=<span class="hljs-number">4</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = QuantoQuantizedCache(cache_config=cache_config)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>
QuantoQuantizedCache()`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,b=r(),m(p.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-11lpom8"&&(c.textContent=$),b=a(s),h(p.$$.fragment,s)},m(s,k){d(s,c,k),d(s,b,k),g(p,s,k),w=!0},p:x,i(s){w||(u(p.$$.fragment,s),w=!0)},o(s){f(p.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(p,s)}}}function iU(j){let c,$="Example:",b,p,w;return p=new Z({props:{code:"JTIzJTIwUnVuJTIwcGlwJTIwaW5zdGFsbCUyMGhxcSUyMGZpcnN0JTIwaWYlMjB5b3UlMjBkb24ndCUyMGhhdmUlMjBpdCUyMHlldCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvVG9rZW5pemVyJTJDJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBIUVFRdWFudGl6ZWRDYWNoZSUyQyUyMFF1YW50aXplZENhY2hlQ29uZmlnJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyUXdlbiUyRlF3ZW4yLTAuNUItSW5zdHJ1Y3QlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyUXdlbiUyRlF3ZW4yLTAuNUItSW5zdHJ1Y3QlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHRleHQlM0QlMjJNeSUyMG5hbWUlMjBpcyUyMFF3ZW4yJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBQcmVwYXJlJTIwYSUyMGNhY2hlJTIwY2xhc3MlMjBhbmQlMjBwYXNzJTIwaXQlMjB0byUyMG1vZGVsJ3MlMjBmb3J3YXJkJTBBY2FjaGVfY29uZmlnJTIwJTNEJTIwUXVhbnRpemVkQ2FjaGVDb25maWcobmJpdHMlM0Q0JTJDJTIwYXhpc19rZXklM0QxJTJDJTIwYXhpc192YWx1ZSUzRDEpJTBBcGFzdF9rZXlfdmFsdWVzJTIwJTNEJTIwSFFRUXVhbnRpemVkQ2FjaGUoY2FjaGVfY29uZmlnJTNEY2FjaGVfY29uZmlnKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMHBhc3Rfa2V5X3ZhbHVlcyUzRHBhc3Rfa2V5X3ZhbHVlcyUyQyUyMHVzZV9jYWNoZSUzRFRydWUpJTBBb3V0cHV0cy5wYXN0X2tleV92YWx1ZXMlMjAlMjMlMjBhY2Nlc3MlMjBjYWNoZSUyMGZpbGxlZCUyMHdpdGglMjBrZXklMkZ2YWx1ZXMlMjBmcm9tJTIwZ2VuZXJhdGlvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Run pip install hqq first if you don&#x27;t have it yet</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, HQQQuantizedCache, QuantizedCacheConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is Qwen2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>cache_config = QuantizedCacheConfig(nbits=<span class="hljs-number">4</span>, axis_key=<span class="hljs-number">1</span>, axis_value=<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = HQQQuantizedCache(cache_config=cache_config)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>
HQQQuantizedCache()`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,b=r(),m(p.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-11lpom8"&&(c.textContent=$),b=a(s),h(p.$$.fragment,s)},m(s,k){d(s,c,k),d(s,b,k),g(p,s,k),w=!0},p:x,i(s){w||(u(p.$$.fragment,s),w=!0)},o(s){f(p.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(p,s)}}}function dU(j){let c,$="Example:",b,p,w;return p=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMFNpbmtDYWNoZSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMlF3ZW4lMkZRd2VuMi0wLjVCLUluc3RydWN0JTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMlF3ZW4lMkZRd2VuMi0wLjVCLUluc3RydWN0JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcih0ZXh0JTNEJTIyTXklMjBuYW1lJTIwaXMlMjBRd2VuMiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwUHJlcGFyZSUyMGElMjBjYWNoZSUyMGNsYXNzJTIwYW5kJTIwcGFzcyUyMGl0JTIwdG8lMjBtb2RlbCdzJTIwZm9yd2FyZCUwQXBhc3Rfa2V5X3ZhbHVlcyUyMCUzRCUyMFNpbmtDYWNoZSh3aW5kb3dfbGVuZ3RoJTNEMjU2JTJDJTIwbnVtX3NpbmtfdG9rZW5zJTNENCklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBwYXN0X2tleV92YWx1ZXMlM0RwYXN0X2tleV92YWx1ZXMlMkMlMjB1c2VfY2FjaGUlM0RUcnVlKSUwQW91dHB1dHMucGFzdF9rZXlfdmFsdWVzJTIwJTIzJTIwYWNjZXNzJTIwY2FjaGUlMjBmaWxsZWQlMjB3aXRoJTIwa2V5JTJGdmFsdWVzJTIwZnJvbSUyMGdlbmVyYXRpb24=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, SinkCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is Qwen2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = SinkCache(window_length=<span class="hljs-number">256</span>, num_sink_tokens=<span class="hljs-number">4</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>
SinkCache()`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,b=r(),m(p.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-11lpom8"&&(c.textContent=$),b=a(s),h(p.$$.fragment,s)},m(s,k){d(s,c,k),d(s,b,k),g(p,s,k),w=!0},p:x,i(s){w||(u(p.$$.fragment,s),w=!0)},o(s){f(p.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(p,s)}}}function pU(j){let c,$="Example:",b,p,w;return p=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMFN0YXRpY0NhY2hlJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybWV0YS1sbGFtYSUyRkxsYW1hLTItN2ItY2hhdC1oZiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03Yi1jaGF0LWhmJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcih0ZXh0JTNEJTIyTXklMjBuYW1lJTIwaXMlMjBMbGFtYSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwUHJlcGFyZSUyMGElMjBjYWNoZSUyMGNsYXNzJTIwYW5kJTIwcGFzcyUyMGl0JTIwdG8lMjBtb2RlbCdzJTIwZm9yd2FyZCUwQSUyMyUyMExlYXZlJTIwZW1wdHklMjBzcGFjZSUyMGZvciUyMDEwJTIwbmV3JTIwdG9rZW5zJTJDJTIwd2hpY2glMjBjYW4lMjBiZSUyMHVzZWQlMjB3aGVuJTIwY2FsbGluZyUyMGZvcndhcmQlMjBpdGVyYXRpdmVseSUyMDEwJTIwdGltZXMlMjB0byUyMGdlbmVyYXRlJTBBbWF4X2dlbmVyYXRlZF9sZW5ndGglMjAlM0QlMjBpbnB1dHMuaW5wdXRfaWRzLnNoYXBlJTVCMSU1RCUyMCUyQiUyMDEwJTBBcGFzdF9rZXlfdmFsdWVzJTIwJTNEJTIwU3RhdGljQ2FjaGUoY29uZmlnJTNEbW9kZWwuY29uZmlnJTJDJTIwYmF0Y2hfc2l6ZSUzRDElMkMlMjBtYXhfY2FjaGVfbGVuJTNEbWF4X2dlbmVyYXRlZF9sZW5ndGglMkMlMjBkZXZpY2UlM0Rtb2RlbC5kZXZpY2UlMkMlMjBkdHlwZSUzRG1vZGVsLmR0eXBlKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMHBhc3Rfa2V5X3ZhbHVlcyUzRHBhc3Rfa2V5X3ZhbHVlcyUyQyUyMHVzZV9jYWNoZSUzRFRydWUpJTBBb3V0cHV0cy5wYXN0X2tleV92YWx1ZXMlMjAlMjMlMjBhY2Nlc3MlMjBjYWNoZSUyMGZpbGxlZCUyMHdpdGglMjBrZXklMkZ2YWx1ZXMlMjBmcm9tJTIwZ2VuZXJhdGlvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, StaticCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is Llama&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Leave empty space for 10 new tokens, which can be used when calling forward iteratively 10 times to generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>max_generated_length = inputs.input_ids.shape[<span class="hljs-number">1</span>] + <span class="hljs-number">10</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = StaticCache(config=model.config, batch_size=<span class="hljs-number">1</span>, max_cache_len=max_generated_length, device=model.device, dtype=model.dtype)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>
StaticCache()`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,b=r(),m(p.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-11lpom8"&&(c.textContent=$),b=a(s),h(p.$$.fragment,s)},m(s,k){d(s,c,k),d(s,b,k),g(p,s,k),w=!0},p:x,i(s){w||(u(p.$$.fragment,s),w=!0)},o(s){f(p.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(p,s)}}}function mU(j){let c,$="Example:",b,p,w;return p=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyME9mZmxvYWRlZFN0YXRpY0NhY2hlJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHRleHQlM0QlMjJNeSUyMG5hbWUlMjBpcyUyMEdQVDIlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFByZXBhcmUlMjBhJTIwY2FjaGUlMjBjbGFzcyUyMGFuZCUyMHBhc3MlMjBpdCUyMHRvJTIwbW9kZWwncyUyMGZvcndhcmQlMEElMjMlMjBMZWF2ZSUyMGVtcHR5JTIwc3BhY2UlMjBmb3IlMjAxMCUyMG5ldyUyMHRva2VucyUyQyUyMHdoaWNoJTIwY2FuJTIwYmUlMjB1c2VkJTIwd2hlbiUyMGNhbGxpbmclMjBmb3J3YXJkJTIwaXRlcmF0aXZlbHklMjAxMCUyMHRpbWVzJTIwdG8lMjBnZW5lcmF0ZSUwQW1heF9nZW5lcmF0ZWRfbGVuZ3RoJTIwJTNEJTIwaW5wdXRzLmlucHV0X2lkcy5zaGFwZSU1QjElNUQlMjAlMkIlMjAxMCUwQXBhc3Rfa2V5X3ZhbHVlcyUyMCUzRCUyME9mZmxvYWRlZFN0YXRpY0NhY2hlKGNvbmZpZyUzRG1vZGVsLmNvbmZpZyUyQyUyMG1heF9iYXRjaF9zaXplJTNEMSUyQyUyMG1heF9jYWNoZV9sZW4lM0RtYXhfZ2VuZXJhdGVkX2xlbmd0aCUyQyUyMGRldmljZSUzRG1vZGVsLmRldmljZSUyQyUyMGR0eXBlJTNEbW9kZWwuZHR5cGUpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwcGFzdF9rZXlfdmFsdWVzJTNEcGFzdF9rZXlfdmFsdWVzJTJDJTIwdXNlX2NhY2hlJTNEVHJ1ZSklMEFwYXN0X2t2X2xlbmd0aCUyMCUzRCUyMG91dHB1dHMucGFzdF9rZXlfdmFsdWVzJTIwJTIzJTIwYWNjZXNzJTIwY2FjaGUlMjBmaWxsZWQlMjB3aXRoJTIwa2V5JTJGdmFsdWVzJTIwZnJvbSUyMGdlbmVyYXRpb24=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, OffloadedStaticCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is GPT2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Leave empty space for 10 new tokens, which can be used when calling forward iteratively 10 times to generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>max_generated_length = inputs.input_ids.shape[<span class="hljs-number">1</span>] + <span class="hljs-number">10</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = OffloadedStaticCache(config=model.config, max_batch_size=<span class="hljs-number">1</span>, max_cache_len=max_generated_length, device=model.device, dtype=model.dtype)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>past_kv_length = outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,b=r(),m(p.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-11lpom8"&&(c.textContent=$),b=a(s),h(p.$$.fragment,s)},m(s,k){d(s,c,k),d(s,b,k),g(p,s,k),w=!0},p:x,i(s){w||(u(p.$$.fragment,s),w=!0)},o(s){f(p.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(p,s)}}}function hU(j){let c,$="Example:",b,p,w;return p=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMEh5YnJpZENhY2hlJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGZ2VtbWEtMi0yYiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZnZW1tYS0yLTJiJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcih0ZXh0JTNEJTIyTXklMjBuYW1lJTIwaXMlMjBHZW1tYSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwUHJlcGFyZSUyMGElMjBjYWNoZSUyMGNsYXNzJTIwYW5kJTIwcGFzcyUyMGl0JTIwdG8lMjBtb2RlbCdzJTIwZm9yd2FyZCUwQSUyMyUyMExlYXZlJTIwZW1wdHklMjBzcGFjZSUyMGZvciUyMDEwJTIwbmV3JTIwdG9rZW5zJTJDJTIwd2hpY2glMjBjYW4lMjBiZSUyMHVzZWQlMjB3aGVuJTIwY2FsbGluZyUyMGZvcndhcmQlMjBpdGVyYXRpdmVseSUyMDEwJTIwdGltZXMlMjB0byUyMGdlbmVyYXRlJTBBbWF4X2dlbmVyYXRlZF9sZW5ndGglMjAlM0QlMjBpbnB1dHMuaW5wdXRfaWRzLnNoYXBlJTVCMSU1RCUyMCUyQiUyMDEwJTBBcGFzdF9rZXlfdmFsdWVzJTIwJTNEJTIwSHlicmlkQ2FjaGUoY29uZmlnJTNEbW9kZWwuY29uZmlnJTJDJTIwYmF0Y2hfc2l6ZSUzRDElMkMlMjBtYXhfY2FjaGVfbGVuJTNEbWF4X2dlbmVyYXRlZF9sZW5ndGglMkMlMjBkZXZpY2UlM0Rtb2RlbC5kZXZpY2UlMkMlMjBkdHlwZSUzRG1vZGVsLmR0eXBlKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMHBhc3Rfa2V5X3ZhbHVlcyUzRHBhc3Rfa2V5X3ZhbHVlcyUyQyUyMHVzZV9jYWNoZSUzRFRydWUpJTBBb3V0cHV0cy5wYXN0X2tleV92YWx1ZXMlMjAlMjMlMjBhY2Nlc3MlMjBjYWNoZSUyMGZpbGxlZCUyMHdpdGglMjBrZXklMkZ2YWx1ZXMlMjBmcm9tJTIwZ2VuZXJhdGlvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, HybridCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;google/gemma-2-2b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/gemma-2-2b&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is Gemma&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Leave empty space for 10 new tokens, which can be used when calling forward iteratively 10 times to generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>max_generated_length = inputs.input_ids.shape[<span class="hljs-number">1</span>] + <span class="hljs-number">10</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = HybridCache(config=model.config, batch_size=<span class="hljs-number">1</span>, max_cache_len=max_generated_length, device=model.device, dtype=model.dtype)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>
HybridCache()`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,b=r(),m(p.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-11lpom8"&&(c.textContent=$),b=a(s),h(p.$$.fragment,s)},m(s,k){d(s,c,k),d(s,b,k),g(p,s,k),w=!0},p:x,i(s){w||(u(p.$$.fragment,s),w=!0)},o(s){f(p.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(p,s)}}}function gU(j){let c,$="Example:",b,p,w;return p=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMFNsaWRpbmdXaW5kb3dDYWNoZSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItSW5zdHJ1Y3QtdjAuMyUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtaXN0cmFsYWklMkZNaXN0cmFsLTdCLUluc3RydWN0LXYwLjMlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHRleHQlM0QlMjJNeSUyMG5hbWUlMjBpcyUyME1pc3RyYWwlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFByZXBhcmUlMjBhJTIwY2FjaGUlMjBjbGFzcyUyMGFuZCUyMHBhc3MlMjBpdCUyMHRvJTIwbW9kZWwncyUyMGZvcndhcmQlMEElMjMlMjBMZWF2ZSUyMGVtcHR5JTIwc3BhY2UlMjBmb3IlMjAxMCUyMG5ldyUyMHRva2VucyUyQyUyMHdoaWNoJTIwY2FuJTIwYmUlMjB1c2VkJTIwd2hlbiUyMGNhbGxpbmclMjBmb3J3YXJkJTIwaXRlcmF0aXZlbHklMjAxMCUyMHRpbWVzJTIwdG8lMjBnZW5lcmF0ZSUwQW1heF9nZW5lcmF0ZWRfbGVuZ3RoJTIwJTNEJTIwaW5wdXRzLmlucHV0X2lkcy5zaGFwZSU1QjElNUQlMjAlMkIlMjAxMCUwQXBhc3Rfa2V5X3ZhbHVlcyUyMCUzRCUyMFNsaWRpbmdXaW5kb3dDYWNoZShjb25maWclM0Rtb2RlbC5jb25maWclMkMlMjBiYXRjaF9zaXplJTNEMSUyQyUyMG1heF9jYWNoZV9sZW4lM0RtYXhfZ2VuZXJhdGVkX2xlbmd0aCUyQyUyMGRldmljZSUzRG1vZGVsLmRldmljZSUyQyUyMGR0eXBlJTNEbW9kZWwuZHR5cGUpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwcGFzdF9rZXlfdmFsdWVzJTNEcGFzdF9rZXlfdmFsdWVzJTJDJTIwdXNlX2NhY2hlJTNEVHJ1ZSklMEFvdXRwdXRzLnBhc3Rfa2V5X3ZhbHVlcyUyMCUyMyUyMGFjY2VzcyUyMGNhY2hlJTIwZmlsbGVkJTIwd2l0aCUyMGtleSUyRnZhbHVlcyUyMGZyb20lMjBnZW5lcmF0aW9u",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, SlidingWindowCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-Instruct-v0.3&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-Instruct-v0.3&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is Mistral&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Leave empty space for 10 new tokens, which can be used when calling forward iteratively 10 times to generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>max_generated_length = inputs.input_ids.shape[<span class="hljs-number">1</span>] + <span class="hljs-number">10</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = SlidingWindowCache(config=model.config, batch_size=<span class="hljs-number">1</span>, max_cache_len=max_generated_length, device=model.device, dtype=model.dtype)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>
SlidingWindowCache()`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,b=r(),m(p.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-11lpom8"&&(c.textContent=$),b=a(s),h(p.$$.fragment,s)},m(s,k){d(s,c,k),d(s,b,k),g(p,s,k),w=!0},p:x,i(s){w||(u(p.$$.fragment,s),w=!0)},o(s){f(p.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(p,s)}}}function uU(j){let c,$="Example:",b,p,w;return p=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMER5bmFtaWNDYWNoZSUyQyUyMEVuY29kZXJEZWNvZGVyQ2FjaGUlMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWklMkZ3aGlzcGVyLXNtYWxsJTIyKSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haSUyRndoaXNwZXItc21hbGwlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGF1ZGlvJTNEWU9VUi1BVURJTyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwUHJlcGFyZSUyMGNhY2hlJTIwY2xhc3NlcyUyMGZvciUyMGVuY29kZXIlMjBhbmQlMjBkZWNvZGVyJTIwYW5kJTIwcGFzcyUyMGl0JTIwdG8lMjBtb2RlbCdzJTIwZm9yd2FyZCUwQXNlbGZfYXR0ZW50aW9uX2NhY2hlJTIwJTNEJTIwRHluYW1pY0NhY2hlKCklMEFjcm9zc19hdHRlbnRpb25fY2FjaGUlMjAlM0QlMjBEeW5hbWljQ2FjaGUoKSUwQXBhc3Rfa2V5X3ZhbHVlcyUyMCUzRCUyMEVuY29kZXJEZWNvZGVyQ2FjaGUoc2VsZl9hdHRlbnRpb25fY2FjaGUlMkMlMjBjcm9zc19hdHRlbnRpb25fY2FjaGUpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwcGFzdF9rZXlfdmFsdWVzJTNEcGFzdF9rZXlfdmFsdWVzJTJDJTIwdXNlX2NhY2hlJTNEVHJ1ZSklMEFvdXRwdXRzLnBhc3Rfa2V5X3ZhbHVlcyUyMCUyMyUyMGFjY2VzcyUyMGNhY2hlJTIwZmlsbGVkJTIwd2l0aCUyMGtleSUyRnZhbHVlcyUyMGZyb20lMjBnZW5lcmF0aW9u",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForCausalLM, DynamicCache, EncoderDecoderCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(audio=YOUR-AUDIO, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare cache classes for encoder and decoder and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>self_attention_cache = DynamicCache()
<span class="hljs-meta">&gt;&gt;&gt; </span>cross_attention_cache = DynamicCache()
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = EncoderDecoderCache(self_attention_cache, cross_attention_cache)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>
EncoderDecoderCache()`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,b=r(),m(p.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-11lpom8"&&(c.textContent=$),b=a(s),h(p.$$.fragment,s)},m(s,k){d(s,c,k),d(s,b,k),g(p,s,k),w=!0},p:x,i(s){w||(u(p.$$.fragment,s),w=!0)},o(s){f(p.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(p,s)}}}function fU(j){let c,$="Example:",b,p,w;return p=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBNYW1iYUZvckNhdXNhbExNJTJDJTIwTWFtYmFDYWNoZSUwQSUwQW1vZGVsJTIwJTNEJTIwTWFtYmFGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhdGUtc3BhY2VzJTJGbWFtYmEtMTMwbS1oZiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJzdGF0ZS1zcGFjZXMlMkZtYW1iYS0xMzBtLWhmJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcih0ZXh0JTNEJTIyTXklMjBuYW1lJTIwaXMlMjBNYW1iYSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwUHJlcGFyZSUyMGElMjBjYWNoZSUyMGNsYXNzJTIwYW5kJTIwcGFzcyUyMGl0JTIwdG8lMjBtb2RlbCdzJTIwZm9yd2FyZCUwQXBhc3Rfa2V5X3ZhbHVlcyUyMCUzRCUyME1hbWJhQ2FjaGUoY29uZmlnJTNEbW9kZWwuY29uZmlnJTJDJTIwYmF0Y2hfc2l6ZSUzRDElMkMlMjBkZXZpY2UlM0Rtb2RlbC5kZXZpY2UlMkMlMjBkdHlwZSUzRG1vZGVsLmR0eXBlKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMHBhc3Rfa2V5X3ZhbHVlcyUzRHBhc3Rfa2V5X3ZhbHVlcyUyQyUyMHVzZV9jYWNoZSUzRFRydWUpJTBBb3V0cHV0cy5wYXN0X2tleV92YWx1ZXM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, MambaForCausalLM, MambaCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model = MambaForCausalLM.from_pretrained(<span class="hljs-string">&quot;state-spaces/mamba-130m-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;state-spaces/mamba-130m-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is Mamba&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = MambaCache(config=model.config, batch_size=<span class="hljs-number">1</span>, device=model.device, dtype=model.dtype)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values
MambaCache()`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,b=r(),m(p.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-11lpom8"&&(c.textContent=$),b=a(s),h(p.$$.fragment,s)},m(s,k){d(s,c,k),d(s,b,k),g(p,s,k),w=!0},p:x,i(s){w||(u(p.$$.fragment,s),w=!0)},o(s){f(p.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(p,s)}}}function _U(j){let c,$="Examples:",b,p,w;return p=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMFdhdGVybWFya0RldGVjdG9yJTJDJTIwV2F0ZXJtYXJraW5nQ29uZmlnJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJvcGVuYWktY29tbXVuaXR5JTJGZ3B0MiUyMiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQXRvayUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQXRvay5wYWRfdG9rZW5faWQlMjAlM0QlMjB0b2suZW9zX3Rva2VuX2lkJTBBdG9rLnBhZGRpbmdfc2lkZSUyMCUzRCUyMCUyMmxlZnQlMjIlMEElMEFpbnB1dHMlMjAlM0QlMjB0b2soJTVCJTIyVGhpcyUyMGlzJTIwdGhlJTIwYmVnaW5uaW5nJTIwb2YlMjBhJTIwbG9uZyUyMHN0b3J5JTIyJTJDJTIwJTIyQWxpY2UlMjBhbmQlMjBCb2IlMjBhcmUlMjIlNUQlMkMlMjBwYWRkaW5nJTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRfbGVuJTIwJTNEJTIwaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVELnNoYXBlJTVCLTElNUQlMEElMEElMjMlMjBmaXJzdCUyMGdlbmVyYXRlJTIwdGV4dCUyMHdpdGglMjB3YXRlcm1hcmslMjBhbmQlMjB3aXRob3V0JTBBd2F0ZXJtYXJraW5nX2NvbmZpZyUyMCUzRCUyMFdhdGVybWFya2luZ0NvbmZpZyhiaWFzJTNEMi41JTJDJTIwc2VlZGluZ19zY2hlbWUlM0QlMjJzZWxmaGFzaCUyMiklMEFvdXRfd2F0ZXJtYXJrZWQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMHdhdGVybWFya2luZ19jb25maWclM0R3YXRlcm1hcmtpbmdfY29uZmlnJTJDJTIwZG9fc2FtcGxlJTNERmFsc2UlMkMlMjBtYXhfbGVuZ3RoJTNEMjApJTBBb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RGYWxzZSUyQyUyMG1heF9sZW5ndGglM0QyMCklMEElMEElMjMlMjBub3clMjB3ZSUyMGNhbiUyMGluc3RhbnRpYXRlJTIwdGhlJTIwZGV0ZWN0b3IlMjBhbmQlMjBjaGVjayUyMHRoZSUyMGdlbmVyYXRlZCUyMHRleHQlMEFkZXRlY3RvciUyMCUzRCUyMFdhdGVybWFya0RldGVjdG9yKG1vZGVsX2NvbmZpZyUzRG1vZGVsLmNvbmZpZyUyQyUyMGRldmljZSUzRCUyMmNwdSUyMiUyQyUyMHdhdGVybWFya2luZ19jb25maWclM0R3YXRlcm1hcmtpbmdfY29uZmlnKSUwQWRldGVjdGlvbl9vdXRfd2F0ZXJtYXJrZWQlMjAlM0QlMjBkZXRlY3RvcihvdXRfd2F0ZXJtYXJrZWQlMkMlMjByZXR1cm5fZGljdCUzRFRydWUpJTBBZGV0ZWN0aW9uX291dCUyMCUzRCUyMGRldGVjdG9yKG91dCUyQyUyMHJldHVybl9kaWN0JTNEVHJ1ZSklMEFkZXRlY3Rpb25fb3V0X3dhdGVybWFya2VkLnByZWRpY3Rpb24lMEElMEFkZXRlY3Rpb25fb3V0LnByZWRpY3Rpb24=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, WatermarkDetector, WatermarkingConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;openai-community/gpt2&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(model_id)
<span class="hljs-meta">&gt;&gt;&gt; </span>tok = AutoTokenizer.from_pretrained(model_id)
<span class="hljs-meta">&gt;&gt;&gt; </span>tok.pad_token_id = tok.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>tok.padding_side = <span class="hljs-string">&quot;left&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tok([<span class="hljs-string">&quot;This is the beginning of a long story&quot;</span>, <span class="hljs-string">&quot;Alice and Bob are&quot;</span>], padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_len = inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape[-<span class="hljs-number">1</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># first generate text with watermark and without</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>watermarking_config = WatermarkingConfig(bias=<span class="hljs-number">2.5</span>, seeding_scheme=<span class="hljs-string">&quot;selfhash&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out_watermarked = model.generate(**inputs, watermarking_config=watermarking_config, do_sample=<span class="hljs-literal">False</span>, max_length=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(**inputs, do_sample=<span class="hljs-literal">False</span>, max_length=<span class="hljs-number">20</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># now we can instantiate the detector and check the generated text</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>detector = WatermarkDetector(model_config=model.config, device=<span class="hljs-string">&quot;cpu&quot;</span>, watermarking_config=watermarking_config)
<span class="hljs-meta">&gt;&gt;&gt; </span>detection_out_watermarked = detector(out_watermarked, return_dict=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>detection_out = detector(out, return_dict=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>detection_out_watermarked.prediction
array([ <span class="hljs-literal">True</span>,  <span class="hljs-literal">True</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>detection_out.prediction
array([<span class="hljs-literal">False</span>,  <span class="hljs-literal">False</span>])`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,b=r(),m(p.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=$),b=a(s),h(p.$$.fragment,s)},m(s,k){d(s,c,k),d(s,b,k),g(p,s,k),w=!0},p:x,i(s){w||(u(p.$$.fragment,s),w=!0)},o(s){f(p.$$.fragment,s),w=!1},d(s){s&&(n(c),n(b)),_(p,s)}}}function bU(j){let c,$,b,p,w,s,k,l1='This page lists all the utility functions used by <a href="/docs/transformers/pr_30950/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>.',Xu,Mr,Lu,wr,c1=`The output of <a href="/docs/transformers/pr_30950/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> is an instance of a subclass of
<a href="/docs/transformers/pr_30950/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a>. This output is a data structure containing all the information returned
by <a href="/docs/transformers/pr_30950/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>, but that can also be used as tuple or dictionary.`,Ru,kr,i1="Here’s an example:",Su,$r,Nu,jr,d1=`The <code>generation_output</code> object is a <a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.generation.GenerateDecoderOnlyOutput">GenerateDecoderOnlyOutput</a>, as we can
see in the documentation of that class below, it means it has the following attributes:`,Hu,xr,p1="<li><code>sequences</code>: the generated sequences of tokens</li> <li><code>scores</code> (optional): the prediction scores of the language modelling head, for each generation step</li> <li><code>hidden_states</code> (optional): the hidden states of the model, for each generation step</li> <li><code>attentions</code> (optional): the attention weights of the model, for each generation step</li>",Eu,Jr,m1=`Here we have the <code>scores</code> since we passed along <code>output_scores=True</code>, but we don’t have <code>hidden_states</code> and
<code>attentions</code> because we didn’t pass <code>output_hidden_states=True</code> or <code>output_attentions=True</code>.`,qu,Ur,h1=`You can access each attribute as you would usually do, and if that attribute has not been returned by the model, you
will get <code>None</code>. Here for instance <code>generation_output.scores</code> are all the generated prediction scores of the
language modeling head, and <code>generation_output.attentions</code> is <code>None</code>.`,Qu,Zr,g1=`When using our <code>generation_output</code> object as a tuple, it only keeps the attributes that don’t have <code>None</code> values.
Here, for instance, it has two elements, <code>loss</code> then <code>logits</code>, so`,Du,Cr,Yu,Wr,u1="will return the tuple <code>(generation_output.sequences, generation_output.scores)</code> for instance.",Pu,Br,f1=`When using our <code>generation_output</code> object as a dictionary, it only keeps the attributes that don’t have <code>None</code>
values. Here, for instance, it has two keys that are <code>sequences</code> and <code>scores</code>.`,Au,zr,_1="We document here all output types.",Ou,Ir,Ku,ts,Vr,cy,Zi,b1="Outputs of decoder-only generation models, when using non-beam methods.",ef,ss,Gr,iy,Ci,y1="Outputs of encoder-decoder generation models, when using non-beam methods.",tf,ns,Fr,dy,Wi,T1="Outputs of decoder-only generation models, when using beam methods.",sf,rs,Xr,py,Bi,v1="Outputs of encoder-decoder generation models, when using beam methods.",nf,Lr,rf,as,Rr,my,zi,M1=`Base class for outputs of encoder-decoder generation models using greedy search. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,af,os,Sr,hy,Ii,w1="Base class for outputs of decoder-only generation models using greedy search.",of,ls,Nr,gy,Vi,k1=`Base class for outputs of encoder-decoder generation models using sampling. Hidden states and attention weights of
the decoder (respectively the encoder) can be accessed via the encoder_attentions and the encoder_hidden_states
attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,lf,cs,Hr,uy,Gi,$1="Base class for outputs of decoder-only generation models using sampling.",cf,is,Er,fy,Fi,j1=`Base class for outputs of encoder-decoder generation models using beam search. Hidden states and attention weights
of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the encoder_hidden_states
attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,df,ds,qr,_y,Xi,x1="Base class for outputs of decoder-only generation models using beam search.",pf,ps,Qr,by,Li,J1=`Base class for outputs of encoder-decoder generation models using beam sampling. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,mf,ms,Dr,yy,Ri,U1="Base class for outputs of decoder-only generation models using beam sample.",hf,hs,Yr,Ty,Si,Z1=`Base class for outputs of encoder-decoder generation models using contrastive search. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,gf,gs,Pr,vy,Ni,C1="Base class for outputs of decoder-only generation models using contrastive search.",uf,Ar,ff,De,Or,My,Hi,W1="Flax Base class for outputs of decoder-only generation models using sampling.",wy,ws,Kr,ky,Ei,B1="“Returns a new object replacing the specified fields with new values.",_f,Ye,ea,$y,qi,z1="Flax Base class for outputs of decoder-only generation models using greedy search.",jy,ks,ta,xy,Qi,I1="“Returns a new object replacing the specified fields with new values.",bf,Pe,sa,Jy,Di,V1="Flax Base class for outputs of decoder-only generation models using greedy search.",Uy,$s,na,Zy,Yi,G1="“Returns a new object replacing the specified fields with new values.",yf,ra,Tf,aa,F1=`A <a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> can be used to modify the prediction scores of a language model head for
generation.`,vf,oa,Mf,_e,la,Cy,Pi,X1='<a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforcing alternated generation between the two codebooks of Bark.',Wy,js,By,Ai,ca,wf,L,ia,zy,Oi,L1=`<a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> for classifier free guidance (CFG). The scores are split over the batch dimension,
where the first half correspond to the conditional logits (predicted from the input prompt) and the second half
correspond to the unconditional logits (predicted from an empty or ‘null’ prompt). The processor computes a
weighted average across the conditional and unconditional logits, parameterised by the <code>guidance_scale</code>.`,Iy,Ki,R1='See <a href="https://arxiv.org/abs/2306.05284" rel="nofollow">the paper</a> for more information.',Vy,xs,Gy,Js,Fy,ed,da,kf,ee,pa,Xy,td,S1=`<a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that works similarly to <a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.NoRepeatNGramLogitsProcessor">NoRepeatNGramLogitsProcessor</a>, but applied exclusively to prevent
the repetition of n-grams present in the prompt.`,Ly,sd,N1=`It was designed to promote chattiness in a language model, by preventing the generation of n-grams present in
previous conversation rounds.`,Ry,Us,Sy,nd,ma,$f,te,ha,Ny,rd,H1=`<a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that works similarly to <a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.RepetitionPenaltyLogitsProcessor">RepetitionPenaltyLogitsProcessor</a>, but with an <em>inverse</em> penalty
that is applied to the tokens present in the prompt. In other words, a penalty above 1.0 increases the odds of
selecting tokens that were present in the prompt.`,Hy,ad,E1=`It was designed to avoid hallucination in input-grounded tasks, like summarization. Although originally intended
for encoder-decoder models, it can also be used with decoder-only models like LLMs.`,Ey,Zs,qy,od,ga,jf,be,ua,Qy,ld,q1=`<a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that performs epsilon-sampling, i.e. restricting to tokens with <code>prob &gt;= epsilon</code>. Takes the
largest min_tokens_to_keep tokens if no tokens satisfy this constraint. See <a href="https://arxiv.org/abs/2210.15191" rel="nofollow">Truncation Sampling as Language Model
Desmoothing</a> for more information.`,Dy,Cs,Yy,cd,fa,xf,ye,_a,Py,id,Q1=`<a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that performs eta-sampling, a technique to filter out tokens with probabilities below a dynamic
cutoff value, <code>eta</code>, which is calculated based on a combination of the hyperparameter <code>epsilon</code> and the entropy of
the token probabilities, i.e. <code>eta := min(epsilon, sqrt(epsilon * e^-entropy(probabilities)))</code>. Takes the largest
min_tokens_to_keep tokens if no tokens satisfy this constraint. It addresses the issue of poor quality in long
samples of text generated by neural language models leading to more coherent and fluent text. See <a href="https://arxiv.org/abs/2210.15191" rel="nofollow">Truncation
Sampling as Language Model Desmoothing</a> for more information. Note: <code>do_sample</code>
must be set to <code>True</code> for this <code>LogitsProcessor</code> to work.`,Ay,Ws,Oy,dd,ba,Jf,Te,ya,Ky,pd,D1=`<a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that exponentially increases the score of the <code>eos_token_id</code> after <code>start_index</code> has been
reached. This allows generating shorter sequences without having a hard cutoff, allowing the <code>eos_token</code> to be
predicted in a meaningful position.`,eT,Bs,tT,md,Ta,Uf,ve,va,sT,hd,Y1=`<a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces the specified token as the first generated token. Used with encoder-decoder
models.`,nT,zs,rT,gd,Ma,Zf,Me,wa,aT,ud,P1='<a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces the specified token as the last generated token when <code>max_length</code> is reached.',oT,Is,lT,fd,ka,Cf,R,$a,cT,_d,A1='<a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces diverse beam search.',iT,bd,O1=`Note that this logits processor is only effective for <code>PreTrainedModel.group_beam_search</code>. See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">Diverse Beam
Search: Decoding Diverse Solutions from Neural Sequence Models</a> for more
details.`,dT,yd,K1=`Traditional beam search often generates very similar sequences across different beams.
<code>HammingDiversityLogitsProcessor</code> addresses this by penalizing beams that generate tokens already chosen by other
beams in the same time step.`,pT,Vs,mT,Td,ja,Wf,we,xa,hT,vd,ek=`<a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that removes all <code>nan</code> and <code>inf</code> values to avoid the generation method to fail. Note that using
the logits processor should only be used if necessary since it can slow down the generation method.`,gT,Md,tk=`This logits processor has no <code>generate</code> example, as there shouldn’t be a correct combination of flags that warrants
its use.`,uT,wd,Ja,Bf,ke,Ua,fT,kd,sk=`<a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> for normalizing the scores using log-softmax. It’s important to normalize
the scores during beam search, after applying the logits processors or warpers, since the search algorithm used in
this library doesn’t do it (it only does it before, but they may need re-normalization) but it still supposes that
the scores are normalized when comparing the hypotheses.`,_T,Gs,bT,$d,Za,zf,Ae,Ca,yT,jd,nk="Abstract base class for all logit processors that can be applied during generation.",TT,xd,Wa,If,Oe,Ba,vT,Jd,rk=`This class can be used to create a list of <a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> to subsequently process a <code>scores</code> input tensor.
This class inherits from list and adds a specific <em><strong>call</strong></em> method to apply each <a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> to the
inputs.`,MT,Ud,za,Vf,$e,Ia,wT,Zd,ak=`<a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforcing a min-length by setting EOS probability to 0. Note that, for decoder-only models
like most LLMs, the length includes the prompt.`,kT,Fs,$T,Cd,Va,Gf,je,Ga,jT,Wd,ok=`<a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforcing a min-length of new tokens by setting EOS (End-Of-Sequence) token probability to 0.
Contrarily to <a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.MinLengthLogitsProcessor">MinLengthLogitsProcessor</a>, this processor ignores the prompt.`,xT,Xs,JT,Bd,Fa,Ff,S,Xa,UT,zd,lk=`<a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that performs min-p, i.e. keeps all tokens that are above a minimum probability, scaled by the
probability of the most likely token. As a result, the filter becomes more agressive in the presence of
high-probability tokens, which is a sign of a confident output that we shouldn’t deviate from.`,ZT,Id,ck=`Often used together with <a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.TemperatureLogitsWarper">TemperatureLogitsWarper</a>. Used as an alternative to <a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.TopPLogitsWarper">TopPLogitsWarper</a> and
<a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.TopKLogitsWarper">TopKLogitsWarper</a>.`,CT,Vd,ik='Created by @menhguin and @kalomaze (github handles). Code adapted from <a href="https://github.com/oobabooga/text-generation-webui/pull/4449/files" rel="nofollow">this external PR</a>',WT,Ls,BT,Gd,La,Xf,se,Ra,zT,Fd,dk='<a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces that specified sequences will never be selected.',IT,Rs,VT,Ss,GT,Xd,Sa,Lf,ne,Na,FT,Ld,pk=`N-grams are groups of “n” consecutive words, characters, or tokens taken from a sequence of text. Given the
sentence: “She runs fast”, the bi-grams (n=2) would be (“she”, “runs”) and (“runs”, “fast”). In text generation,
avoiding repetitions of word sequences provides a more diverse output. This <a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforces no
repetition of n-grams by setting the scores of banned tokens to negative infinity which eliminates those tokens
from consideration when further processing the scores. Note that, for decoder-only models like most LLMs, the
prompt is also considered to obtain the n-grams.
<a href="https://github.com/pytorch/fairseq/blob/a07cb6f40480928c9e0548b737aadd36ee66ac76/fairseq/sequence_generator.py#L345" rel="nofollow">Fairseq</a>.`,XT,Ns,LT,Hs,RT,Rd,Ha,Rf,xe,Ea,ST,Sd,mk=`<a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces constrained generation and is useful for prefix-conditioned constrained
generation. See <a href="https://arxiv.org/abs/2010.00904" rel="nofollow">Autoregressive Entity Retrieval</a> for more information.`,NT,Es,HT,Nd,qa,Sf,re,Qa,ET,Hd,hk=`<a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that prevents the repetition of previous tokens through a penalty. This penalty is applied at
most once per token. Note that, for decoder-only models like most LLMs, the considered tokens include the prompt.`,qT,Ed,gk=`In the original <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">paper</a>, the authors suggest the use of a penalty of around
1.2 to achieve a good balance between truthful generation and lack of repetition. To penalize and reduce
repetition, use <code>penalty</code> values above 1.0, where a higher value penalizes more strongly. To reward and encourage
repetition, use <code>penalty</code> values between 0.0 and 1.0, where a lower value rewards more strongly.`,QT,qs,DT,qd,Da,Nf,ae,Ya,YT,Qd,uk=`<a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that applies an additive bias on sequences. The bias is applied to the last token of a sequence
when the next generated token can complete it. Consequently, to take the most of biasing sequences with more than
one token, consider using beam methods (to gracefully work around partially completed sequences that have a
negative bias) and applying the bias to their prefixes (to ensure the bias is applied earlier).`,PT,Qs,AT,Ds,OT,Dd,Pa,Hf,Je,Aa,KT,Yd,fk=`<a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.SuppressTokensAtBeginLogitsProcessor">SuppressTokensAtBeginLogitsProcessor</a> supresses a list of tokens as soon as the <code>generate</code> function starts
generating using <code>begin_index</code> tokens. This should ensure that the tokens defined by <code>begin_suppress_tokens</code> are
not generated at the begining. Originally created for
<a href="https://huggingface.co/docs/transformers/model_doc/whisper" rel="nofollow">Whisper</a>.`,ev,Ys,tv,Pd,Oa,Ef,Ue,Ka,sv,Ad,_k=`This processor can be used to suppress a list of tokens. The processor will set their log probs to <code>-inf</code> so
that they are not generated. Originally created for
<a href="https://huggingface.co/docs/transformers/model_doc/whisper" rel="nofollow">Whisper</a>.`,nv,Ps,rv,Od,eo,qf,oe,to,av,Kd,bk=`<a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> for temperature (exponential scaling output probability distribution), which effectively means
that it can control the randomness of the predicted tokens. Often used together with <a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.TopPLogitsWarper">TopPLogitsWarper</a> and
<a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.TopKLogitsWarper">TopKLogitsWarper</a>.`,ov,As,lv,Os,cv,ep,so,Qf,Ze,no,iv,tp,yk=`<a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that performs top-k, i.e. restricting to the k highest probability elements. Often used
together with <a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.TemperatureLogitsWarper">TemperatureLogitsWarper</a> and <a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.TopPLogitsWarper">TopPLogitsWarper</a>.`,dv,Ks,pv,sp,ro,Df,Ce,ao,mv,np,Tk=`<a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that performs top-p, i.e. restricting to top tokens summing to prob_cut_off &lt;= prob_cut_off.
Often used together with <a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.TemperatureLogitsWarper">TemperatureLogitsWarper</a> and <a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.TopKLogitsWarper">TopKLogitsWarper</a>.`,hv,en,gv,rp,oo,Yf,le,lo,uv,ap,vk=`<a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that performs typical decoding. Inspired on how humans use language, it prioritizes tokens
whose log probability is close to the entropy of the token probability distribution. This means that the most
likely tokens may be discarded in the process.`,fv,op,Mk='See <a href="https://arxiv.org/abs/2202.00666" rel="nofollow">Typical Decoding for Natural Language Generation</a> for more information.',_v,tn,bv,lp,co,Pf,ce,io,yv,cp,wk=`Logits processor for Classifier-Free Guidance (CFG). The processors computes a weighted average across scores
from prompt conditional and prompt unconditional (or negative) logits, parameterized by the <code>guidance_scale</code>.
The unconditional scores are computed internally by prompting <code>model</code> with the <code>unconditional_ids</code> branch.`,Tv,ip,kk='See <a href="https://arxiv.org/abs/2306.17806" rel="nofollow">the paper</a> for more information.',vv,sn,Mv,dp,po,Af,ie,mo,wv,pp,$k=`<a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that modifies the logits for the generation of timestamps in the transcription. When the input
tokens are at a specific threshold, the processor sets the scores to negative infinity. The processor makes sure
that timestamp tokens appear in pairs, by masking out the logits that would break this pairing pattern. This is
done to maintain the consistency and structure of generated timestamps. It also ensures that when the predicted
probability of sampling any of the timestamp token is greater than any individual non-timestamp token, those
non-timestamp logits are set to negative infinity. This is done to ensure the generation of timestamps over other
potential tokens.`,kv,mp,jk='See <a href="https://arxiv.org/abs/2212.04356" rel="nofollow">the paper</a> for more information.',$v,nn,jv,hp,ho,Of,N,go,xv,gp,xk=`Logits processor for watermarking generated text. The processor modifies model output scores by adding a small bias to
randomized set of “green” tokens before generating the next token. “Green” tokens selection process depends on the
<code>seeding_scheme</code> used. The code was based on the <a href="https://github.com/jwkirchenbauer/lm-watermarking/tree/main" rel="nofollow">original repo</a>.`,Jv,up,Jk='The text generated by this <code>LogitsProcessor</code> can be detected using <code>WatermarkDetector</code>. See <a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.WatermarkDetector.__call__"><strong>call</strong>()</a> for details,',Uv,fp,Uk='See <a href="https://arxiv.org/abs/2306.04634" rel="nofollow">the paper</a> for more information.',Zv,rn,Cv,_p,uo,Kf,fo,e_,Ke,_o,Wv,bp,Zk='<a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces the specified token as the first generated token.',Bv,yp,bo,t_,et,yo,zv,Tp,Ck='<a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces the specified token as the last generated token when <code>max_length</code> is reached.',Iv,vp,To,s_,tt,vo,Vv,Mp,Wk=`This processor takes a list of pairs of integers which indicates a mapping from generation indices to token
indices that will be forced before sampling. The processor will set their log probs to <code>0</code> and all other tokens to
<code>-inf</code> so that they are sampled at their corresponding index.`,Gv,wp,Mo,n_,st,wo,Fv,kp,Bk="Abstract base class for all logit processors that can be applied during generation.",Xv,an,ko,Lv,$p,zk="TF method for processing logits.",r_,nt,$o,Rv,jp,Ik=`This class can be used to create a list of <a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> to subsequently process a <code>scores</code> input tensor.
This class inherits from list and adds a specific <em><strong>call</strong></em> method to apply each <a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> to the
inputs.`,Sv,xp,jo,a_,rt,xo,Nv,Jp,Vk="Abstract base class for all logit warpers that can be applied during generation with multinomial sampling.",Hv,on,Jo,Ev,Up,Gk="TF method for warping logits.",o_,at,Uo,qv,Zp,Fk='<a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> enforcing a min-length by setting EOS probability to 0.',Qv,Cp,Zo,l_,ot,Co,Dv,Wp,Xk='<a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces that specified sequences will never be sampled.',Yv,Bp,Wo,c_,lt,Bo,Pv,zp,Lk=`<a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces no repetition of n-grams. See
<a href="https://github.com/pytorch/fairseq/blob/a07cb6f40480928c9e0548b737aadd36ee66ac76/fairseq/sequence_generator.py#L345" rel="nofollow">Fairseq</a>.`,Av,Ip,zo,i_,ct,Io,Ov,Vp,Rk='<a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> enforcing an exponential penalty on repeated sequences.',Kv,Gp,Vo,d_,it,Go,eM,Fp,Sk=`<a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.TFSuppressTokensAtBeginLogitsProcessor">TFSuppressTokensAtBeginLogitsProcessor</a> suppresses a list of tokens as soon as the <code>generate</code> function starts
generating using <code>begin_index</code> tokens. This should ensure that the tokens defined by <code>begin_suppress_tokens</code> at not
sampled at the begining of the generation.`,tM,Xp,Fo,p_,dt,Xo,sM,Lp,Nk=`This processor can be used to suppress a list of tokens. The processor will set their log probs to <code>-inf</code> so that they
are not sampled.`,nM,Rp,Lo,m_,pt,Ro,rM,Sp,Hk='<a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.TFLogitsWarper">TFLogitsWarper</a> for temperature (exponential scaling output probability distribution).',aM,Np,So,h_,mt,No,oM,Hp,Ek='<a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.TFLogitsWarper">TFLogitsWarper</a> that performs top-k, i.e. restricting to the k highest probability elements.',lM,Ep,Ho,g_,ht,Eo,cM,qp,qk='<a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.TFLogitsWarper">TFLogitsWarper</a> that performs top-p, i.e. restricting to top tokens summing to &lt;= prob_cut_off.',iM,Qp,qo,u_,Qo,f_,gt,Do,dM,Dp,Qk='<a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> that enforces the specified token as the first generated token.',pM,Yp,Yo,__,ut,Po,mM,Pp,Dk='<a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> that enforces the specified token as the last generated token when <code>max_length</code> is reached.',hM,Ap,Ao,b_,ft,Oo,gM,Op,Yk=`<a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> that takes a list of pairs of integers which indicates a mapping from generation indices to
token indices that will be forced before sampling. The processor will set their log probs to 0 and all other tokens
to <code>-inf</code> so that they are sampled at their corresponding index.`,uM,Kp,Ko,y_,_t,el,fM,em,Pk="Abstract base class for all logit processors that can be applied during generation.",_M,ln,tl,bM,tm,Ak="Flax method for processing logits.",T_,bt,sl,yM,sm,Ok=`This class can be used to create a list of <a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> or <a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> to subsequently process
a <code>scores</code> input tensor. This class inherits from list and adds a specific <em><strong>call</strong></em> method to apply each
<a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> or <a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> to the inputs.`,TM,nm,nl,v_,yt,rl,vM,rm,Kk="Abstract base class for all logit warpers that can be applied during generation with multinomial sampling.",MM,cn,al,wM,am,e$="Flax method for warping logits.",M_,Tt,ol,kM,om,t$='<a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> enforcing a min-length by setting EOS probability to 0.',$M,lm,ll,w_,vt,cl,jM,cm,s$=`<a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> supressing a list of tokens as soon as the <code>generate</code> function starts generating using
<code>begin_index</code> tokens. This should ensure that the tokens defined by <code>begin_suppress_tokens</code> are not sampled at the
begining of the generation.`,xM,im,il,k_,Mt,dl,JM,dm,n$=`<a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> suppressing a list of tokens at each decoding step. The processor will set their log probs
to be <code>-inf</code> so they are not sampled.`,UM,pm,pl,$_,wt,ml,ZM,mm,r$='<a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> for temperature (exponential scaling output probability distribution).',CM,hm,hl,j_,kt,gl,WM,gm,a$='<a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> that performs top-k, i.e. restricting to the k highest probability elements.',BM,um,ul,x_,$t,fl,zM,fm,o$='<a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> that performs top-p, i.e. restricting to top tokens summing to prob_cut_off &lt;= prob_cut_off.',IM,_m,_l,J_,jt,bl,VM,bm,l$=`Whisper specific Processor. This processor can be used to force a list of tokens. The processor will set their log
probs to <code>inf</code> so that they are sampled at their corresponding index.`,GM,ym,yl,U_,Tl,Z_,vl,c$='A <a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a> can be used to change when to stop generation (other than EOS token). Please note that this is exclusively available to our PyTorch implementations.',C_,We,Ml,FM,Tm,i$="Abstract base class for all stopping criteria that can be applied during generation.",XM,vm,d$="If your stopping criteria depends on the <code>scores</code> input, make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.",LM,Mm,wl,W_,us,kl,RM,wm,$l,B_,xt,jl,SM,km,p$=`This class can be used to stop generation whenever the full generated number of tokens exceeds <code>max_length</code>. Keep
in mind for decoder-only type of transformers, this will include the initial prompted tokens.`,NM,$m,xl,z_,Jt,Jl,HM,jm,m$=`This class can be used to stop generation whenever the full generation exceeds some amount of time. By default, the
time will start being counted when you initialize this function. You can override this by passing an
<code>initial_time</code>.`,EM,xm,Ul,I_,J,Zl,qM,Jm,h$=`This class can be used to stop generation whenever specific string sequences are generated. It preprocesses
the strings together with the tokenizer vocab to find positions where tokens can validly complete the stop strings.`,QM,Um,g$=`Generation is stopped as soon as a token is generated that completes any of the stop strings.
We want to catch any instance in which the stop string would be present in the decoded output, which means
we must also catch cases with “overhangs” off one or both ends. To make this more concrete, for the stop string
“stop”, any of the following token sequences would trigger the match:`,DM,Zm,u$="<li>[“st”, “op”]</li> <li>[“stop”]</li> <li>[“st”, “opera”]</li> <li>[“sto”, “pper”]</li> <li>[“las”, “topper”]</li> <li>[“s”, “to”, “pped”]</li>",YM,Cm,f$=`Note that a match will only be triggered if the stop string is at the end of the generated sequence. In other
words, these sequences will not trigger a match:`,PM,Wm,_$="<li>[“stop”, “at”]</li> <li>[“st”, “op”, “at”]</li> <li>[“st”, “opera”, “tion”]</li>",AM,Bm,b$=`The reason these are not a match is that the stop string does not overlap with the final token. If you can remove
one or more tokens from the end of the sequence without destroying the stop string, then this criterion will not
match that stop string. This is by design; because this check is run after each token is generated, we can’t miss a
valid stop string if one is generated, but we don’t want to halt generation just because the stop string exists
somewhere in the past input_ids.`,OM,zm,y$=`How is the match actually performed, though? We do it in quite a confusing way, because we want the entire match
process to be compilable with Torch or XLA, which means we cannot use standard string methods. However, it is possible,
with some work, to do string matching with pure tensor operations. We’ll begin by describing the algorithm we use
with standard string operations, and then at the end we’ll explain how this is converted to pure tensor operations.`,KM,Im,T$=`The key to the algorithm is an observation: Because the stop string must overlap with the end of the token sequence, we can start at
the end of the sequence and work backwards. Specifically, we check that there is an overlap between the start of
the final token and the end of the stop_string, or to put it another way, stop_string[-i:] == token[:i] for
some i > 0. If you look at the positive examples above, you’ll see the last token in all of them fulfills this
property:`,e0,Vm,v$="<li>[“st”, “op”] (overlap is “op”, overlap length == 2)</li> <li>[“stop”]  (overlap is “stop”, overlap length == 4)</li> <li>[“st”, “opera”]  (overlap is “op”, overlap length == 2)</li> <li>[“sto”, “pper”]  (overlap is “p”, overlap length == 1)</li> <li>[“las”, “topper”]  (overlap is “top”, overlap length == 3)</li> <li>[“s”, “to”, “pped”]  (overlap is “p”, overlap length == 1)</li>",t0,Gm,M$=`It’s impossible to construct a matching sequence that does not have this property (feel free to verify this
yourself). However, although this overlap between the start of the final token and the end of the stop string is
necessary for a match, it is not sufficient. We also need to check that the rest of the token sequence is
consistent with the stop string.`,s0,Fm,w$=`How do we do that? Let’s use [“s”, “to”, “pped”] as an example. We know that the final token, “pped”, has an
overlap of 1 with the stop string, “stop”. We then go back to the previous token, “to”. Since we have already
matched 1 character from the stop string, the remainder to check is “sto”. We check that the next token “to”
matches the end of the remainder, which it does. We have now matched 3 characters from the stop string, and the
remainder to match is “s”. We go back to the previous token again, which is also “s”. This is a match, and so
we have matched the entire stop string.`,n0,Xm,k$=`How does it work when the tokens run off the start of the stop string, though? Let’s consider the example of
[“las”, “topper”]. The final token, “topper”, has an overlap of 3 with the stop string, “stop”. Therefore,
the remaining stop string to match is “s”. We go back to the previous token, “las”. Because the remainder to
match is just “s”, with length 1, we consider only the final 1 character from the token, which is “s”. This
matches the stop string, and so the entire string is matched.`,r0,Lm,$$=`How do we compute these matches with tensor operations, though? Simply: we efficiently precompute the necessary
information for all tokens! For every token, we compute:`,a0,Rm,j$="<li>Its overlap with the end of the stop string, if any</li> <li>The positions inside the stop string where the token matches, including matches that run off the start.</li> <li>The total length of the token</li>",o0,Sm,x$=`For example, for the token “pped”, we would compute an end overlap of 1, no internal matching positions,
and a length of 4. For the token “to”, we would compute no end overlap, a single internal matching position
of 1 (counting from the end), and a length of 2. For the token “s”, we would compute no end overlap,
a single internal matching position of 3 (again counting from the end) and a length of 1.`,l0,Nm,J$=`As long as we have this information, we can execute the algorithm above without any string comparison
operations. We simply perform the following steps:`,c0,Hm,U$="<li>Check if the final token has an end-overlap with the start string</li> <li>Continue backwards, keeping track of how much of the stop string we’ve matched so far</li> <li>At each point, check if the next token has the current position as one of its valid positions</li> <li>Continue until either a match fails, or we completely match the whole stop string</li>",i0,Em,Z$=`Again, consider [“s”, “to”, “pped”] as an example. “pped” has an end overlap of 1, so we can begin a match.
We have matched 1 character so far, so we check that the next token “to”, has 1 as a valid position (again,
counting from the end). It does, so we add the length of “to” to our position tracker. We have now matched
3 characters, so we check that the next token “s” has 3 as a valid position. It does, so we add its length
to the position tracker. The position tracker is now 4, which is the length of the stop string. We have matched the
entire stop string.`,d0,qm,C$=`In the second case, [“las”, “topper”], “topper” has an end overlap of 3, so we can begin a match. We have
matched 3 characters so far, so we check that the next token “las” has 3 as a valid position. It does, because we
allow tokens to match positions that run off the start of the stop string. We add its length to the position
tracker. The position tracker is now 6, which is greater than the length of the stop string! Don’t panic, though -
this also counts as a match of the stop string. We have matched the entire stop string.`,p0,dn,m0,Qm,Cl,V_,Ut,Wl,h0,Dm,W$=`This class can be used to stop generation whenever the “end-of-sequence” token is generated.
By default, it uses the <code>model.generation_config.eos_token_id</code>.`,g0,Ym,Bl,G_,zl,F_,Il,B$='A <a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.Constraint">Constraint</a> can be used to force the generation to include specific tokens or sequences in the output. Please note that this is exclusively available to our PyTorch implementations.',X_,W,Vl,u0,Pm,z$=`Abstract base class for all constraints that can be applied during generation.
It must define how the constraint can be satisfied.`,f0,Am,I$="All classes that inherit Constraint must follow the requirement that",_0,pn,b0,Om,V$="will always terminate (halt).",y0,mn,Gl,T0,Km,G$="When called, returns the token(s) that would take this constraint one step closer to being fulfilled.",v0,hn,Fl,M0,eh,F$="Creates a new instance of this constraint.",w0,gn,Xl,k0,th,X$="Reads in a token and returns whether it creates progress.",$0,un,Ll,j0,sh,L$="Returns the number of remaining steps of <code>advance()</code> in order to complete this constraint.",x0,fn,Rl,J0,nh,R$=`Resets the state of this constraint to its initialization. We would call this in cases where the fulfillment of
a constraint is abrupted by an unwanted token.`,U0,_n,Sl,Z0,rh,S$="Tests whether this constraint has been properly defined.",C0,Ht,Nl,W0,ah,N$=`Reads in a token and returns booleans that indicate the progress made by it. This function will update the
state of this object unlikes <code>does_advance(self, token_id: int)</code>.`,B0,oh,H$=`This isn’t to test whether a certain token will advance the progress; it’s to update its state as if it has
been generated. This becomes important if token_id != desired token (refer to else statement in
PhrasalConstraint)`,L_,fs,Hl,z0,lh,E$='<a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.Constraint">Constraint</a> enforcing that an ordered sequence of tokens is included in the output.',R_,_s,El,I0,ch,q$='A special <a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.Constraint">Constraint</a> that is fulfilled by fulfilling just one of several constraints.',S_,Be,ql,V0,ih,Q$="A class for beam scorers to track its progress through a list of constraints.",G0,A,Ql,F0,dh,D$=`The list of tokens to generate such that we can make progress.
By “list” we don’t mean the list of token that will fully fulfill a constraint.`,X0,ph,Y$=`Given constraints <code>c_i = {t_ij | j == # of tokens}</code>, If we’re not in the middle of progressing through a
specific constraint <code>c_i</code>, we return:`,L0,mh,P$="<code>[t_k1 for k in indices of unfulfilled constraints]</code>",R0,hh,A$=`If we are in the middle of a constraint, then we return:
<code>[t_ij]</code>, where <code>i</code> is the index of the inprogress constraint, <code>j</code> is the next step for the constraint.`,S0,gh,O$=`Though we don’t care which constraint is fulfilled first, if we are in the progress of fulfilling a constraint,
that’s the only one we’ll return.`,N0,bn,Dl,H0,uh,K$="token_ids: the tokens generated thus far to reset the state of the progress through constraints.",N_,Yl,H_,ze,Pl,E0,fh,ej=`Abstract base class for all beam scorers that are used for <code>~PreTrainedModel.beam_search</code> and
<code>~PreTrainedModel.beam_sample</code>.`,q0,_h,Al,Q0,bh,Ol,E_,H,Kl,D0,yh,tj='<a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> implementing standard beam search decoding.',Y0,Th,sj=`Adapted in part from <a href="https://github.com/facebookresearch/XLM/blob/9e6f6814d17be4fe5b15f2e6c43eb2b2d76daeb4/src/model/transformer.py#L529" rel="nofollow">Facebook’s XLM beam search
code</a>.`,P0,vh,nj=`Reference for the diverse beam search algorithm and implementation <a href="https://github.com/ashwinkalyan/dbs/blob/master/dbs/beam_utils.lua" rel="nofollow">Ashwin Kalyan’s DBS
implementation</a>`,A0,Mh,ec,O0,wh,tc,q_,Ie,sc,K0,kh,rj='<a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> implementing constrained beam search decoding.',ew,$h,nc,tw,jh,rc,Q_,ac,D_,G,oc,sw,xh,aj="Simple text streamer that prints the token(s) to stdout as soon as entire words are formed.",nw,yn,rw,Tn,aw,vn,lc,ow,Jh,oj="Flushes any remaining cache and prints a newline to stdout.",lw,Mn,cc,cw,Uh,lj="Prints the new text to stdout. If the stream is ending, also prints a newline.",iw,wn,ic,dw,Zh,cj="Receives tokens, decodes them, and prints them to stdout as soon as they form entire words.",Y_,de,dc,pw,Ch,ij=`Streamer that stores print-ready text in a queue, to be used by a downstream application as an iterator. This is
useful for applications that benefit from acessing the generated text in a non-blocking way (e.g. in an interactive
Gradio demo).`,mw,kn,hw,$n,gw,jn,pc,uw,Wh,dj="Put the new text in the queue. If the stream is ending, also put a stop signal in the queue.",P_,mc,A_,Zt,hc,fw,Bh,pj="Base, abstract class for all caches. The actual data structure is specific to each subclass.",_w,xn,gc,bw,zh,mj="Updates the cache with the new <code>key_states</code> and <code>value_states</code> for the layer <code>layer_idx</code>.",O_,Ct,uc,yw,Ih,hj="Base class for cache configs",Tw,Jn,fc,vw,Vh,gj=`Updates attributes of this class instance with attributes from <code>kwargs</code> if they match existing attributes,
returning all the unused kwargs.`,K_,Wt,_c,Mw,Gh,uj="Configuration class for quantized cache settings.",ww,Un,bc,kw,Fh,fj="Validates if the arguments passed are correct",eb,z,yc,$w,Xh,_j="A cache that grows dynamically as more tokens are generated. This is the default for generative models.",jw,Lh,bj=`It stores the Key and Value states as a list of tensors, one for each layer. The expected shape for each tensor is
<code>[batch_size, num_heads, seq_len, head_dim]</code>.`,xw,Zn,Jw,Cn,Tc,Uw,Rh,yj="Updates the cache with the new <code>key_states</code> and <code>value_states</code> for the layer <code>layer_idx</code>.",Zw,Wn,vc,Cw,Sh,Tj="Returns the sequence length of the cached states. A layer index can be optionally passed.",Ww,Bn,Mc,Bw,Nh,vj="Reorders the cache for beam search, given the selected beam indices.",zw,zn,wc,Iw,Hh,Mj=`Converts the <code>DynamicCache</code> instance into the its equivalent in the legacy cache format. Used for
backward compatibility.`,Vw,In,kc,Gw,Eh,wj=`Converts a cache in the legacy cache format into an equivalent <code>DynamicCache</code>. Used for
backward compatibility.`,tb,E,$c,Fw,qh,kj=`A quantizer cache similar to what is described in the <a href="https://arxiv.org/abs/2402.02750" rel="nofollow">KIVI: A Tuning-Free Asymmetric 2bit Quantization for KV Cache paper</a>.
It allows the model to generate longer sequence length without allocating too much memory for Key and Value cache by applying quantization.`,Xw,Qh,$j=`The cache has two types of storage, one for original precision and one for the quantized cache. A <code>residual length</code> is set as a maximum capacity for the
original precision cache. When the length goes beyond maximum capacity, the original precision cache is discarded and moved into the quantized cache. The
quantization is done per-channel with a set <code>q_group_size</code> for both Keys and Values, in contrast to what was described in the paper.`,Lw,Dh,jj=`It stores Keys and Values a list of quantized tensors (tuples in case we need to store metadata), one for each layer. Additionally, it stores the Key and
Value in original precision states as a list of tensors, one for each layer. The size of each tensor
is <code>[batch_size, num_heads, seq_len - residual_length, head_dim]</code>`,Rw,Yh,jc,Sw,Vn,xc,Nw,Ph,xj="Returns the sequence length of the cached states. A layer index can be optionally passed.",sb,Bt,Jc,Hw,Ah,Jj="Quantized Cache class that uses <code>quanto</code> as a backend to perform quantization. Current implementation supports <code>int2</code> and <code>int4</code> dtypes only.",Ew,Gn,nb,zt,Uc,qw,Oh,Uj="Quantized Cache class that uses <code>HQQ</code> as a backend to perform quantization. Current implementation supports <code>int2</code>, <code>int4</code>, <code>int8</code> dtypes.",Qw,Fn,rb,F,Zc,Dw,Kh,Zj=`A cache that as described in the <a href="https://arxiv.org/abs/2309.17453" rel="nofollow">Attention Sinks paper</a>. It allows the model to
generate beyond the length of its context window, without losing fluency in the conversation. As it discards past
tokens, the model will lose the ability to generate tokens that depend on the context that was discarded.`,Yw,eg,Cj=`It stores the Key and Value states as a list of tensors, one for each layer. The expected shape for each tensor is
<code>[batch_size, num_heads, seq_len, head_dim]</code>.`,Pw,Xn,Aw,Ln,Cc,Ow,tg,Wj="Updates the cache with the new <code>key_states</code> and <code>value_states</code> for the layer <code>layer_idx</code>.",Kw,Rn,Wc,e2,sg,Bj="Returns the sequence length of the cached states. A layer index can be optionally passed.",t2,Sn,Bc,s2,ng,zj="Reorders the cache for beam search, given the selected beam indices.",ab,q,zc,n2,rg,Ij=`A drop-in replacement for DynamicCache that conserves GPU memory at the expense of more CPU memory.
Useful for generating from models with very long context.`,r2,ag,Vj=`In addition to the default CUDA stream, where all forward() computations happen,
this class uses another stream, the prefetch stream, which it creates itself.
Since scheduling of operations on separate streams happens independently, this class uses
the prefetch stream to asynchronously prefetch the KV cache of layer k+1 when layer k is executing.
The movement of the layer k-1 cache to the CPU is handled by the default stream as a simple way to
ensure the eviction is scheduled after all computations on that cache are finished.`,a2,Nn,Ic,o2,og,Gj="Updates the cache with the new <code>key_states</code> and <code>value_states</code> for the layer <code>layer_idx</code>.",l2,Hn,Vc,c2,lg,Fj="Starts prefetching the next layer cache",i2,En,Gc,d2,cg,Xj="Moves the previous layer cache to the CPU",ob,Q,Fc,p2,ig,Lj="Static Cache class to be used with <code>torch.compile(model)</code> and <code>torch.export()</code>.",m2,qn,h2,Qn,Xc,g2,dg,Rj=`Updates the cache with the new <code>key_states</code> and <code>value_states</code> for the layer <code>layer_idx</code>.
It is VERY important to index using a tensor, otherwise you introduce a copy to the device.`,u2,Dn,Lc,f2,pg,Sj="Returns the sequence length of the cached states that were seen by the model.",_2,Yn,Rc,b2,mg,Nj="Resets the cache values while preserving the objects",lb,D,Sc,y2,hg,Hj=`Static cache class to be used with <code>torch.compile(model)</code> that offloads to the CPU or
another device.`,T2,Pn,v2,An,Nc,M2,gg,Ej=`Updates the cache with the new <code>key_states</code> and <code>value_states</code> for the layer <code>layer_idx</code>.
It is VERY important to index using a tensor, otherwise you introduce a copy to the device.`,w2,On,Hc,k2,ug,qj="Returns the sequence length of the cached states that were seen by the model.",$2,Kn,Ec,j2,fg,Qj="Resets the cache values while preserving the objects.",cb,Y,qc,x2,_g,Dj=`Hybrid Cache class to be used with <code>torch.compile</code> for Gemma2 models that alternate between a local sliding window attention
and global attention in every other layer. Under the hood, Hybrid Cache leverages [“SlidingWindowCache”] for sliding window attention
and [“StaticCache”] for global attention. For more information, see the documentation of each subcomponeent cache class.`,J2,er,U2,bg,Qc,Z2,yg,Dc,C2,tr,Yc,W2,Tg,Yj="Resets the cache values while preserving the objects",ib,I,Pc,B2,vg,Pj=`Sliding Window Cache class to be used with <code>torch.compile</code> for models like Mistral that support sliding window attention.
Every time when we try to update the cache, we compute the <code>indices</code> based on <code>cache_position &gt;= self.config.sliding_window - 1</code>,
if true(which means the cache can not hold all the old key value states and new states together because of the sliding window constraint),
we need to do a cycle shift based on <code>indices</code> to replace the oldest states by the new key value states passed in.`,z2,Mg,Aj="The <code>to_shift</code> is only true once we are above sliding_window. Thus with <code>sliding_window==64</code>:",I2,wg,Oj=`indices = (slicing + to_shift[-1].int()-1) % self.config.sliding_window
tensor([ 1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16, 17, 18,
19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36,
37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54,
55, 56, 57, 58, 59, 60, 61, 62, 63,  0])`,V2,kg,Kj="We overwrite the cache using these, then we always write at cache_position (clamped to <code>sliding_window</code>)",G2,sr,F2,$g,Ac,X2,jg,Oc,db,V,Kc,L2,xg,ex=`Base, abstract class for all encoder-decoder caches. Can be used to hold combinations of self-attention and
cross-attention caches.`,R2,nr,S2,rr,ei,N2,Jg,tx="Returns the sequence length of the cached states. A layer index can be optionally passed.",H2,ar,ti,E2,Ug,sx="Converts the <code>EncoderDecoderCache</code> instance into  its equivalent in the legacy cache format.",q2,or,si,Q2,Zg,nx="Converts a cache in the legacy cache format into an equivalent <code>EncoderDecoderCache</code>.",D2,Cg,ni,Y2,lr,ri,P2,Wg,rx="Reorders the cache for beam search, given the selected beam indices.",pb,P,ai,A2,Bg,ax="Cache for mamba model which does not have attention mechanism and key value states.",O2,cr,K2,zg,oi,e1,Ig,li,t1,Vg,ci,mb,ii,hb,pe,di,s1,Gg,ox=`Detector for detection of watermark generated text. The detector needs to be given the exact same settings that were
given during text generation to replicate the watermark greenlist generation and so detect the watermark. This includes
the correct device that was used during text generation, the correct watermarking arguments and the correct tokenizer vocab size.
The code was based on the <a href="https://github.com/jwkirchenbauer/lm-watermarking/tree/main" rel="nofollow">original repo</a>.`,n1,Fg,lx='See <a href="https://arxiv.org/abs/2306.04634" rel="nofollow">the paper</a> for more information.',r1,ir,a1,dr,pi,o1,Xg,cx="ma",gb,mi,ub,wu,fb;return w=new ge({props:{title:"Utilities for Generation",local:"utilities-for-generation",headingTag:"h1"}}),Mr=new ge({props:{title:"Generate Outputs",local:"generate-outputs",headingTag:"h2"}}),$r=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdQVDJUb2tlbml6ZXIlMkMlMjBHUFQyTE1IZWFkTW9kZWwlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBHUFQyVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWktY29tbXVuaXR5JTJGZ3B0MiUyMiklMEFtb2RlbCUyMCUzRCUyMEdQVDJMTUhlYWRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjBhbmQlMjAlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQWdlbmVyYXRpb25fb3V0cHV0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjByZXR1cm5fZGljdF9pbl9nZW5lcmF0ZSUzRFRydWUlMkMlMjBvdXRwdXRfc2NvcmVzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2Tokenizer, GPT2LMHeadModel

tokenizer = GPT2Tokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
model = GPT2LMHeadModel.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)

inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute and &quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
generation_output = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)`,wrap:!1}}),Cr=new Z({props:{code:"Z2VuZXJhdGlvbl9vdXRwdXQlNUIlM0EyJTVE",highlighted:'generation_output[:<span class="hljs-number">2</span>]',wrap:!1}}),Ir=new ge({props:{title:"PyTorch",local:"transformers.generation.GenerateDecoderOnlyOutput",headingTag:"h3"}}),Vr=new M({props:{name:"class transformers.generation.GenerateDecoderOnlyOutput",anchor:"transformers.generation.GenerateDecoderOnlyOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"scores",val:": Optional = None"},{name:"logits",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.GenerateDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.logits",description:`<strong>logits</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_logits=True</code>) &#x2014;
Unprocessed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"logits"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor)))</code>, <em>optional</em>, returned when <code>use_cache=True</code>) &#x2014;
Returns the model cache, used to speed up decoding. Different models have a different cache format, check
the model&#x2019;s documentation. Usually, a <a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.Cache">Cache</a> instance.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/utils.py#L115"}}),Gr=new M({props:{name:"class transformers.generation.GenerateEncoderDecoderOutput",anchor:"transformers.generation.GenerateEncoderDecoderOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"scores",val:": Optional = None"},{name:"logits",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.GenerateEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.logits",description:`<strong>logits</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_logits=True</code>) &#x2014;
Unprocessed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"logits"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor)))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Returns the model cache, used to speed up decoding. Different models have a different cache format, check
the model&#x2019;s documentation. Usually, a <a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.Cache">Cache</a> instance.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/utils.py#L151"}}),Fr=new M({props:{name:"class transformers.generation.GenerateBeamDecoderOnlyOutput",anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"sequences_scores",val:": Optional = None"},{name:"scores",val:": Optional = None"},{name:"logits",val:": Optional = None"},{name:"beam_indices",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code>) &#x2014;
Beam transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens in this beam.
Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.logits",description:`<strong>logits</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_logits=True</code>) &#x2014;
Unprocessed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"logits"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>, returned when <code>output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"hidden_states"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor)))</code>, <em>optional</em>, returned when <code>use_cache=True</code>) &#x2014;
Returns the model cache, used to speed up decoding. Different models have a different cache format, check
the model&#x2019;s documentation. Usually, a <a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.Cache">Cache</a> instance.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/utils.py#L199"}}),Xr=new M({props:{name:"class transformers.generation.GenerateBeamEncoderDecoderOutput",anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"sequences_scores",val:": Optional = None"},{name:"scores",val:": Optional = None"},{name:"logits",val:": Optional = None"},{name:"beam_indices",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code>) &#x2014;
Beam transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens in this beam.
Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.logits",description:`<strong>logits</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_logits=True</code>) &#x2014;
Unprocessed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"logits"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>, returned when <code>output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size*num_beams*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor)))</code>, <em>optional</em>, returned when <code>use_cache=True</code>) &#x2014;
Returns the model cache, used to speed up decoding. Different models have a different cache format, check
the model&#x2019;s documentation. Usually, a <a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.Cache">Cache</a> instance.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/utils.py#L243"}}),Lr=new ge({props:{title:"TensorFlow",local:"transformers.generation.TFGreedySearchEncoderDecoderOutput",headingTag:"h3"}}),Rr=new M({props:{name:"class transformers.generation.TFGreedySearchEncoderDecoderOutput",anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/tf_utils.py#L85"}}),Sr=new M({props:{name:"class transformers.generation.TFGreedySearchDecoderOnlyOutput",anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/tf_utils.py#L57"}}),Nr=new M({props:{name:"class transformers.generation.TFSampleEncoderDecoderOutput",anchor:"transformers.generation.TFSampleEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size*num_return_sequences, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/tf_utils.py#L155"}}),Hr=new M({props:{name:"class transformers.generation.TFSampleDecoderOnlyOutput",anchor:"transformers.generation.TFSampleDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(num_return_sequences*batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(num_return_sequences*batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/tf_utils.py#L127"}}),Er=new M({props:{name:"class transformers.generation.TFBeamSearchEncoderDecoderOutput",anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": Optional = None"},{name:"scores",val:": Optional = None"},{name:"beam_indices",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. <code>Tuple of </code>tf.Tensor<code>with up to</code>max_new_tokens<code>elements (one element for each generated token), with each tensor of shape</code>(batch_size*num_beams, config.vocab_size)\`.`,name:"scores"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size*num_beams*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/tf_utils.py#L232"}}),qr=new M({props:{name:"class transformers.generation.TFBeamSearchDecoderOnlyOutput",anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": Optional = None"},{name:"scores",val:": Optional = None"},{name:"beam_indices",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/tf_utils.py#L197"}}),Qr=new M({props:{name:"class transformers.generation.TFBeamSampleEncoderDecoderOutput",anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": Optional = None"},{name:"scores",val:": Optional = None"},{name:"beam_indices",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size * num_return_sequence)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size*num_beams, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/tf_utils.py#L317"}}),Dr=new M({props:{name:"class transformers.generation.TFBeamSampleDecoderOnlyOutput",anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": Optional = None"},{name:"scores",val:": Optional = None"},{name:"beam_indices",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size * num_return_sequence)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/tf_utils.py#L282"}}),Yr=new M({props:{name:"class transformers.generation.TFContrastiveSearchEncoderDecoderOutput",anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/tf_utils.py#L393"}}),Pr=new M({props:{name:"class transformers.generation.TFContrastiveSearchDecoderOnlyOutput",anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/tf_utils.py#L366"}}),Ar=new ge({props:{title:"FLAX",local:"transformers.generation.FlaxSampleOutput",headingTag:"h3"}}),Or=new M({props:{name:"class transformers.generation.FlaxSampleOutput",anchor:"transformers.generation.FlaxSampleOutput",parameters:[{name:"sequences",val:": Array = None"}],parametersDescription:[{anchor:"transformers.generation.FlaxSampleOutput.sequences",description:`<strong>sequences</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, max_length)</code>) &#x2014;
The generated sequences.`,name:"sequences"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/flax_utils.py#L69"}}),Kr=new M({props:{name:"replace",anchor:"transformers.generation.FlaxSampleOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/flax/struct.py#L111"}}),ea=new M({props:{name:"class transformers.generation.FlaxGreedySearchOutput",anchor:"transformers.generation.FlaxGreedySearchOutput",parameters:[{name:"sequences",val:": Array = None"}],parametersDescription:[{anchor:"transformers.generation.FlaxGreedySearchOutput.sequences",description:`<strong>sequences</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, max_length)</code>) &#x2014;
The generated sequences.`,name:"sequences"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/flax_utils.py#L55"}}),ta=new M({props:{name:"replace",anchor:"transformers.generation.FlaxGreedySearchOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/flax/struct.py#L111"}}),sa=new M({props:{name:"class transformers.generation.FlaxBeamSearchOutput",anchor:"transformers.generation.FlaxBeamSearchOutput",parameters:[{name:"sequences",val:": Array = None"},{name:"scores",val:": Array = None"}],parametersDescription:[{anchor:"transformers.generation.FlaxBeamSearchOutput.sequences",description:`<strong>sequences</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, max_length)</code>) &#x2014;
The generated sequences.`,name:"sequences"},{anchor:"transformers.generation.FlaxBeamSearchOutput.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size,)</code>) &#x2014;
The scores (log probabilities) of the generated sequences.`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/flax_utils.py#L83"}}),na=new M({props:{name:"replace",anchor:"transformers.generation.FlaxBeamSearchOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/flax/struct.py#L111"}}),ra=new ge({props:{title:"LogitsProcessor",local:"logitsprocessor",headingTag:"h2"}}),oa=new ge({props:{title:"PyTorch",local:"transformers.AlternatingCodebooksLogitsProcessor",headingTag:"h3"}}),la=new M({props:{name:"class transformers.AlternatingCodebooksLogitsProcessor",anchor:"transformers.AlternatingCodebooksLogitsProcessor",parameters:[{name:"input_start_len",val:": int"},{name:"semantic_vocab_size",val:": int"},{name:"codebook_size",val:": int"}],parametersDescription:[{anchor:"transformers.AlternatingCodebooksLogitsProcessor.input_start_len",description:`<strong>input_start_len</strong> (<code>int</code>) &#x2014;
The length of the initial input sequence.`,name:"input_start_len"},{anchor:"transformers.AlternatingCodebooksLogitsProcessor.semantic_vocab_size",description:`<strong>semantic_vocab_size</strong> (<code>int</code>) &#x2014;
Vocabulary size of the semantic part, i.e number of tokens associated to the semantic vocabulary.`,name:"semantic_vocab_size"},{anchor:"transformers.AlternatingCodebooksLogitsProcessor.codebook_size",description:`<strong>codebook_size</strong> (<code>int</code>) &#x2014;
Number of tokens associated to the codebook.`,name:"codebook_size"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L2131"}}),js=new vr({props:{warning:!0,$$slots:{default:[MJ]},$$scope:{ctx:j}}}),ca=new M({props:{name:"__call__",anchor:"transformers.AlternatingCodebooksLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L2160"}}),ia=new M({props:{name:"class transformers.ClassifierFreeGuidanceLogitsProcessor",anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor",parameters:[{name:"guidance_scale",val:""}],parametersDescription:[{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.guidance_scale",description:`<strong>guidance_scale</strong> (float) &#x2014;
The guidance scale for classifier free guidance (CFG). CFG is enabled by setting <code>guidance_scale &gt; 1</code>.
Higher guidance scale encourages the model to generate samples that are more closely linked to the input
prompt, usually at the expense of poorer quality.`,name:"guidance_scale"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L2067"}}),xs=new vr({props:{warning:!0,$$slots:{default:[wJ]},$$scope:{ctx:j}}}),Js=new C({props:{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.example",$$slots:{default:[kJ]},$$scope:{ctx:j}}}),da=new M({props:{name:"__call__",anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L2115",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),pa=new M({props:{name:"class transformers.EncoderNoRepeatNGramLogitsProcessor",anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor",parameters:[{name:"encoder_ngram_size",val:": int"},{name:"encoder_input_ids",val:": LongTensor"}],parametersDescription:[{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.encoder_ngram_size",description:`<strong>encoder_ngram_size</strong> (<code>int</code>) &#x2014;
All ngrams of size <code>ngram_size</code> can only occur within the encoder input ids.`,name:"encoder_ngram_size"},{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.encoder_input_ids",description:`<strong>encoder_input_ids</strong> (<code>int</code>) &#x2014;
The encoder_input_ids that should not be repeated within the decoder ids.`,name:"encoder_input_ids"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L981"}}),Us=new C({props:{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.example",$$slots:{default:[$J]},$$scope:{ctx:j}}}),ma=new M({props:{name:"__call__",anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L1030",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),ha=new M({props:{name:"class transformers.EncoderRepetitionPenaltyLogitsProcessor",anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor",parameters:[{name:"penalty",val:": float"},{name:"encoder_input_ids",val:": LongTensor"}],parametersDescription:[{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.penalty",description:`<strong>penalty</strong> (<code>float</code>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. Above 1.0 rewards prompt tokens. Between 0.0
and 1.0 penalizes prompt tokens.`,name:"penalty"},{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.encoder_input_ids",description:`<strong>encoder_input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
The encoder_input_ids that should be repeated within the decoder ids.`,name:"encoder_input_ids"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L362"}}),Zs=new C({props:{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.example",$$slots:{default:[jJ]},$$scope:{ctx:j}}}),ga=new M({props:{name:"__call__",anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L406",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),ua=new M({props:{name:"class transformers.EpsilonLogitsWarper",anchor:"transformers.EpsilonLogitsWarper",parameters:[{name:"epsilon",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.EpsilonLogitsWarper.epsilon",description:`<strong>epsilon</strong> (<code>float</code>) &#x2014;
If set to &gt; 0, only the most tokens with probabilities <code>epsilon</code> or higher are kept for generation.`,name:"epsilon"},{anchor:"transformers.EpsilonLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.EpsilonLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L702"}}),Cs=new C({props:{anchor:"transformers.EpsilonLogitsWarper.example",$$slots:{default:[xJ]},$$scope:{ctx:j}}}),fa=new M({props:{name:"__call__",anchor:"transformers.EpsilonLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EpsilonLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EpsilonLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L757",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),_a=new M({props:{name:"class transformers.EtaLogitsWarper",anchor:"transformers.EtaLogitsWarper",parameters:[{name:"epsilon",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"},{name:"device",val:": str = 'cpu'"}],parametersDescription:[{anchor:"transformers.EtaLogitsWarper.epsilon",description:`<strong>epsilon</strong> (<code>float</code>) &#x2014;
A float value in the range (0, 1). Hyperparameter used to calculate the dynamic cutoff value, <code>eta</code>. The
suggested values from the paper ranges from 3e-4 to 4e-3 depending on the size of the model.`,name:"epsilon"},{anchor:"transformers.EtaLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All values that are found to be below the dynamic cutoff value, <code>eta</code>, are set to this float value. This
parameter is useful when logits need to be modified for very low probability tokens that should be excluded
from generation entirely.`,name:"filter_value"},{anchor:"transformers.EtaLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Specifies the minimum number of tokens that must be kept for generation, regardless of their probabilities.
For example, if <code>min_tokens_to_keep</code> is set to 1, at least one token will always be kept for generation,
even if all tokens have probabilities below the cutoff <code>eta</code>.`,name:"min_tokens_to_keep"},{anchor:"transformers.EtaLogitsWarper.device",description:`<strong>device</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;cpu&quot;</code>) &#x2014;
The device to allocate the tensors.`,name:"device"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L771"}}),Ws=new C({props:{anchor:"transformers.EtaLogitsWarper.example",$$slots:{default:[JJ]},$$scope:{ctx:j}}}),ba=new M({props:{name:"__call__",anchor:"transformers.EtaLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EtaLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EtaLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L840",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),ya=new M({props:{name:"class transformers.ExponentialDecayLengthPenalty",anchor:"transformers.ExponentialDecayLengthPenalty",parameters:[{name:"exponential_decay_length_penalty",val:": Tuple"},{name:"eos_token_id",val:": Union"},{name:"input_ids_seq_length",val:": int"}],parametersDescription:[{anchor:"transformers.ExponentialDecayLengthPenalty.exponential_decay_length_penalty",description:`<strong>exponential_decay_length_penalty</strong> (<code>tuple(int, float)</code>) &#x2014;
This tuple shall consist of: <code>(start_index, decay_factor)</code> where <code>start_index</code> indicates where penalty
starts and <code>decay_factor</code> represents the factor of exponential decay`,name:"exponential_decay_length_penalty"},{anchor:"transformers.ExponentialDecayLengthPenalty.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int], torch.Tensor]</code>) &#x2014;
The id(s) of the <em>end-of-sequence</em> token.`,name:"eos_token_id"},{anchor:"transformers.ExponentialDecayLengthPenalty.input_ids_seq_length",description:`<strong>input_ids_seq_length</strong> (<code>int</code>) &#x2014;
The length of the input sequence.`,name:"input_ids_seq_length"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L1643"}}),Bs=new C({props:{anchor:"transformers.ExponentialDecayLengthPenalty.example",$$slots:{default:[UJ]},$$scope:{ctx:j}}}),Ta=new M({props:{name:"__call__",anchor:"transformers.ExponentialDecayLengthPenalty.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ExponentialDecayLengthPenalty.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ExponentialDecayLengthPenalty.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L1729",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),va=new M({props:{name:"class transformers.ForcedBOSTokenLogitsProcessor",anchor:"transformers.ForcedBOSTokenLogitsProcessor",parameters:[{name:"bos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.ForcedBOSTokenLogitsProcessor.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the first generated token.`,name:"bos_token_id"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L1521"}}),zs=new C({props:{anchor:"transformers.ForcedBOSTokenLogitsProcessor.example",$$slots:{default:[ZJ]},$$scope:{ctx:j}}}),Ma=new M({props:{name:"__call__",anchor:"transformers.ForcedBOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ForcedBOSTokenLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ForcedBOSTokenLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L1556",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),wa=new M({props:{name:"class transformers.ForcedEOSTokenLogitsProcessor",anchor:"transformers.ForcedEOSTokenLogitsProcessor",parameters:[{name:"max_length",val:": int"},{name:"eos_token_id",val:": Union"},{name:"device",val:": str = 'cpu'"}],parametersDescription:[{anchor:"transformers.ForcedEOSTokenLogitsProcessor.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.ForcedEOSTokenLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int], torch.Tensor]</code>) &#x2014;
The id(s) of the <em>end-of-sequence</em> token.`,name:"eos_token_id"},{anchor:"transformers.ForcedEOSTokenLogitsProcessor.device",description:`<strong>device</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;cpu&quot;</code>) &#x2014;
The device to allocate the tensors.`,name:"device"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L1566"}}),Is=new C({props:{anchor:"transformers.ForcedEOSTokenLogitsProcessor.example",$$slots:{default:[CJ]},$$scope:{ctx:j}}}),ka=new M({props:{name:"__call__",anchor:"transformers.ForcedEOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ForcedEOSTokenLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ForcedEOSTokenLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L1612",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),$a=new M({props:{name:"class transformers.HammingDiversityLogitsProcessor",anchor:"transformers.HammingDiversityLogitsProcessor",parameters:[{name:"diversity_penalty",val:": float"},{name:"num_beams",val:": int"},{name:"num_beam_groups",val:": int"}],parametersDescription:[{anchor:"transformers.HammingDiversityLogitsProcessor.diversity_penalty",description:`<strong>diversity_penalty</strong> (<code>float</code>) &#x2014;
This value is subtracted from a beam&#x2019;s score if it generates a token same as any beam from other group at a
particular time. A higher <code>diversity_penalty</code> will enforce greater diversity among the beams. Adjusting
this value can help strike a balance between diversity and natural likelihood.`,name:"diversity_penalty"},{anchor:"transformers.HammingDiversityLogitsProcessor.num_beams",description:`<strong>num_beams</strong> (<code>int</code>) &#x2014;
Number of beams for beam search. 1 means no beam search.`,name:"num_beams"},{anchor:"transformers.HammingDiversityLogitsProcessor.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
<a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L1385"}}),Vs=new C({props:{anchor:"transformers.HammingDiversityLogitsProcessor.example",$$slots:{default:[WJ]},$$scope:{ctx:j}}}),ja=new M({props:{name:"__call__",anchor:"transformers.HammingDiversityLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"current_tokens",val:": LongTensor"},{name:"beam_group_idx",val:": int"}],parametersDescription:[{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using
beam search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.current_tokens",description:`<strong>current_tokens</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary, corresponding to the tokens selected by the other
beam groups in the current generation step.`,name:"current_tokens"},{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.beam_group_idx",description:`<strong>beam_group_idx</strong> (<code>int</code>) &#x2014;
The index of the beam group currently being processed.`,name:"beam_group_idx"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L1472",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),xa=new M({props:{name:"class transformers.InfNanRemoveLogitsProcessor",anchor:"transformers.InfNanRemoveLogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L1622"}}),Ja=new M({props:{name:"__call__",anchor:"transformers.InfNanRemoveLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.InfNanRemoveLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.InfNanRemoveLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L1631",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ua=new M({props:{name:"class transformers.LogitNormalization",anchor:"transformers.LogitNormalization",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L1744"}}),Gs=new C({props:{anchor:"transformers.LogitNormalization.example",$$slots:{default:[BJ]},$$scope:{ctx:j}}}),Za=new M({props:{name:"__call__",anchor:"transformers.LogitNormalization.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.LogitNormalization.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitNormalization.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L1775",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ca=new M({props:{name:"class transformers.LogitsProcessor",anchor:"transformers.LogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L45"}}),Wa=new M({props:{name:"__call__",anchor:"transformers.LogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.LogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L48",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ba=new M({props:{name:"class transformers.LogitsProcessorList",anchor:"transformers.LogitsProcessorList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L71"}}),za=new M({props:{name:"__call__",anchor:"transformers.LogitsProcessorList.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LogitsProcessorList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitsProcessorList.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using
beam search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.LogitsProcessorList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional kwargs that are specific to a logits processor.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L78",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ia=new M({props:{name:"class transformers.MinLengthLogitsProcessor",anchor:"transformers.MinLengthLogitsProcessor",parameters:[{name:"min_length",val:": int"},{name:"eos_token_id",val:": Union"},{name:"device",val:": str = 'cpu'"}],parametersDescription:[{anchor:"transformers.MinLengthLogitsProcessor.min_length",description:`<strong>min_length</strong> (<code>int</code>) &#x2014;
The minimum length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_length"},{anchor:"transformers.MinLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int], torch.Tensor]</code>) &#x2014;
The id(s) of the <em>end-of-sequence</em> token.`,name:"eos_token_id"},{anchor:"transformers.MinLengthLogitsProcessor.device",description:`<strong>device</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;cpu&quot;</code>) &#x2014;
The device to allocate the tensors.`,name:"device"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L109"}}),Fs=new C({props:{anchor:"transformers.MinLengthLogitsProcessor.example",$$slots:{default:[zJ]},$$scope:{ctx:j}}}),Va=new M({props:{name:"__call__",anchor:"transformers.MinLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.MinLengthLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MinLengthLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L160",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ga=new M({props:{name:"class transformers.MinNewTokensLengthLogitsProcessor",anchor:"transformers.MinNewTokensLengthLogitsProcessor",parameters:[{name:"prompt_length_to_skip",val:": int"},{name:"min_new_tokens",val:": int"},{name:"eos_token_id",val:": Union"},{name:"device",val:": str = 'cpu'"}],parametersDescription:[{anchor:"transformers.MinNewTokensLengthLogitsProcessor.prompt_length_to_skip",description:`<strong>prompt_length_to_skip</strong> (<code>int</code>) &#x2014;
The input tokens length. Not a valid argument when used with <code>generate</code> as it will automatically assign the
input length.`,name:"prompt_length_to_skip"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.min_new_tokens",description:`<strong>min_new_tokens</strong> (<code>int</code>) &#x2014;
The minimum <em>new</em> tokens length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_new_tokens"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int], torch.Tensor]</code>) &#x2014;
The id(s) of the <em>end-of-sequence</em> token.`,name:"eos_token_id"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.device",description:`<strong>device</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;cpu&quot;</code>) &#x2014;
The device to allocate the tensors.`,name:"device"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L170"}}),Xs=new C({props:{anchor:"transformers.MinNewTokensLengthLogitsProcessor.example",$$slots:{default:[IJ]},$$scope:{ctx:j}}}),Fa=new M({props:{name:"__call__",anchor:"transformers.MinNewTokensLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.MinNewTokensLengthLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L230",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Xa=new M({props:{name:"class transformers.MinPLogitsWarper",anchor:"transformers.MinPLogitsWarper",parameters:[{name:"min_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.MinPLogitsWarper.min_p",description:`<strong>min_p</strong> (<code>float</code>) &#x2014;
Minimum token probability, which will be scaled by the probability of the most likely token. It must be a
value between 0 and 1. Typical values are in the 0.01-0.2 range, comparably selective as setting <code>top_p</code> in
the 0.99-0.8 range (use the opposite of normal <code>top_p</code> values).`,name:"min_p"},{anchor:"transformers.MinPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.MinPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L537"}}),Ls=new C({props:{anchor:"transformers.MinPLogitsWarper.example",$$slots:{default:[VJ]},$$scope:{ctx:j}}}),La=new M({props:{name:"__call__",anchor:"transformers.MinPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L594"}}),Ra=new M({props:{name:"class transformers.NoBadWordsLogitsProcessor",anchor:"transformers.NoBadWordsLogitsProcessor",parameters:[{name:"bad_words_ids",val:": List"},{name:"eos_token_id",val:": Union = None"}],parametersDescription:[{anchor:"transformers.NoBadWordsLogitsProcessor.bad_words_ids",description:`<strong>bad_words_ids</strong> (<code>List[List[int]]</code>) &#x2014;
List of list of token ids that are not allowed to be generated.`,name:"bad_words_ids"},{anchor:"transformers.NoBadWordsLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int], torch.Tensor]</code>, <em>optional</em>) &#x2014;
The id(s) of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L1225"}}),Rs=new vr({props:{$$slots:{default:[GJ]},$$scope:{ctx:j}}}),Ss=new C({props:{anchor:"transformers.NoBadWordsLogitsProcessor.example",$$slots:{default:[FJ]},$$scope:{ctx:j}}}),Sa=new M({props:{name:"__call__",anchor:"transformers.NoBadWordsLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.NoBadWordsLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.NoBadWordsLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L1123",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Na=new M({props:{name:"class transformers.NoRepeatNGramLogitsProcessor",anchor:"transformers.NoRepeatNGramLogitsProcessor",parameters:[{name:"ngram_size",val:": int"}],parametersDescription:[{anchor:"transformers.NoRepeatNGramLogitsProcessor.ngram_size",description:`<strong>ngram_size</strong> (<code>int</code>) &#x2014;
All ngrams of size <code>ngram_size</code> can only occur once.`,name:"ngram_size"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L922"}}),Ns=new vr({props:{$$slots:{default:[XJ]},$$scope:{ctx:j}}}),Hs=new C({props:{anchor:"transformers.NoRepeatNGramLogitsProcessor.example",$$slots:{default:[LJ]},$$scope:{ctx:j}}}),Ha=new M({props:{name:"__call__",anchor:"transformers.NoRepeatNGramLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.NoRepeatNGramLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.NoRepeatNGramLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L969",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ea=new M({props:{name:"class transformers.PrefixConstrainedLogitsProcessor",anchor:"transformers.PrefixConstrainedLogitsProcessor",parameters:[{name:"prefix_allowed_tokens_fn",val:": Callable"},{name:"num_beams",val:": int"}],parametersDescription:[{anchor:"transformers.PrefixConstrainedLogitsProcessor.prefix_allowed_tokens_fn",description:`<strong>prefix_allowed_tokens_fn</strong> (<code>Callable[[int, torch.Tensor], List[int]]</code>) &#x2014;
This function constraints the beam search to allowed tokens only at each step. This function takes 2
arguments <code>inputs_ids</code> and the batch ID <code>batch_id</code>. It has to return a list with the allowed tokens for the
next generation step conditioned on the previously generated tokens <code>inputs_ids</code> and the batch ID
<code>batch_id</code>.`,name:"prefix_allowed_tokens_fn"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L1316"}}),Es=new C({props:{anchor:"transformers.PrefixConstrainedLogitsProcessor.example",$$slots:{default:[RJ]},$$scope:{ctx:j}}}),qa=new M({props:{name:"__call__",anchor:"transformers.PrefixConstrainedLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.PrefixConstrainedLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.PrefixConstrainedLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L1367",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Qa=new M({props:{name:"class transformers.RepetitionPenaltyLogitsProcessor",anchor:"transformers.RepetitionPenaltyLogitsProcessor",parameters:[{name:"penalty",val:": float"}],parametersDescription:[{anchor:"transformers.RepetitionPenaltyLogitsProcessor.penalty",description:`<strong>penalty</strong> (<code>float</code>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. Above 1.0 penalizes previously generated
tokens. Between 0.0 and 1.0 rewards previously generated tokens.`,name:"penalty"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L308"}}),qs=new C({props:{anchor:"transformers.RepetitionPenaltyLogitsProcessor.example",$$slots:{default:[SJ]},$$scope:{ctx:j}}}),Da=new M({props:{name:"__call__",anchor:"transformers.RepetitionPenaltyLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.RepetitionPenaltyLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.RepetitionPenaltyLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L351",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ya=new M({props:{name:"class transformers.SequenceBiasLogitsProcessor",anchor:"transformers.SequenceBiasLogitsProcessor",parameters:[{name:"sequence_bias",val:": List"}],parametersDescription:[{anchor:"transformers.SequenceBiasLogitsProcessor.sequence_bias",description:`<strong>sequence_bias</strong> (<code>List[List[Union[List[int], float]]]</code>) &#x2014;
List of lists that maps a sequence of tokens to its bias term (e.g. <code>[[[10, 45], -2.0], [[64], -7.5]]</code>). Positive biases increase the odds of the
sequence being selected, while negative biases do the opposite. If a sequence has a length of 1, its bias
will always be applied. Otherwise, the bias will only be applied if the sequence in question is about to be
completed (in the token selection step after this processor is applied).`,name:"sequence_bias"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L1050"}}),Qs=new vr({props:{$$slots:{default:[NJ]},$$scope:{ctx:j}}}),Ds=new C({props:{anchor:"transformers.SequenceBiasLogitsProcessor.example",$$slots:{default:[HJ]},$$scope:{ctx:j}}}),Pa=new M({props:{name:"__call__",anchor:"transformers.SequenceBiasLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SequenceBiasLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SequenceBiasLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L1123",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Aa=new M({props:{name:"class transformers.SuppressTokensAtBeginLogitsProcessor",anchor:"transformers.SuppressTokensAtBeginLogitsProcessor",parameters:[{name:"begin_suppress_tokens",val:""},{name:"begin_index",val:""},{name:"device",val:": str = 'cpu'"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L1781"}}),Ys=new C({props:{anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.example",$$slots:{default:[EJ]},$$scope:{ctx:j}}}),Oa=new M({props:{name:"__call__",anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L1823",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ka=new M({props:{name:"class transformers.SuppressTokensLogitsProcessor",anchor:"transformers.SuppressTokensLogitsProcessor",parameters:[{name:"suppress_tokens",val:""},{name:"device",val:": str = 'cpu'"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L1834"}}),Ps=new C({props:{anchor:"transformers.SuppressTokensLogitsProcessor.example",$$slots:{default:[qJ]},$$scope:{ctx:j}}}),eo=new M({props:{name:"__call__",anchor:"transformers.SuppressTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SuppressTokensLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SuppressTokensLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L1866",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),to=new M({props:{name:"class transformers.TemperatureLogitsWarper",anchor:"transformers.TemperatureLogitsWarper",parameters:[{name:"temperature",val:": float"}],parametersDescription:[{anchor:"transformers.TemperatureLogitsWarper.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
Strictly positive float value used to modulate the logits distribution. A value smaller than <code>1</code> decreases
randomness (and vice versa), with <code>0</code> being equivalent to shifting all probability mass to the most likely
token.`,name:"temperature"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L242"}}),As=new vr({props:{$$slots:{default:[QJ]},$$scope:{ctx:j}}}),Os=new C({props:{anchor:"transformers.TemperatureLogitsWarper.example",$$slots:{default:[DJ]},$$scope:{ctx:j}}}),so=new M({props:{name:"__call__",anchor:"transformers.TemperatureLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TemperatureLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TemperatureLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L302",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),no=new M({props:{name:"class transformers.TopKLogitsWarper",anchor:"transformers.TopKLogitsWarper",parameters:[{name:"top_k",val:": int"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TopKLogitsWarper.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.TopKLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TopKLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L484"}}),Ks=new C({props:{anchor:"transformers.TopKLogitsWarper.example",$$slots:{default:[YJ]},$$scope:{ctx:j}}}),ro=new M({props:{name:"__call__",anchor:"transformers.TopKLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TopKLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TopKLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L528",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),ao=new M({props:{name:"class transformers.TopPLogitsWarper",anchor:"transformers.TopPLogitsWarper",parameters:[{name:"top_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TopPLogitsWarper.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"transformers.TopPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TopPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L417"}}),en=new C({props:{anchor:"transformers.TopPLogitsWarper.example",$$slots:{default:[PJ]},$$scope:{ctx:j}}}),oo=new M({props:{name:"__call__",anchor:"transformers.TopPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TopPLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TopPLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L468",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),lo=new M({props:{name:"class transformers.TypicalLogitsWarper",anchor:"transformers.TypicalLogitsWarper",parameters:[{name:"mass",val:": float = 0.9"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TypicalLogitsWarper.mass",description:`<strong>mass</strong> (<code>float</code>, <em>optional</em>, defaults to 0.9) &#x2014;
Value of typical_p between 0 and 1 inclusive, defaults to 0.9.`,name:"mass"},{anchor:"transformers.TypicalLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TypicalLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L614"}}),tn=new C({props:{anchor:"transformers.TypicalLogitsWarper.example",$$slots:{default:[AJ]},$$scope:{ctx:j}}}),co=new M({props:{name:"__call__",anchor:"transformers.TypicalLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TypicalLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TypicalLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L678",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),io=new M({props:{name:"class transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor",anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor",parameters:[{name:"guidance_scale",val:": float"},{name:"model",val:""},{name:"unconditional_ids",val:": Optional = None"},{name:"unconditional_attention_mask",val:": Optional = None"},{name:"use_cache",val:": Optional = True"}],parametersDescription:[{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>) &#x2014;
The guidance scale for classifier free guidance (CFG). CFG is enabled by setting <code>guidance_scale != 1</code>.
Higher guidance scale encourages the model to generate samples that are more closely linked to the input
prompt, usually at the expense of poorer quality. A value smaller than 1 has the opposite effect, while
making the negative prompt provided with negative_prompt_ids (if any) act as a positive prompt.`,name:"guidance_scale"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.model",description:`<strong>model</strong> (<code>PreTrainedModel</code>) &#x2014;
The model computing the unconditional scores. Supposedly the same as the one computing the conditional
scores. Both models must use the same tokenizer.`,name:"model"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.unconditional_ids",description:`<strong>unconditional_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary for the unconditional branch. If unset, will default to
the last token of the prompt.`,name:"unconditional_ids"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.unconditional_attention_mask",description:`<strong>unconditional_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Attention mask for unconditional_ids.`,name:"unconditional_attention_mask"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to cache key/values during the negative prompt forward pass.`,name:"use_cache"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L2176"}}),sn=new C({props:{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.example",$$slots:{default:[OJ]},$$scope:{ctx:j}}}),po=new M({props:{name:"__call__",anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.__call__",parameters:[{name:"input_ids",val:""},{name:"scores",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L2282"}}),mo=new M({props:{name:"class transformers.WhisperTimeStampLogitsProcessor",anchor:"transformers.WhisperTimeStampLogitsProcessor",parameters:[{name:"generate_config",val:""},{name:"begin_index",val:": Optional = None"},{name:"_detect_timestamp_from_logprob",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.WhisperTimeStampLogitsProcessor.generate_config",description:`<strong>generate_config</strong> (<code>GenerateConfig</code>) &#x2014;
The generate config used to generate the output. The following parameters are required:
eos_token_id (<code>int</code>, <em>optional</em>, defaults to 50257):
The id of the <em>end-of-sequence</em> token.
no_timestamps_token_id (<code>int</code>, <em>optional</em>, defaults to 50363):
The id of the <code>&quot;&lt;|notimestamps|&gt;&quot;</code> token.
max_initial_timestamp_index (<code>int</code>, <em>optional</em>, defaults to 1):
Used to set the maximum value of the initial timestamp. This is used to prevent the model from
predicting timestamps that are too far in the future.`,name:"generate_config"},{anchor:"transformers.WhisperTimeStampLogitsProcessor.begin_index",description:"<strong>begin_index</strong> (<code>Optional</code>, <em>optional</em>) &#x2014; Token index of the first token that is generated by the model.",name:"begin_index"},{anchor:"transformers.WhisperTimeStampLogitsProcessor._detect_timestamp_from_logprob",description:"<strong>_detect_timestamp_from_logprob</strong> (<code>bool</code>, <em>optional</em>) &#x2014; Whether timestamps can be predicted from logprobs over all timestamps.",name:"_detect_timestamp_from_logprob"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L1874"}}),nn=new C({props:{anchor:"transformers.WhisperTimeStampLogitsProcessor.example",$$slots:{default:[KJ]},$$scope:{ctx:j}}}),ho=new M({props:{name:"__call__",anchor:"transformers.WhisperTimeStampLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.WhisperTimeStampLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.WhisperTimeStampLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L1959",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),go=new M({props:{name:"class transformers.WatermarkLogitsProcessor",anchor:"transformers.WatermarkLogitsProcessor",parameters:[{name:"vocab_size",val:""},{name:"device",val:""},{name:"greenlist_ratio",val:": float = 0.25"},{name:"bias",val:": float = 2.0"},{name:"hashing_key",val:": int = 15485863"},{name:"seeding_scheme",val:": str = 'lefthash'"},{name:"context_width",val:": int = 1"}],parametersDescription:[{anchor:"transformers.WatermarkLogitsProcessor.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>) &#x2014;
The model tokenizer&#x2019;s vocab_size. Used to calculate &#x201C;green&#x201D; tokens ratio.`,name:"vocab_size"},{anchor:"transformers.WatermarkLogitsProcessor.device",description:`<strong>device</strong> (<code>str</code>) &#x2014;
The device where model is allocated.`,name:"device"},{anchor:"transformers.WatermarkLogitsProcessor.greenlist_ratio",description:`<strong>greenlist_ratio</strong> (<code>float</code>, optional, <em>optional</em>, defaults to 0.25) &#x2014;
The ratio of &#x201C;green&#x201D; tokens used to the vocabulary size. Defaults to 0.25.`,name:"greenlist_ratio"},{anchor:"transformers.WatermarkLogitsProcessor.bias",description:`<strong>bias</strong> (<code>float</code>, optional, <em>optional</em>, defaults to 2.0) &#x2014;
The bias added to the selected &#x201C;green&#x201D; tokens&#x2019; logits. Consider lowering the
<code>bias</code> if the text generation quality degrades. Recommended values are in the
range of [0.5, 2.0]. Defaults to 2.0.`,name:"bias"},{anchor:"transformers.WatermarkLogitsProcessor.hashing_key",description:`<strong>hashing_key</strong> (<code>int</code>, optional, <em>optional</em>, defaults to 15485863) &#x2014;
Key used for hashing. If you deploy this watermark, we advise using another private key.
Defaults to 15485863 (the millionth prime).`,name:"hashing_key"},{anchor:"transformers.WatermarkLogitsProcessor.seeding_scheme",description:`<strong>seeding_scheme</strong> (<code>str</code>, optional, <em>optional</em>, defaults to <code>&quot;lefthash&quot;</code>) &#x2014;
The seeding scheme used for selecting &#x201C;green&#x201D; tokens. Accepts values:<ul>
<li>&#x201C;lefthash&#x201D; (default): &#x201C;green&#x201D; tokens selection depend on the last token (Algorithm 2 from paper)</li>
<li>&#x201C;selfhash&#x201D;: &#x201C;green&#x201D; tokens selection depends on the current token itself (Algorithm 3 from paper)
The downside of this scheme is that it considers all possible next tokens and can be slower than &#x201C;lefthash&#x201D;.
The context length of previous tokens to use in seeding. Higher context length makes watermarking more robust.</li>
</ul>`,name:"seeding_scheme"},{anchor:"transformers.WatermarkLogitsProcessor.context_width",description:`<strong>context_width</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of previous tokens to use when setting the seed.`,name:"context_width"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L2341"}}),rn=new C({props:{anchor:"transformers.WatermarkLogitsProcessor.example",$$slots:{default:[eU]},$$scope:{ctx:j}}}),uo=new M({props:{name:"__call__",anchor:"transformers.WatermarkLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/logits_process.py#L2463"}}),fo=new ge({props:{title:"TensorFlow",local:"transformers.TFForcedBOSTokenLogitsProcessor",headingTag:"h3"}}),_o=new M({props:{name:"class transformers.TFForcedBOSTokenLogitsProcessor",anchor:"transformers.TFForcedBOSTokenLogitsProcessor",parameters:[{name:"bos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFForcedBOSTokenLogitsProcessor.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the first generated token.`,name:"bos_token_id"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/tf_logits_process.py#L448"}}),bo=new M({props:{name:"__call__",anchor:"transformers.TFForcedBOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/tf_logits_process.py#L462"}}),yo=new M({props:{name:"class transformers.TFForcedEOSTokenLogitsProcessor",anchor:"transformers.TFForcedEOSTokenLogitsProcessor",parameters:[{name:"max_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFForcedEOSTokenLogitsProcessor.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.TFForcedEOSTokenLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/tf_logits_process.py#L478"}}),To=new M({props:{name:"__call__",anchor:"transformers.TFForcedEOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/tf_logits_process.py#L495"}}),vo=new M({props:{name:"class transformers.TFForceTokensLogitsProcessor",anchor:"transformers.TFForceTokensLogitsProcessor",parameters:[{name:"force_token_map",val:": List"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/tf_logits_process.py#L563"}}),Mo=new M({props:{name:"__call__",anchor:"transformers.TFForceTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/tf_logits_process.py#L579"}}),wo=new M({props:{name:"class transformers.TFLogitsProcessor",anchor:"transformers.TFLogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/tf_logits_process.py#L53"}}),ko=new M({props:{name:"__call__",anchor:"transformers.TFLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],parametersDescription:[{anchor:"transformers.TFLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30950/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/pr_30950/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30950/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search.`,name:"scores"},{anchor:"transformers.TFLogitsProcessor.__call__.cur_len",description:`<strong>cur_len</strong> (<code>int</code>) &#x2014;
The current length of valid input sequence tokens. In the TF implementation, the input_ids&#x2019; sequence length
is the maximum length generate can produce, and we need to know which of its tokens are valid.`,name:"cur_len"},{anchor:"transformers.TFLogitsProcessor.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/tf_logits_process.py#L56",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),$o=new M({props:{name:"class transformers.TFLogitsProcessorList",anchor:"transformers.TFLogitsProcessorList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/tf_logits_process.py#L75"}}),jo=new M({props:{name:"__call__",anchor:"transformers.TFLogitsProcessorList.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFLogitsProcessorList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30950/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/pr_30950/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30950/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFLogitsProcessorList.__call__.scores",description:`<strong>scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search.`,name:"scores"},{anchor:"transformers.TFLogitsProcessorList.__call__.cur_len",description:`<strong>cur_len</strong> (<code>int</code>) &#x2014;
The current length of valid input sequence tokens. In the TF implementation, the input_ids&#x2019; sequence length
is the maximum length generate can produce, and we need to know which of its tokens are valid.`,name:"cur_len"},{anchor:"transformers.TFLogitsProcessorList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/tf_logits_process.py#L82",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),xo=new M({props:{name:"class transformers.TFLogitsWarper",anchor:"transformers.TFLogitsWarper",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/tf_logits_process.py#L64"}}),Jo=new M({props:{name:"__call__",anchor:"transformers.TFLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],parametersDescription:[{anchor:"transformers.TFLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30950/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/pr_30950/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30950/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search.`,name:"scores"},{anchor:"transformers.TFLogitsWarper.__call__.cur_len",description:`<strong>cur_len</strong> (<code>int</code>) &#x2014;
The current length of valid input sequence tokens. In the TF implementation, the input_ids&#x2019; sequence length
is the maximum length generate can produce, and we need to know which of its tokens are valid.`,name:"cur_len"},{anchor:"transformers.TFLogitsWarper.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/tf_logits_process.py#L67",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Uo=new M({props:{name:"class transformers.TFMinLengthLogitsProcessor",anchor:"transformers.TFMinLengthLogitsProcessor",parameters:[{name:"min_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFMinLengthLogitsProcessor.min_length",description:`<strong>min_length</strong> (<code>int</code>) &#x2014;
The minimum length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_length"},{anchor:"transformers.TFMinLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/tf_logits_process.py#L202"}}),Zo=new M({props:{name:"__call__",anchor:"transformers.TFMinLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/tf_logits_process.py#L228"}}),Co=new M({props:{name:"class transformers.TFNoBadWordsLogitsProcessor",anchor:"transformers.TFNoBadWordsLogitsProcessor",parameters:[{name:"bad_words_ids",val:": List"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFNoBadWordsLogitsProcessor.bad_words_ids",description:`<strong>bad_words_ids</strong> (<code>List[List[int]]</code>) &#x2014;
List of list of token ids that are not allowed to be generated. In order to get the tokens of the words
that should not appear in the generated text, make sure to set <code>add_prefix_space=True</code> when initializing
the tokenizer, and use <code>tokenizer(bad_words, add_special_tokens=False).input_ids</code>. The <code>add_prefix_space</code>
argument is only supported for some slow tokenizers, as fast tokenizers&#x2019; prefixing behaviours come from
<code>pre tokenizers</code>. Read more <a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">here</a>.`,name:"bad_words_ids"},{anchor:"transformers.TFNoBadWordsLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/tf_logits_process.py#L288"}}),Wo=new M({props:{name:"__call__",anchor:"transformers.TFNoBadWordsLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/tf_logits_process.py#L367"}}),Bo=new M({props:{name:"class transformers.TFNoRepeatNGramLogitsProcessor",anchor:"transformers.TFNoRepeatNGramLogitsProcessor",parameters:[{name:"ngram_size",val:": int"}],parametersDescription:[{anchor:"transformers.TFNoRepeatNGramLogitsProcessor.ngram_size",description:`<strong>ngram_size</strong> (<code>int</code>) &#x2014;
All ngrams of size <code>ngram_size</code> can only occur once.`,name:"ngram_size"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/tf_logits_process.py#L388"}}),zo=new M({props:{name:"__call__",anchor:"transformers.TFNoRepeatNGramLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/tf_logits_process.py#L427"}}),Io=new M({props:{name:"class transformers.TFRepetitionPenaltyLogitsProcessor",anchor:"transformers.TFRepetitionPenaltyLogitsProcessor",parameters:[{name:"penalty",val:": float"}],parametersDescription:[{anchor:"transformers.TFRepetitionPenaltyLogitsProcessor.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">this
paper</a> for more details.`,name:"repetition_penalty"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/tf_logits_process.py#L238"}}),Vo=new M({props:{name:"__call__",anchor:"transformers.TFRepetitionPenaltyLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/tf_logits_process.py#L280"}}),Go=new M({props:{name:"class transformers.TFSuppressTokensAtBeginLogitsProcessor",anchor:"transformers.TFSuppressTokensAtBeginLogitsProcessor",parameters:[{name:"begin_suppress_tokens",val:""},{name:"begin_index",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/tf_logits_process.py#L511"}}),Fo=new M({props:{name:"__call__",anchor:"transformers.TFSuppressTokensAtBeginLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/tf_logits_process.py#L522"}}),Xo=new M({props:{name:"class transformers.TFSuppressTokensLogitsProcessor",anchor:"transformers.TFSuppressTokensLogitsProcessor",parameters:[{name:"suppress_tokens",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/tf_logits_process.py#L541"}}),Lo=new M({props:{name:"__call__",anchor:"transformers.TFSuppressTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/tf_logits_process.py#L548"}}),Ro=new M({props:{name:"class transformers.TFTemperatureLogitsWarper",anchor:"transformers.TFTemperatureLogitsWarper",parameters:[{name:"temperature",val:": float"}],parametersDescription:[{anchor:"transformers.TFTemperatureLogitsWarper.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
The value used to module the logits distribution.`,name:"temperature"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/tf_logits_process.py#L98"}}),So=new M({props:{name:"__call__",anchor:"transformers.TFTemperatureLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/tf_logits_process.py#L113"}}),No=new M({props:{name:"class transformers.TFTopKLogitsWarper",anchor:"transformers.TFTopKLogitsWarper",parameters:[{name:"top_k",val:": int"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TFTopKLogitsWarper.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.TFTopKLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TFTopKLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/tf_logits_process.py#L118"}}),Ho=new M({props:{name:"__call__",anchor:"transformers.TFTopKLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/tf_logits_process.py#L138"}}),Eo=new M({props:{name:"class transformers.TFTopPLogitsWarper",anchor:"transformers.TFTopPLogitsWarper",parameters:[{name:"top_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TFTopPLogitsWarper.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"transformers.TFTopPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TFTopPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/tf_logits_process.py#L146"}}),qo=new M({props:{name:"__call__",anchor:"transformers.TFTopPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/tf_logits_process.py#L170"}}),Qo=new ge({props:{title:"FLAX",local:"transformers.FlaxForcedBOSTokenLogitsProcessor",headingTag:"h3"}}),Do=new M({props:{name:"class transformers.FlaxForcedBOSTokenLogitsProcessor",anchor:"transformers.FlaxForcedBOSTokenLogitsProcessor",parameters:[{name:"bos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.FlaxForcedBOSTokenLogitsProcessor.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the first generated token.`,name:"bos_token_id"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/flax_logits_process.py#L195"}}),Yo=new M({props:{name:"__call__",anchor:"transformers.FlaxForcedBOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/flax_logits_process.py#L207"}}),Po=new M({props:{name:"class transformers.FlaxForcedEOSTokenLogitsProcessor",anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor",parameters:[{name:"max_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/flax_logits_process.py#L217"}}),Ao=new M({props:{name:"__call__",anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/flax_logits_process.py#L232"}}),Oo=new M({props:{name:"class transformers.FlaxForceTokensLogitsProcessor",anchor:"transformers.FlaxForceTokensLogitsProcessor",parameters:[{name:"force_token_map",val:""}],parametersDescription:[{anchor:"transformers.FlaxForceTokensLogitsProcessor.force_token_map",description:`<strong>force_token_map</strong> (<code>list</code>) &#x2014;
Map giving token ids and indices where they will be forced to be sampled.`,name:"force_token_map"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/flax_logits_process.py#L316"}}),Ko=new M({props:{name:"__call__",anchor:"transformers.FlaxForceTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/flax_logits_process.py#L338"}}),el=new M({props:{name:"class transformers.FlaxLogitsProcessor",anchor:"transformers.FlaxLogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/flax_logits_process.py#L51"}}),tl=new M({props:{name:"__call__",anchor:"transformers.FlaxLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"}],parametersDescription:[{anchor:"transformers.FlaxLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30950/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/pr_30950/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30950/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.FlaxLogitsProcessor.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/flax_logits_process.py#L54",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),sl=new M({props:{name:"class transformers.FlaxLogitsProcessorList",anchor:"transformers.FlaxLogitsProcessorList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/flax_logits_process.py#L73"}}),nl=new M({props:{name:"__call__",anchor:"transformers.FlaxLogitsProcessorList.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxLogitsProcessorList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30950/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/pr_30950/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30950/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxLogitsProcessorList.__call__.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.FlaxLogitsProcessorList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/flax_logits_process.py#L80",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),rl=new M({props:{name:"class transformers.FlaxLogitsWarper",anchor:"transformers.FlaxLogitsWarper",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/flax_logits_process.py#L62"}}),al=new M({props:{name:"__call__",anchor:"transformers.FlaxLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"}],parametersDescription:[{anchor:"transformers.FlaxLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30950/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/pr_30950/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30950/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.FlaxLogitsWarper.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/flax_logits_process.py#L65",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),ol=new M({props:{name:"class transformers.FlaxMinLengthLogitsProcessor",anchor:"transformers.FlaxMinLengthLogitsProcessor",parameters:[{name:"min_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.FlaxMinLengthLogitsProcessor.min_length",description:`<strong>min_length</strong> (<code>int</code>) &#x2014;
The minimum length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_length"},{anchor:"transformers.FlaxMinLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/flax_logits_process.py#L242"}}),ll=new M({props:{name:"__call__",anchor:"transformers.FlaxMinLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/flax_logits_process.py#L263"}}),cl=new M({props:{name:"class transformers.FlaxSuppressTokensAtBeginLogitsProcessor",anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor",parameters:[{name:"begin_suppress_tokens",val:""},{name:"begin_index",val:""}],parametersDescription:[{anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor.begin_suppress_tokens",description:`<strong>begin_suppress_tokens</strong> (<code>List[int]</code>) &#x2014;
Tokens to not sample.`,name:"begin_suppress_tokens"},{anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor.begin_index",description:`<strong>begin_index</strong> (<code>int</code>) &#x2014;
Index where the tokens are suppressed.`,name:"begin_index"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/flax_logits_process.py#L272"}}),il=new M({props:{name:"__call__",anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor.__call__",parameters:[{name:"input_ids",val:""},{name:"scores",val:""},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/flax_logits_process.py#L289"}}),dl=new M({props:{name:"class transformers.FlaxSuppressTokensLogitsProcessor",anchor:"transformers.FlaxSuppressTokensLogitsProcessor",parameters:[{name:"suppress_tokens",val:": list"}],parametersDescription:[{anchor:"transformers.FlaxSuppressTokensLogitsProcessor.suppress_tokens",description:`<strong>suppress_tokens</strong> (<code>list</code>) &#x2014;
Tokens to not sample.`,name:"suppress_tokens"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/flax_logits_process.py#L297"}}),pl=new M({props:{name:"__call__",anchor:"transformers.FlaxSuppressTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/flax_logits_process.py#L310"}}),ml=new M({props:{name:"class transformers.FlaxTemperatureLogitsWarper",anchor:"transformers.FlaxTemperatureLogitsWarper",parameters:[{name:"temperature",val:": float"}],parametersDescription:[{anchor:"transformers.FlaxTemperatureLogitsWarper.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
The value used to module the logits distribution.`,name:"temperature"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/flax_logits_process.py#L96"}}),hl=new M({props:{name:"__call__",anchor:"transformers.FlaxTemperatureLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/flax_logits_process.py#L111"}}),gl=new M({props:{name:"class transformers.FlaxTopKLogitsWarper",anchor:"transformers.FlaxTopKLogitsWarper",parameters:[{name:"top_k",val:": int"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.FlaxTopKLogitsWarper.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.FlaxTopKLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.FlaxTopKLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/flax_logits_process.py#L160"}}),ul=new M({props:{name:"__call__",anchor:"transformers.FlaxTopKLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/flax_logits_process.py#L180"}}),fl=new M({props:{name:"class transformers.FlaxTopPLogitsWarper",anchor:"transformers.FlaxTopPLogitsWarper",parameters:[{name:"top_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.FlaxTopPLogitsWarper.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"transformers.FlaxTopPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.FlaxTopPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/flax_logits_process.py#L116"}}),_l=new M({props:{name:"__call__",anchor:"transformers.FlaxTopPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/flax_logits_process.py#L140"}}),bl=new M({props:{name:"class transformers.FlaxWhisperTimeStampLogitsProcessor",anchor:"transformers.FlaxWhisperTimeStampLogitsProcessor",parameters:[{name:"generate_config",val:""},{name:"model_config",val:""},{name:"decoder_input_length",val:""}],parametersDescription:[{anchor:"transformers.FlaxWhisperTimeStampLogitsProcessor.generate_config",description:`<strong>generate_config</strong> (<code>GenerateConfig</code>) &#x2014;
The generate config used to generate the output. The following parameters are required:
eos_token_id (<code>int</code>, <em>optional</em>, defaults to 50257):
The id of the <em>end-of-sequence</em> token.
no_timestamps_token_id (<code>int</code>, <em>optional</em>, defaults to 50363):
The id of the <code>&quot;&lt;|notimestamps|&gt;&quot;</code> token.
max_initial_timestamp_index (<code>int</code>, <em>optional</em>, defaults to 1):
Used to set the maximum value of the initial timestamp. This is used to prevent the model from
predicting timestamps that are too far in the future.`,name:"generate_config"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/flax_logits_process.py#L364"}}),yl=new M({props:{name:"__call__",anchor:"transformers.FlaxWhisperTimeStampLogitsProcessor.__call__",parameters:[{name:"input_ids",val:""},{name:"scores",val:""},{name:"cur_len",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/flax_logits_process.py#L398"}}),Tl=new ge({props:{title:"StoppingCriteria",local:"transformers.StoppingCriteria",headingTag:"h2"}}),Ml=new M({props:{name:"class transformers.StoppingCriteria",anchor:"transformers.StoppingCriteria",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/stopping_criteria.py#L46"}}),wl=new M({props:{name:"__call__",anchor:"transformers.StoppingCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.StoppingCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30950/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30950/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30950/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.StoppingCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.StoppingCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/stopping_criteria.py#L53",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),kl=new M({props:{name:"class transformers.StoppingCriteriaList",anchor:"transformers.StoppingCriteriaList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/stopping_criteria.py#L491"}}),$l=new M({props:{name:"__call__",anchor:"transformers.StoppingCriteriaList.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.StoppingCriteriaList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30950/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30950/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30950/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.StoppingCriteriaList.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.StoppingCriteriaList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/stopping_criteria.py#L492",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),jl=new M({props:{name:"class transformers.MaxLengthCriteria",anchor:"transformers.MaxLengthCriteria",parameters:[{name:"max_length",val:": int"},{name:"max_position_embeddings",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MaxLengthCriteria.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length that the output sequence can have in number of tokens.`,name:"max_length"},{anchor:"transformers.MaxLengthCriteria.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum model length, as defined by the model&#x2019;s <code>config.max_position_embeddings</code> attribute.`,name:"max_position_embeddings"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/stopping_criteria.py#L58"}}),xl=new M({props:{name:"__call__",anchor:"transformers.MaxLengthCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MaxLengthCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30950/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30950/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30950/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MaxLengthCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.MaxLengthCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/stopping_criteria.py#L74",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),Jl=new M({props:{name:"class transformers.MaxTimeCriteria",anchor:"transformers.MaxTimeCriteria",parameters:[{name:"max_time",val:": float"},{name:"initial_timestamp",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MaxTimeCriteria.max_time",description:`<strong>max_time</strong> (<code>float</code>) &#x2014;
The maximum allowed time in seconds for the generation.`,name:"max_time"},{anchor:"transformers.MaxTimeCriteria.initial_time",description:`<strong>initial_time</strong> (<code>float</code>, <em>optional</em>, defaults to <code>time.time()</code>) &#x2014;
The start of the generation allowed time.`,name:"initial_time"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/stopping_criteria.py#L87"}}),Ul=new M({props:{name:"__call__",anchor:"transformers.MaxTimeCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MaxTimeCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30950/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30950/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30950/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MaxTimeCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.MaxTimeCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/stopping_criteria.py#L104",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),Zl=new M({props:{name:"class transformers.StopStringCriteria",anchor:"transformers.StopStringCriteria",parameters:[{name:"tokenizer",val:": PreTrainedTokenizerBase"},{name:"stop_strings",val:": Union"}],parametersDescription:[{anchor:"transformers.StopStringCriteria.tokenizer",description:`<strong>tokenizer</strong> (<code>PreTrainedTokenizer</code>) &#x2014;
The model&#x2019;s associated tokenizer (necessary to extract vocab and tokenize the termination sequences)`,name:"tokenizer"},{anchor:"transformers.StopStringCriteria.stop_strings",description:`<strong>stop_strings</strong> (<code>Union[str, List[str]]</code>) &#x2014;
A list of strings that should end generation. If a string is passed, it will be treated like a
list with a single element.`,name:"stop_strings"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/stopping_criteria.py#L110"}}),dn=new C({props:{anchor:"transformers.StopStringCriteria.example",$$slots:{default:[tU]},$$scope:{ctx:j}}}),Cl=new M({props:{name:"__call__",anchor:"transformers.StopStringCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.StopStringCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30950/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30950/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30950/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.StopStringCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.StopStringCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/stopping_criteria.py#L387",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),Wl=new M({props:{name:"class transformers.EosTokenCriteria",anchor:"transformers.EosTokenCriteria",parameters:[{name:"eos_token_id",val:": Union"}],parametersDescription:[{anchor:"transformers.EosTokenCriteria.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int], torch.Tensor]</code>) &#x2014;
The id(s) of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/stopping_criteria.py#L446"}}),Bl=new M({props:{name:"__call__",anchor:"transformers.EosTokenCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.EosTokenCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30950/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30950/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30950/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EosTokenCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.EosTokenCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/stopping_criteria.py#L463",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),zl=new ge({props:{title:"Constraints",local:"transformers.Constraint",headingTag:"h2"}}),Vl=new M({props:{name:"class transformers.Constraint",anchor:"transformers.Constraint",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/beam_constraints.py#L5"}}),pn=new C({props:{anchor:"transformers.Constraint.example",$$slots:{default:[sU]},$$scope:{ctx:j}}}),Gl=new M({props:{name:"advance",anchor:"transformers.Constraint.advance",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/beam_constraints.py#L48",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>A single token ID (int) that advances the constraint, or</li>
<li>A list of token IDs that could advance the constraint</li>
<li>None if the constraint is completed or cannot be advanced</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>token_ids (Union[int, List[int], None])</p>
`}}),Fl=new M({props:{name:"copy",anchor:"transformers.Constraint.copy",parameters:[{name:"stateful",val:" = False"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/beam_constraints.py#L116",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The same constraint as the one being called from.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>constraint(<code>Constraint</code>)</p>
`}}),Xl=new M({props:{name:"does_advance",anchor:"transformers.Constraint.does_advance",parameters:[{name:"token_id",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/beam_constraints.py#L63"}}),Ll=new M({props:{name:"remaining",anchor:"transformers.Constraint.remaining",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/beam_constraints.py#L107"}}),Rl=new M({props:{name:"reset",anchor:"transformers.Constraint.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/beam_constraints.py#L97"}}),Sl=new M({props:{name:"test",anchor:"transformers.Constraint.test",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/beam_constraints.py#L24"}}),Nl=new M({props:{name:"update",anchor:"transformers.Constraint.update",parameters:[{name:"token_id",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/beam_constraints.py#L72",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Whether this constraint has become one step closer to being fulfuilled.
completed(<code>bool</code>):
Whether this constraint has been completely fulfilled by this token being generated.
reset (<code>bool</code>):
Whether this constraint has reset its progress by this token being generated.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>stepped(<code>bool</code>)</p>
`}}),Hl=new M({props:{name:"class transformers.PhrasalConstraint",anchor:"transformers.PhrasalConstraint",parameters:[{name:"token_ids",val:": List"}],parametersDescription:[{anchor:"transformers.PhrasalConstraint.token_ids",description:`<strong>token_ids</strong> (<code>List[int]</code>) &#x2014;
The id of the token that must be generated by the output.`,name:"token_ids"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/beam_constraints.py#L132"}}),El=new M({props:{name:"class transformers.DisjunctiveConstraint",anchor:"transformers.DisjunctiveConstraint",parameters:[{name:"nested_token_ids",val:": List"}],parametersDescription:[{anchor:"transformers.DisjunctiveConstraint.nested_token_ids",description:`<strong>nested_token_ids</strong> (<code>List[List[int]]</code>) &#x2014;
A list of words, where each word is a list of ids. This constraint is fulfilled by generating just one from
the list of words.`,name:"nested_token_ids"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/beam_constraints.py#L264"}}),ql=new M({props:{name:"class transformers.ConstraintListState",anchor:"transformers.ConstraintListState",parameters:[{name:"constraints",val:": List"}],parametersDescription:[{anchor:"transformers.ConstraintListState.constraints",description:`<strong>constraints</strong> (<code>List[Constraint]</code>) &#x2014;
A list of <a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.Constraint">Constraint</a> objects that must be fulfilled by the beam scorer.`,name:"constraints"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/beam_constraints.py#L354"}}),Ql=new M({props:{name:"advance",anchor:"transformers.ConstraintListState.advance",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/beam_constraints.py#L386"}}),Dl=new M({props:{name:"reset",anchor:"transformers.ConstraintListState.reset",parameters:[{name:"token_ids",val:": Optional"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/beam_constraints.py#L421"}}),Yl=new ge({props:{title:"BeamSearch",local:"transformers.BeamScorer",headingTag:"h2"}}),Pl=new M({props:{name:"class transformers.BeamScorer",anchor:"transformers.BeamScorer",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/beam_search.py#L91"}}),Al=new M({props:{name:"process",anchor:"transformers.BeamScorer.process",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BeamScorer.process.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using any class inheriting from <a href="/docs/transformers/pr_30950/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See
<a href="/docs/transformers/pr_30950/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/pr_30950/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.BeamScorer.process.next_scores",description:`<strong>next_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Current scores of the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_scores"},{anchor:"transformers.BeamScorer.process.next_tokens",description:`<strong>next_tokens</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
<code>input_ids</code> of the tokens corresponding to the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_tokens"},{anchor:"transformers.BeamScorer.process.next_indices",description:`<strong>next_indices</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Beam indices indicating to which beam hypothesis the <code>next_tokens</code> correspond.`,name:"next_indices"},{anchor:"transformers.BeamScorer.process.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.BeamScorer.process.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.BeamScorer.process.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Beam indices indicating to which beam hypothesis each token correspond.`,name:"beam_indices"},{anchor:"transformers.BeamScorer.process.group_index",description:`<strong>group_index</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The index of the group of beams. Used with <code>~PreTrainedModel.group_beam_search</code>.`,name:"group_index"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/beam_search.py#L97",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary composed of the fields as defined above:</p>
<ul>
<li><strong>next_beam_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Updated scores of all
non-finished beams.</li>
<li><strong>next_beam_tokens</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Next tokens to be added
to the non-finished beam_hypotheses.</li>
<li><strong>next_beam_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Beam indices
indicating to which beam the next tokens shall be added.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>UserDict</code></p>
`}}),Ol=new M({props:{name:"finalize",anchor:"transformers.BeamScorer.finalize",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"max_length",val:": int"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BeamScorer.finalize.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using any class inheriting from <a href="/docs/transformers/pr_30950/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See
<a href="/docs/transformers/pr_30950/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/pr_30950/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.BeamScorer.finalize.final_beam_scores",description:`<strong>final_beam_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) &#x2014;
The final scores of all non-finished beams.`,name:"final_beam_scores"},{anchor:"transformers.BeamScorer.finalize.final_beam_tokens",description:`<strong>final_beam_tokens</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) &#x2014;
The last tokens to be added to the non-finished beam_hypotheses.`,name:"final_beam_tokens"},{anchor:"transformers.BeamScorer.finalize.final_beam_indices",description:`<strong>final_beam_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) &#x2014;
The beam indices indicating to which beam the <code>final_beam_tokens</code> shall be added.`,name:"final_beam_indices"},{anchor:"transformers.BeamScorer.finalize.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.BeamScorer.finalize.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/beam_search.py#L109",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated sequences.
The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter if all batches finished early
due to the <code>eos_token_id</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.LongTensor</code> of shape <code>(batch_size * num_return_sequences, sequence_length)</code></p>
`}}),Kl=new M({props:{name:"class transformers.BeamSearchScorer",anchor:"transformers.BeamSearchScorer",parameters:[{name:"batch_size",val:": int"},{name:"num_beams",val:": int"},{name:"device",val:": device"},{name:"length_penalty",val:": Optional = 1.0"},{name:"do_early_stopping",val:": Union = False"},{name:"num_beam_hyps_to_keep",val:": Optional = 1"},{name:"num_beam_groups",val:": Optional = 1"},{name:"max_length",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.BeamSearchScorer.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
Batch Size of <code>input_ids</code> for which standard beam search decoding is run in parallel.`,name:"batch_size"},{anchor:"transformers.BeamSearchScorer.num_beams",description:`<strong>num_beams</strong> (<code>int</code>) &#x2014;
Number of beams for beam search.`,name:"num_beams"},{anchor:"transformers.BeamSearchScorer.device",description:`<strong>device</strong> (<code>torch.device</code>) &#x2014;
Defines the device type (<em>e.g.</em>, <code>&quot;cpu&quot;</code> or <code>&quot;cuda&quot;</code>) on which this instance of <code>BeamSearchScorer</code> will be
allocated.`,name:"device"},{anchor:"transformers.BeamSearchScorer.length_penalty",description:`<strong>length_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Exponential penalty to the length that is used with beam-based generation. It is applied as an exponent to
the sequence length, which in turn is used to divide the score of the sequence. Since the score is the log
likelihood of the sequence (i.e. negative), <code>length_penalty</code> &gt; 0.0 promotes longer sequences, while
<code>length_penalty</code> &lt; 0.0 encourages shorter sequences.`,name:"length_penalty"},{anchor:"transformers.BeamSearchScorer.do_early_stopping",description:`<strong>do_early_stopping</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Controls the stopping condition for beam-based methods, like beam-search. It accepts the following values:
<code>True</code>, where the generation stops as soon as there are <code>num_beams</code> complete candidates; <code>False</code>, where an
heuristic is applied and the generation stops when is it very unlikely to find better candidates;
<code>&quot;never&quot;</code>, where the beam search procedure only stops when there cannot be better candidates (canonical
beam search algorithm).`,name:"do_early_stopping"},{anchor:"transformers.BeamSearchScorer.num_beam_hyps_to_keep",description:`<strong>num_beam_hyps_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of beam hypotheses that shall be returned upon calling
<a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.BeamSearchScorer.finalize">finalize()</a>.`,name:"num_beam_hyps_to_keep"},{anchor:"transformers.BeamSearchScorer.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"transformers.BeamSearchScorer.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/beam_search.py#L123"}}),ec=new M({props:{name:"process",anchor:"transformers.BeamSearchScorer.process",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"pad_token_id",val:": Union = None"},{name:"eos_token_id",val:": Union = None"},{name:"beam_indices",val:": Optional = None"},{name:"group_index",val:": Optional = 0"},{name:"decoder_prompt_len",val:": Optional = 0"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/beam_search.py#L215"}}),tc=new M({props:{name:"finalize",anchor:"transformers.BeamSearchScorer.finalize",parameters:[{name:"input_ids",val:": LongTensor"},{name:"final_beam_scores",val:": FloatTensor"},{name:"final_beam_tokens",val:": LongTensor"},{name:"final_beam_indices",val:": LongTensor"},{name:"max_length",val:": int"},{name:"pad_token_id",val:": Union = None"},{name:"eos_token_id",val:": Union = None"},{name:"beam_indices",val:": Optional = None"},{name:"decoder_prompt_len",val:": Optional = 0"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/beam_search.py#L320"}}),sc=new M({props:{name:"class transformers.ConstrainedBeamSearchScorer",anchor:"transformers.ConstrainedBeamSearchScorer",parameters:[{name:"batch_size",val:": int"},{name:"num_beams",val:": int"},{name:"constraints",val:": List"},{name:"device",val:": device"},{name:"length_penalty",val:": Optional = 1.0"},{name:"do_early_stopping",val:": Union = False"},{name:"num_beam_hyps_to_keep",val:": Optional = 1"},{name:"num_beam_groups",val:": Optional = 1"},{name:"max_length",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.ConstrainedBeamSearchScorer.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
Batch Size of <code>input_ids</code> for which standard beam search decoding is run in parallel.`,name:"batch_size"},{anchor:"transformers.ConstrainedBeamSearchScorer.num_beams",description:`<strong>num_beams</strong> (<code>int</code>) &#x2014;
Number of beams for beam search.`,name:"num_beams"},{anchor:"transformers.ConstrainedBeamSearchScorer.constraints",description:`<strong>constraints</strong> (<code>List[Constraint]</code>) &#x2014;
A list of positive constraints represented as <code>Constraint</code> objects that must be fulfilled in the generation
output. For more information, the documentation of <a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.Constraint">Constraint</a> should be read.`,name:"constraints"},{anchor:"transformers.ConstrainedBeamSearchScorer.device",description:`<strong>device</strong> (<code>torch.device</code>) &#x2014;
Defines the device type (<em>e.g.</em>, <code>&quot;cpu&quot;</code> or <code>&quot;cuda&quot;</code>) on which this instance of <code>BeamSearchScorer</code> will be
allocated.`,name:"device"},{anchor:"transformers.ConstrainedBeamSearchScorer.length_penalty",description:`<strong>length_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Exponential penalty to the length that is used with beam-based generation. It is applied as an exponent to
the sequence length, which in turn is used to divide the score of the sequence. Since the score is the log
likelihood of the sequence (i.e. negative), <code>length_penalty</code> &gt; 0.0 promotes longer sequences, while
<code>length_penalty</code> &lt; 0.0 encourages shorter sequences.`,name:"length_penalty"},{anchor:"transformers.ConstrainedBeamSearchScorer.do_early_stopping",description:`<strong>do_early_stopping</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Controls the stopping condition for beam-based methods, like beam-search. It accepts the following values:
<code>True</code>, where the generation stops as soon as there are <code>num_beams</code> complete candidates; <code>False</code>, where an
heuristic is applied and the generation stops when is it very unlikely to find better candidates;
<code>&quot;never&quot;</code>, where the beam search procedure only stops when there cannot be better candidates (canonical
beam search algorithm).`,name:"do_early_stopping"},{anchor:"transformers.ConstrainedBeamSearchScorer.num_beam_hyps_to_keep",description:`<strong>num_beam_hyps_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of beam hypotheses that shall be returned upon calling
<a href="/docs/transformers/pr_30950/en/internal/generation_utils#transformers.BeamSearchScorer.finalize">finalize()</a>.`,name:"num_beam_hyps_to_keep"},{anchor:"transformers.ConstrainedBeamSearchScorer.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"transformers.ConstrainedBeamSearchScorer.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/beam_search.py#L419"}}),nc=new M({props:{name:"process",anchor:"transformers.ConstrainedBeamSearchScorer.process",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"scores_for_all_vocab",val:": FloatTensor"},{name:"pad_token_id",val:": Union = None"},{name:"eos_token_id",val:": Union = None"},{name:"beam_indices",val:": Optional = None"},{name:"decoder_prompt_len",val:": Optional = 0"}],parametersDescription:[{anchor:"transformers.ConstrainedBeamSearchScorer.process.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using any class inheriting from <a href="/docs/transformers/pr_30950/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See
<a href="/docs/transformers/pr_30950/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/pr_30950/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.next_scores",description:`<strong>next_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Current scores of the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_scores"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.next_tokens",description:`<strong>next_tokens</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
<code>input_ids</code> of the tokens corresponding to the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_tokens"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.next_indices",description:`<strong>next_indices</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Beam indices indicating to which beam hypothesis the <code>next_tokens</code> correspond.`,name:"next_indices"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.scores_for_all_vocab",description:`<strong>scores_for_all_vocab</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
The scores of all tokens in the vocabulary for each of the beam hypotheses.`,name:"scores_for_all_vocab"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Beam indices indicating to which beam hypothesis each token correspond.`,name:"beam_indices"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.decoder_prompt_len",description:`<strong>decoder_prompt_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The length of prompt that is included in the input to decoder.`,name:"decoder_prompt_len"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/beam_search.py#L513",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary composed of the fields as defined above:</p>
<ul>
<li>
<p><strong>next_beam_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Updated scores of
all
non-finished beams.</p>
</li>
<li>
<p><strong>next_beam_tokens</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Next tokens to be
added
to the non-finished beam_hypotheses.</p>
</li>
<li>
<p><strong>next_beam_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Beam indices
indicating to which beam the next tokens shall be added.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>UserDict</code></p>
`}}),rc=new M({props:{name:"finalize",anchor:"transformers.ConstrainedBeamSearchScorer.finalize",parameters:[{name:"input_ids",val:": LongTensor"},{name:"final_beam_scores",val:": FloatTensor"},{name:"final_beam_tokens",val:": LongTensor"},{name:"final_beam_indices",val:": LongTensor"},{name:"max_length",val:": int"},{name:"pad_token_id",val:": Union = None"},{name:"eos_token_id",val:": Union = None"},{name:"beam_indices",val:": Optional = None"},{name:"decoder_prompt_len",val:": Optional = 0"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/beam_search.py#L813"}}),ac=new ge({props:{title:"Streamers",local:"transformers.TextStreamer",headingTag:"h2"}}),oc=new M({props:{name:"class transformers.TextStreamer",anchor:"transformers.TextStreamer",parameters:[{name:"tokenizer",val:": AutoTokenizer"},{name:"skip_prompt",val:": bool = False"},{name:"**decode_kwargs",val:""}],parametersDescription:[{anchor:"transformers.TextStreamer.tokenizer",description:`<strong>tokenizer</strong> (<code>AutoTokenizer</code>) &#x2014;
The tokenized used to decode the tokens.`,name:"tokenizer"},{anchor:"transformers.TextStreamer.skip_prompt",description:`<strong>skip_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to skip the prompt to <code>.generate()</code> or not. Useful e.g. for chatbots.`,name:"skip_prompt"},{anchor:"transformers.TextStreamer.decode_kwargs",description:`<strong>decode_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional keyword arguments to pass to the tokenizer&#x2019;s <code>decode</code> method.`,name:"decode_kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/streamers.py#L38"}}),yn=new vr({props:{warning:!0,$$slots:{default:[nU]},$$scope:{ctx:j}}}),Tn=new C({props:{anchor:"transformers.TextStreamer.example",$$slots:{default:[rU]},$$scope:{ctx:j}}}),lc=new M({props:{name:"end",anchor:"transformers.TextStreamer.end",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/streamers.py#L116"}}),cc=new M({props:{name:"on_finalized_text",anchor:"transformers.TextStreamer.on_finalized_text",parameters:[{name:"text",val:": str"},{name:"stream_end",val:": bool = False"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/streamers.py#L130"}}),ic=new M({props:{name:"put",anchor:"transformers.TextStreamer.put",parameters:[{name:"value",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/streamers.py#L82"}}),dc=new M({props:{name:"class transformers.TextIteratorStreamer",anchor:"transformers.TextIteratorStreamer",parameters:[{name:"tokenizer",val:": AutoTokenizer"},{name:"skip_prompt",val:": bool = False"},{name:"timeout",val:": Optional = None"},{name:"**decode_kwargs",val:""}],parametersDescription:[{anchor:"transformers.TextIteratorStreamer.tokenizer",description:`<strong>tokenizer</strong> (<code>AutoTokenizer</code>) &#x2014;
The tokenized used to decode the tokens.`,name:"tokenizer"},{anchor:"transformers.TextIteratorStreamer.skip_prompt",description:`<strong>skip_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to skip the prompt to <code>.generate()</code> or not. Useful e.g. for chatbots.`,name:"skip_prompt"},{anchor:"transformers.TextIteratorStreamer.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The timeout for the text queue. If <code>None</code>, the queue will block indefinitely. Useful to handle exceptions
in <code>.generate()</code>, when it is called in a separate thread.`,name:"timeout"},{anchor:"transformers.TextIteratorStreamer.decode_kwargs",description:`<strong>decode_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional keyword arguments to pass to the tokenizer&#x2019;s <code>decode</code> method.`,name:"decode_kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/streamers.py#L159"}}),kn=new vr({props:{warning:!0,$$slots:{default:[aU]},$$scope:{ctx:j}}}),$n=new C({props:{anchor:"transformers.TextIteratorStreamer.example",$$slots:{default:[oU]},$$scope:{ctx:j}}}),pc=new M({props:{name:"on_finalized_text",anchor:"transformers.TextIteratorStreamer.on_finalized_text",parameters:[{name:"text",val:": str"},{name:"stream_end",val:": bool = False"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/streamers.py#L213"}}),mc=new ge({props:{title:"Caches",local:"transformers.Cache",headingTag:"h2"}}),hc=new M({props:{name:"class transformers.Cache",anchor:"transformers.Cache",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/cache_utils.py#L26"}}),gc=new M({props:{name:"update",anchor:"transformers.Cache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Cache.update.key_states",description:`<strong>key_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new key states to cache.`,name:"key_states"},{anchor:"transformers.Cache.update.value_states",description:`<strong>value_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new value states to cache.`,name:"value_states"},{anchor:"transformers.Cache.update.layer_idx",description:`<strong>layer_idx</strong> (<code>int</code>) &#x2014;
The index of the layer to cache the states for.`,name:"layer_idx"},{anchor:"transformers.Cache.update.cache_kwargs",description:`<strong>cache_kwargs</strong> (<code>Dict[str, Any]</code>, <code>optional</code>) &#x2014;
Additional arguments for the cache subclass. These are specific to each subclass and allow new types of
cache to be created.`,name:"cache_kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/cache_utils.py#L34",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the updated key and value states.</p>
`}}),uc=new M({props:{name:"class transformers.CacheConfig",anchor:"transformers.CacheConfig",parameters:[{name:"cache_implementation",val:": None"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/cache_utils.py#L102"}}),fc=new M({props:{name:"update",anchor:"transformers.CacheConfig.update",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.CacheConfig.update.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Dictionary of attributes to tentatively update this class.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/cache_utils.py#L176",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary containing all the key-value pairs that were not used to update the instance.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, Any]</code></p>
`}}),_c=new M({props:{name:"class transformers.QuantizedCacheConfig",anchor:"transformers.QuantizedCacheConfig",parameters:[{name:"backend",val:": str = 'quanto'"},{name:"nbits",val:": Optional = 4"},{name:"axis_key",val:": Optional = 0"},{name:"axis_value",val:": Optional = 0"},{name:"q_group_size",val:": Optional = 64"},{name:"residual_length",val:": Optional = 128"},{name:"compute_dtype",val:": Optional = torch.float16"},{name:"device",val:": Optional = 'cpu'"}],parametersDescription:[{anchor:"transformers.QuantizedCacheConfig.backend",description:`<strong>backend</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;quanto&quot;</code>) &#x2014;
Backend to use when performing quantization, Can be one of [<code>quanto</code>, <code>HQQ</code>]`,name:"backend"},{anchor:"transformers.QuantizedCacheConfig.nbits",description:`<strong>nbits</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to 4) &#x2014;
Number of bits, can be 2 or 4 for the <code>quanto</code> backend and one of [1, 2, 3, 4, 8] for the <code>HQQ</code> backend. Defaults to 2.`,name:"nbits"},{anchor:"transformers.QuantizedCacheConfig.axis_key",description:`<strong>axis_key</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Axis over which to perform grouping for the key tensors. Can be [0, -1] for <code>quanto</code> backend and [0, 1] for <code>HQQ</code> backend.`,name:"axis_key"},{anchor:"transformers.QuantizedCacheConfig.axis_value",description:`<strong>axis_value</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Axis over which to perform grouping for the value tensors. Can be [0, -1] for <code>quanto</code> backend and [0, 1] for <code>HQQ</code> backend.`,name:"axis_value"},{anchor:"transformers.QuantizedCacheConfig.q_group_size",description:`<strong>q_group_size</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to 64) &#x2014;
Size of the quantization group, should be a divisor of the model&#x2019;s hidden dimension.
Defaults to 64.`,name:"q_group_size"},{anchor:"transformers.QuantizedCacheConfig.residual_length",description:`<strong>residual_length</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to 128) &#x2014;
Length of the residual cache which will always be stored in original presicion.
Defaults to 128.`,name:"residual_length"},{anchor:"transformers.QuantizedCacheConfig.compute_dtype",description:`<strong>compute_dtype</strong> (<code>torch.dtype</code>, <em>optional</em>, defaults to <code>torch.float16</code>) &#x2014;
The defualt dtype used for computations in the model. Keys and Values will be cast to this dtype after dequantization.`,name:"compute_dtype"},{anchor:"transformers.QuantizedCacheConfig.device",description:`<strong>device</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;cpu&quot;</code>) &#x2014;
Device on which to perform computations, should be same as the model&#x2019;s device.`,name:"device"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/cache_utils.py#L199"}}),bc=new M({props:{name:"validate",anchor:"transformers.QuantizedCacheConfig.validate",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/cache_utils.py#L245"}}),yc=new M({props:{name:"class transformers.DynamicCache",anchor:"transformers.DynamicCache",parameters:[{name:"num_hidden_layers",val:": Optional = None"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/cache_utils.py#L338"}}),Zn=new C({props:{anchor:"transformers.DynamicCache.example",$$slots:{default:[lU]},$$scope:{ctx:j}}}),Tc=new M({props:{name:"update",anchor:"transformers.DynamicCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.DynamicCache.update.key_states",description:`<strong>key_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new key states to cache.`,name:"key_states"},{anchor:"transformers.DynamicCache.update.value_states",description:`<strong>value_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new value states to cache.`,name:"value_states"},{anchor:"transformers.DynamicCache.update.layer_idx",description:`<strong>layer_idx</strong> (<code>int</code>) &#x2014;
The index of the layer to cache the states for.`,name:"layer_idx"},{anchor:"transformers.DynamicCache.update.cache_kwargs",description:`<strong>cache_kwargs</strong> (<code>Dict[str, Any]</code>, <code>optional</code>) &#x2014;
Additional arguments for the cache subclass. No additional arguments are used in <code>DynamicCache</code>.`,name:"cache_kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/cache_utils.py#L398",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the updated key and value states.</p>
`}}),vc=new M({props:{name:"get_seq_length",anchor:"transformers.DynamicCache.get_seq_length",parameters:[{name:"layer_idx",val:": Optional = 0"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/cache_utils.py#L440"}}),Mc=new M({props:{name:"reorder_cache",anchor:"transformers.DynamicCache.reorder_cache",parameters:[{name:"beam_idx",val:": LongTensor"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/cache_utils.py#L80"}}),wc=new M({props:{name:"to_legacy_cache",anchor:"transformers.DynamicCache.to_legacy_cache",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/cache_utils.py#L451"}}),kc=new M({props:{name:"from_legacy_cache",anchor:"transformers.DynamicCache.from_legacy_cache",parameters:[{name:"past_key_values",val:": Optional = None"},{name:"num_hidden_layers",val:": int = None"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/cache_utils.py#L459"}}),$c=new M({props:{name:"class transformers.QuantizedCache",anchor:"transformers.QuantizedCache",parameters:[{name:"cache_config",val:": QuantizedCacheConfig"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/cache_utils.py#L639"}}),jc=new M({props:{name:"update",anchor:"transformers.QuantizedCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": Optional = None"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/cache_utils.py#L668"}}),xc=new M({props:{name:"get_seq_length",anchor:"transformers.QuantizedCache.get_seq_length",parameters:[{name:"layer_idx",val:": Optional = 0"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/cache_utils.py#L709"}}),Jc=new M({props:{name:"class transformers.QuantoQuantizedCache",anchor:"transformers.QuantoQuantizedCache",parameters:[{name:"cache_config",val:": CacheConfig"}],parametersDescription:[{anchor:"transformers.QuantoQuantizedCache.cache_config",description:`<strong>cache_config</strong> (<code>QuantizedCacheConfig</code>) &#x2014;
A configuration containing all the arguments to be used by the quantizer, including axis, qtype and group size.`,name:"cache_config"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/cache_utils.py#L727"}}),Gn=new C({props:{anchor:"transformers.QuantoQuantizedCache.example",$$slots:{default:[cU]},$$scope:{ctx:j}}}),Uc=new M({props:{name:"class transformers.HQQQuantizedCache",anchor:"transformers.HQQQuantizedCache",parameters:[{name:"cache_config",val:": CacheConfig"}],parametersDescription:[{anchor:"transformers.HQQQuantizedCache.cache_config",description:`<strong>cache_config</strong> (<code>QuantizedCacheConfig</code>) &#x2014;
A configuration containing all the arguments to be used by the quantizer, including axis, qtype and group size.`,name:"cache_config"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/cache_utils.py#L787"}}),Fn=new C({props:{anchor:"transformers.HQQQuantizedCache.example",$$slots:{default:[iU]},$$scope:{ctx:j}}}),Zc=new M({props:{name:"class transformers.SinkCache",anchor:"transformers.SinkCache",parameters:[{name:"window_length",val:": int"},{name:"num_sink_tokens",val:": int"}],parametersDescription:[{anchor:"transformers.SinkCache.window_length",description:`<strong>window_length</strong> (<code>int</code>) &#x2014;
The length of the context window.`,name:"window_length"},{anchor:"transformers.SinkCache.num_sink_tokens",description:`<strong>num_sink_tokens</strong> (<code>int</code>) &#x2014;
The number of sink tokens. See the original paper for more information.`,name:"num_sink_tokens"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/cache_utils.py#L849"}}),Xn=new C({props:{anchor:"transformers.SinkCache.example",$$slots:{default:[dU]},$$scope:{ctx:j}}}),Cc=new M({props:{name:"update",anchor:"transformers.SinkCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.SinkCache.update.key_states",description:`<strong>key_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new key states to cache.`,name:"key_states"},{anchor:"transformers.SinkCache.update.value_states",description:`<strong>value_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new value states to cache.`,name:"value_states"},{anchor:"transformers.SinkCache.update.layer_idx",description:`<strong>layer_idx</strong> (<code>int</code>) &#x2014;
The index of the layer to cache the states for.`,name:"layer_idx"},{anchor:"transformers.SinkCache.update.cache_kwargs",description:`<strong>cache_kwargs</strong> (<code>Dict[str, Any]</code>, <code>optional</code>) &#x2014;
Additional arguments for the cache subclass. The following arguments can be used in <code>SinkCache</code>: <code>sin</code>,
<code>cos</code> and <code>partial_rotation_size</code>. These arguments are used with models using RoPE, to recompute the
rotation as the tokens are shifted.`,name:"cache_kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/cache_utils.py#L939",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the updated key and value states.</p>
`}}),Wc=new M({props:{name:"get_seq_length",anchor:"transformers.SinkCache.get_seq_length",parameters:[{name:"layer_idx",val:": Optional = 0"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/cache_utils.py#L927"}}),Bc=new M({props:{name:"reorder_cache",anchor:"transformers.SinkCache.reorder_cache",parameters:[{name:"beam_idx",val:": LongTensor"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/cache_utils.py#L80"}}),zc=new M({props:{name:"class transformers.OffloadedCache",anchor:"transformers.OffloadedCache",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/cache_utils.py#L527"}}),Ic=new M({props:{name:"update",anchor:"transformers.OffloadedCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.OffloadedCache.update.key_states",description:`<strong>key_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new key states to cache.`,name:"key_states"},{anchor:"transformers.OffloadedCache.update.value_states",description:`<strong>value_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new value states to cache.`,name:"value_states"},{anchor:"transformers.OffloadedCache.update.layer_idx",description:`<strong>layer_idx</strong> (<code>int</code>) &#x2014;
The index of the layer to cache the states for.`,name:"layer_idx"},{anchor:"transformers.OffloadedCache.update.cache_kwargs",description:`<strong>cache_kwargs</strong> (<code>Dict[str, Any]</code>, <code>optional</code>) &#x2014;
Additional arguments for the cache subclass. No additional arguments are used in <code>OffloadedCache</code>.`,name:"cache_kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/cache_utils.py#L594",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the updated key and value states.</p>
`}}),Vc=new M({props:{name:"prefetch_layer",anchor:"transformers.OffloadedCache.prefetch_layer",parameters:[{name:"layer_idx",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/cache_utils.py#L548"}}),Gc=new M({props:{name:"evict_previous_layer",anchor:"transformers.OffloadedCache.evict_previous_layer",parameters:[{name:"layer_idx",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/cache_utils.py#L557"}}),Fc=new M({props:{name:"class transformers.StaticCache",anchor:"transformers.StaticCache",parameters:[{name:"config",val:": PretrainedConfig"},{name:"batch_size",val:": int = None"},{name:"max_cache_len",val:": int = None"},{name:"device",val:": device = None"},{name:"dtype",val:": dtype = torch.float32"},{name:"max_batch_size",val:": Optional = None"},{name:"layer_device_map",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.StaticCache.config",description:`<strong>config</strong> (<code>PretrainedConfig</code>) &#x2014;
The configuration file defining the shape-related attributes required to initialize the static cache.`,name:"config"},{anchor:"transformers.StaticCache.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
The batch size with which the model will be used. Note that a new instance must be instantiated if a
smaller batch size is used. If you are manually setting the batch size, make sure to take into account the number of beams if you are running beam search`,name:"batch_size"},{anchor:"transformers.StaticCache.max_cache_len",description:`<strong>max_cache_len</strong> (<code>int</code>) &#x2014;
The maximum sequence length with which the model will be used.`,name:"max_cache_len"},{anchor:"transformers.StaticCache.device",description:`<strong>device</strong> (<code>torch.device</code> or <code>str</code>) &#x2014;
The device on which the cache should be initialized. Should be the same as the layer.`,name:"device"},{anchor:"transformers.StaticCache.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>, defaults to <code>torch.float32</code>) &#x2014;
The default <code>dtype</code> to use when initializing the layer.`,name:"dtype"},{anchor:"transformers.StaticCache.layer_device_map(`Dict[int,",description:"<strong>layer_device_map(`Dict[int,</strong> Union[str, torch.device, int]]]<code>, </code>optional<code>) -- Mapping between the layers and its device. This is required when you are manually initializing the cache and the model is splitted between differents gpus. You can know which layers mapped to which device by checking the associated device_map: </code>model.hf_device_map`.",name:"layer_device_map(`Dict[int,"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/cache_utils.py#L1034"}}),qn=new C({props:{anchor:"transformers.StaticCache.example",$$slots:{default:[pU]},$$scope:{ctx:j}}}),Xc=new M({props:{name:"update",anchor:"transformers.StaticCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.StaticCache.update.key_states",description:`<strong>key_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new key states to cache.`,name:"key_states"},{anchor:"transformers.StaticCache.update.value_states",description:`<strong>value_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new value states to cache.`,name:"value_states"},{anchor:"transformers.StaticCache.update.layer_idx",description:`<strong>layer_idx</strong> (<code>int</code>) &#x2014;
The index of the layer to cache the states for.`,name:"layer_idx"},{anchor:"transformers.StaticCache.update.cache_kwargs",description:`<strong>cache_kwargs</strong> (<code>Dict[str, Any]</code>, <code>optional</code>) &#x2014;
Additional arguments for the cache subclass. The <code>StaticCache</code> needs the <code>cache_position</code> input
to know how where to write in the cache.`,name:"cache_kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/cache_utils.py#L1133",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the updated key and value states.</p>
`}}),Lc=new M({props:{name:"get_seq_length",anchor:"transformers.StaticCache.get_seq_length",parameters:[{name:"layer_idx",val:": Optional = 0"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/cache_utils.py#L1181"}}),Rc=new M({props:{name:"reset",anchor:"transformers.StaticCache.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/cache_utils.py#L1192"}}),Sc=new M({props:{name:"class transformers.OffloadedStaticCache",anchor:"transformers.OffloadedStaticCache",parameters:[{name:"config",val:": PretrainedConfig"},{name:"max_batch_size",val:": int"},{name:"max_cache_len",val:": Optional"},{name:"device",val:": Union"},{name:"dtype",val:": Optional = None"},{name:"offload_device",val:": Union = device(type='cpu')"}],parametersDescription:[{anchor:"transformers.OffloadedStaticCache.config",description:`<strong>config</strong> (\`PretrainedConfig) &#x2014;
The configuration file defining the shape-related attributes required to initialize
the static cache.`,name:"config"},{anchor:"transformers.OffloadedStaticCache.max_batch_size",description:`<strong>max_batch_size</strong> (<code>int</code>) &#x2014;
The maximum batch size with which the model will be used.`,name:"max_batch_size"},{anchor:"transformers.OffloadedStaticCache.max_cache_len",description:`<strong>max_cache_len</strong> (<code>int</code>) &#x2014;
The maximum sequence length with which the model will be used.`,name:"max_cache_len"},{anchor:"transformers.OffloadedStaticCache.device",description:`<strong>device</strong> (<code>Union[str, torch.device]</code>) &#x2014;
The device on which the cache should be initialized. Should be the same as the
layer device.`,name:"device"},{anchor:"transformers.OffloadedStaticCache.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>) &#x2014;
The default <code>dtype</code> to use when initializing the cache.`,name:"dtype"},{anchor:"transformers.OffloadedStaticCache.offload_device",description:`<strong>offload_device</strong> (<code>Union[str, torch.device]</code>, <em>optional</em>, defaults to <code>cpu</code>) &#x2014;
The device to offload to. Defaults to CPU.`,name:"offload_device"},{anchor:"transformers.OffloadedStaticCache.key_cache",description:`<strong>key_cache</strong> (<code>List[torch.Tensor]</code>) &#x2014;
Off-loaded key cache tensors. First one will be on device, where-as the others are
off-loaded.`,name:"key_cache"},{anchor:"transformers.OffloadedStaticCache.value_cache",description:`<strong>value_cache</strong> (<code>List[torch.Tensor]</code>) &#x2014;
Off-loaded value cache tensors. First one will be on device, where-as the others are
off-loaded.`,name:"value_cache"},{anchor:"transformers.OffloadedStaticCache.max_batch_size",description:`<strong>max_batch_size</strong> (<code>int</code>) &#x2014;
The maximum batch size with which this cache can be used.`,name:"max_batch_size"},{anchor:"transformers.OffloadedStaticCache.max_cache_len",description:`<strong>max_cache_len</strong> (<code>int</code>) &#x2014;
The maximum sequence length with which this cache can be used.`,name:"max_cache_len"},{anchor:"transformers.OffloadedStaticCache.device",description:`<strong>device</strong> (<code>torch.device</code>) &#x2014;
The device on which the cache is used.`,name:"device"},{anchor:"transformers.OffloadedStaticCache.offload_device",description:`<strong>offload_device</strong> (<code>torch.device</code>) &#x2014;
The device used to offload to.`,name:"offload_device"},{anchor:"transformers.OffloadedStaticCache.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>) &#x2014;
The <code>dtype</code> used to initializing the cache.`,name:"dtype"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/cache_utils.py#L1814"}}),Pn=new C({props:{anchor:"transformers.OffloadedStaticCache.example",$$slots:{default:[mU]},$$scope:{ctx:j}}}),Nc=new M({props:{name:"update",anchor:"transformers.OffloadedStaticCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.OffloadedStaticCache.update.key_states",description:`<strong>key_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new key states to cache.`,name:"key_states"},{anchor:"transformers.OffloadedStaticCache.update.value_states",description:`<strong>value_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new value states to cache.`,name:"value_states"},{anchor:"transformers.OffloadedStaticCache.update.layer_idx",description:`<strong>layer_idx</strong> (<code>int</code>) &#x2014;
The index of the layer to cache the states for.`,name:"layer_idx"},{anchor:"transformers.OffloadedStaticCache.update.cache_kwargs",description:`<strong>cache_kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional arguments for the cache subclass. The <code>OffloadedStaticCache</code> needs the
<code>cache_position</code> input to know how where to write in the cache.`,name:"cache_kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/cache_utils.py#L1926",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the updated key and value states.</p>
`}}),Hc=new M({props:{name:"get_seq_length",anchor:"transformers.OffloadedStaticCache.get_seq_length",parameters:[{name:"layer_idx",val:": Optional = 0"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/cache_utils.py#L2009"}}),Ec=new M({props:{name:"reset",anchor:"transformers.OffloadedStaticCache.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/cache_utils.py#L2020"}}),qc=new M({props:{name:"class transformers.HybridCache",anchor:"transformers.HybridCache",parameters:[{name:"config",val:": PretrainedConfig"},{name:"batch_size",val:": int = None"},{name:"max_cache_len",val:": int = None"},{name:"device",val:": Union = 'cpu'"},{name:"dtype",val:": dtype = torch.float32"},{name:"max_batch_size",val:": Optional = None"},{name:"layer_device_map",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.HybridCache.config",description:"<strong>config</strong> (`PretrainedConfig) &#x2014;\nThe configuration file defining the shape-related attributes required to initialize the static cache.",name:"config"},{anchor:"transformers.HybridCache.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
The batch size with which the model will be used. Note that a new instance must be instantiated if a
smaller batch size is used.`,name:"batch_size"},{anchor:"transformers.HybridCache.max_cache_len",description:`<strong>max_cache_len</strong> (<code>int</code>) &#x2014;
The maximum sequence length with which the model will be used.`,name:"max_cache_len"},{anchor:"transformers.HybridCache.device",description:`<strong>device</strong> (<code>torch.device</code> or <code>str</code>, <em>optional</em>, defaults to <code>&quot;cpu&quot;</code>) &#x2014;
The device on which the cache should be initialized. Should be the same as the layer.`,name:"device"},{anchor:"transformers.HybridCache.dtype",description:`<strong>dtype</strong> (torch.dtype, <em>optional</em>, defaults to <code>torch.float32</code>) &#x2014;
The default <code>dtype</code> to use when initializing the layer.`,name:"dtype"},{anchor:"transformers.HybridCache.layer_device_map(`Dict[int,",description:"<strong>layer_device_map(`Dict[int,</strong> Union[str, torch.device, int]]]<code>, </code>optional<code>) -- Mapping between the layers and its device. This is required when you are manually initializing the cache and the model is splitted between differents gpus. You can know which layers mapped to which device by checking the associated device_map: </code>model.hf_device_map`.",name:"layer_device_map(`Dict[int,"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/cache_utils.py#L1517"}}),er=new C({props:{anchor:"transformers.HybridCache.example",$$slots:{default:[hU]},$$scope:{ctx:j}}}),Qc=new M({props:{name:"update",anchor:"transformers.HybridCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": Optional = None"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/cache_utils.py#L1656"}}),Dc=new M({props:{name:"get_seq_length",anchor:"transformers.HybridCache.get_seq_length",parameters:[{name:"layer_idx",val:": Optional = 0"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/cache_utils.py#L1687"}}),Yc=new M({props:{name:"reset",anchor:"transformers.HybridCache.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/cache_utils.py#L1698"}}),Pc=new M({props:{name:"class transformers.SlidingWindowCache",anchor:"transformers.SlidingWindowCache",parameters:[{name:"config",val:": PretrainedConfig"},{name:"batch_size",val:": int = None"},{name:"max_cache_len",val:": int = None"},{name:"device",val:": device = None"},{name:"dtype",val:": dtype = torch.float32"},{name:"max_batch_size",val:": Optional = None"},{name:"layer_device_map",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.SlidingWindowCache.config",description:`<strong>config</strong> (<code>PretrainedConfig</code>) &#x2014;
The configuration file defining the shape-related attributes required to initialize the static cache.`,name:"config"},{anchor:"transformers.SlidingWindowCache.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
The batch size with which the model will be used. Note that a new instance must be instantiated if a
smaller batch size is used.`,name:"batch_size"},{anchor:"transformers.SlidingWindowCache.max_cache_len",description:`<strong>max_cache_len</strong> (<code>int</code>) &#x2014;
The maximum sequence length with which the model will be used.`,name:"max_cache_len"},{anchor:"transformers.SlidingWindowCache.device",description:`<strong>device</strong> (<code>torch.device</code> or <code>str</code>) &#x2014;
The device on which the cache should be initialized. Should be the same as the layer.`,name:"device"},{anchor:"transformers.SlidingWindowCache.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>, defaults to <code>torch.float32</code>) &#x2014;
The default <code>dtype</code> to use when initializing the layer.`,name:"dtype"},{anchor:"transformers.SlidingWindowCache.layer_device_map(`Dict[int,",description:"<strong>layer_device_map(`Dict[int,</strong> Union[str, torch.device, int]]]<code>, </code>optional<code>) -- Mapping between the layers and its device. This is required when you are manually initializing the cache and the model is splitted between differents gpus. You can know which layers mapped to which device by checking the associated device_map: </code>model.hf_device_map`.",name:"layer_device_map(`Dict[int,"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/cache_utils.py#L1200"}}),sr=new C({props:{anchor:"transformers.SlidingWindowCache.example",$$slots:{default:[gU]},$$scope:{ctx:j}}}),Ac=new M({props:{name:"update",anchor:"transformers.SlidingWindowCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": Optional = None"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/cache_utils.py#L1282"}}),Oc=new M({props:{name:"reset",anchor:"transformers.SlidingWindowCache.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/cache_utils.py#L1333"}}),Kc=new M({props:{name:"class transformers.EncoderDecoderCache",anchor:"transformers.EncoderDecoderCache",parameters:[{name:"self_attention_cache",val:": Cache"},{name:"cross_attention_cache",val:": Cache"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/cache_utils.py#L1340"}}),nr=new C({props:{anchor:"transformers.EncoderDecoderCache.example",$$slots:{default:[uU]},$$scope:{ctx:j}}}),ei=new M({props:{name:"get_seq_length",anchor:"transformers.EncoderDecoderCache.get_seq_length",parameters:[{name:"layer_idx",val:": Optional = 0"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/cache_utils.py#L1428"}}),ti=new M({props:{name:"to_legacy_cache",anchor:"transformers.EncoderDecoderCache.to_legacy_cache",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/cache_utils.py#L1397"}}),si=new M({props:{name:"from_legacy_cache",anchor:"transformers.EncoderDecoderCache.from_legacy_cache",parameters:[{name:"past_key_values",val:": Optional = None"},{name:"num_hidden_layers",val:": int = None"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/cache_utils.py#L1409"}}),ni=new M({props:{name:"reset",anchor:"transformers.EncoderDecoderCache.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/cache_utils.py#L1437"}}),ri=new M({props:{name:"reorder_cache",anchor:"transformers.EncoderDecoderCache.reorder_cache",parameters:[{name:"beam_idx",val:": LongTensor"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/cache_utils.py#L1452"}}),ai=new M({props:{name:"class transformers.MambaCache",anchor:"transformers.MambaCache",parameters:[{name:"config",val:": PretrainedConfig"},{name:"batch_size",val:": int = None"},{name:"dtype",val:": dtype = torch.float16"},{name:"device",val:": Union = None"},{name:"max_batch_size",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MambaCache.config",description:"<strong>config</strong> (`PretrainedConfig) &#x2014;\nThe configuration file defining the shape-related attributes required to initialize the static cache.",name:"config"},{anchor:"transformers.MambaCache.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
The batch size with which the model will be used. Note that a new instance must be instantiated if a
smaller batch size is used.`,name:"batch_size"},{anchor:"transformers.MambaCache.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>, defaults to <code>torch.float16</code>) &#x2014;
The default <code>dtype</code> to use when initializing the layer.`,name:"dtype"},{anchor:"transformers.MambaCache.device",description:`<strong>device</strong> (<code>torch.device</code> or <code>str</code>, <em>optional</em>) &#x2014;
The device on which the cache should be initialized. Should be the same as the layer.
dtype &#x2014; (<code>torch.dtype</code>):
The default <code>dtype</code> used to initializing the cache.
intermediate_size &#x2014; (<code>int</code>):
Model&#x2019;s intermediate_size taken from config.
ssm_state_size &#x2014; (<code>int</code>):
Model&#x2019;s state_size taken from config.
conv_kernel_size &#x2014; (<code>int</code>):
Model&#x2019;s convolution kernel size taken from config
conv_states &#x2014; (<code>torch.Tensor</code>):
A tensor of shape <code>[layer_idx, batch_size, intermediate_size, conv_kernel_size]</code> that holds convolutional states.
ssm_states &#x2014; (<code>torch.Tensor</code>):
A tensor of shape <code>[layer_idx, batch_size, intermediate_size, ssm_state_size]</code> that holds ssm states`,name:"device"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/cache_utils.py#L1706"}}),cr=new C({props:{anchor:"transformers.MambaCache.example",$$slots:{default:[fU]},$$scope:{ctx:j}}}),oi=new M({props:{name:"update_conv_state",anchor:"transformers.MambaCache.update_conv_state",parameters:[{name:"layer_idx",val:": int"},{name:"new_conv_state",val:": Tensor"},{name:"cache_position",val:": LongTensor"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/cache_utils.py#L1793"}}),li=new M({props:{name:"update_ssm_state",anchor:"transformers.MambaCache.update_ssm_state",parameters:[{name:"layer_idx",val:": int"},{name:"new_ssm_state",val:": Tensor"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/cache_utils.py#L1805"}}),ci=new M({props:{name:"reset",anchor:"transformers.MambaCache.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/cache_utils.py#L1809"}}),ii=new ge({props:{title:"Watermark Utils",local:"transformers.WatermarkDetector",headingTag:"h2"}}),di=new M({props:{name:"class transformers.WatermarkDetector",anchor:"transformers.WatermarkDetector",parameters:[{name:"model_config",val:": PretrainedConfig"},{name:"device",val:": str"},{name:"watermarking_config",val:": Union"},{name:"ignore_repeated_ngrams",val:": bool = False"},{name:"max_cache_size",val:": int = 128"}],parametersDescription:[{anchor:"transformers.WatermarkDetector.model_config",description:`<strong>model_config</strong> (<code>PretrainedConfig</code>) &#x2014;
The model config that will be used to get model specific arguments used when generating.`,name:"model_config"},{anchor:"transformers.WatermarkDetector.device",description:`<strong>device</strong> (<code>str</code>) &#x2014;
The device which was used during watermarked text generation.`,name:"device"},{anchor:"transformers.WatermarkDetector.watermarking_config",description:`<strong>watermarking_config</strong> (Union[<code>WatermarkingConfig</code>, <code>Dict</code>]) &#x2014;
The exact same watermarking config and arguments used when generating text.`,name:"watermarking_config"},{anchor:"transformers.WatermarkDetector.ignore_repeated_ngrams",description:`<strong>ignore_repeated_ngrams</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to count every unique ngram only once or not.`,name:"ignore_repeated_ngrams"},{anchor:"transformers.WatermarkDetector.max_cache_size",description:`<strong>max_cache_size</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
The max size to be used for LRU caching of seeding/sampling algorithms called for every token.`,name:"max_cache_size"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/watermarking.py#L70"}}),ir=new C({props:{anchor:"transformers.WatermarkDetector.example",$$slots:{default:[_U]},$$scope:{ctx:j}}}),pi=new M({props:{name:"__call__",anchor:"transformers.WatermarkDetector.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"z_threshold",val:": float = 3.0"},{name:"return_dict",val:": bool = False"}],parametersDescription:[{anchor:"transformers.WatermarkDetector.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
The watermark generated text. It is advised to remove the prompt, which can affect the detection.`,name:"input_ids"},{anchor:"transformers.WatermarkDetector.__call__.z_threshold",description:`<strong>z_threshold</strong> (<code>Dict</code>, <em>optional</em>, defaults to <code>3.0</code>) &#x2014;
Changing this threshold will change the sensitivity of the detector. Higher z threshold gives less
sensitivity and vice versa for lower z threshold.`,name:"z_threshold"},{anchor:"transformers.WatermarkDetector.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>,  <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to return <code>~generation.WatermarkDetectorOutput</code> or not. If not it will return boolean predictions,`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_30950/src/transformers/generation/watermarking.py#L190",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>WatermarkDetectorOutput</code>
if <code>return_dict=True</code> otherwise a <code>np.array</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>WatermarkDetectorOutput</code> or <code>np.array</code></p>
`}}),mi=new vJ({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/internal/generation_utils.md"}}),{c(){c=o("meta"),$=r(),b=o("p"),p=r(),m(w.$$.fragment),s=r(),k=o("p"),k.innerHTML=l1,Xu=r(),m(Mr.$$.fragment),Lu=r(),wr=o("p"),wr.innerHTML=c1,Ru=r(),kr=o("p"),kr.textContent=i1,Su=r(),m($r.$$.fragment),Nu=r(),jr=o("p"),jr.innerHTML=d1,Hu=r(),xr=o("ul"),xr.innerHTML=p1,Eu=r(),Jr=o("p"),Jr.innerHTML=m1,qu=r(),Ur=o("p"),Ur.innerHTML=h1,Qu=r(),Zr=o("p"),Zr.innerHTML=g1,Du=r(),m(Cr.$$.fragment),Yu=r(),Wr=o("p"),Wr.innerHTML=u1,Pu=r(),Br=o("p"),Br.innerHTML=f1,Au=r(),zr=o("p"),zr.textContent=_1,Ou=r(),m(Ir.$$.fragment),Ku=r(),ts=o("div"),m(Vr.$$.fragment),cy=r(),Zi=o("p"),Zi.textContent=b1,ef=r(),ss=o("div"),m(Gr.$$.fragment),iy=r(),Ci=o("p"),Ci.textContent=y1,tf=r(),ns=o("div"),m(Fr.$$.fragment),dy=r(),Wi=o("p"),Wi.textContent=T1,sf=r(),rs=o("div"),m(Xr.$$.fragment),py=r(),Bi=o("p"),Bi.textContent=v1,nf=r(),m(Lr.$$.fragment),rf=r(),as=o("div"),m(Rr.$$.fragment),my=r(),zi=o("p"),zi.textContent=M1,af=r(),os=o("div"),m(Sr.$$.fragment),hy=r(),Ii=o("p"),Ii.textContent=w1,of=r(),ls=o("div"),m(Nr.$$.fragment),gy=r(),Vi=o("p"),Vi.textContent=k1,lf=r(),cs=o("div"),m(Hr.$$.fragment),uy=r(),Gi=o("p"),Gi.textContent=$1,cf=r(),is=o("div"),m(Er.$$.fragment),fy=r(),Fi=o("p"),Fi.textContent=j1,df=r(),ds=o("div"),m(qr.$$.fragment),_y=r(),Xi=o("p"),Xi.textContent=x1,pf=r(),ps=o("div"),m(Qr.$$.fragment),by=r(),Li=o("p"),Li.textContent=J1,mf=r(),ms=o("div"),m(Dr.$$.fragment),yy=r(),Ri=o("p"),Ri.textContent=U1,hf=r(),hs=o("div"),m(Yr.$$.fragment),Ty=r(),Si=o("p"),Si.textContent=Z1,gf=r(),gs=o("div"),m(Pr.$$.fragment),vy=r(),Ni=o("p"),Ni.textContent=C1,uf=r(),m(Ar.$$.fragment),ff=r(),De=o("div"),m(Or.$$.fragment),My=r(),Hi=o("p"),Hi.textContent=W1,wy=r(),ws=o("div"),m(Kr.$$.fragment),ky=r(),Ei=o("p"),Ei.textContent=B1,_f=r(),Ye=o("div"),m(ea.$$.fragment),$y=r(),qi=o("p"),qi.textContent=z1,jy=r(),ks=o("div"),m(ta.$$.fragment),xy=r(),Qi=o("p"),Qi.textContent=I1,bf=r(),Pe=o("div"),m(sa.$$.fragment),Jy=r(),Di=o("p"),Di.textContent=V1,Uy=r(),$s=o("div"),m(na.$$.fragment),Zy=r(),Yi=o("p"),Yi.textContent=G1,yf=r(),m(ra.$$.fragment),Tf=r(),aa=o("p"),aa.innerHTML=F1,vf=r(),m(oa.$$.fragment),Mf=r(),_e=o("div"),m(la.$$.fragment),Cy=r(),Pi=o("p"),Pi.innerHTML=X1,Wy=r(),m(js.$$.fragment),By=r(),Ai=o("div"),m(ca.$$.fragment),wf=r(),L=o("div"),m(ia.$$.fragment),zy=r(),Oi=o("p"),Oi.innerHTML=L1,Iy=r(),Ki=o("p"),Ki.innerHTML=R1,Vy=r(),m(xs.$$.fragment),Gy=r(),m(Js.$$.fragment),Fy=r(),ed=o("div"),m(da.$$.fragment),kf=r(),ee=o("div"),m(pa.$$.fragment),Xy=r(),td=o("p"),td.innerHTML=S1,Ly=r(),sd=o("p"),sd.textContent=N1,Ry=r(),m(Us.$$.fragment),Sy=r(),nd=o("div"),m(ma.$$.fragment),$f=r(),te=o("div"),m(ha.$$.fragment),Ny=r(),rd=o("p"),rd.innerHTML=H1,Hy=r(),ad=o("p"),ad.textContent=E1,Ey=r(),m(Zs.$$.fragment),qy=r(),od=o("div"),m(ga.$$.fragment),jf=r(),be=o("div"),m(ua.$$.fragment),Qy=r(),ld=o("p"),ld.innerHTML=q1,Dy=r(),m(Cs.$$.fragment),Yy=r(),cd=o("div"),m(fa.$$.fragment),xf=r(),ye=o("div"),m(_a.$$.fragment),Py=r(),id=o("p"),id.innerHTML=Q1,Ay=r(),m(Ws.$$.fragment),Oy=r(),dd=o("div"),m(ba.$$.fragment),Jf=r(),Te=o("div"),m(ya.$$.fragment),Ky=r(),pd=o("p"),pd.innerHTML=D1,eT=r(),m(Bs.$$.fragment),tT=r(),md=o("div"),m(Ta.$$.fragment),Uf=r(),ve=o("div"),m(va.$$.fragment),sT=r(),hd=o("p"),hd.innerHTML=Y1,nT=r(),m(zs.$$.fragment),rT=r(),gd=o("div"),m(Ma.$$.fragment),Zf=r(),Me=o("div"),m(wa.$$.fragment),aT=r(),ud=o("p"),ud.innerHTML=P1,oT=r(),m(Is.$$.fragment),lT=r(),fd=o("div"),m(ka.$$.fragment),Cf=r(),R=o("div"),m($a.$$.fragment),cT=r(),_d=o("p"),_d.innerHTML=A1,iT=r(),bd=o("p"),bd.innerHTML=O1,dT=r(),yd=o("p"),yd.innerHTML=K1,pT=r(),m(Vs.$$.fragment),mT=r(),Td=o("div"),m(ja.$$.fragment),Wf=r(),we=o("div"),m(xa.$$.fragment),hT=r(),vd=o("p"),vd.innerHTML=ek,gT=r(),Md=o("p"),Md.innerHTML=tk,uT=r(),wd=o("div"),m(Ja.$$.fragment),Bf=r(),ke=o("div"),m(Ua.$$.fragment),fT=r(),kd=o("p"),kd.innerHTML=sk,_T=r(),m(Gs.$$.fragment),bT=r(),$d=o("div"),m(Za.$$.fragment),zf=r(),Ae=o("div"),m(Ca.$$.fragment),yT=r(),jd=o("p"),jd.textContent=nk,TT=r(),xd=o("div"),m(Wa.$$.fragment),If=r(),Oe=o("div"),m(Ba.$$.fragment),vT=r(),Jd=o("p"),Jd.innerHTML=rk,MT=r(),Ud=o("div"),m(za.$$.fragment),Vf=r(),$e=o("div"),m(Ia.$$.fragment),wT=r(),Zd=o("p"),Zd.innerHTML=ak,kT=r(),m(Fs.$$.fragment),$T=r(),Cd=o("div"),m(Va.$$.fragment),Gf=r(),je=o("div"),m(Ga.$$.fragment),jT=r(),Wd=o("p"),Wd.innerHTML=ok,xT=r(),m(Xs.$$.fragment),JT=r(),Bd=o("div"),m(Fa.$$.fragment),Ff=r(),S=o("div"),m(Xa.$$.fragment),UT=r(),zd=o("p"),zd.innerHTML=lk,ZT=r(),Id=o("p"),Id.innerHTML=ck,CT=r(),Vd=o("p"),Vd.innerHTML=ik,WT=r(),m(Ls.$$.fragment),BT=r(),Gd=o("div"),m(La.$$.fragment),Xf=r(),se=o("div"),m(Ra.$$.fragment),zT=r(),Fd=o("p"),Fd.innerHTML=dk,IT=r(),m(Rs.$$.fragment),VT=r(),m(Ss.$$.fragment),GT=r(),Xd=o("div"),m(Sa.$$.fragment),Lf=r(),ne=o("div"),m(Na.$$.fragment),FT=r(),Ld=o("p"),Ld.innerHTML=pk,XT=r(),m(Ns.$$.fragment),LT=r(),m(Hs.$$.fragment),RT=r(),Rd=o("div"),m(Ha.$$.fragment),Rf=r(),xe=o("div"),m(Ea.$$.fragment),ST=r(),Sd=o("p"),Sd.innerHTML=mk,NT=r(),m(Es.$$.fragment),HT=r(),Nd=o("div"),m(qa.$$.fragment),Sf=r(),re=o("div"),m(Qa.$$.fragment),ET=r(),Hd=o("p"),Hd.innerHTML=hk,qT=r(),Ed=o("p"),Ed.innerHTML=gk,QT=r(),m(qs.$$.fragment),DT=r(),qd=o("div"),m(Da.$$.fragment),Nf=r(),ae=o("div"),m(Ya.$$.fragment),YT=r(),Qd=o("p"),Qd.innerHTML=uk,PT=r(),m(Qs.$$.fragment),AT=r(),m(Ds.$$.fragment),OT=r(),Dd=o("div"),m(Pa.$$.fragment),Hf=r(),Je=o("div"),m(Aa.$$.fragment),KT=r(),Yd=o("p"),Yd.innerHTML=fk,ev=r(),m(Ys.$$.fragment),tv=r(),Pd=o("div"),m(Oa.$$.fragment),Ef=r(),Ue=o("div"),m(Ka.$$.fragment),sv=r(),Ad=o("p"),Ad.innerHTML=_k,nv=r(),m(Ps.$$.fragment),rv=r(),Od=o("div"),m(eo.$$.fragment),qf=r(),oe=o("div"),m(to.$$.fragment),av=r(),Kd=o("p"),Kd.innerHTML=bk,ov=r(),m(As.$$.fragment),lv=r(),m(Os.$$.fragment),cv=r(),ep=o("div"),m(so.$$.fragment),Qf=r(),Ze=o("div"),m(no.$$.fragment),iv=r(),tp=o("p"),tp.innerHTML=yk,dv=r(),m(Ks.$$.fragment),pv=r(),sp=o("div"),m(ro.$$.fragment),Df=r(),Ce=o("div"),m(ao.$$.fragment),mv=r(),np=o("p"),np.innerHTML=Tk,hv=r(),m(en.$$.fragment),gv=r(),rp=o("div"),m(oo.$$.fragment),Yf=r(),le=o("div"),m(lo.$$.fragment),uv=r(),ap=o("p"),ap.innerHTML=vk,fv=r(),op=o("p"),op.innerHTML=Mk,_v=r(),m(tn.$$.fragment),bv=r(),lp=o("div"),m(co.$$.fragment),Pf=r(),ce=o("div"),m(io.$$.fragment),yv=r(),cp=o("p"),cp.innerHTML=wk,Tv=r(),ip=o("p"),ip.innerHTML=kk,vv=r(),m(sn.$$.fragment),Mv=r(),dp=o("div"),m(po.$$.fragment),Af=r(),ie=o("div"),m(mo.$$.fragment),wv=r(),pp=o("p"),pp.innerHTML=$k,kv=r(),mp=o("p"),mp.innerHTML=jk,$v=r(),m(nn.$$.fragment),jv=r(),hp=o("div"),m(ho.$$.fragment),Of=r(),N=o("div"),m(go.$$.fragment),xv=r(),gp=o("p"),gp.innerHTML=xk,Jv=r(),up=o("p"),up.innerHTML=Jk,Uv=r(),fp=o("p"),fp.innerHTML=Uk,Zv=r(),m(rn.$$.fragment),Cv=r(),_p=o("div"),m(uo.$$.fragment),Kf=r(),m(fo.$$.fragment),e_=r(),Ke=o("div"),m(_o.$$.fragment),Wv=r(),bp=o("p"),bp.innerHTML=Zk,Bv=r(),yp=o("div"),m(bo.$$.fragment),t_=r(),et=o("div"),m(yo.$$.fragment),zv=r(),Tp=o("p"),Tp.innerHTML=Ck,Iv=r(),vp=o("div"),m(To.$$.fragment),s_=r(),tt=o("div"),m(vo.$$.fragment),Vv=r(),Mp=o("p"),Mp.innerHTML=Wk,Gv=r(),wp=o("div"),m(Mo.$$.fragment),n_=r(),st=o("div"),m(wo.$$.fragment),Fv=r(),kp=o("p"),kp.textContent=Bk,Xv=r(),an=o("div"),m(ko.$$.fragment),Lv=r(),$p=o("p"),$p.textContent=zk,r_=r(),nt=o("div"),m($o.$$.fragment),Rv=r(),jp=o("p"),jp.innerHTML=Ik,Sv=r(),xp=o("div"),m(jo.$$.fragment),a_=r(),rt=o("div"),m(xo.$$.fragment),Nv=r(),Jp=o("p"),Jp.textContent=Vk,Hv=r(),on=o("div"),m(Jo.$$.fragment),Ev=r(),Up=o("p"),Up.textContent=Gk,o_=r(),at=o("div"),m(Uo.$$.fragment),qv=r(),Zp=o("p"),Zp.innerHTML=Fk,Qv=r(),Cp=o("div"),m(Zo.$$.fragment),l_=r(),ot=o("div"),m(Co.$$.fragment),Dv=r(),Wp=o("p"),Wp.innerHTML=Xk,Yv=r(),Bp=o("div"),m(Wo.$$.fragment),c_=r(),lt=o("div"),m(Bo.$$.fragment),Pv=r(),zp=o("p"),zp.innerHTML=Lk,Av=r(),Ip=o("div"),m(zo.$$.fragment),i_=r(),ct=o("div"),m(Io.$$.fragment),Ov=r(),Vp=o("p"),Vp.innerHTML=Rk,Kv=r(),Gp=o("div"),m(Vo.$$.fragment),d_=r(),it=o("div"),m(Go.$$.fragment),eM=r(),Fp=o("p"),Fp.innerHTML=Sk,tM=r(),Xp=o("div"),m(Fo.$$.fragment),p_=r(),dt=o("div"),m(Xo.$$.fragment),sM=r(),Lp=o("p"),Lp.innerHTML=Nk,nM=r(),Rp=o("div"),m(Lo.$$.fragment),m_=r(),pt=o("div"),m(Ro.$$.fragment),rM=r(),Sp=o("p"),Sp.innerHTML=Hk,aM=r(),Np=o("div"),m(So.$$.fragment),h_=r(),mt=o("div"),m(No.$$.fragment),oM=r(),Hp=o("p"),Hp.innerHTML=Ek,lM=r(),Ep=o("div"),m(Ho.$$.fragment),g_=r(),ht=o("div"),m(Eo.$$.fragment),cM=r(),qp=o("p"),qp.innerHTML=qk,iM=r(),Qp=o("div"),m(qo.$$.fragment),u_=r(),m(Qo.$$.fragment),f_=r(),gt=o("div"),m(Do.$$.fragment),dM=r(),Dp=o("p"),Dp.innerHTML=Qk,pM=r(),Yp=o("div"),m(Yo.$$.fragment),__=r(),ut=o("div"),m(Po.$$.fragment),mM=r(),Pp=o("p"),Pp.innerHTML=Dk,hM=r(),Ap=o("div"),m(Ao.$$.fragment),b_=r(),ft=o("div"),m(Oo.$$.fragment),gM=r(),Op=o("p"),Op.innerHTML=Yk,uM=r(),Kp=o("div"),m(Ko.$$.fragment),y_=r(),_t=o("div"),m(el.$$.fragment),fM=r(),em=o("p"),em.textContent=Pk,_M=r(),ln=o("div"),m(tl.$$.fragment),bM=r(),tm=o("p"),tm.textContent=Ak,T_=r(),bt=o("div"),m(sl.$$.fragment),yM=r(),sm=o("p"),sm.innerHTML=Ok,TM=r(),nm=o("div"),m(nl.$$.fragment),v_=r(),yt=o("div"),m(rl.$$.fragment),vM=r(),rm=o("p"),rm.textContent=Kk,MM=r(),cn=o("div"),m(al.$$.fragment),wM=r(),am=o("p"),am.textContent=e$,M_=r(),Tt=o("div"),m(ol.$$.fragment),kM=r(),om=o("p"),om.innerHTML=t$,$M=r(),lm=o("div"),m(ll.$$.fragment),w_=r(),vt=o("div"),m(cl.$$.fragment),jM=r(),cm=o("p"),cm.innerHTML=s$,xM=r(),im=o("div"),m(il.$$.fragment),k_=r(),Mt=o("div"),m(dl.$$.fragment),JM=r(),dm=o("p"),dm.innerHTML=n$,UM=r(),pm=o("div"),m(pl.$$.fragment),$_=r(),wt=o("div"),m(ml.$$.fragment),ZM=r(),mm=o("p"),mm.innerHTML=r$,CM=r(),hm=o("div"),m(hl.$$.fragment),j_=r(),kt=o("div"),m(gl.$$.fragment),WM=r(),gm=o("p"),gm.innerHTML=a$,BM=r(),um=o("div"),m(ul.$$.fragment),x_=r(),$t=o("div"),m(fl.$$.fragment),zM=r(),fm=o("p"),fm.innerHTML=o$,IM=r(),_m=o("div"),m(_l.$$.fragment),J_=r(),jt=o("div"),m(bl.$$.fragment),VM=r(),bm=o("p"),bm.innerHTML=l$,GM=r(),ym=o("div"),m(yl.$$.fragment),U_=r(),m(Tl.$$.fragment),Z_=r(),vl=o("p"),vl.innerHTML=c$,C_=r(),We=o("div"),m(Ml.$$.fragment),FM=r(),Tm=o("p"),Tm.textContent=i$,XM=r(),vm=o("p"),vm.innerHTML=d$,LM=r(),Mm=o("div"),m(wl.$$.fragment),W_=r(),us=o("div"),m(kl.$$.fragment),RM=r(),wm=o("div"),m($l.$$.fragment),B_=r(),xt=o("div"),m(jl.$$.fragment),SM=r(),km=o("p"),km.innerHTML=p$,NM=r(),$m=o("div"),m(xl.$$.fragment),z_=r(),Jt=o("div"),m(Jl.$$.fragment),HM=r(),jm=o("p"),jm.innerHTML=m$,EM=r(),xm=o("div"),m(Ul.$$.fragment),I_=r(),J=o("div"),m(Zl.$$.fragment),qM=r(),Jm=o("p"),Jm.textContent=h$,QM=r(),Um=o("p"),Um.textContent=g$,DM=r(),Zm=o("ul"),Zm.innerHTML=u$,YM=r(),Cm=o("p"),Cm.textContent=f$,PM=r(),Wm=o("ul"),Wm.innerHTML=_$,AM=r(),Bm=o("p"),Bm.textContent=b$,OM=r(),zm=o("p"),zm.textContent=y$,KM=r(),Im=o("p"),Im.textContent=T$,e0=r(),Vm=o("ul"),Vm.innerHTML=v$,t0=r(),Gm=o("p"),Gm.textContent=M$,s0=r(),Fm=o("p"),Fm.textContent=w$,n0=r(),Xm=o("p"),Xm.textContent=k$,r0=r(),Lm=o("p"),Lm.textContent=$$,a0=r(),Rm=o("ul"),Rm.innerHTML=j$,o0=r(),Sm=o("p"),Sm.textContent=x$,l0=r(),Nm=o("p"),Nm.textContent=J$,c0=r(),Hm=o("ul"),Hm.innerHTML=U$,i0=r(),Em=o("p"),Em.textContent=Z$,d0=r(),qm=o("p"),qm.textContent=C$,p0=r(),m(dn.$$.fragment),m0=r(),Qm=o("div"),m(Cl.$$.fragment),V_=r(),Ut=o("div"),m(Wl.$$.fragment),h0=r(),Dm=o("p"),Dm.innerHTML=W$,g0=r(),Ym=o("div"),m(Bl.$$.fragment),G_=r(),m(zl.$$.fragment),F_=r(),Il=o("p"),Il.innerHTML=B$,X_=r(),W=o("div"),m(Vl.$$.fragment),u0=r(),Pm=o("p"),Pm.textContent=z$,f0=r(),Am=o("p"),Am.textContent=I$,_0=r(),m(pn.$$.fragment),b0=r(),Om=o("p"),Om.textContent=V$,y0=r(),mn=o("div"),m(Gl.$$.fragment),T0=r(),Km=o("p"),Km.textContent=G$,v0=r(),hn=o("div"),m(Fl.$$.fragment),M0=r(),eh=o("p"),eh.textContent=F$,w0=r(),gn=o("div"),m(Xl.$$.fragment),k0=r(),th=o("p"),th.textContent=X$,$0=r(),un=o("div"),m(Ll.$$.fragment),j0=r(),sh=o("p"),sh.innerHTML=L$,x0=r(),fn=o("div"),m(Rl.$$.fragment),J0=r(),nh=o("p"),nh.textContent=R$,U0=r(),_n=o("div"),m(Sl.$$.fragment),Z0=r(),rh=o("p"),rh.textContent=S$,C0=r(),Ht=o("div"),m(Nl.$$.fragment),W0=r(),ah=o("p"),ah.innerHTML=N$,B0=r(),oh=o("p"),oh.textContent=H$,L_=r(),fs=o("div"),m(Hl.$$.fragment),z0=r(),lh=o("p"),lh.innerHTML=E$,R_=r(),_s=o("div"),m(El.$$.fragment),I0=r(),ch=o("p"),ch.innerHTML=q$,S_=r(),Be=o("div"),m(ql.$$.fragment),V0=r(),ih=o("p"),ih.textContent=Q$,G0=r(),A=o("div"),m(Ql.$$.fragment),F0=r(),dh=o("p"),dh.textContent=D$,X0=r(),ph=o("p"),ph.innerHTML=Y$,L0=r(),mh=o("p"),mh.innerHTML=P$,R0=r(),hh=o("p"),hh.innerHTML=A$,S0=r(),gh=o("p"),gh.textContent=O$,N0=r(),bn=o("div"),m(Dl.$$.fragment),H0=r(),uh=o("p"),uh.textContent=K$,N_=r(),m(Yl.$$.fragment),H_=r(),ze=o("div"),m(Pl.$$.fragment),E0=r(),fh=o("p"),fh.innerHTML=ej,q0=r(),_h=o("div"),m(Al.$$.fragment),Q0=r(),bh=o("div"),m(Ol.$$.fragment),E_=r(),H=o("div"),m(Kl.$$.fragment),D0=r(),yh=o("p"),yh.innerHTML=tj,Y0=r(),Th=o("p"),Th.innerHTML=sj,P0=r(),vh=o("p"),vh.innerHTML=nj,A0=r(),Mh=o("div"),m(ec.$$.fragment),O0=r(),wh=o("div"),m(tc.$$.fragment),q_=r(),Ie=o("div"),m(sc.$$.fragment),K0=r(),kh=o("p"),kh.innerHTML=rj,ew=r(),$h=o("div"),m(nc.$$.fragment),tw=r(),jh=o("div"),m(rc.$$.fragment),Q_=r(),m(ac.$$.fragment),D_=r(),G=o("div"),m(oc.$$.fragment),sw=r(),xh=o("p"),xh.textContent=aj,nw=r(),m(yn.$$.fragment),rw=r(),m(Tn.$$.fragment),aw=r(),vn=o("div"),m(lc.$$.fragment),ow=r(),Jh=o("p"),Jh.textContent=oj,lw=r(),Mn=o("div"),m(cc.$$.fragment),cw=r(),Uh=o("p"),Uh.textContent=lj,iw=r(),wn=o("div"),m(ic.$$.fragment),dw=r(),Zh=o("p"),Zh.textContent=cj,Y_=r(),de=o("div"),m(dc.$$.fragment),pw=r(),Ch=o("p"),Ch.textContent=ij,mw=r(),m(kn.$$.fragment),hw=r(),m($n.$$.fragment),gw=r(),jn=o("div"),m(pc.$$.fragment),uw=r(),Wh=o("p"),Wh.textContent=dj,P_=r(),m(mc.$$.fragment),A_=r(),Zt=o("div"),m(hc.$$.fragment),fw=r(),Bh=o("p"),Bh.textContent=pj,_w=r(),xn=o("div"),m(gc.$$.fragment),bw=r(),zh=o("p"),zh.innerHTML=mj,O_=r(),Ct=o("div"),m(uc.$$.fragment),yw=r(),Ih=o("p"),Ih.textContent=hj,Tw=r(),Jn=o("div"),m(fc.$$.fragment),vw=r(),Vh=o("p"),Vh.innerHTML=gj,K_=r(),Wt=o("div"),m(_c.$$.fragment),Mw=r(),Gh=o("p"),Gh.textContent=uj,ww=r(),Un=o("div"),m(bc.$$.fragment),kw=r(),Fh=o("p"),Fh.textContent=fj,eb=r(),z=o("div"),m(yc.$$.fragment),$w=r(),Xh=o("p"),Xh.textContent=_j,jw=r(),Lh=o("p"),Lh.innerHTML=bj,xw=r(),m(Zn.$$.fragment),Jw=r(),Cn=o("div"),m(Tc.$$.fragment),Uw=r(),Rh=o("p"),Rh.innerHTML=yj,Zw=r(),Wn=o("div"),m(vc.$$.fragment),Cw=r(),Sh=o("p"),Sh.textContent=Tj,Ww=r(),Bn=o("div"),m(Mc.$$.fragment),Bw=r(),Nh=o("p"),Nh.textContent=vj,zw=r(),zn=o("div"),m(wc.$$.fragment),Iw=r(),Hh=o("p"),Hh.innerHTML=Mj,Vw=r(),In=o("div"),m(kc.$$.fragment),Gw=r(),Eh=o("p"),Eh.innerHTML=wj,tb=r(),E=o("div"),m($c.$$.fragment),Fw=r(),qh=o("p"),qh.innerHTML=kj,Xw=r(),Qh=o("p"),Qh.innerHTML=$j,Lw=r(),Dh=o("p"),Dh.innerHTML=jj,Rw=r(),Yh=o("div"),m(jc.$$.fragment),Sw=r(),Vn=o("div"),m(xc.$$.fragment),Nw=r(),Ph=o("p"),Ph.textContent=xj,sb=r(),Bt=o("div"),m(Jc.$$.fragment),Hw=r(),Ah=o("p"),Ah.innerHTML=Jj,Ew=r(),m(Gn.$$.fragment),nb=r(),zt=o("div"),m(Uc.$$.fragment),qw=r(),Oh=o("p"),Oh.innerHTML=Uj,Qw=r(),m(Fn.$$.fragment),rb=r(),F=o("div"),m(Zc.$$.fragment),Dw=r(),Kh=o("p"),Kh.innerHTML=Zj,Yw=r(),eg=o("p"),eg.innerHTML=Cj,Pw=r(),m(Xn.$$.fragment),Aw=r(),Ln=o("div"),m(Cc.$$.fragment),Ow=r(),tg=o("p"),tg.innerHTML=Wj,Kw=r(),Rn=o("div"),m(Wc.$$.fragment),e2=r(),sg=o("p"),sg.textContent=Bj,t2=r(),Sn=o("div"),m(Bc.$$.fragment),s2=r(),ng=o("p"),ng.textContent=zj,ab=r(),q=o("div"),m(zc.$$.fragment),n2=r(),rg=o("p"),rg.textContent=Ij,r2=r(),ag=o("p"),ag.textContent=Vj,a2=r(),Nn=o("div"),m(Ic.$$.fragment),o2=r(),og=o("p"),og.innerHTML=Gj,l2=r(),Hn=o("div"),m(Vc.$$.fragment),c2=r(),lg=o("p"),lg.textContent=Fj,i2=r(),En=o("div"),m(Gc.$$.fragment),d2=r(),cg=o("p"),cg.textContent=Xj,ob=r(),Q=o("div"),m(Fc.$$.fragment),p2=r(),ig=o("p"),ig.innerHTML=Lj,m2=r(),m(qn.$$.fragment),h2=r(),Qn=o("div"),m(Xc.$$.fragment),g2=r(),dg=o("p"),dg.innerHTML=Rj,u2=r(),Dn=o("div"),m(Lc.$$.fragment),f2=r(),pg=o("p"),pg.textContent=Sj,_2=r(),Yn=o("div"),m(Rc.$$.fragment),b2=r(),mg=o("p"),mg.textContent=Nj,lb=r(),D=o("div"),m(Sc.$$.fragment),y2=r(),hg=o("p"),hg.innerHTML=Hj,T2=r(),m(Pn.$$.fragment),v2=r(),An=o("div"),m(Nc.$$.fragment),M2=r(),gg=o("p"),gg.innerHTML=Ej,w2=r(),On=o("div"),m(Hc.$$.fragment),k2=r(),ug=o("p"),ug.textContent=qj,$2=r(),Kn=o("div"),m(Ec.$$.fragment),j2=r(),fg=o("p"),fg.textContent=Qj,cb=r(),Y=o("div"),m(qc.$$.fragment),x2=r(),_g=o("p"),_g.innerHTML=Dj,J2=r(),m(er.$$.fragment),U2=r(),bg=o("div"),m(Qc.$$.fragment),Z2=r(),yg=o("div"),m(Dc.$$.fragment),C2=r(),tr=o("div"),m(Yc.$$.fragment),W2=r(),Tg=o("p"),Tg.textContent=Yj,ib=r(),I=o("div"),m(Pc.$$.fragment),B2=r(),vg=o("p"),vg.innerHTML=Pj,z2=r(),Mg=o("p"),Mg.innerHTML=Aj,I2=r(),wg=o("p"),wg.textContent=Oj,V2=r(),kg=o("p"),kg.innerHTML=Kj,G2=r(),m(sr.$$.fragment),F2=r(),$g=o("div"),m(Ac.$$.fragment),X2=r(),jg=o("div"),m(Oc.$$.fragment),db=r(),V=o("div"),m(Kc.$$.fragment),L2=r(),xg=o("p"),xg.textContent=ex,R2=r(),m(nr.$$.fragment),S2=r(),rr=o("div"),m(ei.$$.fragment),N2=r(),Jg=o("p"),Jg.textContent=tx,H2=r(),ar=o("div"),m(ti.$$.fragment),E2=r(),Ug=o("p"),Ug.innerHTML=sx,q2=r(),or=o("div"),m(si.$$.fragment),Q2=r(),Zg=o("p"),Zg.innerHTML=nx,D2=r(),Cg=o("div"),m(ni.$$.fragment),Y2=r(),lr=o("div"),m(ri.$$.fragment),P2=r(),Wg=o("p"),Wg.textContent=rx,pb=r(),P=o("div"),m(ai.$$.fragment),A2=r(),Bg=o("p"),Bg.textContent=ax,O2=r(),m(cr.$$.fragment),K2=r(),zg=o("div"),m(oi.$$.fragment),e1=r(),Ig=o("div"),m(li.$$.fragment),t1=r(),Vg=o("div"),m(ci.$$.fragment),mb=r(),m(ii.$$.fragment),hb=r(),pe=o("div"),m(di.$$.fragment),s1=r(),Gg=o("p"),Gg.innerHTML=ox,n1=r(),Fg=o("p"),Fg.innerHTML=lx,r1=r(),m(ir.$$.fragment),a1=r(),dr=o("div"),m(pi.$$.fragment),o1=r(),Xg=o("p"),Xg.textContent=cx,gb=r(),m(mi.$$.fragment),ub=r(),wu=o("p"),this.h()},l(e){const i=TJ("svelte-u9bgzb",document.head);c=l(i,"META",{name:!0,content:!0}),i.forEach(n),$=a(e),b=l(e,"P",{}),T(b).forEach(n),p=a(e),h(w.$$.fragment,e),s=a(e),k=l(e,"P",{"data-svelte-h":!0}),y(k)!=="svelte-r4gg2f"&&(k.innerHTML=l1),Xu=a(e),h(Mr.$$.fragment,e),Lu=a(e),wr=l(e,"P",{"data-svelte-h":!0}),y(wr)!=="svelte-1bi0hj9"&&(wr.innerHTML=c1),Ru=a(e),kr=l(e,"P",{"data-svelte-h":!0}),y(kr)!=="svelte-wwwyth"&&(kr.textContent=i1),Su=a(e),h($r.$$.fragment,e),Nu=a(e),jr=l(e,"P",{"data-svelte-h":!0}),y(jr)!=="svelte-wwlykk"&&(jr.innerHTML=d1),Hu=a(e),xr=l(e,"UL",{"data-svelte-h":!0}),y(xr)!=="svelte-1arpy9m"&&(xr.innerHTML=p1),Eu=a(e),Jr=l(e,"P",{"data-svelte-h":!0}),y(Jr)!=="svelte-xh59rv"&&(Jr.innerHTML=m1),qu=a(e),Ur=l(e,"P",{"data-svelte-h":!0}),y(Ur)!=="svelte-rqavqw"&&(Ur.innerHTML=h1),Qu=a(e),Zr=l(e,"P",{"data-svelte-h":!0}),y(Zr)!=="svelte-qr02he"&&(Zr.innerHTML=g1),Du=a(e),h(Cr.$$.fragment,e),Yu=a(e),Wr=l(e,"P",{"data-svelte-h":!0}),y(Wr)!=="svelte-114v74y"&&(Wr.innerHTML=u1),Pu=a(e),Br=l(e,"P",{"data-svelte-h":!0}),y(Br)!=="svelte-13knclg"&&(Br.innerHTML=f1),Au=a(e),zr=l(e,"P",{"data-svelte-h":!0}),y(zr)!=="svelte-gz8gow"&&(zr.textContent=_1),Ou=a(e),h(Ir.$$.fragment,e),Ku=a(e),ts=l(e,"DIV",{class:!0});var hi=T(ts);h(Vr.$$.fragment,hi),cy=a(hi),Zi=l(hi,"P",{"data-svelte-h":!0}),y(Zi)!=="svelte-k7oes3"&&(Zi.textContent=b1),hi.forEach(n),ef=a(e),ss=l(e,"DIV",{class:!0});var gi=T(ss);h(Gr.$$.fragment,gi),iy=a(gi),Ci=l(gi,"P",{"data-svelte-h":!0}),y(Ci)!=="svelte-111f3sj"&&(Ci.textContent=y1),gi.forEach(n),tf=a(e),ns=l(e,"DIV",{class:!0});var ui=T(ns);h(Fr.$$.fragment,ui),dy=a(ui),Wi=l(ui,"P",{"data-svelte-h":!0}),y(Wi)!=="svelte-1j3b9cp"&&(Wi.textContent=T1),ui.forEach(n),sf=a(e),rs=l(e,"DIV",{class:!0});var fi=T(rs);h(Xr.$$.fragment,fi),py=a(fi),Bi=l(fi,"P",{"data-svelte-h":!0}),y(Bi)!=="svelte-16r5px1"&&(Bi.textContent=v1),fi.forEach(n),nf=a(e),h(Lr.$$.fragment,e),rf=a(e),as=l(e,"DIV",{class:!0});var _i=T(as);h(Rr.$$.fragment,_i),my=a(_i),zi=l(_i,"P",{"data-svelte-h":!0}),y(zi)!=="svelte-1bnrp61"&&(zi.textContent=M1),_i.forEach(n),af=a(e),os=l(e,"DIV",{class:!0});var bi=T(os);h(Sr.$$.fragment,bi),hy=a(bi),Ii=l(bi,"P",{"data-svelte-h":!0}),y(Ii)!=="svelte-fenhkk"&&(Ii.textContent=w1),bi.forEach(n),of=a(e),ls=l(e,"DIV",{class:!0});var yi=T(ls);h(Nr.$$.fragment,yi),gy=a(yi),Vi=l(yi,"P",{"data-svelte-h":!0}),y(Vi)!=="svelte-1dqtgq4"&&(Vi.textContent=k1),yi.forEach(n),lf=a(e),cs=l(e,"DIV",{class:!0});var Ti=T(cs);h(Hr.$$.fragment,Ti),uy=a(Ti),Gi=l(Ti,"P",{"data-svelte-h":!0}),y(Gi)!=="svelte-10orfv5"&&(Gi.textContent=$1),Ti.forEach(n),cf=a(e),is=l(e,"DIV",{class:!0});var vi=T(is);h(Er.$$.fragment,vi),fy=a(vi),Fi=l(vi,"P",{"data-svelte-h":!0}),y(Fi)!=="svelte-jg8udg"&&(Fi.textContent=j1),vi.forEach(n),df=a(e),ds=l(e,"DIV",{class:!0});var Mi=T(ds);h(qr.$$.fragment,Mi),_y=a(Mi),Xi=l(Mi,"P",{"data-svelte-h":!0}),y(Xi)!=="svelte-1i40667"&&(Xi.textContent=x1),Mi.forEach(n),pf=a(e),ps=l(e,"DIV",{class:!0});var wi=T(ps);h(Qr.$$.fragment,wi),by=a(wi),Li=l(wi,"P",{"data-svelte-h":!0}),y(Li)!=="svelte-n5fi8x"&&(Li.textContent=J1),wi.forEach(n),mf=a(e),ms=l(e,"DIV",{class:!0});var ki=T(ms);h(Dr.$$.fragment,ki),yy=a(ki),Ri=l(ki,"P",{"data-svelte-h":!0}),y(Ri)!=="svelte-h5pj3l"&&(Ri.textContent=U1),ki.forEach(n),hf=a(e),hs=l(e,"DIV",{class:!0});var $i=T(hs);h(Yr.$$.fragment,$i),Ty=a($i),Si=l($i,"P",{"data-svelte-h":!0}),y(Si)!=="svelte-b9zq6n"&&(Si.textContent=Z1),$i.forEach(n),gf=a(e),gs=l(e,"DIV",{class:!0});var ji=T(gs);h(Pr.$$.fragment,ji),vy=a(ji),Ni=l(ji,"P",{"data-svelte-h":!0}),y(Ni)!=="svelte-pru3ks"&&(Ni.textContent=C1),ji.forEach(n),uf=a(e),h(Ar.$$.fragment,e),ff=a(e),De=l(e,"DIV",{class:!0});var bs=T(De);h(Or.$$.fragment,bs),My=a(bs),Hi=l(bs,"P",{"data-svelte-h":!0}),y(Hi)!=="svelte-qoov36"&&(Hi.textContent=W1),wy=a(bs),ws=l(bs,"DIV",{class:!0});var xi=T(ws);h(Kr.$$.fragment,xi),ky=a(xi),Ei=l(xi,"P",{"data-svelte-h":!0}),y(Ei)!=="svelte-5ihtpa"&&(Ei.textContent=B1),xi.forEach(n),bs.forEach(n),_f=a(e),Ye=l(e,"DIV",{class:!0});var ys=T(Ye);h(ea.$$.fragment,ys),$y=a(ys),qi=l(ys,"P",{"data-svelte-h":!0}),y(qi)!=="svelte-1tz7qrd"&&(qi.textContent=z1),jy=a(ys),ks=l(ys,"DIV",{class:!0});var Ji=T(ks);h(ta.$$.fragment,Ji),xy=a(Ji),Qi=l(Ji,"P",{"data-svelte-h":!0}),y(Qi)!=="svelte-5ihtpa"&&(Qi.textContent=I1),Ji.forEach(n),ys.forEach(n),bf=a(e),Pe=l(e,"DIV",{class:!0});var Ts=T(Pe);h(sa.$$.fragment,Ts),Jy=a(Ts),Di=l(Ts,"P",{"data-svelte-h":!0}),y(Di)!=="svelte-1tz7qrd"&&(Di.textContent=V1),Uy=a(Ts),$s=l(Ts,"DIV",{class:!0});var Ui=T($s);h(na.$$.fragment,Ui),Zy=a(Ui),Yi=l(Ui,"P",{"data-svelte-h":!0}),y(Yi)!=="svelte-5ihtpa"&&(Yi.textContent=G1),Ui.forEach(n),Ts.forEach(n),yf=a(e),h(ra.$$.fragment,e),Tf=a(e),aa=l(e,"P",{"data-svelte-h":!0}),y(aa)!=="svelte-xpgnyg"&&(aa.innerHTML=F1),vf=a(e),h(oa.$$.fragment,e),Mf=a(e),_e=l(e,"DIV",{class:!0});var It=T(_e);h(la.$$.fragment,It),Cy=a(It),Pi=l(It,"P",{"data-svelte-h":!0}),y(Pi)!=="svelte-1tofoov"&&(Pi.innerHTML=X1),Wy=a(It),h(js.$$.fragment,It),By=a(It),Ai=l(It,"DIV",{class:!0});var ku=T(Ai);h(ca.$$.fragment,ku),ku.forEach(n),It.forEach(n),wf=a(e),L=l(e,"DIV",{class:!0});var me=T(L);h(ia.$$.fragment,me),zy=a(me),Oi=l(me,"P",{"data-svelte-h":!0}),y(Oi)!=="svelte-15r83sk"&&(Oi.innerHTML=L1),Iy=a(me),Ki=l(me,"P",{"data-svelte-h":!0}),y(Ki)!=="svelte-lu7kru"&&(Ki.innerHTML=R1),Vy=a(me),h(xs.$$.fragment,me),Gy=a(me),h(Js.$$.fragment,me),Fy=a(me),ed=l(me,"DIV",{class:!0});var $u=T(ed);h(da.$$.fragment,$u),$u.forEach(n),me.forEach(n),kf=a(e),ee=l(e,"DIV",{class:!0});var Ve=T(ee);h(pa.$$.fragment,Ve),Xy=a(Ve),td=l(Ve,"P",{"data-svelte-h":!0}),y(td)!=="svelte-1xdiirj"&&(td.innerHTML=S1),Ly=a(Ve),sd=l(Ve,"P",{"data-svelte-h":!0}),y(sd)!=="svelte-mpy00q"&&(sd.textContent=N1),Ry=a(Ve),h(Us.$$.fragment,Ve),Sy=a(Ve),nd=l(Ve,"DIV",{class:!0});var ju=T(nd);h(ma.$$.fragment,ju),ju.forEach(n),Ve.forEach(n),$f=a(e),te=l(e,"DIV",{class:!0});var Ge=T(te);h(ha.$$.fragment,Ge),Ny=a(Ge),rd=l(Ge,"P",{"data-svelte-h":!0}),y(rd)!=="svelte-vcro9p"&&(rd.innerHTML=H1),Hy=a(Ge),ad=l(Ge,"P",{"data-svelte-h":!0}),y(ad)!=="svelte-3qpgm7"&&(ad.textContent=E1),Ey=a(Ge),h(Zs.$$.fragment,Ge),qy=a(Ge),od=l(Ge,"DIV",{class:!0});var xu=T(od);h(ga.$$.fragment,xu),xu.forEach(n),Ge.forEach(n),jf=a(e),be=l(e,"DIV",{class:!0});var Vt=T(be);h(ua.$$.fragment,Vt),Qy=a(Vt),ld=l(Vt,"P",{"data-svelte-h":!0}),y(ld)!=="svelte-1um26kr"&&(ld.innerHTML=q1),Dy=a(Vt),h(Cs.$$.fragment,Vt),Yy=a(Vt),cd=l(Vt,"DIV",{class:!0});var Ju=T(cd);h(fa.$$.fragment,Ju),Ju.forEach(n),Vt.forEach(n),xf=a(e),ye=l(e,"DIV",{class:!0});var Gt=T(ye);h(_a.$$.fragment,Gt),Py=a(Gt),id=l(Gt,"P",{"data-svelte-h":!0}),y(id)!=="svelte-zfgzwg"&&(id.innerHTML=Q1),Ay=a(Gt),h(Ws.$$.fragment,Gt),Oy=a(Gt),dd=l(Gt,"DIV",{class:!0});var Uu=T(dd);h(ba.$$.fragment,Uu),Uu.forEach(n),Gt.forEach(n),Jf=a(e),Te=l(e,"DIV",{class:!0});var Ft=T(Te);h(ya.$$.fragment,Ft),Ky=a(Ft),pd=l(Ft,"P",{"data-svelte-h":!0}),y(pd)!=="svelte-uleesu"&&(pd.innerHTML=D1),eT=a(Ft),h(Bs.$$.fragment,Ft),tT=a(Ft),md=l(Ft,"DIV",{class:!0});var Zu=T(md);h(Ta.$$.fragment,Zu),Zu.forEach(n),Ft.forEach(n),Uf=a(e),ve=l(e,"DIV",{class:!0});var Xt=T(ve);h(va.$$.fragment,Xt),sT=a(Xt),hd=l(Xt,"P",{"data-svelte-h":!0}),y(hd)!=="svelte-15pii2y"&&(hd.innerHTML=Y1),nT=a(Xt),h(zs.$$.fragment,Xt),rT=a(Xt),gd=l(Xt,"DIV",{class:!0});var Cu=T(gd);h(Ma.$$.fragment,Cu),Cu.forEach(n),Xt.forEach(n),Zf=a(e),Me=l(e,"DIV",{class:!0});var Lt=T(Me);h(wa.$$.fragment,Lt),aT=a(Lt),ud=l(Lt,"P",{"data-svelte-h":!0}),y(ud)!=="svelte-per9pa"&&(ud.innerHTML=P1),oT=a(Lt),h(Is.$$.fragment,Lt),lT=a(Lt),fd=l(Lt,"DIV",{class:!0});var Wu=T(fd);h(ka.$$.fragment,Wu),Wu.forEach(n),Lt.forEach(n),Cf=a(e),R=l(e,"DIV",{class:!0});var he=T(R);h($a.$$.fragment,he),cT=a(he),_d=l(he,"P",{"data-svelte-h":!0}),y(_d)!=="svelte-tbzhgg"&&(_d.innerHTML=A1),iT=a(he),bd=l(he,"P",{"data-svelte-h":!0}),y(bd)!=="svelte-1b0c3nk"&&(bd.innerHTML=O1),dT=a(he),yd=l(he,"P",{"data-svelte-h":!0}),y(yd)!=="svelte-2fpu88"&&(yd.innerHTML=K1),pT=a(he),h(Vs.$$.fragment,he),mT=a(he),Td=l(he,"DIV",{class:!0});var Bu=T(Td);h(ja.$$.fragment,Bu),Bu.forEach(n),he.forEach(n),Wf=a(e),we=l(e,"DIV",{class:!0});var Rt=T(we);h(xa.$$.fragment,Rt),hT=a(Rt),vd=l(Rt,"P",{"data-svelte-h":!0}),y(vd)!=="svelte-vf5cjp"&&(vd.innerHTML=ek),gT=a(Rt),Md=l(Rt,"P",{"data-svelte-h":!0}),y(Md)!=="svelte-1v3r596"&&(Md.innerHTML=tk),uT=a(Rt),wd=l(Rt,"DIV",{class:!0});var zu=T(wd);h(Ja.$$.fragment,zu),zu.forEach(n),Rt.forEach(n),Bf=a(e),ke=l(e,"DIV",{class:!0});var St=T(ke);h(Ua.$$.fragment,St),fT=a(St),kd=l(St,"P",{"data-svelte-h":!0}),y(kd)!=="svelte-twr1a1"&&(kd.innerHTML=sk),_T=a(St),h(Gs.$$.fragment,St),bT=a(St),$d=l(St,"DIV",{class:!0});var Iu=T($d);h(Za.$$.fragment,Iu),Iu.forEach(n),St.forEach(n),zf=a(e),Ae=l(e,"DIV",{class:!0});var vs=T(Ae);h(Ca.$$.fragment,vs),yT=a(vs),jd=l(vs,"P",{"data-svelte-h":!0}),y(jd)!=="svelte-y1kta5"&&(jd.textContent=nk),TT=a(vs),xd=l(vs,"DIV",{class:!0});var Vu=T(xd);h(Wa.$$.fragment,Vu),Vu.forEach(n),vs.forEach(n),If=a(e),Oe=l(e,"DIV",{class:!0});var Ms=T(Oe);h(Ba.$$.fragment,Ms),vT=a(Ms),Jd=l(Ms,"P",{"data-svelte-h":!0}),y(Jd)!=="svelte-6a563b"&&(Jd.innerHTML=rk),MT=a(Ms),Ud=l(Ms,"DIV",{class:!0});var Gu=T(Ud);h(za.$$.fragment,Gu),Gu.forEach(n),Ms.forEach(n),Vf=a(e),$e=l(e,"DIV",{class:!0});var Nt=T($e);h(Ia.$$.fragment,Nt),wT=a(Nt),Zd=l(Nt,"P",{"data-svelte-h":!0}),y(Zd)!=="svelte-5rlway"&&(Zd.innerHTML=ak),kT=a(Nt),h(Fs.$$.fragment,Nt),$T=a(Nt),Cd=l(Nt,"DIV",{class:!0});var Fu=T(Cd);h(Va.$$.fragment,Fu),Fu.forEach(n),Nt.forEach(n),Gf=a(e),je=l(e,"DIV",{class:!0});var pr=T(je);h(Ga.$$.fragment,pr),jT=a(pr),Wd=l(pr,"P",{"data-svelte-h":!0}),y(Wd)!=="svelte-psvkj3"&&(Wd.innerHTML=ok),xT=a(pr),h(Xs.$$.fragment,pr),JT=a(pr),Bd=l(pr,"DIV",{class:!0});var ix=T(Bd);h(Fa.$$.fragment,ix),ix.forEach(n),pr.forEach(n),Ff=a(e),S=l(e,"DIV",{class:!0});var Fe=T(S);h(Xa.$$.fragment,Fe),UT=a(Fe),zd=l(Fe,"P",{"data-svelte-h":!0}),y(zd)!=="svelte-1jpfgft"&&(zd.innerHTML=lk),ZT=a(Fe),Id=l(Fe,"P",{"data-svelte-h":!0}),y(Id)!=="svelte-jx5en3"&&(Id.innerHTML=ck),CT=a(Fe),Vd=l(Fe,"P",{"data-svelte-h":!0}),y(Vd)!=="svelte-1fvwhfn"&&(Vd.innerHTML=ik),WT=a(Fe),h(Ls.$$.fragment,Fe),BT=a(Fe),Gd=l(Fe,"DIV",{class:!0});var dx=T(Gd);h(La.$$.fragment,dx),dx.forEach(n),Fe.forEach(n),Xf=a(e),se=l(e,"DIV",{class:!0});var Et=T(se);h(Ra.$$.fragment,Et),zT=a(Et),Fd=l(Et,"P",{"data-svelte-h":!0}),y(Fd)!=="svelte-5mmcju"&&(Fd.innerHTML=dk),IT=a(Et),h(Rs.$$.fragment,Et),VT=a(Et),h(Ss.$$.fragment,Et),GT=a(Et),Xd=l(Et,"DIV",{class:!0});var px=T(Xd);h(Sa.$$.fragment,px),px.forEach(n),Et.forEach(n),Lf=a(e),ne=l(e,"DIV",{class:!0});var qt=T(ne);h(Na.$$.fragment,qt),FT=a(qt),Ld=l(qt,"P",{"data-svelte-h":!0}),y(Ld)!=="svelte-kizmb9"&&(Ld.innerHTML=pk),XT=a(qt),h(Ns.$$.fragment,qt),LT=a(qt),h(Hs.$$.fragment,qt),RT=a(qt),Rd=l(qt,"DIV",{class:!0});var mx=T(Rd);h(Ha.$$.fragment,mx),mx.forEach(n),qt.forEach(n),Rf=a(e),xe=l(e,"DIV",{class:!0});var mr=T(xe);h(Ea.$$.fragment,mr),ST=a(mr),Sd=l(mr,"P",{"data-svelte-h":!0}),y(Sd)!=="svelte-1wfjcle"&&(Sd.innerHTML=mk),NT=a(mr),h(Es.$$.fragment,mr),HT=a(mr),Nd=l(mr,"DIV",{class:!0});var hx=T(Nd);h(qa.$$.fragment,hx),hx.forEach(n),mr.forEach(n),Sf=a(e),re=l(e,"DIV",{class:!0});var Qt=T(re);h(Qa.$$.fragment,Qt),ET=a(Qt),Hd=l(Qt,"P",{"data-svelte-h":!0}),y(Hd)!=="svelte-8gw8xu"&&(Hd.innerHTML=hk),qT=a(Qt),Ed=l(Qt,"P",{"data-svelte-h":!0}),y(Ed)!=="svelte-qhda5i"&&(Ed.innerHTML=gk),QT=a(Qt),h(qs.$$.fragment,Qt),DT=a(Qt),qd=l(Qt,"DIV",{class:!0});var gx=T(qd);h(Da.$$.fragment,gx),gx.forEach(n),Qt.forEach(n),Nf=a(e),ae=l(e,"DIV",{class:!0});var Dt=T(ae);h(Ya.$$.fragment,Dt),YT=a(Dt),Qd=l(Dt,"P",{"data-svelte-h":!0}),y(Qd)!=="svelte-1izqd7h"&&(Qd.innerHTML=uk),PT=a(Dt),h(Qs.$$.fragment,Dt),AT=a(Dt),h(Ds.$$.fragment,Dt),OT=a(Dt),Dd=l(Dt,"DIV",{class:!0});var ux=T(Dd);h(Pa.$$.fragment,ux),ux.forEach(n),Dt.forEach(n),Hf=a(e),Je=l(e,"DIV",{class:!0});var hr=T(Je);h(Aa.$$.fragment,hr),KT=a(hr),Yd=l(hr,"P",{"data-svelte-h":!0}),y(Yd)!=="svelte-fw9muh"&&(Yd.innerHTML=fk),ev=a(hr),h(Ys.$$.fragment,hr),tv=a(hr),Pd=l(hr,"DIV",{class:!0});var fx=T(Pd);h(Oa.$$.fragment,fx),fx.forEach(n),hr.forEach(n),Ef=a(e),Ue=l(e,"DIV",{class:!0});var gr=T(Ue);h(Ka.$$.fragment,gr),sv=a(gr),Ad=l(gr,"P",{"data-svelte-h":!0}),y(Ad)!=="svelte-kp6ubc"&&(Ad.innerHTML=_k),nv=a(gr),h(Ps.$$.fragment,gr),rv=a(gr),Od=l(gr,"DIV",{class:!0});var _x=T(Od);h(eo.$$.fragment,_x),_x.forEach(n),gr.forEach(n),qf=a(e),oe=l(e,"DIV",{class:!0});var Yt=T(oe);h(to.$$.fragment,Yt),av=a(Yt),Kd=l(Yt,"P",{"data-svelte-h":!0}),y(Kd)!=="svelte-ru4wy"&&(Kd.innerHTML=bk),ov=a(Yt),h(As.$$.fragment,Yt),lv=a(Yt),h(Os.$$.fragment,Yt),cv=a(Yt),ep=l(Yt,"DIV",{class:!0});var bx=T(ep);h(so.$$.fragment,bx),bx.forEach(n),Yt.forEach(n),Qf=a(e),Ze=l(e,"DIV",{class:!0});var ur=T(Ze);h(no.$$.fragment,ur),iv=a(ur),tp=l(ur,"P",{"data-svelte-h":!0}),y(tp)!=="svelte-bndn7g"&&(tp.innerHTML=yk),dv=a(ur),h(Ks.$$.fragment,ur),pv=a(ur),sp=l(ur,"DIV",{class:!0});var yx=T(sp);h(ro.$$.fragment,yx),yx.forEach(n),ur.forEach(n),Df=a(e),Ce=l(e,"DIV",{class:!0});var fr=T(Ce);h(ao.$$.fragment,fr),mv=a(fr),np=l(fr,"P",{"data-svelte-h":!0}),y(np)!=="svelte-5dxy60"&&(np.innerHTML=Tk),hv=a(fr),h(en.$$.fragment,fr),gv=a(fr),rp=l(fr,"DIV",{class:!0});var Tx=T(rp);h(oo.$$.fragment,Tx),Tx.forEach(n),fr.forEach(n),Yf=a(e),le=l(e,"DIV",{class:!0});var Pt=T(le);h(lo.$$.fragment,Pt),uv=a(Pt),ap=l(Pt,"P",{"data-svelte-h":!0}),y(ap)!=="svelte-1crmobt"&&(ap.innerHTML=vk),fv=a(Pt),op=l(Pt,"P",{"data-svelte-h":!0}),y(op)!=="svelte-1qmimno"&&(op.innerHTML=Mk),_v=a(Pt),h(tn.$$.fragment,Pt),bv=a(Pt),lp=l(Pt,"DIV",{class:!0});var vx=T(lp);h(co.$$.fragment,vx),vx.forEach(n),Pt.forEach(n),Pf=a(e),ce=l(e,"DIV",{class:!0});var At=T(ce);h(io.$$.fragment,At),yv=a(At),cp=l(At,"P",{"data-svelte-h":!0}),y(cp)!=="svelte-1dewsn6"&&(cp.innerHTML=wk),Tv=a(At),ip=l(At,"P",{"data-svelte-h":!0}),y(ip)!=="svelte-5qs7tv"&&(ip.innerHTML=kk),vv=a(At),h(sn.$$.fragment,At),Mv=a(At),dp=l(At,"DIV",{class:!0});var Mx=T(dp);h(po.$$.fragment,Mx),Mx.forEach(n),At.forEach(n),Af=a(e),ie=l(e,"DIV",{class:!0});var Ot=T(ie);h(mo.$$.fragment,Ot),wv=a(Ot),pp=l(Ot,"P",{"data-svelte-h":!0}),y(pp)!=="svelte-e1556w"&&(pp.innerHTML=$k),kv=a(Ot),mp=l(Ot,"P",{"data-svelte-h":!0}),y(mp)!=="svelte-qmmn5t"&&(mp.innerHTML=jk),$v=a(Ot),h(nn.$$.fragment,Ot),jv=a(Ot),hp=l(Ot,"DIV",{class:!0});var wx=T(hp);h(ho.$$.fragment,wx),wx.forEach(n),Ot.forEach(n),Of=a(e),N=l(e,"DIV",{class:!0});var Xe=T(N);h(go.$$.fragment,Xe),xv=a(Xe),gp=l(Xe,"P",{"data-svelte-h":!0}),y(gp)!=="svelte-1722u08"&&(gp.innerHTML=xk),Jv=a(Xe),up=l(Xe,"P",{"data-svelte-h":!0}),y(up)!=="svelte-1w1rhk4"&&(up.innerHTML=Jk),Uv=a(Xe),fp=l(Xe,"P",{"data-svelte-h":!0}),y(fp)!=="svelte-y9hsik"&&(fp.innerHTML=Uk),Zv=a(Xe),h(rn.$$.fragment,Xe),Cv=a(Xe),_p=l(Xe,"DIV",{class:!0});var kx=T(_p);h(uo.$$.fragment,kx),kx.forEach(n),Xe.forEach(n),Kf=a(e),h(fo.$$.fragment,e),e_=a(e),Ke=l(e,"DIV",{class:!0});var Lg=T(Ke);h(_o.$$.fragment,Lg),Wv=a(Lg),bp=l(Lg,"P",{"data-svelte-h":!0}),y(bp)!=="svelte-129t082"&&(bp.innerHTML=Zk),Bv=a(Lg),yp=l(Lg,"DIV",{class:!0});var $x=T(yp);h(bo.$$.fragment,$x),$x.forEach(n),Lg.forEach(n),t_=a(e),et=l(e,"DIV",{class:!0});var Rg=T(et);h(yo.$$.fragment,Rg),zv=a(Rg),Tp=l(Rg,"P",{"data-svelte-h":!0}),y(Tp)!=="svelte-1dr4ada"&&(Tp.innerHTML=Ck),Iv=a(Rg),vp=l(Rg,"DIV",{class:!0});var jx=T(vp);h(To.$$.fragment,jx),jx.forEach(n),Rg.forEach(n),s_=a(e),tt=l(e,"DIV",{class:!0});var Sg=T(tt);h(vo.$$.fragment,Sg),Vv=a(Sg),Mp=l(Sg,"P",{"data-svelte-h":!0}),y(Mp)!=="svelte-1557waw"&&(Mp.innerHTML=Wk),Gv=a(Sg),wp=l(Sg,"DIV",{class:!0});var xx=T(wp);h(Mo.$$.fragment,xx),xx.forEach(n),Sg.forEach(n),n_=a(e),st=l(e,"DIV",{class:!0});var Ng=T(st);h(wo.$$.fragment,Ng),Fv=a(Ng),kp=l(Ng,"P",{"data-svelte-h":!0}),y(kp)!=="svelte-y1kta5"&&(kp.textContent=Bk),Xv=a(Ng),an=l(Ng,"DIV",{class:!0});var _b=T(an);h(ko.$$.fragment,_b),Lv=a(_b),$p=l(_b,"P",{"data-svelte-h":!0}),y($p)!=="svelte-5aspnb"&&($p.textContent=zk),_b.forEach(n),Ng.forEach(n),r_=a(e),nt=l(e,"DIV",{class:!0});var Hg=T(nt);h($o.$$.fragment,Hg),Rv=a(Hg),jp=l(Hg,"P",{"data-svelte-h":!0}),y(jp)!=="svelte-1yjvvyv"&&(jp.innerHTML=Ik),Sv=a(Hg),xp=l(Hg,"DIV",{class:!0});var Jx=T(xp);h(jo.$$.fragment,Jx),Jx.forEach(n),Hg.forEach(n),a_=a(e),rt=l(e,"DIV",{class:!0});var Eg=T(rt);h(xo.$$.fragment,Eg),Nv=a(Eg),Jp=l(Eg,"P",{"data-svelte-h":!0}),y(Jp)!=="svelte-th82mu"&&(Jp.textContent=Vk),Hv=a(Eg),on=l(Eg,"DIV",{class:!0});var bb=T(on);h(Jo.$$.fragment,bb),Ev=a(bb),Up=l(bb,"P",{"data-svelte-h":!0}),y(Up)!=="svelte-hcoglc"&&(Up.textContent=Gk),bb.forEach(n),Eg.forEach(n),o_=a(e),at=l(e,"DIV",{class:!0});var qg=T(at);h(Uo.$$.fragment,qg),qv=a(qg),Zp=l(qg,"P",{"data-svelte-h":!0}),y(Zp)!=="svelte-1a6ybmy"&&(Zp.innerHTML=Fk),Qv=a(qg),Cp=l(qg,"DIV",{class:!0});var Ux=T(Cp);h(Zo.$$.fragment,Ux),Ux.forEach(n),qg.forEach(n),l_=a(e),ot=l(e,"DIV",{class:!0});var Qg=T(ot);h(Co.$$.fragment,Qg),Dv=a(Qg),Wp=l(Qg,"P",{"data-svelte-h":!0}),y(Wp)!=="svelte-3sqvg7"&&(Wp.innerHTML=Xk),Yv=a(Qg),Bp=l(Qg,"DIV",{class:!0});var Zx=T(Bp);h(Wo.$$.fragment,Zx),Zx.forEach(n),Qg.forEach(n),c_=a(e),lt=l(e,"DIV",{class:!0});var Dg=T(lt);h(Bo.$$.fragment,Dg),Pv=a(Dg),zp=l(Dg,"P",{"data-svelte-h":!0}),y(zp)!=="svelte-84jqpj"&&(zp.innerHTML=Lk),Av=a(Dg),Ip=l(Dg,"DIV",{class:!0});var Cx=T(Ip);h(zo.$$.fragment,Cx),Cx.forEach(n),Dg.forEach(n),i_=a(e),ct=l(e,"DIV",{class:!0});var Yg=T(ct);h(Io.$$.fragment,Yg),Ov=a(Yg),Vp=l(Yg,"P",{"data-svelte-h":!0}),y(Vp)!=="svelte-7guh9y"&&(Vp.innerHTML=Rk),Kv=a(Yg),Gp=l(Yg,"DIV",{class:!0});var Wx=T(Gp);h(Vo.$$.fragment,Wx),Wx.forEach(n),Yg.forEach(n),d_=a(e),it=l(e,"DIV",{class:!0});var Pg=T(it);h(Go.$$.fragment,Pg),eM=a(Pg),Fp=l(Pg,"P",{"data-svelte-h":!0}),y(Fp)!=="svelte-17be4ul"&&(Fp.innerHTML=Sk),tM=a(Pg),Xp=l(Pg,"DIV",{class:!0});var Bx=T(Xp);h(Fo.$$.fragment,Bx),Bx.forEach(n),Pg.forEach(n),p_=a(e),dt=l(e,"DIV",{class:!0});var Ag=T(dt);h(Xo.$$.fragment,Ag),sM=a(Ag),Lp=l(Ag,"P",{"data-svelte-h":!0}),y(Lp)!=="svelte-a554sd"&&(Lp.innerHTML=Nk),nM=a(Ag),Rp=l(Ag,"DIV",{class:!0});var zx=T(Rp);h(Lo.$$.fragment,zx),zx.forEach(n),Ag.forEach(n),m_=a(e),pt=l(e,"DIV",{class:!0});var Og=T(pt);h(Ro.$$.fragment,Og),rM=a(Og),Sp=l(Og,"P",{"data-svelte-h":!0}),y(Sp)!=="svelte-es836t"&&(Sp.innerHTML=Hk),aM=a(Og),Np=l(Og,"DIV",{class:!0});var Ix=T(Np);h(So.$$.fragment,Ix),Ix.forEach(n),Og.forEach(n),h_=a(e),mt=l(e,"DIV",{class:!0});var Kg=T(mt);h(No.$$.fragment,Kg),oM=a(Kg),Hp=l(Kg,"P",{"data-svelte-h":!0}),y(Hp)!=="svelte-c6ywz0"&&(Hp.innerHTML=Ek),lM=a(Kg),Ep=l(Kg,"DIV",{class:!0});var Vx=T(Ep);h(Ho.$$.fragment,Vx),Vx.forEach(n),Kg.forEach(n),g_=a(e),ht=l(e,"DIV",{class:!0});var eu=T(ht);h(Eo.$$.fragment,eu),cM=a(eu),qp=l(eu,"P",{"data-svelte-h":!0}),y(qp)!=="svelte-ogyl9u"&&(qp.innerHTML=qk),iM=a(eu),Qp=l(eu,"DIV",{class:!0});var Gx=T(Qp);h(qo.$$.fragment,Gx),Gx.forEach(n),eu.forEach(n),u_=a(e),h(Qo.$$.fragment,e),f_=a(e),gt=l(e,"DIV",{class:!0});var tu=T(gt);h(Do.$$.fragment,tu),dM=a(tu),Dp=l(tu,"P",{"data-svelte-h":!0}),y(Dp)!=="svelte-1r5olnu"&&(Dp.innerHTML=Qk),pM=a(tu),Yp=l(tu,"DIV",{class:!0});var Fx=T(Yp);h(Yo.$$.fragment,Fx),Fx.forEach(n),tu.forEach(n),__=a(e),ut=l(e,"DIV",{class:!0});var su=T(ut);h(Po.$$.fragment,su),mM=a(su),Pp=l(su,"P",{"data-svelte-h":!0}),y(Pp)!=="svelte-1sccdxy"&&(Pp.innerHTML=Dk),hM=a(su),Ap=l(su,"DIV",{class:!0});var Xx=T(Ap);h(Ao.$$.fragment,Xx),Xx.forEach(n),su.forEach(n),b_=a(e),ft=l(e,"DIV",{class:!0});var nu=T(ft);h(Oo.$$.fragment,nu),gM=a(nu),Op=l(nu,"P",{"data-svelte-h":!0}),y(Op)!=="svelte-1v4imk3"&&(Op.innerHTML=Yk),uM=a(nu),Kp=l(nu,"DIV",{class:!0});var Lx=T(Kp);h(Ko.$$.fragment,Lx),Lx.forEach(n),nu.forEach(n),y_=a(e),_t=l(e,"DIV",{class:!0});var ru=T(_t);h(el.$$.fragment,ru),fM=a(ru),em=l(ru,"P",{"data-svelte-h":!0}),y(em)!=="svelte-y1kta5"&&(em.textContent=Pk),_M=a(ru),ln=l(ru,"DIV",{class:!0});var yb=T(ln);h(tl.$$.fragment,yb),bM=a(yb),tm=l(yb,"P",{"data-svelte-h":!0}),y(tm)!=="svelte-1l17mwc"&&(tm.textContent=Ak),yb.forEach(n),ru.forEach(n),T_=a(e),bt=l(e,"DIV",{class:!0});var au=T(bt);h(sl.$$.fragment,au),yM=a(au),sm=l(au,"P",{"data-svelte-h":!0}),y(sm)!=="svelte-1uevu1f"&&(sm.innerHTML=Ok),TM=a(au),nm=l(au,"DIV",{class:!0});var Rx=T(nm);h(nl.$$.fragment,Rx),Rx.forEach(n),au.forEach(n),v_=a(e),yt=l(e,"DIV",{class:!0});var ou=T(yt);h(rl.$$.fragment,ou),vM=a(ou),rm=l(ou,"P",{"data-svelte-h":!0}),y(rm)!=="svelte-th82mu"&&(rm.textContent=Kk),MM=a(ou),cn=l(ou,"DIV",{class:!0});var Tb=T(cn);h(al.$$.fragment,Tb),wM=a(Tb),am=l(Tb,"P",{"data-svelte-h":!0}),y(am)!=="svelte-1tcb5cf"&&(am.textContent=e$),Tb.forEach(n),ou.forEach(n),M_=a(e),Tt=l(e,"DIV",{class:!0});var lu=T(Tt);h(ol.$$.fragment,lu),kM=a(lu),om=l(lu,"P",{"data-svelte-h":!0}),y(om)!=="svelte-1n5b6ia"&&(om.innerHTML=t$),$M=a(lu),lm=l(lu,"DIV",{class:!0});var Sx=T(lm);h(ll.$$.fragment,Sx),Sx.forEach(n),lu.forEach(n),w_=a(e),vt=l(e,"DIV",{class:!0});var cu=T(vt);h(cl.$$.fragment,cu),jM=a(cu),cm=l(cu,"P",{"data-svelte-h":!0}),y(cm)!=="svelte-1dzx6qu"&&(cm.innerHTML=s$),xM=a(cu),im=l(cu,"DIV",{class:!0});var Nx=T(im);h(il.$$.fragment,Nx),Nx.forEach(n),cu.forEach(n),k_=a(e),Mt=l(e,"DIV",{class:!0});var iu=T(Mt);h(dl.$$.fragment,iu),JM=a(iu),dm=l(iu,"P",{"data-svelte-h":!0}),y(dm)!=="svelte-wz2mkg"&&(dm.innerHTML=n$),UM=a(iu),pm=l(iu,"DIV",{class:!0});var Hx=T(pm);h(pl.$$.fragment,Hx),Hx.forEach(n),iu.forEach(n),$_=a(e),wt=l(e,"DIV",{class:!0});var du=T(wt);h(ml.$$.fragment,du),ZM=a(du),mm=l(du,"P",{"data-svelte-h":!0}),y(mm)!=="svelte-vwzzi3"&&(mm.innerHTML=r$),CM=a(du),hm=l(du,"DIV",{class:!0});var Ex=T(hm);h(hl.$$.fragment,Ex),Ex.forEach(n),du.forEach(n),j_=a(e),kt=l(e,"DIV",{class:!0});var pu=T(kt);h(gl.$$.fragment,pu),WM=a(pu),gm=l(pu,"P",{"data-svelte-h":!0}),y(gm)!=="svelte-11phk8u"&&(gm.innerHTML=a$),BM=a(pu),um=l(pu,"DIV",{class:!0});var qx=T(um);h(ul.$$.fragment,qx),qx.forEach(n),pu.forEach(n),x_=a(e),$t=l(e,"DIV",{class:!0});var mu=T($t);h(fl.$$.fragment,mu),zM=a(mu),fm=l(mu,"P",{"data-svelte-h":!0}),y(fm)!=="svelte-1utltb4"&&(fm.innerHTML=o$),IM=a(mu),_m=l(mu,"DIV",{class:!0});var Qx=T(_m);h(_l.$$.fragment,Qx),Qx.forEach(n),mu.forEach(n),J_=a(e),jt=l(e,"DIV",{class:!0});var hu=T(jt);h(bl.$$.fragment,hu),VM=a(hu),bm=l(hu,"P",{"data-svelte-h":!0}),y(bm)!=="svelte-1sygpwz"&&(bm.innerHTML=l$),GM=a(hu),ym=l(hu,"DIV",{class:!0});var Dx=T(ym);h(yl.$$.fragment,Dx),Dx.forEach(n),hu.forEach(n),U_=a(e),h(Tl.$$.fragment,e),Z_=a(e),vl=l(e,"P",{"data-svelte-h":!0}),y(vl)!=="svelte-u6m09u"&&(vl.innerHTML=c$),C_=a(e),We=l(e,"DIV",{class:!0});var _r=T(We);h(Ml.$$.fragment,_r),FM=a(_r),Tm=l(_r,"P",{"data-svelte-h":!0}),y(Tm)!=="svelte-rfvu1k"&&(Tm.textContent=i$),XM=a(_r),vm=l(_r,"P",{"data-svelte-h":!0}),y(vm)!=="svelte-e1lytz"&&(vm.innerHTML=d$),LM=a(_r),Mm=l(_r,"DIV",{class:!0});var Yx=T(Mm);h(wl.$$.fragment,Yx),Yx.forEach(n),_r.forEach(n),W_=a(e),us=l(e,"DIV",{class:!0});var vb=T(us);h(kl.$$.fragment,vb),RM=a(vb),wm=l(vb,"DIV",{class:!0});var Px=T(wm);h($l.$$.fragment,Px),Px.forEach(n),vb.forEach(n),B_=a(e),xt=l(e,"DIV",{class:!0});var gu=T(xt);h(jl.$$.fragment,gu),SM=a(gu),km=l(gu,"P",{"data-svelte-h":!0}),y(km)!=="svelte-4hfu96"&&(km.innerHTML=p$),NM=a(gu),$m=l(gu,"DIV",{class:!0});var Ax=T($m);h(xl.$$.fragment,Ax),Ax.forEach(n),gu.forEach(n),z_=a(e),Jt=l(e,"DIV",{class:!0});var uu=T(Jt);h(Jl.$$.fragment,uu),HM=a(uu),jm=l(uu,"P",{"data-svelte-h":!0}),y(jm)!=="svelte-q5v59n"&&(jm.innerHTML=m$),EM=a(uu),xm=l(uu,"DIV",{class:!0});var Ox=T(xm);h(Ul.$$.fragment,Ox),Ox.forEach(n),uu.forEach(n),I_=a(e),J=l(e,"DIV",{class:!0});var U=T(J);h(Zl.$$.fragment,U),qM=a(U),Jm=l(U,"P",{"data-svelte-h":!0}),y(Jm)!=="svelte-1rue44"&&(Jm.textContent=h$),QM=a(U),Um=l(U,"P",{"data-svelte-h":!0}),y(Um)!=="svelte-we1k7h"&&(Um.textContent=g$),DM=a(U),Zm=l(U,"UL",{"data-svelte-h":!0}),y(Zm)!=="svelte-1f6ppg"&&(Zm.innerHTML=u$),YM=a(U),Cm=l(U,"P",{"data-svelte-h":!0}),y(Cm)!=="svelte-1uu68ip"&&(Cm.textContent=f$),PM=a(U),Wm=l(U,"UL",{"data-svelte-h":!0}),y(Wm)!=="svelte-izl8df"&&(Wm.innerHTML=_$),AM=a(U),Bm=l(U,"P",{"data-svelte-h":!0}),y(Bm)!=="svelte-hoqys0"&&(Bm.textContent=b$),OM=a(U),zm=l(U,"P",{"data-svelte-h":!0}),y(zm)!=="svelte-1a9fclk"&&(zm.textContent=y$),KM=a(U),Im=l(U,"P",{"data-svelte-h":!0}),y(Im)!=="svelte-15ntb9y"&&(Im.textContent=T$),e0=a(U),Vm=l(U,"UL",{"data-svelte-h":!0}),y(Vm)!=="svelte-vv46ly"&&(Vm.innerHTML=v$),t0=a(U),Gm=l(U,"P",{"data-svelte-h":!0}),y(Gm)!=="svelte-1owyk1q"&&(Gm.textContent=M$),s0=a(U),Fm=l(U,"P",{"data-svelte-h":!0}),y(Fm)!=="svelte-wt8oc0"&&(Fm.textContent=w$),n0=a(U),Xm=l(U,"P",{"data-svelte-h":!0}),y(Xm)!=="svelte-ws21yj"&&(Xm.textContent=k$),r0=a(U),Lm=l(U,"P",{"data-svelte-h":!0}),y(Lm)!=="svelte-l6qxzs"&&(Lm.textContent=$$),a0=a(U),Rm=l(U,"UL",{"data-svelte-h":!0}),y(Rm)!=="svelte-p67cyh"&&(Rm.innerHTML=j$),o0=a(U),Sm=l(U,"P",{"data-svelte-h":!0}),y(Sm)!=="svelte-1fg1xi2"&&(Sm.textContent=x$),l0=a(U),Nm=l(U,"P",{"data-svelte-h":!0}),y(Nm)!=="svelte-1e0ripw"&&(Nm.textContent=J$),c0=a(U),Hm=l(U,"UL",{"data-svelte-h":!0}),y(Hm)!=="svelte-1v088e0"&&(Hm.innerHTML=U$),i0=a(U),Em=l(U,"P",{"data-svelte-h":!0}),y(Em)!=="svelte-be7vix"&&(Em.textContent=Z$),d0=a(U),qm=l(U,"P",{"data-svelte-h":!0}),y(qm)!=="svelte-1xhdoom"&&(qm.textContent=C$),p0=a(U),h(dn.$$.fragment,U),m0=a(U),Qm=l(U,"DIV",{class:!0});var Kx=T(Qm);h(Cl.$$.fragment,Kx),Kx.forEach(n),U.forEach(n),V_=a(e),Ut=l(e,"DIV",{class:!0});var fu=T(Ut);h(Wl.$$.fragment,fu),h0=a(fu),Dm=l(fu,"P",{"data-svelte-h":!0}),y(Dm)!=="svelte-1t19wr8"&&(Dm.innerHTML=W$),g0=a(fu),Ym=l(fu,"DIV",{class:!0});var eJ=T(Ym);h(Bl.$$.fragment,eJ),eJ.forEach(n),fu.forEach(n),G_=a(e),h(zl.$$.fragment,e),F_=a(e),Il=l(e,"P",{"data-svelte-h":!0}),y(Il)!=="svelte-1q4fris"&&(Il.innerHTML=B$),X_=a(e),W=l(e,"DIV",{class:!0});var B=T(W);h(Vl.$$.fragment,B),u0=a(B),Pm=l(B,"P",{"data-svelte-h":!0}),y(Pm)!=="svelte-1kh5y5v"&&(Pm.textContent=z$),f0=a(B),Am=l(B,"P",{"data-svelte-h":!0}),y(Am)!=="svelte-1ygkifj"&&(Am.textContent=I$),_0=a(B),h(pn.$$.fragment,B),b0=a(B),Om=l(B,"P",{"data-svelte-h":!0}),y(Om)!=="svelte-7kbd1a"&&(Om.textContent=V$),y0=a(B),mn=l(B,"DIV",{class:!0});var Mb=T(mn);h(Gl.$$.fragment,Mb),T0=a(Mb),Km=l(Mb,"P",{"data-svelte-h":!0}),y(Km)!=="svelte-163x237"&&(Km.textContent=G$),Mb.forEach(n),v0=a(B),hn=l(B,"DIV",{class:!0});var wb=T(hn);h(Fl.$$.fragment,wb),M0=a(wb),eh=l(wb,"P",{"data-svelte-h":!0}),y(eh)!=="svelte-dtkk01"&&(eh.textContent=F$),wb.forEach(n),w0=a(B),gn=l(B,"DIV",{class:!0});var kb=T(gn);h(Xl.$$.fragment,kb),k0=a(kb),th=l(kb,"P",{"data-svelte-h":!0}),y(th)!=="svelte-11pa7k0"&&(th.textContent=X$),kb.forEach(n),$0=a(B),un=l(B,"DIV",{class:!0});var $b=T(un);h(Ll.$$.fragment,$b),j0=a($b),sh=l($b,"P",{"data-svelte-h":!0}),y(sh)!=="svelte-57vcuk"&&(sh.innerHTML=L$),$b.forEach(n),x0=a(B),fn=l(B,"DIV",{class:!0});var jb=T(fn);h(Rl.$$.fragment,jb),J0=a(jb),nh=l(jb,"P",{"data-svelte-h":!0}),y(nh)!=="svelte-e342dt"&&(nh.textContent=R$),jb.forEach(n),U0=a(B),_n=l(B,"DIV",{class:!0});var xb=T(_n);h(Sl.$$.fragment,xb),Z0=a(xb),rh=l(xb,"P",{"data-svelte-h":!0}),y(rh)!=="svelte-vbd5xj"&&(rh.textContent=S$),xb.forEach(n),C0=a(B),Ht=l(B,"DIV",{class:!0});var _u=T(Ht);h(Nl.$$.fragment,_u),W0=a(_u),ah=l(_u,"P",{"data-svelte-h":!0}),y(ah)!=="svelte-1c2dshy"&&(ah.innerHTML=N$),B0=a(_u),oh=l(_u,"P",{"data-svelte-h":!0}),y(oh)!=="svelte-1qvu1un"&&(oh.textContent=H$),_u.forEach(n),B.forEach(n),L_=a(e),fs=l(e,"DIV",{class:!0});var Jb=T(fs);h(Hl.$$.fragment,Jb),z0=a(Jb),lh=l(Jb,"P",{"data-svelte-h":!0}),y(lh)!=="svelte-6v8pe8"&&(lh.innerHTML=E$),Jb.forEach(n),R_=a(e),_s=l(e,"DIV",{class:!0});var Ub=T(_s);h(El.$$.fragment,Ub),I0=a(Ub),ch=l(Ub,"P",{"data-svelte-h":!0}),y(ch)!=="svelte-oywlqf"&&(ch.innerHTML=q$),Ub.forEach(n),S_=a(e),Be=l(e,"DIV",{class:!0});var br=T(Be);h(ql.$$.fragment,br),V0=a(br),ih=l(br,"P",{"data-svelte-h":!0}),y(ih)!=="svelte-rxlesw"&&(ih.textContent=Q$),G0=a(br),A=l(br,"DIV",{class:!0});var Le=T(A);h(Ql.$$.fragment,Le),F0=a(Le),dh=l(Le,"P",{"data-svelte-h":!0}),y(dh)!=="svelte-15hhlou"&&(dh.textContent=D$),X0=a(Le),ph=l(Le,"P",{"data-svelte-h":!0}),y(ph)!=="svelte-e6h4hs"&&(ph.innerHTML=Y$),L0=a(Le),mh=l(Le,"P",{"data-svelte-h":!0}),y(mh)!=="svelte-1w36vm3"&&(mh.innerHTML=P$),R0=a(Le),hh=l(Le,"P",{"data-svelte-h":!0}),y(hh)!=="svelte-1niq0qw"&&(hh.innerHTML=A$),S0=a(Le),gh=l(Le,"P",{"data-svelte-h":!0}),y(gh)!=="svelte-af4g6f"&&(gh.textContent=O$),Le.forEach(n),N0=a(br),bn=l(br,"DIV",{class:!0});var Zb=T(bn);h(Dl.$$.fragment,Zb),H0=a(Zb),uh=l(Zb,"P",{"data-svelte-h":!0}),y(uh)!=="svelte-eab6jp"&&(uh.textContent=K$),Zb.forEach(n),br.forEach(n),N_=a(e),h(Yl.$$.fragment,e),H_=a(e),ze=l(e,"DIV",{class:!0});var yr=T(ze);h(Pl.$$.fragment,yr),E0=a(yr),fh=l(yr,"P",{"data-svelte-h":!0}),y(fh)!=="svelte-1fikjzl"&&(fh.innerHTML=ej),q0=a(yr),_h=l(yr,"DIV",{class:!0});var tJ=T(_h);h(Al.$$.fragment,tJ),tJ.forEach(n),Q0=a(yr),bh=l(yr,"DIV",{class:!0});var sJ=T(bh);h(Ol.$$.fragment,sJ),sJ.forEach(n),yr.forEach(n),E_=a(e),H=l(e,"DIV",{class:!0});var Re=T(H);h(Kl.$$.fragment,Re),D0=a(Re),yh=l(Re,"P",{"data-svelte-h":!0}),y(yh)!=="svelte-qpbkj3"&&(yh.innerHTML=tj),Y0=a(Re),Th=l(Re,"P",{"data-svelte-h":!0}),y(Th)!=="svelte-19qrwo1"&&(Th.innerHTML=sj),P0=a(Re),vh=l(Re,"P",{"data-svelte-h":!0}),y(vh)!=="svelte-l79sbt"&&(vh.innerHTML=nj),A0=a(Re),Mh=l(Re,"DIV",{class:!0});var nJ=T(Mh);h(ec.$$.fragment,nJ),nJ.forEach(n),O0=a(Re),wh=l(Re,"DIV",{class:!0});var rJ=T(wh);h(tc.$$.fragment,rJ),rJ.forEach(n),Re.forEach(n),q_=a(e),Ie=l(e,"DIV",{class:!0});var Tr=T(Ie);h(sc.$$.fragment,Tr),K0=a(Tr),kh=l(Tr,"P",{"data-svelte-h":!0}),y(kh)!=="svelte-tfr7i8"&&(kh.innerHTML=rj),ew=a(Tr),$h=l(Tr,"DIV",{class:!0});var aJ=T($h);h(nc.$$.fragment,aJ),aJ.forEach(n),tw=a(Tr),jh=l(Tr,"DIV",{class:!0});var oJ=T(jh);h(rc.$$.fragment,oJ),oJ.forEach(n),Tr.forEach(n),Q_=a(e),h(ac.$$.fragment,e),D_=a(e),G=l(e,"DIV",{class:!0});var ue=T(G);h(oc.$$.fragment,ue),sw=a(ue),xh=l(ue,"P",{"data-svelte-h":!0}),y(xh)!=="svelte-5jvlz5"&&(xh.textContent=aj),nw=a(ue),h(yn.$$.fragment,ue),rw=a(ue),h(Tn.$$.fragment,ue),aw=a(ue),vn=l(ue,"DIV",{class:!0});var Cb=T(vn);h(lc.$$.fragment,Cb),ow=a(Cb),Jh=l(Cb,"P",{"data-svelte-h":!0}),y(Jh)!=="svelte-10d94rs"&&(Jh.textContent=oj),Cb.forEach(n),lw=a(ue),Mn=l(ue,"DIV",{class:!0});var Wb=T(Mn);h(cc.$$.fragment,Wb),cw=a(Wb),Uh=l(Wb,"P",{"data-svelte-h":!0}),y(Uh)!=="svelte-tm945r"&&(Uh.textContent=lj),Wb.forEach(n),iw=a(ue),wn=l(ue,"DIV",{class:!0});var Bb=T(wn);h(ic.$$.fragment,Bb),dw=a(Bb),Zh=l(Bb,"P",{"data-svelte-h":!0}),y(Zh)!=="svelte-1i1356p"&&(Zh.textContent=cj),Bb.forEach(n),ue.forEach(n),Y_=a(e),de=l(e,"DIV",{class:!0});var Kt=T(de);h(dc.$$.fragment,Kt),pw=a(Kt),Ch=l(Kt,"P",{"data-svelte-h":!0}),y(Ch)!=="svelte-190fodr"&&(Ch.textContent=ij),mw=a(Kt),h(kn.$$.fragment,Kt),hw=a(Kt),h($n.$$.fragment,Kt),gw=a(Kt),jn=l(Kt,"DIV",{class:!0});var zb=T(jn);h(pc.$$.fragment,zb),uw=a(zb),Wh=l(zb,"P",{"data-svelte-h":!0}),y(Wh)!=="svelte-16i5iz"&&(Wh.textContent=dj),zb.forEach(n),Kt.forEach(n),P_=a(e),h(mc.$$.fragment,e),A_=a(e),Zt=l(e,"DIV",{class:!0});var bu=T(Zt);h(hc.$$.fragment,bu),fw=a(bu),Bh=l(bu,"P",{"data-svelte-h":!0}),y(Bh)!=="svelte-15qehu2"&&(Bh.textContent=pj),_w=a(bu),xn=l(bu,"DIV",{class:!0});var Ib=T(xn);h(gc.$$.fragment,Ib),bw=a(Ib),zh=l(Ib,"P",{"data-svelte-h":!0}),y(zh)!=="svelte-dfcv5s"&&(zh.innerHTML=mj),Ib.forEach(n),bu.forEach(n),O_=a(e),Ct=l(e,"DIV",{class:!0});var yu=T(Ct);h(uc.$$.fragment,yu),yw=a(yu),Ih=l(yu,"P",{"data-svelte-h":!0}),y(Ih)!=="svelte-1sqibp"&&(Ih.textContent=hj),Tw=a(yu),Jn=l(yu,"DIV",{class:!0});var Vb=T(Jn);h(fc.$$.fragment,Vb),vw=a(Vb),Vh=l(Vb,"P",{"data-svelte-h":!0}),y(Vh)!=="svelte-n0rwld"&&(Vh.innerHTML=gj),Vb.forEach(n),yu.forEach(n),K_=a(e),Wt=l(e,"DIV",{class:!0});var Tu=T(Wt);h(_c.$$.fragment,Tu),Mw=a(Tu),Gh=l(Tu,"P",{"data-svelte-h":!0}),y(Gh)!=="svelte-157zylv"&&(Gh.textContent=uj),ww=a(Tu),Un=l(Tu,"DIV",{class:!0});var Gb=T(Un);h(bc.$$.fragment,Gb),kw=a(Gb),Fh=l(Gb,"P",{"data-svelte-h":!0}),y(Fh)!=="svelte-15juztn"&&(Fh.textContent=fj),Gb.forEach(n),Tu.forEach(n),eb=a(e),z=l(e,"DIV",{class:!0});var X=T(z);h(yc.$$.fragment,X),$w=a(X),Xh=l(X,"P",{"data-svelte-h":!0}),y(Xh)!=="svelte-11w7j52"&&(Xh.textContent=_j),jw=a(X),Lh=l(X,"P",{"data-svelte-h":!0}),y(Lh)!=="svelte-1f9j82e"&&(Lh.innerHTML=bj),xw=a(X),h(Zn.$$.fragment,X),Jw=a(X),Cn=l(X,"DIV",{class:!0});var Fb=T(Cn);h(Tc.$$.fragment,Fb),Uw=a(Fb),Rh=l(Fb,"P",{"data-svelte-h":!0}),y(Rh)!=="svelte-dfcv5s"&&(Rh.innerHTML=yj),Fb.forEach(n),Zw=a(X),Wn=l(X,"DIV",{class:!0});var Xb=T(Wn);h(vc.$$.fragment,Xb),Cw=a(Xb),Sh=l(Xb,"P",{"data-svelte-h":!0}),y(Sh)!=="svelte-1nftdf9"&&(Sh.textContent=Tj),Xb.forEach(n),Ww=a(X),Bn=l(X,"DIV",{class:!0});var Lb=T(Bn);h(Mc.$$.fragment,Lb),Bw=a(Lb),Nh=l(Lb,"P",{"data-svelte-h":!0}),y(Nh)!=="svelte-114iuj0"&&(Nh.textContent=vj),Lb.forEach(n),zw=a(X),zn=l(X,"DIV",{class:!0});var Rb=T(zn);h(wc.$$.fragment,Rb),Iw=a(Rb),Hh=l(Rb,"P",{"data-svelte-h":!0}),y(Hh)!=="svelte-dst59w"&&(Hh.innerHTML=Mj),Rb.forEach(n),Vw=a(X),In=l(X,"DIV",{class:!0});var Sb=T(In);h(kc.$$.fragment,Sb),Gw=a(Sb),Eh=l(Sb,"P",{"data-svelte-h":!0}),y(Eh)!=="svelte-15y4kd1"&&(Eh.innerHTML=wj),Sb.forEach(n),X.forEach(n),tb=a(e),E=l(e,"DIV",{class:!0});var Se=T(E);h($c.$$.fragment,Se),Fw=a(Se),qh=l(Se,"P",{"data-svelte-h":!0}),y(qh)!=="svelte-1x0oesy"&&(qh.innerHTML=kj),Xw=a(Se),Qh=l(Se,"P",{"data-svelte-h":!0}),y(Qh)!=="svelte-2ai6qp"&&(Qh.innerHTML=$j),Lw=a(Se),Dh=l(Se,"P",{"data-svelte-h":!0}),y(Dh)!=="svelte-18fduhd"&&(Dh.innerHTML=jj),Rw=a(Se),Yh=l(Se,"DIV",{class:!0});var lJ=T(Yh);h(jc.$$.fragment,lJ),lJ.forEach(n),Sw=a(Se),Vn=l(Se,"DIV",{class:!0});var Nb=T(Vn);h(xc.$$.fragment,Nb),Nw=a(Nb),Ph=l(Nb,"P",{"data-svelte-h":!0}),y(Ph)!=="svelte-1nftdf9"&&(Ph.textContent=xj),Nb.forEach(n),Se.forEach(n),sb=a(e),Bt=l(e,"DIV",{class:!0});var vu=T(Bt);h(Jc.$$.fragment,vu),Hw=a(vu),Ah=l(vu,"P",{"data-svelte-h":!0}),y(Ah)!=="svelte-pjm1pe"&&(Ah.innerHTML=Jj),Ew=a(vu),h(Gn.$$.fragment,vu),vu.forEach(n),nb=a(e),zt=l(e,"DIV",{class:!0});var Mu=T(zt);h(Uc.$$.fragment,Mu),qw=a(Mu),Oh=l(Mu,"P",{"data-svelte-h":!0}),y(Oh)!=="svelte-api7s7"&&(Oh.innerHTML=Uj),Qw=a(Mu),h(Fn.$$.fragment,Mu),Mu.forEach(n),rb=a(e),F=l(e,"DIV",{class:!0});var fe=T(F);h(Zc.$$.fragment,fe),Dw=a(fe),Kh=l(fe,"P",{"data-svelte-h":!0}),y(Kh)!=="svelte-ldcea6"&&(Kh.innerHTML=Zj),Yw=a(fe),eg=l(fe,"P",{"data-svelte-h":!0}),y(eg)!=="svelte-1f9j82e"&&(eg.innerHTML=Cj),Pw=a(fe),h(Xn.$$.fragment,fe),Aw=a(fe),Ln=l(fe,"DIV",{class:!0});var Hb=T(Ln);h(Cc.$$.fragment,Hb),Ow=a(Hb),tg=l(Hb,"P",{"data-svelte-h":!0}),y(tg)!=="svelte-dfcv5s"&&(tg.innerHTML=Wj),Hb.forEach(n),Kw=a(fe),Rn=l(fe,"DIV",{class:!0});var Eb=T(Rn);h(Wc.$$.fragment,Eb),e2=a(Eb),sg=l(Eb,"P",{"data-svelte-h":!0}),y(sg)!=="svelte-1nftdf9"&&(sg.textContent=Bj),Eb.forEach(n),t2=a(fe),Sn=l(fe,"DIV",{class:!0});var qb=T(Sn);h(Bc.$$.fragment,qb),s2=a(qb),ng=l(qb,"P",{"data-svelte-h":!0}),y(ng)!=="svelte-114iuj0"&&(ng.textContent=zj),qb.forEach(n),fe.forEach(n),ab=a(e),q=l(e,"DIV",{class:!0});var Ne=T(q);h(zc.$$.fragment,Ne),n2=a(Ne),rg=l(Ne,"P",{"data-svelte-h":!0}),y(rg)!=="svelte-8o3e5p"&&(rg.textContent=Ij),r2=a(Ne),ag=l(Ne,"P",{"data-svelte-h":!0}),y(ag)!=="svelte-1cyjk9y"&&(ag.textContent=Vj),a2=a(Ne),Nn=l(Ne,"DIV",{class:!0});var Qb=T(Nn);h(Ic.$$.fragment,Qb),o2=a(Qb),og=l(Qb,"P",{"data-svelte-h":!0}),y(og)!=="svelte-dfcv5s"&&(og.innerHTML=Gj),Qb.forEach(n),l2=a(Ne),Hn=l(Ne,"DIV",{class:!0});var Db=T(Hn);h(Vc.$$.fragment,Db),c2=a(Db),lg=l(Db,"P",{"data-svelte-h":!0}),y(lg)!=="svelte-t93z5n"&&(lg.textContent=Fj),Db.forEach(n),i2=a(Ne),En=l(Ne,"DIV",{class:!0});var Yb=T(En);h(Gc.$$.fragment,Yb),d2=a(Yb),cg=l(Yb,"P",{"data-svelte-h":!0}),y(cg)!=="svelte-1rjgo2n"&&(cg.textContent=Xj),Yb.forEach(n),Ne.forEach(n),ob=a(e),Q=l(e,"DIV",{class:!0});var He=T(Q);h(Fc.$$.fragment,He),p2=a(He),ig=l(He,"P",{"data-svelte-h":!0}),y(ig)!=="svelte-1atvuc"&&(ig.innerHTML=Lj),m2=a(He),h(qn.$$.fragment,He),h2=a(He),Qn=l(He,"DIV",{class:!0});var Pb=T(Qn);h(Xc.$$.fragment,Pb),g2=a(Pb),dg=l(Pb,"P",{"data-svelte-h":!0}),y(dg)!=="svelte-vi6d54"&&(dg.innerHTML=Rj),Pb.forEach(n),u2=a(He),Dn=l(He,"DIV",{class:!0});var Ab=T(Dn);h(Lc.$$.fragment,Ab),f2=a(Ab),pg=l(Ab,"P",{"data-svelte-h":!0}),y(pg)!=="svelte-14hqs6n"&&(pg.textContent=Sj),Ab.forEach(n),_2=a(He),Yn=l(He,"DIV",{class:!0});var Ob=T(Yn);h(Rc.$$.fragment,Ob),b2=a(Ob),mg=l(Ob,"P",{"data-svelte-h":!0}),y(mg)!=="svelte-135okg0"&&(mg.textContent=Nj),Ob.forEach(n),He.forEach(n),lb=a(e),D=l(e,"DIV",{class:!0});var Ee=T(D);h(Sc.$$.fragment,Ee),y2=a(Ee),hg=l(Ee,"P",{"data-svelte-h":!0}),y(hg)!=="svelte-t1noj8"&&(hg.innerHTML=Hj),T2=a(Ee),h(Pn.$$.fragment,Ee),v2=a(Ee),An=l(Ee,"DIV",{class:!0});var Kb=T(An);h(Nc.$$.fragment,Kb),M2=a(Kb),gg=l(Kb,"P",{"data-svelte-h":!0}),y(gg)!=="svelte-vi6d54"&&(gg.innerHTML=Ej),Kb.forEach(n),w2=a(Ee),On=l(Ee,"DIV",{class:!0});var ey=T(On);h(Hc.$$.fragment,ey),k2=a(ey),ug=l(ey,"P",{"data-svelte-h":!0}),y(ug)!=="svelte-14hqs6n"&&(ug.textContent=qj),ey.forEach(n),$2=a(Ee),Kn=l(Ee,"DIV",{class:!0});var ty=T(Kn);h(Ec.$$.fragment,ty),j2=a(ty),fg=l(ty,"P",{"data-svelte-h":!0}),y(fg)!=="svelte-oxae9u"&&(fg.textContent=Qj),ty.forEach(n),Ee.forEach(n),cb=a(e),Y=l(e,"DIV",{class:!0});var qe=T(Y);h(qc.$$.fragment,qe),x2=a(qe),_g=l(qe,"P",{"data-svelte-h":!0}),y(_g)!=="svelte-oxdq12"&&(_g.innerHTML=Dj),J2=a(qe),h(er.$$.fragment,qe),U2=a(qe),bg=l(qe,"DIV",{class:!0});var cJ=T(bg);h(Qc.$$.fragment,cJ),cJ.forEach(n),Z2=a(qe),yg=l(qe,"DIV",{class:!0});var iJ=T(yg);h(Dc.$$.fragment,iJ),iJ.forEach(n),C2=a(qe),tr=l(qe,"DIV",{class:!0});var sy=T(tr);h(Yc.$$.fragment,sy),W2=a(sy),Tg=l(sy,"P",{"data-svelte-h":!0}),y(Tg)!=="svelte-135okg0"&&(Tg.textContent=Yj),sy.forEach(n),qe.forEach(n),ib=a(e),I=l(e,"DIV",{class:!0});var O=T(I);h(Pc.$$.fragment,O),B2=a(O),vg=l(O,"P",{"data-svelte-h":!0}),y(vg)!=="svelte-16jubgm"&&(vg.innerHTML=Pj),z2=a(O),Mg=l(O,"P",{"data-svelte-h":!0}),y(Mg)!=="svelte-437xch"&&(Mg.innerHTML=Aj),I2=a(O),wg=l(O,"P",{"data-svelte-h":!0}),y(wg)!=="svelte-1qvpx79"&&(wg.textContent=Oj),V2=a(O),kg=l(O,"P",{"data-svelte-h":!0}),y(kg)!=="svelte-dhmy5x"&&(kg.innerHTML=Kj),G2=a(O),h(sr.$$.fragment,O),F2=a(O),$g=l(O,"DIV",{class:!0});var dJ=T($g);h(Ac.$$.fragment,dJ),dJ.forEach(n),X2=a(O),jg=l(O,"DIV",{class:!0});var pJ=T(jg);h(Oc.$$.fragment,pJ),pJ.forEach(n),O.forEach(n),db=a(e),V=l(e,"DIV",{class:!0});var K=T(V);h(Kc.$$.fragment,K),L2=a(K),xg=l(K,"P",{"data-svelte-h":!0}),y(xg)!=="svelte-biazxg"&&(xg.textContent=ex),R2=a(K),h(nr.$$.fragment,K),S2=a(K),rr=l(K,"DIV",{class:!0});var ny=T(rr);h(ei.$$.fragment,ny),N2=a(ny),Jg=l(ny,"P",{"data-svelte-h":!0}),y(Jg)!=="svelte-1nftdf9"&&(Jg.textContent=tx),ny.forEach(n),H2=a(K),ar=l(K,"DIV",{class:!0});var ry=T(ar);h(ti.$$.fragment,ry),E2=a(ry),Ug=l(ry,"P",{"data-svelte-h":!0}),y(Ug)!=="svelte-qvnpmr"&&(Ug.innerHTML=sx),ry.forEach(n),q2=a(K),or=l(K,"DIV",{class:!0});var ay=T(or);h(si.$$.fragment,ay),Q2=a(ay),Zg=l(ay,"P",{"data-svelte-h":!0}),y(Zg)!=="svelte-1tx1mox"&&(Zg.innerHTML=nx),ay.forEach(n),D2=a(K),Cg=l(K,"DIV",{class:!0});var mJ=T(Cg);h(ni.$$.fragment,mJ),mJ.forEach(n),Y2=a(K),lr=l(K,"DIV",{class:!0});var oy=T(lr);h(ri.$$.fragment,oy),P2=a(oy),Wg=l(oy,"P",{"data-svelte-h":!0}),y(Wg)!=="svelte-114iuj0"&&(Wg.textContent=rx),oy.forEach(n),K.forEach(n),pb=a(e),P=l(e,"DIV",{class:!0});var Qe=T(P);h(ai.$$.fragment,Qe),A2=a(Qe),Bg=l(Qe,"P",{"data-svelte-h":!0}),y(Bg)!=="svelte-plgsbf"&&(Bg.textContent=ax),O2=a(Qe),h(cr.$$.fragment,Qe),K2=a(Qe),zg=l(Qe,"DIV",{class:!0});var hJ=T(zg);h(oi.$$.fragment,hJ),hJ.forEach(n),e1=a(Qe),Ig=l(Qe,"DIV",{class:!0});var gJ=T(Ig);h(li.$$.fragment,gJ),gJ.forEach(n),t1=a(Qe),Vg=l(Qe,"DIV",{class:!0});var uJ=T(Vg);h(ci.$$.fragment,uJ),uJ.forEach(n),Qe.forEach(n),mb=a(e),h(ii.$$.fragment,e),hb=a(e),pe=l(e,"DIV",{class:!0});var es=T(pe);h(di.$$.fragment,es),s1=a(es),Gg=l(es,"P",{"data-svelte-h":!0}),y(Gg)!=="svelte-17osgxw"&&(Gg.innerHTML=ox),n1=a(es),Fg=l(es,"P",{"data-svelte-h":!0}),y(Fg)!=="svelte-y9hsik"&&(Fg.innerHTML=lx),r1=a(es),h(ir.$$.fragment,es),a1=a(es),dr=l(es,"DIV",{class:!0});var ly=T(dr);h(pi.$$.fragment,ly),o1=a(ly),Xg=l(ly,"P",{"data-svelte-h":!0}),y(Xg)!=="svelte-8xv78e"&&(Xg.textContent=cx),ly.forEach(n),es.forEach(n),gb=a(e),h(mi.$$.fragment,e),ub=a(e),wu=l(e,"P",{}),T(wu).forEach(n),this.h()},h(){v(c,"name","hf:doc:metadata"),v(c,"content",yU),v(ts,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ss,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ns,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(rs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(as,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(os,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ls,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(cs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(is,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ds,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ps,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ms,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(hs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(gs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ws,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(De,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ks,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v($s,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ai,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ed,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(nd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(od,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(cd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(dd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(md,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(gd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(fd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Td,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(wd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(we,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v($d,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(xd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ud,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Cd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v($e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Bd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Gd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Xd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Rd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Nd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(qd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Dd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Pd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Od,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ep,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(sp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(rp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(lp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(dp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(hp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(_p,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(yp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(vp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(et,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(wp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(an,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(st,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(xp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(nt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(on,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(rt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Cp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(at,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Bp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ot,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ip,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(lt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Gp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ct,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Xp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(it,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Rp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(dt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Np,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(pt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ep,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(mt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Qp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ht,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Yp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(gt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ap,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ut,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Kp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ft,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ln,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(_t,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(nm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(bt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(cn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(yt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(lm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(im,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(vt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(pm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Mt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(hm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(wt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(um,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(kt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(_m,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v($t,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ym,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(jt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Mm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(We,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(wm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(us,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v($m,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(xt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(xm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Jt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Qm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ym,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ut,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(mn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(hn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(gn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(un,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(fn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(_n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ht,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(fs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(_s,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(bn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(_h,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(bh,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Mh,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(wh,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v($h,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(jh,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(vn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Mn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(wn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(jn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(xn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Zt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Jn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ct,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Un,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Wt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Cn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Wn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Bn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(zn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(In,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Yh,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Vn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Bt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(zt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ln,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Rn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Sn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Nn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Hn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(En,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Qn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Dn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Yn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(An,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(On,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Kn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(bg,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(yg,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(tr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v($g,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(jg,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(rr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ar,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(or,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Cg,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(lr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(zg,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ig,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Vg,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(dr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,i){t(document.head,c),d(e,$,i),d(e,b,i),d(e,p,i),g(w,e,i),d(e,s,i),d(e,k,i),d(e,Xu,i),g(Mr,e,i),d(e,Lu,i),d(e,wr,i),d(e,Ru,i),d(e,kr,i),d(e,Su,i),g($r,e,i),d(e,Nu,i),d(e,jr,i),d(e,Hu,i),d(e,xr,i),d(e,Eu,i),d(e,Jr,i),d(e,qu,i),d(e,Ur,i),d(e,Qu,i),d(e,Zr,i),d(e,Du,i),g(Cr,e,i),d(e,Yu,i),d(e,Wr,i),d(e,Pu,i),d(e,Br,i),d(e,Au,i),d(e,zr,i),d(e,Ou,i),g(Ir,e,i),d(e,Ku,i),d(e,ts,i),g(Vr,ts,null),t(ts,cy),t(ts,Zi),d(e,ef,i),d(e,ss,i),g(Gr,ss,null),t(ss,iy),t(ss,Ci),d(e,tf,i),d(e,ns,i),g(Fr,ns,null),t(ns,dy),t(ns,Wi),d(e,sf,i),d(e,rs,i),g(Xr,rs,null),t(rs,py),t(rs,Bi),d(e,nf,i),g(Lr,e,i),d(e,rf,i),d(e,as,i),g(Rr,as,null),t(as,my),t(as,zi),d(e,af,i),d(e,os,i),g(Sr,os,null),t(os,hy),t(os,Ii),d(e,of,i),d(e,ls,i),g(Nr,ls,null),t(ls,gy),t(ls,Vi),d(e,lf,i),d(e,cs,i),g(Hr,cs,null),t(cs,uy),t(cs,Gi),d(e,cf,i),d(e,is,i),g(Er,is,null),t(is,fy),t(is,Fi),d(e,df,i),d(e,ds,i),g(qr,ds,null),t(ds,_y),t(ds,Xi),d(e,pf,i),d(e,ps,i),g(Qr,ps,null),t(ps,by),t(ps,Li),d(e,mf,i),d(e,ms,i),g(Dr,ms,null),t(ms,yy),t(ms,Ri),d(e,hf,i),d(e,hs,i),g(Yr,hs,null),t(hs,Ty),t(hs,Si),d(e,gf,i),d(e,gs,i),g(Pr,gs,null),t(gs,vy),t(gs,Ni),d(e,uf,i),g(Ar,e,i),d(e,ff,i),d(e,De,i),g(Or,De,null),t(De,My),t(De,Hi),t(De,wy),t(De,ws),g(Kr,ws,null),t(ws,ky),t(ws,Ei),d(e,_f,i),d(e,Ye,i),g(ea,Ye,null),t(Ye,$y),t(Ye,qi),t(Ye,jy),t(Ye,ks),g(ta,ks,null),t(ks,xy),t(ks,Qi),d(e,bf,i),d(e,Pe,i),g(sa,Pe,null),t(Pe,Jy),t(Pe,Di),t(Pe,Uy),t(Pe,$s),g(na,$s,null),t($s,Zy),t($s,Yi),d(e,yf,i),g(ra,e,i),d(e,Tf,i),d(e,aa,i),d(e,vf,i),g(oa,e,i),d(e,Mf,i),d(e,_e,i),g(la,_e,null),t(_e,Cy),t(_e,Pi),t(_e,Wy),g(js,_e,null),t(_e,By),t(_e,Ai),g(ca,Ai,null),d(e,wf,i),d(e,L,i),g(ia,L,null),t(L,zy),t(L,Oi),t(L,Iy),t(L,Ki),t(L,Vy),g(xs,L,null),t(L,Gy),g(Js,L,null),t(L,Fy),t(L,ed),g(da,ed,null),d(e,kf,i),d(e,ee,i),g(pa,ee,null),t(ee,Xy),t(ee,td),t(ee,Ly),t(ee,sd),t(ee,Ry),g(Us,ee,null),t(ee,Sy),t(ee,nd),g(ma,nd,null),d(e,$f,i),d(e,te,i),g(ha,te,null),t(te,Ny),t(te,rd),t(te,Hy),t(te,ad),t(te,Ey),g(Zs,te,null),t(te,qy),t(te,od),g(ga,od,null),d(e,jf,i),d(e,be,i),g(ua,be,null),t(be,Qy),t(be,ld),t(be,Dy),g(Cs,be,null),t(be,Yy),t(be,cd),g(fa,cd,null),d(e,xf,i),d(e,ye,i),g(_a,ye,null),t(ye,Py),t(ye,id),t(ye,Ay),g(Ws,ye,null),t(ye,Oy),t(ye,dd),g(ba,dd,null),d(e,Jf,i),d(e,Te,i),g(ya,Te,null),t(Te,Ky),t(Te,pd),t(Te,eT),g(Bs,Te,null),t(Te,tT),t(Te,md),g(Ta,md,null),d(e,Uf,i),d(e,ve,i),g(va,ve,null),t(ve,sT),t(ve,hd),t(ve,nT),g(zs,ve,null),t(ve,rT),t(ve,gd),g(Ma,gd,null),d(e,Zf,i),d(e,Me,i),g(wa,Me,null),t(Me,aT),t(Me,ud),t(Me,oT),g(Is,Me,null),t(Me,lT),t(Me,fd),g(ka,fd,null),d(e,Cf,i),d(e,R,i),g($a,R,null),t(R,cT),t(R,_d),t(R,iT),t(R,bd),t(R,dT),t(R,yd),t(R,pT),g(Vs,R,null),t(R,mT),t(R,Td),g(ja,Td,null),d(e,Wf,i),d(e,we,i),g(xa,we,null),t(we,hT),t(we,vd),t(we,gT),t(we,Md),t(we,uT),t(we,wd),g(Ja,wd,null),d(e,Bf,i),d(e,ke,i),g(Ua,ke,null),t(ke,fT),t(ke,kd),t(ke,_T),g(Gs,ke,null),t(ke,bT),t(ke,$d),g(Za,$d,null),d(e,zf,i),d(e,Ae,i),g(Ca,Ae,null),t(Ae,yT),t(Ae,jd),t(Ae,TT),t(Ae,xd),g(Wa,xd,null),d(e,If,i),d(e,Oe,i),g(Ba,Oe,null),t(Oe,vT),t(Oe,Jd),t(Oe,MT),t(Oe,Ud),g(za,Ud,null),d(e,Vf,i),d(e,$e,i),g(Ia,$e,null),t($e,wT),t($e,Zd),t($e,kT),g(Fs,$e,null),t($e,$T),t($e,Cd),g(Va,Cd,null),d(e,Gf,i),d(e,je,i),g(Ga,je,null),t(je,jT),t(je,Wd),t(je,xT),g(Xs,je,null),t(je,JT),t(je,Bd),g(Fa,Bd,null),d(e,Ff,i),d(e,S,i),g(Xa,S,null),t(S,UT),t(S,zd),t(S,ZT),t(S,Id),t(S,CT),t(S,Vd),t(S,WT),g(Ls,S,null),t(S,BT),t(S,Gd),g(La,Gd,null),d(e,Xf,i),d(e,se,i),g(Ra,se,null),t(se,zT),t(se,Fd),t(se,IT),g(Rs,se,null),t(se,VT),g(Ss,se,null),t(se,GT),t(se,Xd),g(Sa,Xd,null),d(e,Lf,i),d(e,ne,i),g(Na,ne,null),t(ne,FT),t(ne,Ld),t(ne,XT),g(Ns,ne,null),t(ne,LT),g(Hs,ne,null),t(ne,RT),t(ne,Rd),g(Ha,Rd,null),d(e,Rf,i),d(e,xe,i),g(Ea,xe,null),t(xe,ST),t(xe,Sd),t(xe,NT),g(Es,xe,null),t(xe,HT),t(xe,Nd),g(qa,Nd,null),d(e,Sf,i),d(e,re,i),g(Qa,re,null),t(re,ET),t(re,Hd),t(re,qT),t(re,Ed),t(re,QT),g(qs,re,null),t(re,DT),t(re,qd),g(Da,qd,null),d(e,Nf,i),d(e,ae,i),g(Ya,ae,null),t(ae,YT),t(ae,Qd),t(ae,PT),g(Qs,ae,null),t(ae,AT),g(Ds,ae,null),t(ae,OT),t(ae,Dd),g(Pa,Dd,null),d(e,Hf,i),d(e,Je,i),g(Aa,Je,null),t(Je,KT),t(Je,Yd),t(Je,ev),g(Ys,Je,null),t(Je,tv),t(Je,Pd),g(Oa,Pd,null),d(e,Ef,i),d(e,Ue,i),g(Ka,Ue,null),t(Ue,sv),t(Ue,Ad),t(Ue,nv),g(Ps,Ue,null),t(Ue,rv),t(Ue,Od),g(eo,Od,null),d(e,qf,i),d(e,oe,i),g(to,oe,null),t(oe,av),t(oe,Kd),t(oe,ov),g(As,oe,null),t(oe,lv),g(Os,oe,null),t(oe,cv),t(oe,ep),g(so,ep,null),d(e,Qf,i),d(e,Ze,i),g(no,Ze,null),t(Ze,iv),t(Ze,tp),t(Ze,dv),g(Ks,Ze,null),t(Ze,pv),t(Ze,sp),g(ro,sp,null),d(e,Df,i),d(e,Ce,i),g(ao,Ce,null),t(Ce,mv),t(Ce,np),t(Ce,hv),g(en,Ce,null),t(Ce,gv),t(Ce,rp),g(oo,rp,null),d(e,Yf,i),d(e,le,i),g(lo,le,null),t(le,uv),t(le,ap),t(le,fv),t(le,op),t(le,_v),g(tn,le,null),t(le,bv),t(le,lp),g(co,lp,null),d(e,Pf,i),d(e,ce,i),g(io,ce,null),t(ce,yv),t(ce,cp),t(ce,Tv),t(ce,ip),t(ce,vv),g(sn,ce,null),t(ce,Mv),t(ce,dp),g(po,dp,null),d(e,Af,i),d(e,ie,i),g(mo,ie,null),t(ie,wv),t(ie,pp),t(ie,kv),t(ie,mp),t(ie,$v),g(nn,ie,null),t(ie,jv),t(ie,hp),g(ho,hp,null),d(e,Of,i),d(e,N,i),g(go,N,null),t(N,xv),t(N,gp),t(N,Jv),t(N,up),t(N,Uv),t(N,fp),t(N,Zv),g(rn,N,null),t(N,Cv),t(N,_p),g(uo,_p,null),d(e,Kf,i),g(fo,e,i),d(e,e_,i),d(e,Ke,i),g(_o,Ke,null),t(Ke,Wv),t(Ke,bp),t(Ke,Bv),t(Ke,yp),g(bo,yp,null),d(e,t_,i),d(e,et,i),g(yo,et,null),t(et,zv),t(et,Tp),t(et,Iv),t(et,vp),g(To,vp,null),d(e,s_,i),d(e,tt,i),g(vo,tt,null),t(tt,Vv),t(tt,Mp),t(tt,Gv),t(tt,wp),g(Mo,wp,null),d(e,n_,i),d(e,st,i),g(wo,st,null),t(st,Fv),t(st,kp),t(st,Xv),t(st,an),g(ko,an,null),t(an,Lv),t(an,$p),d(e,r_,i),d(e,nt,i),g($o,nt,null),t(nt,Rv),t(nt,jp),t(nt,Sv),t(nt,xp),g(jo,xp,null),d(e,a_,i),d(e,rt,i),g(xo,rt,null),t(rt,Nv),t(rt,Jp),t(rt,Hv),t(rt,on),g(Jo,on,null),t(on,Ev),t(on,Up),d(e,o_,i),d(e,at,i),g(Uo,at,null),t(at,qv),t(at,Zp),t(at,Qv),t(at,Cp),g(Zo,Cp,null),d(e,l_,i),d(e,ot,i),g(Co,ot,null),t(ot,Dv),t(ot,Wp),t(ot,Yv),t(ot,Bp),g(Wo,Bp,null),d(e,c_,i),d(e,lt,i),g(Bo,lt,null),t(lt,Pv),t(lt,zp),t(lt,Av),t(lt,Ip),g(zo,Ip,null),d(e,i_,i),d(e,ct,i),g(Io,ct,null),t(ct,Ov),t(ct,Vp),t(ct,Kv),t(ct,Gp),g(Vo,Gp,null),d(e,d_,i),d(e,it,i),g(Go,it,null),t(it,eM),t(it,Fp),t(it,tM),t(it,Xp),g(Fo,Xp,null),d(e,p_,i),d(e,dt,i),g(Xo,dt,null),t(dt,sM),t(dt,Lp),t(dt,nM),t(dt,Rp),g(Lo,Rp,null),d(e,m_,i),d(e,pt,i),g(Ro,pt,null),t(pt,rM),t(pt,Sp),t(pt,aM),t(pt,Np),g(So,Np,null),d(e,h_,i),d(e,mt,i),g(No,mt,null),t(mt,oM),t(mt,Hp),t(mt,lM),t(mt,Ep),g(Ho,Ep,null),d(e,g_,i),d(e,ht,i),g(Eo,ht,null),t(ht,cM),t(ht,qp),t(ht,iM),t(ht,Qp),g(qo,Qp,null),d(e,u_,i),g(Qo,e,i),d(e,f_,i),d(e,gt,i),g(Do,gt,null),t(gt,dM),t(gt,Dp),t(gt,pM),t(gt,Yp),g(Yo,Yp,null),d(e,__,i),d(e,ut,i),g(Po,ut,null),t(ut,mM),t(ut,Pp),t(ut,hM),t(ut,Ap),g(Ao,Ap,null),d(e,b_,i),d(e,ft,i),g(Oo,ft,null),t(ft,gM),t(ft,Op),t(ft,uM),t(ft,Kp),g(Ko,Kp,null),d(e,y_,i),d(e,_t,i),g(el,_t,null),t(_t,fM),t(_t,em),t(_t,_M),t(_t,ln),g(tl,ln,null),t(ln,bM),t(ln,tm),d(e,T_,i),d(e,bt,i),g(sl,bt,null),t(bt,yM),t(bt,sm),t(bt,TM),t(bt,nm),g(nl,nm,null),d(e,v_,i),d(e,yt,i),g(rl,yt,null),t(yt,vM),t(yt,rm),t(yt,MM),t(yt,cn),g(al,cn,null),t(cn,wM),t(cn,am),d(e,M_,i),d(e,Tt,i),g(ol,Tt,null),t(Tt,kM),t(Tt,om),t(Tt,$M),t(Tt,lm),g(ll,lm,null),d(e,w_,i),d(e,vt,i),g(cl,vt,null),t(vt,jM),t(vt,cm),t(vt,xM),t(vt,im),g(il,im,null),d(e,k_,i),d(e,Mt,i),g(dl,Mt,null),t(Mt,JM),t(Mt,dm),t(Mt,UM),t(Mt,pm),g(pl,pm,null),d(e,$_,i),d(e,wt,i),g(ml,wt,null),t(wt,ZM),t(wt,mm),t(wt,CM),t(wt,hm),g(hl,hm,null),d(e,j_,i),d(e,kt,i),g(gl,kt,null),t(kt,WM),t(kt,gm),t(kt,BM),t(kt,um),g(ul,um,null),d(e,x_,i),d(e,$t,i),g(fl,$t,null),t($t,zM),t($t,fm),t($t,IM),t($t,_m),g(_l,_m,null),d(e,J_,i),d(e,jt,i),g(bl,jt,null),t(jt,VM),t(jt,bm),t(jt,GM),t(jt,ym),g(yl,ym,null),d(e,U_,i),g(Tl,e,i),d(e,Z_,i),d(e,vl,i),d(e,C_,i),d(e,We,i),g(Ml,We,null),t(We,FM),t(We,Tm),t(We,XM),t(We,vm),t(We,LM),t(We,Mm),g(wl,Mm,null),d(e,W_,i),d(e,us,i),g(kl,us,null),t(us,RM),t(us,wm),g($l,wm,null),d(e,B_,i),d(e,xt,i),g(jl,xt,null),t(xt,SM),t(xt,km),t(xt,NM),t(xt,$m),g(xl,$m,null),d(e,z_,i),d(e,Jt,i),g(Jl,Jt,null),t(Jt,HM),t(Jt,jm),t(Jt,EM),t(Jt,xm),g(Ul,xm,null),d(e,I_,i),d(e,J,i),g(Zl,J,null),t(J,qM),t(J,Jm),t(J,QM),t(J,Um),t(J,DM),t(J,Zm),t(J,YM),t(J,Cm),t(J,PM),t(J,Wm),t(J,AM),t(J,Bm),t(J,OM),t(J,zm),t(J,KM),t(J,Im),t(J,e0),t(J,Vm),t(J,t0),t(J,Gm),t(J,s0),t(J,Fm),t(J,n0),t(J,Xm),t(J,r0),t(J,Lm),t(J,a0),t(J,Rm),t(J,o0),t(J,Sm),t(J,l0),t(J,Nm),t(J,c0),t(J,Hm),t(J,i0),t(J,Em),t(J,d0),t(J,qm),t(J,p0),g(dn,J,null),t(J,m0),t(J,Qm),g(Cl,Qm,null),d(e,V_,i),d(e,Ut,i),g(Wl,Ut,null),t(Ut,h0),t(Ut,Dm),t(Ut,g0),t(Ut,Ym),g(Bl,Ym,null),d(e,G_,i),g(zl,e,i),d(e,F_,i),d(e,Il,i),d(e,X_,i),d(e,W,i),g(Vl,W,null),t(W,u0),t(W,Pm),t(W,f0),t(W,Am),t(W,_0),g(pn,W,null),t(W,b0),t(W,Om),t(W,y0),t(W,mn),g(Gl,mn,null),t(mn,T0),t(mn,Km),t(W,v0),t(W,hn),g(Fl,hn,null),t(hn,M0),t(hn,eh),t(W,w0),t(W,gn),g(Xl,gn,null),t(gn,k0),t(gn,th),t(W,$0),t(W,un),g(Ll,un,null),t(un,j0),t(un,sh),t(W,x0),t(W,fn),g(Rl,fn,null),t(fn,J0),t(fn,nh),t(W,U0),t(W,_n),g(Sl,_n,null),t(_n,Z0),t(_n,rh),t(W,C0),t(W,Ht),g(Nl,Ht,null),t(Ht,W0),t(Ht,ah),t(Ht,B0),t(Ht,oh),d(e,L_,i),d(e,fs,i),g(Hl,fs,null),t(fs,z0),t(fs,lh),d(e,R_,i),d(e,_s,i),g(El,_s,null),t(_s,I0),t(_s,ch),d(e,S_,i),d(e,Be,i),g(ql,Be,null),t(Be,V0),t(Be,ih),t(Be,G0),t(Be,A),g(Ql,A,null),t(A,F0),t(A,dh),t(A,X0),t(A,ph),t(A,L0),t(A,mh),t(A,R0),t(A,hh),t(A,S0),t(A,gh),t(Be,N0),t(Be,bn),g(Dl,bn,null),t(bn,H0),t(bn,uh),d(e,N_,i),g(Yl,e,i),d(e,H_,i),d(e,ze,i),g(Pl,ze,null),t(ze,E0),t(ze,fh),t(ze,q0),t(ze,_h),g(Al,_h,null),t(ze,Q0),t(ze,bh),g(Ol,bh,null),d(e,E_,i),d(e,H,i),g(Kl,H,null),t(H,D0),t(H,yh),t(H,Y0),t(H,Th),t(H,P0),t(H,vh),t(H,A0),t(H,Mh),g(ec,Mh,null),t(H,O0),t(H,wh),g(tc,wh,null),d(e,q_,i),d(e,Ie,i),g(sc,Ie,null),t(Ie,K0),t(Ie,kh),t(Ie,ew),t(Ie,$h),g(nc,$h,null),t(Ie,tw),t(Ie,jh),g(rc,jh,null),d(e,Q_,i),g(ac,e,i),d(e,D_,i),d(e,G,i),g(oc,G,null),t(G,sw),t(G,xh),t(G,nw),g(yn,G,null),t(G,rw),g(Tn,G,null),t(G,aw),t(G,vn),g(lc,vn,null),t(vn,ow),t(vn,Jh),t(G,lw),t(G,Mn),g(cc,Mn,null),t(Mn,cw),t(Mn,Uh),t(G,iw),t(G,wn),g(ic,wn,null),t(wn,dw),t(wn,Zh),d(e,Y_,i),d(e,de,i),g(dc,de,null),t(de,pw),t(de,Ch),t(de,mw),g(kn,de,null),t(de,hw),g($n,de,null),t(de,gw),t(de,jn),g(pc,jn,null),t(jn,uw),t(jn,Wh),d(e,P_,i),g(mc,e,i),d(e,A_,i),d(e,Zt,i),g(hc,Zt,null),t(Zt,fw),t(Zt,Bh),t(Zt,_w),t(Zt,xn),g(gc,xn,null),t(xn,bw),t(xn,zh),d(e,O_,i),d(e,Ct,i),g(uc,Ct,null),t(Ct,yw),t(Ct,Ih),t(Ct,Tw),t(Ct,Jn),g(fc,Jn,null),t(Jn,vw),t(Jn,Vh),d(e,K_,i),d(e,Wt,i),g(_c,Wt,null),t(Wt,Mw),t(Wt,Gh),t(Wt,ww),t(Wt,Un),g(bc,Un,null),t(Un,kw),t(Un,Fh),d(e,eb,i),d(e,z,i),g(yc,z,null),t(z,$w),t(z,Xh),t(z,jw),t(z,Lh),t(z,xw),g(Zn,z,null),t(z,Jw),t(z,Cn),g(Tc,Cn,null),t(Cn,Uw),t(Cn,Rh),t(z,Zw),t(z,Wn),g(vc,Wn,null),t(Wn,Cw),t(Wn,Sh),t(z,Ww),t(z,Bn),g(Mc,Bn,null),t(Bn,Bw),t(Bn,Nh),t(z,zw),t(z,zn),g(wc,zn,null),t(zn,Iw),t(zn,Hh),t(z,Vw),t(z,In),g(kc,In,null),t(In,Gw),t(In,Eh),d(e,tb,i),d(e,E,i),g($c,E,null),t(E,Fw),t(E,qh),t(E,Xw),t(E,Qh),t(E,Lw),t(E,Dh),t(E,Rw),t(E,Yh),g(jc,Yh,null),t(E,Sw),t(E,Vn),g(xc,Vn,null),t(Vn,Nw),t(Vn,Ph),d(e,sb,i),d(e,Bt,i),g(Jc,Bt,null),t(Bt,Hw),t(Bt,Ah),t(Bt,Ew),g(Gn,Bt,null),d(e,nb,i),d(e,zt,i),g(Uc,zt,null),t(zt,qw),t(zt,Oh),t(zt,Qw),g(Fn,zt,null),d(e,rb,i),d(e,F,i),g(Zc,F,null),t(F,Dw),t(F,Kh),t(F,Yw),t(F,eg),t(F,Pw),g(Xn,F,null),t(F,Aw),t(F,Ln),g(Cc,Ln,null),t(Ln,Ow),t(Ln,tg),t(F,Kw),t(F,Rn),g(Wc,Rn,null),t(Rn,e2),t(Rn,sg),t(F,t2),t(F,Sn),g(Bc,Sn,null),t(Sn,s2),t(Sn,ng),d(e,ab,i),d(e,q,i),g(zc,q,null),t(q,n2),t(q,rg),t(q,r2),t(q,ag),t(q,a2),t(q,Nn),g(Ic,Nn,null),t(Nn,o2),t(Nn,og),t(q,l2),t(q,Hn),g(Vc,Hn,null),t(Hn,c2),t(Hn,lg),t(q,i2),t(q,En),g(Gc,En,null),t(En,d2),t(En,cg),d(e,ob,i),d(e,Q,i),g(Fc,Q,null),t(Q,p2),t(Q,ig),t(Q,m2),g(qn,Q,null),t(Q,h2),t(Q,Qn),g(Xc,Qn,null),t(Qn,g2),t(Qn,dg),t(Q,u2),t(Q,Dn),g(Lc,Dn,null),t(Dn,f2),t(Dn,pg),t(Q,_2),t(Q,Yn),g(Rc,Yn,null),t(Yn,b2),t(Yn,mg),d(e,lb,i),d(e,D,i),g(Sc,D,null),t(D,y2),t(D,hg),t(D,T2),g(Pn,D,null),t(D,v2),t(D,An),g(Nc,An,null),t(An,M2),t(An,gg),t(D,w2),t(D,On),g(Hc,On,null),t(On,k2),t(On,ug),t(D,$2),t(D,Kn),g(Ec,Kn,null),t(Kn,j2),t(Kn,fg),d(e,cb,i),d(e,Y,i),g(qc,Y,null),t(Y,x2),t(Y,_g),t(Y,J2),g(er,Y,null),t(Y,U2),t(Y,bg),g(Qc,bg,null),t(Y,Z2),t(Y,yg),g(Dc,yg,null),t(Y,C2),t(Y,tr),g(Yc,tr,null),t(tr,W2),t(tr,Tg),d(e,ib,i),d(e,I,i),g(Pc,I,null),t(I,B2),t(I,vg),t(I,z2),t(I,Mg),t(I,I2),t(I,wg),t(I,V2),t(I,kg),t(I,G2),g(sr,I,null),t(I,F2),t(I,$g),g(Ac,$g,null),t(I,X2),t(I,jg),g(Oc,jg,null),d(e,db,i),d(e,V,i),g(Kc,V,null),t(V,L2),t(V,xg),t(V,R2),g(nr,V,null),t(V,S2),t(V,rr),g(ei,rr,null),t(rr,N2),t(rr,Jg),t(V,H2),t(V,ar),g(ti,ar,null),t(ar,E2),t(ar,Ug),t(V,q2),t(V,or),g(si,or,null),t(or,Q2),t(or,Zg),t(V,D2),t(V,Cg),g(ni,Cg,null),t(V,Y2),t(V,lr),g(ri,lr,null),t(lr,P2),t(lr,Wg),d(e,pb,i),d(e,P,i),g(ai,P,null),t(P,A2),t(P,Bg),t(P,O2),g(cr,P,null),t(P,K2),t(P,zg),g(oi,zg,null),t(P,e1),t(P,Ig),g(li,Ig,null),t(P,t1),t(P,Vg),g(ci,Vg,null),d(e,mb,i),g(ii,e,i),d(e,hb,i),d(e,pe,i),g(di,pe,null),t(pe,s1),t(pe,Gg),t(pe,n1),t(pe,Fg),t(pe,r1),g(ir,pe,null),t(pe,a1),t(pe,dr),g(pi,dr,null),t(dr,o1),t(dr,Xg),d(e,gb,i),g(mi,e,i),d(e,ub,i),d(e,wu,i),fb=!0},p(e,[i]){const hi={};i&2&&(hi.$$scope={dirty:i,ctx:e}),js.$set(hi);const gi={};i&2&&(gi.$$scope={dirty:i,ctx:e}),xs.$set(gi);const ui={};i&2&&(ui.$$scope={dirty:i,ctx:e}),Js.$set(ui);const fi={};i&2&&(fi.$$scope={dirty:i,ctx:e}),Us.$set(fi);const _i={};i&2&&(_i.$$scope={dirty:i,ctx:e}),Zs.$set(_i);const bi={};i&2&&(bi.$$scope={dirty:i,ctx:e}),Cs.$set(bi);const yi={};i&2&&(yi.$$scope={dirty:i,ctx:e}),Ws.$set(yi);const Ti={};i&2&&(Ti.$$scope={dirty:i,ctx:e}),Bs.$set(Ti);const vi={};i&2&&(vi.$$scope={dirty:i,ctx:e}),zs.$set(vi);const Mi={};i&2&&(Mi.$$scope={dirty:i,ctx:e}),Is.$set(Mi);const wi={};i&2&&(wi.$$scope={dirty:i,ctx:e}),Vs.$set(wi);const ki={};i&2&&(ki.$$scope={dirty:i,ctx:e}),Gs.$set(ki);const $i={};i&2&&($i.$$scope={dirty:i,ctx:e}),Fs.$set($i);const ji={};i&2&&(ji.$$scope={dirty:i,ctx:e}),Xs.$set(ji);const bs={};i&2&&(bs.$$scope={dirty:i,ctx:e}),Ls.$set(bs);const xi={};i&2&&(xi.$$scope={dirty:i,ctx:e}),Rs.$set(xi);const ys={};i&2&&(ys.$$scope={dirty:i,ctx:e}),Ss.$set(ys);const Ji={};i&2&&(Ji.$$scope={dirty:i,ctx:e}),Ns.$set(Ji);const Ts={};i&2&&(Ts.$$scope={dirty:i,ctx:e}),Hs.$set(Ts);const Ui={};i&2&&(Ui.$$scope={dirty:i,ctx:e}),Es.$set(Ui);const It={};i&2&&(It.$$scope={dirty:i,ctx:e}),qs.$set(It);const ku={};i&2&&(ku.$$scope={dirty:i,ctx:e}),Qs.$set(ku);const me={};i&2&&(me.$$scope={dirty:i,ctx:e}),Ds.$set(me);const $u={};i&2&&($u.$$scope={dirty:i,ctx:e}),Ys.$set($u);const Ve={};i&2&&(Ve.$$scope={dirty:i,ctx:e}),Ps.$set(Ve);const ju={};i&2&&(ju.$$scope={dirty:i,ctx:e}),As.$set(ju);const Ge={};i&2&&(Ge.$$scope={dirty:i,ctx:e}),Os.$set(Ge);const xu={};i&2&&(xu.$$scope={dirty:i,ctx:e}),Ks.$set(xu);const Vt={};i&2&&(Vt.$$scope={dirty:i,ctx:e}),en.$set(Vt);const Ju={};i&2&&(Ju.$$scope={dirty:i,ctx:e}),tn.$set(Ju);const Gt={};i&2&&(Gt.$$scope={dirty:i,ctx:e}),sn.$set(Gt);const Uu={};i&2&&(Uu.$$scope={dirty:i,ctx:e}),nn.$set(Uu);const Ft={};i&2&&(Ft.$$scope={dirty:i,ctx:e}),rn.$set(Ft);const Zu={};i&2&&(Zu.$$scope={dirty:i,ctx:e}),dn.$set(Zu);const Xt={};i&2&&(Xt.$$scope={dirty:i,ctx:e}),pn.$set(Xt);const Cu={};i&2&&(Cu.$$scope={dirty:i,ctx:e}),yn.$set(Cu);const Lt={};i&2&&(Lt.$$scope={dirty:i,ctx:e}),Tn.$set(Lt);const Wu={};i&2&&(Wu.$$scope={dirty:i,ctx:e}),kn.$set(Wu);const he={};i&2&&(he.$$scope={dirty:i,ctx:e}),$n.$set(he);const Bu={};i&2&&(Bu.$$scope={dirty:i,ctx:e}),Zn.$set(Bu);const Rt={};i&2&&(Rt.$$scope={dirty:i,ctx:e}),Gn.$set(Rt);const zu={};i&2&&(zu.$$scope={dirty:i,ctx:e}),Fn.$set(zu);const St={};i&2&&(St.$$scope={dirty:i,ctx:e}),Xn.$set(St);const Iu={};i&2&&(Iu.$$scope={dirty:i,ctx:e}),qn.$set(Iu);const vs={};i&2&&(vs.$$scope={dirty:i,ctx:e}),Pn.$set(vs);const Vu={};i&2&&(Vu.$$scope={dirty:i,ctx:e}),er.$set(Vu);const Ms={};i&2&&(Ms.$$scope={dirty:i,ctx:e}),sr.$set(Ms);const Gu={};i&2&&(Gu.$$scope={dirty:i,ctx:e}),nr.$set(Gu);const Nt={};i&2&&(Nt.$$scope={dirty:i,ctx:e}),cr.$set(Nt);const Fu={};i&2&&(Fu.$$scope={dirty:i,ctx:e}),ir.$set(Fu)},i(e){fb||(u(w.$$.fragment,e),u(Mr.$$.fragment,e),u($r.$$.fragment,e),u(Cr.$$.fragment,e),u(Ir.$$.fragment,e),u(Vr.$$.fragment,e),u(Gr.$$.fragment,e),u(Fr.$$.fragment,e),u(Xr.$$.fragment,e),u(Lr.$$.fragment,e),u(Rr.$$.fragment,e),u(Sr.$$.fragment,e),u(Nr.$$.fragment,e),u(Hr.$$.fragment,e),u(Er.$$.fragment,e),u(qr.$$.fragment,e),u(Qr.$$.fragment,e),u(Dr.$$.fragment,e),u(Yr.$$.fragment,e),u(Pr.$$.fragment,e),u(Ar.$$.fragment,e),u(Or.$$.fragment,e),u(Kr.$$.fragment,e),u(ea.$$.fragment,e),u(ta.$$.fragment,e),u(sa.$$.fragment,e),u(na.$$.fragment,e),u(ra.$$.fragment,e),u(oa.$$.fragment,e),u(la.$$.fragment,e),u(js.$$.fragment,e),u(ca.$$.fragment,e),u(ia.$$.fragment,e),u(xs.$$.fragment,e),u(Js.$$.fragment,e),u(da.$$.fragment,e),u(pa.$$.fragment,e),u(Us.$$.fragment,e),u(ma.$$.fragment,e),u(ha.$$.fragment,e),u(Zs.$$.fragment,e),u(ga.$$.fragment,e),u(ua.$$.fragment,e),u(Cs.$$.fragment,e),u(fa.$$.fragment,e),u(_a.$$.fragment,e),u(Ws.$$.fragment,e),u(ba.$$.fragment,e),u(ya.$$.fragment,e),u(Bs.$$.fragment,e),u(Ta.$$.fragment,e),u(va.$$.fragment,e),u(zs.$$.fragment,e),u(Ma.$$.fragment,e),u(wa.$$.fragment,e),u(Is.$$.fragment,e),u(ka.$$.fragment,e),u($a.$$.fragment,e),u(Vs.$$.fragment,e),u(ja.$$.fragment,e),u(xa.$$.fragment,e),u(Ja.$$.fragment,e),u(Ua.$$.fragment,e),u(Gs.$$.fragment,e),u(Za.$$.fragment,e),u(Ca.$$.fragment,e),u(Wa.$$.fragment,e),u(Ba.$$.fragment,e),u(za.$$.fragment,e),u(Ia.$$.fragment,e),u(Fs.$$.fragment,e),u(Va.$$.fragment,e),u(Ga.$$.fragment,e),u(Xs.$$.fragment,e),u(Fa.$$.fragment,e),u(Xa.$$.fragment,e),u(Ls.$$.fragment,e),u(La.$$.fragment,e),u(Ra.$$.fragment,e),u(Rs.$$.fragment,e),u(Ss.$$.fragment,e),u(Sa.$$.fragment,e),u(Na.$$.fragment,e),u(Ns.$$.fragment,e),u(Hs.$$.fragment,e),u(Ha.$$.fragment,e),u(Ea.$$.fragment,e),u(Es.$$.fragment,e),u(qa.$$.fragment,e),u(Qa.$$.fragment,e),u(qs.$$.fragment,e),u(Da.$$.fragment,e),u(Ya.$$.fragment,e),u(Qs.$$.fragment,e),u(Ds.$$.fragment,e),u(Pa.$$.fragment,e),u(Aa.$$.fragment,e),u(Ys.$$.fragment,e),u(Oa.$$.fragment,e),u(Ka.$$.fragment,e),u(Ps.$$.fragment,e),u(eo.$$.fragment,e),u(to.$$.fragment,e),u(As.$$.fragment,e),u(Os.$$.fragment,e),u(so.$$.fragment,e),u(no.$$.fragment,e),u(Ks.$$.fragment,e),u(ro.$$.fragment,e),u(ao.$$.fragment,e),u(en.$$.fragment,e),u(oo.$$.fragment,e),u(lo.$$.fragment,e),u(tn.$$.fragment,e),u(co.$$.fragment,e),u(io.$$.fragment,e),u(sn.$$.fragment,e),u(po.$$.fragment,e),u(mo.$$.fragment,e),u(nn.$$.fragment,e),u(ho.$$.fragment,e),u(go.$$.fragment,e),u(rn.$$.fragment,e),u(uo.$$.fragment,e),u(fo.$$.fragment,e),u(_o.$$.fragment,e),u(bo.$$.fragment,e),u(yo.$$.fragment,e),u(To.$$.fragment,e),u(vo.$$.fragment,e),u(Mo.$$.fragment,e),u(wo.$$.fragment,e),u(ko.$$.fragment,e),u($o.$$.fragment,e),u(jo.$$.fragment,e),u(xo.$$.fragment,e),u(Jo.$$.fragment,e),u(Uo.$$.fragment,e),u(Zo.$$.fragment,e),u(Co.$$.fragment,e),u(Wo.$$.fragment,e),u(Bo.$$.fragment,e),u(zo.$$.fragment,e),u(Io.$$.fragment,e),u(Vo.$$.fragment,e),u(Go.$$.fragment,e),u(Fo.$$.fragment,e),u(Xo.$$.fragment,e),u(Lo.$$.fragment,e),u(Ro.$$.fragment,e),u(So.$$.fragment,e),u(No.$$.fragment,e),u(Ho.$$.fragment,e),u(Eo.$$.fragment,e),u(qo.$$.fragment,e),u(Qo.$$.fragment,e),u(Do.$$.fragment,e),u(Yo.$$.fragment,e),u(Po.$$.fragment,e),u(Ao.$$.fragment,e),u(Oo.$$.fragment,e),u(Ko.$$.fragment,e),u(el.$$.fragment,e),u(tl.$$.fragment,e),u(sl.$$.fragment,e),u(nl.$$.fragment,e),u(rl.$$.fragment,e),u(al.$$.fragment,e),u(ol.$$.fragment,e),u(ll.$$.fragment,e),u(cl.$$.fragment,e),u(il.$$.fragment,e),u(dl.$$.fragment,e),u(pl.$$.fragment,e),u(ml.$$.fragment,e),u(hl.$$.fragment,e),u(gl.$$.fragment,e),u(ul.$$.fragment,e),u(fl.$$.fragment,e),u(_l.$$.fragment,e),u(bl.$$.fragment,e),u(yl.$$.fragment,e),u(Tl.$$.fragment,e),u(Ml.$$.fragment,e),u(wl.$$.fragment,e),u(kl.$$.fragment,e),u($l.$$.fragment,e),u(jl.$$.fragment,e),u(xl.$$.fragment,e),u(Jl.$$.fragment,e),u(Ul.$$.fragment,e),u(Zl.$$.fragment,e),u(dn.$$.fragment,e),u(Cl.$$.fragment,e),u(Wl.$$.fragment,e),u(Bl.$$.fragment,e),u(zl.$$.fragment,e),u(Vl.$$.fragment,e),u(pn.$$.fragment,e),u(Gl.$$.fragment,e),u(Fl.$$.fragment,e),u(Xl.$$.fragment,e),u(Ll.$$.fragment,e),u(Rl.$$.fragment,e),u(Sl.$$.fragment,e),u(Nl.$$.fragment,e),u(Hl.$$.fragment,e),u(El.$$.fragment,e),u(ql.$$.fragment,e),u(Ql.$$.fragment,e),u(Dl.$$.fragment,e),u(Yl.$$.fragment,e),u(Pl.$$.fragment,e),u(Al.$$.fragment,e),u(Ol.$$.fragment,e),u(Kl.$$.fragment,e),u(ec.$$.fragment,e),u(tc.$$.fragment,e),u(sc.$$.fragment,e),u(nc.$$.fragment,e),u(rc.$$.fragment,e),u(ac.$$.fragment,e),u(oc.$$.fragment,e),u(yn.$$.fragment,e),u(Tn.$$.fragment,e),u(lc.$$.fragment,e),u(cc.$$.fragment,e),u(ic.$$.fragment,e),u(dc.$$.fragment,e),u(kn.$$.fragment,e),u($n.$$.fragment,e),u(pc.$$.fragment,e),u(mc.$$.fragment,e),u(hc.$$.fragment,e),u(gc.$$.fragment,e),u(uc.$$.fragment,e),u(fc.$$.fragment,e),u(_c.$$.fragment,e),u(bc.$$.fragment,e),u(yc.$$.fragment,e),u(Zn.$$.fragment,e),u(Tc.$$.fragment,e),u(vc.$$.fragment,e),u(Mc.$$.fragment,e),u(wc.$$.fragment,e),u(kc.$$.fragment,e),u($c.$$.fragment,e),u(jc.$$.fragment,e),u(xc.$$.fragment,e),u(Jc.$$.fragment,e),u(Gn.$$.fragment,e),u(Uc.$$.fragment,e),u(Fn.$$.fragment,e),u(Zc.$$.fragment,e),u(Xn.$$.fragment,e),u(Cc.$$.fragment,e),u(Wc.$$.fragment,e),u(Bc.$$.fragment,e),u(zc.$$.fragment,e),u(Ic.$$.fragment,e),u(Vc.$$.fragment,e),u(Gc.$$.fragment,e),u(Fc.$$.fragment,e),u(qn.$$.fragment,e),u(Xc.$$.fragment,e),u(Lc.$$.fragment,e),u(Rc.$$.fragment,e),u(Sc.$$.fragment,e),u(Pn.$$.fragment,e),u(Nc.$$.fragment,e),u(Hc.$$.fragment,e),u(Ec.$$.fragment,e),u(qc.$$.fragment,e),u(er.$$.fragment,e),u(Qc.$$.fragment,e),u(Dc.$$.fragment,e),u(Yc.$$.fragment,e),u(Pc.$$.fragment,e),u(sr.$$.fragment,e),u(Ac.$$.fragment,e),u(Oc.$$.fragment,e),u(Kc.$$.fragment,e),u(nr.$$.fragment,e),u(ei.$$.fragment,e),u(ti.$$.fragment,e),u(si.$$.fragment,e),u(ni.$$.fragment,e),u(ri.$$.fragment,e),u(ai.$$.fragment,e),u(cr.$$.fragment,e),u(oi.$$.fragment,e),u(li.$$.fragment,e),u(ci.$$.fragment,e),u(ii.$$.fragment,e),u(di.$$.fragment,e),u(ir.$$.fragment,e),u(pi.$$.fragment,e),u(mi.$$.fragment,e),fb=!0)},o(e){f(w.$$.fragment,e),f(Mr.$$.fragment,e),f($r.$$.fragment,e),f(Cr.$$.fragment,e),f(Ir.$$.fragment,e),f(Vr.$$.fragment,e),f(Gr.$$.fragment,e),f(Fr.$$.fragment,e),f(Xr.$$.fragment,e),f(Lr.$$.fragment,e),f(Rr.$$.fragment,e),f(Sr.$$.fragment,e),f(Nr.$$.fragment,e),f(Hr.$$.fragment,e),f(Er.$$.fragment,e),f(qr.$$.fragment,e),f(Qr.$$.fragment,e),f(Dr.$$.fragment,e),f(Yr.$$.fragment,e),f(Pr.$$.fragment,e),f(Ar.$$.fragment,e),f(Or.$$.fragment,e),f(Kr.$$.fragment,e),f(ea.$$.fragment,e),f(ta.$$.fragment,e),f(sa.$$.fragment,e),f(na.$$.fragment,e),f(ra.$$.fragment,e),f(oa.$$.fragment,e),f(la.$$.fragment,e),f(js.$$.fragment,e),f(ca.$$.fragment,e),f(ia.$$.fragment,e),f(xs.$$.fragment,e),f(Js.$$.fragment,e),f(da.$$.fragment,e),f(pa.$$.fragment,e),f(Us.$$.fragment,e),f(ma.$$.fragment,e),f(ha.$$.fragment,e),f(Zs.$$.fragment,e),f(ga.$$.fragment,e),f(ua.$$.fragment,e),f(Cs.$$.fragment,e),f(fa.$$.fragment,e),f(_a.$$.fragment,e),f(Ws.$$.fragment,e),f(ba.$$.fragment,e),f(ya.$$.fragment,e),f(Bs.$$.fragment,e),f(Ta.$$.fragment,e),f(va.$$.fragment,e),f(zs.$$.fragment,e),f(Ma.$$.fragment,e),f(wa.$$.fragment,e),f(Is.$$.fragment,e),f(ka.$$.fragment,e),f($a.$$.fragment,e),f(Vs.$$.fragment,e),f(ja.$$.fragment,e),f(xa.$$.fragment,e),f(Ja.$$.fragment,e),f(Ua.$$.fragment,e),f(Gs.$$.fragment,e),f(Za.$$.fragment,e),f(Ca.$$.fragment,e),f(Wa.$$.fragment,e),f(Ba.$$.fragment,e),f(za.$$.fragment,e),f(Ia.$$.fragment,e),f(Fs.$$.fragment,e),f(Va.$$.fragment,e),f(Ga.$$.fragment,e),f(Xs.$$.fragment,e),f(Fa.$$.fragment,e),f(Xa.$$.fragment,e),f(Ls.$$.fragment,e),f(La.$$.fragment,e),f(Ra.$$.fragment,e),f(Rs.$$.fragment,e),f(Ss.$$.fragment,e),f(Sa.$$.fragment,e),f(Na.$$.fragment,e),f(Ns.$$.fragment,e),f(Hs.$$.fragment,e),f(Ha.$$.fragment,e),f(Ea.$$.fragment,e),f(Es.$$.fragment,e),f(qa.$$.fragment,e),f(Qa.$$.fragment,e),f(qs.$$.fragment,e),f(Da.$$.fragment,e),f(Ya.$$.fragment,e),f(Qs.$$.fragment,e),f(Ds.$$.fragment,e),f(Pa.$$.fragment,e),f(Aa.$$.fragment,e),f(Ys.$$.fragment,e),f(Oa.$$.fragment,e),f(Ka.$$.fragment,e),f(Ps.$$.fragment,e),f(eo.$$.fragment,e),f(to.$$.fragment,e),f(As.$$.fragment,e),f(Os.$$.fragment,e),f(so.$$.fragment,e),f(no.$$.fragment,e),f(Ks.$$.fragment,e),f(ro.$$.fragment,e),f(ao.$$.fragment,e),f(en.$$.fragment,e),f(oo.$$.fragment,e),f(lo.$$.fragment,e),f(tn.$$.fragment,e),f(co.$$.fragment,e),f(io.$$.fragment,e),f(sn.$$.fragment,e),f(po.$$.fragment,e),f(mo.$$.fragment,e),f(nn.$$.fragment,e),f(ho.$$.fragment,e),f(go.$$.fragment,e),f(rn.$$.fragment,e),f(uo.$$.fragment,e),f(fo.$$.fragment,e),f(_o.$$.fragment,e),f(bo.$$.fragment,e),f(yo.$$.fragment,e),f(To.$$.fragment,e),f(vo.$$.fragment,e),f(Mo.$$.fragment,e),f(wo.$$.fragment,e),f(ko.$$.fragment,e),f($o.$$.fragment,e),f(jo.$$.fragment,e),f(xo.$$.fragment,e),f(Jo.$$.fragment,e),f(Uo.$$.fragment,e),f(Zo.$$.fragment,e),f(Co.$$.fragment,e),f(Wo.$$.fragment,e),f(Bo.$$.fragment,e),f(zo.$$.fragment,e),f(Io.$$.fragment,e),f(Vo.$$.fragment,e),f(Go.$$.fragment,e),f(Fo.$$.fragment,e),f(Xo.$$.fragment,e),f(Lo.$$.fragment,e),f(Ro.$$.fragment,e),f(So.$$.fragment,e),f(No.$$.fragment,e),f(Ho.$$.fragment,e),f(Eo.$$.fragment,e),f(qo.$$.fragment,e),f(Qo.$$.fragment,e),f(Do.$$.fragment,e),f(Yo.$$.fragment,e),f(Po.$$.fragment,e),f(Ao.$$.fragment,e),f(Oo.$$.fragment,e),f(Ko.$$.fragment,e),f(el.$$.fragment,e),f(tl.$$.fragment,e),f(sl.$$.fragment,e),f(nl.$$.fragment,e),f(rl.$$.fragment,e),f(al.$$.fragment,e),f(ol.$$.fragment,e),f(ll.$$.fragment,e),f(cl.$$.fragment,e),f(il.$$.fragment,e),f(dl.$$.fragment,e),f(pl.$$.fragment,e),f(ml.$$.fragment,e),f(hl.$$.fragment,e),f(gl.$$.fragment,e),f(ul.$$.fragment,e),f(fl.$$.fragment,e),f(_l.$$.fragment,e),f(bl.$$.fragment,e),f(yl.$$.fragment,e),f(Tl.$$.fragment,e),f(Ml.$$.fragment,e),f(wl.$$.fragment,e),f(kl.$$.fragment,e),f($l.$$.fragment,e),f(jl.$$.fragment,e),f(xl.$$.fragment,e),f(Jl.$$.fragment,e),f(Ul.$$.fragment,e),f(Zl.$$.fragment,e),f(dn.$$.fragment,e),f(Cl.$$.fragment,e),f(Wl.$$.fragment,e),f(Bl.$$.fragment,e),f(zl.$$.fragment,e),f(Vl.$$.fragment,e),f(pn.$$.fragment,e),f(Gl.$$.fragment,e),f(Fl.$$.fragment,e),f(Xl.$$.fragment,e),f(Ll.$$.fragment,e),f(Rl.$$.fragment,e),f(Sl.$$.fragment,e),f(Nl.$$.fragment,e),f(Hl.$$.fragment,e),f(El.$$.fragment,e),f(ql.$$.fragment,e),f(Ql.$$.fragment,e),f(Dl.$$.fragment,e),f(Yl.$$.fragment,e),f(Pl.$$.fragment,e),f(Al.$$.fragment,e),f(Ol.$$.fragment,e),f(Kl.$$.fragment,e),f(ec.$$.fragment,e),f(tc.$$.fragment,e),f(sc.$$.fragment,e),f(nc.$$.fragment,e),f(rc.$$.fragment,e),f(ac.$$.fragment,e),f(oc.$$.fragment,e),f(yn.$$.fragment,e),f(Tn.$$.fragment,e),f(lc.$$.fragment,e),f(cc.$$.fragment,e),f(ic.$$.fragment,e),f(dc.$$.fragment,e),f(kn.$$.fragment,e),f($n.$$.fragment,e),f(pc.$$.fragment,e),f(mc.$$.fragment,e),f(hc.$$.fragment,e),f(gc.$$.fragment,e),f(uc.$$.fragment,e),f(fc.$$.fragment,e),f(_c.$$.fragment,e),f(bc.$$.fragment,e),f(yc.$$.fragment,e),f(Zn.$$.fragment,e),f(Tc.$$.fragment,e),f(vc.$$.fragment,e),f(Mc.$$.fragment,e),f(wc.$$.fragment,e),f(kc.$$.fragment,e),f($c.$$.fragment,e),f(jc.$$.fragment,e),f(xc.$$.fragment,e),f(Jc.$$.fragment,e),f(Gn.$$.fragment,e),f(Uc.$$.fragment,e),f(Fn.$$.fragment,e),f(Zc.$$.fragment,e),f(Xn.$$.fragment,e),f(Cc.$$.fragment,e),f(Wc.$$.fragment,e),f(Bc.$$.fragment,e),f(zc.$$.fragment,e),f(Ic.$$.fragment,e),f(Vc.$$.fragment,e),f(Gc.$$.fragment,e),f(Fc.$$.fragment,e),f(qn.$$.fragment,e),f(Xc.$$.fragment,e),f(Lc.$$.fragment,e),f(Rc.$$.fragment,e),f(Sc.$$.fragment,e),f(Pn.$$.fragment,e),f(Nc.$$.fragment,e),f(Hc.$$.fragment,e),f(Ec.$$.fragment,e),f(qc.$$.fragment,e),f(er.$$.fragment,e),f(Qc.$$.fragment,e),f(Dc.$$.fragment,e),f(Yc.$$.fragment,e),f(Pc.$$.fragment,e),f(sr.$$.fragment,e),f(Ac.$$.fragment,e),f(Oc.$$.fragment,e),f(Kc.$$.fragment,e),f(nr.$$.fragment,e),f(ei.$$.fragment,e),f(ti.$$.fragment,e),f(si.$$.fragment,e),f(ni.$$.fragment,e),f(ri.$$.fragment,e),f(ai.$$.fragment,e),f(cr.$$.fragment,e),f(oi.$$.fragment,e),f(li.$$.fragment,e),f(ci.$$.fragment,e),f(ii.$$.fragment,e),f(di.$$.fragment,e),f(ir.$$.fragment,e),f(pi.$$.fragment,e),f(mi.$$.fragment,e),fb=!1},d(e){e&&(n($),n(b),n(p),n(s),n(k),n(Xu),n(Lu),n(wr),n(Ru),n(kr),n(Su),n(Nu),n(jr),n(Hu),n(xr),n(Eu),n(Jr),n(qu),n(Ur),n(Qu),n(Zr),n(Du),n(Yu),n(Wr),n(Pu),n(Br),n(Au),n(zr),n(Ou),n(Ku),n(ts),n(ef),n(ss),n(tf),n(ns),n(sf),n(rs),n(nf),n(rf),n(as),n(af),n(os),n(of),n(ls),n(lf),n(cs),n(cf),n(is),n(df),n(ds),n(pf),n(ps),n(mf),n(ms),n(hf),n(hs),n(gf),n(gs),n(uf),n(ff),n(De),n(_f),n(Ye),n(bf),n(Pe),n(yf),n(Tf),n(aa),n(vf),n(Mf),n(_e),n(wf),n(L),n(kf),n(ee),n($f),n(te),n(jf),n(be),n(xf),n(ye),n(Jf),n(Te),n(Uf),n(ve),n(Zf),n(Me),n(Cf),n(R),n(Wf),n(we),n(Bf),n(ke),n(zf),n(Ae),n(If),n(Oe),n(Vf),n($e),n(Gf),n(je),n(Ff),n(S),n(Xf),n(se),n(Lf),n(ne),n(Rf),n(xe),n(Sf),n(re),n(Nf),n(ae),n(Hf),n(Je),n(Ef),n(Ue),n(qf),n(oe),n(Qf),n(Ze),n(Df),n(Ce),n(Yf),n(le),n(Pf),n(ce),n(Af),n(ie),n(Of),n(N),n(Kf),n(e_),n(Ke),n(t_),n(et),n(s_),n(tt),n(n_),n(st),n(r_),n(nt),n(a_),n(rt),n(o_),n(at),n(l_),n(ot),n(c_),n(lt),n(i_),n(ct),n(d_),n(it),n(p_),n(dt),n(m_),n(pt),n(h_),n(mt),n(g_),n(ht),n(u_),n(f_),n(gt),n(__),n(ut),n(b_),n(ft),n(y_),n(_t),n(T_),n(bt),n(v_),n(yt),n(M_),n(Tt),n(w_),n(vt),n(k_),n(Mt),n($_),n(wt),n(j_),n(kt),n(x_),n($t),n(J_),n(jt),n(U_),n(Z_),n(vl),n(C_),n(We),n(W_),n(us),n(B_),n(xt),n(z_),n(Jt),n(I_),n(J),n(V_),n(Ut),n(G_),n(F_),n(Il),n(X_),n(W),n(L_),n(fs),n(R_),n(_s),n(S_),n(Be),n(N_),n(H_),n(ze),n(E_),n(H),n(q_),n(Ie),n(Q_),n(D_),n(G),n(Y_),n(de),n(P_),n(A_),n(Zt),n(O_),n(Ct),n(K_),n(Wt),n(eb),n(z),n(tb),n(E),n(sb),n(Bt),n(nb),n(zt),n(rb),n(F),n(ab),n(q),n(ob),n(Q),n(lb),n(D),n(cb),n(Y),n(ib),n(I),n(db),n(V),n(pb),n(P),n(mb),n(hb),n(pe),n(gb),n(ub),n(wu)),n(c),_(w,e),_(Mr,e),_($r,e),_(Cr,e),_(Ir,e),_(Vr),_(Gr),_(Fr),_(Xr),_(Lr,e),_(Rr),_(Sr),_(Nr),_(Hr),_(Er),_(qr),_(Qr),_(Dr),_(Yr),_(Pr),_(Ar,e),_(Or),_(Kr),_(ea),_(ta),_(sa),_(na),_(ra,e),_(oa,e),_(la),_(js),_(ca),_(ia),_(xs),_(Js),_(da),_(pa),_(Us),_(ma),_(ha),_(Zs),_(ga),_(ua),_(Cs),_(fa),_(_a),_(Ws),_(ba),_(ya),_(Bs),_(Ta),_(va),_(zs),_(Ma),_(wa),_(Is),_(ka),_($a),_(Vs),_(ja),_(xa),_(Ja),_(Ua),_(Gs),_(Za),_(Ca),_(Wa),_(Ba),_(za),_(Ia),_(Fs),_(Va),_(Ga),_(Xs),_(Fa),_(Xa),_(Ls),_(La),_(Ra),_(Rs),_(Ss),_(Sa),_(Na),_(Ns),_(Hs),_(Ha),_(Ea),_(Es),_(qa),_(Qa),_(qs),_(Da),_(Ya),_(Qs),_(Ds),_(Pa),_(Aa),_(Ys),_(Oa),_(Ka),_(Ps),_(eo),_(to),_(As),_(Os),_(so),_(no),_(Ks),_(ro),_(ao),_(en),_(oo),_(lo),_(tn),_(co),_(io),_(sn),_(po),_(mo),_(nn),_(ho),_(go),_(rn),_(uo),_(fo,e),_(_o),_(bo),_(yo),_(To),_(vo),_(Mo),_(wo),_(ko),_($o),_(jo),_(xo),_(Jo),_(Uo),_(Zo),_(Co),_(Wo),_(Bo),_(zo),_(Io),_(Vo),_(Go),_(Fo),_(Xo),_(Lo),_(Ro),_(So),_(No),_(Ho),_(Eo),_(qo),_(Qo,e),_(Do),_(Yo),_(Po),_(Ao),_(Oo),_(Ko),_(el),_(tl),_(sl),_(nl),_(rl),_(al),_(ol),_(ll),_(cl),_(il),_(dl),_(pl),_(ml),_(hl),_(gl),_(ul),_(fl),_(_l),_(bl),_(yl),_(Tl,e),_(Ml),_(wl),_(kl),_($l),_(jl),_(xl),_(Jl),_(Ul),_(Zl),_(dn),_(Cl),_(Wl),_(Bl),_(zl,e),_(Vl),_(pn),_(Gl),_(Fl),_(Xl),_(Ll),_(Rl),_(Sl),_(Nl),_(Hl),_(El),_(ql),_(Ql),_(Dl),_(Yl,e),_(Pl),_(Al),_(Ol),_(Kl),_(ec),_(tc),_(sc),_(nc),_(rc),_(ac,e),_(oc),_(yn),_(Tn),_(lc),_(cc),_(ic),_(dc),_(kn),_($n),_(pc),_(mc,e),_(hc),_(gc),_(uc),_(fc),_(_c),_(bc),_(yc),_(Zn),_(Tc),_(vc),_(Mc),_(wc),_(kc),_($c),_(jc),_(xc),_(Jc),_(Gn),_(Uc),_(Fn),_(Zc),_(Xn),_(Cc),_(Wc),_(Bc),_(zc),_(Ic),_(Vc),_(Gc),_(Fc),_(qn),_(Xc),_(Lc),_(Rc),_(Sc),_(Pn),_(Nc),_(Hc),_(Ec),_(qc),_(er),_(Qc),_(Dc),_(Yc),_(Pc),_(sr),_(Ac),_(Oc),_(Kc),_(nr),_(ei),_(ti),_(si),_(ni),_(ri),_(ai),_(cr),_(oi),_(li),_(ci),_(ii,e),_(di),_(ir),_(pi),_(mi,e)}}}const yU='{"title":"Utilities for Generation","local":"utilities-for-generation","sections":[{"title":"Generate Outputs","local":"generate-outputs","sections":[{"title":"PyTorch","local":"transformers.generation.GenerateDecoderOnlyOutput","sections":[],"depth":3},{"title":"TensorFlow","local":"transformers.generation.TFGreedySearchEncoderDecoderOutput","sections":[],"depth":3},{"title":"FLAX","local":"transformers.generation.FlaxSampleOutput","sections":[],"depth":3}],"depth":2},{"title":"LogitsProcessor","local":"logitsprocessor","sections":[{"title":"PyTorch","local":"transformers.AlternatingCodebooksLogitsProcessor","sections":[],"depth":3},{"title":"TensorFlow","local":"transformers.TFForcedBOSTokenLogitsProcessor","sections":[],"depth":3},{"title":"FLAX","local":"transformers.FlaxForcedBOSTokenLogitsProcessor","sections":[],"depth":3}],"depth":2},{"title":"StoppingCriteria","local":"transformers.StoppingCriteria","sections":[],"depth":2},{"title":"Constraints","local":"transformers.Constraint","sections":[],"depth":2},{"title":"BeamSearch","local":"transformers.BeamScorer","sections":[],"depth":2},{"title":"Streamers","local":"transformers.TextStreamer","sections":[],"depth":2},{"title":"Caches","local":"transformers.Cache","sections":[],"depth":2},{"title":"Watermark Utils","local":"transformers.WatermarkDetector","sections":[],"depth":2}],"depth":1}';function TU(j){return _J(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class JU extends bJ{constructor(c){super(),yJ(this,c,TU,bU,fJ,{})}}export{JU as component};
