import{s as el,f as nl,n as pl,o as il}from"../chunks/scheduler.9bc65507.js";import{S as cl,i as ml,g as p,s as e,r as m,A as ol,h as i,f as l,c as n,j as Tt,u as o,x as c,k as y,y as rl,a,v as r,d as g,t as M,w as h}from"../chunks/index.707bf1b6.js";import{C as j}from"../chunks/CodeBlock.54a9f38d.js";import{D as gl}from"../chunks/DocNotebookDropdown.41f65cb5.js";import{H as Js,E as Ml}from"../chunks/EditOnGithub.922df6ba.js";function hl(ft){let b,Us,bs,ws,C,xs,W,Ts,v,Ct=`従来、<a href="object_detection">オブジェクト検出</a> に使用されるモデルには、トレーニング用のラベル付き画像データセットが必要でした。
トレーニング データからのクラスのセットの検出に限定されます。`,fs,I,Wt=`ゼロショットオブジェクト検出は、別のアプローチを使用する <a href="../model_doc/owlvit">OWL-ViT</a> モデルによってサポートされています。 OWL-ViT
オープン語彙オブジェクト検出器です。これは、フリーテキストクエリに基づいて画像内のオブジェクトを検出できることを意味します。
ラベル付きデータセットでモデルを微調整する必要性。`,Cs,$,vt=`OWL-ViTは、マルチモーダル表現を利用してオープン語彙の検出を実行します。 <a href="../model_doc/clip">CLIP</a> とを組み合わせます。
軽量のオブジェクト分類および位置特定ヘッド。オープン語彙の検出は、CLIP のテキスト エンコーダーを使用してフリーテキスト クエリを埋め込み、それらをオブジェクト分類およびローカリゼーション ヘッドへの入力として使用することによって実現されます。
画像とそれに対応するテキストの説明を関連付け、ViT は画像パッチを入力として処理します。作家たち
のOWL-ViTは、まずCLIPをゼロからトレーニングし、次に標準の物体検出データセットを使用してOWL-ViTをエンドツーエンドで微調整しました。
二部マッチング損失。`,Ws,k,It="このアプローチを使用すると、モデルはラベル付きデータセットで事前にトレーニングしなくても、テキストの説明に基づいてオブジェクトを検出できます。",vs,R,$t="このガイドでは、OWL-ViT の使用方法を学習します。",Is,Z,kt="<li>テキストプロンプトに基づいてオブジェクトを検出します</li> <li>バッチオブジェクト検出用</li> <li>画像誘導物体検出用</li>",$s,Q,Rt="始める前に、必要なライブラリがすべてインストールされていることを確認してください。",ks,_,Rs,V,Zs,z,Zt=`OWL-ViTによる推論を試す最も簡単な方法は、OWL-ViTを<a href="/docs/transformers/pr_30862/ja/main_classes/pipelines#transformers.pipeline">pipeline()</a>で使用することです。パイプラインをインスタンス化する
<a href="https://huggingface.co/models?other=owlvit" rel="nofollow">Hugging Face Hub のチェックポイント</a> からのゼロショット オブジェクト検出の場合:`,Qs,B,_s,H,Qt=`次に、物体を検出したい画像を選択します。ここでは、宇宙飛行士アイリーン・コリンズの画像を使用します。
<a href="https://www.nasa.gov/multimedia/imagegallery/index.html" rel="nofollow">NASA</a> Great Images データセットの一部。`,Vs,N,zs,d,_t='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/zero-sh-obj-detection_1.png" alt="Astronaut Eileen Collins"/>',Bs,X,Vt=`検索する画像と候補オブジェクトのラベルをパイプラインに渡します。
ここでは画像を直接渡します。他の適切なオプションには、画像へのローカル パスまたは画像 URL が含まれます。また、画像をクエリするすべてのアイテムのテキスト説明も渡します。`,Hs,G,Ns,q,zt="予測を視覚化してみましょう。",Xs,Y,Gs,J,Bt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/zero-sh-obj-detection_2.png" alt="Visualized predictions on NASA image"/>',qs,E,Ys,S,Ht=`ゼロショット物体検出パイプラインの使用方法を確認したので、同じことを再現してみましょう。
手動で結果を取得します。`,Es,F,Nt=`まず、<a href="https://huggingface.co/models?other=owlvit" rel="nofollow">Hugging Face Hub のチェックポイント</a> からモデルと関連プロセッサをロードします。
ここでは、前と同じチェックポイントを使用します。`,Ss,L,Fs,A,Xt="気分を変えて、別の画像を撮ってみましょう。",Ls,D,As,U,Gt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/zero-sh-obj-detection_3.png" alt="Beach photo"/>',Ds,P,qt=`プロセッサを使用してモデルの入力を準備します。プロセッサーは、
サイズ変更と正規化によるモデルの画像と、テキスト入力を処理する <a href="/docs/transformers/pr_30862/ja/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a> です。`,Ps,K,Ks,O,Yt=`入力をモデルに渡し、後処理し、結果を視覚化します。以前は画像プロセッサによって画像のサイズが変更されていたため、
それらをモデルにフィードするには、<code>post_process_object_detection()</code> メソッドを使用して、予測された境界を確認する必要があります。
ボックスは元の画像を基準とした正しい座標を持ちます。`,Os,ss,st,w,Et='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/zero-sh-obj-detection_4.png" alt="Beach photo with detected objects"/>',tt,ts,lt,ls,St=`複数の画像セットとテキスト クエリを渡して、複数の画像内の異なる (または同じ) オブジェクトを検索できます。
宇宙飛行士の画像とビーチの画像を組み合わせてみましょう。
バッチ処理の場合、テキスト クエリをネストされたリストとしてプロセッサに渡し、画像を PIL イメージのリストとして渡す必要があります。
PyTorch テンソル、または NumPy 配列。`,at,as,et,es,Ft=`以前は後処理のために単一の画像のサイズをテンソルとして渡していましたが、タプルを渡すこともできます。
複数の画像のタプルのリスト。 2 つの例の予測を作成し、2 番目の例 (<code>image_idx = 1</code>) を視覚化しましょう。`,nt,ns,pt,x,Lt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/zero-sh-obj-detection_4.png" alt="Beach photo with detected objects"/>',it,ps,ct,is,At=`テキストクエリによるゼロショットオブジェクト検出に加えて、OWL-ViTは画像ガイドによるオブジェクト検出を提供します。これはつまり
画像クエリを使用して、ターゲット画像内の類似したオブジェクトを検索できます。
テキスト クエリとは異なり、使用できるサンプル画像は 1 つだけです。`,mt,cs,Dt=`対象画像としてソファに2匹の猫がいる画像と、1匹の猫の画像を撮影しましょう
クエリとして:`,ot,ms,rt,os,Pt="画像を簡単に見てみましょう。",gt,rs,Mt,T,Kt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/zero-sh-obj-detection_5.png" alt="Cats"/>',ht,gs,Ot="前処理ステップでは、テキスト クエリの代わりに <code>query_images</code> を使用する必要があります。",jt,Ms,yt,hs,sl=`予測の場合、入力をモデルに渡す代わりに、<code>image_guided_detection()</code> に渡します。予測を描く
ラベルがないことを除いては以前と同様です。`,ut,js,bt,f,tl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/zero-sh-obj-detection_6.png" alt="Cats with bounding boxes"/>',dt,ys,ll="OWL-ViTによる推論をインタラクティブに試したい場合は、このデモをチェックしてください。",Jt,u,al,Ut,us,wt,ds,xt;return C=new Js({props:{title:"Zero-shot object detection",local:"zero-shot-object-detection",headingTag:"h1"}}),W=new gl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ja/zero_shot_object_detection.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ja/pytorch/zero_shot_object_detection.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ja/tensorflow/zero_shot_object_detection.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ja/zero_shot_object_detection.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ja/pytorch/zero_shot_object_detection.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ja/tensorflow/zero_shot_object_detection.ipynb"}]}}),_=new j({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwdHJhbnNmb3JtZXJz",highlighted:"pip install -q transformers",wrap:!1}}),V=new Js({props:{title:"Zero-shot object detection pipeline",local:"zero-shot-object-detection-pipeline",headingTag:"h2"}}),B=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMmdvb2dsZSUyRm93bHZpdC1iYXNlLXBhdGNoMzIlMjIlMEFkZXRlY3RvciUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEY2hlY2twb2ludCUyQyUyMHRhc2slM0QlMjJ6ZXJvLXNob3Qtb2JqZWN0LWRldGVjdGlvbiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;google/owlvit-base-patch32&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>detector = pipeline(model=checkpoint, task=<span class="hljs-string">&quot;zero-shot-object-detection&quot;</span>)`,wrap:!1}}),N=new j({props:{code:"aW1wb3J0JTIwc2tpbWFnZSUwQWltcG9ydCUyMG51bXB5JTIwYXMlMjBucCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQSUwQWltYWdlJTIwJTNEJTIwc2tpbWFnZS5kYXRhLmFzdHJvbmF1dCgpJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5mcm9tYXJyYXkobnAudWludDgoaW1hZ2UpKS5jb252ZXJ0KCUyMlJHQiUyMiklMEElMEFpbWFnZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> skimage
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span>image = skimage.data.astronaut()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.fromarray(np.uint8(image)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),G=new j({props:{code:"cHJlZGljdGlvbnMlMjAlM0QlMjBkZXRlY3RvciglMEElMjAlMjAlMjAlMjBpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMGNhbmRpZGF0ZV9sYWJlbHMlM0QlNUIlMjJodW1hbiUyMGZhY2UlMjIlMkMlMjAlMjJyb2NrZXQlMjIlMkMlMjAlMjJuYXNhJTIwYmFkZ2UlMjIlMkMlMjAlMjJzdGFyLXNwYW5nbGVkJTIwYmFubmVyJTIyJTVEJTJDJTBBKSUwQXByZWRpY3Rpb25z",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>predictions = detector(
<span class="hljs-meta">... </span>    image,
<span class="hljs-meta">... </span>    candidate_labels=[<span class="hljs-string">&quot;human face&quot;</span>, <span class="hljs-string">&quot;rocket&quot;</span>, <span class="hljs-string">&quot;nasa badge&quot;</span>, <span class="hljs-string">&quot;star-spangled banner&quot;</span>],
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>predictions
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.3571370542049408</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;human face&#x27;</span>,
  <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">180</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">71</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">271</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">178</span>}},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.28099656105041504</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;nasa badge&#x27;</span>,
  <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">129</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">348</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">206</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">427</span>}},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.2110239565372467</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;rocket&#x27;</span>,
  <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">350</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: -<span class="hljs-number">1</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">468</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">288</span>}},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.13790413737297058</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;star-spangled banner&#x27;</span>,
  <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">105</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">509</span>}},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.11950037628412247</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;nasa badge&#x27;</span>,
  <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">277</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">338</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">327</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">380</span>}},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.10649408400058746</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;rocket&#x27;</span>,
  <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">358</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">64</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">424</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">280</span>}}]`,wrap:!1}}),Y=new j({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlRHJhdyUwQSUwQWRyYXclMjAlM0QlMjBJbWFnZURyYXcuRHJhdyhpbWFnZSklMEElMEFmb3IlMjBwcmVkaWN0aW9uJTIwaW4lMjBwcmVkaWN0aW9ucyUzQSUwQSUyMCUyMCUyMCUyMGJveCUyMCUzRCUyMHByZWRpY3Rpb24lNUIlMjJib3glMjIlNUQlMEElMjAlMjAlMjAlMjBsYWJlbCUyMCUzRCUyMHByZWRpY3Rpb24lNUIlMjJsYWJlbCUyMiU1RCUwQSUyMCUyMCUyMCUyMHNjb3JlJTIwJTNEJTIwcHJlZGljdGlvbiU1QiUyMnNjb3JlJTIyJTVEJTBBJTBBJTIwJTIwJTIwJTIweG1pbiUyQyUyMHltaW4lMkMlMjB4bWF4JTJDJTIweW1heCUyMCUzRCUyMGJveC52YWx1ZXMoKSUwQSUyMCUyMCUyMCUyMGRyYXcucmVjdGFuZ2xlKCh4bWluJTJDJTIweW1pbiUyQyUyMHhtYXglMkMlMjB5bWF4KSUyQyUyMG91dGxpbmUlM0QlMjJyZWQlMjIlMkMlMjB3aWR0aCUzRDEpJTBBJTIwJTIwJTIwJTIwZHJhdy50ZXh0KCh4bWluJTJDJTIweW1pbiklMkMlMjBmJTIyJTdCbGFiZWwlN0QlM0ElMjAlN0Jyb3VuZChzY29yZSUyQzIpJTdEJTIyJTJDJTIwZmlsbCUzRCUyMndoaXRlJTIyKSUwQSUwQWltYWdl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> ImageDraw

<span class="hljs-meta">&gt;&gt;&gt; </span>draw = ImageDraw.Draw(image)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> prediction <span class="hljs-keyword">in</span> predictions:
<span class="hljs-meta">... </span>    box = prediction[<span class="hljs-string">&quot;box&quot;</span>]
<span class="hljs-meta">... </span>    label = prediction[<span class="hljs-string">&quot;label&quot;</span>]
<span class="hljs-meta">... </span>    score = prediction[<span class="hljs-string">&quot;score&quot;</span>]

<span class="hljs-meta">... </span>    xmin, ymin, xmax, ymax = box.values()
<span class="hljs-meta">... </span>    draw.rectangle((xmin, ymin, xmax, ymax), outline=<span class="hljs-string">&quot;red&quot;</span>, width=<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    draw.text((xmin, ymin), <span class="hljs-string">f&quot;<span class="hljs-subst">{label}</span>: <span class="hljs-subst">{<span class="hljs-built_in">round</span>(score,<span class="hljs-number">2</span>)}</span>&quot;</span>, fill=<span class="hljs-string">&quot;white&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),E=new Js({props:{title:"Text-prompted zero-shot object detection by hand",local:"text-prompted-zero-shot-object-detection-by-hand",headingTag:"h2"}}),L=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBBdXRvTW9kZWxGb3JaZXJvU2hvdE9iamVjdERldGVjdGlvbiUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yWmVyb1Nob3RPYmplY3REZXRlY3Rpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForZeroShotObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForZeroShotObjectDetection.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(checkpoint)`,wrap:!1}}),D=new j({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnVuc3BsYXNoLmNvbSUyRnBob3RvcyUyRm9qMHplWTJMdGs0JTJGZG93bmxvYWQlM0ZpeGlkJTNETW53eE1qQTNmREI4TVh4elpXRnlZMmg4TVRSOGZIQnBZMjVwWTN4bGJud3dmSHg4ZkRFMk56YzBPVEUxTkRrJTI2Zm9yY2UlM0R0cnVlJTI2dyUzRDY0MCUyMiUwQWltJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQWlt",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://unsplash.com/photos/oj0zeY2Ltk4/download?ixid=MnwxMjA3fDB8MXxzZWFyY2h8MTR8fHBpY25pY3xlbnwwfHx8fDE2Nzc0OTE1NDk&amp;force=true&amp;w=640&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>im = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>im`,wrap:!1}}),K=new j({props:{code:"dGV4dF9xdWVyaWVzJTIwJTNEJTIwJTVCJTIyaGF0JTIyJTJDJTIwJTIyYm9vayUyMiUyQyUyMCUyMnN1bmdsYXNzZXMlMjIlMkMlMjAlMjJjYW1lcmElMjIlNUQlMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IodGV4dCUzRHRleHRfcXVlcmllcyUyQyUyMGltYWdlcyUzRGltJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>text_queries = [<span class="hljs-string">&quot;hat&quot;</span>, <span class="hljs-string">&quot;book&quot;</span>, <span class="hljs-string">&quot;sunglasses&quot;</span>, <span class="hljs-string">&quot;camera&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=text_queries, images=im, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)`,wrap:!1}}),ss=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUyMCUyMCUyMCUyMHRhcmdldF9zaXplcyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUJpbS5zaXplJTVCJTNBJTNBLTElNUQlNUQpJTBBJTIwJTIwJTIwJTIwcmVzdWx0cyUyMCUzRCUyMHByb2Nlc3Nvci5wb3N0X3Byb2Nlc3Nfb2JqZWN0X2RldGVjdGlvbihvdXRwdXRzJTJDJTIwdGhyZXNob2xkJTNEMC4xJTJDJTIwdGFyZ2V0X3NpemVzJTNEdGFyZ2V0X3NpemVzKSU1QjAlNUQlMEElMEFkcmF3JTIwJTNEJTIwSW1hZ2VEcmF3LkRyYXcoaW0pJTBBJTBBc2NvcmVzJTIwJTNEJTIwcmVzdWx0cyU1QiUyMnNjb3JlcyUyMiU1RC50b2xpc3QoKSUwQWxhYmVscyUyMCUzRCUyMHJlc3VsdHMlNUIlMjJsYWJlbHMlMjIlNUQudG9saXN0KCklMEFib3hlcyUyMCUzRCUyMHJlc3VsdHMlNUIlMjJib3hlcyUyMiU1RC50b2xpc3QoKSUwQSUwQWZvciUyMGJveCUyQyUyMHNjb3JlJTJDJTIwbGFiZWwlMjBpbiUyMHppcChib3hlcyUyQyUyMHNjb3JlcyUyQyUyMGxhYmVscyklM0ElMEElMjAlMjAlMjAlMjB4bWluJTJDJTIweW1pbiUyQyUyMHhtYXglMkMlMjB5bWF4JTIwJTNEJTIwYm94JTBBJTIwJTIwJTIwJTIwZHJhdy5yZWN0YW5nbGUoKHhtaW4lMkMlMjB5bWluJTJDJTIweG1heCUyQyUyMHltYXgpJTJDJTIwb3V0bGluZSUzRCUyMnJlZCUyMiUyQyUyMHdpZHRoJTNEMSklMEElMjAlMjAlMjAlMjBkcmF3LnRleHQoKHhtaW4lMkMlMjB5bWluKSUyQyUyMGYlMjIlN0J0ZXh0X3F1ZXJpZXMlNUJsYWJlbCU1RCU3RCUzQSUyMCU3QnJvdW5kKHNjb3JlJTJDMiklN0QlMjIlMkMlMjBmaWxsJTNEJTIyd2hpdGUlMjIpJTBBJTBBaW0=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)
<span class="hljs-meta">... </span>    target_sizes = torch.tensor([im.size[::-<span class="hljs-number">1</span>]])
<span class="hljs-meta">... </span>    results = processor.post_process_object_detection(outputs, threshold=<span class="hljs-number">0.1</span>, target_sizes=target_sizes)[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>draw = ImageDraw.Draw(im)

<span class="hljs-meta">&gt;&gt;&gt; </span>scores = results[<span class="hljs-string">&quot;scores&quot;</span>].tolist()
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = results[<span class="hljs-string">&quot;labels&quot;</span>].tolist()
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes = results[<span class="hljs-string">&quot;boxes&quot;</span>].tolist()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> box, score, label <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(boxes, scores, labels):
<span class="hljs-meta">... </span>    xmin, ymin, xmax, ymax = box
<span class="hljs-meta">... </span>    draw.rectangle((xmin, ymin, xmax, ymax), outline=<span class="hljs-string">&quot;red&quot;</span>, width=<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    draw.text((xmin, ymin), <span class="hljs-string">f&quot;<span class="hljs-subst">{text_queries[label]}</span>: <span class="hljs-subst">{<span class="hljs-built_in">round</span>(score,<span class="hljs-number">2</span>)}</span>&quot;</span>, fill=<span class="hljs-string">&quot;white&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>im`,wrap:!1}}),ts=new Js({props:{title:"Batch processing",local:"batch-processing",headingTag:"h2"}}),as=new j({props:{code:"aW1hZ2VzJTIwJTNEJTIwJTVCaW1hZ2UlMkMlMjBpbSU1RCUwQXRleHRfcXVlcmllcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU1QiUyMmh1bWFuJTIwZmFjZSUyMiUyQyUyMCUyMnJvY2tldCUyMiUyQyUyMCUyMm5hc2ElMjBiYWRnZSUyMiUyQyUyMCUyMnN0YXItc3BhbmdsZWQlMjBiYW5uZXIlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlNUIlMjJoYXQlMjIlMkMlMjAlMjJib29rJTIyJTJDJTIwJTIyc3VuZ2xhc3NlcyUyMiUyQyUyMCUyMmNhbWVyYSUyMiU1RCUyQyUwQSU1RCUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcih0ZXh0JTNEdGV4dF9xdWVyaWVzJTJDJTIwaW1hZ2VzJTNEaW1hZ2VzJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>images = [image, im]
<span class="hljs-meta">&gt;&gt;&gt; </span>text_queries = [
<span class="hljs-meta">... </span>    [<span class="hljs-string">&quot;human face&quot;</span>, <span class="hljs-string">&quot;rocket&quot;</span>, <span class="hljs-string">&quot;nasa badge&quot;</span>, <span class="hljs-string">&quot;star-spangled banner&quot;</span>],
<span class="hljs-meta">... </span>    [<span class="hljs-string">&quot;hat&quot;</span>, <span class="hljs-string">&quot;book&quot;</span>, <span class="hljs-string">&quot;sunglasses&quot;</span>, <span class="hljs-string">&quot;camera&quot;</span>],
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=text_queries, images=images, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)`,wrap:!1}}),ns=new j({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMjAlMjAlMjAlMjB0YXJnZXRfc2l6ZXMlMjAlM0QlMjAlNUJ4LnNpemUlNUIlM0ElM0EtMSU1RCUyMGZvciUyMHglMjBpbiUyMGltYWdlcyU1RCUwQSUyMCUyMCUyMCUyMHJlc3VsdHMlMjAlM0QlMjBwcm9jZXNzb3IucG9zdF9wcm9jZXNzX29iamVjdF9kZXRlY3Rpb24ob3V0cHV0cyUyQyUyMHRocmVzaG9sZCUzRDAuMSUyQyUyMHRhcmdldF9zaXplcyUzRHRhcmdldF9zaXplcyklMEElMEFpbWFnZV9pZHglMjAlM0QlMjAxJTBBZHJhdyUyMCUzRCUyMEltYWdlRHJhdy5EcmF3KGltYWdlcyU1QmltYWdlX2lkeCU1RCklMEElMEFzY29yZXMlMjAlM0QlMjByZXN1bHRzJTVCaW1hZ2VfaWR4JTVEJTVCJTIyc2NvcmVzJTIyJTVELnRvbGlzdCgpJTBBbGFiZWxzJTIwJTNEJTIwcmVzdWx0cyU1QmltYWdlX2lkeCU1RCU1QiUyMmxhYmVscyUyMiU1RC50b2xpc3QoKSUwQWJveGVzJTIwJTNEJTIwcmVzdWx0cyU1QmltYWdlX2lkeCU1RCU1QiUyMmJveGVzJTIyJTVELnRvbGlzdCgpJTBBJTBBZm9yJTIwYm94JTJDJTIwc2NvcmUlMkMlMjBsYWJlbCUyMGluJTIwemlwKGJveGVzJTJDJTIwc2NvcmVzJTJDJTIwbGFiZWxzKSUzQSUwQSUyMCUyMCUyMCUyMHhtaW4lMkMlMjB5bWluJTJDJTIweG1heCUyQyUyMHltYXglMjAlM0QlMjBib3glMEElMjAlMjAlMjAlMjBkcmF3LnJlY3RhbmdsZSgoeG1pbiUyQyUyMHltaW4lMkMlMjB4bWF4JTJDJTIweW1heCklMkMlMjBvdXRsaW5lJTNEJTIycmVkJTIyJTJDJTIwd2lkdGglM0QxKSUwQSUyMCUyMCUyMCUyMGRyYXcudGV4dCgoeG1pbiUyQyUyMHltaW4pJTJDJTIwZiUyMiU3QnRleHRfcXVlcmllcyU1QmltYWdlX2lkeCU1RCU1QmxhYmVsJTVEJTdEJTNBJTIwJTdCcm91bmQoc2NvcmUlMkMyKSU3RCUyMiUyQyUyMGZpbGwlM0QlMjJ3aGl0ZSUyMiklMEElMEFpbWFnZXMlNUJpbWFnZV9pZHglNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)
<span class="hljs-meta">... </span>    target_sizes = [x.size[::-<span class="hljs-number">1</span>] <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> images]
<span class="hljs-meta">... </span>    results = processor.post_process_object_detection(outputs, threshold=<span class="hljs-number">0.1</span>, target_sizes=target_sizes)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_idx = <span class="hljs-number">1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>draw = ImageDraw.Draw(images[image_idx])

<span class="hljs-meta">&gt;&gt;&gt; </span>scores = results[image_idx][<span class="hljs-string">&quot;scores&quot;</span>].tolist()
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = results[image_idx][<span class="hljs-string">&quot;labels&quot;</span>].tolist()
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes = results[image_idx][<span class="hljs-string">&quot;boxes&quot;</span>].tolist()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> box, score, label <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(boxes, scores, labels):
<span class="hljs-meta">... </span>    xmin, ymin, xmax, ymax = box
<span class="hljs-meta">... </span>    draw.rectangle((xmin, ymin, xmax, ymax), outline=<span class="hljs-string">&quot;red&quot;</span>, width=<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    draw.text((xmin, ymin), <span class="hljs-string">f&quot;<span class="hljs-subst">{text_queries[image_idx][label]}</span>: <span class="hljs-subst">{<span class="hljs-built_in">round</span>(score,<span class="hljs-number">2</span>)}</span>&quot;</span>, fill=<span class="hljs-string">&quot;white&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>images[image_idx]`,wrap:!1}}),ps=new Js({props:{title:"Image-guided object detection",local:"image-guided-object-detection",headingTag:"h2"}}),ms=new j({props:{code:"dXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlX3RhcmdldCUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFxdWVyeV91cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDA1MjQyODAuanBnJTIyJTBBcXVlcnlfaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldChxdWVyeV91cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_target = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>query_url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000524280.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>query_image = Image.<span class="hljs-built_in">open</span>(requests.get(query_url, stream=<span class="hljs-literal">True</span>).raw)`,wrap:!1}}),rs=new j({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQWZpZyUyQyUyMGF4JTIwJTNEJTIwcGx0LnN1YnBsb3RzKDElMkMlMjAyKSUwQWF4JTVCMCU1RC5pbXNob3coaW1hZ2VfdGFyZ2V0KSUwQWF4JTVCMSU1RC5pbXNob3cocXVlcnlfaW1hZ2Up",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

<span class="hljs-meta">&gt;&gt;&gt; </span>fig, ax = plt.subplots(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ax[<span class="hljs-number">0</span>].imshow(image_target)
<span class="hljs-meta">&gt;&gt;&gt; </span>ax[<span class="hljs-number">1</span>].imshow(query_image)`,wrap:!1}}),Ms=new j({props:{code:"aW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlX3RhcmdldCUyQyUyMHF1ZXJ5X2ltYWdlcyUzRHF1ZXJ5X2ltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image_target, query_images=query_image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),js=new j({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbC5pbWFnZV9ndWlkZWRfZGV0ZWN0aW9uKCoqaW5wdXRzKSUwQSUyMCUyMCUyMCUyMHRhcmdldF9zaXplcyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUJpbWFnZV90YXJnZXQuc2l6ZSU1QiUzQSUzQS0xJTVEJTVEKSUwQSUyMCUyMCUyMCUyMHJlc3VsdHMlMjAlM0QlMjBwcm9jZXNzb3IucG9zdF9wcm9jZXNzX2ltYWdlX2d1aWRlZF9kZXRlY3Rpb24ob3V0cHV0cyUzRG91dHB1dHMlMkMlMjB0YXJnZXRfc2l6ZXMlM0R0YXJnZXRfc2l6ZXMpJTVCMCU1RCUwQSUwQWRyYXclMjAlM0QlMjBJbWFnZURyYXcuRHJhdyhpbWFnZV90YXJnZXQpJTBBJTBBc2NvcmVzJTIwJTNEJTIwcmVzdWx0cyU1QiUyMnNjb3JlcyUyMiU1RC50b2xpc3QoKSUwQWJveGVzJTIwJTNEJTIwcmVzdWx0cyU1QiUyMmJveGVzJTIyJTVELnRvbGlzdCgpJTBBJTBBZm9yJTIwYm94JTJDJTIwc2NvcmUlMkMlMjBsYWJlbCUyMGluJTIwemlwKGJveGVzJTJDJTIwc2NvcmVzJTJDJTIwbGFiZWxzKSUzQSUwQSUyMCUyMCUyMCUyMHhtaW4lMkMlMjB5bWluJTJDJTIweG1heCUyQyUyMHltYXglMjAlM0QlMjBib3glMEElMjAlMjAlMjAlMjBkcmF3LnJlY3RhbmdsZSgoeG1pbiUyQyUyMHltaW4lMkMlMjB4bWF4JTJDJTIweW1heCklMkMlMjBvdXRsaW5lJTNEJTIyd2hpdGUlMjIlMkMlMjB3aWR0aCUzRDQpJTBBJTBBaW1hZ2VfdGFyZ2V0",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model.image_guided_detection(**inputs)
<span class="hljs-meta">... </span>    target_sizes = torch.tensor([image_target.size[::-<span class="hljs-number">1</span>]])
<span class="hljs-meta">... </span>    results = processor.post_process_image_guided_detection(outputs=outputs, target_sizes=target_sizes)[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>draw = ImageDraw.Draw(image_target)

<span class="hljs-meta">&gt;&gt;&gt; </span>scores = results[<span class="hljs-string">&quot;scores&quot;</span>].tolist()
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes = results[<span class="hljs-string">&quot;boxes&quot;</span>].tolist()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> box, score, label <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(boxes, scores, labels):
<span class="hljs-meta">... </span>    xmin, ymin, xmax, ymax = box
<span class="hljs-meta">... </span>    draw.rectangle((xmin, ymin, xmax, ymax), outline=<span class="hljs-string">&quot;white&quot;</span>, width=<span class="hljs-number">4</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_target`,wrap:!1}}),us=new Ml({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/ja/tasks/zero_shot_object_detection.md"}}),{c(){b=p("meta"),Us=e(),bs=p("p"),ws=e(),m(C.$$.fragment),xs=e(),m(W.$$.fragment),Ts=e(),v=p("p"),v.innerHTML=Ct,fs=e(),I=p("p"),I.innerHTML=Wt,Cs=e(),$=p("p"),$.innerHTML=vt,Ws=e(),k=p("p"),k.textContent=It,vs=e(),R=p("p"),R.textContent=$t,Is=e(),Z=p("ul"),Z.innerHTML=kt,$s=e(),Q=p("p"),Q.textContent=Rt,ks=e(),m(_.$$.fragment),Rs=e(),m(V.$$.fragment),Zs=e(),z=p("p"),z.innerHTML=Zt,Qs=e(),m(B.$$.fragment),_s=e(),H=p("p"),H.innerHTML=Qt,Vs=e(),m(N.$$.fragment),zs=e(),d=p("div"),d.innerHTML=_t,Bs=e(),X=p("p"),X.textContent=Vt,Hs=e(),m(G.$$.fragment),Ns=e(),q=p("p"),q.textContent=zt,Xs=e(),m(Y.$$.fragment),Gs=e(),J=p("div"),J.innerHTML=Bt,qs=e(),m(E.$$.fragment),Ys=e(),S=p("p"),S.textContent=Ht,Es=e(),F=p("p"),F.innerHTML=Nt,Ss=e(),m(L.$$.fragment),Fs=e(),A=p("p"),A.textContent=Xt,Ls=e(),m(D.$$.fragment),As=e(),U=p("div"),U.innerHTML=Gt,Ds=e(),P=p("p"),P.innerHTML=qt,Ps=e(),m(K.$$.fragment),Ks=e(),O=p("p"),O.innerHTML=Yt,Os=e(),m(ss.$$.fragment),st=e(),w=p("div"),w.innerHTML=Et,tt=e(),m(ts.$$.fragment),lt=e(),ls=p("p"),ls.textContent=St,at=e(),m(as.$$.fragment),et=e(),es=p("p"),es.innerHTML=Ft,nt=e(),m(ns.$$.fragment),pt=e(),x=p("div"),x.innerHTML=Lt,it=e(),m(ps.$$.fragment),ct=e(),is=p("p"),is.textContent=At,mt=e(),cs=p("p"),cs.textContent=Dt,ot=e(),m(ms.$$.fragment),rt=e(),os=p("p"),os.textContent=Pt,gt=e(),m(rs.$$.fragment),Mt=e(),T=p("div"),T.innerHTML=Kt,ht=e(),gs=p("p"),gs.innerHTML=Ot,jt=e(),m(Ms.$$.fragment),yt=e(),hs=p("p"),hs.innerHTML=sl,ut=e(),m(js.$$.fragment),bt=e(),f=p("div"),f.innerHTML=tl,dt=e(),ys=p("p"),ys.textContent=ll,Jt=e(),u=p("iframe"),Ut=e(),m(us.$$.fragment),wt=e(),ds=p("p"),this.h()},l(s){const t=ol("svelte-u9bgzb",document.head);b=i(t,"META",{name:!0,content:!0}),t.forEach(l),Us=n(s),bs=i(s,"P",{}),Tt(bs).forEach(l),ws=n(s),o(C.$$.fragment,s),xs=n(s),o(W.$$.fragment,s),Ts=n(s),v=i(s,"P",{"data-svelte-h":!0}),c(v)!=="svelte-1jmn15x"&&(v.innerHTML=Ct),fs=n(s),I=i(s,"P",{"data-svelte-h":!0}),c(I)!=="svelte-316ad1"&&(I.innerHTML=Wt),Cs=n(s),$=i(s,"P",{"data-svelte-h":!0}),c($)!=="svelte-13iuwwr"&&($.innerHTML=vt),Ws=n(s),k=i(s,"P",{"data-svelte-h":!0}),c(k)!=="svelte-1o1n265"&&(k.textContent=It),vs=n(s),R=i(s,"P",{"data-svelte-h":!0}),c(R)!=="svelte-nsc34w"&&(R.textContent=$t),Is=n(s),Z=i(s,"UL",{"data-svelte-h":!0}),c(Z)!=="svelte-v788np"&&(Z.innerHTML=kt),$s=n(s),Q=i(s,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-1lya3k8"&&(Q.textContent=Rt),ks=n(s),o(_.$$.fragment,s),Rs=n(s),o(V.$$.fragment,s),Zs=n(s),z=i(s,"P",{"data-svelte-h":!0}),c(z)!=="svelte-1b5003v"&&(z.innerHTML=Zt),Qs=n(s),o(B.$$.fragment,s),_s=n(s),H=i(s,"P",{"data-svelte-h":!0}),c(H)!=="svelte-t24qb7"&&(H.innerHTML=Qt),Vs=n(s),o(N.$$.fragment,s),zs=n(s),d=i(s,"DIV",{class:!0,"data-svelte-h":!0}),c(d)!=="svelte-17qmfee"&&(d.innerHTML=_t),Bs=n(s),X=i(s,"P",{"data-svelte-h":!0}),c(X)!=="svelte-1pcmuvb"&&(X.textContent=Vt),Hs=n(s),o(G.$$.fragment,s),Ns=n(s),q=i(s,"P",{"data-svelte-h":!0}),c(q)!=="svelte-3md4si"&&(q.textContent=zt),Xs=n(s),o(Y.$$.fragment,s),Gs=n(s),J=i(s,"DIV",{class:!0,"data-svelte-h":!0}),c(J)!=="svelte-1fwpqdn"&&(J.innerHTML=Bt),qs=n(s),o(E.$$.fragment,s),Ys=n(s),S=i(s,"P",{"data-svelte-h":!0}),c(S)!=="svelte-fghste"&&(S.textContent=Ht),Es=n(s),F=i(s,"P",{"data-svelte-h":!0}),c(F)!=="svelte-1faeuph"&&(F.innerHTML=Nt),Ss=n(s),o(L.$$.fragment,s),Fs=n(s),A=i(s,"P",{"data-svelte-h":!0}),c(A)!=="svelte-vbbgku"&&(A.textContent=Xt),Ls=n(s),o(D.$$.fragment,s),As=n(s),U=i(s,"DIV",{class:!0,"data-svelte-h":!0}),c(U)!=="svelte-owux8y"&&(U.innerHTML=Gt),Ds=n(s),P=i(s,"P",{"data-svelte-h":!0}),c(P)!=="svelte-15vayw6"&&(P.innerHTML=qt),Ps=n(s),o(K.$$.fragment,s),Ks=n(s),O=i(s,"P",{"data-svelte-h":!0}),c(O)!=="svelte-v25fhy"&&(O.innerHTML=Yt),Os=n(s),o(ss.$$.fragment,s),st=n(s),w=i(s,"DIV",{class:!0,"data-svelte-h":!0}),c(w)!=="svelte-1m863ar"&&(w.innerHTML=Et),tt=n(s),o(ts.$$.fragment,s),lt=n(s),ls=i(s,"P",{"data-svelte-h":!0}),c(ls)!=="svelte-1d0cvqy"&&(ls.textContent=St),at=n(s),o(as.$$.fragment,s),et=n(s),es=i(s,"P",{"data-svelte-h":!0}),c(es)!=="svelte-7sl4ju"&&(es.innerHTML=Ft),nt=n(s),o(ns.$$.fragment,s),pt=n(s),x=i(s,"DIV",{class:!0,"data-svelte-h":!0}),c(x)!=="svelte-1m863ar"&&(x.innerHTML=Lt),it=n(s),o(ps.$$.fragment,s),ct=n(s),is=i(s,"P",{"data-svelte-h":!0}),c(is)!=="svelte-cpc5ya"&&(is.textContent=At),mt=n(s),cs=i(s,"P",{"data-svelte-h":!0}),c(cs)!=="svelte-16l357l"&&(cs.textContent=Dt),ot=n(s),o(ms.$$.fragment,s),rt=n(s),os=i(s,"P",{"data-svelte-h":!0}),c(os)!=="svelte-9k435k"&&(os.textContent=Pt),gt=n(s),o(rs.$$.fragment,s),Mt=n(s),T=i(s,"DIV",{class:!0,"data-svelte-h":!0}),c(T)!=="svelte-y78yu"&&(T.innerHTML=Kt),ht=n(s),gs=i(s,"P",{"data-svelte-h":!0}),c(gs)!=="svelte-1g2qd19"&&(gs.innerHTML=Ot),jt=n(s),o(Ms.$$.fragment,s),yt=n(s),hs=i(s,"P",{"data-svelte-h":!0}),c(hs)!=="svelte-ccdvl"&&(hs.innerHTML=sl),ut=n(s),o(js.$$.fragment,s),bt=n(s),f=i(s,"DIV",{class:!0,"data-svelte-h":!0}),c(f)!=="svelte-1f4dev0"&&(f.innerHTML=tl),dt=n(s),ys=i(s,"P",{"data-svelte-h":!0}),c(ys)!=="svelte-1xcb9x7"&&(ys.textContent=ll),Jt=n(s),u=i(s,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),Tt(u).forEach(l),Ut=n(s),o(us.$$.fragment,s),wt=n(s),ds=i(s,"P",{}),Tt(ds).forEach(l),this.h()},h(){y(b,"name","hf:doc:metadata"),y(b,"content",jl),y(d,"class","flex justify-center"),y(J,"class","flex justify-center"),y(U,"class","flex justify-center"),y(w,"class","flex justify-center"),y(x,"class","flex justify-center"),y(T,"class","flex justify-center"),y(f,"class","flex justify-center"),nl(u.src,al="https://adirik-owl-vit.hf.space")||y(u,"src",al),y(u,"frameborder","0"),y(u,"width","850"),y(u,"height","450")},m(s,t){rl(document.head,b),a(s,Us,t),a(s,bs,t),a(s,ws,t),r(C,s,t),a(s,xs,t),r(W,s,t),a(s,Ts,t),a(s,v,t),a(s,fs,t),a(s,I,t),a(s,Cs,t),a(s,$,t),a(s,Ws,t),a(s,k,t),a(s,vs,t),a(s,R,t),a(s,Is,t),a(s,Z,t),a(s,$s,t),a(s,Q,t),a(s,ks,t),r(_,s,t),a(s,Rs,t),r(V,s,t),a(s,Zs,t),a(s,z,t),a(s,Qs,t),r(B,s,t),a(s,_s,t),a(s,H,t),a(s,Vs,t),r(N,s,t),a(s,zs,t),a(s,d,t),a(s,Bs,t),a(s,X,t),a(s,Hs,t),r(G,s,t),a(s,Ns,t),a(s,q,t),a(s,Xs,t),r(Y,s,t),a(s,Gs,t),a(s,J,t),a(s,qs,t),r(E,s,t),a(s,Ys,t),a(s,S,t),a(s,Es,t),a(s,F,t),a(s,Ss,t),r(L,s,t),a(s,Fs,t),a(s,A,t),a(s,Ls,t),r(D,s,t),a(s,As,t),a(s,U,t),a(s,Ds,t),a(s,P,t),a(s,Ps,t),r(K,s,t),a(s,Ks,t),a(s,O,t),a(s,Os,t),r(ss,s,t),a(s,st,t),a(s,w,t),a(s,tt,t),r(ts,s,t),a(s,lt,t),a(s,ls,t),a(s,at,t),r(as,s,t),a(s,et,t),a(s,es,t),a(s,nt,t),r(ns,s,t),a(s,pt,t),a(s,x,t),a(s,it,t),r(ps,s,t),a(s,ct,t),a(s,is,t),a(s,mt,t),a(s,cs,t),a(s,ot,t),r(ms,s,t),a(s,rt,t),a(s,os,t),a(s,gt,t),r(rs,s,t),a(s,Mt,t),a(s,T,t),a(s,ht,t),a(s,gs,t),a(s,jt,t),r(Ms,s,t),a(s,yt,t),a(s,hs,t),a(s,ut,t),r(js,s,t),a(s,bt,t),a(s,f,t),a(s,dt,t),a(s,ys,t),a(s,Jt,t),a(s,u,t),a(s,Ut,t),r(us,s,t),a(s,wt,t),a(s,ds,t),xt=!0},p:pl,i(s){xt||(g(C.$$.fragment,s),g(W.$$.fragment,s),g(_.$$.fragment,s),g(V.$$.fragment,s),g(B.$$.fragment,s),g(N.$$.fragment,s),g(G.$$.fragment,s),g(Y.$$.fragment,s),g(E.$$.fragment,s),g(L.$$.fragment,s),g(D.$$.fragment,s),g(K.$$.fragment,s),g(ss.$$.fragment,s),g(ts.$$.fragment,s),g(as.$$.fragment,s),g(ns.$$.fragment,s),g(ps.$$.fragment,s),g(ms.$$.fragment,s),g(rs.$$.fragment,s),g(Ms.$$.fragment,s),g(js.$$.fragment,s),g(us.$$.fragment,s),xt=!0)},o(s){M(C.$$.fragment,s),M(W.$$.fragment,s),M(_.$$.fragment,s),M(V.$$.fragment,s),M(B.$$.fragment,s),M(N.$$.fragment,s),M(G.$$.fragment,s),M(Y.$$.fragment,s),M(E.$$.fragment,s),M(L.$$.fragment,s),M(D.$$.fragment,s),M(K.$$.fragment,s),M(ss.$$.fragment,s),M(ts.$$.fragment,s),M(as.$$.fragment,s),M(ns.$$.fragment,s),M(ps.$$.fragment,s),M(ms.$$.fragment,s),M(rs.$$.fragment,s),M(Ms.$$.fragment,s),M(js.$$.fragment,s),M(us.$$.fragment,s),xt=!1},d(s){s&&(l(Us),l(bs),l(ws),l(xs),l(Ts),l(v),l(fs),l(I),l(Cs),l($),l(Ws),l(k),l(vs),l(R),l(Is),l(Z),l($s),l(Q),l(ks),l(Rs),l(Zs),l(z),l(Qs),l(_s),l(H),l(Vs),l(zs),l(d),l(Bs),l(X),l(Hs),l(Ns),l(q),l(Xs),l(Gs),l(J),l(qs),l(Ys),l(S),l(Es),l(F),l(Ss),l(Fs),l(A),l(Ls),l(As),l(U),l(Ds),l(P),l(Ps),l(Ks),l(O),l(Os),l(st),l(w),l(tt),l(lt),l(ls),l(at),l(et),l(es),l(nt),l(pt),l(x),l(it),l(ct),l(is),l(mt),l(cs),l(ot),l(rt),l(os),l(gt),l(Mt),l(T),l(ht),l(gs),l(jt),l(yt),l(hs),l(ut),l(bt),l(f),l(dt),l(ys),l(Jt),l(u),l(Ut),l(wt),l(ds)),l(b),h(C,s),h(W,s),h(_,s),h(V,s),h(B,s),h(N,s),h(G,s),h(Y,s),h(E,s),h(L,s),h(D,s),h(K,s),h(ss,s),h(ts,s),h(as,s),h(ns,s),h(ps,s),h(ms,s),h(rs,s),h(Ms,s),h(js,s),h(us,s)}}}const jl='{"title":"Zero-shot object detection","local":"zero-shot-object-detection","sections":[{"title":"Zero-shot object detection pipeline","local":"zero-shot-object-detection-pipeline","sections":[],"depth":2},{"title":"Text-prompted zero-shot object detection by hand","local":"text-prompted-zero-shot-object-detection-by-hand","sections":[],"depth":2},{"title":"Batch processing","local":"batch-processing","sections":[],"depth":2},{"title":"Image-guided object detection","local":"image-guided-object-detection","sections":[],"depth":2}],"depth":1}';function yl(ft){return il(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class wl extends cl{constructor(b){super(),ml(this,b,yl,hl,el,{})}}export{wl as component};
