import{s as ga,o as _a,n as ar}from"../chunks/scheduler.9bc65507.js";import{S as va,i as xa,g as n,s as o,r as p,A as $a,h as l,f as t,c as a,j as $,u as f,x as d,k as b,y as s,a as i,v as u,d as h,t as g,w as _}from"../chunks/index.707bf1b6.js";import{T as uo}from"../chunks/Tip.c2ecdbf4.js";import{D as M}from"../chunks/Docstring.86474e80.js";import{C as lr}from"../chunks/CodeBlock.54a9f38d.js";import{E as ho}from"../chunks/ExampleCodeBlock.034f3a73.js";import{H as pe,E as ba}from"../chunks/EditOnGithub.922df6ba.js";function ya(X){let c,T=`This class method is simply calling the feature extractor
<a href="/docs/transformers/pr_30375/ja/main_classes/feature_extractor#transformers.FeatureExtractionMixin.from_pretrained">from_pretrained()</a>, image processor
<a href="/docs/transformers/pr_30375/ja/main_classes/image_processor#transformers.ImageProcessingMixin">ImageProcessingMixin</a> and the tokenizer
<code>~tokenization_utils_base.PreTrainedTokenizer.from_pretrained</code> methods. Please refer to the docstrings of the
methods above for more information.`;return{c(){c=n("p"),c.innerHTML=T},l(v){c=l(v,"P",{"data-svelte-h":!0}),d(c)!=="svelte-1t7p5fv"&&(c.innerHTML=T)},m(v,x){i(v,c,x)},p:ar,d(v){v&&t(c)}}}function Ma(X){let c,T="Examples:",v,x,C;return x=new lr({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBQdXNoJTIwdGhlJTIwcHJvY2Vzc29yJTIwdG8lMjB5b3VyJTIwbmFtZXNwYWNlJTIwd2l0aCUyMHRoZSUyMG5hbWUlMjAlMjJteS1maW5ldHVuZWQtYmVydCUyMi4lMEFwcm9jZXNzb3IucHVzaF90b19odWIoJTIybXktZmluZXR1bmVkLWJlcnQlMjIpJTBBJTBBJTIzJTIwUHVzaCUyMHRoZSUyMHByb2Nlc3NvciUyMHRvJTIwYW4lMjBvcmdhbml6YXRpb24lMjB3aXRoJTIwdGhlJTIwbmFtZSUyMCUyMm15LWZpbmV0dW5lZC1iZXJ0JTIyLiUwQXByb2Nlc3Nvci5wdXNoX3RvX2h1YiglMjJodWdnaW5nZmFjZSUyRm15LWZpbmV0dW5lZC1iZXJ0JTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-comment"># Push the processor to your namespace with the name &quot;my-finetuned-bert&quot;.</span>
processor.push_to_hub(<span class="hljs-string">&quot;my-finetuned-bert&quot;</span>)

<span class="hljs-comment"># Push the processor to an organization with the name &quot;my-finetuned-bert&quot;.</span>
processor.push_to_hub(<span class="hljs-string">&quot;huggingface/my-finetuned-bert&quot;</span>)`,wrap:!1}}),{c(){c=n("p"),c.textContent=T,v=o(),p(x.$$.fragment)},l(m){c=l(m,"P",{"data-svelte-h":!0}),d(c)!=="svelte-kvfsh7"&&(c.textContent=T),v=a(m),f(x.$$.fragment,m)},m(m,j){i(m,c,j),i(m,v,j),u(x,m,j),C=!0},p:ar,i(m){C||(h(x.$$.fragment,m),C=!0)},o(m){g(x.$$.fragment,m),C=!1},d(m){m&&(t(c),t(v)),_(x,m)}}}function wa(X){let c,T="This API is experimental and may have some slight breaking changes in the next releases.";return{c(){c=n("p"),c.textContent=T},l(v){c=l(v,"P",{"data-svelte-h":!0}),d(c)!=="svelte-15rpg4"&&(c.textContent=T)},m(v,x){i(v,c,x)},p:ar,d(v){v&&t(c)}}}function Ta(X){let c,T=`This class method is simply calling <a href="/docs/transformers/pr_30375/ja/main_classes/feature_extractor#transformers.FeatureExtractionMixin.save_pretrained">save_pretrained()</a> and
<a href="/docs/transformers/pr_30375/ja/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.save_pretrained">save_pretrained()</a>. Please refer to the docstrings of the
methods above for more information.`;return{c(){c=n("p"),c.innerHTML=T},l(v){c=l(v,"P",{"data-svelte-h":!0}),d(c)!=="svelte-1s39tx2"&&(c.innerHTML=T)},m(v,x){i(v,c,x)},p:ar,d(v){v&&t(c)}}}function Ca(X){let c,T="Examples:",v,x,C;return x=new lr({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvd19kYXRhc2V0cyUyMGFzJTIwdGZkcyUwQSUwQWRhdGFzZXQlMjAlM0QlMjB0ZmRzLmxvYWQoJTIyc3F1YWQlMjIpJTBBJTBBdHJhaW5pbmdfZXhhbXBsZXMlMjAlM0QlMjBnZXRfZXhhbXBsZXNfZnJvbV9kYXRhc2V0KGRhdGFzZXQlMkMlMjBldmFsdWF0ZSUzREZhbHNlKSUwQWV2YWx1YXRpb25fZXhhbXBsZXMlMjAlM0QlMjBnZXRfZXhhbXBsZXNfZnJvbV9kYXRhc2V0KGRhdGFzZXQlMkMlMjBldmFsdWF0ZSUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow_datasets <span class="hljs-keyword">as</span> tfds

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = tfds.load(<span class="hljs-string">&quot;squad&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>training_examples = get_examples_from_dataset(dataset, evaluate=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>evaluation_examples = get_examples_from_dataset(dataset, evaluate=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){c=n("p"),c.textContent=T,v=o(),p(x.$$.fragment)},l(m){c=l(m,"P",{"data-svelte-h":!0}),d(c)!=="svelte-kvfsh7"&&(c.textContent=T),v=a(m),f(x.$$.fragment,m)},m(m,j){i(m,c,j),i(m,v,j),u(x,m,j),C=!0},p:ar,i(m){C||(h(x.$$.fragment,m),C=!0)},o(m){g(x.$$.fragment,m),C=!1},d(m){m&&(t(c),t(v)),_(x,m)}}}function Pa(X){let c,T="Example:",v,x,C;return x=new lr({props:{code:"cHJvY2Vzc29yJTIwJTNEJTIwU3F1YWRWMlByb2Nlc3NvcigpJTBBZXhhbXBsZXMlMjAlM0QlMjBwcm9jZXNzb3IuZ2V0X2Rldl9leGFtcGxlcyhkYXRhX2RpciklMEElMEFmZWF0dXJlcyUyMCUzRCUyMHNxdWFkX2NvbnZlcnRfZXhhbXBsZXNfdG9fZmVhdHVyZXMoJTBBJTIwJTIwJTIwJTIwZXhhbXBsZXMlM0RleGFtcGxlcyUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMG1heF9zZXFfbGVuZ3RoJTNEYXJncy5tYXhfc2VxX2xlbmd0aCUyQyUwQSUyMCUyMCUyMCUyMGRvY19zdHJpZGUlM0RhcmdzLmRvY19zdHJpZGUlMkMlMEElMjAlMjAlMjAlMjBtYXhfcXVlcnlfbGVuZ3RoJTNEYXJncy5tYXhfcXVlcnlfbGVuZ3RoJTJDJTBBJTIwJTIwJTIwJTIwaXNfdHJhaW5pbmclM0Rub3QlMjBldmFsdWF0ZSUyQyUwQSk=",highlighted:`processor = SquadV2Processor()
examples = processor.get_dev_examples(data_dir)

features = squad_convert_examples_to_features(
    examples=examples,
    tokenizer=tokenizer,
    max_seq_length=args.max_seq_length,
    doc_stride=args.doc_stride,
    max_query_length=args.max_query_length,
    is_training=<span class="hljs-keyword">not</span> evaluate,
)`,wrap:!1}}),{c(){c=n("p"),c.textContent=T,v=o(),p(x.$$.fragment)},l(m){c=l(m,"P",{"data-svelte-h":!0}),d(c)!=="svelte-11lpom8"&&(c.textContent=T),v=a(m),f(x.$$.fragment,m)},m(m,j){i(m,c,j),i(m,v,j),u(x,m,j),C=!0},p:ar,i(m){C||(h(x.$$.fragment,m),C=!0)},o(m){g(x.$$.fragment,m),C=!1},d(m){m&&(t(c),t(v)),_(x,m)}}}function ja(X){let c,T,v,x,C,m,j,go="Transformers ライブラリでは、プロセッサは 2 つの異なる意味を持ちます。",ir,fe,_o=`<li><a href="../model_doc/wav2vec2">Wav2Vec2</a> などのマルチモーダル モデルの入力を前処理するオブジェクト (音声とテキスト)
または <a href="../model_doc/clip">CLIP</a> (テキストとビジョン)</li> <li>古いバージョンのライブラリで GLUE または SQUAD のデータを前処理するために使用されていたオブジェクトは非推奨になりました。</li>`,dr,ue,cr,he,vo=`マルチモーダル モデルでは、オブジェクトが複数のモダリティ (テキスト、
視覚と音声）。これは、2 つ以上の処理オブジェクトをグループ化するプロセッサーと呼ばれるオブジェクトによって処理されます。
トークナイザー (テキスト モダリティ用)、画像プロセッサー (視覚用)、特徴抽出器 (オーディオ用) など。`,mr,ge,xo="これらのプロセッサは、保存およびロード機能を実装する次の基本クラスを継承します。",pr,y,_e,ps,Tt,$o="This is a mixin used to provide saving/loading functionality for all processor classes.",fs,F,ve,us,Ct,bo=`Similar to the <code>apply_chat_template</code> method on tokenizers, this method applies a Jinja template to input
conversations to turn them into a single tokenizable string.`,hs,S,xe,gs,Pt,yo="Instantiates a type of <code>~processing_utils.ProcessingMixin</code> from a Python dictionary of parameters.",_s,Z,$e,vs,jt,Mo="Instantiate a processor associated with a pretrained model.",xs,R,$s,G,be,bs,It,wo=`From a <code>pretrained_model_name_or_path</code>, resolve to a dictionary of parameters, to be used for instantiating a
processor of type <code>~processing_utils.ProcessingMixin</code> using <code>from_args_and_dict</code>.`,ys,q,ye,Ms,kt,To="Upload the processor files to the 🤗 Model Hub.",ws,W,Ts,V,Me,Cs,Xt,Co=`Register this class with a given auto class. This should only be used for custom feature extractors as the ones
in the library are already mapped with <code>AutoProcessor</code>.`,Ps,Q,js,z,we,Is,Jt,Po=`Saves the attributes of this processor (feature extractor, tokenizer…) in the specified directory so that it
can be reloaded using the <a href="/docs/transformers/pr_30375/ja/main_classes/processors#transformers.ProcessorMixin.from_pretrained">from_pretrained()</a> method.`,ks,Y,Xs,A,Te,Js,Lt,jo="Serializes this instance to a Python dictionary.",Ls,O,Ce,Us,Ut,Io="Save this instance to a JSON file.",Zs,K,Pe,qs,Zt,ko="Serializes this instance to a JSON string.",fr,je,ur,Ie,Xo=`すべてのプロセッサは、同じアーキテクチャに従っています。
<a href="/docs/transformers/pr_30375/ja/main_classes/processors#transformers.DataProcessor">DataProcessor</a>。プロセッサは次のリストを返します。
<a href="/docs/transformers/pr_30375/ja/main_classes/processors#transformers.InputExample">InputExample</a>。これら
<a href="/docs/transformers/pr_30375/ja/main_classes/processors#transformers.InputExample">InputExample</a> は次のように変換できます。
<code>~data.processors.utils.Input features</code> をモデルにフィードします。`,hr,P,ke,Vs,qt,Jo="Base class for data converters for sequence classification data sets.",zs,ee,Xe,Es,Vt,Lo='Gets a collection of <a href="/docs/transformers/pr_30375/ja/main_classes/processors#transformers.InputExample">InputExample</a> for the dev set.',Hs,te,Je,Ns,zt,Uo="Gets an example from a dict with tensorflow tensors.",Bs,re,Le,Ds,Et,Zo="Gets the list of labels for this data set.",Fs,se,Ue,Ss,Ht,qo='Gets a collection of <a href="/docs/transformers/pr_30375/ja/main_classes/processors#transformers.InputExample">InputExample</a> for the test set.',Rs,oe,Ze,Gs,Nt,Vo='Gets a collection of <a href="/docs/transformers/pr_30375/ja/main_classes/processors#transformers.InputExample">InputExample</a> for the train set.',Ws,ae,qe,Qs,Bt,zo=`Some tensorflow_datasets datasets are not formatted the same way the GLUE datasets are. This method converts
examples to the correct format.`,gr,J,Ve,Ys,Dt,Eo="A single training/test example for simple sequence classification.",As,ne,ze,Os,Ft,Ho="Serializes this instance to a JSON string.",_r,L,Ee,Ks,St,No="A single set of features of data. Property names are the same names as the corresponding inputs to a model.",eo,le,He,to,Rt,Bo="Serializes this instance to a JSON string.",vr,Ne,xr,Be,Do=`<a href="https://gluebenchmark.com/" rel="nofollow">一般言語理解評価 (GLUE)</a> は、
既存の NLU タスクの多様なセットにわたるモデルのパフォーマンス。紙と同時発売された <a href="https://openreview.net/pdf?id=rJ4km2R5t7" rel="nofollow">GLUE: A
自然言語理解のためのマルチタスクベンチマークおよび分析プラットフォーム</a>`,$r,De,Fo=`このライブラリは、MRPC、MNLI、MNLI (不一致)、CoLA、SST2、STSB、
QQP、QNLI、RTE、WNLI。`,br,Fe,So="それらのプロセッサは次のとおりです。",yr,Se,Ro="<li><code>~data.processors.utils.MrpcProcessor</code></li> <li><code>~data.processors.utils.MnliProcessor</code></li> <li><code>~data.processors.utils.MnliMismatchedProcessor</code></li> <li><code>~data.processors.utils.Sst2Processor</code></li> <li><code>~data.processors.utils.StsbProcessor</code></li> <li><code>~data.processors.utils.QqpProcessor</code></li> <li><code>~data.processors.utils.QnliProcessor</code></li> <li><code>~data.processors.utils.RteProcessor</code></li> <li><code>~data.processors.utils.WnliProcessor</code></li>",Mr,Re,Go=`さらに、次のメソッドを使用して、データ ファイルから値をロードし、それらをリストに変換することができます。
<a href="/docs/transformers/pr_30375/ja/main_classes/processors#transformers.InputExample">InputExample</a>。`,wr,N,Ge,ro,Gt,Wo="Loads a data file into a list of <code>InputFeatures</code>",Tr,We,Cr,Qe,Qo=`<a href="https://www.nyu.edu/projects/bowman/xnli/" rel="nofollow">クロスリンガル NLI コーパス (XNLI)</a> は、
言語を超えたテキスト表現の品質。 XNLI は、<a href="http://www.nyu.edu/projects/bowman/multinli/" rel="nofollow"><em>MultiNLI</em></a> に基づくクラウドソースのデータセットです。テキストのペアには、15 個のテキスト含意アノテーションがラベル付けされています。
さまざまな言語 (英語などの高リソース言語とスワヒリ語などの低リソース言語の両方を含む)。`,Pr,Ye,Yo='論文 <a href="https://arxiv.org/abs/1809.05053" rel="nofollow">XNLI: Evaluating Cross-lingual Sentence Representations</a> と同時にリリースされました。',jr,Ae,Ao="このライブラリは、XNLI データをロードするプロセッサをホストします。",Ir,Oe,Oo="<li><code>~data.processors.utils.XnliProcessor</code></li>",kr,Ke,Ko="テストセットにはゴールドラベルが付いているため、評価はテストセットで行われますのでご了承ください。",Xr,et,ea='これらのプロセッサを使用する例は、<a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/text-classification/run_xnli.py" rel="nofollow">run_xnli.py</a> スクリプトに示されています。',Jr,tt,Lr,rt,ta=`<a href="https://rajpurkar.github.io/SQuAD-explorer//" rel="nofollow">The Stanford Question Answering Dataset (SQuAD)</a> は、次のベンチマークです。
質問応答に関するモデルのパフォーマンスを評価します。 v1.1 と v2.0 の 2 つのバージョンが利用可能です。最初のバージョン
(v1.1) は、論文 <a href="https://arxiv.org/abs/1606.05250" rel="nofollow">SQuAD: 100,000+ question for Machine Comprehension of Text</a> とともにリリースされました。 2 番目のバージョン (v2.0) は、論文 <a href="https://arxiv.org/abs/1806.03822" rel="nofollow">Know What You Don’t と同時にリリースされました。
知っておくべき: SQuAD の答えられない質問</a>。`,Ur,st,ra="このライブラリは、次の 2 つのバージョンのそれぞれのプロセッサをホストします。",Zr,ot,qr,at,sa="それらのプロセッサは次のとおりです。",Vr,nt,oa="<li><code>~data.processors.utils.SquadV1Processor</code></li> <li><code>~data.processors.utils.SquadV2Processor</code></li>",zr,lt,aa="どちらも抽象クラス <code>~data.processors.utils.SquadProcessor</code> を継承しています。",Er,k,it,so,Wt,na=`Processor for the SQuAD data set. overridden by SquadV1Processor and SquadV2Processor, used by the version 1.1 and
version 2.0 of SQuAD, respectively.`,oo,ie,dt,ao,Qt,la="Returns the evaluation example from the data directory.",no,E,ct,lo,Yt,ia="Creates a list of <code>SquadExample</code> using a TFDS dataset.",io,de,co,ce,mt,mo,At,da="Returns the training examples from the data directory.",Hr,pt,ca=`さらに、次のメソッドを使用して、SQuAD の例を次の形式に変換できます。
モデルの入力として使用できる <code>~data.processors.utils.SquadFeatures</code>。`,Nr,U,ft,po,Ot,ma=`Converts a list of examples into a list of features that can be directly given as input to a model. It is
model-dependant and takes advantage of many of the tokenizer’s features to create the model’s inputs.`,fo,me,Br,ut,pa=`これらのプロセッサと前述の方法は、データを含むファイルだけでなく、
<em>tensorflow_datasets</em> パッケージ。以下に例を示します。`,Dr,ht,Fr,gt,fa="以下にプロセッサを使用した例と、データ ファイルを使用した変換方法を示します。",Sr,_t,Rr,vt,ua="<em>tensorflow_datasets</em> の使用は、データ ファイルを使用するのと同じくらい簡単です。",Gr,xt,Wr,$t,ha='これらのプロセッサを使用する別の例は、<a href="https://github.com/huggingface/transformers/tree/main/examples/legacy/question-answering/run_squad.py" rel="nofollow">run_squad.py</a> スクリプトに示されています。',Qr,bt,Yr,nr,Ar;return C=new pe({props:{title:"Processors",local:"processors",headingTag:"h1"}}),ue=new pe({props:{title:"Multi-modal processors",local:"transformers.ProcessorMixin",headingTag:"h2"}}),_e=new M({props:{name:"class transformers.ProcessorMixin",anchor:"transformers.ProcessorMixin",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30375/src/transformers/processing_utils.py#L312"}}),ve=new M({props:{name:"apply_chat_template",anchor:"transformers.ProcessorMixin.apply_chat_template",parameters:[{name:"conversation",val:": List"},{name:"chat_template",val:": Optional = None"},{name:"tokenize",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.apply_chat_template.conversation",description:`<strong>conversation</strong> (<code>List[Dict, str, str]</code>) &#x2014;
The conversation to format.`,name:"conversation"},{anchor:"transformers.ProcessorMixin.apply_chat_template.chat_template",description:`<strong>chat_template</strong> (<code>Optional[str]</code>, <em>optional</em>) &#x2014;
The Jinja template to use for formatting the conversation. If not provided, the default chat template
is used.`,name:"chat_template"},{anchor:"transformers.ProcessorMixin.apply_chat_template.tokenize",description:`<strong>tokenize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to tokenize the output or not.
**kwargs &#x2014;
Additional keyword arguments`,name:"tokenize"}],source:"https://github.com/huggingface/transformers/blob/vr_30375/src/transformers/processing_utils.py#L890"}}),xe=new M({props:{name:"from_args_and_dict",anchor:"transformers.ProcessorMixin.from_args_and_dict",parameters:[{name:"args",val:""},{name:"processor_dict",val:": Dict"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.from_args_and_dict.processor_dict",description:`<strong>processor_dict</strong> (<code>Dict[str, Any]</code>) &#x2014;
Dictionary that will be used to instantiate the processor object. Such a dictionary can be
retrieved from a pretrained checkpoint by leveraging the
<code>~processing_utils.ProcessingMixin.to_dict</code> method.`,name:"processor_dict"},{anchor:"transformers.ProcessorMixin.from_args_and_dict.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Additional parameters from which to initialize the processor object.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30375/src/transformers/processing_utils.py#L631",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processor object instantiated from those
parameters.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~processing_utils.ProcessingMixin</code></p>
`}}),$e=new M({props:{name:"from_pretrained",anchor:"transformers.ProcessorMixin.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"cache_dir",val:": Union = None"},{name:"force_download",val:": bool = False"},{name:"local_files_only",val:": bool = False"},{name:"token",val:": Union = None"},{name:"revision",val:": str = 'main'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
This can be either:</p>
<ul>
<li>a string, the <em>model id</em> of a pretrained feature_extractor hosted inside a model repo on
huggingface.co.</li>
<li>a path to a <em>directory</em> containing a feature extractor file saved using the
<a href="/docs/transformers/pr_30375/ja/main_classes/feature_extractor#transformers.FeatureExtractionMixin.save_pretrained">save_pretrained()</a> method, e.g., <code>./my_model_directory/</code>.</li>
<li>a path or url to a saved feature extractor JSON <em>file</em>, e.g.,
<code>./my_model_directory/preprocessor_config.json</code>.
**kwargs &#x2014;
Additional keyword arguments passed along to both
<a href="/docs/transformers/pr_30375/ja/main_classes/feature_extractor#transformers.FeatureExtractionMixin.from_pretrained">from_pretrained()</a> and
<code>~tokenization_utils_base.PreTrainedTokenizer.from_pretrained</code>.</li>
</ul>`,name:"pretrained_model_name_or_path"}],source:"https://github.com/huggingface/transformers/blob/vr_30375/src/transformers/processing_utils.py#L777"}}),R=new uo({props:{$$slots:{default:[ya]},$$scope:{ctx:X}}}),be=new M({props:{name:"get_processor_dict",anchor:"transformers.ProcessorMixin.get_processor_dict",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.get_processor_dict.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
The identifier of the pre-trained checkpoint from which we want the dictionary of parameters.`,name:"pretrained_model_name_or_path"},{anchor:"transformers.ProcessorMixin.get_processor_dict.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the relevant files are located inside a subfolder of the model repo on huggingface.co, you can
specify the folder name here.`,name:"subfolder"}],source:"https://github.com/huggingface/transformers/blob/vr_30375/src/transformers/processing_utils.py#L517",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The dictionary(ies) that will be used to instantiate the processor object.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Tuple[Dict, Dict]</code></p>
`}}),ye=new M({props:{name:"push_to_hub",anchor:"transformers.ProcessorMixin.push_to_hub",parameters:[{name:"repo_id",val:": str"},{name:"use_temp_dir",val:": Optional = None"},{name:"commit_message",val:": Optional = None"},{name:"private",val:": Optional = None"},{name:"token",val:": Union = None"},{name:"max_shard_size",val:": Union = '5GB'"},{name:"create_pr",val:": bool = False"},{name:"safe_serialization",val:": bool = True"},{name:"revision",val:": str = None"},{name:"commit_description",val:": str = None"},{name:"tags",val:": Optional = None"},{name:"**deprecated_kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.push_to_hub.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The name of the repository you want to push your processor to. It should contain your organization name
when pushing to a given organization.`,name:"repo_id"},{anchor:"transformers.ProcessorMixin.push_to_hub.use_temp_dir",description:`<strong>use_temp_dir</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to use a temporary directory to store the files saved before they are pushed to the Hub.
Will default to <code>True</code> if there is no directory named like <code>repo_id</code>, <code>False</code> otherwise.`,name:"use_temp_dir"},{anchor:"transformers.ProcessorMixin.push_to_hub.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Message to commit while pushing. Will default to <code>&quot;Upload processor&quot;</code>.`,name:"commit_message"},{anchor:"transformers.ProcessorMixin.push_to_hub.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not the repository created should be private.`,name:"private"},{anchor:"transformers.ProcessorMixin.push_to_hub.token",description:`<strong>token</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>). Will default to <code>True</code> if <code>repo_url</code>
is not specified.`,name:"token"},{anchor:"transformers.ProcessorMixin.push_to_hub.max_shard_size",description:`<strong>max_shard_size</strong> (<code>int</code> or <code>str</code>, <em>optional</em>, defaults to <code>&quot;5GB&quot;</code>) &#x2014;
Only applicable for models. The maximum size for a checkpoint before being sharded. Checkpoints shard
will then be each of size lower than this size. If expressed as a string, needs to be digits followed
by a unit (like <code>&quot;5MB&quot;</code>). We default it to <code>&quot;5GB&quot;</code> so that users can easily load models on free-tier
Google Colab instances without any CPU OOM issues.`,name:"max_shard_size"},{anchor:"transformers.ProcessorMixin.push_to_hub.create_pr",description:`<strong>create_pr</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to create a PR with the uploaded files or directly commit.`,name:"create_pr"},{anchor:"transformers.ProcessorMixin.push_to_hub.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to convert the model weights in safetensors format for safer serialization.`,name:"safe_serialization"},{anchor:"transformers.ProcessorMixin.push_to_hub.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Branch to push the uploaded files to.`,name:"revision"},{anchor:"transformers.ProcessorMixin.push_to_hub.commit_description",description:`<strong>commit_description</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The description of the commit that will be created`,name:"commit_description"},{anchor:"transformers.ProcessorMixin.push_to_hub.tags",description:`<strong>tags</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
List of tags to push on the Hub.`,name:"tags"}],source:"https://github.com/huggingface/transformers/blob/vr_30375/src/transformers/utils/hub.py#L809"}}),W=new ho({props:{anchor:"transformers.ProcessorMixin.push_to_hub.example",$$slots:{default:[Ma]},$$scope:{ctx:X}}}),Me=new M({props:{name:"register_for_auto_class",anchor:"transformers.ProcessorMixin.register_for_auto_class",parameters:[{name:"auto_class",val:" = 'AutoProcessor'"}],parametersDescription:[{anchor:"transformers.ProcessorMixin.register_for_auto_class.auto_class",description:`<strong>auto_class</strong> (<code>str</code> or <code>type</code>, <em>optional</em>, defaults to <code>&quot;AutoProcessor&quot;</code>) &#x2014;
The auto class to register this new feature extractor with.`,name:"auto_class"}],source:"https://github.com/huggingface/transformers/blob/vr_30375/src/transformers/processing_utils.py#L841"}}),Q=new uo({props:{warning:!0,$$slots:{default:[wa]},$$scope:{ctx:X}}}),we=new M({props:{name:"save_pretrained",anchor:"transformers.ProcessorMixin.save_pretrained",parameters:[{name:"save_directory",val:""},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory where the feature extractor JSON file and the tokenizer files will be saved (directory will
be created if it does not exist).`,name:"save_directory"},{anchor:"transformers.ProcessorMixin.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"transformers.ProcessorMixin.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional key word arguments passed along to the <a href="/docs/transformers/pr_30375/ja/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30375/src/transformers/processing_utils.py#L428"}}),Y=new uo({props:{$$slots:{default:[Ta]},$$scope:{ctx:X}}}),Te=new M({props:{name:"to_dict",anchor:"transformers.ProcessorMixin.to_dict",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30375/src/transformers/processing_utils.py#L363",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of all the attributes that make up this processor instance.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, Any]</code></p>
`}}),Ce=new M({props:{name:"to_json_file",anchor:"transformers.ProcessorMixin.to_json_file",parameters:[{name:"json_file_path",val:": Union"}],parametersDescription:[{anchor:"transformers.ProcessorMixin.to_json_file.json_file_path",description:`<strong>json_file_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Path to the JSON file in which this processor instance&#x2019;s parameters will be saved.`,name:"json_file_path"}],source:"https://github.com/huggingface/transformers/blob/vr_30375/src/transformers/processing_utils.py#L412"}}),Pe=new M({props:{name:"to_json_string",anchor:"transformers.ProcessorMixin.to_json_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30375/src/transformers/processing_utils.py#L401",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>String containing all the attributes that make up this feature_extractor instance in JSON format.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),je=new pe({props:{title:"Deprecated processors",local:"transformers.DataProcessor",headingTag:"h2"}}),ke=new M({props:{name:"class transformers.DataProcessor",anchor:"transformers.DataProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30375/src/transformers/data/processors/utils.py#L80"}}),Xe=new M({props:{name:"get_dev_examples",anchor:"transformers.DataProcessor.get_dev_examples",parameters:[{name:"data_dir",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30375/src/transformers/data/processors/utils.py#L97"}}),Je=new M({props:{name:"get_example_from_tensor_dict",anchor:"transformers.DataProcessor.get_example_from_tensor_dict",parameters:[{name:"tensor_dict",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30375/src/transformers/data/processors/utils.py#L83"}}),Le=new M({props:{name:"get_labels",anchor:"transformers.DataProcessor.get_labels",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30375/src/transformers/data/processors/utils.py#L105"}}),Ue=new M({props:{name:"get_test_examples",anchor:"transformers.DataProcessor.get_test_examples",parameters:[{name:"data_dir",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30375/src/transformers/data/processors/utils.py#L101"}}),Ze=new M({props:{name:"get_train_examples",anchor:"transformers.DataProcessor.get_train_examples",parameters:[{name:"data_dir",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30375/src/transformers/data/processors/utils.py#L93"}}),qe=new M({props:{name:"tfds_map",anchor:"transformers.DataProcessor.tfds_map",parameters:[{name:"example",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30375/src/transformers/data/processors/utils.py#L109"}}),Ve=new M({props:{name:"class transformers.InputExample",anchor:"transformers.InputExample",parameters:[{name:"guid",val:": str"},{name:"text_a",val:": str"},{name:"text_b",val:": Optional = None"},{name:"label",val:": Optional = None"}],source:"https://github.com/huggingface/transformers/blob/vr_30375/src/transformers/data/processors/utils.py#L29"}}),ze=new M({props:{name:"to_json_string",anchor:"transformers.InputExample.to_json_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30375/src/transformers/data/processors/utils.py#L49"}}),Ee=new M({props:{name:"class transformers.InputFeatures",anchor:"transformers.InputFeatures",parameters:[{name:"input_ids",val:": List"},{name:"attention_mask",val:": Optional = None"},{name:"token_type_ids",val:": Optional = None"},{name:"label",val:": Union = None"}],source:"https://github.com/huggingface/transformers/blob/vr_30375/src/transformers/data/processors/utils.py#L54"}}),He=new M({props:{name:"to_json_string",anchor:"transformers.InputFeatures.to_json_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30375/src/transformers/data/processors/utils.py#L75"}}),Ne=new pe({props:{title:"GLUE",local:"transformers.glue_convert_examples_to_features",headingTag:"h2"}}),Ge=new M({props:{name:"transformers.glue_convert_examples_to_features",anchor:"transformers.glue_convert_examples_to_features",parameters:[{name:"examples",val:": Union"},{name:"tokenizer",val:": PreTrainedTokenizer"},{name:"max_length",val:": Optional = None"},{name:"task",val:" = None"},{name:"label_list",val:" = None"},{name:"output_mode",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/vr_30375/src/transformers/data/processors/glue.py#L41",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If the <code>examples</code> input is a <code>tf.data.Dataset</code>, will return a <code>tf.data.Dataset</code> containing the task-specific
features. If the input is a list of <code>InputExamples</code>, will return a list of task-specific <code>InputFeatures</code> which
can be fed to the model.</p>
`}}),We=new pe({props:{title:"XNLI",local:"xnli",headingTag:"h2"}}),tt=new pe({props:{title:"SQuAD",local:"squad",headingTag:"h2"}}),ot=new pe({props:{title:"Processors",local:"transformers.data.processors.squad.SquadProcessor",headingTag:"h3"}}),it=new M({props:{name:"class transformers.data.processors.squad.SquadProcessor",anchor:"transformers.data.processors.squad.SquadProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30375/src/transformers/data/processors/squad.py#L541"}}),dt=new M({props:{name:"get_dev_examples",anchor:"transformers.data.processors.squad.SquadProcessor.get_dev_examples",parameters:[{name:"data_dir",val:""},{name:"filename",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/vr_30375/src/transformers/data/processors/squad.py#L629"}}),ct=new M({props:{name:"get_examples_from_dataset",anchor:"transformers.data.processors.squad.SquadProcessor.get_examples_from_dataset",parameters:[{name:"dataset",val:""},{name:"evaluate",val:" = False"}],source:"https://github.com/huggingface/transformers/blob/vr_30375/src/transformers/data/processors/squad.py#L574",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of SquadExample</p>
`}}),de=new ho({props:{anchor:"transformers.data.processors.squad.SquadProcessor.get_examples_from_dataset.example",$$slots:{default:[Ca]},$$scope:{ctx:X}}}),mt=new M({props:{name:"get_train_examples",anchor:"transformers.data.processors.squad.SquadProcessor.get_train_examples",parameters:[{name:"data_dir",val:""},{name:"filename",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/vr_30375/src/transformers/data/processors/squad.py#L607"}}),ft=new M({props:{name:"transformers.squad_convert_examples_to_features",anchor:"transformers.squad_convert_examples_to_features",parameters:[{name:"examples",val:""},{name:"tokenizer",val:""},{name:"max_seq_length",val:""},{name:"doc_stride",val:""},{name:"max_query_length",val:""},{name:"is_training",val:""},{name:"padding_strategy",val:" = 'max_length'"},{name:"return_dataset",val:" = False"},{name:"threads",val:" = 1"},{name:"tqdm_enabled",val:" = True"}],source:"https://github.com/huggingface/transformers/blob/vr_30375/src/transformers/data/processors/squad.py#L316",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>list of <code>SquadFeatures</code></p>
`}}),me=new ho({props:{anchor:"transformers.squad_convert_examples_to_features.example",$$slots:{default:[Pa]},$$scope:{ctx:X}}}),ht=new pe({props:{title:"Example usage",local:"example-usage",headingTag:"h3"}}),_t=new lr({props:{code:"JTIzJTIwTG9hZGluZyUyMGElMjBWMiUyMHByb2Nlc3NvciUwQXByb2Nlc3NvciUyMCUzRCUyMFNxdWFkVjJQcm9jZXNzb3IoKSUwQWV4YW1wbGVzJTIwJTNEJTIwcHJvY2Vzc29yLmdldF9kZXZfZXhhbXBsZXMoc3F1YWRfdjJfZGF0YV9kaXIpJTBBJTBBJTIzJTIwTG9hZGluZyUyMGElMjBWMSUyMHByb2Nlc3NvciUwQXByb2Nlc3NvciUyMCUzRCUyMFNxdWFkVjFQcm9jZXNzb3IoKSUwQWV4YW1wbGVzJTIwJTNEJTIwcHJvY2Vzc29yLmdldF9kZXZfZXhhbXBsZXMoc3F1YWRfdjFfZGF0YV9kaXIpJTBBJTBBZmVhdHVyZXMlMjAlM0QlMjBzcXVhZF9jb252ZXJ0X2V4YW1wbGVzX3RvX2ZlYXR1cmVzKCUwQSUyMCUyMCUyMCUyMGV4YW1wbGVzJTNEZXhhbXBsZXMlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxX2xlbmd0aCUzRG1heF9zZXFfbGVuZ3RoJTJDJTBBJTIwJTIwJTIwJTIwZG9jX3N0cmlkZSUzRGFyZ3MuZG9jX3N0cmlkZSUyQyUwQSUyMCUyMCUyMCUyMG1heF9xdWVyeV9sZW5ndGglM0RtYXhfcXVlcnlfbGVuZ3RoJTJDJTBBJTIwJTIwJTIwJTIwaXNfdHJhaW5pbmclM0Rub3QlMjBldmFsdWF0ZSUyQyUwQSk=",highlighted:`<span class="hljs-comment"># Loading a V2 processor</span>
processor = SquadV2Processor()
examples = processor.get_dev_examples(squad_v2_data_dir)

<span class="hljs-comment"># Loading a V1 processor</span>
processor = SquadV1Processor()
examples = processor.get_dev_examples(squad_v1_data_dir)

features = squad_convert_examples_to_features(
    examples=examples,
    tokenizer=tokenizer,
    max_seq_length=max_seq_length,
    doc_stride=args.doc_stride,
    max_query_length=max_query_length,
    is_training=<span class="hljs-keyword">not</span> evaluate,
)`,wrap:!1}}),xt=new lr({props:{code:"JTIzJTIwdGVuc29yZmxvd19kYXRhc2V0cyUyMG9ubHklMjBoYW5kbGUlMjBTcXVhZCUyMFYxLiUwQXRmZHNfZXhhbXBsZXMlMjAlM0QlMjB0ZmRzLmxvYWQoJTIyc3F1YWQlMjIpJTBBZXhhbXBsZXMlMjAlM0QlMjBTcXVhZFYxUHJvY2Vzc29yKCkuZ2V0X2V4YW1wbGVzX2Zyb21fZGF0YXNldCh0ZmRzX2V4YW1wbGVzJTJDJTIwZXZhbHVhdGUlM0RldmFsdWF0ZSklMEElMEFmZWF0dXJlcyUyMCUzRCUyMHNxdWFkX2NvbnZlcnRfZXhhbXBsZXNfdG9fZmVhdHVyZXMoJTBBJTIwJTIwJTIwJTIwZXhhbXBsZXMlM0RleGFtcGxlcyUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMG1heF9zZXFfbGVuZ3RoJTNEbWF4X3NlcV9sZW5ndGglMkMlMEElMjAlMjAlMjAlMjBkb2Nfc3RyaWRlJTNEYXJncy5kb2Nfc3RyaWRlJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3F1ZXJ5X2xlbmd0aCUzRG1heF9xdWVyeV9sZW5ndGglMkMlMEElMjAlMjAlMjAlMjBpc190cmFpbmluZyUzRG5vdCUyMGV2YWx1YXRlJTJDJTBBKQ==",highlighted:`<span class="hljs-comment"># tensorflow_datasets only handle Squad V1.</span>
tfds_examples = tfds.load(<span class="hljs-string">&quot;squad&quot;</span>)
examples = SquadV1Processor().get_examples_from_dataset(tfds_examples, evaluate=evaluate)

features = squad_convert_examples_to_features(
    examples=examples,
    tokenizer=tokenizer,
    max_seq_length=max_seq_length,
    doc_stride=args.doc_stride,
    max_query_length=max_query_length,
    is_training=<span class="hljs-keyword">not</span> evaluate,
)`,wrap:!1}}),bt=new ba({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/ja/main_classes/processors.md"}}),{c(){c=n("meta"),T=o(),v=n("p"),x=o(),p(C.$$.fragment),m=o(),j=n("p"),j.textContent=go,ir=o(),fe=n("ul"),fe.innerHTML=_o,dr=o(),p(ue.$$.fragment),cr=o(),he=n("p"),he.textContent=vo,mr=o(),ge=n("p"),ge.textContent=xo,pr=o(),y=n("div"),p(_e.$$.fragment),ps=o(),Tt=n("p"),Tt.textContent=$o,fs=o(),F=n("div"),p(ve.$$.fragment),us=o(),Ct=n("p"),Ct.innerHTML=bo,hs=o(),S=n("div"),p(xe.$$.fragment),gs=o(),Pt=n("p"),Pt.innerHTML=yo,_s=o(),Z=n("div"),p($e.$$.fragment),vs=o(),jt=n("p"),jt.textContent=Mo,xs=o(),p(R.$$.fragment),$s=o(),G=n("div"),p(be.$$.fragment),bs=o(),It=n("p"),It.innerHTML=wo,ys=o(),q=n("div"),p(ye.$$.fragment),Ms=o(),kt=n("p"),kt.textContent=To,ws=o(),p(W.$$.fragment),Ts=o(),V=n("div"),p(Me.$$.fragment),Cs=o(),Xt=n("p"),Xt.innerHTML=Co,Ps=o(),p(Q.$$.fragment),js=o(),z=n("div"),p(we.$$.fragment),Is=o(),Jt=n("p"),Jt.innerHTML=Po,ks=o(),p(Y.$$.fragment),Xs=o(),A=n("div"),p(Te.$$.fragment),Js=o(),Lt=n("p"),Lt.textContent=jo,Ls=o(),O=n("div"),p(Ce.$$.fragment),Us=o(),Ut=n("p"),Ut.textContent=Io,Zs=o(),K=n("div"),p(Pe.$$.fragment),qs=o(),Zt=n("p"),Zt.textContent=ko,fr=o(),p(je.$$.fragment),ur=o(),Ie=n("p"),Ie.innerHTML=Xo,hr=o(),P=n("div"),p(ke.$$.fragment),Vs=o(),qt=n("p"),qt.textContent=Jo,zs=o(),ee=n("div"),p(Xe.$$.fragment),Es=o(),Vt=n("p"),Vt.innerHTML=Lo,Hs=o(),te=n("div"),p(Je.$$.fragment),Ns=o(),zt=n("p"),zt.textContent=Uo,Bs=o(),re=n("div"),p(Le.$$.fragment),Ds=o(),Et=n("p"),Et.textContent=Zo,Fs=o(),se=n("div"),p(Ue.$$.fragment),Ss=o(),Ht=n("p"),Ht.innerHTML=qo,Rs=o(),oe=n("div"),p(Ze.$$.fragment),Gs=o(),Nt=n("p"),Nt.innerHTML=Vo,Ws=o(),ae=n("div"),p(qe.$$.fragment),Qs=o(),Bt=n("p"),Bt.textContent=zo,gr=o(),J=n("div"),p(Ve.$$.fragment),Ys=o(),Dt=n("p"),Dt.textContent=Eo,As=o(),ne=n("div"),p(ze.$$.fragment),Os=o(),Ft=n("p"),Ft.textContent=Ho,_r=o(),L=n("div"),p(Ee.$$.fragment),Ks=o(),St=n("p"),St.textContent=No,eo=o(),le=n("div"),p(He.$$.fragment),to=o(),Rt=n("p"),Rt.textContent=Bo,vr=o(),p(Ne.$$.fragment),xr=o(),Be=n("p"),Be.innerHTML=Do,$r=o(),De=n("p"),De.textContent=Fo,br=o(),Fe=n("p"),Fe.textContent=So,yr=o(),Se=n("ul"),Se.innerHTML=Ro,Mr=o(),Re=n("p"),Re.innerHTML=Go,wr=o(),N=n("div"),p(Ge.$$.fragment),ro=o(),Gt=n("p"),Gt.innerHTML=Wo,Tr=o(),p(We.$$.fragment),Cr=o(),Qe=n("p"),Qe.innerHTML=Qo,Pr=o(),Ye=n("p"),Ye.innerHTML=Yo,jr=o(),Ae=n("p"),Ae.textContent=Ao,Ir=o(),Oe=n("ul"),Oe.innerHTML=Oo,kr=o(),Ke=n("p"),Ke.textContent=Ko,Xr=o(),et=n("p"),et.innerHTML=ea,Jr=o(),p(tt.$$.fragment),Lr=o(),rt=n("p"),rt.innerHTML=ta,Ur=o(),st=n("p"),st.textContent=ra,Zr=o(),p(ot.$$.fragment),qr=o(),at=n("p"),at.textContent=sa,Vr=o(),nt=n("ul"),nt.innerHTML=oa,zr=o(),lt=n("p"),lt.innerHTML=aa,Er=o(),k=n("div"),p(it.$$.fragment),so=o(),Wt=n("p"),Wt.textContent=na,oo=o(),ie=n("div"),p(dt.$$.fragment),ao=o(),Qt=n("p"),Qt.textContent=la,no=o(),E=n("div"),p(ct.$$.fragment),lo=o(),Yt=n("p"),Yt.innerHTML=ia,io=o(),p(de.$$.fragment),co=o(),ce=n("div"),p(mt.$$.fragment),mo=o(),At=n("p"),At.textContent=da,Hr=o(),pt=n("p"),pt.innerHTML=ca,Nr=o(),U=n("div"),p(ft.$$.fragment),po=o(),Ot=n("p"),Ot.textContent=ma,fo=o(),p(me.$$.fragment),Br=o(),ut=n("p"),ut.innerHTML=pa,Dr=o(),p(ht.$$.fragment),Fr=o(),gt=n("p"),gt.textContent=fa,Sr=o(),p(_t.$$.fragment),Rr=o(),vt=n("p"),vt.innerHTML=ua,Gr=o(),p(xt.$$.fragment),Wr=o(),$t=n("p"),$t.innerHTML=ha,Qr=o(),p(bt.$$.fragment),Yr=o(),nr=n("p"),this.h()},l(e){const r=$a("svelte-u9bgzb",document.head);c=l(r,"META",{name:!0,content:!0}),r.forEach(t),T=a(e),v=l(e,"P",{}),$(v).forEach(t),x=a(e),f(C.$$.fragment,e),m=a(e),j=l(e,"P",{"data-svelte-h":!0}),d(j)!=="svelte-4gs895"&&(j.textContent=go),ir=a(e),fe=l(e,"UL",{"data-svelte-h":!0}),d(fe)!=="svelte-1h23xz2"&&(fe.innerHTML=_o),dr=a(e),f(ue.$$.fragment,e),cr=a(e),he=l(e,"P",{"data-svelte-h":!0}),d(he)!=="svelte-hbbv64"&&(he.textContent=vo),mr=a(e),ge=l(e,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-t565jj"&&(ge.textContent=xo),pr=a(e),y=l(e,"DIV",{class:!0});var w=$(y);f(_e.$$.fragment,w),ps=a(w),Tt=l(w,"P",{"data-svelte-h":!0}),d(Tt)!=="svelte-1s4wckx"&&(Tt.textContent=$o),fs=a(w),F=l(w,"DIV",{class:!0});var yt=$(F);f(ve.$$.fragment,yt),us=a(yt),Ct=l(yt,"P",{"data-svelte-h":!0}),d(Ct)!=="svelte-10dqwuv"&&(Ct.innerHTML=bo),yt.forEach(t),hs=a(w),S=l(w,"DIV",{class:!0});var Mt=$(S);f(xe.$$.fragment,Mt),gs=a(Mt),Pt=l(Mt,"P",{"data-svelte-h":!0}),d(Pt)!=="svelte-1i2d3vx"&&(Pt.innerHTML=yo),Mt.forEach(t),_s=a(w),Z=l(w,"DIV",{class:!0});var B=$(Z);f($e.$$.fragment,B),vs=a(B),jt=l(B,"P",{"data-svelte-h":!0}),d(jt)!=="svelte-1cj8dcb"&&(jt.textContent=Mo),xs=a(B),f(R.$$.fragment,B),B.forEach(t),$s=a(w),G=l(w,"DIV",{class:!0});var wt=$(G);f(be.$$.fragment,wt),bs=a(wt),It=l(wt,"P",{"data-svelte-h":!0}),d(It)!=="svelte-hsvutq"&&(It.innerHTML=wo),wt.forEach(t),ys=a(w),q=l(w,"DIV",{class:!0});var D=$(q);f(ye.$$.fragment,D),Ms=a(D),kt=l(D,"P",{"data-svelte-h":!0}),d(kt)!=="svelte-1cwsjho"&&(kt.textContent=To),ws=a(D),f(W.$$.fragment,D),D.forEach(t),Ts=a(w),V=l(w,"DIV",{class:!0});var Kt=$(V);f(Me.$$.fragment,Kt),Cs=a(Kt),Xt=l(Kt,"P",{"data-svelte-h":!0}),d(Xt)!=="svelte-hhsvto"&&(Xt.innerHTML=Co),Ps=a(Kt),f(Q.$$.fragment,Kt),Kt.forEach(t),js=a(w),z=l(w,"DIV",{class:!0});var er=$(z);f(we.$$.fragment,er),Is=a(er),Jt=l(er,"P",{"data-svelte-h":!0}),d(Jt)!=="svelte-z5jxy5"&&(Jt.innerHTML=Po),ks=a(er),f(Y.$$.fragment,er),er.forEach(t),Xs=a(w),A=l(w,"DIV",{class:!0});var Or=$(A);f(Te.$$.fragment,Or),Js=a(Or),Lt=l(Or,"P",{"data-svelte-h":!0}),d(Lt)!=="svelte-1ww3wqq"&&(Lt.textContent=jo),Or.forEach(t),Ls=a(w),O=l(w,"DIV",{class:!0});var Kr=$(O);f(Ce.$$.fragment,Kr),Us=a(Kr),Ut=l(Kr,"P",{"data-svelte-h":!0}),d(Ut)!=="svelte-1g70y32"&&(Ut.textContent=Io),Kr.forEach(t),Zs=a(w),K=l(w,"DIV",{class:!0});var es=$(K);f(Pe.$$.fragment,es),qs=a(es),Zt=l(es,"P",{"data-svelte-h":!0}),d(Zt)!=="svelte-5ayq1f"&&(Zt.textContent=ko),es.forEach(t),w.forEach(t),fr=a(e),f(je.$$.fragment,e),ur=a(e),Ie=l(e,"P",{"data-svelte-h":!0}),d(Ie)!=="svelte-1q47k75"&&(Ie.innerHTML=Xo),hr=a(e),P=l(e,"DIV",{class:!0});var I=$(P);f(ke.$$.fragment,I),Vs=a(I),qt=l(I,"P",{"data-svelte-h":!0}),d(qt)!=="svelte-1bsw04k"&&(qt.textContent=Jo),zs=a(I),ee=l(I,"DIV",{class:!0});var ts=$(ee);f(Xe.$$.fragment,ts),Es=a(ts),Vt=l(ts,"P",{"data-svelte-h":!0}),d(Vt)!=="svelte-1bmr8v2"&&(Vt.innerHTML=Lo),ts.forEach(t),Hs=a(I),te=l(I,"DIV",{class:!0});var rs=$(te);f(Je.$$.fragment,rs),Ns=a(rs),zt=l(rs,"P",{"data-svelte-h":!0}),d(zt)!=="svelte-pplryq"&&(zt.textContent=Uo),rs.forEach(t),Bs=a(I),re=l(I,"DIV",{class:!0});var ss=$(re);f(Le.$$.fragment,ss),Ds=a(ss),Et=l(ss,"P",{"data-svelte-h":!0}),d(Et)!=="svelte-3oqyjr"&&(Et.textContent=Zo),ss.forEach(t),Fs=a(I),se=l(I,"DIV",{class:!0});var os=$(se);f(Ue.$$.fragment,os),Ss=a(os),Ht=l(os,"P",{"data-svelte-h":!0}),d(Ht)!=="svelte-1rbodf5"&&(Ht.innerHTML=qo),os.forEach(t),Rs=a(I),oe=l(I,"DIV",{class:!0});var as=$(oe);f(Ze.$$.fragment,as),Gs=a(as),Nt=l(as,"P",{"data-svelte-h":!0}),d(Nt)!=="svelte-1s67zn3"&&(Nt.innerHTML=Vo),as.forEach(t),Ws=a(I),ae=l(I,"DIV",{class:!0});var ns=$(ae);f(qe.$$.fragment,ns),Qs=a(ns),Bt=l(ns,"P",{"data-svelte-h":!0}),d(Bt)!=="svelte-1jevh15"&&(Bt.textContent=zo),ns.forEach(t),I.forEach(t),gr=a(e),J=l(e,"DIV",{class:!0});var tr=$(J);f(Ve.$$.fragment,tr),Ys=a(tr),Dt=l(tr,"P",{"data-svelte-h":!0}),d(Dt)!=="svelte-vkt0pi"&&(Dt.textContent=Eo),As=a(tr),ne=l(tr,"DIV",{class:!0});var ls=$(ne);f(ze.$$.fragment,ls),Os=a(ls),Ft=l(ls,"P",{"data-svelte-h":!0}),d(Ft)!=="svelte-5ayq1f"&&(Ft.textContent=Ho),ls.forEach(t),tr.forEach(t),_r=a(e),L=l(e,"DIV",{class:!0});var rr=$(L);f(Ee.$$.fragment,rr),Ks=a(rr),St=l(rr,"P",{"data-svelte-h":!0}),d(St)!=="svelte-168wf64"&&(St.textContent=No),eo=a(rr),le=l(rr,"DIV",{class:!0});var is=$(le);f(He.$$.fragment,is),to=a(is),Rt=l(is,"P",{"data-svelte-h":!0}),d(Rt)!=="svelte-5ayq1f"&&(Rt.textContent=Bo),is.forEach(t),rr.forEach(t),vr=a(e),f(Ne.$$.fragment,e),xr=a(e),Be=l(e,"P",{"data-svelte-h":!0}),d(Be)!=="svelte-dz9ydi"&&(Be.innerHTML=Do),$r=a(e),De=l(e,"P",{"data-svelte-h":!0}),d(De)!=="svelte-1lukeag"&&(De.textContent=Fo),br=a(e),Fe=l(e,"P",{"data-svelte-h":!0}),d(Fe)!=="svelte-w2nqkz"&&(Fe.textContent=So),yr=a(e),Se=l(e,"UL",{"data-svelte-h":!0}),d(Se)!=="svelte-my8qym"&&(Se.innerHTML=Ro),Mr=a(e),Re=l(e,"P",{"data-svelte-h":!0}),d(Re)!=="svelte-1pvgfj9"&&(Re.innerHTML=Go),wr=a(e),N=l(e,"DIV",{class:!0});var ds=$(N);f(Ge.$$.fragment,ds),ro=a(ds),Gt=l(ds,"P",{"data-svelte-h":!0}),d(Gt)!=="svelte-5lvrve"&&(Gt.innerHTML=Wo),ds.forEach(t),Tr=a(e),f(We.$$.fragment,e),Cr=a(e),Qe=l(e,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-1cfncyx"&&(Qe.innerHTML=Qo),Pr=a(e),Ye=l(e,"P",{"data-svelte-h":!0}),d(Ye)!=="svelte-10048a6"&&(Ye.innerHTML=Yo),jr=a(e),Ae=l(e,"P",{"data-svelte-h":!0}),d(Ae)!=="svelte-1z0bn35"&&(Ae.textContent=Ao),Ir=a(e),Oe=l(e,"UL",{"data-svelte-h":!0}),d(Oe)!=="svelte-1e2xq99"&&(Oe.innerHTML=Oo),kr=a(e),Ke=l(e,"P",{"data-svelte-h":!0}),d(Ke)!=="svelte-1d3nf11"&&(Ke.textContent=Ko),Xr=a(e),et=l(e,"P",{"data-svelte-h":!0}),d(et)!=="svelte-7zvs7i"&&(et.innerHTML=ea),Jr=a(e),f(tt.$$.fragment,e),Lr=a(e),rt=l(e,"P",{"data-svelte-h":!0}),d(rt)!=="svelte-5cjvlv"&&(rt.innerHTML=ta),Ur=a(e),st=l(e,"P",{"data-svelte-h":!0}),d(st)!=="svelte-10uynke"&&(st.textContent=ra),Zr=a(e),f(ot.$$.fragment,e),qr=a(e),at=l(e,"P",{"data-svelte-h":!0}),d(at)!=="svelte-w2nqkz"&&(at.textContent=sa),Vr=a(e),nt=l(e,"UL",{"data-svelte-h":!0}),d(nt)!=="svelte-1qiv3qf"&&(nt.innerHTML=oa),zr=a(e),lt=l(e,"P",{"data-svelte-h":!0}),d(lt)!=="svelte-ii491f"&&(lt.innerHTML=aa),Er=a(e),k=l(e,"DIV",{class:!0});var H=$(k);f(it.$$.fragment,H),so=a(H),Wt=l(H,"P",{"data-svelte-h":!0}),d(Wt)!=="svelte-173gxyd"&&(Wt.textContent=na),oo=a(H),ie=l(H,"DIV",{class:!0});var cs=$(ie);f(dt.$$.fragment,cs),ao=a(cs),Qt=l(cs,"P",{"data-svelte-h":!0}),d(Qt)!=="svelte-wmaktk"&&(Qt.textContent=la),cs.forEach(t),no=a(H),E=l(H,"DIV",{class:!0});var sr=$(E);f(ct.$$.fragment,sr),lo=a(sr),Yt=l(sr,"P",{"data-svelte-h":!0}),d(Yt)!=="svelte-11nqnea"&&(Yt.innerHTML=ia),io=a(sr),f(de.$$.fragment,sr),sr.forEach(t),co=a(H),ce=l(H,"DIV",{class:!0});var ms=$(ce);f(mt.$$.fragment,ms),mo=a(ms),At=l(ms,"P",{"data-svelte-h":!0}),d(At)!=="svelte-d5zv1x"&&(At.textContent=da),ms.forEach(t),H.forEach(t),Hr=a(e),pt=l(e,"P",{"data-svelte-h":!0}),d(pt)!=="svelte-18mz77q"&&(pt.innerHTML=ca),Nr=a(e),U=l(e,"DIV",{class:!0});var or=$(U);f(ft.$$.fragment,or),po=a(or),Ot=l(or,"P",{"data-svelte-h":!0}),d(Ot)!=="svelte-169nh0g"&&(Ot.textContent=ma),fo=a(or),f(me.$$.fragment,or),or.forEach(t),Br=a(e),ut=l(e,"P",{"data-svelte-h":!0}),d(ut)!=="svelte-1esudax"&&(ut.innerHTML=pa),Dr=a(e),f(ht.$$.fragment,e),Fr=a(e),gt=l(e,"P",{"data-svelte-h":!0}),d(gt)!=="svelte-3glna9"&&(gt.textContent=fa),Sr=a(e),f(_t.$$.fragment,e),Rr=a(e),vt=l(e,"P",{"data-svelte-h":!0}),d(vt)!=="svelte-jzuhjq"&&(vt.innerHTML=ua),Gr=a(e),f(xt.$$.fragment,e),Wr=a(e),$t=l(e,"P",{"data-svelte-h":!0}),d($t)!=="svelte-fac3c8"&&($t.innerHTML=ha),Qr=a(e),f(bt.$$.fragment,e),Yr=a(e),nr=l(e,"P",{}),$(nr).forEach(t),this.h()},h(){b(c,"name","hf:doc:metadata"),b(c,"content",Ia),b(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,r){s(document.head,c),i(e,T,r),i(e,v,r),i(e,x,r),u(C,e,r),i(e,m,r),i(e,j,r),i(e,ir,r),i(e,fe,r),i(e,dr,r),u(ue,e,r),i(e,cr,r),i(e,he,r),i(e,mr,r),i(e,ge,r),i(e,pr,r),i(e,y,r),u(_e,y,null),s(y,ps),s(y,Tt),s(y,fs),s(y,F),u(ve,F,null),s(F,us),s(F,Ct),s(y,hs),s(y,S),u(xe,S,null),s(S,gs),s(S,Pt),s(y,_s),s(y,Z),u($e,Z,null),s(Z,vs),s(Z,jt),s(Z,xs),u(R,Z,null),s(y,$s),s(y,G),u(be,G,null),s(G,bs),s(G,It),s(y,ys),s(y,q),u(ye,q,null),s(q,Ms),s(q,kt),s(q,ws),u(W,q,null),s(y,Ts),s(y,V),u(Me,V,null),s(V,Cs),s(V,Xt),s(V,Ps),u(Q,V,null),s(y,js),s(y,z),u(we,z,null),s(z,Is),s(z,Jt),s(z,ks),u(Y,z,null),s(y,Xs),s(y,A),u(Te,A,null),s(A,Js),s(A,Lt),s(y,Ls),s(y,O),u(Ce,O,null),s(O,Us),s(O,Ut),s(y,Zs),s(y,K),u(Pe,K,null),s(K,qs),s(K,Zt),i(e,fr,r),u(je,e,r),i(e,ur,r),i(e,Ie,r),i(e,hr,r),i(e,P,r),u(ke,P,null),s(P,Vs),s(P,qt),s(P,zs),s(P,ee),u(Xe,ee,null),s(ee,Es),s(ee,Vt),s(P,Hs),s(P,te),u(Je,te,null),s(te,Ns),s(te,zt),s(P,Bs),s(P,re),u(Le,re,null),s(re,Ds),s(re,Et),s(P,Fs),s(P,se),u(Ue,se,null),s(se,Ss),s(se,Ht),s(P,Rs),s(P,oe),u(Ze,oe,null),s(oe,Gs),s(oe,Nt),s(P,Ws),s(P,ae),u(qe,ae,null),s(ae,Qs),s(ae,Bt),i(e,gr,r),i(e,J,r),u(Ve,J,null),s(J,Ys),s(J,Dt),s(J,As),s(J,ne),u(ze,ne,null),s(ne,Os),s(ne,Ft),i(e,_r,r),i(e,L,r),u(Ee,L,null),s(L,Ks),s(L,St),s(L,eo),s(L,le),u(He,le,null),s(le,to),s(le,Rt),i(e,vr,r),u(Ne,e,r),i(e,xr,r),i(e,Be,r),i(e,$r,r),i(e,De,r),i(e,br,r),i(e,Fe,r),i(e,yr,r),i(e,Se,r),i(e,Mr,r),i(e,Re,r),i(e,wr,r),i(e,N,r),u(Ge,N,null),s(N,ro),s(N,Gt),i(e,Tr,r),u(We,e,r),i(e,Cr,r),i(e,Qe,r),i(e,Pr,r),i(e,Ye,r),i(e,jr,r),i(e,Ae,r),i(e,Ir,r),i(e,Oe,r),i(e,kr,r),i(e,Ke,r),i(e,Xr,r),i(e,et,r),i(e,Jr,r),u(tt,e,r),i(e,Lr,r),i(e,rt,r),i(e,Ur,r),i(e,st,r),i(e,Zr,r),u(ot,e,r),i(e,qr,r),i(e,at,r),i(e,Vr,r),i(e,nt,r),i(e,zr,r),i(e,lt,r),i(e,Er,r),i(e,k,r),u(it,k,null),s(k,so),s(k,Wt),s(k,oo),s(k,ie),u(dt,ie,null),s(ie,ao),s(ie,Qt),s(k,no),s(k,E),u(ct,E,null),s(E,lo),s(E,Yt),s(E,io),u(de,E,null),s(k,co),s(k,ce),u(mt,ce,null),s(ce,mo),s(ce,At),i(e,Hr,r),i(e,pt,r),i(e,Nr,r),i(e,U,r),u(ft,U,null),s(U,po),s(U,Ot),s(U,fo),u(me,U,null),i(e,Br,r),i(e,ut,r),i(e,Dr,r),u(ht,e,r),i(e,Fr,r),i(e,gt,r),i(e,Sr,r),u(_t,e,r),i(e,Rr,r),i(e,vt,r),i(e,Gr,r),u(xt,e,r),i(e,Wr,r),i(e,$t,r),i(e,Qr,r),u(bt,e,r),i(e,Yr,r),i(e,nr,r),Ar=!0},p(e,[r]){const w={};r&2&&(w.$$scope={dirty:r,ctx:e}),R.$set(w);const yt={};r&2&&(yt.$$scope={dirty:r,ctx:e}),W.$set(yt);const Mt={};r&2&&(Mt.$$scope={dirty:r,ctx:e}),Q.$set(Mt);const B={};r&2&&(B.$$scope={dirty:r,ctx:e}),Y.$set(B);const wt={};r&2&&(wt.$$scope={dirty:r,ctx:e}),de.$set(wt);const D={};r&2&&(D.$$scope={dirty:r,ctx:e}),me.$set(D)},i(e){Ar||(h(C.$$.fragment,e),h(ue.$$.fragment,e),h(_e.$$.fragment,e),h(ve.$$.fragment,e),h(xe.$$.fragment,e),h($e.$$.fragment,e),h(R.$$.fragment,e),h(be.$$.fragment,e),h(ye.$$.fragment,e),h(W.$$.fragment,e),h(Me.$$.fragment,e),h(Q.$$.fragment,e),h(we.$$.fragment,e),h(Y.$$.fragment,e),h(Te.$$.fragment,e),h(Ce.$$.fragment,e),h(Pe.$$.fragment,e),h(je.$$.fragment,e),h(ke.$$.fragment,e),h(Xe.$$.fragment,e),h(Je.$$.fragment,e),h(Le.$$.fragment,e),h(Ue.$$.fragment,e),h(Ze.$$.fragment,e),h(qe.$$.fragment,e),h(Ve.$$.fragment,e),h(ze.$$.fragment,e),h(Ee.$$.fragment,e),h(He.$$.fragment,e),h(Ne.$$.fragment,e),h(Ge.$$.fragment,e),h(We.$$.fragment,e),h(tt.$$.fragment,e),h(ot.$$.fragment,e),h(it.$$.fragment,e),h(dt.$$.fragment,e),h(ct.$$.fragment,e),h(de.$$.fragment,e),h(mt.$$.fragment,e),h(ft.$$.fragment,e),h(me.$$.fragment,e),h(ht.$$.fragment,e),h(_t.$$.fragment,e),h(xt.$$.fragment,e),h(bt.$$.fragment,e),Ar=!0)},o(e){g(C.$$.fragment,e),g(ue.$$.fragment,e),g(_e.$$.fragment,e),g(ve.$$.fragment,e),g(xe.$$.fragment,e),g($e.$$.fragment,e),g(R.$$.fragment,e),g(be.$$.fragment,e),g(ye.$$.fragment,e),g(W.$$.fragment,e),g(Me.$$.fragment,e),g(Q.$$.fragment,e),g(we.$$.fragment,e),g(Y.$$.fragment,e),g(Te.$$.fragment,e),g(Ce.$$.fragment,e),g(Pe.$$.fragment,e),g(je.$$.fragment,e),g(ke.$$.fragment,e),g(Xe.$$.fragment,e),g(Je.$$.fragment,e),g(Le.$$.fragment,e),g(Ue.$$.fragment,e),g(Ze.$$.fragment,e),g(qe.$$.fragment,e),g(Ve.$$.fragment,e),g(ze.$$.fragment,e),g(Ee.$$.fragment,e),g(He.$$.fragment,e),g(Ne.$$.fragment,e),g(Ge.$$.fragment,e),g(We.$$.fragment,e),g(tt.$$.fragment,e),g(ot.$$.fragment,e),g(it.$$.fragment,e),g(dt.$$.fragment,e),g(ct.$$.fragment,e),g(de.$$.fragment,e),g(mt.$$.fragment,e),g(ft.$$.fragment,e),g(me.$$.fragment,e),g(ht.$$.fragment,e),g(_t.$$.fragment,e),g(xt.$$.fragment,e),g(bt.$$.fragment,e),Ar=!1},d(e){e&&(t(T),t(v),t(x),t(m),t(j),t(ir),t(fe),t(dr),t(cr),t(he),t(mr),t(ge),t(pr),t(y),t(fr),t(ur),t(Ie),t(hr),t(P),t(gr),t(J),t(_r),t(L),t(vr),t(xr),t(Be),t($r),t(De),t(br),t(Fe),t(yr),t(Se),t(Mr),t(Re),t(wr),t(N),t(Tr),t(Cr),t(Qe),t(Pr),t(Ye),t(jr),t(Ae),t(Ir),t(Oe),t(kr),t(Ke),t(Xr),t(et),t(Jr),t(Lr),t(rt),t(Ur),t(st),t(Zr),t(qr),t(at),t(Vr),t(nt),t(zr),t(lt),t(Er),t(k),t(Hr),t(pt),t(Nr),t(U),t(Br),t(ut),t(Dr),t(Fr),t(gt),t(Sr),t(Rr),t(vt),t(Gr),t(Wr),t($t),t(Qr),t(Yr),t(nr)),t(c),_(C,e),_(ue,e),_(_e),_(ve),_(xe),_($e),_(R),_(be),_(ye),_(W),_(Me),_(Q),_(we),_(Y),_(Te),_(Ce),_(Pe),_(je,e),_(ke),_(Xe),_(Je),_(Le),_(Ue),_(Ze),_(qe),_(Ve),_(ze),_(Ee),_(He),_(Ne,e),_(Ge),_(We,e),_(tt,e),_(ot,e),_(it),_(dt),_(ct),_(de),_(mt),_(ft),_(me),_(ht,e),_(_t,e),_(xt,e),_(bt,e)}}}const Ia='{"title":"Processors","local":"processors","sections":[{"title":"Multi-modal processors","local":"transformers.ProcessorMixin","sections":[],"depth":2},{"title":"Deprecated processors","local":"transformers.DataProcessor","sections":[],"depth":2},{"title":"GLUE","local":"transformers.glue_convert_examples_to_features","sections":[],"depth":2},{"title":"XNLI","local":"xnli","sections":[],"depth":2},{"title":"SQuAD","local":"squad","sections":[{"title":"Processors","local":"transformers.data.processors.squad.SquadProcessor","sections":[],"depth":3},{"title":"Example usage","local":"example-usage","sections":[],"depth":3}],"depth":2}],"depth":1}';function ka(X){return _a(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class za extends va{constructor(c){super(),xa(this,c,ka,ja,ga,{})}}export{za as component};
