import{s as Pn,n as Kn,o as On}from"../chunks/scheduler.7bc62968.js";import{S as sp,i as tp,g as h,s as a,r as p,A as lp,h as j,f as l,c as n,j as Ln,u as i,x as J,k as Dn,y as ep,a as e,v as o,d as M,t as r,w as c}from"../chunks/index.66556066.js";import{C as u}from"../chunks/CodeBlock.5372f996.js";import{H as m,E as ap}from"../chunks/index.b8c37ceb.js";function np(Sa){let y,ll,sl,el,T,al,w,Va=`A Typescript powered wrapper for the HF Inference API (serverless), Inference Endpoints (dedicated), and all supported Inference Providers.
It works with <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Inference API (serverless)</a> and <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inference Endpoints (dedicated)</a>, and even with all supported third-party Inference Providers.`,nl,f,Ra='You can also try out a live <a href="https://observablehq.com/@huggingface/hello-huggingface-js-inference" rel="nofollow">interactive notebook</a>, see some demos on <a href="https://huggingface.co/huggingfacejs" rel="nofollow">hf.co/huggingfacejs</a>, or watch a <a href="https://scrimba.com/scrim/cod8248f5adfd6e129582c523" rel="nofollow">Scrimba tutorial that explains how Inference Endpoints works</a>.',pl,g,il,d,ol,U,Ml,I,rl,b,cl,$,hl,C,jl,B,Jl,x,qa='❗<strong>Important note:</strong> Using an access token is optional to get started, however you will be rate limited eventually. Join <a href="https://huggingface.co/join" rel="nofollow">Hugging Face</a> and then visit <a href="https://huggingface.co/settings/tokens" rel="nofollow">access tokens</a> to generate your access token for <strong>free</strong>.',ml,k,za="Your access token should be kept private. If you need to protect it in front-end applications, we suggest setting up a proxy server that stores the access token.",ul,Z,yl,G,Fa="You can send inference requests to third-party providers with the inference client.",Tl,Q,Ha="Currently, we support the following providers:",wl,N,_a='<li><a href="https://fal.ai" rel="nofollow">Fal.ai</a></li> <li><a href="https://fireworks.ai" rel="nofollow">Fireworks AI</a></li> <li><a href="https://hyperbolic.xyz" rel="nofollow">Hyperbolic</a></li> <li><a href="https://studio.nebius.ai" rel="nofollow">Nebius</a></li> <li><a href="https://novita.ai/?utm_source=github_huggingface&amp;utm_medium=github_readme&amp;utm_campaign=link" rel="nofollow">Novita</a></li> <li><a href="https://nscale.com" rel="nofollow">Nscale</a></li> <li><a href="https://replicate.com" rel="nofollow">Replicate</a></li> <li><a href="https://sambanova.ai" rel="nofollow">Sambanova</a></li> <li><a href="https://together.xyz" rel="nofollow">Together</a></li> <li><a href="https://blackforestlabs.ai" rel="nofollow">Blackforestlabs</a></li> <li><a href="https://cohere.com" rel="nofollow">Cohere</a></li> <li><a href="https://cerebras.ai/" rel="nofollow">Cerebras</a></li>',fl,E,La="To send requests to a third-party provider, you have to pass the <code>provider</code> parameter to the inference function. Make sure your request is authenticated with an access token.",gl,v,dl,W,Da=`When authenticated with a Hugging Face access token, the request is routed through <a href="https://huggingface.co." rel="nofollow">https://huggingface.co.</a>
When authenticated with a third-party provider key, the request is made directly against that provider’s inference API.`,Ul,A,Pa="Only a subset of models are supported when requesting third-party providers. You can check the list of supported models per pipeline tasks here:",Il,Y,Ka='<li><a href="https://huggingface.co/api/partners/fal-ai/models" rel="nofollow">Fal.ai supported models</a></li> <li><a href="https://huggingface.co/api/partners/fireworks-ai/models" rel="nofollow">Fireworks AI supported models</a></li> <li><a href="https://huggingface.co/api/partners/hyperbolic/models" rel="nofollow">Hyperbolic supported models</a></li> <li><a href="https://huggingface.co/api/partners/nebius/models" rel="nofollow">Nebius supported models</a></li> <li><a href="https://huggingface.co/api/partners/nscale/models" rel="nofollow">Nscale supported models</a></li> <li><a href="https://huggingface.co/api/partners/replicate/models" rel="nofollow">Replicate supported models</a></li> <li><a href="https://huggingface.co/api/partners/sambanova/models" rel="nofollow">Sambanova supported models</a></li> <li><a href="https://huggingface.co/api/partners/together/models" rel="nofollow">Together supported models</a></li> <li><a href="https://huggingface.co/api/partners/cohere/models" rel="nofollow">Cohere supported models</a></li> <li><a href="https://huggingface.co/api/partners/cerebras/models" rel="nofollow">Cerebras supported models</a></li> <li><a href="https://huggingface.co/models?inference=warm&amp;sort=trending" rel="nofollow">HF Inference API (serverless)</a></li>',bl,X,Oa=`❗<strong>Important note:</strong> To be compatible, the third-party API must adhere to the “standard” shape API we expect on HF model pages for each pipeline task type.
This is not an issue for LLMs as everyone converged on the OpenAI API anyways, but can be more tricky for other tasks like “text-to-image” or “automatic-speech-recognition” where there exists no standard API. Let us know if any help is needed or if we can make things easier for you!`,$l,S,sn='👋<strong>Want to add another provider?</strong> Get in touch if you’d like to add support for another Inference provider, and/or request it on <a href="https://huggingface.co/spaces/huggingface/HuggingDiscussions/discussions/49" rel="nofollow">https://huggingface.co/spaces/huggingface/HuggingDiscussions/discussions/49</a>',Cl,V,Bl,R,tn="You can import the functions you need directly from the module instead of using the <code>InferenceClient</code> class.",xl,q,kl,z,ln="This will enable tree-shaking by your bundler.",Zl,F,Gl,H,Ql,_,en="Generates text from an input prompt.",Nl,L,an='<a href="https://huggingface.co/spaces/huggingfacejs/streaming-text-generation" rel="nofollow">Demo</a>',El,D,vl,P,Wl,K,nn='Using the <code>chatCompletion</code> method, you can generate text with models compatible with the OpenAI Chat Completion API. All models served by <a href="https://huggingface.co/docs/text-generation-inference/" rel="nofollow">TGI</a> on Hugging Face support Messages API.',Al,O,pn='<a href="https://huggingface.co/spaces/huggingfacejs/streaming-chat-completion" rel="nofollow">Demo</a>',Yl,ss,Xl,ts,on="It’s also possible to call Mistral or OpenAI endpoints directly:",Sl,ls,Vl,es,Rl,as,Mn="Tries to fill in a hole with a missing word (token to be precise).",ql,ns,zl,ps,Fl,is,rn="Summarizes longer text into shorter text. Be careful, some models have a maximum length of input.",Hl,os,_l,Ms,Ll,rs,cn="Answers questions based on the context you provide.",Dl,cs,Pl,hs,Kl,js,Ol,Js,se,ms,hn="Often used for sentiment analysis, this method will assign labels to the given text along with a probability score of that label.",te,us,le,ys,ee,Ts,jn="Used for sentence parsing, either grammatical, or Named Entity Recognition (NER) to understand keywords contained within text.",ae,ws,ne,fs,pe,gs,Jn="Converts text from one language to another.",ie,ds,oe,Us,Me,Is,mn="Checks how well an input text fits into a set of labels you provide.",re,bs,ce,$s,he,Cs,un="This task corresponds to any chatbot-like structure. Models tend to have shorter max_length, so please check with caution when using a given model if you need long-range dependency or not.",je,Bs,Je,xs,me,ks,yn="Calculate the semantic similarity between one text and a list of other sentences.",ue,Zs,ye,Gs,Te,Qs,we,Ns,Tn="Transcribes speech from an audio file.",fe,Es,wn='<a href="https://huggingface.co/spaces/huggingfacejs/speech-recognition-vue" rel="nofollow">Demo</a>',ge,vs,de,Ws,Ue,As,fn="Assigns labels to the given audio along with a probability score of that label.",Ie,Ys,gn='<a href="https://huggingface.co/spaces/huggingfacejs/audio-classification-vue" rel="nofollow">Demo</a>',be,Xs,$e,Ss,Ce,Vs,dn="Generates natural-sounding speech from text input.",Be,Rs,Un='<a href="https://scrimba.com/scrim/co8da4d23b49b648f77f4848a?pl=pkVnrP7uP" rel="nofollow">Interactive tutorial</a>',xe,qs,ke,zs,Ze,Fs,In="Outputs one or multiple generated audios from an input audio, commonly used for speech enhancement and source separation.",Ge,Hs,Qe,_s,Ne,Ls,Ee,Ds,bn="Assigns labels to a given image along with a probability score of that label.",ve,Ps,$n='<a href="https://huggingface.co/spaces/huggingfacejs/image-classification-vue" rel="nofollow">Demo</a>',We,Ks,Ae,Os,Ye,st,Cn="Detects objects within an image and returns labels with corresponding bounding boxes and probability scores.",Xe,tt,Bn='<a href="https://huggingface.co/spaces/huggingfacejs/object-detection-vue" rel="nofollow">Demo</a>',Se,lt,Ve,et,Re,at,xn="Detects segments within an image and returns labels with corresponding bounding boxes and probability scores.",qe,nt,ze,pt,Fe,it,kn="Outputs text from a given image, commonly used for captioning or optical character recognition.",He,ot,_e,Mt,Le,rt,Zn="Creates an image from a text prompt.",De,ct,Gn='<a href="https://huggingface.co/spaces/huggingfacejs/image-to-text" rel="nofollow">Demo</a>',Pe,ht,Ke,jt,Oe,Jt,Qn="Image-to-image is the task of transforming a source image to match the characteristics of a target image or a target image domain.",sa,mt,Nn='<a href="https://scrimba.com/scrim/co4834bf9a91cc81cfab07969?pl=pkVnrP7uP" rel="nofollow">Interactive tutorial</a>',ta,ut,la,yt,ea,Tt,En="Checks how well an input image fits into a set of labels you provide.",aa,wt,na,ft,pa,gt,ia,dt,vn="This task reads some text and outputs raw float values, that are usually consumed as part of a semantic database/semantic search.",oa,Ut,Ma,It,ra,bt,Wn="Visual Question Answering is the task of answering open-ended questions based on an image. They output natural language responses to natural language questions.",ca,$t,An='<a href="https://huggingface.co/spaces/huggingfacejs/doc-vis-qa" rel="nofollow">Demo</a>',ha,Ct,ja,Bt,Ja,xt,Yn="Document question answering models take a (document, question) pair as input and return an answer in natural language.",ma,kt,Xn='<a href="https://huggingface.co/spaces/huggingfacejs/doc-vis-qa" rel="nofollow">Demo</a>',ua,Zt,ya,Gt,Ta,Qt,wa,Nt,Sn="Tabular regression is the task of predicting a numerical value given a set of attributes.",fa,Et,ga,vt,da,Wt,Vn="Tabular classification is the task of classifying a target category (a group) based on set of attributes.",Ua,At,Ia,Yt,Rn="You can use any Chat Completion API-compatible provider with the <code>chatCompletion</code> method.",ba,Xt,$a,St,Ca,Vt,qn='Learn more about using your own inference endpoints <a href="https://hf.co/docs/inference-endpoints/" rel="nofollow">here</a>',Ba,Rt,xa,qt,zn=`By default, all calls to the inference endpoint will wait until the model is
loaded. When <a href="https://huggingface.co/docs/inference-endpoints/en/autoscaling#scaling-to-0" rel="nofollow">scaling to
0</a>
is enabled on the endpoint, this can result in non-trivial waiting time. If
you’d rather disable this behavior and handle the endpoint’s returned 500 HTTP
errors yourself, you can do so like so:`,ka,zt,Za,Ft,Ga,Ht,Qa,_t,Na,Lt,Fn='We have an informative documentation project called <a href="https://huggingface.co/tasks" rel="nofollow">Tasks</a> to list available models for each task and explain how each task works in detail.',Ea,Dt,Hn="It also contains demos, example outputs, and other resources should you want to dig deeper into the ML side of things.",va,Pt,Wa,Kt,_n="<li><code>@huggingface/tasks</code> : Typings only</li>",Aa,Ot,Ya,tl,Xa;return T=new m({props:{title:"🤗 Hugging Face Inference",local:"-hugging-face-inference",headingTag:"h1"}}),g=new m({props:{title:"Getting Started",local:"getting-started",headingTag:"h2"}}),d=new m({props:{title:"Install",local:"install",headingTag:"h3"}}),U=new m({props:{title:"Node",local:"node",headingTag:"h4"}}),I=new u({props:{code:"bnBtJTIwaW5zdGFsbCUyMCU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNlJTBBJTBBcG5wbSUyMGFkZCUyMCU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNlJTBBJTBBeWFybiUyMGFkZCUyMCU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNl",highlighted:`npm install @huggingface/inference

pnpm add @huggingface/inference

yarn add @huggingface/inference`,wrap:!1}}),b=new m({props:{title:"Deno",local:"deno",headingTag:"h4"}}),$=new u({props:{code:"JTJGJTJGJTIwZXNtLnNoJTBBaW1wb3J0JTIwJTdCJTIwSW5mZXJlbmNlQ2xpZW50JTIwJTdEJTIwZnJvbSUyMCUyMmh0dHBzJTNBJTJGJTJGZXNtLnNoJTJGJTQwaHVnZ2luZ2ZhY2UlMkZpbmZlcmVuY2UlMjIlMEElMkYlMkYlMjBvciUyMG5wbSUzQSUwQWltcG9ydCUyMCU3QiUyMEluZmVyZW5jZUNsaWVudCUyMCU3RCUyMGZyb20lMjAlMjJucG0lM0ElNDBodWdnaW5nZmFjZSUyRmluZmVyZW5jZSUyMg==",highlighted:`<span class="hljs-comment">// esm.sh</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">InferenceClient</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://esm.sh/@huggingface/inference&quot;</span>
<span class="hljs-comment">// or npm:</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">InferenceClient</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;npm:@huggingface/inference&quot;</span>`,wrap:!1}}),C=new m({props:{title:"Initialize",local:"initialize",headingTag:"h3"}}),B=new u({props:{code:"aW1wb3J0JTIwJTdCJTIwSW5mZXJlbmNlQ2xpZW50JTIwJTdEJTIwZnJvbSUyMCclNDBodWdnaW5nZmFjZSUyRmluZmVyZW5jZSclMEElMEFjb25zdCUyMGhmJTIwJTNEJTIwbmV3JTIwSW5mZXJlbmNlQ2xpZW50KCd5b3VyJTIwYWNjZXNzJTIwdG9rZW4nKQ==",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">InferenceClient</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@huggingface/inference&#x27;</span>

<span class="hljs-keyword">const</span> hf = <span class="hljs-keyword">new</span> <span class="hljs-title class_">InferenceClient</span>(<span class="hljs-string">&#x27;your access token&#x27;</span>)`,wrap:!1}}),Z=new m({props:{title:"All supported inference providers",local:"all-supported-inference-providers",headingTag:"h3"}}),v=new u({props:{code:"Y29uc3QlMjBhY2Nlc3NUb2tlbiUyMCUzRCUyMCUyMmhmXy4uLiUyMiUzQiUyMCUyRiUyRiUyMEVpdGhlciUyMGElMjBIRiUyMGFjY2VzcyUyMHRva2VuJTJDJTIwb3IlMjBhbiUyMEFQSSUyMGtleSUyMGZyb20lMjB0aGUlMjB0aGlyZC1wYXJ0eSUyMHByb3ZpZGVyJTIwKFJlcGxpY2F0ZSUyMGluJTIwdGhpcyUyMGV4YW1wbGUpJTBBJTBBY29uc3QlMjBjbGllbnQlMjAlM0QlMjBuZXclMjBJbmZlcmVuY2VDbGllbnQoYWNjZXNzVG9rZW4pJTNCJTBBYXdhaXQlMjBjbGllbnQudGV4dFRvSW1hZ2UoJTdCJTBBJTIwJTIwcHJvdmlkZXIlM0ElMjAlMjJyZXBsaWNhdGUlMjIlMkMlMEElMjAlMjBtb2RlbCUzQSUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRmx1eC4xLWRldiUyMiUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCUyMkElMjBibGFjayUyMGZvcmVzdCUyMGNha2UlMjIlMEElN0Qp",highlighted:`<span class="hljs-keyword">const</span> accessToken = <span class="hljs-string">&quot;hf_...&quot;</span>; <span class="hljs-comment">// Either a HF access token, or an API key from the third-party provider (Replicate in this example)</span>

<span class="hljs-keyword">const</span> client = <span class="hljs-keyword">new</span> <span class="hljs-title class_">InferenceClient</span>(accessToken);
<span class="hljs-keyword">await</span> client.<span class="hljs-title function_">textToImage</span>({
  <span class="hljs-attr">provider</span>: <span class="hljs-string">&quot;replicate&quot;</span>,
  <span class="hljs-attr">model</span>:<span class="hljs-string">&quot;black-forest-labs/Flux.1-dev&quot;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&quot;A black forest cake&quot;</span>
})`,wrap:!1}}),V=new m({props:{title:"Tree-shaking",local:"tree-shaking",headingTag:"h3"}}),q=new u({props:{code:"aW1wb3J0JTIwJTdCJTIwdGV4dEdlbmVyYXRpb24lMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZpbmZlcmVuY2UlMjIlM0IlMEElMEFhd2FpdCUyMHRleHRHZW5lcmF0aW9uKCU3QiUwQSUyMCUyMGFjY2Vzc1Rva2VuJTNBJTIwJTIyaGZfLi4uJTIyJTJDJTBBJTIwJTIwbW9kZWwlM0ElMjAlMjJtb2RlbF9vcl9lbmRwb2ludCUyMiUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMC4uLiUyQyUwQSUyMCUyMHBhcmFtZXRlcnMlM0ElMjAuLi4lMEElN0Qp",highlighted:`<span class="hljs-keyword">import</span> { textGeneration } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/inference&quot;</span>;

<span class="hljs-keyword">await</span> <span class="hljs-title function_">textGeneration</span>({
  <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>,
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;model_or_endpoint&quot;</span>,
  <span class="hljs-attr">inputs</span>: ...,
  <span class="hljs-attr">parameters</span>: ...
})`,wrap:!1}}),F=new m({props:{title:"Natural Language Processing",local:"natural-language-processing",headingTag:"h2"}}),H=new m({props:{title:"Text Generation",local:"text-generation",headingTag:"h3"}}),D=new u({props:{code:"YXdhaXQlMjBoZi50ZXh0R2VuZXJhdGlvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdncHQyJyUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCdUaGUlMjBhbnN3ZXIlMjB0byUyMHRoZSUyMHVuaXZlcnNlJTIwaXMnJTBBJTdEKSUwQSUwQWZvciUyMGF3YWl0JTIwKGNvbnN0JTIwb3V0cHV0JTIwb2YlMjBoZi50ZXh0R2VuZXJhdGlvblN0cmVhbSglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCUyMmdvb2dsZSUyRmZsYW4tdDUteHhsJTIyJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJ3JlcGVhdCUyMCUyMm9uZSUyMHR3byUyMHRocmVlJTIwZm91ciUyMiclMkMlMEElMjAlMjBwYXJhbWV0ZXJzJTNBJTIwJTdCJTIwbWF4X25ld190b2tlbnMlM0ElMjAyNTAlMjAlN0QlMEElN0QpKSUyMCU3QiUwQSUyMCUyMGNvbnNvbGUubG9nKG91dHB1dC50b2tlbi50ZXh0JTJDJTIwb3V0cHV0LmdlbmVyYXRlZF90ZXh0KSUzQiUwQSU3RA==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">textGeneration</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;gpt2&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;The answer to the universe is&#x27;</span>
})

<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> output <span class="hljs-keyword">of</span> hf.<span class="hljs-title function_">textGenerationStream</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;google/flan-t5-xxl&quot;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;repeat &quot;one two three four&quot;&#x27;</span>,
  <span class="hljs-attr">parameters</span>: { <span class="hljs-attr">max_new_tokens</span>: <span class="hljs-number">250</span> }
})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(output.<span class="hljs-property">token</span>.<span class="hljs-property">text</span>, output.<span class="hljs-property">generated_text</span>);
}`,wrap:!1}}),P=new m({props:{title:"Text Generation (Chat Completion API Compatible)",local:"text-generation-chat-completion-api-compatible",headingTag:"h3"}}),ss=new u({props:{code:"JTJGJTJGJTIwTm9uLXN0cmVhbWluZyUyMEFQSSUwQWNvbnN0JTIwb3V0JTIwJTNEJTIwYXdhaXQlMjBoZi5jaGF0Q29tcGxldGlvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCUyMm1ldGEtbGxhbWElMkZMbGFtYS0zLjEtOEItSW5zdHJ1Y3QlMjIlMkMlMEElMjAlMjBtZXNzYWdlcyUzQSUyMCU1QiU3QiUyMHJvbGUlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwY29udGVudCUzQSUyMCUyMkhlbGxvJTJDJTIwbmljZSUyMHRvJTIwbWVldCUyMHlvdSElMjIlMjAlN0QlNUQlMkMlMEElMjAlMjBtYXhfdG9rZW5zJTNBJTIwNTEyJTJDJTBBJTIwJTIwdGVtcGVyYXR1cmUlM0ElMjAwLjElMkMlMEElN0QpJTNCJTBBJTBBJTJGJTJGJTIwU3RyZWFtaW5nJTIwQVBJJTBBbGV0JTIwb3V0JTIwJTNEJTIwJTIyJTIyJTNCJTBBZm9yJTIwYXdhaXQlMjAoY29uc3QlMjBjaHVuayUyMG9mJTIwaGYuY2hhdENvbXBsZXRpb25TdHJlYW0oJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAlMjJtZXRhLWxsYW1hJTJGTGxhbWEtMy4xLThCLUluc3RydWN0JTIyJTJDJTBBJTIwJTIwbWVzc2FnZXMlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjByb2xlJTNBJTIwJTIydXNlciUyMiUyQyUyMGNvbnRlbnQlM0ElMjAlMjJDYW4lMjB5b3UlMjBoZWxwJTIwbWUlMjBzb2x2ZSUyMGFuJTIwZXF1YXRpb24lM0YlMjIlMjAlN0QlMkMlMEElMjAlMjAlNUQlMkMlMEElMjAlMjBtYXhfdG9rZW5zJTNBJTIwNTEyJTJDJTBBJTIwJTIwdGVtcGVyYXR1cmUlM0ElMjAwLjElMkMlMEElN0QpKSUyMCU3QiUwQSUyMCUyMGlmJTIwKGNodW5rLmNob2ljZXMlMjAlMjYlMjYlMjBjaHVuay5jaG9pY2VzLmxlbmd0aCUyMCUzRSUyMDApJTIwJTdCJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTJCJTNEJTIwY2h1bmsuY2hvaWNlcyU1QjAlNUQuZGVsdGEuY29udGVudCUzQiUwQSUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-comment">// Non-streaming API</span>
<span class="hljs-keyword">const</span> out = <span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">chatCompletion</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;meta-llama/Llama-3.1-8B-Instruct&quot;</span>,
  <span class="hljs-attr">messages</span>: [{ <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Hello, nice to meet you!&quot;</span> }],
  <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">512</span>,
  <span class="hljs-attr">temperature</span>: <span class="hljs-number">0.1</span>,
});

<span class="hljs-comment">// Streaming API</span>
<span class="hljs-keyword">let</span> out = <span class="hljs-string">&quot;&quot;</span>;
<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> chunk <span class="hljs-keyword">of</span> hf.<span class="hljs-title function_">chatCompletionStream</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;meta-llama/Llama-3.1-8B-Instruct&quot;</span>,
  <span class="hljs-attr">messages</span>: [
    { <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Can you help me solve an equation?&quot;</span> },
  ],
  <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">512</span>,
  <span class="hljs-attr">temperature</span>: <span class="hljs-number">0.1</span>,
})) {
  <span class="hljs-keyword">if</span> (chunk.<span class="hljs-property">choices</span> &amp;&amp; chunk.<span class="hljs-property">choices</span>.<span class="hljs-property">length</span> &gt; <span class="hljs-number">0</span>) {
    out += chunk.<span class="hljs-property">choices</span>[<span class="hljs-number">0</span>].<span class="hljs-property">delta</span>.<span class="hljs-property">content</span>;
  }
}`,wrap:!1}}),ls=new u({props:{code:"Y29uc3QlMjBvcGVuYWklMjAlM0QlMjBuZXclMjBJbmZlcmVuY2VDbGllbnQoT1BFTkFJX1RPS0VOKS5lbmRwb2ludCglMjJodHRwcyUzQSUyRiUyRmFwaS5vcGVuYWkuY29tJTIyKSUzQiUwQSUwQWxldCUyMG91dCUyMCUzRCUyMCUyMiUyMiUzQiUwQWZvciUyMGF3YWl0JTIwKGNvbnN0JTIwY2h1bmslMjBvZiUyMG9wZW5haS5jaGF0Q29tcGxldGlvblN0cmVhbSglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCUyMmdwdC0zLjUtdHVyYm8lMjIlMkMlMEElMjAlMjBtZXNzYWdlcyUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUyMHJvbGUlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwY29udGVudCUzQSUyMCUyMkNvbXBsZXRlJTIwdGhlJTIwZXF1YXRpb24lMjAxJTJCMSUzRCUyMCUyQ2p1c3QlMjB0aGUlMjBhbnN3ZXIlMjIlMjAlN0QlMkMlMEElMjAlMjAlNUQlMkMlMEElMjAlMjBtYXhfdG9rZW5zJTNBJTIwNTAwJTJDJTBBJTIwJTIwdGVtcGVyYXR1cmUlM0ElMjAwLjElMkMlMEElMjAlMjBzZWVkJTNBJTIwMCUyQyUwQSU3RCkpJTIwJTdCJTBBJTIwJTIwaWYlMjAoY2h1bmsuY2hvaWNlcyUyMCUyNiUyNiUyMGNodW5rLmNob2ljZXMubGVuZ3RoJTIwJTNFJTIwMCklMjAlN0IlMEElMjAlMjAlMjAlMjBvdXQlMjAlMkIlM0QlMjBjaHVuay5jaG9pY2VzJTVCMCU1RC5kZWx0YS5jb250ZW50JTNCJTBBJTIwJTIwJTdEJTBBJTdEJTBBJTBBJTJGJTJGJTIwRm9yJTIwbWlzdHJhbCUyMEFJJTNBJTBBJTJGJTJGJTIwZW5kcG9pbnRVcmwlM0ElMjAlMjJodHRwcyUzQSUyRiUyRmFwaS5taXN0cmFsLmFpJTIyJTBBJTJGJTJGJTIwbW9kZWwlM0ElMjAlMjJtaXN0cmFsLXRpbnklMjI=",highlighted:`<span class="hljs-keyword">const</span> openai = <span class="hljs-keyword">new</span> <span class="hljs-title class_">InferenceClient</span>(<span class="hljs-variable constant_">OPENAI_TOKEN</span>).<span class="hljs-title function_">endpoint</span>(<span class="hljs-string">&quot;https://api.openai.com&quot;</span>);

<span class="hljs-keyword">let</span> out = <span class="hljs-string">&quot;&quot;</span>;
<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> chunk <span class="hljs-keyword">of</span> openai.<span class="hljs-title function_">chatCompletionStream</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;gpt-3.5-turbo&quot;</span>,
  <span class="hljs-attr">messages</span>: [
    { <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Complete the equation 1+1= ,just the answer&quot;</span> },
  ],
  <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">500</span>,
  <span class="hljs-attr">temperature</span>: <span class="hljs-number">0.1</span>,
  <span class="hljs-attr">seed</span>: <span class="hljs-number">0</span>,
})) {
  <span class="hljs-keyword">if</span> (chunk.<span class="hljs-property">choices</span> &amp;&amp; chunk.<span class="hljs-property">choices</span>.<span class="hljs-property">length</span> &gt; <span class="hljs-number">0</span>) {
    out += chunk.<span class="hljs-property">choices</span>[<span class="hljs-number">0</span>].<span class="hljs-property">delta</span>.<span class="hljs-property">content</span>;
  }
}

<span class="hljs-comment">// For mistral AI:</span>
<span class="hljs-comment">// endpointUrl: &quot;https://api.mistral.ai&quot;</span>
<span class="hljs-comment">// model: &quot;mistral-tiny&quot;</span>`,wrap:!1}}),es=new m({props:{title:"Fill Mask",local:"fill-mask",headingTag:"h3"}}),ns=new u({props:{code:"YXdhaXQlMjBoZi5maWxsTWFzayglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdiZXJ0LWJhc2UtdW5jYXNlZCclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAnJTVCTUFTSyU1RCUyMHdvcmxkISclMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">fillMask</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;bert-base-uncased&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;[MASK] world!&#x27;</span>
})`,wrap:!1}}),ps=new m({props:{title:"Summarization",local:"summarization",headingTag:"h3"}}),os=new u({props:{code:"YXdhaXQlMjBoZi5zdW1tYXJpemF0aW9uKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ2ZhY2Vib29rJTJGYmFydC1sYXJnZS1jbm4nJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTBBJTIwJTIwJTIwJTIwJ1RoZSUyMHRvd2VyJTIwaXMlMjAzMjQlMjBtZXRyZXMlMjAoMSUyQzA2MyUyMGZ0KSUyMHRhbGwlMkMlMjBhYm91dCUyMHRoZSUyMHNhbWUlMjBoZWlnaHQlMjBhcyUyMGFuJTIwODEtc3RvcmV5JTIwYnVpbGRpbmclMkMlMjBhbmQlMjB0aGUlMjB0YWxsZXN0JTIwc3RydWN0dXJlJTIwaW4lMjBQYXJpcy4lMjBJdHMlMjBiYXNlJTIwaXMlMjBzcXVhcmUlMkMlMjBtZWFzdXJpbmclMjAxMjUlMjBtZXRyZXMlMjAoNDEwJTIwZnQpJTIwb24lMjBlYWNoJTIwc2lkZS4lMjBEdXJpbmclMjBpdHMlMjBjb25zdHJ1Y3Rpb24lMkMlMjB0aGUlMjBFaWZmZWwlMjBUb3dlciUyMHN1cnBhc3NlZCUyMHRoZSUyMFdhc2hpbmd0b24lMjBNb251bWVudCUyMHRvJTIwYmVjb21lJTIwdGhlJTIwdGFsbGVzdCUyMG1hbi1tYWRlJTIwc3RydWN0dXJlJTIwaW4lMjB0aGUlMjB3b3JsZCUyQyUyMGElMjB0aXRsZSUyMGl0JTIwaGVsZCUyMGZvciUyMDQxJTIweWVhcnMlMjB1bnRpbCUyMHRoZSUyMENocnlzbGVyJTIwQnVpbGRpbmclMjBpbiUyME5ldyUyMFlvcmslMjBDaXR5JTIwd2FzJTIwZmluaXNoZWQlMjBpbiUyMDE5MzAuJyUyQyUwQSUyMCUyMHBhcmFtZXRlcnMlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjBtYXhfbGVuZ3RoJTNBJTIwMTAwJTBBJTIwJTIwJTdEJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">summarization</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/bart-large-cnn&#x27;</span>,
  <span class="hljs-attr">inputs</span>:
    <span class="hljs-string">&#x27;The tower is 324 metres (1,063 ft) tall, about the same height as an 81-storey building, and the tallest structure in Paris. Its base is square, measuring 125 metres (410 ft) on each side. During its construction, the Eiffel Tower surpassed the Washington Monument to become the tallest man-made structure in the world, a title it held for 41 years until the Chrysler Building in New York City was finished in 1930.&#x27;</span>,
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">max_length</span>: <span class="hljs-number">100</span>
  }
})`,wrap:!1}}),Ms=new m({props:{title:"Question Answering",local:"question-answering",headingTag:"h3"}}),cs=new u({props:{code:"YXdhaXQlMjBoZi5xdWVzdGlvbkFuc3dlcmluZyglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdkZWVwc2V0JTJGcm9iZXJ0YS1iYXNlLXNxdWFkMiclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjBxdWVzdGlvbiUzQSUyMCdXaGF0JTIwaXMlMjB0aGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlM0YnJTJDJTBBJTIwJTIwJTIwJTIwY29udGV4dCUzQSUyMCdUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMFBhcmlzLiclMEElMjAlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">questionAnswering</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;deepset/roberta-base-squad2&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">question</span>: <span class="hljs-string">&#x27;What is the capital of France?&#x27;</span>,
    <span class="hljs-attr">context</span>: <span class="hljs-string">&#x27;The capital of France is Paris.&#x27;</span>
  }
})`,wrap:!1}}),hs=new m({props:{title:"Table Question Answering",local:"table-question-answering",headingTag:"h3"}}),js=new u({props:{code:"YXdhaXQlMjBoZi50YWJsZVF1ZXN0aW9uQW5zd2VyaW5nKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ2dvb2dsZSUyRnRhcGFzLWJhc2UtZmluZXR1bmVkLXd0cSclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjBxdWVyeSUzQSUyMCdIb3clMjBtYW55JTIwc3RhcnMlMjBkb2VzJTIwdGhlJTIwdHJhbnNmb3JtZXJzJTIwcmVwb3NpdG9yeSUyMGhhdmUlM0YnJTJDJTBBJTIwJTIwJTIwJTIwdGFibGUlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjBSZXBvc2l0b3J5JTNBJTIwJTVCJ1RyYW5zZm9ybWVycyclMkMlMjAnRGF0YXNldHMnJTJDJTIwJ1Rva2VuaXplcnMnJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwU3RhcnMlM0ElMjAlNUInMzY1NDInJTJDJTIwJzQ1MTInJTJDJTIwJzM5MzQnJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwQ29udHJpYnV0b3JzJTNBJTIwJTVCJzY1MSclMkMlMjAnNzcnJTJDJTIwJzM0JyU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCdQcm9ncmFtbWluZyUyMGxhbmd1YWdlJyUzQSUyMCU1QidQeXRob24nJTJDJTIwJ1B5dGhvbiclMkMlMjAnUnVzdCUyQyUyMFB5dGhvbiUyMGFuZCUyME5vZGVKUyclNUQlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">tableQuestionAnswering</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;google/tapas-base-finetuned-wtq&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">query</span>: <span class="hljs-string">&#x27;How many stars does the transformers repository have?&#x27;</span>,
    <span class="hljs-attr">table</span>: {
      <span class="hljs-title class_">Repository</span>: [<span class="hljs-string">&#x27;Transformers&#x27;</span>, <span class="hljs-string">&#x27;Datasets&#x27;</span>, <span class="hljs-string">&#x27;Tokenizers&#x27;</span>],
      <span class="hljs-title class_">Stars</span>: [<span class="hljs-string">&#x27;36542&#x27;</span>, <span class="hljs-string">&#x27;4512&#x27;</span>, <span class="hljs-string">&#x27;3934&#x27;</span>],
      <span class="hljs-title class_">Contributors</span>: [<span class="hljs-string">&#x27;651&#x27;</span>, <span class="hljs-string">&#x27;77&#x27;</span>, <span class="hljs-string">&#x27;34&#x27;</span>],
      <span class="hljs-string">&#x27;Programming language&#x27;</span>: [<span class="hljs-string">&#x27;Python&#x27;</span>, <span class="hljs-string">&#x27;Python&#x27;</span>, <span class="hljs-string">&#x27;Rust, Python and NodeJS&#x27;</span>]
    }
  }
})`,wrap:!1}}),Js=new m({props:{title:"Text Classification",local:"text-classification",headingTag:"h3"}}),us=new u({props:{code:"YXdhaXQlMjBoZi50ZXh0Q2xhc3NpZmljYXRpb24oJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAnZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2gnJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJ0klMjBsaWtlJTIweW91LiUyMEklMjBsb3ZlJTIweW91LiclMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">textClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;distilbert-base-uncased-finetuned-sst-2-english&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;I like you. I love you.&#x27;</span>
})`,wrap:!1}}),ys=new m({props:{title:"Token Classification",local:"token-classification",headingTag:"h3"}}),ws=new u({props:{code:"YXdhaXQlMjBoZi50b2tlbkNsYXNzaWZpY2F0aW9uKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ2RibWR6JTJGYmVydC1sYXJnZS1jYXNlZC1maW5ldHVuZWQtY29ubGwwMy1lbmdsaXNoJyUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCdNeSUyMG5hbWUlMjBpcyUyMFNhcmFoJTIwSmVzc2ljYSUyMFBhcmtlciUyMGJ1dCUyMHlvdSUyMGNhbiUyMGNhbGwlMjBtZSUyMEplc3NpY2EnJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">tokenClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;dbmdz/bert-large-cased-finetuned-conll03-english&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;My name is Sarah Jessica Parker but you can call me Jessica&#x27;</span>
})`,wrap:!1}}),fs=new m({props:{title:"Translation",local:"translation",headingTag:"h3"}}),ds=new u({props:{code:"YXdhaXQlMjBoZi50cmFuc2xhdGlvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCd0NS1iYXNlJyUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCdNeSUyMG5hbWUlMjBpcyUyMFdvbGZnYW5nJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyMEJlcmxpbiclMEElN0QpJTBBJTBBYXdhaXQlMjBoZi50cmFuc2xhdGlvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdmYWNlYm9vayUyRm1iYXJ0LWxhcmdlLTUwLW1hbnktdG8tbWFueS1tbXQnJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwdGV4dFRvVHJhbnNsYXRlJTJDJTBBJTIwJTIwcGFyYW1ldGVycyUzQSUyMCU3QiUwQSUyMCUyMCUyMnNyY19sYW5nJTIyJTNBJTIwJTIyZW5fWFglMjIlMkMlMEElMjAlMjAlMjJ0Z3RfbGFuZyUyMiUzQSUyMCUyMmZyX1hYJTIyJTBBJTIwJTdEJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">translation</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;t5-base&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;My name is Wolfgang and I live in Berlin&#x27;</span>
})

<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">translation</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/mbart-large-50-many-to-many-mmt&#x27;</span>,
  <span class="hljs-attr">inputs</span>: textToTranslate,
  <span class="hljs-attr">parameters</span>: {
  <span class="hljs-string">&quot;src_lang&quot;</span>: <span class="hljs-string">&quot;en_XX&quot;</span>,
  <span class="hljs-string">&quot;tgt_lang&quot;</span>: <span class="hljs-string">&quot;fr_XX&quot;</span>
 }
})`,wrap:!1}}),Us=new m({props:{title:"Zero-Shot Classification",local:"zero-shot-classification",headingTag:"h3"}}),bs=new u({props:{code:"YXdhaXQlMjBoZi56ZXJvU2hvdENsYXNzaWZpY2F0aW9uKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ2ZhY2Vib29rJTJGYmFydC1sYXJnZS1tbmxpJyUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCdIaSUyQyUyMEklMjByZWNlbnRseSUyMGJvdWdodCUyMGElMjBkZXZpY2UlMjBmcm9tJTIweW91ciUyMGNvbXBhbnklMjBidXQlMjBpdCUyMGlzJTIwbm90JTIwd29ya2luZyUyMGFzJTIwYWR2ZXJ0aXNlZCUyMGFuZCUyMEklMjB3b3VsZCUyMGxpa2UlMjB0byUyMGdldCUyMHJlaW1idXJzZWQhJyUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMHBhcmFtZXRlcnMlM0ElMjAlN0IlMjBjYW5kaWRhdGVfbGFiZWxzJTNBJTIwJTVCJ3JlZnVuZCclMkMlMjAnbGVnYWwnJTJDJTIwJ2ZhcSclNUQlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">zeroShotClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/bart-large-mnli&#x27;</span>,
  <span class="hljs-attr">inputs</span>: [
    <span class="hljs-string">&#x27;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&#x27;</span>
  ],
  <span class="hljs-attr">parameters</span>: { <span class="hljs-attr">candidate_labels</span>: [<span class="hljs-string">&#x27;refund&#x27;</span>, <span class="hljs-string">&#x27;legal&#x27;</span>, <span class="hljs-string">&#x27;faq&#x27;</span>] }
})`,wrap:!1}}),$s=new m({props:{title:"Conversational",local:"conversational",headingTag:"h3"}}),Bs=new u({props:{code:"YXdhaXQlMjBoZi5jb252ZXJzYXRpb25hbCglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdtaWNyb3NvZnQlMkZEaWFsb0dQVC1sYXJnZSclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjBwYXN0X3VzZXJfaW5wdXRzJTNBJTIwJTVCJ1doaWNoJTIwbW92aWUlMjBpcyUyMHRoZSUyMGJlc3QlMjAlM0YnJTVEJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGVkX3Jlc3BvbnNlcyUzQSUyMCU1QidJdCUyMGlzJTIwRGllJTIwSGFyZCUyMGZvciUyMHN1cmUuJyU1RCUyQyUwQSUyMCUyMCUyMCUyMHRleHQlM0ElMjAnQ2FuJTIweW91JTIwZXhwbGFpbiUyMHdoeSUyMCUzRiclMEElMjAlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">conversational</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;microsoft/DialoGPT-large&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">past_user_inputs</span>: [<span class="hljs-string">&#x27;Which movie is the best ?&#x27;</span>],
    <span class="hljs-attr">generated_responses</span>: [<span class="hljs-string">&#x27;It is Die Hard for sure.&#x27;</span>],
    <span class="hljs-attr">text</span>: <span class="hljs-string">&#x27;Can you explain why ?&#x27;</span>
  }
})`,wrap:!1}}),xs=new m({props:{title:"Sentence Similarity",local:"sentence-similarity",headingTag:"h3"}}),Zs=new u({props:{code:"YXdhaXQlMjBoZi5zZW50ZW5jZVNpbWlsYXJpdHkoJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAnc2VudGVuY2UtdHJhbnNmb3JtZXJzJTJGcGFyYXBocmFzZS14bG0tci1tdWx0aWxpbmd1YWwtdjEnJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwc291cmNlX3NlbnRlbmNlJTNBJTIwJ1RoYXQlMjBpcyUyMGElMjBoYXBweSUyMHBlcnNvbiclMkMlMEElMjAlMjAlMjAlMjBzZW50ZW5jZXMlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAnVGhhdCUyMGlzJTIwYSUyMGhhcHB5JTIwZG9nJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCdUaGF0JTIwaXMlMjBhJTIwdmVyeSUyMGhhcHB5JTIwcGVyc29uJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCdUb2RheSUyMGlzJTIwYSUyMHN1bm55JTIwZGF5JyUwQSUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCU3RCUwQSU3RCk=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">sentenceSimilarity</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;sentence-transformers/paraphrase-xlm-r-multilingual-v1&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">source_sentence</span>: <span class="hljs-string">&#x27;That is a happy person&#x27;</span>,
    <span class="hljs-attr">sentences</span>: [
      <span class="hljs-string">&#x27;That is a happy dog&#x27;</span>,
      <span class="hljs-string">&#x27;That is a very happy person&#x27;</span>,
      <span class="hljs-string">&#x27;Today is a sunny day&#x27;</span>
    ]
  }
})`,wrap:!1}}),Gs=new m({props:{title:"Audio",local:"audio",headingTag:"h2"}}),Qs=new m({props:{title:"Automatic Speech Recognition",local:"automatic-speech-recognition",headingTag:"h3"}}),vs=new u({props:{code:"YXdhaXQlMjBoZi5hdXRvbWF0aWNTcGVlY2hSZWNvZ25pdGlvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdmYWNlYm9vayUyRndhdjJ2ZWMyLWxhcmdlLTk2MGgtbHY2MC1zZWxmJyUyQyUwQSUyMCUyMGRhdGElM0ElMjByZWFkRmlsZVN5bmMoJ3Rlc3QlMkZzYW1wbGUxLmZsYWMnKSUwQSU3RCk=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">automaticSpeechRecognition</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/wav2vec2-large-960h-lv60-self&#x27;</span>,
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/sample1.flac&#x27;</span>)
})`,wrap:!1}}),Ws=new m({props:{title:"Audio Classification",local:"audio-classification",headingTag:"h3"}}),Xs=new u({props:{code:"YXdhaXQlMjBoZi5hdWRpb0NsYXNzaWZpY2F0aW9uKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ3N1cGVyYiUyRmh1YmVydC1sYXJnZS1zdXBlcmItZXInJTJDJTBBJTIwJTIwZGF0YSUzQSUyMHJlYWRGaWxlU3luYygndGVzdCUyRnNhbXBsZTEuZmxhYycpJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">audioClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;superb/hubert-large-superb-er&#x27;</span>,
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/sample1.flac&#x27;</span>)
})`,wrap:!1}}),Ss=new m({props:{title:"Text To Speech",local:"text-to-speech",headingTag:"h3"}}),qs=new u({props:{code:"YXdhaXQlMjBoZi50ZXh0VG9TcGVlY2goJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAnZXNwbmV0JTJGa2FuLWJheWFzaGlfbGpzcGVlY2hfdml0cyclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAnSGVsbG8lMjB3b3JsZCEnJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">textToSpeech</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;espnet/kan-bayashi_ljspeech_vits&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;Hello world!&#x27;</span>
})`,wrap:!1}}),zs=new m({props:{title:"Audio To Audio",local:"audio-to-audio",headingTag:"h3"}}),Hs=new u({props:{code:"YXdhaXQlMjBoZi5hdWRpb1RvQXVkaW8oJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAnc3BlZWNoYnJhaW4lMkZzZXBmb3JtZXItd2hhbSclMkMlMEElMjAlMjBkYXRhJTNBJTIwcmVhZEZpbGVTeW5jKCd0ZXN0JTJGc2FtcGxlMS5mbGFjJyklMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">audioToAudio</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;speechbrain/sepformer-wham&#x27;</span>,
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/sample1.flac&#x27;</span>)
})`,wrap:!1}}),_s=new m({props:{title:"Computer Vision",local:"computer-vision",headingTag:"h2"}}),Ls=new m({props:{title:"Image Classification",local:"image-classification",headingTag:"h3"}}),Ks=new u({props:{code:"YXdhaXQlMjBoZi5pbWFnZUNsYXNzaWZpY2F0aW9uKCU3QiUwQSUyMCUyMGRhdGElM0ElMjByZWFkRmlsZVN5bmMoJ3Rlc3QlMkZjaGVldGFoLnBuZycpJTJDJTBBJTIwJTIwbW9kZWwlM0ElMjAnZ29vZ2xlJTJGdml0LWJhc2UtcGF0Y2gxNi0yMjQnJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">imageClassification</span>({
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/cheetah.png&#x27;</span>),
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;google/vit-base-patch16-224&#x27;</span>
})`,wrap:!1}}),Os=new m({props:{title:"Object Detection",local:"object-detection",headingTag:"h3"}}),lt=new u({props:{code:"YXdhaXQlMjBoZi5vYmplY3REZXRlY3Rpb24oJTdCJTBBJTIwJTIwZGF0YSUzQSUyMHJlYWRGaWxlU3luYygndGVzdCUyRmNhdHMucG5nJyklMkMlMEElMjAlMjBtb2RlbCUzQSUyMCdmYWNlYm9vayUyRmRldHItcmVzbmV0LTUwJyUwQSU3RCk=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">objectDetection</span>({
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/cats.png&#x27;</span>),
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/detr-resnet-50&#x27;</span>
})`,wrap:!1}}),et=new m({props:{title:"Image Segmentation",local:"image-segmentation",headingTag:"h3"}}),nt=new u({props:{code:"YXdhaXQlMjBoZi5pbWFnZVNlZ21lbnRhdGlvbiglN0IlMEElMjAlMjBkYXRhJTNBJTIwcmVhZEZpbGVTeW5jKCd0ZXN0JTJGY2F0cy5wbmcnKSUyQyUwQSUyMCUyMG1vZGVsJTNBJTIwJ2ZhY2Vib29rJTJGZGV0ci1yZXNuZXQtNTAtcGFub3B0aWMnJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">imageSegmentation</span>({
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/cats.png&#x27;</span>),
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/detr-resnet-50-panoptic&#x27;</span>
})`,wrap:!1}}),pt=new m({props:{title:"Image To Text",local:"image-to-text",headingTag:"h3"}}),ot=new u({props:{code:"YXdhaXQlMjBoZi5pbWFnZVRvVGV4dCglN0IlMEElMjAlMjBkYXRhJTNBJTIwcmVhZEZpbGVTeW5jKCd0ZXN0JTJGY2F0cy5wbmcnKSUyQyUwQSUyMCUyMG1vZGVsJTNBJTIwJ25scGNvbm5lY3QlMkZ2aXQtZ3B0Mi1pbWFnZS1jYXB0aW9uaW5nJyUwQSU3RCk=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">imageToText</span>({
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/cats.png&#x27;</span>),
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;nlpconnect/vit-gpt2-image-captioning&#x27;</span>
})`,wrap:!1}}),Mt=new m({props:{title:"Text To Image",local:"text-to-image",headingTag:"h3"}}),ht=new u({props:{code:"YXdhaXQlMjBoZi50ZXh0VG9JbWFnZSglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYnJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJ2ElMjBwaWN0dXJlJTIwb2YlMjBhJTIwZ3JlZW4lMjBiaXJkJyUwQSU3RCk=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">textToImage</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;black-forest-labs/FLUX.1-dev&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;a picture of a green bird&#x27;</span>
})`,wrap:!1}}),jt=new m({props:{title:"Image To Image",local:"image-to-image",headingTag:"h3"}}),ut=new u({props:{code:"YXdhaXQlMjBoZi5pbWFnZVRvSW1hZ2UoJTdCJTBBJTIwJTIwaW5wdXRzJTNBJTIwbmV3JTIwQmxvYiglNUJyZWFkRmlsZVN5bmMoJTIydGVzdCUyRnN0b3JtdHJvb3Blcl9kZXB0aC5wbmclMjIpJTVEKSUyQyUwQSUyMCUyMHBhcmFtZXRlcnMlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjBwcm9tcHQlM0ElMjAlMjJlbG1vJ3MlMjBsZWN0dXJlJTIyJTJDJTBBJTIwJTIwJTdEJTJDJTBBJTIwJTIwbW9kZWwlM0ElMjAlMjJsbGx5YXN2aWVsJTJGc2QtY29udHJvbG5ldC1kZXB0aCUyMiUyQyUwQSU3RCklM0I=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">imageToImage</span>({
  <span class="hljs-attr">inputs</span>: <span class="hljs-keyword">new</span> <span class="hljs-title class_">Blob</span>([<span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&quot;test/stormtrooper_depth.png&quot;</span>)]),
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">prompt</span>: <span class="hljs-string">&quot;elmo&#x27;s lecture&quot;</span>,
  },
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;lllyasviel/sd-controlnet-depth&quot;</span>,
});`,wrap:!1}}),yt=new m({props:{title:"Zero Shot Image Classification",local:"zero-shot-image-classification",headingTag:"h3"}}),wt=new u({props:{code:"YXdhaXQlMjBoZi56ZXJvU2hvdEltYWdlQ2xhc3NpZmljYXRpb24oJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAnb3BlbmFpJTJGY2xpcC12aXQtbGFyZ2UtcGF0Y2gxNC0zMzYnJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0ElMjBhd2FpdCUyMChhd2FpdCUyMGZldGNoKCdodHRwcyUzQSUyRiUyRnBsYWNla2l0dGVuLmNvbSUyRjMwMCUyRjMwMCcpKS5ibG9iKCklMEElMjAlMjAlN0QlMkMlMEElMjAlMjBwYXJhbWV0ZXJzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwY2FuZGlkYXRlX2xhYmVscyUzQSUyMCU1QidjYXQnJTJDJTIwJ2RvZyclNUQlMEElMjAlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">zeroShotImageClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;openai/clip-vit-large-patch14-336&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">image</span>: <span class="hljs-keyword">await</span> (<span class="hljs-keyword">await</span> <span class="hljs-title function_">fetch</span>(<span class="hljs-string">&#x27;https://placekitten.com/300/300&#x27;</span>)).<span class="hljs-title function_">blob</span>()
  },
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">candidate_labels</span>: [<span class="hljs-string">&#x27;cat&#x27;</span>, <span class="hljs-string">&#x27;dog&#x27;</span>]
  }
})`,wrap:!1}}),ft=new m({props:{title:"Multimodal",local:"multimodal",headingTag:"h2"}}),gt=new m({props:{title:"Feature Extraction",local:"feature-extraction",headingTag:"h3"}}),Ut=new u({props:{code:"YXdhaXQlMjBoZi5mZWF0dXJlRXh0cmFjdGlvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCUyMnNlbnRlbmNlLXRyYW5zZm9ybWVycyUyRmRpc3RpbGJlcnQtYmFzZS1ubGktbWVhbi10b2tlbnMlMjIlMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAlMjJUaGF0JTIwaXMlMjBhJTIwaGFwcHklMjBwZXJzb24lMjIlMkMlMEElN0QpJTNC",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">featureExtraction</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;sentence-transformers/distilbert-base-nli-mean-tokens&quot;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&quot;That is a happy person&quot;</span>,
});`,wrap:!1}}),It=new m({props:{title:"Visual Question Answering",local:"visual-question-answering",headingTag:"h3"}}),Ct=new u({props:{code:"YXdhaXQlMjBoZi52aXN1YWxRdWVzdGlvbkFuc3dlcmluZyglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdkYW5kZWxpbiUyRnZpbHQtYjMyLWZpbmV0dW5lZC12cWEnJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwcXVlc3Rpb24lM0ElMjAnSG93JTIwbWFueSUyMGNhdHMlMjBhcmUlMjBseWluZyUyMGRvd24lM0YnJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0ElMjBhd2FpdCUyMChhd2FpdCUyMGZldGNoKCdodHRwcyUzQSUyRiUyRnBsYWNla2l0dGVuLmNvbSUyRjMwMCUyRjMwMCcpKS5ibG9iKCklMEElMjAlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">visualQuestionAnswering</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;dandelin/vilt-b32-finetuned-vqa&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">question</span>: <span class="hljs-string">&#x27;How many cats are lying down?&#x27;</span>,
    <span class="hljs-attr">image</span>: <span class="hljs-keyword">await</span> (<span class="hljs-keyword">await</span> <span class="hljs-title function_">fetch</span>(<span class="hljs-string">&#x27;https://placekitten.com/300/300&#x27;</span>)).<span class="hljs-title function_">blob</span>()
  }
})`,wrap:!1}}),Bt=new m({props:{title:"Document Question Answering",local:"document-question-answering",headingTag:"h3"}}),Zt=new u({props:{code:"YXdhaXQlMjBoZi5kb2N1bWVudFF1ZXN0aW9uQW5zd2VyaW5nKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ2ltcGlyYSUyRmxheW91dGxtLWRvY3VtZW50LXFhJyUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMHF1ZXN0aW9uJTNBJTIwJ0ludm9pY2UlMjBudW1iZXIlM0YnJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0ElMjBhd2FpdCUyMChhd2FpdCUyMGZldGNoKCdodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc3BhY2VzJTJGaW1waXJhJTJGZG9jcXVlcnklMkZyZXNvbHZlJTJGMjM1OTIyM2MxODM3YTc1ODc0MDJiZGEwZjI2NDMzODJhNmVlZmVhYiUyRmludm9pY2UucG5nJykpLmJsb2IoKSUyQyUwQSUyMCUyMCU3RCUwQSU3RCk=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">documentQuestionAnswering</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;impira/layoutlm-document-qa&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">question</span>: <span class="hljs-string">&#x27;Invoice number?&#x27;</span>,
    <span class="hljs-attr">image</span>: <span class="hljs-keyword">await</span> (<span class="hljs-keyword">await</span> <span class="hljs-title function_">fetch</span>(<span class="hljs-string">&#x27;https://huggingface.co/spaces/impira/docquery/resolve/2359223c1837a7587402bda0f2643382a6eefeab/invoice.png&#x27;</span>)).<span class="hljs-title function_">blob</span>(),
  }
})`,wrap:!1}}),Gt=new m({props:{title:"Tabular",local:"tabular",headingTag:"h2"}}),Qt=new m({props:{title:"Tabular Regression",local:"tabular-regression",headingTag:"h3"}}),Et=new u({props:{code:"YXdhaXQlMjBoZi50YWJ1bGFyUmVncmVzc2lvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCUyMnNjaWtpdC1sZWFybiUyRkZpc2gtV2VpZ2h0JTIyJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwZGF0YSUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMkhlaWdodCUyMiUzQSUyMCU1QiUyMjExLjUyJTIyJTJDJTIwJTIyMTIuNDglMjIlMkMlMjAlMjIxMi4zNzc4JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyTGVuZ3RoMSUyMiUzQSUyMCU1QiUyMjIzLjIlMjIlMkMlMjAlMjIyNCUyMiUyQyUyMCUyMjIzLjklMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJMZW5ndGgyJTIyJTNBJTIwJTVCJTIyMjUuNCUyMiUyQyUyMCUyMjI2LjMlMjIlMkMlMjAlMjIyNi41JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyTGVuZ3RoMyUyMiUzQSUyMCU1QiUyMjMwJTIyJTJDJTIwJTIyMzEuMiUyMiUyQyUyMCUyMjMxLjElMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJTcGVjaWVzJTIyJTNBJTIwJTVCJTIyQnJlYW0lMjIlMkMlMjAlMjJCcmVhbSUyMiUyQyUyMCUyMkJyZWFtJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2lkdGglMjIlM0ElMjAlNUIlMjI0LjAyJTIyJTJDJTIwJTIyNC4zMDU2JTIyJTJDJTIwJTIyNC42OTYxJTIyJTVEJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTdEJTJDJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">tabularRegression</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;scikit-learn/Fish-Weight&quot;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">data</span>: {
      <span class="hljs-string">&quot;Height&quot;</span>: [<span class="hljs-string">&quot;11.52&quot;</span>, <span class="hljs-string">&quot;12.48&quot;</span>, <span class="hljs-string">&quot;12.3778&quot;</span>],
      <span class="hljs-string">&quot;Length1&quot;</span>: [<span class="hljs-string">&quot;23.2&quot;</span>, <span class="hljs-string">&quot;24&quot;</span>, <span class="hljs-string">&quot;23.9&quot;</span>],
      <span class="hljs-string">&quot;Length2&quot;</span>: [<span class="hljs-string">&quot;25.4&quot;</span>, <span class="hljs-string">&quot;26.3&quot;</span>, <span class="hljs-string">&quot;26.5&quot;</span>],
      <span class="hljs-string">&quot;Length3&quot;</span>: [<span class="hljs-string">&quot;30&quot;</span>, <span class="hljs-string">&quot;31.2&quot;</span>, <span class="hljs-string">&quot;31.1&quot;</span>],
      <span class="hljs-string">&quot;Species&quot;</span>: [<span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>],
      <span class="hljs-string">&quot;Width&quot;</span>: [<span class="hljs-string">&quot;4.02&quot;</span>, <span class="hljs-string">&quot;4.3056&quot;</span>, <span class="hljs-string">&quot;4.6961&quot;</span>]
    },
  },
})`,wrap:!1}}),vt=new m({props:{title:"Tabular Classification",local:"tabular-classification",headingTag:"h3"}}),At=new u({props:{code:"YXdhaXQlMjBoZi50YWJ1bGFyQ2xhc3NpZmljYXRpb24oJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAlMjJ2dm1ubm5rdiUyRndpbmUtcXVhbGl0eSUyMiUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMGRhdGElM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJmaXhlZF9hY2lkaXR5JTIyJTNBJTIwJTVCJTIyNy40JTIyJTJDJTIwJTIyNy44JTIyJTJDJTIwJTIyMTAuMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnZvbGF0aWxlX2FjaWRpdHklMjIlM0ElMjAlNUIlMjIwLjclMjIlMkMlMjAlMjIwLjg4JTIyJTJDJTIwJTIyMC4zMiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMmNpdHJpY19hY2lkJTIyJTNBJTIwJTVCJTIyMCUyMiUyQyUyMCUyMjAlMjIlMkMlMjAlMjIwLjQ1JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIycmVzaWR1YWxfc3VnYXIlMjIlM0ElMjAlNUIlMjIxLjklMjIlMkMlMjAlMjIyLjYlMjIlMkMlMjAlMjI2LjQlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJjaGxvcmlkZXMlMjIlM0ElMjAlNUIlMjIwLjA3NiUyMiUyQyUyMCUyMjAuMDk4JTIyJTJDJTIwJTIyMC4wNzMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJmcmVlX3N1bGZ1cl9kaW94aWRlJTIyJTNBJTIwJTVCJTIyMTElMjIlMkMlMjAlMjIyNSUyMiUyQyUyMCUyMjUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJ0b3RhbF9zdWxmdXJfZGlveGlkZSUyMiUzQSUyMCU1QiUyMjM0JTIyJTJDJTIwJTIyNjclMjIlMkMlMjAlMjIxMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlbnNpdHklMjIlM0ElMjAlNUIlMjIwLjk5NzglMjIlMkMlMjAlMjIwLjk5NjglMjIlMkMlMjAlMjIwLjk5NzYlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJwSCUyMiUzQSUyMCU1QiUyMjMuNTElMjIlMkMlMjAlMjIzLjIlMjIlMkMlMjAlMjIzLjIzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3VscGhhdGVzJTIyJTNBJTIwJTVCJTIyMC41NiUyMiUyQyUyMCUyMjAuNjglMjIlMkMlMjAlMjIwLjgyJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyYWxjb2hvbCUyMiUzQSUyMCU1QiUyMjkuNCUyMiUyQyUyMCUyMjkuOCUyMiUyQyUyMCUyMjEyLjYlMjIlNUQlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlN0QlMkMlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">tabularClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;vvmnnnkv/wine-quality&quot;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">data</span>: {
      <span class="hljs-string">&quot;fixed_acidity&quot;</span>: [<span class="hljs-string">&quot;7.4&quot;</span>, <span class="hljs-string">&quot;7.8&quot;</span>, <span class="hljs-string">&quot;10.3&quot;</span>],
      <span class="hljs-string">&quot;volatile_acidity&quot;</span>: [<span class="hljs-string">&quot;0.7&quot;</span>, <span class="hljs-string">&quot;0.88&quot;</span>, <span class="hljs-string">&quot;0.32&quot;</span>],
      <span class="hljs-string">&quot;citric_acid&quot;</span>: [<span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0.45&quot;</span>],
      <span class="hljs-string">&quot;residual_sugar&quot;</span>: [<span class="hljs-string">&quot;1.9&quot;</span>, <span class="hljs-string">&quot;2.6&quot;</span>, <span class="hljs-string">&quot;6.4&quot;</span>],
      <span class="hljs-string">&quot;chlorides&quot;</span>: [<span class="hljs-string">&quot;0.076&quot;</span>, <span class="hljs-string">&quot;0.098&quot;</span>, <span class="hljs-string">&quot;0.073&quot;</span>],
      <span class="hljs-string">&quot;free_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;11&quot;</span>, <span class="hljs-string">&quot;25&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>],
      <span class="hljs-string">&quot;total_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;34&quot;</span>, <span class="hljs-string">&quot;67&quot;</span>, <span class="hljs-string">&quot;13&quot;</span>],
      <span class="hljs-string">&quot;density&quot;</span>: [<span class="hljs-string">&quot;0.9978&quot;</span>, <span class="hljs-string">&quot;0.9968&quot;</span>, <span class="hljs-string">&quot;0.9976&quot;</span>],
      <span class="hljs-string">&quot;pH&quot;</span>: [<span class="hljs-string">&quot;3.51&quot;</span>, <span class="hljs-string">&quot;3.2&quot;</span>, <span class="hljs-string">&quot;3.23&quot;</span>],
      <span class="hljs-string">&quot;sulphates&quot;</span>: [<span class="hljs-string">&quot;0.56&quot;</span>, <span class="hljs-string">&quot;0.68&quot;</span>, <span class="hljs-string">&quot;0.82&quot;</span>],
      <span class="hljs-string">&quot;alcohol&quot;</span>: [<span class="hljs-string">&quot;9.4&quot;</span>, <span class="hljs-string">&quot;9.8&quot;</span>, <span class="hljs-string">&quot;12.6&quot;</span>]
    },
  },
})`,wrap:!1}}),Xt=new u({props:{code:"JTJGJTJGJTIwQ2hhdCUyMENvbXBsZXRpb24lMjBFeGFtcGxlJTBBY29uc3QlMjBNSVNUUkFMX0tFWSUyMCUzRCUyMHByb2Nlc3MuZW52Lk1JU1RSQUxfS0VZJTNCJTBBY29uc3QlMjBoZiUyMCUzRCUyMG5ldyUyMEluZmVyZW5jZUNsaWVudChNSVNUUkFMX0tFWSklM0IlMEFjb25zdCUyMGVwJTIwJTNEJTIwaGYuZW5kcG9pbnQoJTIyaHR0cHMlM0ElMkYlMkZhcGkubWlzdHJhbC5haSUyMiklM0IlMEFjb25zdCUyMHN0cmVhbSUyMCUzRCUyMGVwLmNoYXRDb21wbGV0aW9uU3RyZWFtKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJTIybWlzdHJhbC10aW55JTIyJTJDJTBBJTIwJTIwbWVzc2FnZXMlM0ElMjAlNUIlN0IlMjByb2xlJTNBJTIwJTIydXNlciUyMiUyQyUyMGNvbnRlbnQlM0ElMjAlMjJDb21wbGV0ZSUyMHRoZSUyMGVxdWF0aW9uJTIwb25lJTIwJTJCJTIwb25lJTIwJTNEJTIwJTJDJTIwanVzdCUyMHRoZSUyMGFuc3dlciUyMiUyMCU3RCU1RCUyQyUwQSU3RCklM0IlMEFsZXQlMjBvdXQlMjAlM0QlMjAlMjIlMjIlM0IlMEFmb3IlMjBhd2FpdCUyMChjb25zdCUyMGNodW5rJTIwb2YlMjBzdHJlYW0pJTIwJTdCJTBBJTIwJTIwaWYlMjAoY2h1bmsuY2hvaWNlcyUyMCUyNiUyNiUyMGNodW5rLmNob2ljZXMubGVuZ3RoJTIwJTNFJTIwMCklMjAlN0IlMEElMjAlMjAlMjAlMjBvdXQlMjAlMkIlM0QlMjBjaHVuay5jaG9pY2VzJTVCMCU1RC5kZWx0YS5jb250ZW50JTNCJTBBJTIwJTIwJTIwJTIwY29uc29sZS5sb2cob3V0KSUzQiUwQSUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-comment">// Chat Completion Example</span>
<span class="hljs-keyword">const</span> <span class="hljs-variable constant_">MISTRAL_KEY</span> = process.<span class="hljs-property">env</span>.<span class="hljs-property">MISTRAL_KEY</span>;
<span class="hljs-keyword">const</span> hf = <span class="hljs-keyword">new</span> <span class="hljs-title class_">InferenceClient</span>(<span class="hljs-variable constant_">MISTRAL_KEY</span>);
<span class="hljs-keyword">const</span> ep = hf.<span class="hljs-title function_">endpoint</span>(<span class="hljs-string">&quot;https://api.mistral.ai&quot;</span>);
<span class="hljs-keyword">const</span> stream = ep.<span class="hljs-title function_">chatCompletionStream</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;mistral-tiny&quot;</span>,
  <span class="hljs-attr">messages</span>: [{ <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Complete the equation one + one = , just the answer&quot;</span> }],
});
<span class="hljs-keyword">let</span> out = <span class="hljs-string">&quot;&quot;</span>;
<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> chunk <span class="hljs-keyword">of</span> stream) {
  <span class="hljs-keyword">if</span> (chunk.<span class="hljs-property">choices</span> &amp;&amp; chunk.<span class="hljs-property">choices</span>.<span class="hljs-property">length</span> &gt; <span class="hljs-number">0</span>) {
    out += chunk.<span class="hljs-property">choices</span>[<span class="hljs-number">0</span>].<span class="hljs-property">delta</span>.<span class="hljs-property">content</span>;
    <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(out);
  }
}`,wrap:!1}}),St=new m({props:{title:"Custom Inference Endpoints",local:"custom-inference-endpoints",headingTag:"h2"}}),Rt=new u({props:{code:"Y29uc3QlMjBncHQyJTIwJTNEJTIwaGYuZW5kcG9pbnQoJ2h0dHBzJTNBJTJGJTJGeHl6LmV1LXdlc3QtMS5hd3MuZW5kcG9pbnRzLmh1Z2dpbmdmYWNlLmNsb3VkJTJGZ3B0MicpJTNCJTBBY29uc3QlMjAlN0IlMjBnZW5lcmF0ZWRfdGV4dCUyMCU3RCUyMCUzRCUyMGF3YWl0JTIwZ3B0Mi50ZXh0R2VuZXJhdGlvbiglN0JpbnB1dHMlM0ElMjAnVGhlJTIwYW5zd2VyJTIwdG8lMjB0aGUlMjB1bml2ZXJzZSUyMGlzJyU3RCklM0IlMEElMEElMkYlMkYlMjBDaGF0JTIwQ29tcGxldGlvbiUyMEV4YW1wbGUlMEFjb25zdCUyMGVwJTIwJTNEJTIwaGYuZW5kcG9pbnQoJTBBJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZyb3V0ZXIuaHVnZ2luZ2ZhY2UuY28lMkZoZi1pbmZlcmVuY2UlMkZtb2RlbHMlMkZtZXRhLWxsYW1hJTJGTGxhbWEtMy4xLThCLUluc3RydWN0JTIyJTBBKSUzQiUwQWNvbnN0JTIwc3RyZWFtJTIwJTNEJTIwZXAuY2hhdENvbXBsZXRpb25TdHJlYW0oJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAlMjJ0Z2klMjIlMkMlMEElMjAlMjBtZXNzYWdlcyUzQSUyMCU1QiU3QiUyMHJvbGUlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwY29udGVudCUzQSUyMCUyMkNvbXBsZXRlJTIwdGhlJTIwZXF1YXRpb24lMjAxJTJCMSUzRCUyMCUyQ2p1c3QlMjB0aGUlMjBhbnN3ZXIlMjIlMjAlN0QlNUQlMkMlMEElMjAlMjBtYXhfdG9rZW5zJTNBJTIwNTAwJTJDJTBBJTIwJTIwdGVtcGVyYXR1cmUlM0ElMjAwLjElMkMlMEElMjAlMjBzZWVkJTNBJTIwMCUyQyUwQSU3RCklM0IlMEFsZXQlMjBvdXQlMjAlM0QlMjAlMjIlMjIlM0IlMEFmb3IlMjBhd2FpdCUyMChjb25zdCUyMGNodW5rJTIwb2YlMjBzdHJlYW0pJTIwJTdCJTBBJTIwJTIwaWYlMjAoY2h1bmsuY2hvaWNlcyUyMCUyNiUyNiUyMGNodW5rLmNob2ljZXMubGVuZ3RoJTIwJTNFJTIwMCklMjAlN0IlMEElMjAlMjAlMjAlMjBvdXQlMjAlMkIlM0QlMjBjaHVuay5jaG9pY2VzJTVCMCU1RC5kZWx0YS5jb250ZW50JTNCJTBBJTIwJTIwJTIwJTIwY29uc29sZS5sb2cob3V0KSUzQiUwQSUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-keyword">const</span> gpt2 = hf.<span class="hljs-title function_">endpoint</span>(<span class="hljs-string">&#x27;https://xyz.eu-west-1.aws.endpoints.huggingface.cloud/gpt2&#x27;</span>);
<span class="hljs-keyword">const</span> { generated_text } = <span class="hljs-keyword">await</span> gpt2.<span class="hljs-title function_">textGeneration</span>({<span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;The answer to the universe is&#x27;</span>});

<span class="hljs-comment">// Chat Completion Example</span>
<span class="hljs-keyword">const</span> ep = hf.<span class="hljs-title function_">endpoint</span>(
  <span class="hljs-string">&quot;https://router.huggingface.co/hf-inference/models/meta-llama/Llama-3.1-8B-Instruct&quot;</span>
);
<span class="hljs-keyword">const</span> stream = ep.<span class="hljs-title function_">chatCompletionStream</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;tgi&quot;</span>,
  <span class="hljs-attr">messages</span>: [{ <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Complete the equation 1+1= ,just the answer&quot;</span> }],
  <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">500</span>,
  <span class="hljs-attr">temperature</span>: <span class="hljs-number">0.1</span>,
  <span class="hljs-attr">seed</span>: <span class="hljs-number">0</span>,
});
<span class="hljs-keyword">let</span> out = <span class="hljs-string">&quot;&quot;</span>;
<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> chunk <span class="hljs-keyword">of</span> stream) {
  <span class="hljs-keyword">if</span> (chunk.<span class="hljs-property">choices</span> &amp;&amp; chunk.<span class="hljs-property">choices</span>.<span class="hljs-property">length</span> &gt; <span class="hljs-number">0</span>) {
    out += chunk.<span class="hljs-property">choices</span>[<span class="hljs-number">0</span>].<span class="hljs-property">delta</span>.<span class="hljs-property">content</span>;
    <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(out);
  }
}`,wrap:!1}}),zt=new u({props:{code:"Y29uc3QlMjBncHQyJTIwJTNEJTIwaGYuZW5kcG9pbnQoJ2h0dHBzJTNBJTJGJTJGeHl6LmV1LXdlc3QtMS5hd3MuZW5kcG9pbnRzLmh1Z2dpbmdmYWNlLmNsb3VkJTJGZ3B0MicpJTNCJTBBY29uc3QlMjAlN0IlMjBnZW5lcmF0ZWRfdGV4dCUyMCU3RCUyMCUzRCUyMGF3YWl0JTIwZ3B0Mi50ZXh0R2VuZXJhdGlvbiglMEElMjAlMjAlN0JpbnB1dHMlM0ElMjAnVGhlJTIwYW5zd2VyJTIwdG8lMjB0aGUlMjB1bml2ZXJzZSUyMGlzJyU3RCUyQyUwQSUyMCUyMCU3QnJldHJ5X29uX2Vycm9yJTNBJTIwZmFsc2UlN0QlMkMlMEEpJTNC",highlighted:`<span class="hljs-keyword">const</span> gpt2 = hf.<span class="hljs-title function_">endpoint</span>(<span class="hljs-string">&#x27;https://xyz.eu-west-1.aws.endpoints.huggingface.cloud/gpt2&#x27;</span>);
<span class="hljs-keyword">const</span> { generated_text } = <span class="hljs-keyword">await</span> gpt2.<span class="hljs-title function_">textGeneration</span>(
  {<span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;The answer to the universe is&#x27;</span>},
  {<span class="hljs-attr">retry_on_error</span>: <span class="hljs-literal">false</span>},
);`,wrap:!1}}),Ft=new m({props:{title:"Running tests",local:"running-tests",headingTag:"h2"}}),Ht=new u({props:{code:"SEZfVE9LRU4lM0QlMjJ5b3VyJTIwYWNjZXNzJTIwdG9rZW4lMjIlMjBwbnBtJTIwcnVuJTIwdGVzdA==",highlighted:"HF_TOKEN=&quot;your access token&quot; pnpm run test",wrap:!1}}),_t=new m({props:{title:"Finding appropriate models",local:"finding-appropriate-models",headingTag:"h2"}}),Pt=new m({props:{title:"Dependencies",local:"dependencies",headingTag:"h2"}}),Ot=new ap({props:{source:"https://github.com/huggingface/huggingface.js/blob/main/docs/inference/README.md"}}),{c(){y=h("meta"),ll=a(),sl=h("p"),el=a(),p(T.$$.fragment),al=a(),w=h("p"),w.innerHTML=Va,nl=a(),f=h("p"),f.innerHTML=Ra,pl=a(),p(g.$$.fragment),il=a(),p(d.$$.fragment),ol=a(),p(U.$$.fragment),Ml=a(),p(I.$$.fragment),rl=a(),p(b.$$.fragment),cl=a(),p($.$$.fragment),hl=a(),p(C.$$.fragment),jl=a(),p(B.$$.fragment),Jl=a(),x=h("p"),x.innerHTML=qa,ml=a(),k=h("p"),k.textContent=za,ul=a(),p(Z.$$.fragment),yl=a(),G=h("p"),G.textContent=Fa,Tl=a(),Q=h("p"),Q.textContent=Ha,wl=a(),N=h("ul"),N.innerHTML=_a,fl=a(),E=h("p"),E.innerHTML=La,gl=a(),p(v.$$.fragment),dl=a(),W=h("p"),W.innerHTML=Da,Ul=a(),A=h("p"),A.textContent=Pa,Il=a(),Y=h("ul"),Y.innerHTML=Ka,bl=a(),X=h("p"),X.innerHTML=Oa,$l=a(),S=h("p"),S.innerHTML=sn,Cl=a(),p(V.$$.fragment),Bl=a(),R=h("p"),R.innerHTML=tn,xl=a(),p(q.$$.fragment),kl=a(),z=h("p"),z.textContent=ln,Zl=a(),p(F.$$.fragment),Gl=a(),p(H.$$.fragment),Ql=a(),_=h("p"),_.textContent=en,Nl=a(),L=h("p"),L.innerHTML=an,El=a(),p(D.$$.fragment),vl=a(),p(P.$$.fragment),Wl=a(),K=h("p"),K.innerHTML=nn,Al=a(),O=h("p"),O.innerHTML=pn,Yl=a(),p(ss.$$.fragment),Xl=a(),ts=h("p"),ts.textContent=on,Sl=a(),p(ls.$$.fragment),Vl=a(),p(es.$$.fragment),Rl=a(),as=h("p"),as.textContent=Mn,ql=a(),p(ns.$$.fragment),zl=a(),p(ps.$$.fragment),Fl=a(),is=h("p"),is.textContent=rn,Hl=a(),p(os.$$.fragment),_l=a(),p(Ms.$$.fragment),Ll=a(),rs=h("p"),rs.textContent=cn,Dl=a(),p(cs.$$.fragment),Pl=a(),p(hs.$$.fragment),Kl=a(),p(js.$$.fragment),Ol=a(),p(Js.$$.fragment),se=a(),ms=h("p"),ms.textContent=hn,te=a(),p(us.$$.fragment),le=a(),p(ys.$$.fragment),ee=a(),Ts=h("p"),Ts.textContent=jn,ae=a(),p(ws.$$.fragment),ne=a(),p(fs.$$.fragment),pe=a(),gs=h("p"),gs.textContent=Jn,ie=a(),p(ds.$$.fragment),oe=a(),p(Us.$$.fragment),Me=a(),Is=h("p"),Is.textContent=mn,re=a(),p(bs.$$.fragment),ce=a(),p($s.$$.fragment),he=a(),Cs=h("p"),Cs.textContent=un,je=a(),p(Bs.$$.fragment),Je=a(),p(xs.$$.fragment),me=a(),ks=h("p"),ks.textContent=yn,ue=a(),p(Zs.$$.fragment),ye=a(),p(Gs.$$.fragment),Te=a(),p(Qs.$$.fragment),we=a(),Ns=h("p"),Ns.textContent=Tn,fe=a(),Es=h("p"),Es.innerHTML=wn,ge=a(),p(vs.$$.fragment),de=a(),p(Ws.$$.fragment),Ue=a(),As=h("p"),As.textContent=fn,Ie=a(),Ys=h("p"),Ys.innerHTML=gn,be=a(),p(Xs.$$.fragment),$e=a(),p(Ss.$$.fragment),Ce=a(),Vs=h("p"),Vs.textContent=dn,Be=a(),Rs=h("p"),Rs.innerHTML=Un,xe=a(),p(qs.$$.fragment),ke=a(),p(zs.$$.fragment),Ze=a(),Fs=h("p"),Fs.textContent=In,Ge=a(),p(Hs.$$.fragment),Qe=a(),p(_s.$$.fragment),Ne=a(),p(Ls.$$.fragment),Ee=a(),Ds=h("p"),Ds.textContent=bn,ve=a(),Ps=h("p"),Ps.innerHTML=$n,We=a(),p(Ks.$$.fragment),Ae=a(),p(Os.$$.fragment),Ye=a(),st=h("p"),st.textContent=Cn,Xe=a(),tt=h("p"),tt.innerHTML=Bn,Se=a(),p(lt.$$.fragment),Ve=a(),p(et.$$.fragment),Re=a(),at=h("p"),at.textContent=xn,qe=a(),p(nt.$$.fragment),ze=a(),p(pt.$$.fragment),Fe=a(),it=h("p"),it.textContent=kn,He=a(),p(ot.$$.fragment),_e=a(),p(Mt.$$.fragment),Le=a(),rt=h("p"),rt.textContent=Zn,De=a(),ct=h("p"),ct.innerHTML=Gn,Pe=a(),p(ht.$$.fragment),Ke=a(),p(jt.$$.fragment),Oe=a(),Jt=h("p"),Jt.textContent=Qn,sa=a(),mt=h("p"),mt.innerHTML=Nn,ta=a(),p(ut.$$.fragment),la=a(),p(yt.$$.fragment),ea=a(),Tt=h("p"),Tt.textContent=En,aa=a(),p(wt.$$.fragment),na=a(),p(ft.$$.fragment),pa=a(),p(gt.$$.fragment),ia=a(),dt=h("p"),dt.textContent=vn,oa=a(),p(Ut.$$.fragment),Ma=a(),p(It.$$.fragment),ra=a(),bt=h("p"),bt.textContent=Wn,ca=a(),$t=h("p"),$t.innerHTML=An,ha=a(),p(Ct.$$.fragment),ja=a(),p(Bt.$$.fragment),Ja=a(),xt=h("p"),xt.textContent=Yn,ma=a(),kt=h("p"),kt.innerHTML=Xn,ua=a(),p(Zt.$$.fragment),ya=a(),p(Gt.$$.fragment),Ta=a(),p(Qt.$$.fragment),wa=a(),Nt=h("p"),Nt.textContent=Sn,fa=a(),p(Et.$$.fragment),ga=a(),p(vt.$$.fragment),da=a(),Wt=h("p"),Wt.textContent=Vn,Ua=a(),p(At.$$.fragment),Ia=a(),Yt=h("p"),Yt.innerHTML=Rn,ba=a(),p(Xt.$$.fragment),$a=a(),p(St.$$.fragment),Ca=a(),Vt=h("p"),Vt.innerHTML=qn,Ba=a(),p(Rt.$$.fragment),xa=a(),qt=h("p"),qt.innerHTML=zn,ka=a(),p(zt.$$.fragment),Za=a(),p(Ft.$$.fragment),Ga=a(),p(Ht.$$.fragment),Qa=a(),p(_t.$$.fragment),Na=a(),Lt=h("p"),Lt.innerHTML=Fn,Ea=a(),Dt=h("p"),Dt.textContent=Hn,va=a(),p(Pt.$$.fragment),Wa=a(),Kt=h("ul"),Kt.innerHTML=_n,Aa=a(),p(Ot.$$.fragment),Ya=a(),tl=h("p"),this.h()},l(s){const t=lp("svelte-u9bgzb",document.head);y=j(t,"META",{name:!0,content:!0}),t.forEach(l),ll=n(s),sl=j(s,"P",{}),Ln(sl).forEach(l),el=n(s),i(T.$$.fragment,s),al=n(s),w=j(s,"P",{"data-svelte-h":!0}),J(w)!=="svelte-b2bs3"&&(w.innerHTML=Va),nl=n(s),f=j(s,"P",{"data-svelte-h":!0}),J(f)!=="svelte-15l1k62"&&(f.innerHTML=Ra),pl=n(s),i(g.$$.fragment,s),il=n(s),i(d.$$.fragment,s),ol=n(s),i(U.$$.fragment,s),Ml=n(s),i(I.$$.fragment,s),rl=n(s),i(b.$$.fragment,s),cl=n(s),i($.$$.fragment,s),hl=n(s),i(C.$$.fragment,s),jl=n(s),i(B.$$.fragment,s),Jl=n(s),x=j(s,"P",{"data-svelte-h":!0}),J(x)!=="svelte-ys53zo"&&(x.innerHTML=qa),ml=n(s),k=j(s,"P",{"data-svelte-h":!0}),J(k)!=="svelte-2l8ybr"&&(k.textContent=za),ul=n(s),i(Z.$$.fragment,s),yl=n(s),G=j(s,"P",{"data-svelte-h":!0}),J(G)!=="svelte-jymwke"&&(G.textContent=Fa),Tl=n(s),Q=j(s,"P",{"data-svelte-h":!0}),J(Q)!=="svelte-10x65ih"&&(Q.textContent=Ha),wl=n(s),N=j(s,"UL",{"data-svelte-h":!0}),J(N)!=="svelte-123amn0"&&(N.innerHTML=_a),fl=n(s),E=j(s,"P",{"data-svelte-h":!0}),J(E)!=="svelte-10p6n92"&&(E.innerHTML=La),gl=n(s),i(v.$$.fragment,s),dl=n(s),W=j(s,"P",{"data-svelte-h":!0}),J(W)!=="svelte-chybr3"&&(W.innerHTML=Da),Ul=n(s),A=j(s,"P",{"data-svelte-h":!0}),J(A)!=="svelte-1q5o8lp"&&(A.textContent=Pa),Il=n(s),Y=j(s,"UL",{"data-svelte-h":!0}),J(Y)!=="svelte-19nggaq"&&(Y.innerHTML=Ka),bl=n(s),X=j(s,"P",{"data-svelte-h":!0}),J(X)!=="svelte-w24fai"&&(X.innerHTML=Oa),$l=n(s),S=j(s,"P",{"data-svelte-h":!0}),J(S)!=="svelte-anhj2e"&&(S.innerHTML=sn),Cl=n(s),i(V.$$.fragment,s),Bl=n(s),R=j(s,"P",{"data-svelte-h":!0}),J(R)!=="svelte-9hw06n"&&(R.innerHTML=tn),xl=n(s),i(q.$$.fragment,s),kl=n(s),z=j(s,"P",{"data-svelte-h":!0}),J(z)!=="svelte-88xj6h"&&(z.textContent=ln),Zl=n(s),i(F.$$.fragment,s),Gl=n(s),i(H.$$.fragment,s),Ql=n(s),_=j(s,"P",{"data-svelte-h":!0}),J(_)!=="svelte-18cimv4"&&(_.textContent=en),Nl=n(s),L=j(s,"P",{"data-svelte-h":!0}),J(L)!=="svelte-kjz90x"&&(L.innerHTML=an),El=n(s),i(D.$$.fragment,s),vl=n(s),i(P.$$.fragment,s),Wl=n(s),K=j(s,"P",{"data-svelte-h":!0}),J(K)!=="svelte-1jovdfa"&&(K.innerHTML=nn),Al=n(s),O=j(s,"P",{"data-svelte-h":!0}),J(O)!=="svelte-slg7wg"&&(O.innerHTML=pn),Yl=n(s),i(ss.$$.fragment,s),Xl=n(s),ts=j(s,"P",{"data-svelte-h":!0}),J(ts)!=="svelte-1daohkt"&&(ts.textContent=on),Sl=n(s),i(ls.$$.fragment,s),Vl=n(s),i(es.$$.fragment,s),Rl=n(s),as=j(s,"P",{"data-svelte-h":!0}),J(as)!=="svelte-1mnrr3b"&&(as.textContent=Mn),ql=n(s),i(ns.$$.fragment,s),zl=n(s),i(ps.$$.fragment,s),Fl=n(s),is=j(s,"P",{"data-svelte-h":!0}),J(is)!=="svelte-4s1xv3"&&(is.textContent=rn),Hl=n(s),i(os.$$.fragment,s),_l=n(s),i(Ms.$$.fragment,s),Ll=n(s),rs=j(s,"P",{"data-svelte-h":!0}),J(rs)!=="svelte-vnhv92"&&(rs.textContent=cn),Dl=n(s),i(cs.$$.fragment,s),Pl=n(s),i(hs.$$.fragment,s),Kl=n(s),i(js.$$.fragment,s),Ol=n(s),i(Js.$$.fragment,s),se=n(s),ms=j(s,"P",{"data-svelte-h":!0}),J(ms)!=="svelte-vlz10z"&&(ms.textContent=hn),te=n(s),i(us.$$.fragment,s),le=n(s),i(ys.$$.fragment,s),ee=n(s),Ts=j(s,"P",{"data-svelte-h":!0}),J(Ts)!=="svelte-qln4hq"&&(Ts.textContent=jn),ae=n(s),i(ws.$$.fragment,s),ne=n(s),i(fs.$$.fragment,s),pe=n(s),gs=j(s,"P",{"data-svelte-h":!0}),J(gs)!=="svelte-yinzpl"&&(gs.textContent=Jn),ie=n(s),i(ds.$$.fragment,s),oe=n(s),i(Us.$$.fragment,s),Me=n(s),Is=j(s,"P",{"data-svelte-h":!0}),J(Is)!=="svelte-mqluby"&&(Is.textContent=mn),re=n(s),i(bs.$$.fragment,s),ce=n(s),i($s.$$.fragment,s),he=n(s),Cs=j(s,"P",{"data-svelte-h":!0}),J(Cs)!=="svelte-1wq8md5"&&(Cs.textContent=un),je=n(s),i(Bs.$$.fragment,s),Je=n(s),i(xs.$$.fragment,s),me=n(s),ks=j(s,"P",{"data-svelte-h":!0}),J(ks)!=="svelte-tf7teq"&&(ks.textContent=yn),ue=n(s),i(Zs.$$.fragment,s),ye=n(s),i(Gs.$$.fragment,s),Te=n(s),i(Qs.$$.fragment,s),we=n(s),Ns=j(s,"P",{"data-svelte-h":!0}),J(Ns)!=="svelte-1in7idl"&&(Ns.textContent=Tn),fe=n(s),Es=j(s,"P",{"data-svelte-h":!0}),J(Es)!=="svelte-18afluh"&&(Es.innerHTML=wn),ge=n(s),i(vs.$$.fragment,s),de=n(s),i(Ws.$$.fragment,s),Ue=n(s),As=j(s,"P",{"data-svelte-h":!0}),J(As)!=="svelte-12s1din"&&(As.textContent=fn),Ie=n(s),Ys=j(s,"P",{"data-svelte-h":!0}),J(Ys)!=="svelte-1jpdfy8"&&(Ys.innerHTML=gn),be=n(s),i(Xs.$$.fragment,s),$e=n(s),i(Ss.$$.fragment,s),Ce=n(s),Vs=j(s,"P",{"data-svelte-h":!0}),J(Vs)!=="svelte-1h8ubig"&&(Vs.textContent=dn),Be=n(s),Rs=j(s,"P",{"data-svelte-h":!0}),J(Rs)!=="svelte-1edrfzt"&&(Rs.innerHTML=Un),xe=n(s),i(qs.$$.fragment,s),ke=n(s),i(zs.$$.fragment,s),Ze=n(s),Fs=j(s,"P",{"data-svelte-h":!0}),J(Fs)!=="svelte-zj5o06"&&(Fs.textContent=In),Ge=n(s),i(Hs.$$.fragment,s),Qe=n(s),i(_s.$$.fragment,s),Ne=n(s),i(Ls.$$.fragment,s),Ee=n(s),Ds=j(s,"P",{"data-svelte-h":!0}),J(Ds)!=="svelte-1nlp89w"&&(Ds.textContent=bn),ve=n(s),Ps=j(s,"P",{"data-svelte-h":!0}),J(Ps)!=="svelte-10vvvxx"&&(Ps.innerHTML=$n),We=n(s),i(Ks.$$.fragment,s),Ae=n(s),i(Os.$$.fragment,s),Ye=n(s),st=j(s,"P",{"data-svelte-h":!0}),J(st)!=="svelte-d15mev"&&(st.textContent=Cn),Xe=n(s),tt=j(s,"P",{"data-svelte-h":!0}),J(tt)!=="svelte-pxrbuw"&&(tt.innerHTML=Bn),Se=n(s),i(lt.$$.fragment,s),Ve=n(s),i(et.$$.fragment,s),Re=n(s),at=j(s,"P",{"data-svelte-h":!0}),J(at)!=="svelte-1oenl8f"&&(at.textContent=xn),qe=n(s),i(nt.$$.fragment,s),ze=n(s),i(pt.$$.fragment,s),Fe=n(s),it=j(s,"P",{"data-svelte-h":!0}),J(it)!=="svelte-66badz"&&(it.textContent=kn),He=n(s),i(ot.$$.fragment,s),_e=n(s),i(Mt.$$.fragment,s),Le=n(s),rt=j(s,"P",{"data-svelte-h":!0}),J(rt)!=="svelte-13iv3hh"&&(rt.textContent=Zn),De=n(s),ct=j(s,"P",{"data-svelte-h":!0}),J(ct)!=="svelte-1mgyz4r"&&(ct.innerHTML=Gn),Pe=n(s),i(ht.$$.fragment,s),Ke=n(s),i(jt.$$.fragment,s),Oe=n(s),Jt=j(s,"P",{"data-svelte-h":!0}),J(Jt)!=="svelte-1y7kqaa"&&(Jt.textContent=Qn),sa=n(s),mt=j(s,"P",{"data-svelte-h":!0}),J(mt)!=="svelte-m8xmew"&&(mt.innerHTML=Nn),ta=n(s),i(ut.$$.fragment,s),la=n(s),i(yt.$$.fragment,s),ea=n(s),Tt=j(s,"P",{"data-svelte-h":!0}),J(Tt)!=="svelte-m7q2yg"&&(Tt.textContent=En),aa=n(s),i(wt.$$.fragment,s),na=n(s),i(ft.$$.fragment,s),pa=n(s),i(gt.$$.fragment,s),ia=n(s),dt=j(s,"P",{"data-svelte-h":!0}),J(dt)!=="svelte-174b8m1"&&(dt.textContent=vn),oa=n(s),i(Ut.$$.fragment,s),Ma=n(s),i(It.$$.fragment,s),ra=n(s),bt=j(s,"P",{"data-svelte-h":!0}),J(bt)!=="svelte-cnruui"&&(bt.textContent=Wn),ca=n(s),$t=j(s,"P",{"data-svelte-h":!0}),J($t)!=="svelte-hwgezm"&&($t.innerHTML=An),ha=n(s),i(Ct.$$.fragment,s),ja=n(s),i(Bt.$$.fragment,s),Ja=n(s),xt=j(s,"P",{"data-svelte-h":!0}),J(xt)!=="svelte-1tpexz3"&&(xt.textContent=Yn),ma=n(s),kt=j(s,"P",{"data-svelte-h":!0}),J(kt)!=="svelte-hwgezm"&&(kt.innerHTML=Xn),ua=n(s),i(Zt.$$.fragment,s),ya=n(s),i(Gt.$$.fragment,s),Ta=n(s),i(Qt.$$.fragment,s),wa=n(s),Nt=j(s,"P",{"data-svelte-h":!0}),J(Nt)!=="svelte-1js246c"&&(Nt.textContent=Sn),fa=n(s),i(Et.$$.fragment,s),ga=n(s),i(vt.$$.fragment,s),da=n(s),Wt=j(s,"P",{"data-svelte-h":!0}),J(Wt)!=="svelte-7l7zu1"&&(Wt.textContent=Vn),Ua=n(s),i(At.$$.fragment,s),Ia=n(s),Yt=j(s,"P",{"data-svelte-h":!0}),J(Yt)!=="svelte-cw0lq3"&&(Yt.innerHTML=Rn),ba=n(s),i(Xt.$$.fragment,s),$a=n(s),i(St.$$.fragment,s),Ca=n(s),Vt=j(s,"P",{"data-svelte-h":!0}),J(Vt)!=="svelte-14q869u"&&(Vt.innerHTML=qn),Ba=n(s),i(Rt.$$.fragment,s),xa=n(s),qt=j(s,"P",{"data-svelte-h":!0}),J(qt)!=="svelte-16znzc1"&&(qt.innerHTML=zn),ka=n(s),i(zt.$$.fragment,s),Za=n(s),i(Ft.$$.fragment,s),Ga=n(s),i(Ht.$$.fragment,s),Qa=n(s),i(_t.$$.fragment,s),Na=n(s),Lt=j(s,"P",{"data-svelte-h":!0}),J(Lt)!=="svelte-62a9et"&&(Lt.innerHTML=Fn),Ea=n(s),Dt=j(s,"P",{"data-svelte-h":!0}),J(Dt)!=="svelte-1yyf4wc"&&(Dt.textContent=Hn),va=n(s),i(Pt.$$.fragment,s),Wa=n(s),Kt=j(s,"UL",{"data-svelte-h":!0}),J(Kt)!=="svelte-mopwlb"&&(Kt.innerHTML=_n),Aa=n(s),i(Ot.$$.fragment,s),Ya=n(s),tl=j(s,"P",{}),Ln(tl).forEach(l),this.h()},h(){Dn(y,"name","hf:doc:metadata"),Dn(y,"content",pp)},m(s,t){ep(document.head,y),e(s,ll,t),e(s,sl,t),e(s,el,t),o(T,s,t),e(s,al,t),e(s,w,t),e(s,nl,t),e(s,f,t),e(s,pl,t),o(g,s,t),e(s,il,t),o(d,s,t),e(s,ol,t),o(U,s,t),e(s,Ml,t),o(I,s,t),e(s,rl,t),o(b,s,t),e(s,cl,t),o($,s,t),e(s,hl,t),o(C,s,t),e(s,jl,t),o(B,s,t),e(s,Jl,t),e(s,x,t),e(s,ml,t),e(s,k,t),e(s,ul,t),o(Z,s,t),e(s,yl,t),e(s,G,t),e(s,Tl,t),e(s,Q,t),e(s,wl,t),e(s,N,t),e(s,fl,t),e(s,E,t),e(s,gl,t),o(v,s,t),e(s,dl,t),e(s,W,t),e(s,Ul,t),e(s,A,t),e(s,Il,t),e(s,Y,t),e(s,bl,t),e(s,X,t),e(s,$l,t),e(s,S,t),e(s,Cl,t),o(V,s,t),e(s,Bl,t),e(s,R,t),e(s,xl,t),o(q,s,t),e(s,kl,t),e(s,z,t),e(s,Zl,t),o(F,s,t),e(s,Gl,t),o(H,s,t),e(s,Ql,t),e(s,_,t),e(s,Nl,t),e(s,L,t),e(s,El,t),o(D,s,t),e(s,vl,t),o(P,s,t),e(s,Wl,t),e(s,K,t),e(s,Al,t),e(s,O,t),e(s,Yl,t),o(ss,s,t),e(s,Xl,t),e(s,ts,t),e(s,Sl,t),o(ls,s,t),e(s,Vl,t),o(es,s,t),e(s,Rl,t),e(s,as,t),e(s,ql,t),o(ns,s,t),e(s,zl,t),o(ps,s,t),e(s,Fl,t),e(s,is,t),e(s,Hl,t),o(os,s,t),e(s,_l,t),o(Ms,s,t),e(s,Ll,t),e(s,rs,t),e(s,Dl,t),o(cs,s,t),e(s,Pl,t),o(hs,s,t),e(s,Kl,t),o(js,s,t),e(s,Ol,t),o(Js,s,t),e(s,se,t),e(s,ms,t),e(s,te,t),o(us,s,t),e(s,le,t),o(ys,s,t),e(s,ee,t),e(s,Ts,t),e(s,ae,t),o(ws,s,t),e(s,ne,t),o(fs,s,t),e(s,pe,t),e(s,gs,t),e(s,ie,t),o(ds,s,t),e(s,oe,t),o(Us,s,t),e(s,Me,t),e(s,Is,t),e(s,re,t),o(bs,s,t),e(s,ce,t),o($s,s,t),e(s,he,t),e(s,Cs,t),e(s,je,t),o(Bs,s,t),e(s,Je,t),o(xs,s,t),e(s,me,t),e(s,ks,t),e(s,ue,t),o(Zs,s,t),e(s,ye,t),o(Gs,s,t),e(s,Te,t),o(Qs,s,t),e(s,we,t),e(s,Ns,t),e(s,fe,t),e(s,Es,t),e(s,ge,t),o(vs,s,t),e(s,de,t),o(Ws,s,t),e(s,Ue,t),e(s,As,t),e(s,Ie,t),e(s,Ys,t),e(s,be,t),o(Xs,s,t),e(s,$e,t),o(Ss,s,t),e(s,Ce,t),e(s,Vs,t),e(s,Be,t),e(s,Rs,t),e(s,xe,t),o(qs,s,t),e(s,ke,t),o(zs,s,t),e(s,Ze,t),e(s,Fs,t),e(s,Ge,t),o(Hs,s,t),e(s,Qe,t),o(_s,s,t),e(s,Ne,t),o(Ls,s,t),e(s,Ee,t),e(s,Ds,t),e(s,ve,t),e(s,Ps,t),e(s,We,t),o(Ks,s,t),e(s,Ae,t),o(Os,s,t),e(s,Ye,t),e(s,st,t),e(s,Xe,t),e(s,tt,t),e(s,Se,t),o(lt,s,t),e(s,Ve,t),o(et,s,t),e(s,Re,t),e(s,at,t),e(s,qe,t),o(nt,s,t),e(s,ze,t),o(pt,s,t),e(s,Fe,t),e(s,it,t),e(s,He,t),o(ot,s,t),e(s,_e,t),o(Mt,s,t),e(s,Le,t),e(s,rt,t),e(s,De,t),e(s,ct,t),e(s,Pe,t),o(ht,s,t),e(s,Ke,t),o(jt,s,t),e(s,Oe,t),e(s,Jt,t),e(s,sa,t),e(s,mt,t),e(s,ta,t),o(ut,s,t),e(s,la,t),o(yt,s,t),e(s,ea,t),e(s,Tt,t),e(s,aa,t),o(wt,s,t),e(s,na,t),o(ft,s,t),e(s,pa,t),o(gt,s,t),e(s,ia,t),e(s,dt,t),e(s,oa,t),o(Ut,s,t),e(s,Ma,t),o(It,s,t),e(s,ra,t),e(s,bt,t),e(s,ca,t),e(s,$t,t),e(s,ha,t),o(Ct,s,t),e(s,ja,t),o(Bt,s,t),e(s,Ja,t),e(s,xt,t),e(s,ma,t),e(s,kt,t),e(s,ua,t),o(Zt,s,t),e(s,ya,t),o(Gt,s,t),e(s,Ta,t),o(Qt,s,t),e(s,wa,t),e(s,Nt,t),e(s,fa,t),o(Et,s,t),e(s,ga,t),o(vt,s,t),e(s,da,t),e(s,Wt,t),e(s,Ua,t),o(At,s,t),e(s,Ia,t),e(s,Yt,t),e(s,ba,t),o(Xt,s,t),e(s,$a,t),o(St,s,t),e(s,Ca,t),e(s,Vt,t),e(s,Ba,t),o(Rt,s,t),e(s,xa,t),e(s,qt,t),e(s,ka,t),o(zt,s,t),e(s,Za,t),o(Ft,s,t),e(s,Ga,t),o(Ht,s,t),e(s,Qa,t),o(_t,s,t),e(s,Na,t),e(s,Lt,t),e(s,Ea,t),e(s,Dt,t),e(s,va,t),o(Pt,s,t),e(s,Wa,t),e(s,Kt,t),e(s,Aa,t),o(Ot,s,t),e(s,Ya,t),e(s,tl,t),Xa=!0},p:Kn,i(s){Xa||(M(T.$$.fragment,s),M(g.$$.fragment,s),M(d.$$.fragment,s),M(U.$$.fragment,s),M(I.$$.fragment,s),M(b.$$.fragment,s),M($.$$.fragment,s),M(C.$$.fragment,s),M(B.$$.fragment,s),M(Z.$$.fragment,s),M(v.$$.fragment,s),M(V.$$.fragment,s),M(q.$$.fragment,s),M(F.$$.fragment,s),M(H.$$.fragment,s),M(D.$$.fragment,s),M(P.$$.fragment,s),M(ss.$$.fragment,s),M(ls.$$.fragment,s),M(es.$$.fragment,s),M(ns.$$.fragment,s),M(ps.$$.fragment,s),M(os.$$.fragment,s),M(Ms.$$.fragment,s),M(cs.$$.fragment,s),M(hs.$$.fragment,s),M(js.$$.fragment,s),M(Js.$$.fragment,s),M(us.$$.fragment,s),M(ys.$$.fragment,s),M(ws.$$.fragment,s),M(fs.$$.fragment,s),M(ds.$$.fragment,s),M(Us.$$.fragment,s),M(bs.$$.fragment,s),M($s.$$.fragment,s),M(Bs.$$.fragment,s),M(xs.$$.fragment,s),M(Zs.$$.fragment,s),M(Gs.$$.fragment,s),M(Qs.$$.fragment,s),M(vs.$$.fragment,s),M(Ws.$$.fragment,s),M(Xs.$$.fragment,s),M(Ss.$$.fragment,s),M(qs.$$.fragment,s),M(zs.$$.fragment,s),M(Hs.$$.fragment,s),M(_s.$$.fragment,s),M(Ls.$$.fragment,s),M(Ks.$$.fragment,s),M(Os.$$.fragment,s),M(lt.$$.fragment,s),M(et.$$.fragment,s),M(nt.$$.fragment,s),M(pt.$$.fragment,s),M(ot.$$.fragment,s),M(Mt.$$.fragment,s),M(ht.$$.fragment,s),M(jt.$$.fragment,s),M(ut.$$.fragment,s),M(yt.$$.fragment,s),M(wt.$$.fragment,s),M(ft.$$.fragment,s),M(gt.$$.fragment,s),M(Ut.$$.fragment,s),M(It.$$.fragment,s),M(Ct.$$.fragment,s),M(Bt.$$.fragment,s),M(Zt.$$.fragment,s),M(Gt.$$.fragment,s),M(Qt.$$.fragment,s),M(Et.$$.fragment,s),M(vt.$$.fragment,s),M(At.$$.fragment,s),M(Xt.$$.fragment,s),M(St.$$.fragment,s),M(Rt.$$.fragment,s),M(zt.$$.fragment,s),M(Ft.$$.fragment,s),M(Ht.$$.fragment,s),M(_t.$$.fragment,s),M(Pt.$$.fragment,s),M(Ot.$$.fragment,s),Xa=!0)},o(s){r(T.$$.fragment,s),r(g.$$.fragment,s),r(d.$$.fragment,s),r(U.$$.fragment,s),r(I.$$.fragment,s),r(b.$$.fragment,s),r($.$$.fragment,s),r(C.$$.fragment,s),r(B.$$.fragment,s),r(Z.$$.fragment,s),r(v.$$.fragment,s),r(V.$$.fragment,s),r(q.$$.fragment,s),r(F.$$.fragment,s),r(H.$$.fragment,s),r(D.$$.fragment,s),r(P.$$.fragment,s),r(ss.$$.fragment,s),r(ls.$$.fragment,s),r(es.$$.fragment,s),r(ns.$$.fragment,s),r(ps.$$.fragment,s),r(os.$$.fragment,s),r(Ms.$$.fragment,s),r(cs.$$.fragment,s),r(hs.$$.fragment,s),r(js.$$.fragment,s),r(Js.$$.fragment,s),r(us.$$.fragment,s),r(ys.$$.fragment,s),r(ws.$$.fragment,s),r(fs.$$.fragment,s),r(ds.$$.fragment,s),r(Us.$$.fragment,s),r(bs.$$.fragment,s),r($s.$$.fragment,s),r(Bs.$$.fragment,s),r(xs.$$.fragment,s),r(Zs.$$.fragment,s),r(Gs.$$.fragment,s),r(Qs.$$.fragment,s),r(vs.$$.fragment,s),r(Ws.$$.fragment,s),r(Xs.$$.fragment,s),r(Ss.$$.fragment,s),r(qs.$$.fragment,s),r(zs.$$.fragment,s),r(Hs.$$.fragment,s),r(_s.$$.fragment,s),r(Ls.$$.fragment,s),r(Ks.$$.fragment,s),r(Os.$$.fragment,s),r(lt.$$.fragment,s),r(et.$$.fragment,s),r(nt.$$.fragment,s),r(pt.$$.fragment,s),r(ot.$$.fragment,s),r(Mt.$$.fragment,s),r(ht.$$.fragment,s),r(jt.$$.fragment,s),r(ut.$$.fragment,s),r(yt.$$.fragment,s),r(wt.$$.fragment,s),r(ft.$$.fragment,s),r(gt.$$.fragment,s),r(Ut.$$.fragment,s),r(It.$$.fragment,s),r(Ct.$$.fragment,s),r(Bt.$$.fragment,s),r(Zt.$$.fragment,s),r(Gt.$$.fragment,s),r(Qt.$$.fragment,s),r(Et.$$.fragment,s),r(vt.$$.fragment,s),r(At.$$.fragment,s),r(Xt.$$.fragment,s),r(St.$$.fragment,s),r(Rt.$$.fragment,s),r(zt.$$.fragment,s),r(Ft.$$.fragment,s),r(Ht.$$.fragment,s),r(_t.$$.fragment,s),r(Pt.$$.fragment,s),r(Ot.$$.fragment,s),Xa=!1},d(s){s&&(l(ll),l(sl),l(el),l(al),l(w),l(nl),l(f),l(pl),l(il),l(ol),l(Ml),l(rl),l(cl),l(hl),l(jl),l(Jl),l(x),l(ml),l(k),l(ul),l(yl),l(G),l(Tl),l(Q),l(wl),l(N),l(fl),l(E),l(gl),l(dl),l(W),l(Ul),l(A),l(Il),l(Y),l(bl),l(X),l($l),l(S),l(Cl),l(Bl),l(R),l(xl),l(kl),l(z),l(Zl),l(Gl),l(Ql),l(_),l(Nl),l(L),l(El),l(vl),l(Wl),l(K),l(Al),l(O),l(Yl),l(Xl),l(ts),l(Sl),l(Vl),l(Rl),l(as),l(ql),l(zl),l(Fl),l(is),l(Hl),l(_l),l(Ll),l(rs),l(Dl),l(Pl),l(Kl),l(Ol),l(se),l(ms),l(te),l(le),l(ee),l(Ts),l(ae),l(ne),l(pe),l(gs),l(ie),l(oe),l(Me),l(Is),l(re),l(ce),l(he),l(Cs),l(je),l(Je),l(me),l(ks),l(ue),l(ye),l(Te),l(we),l(Ns),l(fe),l(Es),l(ge),l(de),l(Ue),l(As),l(Ie),l(Ys),l(be),l($e),l(Ce),l(Vs),l(Be),l(Rs),l(xe),l(ke),l(Ze),l(Fs),l(Ge),l(Qe),l(Ne),l(Ee),l(Ds),l(ve),l(Ps),l(We),l(Ae),l(Ye),l(st),l(Xe),l(tt),l(Se),l(Ve),l(Re),l(at),l(qe),l(ze),l(Fe),l(it),l(He),l(_e),l(Le),l(rt),l(De),l(ct),l(Pe),l(Ke),l(Oe),l(Jt),l(sa),l(mt),l(ta),l(la),l(ea),l(Tt),l(aa),l(na),l(pa),l(ia),l(dt),l(oa),l(Ma),l(ra),l(bt),l(ca),l($t),l(ha),l(ja),l(Ja),l(xt),l(ma),l(kt),l(ua),l(ya),l(Ta),l(wa),l(Nt),l(fa),l(ga),l(da),l(Wt),l(Ua),l(Ia),l(Yt),l(ba),l($a),l(Ca),l(Vt),l(Ba),l(xa),l(qt),l(ka),l(Za),l(Ga),l(Qa),l(Na),l(Lt),l(Ea),l(Dt),l(va),l(Wa),l(Kt),l(Aa),l(Ya),l(tl)),l(y),c(T,s),c(g,s),c(d,s),c(U,s),c(I,s),c(b,s),c($,s),c(C,s),c(B,s),c(Z,s),c(v,s),c(V,s),c(q,s),c(F,s),c(H,s),c(D,s),c(P,s),c(ss,s),c(ls,s),c(es,s),c(ns,s),c(ps,s),c(os,s),c(Ms,s),c(cs,s),c(hs,s),c(js,s),c(Js,s),c(us,s),c(ys,s),c(ws,s),c(fs,s),c(ds,s),c(Us,s),c(bs,s),c($s,s),c(Bs,s),c(xs,s),c(Zs,s),c(Gs,s),c(Qs,s),c(vs,s),c(Ws,s),c(Xs,s),c(Ss,s),c(qs,s),c(zs,s),c(Hs,s),c(_s,s),c(Ls,s),c(Ks,s),c(Os,s),c(lt,s),c(et,s),c(nt,s),c(pt,s),c(ot,s),c(Mt,s),c(ht,s),c(jt,s),c(ut,s),c(yt,s),c(wt,s),c(ft,s),c(gt,s),c(Ut,s),c(It,s),c(Ct,s),c(Bt,s),c(Zt,s),c(Gt,s),c(Qt,s),c(Et,s),c(vt,s),c(At,s),c(Xt,s),c(St,s),c(Rt,s),c(zt,s),c(Ft,s),c(Ht,s),c(_t,s),c(Pt,s),c(Ot,s)}}}const pp='{"title":"🤗 Hugging Face Inference","local":"-hugging-face-inference","sections":[{"title":"Getting Started","local":"getting-started","sections":[{"title":"Install","local":"install","sections":[{"title":"Node","local":"node","sections":[],"depth":4},{"title":"Deno","local":"deno","sections":[],"depth":4}],"depth":3},{"title":"Initialize","local":"initialize","sections":[],"depth":3},{"title":"All supported inference providers","local":"all-supported-inference-providers","sections":[],"depth":3},{"title":"Tree-shaking","local":"tree-shaking","sections":[],"depth":3}],"depth":2},{"title":"Natural Language Processing","local":"natural-language-processing","sections":[{"title":"Text Generation","local":"text-generation","sections":[],"depth":3},{"title":"Text Generation (Chat Completion API Compatible)","local":"text-generation-chat-completion-api-compatible","sections":[],"depth":3},{"title":"Fill Mask","local":"fill-mask","sections":[],"depth":3},{"title":"Summarization","local":"summarization","sections":[],"depth":3},{"title":"Question Answering","local":"question-answering","sections":[],"depth":3},{"title":"Table Question Answering","local":"table-question-answering","sections":[],"depth":3},{"title":"Text Classification","local":"text-classification","sections":[],"depth":3},{"title":"Token Classification","local":"token-classification","sections":[],"depth":3},{"title":"Translation","local":"translation","sections":[],"depth":3},{"title":"Zero-Shot Classification","local":"zero-shot-classification","sections":[],"depth":3},{"title":"Conversational","local":"conversational","sections":[],"depth":3},{"title":"Sentence Similarity","local":"sentence-similarity","sections":[],"depth":3}],"depth":2},{"title":"Audio","local":"audio","sections":[{"title":"Automatic Speech Recognition","local":"automatic-speech-recognition","sections":[],"depth":3},{"title":"Audio Classification","local":"audio-classification","sections":[],"depth":3},{"title":"Text To Speech","local":"text-to-speech","sections":[],"depth":3},{"title":"Audio To Audio","local":"audio-to-audio","sections":[],"depth":3}],"depth":2},{"title":"Computer Vision","local":"computer-vision","sections":[{"title":"Image Classification","local":"image-classification","sections":[],"depth":3},{"title":"Object Detection","local":"object-detection","sections":[],"depth":3},{"title":"Image Segmentation","local":"image-segmentation","sections":[],"depth":3},{"title":"Image To Text","local":"image-to-text","sections":[],"depth":3},{"title":"Text To Image","local":"text-to-image","sections":[],"depth":3},{"title":"Image To Image","local":"image-to-image","sections":[],"depth":3},{"title":"Zero Shot Image Classification","local":"zero-shot-image-classification","sections":[],"depth":3}],"depth":2},{"title":"Multimodal","local":"multimodal","sections":[{"title":"Feature Extraction","local":"feature-extraction","sections":[],"depth":3},{"title":"Visual Question Answering","local":"visual-question-answering","sections":[],"depth":3},{"title":"Document Question Answering","local":"document-question-answering","sections":[],"depth":3}],"depth":2},{"title":"Tabular","local":"tabular","sections":[{"title":"Tabular Regression","local":"tabular-regression","sections":[],"depth":3},{"title":"Tabular Classification","local":"tabular-classification","sections":[],"depth":3}],"depth":2},{"title":"Custom Inference Endpoints","local":"custom-inference-endpoints","sections":[],"depth":2},{"title":"Running tests","local":"running-tests","sections":[],"depth":2},{"title":"Finding appropriate models","local":"finding-appropriate-models","sections":[],"depth":2},{"title":"Dependencies","local":"dependencies","sections":[],"depth":2}],"depth":1}';function ip(Sa){return On(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class hp extends sp{constructor(y){super(),tp(this,y,ip,np,Pn,{})}}export{hp as component};
