import{s as jt,f as Ct,o as It,n as Se}from"../chunks/scheduler.25b97de1.js";import{S as Dt,i as zt,g as l,s as a,r as g,A as Jt,h as d,f as o,c as r,j as de,u as f,x as h,k as J,y as m,a as n,v as u,d as _,t as b,w as y}from"../chunks/index.d9030fc9.js";import{T as vt}from"../chunks/Tip.baa67368.js";import{D as ye}from"../chunks/Docstring.ffac8efa.js";import{C as Le}from"../chunks/CodeBlock.e6cd0d95.js";import{E as Zt}from"../chunks/ExampleCodeBlock.22dfe688.js";import{H as ce,E as Ut}from"../chunks/EditOnGithub.91d95064.js";function kt(z){let i,M='In the <a href="https://github.com/isl-org/ZoeDepth/blob/edb6daf45458569e24f50250ef1ed08c015f17a7/zoedepth/models/depth_model.py#L131">original implementation</a> ZoeDepth model performs inference on both the original and flipped images and averages out the results. The <code>post_process_depth_estimation</code> function can handle this for us by passing the flipped outputs to the optional <code>outputs_flipped</code> argument:',p,c,w=`<code class="language-Python">&gt;&gt;&gt; with torch.no_grad():   
...     outputs = model(pixel_values)
...     outputs_flipped = model(pixel_values=torch.flip(inputs.pixel_values, dims=[3]))
&gt;&gt;&gt; post_processed_output = image_processor.post_process_depth_estimation(
...     outputs,
...     source_sizes=[(image.height, image.width)],
...     outputs_flipped=outputs_flipped,
... )
</code>`;return{c(){i=l("p"),i.innerHTML=M,p=a(),c=l("pre"),c.innerHTML=w},l(s){i=d(s,"P",{"data-svelte-h":!0}),h(i)!=="svelte-1uajjwo"&&(i.innerHTML=M),p=r(s),c=d(s,"PRE",{"data-svelte-h":!0}),h(c)!=="svelte-1oycc4w"&&(c.innerHTML=w)},m(s,T){n(s,i,T),n(s,p,T),n(s,c,T)},p:Se,d(s){s&&(o(i),o(p),o(c))}}}function $t(z){let i,M="Example:",p,c,w;return c=new Le({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFpvZURlcHRoQ29uZmlnJTJDJTIwWm9lRGVwdGhGb3JEZXB0aEVzdGltYXRpb24lMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwWm9lRGVwdGglMjB6b2VkZXB0aC1sYXJnZSUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBab2VEZXB0aENvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMHpvZWRlcHRoLWxhcmdlJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBab2VEZXB0aEZvckRlcHRoRXN0aW1hdGlvbihjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ZoeDepthConfig, ZoeDepthForDepthEstimation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a ZoeDepth zoedepth-large style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = ZoeDepthConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the zoedepth-large style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ZoeDepthForDepthEstimation(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){i=l("p"),i.textContent=M,p=a(),g(c.$$.fragment)},l(s){i=d(s,"P",{"data-svelte-h":!0}),h(i)!=="svelte-11lpom8"&&(i.textContent=M),p=r(s),f(c.$$.fragment,s)},m(s,T){n(s,i,T),n(s,p,T),u(c,s,T),w=!0},p:Se,i(s){w||(_(c.$$.fragment,s),w=!0)},o(s){b(c.$$.fragment,s),w=!1},d(s){s&&(o(i),o(p)),y(c,s)}}}function xt(z){let i,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){i=l("p"),i.innerHTML=M},l(p){i=d(p,"P",{"data-svelte-h":!0}),h(i)!=="svelte-fincs2"&&(i.innerHTML=M)},m(p,c){n(p,i,c)},p:Se,d(p){p&&o(i)}}}function Rt(z){let i,M="Examples:",p,c,w;return c=new Le({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFpvZURlcHRoRm9yRGVwdGhFc3RpbWF0aW9uJTBBaW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMkludGVsJTJGem9lZGVwdGgtbnl1LWtpdHRpJTIyKSUwQW1vZGVsJTIwJTNEJTIwWm9lRGVwdGhGb3JEZXB0aEVzdGltYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMkludGVsJTJGem9lZGVwdGgtbnl1LWtpdHRpJTIyKSUwQSUwQSUyMyUyMHByZXBhcmUlMjBpbWFnZSUyMGZvciUyMHRoZSUyMG1vZGVsJTBBaW5wdXRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQSUyMyUyMGludGVycG9sYXRlJTIwdG8lMjBvcmlnaW5hbCUyMHNpemUlMEFwb3N0X3Byb2Nlc3NlZF9vdXRwdXQlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IucG9zdF9wcm9jZXNzX2RlcHRoX2VzdGltYXRpb24oJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyQyUwQSUyMCUyMCUyMCUyMHNvdXJjZV9zaXplcyUzRCU1QihpbWFnZS5oZWlnaHQlMkMlMjBpbWFnZS53aWR0aCklNUQlMkMlMEEpJTBBJTBBJTIzJTIwdmlzdWFsaXplJTIwdGhlJTIwcHJlZGljdGlvbiUwQXByZWRpY3RlZF9kZXB0aCUyMCUzRCUyMHBvc3RfcHJvY2Vzc2VkX291dHB1dCU1QjAlNUQlNUIlMjJwcmVkaWN0ZWRfZGVwdGglMjIlNUQlMEFkZXB0aCUyMCUzRCUyMHByZWRpY3RlZF9kZXB0aCUyMColMjAyNTUlMjAlMkYlMjBwcmVkaWN0ZWRfZGVwdGgubWF4KCklMEFkZXB0aCUyMCUzRCUyMGRlcHRoLmRldGFjaCgpLmNwdSgpLm51bXB5KCklMEFkZXB0aCUyMCUzRCUyMEltYWdlLmZyb21hcnJheShkZXB0aC5hc3R5cGUoJTIydWludDglMjIpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, ZoeDepthForDepthEstimation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;Intel/zoedepth-nyu-kitti&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ZoeDepthForDepthEstimation.from_pretrained(<span class="hljs-string">&quot;Intel/zoedepth-nyu-kitti&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare image for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># interpolate to original size</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>post_processed_output = image_processor.post_process_depth_estimation(
<span class="hljs-meta">... </span>    outputs,
<span class="hljs-meta">... </span>    source_sizes=[(image.height, image.width)],
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># visualize the prediction</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_depth = post_processed_output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;predicted_depth&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = predicted_depth * <span class="hljs-number">255</span> / predicted_depth.<span class="hljs-built_in">max</span>()
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = depth.detach().cpu().numpy()
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = Image.fromarray(depth.astype(<span class="hljs-string">&quot;uint8&quot;</span>))`,wrap:!1}}),{c(){i=l("p"),i.textContent=M,p=a(),g(c.$$.fragment)},l(s){i=d(s,"P",{"data-svelte-h":!0}),h(i)!=="svelte-kvfsh7"&&(i.textContent=M),p=r(s),f(c.$$.fragment,s)},m(s,T){n(s,i,T),n(s,p,T),u(c,s,T),w=!0},p:Se,i(s){w||(_(c.$$.fragment,s),w=!0)},o(s){b(c.$$.fragment,s),w=!1},d(s){s&&(o(i),o(p)),y(c,s)}}}function Wt(z){let i,M,p,c,w,s,T,we,B,at='The ZoeDepth model was proposed in <a href="https://arxiv.org/abs/2302.12288" rel="nofollow">ZoeDepth: Zero-shot Transfer by Combining Relative and Metric Depth</a> by Shariq Farooq Bhat, Reiner Birkl, Diana Wofk, Peter Wonka, Matthias Müller. ZoeDepth extends the <a href="dpt">DPT</a> framework for metric (also called absolute) depth estimation. ZoeDepth is pre-trained on 12 datasets using relative depth and fine-tuned on two domains (NYU and KITTI) using metric depth. A lightweight head is used with a novel bin adjustment design called metric bins module for each domain. During inference, each input image is automatically routed to the appropriate head using a latent classifier.',Te,E,rt="The abstract from the paper is the following:",Me,V,it="<em>This paper tackles the problem of depth estimation from a single image. Existing work either focuses on generalization performance disregarding metric scale, i.e. relative depth estimation, or state-of-the-art results on specific datasets, i.e. metric depth estimation. We propose the first approach that combines both worlds, leading to a model with excellent generalization performance while maintaining metric scale. Our flagship model, ZoeD-M12-NK, is pre-trained on 12 datasets using relative depth and fine-tuned on two datasets using metric depth. We use a lightweight head with a novel bin adjustment design called metric bins module for each domain. During inference, each input image is automatically routed to the appropriate head using a latent classifier. Our framework admits multiple configurations depending on the datasets used for relative depth pre-training and metric fine-tuning. Without pre-training, we can already significantly improve the state of the art (SOTA) on the NYU Depth v2 indoor dataset. Pre-training on twelve datasets and fine-tuning on the NYU Depth v2 indoor dataset, we can further improve SOTA for a total of 21% in terms of relative absolute error (REL). Finally, ZoeD-M12-NK is the first model that can jointly train on multiple datasets (NYU Depth v2 and KITTI) without a significant drop in performance and achieve unprecedented zero-shot generalization performance to eight unseen datasets from both indoor and outdoor domains.</em>",ve,k,lt,Ze,N,dt='ZoeDepth architecture. Taken from the <a href="https://arxiv.org/abs/2302.12288">original paper.</a>',je,H,ct=`This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>.
The original code can be found <a href="https://github.com/isl-org/ZoeDepth" rel="nofollow">here</a>.`,Ce,X,Ie,L,pt="<li>ZoeDepth is an absolute (also called metric) depth estimation model, unlike DPT which is a relative depth estimation model. This means that ZoeDepth is able to estimate depth in metric units like meters.</li>",De,S,mt='The easiest to perform inference with ZoeDepth is by leveraging the <a href="../main_classes/pipelines.md">pipeline API</a>:',ze,P,Je,q,ht="Alternatively, one can also perform inference using the classes:",Ue,A,ke,$,$e,Y,xe,Q,gt="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with ZoeDepth.",Re,K,ft='<li>A demo notebook regarding inference with ZoeDepth models can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/ZoeDepth" rel="nofollow">here</a>. 🌎</li>',We,O,Ge,v,ee,Pe,pe,ut=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_30803/en/model_doc/zoedepth#transformers.ZoeDepthForDepthEstimation">ZoeDepthForDepthEstimation</a>. It is used to instantiate an ZoeDepth
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the ZoeDepth
<a href="https://huggingface.co/Intel/zoedepth-nyu" rel="nofollow">Intel/zoedepth-nyu</a> architecture.`,qe,me,_t=`Configuration objects inherit from <a href="/docs/transformers/pr_30803/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_30803/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Ae,x,Fe,te,Be,C,oe,Ye,he,bt="Constructs a ZoeDepth image processor.",Qe,R,ne,Ke,ge,yt="Preprocess an image or batch of images.",Ee,se,Ve,Z,ae,Oe,fe,wt="ZoeDepth model with one or multiple metric depth estimation head(s) on top.",et,ue,Tt=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,tt,j,re,ot,_e,Mt='The <a href="/docs/transformers/pr_30803/en/model_doc/zoedepth#transformers.ZoeDepthForDepthEstimation">ZoeDepthForDepthEstimation</a> forward method, overrides the <code>__call__</code> special method.',nt,W,st,G,Ne,ie,He,be,Xe;return w=new ce({props:{title:"ZoeDepth",local:"zoedepth",headingTag:"h1"}}),T=new ce({props:{title:"Overview",local:"overview",headingTag:"h2"}}),X=new ce({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),P=new Le({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJkZXB0aC1lc3RpbWF0aW9uJTIyJTJDJTIwbW9kZWwlM0QlMjJJbnRlbCUyRnpvZWRlcHRoLW55dS1raXR0aSUyMiklMEFyZXN1bHQlMjAlM0QlMjBwaXBlKGltYWdlKSUwQWRlcHRoJTIwJTNEJTIwcmVzdWx0JTVCJTIyZGVwdGglMjIlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(task=<span class="hljs-string">&quot;depth-estimation&quot;</span>, model=<span class="hljs-string">&quot;Intel/zoedepth-nyu-kitti&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>result = pipe(image)
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = result[<span class="hljs-string">&quot;depth&quot;</span>]`,wrap:!1}}),A=new Le({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, ZoeDepthForDepthEstimation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;Intel/zoedepth-nyu-kitti&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ZoeDepthForDepthEstimation.from_pretrained(<span class="hljs-string">&quot;Intel/zoedepth-nyu-kitti&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare image for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():   
<span class="hljs-meta">... </span>    outputs = model(inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># interpolate to original size and visualize the prediction</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment">## ZoeDepth dynamically pads the input image. Thus we pass the original image size as argument</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment">## to \`post_process_depth_estimation\` to remove the padding and resize to original dimensions.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>post_processed_output = image_processor.post_process_depth_estimation(
<span class="hljs-meta">... </span>    outputs,
<span class="hljs-meta">... </span>    source_sizes=[(image.height, image.width)],
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_depth = post_processed_output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;predicted_depth&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = (predicted_depth - predicted_depth.<span class="hljs-built_in">min</span>()) / (predicted_depth.<span class="hljs-built_in">max</span>() - predicted_depth.<span class="hljs-built_in">min</span>())
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = depth.detach().cpu().numpy() * <span class="hljs-number">255</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = Image.fromarray(depth.astype(<span class="hljs-string">&quot;uint8&quot;</span>))`,wrap:!1}}),$=new vt({props:{$$slots:{default:[kt]},$$scope:{ctx:z}}}),Y=new ce({props:{title:"Resources",local:"resources",headingTag:"h2"}}),O=new ce({props:{title:"ZoeDepthConfig",local:"transformers.ZoeDepthConfig",headingTag:"h2"}}),ee=new ye({props:{name:"class transformers.ZoeDepthConfig",anchor:"transformers.ZoeDepthConfig",parameters:[{name:"backbone_config",val:" = None"},{name:"backbone",val:" = None"},{name:"use_pretrained_backbone",val:" = False"},{name:"backbone_kwargs",val:" = None"},{name:"hidden_act",val:" = 'gelu'"},{name:"initializer_range",val:" = 0.02"},{name:"batch_norm_eps",val:" = 1e-05"},{name:"readout_type",val:" = 'project'"},{name:"reassemble_factors",val:" = [4, 2, 1, 0.5]"},{name:"neck_hidden_sizes",val:" = [96, 192, 384, 768]"},{name:"fusion_hidden_size",val:" = 256"},{name:"head_in_index",val:" = -1"},{name:"use_batch_norm_in_fusion_residual",val:" = False"},{name:"use_bias_in_fusion_residual",val:" = None"},{name:"num_relative_features",val:" = 32"},{name:"add_projection",val:" = False"},{name:"bottleneck_features",val:" = 256"},{name:"num_attractors",val:" = [16, 8, 4, 1]"},{name:"bin_embedding_dim",val:" = 128"},{name:"attractor_alpha",val:" = 1000"},{name:"attractor_gamma",val:" = 2"},{name:"attractor_kind",val:" = 'mean'"},{name:"min_temp",val:" = 0.0212"},{name:"max_temp",val:" = 50.0"},{name:"bin_centers_type",val:" = 'softplus'"},{name:"bin_configurations",val:" = [{'n_bins': 64, 'min_depth': 0.001, 'max_depth': 10.0}]"},{name:"num_patch_transformer_layers",val:" = None"},{name:"patch_transformer_hidden_size",val:" = None"},{name:"patch_transformer_intermediate_size",val:" = None"},{name:"patch_transformer_num_attention_heads",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ZoeDepthConfig.backbone_config",description:`<strong>backbone_config</strong> (<code>Union[Dict[str, Any], PretrainedConfig]</code>, <em>optional</em>, defaults to <code>BeitConfig()</code>) &#x2014;
The configuration of the backbone model.`,name:"backbone_config"},{anchor:"transformers.ZoeDepthConfig.backbone",description:`<strong>backbone</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of backbone to use when <code>backbone_config</code> is <code>None</code>. If <code>use_pretrained_backbone</code> is <code>True</code>, this
will load the corresponding pretrained weights from the timm or transformers library. If <code>use_pretrained_backbone</code>
is <code>False</code>, this loads the backbone&#x2019;s config and uses that to initialize the backbone with random weights.`,name:"backbone"},{anchor:"transformers.ZoeDepthConfig.use_pretrained_backbone",description:`<strong>use_pretrained_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use pretrained weights for the backbone.`,name:"use_pretrained_backbone"},{anchor:"transformers.ZoeDepthConfig.backbone_kwargs",description:`<strong>backbone_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Keyword arguments to be passed to AutoBackbone when loading from a checkpoint
e.g. <code>{&apos;out_indices&apos;: (0, 1, 2, 3)}</code>. Cannot be specified if <code>backbone_config</code> is set.`,name:"backbone_kwargs"},{anchor:"transformers.ZoeDepthConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.ZoeDepthConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.ZoeDepthConfig.batch_norm_eps",description:`<strong>batch_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the batch normalization layers.`,name:"batch_norm_eps"},{anchor:"transformers.ZoeDepthConfig.readout_type",description:`<strong>readout_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;project&quot;</code>) &#x2014;
The readout type to use when processing the readout token (CLS token) of the intermediate hidden states of
the ViT backbone. Can be one of [<code>&quot;ignore&quot;</code>, <code>&quot;add&quot;</code>, <code>&quot;project&quot;</code>].</p>
<ul>
<li>&#x201C;ignore&#x201D; simply ignores the CLS token.</li>
<li>&#x201C;add&#x201D; passes the information from the CLS token to all other tokens by adding the representations.</li>
<li>&#x201C;project&#x201D; passes information to the other tokens by concatenating the readout to all other tokens before
projecting the
representation to the original feature dimension D using a linear layer followed by a GELU non-linearity.</li>
</ul>`,name:"readout_type"},{anchor:"transformers.ZoeDepthConfig.reassemble_factors",description:`<strong>reassemble_factors</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[4, 2, 1, 0.5]</code>) &#x2014;
The up/downsampling factors of the reassemble layers.`,name:"reassemble_factors"},{anchor:"transformers.ZoeDepthConfig.neck_hidden_sizes",description:`<strong>neck_hidden_sizes</strong> (<code>List[str]</code>, <em>optional</em>, defaults to <code>[96, 192, 384, 768]</code>) &#x2014;
The hidden sizes to project to for the feature maps of the backbone.`,name:"neck_hidden_sizes"},{anchor:"transformers.ZoeDepthConfig.fusion_hidden_size",description:`<strong>fusion_hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The number of channels before fusion.`,name:"fusion_hidden_size"},{anchor:"transformers.ZoeDepthConfig.head_in_index",description:`<strong>head_in_index</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
The index of the features to use in the heads.`,name:"head_in_index"},{anchor:"transformers.ZoeDepthConfig.use_batch_norm_in_fusion_residual",description:`<strong>use_batch_norm_in_fusion_residual</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use batch normalization in the pre-activate residual units of the fusion blocks.`,name:"use_batch_norm_in_fusion_residual"},{anchor:"transformers.ZoeDepthConfig.use_bias_in_fusion_residual",description:`<strong>use_bias_in_fusion_residual</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use bias in the pre-activate residual units of the fusion blocks.`,name:"use_bias_in_fusion_residual"},{anchor:"transformers.ZoeDepthConfig.num_relative_features",description:`<strong>num_relative_features</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
The number of features to use in the relative depth estimation head.`,name:"num_relative_features"},{anchor:"transformers.ZoeDepthConfig.add_projection",description:`<strong>add_projection</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to add a projection layer before the depth estimation head.`,name:"add_projection"},{anchor:"transformers.ZoeDepthConfig.bottleneck_features",description:`<strong>bottleneck_features</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The number of features in the bottleneck layer.`,name:"bottleneck_features"},{anchor:"transformers.ZoeDepthConfig.num_attractors",description:"<strong>num_attractors</strong> (<code>List[int], *optional*, defaults to </code>[16, 8, 4, 1]`) &#x2014;\nThe number of attractors to use in each stage.",name:"num_attractors"},{anchor:"transformers.ZoeDepthConfig.bin_embedding_dim",description:`<strong>bin_embedding_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
The dimension of the bin embeddings.`,name:"bin_embedding_dim"},{anchor:"transformers.ZoeDepthConfig.attractor_alpha",description:`<strong>attractor_alpha</strong> (<code>int</code>, <em>optional</em>, defaults to 1000) &#x2014;
The alpha value to use in the attractor.`,name:"attractor_alpha"},{anchor:"transformers.ZoeDepthConfig.attractor_gamma",description:`<strong>attractor_gamma</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The gamma value to use in the attractor.`,name:"attractor_gamma"},{anchor:"transformers.ZoeDepthConfig.attractor_kind",description:`<strong>attractor_kind</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;mean&quot;</code>) &#x2014;
The kind of attractor to use. Can be one of [<code>&quot;mean&quot;</code>, <code>&quot;sum&quot;</code>].`,name:"attractor_kind"},{anchor:"transformers.ZoeDepthConfig.min_temp",description:`<strong>min_temp</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0212) &#x2014;
The minimum temperature value to consider.`,name:"min_temp"},{anchor:"transformers.ZoeDepthConfig.max_temp",description:`<strong>max_temp</strong> (<code>float</code>, <em>optional</em>, defaults to 50.0) &#x2014;
The maximum temperature value to consider.`,name:"max_temp"},{anchor:"transformers.ZoeDepthConfig.bin_centers_type",description:`<strong>bin_centers_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;softplus&quot;</code>) &#x2014;
Activation type used for bin centers. Can be &#x201C;normed&#x201D; or &#x201C;softplus&#x201D;. For &#x201C;normed&#x201D; bin centers, linear normalization trick
is applied. This results in bounded bin centers. For &#x201C;softplus&#x201D;, softplus activation is used and thus are unbounded.`,name:"bin_centers_type"},{anchor:"transformers.ZoeDepthConfig.bin_configurations",description:`<strong>bin_configurations</strong> (<code>List[dict]</code>, <em>optional</em>, defaults to <code>[{&apos;n_bins&apos; -- 64, &apos;min_depth&apos;: 0.001, &apos;max_depth&apos;: 10.0}]</code>):
Configuration for each of the bin heads.
Each configuration should consist of the following keys:</p>
<ul>
<li>name (<code>str</code>): The name of the bin head - only required in case of multiple bin configurations.</li>
<li><code>n_bins</code> (<code>int</code>): The number of bins to use.</li>
<li><code>min_depth</code> (<code>float</code>): The minimum depth value to consider.</li>
<li><code>max_depth</code> (<code>float</code>): The maximum depth value to consider.
In case only a single configuration is passed, the model will use a single head with the specified configuration.
In case multiple configurations are passed, the model will use multiple heads with the specified configurations.</li>
</ul>`,name:"bin_configurations"},{anchor:"transformers.ZoeDepthConfig.num_patch_transformer_layers",description:`<strong>num_patch_transformer_layers</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of transformer layers to use in the patch transformer. Only used in case of multiple bin configurations.`,name:"num_patch_transformer_layers"},{anchor:"transformers.ZoeDepthConfig.patch_transformer_hidden_size",description:`<strong>patch_transformer_hidden_size</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The hidden size to use in the patch transformer. Only used in case of multiple bin configurations.`,name:"patch_transformer_hidden_size"},{anchor:"transformers.ZoeDepthConfig.patch_transformer_intermediate_size",description:`<strong>patch_transformer_intermediate_size</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The intermediate size to use in the patch transformer. Only used in case of multiple bin configurations.`,name:"patch_transformer_intermediate_size"},{anchor:"transformers.ZoeDepthConfig.patch_transformer_num_attention_heads",description:`<strong>patch_transformer_num_attention_heads</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of attention heads to use in the patch transformer. Only used in case of multiple bin configurations.`,name:"patch_transformer_num_attention_heads"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/models/zoedepth/configuration_zoedepth.py#L29"}}),x=new Zt({props:{anchor:"transformers.ZoeDepthConfig.example",$$slots:{default:[$t]},$$scope:{ctx:z}}}),te=new ce({props:{title:"ZoeDepthImageProcessor",local:"transformers.ZoeDepthImageProcessor",headingTag:"h2"}}),oe=new ye({props:{name:"class transformers.ZoeDepthImageProcessor",anchor:"transformers.ZoeDepthImageProcessor",parameters:[{name:"do_pad",val:": bool = True"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"keep_aspect_ratio",val:": bool = True"},{name:"ensure_multiple_of",val:": int = 32"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ZoeDepthImageProcessor.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to apply pad the input.`,name:"do_pad"},{anchor:"transformers.ZoeDepthImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overidden by <code>do_rescale</code> in
<code>preprocess</code>.`,name:"do_rescale"},{anchor:"transformers.ZoeDepthImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overidden by <code>rescale_factor</code> in <code>preprocess</code>.`,name:"rescale_factor"},{anchor:"transformers.ZoeDepthImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method.`,name:"do_normalize"},{anchor:"transformers.ZoeDepthImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.ZoeDepthImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_STD</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.ZoeDepthImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions. Can be overidden by <code>do_resize</code> in <code>preprocess</code>.`,name:"do_resize"},{anchor:"transformers.ZoeDepthImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;height&quot; -- 384, &quot;width&quot;: 512}</code>):
Size of the image after resizing. Size of the image after resizing. If <code>keep_aspect_ratio</code> is <code>True</code>,
the image is resized by choosing the smaller of the height and width scaling factors and using it for both dimensions.
If <code>ensure_multiple_of</code> is also set, the image is further resized to a size that is a multiple of this value.
Can be overidden by <code>size</code> in <code>preprocess</code>.`,name:"size"},{anchor:"transformers.ZoeDepthImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BILINEAR</code>) &#x2014;
Defines the resampling filter to use if resizing the image. Can be overidden by <code>resample</code> in <code>preprocess</code>.`,name:"resample"},{anchor:"transformers.ZoeDepthImageProcessor.keep_aspect_ratio",description:`<strong>keep_aspect_ratio</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
If <code>True</code>, the image is resized by choosing the smaller of the height and width scaling factors and using it
for both dimensions. This ensures that the image is scaled down as little as possible while still fitting
within the desired output size. In case <code>ensure_multiple_of</code> is also set, the image is further resized to a
size that is a multiple of this value by flooring the height and width to the nearest multiple of this value.
Can be overidden by <code>keep_aspect_ratio</code> in <code>preprocess</code>.`,name:"keep_aspect_ratio"},{anchor:"transformers.ZoeDepthImageProcessor.ensure_multiple_of",description:`<strong>ensure_multiple_of</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
If <code>do_resize</code> is <code>True</code>, the image is resized to a size that is a multiple of this value. Works by flooring
the height and width to the nearest multiple of this value.</p>
<p>Works both with and without <code>keep_aspect_ratio</code> being set to <code>True</code>. Can be overidden by <code>ensure_multiple_of</code>
in <code>preprocess</code>.`,name:"ensure_multiple_of"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/models/zoedepth/image_processing_zoedepth.py#L102"}}),ne=new ye({props:{name:"preprocess",anchor:"transformers.ZoeDepthImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]"},{name:"do_pad",val:": bool = None"},{name:"do_rescale",val:": bool = None"},{name:"rescale_factor",val:": float = None"},{name:"do_normalize",val:": bool = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_resize",val:": bool = None"},{name:"size",val:": int = None"},{name:"keep_aspect_ratio",val:": bool = None"},{name:"ensure_multiple_of",val:": int = None"},{name:"resample",val:": Resampling = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": ChannelDimension = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.ZoeDepthImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.ZoeDepthImageProcessor.preprocess.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_pad</code>) &#x2014;
Whether to pad the input image.`,name:"do_pad"},{anchor:"transformers.ZoeDepthImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image values between [0 - 1].`,name:"do_rescale"},{anchor:"transformers.ZoeDepthImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.ZoeDepthImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.ZoeDepthImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean.`,name:"image_mean"},{anchor:"transformers.ZoeDepthImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation.`,name:"image_std"},{anchor:"transformers.ZoeDepthImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.ZoeDepthImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after resizing. If <code>keep_aspect_ratio</code> is <code>True</code>, he image is resized by choosing the
smaller of the height and width scaling factors and using it for both dimensions. If <code>ensure_multiple_of</code>
is also set, the image is further resized to a size that is a multiple of this value.`,name:"size"},{anchor:"transformers.ZoeDepthImageProcessor.preprocess.keep_aspect_ratio",description:`<strong>keep_aspect_ratio</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.keep_aspect_ratio</code>) &#x2014;
If <code>True</code> and <code>do_resize=True</code>, the image is resized by choosing the smaller of the height and width
scaling factors and using it for both dimensions. This ensures that the image is scaled down as little
as possible while still fitting within the desired output size. In case <code>ensure_multiple_of</code> is also
set, the image is further resized to a size that is a multiple of this value by flooring the height and
width to the nearest multiple of this value.`,name:"keep_aspect_ratio"},{anchor:"transformers.ZoeDepthImageProcessor.preprocess.ensure_multiple_of",description:`<strong>ensure_multiple_of</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.ensure_multiple_of</code>) &#x2014;
If <code>do_resize</code> is <code>True</code>, the image is resized to a size that is a multiple of this value. Works by
flooring the height and width to the nearest multiple of this value.</p>
<p>Works both with and without <code>keep_aspect_ratio</code> being set to <code>True</code>. Can be overidden by
<code>ensure_multiple_of</code> in <code>preprocess</code>.`,name:"ensure_multiple_of"},{anchor:"transformers.ZoeDepthImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>, Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.ZoeDepthImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:</p>
<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.ZoeDepthImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:</p>
<ul>
<li><code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
</ul>`,name:"data_format"},{anchor:"transformers.ZoeDepthImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:</p>
<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/models/zoedepth/image_processing_zoedepth.py#L297"}}),se=new ce({props:{title:"ZoeDepthForDepthEstimation",local:"transformers.ZoeDepthForDepthEstimation",headingTag:"h2"}}),ae=new ye({props:{name:"class transformers.ZoeDepthForDepthEstimation",anchor:"transformers.ZoeDepthForDepthEstimation",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.ZoeDepthForDepthEstimation.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30803/en/model_doc/vit#transformers.ViTConfig">ViTConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_30803/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/models/zoedepth/modeling_zoedepth.py#L1275"}}),re=new ye({props:{name:"forward",anchor:"transformers.ZoeDepthForDepthEstimation.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.ZoeDepthForDepthEstimation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/pr_30803/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/pr_30803/en/model_doc/dpt#transformers.DPTFeatureExtractor.__call__">DPTImageProcessor.<strong>call</strong>()</a>
for details.`,name:"pixel_values"},{anchor:"transformers.ZoeDepthForDepthEstimation.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ZoeDepthForDepthEstimation.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ZoeDepthForDepthEstimation.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30803/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.ZoeDepthForDepthEstimation.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Ground truth depth estimation maps for computing the loss.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/vr_30803/src/transformers/models/zoedepth/modeling_zoedepth.py#L1307",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_30803/en/main_classes/output#transformers.modeling_outputs.DepthEstimatorOutput"
>transformers.modeling_outputs.DepthEstimatorOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_30803/en/model_doc/zoedepth#transformers.ZoeDepthConfig"
>ZoeDepthConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>predicted_depth</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, height, width)</code>) — Predicted depth for each pixel.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, num_channels, height, width)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_30803/en/main_classes/output#transformers.modeling_outputs.DepthEstimatorOutput"
>transformers.modeling_outputs.DepthEstimatorOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),W=new vt({props:{$$slots:{default:[xt]},$$scope:{ctx:z}}}),G=new Zt({props:{anchor:"transformers.ZoeDepthForDepthEstimation.forward.example",$$slots:{default:[Rt]},$$scope:{ctx:z}}}),ie=new Ut({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/zoedepth.md"}}),{c(){i=l("meta"),M=a(),p=l("p"),c=a(),g(w.$$.fragment),s=a(),g(T.$$.fragment),we=a(),B=l("p"),B.innerHTML=at,Te=a(),E=l("p"),E.textContent=rt,Me=a(),V=l("p"),V.innerHTML=it,ve=a(),k=l("img"),Ze=a(),N=l("small"),N.innerHTML=dt,je=a(),H=l("p"),H.innerHTML=ct,Ce=a(),g(X.$$.fragment),Ie=a(),L=l("ul"),L.innerHTML=pt,De=a(),S=l("p"),S.innerHTML=mt,ze=a(),g(P.$$.fragment),Je=a(),q=l("p"),q.textContent=ht,Ue=a(),g(A.$$.fragment),ke=a(),g($.$$.fragment),$e=a(),g(Y.$$.fragment),xe=a(),Q=l("p"),Q.textContent=gt,Re=a(),K=l("ul"),K.innerHTML=ft,We=a(),g(O.$$.fragment),Ge=a(),v=l("div"),g(ee.$$.fragment),Pe=a(),pe=l("p"),pe.innerHTML=ut,qe=a(),me=l("p"),me.innerHTML=_t,Ae=a(),g(x.$$.fragment),Fe=a(),g(te.$$.fragment),Be=a(),C=l("div"),g(oe.$$.fragment),Ye=a(),he=l("p"),he.textContent=bt,Qe=a(),R=l("div"),g(ne.$$.fragment),Ke=a(),ge=l("p"),ge.textContent=yt,Ee=a(),g(se.$$.fragment),Ve=a(),Z=l("div"),g(ae.$$.fragment),Oe=a(),fe=l("p"),fe.textContent=wt,et=a(),ue=l("p"),ue.innerHTML=Tt,tt=a(),j=l("div"),g(re.$$.fragment),ot=a(),_e=l("p"),_e.innerHTML=Mt,nt=a(),g(W.$$.fragment),st=a(),g(G.$$.fragment),Ne=a(),g(ie.$$.fragment),He=a(),be=l("p"),this.h()},l(e){const t=Jt("svelte-u9bgzb",document.head);i=d(t,"META",{name:!0,content:!0}),t.forEach(o),M=r(e),p=d(e,"P",{}),de(p).forEach(o),c=r(e),f(w.$$.fragment,e),s=r(e),f(T.$$.fragment,e),we=r(e),B=d(e,"P",{"data-svelte-h":!0}),h(B)!=="svelte-10rgklr"&&(B.innerHTML=at),Te=r(e),E=d(e,"P",{"data-svelte-h":!0}),h(E)!=="svelte-vfdo9a"&&(E.textContent=rt),Me=r(e),V=d(e,"P",{"data-svelte-h":!0}),h(V)!=="svelte-3whyh3"&&(V.innerHTML=it),ve=r(e),k=d(e,"IMG",{src:!0,alt:!0,width:!0}),Ze=r(e),N=d(e,"SMALL",{"data-svelte-h":!0}),h(N)!=="svelte-1n811wn"&&(N.innerHTML=dt),je=r(e),H=d(e,"P",{"data-svelte-h":!0}),h(H)!=="svelte-1qnhban"&&(H.innerHTML=ct),Ce=r(e),f(X.$$.fragment,e),Ie=r(e),L=d(e,"UL",{"data-svelte-h":!0}),h(L)!=="svelte-ysdfoa"&&(L.innerHTML=pt),De=r(e),S=d(e,"P",{"data-svelte-h":!0}),h(S)!=="svelte-vt8hne"&&(S.innerHTML=mt),ze=r(e),f(P.$$.fragment,e),Je=r(e),q=d(e,"P",{"data-svelte-h":!0}),h(q)!=="svelte-rkbhha"&&(q.textContent=ht),Ue=r(e),f(A.$$.fragment,e),ke=r(e),f($.$$.fragment,e),$e=r(e),f(Y.$$.fragment,e),xe=r(e),Q=d(e,"P",{"data-svelte-h":!0}),h(Q)!=="svelte-m5q988"&&(Q.textContent=gt),Re=r(e),K=d(e,"UL",{"data-svelte-h":!0}),h(K)!=="svelte-9gfyrh"&&(K.innerHTML=ft),We=r(e),f(O.$$.fragment,e),Ge=r(e),v=d(e,"DIV",{class:!0});var I=de(v);f(ee.$$.fragment,I),Pe=r(I),pe=d(I,"P",{"data-svelte-h":!0}),h(pe)!=="svelte-1c262eq"&&(pe.innerHTML=ut),qe=r(I),me=d(I,"P",{"data-svelte-h":!0}),h(me)!=="svelte-ur2kjj"&&(me.innerHTML=_t),Ae=r(I),f(x.$$.fragment,I),I.forEach(o),Fe=r(e),f(te.$$.fragment,e),Be=r(e),C=d(e,"DIV",{class:!0});var U=de(C);f(oe.$$.fragment,U),Ye=r(U),he=d(U,"P",{"data-svelte-h":!0}),h(he)!=="svelte-bcn117"&&(he.textContent=bt),Qe=r(U),R=d(U,"DIV",{class:!0});var le=de(R);f(ne.$$.fragment,le),Ke=r(le),ge=d(le,"P",{"data-svelte-h":!0}),h(ge)!=="svelte-1x3yxsa"&&(ge.textContent=yt),le.forEach(o),U.forEach(o),Ee=r(e),f(se.$$.fragment,e),Ve=r(e),Z=d(e,"DIV",{class:!0});var D=de(Z);f(ae.$$.fragment,D),Oe=r(D),fe=d(D,"P",{"data-svelte-h":!0}),h(fe)!=="svelte-7395v3"&&(fe.textContent=wt),et=r(D),ue=d(D,"P",{"data-svelte-h":!0}),h(ue)!=="svelte-1gjh92c"&&(ue.innerHTML=Tt),tt=r(D),j=d(D,"DIV",{class:!0});var F=de(j);f(re.$$.fragment,F),ot=r(F),_e=d(F,"P",{"data-svelte-h":!0}),h(_e)!=="svelte-1iyd2ru"&&(_e.innerHTML=Mt),nt=r(F),f(W.$$.fragment,F),st=r(F),f(G.$$.fragment,F),F.forEach(o),D.forEach(o),Ne=r(e),f(ie.$$.fragment,e),He=r(e),be=d(e,"P",{}),de(be).forEach(o),this.h()},h(){J(i,"name","hf:doc:metadata"),J(i,"content",Gt),Ct(k.src,lt="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/zoedepth_architecture_bis.png")||J(k,"src",lt),J(k,"alt","drawing"),J(k,"width","600"),J(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){m(document.head,i),n(e,M,t),n(e,p,t),n(e,c,t),u(w,e,t),n(e,s,t),u(T,e,t),n(e,we,t),n(e,B,t),n(e,Te,t),n(e,E,t),n(e,Me,t),n(e,V,t),n(e,ve,t),n(e,k,t),n(e,Ze,t),n(e,N,t),n(e,je,t),n(e,H,t),n(e,Ce,t),u(X,e,t),n(e,Ie,t),n(e,L,t),n(e,De,t),n(e,S,t),n(e,ze,t),u(P,e,t),n(e,Je,t),n(e,q,t),n(e,Ue,t),u(A,e,t),n(e,ke,t),u($,e,t),n(e,$e,t),u(Y,e,t),n(e,xe,t),n(e,Q,t),n(e,Re,t),n(e,K,t),n(e,We,t),u(O,e,t),n(e,Ge,t),n(e,v,t),u(ee,v,null),m(v,Pe),m(v,pe),m(v,qe),m(v,me),m(v,Ae),u(x,v,null),n(e,Fe,t),u(te,e,t),n(e,Be,t),n(e,C,t),u(oe,C,null),m(C,Ye),m(C,he),m(C,Qe),m(C,R),u(ne,R,null),m(R,Ke),m(R,ge),n(e,Ee,t),u(se,e,t),n(e,Ve,t),n(e,Z,t),u(ae,Z,null),m(Z,Oe),m(Z,fe),m(Z,et),m(Z,ue),m(Z,tt),m(Z,j),u(re,j,null),m(j,ot),m(j,_e),m(j,nt),u(W,j,null),m(j,st),u(G,j,null),n(e,Ne,t),u(ie,e,t),n(e,He,t),n(e,be,t),Xe=!0},p(e,[t]){const I={};t&2&&(I.$$scope={dirty:t,ctx:e}),$.$set(I);const U={};t&2&&(U.$$scope={dirty:t,ctx:e}),x.$set(U);const le={};t&2&&(le.$$scope={dirty:t,ctx:e}),W.$set(le);const D={};t&2&&(D.$$scope={dirty:t,ctx:e}),G.$set(D)},i(e){Xe||(_(w.$$.fragment,e),_(T.$$.fragment,e),_(X.$$.fragment,e),_(P.$$.fragment,e),_(A.$$.fragment,e),_($.$$.fragment,e),_(Y.$$.fragment,e),_(O.$$.fragment,e),_(ee.$$.fragment,e),_(x.$$.fragment,e),_(te.$$.fragment,e),_(oe.$$.fragment,e),_(ne.$$.fragment,e),_(se.$$.fragment,e),_(ae.$$.fragment,e),_(re.$$.fragment,e),_(W.$$.fragment,e),_(G.$$.fragment,e),_(ie.$$.fragment,e),Xe=!0)},o(e){b(w.$$.fragment,e),b(T.$$.fragment,e),b(X.$$.fragment,e),b(P.$$.fragment,e),b(A.$$.fragment,e),b($.$$.fragment,e),b(Y.$$.fragment,e),b(O.$$.fragment,e),b(ee.$$.fragment,e),b(x.$$.fragment,e),b(te.$$.fragment,e),b(oe.$$.fragment,e),b(ne.$$.fragment,e),b(se.$$.fragment,e),b(ae.$$.fragment,e),b(re.$$.fragment,e),b(W.$$.fragment,e),b(G.$$.fragment,e),b(ie.$$.fragment,e),Xe=!1},d(e){e&&(o(M),o(p),o(c),o(s),o(we),o(B),o(Te),o(E),o(Me),o(V),o(ve),o(k),o(Ze),o(N),o(je),o(H),o(Ce),o(Ie),o(L),o(De),o(S),o(ze),o(Je),o(q),o(Ue),o(ke),o($e),o(xe),o(Q),o(Re),o(K),o(We),o(Ge),o(v),o(Fe),o(Be),o(C),o(Ee),o(Ve),o(Z),o(Ne),o(He),o(be)),o(i),y(w,e),y(T,e),y(X,e),y(P,e),y(A,e),y($,e),y(Y,e),y(O,e),y(ee),y(x),y(te,e),y(oe),y(ne),y(se,e),y(ae),y(re),y(W),y(G),y(ie,e)}}}const Gt='{"title":"ZoeDepth","local":"zoedepth","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"ZoeDepthConfig","local":"transformers.ZoeDepthConfig","sections":[],"depth":2},{"title":"ZoeDepthImageProcessor","local":"transformers.ZoeDepthImageProcessor","sections":[],"depth":2},{"title":"ZoeDepthForDepthEstimation","local":"transformers.ZoeDepthForDepthEstimation","sections":[],"depth":2}],"depth":1}';function Ft(z){return It(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class St extends Dt{constructor(i){super(),zt(this,i,Ft,Wt,jt,{})}}export{St as component};
