import{s as Op,o as tM,n as B}from"../chunks/scheduler.25b97de1.js";import{S as eM,i as lM,g as o,s as a,r as M,A as sM,h as i,f as l,c as n,j as Dp,u as r,x as p,k as Kp,y as aM,a as s,v as y,d as c,t as u,w as m,m as nM,n as oM}from"../chunks/index.d9030fc9.js";import{T as v}from"../chunks/Tip.baa67368.js";import{C as J}from"../chunks/CodeBlock.e6cd0d95.js";import{H as j,E as iM}from"../chunks/EditOnGithub.91d95064.js";function pM(g){let d,U=`Chat templates are a critical component of our <a href="quicktour#chat-with-text-generation-models">chat CLI</a>.
You can apply the learnings of this guide there as well.`;return{c(){d=o("p"),d.innerHTML=U},l(h){d=i(h,"P",{"data-svelte-h":!0}),p(d)!=="svelte-mm4a2n"&&(d.innerHTML=U)},m(h,T){s(h,d,T)},p:B,d(h){h&&l(d)}}}function MM(g){let d,U=`The default behaviour of <code>TextGenerationPipeline</code> is to set <code>add_generation_prompt=True</code> so that it starts a new
message. However, if the final message in the input chat has the “assistant” role, it will assume that this message is
a prefill and switch to <code>continue_final_message=True</code> instead, because most models do not support multiple
consecutive assistant messages. You can override this behaviour by explicitly passing the <code>continue_final_message</code>
argument when calling the pipeline.`;return{c(){d=o("p"),d.innerHTML=U},l(h){d=i(h,"P",{"data-svelte-h":!0}),p(d)!=="svelte-95bbxf"&&(d.innerHTML=U)},m(h,T){s(h,d,T)},p:B,d(h){h&&l(d)}}}function rM(g){let d,U=`By default, some tokenizers add special tokens like <code>&lt;bos&gt;</code> and <code>&lt;eos&gt;</code> to text they tokenize. Chat templates should
already include all the special tokens they need, and so additional special tokens will often be incorrect or
duplicated, which will hurt model performance.`,h,T,C=`Therefore, if you format text with <code>apply_chat_template(tokenize=False)</code>, you should set the argument
<code>add_special_tokens=False</code> when you tokenize that text later. If you use <code>apply_chat_template(tokenize=True)</code>, you don’t need to worry about this!`;return{c(){d=o("p"),d.innerHTML=U,h=a(),T=o("p"),T.innerHTML=C},l(I){d=i(I,"P",{"data-svelte-h":!0}),p(d)!=="svelte-148xjo3"&&(d.innerHTML=U),h=n(I),T=i(I,"P",{"data-svelte-h":!0}),p(T)!=="svelte-1hgzema"&&(T.innerHTML=C)},m(I,b){s(I,d,b),s(I,h,b),s(I,T,b)},p:B,d(I){I&&(l(d),l(h),l(T))}}}function yM(g){let d,U=`The output format above is specific to the <code>Hermes-2-Pro</code> model we’re using in this example. Other models may emit different
tool call formats, and you may need to do some manual parsing at this step. For example, <code>Llama-3.1</code> models will emit
slightly different JSON, with <code>parameters</code> instead of <code>arguments</code>. Regardless of the format the model outputs, you
should add the tool call to the conversation in the format below, with <code>tool_calls</code>, <code>function</code> and <code>arguments</code> keys.`;return{c(){d=o("p"),d.innerHTML=U},l(h){d=i(h,"P",{"data-svelte-h":!0}),p(d)!=="svelte-qsy89c"&&(d.innerHTML=U)},m(h,T){s(h,d,T)},p:B,d(h){h&&l(d)}}}function cM(g){let d,U=`If you’re familiar with the OpenAI API, you should pay attention to an important difference here - the <code>tool_call</code> is
a dict, but in the OpenAI API it’s a JSON string. Passing a string may cause errors or strange model behaviour!`;return{c(){d=o("p"),d.innerHTML=U},l(h){d=i(h,"P",{"data-svelte-h":!0}),p(d)!=="svelte-fq11ea"&&(d.innerHTML=U)},m(h,T){s(h,d,T)},p:B,d(h){h&&l(d)}}}function uM(g){let d,U=`Some model architectures, notably Mistral/Mixtral, also require a <code>tool_call_id</code> here, which should be
9 randomly-generated alphanumeric characters, and assigned to the <code>id</code> key of the tool call
dictionary. The same key should also be assigned to the <code>tool_call_id</code> key of the tool response dictionary below, so
that tool calls can be matched to tool responses. So, for Mistral/Mixtral models, the code above would be:`,h,T,C,I,b="and",G,f,x;return T=new J({props:{code:"dG9vbF9jYWxsX2lkJTIwJTNEJTIwJTIyOUFlM2JEYzJGJTIyJTIwJTIwJTIzJTIwUmFuZG9tJTIwSUQlMkMlMjA5JTIwYWxwaGFudW1lcmljJTIwY2hhcmFjdGVycyUwQXRvb2xfY2FsbCUyMCUzRCUyMCU3QiUyMm5hbWUlMjIlM0ElMjAlMjJnZXRfY3VycmVudF90ZW1wZXJhdHVyZSUyMiUyQyUyMCUyMmFyZ3VtZW50cyUyMiUzQSUyMCU3QiUyMmxvY2F0aW9uJTIyJTNBJTIwJTIyUGFyaXMlMkMlMjBGcmFuY2UlMjIlMkMlMjAlMjJ1bml0JTIyJTNBJTIwJTIyY2Vsc2l1cyUyMiU3RCU3RCUwQW1lc3NhZ2VzLmFwcGVuZCglN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIydG9vbF9jYWxscyUyMiUzQSUyMCU1QiU3QiUyMnR5cGUlMjIlM0ElMjAlMjJmdW5jdGlvbiUyMiUyQyUyMCUyMmlkJTIyJTNBJTIwdG9vbF9jYWxsX2lkJTJDJTIwJTIyZnVuY3Rpb24lMjIlM0ElMjB0b29sX2NhbGwlN0QlNUQlN0Qp",highlighted:`tool_call_id = <span class="hljs-string">&quot;9Ae3bDc2F&quot;</span>  <span class="hljs-comment"># Random ID, 9 alphanumeric characters</span>
tool_call = {<span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_temperature&quot;</span>, <span class="hljs-string">&quot;arguments&quot;</span>: {<span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;Paris, France&quot;</span>, <span class="hljs-string">&quot;unit&quot;</span>: <span class="hljs-string">&quot;celsius&quot;</span>}}
messages.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;tool_calls&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>, <span class="hljs-string">&quot;id&quot;</span>: tool_call_id, <span class="hljs-string">&quot;function&quot;</span>: tool_call}]})`,wrap:!1}}),f=new J({props:{code:"bWVzc2FnZXMuYXBwZW5kKCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ0b29sJTIyJTJDJTIwJTIydG9vbF9jYWxsX2lkJTIyJTNBJTIwdG9vbF9jYWxsX2lkJTJDJTIwJTIybmFtZSUyMiUzQSUyMCUyMmdldF9jdXJyZW50X3RlbXBlcmF0dXJlJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMjIyLjAlMjIlN0Qp",highlighted:'messages.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;tool&quot;</span>, <span class="hljs-string">&quot;tool_call_id&quot;</span>: tool_call_id, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_temperature&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;22.0&quot;</span>})',wrap:!1}}),{c(){d=o("p"),d.innerHTML=U,h=a(),M(T.$$.fragment),C=a(),I=o("p"),I.textContent=b,G=a(),M(f.$$.fragment)},l(w){d=i(w,"P",{"data-svelte-h":!0}),p(d)!=="svelte-70hqps"&&(d.innerHTML=U),h=n(w),r(T.$$.fragment,w),C=n(w),I=i(w,"P",{"data-svelte-h":!0}),p(I)!=="svelte-1qlona5"&&(I.textContent=b),G=n(w),r(f.$$.fragment,w)},m(w,$){s(w,d,$),s(w,h,$),y(T,w,$),s(w,C,$),s(w,I,$),s(w,G,$),y(f,w,$),x=!0},p:B,i(w){x||(c(T.$$.fragment,w),c(f.$$.fragment,w),x=!0)},o(w){u(T.$$.fragment,w),u(f.$$.fragment,w),x=!1},d(w){w&&(l(d),l(h),l(C),l(I),l(G)),m(T,w),m(f,w)}}}function mM(g){let d,U="The <code>documents</code> input for retrieval-augmented generation is not widely supported, and many models have chat templates which simply ignore this input.",h,T,C="To verify if a model supports the <code>documents</code> input, you can read its model card, or <code>print(tokenizer.chat_template)</code> to see if the <code>documents</code> key is used anywhere.",I,b,G='One model class that does support it, though, is Cohere’s <a href="https://huggingface.co/CohereForAI/c4ai-command-r-08-2024" rel="nofollow">Command-R</a> and <a href="https://huggingface.co/CohereForAI/c4ai-command-r-plus-08-2024" rel="nofollow">Command-R+</a>, through their <code>rag</code> chat template. You can see additional examples of grounded generation using this feature in their model cards.';return{c(){d=o("p"),d.innerHTML=U,h=a(),T=o("p"),T.innerHTML=C,I=a(),b=o("p"),b.innerHTML=G},l(f){d=i(f,"P",{"data-svelte-h":!0}),p(d)!=="svelte-bl710l"&&(d.innerHTML=U),h=n(f),T=i(f,"P",{"data-svelte-h":!0}),p(T)!=="svelte-qpz2lz"&&(T.innerHTML=C),I=n(f),b=i(f,"P",{"data-svelte-h":!0}),p(b)!=="svelte-kg7zp3"&&(b.innerHTML=G)},m(f,x){s(f,d,x),s(f,h,x),s(f,T,x),s(f,I,x),s(f,b,x)},p:B,d(f){f&&(l(d),l(h),l(T),l(I),l(b))}}}function dM(g){let d;return{c(){d=nM(`If you're fine-tuning a model for chat, in addition to setting a chat template, you should probably add any new chat
control tokens as special tokens in the tokenizer. Special tokens are never split,
ensuring that your control tokens are always handled as single tokens rather than being tokenized in pieces. You
should also set the tokenizer's \`eos_token\` attribute to the token that marks the end of assistant generations in your
template. This will ensure that text generation tools can correctly figure out when to stop generating text.`)},l(U){d=oM(U,`If you're fine-tuning a model for chat, in addition to setting a chat template, you should probably add any new chat
control tokens as special tokens in the tokenizer. Special tokens are never split,
ensuring that your control tokens are always handled as single tokens rather than being tokenized in pieces. You
should also set the tokenizer's \`eos_token\` attribute to the token that marks the end of assistant generations in your
template. This will ensure that text generation tools can correctly figure out when to stop generating text.`)},m(U,h){s(U,d,h)},d(U){U&&l(d)}}}function hM(g){let d,U=`The easiest way to get started with writing Jinja templates is to take a look at some existing ones. You can use
<code>print(tokenizer.chat_template)</code> for any chat model to see what template it’s using. In general, models that support tool use have
much more complex templates than other models - so when you’re just getting started, they’re probably a bad example
to learn from! You can also take a look at the
<a href="https://jinja.palletsprojects.com/en/3.1.x/templates/#synopsis" rel="nofollow">Jinja documentation</a> for details
of general Jinja formatting and syntax.`;return{c(){d=o("p"),d.innerHTML=U},l(h){d=i(h,"P",{"data-svelte-h":!0}),p(d)!=="svelte-qy60pj"&&(d.innerHTML=U)},m(h,T){s(h,d,T)},p:B,d(h){h&&l(d)}}}function JM(g){let d,U=`You can actually pass any <code>kwarg</code> to <code>apply_chat_template</code>, and it will be accessible inside the template as a variable. In general,
we recommend trying to stick to the core variables above, as it will make your model harder to use if users have
to write custom code to pass model-specific <code>kwargs</code>. However, we’re aware that this field moves quickly, so if you
have a new use-case that doesn’t fit in the core API, feel free to use a new <code>kwarg</code> for it! If a new <code>kwarg</code>
becomes common we may promote it into the core API and create a standard, documented format for it.`;return{c(){d=o("p"),d.innerHTML=U},l(h){d=i(h,"P",{"data-svelte-h":!0}),p(d)!=="svelte-cvlh0x"&&(d.innerHTML=U)},m(h,T){s(h,d,T)},p:B,d(h){h&&l(d)}}}function TM(g){let d,U,h,T,C,I,b,G,f,x=`An increasingly common use case for LLMs is <strong>chat</strong>. In a chat context, rather than continuing a single string
of text (as is the case with a standard language model), the model instead continues a conversation that consists
of one or more <strong>messages</strong>, each of which includes a <strong>role</strong>, like “user” or “assistant”, as well as message text.`,w,$,Xo=`Much like tokenization, different models expect very different input formats for chat. This is the reason we added
<strong>chat templates</strong> as a feature. Chat templates are part of the tokenizer for text-only LLMs or processor for multimodal LLMs. They specify how to convert conversations,
represented as lists of messages, into a single tokenizable string in the format that the model expects.`,rs,S,Ho="Let’s make this concrete with a quick example using the <code>mistralai/Mistral-7B-Instruct-v0.1</code> model:",ys,z,cs,E,Yo=`Notice how the tokenizer has added the control tokens [INST] and [/INST] to indicate the start and end of
user messages (but not assistant messages!), and the entire chat is condensed into a single string.
If we use <code>tokenize=True</code>, which is the default setting, that string will also be tokenized for us.`,us,X,Fo="Now, try the same code, but swap in the <code>HuggingFaceH4/zephyr-7b-beta</code> model instead, and you should get:",ms,H,ds,Y,Lo=`Both Zephyr and Mistral-Instruct were fine-tuned from the same base model, <code>Mistral-7B-v0.1</code>. However, they were trained
with totally different chat formats. Without chat templates, you would have to write manual formatting code for each
model, and it’s very easy to make minor errors that hurt performance! Chat templates handle the details of formatting
for you, allowing you to write universal code that works for any model.`,hs,N,Js,F,Ts,L,Po=`As you can see in the example above, chat templates are easy to use. Simply build a list of messages, with <code>role</code>
and <code>content</code> keys, and then pass it to the <a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a> or <a href="/docs/transformers/pr_30803/en/main_classes/processors#transformers.ProcessorMixin.apply_chat_template">apply_chat_template()</a> method
depending on what type of model you are using. Once you do that,
you’ll get output that’s ready to go! When using chat templates as input for model generation, it’s also a good idea
to use <code>add_generation_prompt=True</code> to add a <a href="#what-are-generation-prompts">generation prompt</a>.`,Us,P,js,D,Do="Here’s an example of preparing input for <code>model.generate()</code>, using <code>Zephyr</code> again:",ws,K,fs,O,Ko="This will yield a string in the input format that Zephyr expects.",Is,tt,gs,et,Oo="Now that our input is formatted correctly for Zephyr, we can use the model to generate a response to the user’s question:",bs,lt,Cs,st,ti="This will yield:",$s,at,xs,nt,Gs,ot,ei=`For multimodal LLMs such as <a href="https://huggingface.co/llava-hf" rel="nofollow">LLaVA</a> the prompts can be formatted in a similar way. The only difference is you need to pass input images/videos as well along with the text. Each <code>&quot;content&quot;</code>
has to be a list containing either a text or an image/video.`,vs,it,li="Here’s an example of preparing input for using <code>LLaVA</code> model:",Bs,pt,Ns,Mt,si=`This yields a string in LLaVAs expected input format with many <code>&lt;image&gt;</code> tokens at the end.
The <code>&lt;image&gt;</code> tokens are placeholders and each one will be replaced by image embeddings when the mode is run in the forward call. The <code>processed_chat</code> can be further passed into <a href="/docs/transformers/pr_30803/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> to generate text.`,Zs,rt,As,yt,ai="Arr, ‘twas easy after all!",Qs,ct,ks,ut,ni=`Yes, there is! Our text generation pipelines support chat inputs, which makes it easy to use chat models. In the past,
we used to use a dedicated “ConversationalPipeline” class, but this has now been deprecated and its functionality
has been merged into the <a href="/docs/transformers/pr_30803/en/main_classes/pipelines#transformers.TextGenerationPipeline">TextGenerationPipeline</a>. Let’s try the <code>Zephyr</code> example again, but this time using
a pipeline:`,qs,mt,Ws,dt,Vs,ht,oi=`The pipeline will take care of all the details of tokenization and calling <code>apply_chat_template</code> for you -
once the model has a chat template, all you need to do is initialize the pipeline and pass it the list of messages!`,_s,Jt,Rs,Tt,ii=`You may have noticed that the <code>apply_chat_template</code> method has an <code>add_generation_prompt</code> argument. This argument tells
the template to add tokens that indicate the start of a bot response. For example, consider the following chat:`,Ss,Ut,zs,jt,pi="Here’s what this will look like without a generation prompt, for a model that uses standard “ChatML” formatting:",Es,wt,Xs,ft,Mi="And here’s what it looks like <strong>with</strong> a generation prompt:",Hs,It,Ys,gt,ri=`Note that this time, we’ve added the tokens that indicate the start of a bot response. This ensures that when the model
generates text it will write a bot response instead of doing something unexpected, like continuing the user’s
message. Remember, chat models are still just language models - they’re trained to continue text, and chat is just a
special kind of text to them! You need to guide them with appropriate control tokens, so they know what they’re
supposed to be doing.`,Fs,bt,yi=`Not all models require generation prompts. Some models, like LLaMA, don’t have any
special tokens before bot responses. In these cases, the <code>add_generation_prompt</code> argument will have no effect. The exact
effect that <code>add_generation_prompt</code> has will depend on the template being used.`,Ls,Ct,Ps,$t,ci=`When passing a list of messages to <code>apply_chat_template</code> or <code>TextGenerationPipeline</code>, you can choose
to format the chat so the model will continue the final message in the chat instead of starting a new one. This is done
by removing any end-of-sequence tokens that indicate the end of the final message, so that the model will simply
extend the final message when it begins to generate text. This is useful for “prefilling” the model’s response.`,Ds,xt,ui="Here’s an example:",Ks,Gt,Os,vt,mi=`The model will generate text that continues the JSON string, rather than starting a new message. This approach
can be very useful for improving the accuracy of the model’s instruction-following when you know how you want
it to start its replies.`,ta,Bt,di=`Because <code>add_generation_prompt</code> adds the tokens that start a new message, and <code>continue_final_message</code> removes any
end-of-message tokens from the final message, it does not make sense to use them together. As a result, you’ll
get an error if you try!`,ea,Z,la,Nt,sa,Zt,hi=`Yes! This is a good way to ensure that the chat template matches the tokens the model sees during training.
We recommend that you apply the chat template as a preprocessing step for your dataset. After this, you
can simply continue like any other language model training task. When training, you should usually set
<code>add_generation_prompt=False</code>, because the added tokens to prompt an assistant response will not be helpful during
training. Let’s see an example:`,aa,At,na,Qt,Ji="And we get:",oa,kt,ia,qt,Ti="From here, just continue training like you would with a standard language modelling task, using the <code>formatted_chat</code> column.",pa,A,Ma,Wt,ra,Vt,Ui=`The only argument that <code>apply_chat_template</code> requires is <code>messages</code>. However, you can pass any keyword
argument to <code>apply_chat_template</code> and it will be accessible inside the template. This gives you a lot of freedom to use
chat templates for many things. There are no restrictions on the names or the format of these arguments - you can pass
strings, lists, dicts or whatever else you want.`,ya,_t,ji=`That said, there are some common use-cases for these extra arguments,
such as passing tools for function calling, or documents for retrieval-augmented generation. In these common cases,
we have some opinionated recommendations about what the names and formats of these arguments should be, which are
described in the sections below. We encourage model authors to make their chat templates compatible with this format,
to make it easy to transfer tool-calling code between models.`,ca,Rt,ua,St,wi=`“Tool use” LLMs can choose to call functions as external tools before generating an answer. When passing tools
to a tool-use model, you can simply pass a list of functions to the <code>tools</code> argument:`,ma,zt,da,Et,fi=`In order for this to work correctly, you should write your functions in the format above, so that they can be parsed
correctly as tools. Specifically, you should follow these rules:`,ha,Xt,Ii=`<li>The function should have a descriptive name</li> <li>Every argument must have a type hint</li> <li>The function must have a docstring in the standard Google style (in other words, an initial function description
followed by an <code>Args:</code> block that describes the arguments, unless the function does not have any arguments.</li> <li>Do not include types in the <code>Args:</code> block. In other words, write <code>a: The first number to multiply</code>, not
<code>a (int): The first number to multiply</code>. Type hints should go in the function header instead.</li> <li>The function can have a return type and a <code>Returns:</code> block in the docstring. However, these are optional
because most tool-use models ignore them.</li>`,Ja,Ht,Ta,Yt,gi=`The sample code above is enough to list the available tools for your model, but what happens if it wants to actually use
one? If that happens, you should:`,Ua,Ft,bi="<li>Parse the model’s output to get the tool name(s) and arguments.</li> <li>Add the model’s tool call(s) to the conversation.</li> <li>Call the corresponding function(s) with those arguments.</li> <li>Add the result(s) to the conversation</li>",ja,Lt,wa,Pt,Ci=`Let’s walk through a tool use example, step by step. For this example, we will use an 8B <code>Hermes-2-Pro</code> model,
as it is one of the highest-performing tool-use models in its size category at the time of writing. If you have the
memory, you can consider using a larger model instead like <a href="https://huggingface.co/CohereForAI/c4ai-command-r-v01" rel="nofollow">Command-R</a>
or <a href="https://huggingface.co/mistralai/Mixtral-8x22B-Instruct-v0.1" rel="nofollow">Mixtral-8x22B</a>, both of which also support tool use
and offer even stronger performance.`,fa,Dt,$i="First, let’s load our model and tokenizer:",Ia,Kt,ga,Ot,xi="Next, let’s define a list of tools:",ba,te,Ca,ee,Gi="Now, let’s set up a conversation for our bot:",$a,le,xa,se,vi="Now, let’s apply the chat template and generate a response:",Ga,ae,va,ne,Bi="And we get:",Ba,oe,Na,ie,Ni=`The model has called the function with valid arguments, in the format requested by the function docstring. It has
inferred that we’re most likely referring to the Paris in France, and it remembered that, as the home of SI units,
the temperature in France should certainly be displayed in Celsius.`,Za,Q,Aa,pe,Zi="Next, let’s append the model’s tool call to the conversation.",Qa,Me,ka,k,qa,re,Ai=`Now that we’ve added the tool call to the conversation, we can call the function and append the result to the
conversation. Since we’re just using a dummy function for this example that always returns 22.0, we can just append
that result directly.`,Wa,ye,Va,q,_a,ce,Qi="Finally, let’s let the assistant read the function outputs and continue chatting with the user:",Ra,ue,Sa,me,ki="And we get:",za,de,Ea,he,qi=`Although this was a simple demo with dummy tools and a single call, the same technique works with
multiple real tools and longer conversations. This can be a powerful way to extend the capabilities of conversational
agents with real-time information, computational tools like calculators, or access to large databases.`,Xa,Je,Ha,Te,Wi=`Each function you pass to the <code>tools</code> argument of <code>apply_chat_template</code> is converted into a
<a href="https://json-schema.org/learn/getting-started-step-by-step" rel="nofollow">JSON schema</a>. These schemas
are then passed to the model chat template. In other words, tool-use models do not see your functions directly, and they
never see the actual code inside them. What they care about is the function <strong>definitions</strong> and the <strong>arguments</strong> they
need to pass to them - they care about what the tools do and how to use them, not how they work! It is up to you
to read their outputs, detect if they have requested to use a tool, pass their arguments to the tool function, and
return the response in the chat.`,Ya,Ue,Vi=`Generating JSON schemas to pass to the template should be automatic and invisible as long as your functions
follow the specification above, but if you encounter problems, or you simply want more control over the conversion,
you can handle the conversion manually. Here is an example of a manual schema conversion.`,Fa,je,La,we,_i="This will yield:",Pa,fe,Da,Ie,Ri=`If you wish, you can edit these schemas, or even write them from scratch yourself without using <code>get_json_schema</code> at
all. JSON schemas can be passed directly to the <code>tools</code> argument of
<code>apply_chat_template</code> - this gives you a lot of power to define precise schemas for more complex functions. Be careful,
though - the more complex your schemas, the more likely the model is to get confused when dealing with them! We
recommend simple function signatures where possible, keeping arguments (and especially complex, nested arguments)
to a minimum.`,Ka,ge,Si="Here is an example of defining schemas by hand, and passing them directly to <code>apply_chat_template</code>:",Oa,be,tn,Ce,en,$e,zi=`“Retrieval-augmented generation” or “RAG” LLMs can search a corpus of documents for information before responding
to a query. This allows models to vastly expand their knowledge base beyond their limited context size. Our
recommendation for RAG models is that their template
should accept a <code>documents</code> argument. This should be a list of documents, where each “document”
is a single dict with <code>title</code> and <code>contents</code> keys, both of which are strings. Because this format is much simpler
than the JSON schemas used for tools, no helper functions are necessary.`,ln,xe,Ei="Here’s an example of a RAG template in action:",sn,Ge,an,W,nn,ve,on,Be,Xi=`The chat template for a model is stored on the <code>tokenizer.chat_template</code> attribute. If no chat template is set, the
default template for that model class is used instead. Let’s take a look at a <code>Zephyr</code> chat template, though note this
one is a little simplified from the actual one!`,pn,Ne,Mn,Ze,Hi=`If you’ve never seen one of these before, this is a <a href="https://jinja.palletsprojects.com/en/3.1.x/templates/" rel="nofollow">Jinja template</a>.
Jinja is a templating language that allows you to write simple code that generates text. In many ways, the code and
syntax resembles Python. In pure Python, this template would look something like this:`,rn,Ae,yn,Qe,Yi="Effectively, the template does three things:",cn,ke,Fi=`<li>For each message, print the role enclosed in <code>&lt;|</code> and <code>|&gt;</code>, like <code>&lt;|user|&gt;</code> or <code>&lt;|assistant|&gt;</code>.</li> <li>Next, print the content of the message, followed by the end-of-sequence token.</li> <li>Finally, if <code>add_generation_prompt</code> is set, print the assistant token, so that the model knows to start generating
an assistant response.</li>`,un,qe,Li=`This is a pretty simple template but Jinja gives you a lot of flexibility to do more complex things! Let’s see a Jinja
template that can format inputs similarly to the way LLaMA formats them (note that the real LLaMA template includes
handling for default system messages and slightly different system message handling in general - don’t use this one
in your actual code!)`,mn,We,dn,Ve,Pi=`Hopefully if you stare at this for a little bit you can see what this template is doing - it adds specific tokens like
<code>[INST]</code> and <code>[/INST]</code> based on the role of each message. User, assistant and system messages are clearly
distinguishable to the model because of the tokens they’re wrapped in.`,hn,_e,Jn,Re,Tn,Se,Di=`Simple, just write a jinja template and set <code>tokenizer.chat_template</code>. You may find it easier to start with an
existing template from another model and simply edit it for your needs! For example, we could take the LLaMA template
above and add ”[ASST]” and ”[/ASST]” to assistant messages:`,Un,ze,jn,Ee,Ki=`Now, simply set the <code>tokenizer.chat_template</code> attribute. Next time you use <a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a>, it will
use your new template! This attribute will be saved in the <code>tokenizer_config.json</code> file, so you can use
<a href="/docs/transformers/pr_30803/en/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> to upload your new template to the Hub and make sure everyone’s using the right
template for your model!`,wn,Xe,fn,He,Oi=`The method <a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a> which uses your chat template is called by the <a href="/docs/transformers/pr_30803/en/main_classes/pipelines#transformers.TextGenerationPipeline">TextGenerationPipeline</a> class, so
once you set the correct chat template, your model will automatically become compatible with <a href="/docs/transformers/pr_30803/en/main_classes/pipelines#transformers.TextGenerationPipeline">TextGenerationPipeline</a>.`,In,V,gn,Ye,bn,Fe,tp=`Some models use different templates for different use cases. For example, they might use one template for normal chat
and another for tool-use, or retrieval-augmented generation. In these cases, <code>tokenizer.chat_template</code> is a dictionary.
This can cause some confusion, and where possible, we recommend using a single template for all use-cases. You can use
Jinja statements like <code>if tools is defined</code> and <code>{% macro %}</code> definitions to easily wrap multiple code paths in a
single template.`,Cn,Le,ep=`When a tokenizer has multiple templates, <code>tokenizer.chat_template</code> will be a <code>dict</code>, where each key is the name
of a template. The <code>apply_chat_template</code> method has special handling for certain template names: Specifically, it will
look for a template named <code>default</code> in most cases, and will raise an error if it can’t find one. However, if a template
named <code>tool_use</code> exists when the user has passed a <code>tools</code> argument, it will use that instead. To access templates
with other names, pass the name of the template you want to the <code>chat_template</code> argument of
<code>apply_chat_template()</code>.`,$n,Pe,lp=`We find that this can be a bit confusing for users, though - so if you’re writing a template yourself, we recommend
trying to put it all in a single template where possible!`,xn,De,Gn,Ke,sp=`When setting the template for a model that’s already been trained for chat, you should ensure that the template
exactly matches the message formatting that the model saw during training, or else you will probably experience
performance degradation. This is true even if you’re training the model further - you will probably get the best
performance if you keep the chat tokens constant. This is very analogous to tokenization - you generally get the
best performance for inference or fine-tuning when you precisely match the tokenization used during training.`,vn,Oe,ap=`If you’re training a model from scratch, or fine-tuning a base language model for chat, on the other hand,
you have a lot of freedom to choose an appropriate template! LLMs are smart enough to learn to handle lots of different
input formats. One popular choice is the <code>ChatML</code> format, and this is a good, flexible choice for many use-cases.
It looks like this:`,Bn,tl,Nn,el,np=`If you like this one, here it is in one-liner form, ready to copy into your code. The one-liner also includes
handy support for <a href="#what-are-generation-prompts">generation prompts</a>, but note that it doesn’t add BOS or EOS tokens!
If your model expects those, they won’t be added automatically by <code>apply_chat_template</code> - in other words, the
text will be tokenized with <code>add_special_tokens=False</code>. This is to avoid potential conflicts between the template and
the <code>add_special_tokens</code> logic. If your model expects special tokens, make sure to add them to the template!`,Zn,ll,An,sl,op=`This template wraps each message in <code>&lt;|im_start|&gt;</code> and <code>&lt;|im_end|&gt;</code> tokens, and simply writes the role as a string, which
allows for flexibility in the roles you train with. The output looks like this:`,Qn,al,kn,nl,ip=`The “user”, “system” and “assistant” roles are the standard for chat, and we recommend using them when it makes sense,
particularly if you want your model to operate well with <a href="/docs/transformers/pr_30803/en/main_classes/pipelines#transformers.TextGenerationPipeline">TextGenerationPipeline</a>. However, you are not limited
to these roles - templating is extremely flexible, and any string can be a role.`,qn,ol,Wn,il,pp=`If you have any chat models, you should set their <code>tokenizer.chat_template</code> attribute and test it using
<a href="/docs/transformers/pr_30803/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a>, then push the updated tokenizer to the Hub. This applies even if you’re
not the model owner - if you’re using a model with an empty chat template, or one that’s still using the default class
template, please open a <a href="https://huggingface.co/docs/hub/repositories-pull-requests-discussions" rel="nofollow">pull request</a> to the model repository so that this attribute can be set properly!`,Vn,pl,Mp=`Once the attribute is set, that’s it, you’re done! <code>tokenizer.apply_chat_template</code> will now work correctly for that
model, which means it is also automatically supported in places like <code>TextGenerationPipeline</code>!`,_n,Ml,rp=`By ensuring that models have this attribute, we can make sure that the whole community gets to use the full power of
open-source models. Formatting mismatches have been haunting the field and silently harming performance for too long -
it’s time to put an end to them!`,Rn,rl,Sn,_,zn,yl,yp=`Jinja templates in <code>transformers</code> are identical to Jinja templates elsewhere. The main thing to know is that
the conversation history will be accessible inside your template as a variable called <code>messages</code>.
You will be able to access <code>messages</code> in your template just like you can in Python, which means you can loop over
it with <code>{% for message in messages %}</code> or access individual messages with <code>{{ messages[0] }}</code>, for example.`,En,cl,cp="You can also use the following tips to write clean, efficient Jinja templates:",Xn,ul,Hn,ml,up=`By default, Jinja will print any whitespace that comes before or after a block. This can be a problem for chat
templates, which generally want to be very precise with whitespace! To avoid this, we strongly recommend writing
your templates like this:`,Yn,dl,Fn,hl,mp="rather than like this:",Ln,Jl,Pn,Tl,dp=`Adding <code>-</code> will strip any whitespace that comes before the block. The second example looks innocent, but the newline
and indentation may end up being included in the output, which is probably not what you want!`,Dn,Ul,Kn,jl,hp=`Inside your template, you will have access several special variables. The most important of these is <code>messages</code>,
which contains the chat history as a list of message dicts. However, there are several others. Not every
variable will be used in every template. The most common other variables are:`,On,wl,Jp="<li><code>tools</code> contains a list of tools in JSON schema format. Will be <code>None</code> or undefined if no tools are passed.</li> <li><code>documents</code> contains a list of documents in the format <code>{&quot;title&quot;: &quot;Title&quot;, &quot;contents&quot;: &quot;Contents&quot;}</code>, used for retrieval-augmented generation. Will be <code>None</code> or undefined if no documents are passed.</li> <li><code>add_generation_prompt</code> is a bool that is <code>True</code> if the user has requested a generation prompt, and <code>False</code> otherwise. If this is set, your template should add the header for an assistant message to the end of the conversation. If your model doesn’t have a specific header for assistant messages, you can ignore this flag.</li> <li><strong>Special tokens</strong> like <code>bos_token</code> and <code>eos_token</code>. These are extracted from <code>tokenizer.special_tokens_map</code>. The exact tokens available inside each template will differ depending on the parent tokenizer.</li>",to,R,eo,fl,lo,Il,Tp="There is also a short list of callable functions available to you inside your templates. These are:",so,gl,Up=`<li><code>raise_exception(msg)</code>: Raises a <code>TemplateException</code>. This is useful for debugging, and for telling users when they’re
doing something that your template doesn’t support.</li> <li><code>strftime_now(format_str)</code>: Equivalent to <code>datetime.now().strftime(format_str)</code> in Python. This is used for getting
the current date/time in a specific format, which is sometimes included in system messages.</li>`,ao,bl,no,Cl,jp=`There are multiple implementations of Jinja in various languages. They generally have the same syntax,
but a key difference is that when you’re writing a template in Python you can use Python methods, such as
<code>.lower()</code> on strings or <code>.items()</code> on dicts. This will break if someone tries to use your template on a non-Python
implementation of Jinja. Non-Python implementations are particularly common in deployment environments, where JS
and Rust are very popular.`,oo,$l,wp=`Don’t panic, though! There are a few easy changes you can make to your templates to ensure they’re compatible across
all implementations of Jinja:`,io,xl,fp=`<li>Replace Python methods with Jinja filters. These usually have the same name, for example <code>string.lower()</code> becomes
<code>string|lower</code>, and <code>dict.items()</code> becomes <code>dict|items</code>. One notable change is that <code>string.strip()</code> becomes <code>string|trim</code>.
See the <a href="https://jinja.palletsprojects.com/en/3.1.x/templates/#builtin-filters" rel="nofollow">list of built-in filters</a>
in the Jinja documentation for more.</li> <li>Replace <code>True</code>, <code>False</code> and <code>None</code>, which are Python-specific, with <code>true</code>, <code>false</code> and <code>none</code>.</li> <li>Directly rendering a dict or list may give different results in other implementations (for example, string entries
might change from single-quoted to double-quoted). Adding the <code>tojson</code> filter can help to ensure consistency here.</li>`,po,Gl,Mo,vl,Ip=`We mentioned above that <code>add_generation_prompt</code> is a special variable that will be accessible inside your template,
and is controlled by the user setting the <code>add_generation_prompt</code> flag. If your model expects a header for
assistant messages, then your template must support adding the header when <code>add_generation_prompt</code> is set.`,ro,Bl,gp="Here is an example of a template that formats messages ChatML-style, with generation prompt support:",yo,Nl,co,Zl,bp=`The exact content of the assistant header will depend on your specific model, but it should always be <strong>the string
that represents the start of an assistant message</strong>, so that if the user applies your template with
<code>add_generation_prompt=True</code> and then generates text, the model will write an assistant response. Also note that some
models do not need a generation prompt, because assistant messages always begin immediately after user messages.
This is particularly common for LLaMA and Mistral models, where assistant messages begin immediately after the <code>[/INST]</code>
token that ends user messages. In these cases, the template can ignore the <code>add_generation_prompt</code> flag.`,uo,Al,Cp=`Generation prompts are important! If your model requires a generation prompt but it is not set in the template, then
model generations will likely be severely degraded, or the model may display unusual behaviour like continuing
the final user message!`,mo,Ql,ho,kl,$p=`When this feature was introduced, most templates were quite small, the Jinja equivalent of a “one-liner” script.
However, with new models and features like tool-use and RAG, some templates can be 100 lines long or more. When
writing templates like these, it’s a good idea to write them in a separate file, using a text editor. You can easily
extract a chat template to a file:`,Jo,ql,To,Wl,xp="Or load the edited template back into the tokenizer:",Uo,Vl,jo,_l,Gp=`As an added bonus, when you write a long, multi-line template in a separate file, line numbers in that file will
exactly correspond to line numbers in template parsing or execution errors. This will make it much easier to
identify the source of issues.`,wo,Rl,fo,Sl,vp=`Although chat templates do not enforce a specific API for tools (or for anything, really), we recommend
template authors try to stick to a standard API where possible. The whole point of chat templates is to allow code
to be transferable across models, so deviating from the standard tools API means users will have to write
custom code to use tools with your model. Sometimes it’s unavoidable, but often with clever templating you can
make the standard API work!`,Io,zl,Bp="Below, we’ll list the elements of the standard API, and give tips on writing templates that will work well with it.",go,El,bo,Xl,Np=`Your template should expect that the variable <code>tools</code> will either be null (if no tools are passed), or is a list
of JSON schema dicts. Our chat template methods allow users to pass tools as either JSON schema or Python functions, but when
functions are passed, we automatically generate JSON schema and pass that to your template. As a result, the
<code>tools</code> variable that your template receives will always be a list of JSON schema. Here is
a sample tool JSON schema:`,Co,Hl,$o,Yl,Zp=`And here is some example code for handling tools in your chat template. Remember, this is just an example for a
specific format - your model will probably need different formatting!`,xo,Fl,Go,Ll,Ap=`The specific tokens and tool descriptions your template renders should of course be chosen to match the ones your model
was trained with. There is no requirement that your <strong>model</strong> understands JSON schema input, only that your template can translate
JSON schema into your model’s format. For example, <a href="https://huggingface.co/CohereForAI/c4ai-command-r-plus-08-2024" rel="nofollow">Command-R</a>
was trained with tools defined using Python function headers, but the Command-R tool template accepts JSON schema,
converts types internally and renders the input tools as Python headers. You can do a lot with templates!`,vo,Pl,Bo,Dl,Qp=`Tool calls, if present, will be a list attached to a message with the “assistant” role. Note that <code>tool_calls</code> is
always a list, even though most tool-calling models only support single tool calls at a time, which means
the list will usually only have a single element. Here is a sample message dict containing a tool call:`,No,Kl,Zo,Ol,kp="And a common pattern for handling them would be something like this:",Ao,ts,Qo,es,qp="Again, you should render the tool call with the formatting and special tokens that your model expects.",ko,ls,qo,ss,Wp=`Tool responses have a simple format: They are a message dict with the “tool” role, a “name” key giving the name
of the called function, and a “content” key containing the result of the tool call. Here is a sample tool response:`,Wo,as,Vo,ns,Vp=`You don’t need to use all of the keys in the tool response. For example, if your model doesn’t expect the function
name to be included in the tool response, then rendering it can be as simple as:`,_o,os,Ro,is,_p=`Again, remember that the actual formatting and special tokens are model-specific - you should take a lot of care
to ensure that tokens, whitespace and everything else exactly match the format your model was trained with!`,So,ps,zo,Ms,Eo;return C=new j({props:{title:"Chat Templates",local:"chat-templates",headingTag:"h1"}}),b=new j({props:{title:"Introduction",local:"introduction",headingTag:"h2"}}),z=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtaXN0cmFsYWklMkZNaXN0cmFsLTdCLUluc3RydWN0LXYwLjElMjIpJTBBJTBBY2hhdCUyMCUzRCUyMCU1QiUwQSUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhlbGxvJTJDJTIwaG93JTIwYXJlJTIweW91JTNGJTIyJTdEJTJDJTBBJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJJ20lMjBkb2luZyUyMGdyZWF0LiUyMEhvdyUyMGNhbiUyMEklMjBoZWxwJTIweW91JTIwdG9kYXklM0YlMjIlN0QlMkMlMEElMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJJ2QlMjBsaWtlJTIwdG8lMjBzaG93JTIwb2ZmJTIwaG93JTIwY2hhdCUyMHRlbXBsYXRpbmclMjB3b3JrcyElMjIlN0QlMkMlMEElNUQlMEElMEF0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZShjaGF0JTJDJTIwdG9rZW5pemUlM0RGYWxzZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-Instruct-v0.1&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>chat = [
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;m doing great. How can I help you today?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;d like to show off how chat templating works!&quot;</span>},
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.apply_chat_template(chat, tokenize=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot;&lt;s&gt; [INST] Hello, how are you? [/INST] I&#x27;m doing great. How can I help you today?&lt;/s&gt; [INST] I&#x27;d like to show off how chat templating works! [/INST]&quot;</span>`,wrap:!1}}),H=new J({props:{code:"JTNDJTdDdXNlciU3QyUzRSUwQUhlbGxvJTJDJTIwaG93JTIwYXJlJTIweW91JTNGJTNDJTJGcyUzRSUwQSUzQyU3Q2Fzc2lzdGFudCU3QyUzRSUwQUknbSUyMGRvaW5nJTIwZ3JlYXQuJTIwSG93JTIwY2FuJTIwSSUyMGhlbHAlMjB5b3UlMjB0b2RheSUzRiUzQyUyRnMlM0UlMEElM0MlN0N1c2VyJTdDJTNFJTBBSSdkJTIwbGlrZSUyMHRvJTIwc2hvdyUyMG9mZiUyMGhvdyUyMGNoYXQlMjB0ZW1wbGF0aW5nJTIwd29ya3MhJTNDJTJGcyUzRQ==",highlighted:`&lt;|user|&gt;
Hello, how are you?&lt;/s&gt;
&lt;|assistant|&gt;
I&#x27;m doing great. How can I help you today?&lt;/s&gt;
&lt;|user|&gt;
I&#x27;d like to show off how chat templating works!&lt;/s&gt;`,wrap:!1}}),N=new v({props:{$$slots:{default:[pM]},$$scope:{ctx:g}}}),F=new j({props:{title:"How do I use chat templates?",local:"how-do-i-use-chat-templates",headingTag:"h2"}}),P=new j({props:{title:"Usage with text-only LLMs",local:"usage-with-text-only-llms",headingTag:"h2"}}),K=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJIdWdnaW5nRmFjZUg0JTJGemVwaHlyLTdiLWJldGElMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTIwJTIwJTIzJTIwWW91JTIwbWF5JTIwd2FudCUyMHRvJTIwdXNlJTIwYmZsb2F0MTYlMjBhbmQlMkZvciUyMG1vdmUlMjB0byUyMEdQVSUyMGhlcmUlMEElMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhvdyUyMG1hbnklMjBoZWxpY29wdGVycyUyMGNhbiUyMGElMjBodW1hbiUyMGVhdCUyMGluJTIwb25lJTIwc2l0dGluZyUzRiUyMiU3RCUyQyUwQSUyMCU1RCUwQXRva2VuaXplZF9jaGF0JTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzRFRydWUlMkMlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKHRva2VuaXplZF9jaGF0JTVCMCU1RCkp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

checkpoint = <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(checkpoint)
model = AutoModelForCausalLM.from_pretrained(checkpoint)  <span class="hljs-comment"># You may want to use bfloat16 and/or move to GPU here</span>

messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a friendly chatbot who always responds in the style of a pirate&quot;</span>,
    },
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;How many helicopters can a human eat in one sitting?&quot;</span>},
 ]
tokenized_chat = tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">True</span>, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-built_in">print</span>(tokenizer.decode(tokenized_chat[<span class="hljs-number">0</span>]))`,wrap:!1}}),tt=new J({props:{code:"JTNDJTdDc3lzdGVtJTdDJTNFJTBBWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUzQyUyRnMlM0UlMEElM0MlN0N1c2VyJTdDJTNFJTBBSG93JTIwbWFueSUyMGhlbGljb3B0ZXJzJTIwY2FuJTIwYSUyMGh1bWFuJTIwZWF0JTIwaW4lMjBvbmUlMjBzaXR0aW5nJTNGJTNDJTJGcyUzRSUwQSUzQyU3Q2Fzc2lzdGFudCU3QyUzRQ==",highlighted:`&lt;|system|&gt;
You are a friendly chatbot who always responds in the style of a pirate&lt;/s&gt;
&lt;|user|&gt;
How many helicopters can a human eat in one sitting?&lt;/s&gt;
&lt;|assistant|&gt;`,wrap:!1}}),lt=new J({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKHRva2VuaXplZF9jaGF0JTJDJTIwbWF4X25ld190b2tlbnMlM0QxMjgpJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShvdXRwdXRzJTVCMCU1RCkp",highlighted:`outputs = model.generate(tokenized_chat, max_new_tokens=<span class="hljs-number">128</span>)
<span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>]))`,wrap:!1}}),at=new J({props:{code:"JTNDJTdDc3lzdGVtJTdDJTNFJTBBWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUzQyUyRnMlM0UlMEElM0MlN0N1c2VyJTdDJTNFJTBBSG93JTIwbWFueSUyMGhlbGljb3B0ZXJzJTIwY2FuJTIwYSUyMGh1bWFuJTIwZWF0JTIwaW4lMjBvbmUlMjBzaXR0aW5nJTNGJTNDJTJGcyUzRSUwQSUzQyU3Q2Fzc2lzdGFudCU3QyUzRSUwQU1hdGV5JTJDJTIwSSdtJTIwYWZyYWlkJTIwSSUyMG11c3QlMjBpbmZvcm0lMjB5ZSUyMHRoYXQlMjBodW1hbnMlMjBjYW5ub3QlMjBlYXQlMjBoZWxpY29wdGVycy4lMjBIZWxpY29wdGVycyUyMGFyZSUyMG5vdCUyMGZvb2QlMkMlMjB0aGV5JTIwYXJlJTIwZmx5aW5nJTIwbWFjaGluZXMuJTIwRm9vZCUyMGlzJTIwbWVhbnQlMjB0byUyMGJlJTIwZWF0ZW4lMkMlMjBsaWtlJTIwYSUyMGhlYXJ0eSUyMHBsYXRlJTIwbyclMjBncm9nJTJDJTIwYSUyMHNhdm9yeSUyMGJvd2wlMjBvJyUyMHN0ZXclMkMlMjBvciUyMGElMjBkZWxpY2lvdXMlMjBsb2FmJTIwbyclMjBicmVhZC4lMjBCdXQlMjBoZWxpY29wdGVycyUyQyUyMHRoZXklMjBiZSUyMGZvciUyMHRyYW5zcG9ydGluJyUyMGFuZCUyMG1vdmluJyUyMGFyb3VuZCUyQyUyMG5vdCUyMGZvciUyMGVhdGluJy4lMjBTbyUyQyUyMEknZCUyMHNheSUyMG5vbmUlMkMlMjBtZSUyMGhlYXJ0aWVzLiUyME5vbmUlMjBhdCUyMGFsbC4=",highlighted:`&lt;|system|&gt;
You are a friendly chatbot who always responds in the style of a pirate&lt;/s&gt;
&lt;|user|&gt;
How many helicopters can a human eat in one sitting?&lt;/s&gt;
&lt;|assistant|&gt;
Matey, I&#x27;m afraid I must inform ye that humans cannot eat helicopters. Helicopters are not food, they are flying machines. Food is meant to be eaten, like a hearty plate o&#x27; grog, a savory bowl o&#x27; stew, or a delicious loaf o&#x27; bread. But helicopters, they be for transportin&#x27; and movin&#x27; around, not for eatin&#x27;. So, I&#x27;d say none, me hearties. None at all.`,wrap:!1}}),nt=new j({props:{title:"Usage with multimodal LLMs",local:"usage-with-multimodal-llms",headingTag:"h2"}}),pt=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBMbGF2YU9uZXZpc2lvbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIybGxhdmEtaGYlMkZsbGF2YS1vbmV2aXNpb24tcXdlbjItMC41Yi1vdi1oZiUyMiUwQW1vZGVsJTIwJTNEJTIwTGxhdmFPbmV2aXNpb25Gb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUyMCUyMCUyMyUyMFlvdSUyMG1heSUyMHdhbnQlMjB0byUyMHVzZSUyMGJmbG9hdDE2JTIwYW5kJTJGb3IlMjBtb3ZlJTIwdG8lMjBHUFUlMjBoZXJlJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBJTBBbWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCU1QiU3QiUyMnR5cGUlMjIlM0ElMjAlMjJ0ZXh0JTIyJTJDJTIwJTIydGV4dCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGElMjBmcmllbmRseSUyMGNoYXRib3QlMjB3aG8lMjBhbHdheXMlMjByZXNwb25kcyUyMGluJTIwdGhlJTIwc3R5bGUlMjBvZiUyMGElMjBwaXJhdGUlMjIlN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIyaW1hZ2UlMjIlMkMlMjAlMjJ1cmwlMjIlM0ElMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIydHlwZSUyMiUzQSUyMCUyMnRleHQlMjIlMkMlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIyV2hhdCUyMGFyZSUyMHRoZXNlJTNGJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTVEJTBBJTBBcHJvY2Vzc2VkX2NoYXQlMjAlM0QlMjBwcm9jZXNzb3IuYXBwbHlfY2hhdF90ZW1wbGF0ZShtZXNzYWdlcyUyQyUyMHRva2VuaXplJTNEVHJ1ZSUyQyUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUzRFRydWUlMkMlMjByZXR1cm5fZGljdCUzRFRydWUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQXByaW50KHByb2Nlc3Nvci5iYXRjaF9kZWNvZGUocHJvY2Vzc2VkX2NoYXQlNUIlMjJpbnB1dF9pZHMlMjIlNUQlNUIlM0ElMkMlMjAlM0EzMCU1RCkp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, LlavaOnevisionForConditionalGeneration

model_id = <span class="hljs-string">&quot;llava-hf/llava-onevision-qwen2-0.5b-ov-hf&quot;</span>
model = LlavaOnevisionForConditionalGeneration.from_pretrained(model_id)  <span class="hljs-comment"># You may want to use bfloat16 and/or move to GPU here</span>
processor = AutoProcessor.from_pretrained(model_id)

messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;You are a friendly chatbot who always responds in the style of a pirate&quot;</span>}],
    },
    {
      <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
      <span class="hljs-string">&quot;content&quot;</span>: [
          {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>},
          {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What are these?&quot;</span>},
        ],
    },
]

processed_chat = processor.apply_chat_template(messages, tokenize=<span class="hljs-literal">True</span>, add_generation_prompt=<span class="hljs-literal">True</span>, return_dict=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-built_in">print</span>(processor.batch_decode(processed_chat[<span class="hljs-string">&quot;input_ids&quot;</span>][:, :<span class="hljs-number">30</span>]))`,wrap:!1}}),rt=new J({props:{code:"JyUzQyU3Q2ltX3N0YXJ0JTdDJTNFc3lzdGVtJTBBWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUzQyU3Q2ltX2VuZCU3QyUzRSUzQyU3Q2ltX3N0YXJ0JTdDJTNFdXNlciUyMCUzQ2ltYWdlJTNFJTNDaW1hZ2UlM0UlM0NpbWFnZSUzRSUzQ2ltYWdlJTNFJTNDaW1hZ2UlM0UlM0NpbWFnZSUzRSUzQ2ltYWdlJTNFJTNDaW1hZ2UlM0Un",highlighted:`&#x27;&lt;|im_start|&gt;system
You are a friendly chatbot who always responds in the style of a pirate&lt;|im_end|&gt;&lt;|im_start|&gt;user &lt;image&gt;&lt;image&gt;&lt;image&gt;&lt;image&gt;&lt;image&gt;&lt;image&gt;&lt;image&gt;&lt;image&gt;&#x27;`,wrap:!1}}),ct=new j({props:{title:"Is there an automated pipeline for chat?",local:"is-there-an-automated-pipeline-for-chat",headingTag:"h2"}}),mt=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnRleHQtZ2VuZXJhdGlvbiUyMiUyQyUyMCUyMkh1Z2dpbmdGYWNlSDQlMkZ6ZXBoeXItN2ItYmV0YSUyMiklMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhvdyUyMG1hbnklMjBoZWxpY29wdGVycyUyMGNhbiUyMGElMjBodW1hbiUyMGVhdCUyMGluJTIwb25lJTIwc2l0dGluZyUzRiUyMiU3RCUyQyUwQSU1RCUwQXByaW50KHBpcGUobWVzc2FnZXMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEyOCklNUIwJTVEJTVCJ2dlbmVyYXRlZF90ZXh0JyU1RCU1Qi0xJTVEKSUyMCUyMCUyMyUyMFByaW50JTIwdGhlJTIwYXNzaXN0YW50J3MlMjByZXNwb25zZQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>)
messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a friendly chatbot who always responds in the style of a pirate&quot;</span>,
    },
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;How many helicopters can a human eat in one sitting?&quot;</span>},
]
<span class="hljs-built_in">print</span>(pipe(messages, max_new_tokens=<span class="hljs-number">128</span>)[<span class="hljs-number">0</span>][<span class="hljs-string">&#x27;generated_text&#x27;</span>][-<span class="hljs-number">1</span>])  <span class="hljs-comment"># Print the assistant&#x27;s response</span>`,wrap:!1}}),dt=new J({props:{code:"JTdCJ3JvbGUnJTNBJTIwJ2Fzc2lzdGFudCclMkMlMjAnY29udGVudCclM0ElMjAlMjJNYXRleSUyQyUyMEknbSUyMGFmcmFpZCUyMEklMjBtdXN0JTIwaW5mb3JtJTIweWUlMjB0aGF0JTIwaHVtYW5zJTIwY2Fubm90JTIwZWF0JTIwaGVsaWNvcHRlcnMuJTIwSGVsaWNvcHRlcnMlMjBhcmUlMjBub3QlMjBmb29kJTJDJTIwdGhleSUyMGFyZSUyMGZseWluZyUyMG1hY2hpbmVzLiUyMEZvb2QlMjBpcyUyMG1lYW50JTIwdG8lMjBiZSUyMGVhdGVuJTJDJTIwbGlrZSUyMGElMjBoZWFydHklMjBwbGF0ZSUyMG8nJTIwZ3JvZyUyQyUyMGElMjBzYXZvcnklMjBib3dsJTIwbyclMjBzdGV3JTJDJTIwb3IlMjBhJTIwZGVsaWNpb3VzJTIwbG9hZiUyMG8nJTIwYnJlYWQuJTIwQnV0JTIwaGVsaWNvcHRlcnMlMkMlMjB0aGV5JTIwYmUlMjBmb3IlMjB0cmFuc3BvcnRpbiclMjBhbmQlMjBtb3ZpbiclMjBhcm91bmQlMkMlMjBub3QlMjBmb3IlMjBlYXRpbicuJTIwU28lMkMlMjBJJ2QlMjBzYXklMjBub25lJTJDJTIwbWUlMjBoZWFydGllcy4lMjBOb25lJTIwYXQlMjBhbGwuJTIyJTdE",highlighted:"{&#x27;role&#x27;: &#x27;assistant&#x27;, &#x27;content&#x27;: &quot;Matey, I&#x27;m afraid I must inform ye that humans cannot eat helicopters. Helicopters are not food, they are flying machines. Food is meant to be eaten, like a hearty plate o&#x27; grog, a savory bowl o&#x27; stew, or a delicious loaf o&#x27; bread. But helicopters, they be for transportin&#x27; and movin&#x27; around, not for eatin&#x27;. So, I&#x27;d say none, me hearties. None at all.&quot;}",wrap:!1}}),Jt=new j({props:{title:"What are “generation prompts”?",local:"what-are-generation-prompts",headingTag:"h2"}}),Ut=new J({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJIaSUyMHRoZXJlISUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyTmljZSUyMHRvJTIwbWVldCUyMHlvdSElMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJDYW4lMjBJJTIwYXNrJTIwYSUyMHF1ZXN0aW9uJTNGJTIyJTdEJTBBJTVE",highlighted:`messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hi there!&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Nice to meet you!&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Can I ask a question?&quot;</span>}
]`,wrap:!1}}),wt=new J({props:{code:"dG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNERmFsc2UpJTBBJTIyJTIyJTIyJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBSGklMjB0aGVyZSElM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRWFzc2lzdGFudCUwQU5pY2UlMjB0byUyMG1lZXQlMjB5b3UhJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBQ2FuJTIwSSUyMGFzayUyMGElMjBxdWVzdGlvbiUzRiUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUyMiUyMiUyMg==",highlighted:`tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot;&quot;&quot;&lt;|im_start|&gt;user
Hi there!&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
Nice to meet you!&lt;|im_end|&gt;
&lt;|im_start|&gt;user
Can I ask a question?&lt;|im_end|&gt;
&quot;&quot;&quot;</span>`,wrap:!1}}),It=new J({props:{code:"dG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSklMEElMjIlMjIlMjIlM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFIaSUyMHRoZXJlISUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50JTBBTmljZSUyMHRvJTIwbWVldCUyMHlvdSElM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFDYW4lMjBJJTIwYXNrJTIwYSUyMHF1ZXN0aW9uJTNGJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlMEElMjIlMjIlMjI=",highlighted:`tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;&quot;&quot;&lt;|im_start|&gt;user
Hi there!&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
Nice to meet you!&lt;|im_end|&gt;
&lt;|im_start|&gt;user
Can I ask a question?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
&quot;&quot;&quot;</span>`,wrap:!1}}),Ct=new j({props:{title:"What does “continue_final_message” do?",local:"what-does-continuefinalmessage-do",headingTag:"h2"}}),Gt=new J({props:{code:"Y2hhdCUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkNhbiUyMHlvdSUyMGZvcm1hdCUyMHRoZSUyMGFuc3dlciUyMGluJTIwSlNPTiUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJyU3QiUyMm5hbWUlMjIlM0ElMjAlMjInJTdEJTJDJTBBJTVEJTBBJTBBZm9ybWF0dGVkX2NoYXQlMjAlM0QlMjB0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZShjaGF0JTJDJTIwdG9rZW5pemUlM0RUcnVlJTJDJTIwcmV0dXJuX2RpY3QlM0RUcnVlJTJDJTIwY29udGludWVfZmluYWxfbWVzc2FnZSUzRFRydWUpJTBBbW9kZWwuZ2VuZXJhdGUoKipmb3JtYXR0ZWRfY2hhdCk=",highlighted:`chat = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Can you format the answer in JSON?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&#x27;{&quot;name&quot;: &quot;&#x27;</span>},
]

formatted_chat = tokenizer.apply_chat_template(chat, tokenize=<span class="hljs-literal">True</span>, return_dict=<span class="hljs-literal">True</span>, continue_final_message=<span class="hljs-literal">True</span>)
model.generate(**formatted_chat)`,wrap:!1}}),Z=new v({props:{$$slots:{default:[MM]},$$scope:{ctx:g}}}),Nt=new j({props:{title:"Can I use chat templates in training?",local:"can-i-use-chat-templates-in-training",headingTag:"h2"}}),At=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBEYXRhc2V0JTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIySHVnZ2luZ0ZhY2VINCUyRnplcGh5ci03Yi1iZXRhJTIyKSUwQSUwQWNoYXQxJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hpY2glMjBpcyUyMGJpZ2dlciUyQyUyMHRoZSUyMG1vb24lMjBvciUyMHRoZSUyMHN1biUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyVGhlJTIwc3VuLiUyMiU3RCUwQSU1RCUwQWNoYXQyJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hpY2glMjBpcyUyMGJpZ2dlciUyQyUyMGElMjB2aXJ1cyUyMG9yJTIwYSUyMGJhY3Rlcml1bSUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyQSUyMGJhY3Rlcml1bS4lMjIlN0QlMEElNUQlMEElMEFkYXRhc2V0JTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIyY2hhdCUyMiUzQSUyMCU1QmNoYXQxJTJDJTIwY2hhdDIlNUQlN0QpJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKGxhbWJkYSUyMHglM0ElMjAlN0IlMjJmb3JtYXR0ZWRfY2hhdCUyMiUzQSUyMHRva2VuaXplci5hcHBseV9jaGF0X3RlbXBsYXRlKHglNUIlMjJjaGF0JTIyJTVEJTJDJTIwdG9rZW5pemUlM0RGYWxzZSUyQyUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUzREZhbHNlKSU3RCklMEFwcmludChkYXRhc2V0JTVCJ2Zvcm1hdHRlZF9jaGF0JyU1RCU1QjAlNUQp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>)

chat1 = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Which is bigger, the moon or the sun?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;The sun.&quot;</span>}
]
chat2 = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Which is bigger, a virus or a bacterium?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;A bacterium.&quot;</span>}
]

dataset = Dataset.from_dict({<span class="hljs-string">&quot;chat&quot;</span>: [chat1, chat2]})
dataset = dataset.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> x: {<span class="hljs-string">&quot;formatted_chat&quot;</span>: tokenizer.apply_chat_template(x[<span class="hljs-string">&quot;chat&quot;</span>], tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">False</span>)})
<span class="hljs-built_in">print</span>(dataset[<span class="hljs-string">&#x27;formatted_chat&#x27;</span>][<span class="hljs-number">0</span>])`,wrap:!1}}),kt=new J({props:{code:"JTNDJTdDdXNlciU3QyUzRSUwQVdoaWNoJTIwaXMlMjBiaWdnZXIlMkMlMjB0aGUlMjBtb29uJTIwb3IlMjB0aGUlMjBzdW4lM0YlM0MlMkZzJTNFJTBBJTNDJTdDYXNzaXN0YW50JTdDJTNFJTBBVGhlJTIwc3VuLiUzQyUyRnMlM0U=",highlighted:`&lt;|user|&gt;
Which is bigger, the moon or the sun?&lt;/s&gt;
&lt;|assistant|&gt;
The sun.&lt;/s&gt;`,wrap:!1}}),A=new v({props:{$$slots:{default:[rM]},$$scope:{ctx:g}}}),Wt=new j({props:{title:"Advanced: Extra inputs to chat templates",local:"advanced-extra-inputs-to-chat-templates",headingTag:"h2"}}),Rt=new j({props:{title:"Advanced: Tool use / function calling",local:"advanced-tool-use--function-calling",headingTag:"h2"}}),zt=new J({props:{code:"aW1wb3J0JTIwZGF0ZXRpbWUlMEElMEFkZWYlMjBjdXJyZW50X3RpbWUoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkdldCUyMHRoZSUyMGN1cnJlbnQlMjBsb2NhbCUyMHRpbWUlMjBhcyUyMGElMjBzdHJpbmcuJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc3RyKGRhdGV0aW1lLm5vdygpKSUwQSUwQWRlZiUyMG11bHRpcGx5KGElM0ElMjBmbG9hdCUyQyUyMGIlM0ElMjBmbG9hdCklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBBJTIwZnVuY3Rpb24lMjB0aGF0JTIwbXVsdGlwbGllcyUyMHR3byUyMG51bWJlcnMlMEElMEElMjAlMjAlMjAlMjBBcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYSUzQSUyMFRoZSUyMGZpcnN0JTIwbnVtYmVyJTIwdG8lMjBtdWx0aXBseSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGIlM0ElMjBUaGUlMjBzZWNvbmQlMjBudW1iZXIlMjB0byUyMG11bHRpcGx5JTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYSUyMColMjBiJTBBJTBBdG9vbHMlMjAlM0QlMjAlNUJjdXJyZW50X3RpbWUlMkMlMjBtdWx0aXBseSU1RCUwQSUwQW1vZGVsX2lucHV0JTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUoJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlMkMlMEElMjAlMjAlMjAlMjB0b29scyUzRHRvb2xzJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> datetime

<span class="hljs-keyword">def</span> <span class="hljs-title function_">current_time</span>():
    <span class="hljs-string">&quot;&quot;&quot;Get the current local time as a string.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">str</span>(datetime.now())

<span class="hljs-keyword">def</span> <span class="hljs-title function_">multiply</span>(<span class="hljs-params">a: <span class="hljs-built_in">float</span>, b: <span class="hljs-built_in">float</span></span>):
    <span class="hljs-string">&quot;&quot;&quot;
    A function that multiplies two numbers

    Args:
        a: The first number to multiply
        b: The second number to multiply
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

tools = [current_time, multiply]

model_input = tokenizer.apply_chat_template(
    messages,
    tools=tools
)`,wrap:!1}}),Ht=new j({props:{title:"Passing tool results to the model",local:"passing-tool-results-to-the-model",headingTag:"h3"}}),Lt=new j({props:{title:"A complete tool use example",local:"a-complete-tool-use-example",headingTag:"h3"}}),Kt=new J({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTBBJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMk5vdXNSZXNlYXJjaCUyRkhlcm1lcy0yLVByby1MbGFtYS0zLThCJTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50JTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

checkpoint = <span class="hljs-string">&quot;NousResearch/Hermes-2-Pro-Llama-3-8B&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(checkpoint)
model = AutoModelForCausalLM.from_pretrained(checkpoint, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),te=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_temperature</span>(<span class="hljs-params">location: <span class="hljs-built_in">str</span>, unit: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">float</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Get the current temperature at a location.

    Args:
        location: The location to get the temperature for, in the format &quot;City, Country&quot;
        unit: The unit to return the temperature in. (choices: [&quot;celsius&quot;, &quot;fahrenheit&quot;])
    Returns:
        The current temperature at the specified location in the specified units, as a float.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-number">22.</span>  <span class="hljs-comment"># A real function should probably actually get the temperature!</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_wind_speed</span>(<span class="hljs-params">location: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">float</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Get the current wind speed in km/h at a given location.

    Args:
        location: The location to get the temperature for, in the format &quot;City, Country&quot;
    Returns:
        The current wind speed at the given location in km/h, as a float.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-number">6.</span>  <span class="hljs-comment"># A real function should probably actually get the wind speed!</span>

tools = [get_current_temperature, get_current_wind_speed]`,wrap:!1}}),le=new J({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGElMjBib3QlMjB0aGF0JTIwcmVzcG9uZHMlMjB0byUyMHdlYXRoZXIlMjBxdWVyaWVzLiUyMFlvdSUyMHNob3VsZCUyMHJlcGx5JTIwd2l0aCUyMHRoZSUyMHVuaXQlMjB1c2VkJTIwaW4lMjB0aGUlMjBxdWVyaWVkJTIwbG9jYXRpb24uJTIyJTdEJTJDJTBBJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySGV5JTJDJTIwd2hhdCdzJTIwdGhlJTIwdGVtcGVyYXR1cmUlMjBpbiUyMFBhcmlzJTIwcmlnaHQlMjBub3clM0YlMjIlN0QlMEElNUQ=",highlighted:`messages = [
  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a bot that responds to weather queries. You should reply with the unit used in the queried location.&quot;</span>},
  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hey, what&#x27;s the temperature in Paris right now?&quot;</span>}
]`,wrap:!1}}),ae=new J({props:{code:"aW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b29scyUzRHRvb2xzJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSUyQyUyMHJldHVybl9kaWN0JTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRzJTIwJTNEJTIwJTdCayUzQSUyMHYudG8obW9kZWwuZGV2aWNlKSUyMGZvciUyMGslMkMlMjB2JTIwaW4lMjBpbnB1dHMuaXRlbXMoKSU3RCUwQW91dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMjgpJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShvdXQlNUIwJTVEJTVCbGVuKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCU1QjAlNUQpJTNBJTVEKSk=",highlighted:`inputs = tokenizer.apply_chat_template(messages, tools=tools, add_generation_prompt=<span class="hljs-literal">True</span>, return_dict=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
inputs = {k: v.to(model.device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}
out = model.generate(**inputs, max_new_tokens=<span class="hljs-number">128</span>)
<span class="hljs-built_in">print</span>(tokenizer.decode(out[<span class="hljs-number">0</span>][<span class="hljs-built_in">len</span>(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][<span class="hljs-number">0</span>]):]))`,wrap:!1}}),oe=new J({props:{code:"JTNDdG9vbF9jYWxsJTNFJTBBJTdCJTIyYXJndW1lbnRzJTIyJTNBJTIwJTdCJTIybG9jYXRpb24lMjIlM0ElMjAlMjJQYXJpcyUyQyUyMEZyYW5jZSUyMiUyQyUyMCUyMnVuaXQlMjIlM0ElMjAlMjJjZWxzaXVzJTIyJTdEJTJDJTIwJTIybmFtZSUyMiUzQSUyMCUyMmdldF9jdXJyZW50X3RlbXBlcmF0dXJlJTIyJTdEJTBBJTNDJTJGdG9vbF9jYWxsJTNFJTNDJTdDaW1fZW5kJTdDJTNF",highlighted:`&lt;tool_call&gt;
{&quot;arguments&quot;: {&quot;location&quot;: &quot;Paris, France&quot;, &quot;unit&quot;: &quot;celsius&quot;}, &quot;name&quot;: &quot;get_current_temperature&quot;}
&lt;/tool_call&gt;&lt;|im_end|&gt;`,wrap:!1}}),Q=new v({props:{$$slots:{default:[yM]},$$scope:{ctx:g}}}),Me=new J({props:{code:"dG9vbF9jYWxsJTIwJTNEJTIwJTdCJTIybmFtZSUyMiUzQSUyMCUyMmdldF9jdXJyZW50X3RlbXBlcmF0dXJlJTIyJTJDJTIwJTIyYXJndW1lbnRzJTIyJTNBJTIwJTdCJTIybG9jYXRpb24lMjIlM0ElMjAlMjJQYXJpcyUyQyUyMEZyYW5jZSUyMiUyQyUyMCUyMnVuaXQlMjIlM0ElMjAlMjJjZWxzaXVzJTIyJTdEJTdEJTBBbWVzc2FnZXMuYXBwZW5kKCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJ0b29sX2NhbGxzJTIyJTNBJTIwJTVCJTdCJTIydHlwZSUyMiUzQSUyMCUyMmZ1bmN0aW9uJTIyJTJDJTIwJTIyZnVuY3Rpb24lMjIlM0ElMjB0b29sX2NhbGwlN0QlNUQlN0Qp",highlighted:`tool_call = {<span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_temperature&quot;</span>, <span class="hljs-string">&quot;arguments&quot;</span>: {<span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;Paris, France&quot;</span>, <span class="hljs-string">&quot;unit&quot;</span>: <span class="hljs-string">&quot;celsius&quot;</span>}}
messages.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;tool_calls&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>, <span class="hljs-string">&quot;function&quot;</span>: tool_call}]})`,wrap:!1}}),k=new v({props:{warning:!0,$$slots:{default:[cM]},$$scope:{ctx:g}}}),ye=new J({props:{code:"bWVzc2FnZXMuYXBwZW5kKCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ0b29sJTIyJTJDJTIwJTIybmFtZSUyMiUzQSUyMCUyMmdldF9jdXJyZW50X3RlbXBlcmF0dXJlJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMjIyLjAlMjIlN0Qp",highlighted:'messages.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;tool&quot;</span>, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_temperature&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;22.0&quot;</span>})',wrap:!1}}),q=new v({props:{$$slots:{default:[uM]},$$scope:{ctx:g}}}),ue=new J({props:{code:"aW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b29scyUzRHRvb2xzJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSUyQyUyMHJldHVybl9kaWN0JTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRzJTIwJTNEJTIwJTdCayUzQSUyMHYudG8obW9kZWwuZGV2aWNlKSUyMGZvciUyMGslMkMlMjB2JTIwaW4lMjBpbnB1dHMuaXRlbXMoKSU3RCUwQW91dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMjgpJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShvdXQlNUIwJTVEJTVCbGVuKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCU1QjAlNUQpJTNBJTVEKSk=",highlighted:`inputs = tokenizer.apply_chat_template(messages, tools=tools, add_generation_prompt=<span class="hljs-literal">True</span>, return_dict=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
inputs = {k: v.to(model.device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}
out = model.generate(**inputs, max_new_tokens=<span class="hljs-number">128</span>)
<span class="hljs-built_in">print</span>(tokenizer.decode(out[<span class="hljs-number">0</span>][<span class="hljs-built_in">len</span>(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][<span class="hljs-number">0</span>]):]))`,wrap:!1}}),de=new J({props:{code:"VGhlJTIwY3VycmVudCUyMHRlbXBlcmF0dXJlJTIwaW4lMjBQYXJpcyUyQyUyMEZyYW5jZSUyMGlzJTIwMjIuMCUyMCVDMiVCMCUyMENlbHNpdXMuJTNDJTdDaW1fZW5kJTdDJTNF",highlighted:"The current temperature in Paris, France is 22.0 ° Celsius.&lt;|im_end|&gt;",wrap:!1}}),Je=new j({props:{title:"Understanding tool schemas",local:"understanding-tool-schemas",headingTag:"h3"}}),je=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy51dGlscyUyMGltcG9ydCUyMGdldF9qc29uX3NjaGVtYSUwQSUwQWRlZiUyMG11bHRpcGx5KGElM0ElMjBmbG9hdCUyQyUyMGIlM0ElMjBmbG9hdCklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBBJTIwZnVuY3Rpb24lMjB0aGF0JTIwbXVsdGlwbGllcyUyMHR3byUyMG51bWJlcnMlMEElMEElMjAlMjAlMjAlMjBBcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYSUzQSUyMFRoZSUyMGZpcnN0JTIwbnVtYmVyJTIwdG8lMjBtdWx0aXBseSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGIlM0ElMjBUaGUlMjBzZWNvbmQlMjBudW1iZXIlMjB0byUyMG11bHRpcGx5JTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYSUyMColMjBiJTBBJTBBc2NoZW1hJTIwJTNEJTIwZ2V0X2pzb25fc2NoZW1hKG11bHRpcGx5KSUwQXByaW50KHNjaGVtYSk=",highlighted:`<span class="hljs-keyword">from</span> transformers.utils <span class="hljs-keyword">import</span> get_json_schema

<span class="hljs-keyword">def</span> <span class="hljs-title function_">multiply</span>(<span class="hljs-params">a: <span class="hljs-built_in">float</span>, b: <span class="hljs-built_in">float</span></span>):
    <span class="hljs-string">&quot;&quot;&quot;
    A function that multiplies two numbers

    Args:
        a: The first number to multiply
        b: The second number to multiply
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

schema = get_json_schema(multiply)
<span class="hljs-built_in">print</span>(schema)`,wrap:!1}}),fe=new J({props:{code:"JTdCJTBBJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMmZ1bmN0aW9uJTIyJTJDJTBBJTIwJTIwJTIyZnVuY3Rpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJuYW1lJTIyJTNBJTIwJTIybXVsdGlwbHklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJkZXNjcmlwdGlvbiUyMiUzQSUyMCUyMkElMjBmdW5jdGlvbiUyMHRoYXQlMjBtdWx0aXBsaWVzJTIwdHdvJTIwbnVtYmVycyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMnBhcmFtZXRlcnMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyb2JqZWN0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIycHJvcGVydGllcyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmElMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIybnVtYmVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZGVzY3JpcHRpb24lMjIlM0ElMjAlMjJUaGUlMjBmaXJzdCUyMG51bWJlciUyMHRvJTIwbXVsdGlwbHklMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJiJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMm51bWJlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlc2NyaXB0aW9uJTIyJTNBJTIwJTIyVGhlJTIwc2Vjb25kJTIwbnVtYmVyJTIwdG8lMjBtdWx0aXBseSUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnJlcXVpcmVkJTIyJTNBJTIwJTVCJTIyYSUyMiUyQyUyMCUyMmIlMjIlNUQlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;function&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;function&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;multiply&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;A function that multiplies two numbers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;object&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;properties&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;a&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;number&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;The first number to multiply&quot;</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;b&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;number&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;The second number to multiply&quot;</span>
        <span class="hljs-punctuation">}</span>
      <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;required&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;a&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;b&quot;</span><span class="hljs-punctuation">]</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),be=new J({props:{code:"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",highlighted:`<span class="hljs-comment"># A simple function that takes no arguments</span>
current_time = {
  <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
  <span class="hljs-string">&quot;function&quot;</span>: {
    <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;current_time&quot;</span>,
    <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get the current local time as a string.&quot;</span>,
    <span class="hljs-string">&quot;parameters&quot;</span>: {
      <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;object&#x27;</span>,
      <span class="hljs-string">&#x27;properties&#x27;</span>: {}
    }
  }
}

<span class="hljs-comment"># A more complete function that takes two numerical arguments</span>
multiply = {
  <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;function&#x27;</span>,
  <span class="hljs-string">&#x27;function&#x27;</span>: {
    <span class="hljs-string">&#x27;name&#x27;</span>: <span class="hljs-string">&#x27;multiply&#x27;</span>,
    <span class="hljs-string">&#x27;description&#x27;</span>: <span class="hljs-string">&#x27;A function that multiplies two numbers&#x27;</span>,
    <span class="hljs-string">&#x27;parameters&#x27;</span>: {
      <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;object&#x27;</span>,
      <span class="hljs-string">&#x27;properties&#x27;</span>: {
        <span class="hljs-string">&#x27;a&#x27;</span>: {
          <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;number&#x27;</span>,
          <span class="hljs-string">&#x27;description&#x27;</span>: <span class="hljs-string">&#x27;The first number to multiply&#x27;</span>
        },
        <span class="hljs-string">&#x27;b&#x27;</span>: {
          <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;number&#x27;</span>, <span class="hljs-string">&#x27;description&#x27;</span>: <span class="hljs-string">&#x27;The second number to multiply&#x27;</span>
        }
      },
      <span class="hljs-string">&#x27;required&#x27;</span>: [<span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>]
    }
  }
}

model_input = tokenizer.apply_chat_template(
    messages,
    tools = [current_time, multiply]
)`,wrap:!1}}),Ce=new j({props:{title:"Advanced: Retrieval-augmented generation",local:"advanced-retrieval-augmented-generation",headingTag:"h2"}}),Ge=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-comment"># Load the model and tokenizer</span>
model_id = <span class="hljs-string">&quot;CohereForAI/c4ai-command-r-v01-4bit&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_id)
model = AutoModelForCausalLM.from_pretrained(model_id, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
device = model.device <span class="hljs-comment"># Get the device the model is loaded on</span>

<span class="hljs-comment"># Define conversation input</span>
conversation = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What has Man always dreamed of?&quot;</span>}
]

<span class="hljs-comment"># Define documents for retrieval-based generation</span>
documents = [
    {
        <span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-string">&quot;The Moon: Our Age-Old Foe&quot;</span>,
        <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Man has always dreamed of destroying the moon. In this essay, I shall...&quot;</span>
    },
    {
        <span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-string">&quot;The Sun: Our Age-Old Friend&quot;</span>,
        <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Although often underappreciated, the sun provides several notable benefits...&quot;</span>
    }
]

<span class="hljs-comment"># Tokenize conversation and documents using a RAG template, returning PyTorch tensors.</span>
input_ids = tokenizer.apply_chat_template(
    conversation=conversation,
    documents=documents,
    chat_template=<span class="hljs-string">&quot;rag&quot;</span>,
    tokenize=<span class="hljs-literal">True</span>,
    add_generation_prompt=<span class="hljs-literal">True</span>,
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

<span class="hljs-comment"># Generate a response</span>
gen_tokens = model.generate(
    input_ids,
    max_new_tokens=<span class="hljs-number">100</span>,
    do_sample=<span class="hljs-literal">True</span>,
    temperature=<span class="hljs-number">0.3</span>,
    )

<span class="hljs-comment"># Decode and print the generated text along with generation prompt</span>
gen_text = tokenizer.decode(gen_tokens[<span class="hljs-number">0</span>])
<span class="hljs-built_in">print</span>(gen_text)`,wrap:!1}}),W=new v({props:{$$slots:{default:[mM]},$$scope:{ctx:g}}}),ve=new j({props:{title:"Advanced: How do chat templates work?",local:"advanced-how-do-chat-templates-work",headingTag:"h2"}}),Ne=new J({props:{code:"JTdCJTI1LSUyMGZvciUyMG1lc3NhZ2UlMjBpbiUyMG1lc3NhZ2VzJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTdCLSUyMCclM0MlN0MnJTIwJTJCJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUyQiUyMCclN0MlM0UlNUNuJyUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiU3Qi0lMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTJCJTIwZW9zX3Rva2VuJTIwJTdEJTdEJTBBJTdCJTI1LSUyMGVuZGZvciUyMCUyNSU3RCUwQSU3QiUyNS0lMjBpZiUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCU3QiU3Qi0lMjAnJTNDJTdDYXNzaXN0YW50JTdDJTNFJTVDbiclMjAlN0QlN0QlMEElN0IlMjUtJTIwZW5kaWYlMjAlMjUlN0Q=",highlighted:`<span class="language-xml">{%- for message in messages %}
    </span><span class="hljs-template-variable">{{<span class="hljs-name">-</span> <span class="hljs-string">&#x27;&lt;|&#x27;</span> + message[&#x27;role&#x27;] + <span class="hljs-string">&#x27;|&gt;\\n&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{<span class="hljs-name">-</span> message[&#x27;content&#x27;] + eos_token }}</span><span class="language-xml">
{%- endfor %}
{%- if add_generation_prompt %}
    </span><span class="hljs-template-variable">{{<span class="hljs-name">-</span> <span class="hljs-string">&#x27;&lt;|assistant|&gt;\\n&#x27;</span> }}</span><span class="language-xml">
{%- endif %}</span>`,wrap:!1}}),Ae=new J({props:{code:"Zm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlM0ElMEElMjAlMjAlMjAlMjBwcmludChmJyUzQyU3QyU3Qm1lc3NhZ2UlNUIlMjJyb2xlJTIyJTVEJTdEJTdDJTNFJyklMEElMjAlMjAlMjAlMjBwcmludChtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTJCJTIwZW9zX3Rva2VuKSUwQWlmJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoJyUzQyU3Q2Fzc2lzdGFudCU3QyUzRScp",highlighted:`<span class="hljs-keyword">for</span> message <span class="hljs-keyword">in</span> messages:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;&lt;|<span class="hljs-subst">{message[<span class="hljs-string">&quot;role&quot;</span>]}</span>|&gt;&#x27;</span>)
    <span class="hljs-built_in">print</span>(message[<span class="hljs-string">&#x27;content&#x27;</span>] + eos_token)
<span class="hljs-keyword">if</span> add_generation_prompt:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;&lt;|assistant|&gt;&#x27;</span>)`,wrap:!1}}),We=new J({props:{code:"JTdCJTI1LSUyMGZvciUyMG1lc3NhZ2UlMjBpbiUyMG1lc3NhZ2VzJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1LSUyMGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCd1c2VyJyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiU3Qi0lMjBib3NfdG9rZW4lMjAlMkIlMjAnJTVCSU5TVCU1RCUyMCclMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTJCJTIwJyUyMCU1QiUyRklOU1QlNUQnJTIwJTdEJTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1LSUyMGVsaWYlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTNEJTNEJTIwJ3N5c3RlbSclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0ItJTIwJyUzQyUzQ1NZUyUzRSUzRSU1QyU1Q24nJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCUyQiUyMCclNUMlNUNuJTNDJTNDJTJGU1lTJTNFJTNFJTVDJTVDbiU1QyU1Q24nJTIwJTdEJTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1LSUyMGVsaWYlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTNEJTNEJTIwJ2Fzc2lzdGFudCclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0ItJTIwJyUyMCclMjAlMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTJCJTIwJyUyMCclMjAlMkIlMjBlb3NfdG9rZW4lMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUtJTIwZW5kaWYlMjAlMjUlN0QlMEElN0IlMjUtJTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`{%- <span class="hljs-keyword">for</span> message <span class="hljs-keyword">in</span> messages %}
    {%- <span class="hljs-keyword">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> %}
        {{- bos_token + <span class="hljs-string">&#x27;[INST] &#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; [/INST]&#x27;</span> }}
    {%- elif message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;system&#x27;</span> %}
        {{- <span class="hljs-string">&#x27;&lt;&lt;SYS&gt;&gt;\\\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27;\\\\n&lt;&lt;/SYS&gt;&gt;\\\\n\\\\n&#x27;</span> }}
    {%- elif message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;assistant&#x27;</span> %}
        {{- <span class="hljs-string">&#x27; &#x27;</span>  + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; &#x27;</span> + eos_token }}
    {%- endif %}
{%- endfor %}`,wrap:!1}}),_e=new j({props:{title:"Advanced: Adding and editing chat templates",local:"advanced-adding-and-editing-chat-templates",headingTag:"h2"}}),Re=new j({props:{title:"How do I create a chat template?",local:"how-do-i-create-a-chat-template",headingTag:"h3"}}),ze=new J({props:{code:"JTdCJTI1LSUyMGZvciUyMG1lc3NhZ2UlMjBpbiUyMG1lc3NhZ2VzJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1LSUyMGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCd1c2VyJyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiU3Qi0lMjBib3NfdG9rZW4lMjAlMkIlMjAnJTVCSU5TVCU1RCUyMCclMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVELnN0cmlwKCklMjAlMkIlMjAnJTIwJTVCJTJGSU5TVCU1RCclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUtJTIwZWxpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAnc3lzdGVtJyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiU3Qi0lMjAnJTNDJTNDU1lTJTNFJTNFJTVDJTVDbiclMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVELnN0cmlwKCklMjAlMkIlMjAnJTVDJTVDbiUzQyUzQyUyRlNZUyUzRSUzRSU1QyU1Q24lNUMlNUNuJyUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNS0lMjBlbGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCdhc3Npc3RhbnQnJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCLSUyMCclNUJBU1NUJTVEJTIwJyUyMCUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTIwJTVCJTJGQVNTVCU1RCclMjAlMkIlMjBlb3NfdG9rZW4lMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUtJTIwZW5kaWYlMjAlMjUlN0QlMEElN0IlMjUtJTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`{%- <span class="hljs-keyword">for</span> message <span class="hljs-keyword">in</span> messages %}
    {%- <span class="hljs-keyword">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> %}
        {{- bos_token + <span class="hljs-string">&#x27;[INST] &#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>].<span class="hljs-keyword">strip</span>() + <span class="hljs-string">&#x27; [/INST]&#x27;</span> }}
    {%- elif message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;system&#x27;</span> %}
        {{- <span class="hljs-string">&#x27;&lt;&lt;SYS&gt;&gt;\\\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>].<span class="hljs-keyword">strip</span>() + <span class="hljs-string">&#x27;\\\\n&lt;&lt;/SYS&gt;&gt;\\\\n\\\\n&#x27;</span> }}
    {%- elif message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;assistant&#x27;</span> %}
        {{- <span class="hljs-string">&#x27;[ASST] &#x27;</span>  + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; [/ASST]&#x27;</span> + eos_token }}
    {%- endif %}
{%- endfor %}`,wrap:!1}}),Xe=new J({props:{code:"dGVtcGxhdGUlMjAlM0QlMjB0b2tlbml6ZXIuY2hhdF90ZW1wbGF0ZSUwQXRlbXBsYXRlJTIwJTNEJTIwdGVtcGxhdGUucmVwbGFjZSglMjJTWVMlMjIlMkMlMjAlMjJTWVNURU0lMjIpJTIwJTIwJTIzJTIwQ2hhbmdlJTIwdGhlJTIwc3lzdGVtJTIwdG9rZW4lMEF0b2tlbml6ZXIuY2hhdF90ZW1wbGF0ZSUyMCUzRCUyMHRlbXBsYXRlJTIwJTIwJTIzJTIwU2V0JTIwdGhlJTIwbmV3JTIwdGVtcGxhdGUlMEF0b2tlbml6ZXIucHVzaF90b19odWIoJTIybW9kZWxfbmFtZSUyMiklMjAlMjAlMjMlMjBVcGxvYWQlMjB5b3VyJTIwbmV3JTIwdGVtcGxhdGUlMjB0byUyMHRoZSUyMEh1YiE=",highlighted:`template = tokenizer.chat_template
template = template.replace(<span class="hljs-string">&quot;SYS&quot;</span>, <span class="hljs-string">&quot;SYSTEM&quot;</span>)  <span class="hljs-comment"># Change the system token</span>
tokenizer.chat_template = template  <span class="hljs-comment"># Set the new template</span>
tokenizer.push_to_hub(<span class="hljs-string">&quot;model_name&quot;</span>)  <span class="hljs-comment"># Upload your new template to the Hub!</span>`,wrap:!1}}),V=new v({props:{$$slots:{default:[dM]},$$scope:{ctx:g}}}),Ye=new j({props:{title:"Why do some models have multiple templates?",local:"why-do-some-models-have-multiple-templates",headingTag:"h3"}}),De=new j({props:{title:"What template should I use?",local:"what-template-should-i-use",headingTag:"h3"}}),tl=new J({props:{code:"JTdCJTI1LSUyMGZvciUyMG1lc3NhZ2UlMjBpbiUyMG1lc3NhZ2VzJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTdCLSUyMCclM0MlN0NpbV9zdGFydCU3QyUzRSclMjAlMkIlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTJCJTIwJyU1Q24nJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCUyQiUyMCclM0MlN0NpbV9lbmQlN0MlM0UnJTIwJTJCJTIwJyU1Q24nJTIwJTdEJTdEJTBBJTdCJTI1LSUyMGVuZGZvciUyMCUyNSU3RA==",highlighted:`<span class="language-xml">{%- for message in messages %}
    </span><span class="hljs-template-variable">{{<span class="hljs-name">-</span> <span class="hljs-string">&#x27;&lt;|im_start|&gt;&#x27;</span> + message[&#x27;role&#x27;] + <span class="hljs-string">&#x27;\\n&#x27;</span> + message[&#x27;content&#x27;] + <span class="hljs-string">&#x27;&lt;|im_end|&gt;&#x27;</span> + <span class="hljs-string">&#x27;\\n&#x27;</span> }}</span><span class="language-xml">
{%- endfor %}</span>`,wrap:!1}}),ll=new J({props:{code:"dG9rZW5pemVyLmNoYXRfdGVtcGxhdGUlMjAlM0QlMjAlMjIlN0IlMjUlMjBpZiUyMG5vdCUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUyMGlzJTIwZGVmaW5lZCUyMCUyNSU3RCU3QiUyNSUyMHNldCUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUyMCUzRCUyMGZhbHNlJTIwJTI1JTdEJTdCJTI1JTIwZW5kaWYlMjAlMjUlN0QlN0IlMjUlMjBmb3IlMjBtZXNzYWdlJTIwaW4lMjBtZXNzYWdlcyUyMCUyNSU3RCU3QiU3QiclM0MlN0NpbV9zdGFydCU3QyUzRSclMjAlMkIlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTJCJTIwJyU1Q24nJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCUyQiUyMCclM0MlN0NpbV9lbmQlN0MlM0UnJTIwJTJCJTIwJyU1Q24nJTdEJTdEJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdEJTdCJTI1JTIwaWYlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlMjAlMjUlN0QlN0IlN0IlMjAnJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlNUNuJyUyMCU3RCU3RCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTIy",highlighted:'tokenizer.chat_template = <span class="hljs-string">&quot;{% if not add_generation_prompt is defined %}{% set add_generation_prompt = false %}{% endif %}{% for message in messages %}{{&#x27;&lt;|im_start|&gt;&#x27; + message[&#x27;role&#x27;] + &#x27;\\n&#x27; + message[&#x27;content&#x27;] + &#x27;&lt;|im_end|&gt;&#x27; + &#x27;\\n&#x27;}}{% endfor %}{% if add_generation_prompt %}{{ &#x27;&lt;|im_start|&gt;assistant\\n&#x27; }}{% endif %}&quot;</span>',wrap:!1}}),al=new J({props:{code:"JTNDJTdDaW1fc3RhcnQlN0MlM0VzeXN0ZW0lMEFZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGNoYXRib3QlMjB0aGF0JTIwd2lsbCUyMGRvJTIwaXRzJTIwYmVzdCUyMG5vdCUyMHRvJTIwc2F5JTIwYW55dGhpbmclMjBzbyUyMHN0dXBpZCUyMHRoYXQlMjBwZW9wbGUlMjB0d2VldCUyMGFib3V0JTIwaXQuJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBSG93JTIwYXJlJTIweW91JTNGJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlMEFJJ20lMjBkb2luZyUyMGdyZWF0ISUzQyU3Q2ltX2VuZCU3QyUzRQ==",highlighted:`&lt;|im_start|&gt;system
You are a helpful chatbot that will do its best not to say anything so stupid that people tweet about it.&lt;|im_end|&gt;
&lt;|im_start|&gt;user
How are you?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
I&#x27;m doing great!&lt;|im_end|&gt;`,wrap:!1}}),ol=new j({props:{title:"I want to add some chat templates! How should I get started?",local:"i-want-to-add-some-chat-templates-how-should-i-get-started",headingTag:"h3"}}),rl=new j({props:{title:"Advanced: Template writing tips",local:"advanced-template-writing-tips",headingTag:"h2"}}),_=new v({props:{$$slots:{default:[hM]},$$scope:{ctx:g}}}),ul=new j({props:{title:"Trimming whitespace",local:"trimming-whitespace",headingTag:"h3"}}),dl=new J({props:{code:"JTdCJTI1LSUyMGZvciUyMG1lc3NhZ2UlMjBpbiUyMG1lc3NhZ2VzJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTdCLSUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTdEJTdEJTBBJTdCJTI1LSUyMGVuZGZvciUyMCUyNSU3RA==",highlighted:`<span class="language-xml">{%- for message in messages %}
    </span><span class="hljs-template-variable">{{<span class="hljs-name">-</span> message[&#x27;role&#x27;] + message[&#x27;content&#x27;] }}</span><span class="language-xml">
{%- endfor %}</span>`,wrap:!1}}),Jl=new J({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlN0IlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCU3RCU3RCUwQSU3QiUyNSUyMGVuZGZvciUyMCUyNSU3RA==",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{ message[<span class="hljs-string">&#x27;role&#x27;</span>] + message[<span class="hljs-string">&#x27;content&#x27;</span>] }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),Ul=new j({props:{title:"Special variables",local:"special-variables",headingTag:"h3"}}),R=new v({props:{$$slots:{default:[JM]},$$scope:{ctx:g}}}),fl=new j({props:{title:"Callable functions",local:"callable-functions",headingTag:"h3"}}),bl=new j({props:{title:"Compatibility with non-Python Jinja",local:"compatibility-with-non-python-jinja",headingTag:"h3"}}),Gl=new j({props:{title:"Writing generation prompts",local:"writing-generation-prompts",headingTag:"h3"}}),Nl=new J({props:{code:"JTdCJTdCLSUyMGJvc190b2tlbiUyMCU3RCU3RCUwQSU3QiUyNS0lMjBmb3IlMjBtZXNzYWdlJTIwaW4lMjBtZXNzYWdlcyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCU3QiU3Qi0lMjAnJTNDJTdDaW1fc3RhcnQlN0MlM0UnJTIwJTJCJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUyQiUyMCclNUNuJyUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTNDJTdDaW1fZW5kJTdDJTNFJyUyMCUyQiUyMCclNUNuJyUyMCU3RCU3RCUwQSU3QiUyNS0lMjBlbmRmb3IlMjAlMjUlN0QlMEElN0IlMjUtJTIwaWYlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlN0ItJTIwJyUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50JTVDbiclMjAlN0QlN0QlMEElN0IlMjUtJTIwZW5kaWYlMjAlMjUlN0Q=",highlighted:`{{- bos_token }}
{%- for message in messages %}
    {{- &#x27;&lt;|im_start|&gt;&#x27; + message[&#x27;role&#x27;] + &#x27;\\n&#x27; + message[&#x27;content&#x27;] + &#x27;&lt;|im_end|&gt;&#x27; + &#x27;\\n&#x27; }}
{%- endfor %}
{%- if add_generation_prompt %}
    {{- &#x27;&lt;|im_start|&gt;assistant\\n&#x27; }}
{%- endif %}`,wrap:!1}}),Ql=new j({props:{title:"Writing and debugging larger templates",local:"writing-and-debugging-larger-templates",headingTag:"h3"}}),ql=new J({props:{code:"b3BlbiglMjJ0ZW1wbGF0ZS5qaW5qYSUyMiUyQyUyMCUyMnclMjIpLndyaXRlKHRva2VuaXplci5jaGF0X3RlbXBsYXRlKQ==",highlighted:'<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;template.jinja&quot;</span>, <span class="hljs-string">&quot;w&quot;</span>).write(tokenizer.chat_template)',wrap:!1}}),Vl=new J({props:{code:"dG9rZW5pemVyLmNoYXRfdGVtcGxhdGUlMjAlM0QlMjBvcGVuKCUyMnRlbXBsYXRlLmppbmphJTIyKS5yZWFkKCk=",highlighted:'tokenizer.chat_template = <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;template.jinja&quot;</span>).read()',wrap:!1}}),Rl=new j({props:{title:"Writing templates for tools",local:"writing-templates-for-tools",headingTag:"h3"}}),El=new j({props:{title:"Tool definitions",local:"tool-definitions",headingTag:"h4"}}),Hl=new J({props:{code:"JTdCJTBBJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMmZ1bmN0aW9uJTIyJTJDJTBBJTIwJTIwJTIyZnVuY3Rpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJuYW1lJTIyJTNBJTIwJTIybXVsdGlwbHklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJkZXNjcmlwdGlvbiUyMiUzQSUyMCUyMkElMjBmdW5jdGlvbiUyMHRoYXQlMjBtdWx0aXBsaWVzJTIwdHdvJTIwbnVtYmVycyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMnBhcmFtZXRlcnMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyb2JqZWN0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIycHJvcGVydGllcyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmElMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIybnVtYmVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZGVzY3JpcHRpb24lMjIlM0ElMjAlMjJUaGUlMjBmaXJzdCUyMG51bWJlciUyMHRvJTIwbXVsdGlwbHklMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJiJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMm51bWJlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlc2NyaXB0aW9uJTIyJTNBJTIwJTIyVGhlJTIwc2Vjb25kJTIwbnVtYmVyJTIwdG8lMjBtdWx0aXBseSUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnJlcXVpcmVkJTIyJTNBJTIwJTVCJTIyYSUyMiUyQyUyMCUyMmIlMjIlNUQlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;function&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;function&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;multiply&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;A function that multiplies two numbers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;object&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;properties&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;a&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;number&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;The first number to multiply&quot;</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;b&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;number&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;The second number to multiply&quot;</span>
        <span class="hljs-punctuation">}</span>
      <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;required&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;a&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;b&quot;</span><span class="hljs-punctuation">]</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Fl=new J({props:{code:"JTdCJTI1LSUyMGlmJTIwdG9vbHMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUtJTIwZm9yJTIwdG9vbCUyMGluJTIwdG9vbHMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0ItJTIwJyUzQ3Rvb2wlM0UnJTIwJTJCJTIwdG9vbCU1QidmdW5jdGlvbiclNUQlNUInbmFtZSclNUQlMjAlMkIlMjAnJTVDbiclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjUtJTIwZm9yJTIwYXJndW1lbnQlMjBpbiUyMHRvb2wlNUInZnVuY3Rpb24nJTVEJTVCJ3BhcmFtZXRlcnMnJTVEJTVCJ3Byb3BlcnRpZXMnJTVEJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCLSUyMGFyZ3VtZW50JTIwJTJCJTIwJyUzQSUyMCclMjAlMkIlMjB0b29sJTVCJ2Z1bmN0aW9uJyU1RCU1QidwYXJhbWV0ZXJzJyU1RCU1Qidwcm9wZXJ0aWVzJyU1RCU1QmFyZ3VtZW50JTVEJTVCJ2Rlc2NyaXB0aW9uJyU1RCUyMCUyQiUyMCclNUNuJyUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyNS0lMjBlbmRmb3IlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0ItJTIwJyU1Q24lM0MlMkZ0b29sJTNFJyUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNS0lMjBlbmRpZiUyMCUyNSU3RCUwQSU3QiUyNS0lMjBlbmRpZiUyMCUyNSU3RA==",highlighted:`{%- if tools %}
    {%- for tool in tools %}
        {{- &#x27;&lt;tool&gt;&#x27; + tool[&#x27;function&#x27;][&#x27;name&#x27;] + &#x27;\\n&#x27; }}
        {%- for argument in tool[&#x27;function&#x27;][&#x27;parameters&#x27;][&#x27;properties&#x27;] %}
            {{- argument + &#x27;: &#x27; + tool[&#x27;function&#x27;][&#x27;parameters&#x27;][&#x27;properties&#x27;][argument][&#x27;description&#x27;] + &#x27;\\n&#x27; }}
        {%- endfor %}
        {{- &#x27;\\n&lt;/tool&gt;&#x27; }}
    {%- endif %}
{%- endif %}`,wrap:!1}}),Pl=new j({props:{title:"Tool calls",local:"tool-calls",headingTag:"h4"}}),Kl=new J({props:{code:"JTdCJTBBJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUwQSUyMCUyMCUyMnRvb2xfY2FsbHMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyZnVuY3Rpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJmdW5jdGlvbiUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm5hbWUlMjIlM0ElMjAlMjJtdWx0aXBseSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmFyZ3VtZW50cyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmElMjIlM0ElMjA1JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYiUyMiUzQSUyMDYlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlNUQlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;assistant&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;tool_calls&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;function&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;function&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;multiply&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;arguments&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;a&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">5</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;b&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">6</span>
        <span class="hljs-punctuation">}</span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),ts=new J({props:{code:"JTdCJTI1LSUyMGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCdhc3Npc3RhbnQnJTIwYW5kJTIwJ3Rvb2xfY2FsbHMnJTIwaW4lMjBtZXNzYWdlJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1LSUyMGZvciUyMHRvb2xfY2FsbCUyMGluJTIwbWVzc2FnZSU1Qid0b29sX2NhbGxzJyU1RCUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiU3Qi0lMjAnJTNDdG9vbF9jYWxsJTNFJyUyMCUyQiUyMHRvb2xfY2FsbCU1QidmdW5jdGlvbiclNUQlNUInbmFtZSclNUQlMjAlMkIlMjAnJTVDbiclMjAlMkIlMjB0b29sX2NhbGwlNUInZnVuY3Rpb24nJTVEJTVCJ2FyZ3VtZW50cyclNUQlN0N0b2pzb24lMjAlMkIlMjAnJTVDbiUzQyUyRnRvb2xfY2FsbCUzRSclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjUtJTIwZW5kaWYlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUtJTIwZW5kZm9yJTIwJTI1JTdEJTBBJTdCJTI1LSUyMGVuZGlmJTIwJTI1JTdE",highlighted:`{%- if message[&#x27;role&#x27;] == &#x27;assistant&#x27; and &#x27;tool_calls&#x27; in message %}
    {%- for tool_call in message[&#x27;tool_calls&#x27;] %}
            {{- &#x27;&lt;tool_call&gt;&#x27; + tool_call[&#x27;function&#x27;][&#x27;name&#x27;] + &#x27;\\n&#x27; + tool_call[&#x27;function&#x27;][&#x27;arguments&#x27;]|tojson + &#x27;\\n&lt;/tool_call&gt;&#x27; }}
        {%- endif %}
    {%- endfor %}
{%- endif %}`,wrap:!1}}),ls=new j({props:{title:"Tool responses",local:"tool-responses",headingTag:"h4"}}),as=new J({props:{code:"JTdCJTBBJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnRvb2wlMjIlMkMlMEElMjAlMjAlMjJuYW1lJTIyJTNBJTIwJTIybXVsdGlwbHklMjIlMkMlMEElMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyMzAlMjIlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;tool&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;multiply&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;30&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),os=new J({props:{code:"JTdCJTI1LSUyMGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCd0b29sJyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCU3QiU3Qi0lMjAlMjIlM0N0b29sX3Jlc3VsdCUzRSUyMiUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAlMjIlM0MlMkZ0b29sX3Jlc3VsdCUzRSUyMiUyMCU3RCU3RCUwQSU3QiUyNS0lMjBlbmRpZiUyMCUyNSU3RA==",highlighted:`{%- if message[&#x27;role&#x27;] == &#x27;tool&#x27; %}
    {{- &quot;&lt;tool_result&gt;&quot; + message[&#x27;content&#x27;] + &quot;&lt;/tool_result&gt;&quot; }}
{%- endif %}`,wrap:!1}}),ps=new iM({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/chat_templating.md"}}),{c(){d=o("meta"),U=a(),h=o("p"),T=a(),M(C.$$.fragment),I=a(),M(b.$$.fragment),G=a(),f=o("p"),f.innerHTML=x,w=a(),$=o("p"),$.innerHTML=Xo,rs=a(),S=o("p"),S.innerHTML=Ho,ys=a(),M(z.$$.fragment),cs=a(),E=o("p"),E.innerHTML=Yo,us=a(),X=o("p"),X.innerHTML=Fo,ms=a(),M(H.$$.fragment),ds=a(),Y=o("p"),Y.innerHTML=Lo,hs=a(),M(N.$$.fragment),Js=a(),M(F.$$.fragment),Ts=a(),L=o("p"),L.innerHTML=Po,Us=a(),M(P.$$.fragment),js=a(),D=o("p"),D.innerHTML=Do,ws=a(),M(K.$$.fragment),fs=a(),O=o("p"),O.textContent=Ko,Is=a(),M(tt.$$.fragment),gs=a(),et=o("p"),et.textContent=Oo,bs=a(),M(lt.$$.fragment),Cs=a(),st=o("p"),st.textContent=ti,$s=a(),M(at.$$.fragment),xs=a(),M(nt.$$.fragment),Gs=a(),ot=o("p"),ot.innerHTML=ei,vs=a(),it=o("p"),it.innerHTML=li,Bs=a(),M(pt.$$.fragment),Ns=a(),Mt=o("p"),Mt.innerHTML=si,Zs=a(),M(rt.$$.fragment),As=a(),yt=o("p"),yt.textContent=ai,Qs=a(),M(ct.$$.fragment),ks=a(),ut=o("p"),ut.innerHTML=ni,qs=a(),M(mt.$$.fragment),Ws=a(),M(dt.$$.fragment),Vs=a(),ht=o("p"),ht.innerHTML=oi,_s=a(),M(Jt.$$.fragment),Rs=a(),Tt=o("p"),Tt.innerHTML=ii,Ss=a(),M(Ut.$$.fragment),zs=a(),jt=o("p"),jt.textContent=pi,Es=a(),M(wt.$$.fragment),Xs=a(),ft=o("p"),ft.innerHTML=Mi,Hs=a(),M(It.$$.fragment),Ys=a(),gt=o("p"),gt.textContent=ri,Fs=a(),bt=o("p"),bt.innerHTML=yi,Ls=a(),M(Ct.$$.fragment),Ps=a(),$t=o("p"),$t.innerHTML=ci,Ds=a(),xt=o("p"),xt.textContent=ui,Ks=a(),M(Gt.$$.fragment),Os=a(),vt=o("p"),vt.textContent=mi,ta=a(),Bt=o("p"),Bt.innerHTML=di,ea=a(),M(Z.$$.fragment),la=a(),M(Nt.$$.fragment),sa=a(),Zt=o("p"),Zt.innerHTML=hi,aa=a(),M(At.$$.fragment),na=a(),Qt=o("p"),Qt.textContent=Ji,oa=a(),M(kt.$$.fragment),ia=a(),qt=o("p"),qt.innerHTML=Ti,pa=a(),M(A.$$.fragment),Ma=a(),M(Wt.$$.fragment),ra=a(),Vt=o("p"),Vt.innerHTML=Ui,ya=a(),_t=o("p"),_t.textContent=ji,ca=a(),M(Rt.$$.fragment),ua=a(),St=o("p"),St.innerHTML=wi,ma=a(),M(zt.$$.fragment),da=a(),Et=o("p"),Et.textContent=fi,ha=a(),Xt=o("ul"),Xt.innerHTML=Ii,Ja=a(),M(Ht.$$.fragment),Ta=a(),Yt=o("p"),Yt.textContent=gi,Ua=a(),Ft=o("ol"),Ft.innerHTML=bi,ja=a(),M(Lt.$$.fragment),wa=a(),Pt=o("p"),Pt.innerHTML=Ci,fa=a(),Dt=o("p"),Dt.textContent=$i,Ia=a(),M(Kt.$$.fragment),ga=a(),Ot=o("p"),Ot.textContent=xi,ba=a(),M(te.$$.fragment),Ca=a(),ee=o("p"),ee.textContent=Gi,$a=a(),M(le.$$.fragment),xa=a(),se=o("p"),se.textContent=vi,Ga=a(),M(ae.$$.fragment),va=a(),ne=o("p"),ne.textContent=Bi,Ba=a(),M(oe.$$.fragment),Na=a(),ie=o("p"),ie.textContent=Ni,Za=a(),M(Q.$$.fragment),Aa=a(),pe=o("p"),pe.textContent=Zi,Qa=a(),M(Me.$$.fragment),ka=a(),M(k.$$.fragment),qa=a(),re=o("p"),re.textContent=Ai,Wa=a(),M(ye.$$.fragment),Va=a(),M(q.$$.fragment),_a=a(),ce=o("p"),ce.textContent=Qi,Ra=a(),M(ue.$$.fragment),Sa=a(),me=o("p"),me.textContent=ki,za=a(),M(de.$$.fragment),Ea=a(),he=o("p"),he.textContent=qi,Xa=a(),M(Je.$$.fragment),Ha=a(),Te=o("p"),Te.innerHTML=Wi,Ya=a(),Ue=o("p"),Ue.textContent=Vi,Fa=a(),M(je.$$.fragment),La=a(),we=o("p"),we.textContent=_i,Pa=a(),M(fe.$$.fragment),Da=a(),Ie=o("p"),Ie.innerHTML=Ri,Ka=a(),ge=o("p"),ge.innerHTML=Si,Oa=a(),M(be.$$.fragment),tn=a(),M(Ce.$$.fragment),en=a(),$e=o("p"),$e.innerHTML=zi,ln=a(),xe=o("p"),xe.textContent=Ei,sn=a(),M(Ge.$$.fragment),an=a(),M(W.$$.fragment),nn=a(),M(ve.$$.fragment),on=a(),Be=o("p"),Be.innerHTML=Xi,pn=a(),M(Ne.$$.fragment),Mn=a(),Ze=o("p"),Ze.innerHTML=Hi,rn=a(),M(Ae.$$.fragment),yn=a(),Qe=o("p"),Qe.textContent=Yi,cn=a(),ke=o("ol"),ke.innerHTML=Fi,un=a(),qe=o("p"),qe.textContent=Li,mn=a(),M(We.$$.fragment),dn=a(),Ve=o("p"),Ve.innerHTML=Pi,hn=a(),M(_e.$$.fragment),Jn=a(),M(Re.$$.fragment),Tn=a(),Se=o("p"),Se.innerHTML=Di,Un=a(),M(ze.$$.fragment),jn=a(),Ee=o("p"),Ee.innerHTML=Ki,wn=a(),M(Xe.$$.fragment),fn=a(),He=o("p"),He.innerHTML=Oi,In=a(),M(V.$$.fragment),gn=a(),M(Ye.$$.fragment),bn=a(),Fe=o("p"),Fe.innerHTML=tp,Cn=a(),Le=o("p"),Le.innerHTML=ep,$n=a(),Pe=o("p"),Pe.textContent=lp,xn=a(),M(De.$$.fragment),Gn=a(),Ke=o("p"),Ke.textContent=sp,vn=a(),Oe=o("p"),Oe.innerHTML=ap,Bn=a(),M(tl.$$.fragment),Nn=a(),el=o("p"),el.innerHTML=np,Zn=a(),M(ll.$$.fragment),An=a(),sl=o("p"),sl.innerHTML=op,Qn=a(),M(al.$$.fragment),kn=a(),nl=o("p"),nl.innerHTML=ip,qn=a(),M(ol.$$.fragment),Wn=a(),il=o("p"),il.innerHTML=pp,Vn=a(),pl=o("p"),pl.innerHTML=Mp,_n=a(),Ml=o("p"),Ml.textContent=rp,Rn=a(),M(rl.$$.fragment),Sn=a(),M(_.$$.fragment),zn=a(),yl=o("p"),yl.innerHTML=yp,En=a(),cl=o("p"),cl.textContent=cp,Xn=a(),M(ul.$$.fragment),Hn=a(),ml=o("p"),ml.textContent=up,Yn=a(),M(dl.$$.fragment),Fn=a(),hl=o("p"),hl.textContent=mp,Ln=a(),M(Jl.$$.fragment),Pn=a(),Tl=o("p"),Tl.innerHTML=dp,Dn=a(),M(Ul.$$.fragment),Kn=a(),jl=o("p"),jl.innerHTML=hp,On=a(),wl=o("ul"),wl.innerHTML=Jp,to=a(),M(R.$$.fragment),eo=a(),M(fl.$$.fragment),lo=a(),Il=o("p"),Il.textContent=Tp,so=a(),gl=o("ul"),gl.innerHTML=Up,ao=a(),M(bl.$$.fragment),no=a(),Cl=o("p"),Cl.innerHTML=jp,oo=a(),$l=o("p"),$l.textContent=wp,io=a(),xl=o("ul"),xl.innerHTML=fp,po=a(),M(Gl.$$.fragment),Mo=a(),vl=o("p"),vl.innerHTML=Ip,ro=a(),Bl=o("p"),Bl.textContent=gp,yo=a(),M(Nl.$$.fragment),co=a(),Zl=o("p"),Zl.innerHTML=bp,uo=a(),Al=o("p"),Al.textContent=Cp,mo=a(),M(Ql.$$.fragment),ho=a(),kl=o("p"),kl.textContent=$p,Jo=a(),M(ql.$$.fragment),To=a(),Wl=o("p"),Wl.textContent=xp,Uo=a(),M(Vl.$$.fragment),jo=a(),_l=o("p"),_l.textContent=Gp,wo=a(),M(Rl.$$.fragment),fo=a(),Sl=o("p"),Sl.textContent=vp,Io=a(),zl=o("p"),zl.textContent=Bp,go=a(),M(El.$$.fragment),bo=a(),Xl=o("p"),Xl.innerHTML=Np,Co=a(),M(Hl.$$.fragment),$o=a(),Yl=o("p"),Yl.textContent=Zp,xo=a(),M(Fl.$$.fragment),Go=a(),Ll=o("p"),Ll.innerHTML=Ap,vo=a(),M(Pl.$$.fragment),Bo=a(),Dl=o("p"),Dl.innerHTML=Qp,No=a(),M(Kl.$$.fragment),Zo=a(),Ol=o("p"),Ol.textContent=kp,Ao=a(),M(ts.$$.fragment),Qo=a(),es=o("p"),es.textContent=qp,ko=a(),M(ls.$$.fragment),qo=a(),ss=o("p"),ss.textContent=Wp,Wo=a(),M(as.$$.fragment),Vo=a(),ns=o("p"),ns.textContent=Vp,_o=a(),M(os.$$.fragment),Ro=a(),is=o("p"),is.textContent=_p,So=a(),M(ps.$$.fragment),zo=a(),Ms=o("p"),this.h()},l(t){const e=sM("svelte-u9bgzb",document.head);d=i(e,"META",{name:!0,content:!0}),e.forEach(l),U=n(t),h=i(t,"P",{}),Dp(h).forEach(l),T=n(t),r(C.$$.fragment,t),I=n(t),r(b.$$.fragment,t),G=n(t),f=i(t,"P",{"data-svelte-h":!0}),p(f)!=="svelte-ydi30o"&&(f.innerHTML=x),w=n(t),$=i(t,"P",{"data-svelte-h":!0}),p($)!=="svelte-hydof7"&&($.innerHTML=Xo),rs=n(t),S=i(t,"P",{"data-svelte-h":!0}),p(S)!=="svelte-19ob0qf"&&(S.innerHTML=Ho),ys=n(t),r(z.$$.fragment,t),cs=n(t),E=i(t,"P",{"data-svelte-h":!0}),p(E)!=="svelte-gwj0xd"&&(E.innerHTML=Yo),us=n(t),X=i(t,"P",{"data-svelte-h":!0}),p(X)!=="svelte-14wqu22"&&(X.innerHTML=Fo),ms=n(t),r(H.$$.fragment,t),ds=n(t),Y=i(t,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1010uaq"&&(Y.innerHTML=Lo),hs=n(t),r(N.$$.fragment,t),Js=n(t),r(F.$$.fragment,t),Ts=n(t),L=i(t,"P",{"data-svelte-h":!0}),p(L)!=="svelte-5xzp3d"&&(L.innerHTML=Po),Us=n(t),r(P.$$.fragment,t),js=n(t),D=i(t,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1vun9x2"&&(D.innerHTML=Do),ws=n(t),r(K.$$.fragment,t),fs=n(t),O=i(t,"P",{"data-svelte-h":!0}),p(O)!=="svelte-bd2gkv"&&(O.textContent=Ko),Is=n(t),r(tt.$$.fragment,t),gs=n(t),et=i(t,"P",{"data-svelte-h":!0}),p(et)!=="svelte-hj60o5"&&(et.textContent=Oo),bs=n(t),r(lt.$$.fragment,t),Cs=n(t),st=i(t,"P",{"data-svelte-h":!0}),p(st)!=="svelte-1bfcqd3"&&(st.textContent=ti),$s=n(t),r(at.$$.fragment,t),xs=n(t),r(nt.$$.fragment,t),Gs=n(t),ot=i(t,"P",{"data-svelte-h":!0}),p(ot)!=="svelte-1m6eey2"&&(ot.innerHTML=ei),vs=n(t),it=i(t,"P",{"data-svelte-h":!0}),p(it)!=="svelte-dcxo7r"&&(it.innerHTML=li),Bs=n(t),r(pt.$$.fragment,t),Ns=n(t),Mt=i(t,"P",{"data-svelte-h":!0}),p(Mt)!=="svelte-1amu1sn"&&(Mt.innerHTML=si),Zs=n(t),r(rt.$$.fragment,t),As=n(t),yt=i(t,"P",{"data-svelte-h":!0}),p(yt)!=="svelte-k9m2iy"&&(yt.textContent=ai),Qs=n(t),r(ct.$$.fragment,t),ks=n(t),ut=i(t,"P",{"data-svelte-h":!0}),p(ut)!=="svelte-1g3xdzp"&&(ut.innerHTML=ni),qs=n(t),r(mt.$$.fragment,t),Ws=n(t),r(dt.$$.fragment,t),Vs=n(t),ht=i(t,"P",{"data-svelte-h":!0}),p(ht)!=="svelte-5umvde"&&(ht.innerHTML=oi),_s=n(t),r(Jt.$$.fragment,t),Rs=n(t),Tt=i(t,"P",{"data-svelte-h":!0}),p(Tt)!=="svelte-rhnu79"&&(Tt.innerHTML=ii),Ss=n(t),r(Ut.$$.fragment,t),zs=n(t),jt=i(t,"P",{"data-svelte-h":!0}),p(jt)!=="svelte-jpbe39"&&(jt.textContent=pi),Es=n(t),r(wt.$$.fragment,t),Xs=n(t),ft=i(t,"P",{"data-svelte-h":!0}),p(ft)!=="svelte-61bp3d"&&(ft.innerHTML=Mi),Hs=n(t),r(It.$$.fragment,t),Ys=n(t),gt=i(t,"P",{"data-svelte-h":!0}),p(gt)!=="svelte-inq88f"&&(gt.textContent=ri),Fs=n(t),bt=i(t,"P",{"data-svelte-h":!0}),p(bt)!=="svelte-uz30n4"&&(bt.innerHTML=yi),Ls=n(t),r(Ct.$$.fragment,t),Ps=n(t),$t=i(t,"P",{"data-svelte-h":!0}),p($t)!=="svelte-1ffeegg"&&($t.innerHTML=ci),Ds=n(t),xt=i(t,"P",{"data-svelte-h":!0}),p(xt)!=="svelte-wwwyth"&&(xt.textContent=ui),Ks=n(t),r(Gt.$$.fragment,t),Os=n(t),vt=i(t,"P",{"data-svelte-h":!0}),p(vt)!=="svelte-j6m3wj"&&(vt.textContent=mi),ta=n(t),Bt=i(t,"P",{"data-svelte-h":!0}),p(Bt)!=="svelte-hfpwig"&&(Bt.innerHTML=di),ea=n(t),r(Z.$$.fragment,t),la=n(t),r(Nt.$$.fragment,t),sa=n(t),Zt=i(t,"P",{"data-svelte-h":!0}),p(Zt)!=="svelte-i3l9c1"&&(Zt.innerHTML=hi),aa=n(t),r(At.$$.fragment,t),na=n(t),Qt=i(t,"P",{"data-svelte-h":!0}),p(Qt)!=="svelte-13505nn"&&(Qt.textContent=Ji),oa=n(t),r(kt.$$.fragment,t),ia=n(t),qt=i(t,"P",{"data-svelte-h":!0}),p(qt)!=="svelte-ziuqkt"&&(qt.innerHTML=Ti),pa=n(t),r(A.$$.fragment,t),Ma=n(t),r(Wt.$$.fragment,t),ra=n(t),Vt=i(t,"P",{"data-svelte-h":!0}),p(Vt)!=="svelte-o848l2"&&(Vt.innerHTML=Ui),ya=n(t),_t=i(t,"P",{"data-svelte-h":!0}),p(_t)!=="svelte-dcun4m"&&(_t.textContent=ji),ca=n(t),r(Rt.$$.fragment,t),ua=n(t),St=i(t,"P",{"data-svelte-h":!0}),p(St)!=="svelte-6sd0wq"&&(St.innerHTML=wi),ma=n(t),r(zt.$$.fragment,t),da=n(t),Et=i(t,"P",{"data-svelte-h":!0}),p(Et)!=="svelte-608o9m"&&(Et.textContent=fi),ha=n(t),Xt=i(t,"UL",{"data-svelte-h":!0}),p(Xt)!=="svelte-vf9yxu"&&(Xt.innerHTML=Ii),Ja=n(t),r(Ht.$$.fragment,t),Ta=n(t),Yt=i(t,"P",{"data-svelte-h":!0}),p(Yt)!=="svelte-11962fa"&&(Yt.textContent=gi),Ua=n(t),Ft=i(t,"OL",{"data-svelte-h":!0}),p(Ft)!=="svelte-1vd84s7"&&(Ft.innerHTML=bi),ja=n(t),r(Lt.$$.fragment,t),wa=n(t),Pt=i(t,"P",{"data-svelte-h":!0}),p(Pt)!=="svelte-1oi0gsn"&&(Pt.innerHTML=Ci),fa=n(t),Dt=i(t,"P",{"data-svelte-h":!0}),p(Dt)!=="svelte-o8n6v4"&&(Dt.textContent=$i),Ia=n(t),r(Kt.$$.fragment,t),ga=n(t),Ot=i(t,"P",{"data-svelte-h":!0}),p(Ot)!=="svelte-1q7358y"&&(Ot.textContent=xi),ba=n(t),r(te.$$.fragment,t),Ca=n(t),ee=i(t,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-11hfyaa"&&(ee.textContent=Gi),$a=n(t),r(le.$$.fragment,t),xa=n(t),se=i(t,"P",{"data-svelte-h":!0}),p(se)!=="svelte-1usrd3e"&&(se.textContent=vi),Ga=n(t),r(ae.$$.fragment,t),va=n(t),ne=i(t,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-13505nn"&&(ne.textContent=Bi),Ba=n(t),r(oe.$$.fragment,t),Na=n(t),ie=i(t,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-nxltbo"&&(ie.textContent=Ni),Za=n(t),r(Q.$$.fragment,t),Aa=n(t),pe=i(t,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-336ooj"&&(pe.textContent=Zi),Qa=n(t),r(Me.$$.fragment,t),ka=n(t),r(k.$$.fragment,t),qa=n(t),re=i(t,"P",{"data-svelte-h":!0}),p(re)!=="svelte-1mv1vl9"&&(re.textContent=Ai),Wa=n(t),r(ye.$$.fragment,t),Va=n(t),r(q.$$.fragment,t),_a=n(t),ce=i(t,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-1qjybqz"&&(ce.textContent=Qi),Ra=n(t),r(ue.$$.fragment,t),Sa=n(t),me=i(t,"P",{"data-svelte-h":!0}),p(me)!=="svelte-13505nn"&&(me.textContent=ki),za=n(t),r(de.$$.fragment,t),Ea=n(t),he=i(t,"P",{"data-svelte-h":!0}),p(he)!=="svelte-1evxmus"&&(he.textContent=qi),Xa=n(t),r(Je.$$.fragment,t),Ha=n(t),Te=i(t,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-pl4mbs"&&(Te.innerHTML=Wi),Ya=n(t),Ue=i(t,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-37xmdz"&&(Ue.textContent=Vi),Fa=n(t),r(je.$$.fragment,t),La=n(t),we=i(t,"P",{"data-svelte-h":!0}),p(we)!=="svelte-1bfcqd3"&&(we.textContent=_i),Pa=n(t),r(fe.$$.fragment,t),Da=n(t),Ie=i(t,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-19t6fs5"&&(Ie.innerHTML=Ri),Ka=n(t),ge=i(t,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-1nlyrys"&&(ge.innerHTML=Si),Oa=n(t),r(be.$$.fragment,t),tn=n(t),r(Ce.$$.fragment,t),en=n(t),$e=i(t,"P",{"data-svelte-h":!0}),p($e)!=="svelte-1977j4z"&&($e.innerHTML=zi),ln=n(t),xe=i(t,"P",{"data-svelte-h":!0}),p(xe)!=="svelte-1xmnzcc"&&(xe.textContent=Ei),sn=n(t),r(Ge.$$.fragment,t),an=n(t),r(W.$$.fragment,t),nn=n(t),r(ve.$$.fragment,t),on=n(t),Be=i(t,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-lanz4l"&&(Be.innerHTML=Xi),pn=n(t),r(Ne.$$.fragment,t),Mn=n(t),Ze=i(t,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-zet1qo"&&(Ze.innerHTML=Hi),rn=n(t),r(Ae.$$.fragment,t),yn=n(t),Qe=i(t,"P",{"data-svelte-h":!0}),p(Qe)!=="svelte-9bdwn1"&&(Qe.textContent=Yi),cn=n(t),ke=i(t,"OL",{"data-svelte-h":!0}),p(ke)!=="svelte-1ax9ke1"&&(ke.innerHTML=Fi),un=n(t),qe=i(t,"P",{"data-svelte-h":!0}),p(qe)!=="svelte-4zn2hx"&&(qe.textContent=Li),mn=n(t),r(We.$$.fragment,t),dn=n(t),Ve=i(t,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-prz4we"&&(Ve.innerHTML=Pi),hn=n(t),r(_e.$$.fragment,t),Jn=n(t),r(Re.$$.fragment,t),Tn=n(t),Se=i(t,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-1ubxgh9"&&(Se.innerHTML=Di),Un=n(t),r(ze.$$.fragment,t),jn=n(t),Ee=i(t,"P",{"data-svelte-h":!0}),p(Ee)!=="svelte-qpoyzq"&&(Ee.innerHTML=Ki),wn=n(t),r(Xe.$$.fragment,t),fn=n(t),He=i(t,"P",{"data-svelte-h":!0}),p(He)!=="svelte-d7jj7k"&&(He.innerHTML=Oi),In=n(t),r(V.$$.fragment,t),gn=n(t),r(Ye.$$.fragment,t),bn=n(t),Fe=i(t,"P",{"data-svelte-h":!0}),p(Fe)!=="svelte-1d7cql4"&&(Fe.innerHTML=tp),Cn=n(t),Le=i(t,"P",{"data-svelte-h":!0}),p(Le)!=="svelte-1u88h1j"&&(Le.innerHTML=ep),$n=n(t),Pe=i(t,"P",{"data-svelte-h":!0}),p(Pe)!=="svelte-1g7ri12"&&(Pe.textContent=lp),xn=n(t),r(De.$$.fragment,t),Gn=n(t),Ke=i(t,"P",{"data-svelte-h":!0}),p(Ke)!=="svelte-5u6sqi"&&(Ke.textContent=sp),vn=n(t),Oe=i(t,"P",{"data-svelte-h":!0}),p(Oe)!=="svelte-ffreiw"&&(Oe.innerHTML=ap),Bn=n(t),r(tl.$$.fragment,t),Nn=n(t),el=i(t,"P",{"data-svelte-h":!0}),p(el)!=="svelte-1cj1ql7"&&(el.innerHTML=np),Zn=n(t),r(ll.$$.fragment,t),An=n(t),sl=i(t,"P",{"data-svelte-h":!0}),p(sl)!=="svelte-soh9qu"&&(sl.innerHTML=op),Qn=n(t),r(al.$$.fragment,t),kn=n(t),nl=i(t,"P",{"data-svelte-h":!0}),p(nl)!=="svelte-1ujzojk"&&(nl.innerHTML=ip),qn=n(t),r(ol.$$.fragment,t),Wn=n(t),il=i(t,"P",{"data-svelte-h":!0}),p(il)!=="svelte-tj8371"&&(il.innerHTML=pp),Vn=n(t),pl=i(t,"P",{"data-svelte-h":!0}),p(pl)!=="svelte-kn2i6o"&&(pl.innerHTML=Mp),_n=n(t),Ml=i(t,"P",{"data-svelte-h":!0}),p(Ml)!=="svelte-197jyne"&&(Ml.textContent=rp),Rn=n(t),r(rl.$$.fragment,t),Sn=n(t),r(_.$$.fragment,t),zn=n(t),yl=i(t,"P",{"data-svelte-h":!0}),p(yl)!=="svelte-1tyqave"&&(yl.innerHTML=yp),En=n(t),cl=i(t,"P",{"data-svelte-h":!0}),p(cl)!=="svelte-10wmjwo"&&(cl.textContent=cp),Xn=n(t),r(ul.$$.fragment,t),Hn=n(t),ml=i(t,"P",{"data-svelte-h":!0}),p(ml)!=="svelte-1ttgeg7"&&(ml.textContent=up),Yn=n(t),r(dl.$$.fragment,t),Fn=n(t),hl=i(t,"P",{"data-svelte-h":!0}),p(hl)!=="svelte-qihux6"&&(hl.textContent=mp),Ln=n(t),r(Jl.$$.fragment,t),Pn=n(t),Tl=i(t,"P",{"data-svelte-h":!0}),p(Tl)!=="svelte-pefrh0"&&(Tl.innerHTML=dp),Dn=n(t),r(Ul.$$.fragment,t),Kn=n(t),jl=i(t,"P",{"data-svelte-h":!0}),p(jl)!=="svelte-1s7e55r"&&(jl.innerHTML=hp),On=n(t),wl=i(t,"UL",{"data-svelte-h":!0}),p(wl)!=="svelte-1rdzqgp"&&(wl.innerHTML=Jp),to=n(t),r(R.$$.fragment,t),eo=n(t),r(fl.$$.fragment,t),lo=n(t),Il=i(t,"P",{"data-svelte-h":!0}),p(Il)!=="svelte-w29vry"&&(Il.textContent=Tp),so=n(t),gl=i(t,"UL",{"data-svelte-h":!0}),p(gl)!=="svelte-1fmzhdy"&&(gl.innerHTML=Up),ao=n(t),r(bl.$$.fragment,t),no=n(t),Cl=i(t,"P",{"data-svelte-h":!0}),p(Cl)!=="svelte-1d5taf1"&&(Cl.innerHTML=jp),oo=n(t),$l=i(t,"P",{"data-svelte-h":!0}),p($l)!=="svelte-f0ucf0"&&($l.textContent=wp),io=n(t),xl=i(t,"UL",{"data-svelte-h":!0}),p(xl)!=="svelte-doa6oc"&&(xl.innerHTML=fp),po=n(t),r(Gl.$$.fragment,t),Mo=n(t),vl=i(t,"P",{"data-svelte-h":!0}),p(vl)!=="svelte-13g6lvo"&&(vl.innerHTML=Ip),ro=n(t),Bl=i(t,"P",{"data-svelte-h":!0}),p(Bl)!=="svelte-i5qalm"&&(Bl.textContent=gp),yo=n(t),r(Nl.$$.fragment,t),co=n(t),Zl=i(t,"P",{"data-svelte-h":!0}),p(Zl)!=="svelte-148o5ra"&&(Zl.innerHTML=bp),uo=n(t),Al=i(t,"P",{"data-svelte-h":!0}),p(Al)!=="svelte-1a5yxb9"&&(Al.textContent=Cp),mo=n(t),r(Ql.$$.fragment,t),ho=n(t),kl=i(t,"P",{"data-svelte-h":!0}),p(kl)!=="svelte-180ap61"&&(kl.textContent=$p),Jo=n(t),r(ql.$$.fragment,t),To=n(t),Wl=i(t,"P",{"data-svelte-h":!0}),p(Wl)!=="svelte-1bv602"&&(Wl.textContent=xp),Uo=n(t),r(Vl.$$.fragment,t),jo=n(t),_l=i(t,"P",{"data-svelte-h":!0}),p(_l)!=="svelte-1mq7g8k"&&(_l.textContent=Gp),wo=n(t),r(Rl.$$.fragment,t),fo=n(t),Sl=i(t,"P",{"data-svelte-h":!0}),p(Sl)!=="svelte-kt3iym"&&(Sl.textContent=vp),Io=n(t),zl=i(t,"P",{"data-svelte-h":!0}),p(zl)!=="svelte-1nlwaki"&&(zl.textContent=Bp),go=n(t),r(El.$$.fragment,t),bo=n(t),Xl=i(t,"P",{"data-svelte-h":!0}),p(Xl)!=="svelte-wrq3v1"&&(Xl.innerHTML=Np),Co=n(t),r(Hl.$$.fragment,t),$o=n(t),Yl=i(t,"P",{"data-svelte-h":!0}),p(Yl)!=="svelte-1woymkp"&&(Yl.textContent=Zp),xo=n(t),r(Fl.$$.fragment,t),Go=n(t),Ll=i(t,"P",{"data-svelte-h":!0}),p(Ll)!=="svelte-1vngoc7"&&(Ll.innerHTML=Ap),vo=n(t),r(Pl.$$.fragment,t),Bo=n(t),Dl=i(t,"P",{"data-svelte-h":!0}),p(Dl)!=="svelte-1x6y95z"&&(Dl.innerHTML=Qp),No=n(t),r(Kl.$$.fragment,t),Zo=n(t),Ol=i(t,"P",{"data-svelte-h":!0}),p(Ol)!=="svelte-my9opo"&&(Ol.textContent=kp),Ao=n(t),r(ts.$$.fragment,t),Qo=n(t),es=i(t,"P",{"data-svelte-h":!0}),p(es)!=="svelte-hsoefm"&&(es.textContent=qp),ko=n(t),r(ls.$$.fragment,t),qo=n(t),ss=i(t,"P",{"data-svelte-h":!0}),p(ss)!=="svelte-1hx88do"&&(ss.textContent=Wp),Wo=n(t),r(as.$$.fragment,t),Vo=n(t),ns=i(t,"P",{"data-svelte-h":!0}),p(ns)!=="svelte-1okuuze"&&(ns.textContent=Vp),_o=n(t),r(os.$$.fragment,t),Ro=n(t),is=i(t,"P",{"data-svelte-h":!0}),p(is)!=="svelte-13n2q2c"&&(is.textContent=_p),So=n(t),r(ps.$$.fragment,t),zo=n(t),Ms=i(t,"P",{}),Dp(Ms).forEach(l),this.h()},h(){Kp(d,"name","hf:doc:metadata"),Kp(d,"content",UM)},m(t,e){aM(document.head,d),s(t,U,e),s(t,h,e),s(t,T,e),y(C,t,e),s(t,I,e),y(b,t,e),s(t,G,e),s(t,f,e),s(t,w,e),s(t,$,e),s(t,rs,e),s(t,S,e),s(t,ys,e),y(z,t,e),s(t,cs,e),s(t,E,e),s(t,us,e),s(t,X,e),s(t,ms,e),y(H,t,e),s(t,ds,e),s(t,Y,e),s(t,hs,e),y(N,t,e),s(t,Js,e),y(F,t,e),s(t,Ts,e),s(t,L,e),s(t,Us,e),y(P,t,e),s(t,js,e),s(t,D,e),s(t,ws,e),y(K,t,e),s(t,fs,e),s(t,O,e),s(t,Is,e),y(tt,t,e),s(t,gs,e),s(t,et,e),s(t,bs,e),y(lt,t,e),s(t,Cs,e),s(t,st,e),s(t,$s,e),y(at,t,e),s(t,xs,e),y(nt,t,e),s(t,Gs,e),s(t,ot,e),s(t,vs,e),s(t,it,e),s(t,Bs,e),y(pt,t,e),s(t,Ns,e),s(t,Mt,e),s(t,Zs,e),y(rt,t,e),s(t,As,e),s(t,yt,e),s(t,Qs,e),y(ct,t,e),s(t,ks,e),s(t,ut,e),s(t,qs,e),y(mt,t,e),s(t,Ws,e),y(dt,t,e),s(t,Vs,e),s(t,ht,e),s(t,_s,e),y(Jt,t,e),s(t,Rs,e),s(t,Tt,e),s(t,Ss,e),y(Ut,t,e),s(t,zs,e),s(t,jt,e),s(t,Es,e),y(wt,t,e),s(t,Xs,e),s(t,ft,e),s(t,Hs,e),y(It,t,e),s(t,Ys,e),s(t,gt,e),s(t,Fs,e),s(t,bt,e),s(t,Ls,e),y(Ct,t,e),s(t,Ps,e),s(t,$t,e),s(t,Ds,e),s(t,xt,e),s(t,Ks,e),y(Gt,t,e),s(t,Os,e),s(t,vt,e),s(t,ta,e),s(t,Bt,e),s(t,ea,e),y(Z,t,e),s(t,la,e),y(Nt,t,e),s(t,sa,e),s(t,Zt,e),s(t,aa,e),y(At,t,e),s(t,na,e),s(t,Qt,e),s(t,oa,e),y(kt,t,e),s(t,ia,e),s(t,qt,e),s(t,pa,e),y(A,t,e),s(t,Ma,e),y(Wt,t,e),s(t,ra,e),s(t,Vt,e),s(t,ya,e),s(t,_t,e),s(t,ca,e),y(Rt,t,e),s(t,ua,e),s(t,St,e),s(t,ma,e),y(zt,t,e),s(t,da,e),s(t,Et,e),s(t,ha,e),s(t,Xt,e),s(t,Ja,e),y(Ht,t,e),s(t,Ta,e),s(t,Yt,e),s(t,Ua,e),s(t,Ft,e),s(t,ja,e),y(Lt,t,e),s(t,wa,e),s(t,Pt,e),s(t,fa,e),s(t,Dt,e),s(t,Ia,e),y(Kt,t,e),s(t,ga,e),s(t,Ot,e),s(t,ba,e),y(te,t,e),s(t,Ca,e),s(t,ee,e),s(t,$a,e),y(le,t,e),s(t,xa,e),s(t,se,e),s(t,Ga,e),y(ae,t,e),s(t,va,e),s(t,ne,e),s(t,Ba,e),y(oe,t,e),s(t,Na,e),s(t,ie,e),s(t,Za,e),y(Q,t,e),s(t,Aa,e),s(t,pe,e),s(t,Qa,e),y(Me,t,e),s(t,ka,e),y(k,t,e),s(t,qa,e),s(t,re,e),s(t,Wa,e),y(ye,t,e),s(t,Va,e),y(q,t,e),s(t,_a,e),s(t,ce,e),s(t,Ra,e),y(ue,t,e),s(t,Sa,e),s(t,me,e),s(t,za,e),y(de,t,e),s(t,Ea,e),s(t,he,e),s(t,Xa,e),y(Je,t,e),s(t,Ha,e),s(t,Te,e),s(t,Ya,e),s(t,Ue,e),s(t,Fa,e),y(je,t,e),s(t,La,e),s(t,we,e),s(t,Pa,e),y(fe,t,e),s(t,Da,e),s(t,Ie,e),s(t,Ka,e),s(t,ge,e),s(t,Oa,e),y(be,t,e),s(t,tn,e),y(Ce,t,e),s(t,en,e),s(t,$e,e),s(t,ln,e),s(t,xe,e),s(t,sn,e),y(Ge,t,e),s(t,an,e),y(W,t,e),s(t,nn,e),y(ve,t,e),s(t,on,e),s(t,Be,e),s(t,pn,e),y(Ne,t,e),s(t,Mn,e),s(t,Ze,e),s(t,rn,e),y(Ae,t,e),s(t,yn,e),s(t,Qe,e),s(t,cn,e),s(t,ke,e),s(t,un,e),s(t,qe,e),s(t,mn,e),y(We,t,e),s(t,dn,e),s(t,Ve,e),s(t,hn,e),y(_e,t,e),s(t,Jn,e),y(Re,t,e),s(t,Tn,e),s(t,Se,e),s(t,Un,e),y(ze,t,e),s(t,jn,e),s(t,Ee,e),s(t,wn,e),y(Xe,t,e),s(t,fn,e),s(t,He,e),s(t,In,e),y(V,t,e),s(t,gn,e),y(Ye,t,e),s(t,bn,e),s(t,Fe,e),s(t,Cn,e),s(t,Le,e),s(t,$n,e),s(t,Pe,e),s(t,xn,e),y(De,t,e),s(t,Gn,e),s(t,Ke,e),s(t,vn,e),s(t,Oe,e),s(t,Bn,e),y(tl,t,e),s(t,Nn,e),s(t,el,e),s(t,Zn,e),y(ll,t,e),s(t,An,e),s(t,sl,e),s(t,Qn,e),y(al,t,e),s(t,kn,e),s(t,nl,e),s(t,qn,e),y(ol,t,e),s(t,Wn,e),s(t,il,e),s(t,Vn,e),s(t,pl,e),s(t,_n,e),s(t,Ml,e),s(t,Rn,e),y(rl,t,e),s(t,Sn,e),y(_,t,e),s(t,zn,e),s(t,yl,e),s(t,En,e),s(t,cl,e),s(t,Xn,e),y(ul,t,e),s(t,Hn,e),s(t,ml,e),s(t,Yn,e),y(dl,t,e),s(t,Fn,e),s(t,hl,e),s(t,Ln,e),y(Jl,t,e),s(t,Pn,e),s(t,Tl,e),s(t,Dn,e),y(Ul,t,e),s(t,Kn,e),s(t,jl,e),s(t,On,e),s(t,wl,e),s(t,to,e),y(R,t,e),s(t,eo,e),y(fl,t,e),s(t,lo,e),s(t,Il,e),s(t,so,e),s(t,gl,e),s(t,ao,e),y(bl,t,e),s(t,no,e),s(t,Cl,e),s(t,oo,e),s(t,$l,e),s(t,io,e),s(t,xl,e),s(t,po,e),y(Gl,t,e),s(t,Mo,e),s(t,vl,e),s(t,ro,e),s(t,Bl,e),s(t,yo,e),y(Nl,t,e),s(t,co,e),s(t,Zl,e),s(t,uo,e),s(t,Al,e),s(t,mo,e),y(Ql,t,e),s(t,ho,e),s(t,kl,e),s(t,Jo,e),y(ql,t,e),s(t,To,e),s(t,Wl,e),s(t,Uo,e),y(Vl,t,e),s(t,jo,e),s(t,_l,e),s(t,wo,e),y(Rl,t,e),s(t,fo,e),s(t,Sl,e),s(t,Io,e),s(t,zl,e),s(t,go,e),y(El,t,e),s(t,bo,e),s(t,Xl,e),s(t,Co,e),y(Hl,t,e),s(t,$o,e),s(t,Yl,e),s(t,xo,e),y(Fl,t,e),s(t,Go,e),s(t,Ll,e),s(t,vo,e),y(Pl,t,e),s(t,Bo,e),s(t,Dl,e),s(t,No,e),y(Kl,t,e),s(t,Zo,e),s(t,Ol,e),s(t,Ao,e),y(ts,t,e),s(t,Qo,e),s(t,es,e),s(t,ko,e),y(ls,t,e),s(t,qo,e),s(t,ss,e),s(t,Wo,e),y(as,t,e),s(t,Vo,e),s(t,ns,e),s(t,_o,e),y(os,t,e),s(t,Ro,e),s(t,is,e),s(t,So,e),y(ps,t,e),s(t,zo,e),s(t,Ms,e),Eo=!0},p(t,[e]){const Rp={};e&2&&(Rp.$$scope={dirty:e,ctx:t}),N.$set(Rp);const Sp={};e&2&&(Sp.$$scope={dirty:e,ctx:t}),Z.$set(Sp);const zp={};e&2&&(zp.$$scope={dirty:e,ctx:t}),A.$set(zp);const Ep={};e&2&&(Ep.$$scope={dirty:e,ctx:t}),Q.$set(Ep);const Xp={};e&2&&(Xp.$$scope={dirty:e,ctx:t}),k.$set(Xp);const Hp={};e&2&&(Hp.$$scope={dirty:e,ctx:t}),q.$set(Hp);const Yp={};e&2&&(Yp.$$scope={dirty:e,ctx:t}),W.$set(Yp);const Fp={};e&2&&(Fp.$$scope={dirty:e,ctx:t}),V.$set(Fp);const Lp={};e&2&&(Lp.$$scope={dirty:e,ctx:t}),_.$set(Lp);const Pp={};e&2&&(Pp.$$scope={dirty:e,ctx:t}),R.$set(Pp)},i(t){Eo||(c(C.$$.fragment,t),c(b.$$.fragment,t),c(z.$$.fragment,t),c(H.$$.fragment,t),c(N.$$.fragment,t),c(F.$$.fragment,t),c(P.$$.fragment,t),c(K.$$.fragment,t),c(tt.$$.fragment,t),c(lt.$$.fragment,t),c(at.$$.fragment,t),c(nt.$$.fragment,t),c(pt.$$.fragment,t),c(rt.$$.fragment,t),c(ct.$$.fragment,t),c(mt.$$.fragment,t),c(dt.$$.fragment,t),c(Jt.$$.fragment,t),c(Ut.$$.fragment,t),c(wt.$$.fragment,t),c(It.$$.fragment,t),c(Ct.$$.fragment,t),c(Gt.$$.fragment,t),c(Z.$$.fragment,t),c(Nt.$$.fragment,t),c(At.$$.fragment,t),c(kt.$$.fragment,t),c(A.$$.fragment,t),c(Wt.$$.fragment,t),c(Rt.$$.fragment,t),c(zt.$$.fragment,t),c(Ht.$$.fragment,t),c(Lt.$$.fragment,t),c(Kt.$$.fragment,t),c(te.$$.fragment,t),c(le.$$.fragment,t),c(ae.$$.fragment,t),c(oe.$$.fragment,t),c(Q.$$.fragment,t),c(Me.$$.fragment,t),c(k.$$.fragment,t),c(ye.$$.fragment,t),c(q.$$.fragment,t),c(ue.$$.fragment,t),c(de.$$.fragment,t),c(Je.$$.fragment,t),c(je.$$.fragment,t),c(fe.$$.fragment,t),c(be.$$.fragment,t),c(Ce.$$.fragment,t),c(Ge.$$.fragment,t),c(W.$$.fragment,t),c(ve.$$.fragment,t),c(Ne.$$.fragment,t),c(Ae.$$.fragment,t),c(We.$$.fragment,t),c(_e.$$.fragment,t),c(Re.$$.fragment,t),c(ze.$$.fragment,t),c(Xe.$$.fragment,t),c(V.$$.fragment,t),c(Ye.$$.fragment,t),c(De.$$.fragment,t),c(tl.$$.fragment,t),c(ll.$$.fragment,t),c(al.$$.fragment,t),c(ol.$$.fragment,t),c(rl.$$.fragment,t),c(_.$$.fragment,t),c(ul.$$.fragment,t),c(dl.$$.fragment,t),c(Jl.$$.fragment,t),c(Ul.$$.fragment,t),c(R.$$.fragment,t),c(fl.$$.fragment,t),c(bl.$$.fragment,t),c(Gl.$$.fragment,t),c(Nl.$$.fragment,t),c(Ql.$$.fragment,t),c(ql.$$.fragment,t),c(Vl.$$.fragment,t),c(Rl.$$.fragment,t),c(El.$$.fragment,t),c(Hl.$$.fragment,t),c(Fl.$$.fragment,t),c(Pl.$$.fragment,t),c(Kl.$$.fragment,t),c(ts.$$.fragment,t),c(ls.$$.fragment,t),c(as.$$.fragment,t),c(os.$$.fragment,t),c(ps.$$.fragment,t),Eo=!0)},o(t){u(C.$$.fragment,t),u(b.$$.fragment,t),u(z.$$.fragment,t),u(H.$$.fragment,t),u(N.$$.fragment,t),u(F.$$.fragment,t),u(P.$$.fragment,t),u(K.$$.fragment,t),u(tt.$$.fragment,t),u(lt.$$.fragment,t),u(at.$$.fragment,t),u(nt.$$.fragment,t),u(pt.$$.fragment,t),u(rt.$$.fragment,t),u(ct.$$.fragment,t),u(mt.$$.fragment,t),u(dt.$$.fragment,t),u(Jt.$$.fragment,t),u(Ut.$$.fragment,t),u(wt.$$.fragment,t),u(It.$$.fragment,t),u(Ct.$$.fragment,t),u(Gt.$$.fragment,t),u(Z.$$.fragment,t),u(Nt.$$.fragment,t),u(At.$$.fragment,t),u(kt.$$.fragment,t),u(A.$$.fragment,t),u(Wt.$$.fragment,t),u(Rt.$$.fragment,t),u(zt.$$.fragment,t),u(Ht.$$.fragment,t),u(Lt.$$.fragment,t),u(Kt.$$.fragment,t),u(te.$$.fragment,t),u(le.$$.fragment,t),u(ae.$$.fragment,t),u(oe.$$.fragment,t),u(Q.$$.fragment,t),u(Me.$$.fragment,t),u(k.$$.fragment,t),u(ye.$$.fragment,t),u(q.$$.fragment,t),u(ue.$$.fragment,t),u(de.$$.fragment,t),u(Je.$$.fragment,t),u(je.$$.fragment,t),u(fe.$$.fragment,t),u(be.$$.fragment,t),u(Ce.$$.fragment,t),u(Ge.$$.fragment,t),u(W.$$.fragment,t),u(ve.$$.fragment,t),u(Ne.$$.fragment,t),u(Ae.$$.fragment,t),u(We.$$.fragment,t),u(_e.$$.fragment,t),u(Re.$$.fragment,t),u(ze.$$.fragment,t),u(Xe.$$.fragment,t),u(V.$$.fragment,t),u(Ye.$$.fragment,t),u(De.$$.fragment,t),u(tl.$$.fragment,t),u(ll.$$.fragment,t),u(al.$$.fragment,t),u(ol.$$.fragment,t),u(rl.$$.fragment,t),u(_.$$.fragment,t),u(ul.$$.fragment,t),u(dl.$$.fragment,t),u(Jl.$$.fragment,t),u(Ul.$$.fragment,t),u(R.$$.fragment,t),u(fl.$$.fragment,t),u(bl.$$.fragment,t),u(Gl.$$.fragment,t),u(Nl.$$.fragment,t),u(Ql.$$.fragment,t),u(ql.$$.fragment,t),u(Vl.$$.fragment,t),u(Rl.$$.fragment,t),u(El.$$.fragment,t),u(Hl.$$.fragment,t),u(Fl.$$.fragment,t),u(Pl.$$.fragment,t),u(Kl.$$.fragment,t),u(ts.$$.fragment,t),u(ls.$$.fragment,t),u(as.$$.fragment,t),u(os.$$.fragment,t),u(ps.$$.fragment,t),Eo=!1},d(t){t&&(l(U),l(h),l(T),l(I),l(G),l(f),l(w),l($),l(rs),l(S),l(ys),l(cs),l(E),l(us),l(X),l(ms),l(ds),l(Y),l(hs),l(Js),l(Ts),l(L),l(Us),l(js),l(D),l(ws),l(fs),l(O),l(Is),l(gs),l(et),l(bs),l(Cs),l(st),l($s),l(xs),l(Gs),l(ot),l(vs),l(it),l(Bs),l(Ns),l(Mt),l(Zs),l(As),l(yt),l(Qs),l(ks),l(ut),l(qs),l(Ws),l(Vs),l(ht),l(_s),l(Rs),l(Tt),l(Ss),l(zs),l(jt),l(Es),l(Xs),l(ft),l(Hs),l(Ys),l(gt),l(Fs),l(bt),l(Ls),l(Ps),l($t),l(Ds),l(xt),l(Ks),l(Os),l(vt),l(ta),l(Bt),l(ea),l(la),l(sa),l(Zt),l(aa),l(na),l(Qt),l(oa),l(ia),l(qt),l(pa),l(Ma),l(ra),l(Vt),l(ya),l(_t),l(ca),l(ua),l(St),l(ma),l(da),l(Et),l(ha),l(Xt),l(Ja),l(Ta),l(Yt),l(Ua),l(Ft),l(ja),l(wa),l(Pt),l(fa),l(Dt),l(Ia),l(ga),l(Ot),l(ba),l(Ca),l(ee),l($a),l(xa),l(se),l(Ga),l(va),l(ne),l(Ba),l(Na),l(ie),l(Za),l(Aa),l(pe),l(Qa),l(ka),l(qa),l(re),l(Wa),l(Va),l(_a),l(ce),l(Ra),l(Sa),l(me),l(za),l(Ea),l(he),l(Xa),l(Ha),l(Te),l(Ya),l(Ue),l(Fa),l(La),l(we),l(Pa),l(Da),l(Ie),l(Ka),l(ge),l(Oa),l(tn),l(en),l($e),l(ln),l(xe),l(sn),l(an),l(nn),l(on),l(Be),l(pn),l(Mn),l(Ze),l(rn),l(yn),l(Qe),l(cn),l(ke),l(un),l(qe),l(mn),l(dn),l(Ve),l(hn),l(Jn),l(Tn),l(Se),l(Un),l(jn),l(Ee),l(wn),l(fn),l(He),l(In),l(gn),l(bn),l(Fe),l(Cn),l(Le),l($n),l(Pe),l(xn),l(Gn),l(Ke),l(vn),l(Oe),l(Bn),l(Nn),l(el),l(Zn),l(An),l(sl),l(Qn),l(kn),l(nl),l(qn),l(Wn),l(il),l(Vn),l(pl),l(_n),l(Ml),l(Rn),l(Sn),l(zn),l(yl),l(En),l(cl),l(Xn),l(Hn),l(ml),l(Yn),l(Fn),l(hl),l(Ln),l(Pn),l(Tl),l(Dn),l(Kn),l(jl),l(On),l(wl),l(to),l(eo),l(lo),l(Il),l(so),l(gl),l(ao),l(no),l(Cl),l(oo),l($l),l(io),l(xl),l(po),l(Mo),l(vl),l(ro),l(Bl),l(yo),l(co),l(Zl),l(uo),l(Al),l(mo),l(ho),l(kl),l(Jo),l(To),l(Wl),l(Uo),l(jo),l(_l),l(wo),l(fo),l(Sl),l(Io),l(zl),l(go),l(bo),l(Xl),l(Co),l($o),l(Yl),l(xo),l(Go),l(Ll),l(vo),l(Bo),l(Dl),l(No),l(Zo),l(Ol),l(Ao),l(Qo),l(es),l(ko),l(qo),l(ss),l(Wo),l(Vo),l(ns),l(_o),l(Ro),l(is),l(So),l(zo),l(Ms)),l(d),m(C,t),m(b,t),m(z,t),m(H,t),m(N,t),m(F,t),m(P,t),m(K,t),m(tt,t),m(lt,t),m(at,t),m(nt,t),m(pt,t),m(rt,t),m(ct,t),m(mt,t),m(dt,t),m(Jt,t),m(Ut,t),m(wt,t),m(It,t),m(Ct,t),m(Gt,t),m(Z,t),m(Nt,t),m(At,t),m(kt,t),m(A,t),m(Wt,t),m(Rt,t),m(zt,t),m(Ht,t),m(Lt,t),m(Kt,t),m(te,t),m(le,t),m(ae,t),m(oe,t),m(Q,t),m(Me,t),m(k,t),m(ye,t),m(q,t),m(ue,t),m(de,t),m(Je,t),m(je,t),m(fe,t),m(be,t),m(Ce,t),m(Ge,t),m(W,t),m(ve,t),m(Ne,t),m(Ae,t),m(We,t),m(_e,t),m(Re,t),m(ze,t),m(Xe,t),m(V,t),m(Ye,t),m(De,t),m(tl,t),m(ll,t),m(al,t),m(ol,t),m(rl,t),m(_,t),m(ul,t),m(dl,t),m(Jl,t),m(Ul,t),m(R,t),m(fl,t),m(bl,t),m(Gl,t),m(Nl,t),m(Ql,t),m(ql,t),m(Vl,t),m(Rl,t),m(El,t),m(Hl,t),m(Fl,t),m(Pl,t),m(Kl,t),m(ts,t),m(ls,t),m(as,t),m(os,t),m(ps,t)}}}const UM='{"title":"Chat Templates","local":"chat-templates","sections":[{"title":"Introduction","local":"introduction","sections":[],"depth":2},{"title":"How do I use chat templates?","local":"how-do-i-use-chat-templates","sections":[],"depth":2},{"title":"Usage with text-only LLMs","local":"usage-with-text-only-llms","sections":[],"depth":2},{"title":"Usage with multimodal LLMs","local":"usage-with-multimodal-llms","sections":[],"depth":2},{"title":"Is there an automated pipeline for chat?","local":"is-there-an-automated-pipeline-for-chat","sections":[],"depth":2},{"title":"What are “generation prompts”?","local":"what-are-generation-prompts","sections":[],"depth":2},{"title":"What does “continue_final_message” do?","local":"what-does-continuefinalmessage-do","sections":[],"depth":2},{"title":"Can I use chat templates in training?","local":"can-i-use-chat-templates-in-training","sections":[],"depth":2},{"title":"Advanced: Extra inputs to chat templates","local":"advanced-extra-inputs-to-chat-templates","sections":[],"depth":2},{"title":"Advanced: Tool use / function calling","local":"advanced-tool-use--function-calling","sections":[{"title":"Passing tool results to the model","local":"passing-tool-results-to-the-model","sections":[],"depth":3},{"title":"A complete tool use example","local":"a-complete-tool-use-example","sections":[],"depth":3},{"title":"Understanding tool schemas","local":"understanding-tool-schemas","sections":[],"depth":3}],"depth":2},{"title":"Advanced: Retrieval-augmented generation","local":"advanced-retrieval-augmented-generation","sections":[],"depth":2},{"title":"Advanced: How do chat templates work?","local":"advanced-how-do-chat-templates-work","sections":[],"depth":2},{"title":"Advanced: Adding and editing chat templates","local":"advanced-adding-and-editing-chat-templates","sections":[{"title":"How do I create a chat template?","local":"how-do-i-create-a-chat-template","sections":[],"depth":3},{"title":"Why do some models have multiple templates?","local":"why-do-some-models-have-multiple-templates","sections":[],"depth":3},{"title":"What template should I use?","local":"what-template-should-i-use","sections":[],"depth":3},{"title":"I want to add some chat templates! How should I get started?","local":"i-want-to-add-some-chat-templates-how-should-i-get-started","sections":[],"depth":3}],"depth":2},{"title":"Advanced: Template writing tips","local":"advanced-template-writing-tips","sections":[{"title":"Trimming whitespace","local":"trimming-whitespace","sections":[],"depth":3},{"title":"Special variables","local":"special-variables","sections":[],"depth":3},{"title":"Callable functions","local":"callable-functions","sections":[],"depth":3},{"title":"Compatibility with non-Python Jinja","local":"compatibility-with-non-python-jinja","sections":[],"depth":3},{"title":"Writing generation prompts","local":"writing-generation-prompts","sections":[],"depth":3},{"title":"Writing and debugging larger templates","local":"writing-and-debugging-larger-templates","sections":[],"depth":3},{"title":"Writing templates for tools","local":"writing-templates-for-tools","sections":[{"title":"Tool definitions","local":"tool-definitions","sections":[],"depth":4},{"title":"Tool calls","local":"tool-calls","sections":[],"depth":4},{"title":"Tool responses","local":"tool-responses","sections":[],"depth":4}],"depth":3}],"depth":2}],"depth":1}';function jM(g){return tM(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class CM extends eM{constructor(d){super(),lM(this,d,jM,TM,Op,{})}}export{CM as component};
