import{s as gt,n as Tt,o as _t}from"../chunks/scheduler.85c25b89.js";import{S as Zt,i as $t,g as s,s as n,r,A as vt,h as o,f as l,c as i,j as Mt,u as m,x as p,k as yt,l as Ct,y as Jt,a,v as d,d as c,t as f,w as u}from"../chunks/index.c9bcf812.js";import{C as h}from"../chunks/CodeBlock.94efc595.js";import{H as Qe,E as Ut}from"../chunks/EditOnGithub.ec73e7c7.js";function xt(Se){let b,ne,le,ie,M,se,y,Ye=`The notebooks and scripts in this examples show how to use Low Rank Adaptation (LoRA) to fine-tune models in a memory efficient manner. Most of PEFT methods supported in peft library but note that some PEFT methods such as Prompt tuning are not supported.
For more information on LoRA, see the <a href="https://arxiv.org/abs/2106.09685" rel="nofollow">original paper</a>.`,oe,g,ze='Here’s an overview of the <code>peft</code>-enabled notebooks and scripts in the <a href="https://github.com/huggingface/trl/tree/main/examples" rel="nofollow">trl repository</a>:',pe,T,De='<thead><tr><th>File</th> <th>Task</th> <th>Description</th></tr></thead> <tbody><tr><td><a href="https://github.com/huggingface/trl/blob/main/examples/research_projects/stack_llama/scripts/rl_training.py" rel="nofollow"><code>stack_llama/rl_training.py</code></a></td> <td>RLHF</td> <td>Distributed fine-tuning of the 7b parameter LLaMA models with a learned reward model and <code>peft</code>.</td></tr> <tr><td><a href="https://github.com/huggingface/trl/blob/main/examples/research_projects/stack_llama/scripts/reward_modeling.py" rel="nofollow"><code>stack_llama/reward_modeling.py</code></a></td> <td>Reward Modeling</td> <td>Distributed training of the 7b parameter LLaMA reward model with <code>peft</code>.</td></tr> <tr><td><a href="https://github.com/huggingface/trl/blob/main/examples/research_projects/stack_llama/scripts/supervised_finetuning.py" rel="nofollow"><code>stack_llama/supervised_finetuning.py</code></a></td> <td>SFT</td> <td>Distributed instruction/supervised fine-tuning of the 7b parameter LLaMA model with <code>peft</code>.</td></tr></tbody>',re,_,me,Z,qe=`Note: peft is in active development, so we install directly from their Github page.
Peft also relies on the latest version of transformers.`,de,$,ce,v,Ke='Note: if you don’t want to log with <code>wandb</code> remove <code>log_with=&quot;wandb&quot;</code> in the scripts/notebooks. You can also replace it with your favourite experiment tracker that’s <a href="https://huggingface.co/docs/accelerate/usage_guides/tracking" rel="nofollow">supported by <code>accelerate</code></a>.',fe,C,ue,J,Oe="Simply declare a <code>PeftConfig</code> object in your script and pass it through <code>.from_pretrained</code> to load the TRL+PEFT model.",he,U,be,x,et="And if you want to load your model in 8bit precision:",we,j,Me,H,tt="… or in 4bit precision:",ye,L,ge,k,Te,G,lt="The <code>trl</code> library is powered by <code>accelerate</code>. As such it is best to configure and launch trainings with the following commands:",_e,W,Ze,B,at="## Using <code>trl</code> + <code>peft</code> and Data Parallelism",$e,R,nt="You can scale up to as many GPUs as you want, as long as you are able to fit the training process in a single device. The only tweak you need to apply is to load the model as follows:",ve,F,Ce,I,it="And if you want to load your model in 8bit precision:",Je,N,Ue,A,st="… or in 4bit precision:",xe,E,je,P,ot="Finally, make sure that the rewards are computed on correct device as well, for that you can use <code>ppo_trainer.model.current_device</code>.",He,V,pt="## Naive pipeline parallelism (NPP) for large models (>60B models)",Le,X,rt=`The <code>trl</code> library also supports naive pipeline parallelism (NPP) for large models (&gt;60B models). This is a simple way to parallelize the model across multiple GPUs.
This paradigm, termed as “Naive Pipeline Parallelism” (NPP) is a simple way to parallelize the model across multiple GPUs. We load the model and the adapters across multiple GPUs and the activations and gradients will be naively communicated across the GPUs. This supports <code>int8</code> models as well as other <code>dtype</code> models.`,ke,w,mt='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/trl-npp.png"/>',Ge,Q,dt="### How to use NPP?",We,S,ct='Simply load your model with a custom <code>device_map</code> argument on the <code>from_pretrained</code> to split your model across multiple devices. Check out this <a href="https://github.com/huggingface/blog/blob/main/accelerate-large-models.md" rel="nofollow">nice tutorial</a> on how to properly create a <code>device_map</code> for your model.',Be,Y,ft="Also make sure to have the <code>lm_head</code> module on the first GPU device as it may throw an error if it is not on the first device. As this time of writing, you need to install the <code>main</code> branch of <code>accelerate</code>: <code>pip install git+https://github.com/huggingface/accelerate.git@main</code> and <code>peft</code>: <code>pip install git+https://github.com/huggingface/peft.git@main</code>.",Re,z,ut="### Launch scripts",Fe,D,ht="Although <code>trl</code> library is powered by <code>accelerate</code>, you should run your training script in a single process. Note that we do not support Data Parallelism together with NPP yet.",Ie,q,Ne,K,bt="## Fine-tuning Llama-2 model",Ae,O,wt="You can easily fine-tune Llama2 model using <code>SFTTrainer</code> and the official script! For example to fine-tune llama2-7b on the Guanaco dataset, run (tested on a single NVIDIA T4-16GB):",Ee,ee,Pe,te,Ve,ae,Xe;return M=new Qe({props:{title:"Examples of using peft with trl to finetune 8-bit models with Low Rank Adaption (LoRA)",local:"examples-of-using-peft-with-trl-to-finetune-8-bit-models-with-low-rank-adaption-lora",headingTag:"h1"}}),_=new Qe({props:{title:"Installation",local:"installation",headingTag:"h2"}}),$=new h({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRybCU1QnBlZnQlNUQlMEFwaXAlMjBpbnN0YWxsJTIwYml0c2FuZGJ5dGVzJTIwbG9yYWxpYiUwQXBpcCUyMGluc3RhbGwlMjBnaXQlMkJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRnRyYW5zZm9ybWVycy5naXQlNDBtYWluJTBBJTIzb3B0aW9uYWwlM0ElMjB3YW5kYiUwQXBpcCUyMGluc3RhbGwlMjB3YW5kYg==",highlighted:`pip install trl[peft]
pip install bitsandbytes loralib
pip install git+https://github.com/huggingface/transformers.git@main
<span class="hljs-comment">#optional: wandb</span>
pip install wandb`,wrap:!1}}),C=new Qe({props:{title:"How to use it?",local:"how-to-use-it",headingTag:"h2"}}),U=new h({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNV2l0aFZhbHVlSGVhZCUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyZWRiZWVjaGluZyUyRmdwdC1uZW8tMTI1TS1pbWRiJTIyJTBBbG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0QzMiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfZHJvcG91dCUzRDAuMDUlMkMlMEElMjAlMjAlMjAlMjBiaWFzJTNEJTIybm9uZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRhc2tfdHlwZSUzRCUyMkNBVVNBTF9MTSUyMiUyQyUwQSklMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNV2l0aFZhbHVlSGVhZC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMjAlMEElMjAlMjAlMjAlMjBwZWZ0X2NvbmZpZyUzRGxvcmFfY29uZmlnJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> AutoModelForCausalLMWithValueHead

model_id = <span class="hljs-string">&quot;edbeeching/gpt-neo-125M-imdb&quot;</span>
lora_config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

model = AutoModelForCausalLMWithValueHead.from_pretrained(
    model_id, 
    peft_config=lora_config,
)`,wrap:!1}}),j=new h({props:{code:"cHJldHJhaW5lZF9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNV2l0aFZhbHVlSGVhZC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwY29uZmlnLm1vZGVsX25hbWUlMkMlMjAlMEElMjAlMjAlMjAlMjBsb2FkX2luXzhiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcGVmdF9jb25maWclM0Rsb3JhX2NvbmZpZyUyQyUwQSk=",highlighted:`pretrained_model = AutoModelForCausalLMWithValueHead.from_pretrained(
    config.model_name, 
    load_in_8bit=<span class="hljs-literal">True</span>,
    peft_config=lora_config,
)`,wrap:!1}}),L=new h({props:{code:"cHJldHJhaW5lZF9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNV2l0aFZhbHVlSGVhZC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwY29uZmlnLm1vZGVsX25hbWUlMkMlMjAlMEElMjAlMjAlMjAlMjBwZWZ0X2NvbmZpZyUzRGxvcmFfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUwQSk=",highlighted:`pretrained_model = AutoModelForCausalLMWithValueHead.from_pretrained(
    config.model_name, 
    peft_config=lora_config,
    load_in_4bit=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),k=new Qe({props:{title:"Launch scripts",local:"launch-scripts",headingTag:"h2"}}),W=new h({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZyUyMCUyMyUyMHdpbGwlMjBwcm9tcHQlMjB5b3UlMjB0byUyMGRlZmluZSUyMHRoZSUyMHRyYWluaW5nJTIwY29uZmlndXJhdGlvbiUwQWFjY2VsZXJhdGUlMjBsYXVuY2glMjBleGFtcGxlcyUyRnNjcmlwdHMlMkZwcG8ucHklMjAtLXVzZV9wZWZ0JTIwJTIzJTIwbGF1bmNoJTYwZXMlMjB0cmFpbmluZw==",highlighted:'accelerate config <span class="hljs-comment"># will prompt you to define the training configuration</span>\naccelerate launch examples/scripts/ppo.py --use_peft <span class="hljs-comment"># launch`es training</span>',wrap:!1}}),F=new h({props:{code:"JTBB",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
...

lora_config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

pretrained_model = AutoModelForCausalLMWithValueHead.from_pretrained(
    config.model_name, 
    peft_config=lora_config,
)`,wrap:!1}}),N=new h({props:{code:"cHJldHJhaW5lZF9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNV2l0aFZhbHVlSGVhZC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwY29uZmlnLm1vZGVsX25hbWUlMkMlMjAlMEElMjAlMjAlMjAlMjBwZWZ0X2NvbmZpZyUzRGxvcmFfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl84Yml0JTNEVHJ1ZSUyQyUwQSk=",highlighted:`pretrained_model = AutoModelForCausalLMWithValueHead.from_pretrained(
    config.model_name, 
    peft_config=lora_config,
    load_in_8bit=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),E=new h({props:{code:"cHJldHJhaW5lZF9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNV2l0aFZhbHVlSGVhZC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwY29uZmlnLm1vZGVsX25hbWUlMkMlMjAlMEElMjAlMjAlMjAlMjBwZWZ0X2NvbmZpZyUzRGxvcmFfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUwQSk=",highlighted:`pretrained_model = AutoModelForCausalLMWithValueHead.from_pretrained(
    config.model_name, 
    peft_config=lora_config,
    load_in_4bit=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),q=new h({props:{code:"cHl0aG9uJTIwUEFUSF9UT19TQ1JJUFQ=",highlighted:"python PATH_TO_SCRIPT",wrap:!1}}),ee=new h({props:{code:"cHl0aG9uJTIwZXhhbXBsZXMlMkZzY3JpcHRzJTJGc2Z0LnB5JTIwLS1vdXRwdXRfZGlyJTIwc2Z0X29wZW5hc3Npc3RhbnQtZ3VhbmFjbyUyMCUyMC0tbW9kZWxfbmFtZSUyMG1ldGEtbGxhbWElMkZMbGFtYS0yLTdiLWhmJTIwLS1kYXRhc2V0X25hbWUlMjB0aW1kZXR0bWVycyUyRm9wZW5hc3Npc3RhbnQtZ3VhbmFjbyUyMC0tbG9hZF9pbl80Yml0JTIwLS11c2VfcGVmdCUyMC0tcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTIwNCUyMC0tZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTIwMg==",highlighted:"python examples/scripts/sft.py --output_dir sft_openassistant-guanaco  --model_name meta-llama/Llama-2-7b-hf --dataset_name timdettmers/openassistant-guanaco --load_in_4bit --use_peft --per_device_train_batch_size 4 --gradient_accumulation_steps 2",wrap:!1}}),te=new Ut({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/lora_tuning_peft.mdx"}}),{c(){b=s("meta"),ne=n(),le=s("p"),ie=n(),r(M.$$.fragment),se=n(),y=s("p"),y.innerHTML=Ye,oe=n(),g=s("p"),g.innerHTML=ze,pe=n(),T=s("table"),T.innerHTML=De,re=n(),r(_.$$.fragment),me=n(),Z=s("p"),Z.textContent=qe,de=n(),r($.$$.fragment),ce=n(),v=s("p"),v.innerHTML=Ke,fe=n(),r(C.$$.fragment),ue=n(),J=s("p"),J.innerHTML=Oe,he=n(),r(U.$$.fragment),be=n(),x=s("p"),x.textContent=et,we=n(),r(j.$$.fragment),Me=n(),H=s("p"),H.textContent=tt,ye=n(),r(L.$$.fragment),ge=n(),r(k.$$.fragment),Te=n(),G=s("p"),G.innerHTML=lt,_e=n(),r(W.$$.fragment),Ze=n(),B=s("p"),B.innerHTML=at,$e=n(),R=s("p"),R.textContent=nt,ve=n(),r(F.$$.fragment),Ce=n(),I=s("p"),I.textContent=it,Je=n(),r(N.$$.fragment),Ue=n(),A=s("p"),A.textContent=st,xe=n(),r(E.$$.fragment),je=n(),P=s("p"),P.innerHTML=ot,He=n(),V=s("p"),V.textContent=pt,Le=n(),X=s("p"),X.innerHTML=rt,ke=n(),w=s("div"),w.innerHTML=mt,Ge=n(),Q=s("p"),Q.textContent=dt,We=n(),S=s("p"),S.innerHTML=ct,Be=n(),Y=s("p"),Y.innerHTML=ft,Re=n(),z=s("p"),z.textContent=ut,Fe=n(),D=s("p"),D.innerHTML=ht,Ie=n(),r(q.$$.fragment),Ne=n(),K=s("p"),K.textContent=bt,Ae=n(),O=s("p"),O.innerHTML=wt,Ee=n(),r(ee.$$.fragment),Pe=n(),r(te.$$.fragment),Ve=n(),ae=s("p"),this.h()},l(e){const t=vt("svelte-u9bgzb",document.head);b=o(t,"META",{name:!0,content:!0}),t.forEach(l),ne=i(e),le=o(e,"P",{}),Mt(le).forEach(l),ie=i(e),m(M.$$.fragment,e),se=i(e),y=o(e,"P",{"data-svelte-h":!0}),p(y)!=="svelte-1z0xkop"&&(y.innerHTML=Ye),oe=i(e),g=o(e,"P",{"data-svelte-h":!0}),p(g)!=="svelte-1mehpt8"&&(g.innerHTML=ze),pe=i(e),T=o(e,"TABLE",{"data-svelte-h":!0}),p(T)!=="svelte-5tx68h"&&(T.innerHTML=De),re=i(e),m(_.$$.fragment,e),me=i(e),Z=o(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-1xrpojm"&&(Z.textContent=qe),de=i(e),m($.$$.fragment,e),ce=i(e),v=o(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-vkwr34"&&(v.innerHTML=Ke),fe=i(e),m(C.$$.fragment,e),ue=i(e),J=o(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-hndmna"&&(J.innerHTML=Oe),he=i(e),m(U.$$.fragment,e),be=i(e),x=o(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-lllysa"&&(x.textContent=et),we=i(e),m(j.$$.fragment,e),Me=i(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-fsazu1"&&(H.textContent=tt),ye=i(e),m(L.$$.fragment,e),ge=i(e),m(k.$$.fragment,e),Te=i(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1dq9zm0"&&(G.innerHTML=lt),_e=i(e),m(W.$$.fragment,e),Ze=i(e),B=o(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-axa1b3"&&(B.innerHTML=at),$e=i(e),R=o(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-5gjozh"&&(R.textContent=nt),ve=i(e),m(F.$$.fragment,e),Ce=i(e),I=o(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-lllysa"&&(I.textContent=it),Je=i(e),m(N.$$.fragment,e),Ue=i(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-fsazu1"&&(A.textContent=st),xe=i(e),m(E.$$.fragment,e),je=i(e),P=o(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-bxfofv"&&(P.innerHTML=ot),He=i(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1ina4iv"&&(V.textContent=pt),Le=i(e),X=o(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-1wvtyh7"&&(X.innerHTML=rt),ke=i(e),w=o(e,"DIV",{style:!0,"data-svelte-h":!0}),p(w)!=="svelte-axlm0o"&&(w.innerHTML=mt),Ge=i(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-ymfl6m"&&(Q.textContent=dt),We=i(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-baerbw"&&(S.innerHTML=ct),Be=i(e),Y=o(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-pr8lox"&&(Y.innerHTML=ft),Re=i(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1wmjcz0"&&(z.textContent=ut),Fe=i(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-qlesp3"&&(D.innerHTML=ht),Ie=i(e),m(q.$$.fragment,e),Ne=i(e),K=o(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-6zwuh"&&(K.textContent=bt),Ae=i(e),O=o(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-98ab3u"&&(O.innerHTML=wt),Ee=i(e),m(ee.$$.fragment,e),Pe=i(e),m(te.$$.fragment,e),Ve=i(e),ae=o(e,"P",{}),Mt(ae).forEach(l),this.h()},h(){yt(b,"name","hf:doc:metadata"),yt(b,"content",jt),Ct(w,"text-align","center")},m(e,t){Jt(document.head,b),a(e,ne,t),a(e,le,t),a(e,ie,t),d(M,e,t),a(e,se,t),a(e,y,t),a(e,oe,t),a(e,g,t),a(e,pe,t),a(e,T,t),a(e,re,t),d(_,e,t),a(e,me,t),a(e,Z,t),a(e,de,t),d($,e,t),a(e,ce,t),a(e,v,t),a(e,fe,t),d(C,e,t),a(e,ue,t),a(e,J,t),a(e,he,t),d(U,e,t),a(e,be,t),a(e,x,t),a(e,we,t),d(j,e,t),a(e,Me,t),a(e,H,t),a(e,ye,t),d(L,e,t),a(e,ge,t),d(k,e,t),a(e,Te,t),a(e,G,t),a(e,_e,t),d(W,e,t),a(e,Ze,t),a(e,B,t),a(e,$e,t),a(e,R,t),a(e,ve,t),d(F,e,t),a(e,Ce,t),a(e,I,t),a(e,Je,t),d(N,e,t),a(e,Ue,t),a(e,A,t),a(e,xe,t),d(E,e,t),a(e,je,t),a(e,P,t),a(e,He,t),a(e,V,t),a(e,Le,t),a(e,X,t),a(e,ke,t),a(e,w,t),a(e,Ge,t),a(e,Q,t),a(e,We,t),a(e,S,t),a(e,Be,t),a(e,Y,t),a(e,Re,t),a(e,z,t),a(e,Fe,t),a(e,D,t),a(e,Ie,t),d(q,e,t),a(e,Ne,t),a(e,K,t),a(e,Ae,t),a(e,O,t),a(e,Ee,t),d(ee,e,t),a(e,Pe,t),d(te,e,t),a(e,Ve,t),a(e,ae,t),Xe=!0},p:Tt,i(e){Xe||(c(M.$$.fragment,e),c(_.$$.fragment,e),c($.$$.fragment,e),c(C.$$.fragment,e),c(U.$$.fragment,e),c(j.$$.fragment,e),c(L.$$.fragment,e),c(k.$$.fragment,e),c(W.$$.fragment,e),c(F.$$.fragment,e),c(N.$$.fragment,e),c(E.$$.fragment,e),c(q.$$.fragment,e),c(ee.$$.fragment,e),c(te.$$.fragment,e),Xe=!0)},o(e){f(M.$$.fragment,e),f(_.$$.fragment,e),f($.$$.fragment,e),f(C.$$.fragment,e),f(U.$$.fragment,e),f(j.$$.fragment,e),f(L.$$.fragment,e),f(k.$$.fragment,e),f(W.$$.fragment,e),f(F.$$.fragment,e),f(N.$$.fragment,e),f(E.$$.fragment,e),f(q.$$.fragment,e),f(ee.$$.fragment,e),f(te.$$.fragment,e),Xe=!1},d(e){e&&(l(ne),l(le),l(ie),l(se),l(y),l(oe),l(g),l(pe),l(T),l(re),l(me),l(Z),l(de),l(ce),l(v),l(fe),l(ue),l(J),l(he),l(be),l(x),l(we),l(Me),l(H),l(ye),l(ge),l(Te),l(G),l(_e),l(Ze),l(B),l($e),l(R),l(ve),l(Ce),l(I),l(Je),l(Ue),l(A),l(xe),l(je),l(P),l(He),l(V),l(Le),l(X),l(ke),l(w),l(Ge),l(Q),l(We),l(S),l(Be),l(Y),l(Re),l(z),l(Fe),l(D),l(Ie),l(Ne),l(K),l(Ae),l(O),l(Ee),l(Pe),l(Ve),l(ae)),l(b),u(M,e),u(_,e),u($,e),u(C,e),u(U,e),u(j,e),u(L,e),u(k,e),u(W,e),u(F,e),u(N,e),u(E,e),u(q,e),u(ee,e),u(te,e)}}}const jt='{"title":"Examples of using peft with trl to finetune 8-bit models with Low Rank Adaption (LoRA)","local":"examples-of-using-peft-with-trl-to-finetune-8-bit-models-with-low-rank-adaption-lora","sections":[{"title":"Installation","local":"installation","sections":[],"depth":2},{"title":"How to use it?","local":"how-to-use-it","sections":[],"depth":2},{"title":"Launch scripts","local":"launch-scripts","sections":[],"depth":2}],"depth":1}';function Ht(Se){return _t(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Bt extends Zt{constructor(b){super(),$t(this,b,Ht,xt,gt,{})}}export{Bt as component};
