import{s as Rt,f as Et,o as Zt,n as eo}from"../chunks/scheduler.25b97de1.js";import{S as St,i as Gt,g as l,s as n,r as h,A as Vt,h as d,f as t,c as s,j as M,u as g,x as y,k as x,y as i,a,v as f,d as u,t as _,w as b}from"../chunks/index.d9030fc9.js";import{T as pt}from"../chunks/Tip.baa67368.js";import{D as J}from"../chunks/Docstring.e257edda.js";import{C as Oo}from"../chunks/CodeBlock.e6cd0d95.js";import{E as ht}from"../chunks/ExampleCodeBlock.20db4b6e.js";import{P as Ht}from"../chunks/PipelineTag.5f100392.js";import{H as F,E as Bt}from"../chunks/EditOnGithub.91d95064.js";function At(j){let r,v='Use <a href="/docs/transformers/pr_28847/en/model_doc/yolos#transformers.YolosImageProcessor">YolosImageProcessor</a> for preparing images (and optional targets) for the model. Contrary to <a href="detr">DETR</a>, YOLOS doesn’t require a <code>pixel_mask</code> to be created.';return{c(){r=l("p"),r.innerHTML=v},l(m){r=d(m,"P",{"data-svelte-h":!0}),y(r)!=="svelte-ckxfd9"&&(r.innerHTML=v)},m(m,p){a(m,r,p)},p:eo,d(m){m&&t(r)}}}function Xt(j){let r,v="Example:",m,p,w;return p=new Oo({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFlvbG9zQ29uZmlnJTJDJTIwWW9sb3NNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBZT0xPUyUyMGh1c3R2bCUyRnlvbG9zLWJhc2UlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwWW9sb3NDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMCh3aXRoJTIwcmFuZG9tJTIwd2VpZ2h0cyklMjBmcm9tJTIwdGhlJTIwaHVzdHZsJTJGeW9sb3MtYmFzZSUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwWW9sb3NNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> YolosConfig, YolosModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a YOLOS hustvl/yolos-base style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = YolosConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the hustvl/yolos-base style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = YolosModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){r=l("p"),r.textContent=v,m=n(),h(p.$$.fragment)},l(c){r=d(c,"P",{"data-svelte-h":!0}),y(r)!=="svelte-11lpom8"&&(r.textContent=v),m=s(c),g(p.$$.fragment,c)},m(c,T){a(c,r,T),a(c,m,T),f(p,c,T),w=!0},p:eo,i(c){w||(u(p.$$.fragment,c),w=!0)},o(c){_(p.$$.fragment,c),w=!1},d(c){c&&(t(r),t(m)),b(p,c)}}}function Qt(j){let r,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=l("p"),r.innerHTML=v},l(m){r=d(m,"P",{"data-svelte-h":!0}),y(r)!=="svelte-fincs2"&&(r.innerHTML=v)},m(m,p){a(m,r,p)},p:eo,d(m){m&&t(r)}}}function Kt(j){let r,v="Example:",m,p,w;return p=new Oo({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFlvbG9zTW9kZWwlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaHVnZ2luZ2ZhY2UlMkZjYXRzLWltYWdlJTIyKSUwQWltYWdlJTIwJTNEJTIwZGF0YXNldCU1QiUyMnRlc3QlMjIlNUQlNUIlMjJpbWFnZSUyMiU1RCU1QjAlNUQlMEElMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmh1c3R2bCUyRnlvbG9zLXNtYWxsJTIyKSUwQW1vZGVsJTIwJTNEJTIwWW9sb3NNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyaHVzdHZsJTJGeW9sb3Mtc21hbGwlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQWxhc3RfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGUlMEFsaXN0KGxhc3RfaGlkZGVuX3N0YXRlcy5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, YolosModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;hustvl/yolos-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = YolosModel.from_pretrained(<span class="hljs-string">&quot;hustvl/yolos-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">3401</span>, <span class="hljs-number">384</span>]`,wrap:!1}}),{c(){r=l("p"),r.textContent=v,m=n(),h(p.$$.fragment)},l(c){r=d(c,"P",{"data-svelte-h":!0}),y(r)!=="svelte-11lpom8"&&(r.textContent=v),m=s(c),g(p.$$.fragment,c)},m(c,T){a(c,r,T),a(c,m,T),f(p,c,T),w=!0},p:eo,i(c){w||(u(p.$$.fragment,c),w=!0)},o(c){_(p.$$.fragment,c),w=!1},d(c){c&&(t(r),t(m)),b(p,c)}}}function en(j){let r,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=l("p"),r.innerHTML=v},l(m){r=d(m,"P",{"data-svelte-h":!0}),y(r)!=="svelte-fincs2"&&(r.innerHTML=v)},m(m,p){a(m,r,p)},p:eo,d(m){m&&t(r)}}}function on(j){let r,v="Examples:",m,p,w;return p=new Oo({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbEZvck9iamVjdERldGVjdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJodXN0dmwlMkZ5b2xvcy10aW55JTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yT2JqZWN0RGV0ZWN0aW9uLmZyb21fcHJldHJhaW5lZCglMjJodXN0dmwlMkZ5b2xvcy10aW55JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQSUyMyUyMGNvbnZlcnQlMjBvdXRwdXRzJTIwKGJvdW5kaW5nJTIwYm94ZXMlMjBhbmQlMjBjbGFzcyUyMGxvZ2l0cyklMjB0byUyMFBhc2NhbCUyMFZPQyUyMGZvcm1hdCUyMCh4bWluJTJDJTIweW1pbiUyQyUyMHhtYXglMkMlMjB5bWF4KSUwQXRhcmdldF9zaXplcyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUJpbWFnZS5zaXplJTVCJTNBJTNBLTElNUQlNUQpJTBBcmVzdWx0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3Nvci5wb3N0X3Byb2Nlc3Nfb2JqZWN0X2RldGVjdGlvbihvdXRwdXRzJTJDJTIwdGhyZXNob2xkJTNEMC45JTJDJTIwdGFyZ2V0X3NpemVzJTNEdGFyZ2V0X3NpemVzKSU1QiUwQSUyMCUyMCUyMCUyMDAlMEElNUQlMEElMEFmb3IlMjBzY29yZSUyQyUyMGxhYmVsJTJDJTIwYm94JTIwaW4lMjB6aXAocmVzdWx0cyU1QiUyMnNjb3JlcyUyMiU1RCUyQyUyMHJlc3VsdHMlNUIlMjJsYWJlbHMlMjIlNUQlMkMlMjByZXN1bHRzJTVCJTIyYm94ZXMlMjIlNUQpJTNBJTBBJTIwJTIwJTIwJTIwYm94JTIwJTNEJTIwJTVCcm91bmQoaSUyQyUyMDIpJTIwZm9yJTIwaSUyMGluJTIwYm94LnRvbGlzdCgpJTVEJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMkRldGVjdGVkJTIwJTdCbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCbGFiZWwuaXRlbSgpJTVEJTdEJTIwd2l0aCUyMGNvbmZpZGVuY2UlMjAlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmJTIyJTdCcm91bmQoc2NvcmUuaXRlbSgpJTJDJTIwMyklN0QlMjBhdCUyMGxvY2F0aW9uJTIwJTdCYm94JTdEJTIyJTBBJTIwJTIwJTIwJTIwKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModelForObjectDetection
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;hustvl/yolos-tiny&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForObjectDetection.from_pretrained(<span class="hljs-string">&quot;hustvl/yolos-tiny&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># convert outputs (bounding boxes and class logits) to Pascal VOC format (xmin, ymin, xmax, ymax)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>target_sizes = torch.tensor([image.size[::-<span class="hljs-number">1</span>]])
<span class="hljs-meta">&gt;&gt;&gt; </span>results = image_processor.post_process_object_detection(outputs, threshold=<span class="hljs-number">0.9</span>, target_sizes=target_sizes)[
<span class="hljs-meta">... </span>    <span class="hljs-number">0</span>
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> score, label, box <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(results[<span class="hljs-string">&quot;scores&quot;</span>], results[<span class="hljs-string">&quot;labels&quot;</span>], results[<span class="hljs-string">&quot;boxes&quot;</span>]):
<span class="hljs-meta">... </span>    box = [<span class="hljs-built_in">round</span>(i, <span class="hljs-number">2</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> box.tolist()]
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>        <span class="hljs-string">f&quot;Detected <span class="hljs-subst">{model.config.id2label[label.item()]}</span> with confidence &quot;</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">f&quot;<span class="hljs-subst">{<span class="hljs-built_in">round</span>(score.item(), <span class="hljs-number">3</span>)}</span> at location <span class="hljs-subst">{box}</span>&quot;</span>
<span class="hljs-meta">... </span>    )
Detected remote <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.991</span> at location [<span class="hljs-number">46.48</span>, <span class="hljs-number">72.78</span>, <span class="hljs-number">178.98</span>, <span class="hljs-number">119.3</span>]
Detected remote <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.908</span> at location [<span class="hljs-number">336.48</span>, <span class="hljs-number">79.27</span>, <span class="hljs-number">368.23</span>, <span class="hljs-number">192.36</span>]
Detected cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.934</span> at location [<span class="hljs-number">337.18</span>, <span class="hljs-number">18.06</span>, <span class="hljs-number">638.14</span>, <span class="hljs-number">373.09</span>]
Detected cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.979</span> at location [<span class="hljs-number">10.93</span>, <span class="hljs-number">53.74</span>, <span class="hljs-number">313.41</span>, <span class="hljs-number">470.67</span>]
Detected remote <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.974</span> at location [<span class="hljs-number">41.63</span>, <span class="hljs-number">72.23</span>, <span class="hljs-number">178.09</span>, <span class="hljs-number">119.99</span>]`,wrap:!1}}),{c(){r=l("p"),r.textContent=v,m=n(),h(p.$$.fragment)},l(c){r=d(c,"P",{"data-svelte-h":!0}),y(r)!=="svelte-kvfsh7"&&(r.textContent=v),m=s(c),g(p.$$.fragment,c)},m(c,T){a(c,r,T),a(c,m,T),f(p,c,T),w=!0},p:eo,i(c){w||(u(p.$$.fragment,c),w=!0)},o(c){_(p.$$.fragment,c),w=!1},d(c){c&&(t(r),t(m)),b(p,c)}}}function tn(j){let r,v,m,p,w,c,T,to,ee,gt=`The YOLOS model was proposed in <a href="https://arxiv.org/abs/2106.00666" rel="nofollow">You Only Look at One Sequence: Rethinking Transformer in Vision through Object Detection</a> by Yuxin Fang, Bencheng Liao, Xinggang Wang, Jiemin Fang, Jiyang Qi, Rui Wu, Jianwei Niu, Wenyu Liu.
YOLOS proposes to just leverage the plain <a href="vit">Vision Transformer (ViT)</a> for object detection, inspired by DETR. It turns out that a base-sized encoder-only Transformer can also achieve 42 AP on COCO, similar to DETR and much more complex frameworks such as Faster R-CNN.`,no,oe,ft="The abstract from the paper is the following:",so,te,ut="<em>Can Transformer perform 2D object- and region-level recognition from a pure sequence-to-sequence perspective with minimal knowledge about the 2D spatial structure? To answer this question, we present You Only Look at One Sequence (YOLOS), a series of object detection models based on the vanilla Vision Transformer with the fewest possible modifications, region priors, as well as inductive biases of the target task. We find that YOLOS pre-trained on the mid-sized ImageNet-1k dataset only can already achieve quite competitive performance on the challenging COCO object detection benchmark, e.g., YOLOS-Base directly adopted from BERT-Base architecture can obtain 42.0 box AP on COCO val. We also discuss the impacts as well as limitations of current pre-train schemes and model scaling strategies for Transformer in vision through YOLOS.</em>",ao,O,_t,ro,ne,bt='YOLOS architecture. Taken from the <a href="https://arxiv.org/abs/2106.00666">original paper</a>.',io,se,yt='This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>. The original code can be found <a href="https://github.com/hustvl/YOLOS" rel="nofollow">here</a>.',lo,ae,co,re,vt=`PyTorch includes a native scaled dot-product attention (SDPA) operator as part of <code>torch.nn.functional</code>. This function
encompasses several implementations that can be applied depending on the inputs and the hardware in use. See the
<a href="https://pytorch.org/docs/stable/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow">official documentation</a>
or the <a href="https://huggingface.co/docs/transformers/main/en/perf_infer_gpu_one#pytorch-scaled-dot-product-attention" rel="nofollow">GPU Inference</a>
page for more information.`,mo,ie,wt=`SDPA is used by default for <code>torch&gt;=2.1.1</code> when an implementation is available, but you may also set
<code>attn_implementation=&quot;sdpa&quot;</code> in <code>from_pretrained()</code> to explicitly request SDPA to be used.`,po,le,ho,de,Tt="For the best speedups, we recommend loading the model in half-precision (e.g. <code>torch.float16</code> or <code>torch.bfloat16</code>).",go,ce,xt="On a local benchmark (A100-40GB, PyTorch 2.3.0, OS Ubuntu 22.04) with <code>float32</code> and <code>hustvl/yolos-base</code> model, we saw the following speedups during inference.",fo,me,$t="<thead><tr><th>Batch size</th> <th>Average inference time (ms), eager mode</th> <th>Average inference time (ms), sdpa model</th> <th>Speed up, Sdpa / Eager (x)</th></tr></thead> <tbody><tr><td>1</td> <td>106</td> <td>76</td> <td>1.39</td></tr> <tr><td>2</td> <td>154</td> <td>90</td> <td>1.71</td></tr> <tr><td>4</td> <td>222</td> <td>116</td> <td>1.91</td></tr> <tr><td>8</td> <td>368</td> <td>168</td> <td>2.19</td></tr></tbody>",uo,pe,_o,he,Mt="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with YOLOS.",bo,ge,yo,fe,jt='<li>All example notebooks illustrating inference + fine-tuning <a href="/docs/transformers/pr_28847/en/model_doc/yolos#transformers.YolosForObjectDetection">YolosForObjectDetection</a> on a custom dataset can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/YOLOS" rel="nofollow">here</a>.</li> <li>Scripts for finetuning <a href="/docs/transformers/pr_28847/en/model_doc/yolos#transformers.YolosForObjectDetection">YolosForObjectDetection</a> with <a href="/docs/transformers/pr_28847/en/main_classes/trainer#transformers.Trainer">Trainer</a> or <a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">Accelerate</a> can be found <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/object-detection" rel="nofollow">here</a>.</li> <li>See also: <a href="../tasks/object_detection">Object detection task guide</a></li>',vo,ue,Yt="If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",wo,D,To,_e,xo,Y,be,Do,De,It=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_28847/en/model_doc/yolos#transformers.YolosModel">YolosModel</a>. It is used to instantiate a YOLOS
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the YOLOS
<a href="https://huggingface.co/hustvl/yolos-base" rel="nofollow">hustvl/yolos-base</a> architecture.`,Lo,Le,Ct=`Configuration objects inherit from <a href="/docs/transformers/pr_28847/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_28847/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Wo,L,$o,ye,Mo,$,ve,Ro,We,zt="Constructs a Detr image processor.",Eo,W,we,Zo,Re,Jt="Preprocess an image or a batch of images so that it can be used by the model.",So,R,Te,Go,Ee,Ut=`Pads a batch of images to the bottom and right of the image with zeros to the size of largest height and width
in the batch and optionally returns their corresponding pixel mask.`,Vo,E,xe,Ho,Ze,kt=`Converts the raw output of <a href="/docs/transformers/pr_28847/en/model_doc/yolos#transformers.YolosForObjectDetection">YolosForObjectDetection</a> into final bounding boxes in (top_left_x, top_left_y,
bottom_right_x, bottom_right_y) format. Only supports PyTorch.`,jo,$e,Yo,I,Me,Bo,Z,je,Ao,Se,Pt="Preprocess an image or a batch of images.",Xo,S,Ye,Qo,Ge,Nt=`Pads a batch of images to the bottom and right of the image with zeros to the size of largest height and width
in the batch and optionally returns their corresponding pixel mask.`,Ko,G,Ie,et,Ve,qt=`Converts the raw output of <a href="/docs/transformers/pr_28847/en/model_doc/yolos#transformers.YolosForObjectDetection">YolosForObjectDetection</a> into final bounding boxes in (top_left_x, top_left_y,
bottom_right_x, bottom_right_y) format. Only supports PyTorch.`,Io,Ce,Co,P,ze,ot,He,Ft=`The bare YOLOS Model transformer outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,tt,U,Je,nt,Be,Ot='The <a href="/docs/transformers/pr_28847/en/model_doc/yolos#transformers.YolosModel">YolosModel</a> forward method, overrides the <code>__call__</code> special method.',st,V,at,H,zo,Ue,Jo,C,ke,rt,Ae,Dt="YOLOS Model (consisting of a ViT encoder) with object detection heads on top, for tasks such as COCO detection.",it,Xe,Lt=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,lt,k,Pe,dt,Qe,Wt='The <a href="/docs/transformers/pr_28847/en/model_doc/yolos#transformers.YolosForObjectDetection">YolosForObjectDetection</a> forward method, overrides the <code>__call__</code> special method.',ct,B,mt,A,Uo,Ne,ko,oo,Po;return w=new F({props:{title:"YOLOS",local:"yolos",headingTag:"h1"}}),T=new F({props:{title:"Overview",local:"overview",headingTag:"h2"}}),ae=new F({props:{title:"Using Scaled Dot Product Attention (SDPA)",local:"using-scaled-dot-product-attention-sdpa",headingTag:"h2"}}),le=new Oo({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvck9iamVjdERldGVjdGlvbiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yT2JqZWN0RGV0ZWN0aW9uLmZyb21fcHJldHJhaW5lZCglMjJodXN0dmwlMkZ5b2xvcy1iYXNlJTIyJTJDJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRCUyMnNkcGElMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBLi4u",highlighted:`from transformers import AutoModelForObjectDetection
model = <span class="hljs-module-access"><span class="hljs-module"><span class="hljs-identifier">AutoModelForObjectDetection</span>.</span></span>from<span class="hljs-constructor">_pretrained(<span class="hljs-string">&quot;hustvl/yolos-base&quot;</span>, <span class="hljs-params">attn_implementation</span>=<span class="hljs-string">&quot;sdpa&quot;</span>, <span class="hljs-params">torch_dtype</span>=<span class="hljs-params">torch</span>.<span class="hljs-params">float16</span>)</span>
...`,wrap:!1}}),pe=new F({props:{title:"Resources",local:"resources",headingTag:"h2"}}),ge=new Ht({props:{pipeline:"object-detection"}}),D=new pt({props:{$$slots:{default:[At]},$$scope:{ctx:j}}}),_e=new F({props:{title:"YolosConfig",local:"transformers.YolosConfig",headingTag:"h2"}}),be=new J({props:{name:"class transformers.YolosConfig",anchor:"transformers.YolosConfig",parameters:[{name:"hidden_size",val:" = 768"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"intermediate_size",val:" = 3072"},{name:"hidden_act",val:" = 'gelu'"},{name:"hidden_dropout_prob",val:" = 0.0"},{name:"attention_probs_dropout_prob",val:" = 0.0"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-12"},{name:"image_size",val:" = [512, 864]"},{name:"patch_size",val:" = 16"},{name:"num_channels",val:" = 3"},{name:"qkv_bias",val:" = True"},{name:"num_detection_tokens",val:" = 100"},{name:"use_mid_position_embeddings",val:" = True"},{name:"auxiliary_loss",val:" = False"},{name:"class_cost",val:" = 1"},{name:"bbox_cost",val:" = 5"},{name:"giou_cost",val:" = 2"},{name:"bbox_loss_coefficient",val:" = 5"},{name:"giou_loss_coefficient",val:" = 2"},{name:"eos_coefficient",val:" = 0.1"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.YolosConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.YolosConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.YolosConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.YolosConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.YolosConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.YolosConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.YolosConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.YolosConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.YolosConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.YolosConfig.image_size",description:`<strong>image_size</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[512, 864]</code>) &#x2014;
The size (resolution) of each image.`,name:"image_size"},{anchor:"transformers.YolosConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The size (resolution) of each patch.`,name:"patch_size"},{anchor:"transformers.YolosConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.YolosConfig.qkv_bias",description:`<strong>qkv_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add a bias to the queries, keys and values.`,name:"qkv_bias"},{anchor:"transformers.YolosConfig.num_detection_tokens",description:`<strong>num_detection_tokens</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of detection tokens.`,name:"num_detection_tokens"},{anchor:"transformers.YolosConfig.use_mid_position_embeddings",description:`<strong>use_mid_position_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use the mid-layer position encodings.`,name:"use_mid_position_embeddings"},{anchor:"transformers.YolosConfig.auxiliary_loss",description:`<strong>auxiliary_loss</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether auxiliary decoding losses (loss at each decoder layer) are to be used.`,name:"auxiliary_loss"},{anchor:"transformers.YolosConfig.class_cost",description:`<strong>class_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
Relative weight of the classification error in the Hungarian matching cost.`,name:"class_cost"},{anchor:"transformers.YolosConfig.bbox_cost",description:`<strong>bbox_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 5) &#x2014;
Relative weight of the L1 error of the bounding box coordinates in the Hungarian matching cost.`,name:"bbox_cost"},{anchor:"transformers.YolosConfig.giou_cost",description:`<strong>giou_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 2) &#x2014;
Relative weight of the generalized IoU loss of the bounding box in the Hungarian matching cost.`,name:"giou_cost"},{anchor:"transformers.YolosConfig.bbox_loss_coefficient",description:`<strong>bbox_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 5) &#x2014;
Relative weight of the L1 bounding box loss in the object detection loss.`,name:"bbox_loss_coefficient"},{anchor:"transformers.YolosConfig.giou_loss_coefficient",description:`<strong>giou_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 2) &#x2014;
Relative weight of the generalized IoU loss in the object detection loss.`,name:"giou_loss_coefficient"},{anchor:"transformers.YolosConfig.eos_coefficient",description:`<strong>eos_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Relative classification weight of the &#x2018;no-object&#x2019; class in the object detection loss.`,name:"eos_coefficient"}],source:"https://github.com/huggingface/transformers/blob/vr_28847/src/transformers/models/yolos/configuration_yolos.py#L30"}}),L=new ht({props:{anchor:"transformers.YolosConfig.example",$$slots:{default:[Xt]},$$scope:{ctx:j}}}),ye=new F({props:{title:"YolosImageProcessor",local:"transformers.YolosImageProcessor",headingTag:"h2"}}),ve=new J({props:{name:"class transformers.YolosImageProcessor",anchor:"transformers.YolosImageProcessor",parameters:[{name:"format",val:": Union = <AnnotationFormat.COCO_DETECTION: 'coco_detection'>"},{name:"do_resize",val:": bool = True"},{name:"size",val:": Dict = None"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": Union = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"do_convert_annotations",val:": Optional = None"},{name:"do_pad",val:": bool = True"},{name:"pad_size",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.YolosImageProcessor.format",description:`<strong>format</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;coco_detection&quot;</code>) &#x2014;
Data format of the annotations. One of &#x201C;coco_detection&#x201D; or &#x201C;coco_panoptic&#x201D;.`,name:"format"},{anchor:"transformers.YolosImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be
overridden by the <code>do_resize</code> parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.YolosImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;shortest_edge&quot; -- 800, &quot;longest_edge&quot;: 1333}</code>):
Size of the image&#x2019;s <code>(height, width)</code> dimensions after resizing. Can be overridden by the <code>size</code> parameter
in the <code>preprocess</code> method. Available options are:<ul>
<li><code>{&quot;height&quot;: int, &quot;width&quot;: int}</code>: The image will be resized to the exact size <code>(height, width)</code>.
Do NOT keep the aspect ratio.</li>
<li><code>{&quot;shortest_edge&quot;: int, &quot;longest_edge&quot;: int}</code>: The image will be resized to a maximum size respecting
the aspect ratio and keeping the shortest edge less or equal to <code>shortest_edge</code> and the longest edge
less or equal to <code>longest_edge</code>.</li>
<li><code>{&quot;max_height&quot;: int, &quot;max_width&quot;: int}</code>: The image will be resized to the maximum size respecting the
aspect ratio and keeping the height less or equal to <code>max_height</code> and the width less or equal to
<code>max_width</code>.</li>
</ul>`,name:"size"},{anchor:"transformers.YolosImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>PILImageResampling.BILINEAR</code>) &#x2014;
Resampling filter to use if resizing the image.`,name:"resample"},{anchor:"transformers.YolosImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the
<code>do_rescale</code> parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.YolosImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by the <code>rescale_factor</code> parameter in the
<code>preprocess</code> method.
do_normalize &#x2014;
Controls whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the
<code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.YolosImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_DEFAULT_MEAN</code>) &#x2014;
Mean values to use when normalizing the image. Can be a single value or a list of values, one for each
channel. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.YolosImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_DEFAULT_STD</code>) &#x2014;
Standard deviation values to use when normalizing the image. Can be a single value or a list of values, one
for each channel. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.YolosImageProcessor.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to pad the image. Can be overridden by the <code>do_pad</code> parameter in the <code>preprocess</code>
method. If <code>True</code>, padding will be applied to the bottom and right of the image with zeros.
If <code>pad_size</code> is provided, the image will be padded to the specified dimensions.
Otherwise, the image will be padded to the maximum height and width of the batch.`,name:"do_pad"},{anchor:"transformers.YolosImageProcessor.pad_size",description:`<strong>pad_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>) &#x2014;
The size <code>{&quot;height&quot;: int, &quot;width&quot; int}</code> to pad the images to. Must be larger than any image size
provided for preprocessing. If <code>pad_size</code> is not provided, images will be padded to the largest
height and width in the batch.`,name:"pad_size"}],source:"https://github.com/huggingface/transformers/blob/vr_28847/src/transformers/models/yolos/image_processing_yolos.py#L723"}}),we=new J({props:{name:"preprocess",anchor:"transformers.YolosImageProcessor.preprocess",parameters:[{name:"images",val:": Union"},{name:"annotations",val:": Union = None"},{name:"return_segmentation_masks",val:": bool = None"},{name:"masks_path",val:": Union = None"},{name:"do_resize",val:": Optional = None"},{name:"size",val:": Optional = None"},{name:"resample",val:" = None"},{name:"do_rescale",val:": Optional = None"},{name:"rescale_factor",val:": Union = None"},{name:"do_normalize",val:": Optional = None"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"do_convert_annotations",val:": Optional = None"},{name:"do_pad",val:": Optional = None"},{name:"format",val:": Union = None"},{name:"return_tensors",val:": Union = None"},{name:"data_format",val:": Union = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": Union = None"},{name:"pad_size",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.YolosImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image or batch of images to preprocess. Expects a single or batch of images with pixel values ranging
from 0 to 255. If passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.YolosImageProcessor.preprocess.annotations",description:`<strong>annotations</strong> (<code>AnnotationType</code> or <code>List[AnnotationType]</code>, <em>optional</em>) &#x2014;
List of annotations associated with the image or batch of images. If annotation is for object
detection, the annotations should be a dictionary with the following keys:<ul>
<li>&#x201C;image_id&#x201D; (<code>int</code>): The image id.</li>
<li>&#x201C;annotations&#x201D; (<code>List[Dict]</code>): List of annotations for an image. Each annotation should be a
dictionary. An image can have no annotations, in which case the list should be empty.
If annotation is for segmentation, the annotations should be a dictionary with the following keys:</li>
<li>&#x201C;image_id&#x201D; (<code>int</code>): The image id.</li>
<li>&#x201C;segments_info&#x201D; (<code>List[Dict]</code>): List of segments for an image. Each segment should be a dictionary.
An image can have no segments, in which case the list should be empty.</li>
<li>&#x201C;file_name&#x201D; (<code>str</code>): The file name of the image.</li>
</ul>`,name:"annotations"},{anchor:"transformers.YolosImageProcessor.preprocess.return_segmentation_masks",description:`<strong>return_segmentation_masks</strong> (<code>bool</code>, <em>optional</em>, defaults to self.return_segmentation_masks) &#x2014;
Whether to return segmentation masks.`,name:"return_segmentation_masks"},{anchor:"transformers.YolosImageProcessor.preprocess.masks_path",description:`<strong>masks_path</strong> (<code>str</code> or <code>pathlib.Path</code>, <em>optional</em>) &#x2014;
Path to the directory containing the segmentation masks.`,name:"masks_path"},{anchor:"transformers.YolosImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_resize) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.YolosImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to self.size) &#x2014;
Size of the image&#x2019;s <code>(height, width)</code> dimensions after resizing. Available options are:<ul>
<li><code>{&quot;height&quot;: int, &quot;width&quot;: int}</code>: The image will be resized to the exact size <code>(height, width)</code>.
Do NOT keep the aspect ratio.</li>
<li><code>{&quot;shortest_edge&quot;: int, &quot;longest_edge&quot;: int}</code>: The image will be resized to a maximum size respecting
the aspect ratio and keeping the shortest edge less or equal to <code>shortest_edge</code> and the longest edge
less or equal to <code>longest_edge</code>.</li>
<li><code>{&quot;max_height&quot;: int, &quot;max_width&quot;: int}</code>: The image will be resized to the maximum size respecting the
aspect ratio and keeping the height less or equal to <code>max_height</code> and the width less or equal to
<code>max_width</code>.</li>
</ul>`,name:"size"},{anchor:"transformers.YolosImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to self.resample) &#x2014;
Resampling filter to use when resizing the image.`,name:"resample"},{anchor:"transformers.YolosImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_rescale) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.YolosImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to self.rescale_factor) &#x2014;
Rescale factor to use when rescaling the image.`,name:"rescale_factor"},{anchor:"transformers.YolosImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_normalize) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.YolosImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to self.image_mean) &#x2014;
Mean to use when normalizing the image.`,name:"image_mean"},{anchor:"transformers.YolosImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to self.image_std) &#x2014;
Standard deviation to use when normalizing the image.`,name:"image_std"},{anchor:"transformers.YolosImageProcessor.preprocess.do_convert_annotations",description:`<strong>do_convert_annotations</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_convert_annotations) &#x2014;
Whether to convert the annotations to the format expected by the model. Converts the bounding
boxes from the format <code>(top_left_x, top_left_y, width, height)</code> to <code>(center_x, center_y, width, height)</code>
and in relative coordinates.`,name:"do_convert_annotations"},{anchor:"transformers.YolosImageProcessor.preprocess.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_pad) &#x2014;
Whether to pad the image. If <code>True</code>, padding will be applied to the bottom and right of
the image with zeros. If <code>pad_size</code> is provided, the image will be padded to the specified
dimensions. Otherwise, the image will be padded to the maximum height and width of the batch.`,name:"do_pad"},{anchor:"transformers.YolosImageProcessor.preprocess.format",description:`<strong>format</strong> (<code>str</code> or <code>AnnotationFormat</code>, <em>optional</em>, defaults to self.format) &#x2014;
Format of the annotations.`,name:"format"},{anchor:"transformers.YolosImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>, defaults to self.return_tensors) &#x2014;
Type of tensors to return. If <code>None</code>, will return the list of images.`,name:"return_tensors"},{anchor:"transformers.YolosImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>str</code> or <code>ChannelDimension</code>, <em>optional</em>, defaults to self.data_format) &#x2014;
The channel dimension format of the image. If not provided, it will be the same as the input image.`,name:"data_format"},{anchor:"transformers.YolosImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"},{anchor:"transformers.YolosImageProcessor.preprocess.pad_size",description:`<strong>pad_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>) &#x2014;
The size <code>{&quot;height&quot;: int, &quot;width&quot; int}</code> to pad the images to. Must be larger than any image size
provided for preprocessing. If <code>pad_size</code> is not provided, images will be padded to the largest
height and width in the batch.`,name:"pad_size"}],source:"https://github.com/huggingface/transformers/blob/vr_28847/src/transformers/models/yolos/image_processing_yolos.py#L1176"}}),Te=new J({props:{name:"pad",anchor:"transformers.YolosImageProcessor.pad",parameters:[{name:"images",val:": List"},{name:"annotations",val:": Optional = None"},{name:"constant_values",val:": Union = 0"},{name:"return_pixel_mask",val:": bool = False"},{name:"return_tensors",val:": Union = None"},{name:"data_format",val:": Optional = None"},{name:"input_data_format",val:": Union = None"},{name:"update_bboxes",val:": bool = True"},{name:"pad_size",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.YolosImageProcessor.pad.image",description:`<strong>image</strong> (<code>np.ndarray</code>) &#x2014;
Image to pad.`,name:"image"},{anchor:"transformers.YolosImageProcessor.pad.annotations",description:`<strong>annotations</strong> (<code>List[Dict[str, any]]</code>, <em>optional</em>) &#x2014;
Annotations to pad along with the images. If provided, the bounding boxes will be updated to match the
padded images.`,name:"annotations"},{anchor:"transformers.YolosImageProcessor.pad.constant_values",description:`<strong>constant_values</strong> (<code>float</code> or <code>Iterable[float]</code>, <em>optional</em>) &#x2014;
The value to use for the padding if <code>mode</code> is <code>&quot;constant&quot;</code>.`,name:"constant_values"},{anchor:"transformers.YolosImageProcessor.pad.return_pixel_mask",description:`<strong>return_pixel_mask</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to return a pixel mask.`,name:"return_pixel_mask"},{anchor:"transformers.YolosImageProcessor.pad.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.YolosImageProcessor.pad.data_format",description:`<strong>data_format</strong> (<code>str</code> or <code>ChannelDimension</code>, <em>optional</em>) &#x2014;
The channel dimension format of the image. If not provided, it will be the same as the input image.`,name:"data_format"},{anchor:"transformers.YolosImageProcessor.pad.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format of the input image. If not provided, it will be inferred.`,name:"input_data_format"},{anchor:"transformers.YolosImageProcessor.pad.update_bboxes",description:`<strong>update_bboxes</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to update the bounding boxes in the annotations to match the padded images. If the
bounding boxes have not been converted to relative coordinates and <code>(centre_x, centre_y, width, height)</code>
format, the bounding boxes will not be updated.`,name:"update_bboxes"},{anchor:"transformers.YolosImageProcessor.pad.pad_size",description:`<strong>pad_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>) &#x2014;
The size <code>{&quot;height&quot;: int, &quot;width&quot; int}</code> to pad the images to. Must be larger than any image size
provided for preprocessing. If <code>pad_size</code> is not provided, images will be padded to the largest
height and width in the batch.`,name:"pad_size"}],source:"https://github.com/huggingface/transformers/blob/vr_28847/src/transformers/models/yolos/image_processing_yolos.py#L1090"}}),xe=new J({props:{name:"post_process_object_detection",anchor:"transformers.YolosImageProcessor.post_process_object_detection",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"target_sizes",val:": Union = None"}],parametersDescription:[{anchor:"transformers.YolosImageProcessor.post_process_object_detection.outputs",description:`<strong>outputs</strong> (<code>YolosObjectDetectionOutput</code>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.YolosImageProcessor.post_process_object_detection.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Score threshold to keep object detection predictions.`,name:"threshold"},{anchor:"transformers.YolosImageProcessor.post_process_object_detection.target_sizes",description:`<strong>target_sizes</strong> (<code>torch.Tensor</code> or <code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
Tensor of shape <code>(batch_size, 2)</code> or list of tuples (<code>Tuple[int, int]</code>) containing the target size
<code>(height, width)</code> of each image in the batch. If unset, predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/vr_28847/src/transformers/models/yolos/image_processing_yolos.py#L1481",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, each dictionary containing the scores, labels and boxes for an image
in the batch as predicted by the model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),$e=new F({props:{title:"YolosFeatureExtractor",local:"transformers.YolosFeatureExtractor",headingTag:"h2"}}),Me=new J({props:{name:"class transformers.YolosFeatureExtractor",anchor:"transformers.YolosFeatureExtractor",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_28847/src/transformers/models/yolos/feature_extraction_yolos.py#L36"}}),je=new J({props:{name:"__call__",anchor:"transformers.YolosFeatureExtractor.__call__",parameters:[{name:"images",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_28847/src/transformers/image_processing_utils.py#L39"}}),Ye=new J({props:{name:"pad",anchor:"transformers.YolosFeatureExtractor.pad",parameters:[{name:"images",val:": List"},{name:"annotations",val:": Optional = None"},{name:"constant_values",val:": Union = 0"},{name:"return_pixel_mask",val:": bool = False"},{name:"return_tensors",val:": Union = None"},{name:"data_format",val:": Optional = None"},{name:"input_data_format",val:": Union = None"},{name:"update_bboxes",val:": bool = True"},{name:"pad_size",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.YolosFeatureExtractor.pad.image",description:`<strong>image</strong> (<code>np.ndarray</code>) &#x2014;
Image to pad.`,name:"image"},{anchor:"transformers.YolosFeatureExtractor.pad.annotations",description:`<strong>annotations</strong> (<code>List[Dict[str, any]]</code>, <em>optional</em>) &#x2014;
Annotations to pad along with the images. If provided, the bounding boxes will be updated to match the
padded images.`,name:"annotations"},{anchor:"transformers.YolosFeatureExtractor.pad.constant_values",description:`<strong>constant_values</strong> (<code>float</code> or <code>Iterable[float]</code>, <em>optional</em>) &#x2014;
The value to use for the padding if <code>mode</code> is <code>&quot;constant&quot;</code>.`,name:"constant_values"},{anchor:"transformers.YolosFeatureExtractor.pad.return_pixel_mask",description:`<strong>return_pixel_mask</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to return a pixel mask.`,name:"return_pixel_mask"},{anchor:"transformers.YolosFeatureExtractor.pad.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.YolosFeatureExtractor.pad.data_format",description:`<strong>data_format</strong> (<code>str</code> or <code>ChannelDimension</code>, <em>optional</em>) &#x2014;
The channel dimension format of the image. If not provided, it will be the same as the input image.`,name:"data_format"},{anchor:"transformers.YolosFeatureExtractor.pad.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format of the input image. If not provided, it will be inferred.`,name:"input_data_format"},{anchor:"transformers.YolosFeatureExtractor.pad.update_bboxes",description:`<strong>update_bboxes</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to update the bounding boxes in the annotations to match the padded images. If the
bounding boxes have not been converted to relative coordinates and <code>(centre_x, centre_y, width, height)</code>
format, the bounding boxes will not be updated.`,name:"update_bboxes"},{anchor:"transformers.YolosFeatureExtractor.pad.pad_size",description:`<strong>pad_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>) &#x2014;
The size <code>{&quot;height&quot;: int, &quot;width&quot; int}</code> to pad the images to. Must be larger than any image size
provided for preprocessing. If <code>pad_size</code> is not provided, images will be padded to the largest
height and width in the batch.`,name:"pad_size"}],source:"https://github.com/huggingface/transformers/blob/vr_28847/src/transformers/models/yolos/image_processing_yolos.py#L1090"}}),Ie=new J({props:{name:"post_process_object_detection",anchor:"transformers.YolosFeatureExtractor.post_process_object_detection",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"target_sizes",val:": Union = None"}],parametersDescription:[{anchor:"transformers.YolosFeatureExtractor.post_process_object_detection.outputs",description:`<strong>outputs</strong> (<code>YolosObjectDetectionOutput</code>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.YolosFeatureExtractor.post_process_object_detection.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Score threshold to keep object detection predictions.`,name:"threshold"},{anchor:"transformers.YolosFeatureExtractor.post_process_object_detection.target_sizes",description:`<strong>target_sizes</strong> (<code>torch.Tensor</code> or <code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
Tensor of shape <code>(batch_size, 2)</code> or list of tuples (<code>Tuple[int, int]</code>) containing the target size
<code>(height, width)</code> of each image in the batch. If unset, predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/vr_28847/src/transformers/models/yolos/image_processing_yolos.py#L1481",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, each dictionary containing the scores, labels and boxes for an image
in the batch as predicted by the model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),Ce=new F({props:{title:"YolosModel",local:"transformers.YolosModel",headingTag:"h2"}}),ze=new J({props:{name:"class transformers.YolosModel",anchor:"transformers.YolosModel",parameters:[{name:"config",val:": YolosConfig"},{name:"add_pooling_layer",val:": bool = True"}],parametersDescription:[{anchor:"transformers.YolosModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_28847/en/model_doc/yolos#transformers.YolosConfig">YolosConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_28847/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_28847/src/transformers/models/yolos/modeling_yolos.py#L624"}}),Je=new J({props:{name:"forward",anchor:"transformers.YolosModel.forward",parameters:[{name:"pixel_values",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.YolosModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/pr_28847/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/pr_28847/en/model_doc/imagegpt#transformers.ImageGPTFeatureExtractor.__call__">YolosImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.YolosModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.YolosModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.YolosModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.YolosModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_28847/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_28847/src/transformers/models/yolos/modeling_yolos.py#L656",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_28847/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_28847/en/model_doc/yolos#transformers.YolosConfig"
>YolosConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_28847/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),V=new pt({props:{$$slots:{default:[Qt]},$$scope:{ctx:j}}}),H=new ht({props:{anchor:"transformers.YolosModel.forward.example",$$slots:{default:[Kt]},$$scope:{ctx:j}}}),Ue=new F({props:{title:"YolosForObjectDetection",local:"transformers.YolosForObjectDetection",headingTag:"h2"}}),ke=new J({props:{name:"class transformers.YolosForObjectDetection",anchor:"transformers.YolosForObjectDetection",parameters:[{name:"config",val:": YolosConfig"}],parametersDescription:[{anchor:"transformers.YolosForObjectDetection.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_28847/en/model_doc/yolos#transformers.YolosConfig">YolosConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_28847/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_28847/src/transformers/models/yolos/modeling_yolos.py#L730"}}),Pe=new J({props:{name:"forward",anchor:"transformers.YolosForObjectDetection.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"labels",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.YolosForObjectDetection.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/pr_28847/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/pr_28847/en/model_doc/imagegpt#transformers.ImageGPTFeatureExtractor.__call__">YolosImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.YolosForObjectDetection.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.YolosForObjectDetection.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.YolosForObjectDetection.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.YolosForObjectDetection.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_28847/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.YolosForObjectDetection.forward.labels",description:`<strong>labels</strong> (<code>List[Dict]</code> of len <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the bipartite matching loss. List of dicts, each dictionary containing at least the
following 2 keys: <code>&apos;class_labels&apos;</code> and <code>&apos;boxes&apos;</code> (the class labels and bounding boxes of an image in the
batch respectively). The class labels themselves should be a <code>torch.LongTensor</code> of len <code>(number of bounding boxes in the image,)</code> and the boxes a <code>torch.FloatTensor</code> of shape <code>(number of bounding boxes in the image, 4)</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/vr_28847/src/transformers/models/yolos/modeling_yolos.py#L763",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.yolos.modeling_yolos.YolosObjectDetectionOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_28847/en/model_doc/yolos#transformers.YolosConfig"
>YolosConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> are provided)) — Total loss as a linear combination of a negative log-likehood (cross-entropy) for class prediction and a
bounding box loss. The latter is defined as a linear combination of the L1 loss and the generalized
scale-invariant IoU loss.</li>
<li><strong>loss_dict</strong> (<code>Dict</code>, <em>optional</em>) — A dictionary containing the individual losses. Useful for logging.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, num_classes + 1)</code>) — Classification logits (including no-object) for all queries.</li>
<li><strong>pred_boxes</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, 4)</code>) — Normalized boxes coordinates for all queries, represented as (center_x, center_y, width, height). These
values are normalized in [0, 1], relative to the size of each individual image in the batch (disregarding
possible padding). You can use <code>post_process()</code> to retrieve the unnormalized bounding
boxes.</li>
<li><strong>auxiliary_outputs</strong> (<code>list[Dict]</code>, <em>optional</em>) — Optional, only returned when auxilary losses are activated (i.e. <code>config.auxiliary_loss</code> is set to <code>True</code>)
and labels are provided. It is a list of dictionaries containing the two above keys (<code>logits</code> and
<code>pred_boxes</code>) for each decoder layer.</li>
<li><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the decoder of the model.</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of
the model at the output of each layer plus the optional initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.yolos.modeling_yolos.YolosObjectDetectionOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),B=new pt({props:{$$slots:{default:[en]},$$scope:{ctx:j}}}),A=new ht({props:{anchor:"transformers.YolosForObjectDetection.forward.example",$$slots:{default:[on]},$$scope:{ctx:j}}}),Ne=new Bt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/yolos.md"}}),{c(){r=l("meta"),v=n(),m=l("p"),p=n(),h(w.$$.fragment),c=n(),h(T.$$.fragment),to=n(),ee=l("p"),ee.innerHTML=gt,no=n(),oe=l("p"),oe.textContent=ft,so=n(),te=l("p"),te.innerHTML=ut,ao=n(),O=l("img"),ro=n(),ne=l("small"),ne.innerHTML=bt,io=n(),se=l("p"),se.innerHTML=yt,lo=n(),h(ae.$$.fragment),co=n(),re=l("p"),re.innerHTML=vt,mo=n(),ie=l("p"),ie.innerHTML=wt,po=n(),h(le.$$.fragment),ho=n(),de=l("p"),de.innerHTML=Tt,go=n(),ce=l("p"),ce.innerHTML=xt,fo=n(),me=l("table"),me.innerHTML=$t,uo=n(),h(pe.$$.fragment),_o=n(),he=l("p"),he.textContent=Mt,bo=n(),h(ge.$$.fragment),yo=n(),fe=l("ul"),fe.innerHTML=jt,vo=n(),ue=l("p"),ue.textContent=Yt,wo=n(),h(D.$$.fragment),To=n(),h(_e.$$.fragment),xo=n(),Y=l("div"),h(be.$$.fragment),Do=n(),De=l("p"),De.innerHTML=It,Lo=n(),Le=l("p"),Le.innerHTML=Ct,Wo=n(),h(L.$$.fragment),$o=n(),h(ye.$$.fragment),Mo=n(),$=l("div"),h(ve.$$.fragment),Ro=n(),We=l("p"),We.textContent=zt,Eo=n(),W=l("div"),h(we.$$.fragment),Zo=n(),Re=l("p"),Re.textContent=Jt,So=n(),R=l("div"),h(Te.$$.fragment),Go=n(),Ee=l("p"),Ee.textContent=Ut,Vo=n(),E=l("div"),h(xe.$$.fragment),Ho=n(),Ze=l("p"),Ze.innerHTML=kt,jo=n(),h($e.$$.fragment),Yo=n(),I=l("div"),h(Me.$$.fragment),Bo=n(),Z=l("div"),h(je.$$.fragment),Ao=n(),Se=l("p"),Se.textContent=Pt,Xo=n(),S=l("div"),h(Ye.$$.fragment),Qo=n(),Ge=l("p"),Ge.textContent=Nt,Ko=n(),G=l("div"),h(Ie.$$.fragment),et=n(),Ve=l("p"),Ve.innerHTML=qt,Io=n(),h(Ce.$$.fragment),Co=n(),P=l("div"),h(ze.$$.fragment),ot=n(),He=l("p"),He.innerHTML=Ft,tt=n(),U=l("div"),h(Je.$$.fragment),nt=n(),Be=l("p"),Be.innerHTML=Ot,st=n(),h(V.$$.fragment),at=n(),h(H.$$.fragment),zo=n(),h(Ue.$$.fragment),Jo=n(),C=l("div"),h(ke.$$.fragment),rt=n(),Ae=l("p"),Ae.textContent=Dt,it=n(),Xe=l("p"),Xe.innerHTML=Lt,lt=n(),k=l("div"),h(Pe.$$.fragment),dt=n(),Qe=l("p"),Qe.innerHTML=Wt,ct=n(),h(B.$$.fragment),mt=n(),h(A.$$.fragment),Uo=n(),h(Ne.$$.fragment),ko=n(),oo=l("p"),this.h()},l(e){const o=Vt("svelte-u9bgzb",document.head);r=d(o,"META",{name:!0,content:!0}),o.forEach(t),v=s(e),m=d(e,"P",{}),M(m).forEach(t),p=s(e),g(w.$$.fragment,e),c=s(e),g(T.$$.fragment,e),to=s(e),ee=d(e,"P",{"data-svelte-h":!0}),y(ee)!=="svelte-98a8ak"&&(ee.innerHTML=gt),no=s(e),oe=d(e,"P",{"data-svelte-h":!0}),y(oe)!=="svelte-vfdo9a"&&(oe.textContent=ft),so=s(e),te=d(e,"P",{"data-svelte-h":!0}),y(te)!=="svelte-ng2z0l"&&(te.innerHTML=ut),ao=s(e),O=d(e,"IMG",{src:!0,alt:!0,width:!0}),ro=s(e),ne=d(e,"SMALL",{"data-svelte-h":!0}),y(ne)!=="svelte-vits75"&&(ne.innerHTML=bt),io=s(e),se=d(e,"P",{"data-svelte-h":!0}),y(se)!=="svelte-zgo631"&&(se.innerHTML=yt),lo=s(e),g(ae.$$.fragment,e),co=s(e),re=d(e,"P",{"data-svelte-h":!0}),y(re)!=="svelte-1cid2pe"&&(re.innerHTML=vt),mo=s(e),ie=d(e,"P",{"data-svelte-h":!0}),y(ie)!=="svelte-1x11lxg"&&(ie.innerHTML=wt),po=s(e),g(le.$$.fragment,e),ho=s(e),de=d(e,"P",{"data-svelte-h":!0}),y(de)!=="svelte-djb2w0"&&(de.innerHTML=Tt),go=s(e),ce=d(e,"P",{"data-svelte-h":!0}),y(ce)!=="svelte-1h02v1a"&&(ce.innerHTML=xt),fo=s(e),me=d(e,"TABLE",{"data-svelte-h":!0}),y(me)!=="svelte-1dnq5yr"&&(me.innerHTML=$t),uo=s(e),g(pe.$$.fragment,e),_o=s(e),he=d(e,"P",{"data-svelte-h":!0}),y(he)!=="svelte-93t6s9"&&(he.textContent=Mt),bo=s(e),g(ge.$$.fragment,e),yo=s(e),fe=d(e,"UL",{"data-svelte-h":!0}),y(fe)!=="svelte-1yq6k3"&&(fe.innerHTML=jt),vo=s(e),ue=d(e,"P",{"data-svelte-h":!0}),y(ue)!=="svelte-1xesile"&&(ue.textContent=Yt),wo=s(e),g(D.$$.fragment,e),To=s(e),g(_e.$$.fragment,e),xo=s(e),Y=d(e,"DIV",{class:!0});var N=M(Y);g(be.$$.fragment,N),Do=s(N),De=d(N,"P",{"data-svelte-h":!0}),y(De)!=="svelte-crahg"&&(De.innerHTML=It),Lo=s(N),Le=d(N,"P",{"data-svelte-h":!0}),y(Le)!=="svelte-1g3rejj"&&(Le.innerHTML=Ct),Wo=s(N),g(L.$$.fragment,N),N.forEach(t),$o=s(e),g(ye.$$.fragment,e),Mo=s(e),$=d(e,"DIV",{class:!0});var z=M($);g(ve.$$.fragment,z),Ro=s(z),We=d(z,"P",{"data-svelte-h":!0}),y(We)!=="svelte-19j0nu1"&&(We.textContent=zt),Eo=s(z),W=d(z,"DIV",{class:!0});var qe=M(W);g(we.$$.fragment,qe),Zo=s(qe),Re=d(qe,"P",{"data-svelte-h":!0}),y(Re)!=="svelte-jgz2ra"&&(Re.textContent=Jt),qe.forEach(t),So=s(z),R=d(z,"DIV",{class:!0});var Fe=M(R);g(Te.$$.fragment,Fe),Go=s(Fe),Ee=d(Fe,"P",{"data-svelte-h":!0}),y(Ee)!=="svelte-1f2f3d6"&&(Ee.textContent=Ut),Fe.forEach(t),Vo=s(z),E=d(z,"DIV",{class:!0});var Oe=M(E);g(xe.$$.fragment,Oe),Ho=s(Oe),Ze=d(Oe,"P",{"data-svelte-h":!0}),y(Ze)!=="svelte-930yy8"&&(Ze.innerHTML=kt),Oe.forEach(t),z.forEach(t),jo=s(e),g($e.$$.fragment,e),Yo=s(e),I=d(e,"DIV",{class:!0});var q=M(I);g(Me.$$.fragment,q),Bo=s(q),Z=d(q,"DIV",{class:!0});var No=M(Z);g(je.$$.fragment,No),Ao=s(No),Se=d(No,"P",{"data-svelte-h":!0}),y(Se)!=="svelte-khengj"&&(Se.textContent=Pt),No.forEach(t),Xo=s(q),S=d(q,"DIV",{class:!0});var qo=M(S);g(Ye.$$.fragment,qo),Qo=s(qo),Ge=d(qo,"P",{"data-svelte-h":!0}),y(Ge)!=="svelte-1f2f3d6"&&(Ge.textContent=Nt),qo.forEach(t),Ko=s(q),G=d(q,"DIV",{class:!0});var Fo=M(G);g(Ie.$$.fragment,Fo),et=s(Fo),Ve=d(Fo,"P",{"data-svelte-h":!0}),y(Ve)!=="svelte-930yy8"&&(Ve.innerHTML=qt),Fo.forEach(t),q.forEach(t),Io=s(e),g(Ce.$$.fragment,e),Co=s(e),P=d(e,"DIV",{class:!0});var Ke=M(P);g(ze.$$.fragment,Ke),ot=s(Ke),He=d(Ke,"P",{"data-svelte-h":!0}),y(He)!=="svelte-19k5mgv"&&(He.innerHTML=Ft),tt=s(Ke),U=d(Ke,"DIV",{class:!0});var X=M(U);g(Je.$$.fragment,X),nt=s(X),Be=d(X,"P",{"data-svelte-h":!0}),y(Be)!=="svelte-hb6p86"&&(Be.innerHTML=Ot),st=s(X),g(V.$$.fragment,X),at=s(X),g(H.$$.fragment,X),X.forEach(t),Ke.forEach(t),zo=s(e),g(Ue.$$.fragment,e),Jo=s(e),C=d(e,"DIV",{class:!0});var Q=M(C);g(ke.$$.fragment,Q),rt=s(Q),Ae=d(Q,"P",{"data-svelte-h":!0}),y(Ae)!=="svelte-1yg9bo0"&&(Ae.textContent=Dt),it=s(Q),Xe=d(Q,"P",{"data-svelte-h":!0}),y(Xe)!=="svelte-1gjh92c"&&(Xe.innerHTML=Lt),lt=s(Q),k=d(Q,"DIV",{class:!0});var K=M(k);g(Pe.$$.fragment,K),dt=s(K),Qe=d(K,"P",{"data-svelte-h":!0}),y(Qe)!=="svelte-idi0yk"&&(Qe.innerHTML=Wt),ct=s(K),g(B.$$.fragment,K),mt=s(K),g(A.$$.fragment,K),K.forEach(t),Q.forEach(t),Uo=s(e),g(Ne.$$.fragment,e),ko=s(e),oo=d(e,"P",{}),M(oo).forEach(t),this.h()},h(){x(r,"name","hf:doc:metadata"),x(r,"content",nn),Et(O.src,_t="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/yolos_architecture.png")||x(O,"src",_t),x(O,"alt","drawing"),x(O,"width","600"),x(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){i(document.head,r),a(e,v,o),a(e,m,o),a(e,p,o),f(w,e,o),a(e,c,o),f(T,e,o),a(e,to,o),a(e,ee,o),a(e,no,o),a(e,oe,o),a(e,so,o),a(e,te,o),a(e,ao,o),a(e,O,o),a(e,ro,o),a(e,ne,o),a(e,io,o),a(e,se,o),a(e,lo,o),f(ae,e,o),a(e,co,o),a(e,re,o),a(e,mo,o),a(e,ie,o),a(e,po,o),f(le,e,o),a(e,ho,o),a(e,de,o),a(e,go,o),a(e,ce,o),a(e,fo,o),a(e,me,o),a(e,uo,o),f(pe,e,o),a(e,_o,o),a(e,he,o),a(e,bo,o),f(ge,e,o),a(e,yo,o),a(e,fe,o),a(e,vo,o),a(e,ue,o),a(e,wo,o),f(D,e,o),a(e,To,o),f(_e,e,o),a(e,xo,o),a(e,Y,o),f(be,Y,null),i(Y,Do),i(Y,De),i(Y,Lo),i(Y,Le),i(Y,Wo),f(L,Y,null),a(e,$o,o),f(ye,e,o),a(e,Mo,o),a(e,$,o),f(ve,$,null),i($,Ro),i($,We),i($,Eo),i($,W),f(we,W,null),i(W,Zo),i(W,Re),i($,So),i($,R),f(Te,R,null),i(R,Go),i(R,Ee),i($,Vo),i($,E),f(xe,E,null),i(E,Ho),i(E,Ze),a(e,jo,o),f($e,e,o),a(e,Yo,o),a(e,I,o),f(Me,I,null),i(I,Bo),i(I,Z),f(je,Z,null),i(Z,Ao),i(Z,Se),i(I,Xo),i(I,S),f(Ye,S,null),i(S,Qo),i(S,Ge),i(I,Ko),i(I,G),f(Ie,G,null),i(G,et),i(G,Ve),a(e,Io,o),f(Ce,e,o),a(e,Co,o),a(e,P,o),f(ze,P,null),i(P,ot),i(P,He),i(P,tt),i(P,U),f(Je,U,null),i(U,nt),i(U,Be),i(U,st),f(V,U,null),i(U,at),f(H,U,null),a(e,zo,o),f(Ue,e,o),a(e,Jo,o),a(e,C,o),f(ke,C,null),i(C,rt),i(C,Ae),i(C,it),i(C,Xe),i(C,lt),i(C,k),f(Pe,k,null),i(k,dt),i(k,Qe),i(k,ct),f(B,k,null),i(k,mt),f(A,k,null),a(e,Uo,o),f(Ne,e,o),a(e,ko,o),a(e,oo,o),Po=!0},p(e,[o]){const N={};o&2&&(N.$$scope={dirty:o,ctx:e}),D.$set(N);const z={};o&2&&(z.$$scope={dirty:o,ctx:e}),L.$set(z);const qe={};o&2&&(qe.$$scope={dirty:o,ctx:e}),V.$set(qe);const Fe={};o&2&&(Fe.$$scope={dirty:o,ctx:e}),H.$set(Fe);const Oe={};o&2&&(Oe.$$scope={dirty:o,ctx:e}),B.$set(Oe);const q={};o&2&&(q.$$scope={dirty:o,ctx:e}),A.$set(q)},i(e){Po||(u(w.$$.fragment,e),u(T.$$.fragment,e),u(ae.$$.fragment,e),u(le.$$.fragment,e),u(pe.$$.fragment,e),u(ge.$$.fragment,e),u(D.$$.fragment,e),u(_e.$$.fragment,e),u(be.$$.fragment,e),u(L.$$.fragment,e),u(ye.$$.fragment,e),u(ve.$$.fragment,e),u(we.$$.fragment,e),u(Te.$$.fragment,e),u(xe.$$.fragment,e),u($e.$$.fragment,e),u(Me.$$.fragment,e),u(je.$$.fragment,e),u(Ye.$$.fragment,e),u(Ie.$$.fragment,e),u(Ce.$$.fragment,e),u(ze.$$.fragment,e),u(Je.$$.fragment,e),u(V.$$.fragment,e),u(H.$$.fragment,e),u(Ue.$$.fragment,e),u(ke.$$.fragment,e),u(Pe.$$.fragment,e),u(B.$$.fragment,e),u(A.$$.fragment,e),u(Ne.$$.fragment,e),Po=!0)},o(e){_(w.$$.fragment,e),_(T.$$.fragment,e),_(ae.$$.fragment,e),_(le.$$.fragment,e),_(pe.$$.fragment,e),_(ge.$$.fragment,e),_(D.$$.fragment,e),_(_e.$$.fragment,e),_(be.$$.fragment,e),_(L.$$.fragment,e),_(ye.$$.fragment,e),_(ve.$$.fragment,e),_(we.$$.fragment,e),_(Te.$$.fragment,e),_(xe.$$.fragment,e),_($e.$$.fragment,e),_(Me.$$.fragment,e),_(je.$$.fragment,e),_(Ye.$$.fragment,e),_(Ie.$$.fragment,e),_(Ce.$$.fragment,e),_(ze.$$.fragment,e),_(Je.$$.fragment,e),_(V.$$.fragment,e),_(H.$$.fragment,e),_(Ue.$$.fragment,e),_(ke.$$.fragment,e),_(Pe.$$.fragment,e),_(B.$$.fragment,e),_(A.$$.fragment,e),_(Ne.$$.fragment,e),Po=!1},d(e){e&&(t(v),t(m),t(p),t(c),t(to),t(ee),t(no),t(oe),t(so),t(te),t(ao),t(O),t(ro),t(ne),t(io),t(se),t(lo),t(co),t(re),t(mo),t(ie),t(po),t(ho),t(de),t(go),t(ce),t(fo),t(me),t(uo),t(_o),t(he),t(bo),t(yo),t(fe),t(vo),t(ue),t(wo),t(To),t(xo),t(Y),t($o),t(Mo),t($),t(jo),t(Yo),t(I),t(Io),t(Co),t(P),t(zo),t(Jo),t(C),t(Uo),t(ko),t(oo)),t(r),b(w,e),b(T,e),b(ae,e),b(le,e),b(pe,e),b(ge,e),b(D,e),b(_e,e),b(be),b(L),b(ye,e),b(ve),b(we),b(Te),b(xe),b($e,e),b(Me),b(je),b(Ye),b(Ie),b(Ce,e),b(ze),b(Je),b(V),b(H),b(Ue,e),b(ke),b(Pe),b(B),b(A),b(Ne,e)}}}const nn='{"title":"YOLOS","local":"yolos","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Using Scaled Dot Product Attention (SDPA)","local":"using-scaled-dot-product-attention-sdpa","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"YolosConfig","local":"transformers.YolosConfig","sections":[],"depth":2},{"title":"YolosImageProcessor","local":"transformers.YolosImageProcessor","sections":[],"depth":2},{"title":"YolosFeatureExtractor","local":"transformers.YolosFeatureExtractor","sections":[],"depth":2},{"title":"YolosModel","local":"transformers.YolosModel","sections":[],"depth":2},{"title":"YolosForObjectDetection","local":"transformers.YolosForObjectDetection","sections":[],"depth":2}],"depth":1}';function sn(j){return Zt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class gn extends St{constructor(r){super(),Gt(this,r,sn,tn,Rt,{})}}export{gn as component};
