import{s as at,n as rt,o as ot}from"../chunks/scheduler.7da89386.js";import{S as yt,i as Tt,g as M,s as i,r as o,A as pt,h as a,f as t,c as n,j as nt,u as y,x as r,k as Mt,y as Ut,a as s,v as T,d as p,t as U,w as J}from"../chunks/index.0b7befd3.js";import{C as w}from"../chunks/CodeBlock.c5b6371f.js";import{H as c,E as Jt}from"../chunks/getInferenceSnippets.6ead4bda.js";function wt($l){let d,he,ue,je,m,be,C,El=`A kernel can provide layers in addition to kernel functions. A layer from
the Hub can replace the <code>forward</code> method of an existing layer for a certain
device type. This makes it possible to provide more performant kernels for
existing layers.`,ke,I,Rl=`See <a href="kernel-requirements.md">Kernel requirements</a> for more information the
requirements of Hub layers.`,Ae,u,ge,f,$e,h,vl=`A layer can be made extensible with the <code>use_kernel_forward_from_hub</code>
decorator. For example:`,Ee,j,Re,b,Nl=`The decorator does not change the behavior of the class — it annotates
the class with the given name (here <code>SiluAndMul</code>). The <code>kernelize</code> function
described below uses this name to look up kernels for the layer.`,ve,k,Ne,A,_l=`An existing layer that does not (yet) have the <code>use_kernel_forward_from_hub</code>
decorator can be made extensible using the <code>replace_kernel_forward_from_hub</code>
function:`,_e,g,Be,$,Bl=`<strong>Warning:</strong> we strongly recommend using layers with a decorator, since
it signifies that the maintainer intends to keep the <code>forward</code> signature
compatible with layers from the hub.`,Ge,E,He,R,Gl=`A model will not use Hub kernels by default, even if it contains extensible
layers. To enable the use of Hub kernels in the model, it needs to be
‘kernelized’ using the <code>kernelize</code> function. This function traverses the
model graph and replaces the <code>forward</code> methods of extensible layers for which
Hub kernels are registered. <code>kernelize</code> can be used as follows:`,Le,v,Se,N,Hl=`The <code>kernelize</code> function modifies the model in-place, the model itself is
returned as a convenience. The <code>mode</code> specifies that the model will be used
in inference. Similarly, you can ask <code>kernelize</code> to prepare the model for
training:`,Ze,_,We,B,Ll=`A model that is kernelized for training can also be used for inference, but
not the other way around. If you want to change the mode of the kernelized
model, you can just run <code>kernelize</code> on the model again with the new mode.`,Ve,G,Sl=`If you want to compile a model with <code>torch.compile</code>, this should be indicated
in the mode as well. You can do this by combining <code>Mode.INFERENCE</code> or
<code>Mode.TRAINING</code> with <code>Mode.TORCH_COMPILE</code> using the set union (<code>|</code>) operator:`,xe,H,Qe,L,Zl=`When the <code>mode</code> argument is not specified,
<code>Mode.TRAINING | Mode.TORCH_COMPILE</code> is used as the default. This mode
aligns most closely with pure PyTorch layers which also support training
and <code>torch.compile</code>. However, to select the most performant kernels, it
is often good to make the mode specific as possible.`,Xe,S,Fe,Z,Wl=`Kernels can be registered per device type. For instance, separate <code>cuda</code> and
<code>metal</code> kernels could be registered for the name <code>SiluAndMul</code>. By default,
<code>kernelize</code> will try to infer the device type from the model’s parameters.
You can pass the device type to <code>kernelize</code> if the device type cannot be
inferred (e.g. because the model has no parameters):`,ze,W,qe,V,Ye,x,Vl=`If the <code>TRAINING</code> and/or <code>TORCH_COMPILE</code> modes are used, but a registered
kernel does not support backward passes or <code>torch.compile</code> respectively,
<code>kernelize</code> will fall back to the original, non-kernelized, layer. You
can let <code>kernelize</code> raise an exception instead by using <code>use_fallback=False</code>:`,Pe,Q,Oe,X,xl="This can be useful if you want to guarantee that Hub kernels are used.",Ke,F,De,z,Ql=`The kernels that are used are logged at the <code>INFO</code> level by <code>kernelize</code>.
See the <a href="https://docs.python.org/3/library/logging.html" rel="nofollow">Python logging</a>
documentation for information on how to configure logging.`,el,q,ll,Y,Xl=`<code>kernelize</code> relies on kernel mappings to find Hub kernels for layers.
Kernel mappings map a kernel name such as <code>SiluAndMul</code> to a kernel on
the Hub. For example:`,tl,P,sl,O,Fl="You can register such a mapping using <code>register_kernel_mapping</code>:",il,K,nl,D,zl=`This will register the kernel mapping in the current context, which is
normally global. It is recommended to scope the mapping to where it is
used with the <code>use_kernel_mapping</code> context manager:`,Ml,ee,al,le,ql=`This ensures that the mapping is not active anymore outside the
<code>with</code>-scope.`,rl,te,ol,se,Yl=`You might want to register two different kernels for a particular layer,
where one kernel is optimized for a specific mode. You can do so by
registering layer repositories for specific modes. For example:`,yl,ie,Tl,ne,Pl=`The <code>kernelize</code> function will attempt to use the following registered
kernels for a given mode:`,pl,Me,Ol=`<li><code>INFERENCE</code>: <code>INFERENCE</code> → <code>INFERENCE | TORCH_COMPILE</code> → <code>TRAINING</code> →
<code>TRAINING | TORCH_COMPILE</code> → <code>FALLBACK</code></li> <li><code>INFERENCE | TORCH_COMPILE</code>: <code>INFERENCE | TORCH_COMPILE</code> →
<code>TRAINING | TORCH_COMPILE</code> → <code>FALLBACK</code></li> <li><code>TRAINING</code>: <code>TRAINING</code> → <code>TRAINING | TORCH_COMPILE</code> → <code>FALLBACK</code></li> <li><code>TRAINING | TORCH_COMPILE</code>: <code>TRAINING | TORCH_COMPILE</code> → <code>FALLBACK</code></li>`,Ul,ae,Kl=`<code>Mode.FALLBACK</code> is a special mode that is used when no other mode matches. It
is also used when a kernel is registered without a mode, as described in the
previous section.`,Jl,re,wl,oe,Dl=`In this case, both <code>Mode.INFERENCE | Mode.TORCH_COMPILE</code> and
<code>Mode.TRAINING | Mode.TORCH_COMPILE</code> will use the <code>Mode.FALLBACK</code> kernel,
since the other kernels do not support <code>torch.compile</code>.`,cl,ye,dl,Te,et=`Some kernels only work with newer CUDA architectures. For instance, some
kernels require capability 9.0 for the TMA unit on Hopper GPUs. <code>kernels</code>
supports registering layers for a range of CUDA capabilities. To do so,
you need to register the layer for a <code>Device</code> with type <code>cuda</code> and
set the supported range of CUDA capabilities with using <code>CUDAProperties</code>:`,ml,pe,Cl,Ue,lt="Capabilities behave as follows:",Il,Je,tt=`<li><p>The minimum and maximum capabilities are inclusive.</p></li> <li><p>When a new kernel is registered with the same min/max capabilities as
an existing kernel, the new kernel will replace the old kernel.</p></li> <li><p>When there are multiple kernels that support a capability, the kernel
with the smaller capability interval will be used. E.g. given:</p> <ul><li><code>KernelA</code> with <code>min_capability=80</code> and <code>max_capability=89</code>;</li> <li><code>KernelB</code> with <code>min_capability=75</code> and <code>max_capability=89</code>;</li> <li><code>kernelize</code> runs on a system with capability 8.6.</li></ul> <p>Then <code>KernelA</code> will be used because the interval 80..89 is smaller
than 75..89. The motivation is that kernels with smaller ranges
tend to be more optimized for a specific set of GPUs. <strong>This behavior
might still change in the future.</strong></p></li>`,ul,we,fl,ce,st=`Registering kernels for the ROCm architecture follows the exact same
pattern as CUDA kernels, using <code>min_capability</code> and <code>max_capability</code> to restrict
a kernel to a range of ROCm capabilities.`,hl,de,jl,me,it=`The <code>LocalLayerRepository</code> class is provided to load a repository from
a local directory. For example:`,bl,Ce,kl,Ie,Al,fe,gl;return m=new c({props:{title:"Layers",local:"layers",headingTag:"h1"}}),u=new c({props:{title:"Making a layer extensible with kernels from the hub",local:"making-a-layer-extensible-with-kernels-from-the-hub",headingTag:"h2"}}),f=new c({props:{title:"Using a decorator",local:"using-a-decorator",headingTag:"h3"}}),j=new w({props:{code:"JTQwdXNlX2tlcm5lbF9mb3J3YXJkX2Zyb21faHViKCUyMlNpbHVBbmRNdWwlMjIpJTBBY2xhc3MlMjBTaWx1QW5kTXVsKG5uLk1vZHVsZSklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBmb3J3YXJkKHNlbGYlMkMlMjBpbnB1dCUzQSUyMHRvcmNoLlRlbnNvciklMjAtJTNFJTIwdG9yY2guVGVuc29yJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZCUyMCUzRCUyMGlucHV0LnNoYXBlJTVCLTElNUQlMjAlMkYlMkYlMjAyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwRi5zaWx1KGlucHV0JTVCLi4uJTJDJTIwJTNBZCU1RCklMjAqJTIwaW5wdXQlNUIuLi4lMkMlMjBkJTNBJTVE",highlighted:`<span class="hljs-meta">@use_kernel_forward_from_hub(<span class="hljs-params"><span class="hljs-string">&quot;SiluAndMul&quot;</span></span>)</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">SiluAndMul</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, <span class="hljs-built_in">input</span>: torch.Tensor</span>) -&gt; torch.Tensor:
        d = <span class="hljs-built_in">input</span>.shape[-<span class="hljs-number">1</span>] // <span class="hljs-number">2</span>
        <span class="hljs-keyword">return</span> F.silu(<span class="hljs-built_in">input</span>[..., :d]) * <span class="hljs-built_in">input</span>[..., d:]`,wrap:!1}}),k=new c({props:{title:"External layers",local:"external-layers",headingTag:"h3"}}),g=new w({props:{code:"ZnJvbSUyMHNvbWVsaWJyYXJ5JTIwaW1wb3J0JTIwU2lsdUFuZE11bCUwQSUwQXJlcGxhY2Vfa2VybmVsX2ZvcndhcmRfZnJvbV9odWIoU2lsdUFuZE11bCUyQyUyMCUyMlNpbHVBbmRNdWwlMjIp",highlighted:`<span class="hljs-keyword">from</span> somelibrary <span class="hljs-keyword">import</span> SiluAndMul

replace_kernel_forward_from_hub(SiluAndMul, <span class="hljs-string">&quot;SiluAndMul&quot;</span>)`,wrap:!1}}),E=new c({props:{title:"Kernelizing a model",local:"kernelizing-a-model",headingTag:"h2"}}),v=new w({props:{code:"bW9kZWwlMjAlM0QlMjBNeU1vZGVsKC4uLiklMEFtb2RlbCUyMCUzRCUyMGtlcm5lbGl6ZShtb2RlbCUyQyUyMG1vZGUlM0RNb2RlLklORkVSRU5DRSk=",highlighted:`model = MyModel(...)
model = kernelize(model, mode=Mode.INFERENCE)`,wrap:!1}}),_=new w({props:{code:"bW9kZWwlMjAlM0QlMjBNeU1vZGVsKC4uLiklMEFtb2RlbCUyMCUzRCUyMGtlcm5lbGl6ZShtb2RlbCUyQyUyMG1vZGUlM0RNb2RlLlRSQUlOSU5HKQ==",highlighted:`model = MyModel(...)
model = kernelize(model, mode=Mode.TRAINING)`,wrap:!1}}),H=new w({props:{code:"bW9kZWwlMjAlM0QlMjBNeU1vZGVsKC4uLiklMEElMEElMjMlMjBJbmZlcmVuY2UlMEFtb2RlbCUyMCUzRCUyMGtlcm5lbGl6ZShtb2RlbCUyQyUyMG1vZGUlM0RNb2RlLklORkVSRU5DRSUyMCU3QyUyME1vZGUuVE9SQ0hfQ09NUElMRSklMEElMEElMjMlMjBUcmFpbmluZyUwQW1vZGVsJTIwJTNEJTIwa2VybmVsaXplKG1vZGVsJTJDJTIwbW9kZSUzRE1vZGUuVFJBSU5JTkclMjAlN0MlMjBNb2RlLlRPUkNIX0NPTVBJTEUp",highlighted:`model = MyModel(...)

<span class="hljs-comment"># Inference</span>
model = kernelize(model, mode=Mode.INFERENCE | Mode.TORCH_COMPILE)

<span class="hljs-comment"># Training</span>
model = kernelize(model, mode=Mode.TRAINING | Mode.TORCH_COMPILE)`,wrap:!1}}),S=new c({props:{title:"Kernel device",local:"kernel-device",headingTag:"h3"}}),W=new w({props:{code:"bW9kZWwlMjAlM0QlMjBNeU1vZGVsKC4uLiklMEFtb2RlbCUyMCUzRCUyMGtlcm5lbGl6ZShtb2RlbCUyQyUyMGRldmljZSUzRCUyMmN1ZGElMjIlMkMlMjBtb2RlJTNETW9kZS5JTkZFUkVOQ0Up",highlighted:`model = MyModel(...)
model = kernelize(model, device=<span class="hljs-string">&quot;cuda&quot;</span>, mode=Mode.INFERENCE)`,wrap:!1}}),V=new c({props:{title:"Fallback forward",local:"fallback-forward",headingTag:"h3"}}),Q=new w({props:{code:"bW9kZWwlMjAlM0QlMjBNeU1vZGVsKC4uLiklMEFtb2RlbCUyMCUzRCUyMGtlcm5lbGl6ZShtb2RlbCUyQyUyMG1vZGUlM0RNb2RlLklORkVSRU5DRSUyMCU3QyUyME1vZGUuVE9SQ0hfQ09NUElMRSUyQyUyMHVzZV9mYWxsYmFjayUzREZhbHNlKQ==",highlighted:`model = MyModel(...)
model = kernelize(model, mode=Mode.INFERENCE | Mode.TORCH_COMPILE, use_fallback=<span class="hljs-literal">False</span>)`,wrap:!1}}),F=new c({props:{title:"Inspecting kernels which kernels are used",local:"inspecting-kernels-which-kernels-are-used",headingTag:"h3"}}),q=new c({props:{title:"Registering a hub kernel for a layer",local:"registering-a-hub-kernel-for-a-layer",headingTag:"h2"}}),P=new w({props:{code:"a2VybmVsX2xheWVyX21hcHBpbmclMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJTaWx1QW5kTXVsJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY3VkYSUyMiUzQSUyMExheWVyUmVwb3NpdG9yeSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIya2VybmVscy1jb21tdW5pdHklMkZhY3RpdmF0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGF5ZXJfbmFtZSUzRCUyMlNpbHVBbmRNdWwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9jbSUyMiUzQSUyMExheWVyUmVwb3NpdG9yeSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIya2VybmVscy1jb21tdW5pdHklMkZhY3RpdmF0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGF5ZXJfbmFtZSUzRCUyMlNpbHVBbmRNdWwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTdE",highlighted:`kernel_layer_mapping = {
    <span class="hljs-string">&quot;SiluAndMul&quot;</span>: {
        <span class="hljs-string">&quot;cuda&quot;</span>: LayerRepository(
            repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
            layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
        ),
        <span class="hljs-string">&quot;rocm&quot;</span>: LayerRepository(
            repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
            layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
        )
    }
}`,wrap:!1}}),K=new w({props:{code:"cmVnaXN0ZXJfa2VybmVsX21hcHBpbmcoa2VybmVsX2xheWVyX21hcHBpbmcp",highlighted:"register_kernel_mapping(kernel_layer_mapping)",wrap:!1}}),ee=new w({props:{code:"d2l0aCUyMHVzZV9rZXJuZWxfbWFwcGluZyhrZXJuZWxfbGF5ZXJfbWFwcGluZyklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBVc2UlMjB0aGUlMjBsYXllciUyMGZvciUyMHdoaWNoJTIwdGhlJTIwbWFwcGluZyUyMGlzJTIwYXBwbGllZC4lMEElMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyMGtlcm5lbGl6ZShtb2RlbCk=",highlighted:`<span class="hljs-keyword">with</span> use_kernel_mapping(kernel_layer_mapping):
    <span class="hljs-comment"># Use the layer for which the mapping is applied.</span>
    model = kernelize(model)`,wrap:!1}}),te=new c({props:{title:"Registering kernels for specific modes",local:"registering-kernels-for-specific-modes",headingTag:"h3"}}),ie=new w({props:{code:"a2VybmVsX2xheWVyX21hcHBpbmclMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJTaWx1QW5kTXVsJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY3VkYSUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyME1vZGUuSU5GRVJFTkNFJTNBJTIwTGF5ZXJSZXBvc2l0b3J5KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJrZXJuZWxzLWNvbW11bml0eSUyRmFjdGl2YXRpb24taW5mZXJlbmNlLW9wdGltaXplZCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxheWVyX25hbWUlM0QlMjJTaWx1QW5kTXVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyME1vZGUuVFJBSU5JTkclMjAlN0MlMjBNb2RlLlRPUkNIX0NPTVBJTEUlM0ElMjBMYXllclJlcG9zaXRvcnkoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMmtlcm5lbHMtY29tbXVuaXR5JTJGYWN0aXZhdGlvbi10cmFpbmluZy1vcHRpbWl6ZWQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYXllcl9uYW1lJTNEJTIyU2lsdUFuZE11bCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEElN0Q=",highlighted:`kernel_layer_mapping = {
    <span class="hljs-string">&quot;SiluAndMul&quot;</span>: {
        <span class="hljs-string">&quot;cuda&quot;</span>: {
          Mode.INFERENCE: LayerRepository(
              repo_id=<span class="hljs-string">&quot;kernels-community/activation-inference-optimized&quot;</span>,
              layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
          ),
          Mode.TRAINING | Mode.TORCH_COMPILE: LayerRepository(
              repo_id=<span class="hljs-string">&quot;kernels-community/activation-training-optimized&quot;</span>,
              layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
          ),
      }
    }
}`,wrap:!1}}),re=new w({props:{code:"a2VybmVsX2xheWVyX21hcHBpbmclMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJTaWx1QW5kTXVsJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY3VkYSUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyME1vZGUuRkFMTEJBQ0slM0ElMjBMYXllclJlcG9zaXRvcnkoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMmtlcm5lbHMtY29tbXVuaXR5JTJGYWN0aXZhdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxheWVyX25hbWUlM0QlMjJTaWx1QW5kTXVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyME1vZGUuSU5GRVJFTkNFJTNBJTIwTGF5ZXJSZXBvc2l0b3J5KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJrZXJuZWxzLWNvbW11bml0eSUyRmFjdGl2YXRpb24taW5mZXJlbmNlLW9wdGltaXplZCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxheWVyX25hbWUlM0QlMjJTaWx1QW5kTXVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyME1vZGUuVFJBSU5JTkclM0ElMjBMYXllclJlcG9zaXRvcnkoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMmtlcm5lbHMtY29tbXVuaXR5JTJGYWN0aXZhdGlvbi10cmFpbmluZy1vcHRpbWl6ZWQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYXllcl9uYW1lJTNEJTIyU2lsdUFuZE11bCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEElN0Q=",highlighted:`kernel_layer_mapping = {
    <span class="hljs-string">&quot;SiluAndMul&quot;</span>: {
        <span class="hljs-string">&quot;cuda&quot;</span>: {
            Mode.FALLBACK: LayerRepository(
                repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
                layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
            ),
            Mode.INFERENCE: LayerRepository(
                repo_id=<span class="hljs-string">&quot;kernels-community/activation-inference-optimized&quot;</span>,
                layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
            ),
            Mode.TRAINING: LayerRepository(
                repo_id=<span class="hljs-string">&quot;kernels-community/activation-training-optimized&quot;</span>,
                layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
            ),
        }
    }
}`,wrap:!1}}),ye=new c({props:{title:"Registering kernels for specific CUDA capabilities",local:"registering-kernels-for-specific-cuda-capabilities",headingTag:"h3"}}),pe=new w({props:{code:"a2VybmVsX2xheWVyX21hcHBpbmclMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJTaWx1QW5kTXVsJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwRGV2aWNlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHR5cGUlM0QlMjJjdWRhJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvcGVydGllcyUzRENVREFQcm9wZXJ0aWVzKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1pbl9jYXBhYmlsaXR5JTNENzUlMkMlMjBtYXhfY2FwYWJpbGl0eSUzRDg5JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklM0ElMjBMYXllclJlcG9zaXRvcnkoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMmtlcm5lbHMtY29tbXVuaXR5JTJGYWN0aXZhdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxheWVyX25hbWUlM0QlMjJTaWx1QW5kTXVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMERldmljZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0eXBlJTNEJTIyY3VkYSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb3BlcnRpZXMlM0RDVURBUHJvcGVydGllcyglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtaW5fY2FwYWJpbGl0eSUzRDkwJTJDJTIwbWF4X2NhcGFiaWxpdHklM0RzeXMubWF4c2l6ZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTNBJTIwTGF5ZXJSZXBvc2l0b3J5KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJrZXJuZWxzLWNvbW11bml0eSUyRmFjdGl2YXRpb24taG9wcGVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGF5ZXJfbmFtZSUzRCUyMlNpbHVBbmRNdWwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTdE",highlighted:`kernel_layer_mapping = {
    <span class="hljs-string">&quot;SiluAndMul&quot;</span>: {
        Device(
            <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;cuda&quot;</span>,
            properties=CUDAProperties(
                min_capability=<span class="hljs-number">75</span>, max_capability=<span class="hljs-number">89</span>
            ),
        ): LayerRepository(
            repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
            layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
        ),
        Device(
            <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;cuda&quot;</span>,
            properties=CUDAProperties(
                min_capability=<span class="hljs-number">90</span>, max_capability=sys.maxsize
            ),
        ): LayerRepository(
            repo_id=<span class="hljs-string">&quot;kernels-community/activation-hopper&quot;</span>,
            layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
        ),
    }
}`,wrap:!1}}),we=new c({props:{title:"Registering kernels for specific ROCm capabilities",local:"registering-kernels-for-specific-rocm-capabilities",headingTag:"h3"}}),de=new c({props:{title:"Loading from a local repository for testing",local:"loading-from-a-local-repository-for-testing",headingTag:"h3"}}),Ce=new w({props:{code:"d2l0aCUyMHVzZV9rZXJuZWxfbWFwcGluZyglMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJTaWx1QW5kTXVsJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY3VkYSUyMiUzQSUyMExvY2FsTGF5ZXJSZXBvc2l0b3J5KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMGluc3RhbGxfa2VybmVsJTIwd2lsbCUyMGdpdmUlMjB0aGUlMjBmdWxseS1yZXNvbHZlZCUyMHBhdGguJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVwb19wYXRoJTNEJTIyJTJGaG9tZSUyRmRhbmllbCUyRmtlcm5lbHMlMkZhY3RpdmF0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGFja2FnZV9uYW1lJTNEJTIyYWN0aXZhdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxheWVyX25hbWUlM0QlMjJTaWx1QW5kTXVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMGluaGVyaXRfbWFwcGluZyUzREZhbHNlJTJDJTBBKSUzQSUwQSUyMCUyMCUyMCUyMGtlcm5lbGl6ZShsaW5lYXIlMkMlMjBtb2RlJTNETW9kZS5JTkZFUkVOQ0Up",highlighted:`with use_kernel_mapping(
    {
        <span class="hljs-string">&quot;SiluAndMul&quot;</span>: {
            <span class="hljs-string">&quot;cuda&quot;</span>: LocalLayerRepository(
                # install_kernel will give the fully-resolved path.
                <span class="hljs-attribute">repo_path</span>=<span class="hljs-string">&quot;/home/daniel/kernels/activation&quot;</span>,
                <span class="hljs-attribute">package_name</span>=<span class="hljs-string">&quot;activation&quot;</span>,
                <span class="hljs-attribute">layer_name</span>=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
            )
        }
    },
    <span class="hljs-attribute">inherit_mapping</span>=<span class="hljs-literal">False</span>,
):
    kernelize(linear, <span class="hljs-attribute">mode</span>=Mode.INFERENCE)`,wrap:!1}}),Ie=new Jt({props:{source:"https://github.com/huggingface/kernels/blob/main/docs/source/layers.md"}}),{c(){d=M("meta"),he=i(),ue=M("p"),je=i(),o(m.$$.fragment),be=i(),C=M("p"),C.innerHTML=El,ke=i(),I=M("p"),I.innerHTML=Rl,Ae=i(),o(u.$$.fragment),ge=i(),o(f.$$.fragment),$e=i(),h=M("p"),h.innerHTML=vl,Ee=i(),o(j.$$.fragment),Re=i(),b=M("p"),b.innerHTML=Nl,ve=i(),o(k.$$.fragment),Ne=i(),A=M("p"),A.innerHTML=_l,_e=i(),o(g.$$.fragment),Be=i(),$=M("p"),$.innerHTML=Bl,Ge=i(),o(E.$$.fragment),He=i(),R=M("p"),R.innerHTML=Gl,Le=i(),o(v.$$.fragment),Se=i(),N=M("p"),N.innerHTML=Hl,Ze=i(),o(_.$$.fragment),We=i(),B=M("p"),B.innerHTML=Ll,Ve=i(),G=M("p"),G.innerHTML=Sl,xe=i(),o(H.$$.fragment),Qe=i(),L=M("p"),L.innerHTML=Zl,Xe=i(),o(S.$$.fragment),Fe=i(),Z=M("p"),Z.innerHTML=Wl,ze=i(),o(W.$$.fragment),qe=i(),o(V.$$.fragment),Ye=i(),x=M("p"),x.innerHTML=Vl,Pe=i(),o(Q.$$.fragment),Oe=i(),X=M("p"),X.textContent=xl,Ke=i(),o(F.$$.fragment),De=i(),z=M("p"),z.innerHTML=Ql,el=i(),o(q.$$.fragment),ll=i(),Y=M("p"),Y.innerHTML=Xl,tl=i(),o(P.$$.fragment),sl=i(),O=M("p"),O.innerHTML=Fl,il=i(),o(K.$$.fragment),nl=i(),D=M("p"),D.innerHTML=zl,Ml=i(),o(ee.$$.fragment),al=i(),le=M("p"),le.innerHTML=ql,rl=i(),o(te.$$.fragment),ol=i(),se=M("p"),se.textContent=Yl,yl=i(),o(ie.$$.fragment),Tl=i(),ne=M("p"),ne.innerHTML=Pl,pl=i(),Me=M("ul"),Me.innerHTML=Ol,Ul=i(),ae=M("p"),ae.innerHTML=Kl,Jl=i(),o(re.$$.fragment),wl=i(),oe=M("p"),oe.innerHTML=Dl,cl=i(),o(ye.$$.fragment),dl=i(),Te=M("p"),Te.innerHTML=et,ml=i(),o(pe.$$.fragment),Cl=i(),Ue=M("p"),Ue.textContent=lt,Il=i(),Je=M("ul"),Je.innerHTML=tt,ul=i(),o(we.$$.fragment),fl=i(),ce=M("p"),ce.innerHTML=st,hl=i(),o(de.$$.fragment),jl=i(),me=M("p"),me.innerHTML=it,bl=i(),o(Ce.$$.fragment),kl=i(),o(Ie.$$.fragment),Al=i(),fe=M("p"),this.h()},l(e){const l=pt("svelte-u9bgzb",document.head);d=a(l,"META",{name:!0,content:!0}),l.forEach(t),he=n(e),ue=a(e,"P",{}),nt(ue).forEach(t),je=n(e),y(m.$$.fragment,e),be=n(e),C=a(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-178x673"&&(C.innerHTML=El),ke=n(e),I=a(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-v68zn9"&&(I.innerHTML=Rl),Ae=n(e),y(u.$$.fragment,e),ge=n(e),y(f.$$.fragment,e),$e=n(e),h=a(e,"P",{"data-svelte-h":!0}),r(h)!=="svelte-1jd41lf"&&(h.innerHTML=vl),Ee=n(e),y(j.$$.fragment,e),Re=n(e),b=a(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-tily1x"&&(b.innerHTML=Nl),ve=n(e),y(k.$$.fragment,e),Ne=n(e),A=a(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1hj9ahw"&&(A.innerHTML=_l),_e=n(e),y(g.$$.fragment,e),Be=n(e),$=a(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-13coke1"&&($.innerHTML=Bl),Ge=n(e),y(E.$$.fragment,e),He=n(e),R=a(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-stkx9y"&&(R.innerHTML=Gl),Le=n(e),y(v.$$.fragment,e),Se=n(e),N=a(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1mdicvi"&&(N.innerHTML=Hl),Ze=n(e),y(_.$$.fragment,e),We=n(e),B=a(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-xhc5xj"&&(B.innerHTML=Ll),Ve=n(e),G=a(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-195gdzl"&&(G.innerHTML=Sl),xe=n(e),y(H.$$.fragment,e),Qe=n(e),L=a(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1pcqrau"&&(L.innerHTML=Zl),Xe=n(e),y(S.$$.fragment,e),Fe=n(e),Z=a(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-808tau"&&(Z.innerHTML=Wl),ze=n(e),y(W.$$.fragment,e),qe=n(e),y(V.$$.fragment,e),Ye=n(e),x=a(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-yu926d"&&(x.innerHTML=Vl),Pe=n(e),y(Q.$$.fragment,e),Oe=n(e),X=a(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1lkusth"&&(X.textContent=xl),Ke=n(e),y(F.$$.fragment,e),De=n(e),z=a(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-161p6z8"&&(z.innerHTML=Ql),el=n(e),y(q.$$.fragment,e),ll=n(e),Y=a(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1r5il31"&&(Y.innerHTML=Xl),tl=n(e),y(P.$$.fragment,e),sl=n(e),O=a(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1mzc83p"&&(O.innerHTML=Fl),il=n(e),y(K.$$.fragment,e),nl=n(e),D=a(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-p5ro9n"&&(D.innerHTML=zl),Ml=n(e),y(ee.$$.fragment,e),al=n(e),le=a(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-z3xuuf"&&(le.innerHTML=ql),rl=n(e),y(te.$$.fragment,e),ol=n(e),se=a(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1ed3b6y"&&(se.textContent=Yl),yl=n(e),y(ie.$$.fragment,e),Tl=n(e),ne=a(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-sek2d8"&&(ne.innerHTML=Pl),pl=n(e),Me=a(e,"UL",{"data-svelte-h":!0}),r(Me)!=="svelte-ewhtf4"&&(Me.innerHTML=Ol),Ul=n(e),ae=a(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-m4furw"&&(ae.innerHTML=Kl),Jl=n(e),y(re.$$.fragment,e),wl=n(e),oe=a(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1oi4pcx"&&(oe.innerHTML=Dl),cl=n(e),y(ye.$$.fragment,e),dl=n(e),Te=a(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1wl92tu"&&(Te.innerHTML=et),ml=n(e),y(pe.$$.fragment,e),Cl=n(e),Ue=a(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-1k7nbkd"&&(Ue.textContent=lt),Il=n(e),Je=a(e,"UL",{"data-svelte-h":!0}),r(Je)!=="svelte-xyngc6"&&(Je.innerHTML=tt),ul=n(e),y(we.$$.fragment,e),fl=n(e),ce=a(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-1q9vv7t"&&(ce.innerHTML=st),hl=n(e),y(de.$$.fragment,e),jl=n(e),me=a(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-qa4iob"&&(me.innerHTML=it),bl=n(e),y(Ce.$$.fragment,e),kl=n(e),y(Ie.$$.fragment,e),Al=n(e),fe=a(e,"P",{}),nt(fe).forEach(t),this.h()},h(){Mt(d,"name","hf:doc:metadata"),Mt(d,"content",ct)},m(e,l){Ut(document.head,d),s(e,he,l),s(e,ue,l),s(e,je,l),T(m,e,l),s(e,be,l),s(e,C,l),s(e,ke,l),s(e,I,l),s(e,Ae,l),T(u,e,l),s(e,ge,l),T(f,e,l),s(e,$e,l),s(e,h,l),s(e,Ee,l),T(j,e,l),s(e,Re,l),s(e,b,l),s(e,ve,l),T(k,e,l),s(e,Ne,l),s(e,A,l),s(e,_e,l),T(g,e,l),s(e,Be,l),s(e,$,l),s(e,Ge,l),T(E,e,l),s(e,He,l),s(e,R,l),s(e,Le,l),T(v,e,l),s(e,Se,l),s(e,N,l),s(e,Ze,l),T(_,e,l),s(e,We,l),s(e,B,l),s(e,Ve,l),s(e,G,l),s(e,xe,l),T(H,e,l),s(e,Qe,l),s(e,L,l),s(e,Xe,l),T(S,e,l),s(e,Fe,l),s(e,Z,l),s(e,ze,l),T(W,e,l),s(e,qe,l),T(V,e,l),s(e,Ye,l),s(e,x,l),s(e,Pe,l),T(Q,e,l),s(e,Oe,l),s(e,X,l),s(e,Ke,l),T(F,e,l),s(e,De,l),s(e,z,l),s(e,el,l),T(q,e,l),s(e,ll,l),s(e,Y,l),s(e,tl,l),T(P,e,l),s(e,sl,l),s(e,O,l),s(e,il,l),T(K,e,l),s(e,nl,l),s(e,D,l),s(e,Ml,l),T(ee,e,l),s(e,al,l),s(e,le,l),s(e,rl,l),T(te,e,l),s(e,ol,l),s(e,se,l),s(e,yl,l),T(ie,e,l),s(e,Tl,l),s(e,ne,l),s(e,pl,l),s(e,Me,l),s(e,Ul,l),s(e,ae,l),s(e,Jl,l),T(re,e,l),s(e,wl,l),s(e,oe,l),s(e,cl,l),T(ye,e,l),s(e,dl,l),s(e,Te,l),s(e,ml,l),T(pe,e,l),s(e,Cl,l),s(e,Ue,l),s(e,Il,l),s(e,Je,l),s(e,ul,l),T(we,e,l),s(e,fl,l),s(e,ce,l),s(e,hl,l),T(de,e,l),s(e,jl,l),s(e,me,l),s(e,bl,l),T(Ce,e,l),s(e,kl,l),T(Ie,e,l),s(e,Al,l),s(e,fe,l),gl=!0},p:rt,i(e){gl||(p(m.$$.fragment,e),p(u.$$.fragment,e),p(f.$$.fragment,e),p(j.$$.fragment,e),p(k.$$.fragment,e),p(g.$$.fragment,e),p(E.$$.fragment,e),p(v.$$.fragment,e),p(_.$$.fragment,e),p(H.$$.fragment,e),p(S.$$.fragment,e),p(W.$$.fragment,e),p(V.$$.fragment,e),p(Q.$$.fragment,e),p(F.$$.fragment,e),p(q.$$.fragment,e),p(P.$$.fragment,e),p(K.$$.fragment,e),p(ee.$$.fragment,e),p(te.$$.fragment,e),p(ie.$$.fragment,e),p(re.$$.fragment,e),p(ye.$$.fragment,e),p(pe.$$.fragment,e),p(we.$$.fragment,e),p(de.$$.fragment,e),p(Ce.$$.fragment,e),p(Ie.$$.fragment,e),gl=!0)},o(e){U(m.$$.fragment,e),U(u.$$.fragment,e),U(f.$$.fragment,e),U(j.$$.fragment,e),U(k.$$.fragment,e),U(g.$$.fragment,e),U(E.$$.fragment,e),U(v.$$.fragment,e),U(_.$$.fragment,e),U(H.$$.fragment,e),U(S.$$.fragment,e),U(W.$$.fragment,e),U(V.$$.fragment,e),U(Q.$$.fragment,e),U(F.$$.fragment,e),U(q.$$.fragment,e),U(P.$$.fragment,e),U(K.$$.fragment,e),U(ee.$$.fragment,e),U(te.$$.fragment,e),U(ie.$$.fragment,e),U(re.$$.fragment,e),U(ye.$$.fragment,e),U(pe.$$.fragment,e),U(we.$$.fragment,e),U(de.$$.fragment,e),U(Ce.$$.fragment,e),U(Ie.$$.fragment,e),gl=!1},d(e){e&&(t(he),t(ue),t(je),t(be),t(C),t(ke),t(I),t(Ae),t(ge),t($e),t(h),t(Ee),t(Re),t(b),t(ve),t(Ne),t(A),t(_e),t(Be),t($),t(Ge),t(He),t(R),t(Le),t(Se),t(N),t(Ze),t(We),t(B),t(Ve),t(G),t(xe),t(Qe),t(L),t(Xe),t(Fe),t(Z),t(ze),t(qe),t(Ye),t(x),t(Pe),t(Oe),t(X),t(Ke),t(De),t(z),t(el),t(ll),t(Y),t(tl),t(sl),t(O),t(il),t(nl),t(D),t(Ml),t(al),t(le),t(rl),t(ol),t(se),t(yl),t(Tl),t(ne),t(pl),t(Me),t(Ul),t(ae),t(Jl),t(wl),t(oe),t(cl),t(dl),t(Te),t(ml),t(Cl),t(Ue),t(Il),t(Je),t(ul),t(fl),t(ce),t(hl),t(jl),t(me),t(bl),t(kl),t(Al),t(fe)),t(d),J(m,e),J(u,e),J(f,e),J(j,e),J(k,e),J(g,e),J(E,e),J(v,e),J(_,e),J(H,e),J(S,e),J(W,e),J(V,e),J(Q,e),J(F,e),J(q,e),J(P,e),J(K,e),J(ee,e),J(te,e),J(ie,e),J(re,e),J(ye,e),J(pe,e),J(we,e),J(de,e),J(Ce,e),J(Ie,e)}}}const ct='{"title":"Layers","local":"layers","sections":[{"title":"Making a layer extensible with kernels from the hub","local":"making-a-layer-extensible-with-kernels-from-the-hub","sections":[{"title":"Using a decorator","local":"using-a-decorator","sections":[],"depth":3},{"title":"External layers","local":"external-layers","sections":[],"depth":3}],"depth":2},{"title":"Kernelizing a model","local":"kernelizing-a-model","sections":[{"title":"Kernel device","local":"kernel-device","sections":[],"depth":3},{"title":"Fallback forward","local":"fallback-forward","sections":[],"depth":3},{"title":"Inspecting kernels which kernels are used","local":"inspecting-kernels-which-kernels-are-used","sections":[],"depth":3}],"depth":2},{"title":"Registering a hub kernel for a layer","local":"registering-a-hub-kernel-for-a-layer","sections":[{"title":"Registering kernels for specific modes","local":"registering-kernels-for-specific-modes","sections":[],"depth":3},{"title":"Registering kernels for specific CUDA capabilities","local":"registering-kernels-for-specific-cuda-capabilities","sections":[],"depth":3},{"title":"Registering kernels for specific ROCm capabilities","local":"registering-kernels-for-specific-rocm-capabilities","sections":[],"depth":3},{"title":"Loading from a local repository for testing","local":"loading-from-a-local-repository-for-testing","sections":[],"depth":3}],"depth":2}],"depth":1}';function dt($l){return ot(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ft extends yt{constructor(d){super(),Tt(this,d,dt,wt,at,{})}}export{ft as component};
