import{s as te,o as ee,n as Kt}from"../chunks/scheduler.6062bdaf.js";import{S as le,i as ae,g as p,s as n,r as m,A as ne,h as o,f as l,c as s,j as Pt,u,x as y,k as et,y as se,a,v as r,d as c,t as M,w as d}from"../chunks/index.4bca734e.js";import{T as Dt}from"../chunks/Tip.b9ac1f03.js";import{C as b}from"../chunks/CodeBlock.fa01571c.js";import{H as K,E as ie}from"../chunks/EditOnGithub.74ab2baa.js";function pe(D){let i,T=`You can read the <a href="../../concept_guides/quantization">conceptual guide on quantization</a> to learn about quantization. It
explains the main concepts that you will be using when performing quantization with the
<a href="/docs/optimum/pr_1945/en/onnxruntime/package_reference/quantization#optimum.onnxruntime.ORTQuantizer">ORTQuantizer</a>.`;return{c(){i=p("p"),i.innerHTML=T},l(h){i=o(h,"P",{"data-svelte-h":!0}),y(i)!=="svelte-1ggk3xw"&&(i.innerHTML=T)},m(h,j){a(h,i,j)},p:Kt,d(h){h&&l(i)}}}function oe(D){let i,T="Currently, only dynamic quantization is supported for Seq2Seq models.";return{c(){i=p("p"),i.textContent=T},l(h){i=o(h,"P",{"data-svelte-h":!0}),y(i)!=="svelte-1s2u00l"&&(i.textContent=T)},m(h,j){a(h,i,j)},p:Kt,d(h){h&&l(i)}}}function me(D){let i,T,h,j,R,lt,C,Ft=`🤗 Optimum provides an <code>optimum.onnxruntime</code> package that enables you to apply quantization on many models hosted on
the Hugging Face Hub using the <a href="https://github.com/microsoft/onnxruntime/blob/master/onnxruntime/python/tools/quantization/README.md" rel="nofollow">ONNX Runtime</a>
quantization tool.`,at,Z,$t=`The quantization process is abstracted via the <a href="/docs/optimum/pr_1945/en/onnxruntime/package_reference/configuration#optimum.onnxruntime.ORTConfig">ORTConfig</a> and
the <a href="/docs/optimum/pr_1945/en/onnxruntime/package_reference/quantization#optimum.onnxruntime.ORTQuantizer">ORTQuantizer</a> classes. The former allows you to specify how quantization should be done,
while the latter effectively handles quantization.`,nt,U,st,W,it,X,Qt="The Optimum ONNX Runtime quantization tool can be used through Optimum command-line interface:",pt,z,ot,I,qt="Quantizing an ONNX model can be done as follows:",mt,v,ut,G,Bt="This quantize all the ONNX files in <code>onnx_model_location</code> with the AVX-512 instructions.",rt,_,ct,F,Vt=`The <a href="/docs/optimum/pr_1945/en/onnxruntime/package_reference/quantization#optimum.onnxruntime.ORTQuantizer">ORTQuantizer</a> class is used to quantize your ONNX model. The class can be initialized using
the <code>from_pretrained()</code> method, which supports different checkpoint formats.`,Mt,$,kt="<li>Using an already initialized <code>ORTModelForXXX</code> class.</li>",dt,Q,ht,w,xt="<li>Using a local ONNX model from a directory.</li>",yt,q,Tt,B,bt,V,Nt=`The <a href="/docs/optimum/pr_1945/en/onnxruntime/package_reference/quantization#optimum.onnxruntime.ORTQuantizer">ORTQuantizer</a> class can be used to quantize dynamically your ONNX model. Below you will
find an easy end-to-end example on how to quantize dynamically
<a href="https://huggingface.co/distilbert-base-uncased-finetuned-sst-2-english" rel="nofollow">distilbert-base-uncased-finetuned-sst-2-english</a>.`,jt,k,Ut,x,wt,N,At=`The <a href="/docs/optimum/pr_1945/en/onnxruntime/package_reference/quantization#optimum.onnxruntime.ORTQuantizer">ORTQuantizer</a> class can be used to quantize statically your ONNX model. Below you will find
an easy end-to-end example on how to quantize statically
<a href="https://huggingface.co/distilbert-base-uncased-finetuned-sst-2-english" rel="nofollow">distilbert-base-uncased-finetuned-sst-2-english</a>.`,Jt,A,ft,E,gt,S,Et=`The <a href="/docs/optimum/pr_1945/en/onnxruntime/package_reference/quantization#optimum.onnxruntime.ORTQuantizer">ORTQuantizer</a> class currently doesn’t support multi-file models, like
<a href="/docs/optimum/pr_1945/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModelForSeq2SeqLM">ORTModelForSeq2SeqLM</a>. If you want to quantize a Seq2Seq model, you have to quantize each
model’s component individually.`,Rt,J,Ct,Y,St="<li>Load seq2seq model as <code>ORTModelForSeq2SeqLM</code>.</li>",Zt,H,Wt,f,Yt="<li>Define Quantizer for encoder, decoder and decoder with past keys</li>",Xt,O,zt,g,Ht="<li>Quantize all models</li>",It,L,vt,P,Gt,tt,_t;return R=new K({props:{title:"Quantization",local:"quantization",headingTag:"h1"}}),U=new Dt({props:{$$slots:{default:[pe]},$$scope:{ctx:D}}}),W=new K({props:{title:"Quantizing a model to be used with Optimum’s CLI",local:"quantizing-a-model-to-be-used-with-optimums-cli",headingTag:"h2"}}),z=new b({props:{code:"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",highlighted:`optimum-cli onnxruntime quantize --<span class="hljs-built_in">help</span>
usage: optimum-cli &lt;<span class="hljs-built_in">command</span>&gt; [&lt;args&gt;] onnxruntime quantize [-h] --onnx_model ONNX_MODEL -o OUTPUT [--per_channel] (--arm64 | --avx2 | --avx512 | --avx512_vnni | --tensorrt | -c CONFIG)

options:
  -h, --<span class="hljs-built_in">help</span>            show this <span class="hljs-built_in">help</span> message and <span class="hljs-built_in">exit</span>
  --arm64               Quantization <span class="hljs-keyword">for</span> the ARM64 architecture.
  --avx2                Quantization with AVX-2 instructions.
  --avx512              Quantization with AVX-512 instructions.
  --avx512_vnni         Quantization with AVX-512 and VNNI instructions.
  --tensorrt            Quantization <span class="hljs-keyword">for</span> NVIDIA TensorRT optimizer.
  -c CONFIG, --config CONFIG
                        \`ORTConfig\` file to use to optimize the model.

Required arguments:
  --onnx_model ONNX_MODEL
                        Path to the repository <span class="hljs-built_in">where</span> the ONNX models to quantize are located.
  -o OUTPUT, --output OUTPUT
                        Path to the directory <span class="hljs-built_in">where</span> to store generated ONNX model.

Optional arguments:
  --per_channel         Compute the quantization parameters on a per-channel basis.
`,wrap:!1}}),v=new b({props:{code:"JTIwb3B0aW11bS1jbGklMjBvbm54cnVudGltZSUyMHF1YW50aXplJTIwLS1vbm54X21vZGVsJTIwb25ueF9tb2RlbF9sb2NhdGlvbiUyRiUyMC0tYXZ4NTEyJTIwLW8lMjBxdWFudGl6ZWRfbW9kZWwlMkY=",highlighted:" optimum-cli onnxruntime quantize --onnx_model onnx_model_location/ --avx512 -o quantized_model/",wrap:!1}}),_=new K({props:{title:"Creating an ORTQuantizer",local:"creating-an-ortquantizer",headingTag:"h2"}}),Q=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRRdWFudGl6ZXIlMkMlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFvcnRfbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMm9wdGltdW0lMkZkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1maW5ldHVuZWQtc3N0LTItZW5nbGlzaCUyMiUwQSklMEElMEFxdWFudGl6ZXIlMjAlM0QlMjBPUlRRdWFudGl6ZXIuZnJvbV9wcmV0cmFpbmVkKG9ydF9tb2RlbCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTQuantizer, ORTModelForSequenceClassification

<span class="hljs-comment"># Loading ONNX Model from the Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>ort_model = ORTModelForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;optimum/distilbert-base-uncased-finetuned-sst-2-english&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-comment"># Create a quantizer from a ORTModelForXXX</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>quantizer = ORTQuantizer.from_pretrained(ort_model)`,wrap:!1}}),q=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRRdWFudGl6ZXIlMEElMEFxdWFudGl6ZXIlMjAlM0QlMjBPUlRRdWFudGl6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMnBhdGglMkZ0byUyRm1vZGVsJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTQuantizer

<span class="hljs-comment"># This assumes a model.onnx exists in path/to/model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>quantizer = ORTQuantizer.from_pretrained(<span class="hljs-string">&quot;path/to/model&quot;</span>)`,wrap:!1}}),B=new K({props:{title:"Apply Dynamic Quantization",local:"apply-dynamic-quantization",headingTag:"h2"}}),k=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRRdWFudGl6ZXIlMkMlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZS5jb25maWd1cmF0aW9uJTIwaW1wb3J0JTIwQXV0b1F1YW50aXphdGlvbkNvbmZpZyUwQSUwQW9ubnhfbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoJTIyJTJDJTIwZXhwb3J0JTNEVHJ1ZSklMEElMEFxdWFudGl6ZXIlMjAlM0QlMjBPUlRRdWFudGl6ZXIuZnJvbV9wcmV0cmFpbmVkKG9ubnhfbW9kZWwpJTBBJTBBZHFjb25maWclMjAlM0QlMjBBdXRvUXVhbnRpemF0aW9uQ29uZmlnLmF2eDUxMl92bm5pKGlzX3N0YXRpYyUzREZhbHNlJTJDJTIwcGVyX2NoYW5uZWwlM0RGYWxzZSklMEElMEFtb2RlbF9xdWFudGl6ZWRfcGF0aCUyMCUzRCUyMHF1YW50aXplci5xdWFudGl6ZSglMEElMjAlMjAlMjAlMjBzYXZlX2RpciUzRCUyMnBhdGglMkZ0byUyRm91dHB1dCUyRm1vZGVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRGRxY29uZmlnJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTQuantizer, ORTModelForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime.configuration <span class="hljs-keyword">import</span> AutoQuantizationConfig

<span class="hljs-comment"># Load PyTorch model and convert to ONNX</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_model = ORTModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>, export=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Create quantizer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>quantizer = ORTQuantizer.from_pretrained(onnx_model)

<span class="hljs-comment"># Define the quantization strategy by creating the appropriate configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dqconfig = AutoQuantizationConfig.avx512_vnni(is_static=<span class="hljs-literal">False</span>, per_channel=<span class="hljs-literal">False</span>)

<span class="hljs-comment"># Quantize the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_quantized_path = quantizer.quantize(
<span class="hljs-meta">... </span>    save_dir=<span class="hljs-string">&quot;path/to/output/model&quot;</span>,
<span class="hljs-meta">... </span>    quantization_config=dqconfig,
<span class="hljs-meta">... </span>)`,wrap:!1}}),x=new K({props:{title:"Static Quantization example",local:"static-quantization-example",headingTag:"h2"}}),A=new b({props:{code:"ZnJvbSUyMGZ1bmN0b29scyUyMGltcG9ydCUyMHBhcnRpYWwlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUUXVhbnRpemVyJTJDJTIwT1JUTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUuY29uZmlndXJhdGlvbiUyMGltcG9ydCUyMEF1dG9RdWFudGl6YXRpb25Db25maWclMkMlMjBBdXRvQ2FsaWJyYXRpb25Db25maWclMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoJTIyJTBBJTBBb25ueF9tb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBleHBvcnQlM0RUcnVlKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQXF1YW50aXplciUyMCUzRCUyME9SVFF1YW50aXplci5mcm9tX3ByZXRyYWluZWQob25ueF9tb2RlbCklMEFxY29uZmlnJTIwJTNEJTIwQXV0b1F1YW50aXphdGlvbkNvbmZpZy5hcm02NChpc19zdGF0aWMlM0RUcnVlJTJDJTIwcGVyX2NoYW5uZWwlM0RGYWxzZSklMEElMEFkZWYlMjBwcmVwcm9jZXNzX2ZuKGV4JTJDJTIwdG9rZW5pemVyKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRva2VuaXplcihleCU1QiUyMnNlbnRlbmNlJTIyJTVEKSUwQSUwQWNhbGlicmF0aW9uX2RhdGFzZXQlMjAlM0QlMjBxdWFudGl6ZXIuZ2V0X2NhbGlicmF0aW9uX2RhdGFzZXQoJTBBJTIwJTIwJTIwJTIwJTIyZ2x1ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGRhdGFzZXRfY29uZmlnX25hbWUlM0QlMjJzc3QyJTIyJTJDJTBBJTIwJTIwJTIwJTIwcHJlcHJvY2Vzc19mdW5jdGlvbiUzRHBhcnRpYWwocHJlcHJvY2Vzc19mbiUyQyUyMHRva2VuaXplciUzRHRva2VuaXplciklMkMlMEElMjAlMjAlMjAlMjBudW1fc2FtcGxlcyUzRDUwJTJDJTBBJTIwJTIwJTIwJTIwZGF0YXNldF9zcGxpdCUzRCUyMnRyYWluJTIyJTJDJTBBKSUwQSUwQWNhbGlicmF0aW9uX2NvbmZpZyUyMCUzRCUyMEF1dG9DYWxpYnJhdGlvbkNvbmZpZy5taW5tYXgoY2FsaWJyYXRpb25fZGF0YXNldCklMEElMEFyYW5nZXMlMjAlM0QlMjBxdWFudGl6ZXIuZml0KCUwQSUyMCUyMCUyMCUyMGRhdGFzZXQlM0RjYWxpYnJhdGlvbl9kYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwY2FsaWJyYXRpb25fY29uZmlnJTNEY2FsaWJyYXRpb25fY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwb3BlcmF0b3JzX3RvX3F1YW50aXplJTNEcWNvbmZpZy5vcGVyYXRvcnNfdG9fcXVhbnRpemUlMkMlMEEpJTBBJTBBbW9kZWxfcXVhbnRpemVkX3BhdGglMjAlM0QlMjBxdWFudGl6ZXIucXVhbnRpemUoJTBBJTIwJTIwJTIwJTIwc2F2ZV9kaXIlM0QlMjJwYXRoJTJGdG8lMkZvdXRwdXQlMkZtb2RlbCUyMiUyQyUwQSUyMCUyMCUyMCUyMGNhbGlicmF0aW9uX3RlbnNvcnNfcmFuZ2UlM0RyYW5nZXMlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcWNvbmZpZyUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> functools <span class="hljs-keyword">import</span> partial
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTQuantizer, ORTModelForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime.configuration <span class="hljs-keyword">import</span> AutoQuantizationConfig, AutoCalibrationConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>

<span class="hljs-comment"># Load PyTorch model and convert to ONNX and create Quantizer and setup config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_model = ORTModelForSequenceClassification.from_pretrained(model_id, export=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(model_id)
<span class="hljs-meta">&gt;&gt;&gt; </span>quantizer = ORTQuantizer.from_pretrained(onnx_model)
<span class="hljs-meta">&gt;&gt;&gt; </span>qconfig = AutoQuantizationConfig.arm64(is_static=<span class="hljs-literal">True</span>, per_channel=<span class="hljs-literal">False</span>)

<span class="hljs-comment"># Create the calibration dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_fn</span>(<span class="hljs-params">ex, tokenizer</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> tokenizer(ex[<span class="hljs-string">&quot;sentence&quot;</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>calibration_dataset = quantizer.get_calibration_dataset(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;glue&quot;</span>,
<span class="hljs-meta">... </span>    dataset_config_name=<span class="hljs-string">&quot;sst2&quot;</span>,
<span class="hljs-meta">... </span>    preprocess_function=partial(preprocess_fn, tokenizer=tokenizer),
<span class="hljs-meta">... </span>    num_samples=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    dataset_split=<span class="hljs-string">&quot;train&quot;</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-comment"># Create the calibration configuration containing the parameters related to calibration.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>calibration_config = AutoCalibrationConfig.minmax(calibration_dataset)

<span class="hljs-comment"># Perform the calibration step: computes the activations quantization ranges</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>ranges = quantizer.fit(
<span class="hljs-meta">... </span>    dataset=calibration_dataset,
<span class="hljs-meta">... </span>    calibration_config=calibration_config,
<span class="hljs-meta">... </span>    operators_to_quantize=qconfig.operators_to_quantize,
<span class="hljs-meta">... </span>)

<span class="hljs-comment"># Apply static quantization on the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_quantized_path = quantizer.quantize(
<span class="hljs-meta">... </span>    save_dir=<span class="hljs-string">&quot;path/to/output/model&quot;</span>,
<span class="hljs-meta">... </span>    calibration_tensors_range=ranges,
<span class="hljs-meta">... </span>    quantization_config=qconfig,
<span class="hljs-meta">... </span>)`,wrap:!1}}),E=new K({props:{title:"Quantize Seq2Seq models",local:"quantize-seq2seq-models",headingTag:"h2"}}),J=new Dt({props:{warning:!0,$$slots:{default:[oe]},$$scope:{ctx:D}}}),H=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRRdWFudGl6ZXIlMkMlMjBPUlRNb2RlbEZvclNlcTJTZXFMTSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lLmNvbmZpZ3VyYXRpb24lMjBpbXBvcnQlMjBBdXRvUXVhbnRpemF0aW9uQ29uZmlnJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJvcHRpbXVtJTJGdDUtc21hbGwlMjIlMEFvbm54X21vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JTZXEyU2VxTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQW1vZGVsX2RpciUyMCUzRCUyMG9ubnhfbW9kZWwubW9kZWxfc2F2ZV9kaXI=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTQuantizer, ORTModelForSeq2SeqLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime.configuration <span class="hljs-keyword">import</span> AutoQuantizationConfig

<span class="hljs-comment"># load Seq2Seq model and set model file directory</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;optimum/t5-small&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_model = ORTModelForSeq2SeqLM.from_pretrained(model_id)
<span class="hljs-meta">&gt;&gt;&gt; </span>model_dir = onnx_model.model_save_dir`,wrap:!1}}),O=new b({props:{code:"ZW5jb2Rlcl9xdWFudGl6ZXIlMjAlM0QlMjBPUlRRdWFudGl6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2RpciUyQyUyMGZpbGVfbmFtZSUzRCUyMmVuY29kZXJfbW9kZWwub25ueCUyMiklMEElMEFkZWNvZGVyX3F1YW50aXplciUyMCUzRCUyME9SVFF1YW50aXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfZGlyJTJDJTIwZmlsZV9uYW1lJTNEJTIyZGVjb2Rlcl9tb2RlbC5vbm54JTIyKSUwQSUwQWRlY29kZXJfd3BfcXVhbnRpemVyJTIwJTNEJTIwT1JUUXVhbnRpemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9kaXIlMkMlMjBmaWxlX25hbWUlM0QlMjJkZWNvZGVyX3dpdGhfcGFzdF9tb2RlbC5vbm54JTIyKSUwQSUwQXF1YW50aXplciUyMCUzRCUyMCU1QmVuY29kZXJfcXVhbnRpemVyJTJDJTIwZGVjb2Rlcl9xdWFudGl6ZXIlMkMlMjBkZWNvZGVyX3dwX3F1YW50aXplciU1RA==",highlighted:`<span class="hljs-comment"># Create encoder quantizer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_quantizer = ORTQuantizer.from_pretrained(model_dir, file_name=<span class="hljs-string">&quot;encoder_model.onnx&quot;</span>)

<span class="hljs-comment"># Create decoder quantizer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_quantizer = ORTQuantizer.from_pretrained(model_dir, file_name=<span class="hljs-string">&quot;decoder_model.onnx&quot;</span>)

<span class="hljs-comment"># Create decoder with past key values quantizer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_wp_quantizer = ORTQuantizer.from_pretrained(model_dir, file_name=<span class="hljs-string">&quot;decoder_with_past_model.onnx&quot;</span>)

<span class="hljs-comment"># Create Quantizer list</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>quantizer = [encoder_quantizer, decoder_quantizer, decoder_wp_quantizer]`,wrap:!1}}),L=new b({props:{code:"ZHFjb25maWclMjAlM0QlMjBBdXRvUXVhbnRpemF0aW9uQ29uZmlnLmF2eDUxMl92bm5pKGlzX3N0YXRpYyUzREZhbHNlJTJDJTIwcGVyX2NoYW5uZWwlM0RGYWxzZSklMEElMEFmb3IlMjBxJTIwaW4lMjBxdWFudGl6ZXIlM0ElMEElMjAlMjAlMjAlMjBxLnF1YW50aXplKHNhdmVfZGlyJTNEJTIyLiUyMiUyQ3F1YW50aXphdGlvbl9jb25maWclM0RkcWNvbmZpZyklMjAlMjAlMjMlMjBkb2N0ZXN0JTNBJTIwJTJCSUdOT1JFX1JFU1VMVA==",highlighted:`<span class="hljs-comment"># Define the quantization strategy by creating the appropriate configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dqconfig = AutoQuantizationConfig.avx512_vnni(is_static=<span class="hljs-literal">False</span>, per_channel=<span class="hljs-literal">False</span>)

<span class="hljs-comment"># Quantize the models individually</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> q <span class="hljs-keyword">in</span> quantizer:
<span class="hljs-meta">... </span>    q.quantize(save_dir=<span class="hljs-string">&quot;.&quot;</span>,quantization_config=dqconfig)  <span class="hljs-comment"># doctest: +IGNORE_RESULT</span>`,wrap:!1}}),P=new ie({props:{source:"https://github.com/huggingface/optimum/blob/main/docs/source/onnxruntime/usage_guides/quantization.mdx"}}),{c(){i=p("meta"),T=n(),h=p("p"),j=n(),m(R.$$.fragment),lt=n(),C=p("p"),C.innerHTML=Ft,at=n(),Z=p("p"),Z.innerHTML=$t,nt=n(),m(U.$$.fragment),st=n(),m(W.$$.fragment),it=n(),X=p("p"),X.textContent=Qt,pt=n(),m(z.$$.fragment),ot=n(),I=p("p"),I.textContent=qt,mt=n(),m(v.$$.fragment),ut=n(),G=p("p"),G.innerHTML=Bt,rt=n(),m(_.$$.fragment),ct=n(),F=p("p"),F.innerHTML=Vt,Mt=n(),$=p("ol"),$.innerHTML=kt,dt=n(),m(Q.$$.fragment),ht=n(),w=p("ol"),w.innerHTML=xt,yt=n(),m(q.$$.fragment),Tt=n(),m(B.$$.fragment),bt=n(),V=p("p"),V.innerHTML=Nt,jt=n(),m(k.$$.fragment),Ut=n(),m(x.$$.fragment),wt=n(),N=p("p"),N.innerHTML=At,Jt=n(),m(A.$$.fragment),ft=n(),m(E.$$.fragment),gt=n(),S=p("p"),S.innerHTML=Et,Rt=n(),m(J.$$.fragment),Ct=n(),Y=p("ol"),Y.innerHTML=St,Zt=n(),m(H.$$.fragment),Wt=n(),f=p("ol"),f.innerHTML=Yt,Xt=n(),m(O.$$.fragment),zt=n(),g=p("ol"),g.innerHTML=Ht,It=n(),m(L.$$.fragment),vt=n(),m(P.$$.fragment),Gt=n(),tt=p("p"),this.h()},l(t){const e=ne("svelte-u9bgzb",document.head);i=o(e,"META",{name:!0,content:!0}),e.forEach(l),T=s(t),h=o(t,"P",{}),Pt(h).forEach(l),j=s(t),u(R.$$.fragment,t),lt=s(t),C=o(t,"P",{"data-svelte-h":!0}),y(C)!=="svelte-wazzwm"&&(C.innerHTML=Ft),at=s(t),Z=o(t,"P",{"data-svelte-h":!0}),y(Z)!=="svelte-1y2zkz4"&&(Z.innerHTML=$t),nt=s(t),u(U.$$.fragment,t),st=s(t),u(W.$$.fragment,t),it=s(t),X=o(t,"P",{"data-svelte-h":!0}),y(X)!=="svelte-rew7gv"&&(X.textContent=Qt),pt=s(t),u(z.$$.fragment,t),ot=s(t),I=o(t,"P",{"data-svelte-h":!0}),y(I)!=="svelte-7tptkq"&&(I.textContent=qt),mt=s(t),u(v.$$.fragment,t),ut=s(t),G=o(t,"P",{"data-svelte-h":!0}),y(G)!=="svelte-q209i"&&(G.innerHTML=Bt),rt=s(t),u(_.$$.fragment,t),ct=s(t),F=o(t,"P",{"data-svelte-h":!0}),y(F)!=="svelte-dgmf0a"&&(F.innerHTML=Vt),Mt=s(t),$=o(t,"OL",{"data-svelte-h":!0}),y($)!=="svelte-prnl7i"&&($.innerHTML=kt),dt=s(t),u(Q.$$.fragment,t),ht=s(t),w=o(t,"OL",{start:!0,"data-svelte-h":!0}),y(w)!=="svelte-s0fljy"&&(w.innerHTML=xt),yt=s(t),u(q.$$.fragment,t),Tt=s(t),u(B.$$.fragment,t),bt=s(t),V=o(t,"P",{"data-svelte-h":!0}),y(V)!=="svelte-43zpeb"&&(V.innerHTML=Nt),jt=s(t),u(k.$$.fragment,t),Ut=s(t),u(x.$$.fragment,t),wt=s(t),N=o(t,"P",{"data-svelte-h":!0}),y(N)!=="svelte-g1rlov"&&(N.innerHTML=At),Jt=s(t),u(A.$$.fragment,t),ft=s(t),u(E.$$.fragment,t),gt=s(t),S=o(t,"P",{"data-svelte-h":!0}),y(S)!=="svelte-oz6aqr"&&(S.innerHTML=Et),Rt=s(t),u(J.$$.fragment,t),Ct=s(t),Y=o(t,"OL",{"data-svelte-h":!0}),y(Y)!=="svelte-o17da9"&&(Y.innerHTML=St),Zt=s(t),u(H.$$.fragment,t),Wt=s(t),f=o(t,"OL",{start:!0,"data-svelte-h":!0}),y(f)!=="svelte-vmrglm"&&(f.innerHTML=Yt),Xt=s(t),u(O.$$.fragment,t),zt=s(t),g=o(t,"OL",{start:!0,"data-svelte-h":!0}),y(g)!=="svelte-1lobl21"&&(g.innerHTML=Ht),It=s(t),u(L.$$.fragment,t),vt=s(t),u(P.$$.fragment,t),Gt=s(t),tt=o(t,"P",{}),Pt(tt).forEach(l),this.h()},h(){et(i,"name","hf:doc:metadata"),et(i,"content",ue),et(w,"start","2"),et(f,"start","2"),et(g,"start","3")},m(t,e){se(document.head,i),a(t,T,e),a(t,h,e),a(t,j,e),r(R,t,e),a(t,lt,e),a(t,C,e),a(t,at,e),a(t,Z,e),a(t,nt,e),r(U,t,e),a(t,st,e),r(W,t,e),a(t,it,e),a(t,X,e),a(t,pt,e),r(z,t,e),a(t,ot,e),a(t,I,e),a(t,mt,e),r(v,t,e),a(t,ut,e),a(t,G,e),a(t,rt,e),r(_,t,e),a(t,ct,e),a(t,F,e),a(t,Mt,e),a(t,$,e),a(t,dt,e),r(Q,t,e),a(t,ht,e),a(t,w,e),a(t,yt,e),r(q,t,e),a(t,Tt,e),r(B,t,e),a(t,bt,e),a(t,V,e),a(t,jt,e),r(k,t,e),a(t,Ut,e),r(x,t,e),a(t,wt,e),a(t,N,e),a(t,Jt,e),r(A,t,e),a(t,ft,e),r(E,t,e),a(t,gt,e),a(t,S,e),a(t,Rt,e),r(J,t,e),a(t,Ct,e),a(t,Y,e),a(t,Zt,e),r(H,t,e),a(t,Wt,e),a(t,f,e),a(t,Xt,e),r(O,t,e),a(t,zt,e),a(t,g,e),a(t,It,e),r(L,t,e),a(t,vt,e),r(P,t,e),a(t,Gt,e),a(t,tt,e),_t=!0},p(t,[e]){const Ot={};e&2&&(Ot.$$scope={dirty:e,ctx:t}),U.$set(Ot);const Lt={};e&2&&(Lt.$$scope={dirty:e,ctx:t}),J.$set(Lt)},i(t){_t||(c(R.$$.fragment,t),c(U.$$.fragment,t),c(W.$$.fragment,t),c(z.$$.fragment,t),c(v.$$.fragment,t),c(_.$$.fragment,t),c(Q.$$.fragment,t),c(q.$$.fragment,t),c(B.$$.fragment,t),c(k.$$.fragment,t),c(x.$$.fragment,t),c(A.$$.fragment,t),c(E.$$.fragment,t),c(J.$$.fragment,t),c(H.$$.fragment,t),c(O.$$.fragment,t),c(L.$$.fragment,t),c(P.$$.fragment,t),_t=!0)},o(t){M(R.$$.fragment,t),M(U.$$.fragment,t),M(W.$$.fragment,t),M(z.$$.fragment,t),M(v.$$.fragment,t),M(_.$$.fragment,t),M(Q.$$.fragment,t),M(q.$$.fragment,t),M(B.$$.fragment,t),M(k.$$.fragment,t),M(x.$$.fragment,t),M(A.$$.fragment,t),M(E.$$.fragment,t),M(J.$$.fragment,t),M(H.$$.fragment,t),M(O.$$.fragment,t),M(L.$$.fragment,t),M(P.$$.fragment,t),_t=!1},d(t){t&&(l(T),l(h),l(j),l(lt),l(C),l(at),l(Z),l(nt),l(st),l(it),l(X),l(pt),l(ot),l(I),l(mt),l(ut),l(G),l(rt),l(ct),l(F),l(Mt),l($),l(dt),l(ht),l(w),l(yt),l(Tt),l(bt),l(V),l(jt),l(Ut),l(wt),l(N),l(Jt),l(ft),l(gt),l(S),l(Rt),l(Ct),l(Y),l(Zt),l(Wt),l(f),l(Xt),l(zt),l(g),l(It),l(vt),l(Gt),l(tt)),l(i),d(R,t),d(U,t),d(W,t),d(z,t),d(v,t),d(_,t),d(Q,t),d(q,t),d(B,t),d(k,t),d(x,t),d(A,t),d(E,t),d(J,t),d(H,t),d(O,t),d(L,t),d(P,t)}}}const ue='{"title":"Quantization","local":"quantization","sections":[{"title":"Quantizing a model to be used with Optimum’s CLI","local":"quantizing-a-model-to-be-used-with-optimums-cli","sections":[],"depth":2},{"title":"Creating an ORTQuantizer","local":"creating-an-ortquantizer","sections":[],"depth":2},{"title":"Apply Dynamic Quantization","local":"apply-dynamic-quantization","sections":[],"depth":2},{"title":"Static Quantization example","local":"static-quantization-example","sections":[],"depth":2},{"title":"Quantize Seq2Seq models","local":"quantize-seq2seq-models","sections":[],"depth":2}],"depth":1}';function re(D){return ee(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Te extends le{constructor(i){super(),ae(this,i,re,me,te,{})}}export{Te as component};
