import{s as il,f as we,n as ol,o as pl}from"../chunks/scheduler.f6b352c8.js";import{S as rl,i as yl,g as M,s as n,r as y,A as ml,h as i,f as l,c as a,j as de,u as m,x as o,k as r,y as cl,a as s,v as c,d as u,t as j,w as U}from"../chunks/index.7f38e934.js";import{C as he}from"../chunks/CodeBlock.2a338b68.js";import{H as jt}from"../chunks/Heading.333929c4.js";import{E as ul}from"../chunks/EditOnGithub.c3245a01.js";function jl(be){let h,Ut,ct,ht,w,wt,d,Te="In the last section, we learned how we can create Agents from scratch using Python code, and we <strong>saw just how tedious that process can be</strong>. Fortunately, many Agent libraries simplify this work by <strong>handling much of the heavy lifting for you</strong>.",dt,b,ge="In this tutorial, <strong>you’ll create your very first Agent</strong> capable of performing actions such as image generation, web search, time zone checking and much more!",bt,T,Ce="You will also publish your agent <strong>on a Hugging Face Space so you can share it with friends and colleagues</strong>.",Tt,g,Je="Let’s get started!",gt,C,Ct,J,fe,Jt,f,Ie="To make this Agent, we’re going to use <code>smolagents</code>, a library that <strong>provides a framework for developing your agents with ease</strong>.",ft,I,ve="This lightweight library is designed for simplicity, but it abstracts away much of the complexity of building an Agent, allowing you to focus on designing your agent’s behavior.",It,v,Be='We’re going to get deeper into smolagents in the next Unit. Meanwhile, you can also check this <a href="https://huggingface.co/blog/smolagents" target="_blank">blog post</a> or the library’s <a href="https://github.com/huggingface/smolagents" target="_blank">repo in GitHub</a>.',vt,B,Ae="In short, smolagents is a library that focuses on <strong>codeAgent</strong>, a kind of agent that performs <strong>“Actions”</strong> through code blocks, and then <strong>“Observes”</strong> results by executing the code.",Bt,A,Ze="Here is an example of what we’ll build!",At,Z,We="We provided our agent with an <strong>Image generation tool</strong> and asked it to generate an image of a cat.",Zt,W,Ee="The agent inside smolagents is going to have the <strong>same behaviors as the custom one we built previously</strong>: it’s going <strong>to think, act and observe in cycle</strong> until it reaches a final answer:",Wt,p,Ge,Et,E,He="Exciting, right?",Gt,G,Ht,H,_e='To start, duplicate this Space: <a href="https://huggingface.co/spaces/agents-course/First_agent_template" target="_blank">https://huggingface.co/spaces/agents-course/First_agent_template</a>',_t,_,ke='<p>Thanks to <a href="https://huggingface.co/spaces/m-ric" target="_blank">Aymeric</a> for this template! 🙌</p>',kt,k,xe="Duplicating this space means <strong>creating a local copy on your own profile</strong>:",xt,x,Qe,Qt,Q,Re='Throughout this lesson, the only file you will need to modify is the (currently incomplete) ”<strong>app.py</strong>”. You can see here the <a href="https://huggingface.co/spaces/agents-course/First_agent_template/blob/main/app.py" rel="nofollow">original one in the template</a>. To find yours, go to your copy of the space, then click the <code>Files</code> tab and then on <code>app.py</code> in the directory listing.',Rt,R,Se="Let’s break down the code together:",St,S,ze="<li>The file begins with some simple but necessary library imports</li>",zt,z,Xt,X,Xe="As outlined earlier, we will directly use the <strong>CodeAgent</strong> class from <strong>smolagents</strong>.",Ft,F,Nt,N,Fe='Now let’s get into the tools! If you want a refresher about tools, don’t hesitate to go back to the <a href="tools">Tools</a> section of the course.',Vt,V,$t,$,Ne="The Tools are what we are encouraging you to build in this section! We give you two examples:",Lt,L,Ve="<li>A <strong>non-working dummy Tool</strong> that you can modify to make something useful.</li> <li>An <strong>actually working Tool</strong> that gets the current time somewhere in the world.</li>",Yt,Y,$e="To define your tool it is important to:",qt,q,Le="<li>Provide input and output types for your function, like in <code>get_current_time_in_timezone(timezone: str) -&gt; str:</code></li> <li><strong>A well formatted docstring</strong>. <code>smolagents</code> is expecting all the arguments to have a <strong>textual description in the docstring</strong>.</li>",Pt,P,Kt,K,Ye='It uses <a href="https://huggingface.co/Qwen/Qwen2.5-Coder-32B-Instruct" rel="nofollow"><code>Qwen/Qwen2.5-Coder-32B-Instruct</code></a> as the LLM engine. This is a very capable model that we’ll access via the serverless API.',Dt,D,Ot,O,qe="This Agent still uses the <code>InferenceClient</code> we saw in an earlier section behind the <strong>HfApiModel</strong> class!",te,tt,Pe="We will give more in-depth examples when we present the framework in Unit 2. For now, you need to focus on <strong>adding new tools to the list of tools</strong> using the <strong>tools</strong> parameter of your Agent.",ee,et,Ke="For example, you could use the <code>DuckDuckGoSearchTool</code> that was imported in the first line of the code, or you can examine the <code>image_generation_tool</code> that is loaded from the Hub later in the code.",le,lt,De="<strong>Adding tools will give your agent new capabilities</strong>, try to be creative here!",se,st,Oe="The complete “app.py”:",ne,nt,ae,at,tl="Your <strong>Goal</strong> is to get familiar with the Space and the Agent.",Me,Mt,el="Currently, the agent in the template <strong>does not use any tools, so try to provide it with some of the pre-made ones or even make some new tools yourself</strong>!",ie,it,ll="We are eagerly waiting for your amazing agents output in the discord channel <strong>#agents-course-showcase</strong>!",oe,pe,re,ot,sl="Congratulations, you’ve built your first Agent! Don’t hesitate to share it with your friends and colleagues.",ye,pt,nl="Since this is your first try, it’s perfectly normal if it’s a little buggy or slow. In future units, we’ll learn how to build even better Agents.",me,rt,al="The best way to learn is to try, so don’t hesitate to update it, add more tools, try with another model, etc.",ce,yt,Ml="In the next section, you’re going to fill the final Quiz and get your certificate!",ue,mt,je,ut,Ue;return w=new jt({props:{title:"Let’s Create Our First Agent Using smolagents",local:"lets-create-our-first-agent-using-smolagents",headingTag:"h1"}}),C=new jt({props:{title:"What is smolagents?",local:"what-is-smolagents",headingTag:"h2"}}),G=new jt({props:{title:"Let’s build our Agent!",local:"lets-build-our-agent",headingTag:"h2"}}),z=new he({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBEdWNrRHVja0dvU2VhcmNoVG9vbCUyQyUyMEhmQXBpTW9kZWwlMkMlMjBsb2FkX3Rvb2wlMkMlMjB0b29sJTBBaW1wb3J0JTIwZGF0ZXRpbWUlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWltcG9ydCUyMHB5dHolMEFpbXBvcnQlMjB5YW1sJTBBZnJvbSUyMHRvb2xzLmZpbmFsX2Fuc3dlciUyMGltcG9ydCUyMEZpbmFsQW5zd2VyVG9vbA==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, DuckDuckGoSearchTool, HfApiModel, load_tool, tool
<span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> pytz
<span class="hljs-keyword">import</span> yaml
<span class="hljs-keyword">from</span> tools.final_answer <span class="hljs-keyword">import</span> FinalAnswerTool`,wrap:!1}}),F=new jt({props:{title:"The Tools",local:"the-tools",headingTag:"h3"}}),V=new he({props:{code:"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",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">my_custom_tool</span>(<span class="hljs-params">arg1:<span class="hljs-built_in">str</span>, arg2:<span class="hljs-built_in">int</span></span>)-&gt; <span class="hljs-built_in">str</span>: <span class="hljs-comment">#it&#x27;s import to specify the return type</span>
    <span class="hljs-comment">#Keep this format for the description / args / args description but feel free to modify the tool</span>
    <span class="hljs-string">&quot;&quot;&quot;A tool that does nothing yet 
    Args:
        arg1: the first argument
        arg2: the second argument
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;What magic will you build ?&quot;</span>

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_time_in_timezone</span>(<span class="hljs-params">timezone: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;A tool that fetches the current local time in a specified timezone.
    Args:
        timezone: A string representing a valid timezone (e.g., &#x27;America/New_York&#x27;).
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Create timezone object</span>
        tz = pytz.timezone(timezone)
        <span class="hljs-comment"># Get current time in that timezone</span>
        local_time = datetime.datetime.now(tz).strftime(<span class="hljs-string">&quot;%Y-%m-%d %H:%M:%S&quot;</span>)
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;The current local time in <span class="hljs-subst">{timezone}</span> is: <span class="hljs-subst">{local_time}</span>&quot;</span>
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error fetching time for timezone &#x27;<span class="hljs-subst">{timezone}</span>&#x27;: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>`,wrap:!1}}),P=new jt({props:{title:"The Agent",local:"the-agent",headingTag:"h3"}}),D=new he({props:{code:"ZmluYWxfYW5zd2VyJTIwJTNEJTIwRmluYWxBbnN3ZXJUb29sKCklMEFtb2RlbCUyMCUzRCUyMEhmQXBpTW9kZWwoJTBBJTIwJTIwJTIwJTIwbWF4X3Rva2VucyUzRDIwOTYlMkMlMEElMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzRDAuNSUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTNEJ1F3ZW4lMkZRd2VuMi41LUNvZGVyLTMyQi1JbnN0cnVjdCclMkMlMEElMjAlMjAlMjAlMjBjdXN0b21fcm9sZV9jb252ZXJzaW9ucyUzRE5vbmUlMkMlMEEpJTBBJTBBd2l0aCUyMG9wZW4oJTIycHJvbXB0cy55YW1sJTIyJTJDJTIwJ3InKSUyMGFzJTIwc3RyZWFtJTNBJTBBJTIwJTIwJTIwJTIwcHJvbXB0X3RlbXBsYXRlcyUyMCUzRCUyMHlhbWwuc2FmZV9sb2FkKHN0cmVhbSklMEElMjAlMjAlMjAlMjAlMEElMjMlMjBXZSdyZSUyMGNyZWF0aW5nJTIwb3VyJTIwQ29kZUFnZW50JTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCZmluYWxfYW5zd2VyJTVEJTJDJTIwJTIzJTIzJTIwYWRkJTIweW91ciUyMHRvb2xzJTIwaGVyZSUyMChkb24ndCUyMHJlbW92ZSUyMGZpbmFsJTIwYW5zd2VyKSUwQSUyMCUyMCUyMCUyMG1heF9zdGVwcyUzRDYlMkMlMEElMjAlMjAlMjAlMjB2ZXJib3NpdHlfbGV2ZWwlM0QxJTJDJTBBJTIwJTIwJTIwJTIwZ3JhbW1hciUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjBwbGFubmluZ19pbnRlcnZhbCUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjBuYW1lJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMGRlc2NyaXB0aW9uJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMHByb21wdF90ZW1wbGF0ZXMlM0Rwcm9tcHRfdGVtcGxhdGVzJTBBKSUwQSUwQUdyYWRpb1VJKGFnZW50KS5sYXVuY2goKQ==",highlighted:`final_answer = FinalAnswerTool()
model = HfApiModel(
    max_tokens=<span class="hljs-number">2096</span>,
    temperature=<span class="hljs-number">0.5</span>,
    model_id=<span class="hljs-string">&#x27;Qwen/Qwen2.5-Coder-32B-Instruct&#x27;</span>,
    custom_role_conversions=<span class="hljs-literal">None</span>,
)

<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;prompts.yaml&quot;</span>, <span class="hljs-string">&#x27;r&#x27;</span>) <span class="hljs-keyword">as</span> stream:
    prompt_templates = yaml.safe_load(stream)
    
<span class="hljs-comment"># We&#x27;re creating our CodeAgent</span>
agent = CodeAgent(
    model=model,
    tools=[final_answer], <span class="hljs-comment">## add your tools here (don&#x27;t remove final answer)</span>
    max_steps=<span class="hljs-number">6</span>,
    verbosity_level=<span class="hljs-number">1</span>,
    grammar=<span class="hljs-literal">None</span>,
    planning_interval=<span class="hljs-literal">None</span>,
    name=<span class="hljs-literal">None</span>,
    description=<span class="hljs-literal">None</span>,
    prompt_templates=prompt_templates
)

GradioUI(agent).launch()`,wrap:!1}}),nt=new he({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, DuckDuckGoSearchTool, HfApiModel, load_tool, tool
<span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> pytz
<span class="hljs-keyword">import</span> yaml
<span class="hljs-keyword">from</span> tools.final_answer <span class="hljs-keyword">import</span> FinalAnswerTool

<span class="hljs-keyword">from</span> Gradio_UI <span class="hljs-keyword">import</span> GradioUI

<span class="hljs-comment"># Below is an example of a tool that does nothing. Amaze us with your creativity !</span>
<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">my_custom_tool</span>(<span class="hljs-params">arg1:<span class="hljs-built_in">str</span>, arg2:<span class="hljs-built_in">int</span></span>)-&gt; <span class="hljs-built_in">str</span>: <span class="hljs-comment">#it&#x27;s import to specify the return type</span>
    <span class="hljs-comment">#Keep this format for the description / args / args description but feel free to modify the tool</span>
    <span class="hljs-string">&quot;&quot;&quot;A tool that does nothing yet 
    Args:
        arg1: the first argument
        arg2: the second argument
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;What magic will you build ?&quot;</span>

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_time_in_timezone</span>(<span class="hljs-params">timezone: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;A tool that fetches the current local time in a specified timezone.
    Args:
        timezone: A string representing a valid timezone (e.g., &#x27;America/New_York&#x27;).
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Create timezone object</span>
        tz = pytz.timezone(timezone)
        <span class="hljs-comment"># Get current time in that timezone</span>
        local_time = datetime.datetime.now(tz).strftime(<span class="hljs-string">&quot;%Y-%m-%d %H:%M:%S&quot;</span>)
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;The current local time in <span class="hljs-subst">{timezone}</span> is: <span class="hljs-subst">{local_time}</span>&quot;</span>
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error fetching time for timezone &#x27;<span class="hljs-subst">{timezone}</span>&#x27;: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>


final_answer = FinalAnswerTool()
model = HfApiModel(
max_tokens=<span class="hljs-number">2096</span>,
temperature=<span class="hljs-number">0.5</span>,
model_id=<span class="hljs-string">&#x27;Qwen/Qwen2.5-Coder-32B-Instruct&#x27;</span>,
custom_role_conversions=<span class="hljs-literal">None</span>,
)


<span class="hljs-comment"># Import tool from Hub</span>
image_generation_tool = load_tool(<span class="hljs-string">&quot;agents-course/text-to-image&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)

<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;prompts.yaml&quot;</span>, <span class="hljs-string">&#x27;r&#x27;</span>) <span class="hljs-keyword">as</span> stream:
    prompt_templates = yaml.safe_load(stream)
    
agent = CodeAgent(
    model=model,
    tools=[final_answer], <span class="hljs-comment">## add your tools here (don&#x27;t remove final answer)</span>
    max_steps=<span class="hljs-number">6</span>,
    verbosity_level=<span class="hljs-number">1</span>,
    grammar=<span class="hljs-literal">None</span>,
    planning_interval=<span class="hljs-literal">None</span>,
    name=<span class="hljs-literal">None</span>,
    description=<span class="hljs-literal">None</span>,
    prompt_templates=prompt_templates
)


GradioUI(agent).launch()`,wrap:!1}}),mt=new ul({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit1/tutorial.mdx"}}),{c(){h=M("meta"),Ut=n(),ct=M("p"),ht=n(),y(w.$$.fragment),wt=n(),d=M("p"),d.innerHTML=Te,dt=n(),b=M("p"),b.innerHTML=ge,bt=n(),T=M("p"),T.innerHTML=Ce,Tt=n(),g=M("p"),g.textContent=Je,gt=n(),y(C.$$.fragment),Ct=n(),J=M("img"),Jt=n(),f=M("p"),f.innerHTML=Ie,ft=n(),I=M("p"),I.textContent=ve,It=n(),v=M("p"),v.innerHTML=Be,vt=n(),B=M("p"),B.innerHTML=Ae,Bt=n(),A=M("p"),A.textContent=Ze,At=n(),Z=M("p"),Z.innerHTML=We,Zt=n(),W=M("p"),W.innerHTML=Ee,Wt=n(),p=M("iframe"),Et=n(),E=M("p"),E.textContent=He,Gt=n(),y(G.$$.fragment),Ht=n(),H=M("p"),H.innerHTML=_e,_t=n(),_=M("blockquote"),_.innerHTML=ke,kt=n(),k=M("p"),k.innerHTML=xe,xt=n(),x=M("img"),Qt=n(),Q=M("p"),Q.innerHTML=Re,Rt=n(),R=M("p"),R.textContent=Se,St=n(),S=M("ul"),S.innerHTML=ze,zt=n(),y(z.$$.fragment),Xt=n(),X=M("p"),X.innerHTML=Xe,Ft=n(),y(F.$$.fragment),Nt=n(),N=M("p"),N.innerHTML=Fe,Vt=n(),y(V.$$.fragment),$t=n(),$=M("p"),$.textContent=Ne,Lt=n(),L=M("ol"),L.innerHTML=Ve,Yt=n(),Y=M("p"),Y.textContent=$e,qt=n(),q=M("ol"),q.innerHTML=Le,Pt=n(),y(P.$$.fragment),Kt=n(),K=M("p"),K.innerHTML=Ye,Dt=n(),y(D.$$.fragment),Ot=n(),O=M("p"),O.innerHTML=qe,te=n(),tt=M("p"),tt.innerHTML=Pe,ee=n(),et=M("p"),et.innerHTML=Ke,le=n(),lt=M("p"),lt.innerHTML=De,se=n(),st=M("p"),st.textContent=Oe,ne=n(),y(nt.$$.fragment),ae=n(),at=M("p"),at.innerHTML=tl,Me=n(),Mt=M("p"),Mt.innerHTML=el,ie=n(),it=M("p"),it.innerHTML=ll,oe=n(),pe=M("hr"),re=n(),ot=M("p"),ot.textContent=sl,ye=n(),pt=M("p"),pt.textContent=nl,me=n(),rt=M("p"),rt.textContent=al,ce=n(),yt=M("p"),yt.textContent=Ml,ue=n(),y(mt.$$.fragment),je=n(),ut=M("p"),this.h()},l(t){const e=ml("svelte-u9bgzb",document.head);h=i(e,"META",{name:!0,content:!0}),e.forEach(l),Ut=a(t),ct=i(t,"P",{}),de(ct).forEach(l),ht=a(t),m(w.$$.fragment,t),wt=a(t),d=i(t,"P",{"data-svelte-h":!0}),o(d)!=="svelte-gmmoh4"&&(d.innerHTML=Te),dt=a(t),b=i(t,"P",{"data-svelte-h":!0}),o(b)!=="svelte-isl0ka"&&(b.innerHTML=ge),bt=a(t),T=i(t,"P",{"data-svelte-h":!0}),o(T)!=="svelte-zy1mev"&&(T.innerHTML=Ce),Tt=a(t),g=i(t,"P",{"data-svelte-h":!0}),o(g)!=="svelte-4b3xjd"&&(g.textContent=Je),gt=a(t),m(C.$$.fragment,t),Ct=a(t),J=i(t,"IMG",{src:!0,alt:!0}),Jt=a(t),f=i(t,"P",{"data-svelte-h":!0}),o(f)!=="svelte-1bet7no"&&(f.innerHTML=Ie),ft=a(t),I=i(t,"P",{"data-svelte-h":!0}),o(I)!=="svelte-oceeap"&&(I.textContent=ve),It=a(t),v=i(t,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1wfbi7x"&&(v.innerHTML=Be),vt=a(t),B=i(t,"P",{"data-svelte-h":!0}),o(B)!=="svelte-u2ce04"&&(B.innerHTML=Ae),Bt=a(t),A=i(t,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1x3dozw"&&(A.textContent=Ze),At=a(t),Z=i(t,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1kwa3nr"&&(Z.innerHTML=We),Zt=a(t),W=i(t,"P",{"data-svelte-h":!0}),o(W)!=="svelte-rc0irz"&&(W.innerHTML=Ee),Wt=a(t),p=i(t,"IFRAME",{width:!0,height:!0,src:!0,title:!0,frameborder:!0,allow:!0,referrerpolicy:!0}),de(p).forEach(l),Et=a(t),E=i(t,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1riubhm"&&(E.textContent=He),Gt=a(t),m(G.$$.fragment,t),Ht=a(t),H=i(t,"P",{"data-svelte-h":!0}),o(H)!=="svelte-3pukde"&&(H.innerHTML=_e),_t=a(t),_=i(t,"BLOCKQUOTE",{"data-svelte-h":!0}),o(_)!=="svelte-y91jqc"&&(_.innerHTML=ke),kt=a(t),k=i(t,"P",{"data-svelte-h":!0}),o(k)!=="svelte-xpoxi8"&&(k.innerHTML=xe),xt=a(t),x=i(t,"IMG",{src:!0,alt:!0}),Qt=a(t),Q=i(t,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-1ifduzy"&&(Q.innerHTML=Re),Rt=a(t),R=i(t,"P",{"data-svelte-h":!0}),o(R)!=="svelte-xgl3rm"&&(R.textContent=Se),St=a(t),S=i(t,"UL",{"data-svelte-h":!0}),o(S)!=="svelte-g8ecnx"&&(S.innerHTML=ze),zt=a(t),m(z.$$.fragment,t),Xt=a(t),X=i(t,"P",{"data-svelte-h":!0}),o(X)!=="svelte-eq9rdr"&&(X.innerHTML=Xe),Ft=a(t),m(F.$$.fragment,t),Nt=a(t),N=i(t,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1qrccm5"&&(N.innerHTML=Fe),Vt=a(t),m(V.$$.fragment,t),$t=a(t),$=i(t,"P",{"data-svelte-h":!0}),o($)!=="svelte-qrpozm"&&($.textContent=Ne),Lt=a(t),L=i(t,"OL",{"data-svelte-h":!0}),o(L)!=="svelte-12muy28"&&(L.innerHTML=Ve),Yt=a(t),Y=i(t,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-mmcol7"&&(Y.textContent=$e),qt=a(t),q=i(t,"OL",{"data-svelte-h":!0}),o(q)!=="svelte-p349vr"&&(q.innerHTML=Le),Pt=a(t),m(P.$$.fragment,t),Kt=a(t),K=i(t,"P",{"data-svelte-h":!0}),o(K)!=="svelte-16qafzg"&&(K.innerHTML=Ye),Dt=a(t),m(D.$$.fragment,t),Ot=a(t),O=i(t,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1o74ygl"&&(O.innerHTML=qe),te=a(t),tt=i(t,"P",{"data-svelte-h":!0}),o(tt)!=="svelte-ji4nw5"&&(tt.innerHTML=Pe),ee=a(t),et=i(t,"P",{"data-svelte-h":!0}),o(et)!=="svelte-1m08tlu"&&(et.innerHTML=Ke),le=a(t),lt=i(t,"P",{"data-svelte-h":!0}),o(lt)!=="svelte-13ckn13"&&(lt.innerHTML=De),se=a(t),st=i(t,"P",{"data-svelte-h":!0}),o(st)!=="svelte-11duvvf"&&(st.textContent=Oe),ne=a(t),m(nt.$$.fragment,t),ae=a(t),at=i(t,"P",{"data-svelte-h":!0}),o(at)!=="svelte-1fyjbth"&&(at.innerHTML=tl),Me=a(t),Mt=i(t,"P",{"data-svelte-h":!0}),o(Mt)!=="svelte-1jetd5f"&&(Mt.innerHTML=el),ie=a(t),it=i(t,"P",{"data-svelte-h":!0}),o(it)!=="svelte-h3h5uq"&&(it.innerHTML=ll),oe=a(t),pe=i(t,"HR",{}),re=a(t),ot=i(t,"P",{"data-svelte-h":!0}),o(ot)!=="svelte-1vcdjz4"&&(ot.textContent=sl),ye=a(t),pt=i(t,"P",{"data-svelte-h":!0}),o(pt)!=="svelte-10mjkny"&&(pt.textContent=nl),me=a(t),rt=i(t,"P",{"data-svelte-h":!0}),o(rt)!=="svelte-10xgfu5"&&(rt.textContent=al),ce=a(t),yt=i(t,"P",{"data-svelte-h":!0}),o(yt)!=="svelte-1s9m3df"&&(yt.textContent=Ml),ue=a(t),m(mt.$$.fragment,t),je=a(t),ut=i(t,"P",{}),de(ut).forEach(l),this.h()},h(){r(h,"name","hf:doc:metadata"),r(h,"content",Ul),we(J.src,fe="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/smolagents.png")||r(J,"src",fe),r(J,"alt","smolagents"),r(p,"width","560"),r(p,"height","315"),we(p.src,Ge="https://www.youtube.com/embed/PQDKcWiuln4?si=ysSTDZoi8y55FVvA")||r(p,"src",Ge),r(p,"title","YouTube video player"),r(p,"frameborder","0"),r(p,"allow","accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"),r(p,"referrerpolicy","strict-origin-when-cross-origin"),p.allowFullscreen="",we(x.src,Qe="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/duplicate-space.gif")||r(x,"src",Qe),r(x,"alt","Duplicate")},m(t,e){cl(document.head,h),s(t,Ut,e),s(t,ct,e),s(t,ht,e),c(w,t,e),s(t,wt,e),s(t,d,e),s(t,dt,e),s(t,b,e),s(t,bt,e),s(t,T,e),s(t,Tt,e),s(t,g,e),s(t,gt,e),c(C,t,e),s(t,Ct,e),s(t,J,e),s(t,Jt,e),s(t,f,e),s(t,ft,e),s(t,I,e),s(t,It,e),s(t,v,e),s(t,vt,e),s(t,B,e),s(t,Bt,e),s(t,A,e),s(t,At,e),s(t,Z,e),s(t,Zt,e),s(t,W,e),s(t,Wt,e),s(t,p,e),s(t,Et,e),s(t,E,e),s(t,Gt,e),c(G,t,e),s(t,Ht,e),s(t,H,e),s(t,_t,e),s(t,_,e),s(t,kt,e),s(t,k,e),s(t,xt,e),s(t,x,e),s(t,Qt,e),s(t,Q,e),s(t,Rt,e),s(t,R,e),s(t,St,e),s(t,S,e),s(t,zt,e),c(z,t,e),s(t,Xt,e),s(t,X,e),s(t,Ft,e),c(F,t,e),s(t,Nt,e),s(t,N,e),s(t,Vt,e),c(V,t,e),s(t,$t,e),s(t,$,e),s(t,Lt,e),s(t,L,e),s(t,Yt,e),s(t,Y,e),s(t,qt,e),s(t,q,e),s(t,Pt,e),c(P,t,e),s(t,Kt,e),s(t,K,e),s(t,Dt,e),c(D,t,e),s(t,Ot,e),s(t,O,e),s(t,te,e),s(t,tt,e),s(t,ee,e),s(t,et,e),s(t,le,e),s(t,lt,e),s(t,se,e),s(t,st,e),s(t,ne,e),c(nt,t,e),s(t,ae,e),s(t,at,e),s(t,Me,e),s(t,Mt,e),s(t,ie,e),s(t,it,e),s(t,oe,e),s(t,pe,e),s(t,re,e),s(t,ot,e),s(t,ye,e),s(t,pt,e),s(t,me,e),s(t,rt,e),s(t,ce,e),s(t,yt,e),s(t,ue,e),c(mt,t,e),s(t,je,e),s(t,ut,e),Ue=!0},p:ol,i(t){Ue||(u(w.$$.fragment,t),u(C.$$.fragment,t),u(G.$$.fragment,t),u(z.$$.fragment,t),u(F.$$.fragment,t),u(V.$$.fragment,t),u(P.$$.fragment,t),u(D.$$.fragment,t),u(nt.$$.fragment,t),u(mt.$$.fragment,t),Ue=!0)},o(t){j(w.$$.fragment,t),j(C.$$.fragment,t),j(G.$$.fragment,t),j(z.$$.fragment,t),j(F.$$.fragment,t),j(V.$$.fragment,t),j(P.$$.fragment,t),j(D.$$.fragment,t),j(nt.$$.fragment,t),j(mt.$$.fragment,t),Ue=!1},d(t){t&&(l(Ut),l(ct),l(ht),l(wt),l(d),l(dt),l(b),l(bt),l(T),l(Tt),l(g),l(gt),l(Ct),l(J),l(Jt),l(f),l(ft),l(I),l(It),l(v),l(vt),l(B),l(Bt),l(A),l(At),l(Z),l(Zt),l(W),l(Wt),l(p),l(Et),l(E),l(Gt),l(Ht),l(H),l(_t),l(_),l(kt),l(k),l(xt),l(x),l(Qt),l(Q),l(Rt),l(R),l(St),l(S),l(zt),l(Xt),l(X),l(Ft),l(Nt),l(N),l(Vt),l($t),l($),l(Lt),l(L),l(Yt),l(Y),l(qt),l(q),l(Pt),l(Kt),l(K),l(Dt),l(Ot),l(O),l(te),l(tt),l(ee),l(et),l(le),l(lt),l(se),l(st),l(ne),l(ae),l(at),l(Me),l(Mt),l(ie),l(it),l(oe),l(pe),l(re),l(ot),l(ye),l(pt),l(me),l(rt),l(ce),l(yt),l(ue),l(je),l(ut)),l(h),U(w,t),U(C,t),U(G,t),U(z,t),U(F,t),U(V,t),U(P,t),U(D,t),U(nt,t),U(mt,t)}}}const Ul='{"title":"Let’s Create Our First Agent Using smolagents","local":"lets-create-our-first-agent-using-smolagents","sections":[{"title":"What is smolagents?","local":"what-is-smolagents","sections":[],"depth":2},{"title":"Let’s build our Agent!","local":"lets-build-our-agent","sections":[{"title":"The Tools","local":"the-tools","sections":[],"depth":3},{"title":"The Agent","local":"the-agent","sections":[],"depth":3}],"depth":2}],"depth":1}';function hl(be){return pl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Cl extends rl{constructor(h){super(),yl(this,h,hl,jl,il,{})}}export{Cl as component};
