import{s as ke,f as $e,n as ve,o as xe}from"../chunks/scheduler.f6b352c8.js";import{S as Xe,i as qe,g as i,s as n,r as h,A as Ze,h as o,f as e,c as a,j as Qs,u,x as p,k as Es,y as Fs,a as l,v as r,d as c,t as M,w}from"../chunks/index.7f38e934.js";import{C as y}from"../chunks/CodeBlock.2a338b68.js";import{H as As}from"../chunks/Heading.333929c4.js";import{E as Ye}from"../chunks/EditOnGithub.c3245a01.js";function Ne(zs){let j,Ct,It,Gt,m,kt,T,Ls,$t,J,Hs="This course is framework-agnostic because we want to <strong>focus on the concepts of AI agents and avoid getting bogged down in the specifics of a particular framework</strong>.",vt,b,Ss="Also, we want students to be able to use the concepts they learn in this course in their own projects, using any framework they like.",xt,f,Ps="Therefore, for this Unit 1, we will use a dummy agent library and a simple serverless API to access our LLM engine.",Xt,U,Os="You probably wouldn’t use these in production, but they will serve as a good <strong>starting point for understanding how agents work</strong>.",qt,g,Ds="After this section, you’ll be ready to <strong>create a simple Agent</strong> using <code>smolagents</code>",Zt,B,Ks="And in the following Units we will also use other AI Agent libraries like <code>LangGraph</code>, <code>LangChain</code>, and <code>LlamaIndex</code>.",Yt,I,te="To keep things simple we will use a simple Python function as a Tool and Agent.",Nt,_,se="We will use built-in Python packages like <code>datetime</code> and <code>os</code> so that you can try it out in any environment.",Rt,C,ee='You can follow the process <a href="https://huggingface.co/agents-course/notebooks/blob/main/dummy_agent_library.ipynb" rel="nofollow">in this notebook</a> and <strong>run the code yourself</strong>.',Wt,G,Et,k,le="In the Hugging Face ecosystem, there is a convenient feature called Serverless API that allows you to easily run inference on many models. There’s no installation or deployment required.",Vt,$,Qt,v,Ft,x,ne="output:",At,X,zt,q,ae="As seen in the LLM section, if we just do decoding, <strong>the model will only stop when it predicts an EOS token</strong>, and this does not happen here because this is a conversational (chat) model and <strong>we didn’t apply the chat template it expects</strong>.",Lt,Z,ie='If we now add the special tokens related to the <a href="https://huggingface.co/meta-llama/Llama-3.2-3B-Instruct">Llama-3.2-3B-Instruct model</a> that we’re using, the behavior changes and it now produces the expected EOS.',Ht,Y,St,N,oe="output:",Pt,R,Ot,W,pe="Using the “chat” method is a much more convenient and reliable way to apply chat templates:",Dt,E,Kt,V,he="output:",ts,Q,ss,F,ue="The chat method is the RECOMMENDED method to use in order to ensure a smooth transition between models, but since this notebook is only educational, we will keep using the “text_generation” method to understand the details.",es,A,ls,z,re="In the previous sections, we saw that the core of an agent library is to append information in the system prompt.",ns,L,ce="This system prompt is a bit more complex than the one we saw earlier, but it already contains:",as,H,Me="<li><strong>Information about the tools</strong></li> <li><strong>Cycle instructions</strong> (Thought → Action → Observation)</li>",is,S,os,P,we="Since we are running the “text_generation” method, we need to apply the prompt manually:",ps,O,hs,D,ye="We can also do it like this, which is what happens inside the <code>chat</code> method :",us,K,rs,tt,je="The prompt now is :",cs,st,Ms,et,de="Let’s decode!",ws,lt,ys,nt,me="output:",js,at,ds,it,Te="Do you see the issue?",ms,d,Bt,Je=`The answer was hallucinated by the model. We need to stop to actually execute the function!
Let’s now stop on “Observation” so that we don’t hallucinate the actual function response`,Vs,ot,Ts,pt,be="print(output)",Js,ht,bs,ut,fe="Action:",fs,rt,Us,ct,Ue=`Much Better!
Let’s now create a dummy get weather function.  In a real situation, you would likely call an API.`,gs,Mt,Bs,wt,ge="output:",Is,yt,_s,jt,Be="Let’s concatenate the base prompt, the completion until function execution and the result of the function as an Observation and resume generation.",Cs,dt,Gs,mt,Ie="Here is the new prompt:",ks,Tt,$s,Jt,_e="Output:",vs,bt,xs,Xs,qs,ft,Ce="We learned how we can create Agents from scratch using Python code, and we <strong>saw just how tedious that process can be</strong>. Fortunately, many Agent libraries simplify this work by handling much of the heavy lifting for you.",Zs,Ut,Ge="Now, we’re ready <strong>to create our first real Agent</strong> using the <code>smolagents</code> library.",Ys,gt,Ns,_t,Rs;return m=new As({props:{title:"Dummy Agent Library",local:"dummy-agent-library",headingTag:"h1"}}),G=new As({props:{title:"Serverless API",local:"serverless-api",headingTag:"h2"}}),$=new y({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwSW5mZXJlbmNlQ2xpZW50JTBBJTBBJTIzJTIzJTIwWW91JTIwbmVlZCUyMGElMjB0b2tlbiUyMGZyb20lMjBodHRwcyUzQSUyRiUyRmhmLmNvJTJGc2V0dGluZ3MlMkZ0b2tlbnMuJTIwSWYlMjB5b3UlMjBydW4lMjB0aGlzJTIwb24lMjBHb29nbGUlMjBDb2xhYiUyQyUyMHlvdSUyMGNhbiUyMHNldCUyMGl0JTIwdXAlMjBpbiUyMHRoZSUyMCUyMnNldHRpbmdzJTIyJTIwdGFiJTIwdW5kZXIlMjAlMjJzZWNyZXRzJTIyLiUyME1ha2UlMjBzdXJlJTIwdG8lMjBjYWxsJTIwaXQlMjAlMjJIRl9UT0tFTiUyMiUwQW9zLmVudmlyb24lNUIlMjJIRl9UT0tFTiUyMiU1RCUzRCUyMmhmX3h4eHh4eHh4eHh4eHh4JTIyJTBBJTBBY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCUyMm1ldGEtbGxhbWElMkZMbGFtYS0zLjItM0ItSW5zdHJ1Y3QlMjIpJTBBJTIzJTIwaWYlMjB0aGUlMjBvdXRwdXRzJTIwZm9yJTIwbmV4dCUyMGNlbGxzJTIwYXJlJTIwd3JvbmclMkMlMjB0aGUlMjBmcmVlJTIwbW9kZWwlMjBtYXklMjBiZSUyMG92ZXJsb2FkZWQuJTIwWW91JTIwY2FuJTIwYWxzbyUyMHVzZSUyMHRoaXMlMjBwdWJsaWMlMjBlbmRwb2ludCUyMHRoYXQlMjBjb250YWlucyUyMExsYW1hLTMuMi0zQi1JbnN0cnVjdCUwQSUyMyUyMGNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMjJodHRwcyUzQSUyRiUyRmpjMjZtd2cyMjhta2o4ZHcudXMtZWFzdC0xLmF3cy5lbmRwb2ludHMuaHVnZ2luZ2ZhY2UuY2xvdWQlMjIp",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

<span class="hljs-comment">## You need a token from https://hf.co/settings/tokens. If you run this on Google Colab, you can set it up in the &quot;settings&quot; tab under &quot;secrets&quot;. Make sure to call it &quot;HF_TOKEN&quot;</span>
os.environ[<span class="hljs-string">&quot;HF_TOKEN&quot;</span>]=<span class="hljs-string">&quot;hf_xxxxxxxxxxxxxx&quot;</span>

client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Llama-3.2-3B-Instruct&quot;</span>)
<span class="hljs-comment"># if the outputs for next cells are wrong, the free model may be overloaded. You can also use this public endpoint that contains Llama-3.2-3B-Instruct</span>
<span class="hljs-comment"># client = InferenceClient(&quot;https://jc26mwg228mkj8dw.us-east-1.aws.endpoints.huggingface.cloud&quot;)</span>`,wrap:!1}}),v=new y({props:{code:"b3V0cHV0JTIwJTNEJTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMEElMjAlMjAlMjAlMjAlMjJUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMiUyQyUwQSUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNEMTAwJTJDJTBBKSUwQSUwQXByaW50KG91dHB1dCk=",highlighted:`output = client.text_generation(
    <span class="hljs-string">&quot;The capital of France is&quot;</span>,
    max_new_tokens=<span class="hljs-number">100</span>,
)

<span class="hljs-built_in">print</span>(output)`,wrap:!1}}),X=new y({props:{code:"UGFyaXMuJTIwVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjBQYXJpcy4lMjBUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMFBhcmlzLiUyMFRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwUGFyaXMuJTIwVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjBQYXJpcy4lMjBUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMFBhcmlzLiUyMFRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwUGFyaXMuJTIwVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjBQYXJpcy4lMjBUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMFBhcmlzLiUyMFRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwUGFyaXMuJTIwVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjBQYXJpcy4lMjBUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMFBhcmlzLiUyMFRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwUGFyaXMuJTIwVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjBQYXJpcy4lMjBUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMFBhcmlzLg==",highlighted:'Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris.',wrap:!1}}),Y=new y({props:{code:"cHJvbXB0JTNEJTIyJTIyJTIyJTNDJTdDYmVnaW5fb2ZfdGV4dCU3QyUzRSUzQyU3Q3N0YXJ0X2hlYWRlcl9pZCU3QyUzRXVzZXIlM0MlN0NlbmRfaGVhZGVyX2lkJTdDJTNFJTBBVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlM0MlN0Nlb3RfaWQlN0MlM0UlM0MlN0NzdGFydF9oZWFkZXJfaWQlN0MlM0Vhc3Npc3RhbnQlM0MlN0NlbmRfaGVhZGVyX2lkJTdDJTNFJTIyJTIyJTIyJTBBb3V0cHV0JTIwJTNEJTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMEElMjAlMjAlMjAlMjBwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDEwMCUyQyUwQSklMEElMEFwcmludChvdXRwdXQp",highlighted:`prompt=<span class="hljs-string">&quot;&quot;&quot;&lt;|begin_of_text|&gt;&lt;|start_header_id|&gt;user&lt;|end_header_id|&gt;
The capital of France is&lt;|eot_id|&gt;&lt;|start_header_id|&gt;assistant&lt;|end_header_id|&gt;&quot;&quot;&quot;</span>
output = client.text_generation(
    prompt,
    max_new_tokens=<span class="hljs-number">100</span>,
)

<span class="hljs-built_in">print</span>(output)`,wrap:!1}}),R=new y({props:{code:"VGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjBQYXJpcy4=",highlighted:'The capital of France <span class="hljs-keyword">is</span> Paris.',wrap:!1}}),E=new y({props:{code:"b3V0cHV0JTIwJTNEJTIwY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjBzdHJlYW0lM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMG1heF90b2tlbnMlM0QxMDI0JTJDJTBBKSUwQXByaW50KG91dHB1dC5jaG9pY2VzJTVCMCU1RC5tZXNzYWdlLmNvbnRlbnQp",highlighted:`output = client.chat.completions.create(
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;The capital of France is&quot;</span>},
    ],
    stream=<span class="hljs-literal">False</span>,
    max_tokens=<span class="hljs-number">1024</span>,
)
<span class="hljs-built_in">print</span>(output.choices[<span class="hljs-number">0</span>].message.content)`,wrap:!1}}),Q=new y({props:{code:"UGFyaXMu",highlighted:"Paris.",wrap:!1}}),A=new As({props:{title:"Dummy Agent",local:"dummy-agent",headingTag:"h2"}}),S=new y({props:{code:"JTBBJTBBJTBBJTBBJTBBJTBBJTBBJTBBKHRoaXMlMjBUaG91Z2h0JTJGQWN0aW9uJTJGT2JzZXJ2YXRpb24lMjBjYW4lMjByZXBlYXQlMjBOJTIwdGltZXMlMkMlMjB5b3UlMjBzaG91bGQlMjB0YWtlJTIwc2V2ZXJhbCUyMHN0ZXBzJTIwd2hlbiUyMG5lZWRlZC4lMjBUaGUlMjAlMjRKU09OX0JMT0IlMjBtdXN0JTIwYmUlMjBmb3JtYXR0ZWQlMjBhcyUyMG1hcmtkb3duJTIwYW5kJTIwb25seSUyMHVzZSUyMGElMjBTSU5HTEUlMjBhY3Rpb24lMjBhdCUyMGElMjB0aW1lLiklMEElMEElMEE=",highlighted:`Answer the following questions as best you can. You have access to the following tools:

get_weather: Get the current weather in a given location

The way you <span class="hljs-keyword">use</span> the tools is by specifying a json blob.
Specifically, <span class="hljs-keyword">this</span> json should have an \`action\` key (<span class="hljs-keyword">with</span> the name of the tool to <span class="hljs-keyword">use</span>) <span class="hljs-keyword">and</span> an \`action_input\` key (<span class="hljs-keyword">with</span> the <span class="hljs-keyword">input</span> to the tool going here).

The only values that should be in the <span class="hljs-string">&quot;action&quot;</span> field are:
get_weather: Get the current weather in a given location, args: {<span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}}
example <span class="hljs-keyword">use</span> : 

{{
  <span class="hljs-string">&quot;action&quot;</span>: <span class="hljs-string">&quot;get_weather&quot;</span>,
  <span class="hljs-string">&quot;action_input&quot;</span>: {<span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;New York&quot;</span>}
}}

ALWAYS <span class="hljs-keyword">use</span> the following format:

Question: the <span class="hljs-keyword">input</span> question you must answer
Thought: you should <span class="hljs-keyword">always</span> think about one action to take. Only one action at a <span class="hljs-keyword">time</span> in <span class="hljs-keyword">this</span> format:
Action:

$JSON_BLOB (<span class="hljs-keyword">inside</span> markdown <span class="hljs-keyword">cell</span>)

Observation: the result of the action. This Observation is <span class="hljs-keyword">unique</span>, complete, <span class="hljs-keyword">and</span> the source of truth.
... (<span class="hljs-keyword">this</span> Thought/Action/Observation can <span class="hljs-keyword">repeat</span> N times, you should take several steps when needed. The $JSON_BLOB must be formatted as markdown <span class="hljs-keyword">and</span> only <span class="hljs-keyword">use</span> a SINGLE action at a <span class="hljs-keyword">time</span>.)

You must <span class="hljs-keyword">always</span> <span class="hljs-keyword">end</span> your <span class="hljs-keyword">output</span> <span class="hljs-keyword">with</span> the following format:

Thought: I now know the <span class="hljs-keyword">final</span> answer
Final Answer: the <span class="hljs-keyword">final</span> answer to the original <span class="hljs-keyword">input</span> question

Now <span class="hljs-keyword">begin</span>! Reminder to ALWAYS <span class="hljs-keyword">use</span> the exact characters \`Final Answer:\` when you provide a definitive answer.`,wrap:!1}}),O=new y({props:{code:"cHJvbXB0JTNEZiUyMiUyMiUyMiUzQyU3Q2JlZ2luX29mX3RleHQlN0MlM0UlM0MlN0NzdGFydF9oZWFkZXJfaWQlN0MlM0VzeXN0ZW0lM0MlN0NlbmRfaGVhZGVyX2lkJTdDJTNFJTBBJTdCU1lTVEVNX1BST01QVCU3RCUwQSUzQyU3Q2VvdF9pZCU3QyUzRSUzQyU3Q3N0YXJ0X2hlYWRlcl9pZCU3QyUzRXVzZXIlM0MlN0NlbmRfaGVhZGVyX2lkJTdDJTNFJTBBV2hhdCdzJTIwdGhlJTIwd2VhdGhlciUyMGluJTIwTG9uZG9uJTIwJTNGJTBBJTNDJTdDZW90X2lkJTdDJTNFJTNDJTdDc3RhcnRfaGVhZGVyX2lkJTdDJTNFYXNzaXN0YW50JTNDJTdDZW5kX2hlYWRlcl9pZCU3QyUzRSUwQSUyMiUyMiUyMg==",highlighted:`<span class="hljs-attr">prompt</span>=f<span class="hljs-string">&quot;&quot;&quot;&lt;|begin_of_text|&gt;&lt;|start_header_id|&gt;system&lt;|end_header_id|&gt;
{SYSTEM_PROMPT}
&lt;|eot_id|&gt;&lt;|start_header_id|&gt;user&lt;|end_header_id|&gt;
What&#x27;s the weather in London ?
&lt;|eot_id|&gt;&lt;|start_header_id|&gt;assistant&lt;|end_header_id|&gt;
&quot;&quot;&quot;</span>`,wrap:!1}}),K=new y({props:{code:"bWVzc2FnZXMlM0QlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMFNZU1RFTV9QUk9NUFQlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0J3MlMjB0aGUlMjB3ZWF0aGVyJTIwaW4lMjBMb25kb24lMjAlM0YlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlNUQlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1ldGEtbGxhbWElMkZMbGFtYS0zLjItM0ItSW5zdHJ1Y3QlMjIpJTBBJTBBdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzREZhbHNlJTJDYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSk=",highlighted:`messages=[
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: SYSTEM_PROMPT},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What&#x27;s the weather in London ?&quot;</span>},
    ]
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-3.2-3B-Instruct&quot;</span>)

tokenizer.apply_chat_template(messages, <span class="hljs-keyword">tokenize</span>=<span class="hljs-keyword">False</span>,add_generation_prompt=<span class="hljs-keyword">True</span>)`,wrap:!1}}),st=new y({props:{code:"JTBBJTBBJTBBJTBBJTBBJTBBJTBBJTBBKHRoaXMlMjBUaG91Z2h0JTJGQWN0aW9uJTJGT2JzZXJ2YXRpb24lMjBjYW4lMjByZXBlYXQlMjBOJTIwdGltZXMlMkMlMjB5b3UlMjBzaG91bGQlMjB0YWtlJTIwc2V2ZXJhbCUyMHN0ZXBzJTIwd2hlbiUyMG5lZWRlZC4lMjBUaGUlMjAlMjRKU09OX0JMT0IlMjBtdXN0JTIwYmUlMjBmb3JtYXR0ZWQlMjBhcyUyMG1hcmtkb3duJTIwYW5kJTIwb25seSUyMHVzZSUyMGElMjBTSU5HTEUlMjBhY3Rpb24lMjBhdCUyMGElMjB0aW1lLiklMEElMEElMEE=",highlighted:`&lt;|<span class="hljs-type">begin_of_text</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;system</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;
Answer</span> the following questions <span class="hljs-built_in">as</span> best you can. You have access to the following tools:

get_weather: Get the current weather <span class="hljs-built_in">in</span> a given location

The way you use the tools is <span class="hljs-built_in">by</span> specifying a json blob.
Specifically, this json should have an \`action\` key (<span class="hljs-built_in">with</span> the name of the tool to use) and a \`action_input\` key (<span class="hljs-built_in">with</span> the input to the tool going here).

The only values that should be <span class="hljs-built_in">in</span> the <span class="hljs-string">&quot;action&quot;</span> <span class="hljs-built_in">field</span> are:
get_weather: Get the current weather <span class="hljs-built_in">in</span> a given location, args: {<span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}}
example use : 

{{
  <span class="hljs-string">&quot;action&quot;</span>: <span class="hljs-string">&quot;get_weather&quot;</span>,
  <span class="hljs-string">&quot;action_input&quot;</span>: {<span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;New York&quot;</span>}
}}

ALWAYS use the following format:

Question: the input question you must answer
Thought: you should always think about one action to take. Only one action <span class="hljs-built_in">at</span> a <span class="hljs-built_in">time</span> <span class="hljs-built_in">in</span> this format:
Action:

$JSON_BLOB (inside markdown cell)

Observation: the result of the action. This Observation is unique, complete, and the source of truth.
... (this Thought/Action/Observation can <span class="hljs-built_in">repeat</span> N times, you should take several steps when needed. The $JSON_BLOB must be formatted <span class="hljs-built_in">as</span> markdown and only use a SINGLE action <span class="hljs-built_in">at</span> a <span class="hljs-built_in">time</span>.)

You must always <span class="hljs-keyword">end</span> your output <span class="hljs-built_in">with</span> the following format:

Thought: I now know the final answer
Final Answer: the final answer to the original input question

Now begin! Reminder to ALWAYS use the <span class="hljs-built_in">exact</span> characters \`Final Answer:\` when you provide a definitive answer. 
&lt;|<span class="hljs-type">eot_id</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;user</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;
What</span>&#x27;s the weather <span class="hljs-built_in">in</span> London ?
&lt;|<span class="hljs-type">eot_id</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;assistant</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;</span>`,wrap:!1}}),lt=new y({props:{code:"b3V0cHV0JTIwJTNEJTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMEElMjAlMjAlMjAlMjBwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDIwMCUyQyUwQSklMEElMEFwcmludChvdXRwdXQp",highlighted:`output = client.text_generation(
    prompt,
    max_new_tokens=<span class="hljs-number">200</span>,
)

<span class="hljs-built_in">print</span>(output)`,wrap:!1}}),at=new y({props:{code:"QWN0aW9uJTNBJTBBJTIwJTIwJTIwJTIwJTYwJTYwJTYwJTBBJTdCJTBBJTIwJTIwJTIyYWN0aW9uJTIyJTNBJTIwJTIyZ2V0X3dlYXRoZXIlMjIlMkMlMEElMjAlMjAlMjJhY3Rpb24lMjIlM0ElMjAlN0IlMjJsb2NhdGlvbiUyMiUzQSUyMCUyMkxvbmRvbiUyMiU3RCUwQSU3RCUwQSUyMCUyMCUyMCUyMCU2MCU2MCU2MCUwQVRob3VnaHQlM0ElMjBJJTIwd2lsbCUyMGNoZWNrJTIwdGhlJTIwd2VhdGhlciUyMGluJTIwTG9uZG9uLiUwQU9ic2VydmF0aW9uJTNBJTIwVGhlJTIwY3VycmVudCUyMHdlYXRoZXIlMjBpbiUyMExvbmRvbiUyMGlzJTIwbW9zdGx5JTIwY2xvdWR5JTIwd2l0aCUyMGElMjBoaWdoJTIwb2YlMjAxMiVDMiVCMEMlMjBhbmQlMjBhJTIwbG93JTIwb2YlMjA4JUMyJUIwQy4=",highlighted:`Action:
    \`\`\`
{
  <span class="hljs-string">&quot;action&quot;</span>: <span class="hljs-string">&quot;get_weather&quot;</span>,
  <span class="hljs-string">&quot;action&quot;</span>: {<span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;London&quot;</span>}
}
    \`\`\`
Thought: I will<span class="hljs-built_in"> check </span>the weather in London.
Observation: The current weather in London is mostly cloudy with a high of 12°C<span class="hljs-built_in"> and </span>a low of 8°C.`,wrap:!1}}),ot=new y({props:{code:"b3V0cHV0JTIwJTNEJTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMEElMjAlMjAlMjAlMjBwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDIwMCUyQyUwQSUyMCUyMCUyMCUyMHN0b3AlM0QlNUIlMjJPYnNlcnZhdGlvbiUzQSUyMiU1RCUyMCUyMyUyMExldCdzJTIwc3RvcCUyMGJlZm9yZSUyMGFueSUyMGFjdHVhbCUyMGZ1bmN0aW9uJTIwaXMlMjBjYWxsZWQlMEEp",highlighted:`output = client.text_generation(
    prompt,
    max_new_tokens=<span class="hljs-number">200</span>,
    stop=[<span class="hljs-string">&quot;Observation:&quot;</span>] <span class="hljs-comment"># Let&#x27;s stop before any actual function is called</span>
)`,wrap:!1}}),ht=new y({props:{code:"b3V0cHV0JTNBJTBB",highlighted:`<span class="hljs-symbol">output:</span>
`,wrap:!1}}),rt=new y({props:{code:"JTdCJTBBJTIyYWN0aW9uJTIyJTNBJTIwJTIyZ2V0X3dlYXRoZXIlMjIlMkMlMEElMjJhY3Rpb24lMjIlM0ElMjAlN0IlMjJsb2NhdGlvbiUyMiUzQSUyMCUyMkxvbmRvbiUyMiU3RCUwQSU3RCUwQSU2MCU2MCU2MCUwQVRob3VnaHQlM0ElMjBJJTIwd2lsbCUyMGNoZWNrJTIwdGhlJTIwd2VhdGhlciUyMGluJTIwTG9uZG9uLiUwQU9ic2VydmF0aW9uJTNB",highlighted:`{
<span class="hljs-string">&quot;action&quot;</span>: <span class="hljs-string">&quot;get_weather&quot;</span>,
<span class="hljs-string">&quot;action&quot;</span>: {<span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;London&quot;</span>}
}
\`\`\`
Thought: I will<span class="hljs-built_in"> check </span>the weather in London.
Observation:`,wrap:!1}}),Mt=new y({props:{code:"JTIzRHVtbXklMjBmdW5jdGlvbiUwQWRlZiUyMGdldF93ZWF0aGVyKGxvY2F0aW9uKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGYlMjJ0aGUlMjB3ZWF0aGVyJTIwaW4lMjAlN0Jsb2NhdGlvbiU3RCUyMGlzJTIwc3VubnklMjB3aXRoJTIwbG93JTIwdGVtcGVyYXR1cmVzLiUyMCU1Q24lMjIlMEElMEFnZXRfd2VhdGhlcignTG9uZG9uJyk=",highlighted:`<span class="hljs-comment">#Dummy function</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_weather</span>(<span class="hljs-params">location</span>):
    <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;the weather in <span class="hljs-subst">{location}</span> is sunny with low temperatures. \\n&quot;</span>

get_weather(<span class="hljs-string">&#x27;London&#x27;</span>)`,wrap:!1}}),yt=new y({props:{code:"J3RoZSUyMHdlYXRoZXIlMjBpbiUyMExvbmRvbiUyMGlzJTIwc3VubnklMjB3aXRoJTIwbG93JTIwdGVtcGVyYXR1cmVzLiUyMCU1Q24n",highlighted:'<span class="hljs-symbol">&#x27;the</span> weather <span class="hljs-keyword">in</span> London <span class="hljs-keyword">is</span> sunny <span class="hljs-keyword">with</span> low temperatures. \\n&#x27;',wrap:!1}}),dt=new y({props:{code:"bmV3X3Byb21wdCUzRHByb21wdCUyQm91dHB1dCUyQmdldF93ZWF0aGVyKCdMb25kb24nKSUwQWZpbmFsX291dHB1dCUyMCUzRCUyMGNsaWVudC50ZXh0X2dlbmVyYXRpb24oJTBBJTIwJTIwJTIwJTIwbmV3X3Byb21wdCUyQyUwQSUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNEMjAwJTJDJTBBKSUwQSUwQXByaW50KGZpbmFsX291dHB1dCk=",highlighted:`new_prompt=prompt+output+get_weather(<span class="hljs-string">&#x27;London&#x27;</span>)
final_output = client.text_generation(
    new_prompt,
    max_new_tokens=<span class="hljs-number">200</span>,
)

<span class="hljs-built_in">print</span>(final_output)`,wrap:!1}}),Tt=new y({props:{code:"JTBBJTBBJTBBJTBBJTBBJTBBJTBBJTBBKHRoaXMlMjBUaG91Z2h0JTJGQWN0aW9uJTJGT2JzZXJ2YXRpb24lMjBjYW4lMjByZXBlYXQlMjBOJTIwdGltZXMlMkMlMjB5b3UlMjBzaG91bGQlMjB0YWtlJTIwc2V2ZXJhbCUyMHN0ZXBzJTIwd2hlbiUyMG5lZWRlZC4lMjBUaGUlMjAlMjRKU09OX0JMT0IlMjBtdXN0JTIwYmUlMjBmb3JtYXR0ZWQlMjBhcyUyMG1hcmtkb3duJTIwYW5kJTIwb25seSUyMHVzZSUyMGElMjBTSU5HTEUlMjBhY3Rpb24lMjBhdCUyMGElMjB0aW1lLiklMEElMEElMEElMEE=",highlighted:`&lt;|<span class="hljs-type">begin_of_text</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;system</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;
    Answer</span> the following questions <span class="hljs-built_in">as</span> best you can. You have access to the following tools:

get_weather: Get the current weather <span class="hljs-built_in">in</span> a given location

The way you use the tools is <span class="hljs-built_in">by</span> specifying a json blob.
Specifically, this json should have a \`action\` key (<span class="hljs-built_in">with</span> the name of the tool to use) and a \`action_input\` key (<span class="hljs-built_in">with</span> the input to the tool going here).

The only values that should be <span class="hljs-built_in">in</span> the <span class="hljs-string">&quot;action&quot;</span> <span class="hljs-built_in">field</span> are:
get_weather: Get the current weather <span class="hljs-built_in">in</span> a given location, args: {<span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}}
example use : 

{{
  <span class="hljs-string">&quot;action&quot;</span>: <span class="hljs-string">&quot;get_weather&quot;</span>,
  <span class="hljs-string">&quot;action_input&quot;</span>: {<span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;New York&quot;</span>}
}}

ALWAYS use the following format:

Question: the input question you must answer
Thought: you should always think about one action to take. Only one action <span class="hljs-built_in">at</span> a <span class="hljs-built_in">time</span> <span class="hljs-built_in">in</span> this format:
Action:

$JSON_BLOB (inside markdown cell)

Observation: the result of the action. This Observation is unique, complete, and the source of truth.
... (this Thought/Action/Observation can <span class="hljs-built_in">repeat</span> N times, you should take several steps when needed. The $JSON_BLOB must be formatted <span class="hljs-built_in">as</span> markdown and only use a SINGLE action <span class="hljs-built_in">at</span> a <span class="hljs-built_in">time</span>.)

You must always <span class="hljs-keyword">end</span> your output <span class="hljs-built_in">with</span> the following format:

Thought: I now know the final answer
Final Answer: the final answer to the original input question

Now begin! Reminder to ALWAYS use the <span class="hljs-built_in">exact</span> characters \`Final Answer:\` when you provide a definitive answer. 
&lt;|<span class="hljs-type">eot_id</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;user</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;
What</span>&#x27;s the weather <span class="hljs-built_in">in</span> London ?
&lt;|<span class="hljs-type">eot_id</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;assistant</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;

Action</span>:
\`\`\`
{
  <span class="hljs-string">&quot;action&quot;</span>: <span class="hljs-string">&quot;get_weather&quot;</span>,
  <span class="hljs-string">&quot;action&quot;</span>: {<span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>: <span class="hljs-string">&quot;London&quot;</span>}
}
\`\`\`
Thought: I will check the weather <span class="hljs-built_in">in</span> London.
Observation:the weather <span class="hljs-built_in">in</span> London is sunny <span class="hljs-built_in">with</span> low temperatures. `,wrap:!1}}),bt=new y({props:{code:"RmluYWwlMjBBbnN3ZXIlM0ElMjBUaGUlMjB3ZWF0aGVyJTIwaW4lMjBMb25kb24lMjBpcyUyMHN1bm55JTIwd2l0aCUyMGxvdyUyMHRlbXBlcmF0dXJlcy4=",highlighted:'<span class="hljs-keyword">Final</span> Answer: The weather <span class="hljs-keyword">in</span> London <span class="hljs-keyword">is</span> sunny <span class="hljs-keyword">with</span> low temperatures.',wrap:!1}}),gt=new Ye({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit1/dummy-agent-library.mdx"}}),{c(){j=i("meta"),Ct=n(),It=i("p"),Gt=n(),h(m.$$.fragment),kt=n(),T=i("img"),$t=n(),J=i("p"),J.innerHTML=Hs,vt=n(),b=i("p"),b.textContent=Ss,xt=n(),f=i("p"),f.textContent=Ps,Xt=n(),U=i("p"),U.innerHTML=Os,qt=n(),g=i("p"),g.innerHTML=Ds,Zt=n(),B=i("p"),B.innerHTML=Ks,Yt=n(),I=i("p"),I.textContent=te,Nt=n(),_=i("p"),_.innerHTML=se,Rt=n(),C=i("p"),C.innerHTML=ee,Wt=n(),h(G.$$.fragment),Et=n(),k=i("p"),k.textContent=le,Vt=n(),h($.$$.fragment),Qt=n(),h(v.$$.fragment),Ft=n(),x=i("p"),x.textContent=ne,At=n(),h(X.$$.fragment),zt=n(),q=i("p"),q.innerHTML=ae,Lt=n(),Z=i("p"),Z.innerHTML=ie,Ht=n(),h(Y.$$.fragment),St=n(),N=i("p"),N.textContent=oe,Pt=n(),h(R.$$.fragment),Ot=n(),W=i("p"),W.textContent=pe,Dt=n(),h(E.$$.fragment),Kt=n(),V=i("p"),V.textContent=he,ts=n(),h(Q.$$.fragment),ss=n(),F=i("p"),F.textContent=ue,es=n(),h(A.$$.fragment),ls=n(),z=i("p"),z.textContent=re,ns=n(),L=i("p"),L.textContent=ce,as=n(),H=i("ol"),H.innerHTML=Me,is=n(),h(S.$$.fragment),os=n(),P=i("p"),P.textContent=we,ps=n(),h(O.$$.fragment),hs=n(),D=i("p"),D.innerHTML=ye,us=n(),h(K.$$.fragment),rs=n(),tt=i("p"),tt.textContent=je,cs=n(),h(st.$$.fragment),Ms=n(),et=i("p"),et.textContent=de,ws=n(),h(lt.$$.fragment),ys=n(),nt=i("p"),nt.textContent=me,js=n(),h(at.$$.fragment),ds=n(),it=i("p"),it.textContent=Te,ms=n(),d=i("blockquote"),Bt=i("p"),Bt.textContent=Je,Vs=n(),h(ot.$$.fragment),Ts=n(),pt=i("p"),pt.textContent=be,Js=n(),h(ht.$$.fragment),bs=n(),ut=i("p"),ut.textContent=fe,fs=n(),h(rt.$$.fragment),Us=n(),ct=i("p"),ct.textContent=Ue,gs=n(),h(Mt.$$.fragment),Bs=n(),wt=i("p"),wt.textContent=ge,Is=n(),h(yt.$$.fragment),_s=n(),jt=i("p"),jt.textContent=Be,Cs=n(),h(dt.$$.fragment),Gs=n(),mt=i("p"),mt.textContent=Ie,ks=n(),h(Tt.$$.fragment),$s=n(),Jt=i("p"),Jt.textContent=_e,vs=n(),h(bt.$$.fragment),xs=n(),Xs=i("hr"),qs=n(),ft=i("p"),ft.innerHTML=Ce,Zs=n(),Ut=i("p"),Ut.innerHTML=Ge,Ys=n(),h(gt.$$.fragment),Ns=n(),_t=i("p"),this.h()},l(t){const s=Ze("svelte-u9bgzb",document.head);j=o(s,"META",{name:!0,content:!0}),s.forEach(e),Ct=a(t),It=o(t,"P",{}),Qs(It).forEach(e),Gt=a(t),u(m.$$.fragment,t),kt=a(t),T=o(t,"IMG",{src:!0,alt:!0}),$t=a(t),J=o(t,"P",{"data-svelte-h":!0}),p(J)!=="svelte-1rwfam6"&&(J.innerHTML=Hs),vt=a(t),b=o(t,"P",{"data-svelte-h":!0}),p(b)!=="svelte-1pvln0h"&&(b.textContent=Ss),xt=a(t),f=o(t,"P",{"data-svelte-h":!0}),p(f)!=="svelte-17n0axy"&&(f.textContent=Ps),Xt=a(t),U=o(t,"P",{"data-svelte-h":!0}),p(U)!=="svelte-1ssvh5p"&&(U.innerHTML=Os),qt=a(t),g=o(t,"P",{"data-svelte-h":!0}),p(g)!=="svelte-r0w337"&&(g.innerHTML=Ds),Zt=a(t),B=o(t,"P",{"data-svelte-h":!0}),p(B)!=="svelte-9snja6"&&(B.innerHTML=Ks),Yt=a(t),I=o(t,"P",{"data-svelte-h":!0}),p(I)!=="svelte-scmak8"&&(I.textContent=te),Nt=a(t),_=o(t,"P",{"data-svelte-h":!0}),p(_)!=="svelte-10qtj1b"&&(_.innerHTML=se),Rt=a(t),C=o(t,"P",{"data-svelte-h":!0}),p(C)!=="svelte-1fa85bb"&&(C.innerHTML=ee),Wt=a(t),u(G.$$.fragment,t),Et=a(t),k=o(t,"P",{"data-svelte-h":!0}),p(k)!=="svelte-1y7mhy7"&&(k.textContent=le),Vt=a(t),u($.$$.fragment,t),Qt=a(t),u(v.$$.fragment,t),Ft=a(t),x=o(t,"P",{"data-svelte-h":!0}),p(x)!=="svelte-1wueeet"&&(x.textContent=ne),At=a(t),u(X.$$.fragment,t),zt=a(t),q=o(t,"P",{"data-svelte-h":!0}),p(q)!=="svelte-14l0pz9"&&(q.innerHTML=ae),Lt=a(t),Z=o(t,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-1891xc3"&&(Z.innerHTML=ie),Ht=a(t),u(Y.$$.fragment,t),St=a(t),N=o(t,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1wueeet"&&(N.textContent=oe),Pt=a(t),u(R.$$.fragment,t),Ot=a(t),W=o(t,"P",{"data-svelte-h":!0}),p(W)!=="svelte-10i9u01"&&(W.textContent=pe),Dt=a(t),u(E.$$.fragment,t),Kt=a(t),V=o(t,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1wueeet"&&(V.textContent=he),ts=a(t),u(Q.$$.fragment,t),ss=a(t),F=o(t,"P",{"data-svelte-h":!0}),p(F)!=="svelte-o9oayq"&&(F.textContent=ue),es=a(t),u(A.$$.fragment,t),ls=a(t),z=o(t,"P",{"data-svelte-h":!0}),p(z)!=="svelte-xr84ar"&&(z.textContent=re),ns=a(t),L=o(t,"P",{"data-svelte-h":!0}),p(L)!=="svelte-1m7y210"&&(L.textContent=ce),as=a(t),H=o(t,"OL",{"data-svelte-h":!0}),p(H)!=="svelte-27sevg"&&(H.innerHTML=Me),is=a(t),u(S.$$.fragment,t),os=a(t),P=o(t,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1jc27vd"&&(P.textContent=we),ps=a(t),u(O.$$.fragment,t),hs=a(t),D=o(t,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1letw4p"&&(D.innerHTML=ye),us=a(t),u(K.$$.fragment,t),rs=a(t),tt=o(t,"P",{"data-svelte-h":!0}),p(tt)!=="svelte-u9o4sn"&&(tt.textContent=je),cs=a(t),u(st.$$.fragment,t),Ms=a(t),et=o(t,"P",{"data-svelte-h":!0}),p(et)!=="svelte-18yryy0"&&(et.textContent=de),ws=a(t),u(lt.$$.fragment,t),ys=a(t),nt=o(t,"P",{"data-svelte-h":!0}),p(nt)!=="svelte-1wueeet"&&(nt.textContent=me),js=a(t),u(at.$$.fragment,t),ds=a(t),it=o(t,"P",{"data-svelte-h":!0}),p(it)!=="svelte-azbr52"&&(it.textContent=Te),ms=a(t),d=o(t,"BLOCKQUOTE",{});var Ws=Qs(d);Bt=o(Ws,"P",{"data-svelte-h":!0}),p(Bt)!=="svelte-eu81gr"&&(Bt.textContent=Je),Vs=a(Ws),u(ot.$$.fragment,Ws),Ws.forEach(e),Ts=a(t),pt=o(t,"P",{"data-svelte-h":!0}),p(pt)!=="svelte-1yqfqub"&&(pt.textContent=be),Js=a(t),u(ht.$$.fragment,t),bs=a(t),ut=o(t,"P",{"data-svelte-h":!0}),p(ut)!=="svelte-a5d62w"&&(ut.textContent=fe),fs=a(t),u(rt.$$.fragment,t),Us=a(t),ct=o(t,"P",{"data-svelte-h":!0}),p(ct)!=="svelte-1ndvzyl"&&(ct.textContent=Ue),gs=a(t),u(Mt.$$.fragment,t),Bs=a(t),wt=o(t,"P",{"data-svelte-h":!0}),p(wt)!=="svelte-1wueeet"&&(wt.textContent=ge),Is=a(t),u(yt.$$.fragment,t),_s=a(t),jt=o(t,"P",{"data-svelte-h":!0}),p(jt)!=="svelte-18w5bdv"&&(jt.textContent=Be),Cs=a(t),u(dt.$$.fragment,t),Gs=a(t),mt=o(t,"P",{"data-svelte-h":!0}),p(mt)!=="svelte-smcbfz"&&(mt.textContent=Ie),ks=a(t),u(Tt.$$.fragment,t),$s=a(t),Jt=o(t,"P",{"data-svelte-h":!0}),p(Jt)!=="svelte-1wuxk0l"&&(Jt.textContent=_e),vs=a(t),u(bt.$$.fragment,t),xs=a(t),Xs=o(t,"HR",{}),qs=a(t),ft=o(t,"P",{"data-svelte-h":!0}),p(ft)!=="svelte-1qq5buo"&&(ft.innerHTML=Ce),Zs=a(t),Ut=o(t,"P",{"data-svelte-h":!0}),p(Ut)!=="svelte-1ef9lfw"&&(Ut.innerHTML=Ge),Ys=a(t),u(gt.$$.fragment,t),Ns=a(t),_t=o(t,"P",{}),Qs(_t).forEach(e),this.h()},h(){Es(j,"name","hf:doc:metadata"),Es(j,"content",Re),$e(T.src,Ls="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/whiteboard-unit1sub3DONE.jpg")||Es(T,"src",Ls),Es(T,"alt","Unit 1 planning")},m(t,s){Fs(document.head,j),l(t,Ct,s),l(t,It,s),l(t,Gt,s),r(m,t,s),l(t,kt,s),l(t,T,s),l(t,$t,s),l(t,J,s),l(t,vt,s),l(t,b,s),l(t,xt,s),l(t,f,s),l(t,Xt,s),l(t,U,s),l(t,qt,s),l(t,g,s),l(t,Zt,s),l(t,B,s),l(t,Yt,s),l(t,I,s),l(t,Nt,s),l(t,_,s),l(t,Rt,s),l(t,C,s),l(t,Wt,s),r(G,t,s),l(t,Et,s),l(t,k,s),l(t,Vt,s),r($,t,s),l(t,Qt,s),r(v,t,s),l(t,Ft,s),l(t,x,s),l(t,At,s),r(X,t,s),l(t,zt,s),l(t,q,s),l(t,Lt,s),l(t,Z,s),l(t,Ht,s),r(Y,t,s),l(t,St,s),l(t,N,s),l(t,Pt,s),r(R,t,s),l(t,Ot,s),l(t,W,s),l(t,Dt,s),r(E,t,s),l(t,Kt,s),l(t,V,s),l(t,ts,s),r(Q,t,s),l(t,ss,s),l(t,F,s),l(t,es,s),r(A,t,s),l(t,ls,s),l(t,z,s),l(t,ns,s),l(t,L,s),l(t,as,s),l(t,H,s),l(t,is,s),r(S,t,s),l(t,os,s),l(t,P,s),l(t,ps,s),r(O,t,s),l(t,hs,s),l(t,D,s),l(t,us,s),r(K,t,s),l(t,rs,s),l(t,tt,s),l(t,cs,s),r(st,t,s),l(t,Ms,s),l(t,et,s),l(t,ws,s),r(lt,t,s),l(t,ys,s),l(t,nt,s),l(t,js,s),r(at,t,s),l(t,ds,s),l(t,it,s),l(t,ms,s),l(t,d,s),Fs(d,Bt),Fs(d,Vs),r(ot,d,null),l(t,Ts,s),l(t,pt,s),l(t,Js,s),r(ht,t,s),l(t,bs,s),l(t,ut,s),l(t,fs,s),r(rt,t,s),l(t,Us,s),l(t,ct,s),l(t,gs,s),r(Mt,t,s),l(t,Bs,s),l(t,wt,s),l(t,Is,s),r(yt,t,s),l(t,_s,s),l(t,jt,s),l(t,Cs,s),r(dt,t,s),l(t,Gs,s),l(t,mt,s),l(t,ks,s),r(Tt,t,s),l(t,$s,s),l(t,Jt,s),l(t,vs,s),r(bt,t,s),l(t,xs,s),l(t,Xs,s),l(t,qs,s),l(t,ft,s),l(t,Zs,s),l(t,Ut,s),l(t,Ys,s),r(gt,t,s),l(t,Ns,s),l(t,_t,s),Rs=!0},p:ve,i(t){Rs||(c(m.$$.fragment,t),c(G.$$.fragment,t),c($.$$.fragment,t),c(v.$$.fragment,t),c(X.$$.fragment,t),c(Y.$$.fragment,t),c(R.$$.fragment,t),c(E.$$.fragment,t),c(Q.$$.fragment,t),c(A.$$.fragment,t),c(S.$$.fragment,t),c(O.$$.fragment,t),c(K.$$.fragment,t),c(st.$$.fragment,t),c(lt.$$.fragment,t),c(at.$$.fragment,t),c(ot.$$.fragment,t),c(ht.$$.fragment,t),c(rt.$$.fragment,t),c(Mt.$$.fragment,t),c(yt.$$.fragment,t),c(dt.$$.fragment,t),c(Tt.$$.fragment,t),c(bt.$$.fragment,t),c(gt.$$.fragment,t),Rs=!0)},o(t){M(m.$$.fragment,t),M(G.$$.fragment,t),M($.$$.fragment,t),M(v.$$.fragment,t),M(X.$$.fragment,t),M(Y.$$.fragment,t),M(R.$$.fragment,t),M(E.$$.fragment,t),M(Q.$$.fragment,t),M(A.$$.fragment,t),M(S.$$.fragment,t),M(O.$$.fragment,t),M(K.$$.fragment,t),M(st.$$.fragment,t),M(lt.$$.fragment,t),M(at.$$.fragment,t),M(ot.$$.fragment,t),M(ht.$$.fragment,t),M(rt.$$.fragment,t),M(Mt.$$.fragment,t),M(yt.$$.fragment,t),M(dt.$$.fragment,t),M(Tt.$$.fragment,t),M(bt.$$.fragment,t),M(gt.$$.fragment,t),Rs=!1},d(t){t&&(e(Ct),e(It),e(Gt),e(kt),e(T),e($t),e(J),e(vt),e(b),e(xt),e(f),e(Xt),e(U),e(qt),e(g),e(Zt),e(B),e(Yt),e(I),e(Nt),e(_),e(Rt),e(C),e(Wt),e(Et),e(k),e(Vt),e(Qt),e(Ft),e(x),e(At),e(zt),e(q),e(Lt),e(Z),e(Ht),e(St),e(N),e(Pt),e(Ot),e(W),e(Dt),e(Kt),e(V),e(ts),e(ss),e(F),e(es),e(ls),e(z),e(ns),e(L),e(as),e(H),e(is),e(os),e(P),e(ps),e(hs),e(D),e(us),e(rs),e(tt),e(cs),e(Ms),e(et),e(ws),e(ys),e(nt),e(js),e(ds),e(it),e(ms),e(d),e(Ts),e(pt),e(Js),e(bs),e(ut),e(fs),e(Us),e(ct),e(gs),e(Bs),e(wt),e(Is),e(_s),e(jt),e(Cs),e(Gs),e(mt),e(ks),e($s),e(Jt),e(vs),e(xs),e(Xs),e(qs),e(ft),e(Zs),e(Ut),e(Ys),e(Ns),e(_t)),e(j),w(m,t),w(G,t),w($,t),w(v,t),w(X,t),w(Y,t),w(R,t),w(E,t),w(Q,t),w(A,t),w(S,t),w(O,t),w(K,t),w(st,t),w(lt,t),w(at,t),w(ot),w(ht,t),w(rt,t),w(Mt,t),w(yt,t),w(dt,t),w(Tt,t),w(bt,t),w(gt,t)}}}const Re='{"title":"Dummy Agent Library","local":"dummy-agent-library","sections":[{"title":"Serverless API","local":"serverless-api","sections":[],"depth":2},{"title":"Dummy Agent","local":"dummy-agent","sections":[],"depth":2}],"depth":1}';function We(zs){return xe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ze extends Xe{constructor(j){super(),qe(this,j,We,Ne,ke,{})}}export{ze as component};
