import{s as Pn,f as On,o as Dn,n as yn}from"../chunks/scheduler.25b97de1.js";import{S as Kn,i as ea,g as r,s,r as c,A as oa,h as i,f as n,c as t,j,u as d,x as M,k as U,y as l,a,v as m,d as p,t as h,w as g}from"../chunks/index.d9030fc9.js";import{T as na}from"../chunks/Tip.baa67368.js";import{D as B}from"../chunks/Docstring.e257edda.js";import{C as A}from"../chunks/CodeBlock.e6cd0d95.js";import{E as Hn}from"../chunks/ExampleCodeBlock.20db4b6e.js";import{H as J,E as aa}from"../chunks/EditOnGithub.91d95064.js";function sa(W){let f,C="<li>Llava-Onevision uses different number of patches for images and thus has to pad the inputs inside modeling code, aside from the padding done when processing the inputs. The default setting is “left-padding” if model is in <code>eval()</code> mode, otherwise “right-padding”.</li>";return{c(){f=r("ul"),f.innerHTML=C},l(v){f=i(v,"UL",{"data-svelte-h":!0}),M(f)!=="svelte-1mipndl"&&(f.innerHTML=C)},m(v,y){a(v,f,y)},p:yn,d(v){v&&n(f)}}}function ta(W){let f,C="Example:",v,y,_;return y=new A({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYXZhT25ldmlzaW9uRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTJDJTIwTGxhdmFPbmV2aXNpb25Db25maWclMkMlMjBTaWdsaXBWaXNpb25Db25maWclMkMlMjBRd2VuMkNvbmZpZyUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBDTElQLXZpc2lvbiUyMGNvbmZpZyUwQXZpc2lvbl9jb25maWclMjAlM0QlMjBTaWdsaXBWaXNpb25Db25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBMbGFtYSUyMGNvbmZpZyUwQXRleHRfY29uZmlnJTIwJTNEJTIwUXdlbjJDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBMbGF2YS1OZXh0JTIwbGxhdmEtaGYlMkZsbGF2YS1vbmV2aXNpb24tcXdlbjItN2Itb3YtaGYlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwTGxhdmFPbmV2aXNpb25Db25maWcodmlzaW9uX2NvbmZpZyUyQyUyMHRleHRfY29uZmlnKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBsbGF2YS1oZiUyRmxsYXZhLW9uZXZpc2lvbi1xd2VuMi03Yi1vdi1oZiUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwTGxhdmFPbmV2aXNpb25Gb3JDb25kaXRpb25hbEdlbmVyYXRpb24oY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlavaOnevisionForConditionalGeneration, LlavaOnevisionConfig, SiglipVisionConfig, Qwen2Config

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a CLIP-vision config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>vision_config = SiglipVisionConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Llama config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text_config = Qwen2Config()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Llava-Next llava-hf/llava-onevision-qwen2-7b-ov-hf style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = LlavaOnevisionConfig(vision_config, text_config)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the llava-hf/llava-onevision-qwen2-7b-ov-hf style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = LlavaOnevisionForConditionalGeneration(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){f=r("p"),f.textContent=C,v=s(),c(y.$$.fragment)},l(u){f=i(u,"P",{"data-svelte-h":!0}),M(f)!=="svelte-11lpom8"&&(f.textContent=C),v=t(u),d(y.$$.fragment,u)},m(u,b){a(u,f,b),a(u,v,b),m(y,u,b),_=!0},p:yn,i(u){_||(p(y.$$.fragment,u),_=!0)},o(u){h(y.$$.fragment,u),_=!1},d(u){u&&(n(f),n(v)),g(y,u)}}}function ra(W){let f,C="Example:",v,y,_;return y=new A({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBMbGF2YU9uZXZpc2lvblByb2Nlc3NvciUyQyUyMExsYXZhT25ldmlzaW9uRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBJTBBbW9kZWwlMjAlM0QlMjBMbGF2YU9uZXZpc2lvbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIybGxhdmEtaGYlMkZsbGF2YS1vbmV2aXNpb24tcXdlbjItN2Itb3YtaGYlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRCUyMmZsb2F0MTYlMjIlMkMlMjBkZXZpY2VfbWFwJTNEJTIyY3VkYSUzQTAlMjIpJTBBcHJvY2Vzc29yJTIwJTNEJTIwTGxhdmFPbmV2aXNpb25Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmxsYXZhLWhmJTJGbGxhdmEtb25ldmlzaW9uLXF3ZW4yLTdiLW92LWhmJTIyKSUwQSUwQWNvbnZlcnNhdGlvbiUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJ0ZXh0JTIyJTJDJTIwJTIydGV4dCUyMiUzQSUyMCUyMldoYXQlMjBpcyUyMHNob3duJTIwaW4lMjB0aGlzJTIwaW1hZ2UlM0YlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIyaW1hZ2UlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElNUQlMEFwcm9tcHQlMjAlM0QlMjBwcm9jZXNzb3IuYXBwbHlfY2hhdF90ZW1wbGF0ZShjb252ZXJzYXRpb24lMkMlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RUcnVlKSUwQSUwQWltYWdlX2ZpbGUlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBcmF3X2ltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQoaW1hZ2VfZmlsZSUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IodGV4dCUzRHByb21wdCUyQyUyMGltYWdlcyUzRHJhd19pbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJ3B0JykudG8oMCUyQyUyMHRvcmNoLmZsb2F0MTYpJTBBJTBBb3V0cHV0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDIwJTJDJTIwZG9fc2FtcGxlJTNERmFsc2UpJTBBcHJvY2Vzc29yLmJhdGNoX2RlY29kZShvdXRwdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlavaOnevisionProcessor, LlavaOnevisionForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>model = LlavaOnevisionForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-onevision-qwen2-7b-ov-hf&quot;</span>, torch_dtype=<span class="hljs-string">&quot;float16&quot;</span>, device_map=<span class="hljs-string">&quot;cuda:0&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = LlavaOnevisionProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-onevision-qwen2-7b-ov-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>conversation = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>      <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
<span class="hljs-meta">... </span>      <span class="hljs-string">&quot;content&quot;</span>: [
<span class="hljs-meta">... </span>          {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What is shown in this image?&quot;</span>},
<span class="hljs-meta">... </span>          {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
<span class="hljs-meta">... </span>        ],
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = processor.apply_chat_template(conversation, add_generation_prompt=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_file = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>raw_image = Image.<span class="hljs-built_in">open</span>(requests.get(image_file, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=prompt, images=raw_image, return_tensors=<span class="hljs-string">&#x27;pt&#x27;</span>).to(<span class="hljs-number">0</span>, torch.float16)

<span class="hljs-meta">&gt;&gt;&gt; </span>output = model.generate(**inputs, max_new_tokens=<span class="hljs-number">20</span>, do_sample=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.batch_decode(output, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;user\\n\\nWhat is shown in this image?\\nassistant\\ncat&quot;</span>`,wrap:!1}}),{c(){f=r("p"),f.textContent=C,v=s(),c(y.$$.fragment)},l(u){f=i(u,"P",{"data-svelte-h":!0}),M(f)!=="svelte-11lpom8"&&(f.textContent=C),v=t(u),d(y.$$.fragment,u)},m(u,b){a(u,f,b),a(u,v,b),m(y,u,b),_=!0},p:yn,i(u){_||(p(y.$$.fragment,u),_=!0)},o(u){h(y.$$.fragment,u),_=!1},d(u){u&&(n(f),n(v)),g(y,u)}}}function ia(W){let f,C,v,y,_,u,b,no,E,vn='The LLaVA-Onevision model was proposed in <a href="https://arxiv.org/abs/2408.03326" rel="nofollow">LLaVA-OneVision: Easy Visual Task Transfer</a> by &lt;Bo Li, Yuanhan Zhang, Dong Guo, Renrui Zhang, Feng Li, Hao Zhang, Kaichen Zhang, Yanwei Li, Ziwei Liu, Chunyuan Li',ao,S,_n="LLaVA-Onevision is a Vision-Language Model that can generate text conditioned on one or several images/videos. The model consists of SigLIP vision encoder and a Qwen2 language backbone. The images are processed with anyres-9 technique where the image is split into 9 patches to better process high resolution images and capture as much details as possible. However, videos are pooled to a total sequence length of 196 tokens each frame for more memory efficient computation. LLaVA-Onevision is available in three sizes: 0.5B, 7B and 72B and achieves remarkable performance on benchmark evaluations.",so,H,Un="The abstract from the paper is the following:",to,P,bn=`<em>We present LLaVA-OneVision, a family of open large multimodal models (LMMs)
developed by consolidating our insights into data, models, and visual representations in the LLaVA-NeXT blog series. Our experimental results demonstrate that
LLaVA-OneVision is the first single model that can simultaneously push the performance boundaries of open LMMs in three important computer vision scenarios:
single-image, multi-image, and video scenarios. Importantly, the design of LLaVAOneVision allows strong transfer learning across different modalities/scenarios,
yielding new emerging capabilities. In particular, strong video understanding and
cross-scenario capabilities are demonstrated through task transfer from images to
videos.</em>`,ro,k,Tn,io,O,wn='LLaVA=Onevision architecture. Taken from the <a href="https://arxiv.org/abs/2408.03326">original paper.</a>',lo,D,jn="Tips:",co,K,Jn="<li>We advise users to use <code>padding_side=&quot;left&quot;</code> when computing batched generation as it leads to more accurate results. Simply make sure to call <code>processor.tokenizer.padding_side = &quot;left&quot;</code> before generating.</li>",mo,q,po,ee,Cn="<li>Note that the model should use a specific prompt format, on which the large language model (LLM) was trained. You can use the processor’s <code>apply_chat_template</code> to format your prompts correctly. For that you have to construct a conversation history, passing a plain string will not format your prompt. Each message in the conversation history for chat templates is a dictionary with keys “role” and “content”. The “content” should be a list of dictionaries, for “text” and “image” modalities.</li>",ho,oe,In='We will use <a href="https://huggingface.co/llava-hf/llava-onevision-qwen2-7b-si-hf" rel="nofollow">llava-onevision-qwen2-7b-si-hf</a> and a conversation history of text and image. Each content field has to be a list of dicts, as follows:',go,ne,uo,ae,Zn=`This model was contributed by <a href="https://huggingface.co/RaushanTurganbay" rel="nofollow">RaushanTurganbay</a>.
The original code can be found <a href="https://github.com/LLaVA-VL/LLaVA-NeXT/tree/main" rel="nofollow">here</a>.`,fo,se,Mo,te,yo,re,xn="Here’s how to load the model and perform inference in half-precision (<code>torch.float16</code>):",vo,ie,_o,le,Uo,ce,Bn="LLaVa-Onevision can perform inference with multiple images as input, where images either belong to the same prompt or different prompts (in batched inference). For that you have to use checkpoints with an “ov” suffix. Here is how you can do it:",bo,de,To,me,wo,pe,zn="LLaVa-Onevision also can perform inference with videos as input, where video frames are treated as multiple images. Here is how you can do it:",jo,he,Jo,ge,Co,ue,Io,fe,Gn="The model can be loaded in 8 or 4 bits, greatly reducing the memory requirements while maintaining the performance of the original model. First make sure to install bitsandbytes, <code>pip install bitsandbytes</code> and make sure to have access to a CUDA compatible GPU device. Simply change the snippet above with:",Zo,Me,xo,ye,Bo,ve,Ln='First make sure to install flash-attn. Refer to the <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">original repository of Flash Attention</a> regarding that package installation. Simply change the snippet above with:',zo,_e,Go,Ue,Lo,I,be,Po,Ve,Wn=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_30079/en/model_doc/llava_onevision#transformers.LlavaOnevisionForConditionalGeneration">LlavaOnevisionForConditionalGeneration</a>. It is used to instantiate an
Llava-NeXT model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the <a href="https://huggingface.co/llava-hf/llava-onevision-qwen2-7b-ov-hf" rel="nofollow">llava-hf/llava-onevision-qwen2-7b-ov-hf</a>
model.`,Oo,Xe,kn=`Configuration objects inherit from <a href="/docs/transformers/pr_30079/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_30079/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Do,R,Wo,Te,ko,T,we,Ko,$e,qn="Constructs a LLaVa-Onevision processor which wraps a LLaVa-Onevision video processor, LLaVa-NeXT image processor and a LLaMa tokenizer into a single processor.",en,Qe,Rn=`<a href="/docs/transformers/pr_30079/en/model_doc/llava_next#transformers.LlavaNextProcessor">LlavaNextProcessor</a> offers all the functionalities of <a href="/docs/transformers/pr_30079/en/model_doc/llava_onevision#transformers.LlavaOnevisionVideoProcessor">LlavaOnevisionVideoProcessor</a>, <a href="/docs/transformers/pr_30079/en/model_doc/llava_next#transformers.LlavaNextImageProcessor">LlavaNextImageProcessor</a> and <a href="/docs/transformers/pr_30079/en/model_doc/llama#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>. See the
<a href="/docs/transformers/pr_30079/en/model_doc/deit#transformers.DeiTFeatureExtractor.__call__"><strong>call</strong>()</a>, <code>__call__()</code> and <a href="/docs/transformers/pr_30079/en/model_doc/llava_next#transformers.LlavaNextProcessor.decode">decode()</a> for more information.`,on,N,je,nn,Ye,Nn=`This method forwards all its arguments to LlamaTokenizerFast’s <a href="/docs/transformers/pr_30079/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.batch_decode">batch_decode()</a>. Please
refer to the docstring of this method for more information.`,an,V,Je,sn,Fe,Vn=`This method forwards all its arguments to LlamaTokenizerFast’s <a href="/docs/transformers/pr_30079/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.decode">decode()</a>. Please refer to
the docstring of this method for more information.`,qo,Ce,Ro,w,Ie,tn,Ae,Xn='Constructs a LLaVa-Onevisino-Video video processor. Based on <a href="/docs/transformers/pr_30079/en/model_doc/siglip#transformers.SiglipImageProcessor">SiglipImageProcessor</a> with incorporation of processing each video frame.',rn,X,Ze,ln,Ee,$n="Process an image with variable resolutions by dividing it into patches.",cn,$,xe,dn,Se,Qn=`Pads the <code>image</code> with the specified <code>padding</code> and <code>mode</code>. Padding can be in the (<code>height</code>, <code>width</code>)
dimension of in the (<code>num_patches</code>) dimension. In the second case an iterable if tuples is expected
as input.`,mn,He,Be,No,ze,Vo,z,Ge,pn,Pe,Yn='Constructs a LLaVa-Onevisino-Video video processor. Based on <a href="/docs/transformers/pr_30079/en/model_doc/siglip#transformers.SiglipImageProcessor">SiglipImageProcessor</a> with incorporation of processing each video frame.',hn,Oe,Le,Xo,We,$o,Z,ke,gn,De,Fn=`The LLaVA-Onevision model which consists of a vision backbone and a language model.
This model inherits from <a href="/docs/transformers/pr_30079/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,un,Ke,An=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,fn,Q,qe,Mn,Y,Qo,Re,Yo,oo,Fo;return _=new J({props:{title:"LLaVA-Onevision",local:"llava-onevision",headingTag:"h1"}}),b=new J({props:{title:"Overview",local:"overview",headingTag:"h2"}}),q=new na({props:{warning:!0,$$slots:{default:[sa]},$$scope:{ctx:W}}}),ne=new A({props:{code:"JTBBJTBBJTBBJTBBJTBBJTIyJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTVDbiUzQ2ltYWdlJTNFV2hhdCUyMGlzJTIwc2hvd24lMjBpbiUyMHRoaXMlMjBpbWFnZSUzRiUzQyU3Q2ltX2VuZCU3QyUzRSU1Q24lM0MlN0NpbV9zdGFydCU3QyUzRWFzc2lzdGFudCU1Q25QYWdlJTIwc2hvd2luZyUyMHRoZSUyMGxpc3QlMjBvZiUyMG9wdGlvbnMuJTNDJTdDaW1fZW5kJTdDJTNFJTIy",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-onevision-qwen2-7b-si-hf&quot;</span>)

conversation = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What’s shown in this image?&quot;</span>},
        ],
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;This image shows a red stop sign.&quot;</span>},]
    },
    {

        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Describe the image in more details.&quot;</span>},
        ],
    },
]

text_prompt = processor.apply_chat_template(conversation, add_generation_prompt=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Note that the template simply formats your prompt, you still have to tokenize it and obtain pixel values for your images</span>
<span class="hljs-built_in">print</span>(text_prompt)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-string">&quot;&lt;|im_start|&gt;user\\n&lt;image&gt;What is shown in this image?&lt;|im_end|&gt;\\n&lt;|im_start|&gt;assistant\\nPage showing the list of options.&lt;|im_end|&gt;&quot;</span>`,wrap:!1}}),se=new J({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),te=new J({props:{title:"Single image inference",local:"single-image-inference",headingTag:"h3"}}),ie=new A({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, LlavaOnevisionForConditionalGeneration
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-onevision-qwen2-7b-ov-hf&quot;</span>) 
model = LlavaOnevisionForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-onevision-qwen2-7b-ov-hf&quot;</span>, torch_dtype=torch.float16, low_cpu_mem_usage=<span class="hljs-literal">True</span>) 
model.to(<span class="hljs-string">&quot;cuda:0&quot;</span>)

<span class="hljs-comment"># prepare image and text prompt, using the appropriate prompt template</span>
url = <span class="hljs-string">&quot;https://github.com/haotian-liu/LLaVA/blob/1a91fc274d7c35a9b50b3cb29c4247ae5837ce39/images/llava_v1_5_radar.jpg?raw=true&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

conversation = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What is shown in this image?&quot;</span>},
        ],
    },
]
prompt = processor.apply_chat_template(conversation, add_generation_prompt=<span class="hljs-literal">True</span>)
inputs = processor(images=image, text=prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda:0&quot;</span>, torch.float16)

<span class="hljs-comment"># autoregressively complete prompt</span>
output = model.generate(**inputs, max_new_tokens=<span class="hljs-number">100</span>)
<span class="hljs-built_in">print</span>(processor.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
<span class="hljs-string">&#x27;user\\n\\nWhat is shown in this image?\\nassistant\\nThe image shows a radar chart, also known as a spider chart or a star chart, which is used to compare multiple quantitative variables. Each axis represents a different variable, and the chart is filled with&#x27;</span>`,wrap:!1}}),le=new J({props:{title:"Multi image inference",local:"multi-image-inference",headingTag:"h3"}}),de=new A({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, LlavaOnevisionForConditionalGeneration

<span class="hljs-comment"># Load the model in half-precision</span>
model = LlavaOnevisionForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-onevision-qwen2-7b-ov-hf&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-onevision-qwen2-7b-ov-hf&quot;</span>)

<span class="hljs-comment"># Get three different images</span>
url = <span class="hljs-string">&quot;https://www.ilankelman.org/stopsigns/australia.jpg&quot;</span>
image_stop = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
image_cats = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

url = <span class="hljs-string">&quot;https://huggingface.co/microsoft/kosmos-2-patch14-224/resolve/main/snowman.jpg&quot;</span>
image_snowman = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-comment"># Prepare a batch of two prompts, where the first one is a multi-turn conversation and the second is not</span>
conversation_1 = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What is shown in this image?&quot;</span>},
            ],
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;There is a red stop sign in the image.&quot;</span>},
            ],
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What about this image? How many cats do you see?&quot;</span>},
            ],
    },
]

conversation_2 = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What is shown in this image?&quot;</span>},
            ],
    },
]

prompt_1 = processor.apply_chat_template(conversation_1, add_generation_prompt=<span class="hljs-literal">True</span>)
prompt_2 = processor.apply_chat_template(conversation_2, add_generation_prompt=<span class="hljs-literal">True</span>)
prompts = [prompt_1, prompt_2]

<span class="hljs-comment"># We can simply feed images in the order they have to be used in the text prompt</span>
inputs = processor(images=[image_stop, image_cats, image_snowman], text=prompts, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device, torch.float16)

<span class="hljs-comment"># Generate</span>
generate_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">30</span>)
processor.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)
[<span class="hljs-string">&#x27;user\\n\\nWhat is shown in this image?\\nassistant\\nThere is a red stop sign in the image.\\nuser\\n\\nWhat about this image? How many cats do you see?\\nassistant\\ntwo&#x27;</span>, <span class="hljs-string">&#x27;user\\n\\nWhat is shown in this image?\\nassistant\\n&#x27;</span>]`,wrap:!1}}),me=new J({props:{title:"Video inference",local:"video-inference",headingTag:"h3"}}),he=new A({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> av
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download

<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, LlavaOnevisionForConditionalGeneration

<span class="hljs-comment"># Load the model in half-precision</span>
model = LlavaOnevisionForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-onevision-qwen2-7b-ov-hf&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-onevision-qwen2-7b-ov-hf&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">read_video_pyav</span>(<span class="hljs-params">container, indices</span>):
    <span class="hljs-string">&#x27;&#x27;&#x27;
    Decode the video with PyAV decoder.
    Args:
        container (\`av.container.input.InputContainer\`): PyAV container.
        indices (\`List[int]\`): List of frame indices to decode.
    Returns:
        result (np.ndarray): np array of decoded frames of shape (num_frames, height, width, 3).
    &#x27;&#x27;&#x27;</span>
    frames = []
    container.seek(<span class="hljs-number">0</span>)
    start_index = indices[<span class="hljs-number">0</span>]
    end_index = indices[-<span class="hljs-number">1</span>]
    <span class="hljs-keyword">for</span> i, frame <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(container.decode(video=<span class="hljs-number">0</span>)):
        <span class="hljs-keyword">if</span> i &gt; end_index:
            <span class="hljs-keyword">break</span>
        <span class="hljs-keyword">if</span> i &gt;= start_index <span class="hljs-keyword">and</span> i <span class="hljs-keyword">in</span> indices:
            frames.append(frame)
    <span class="hljs-keyword">return</span> np.stack([x.to_ndarray(<span class="hljs-built_in">format</span>=<span class="hljs-string">&quot;rgb24&quot;</span>) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> frames])

<span class="hljs-comment"># Load the video as an np.array, sampling uniformly 8 frames (can sample more for longer videos, up to 32 frames)</span>
video_path = hf_hub_download(repo_id=<span class="hljs-string">&quot;raushan-testing-hf/videos-test&quot;</span>, filename=<span class="hljs-string">&quot;sample_demo_1.mp4&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
container = av.<span class="hljs-built_in">open</span>(video_path)
total_frames = container.streams.video[<span class="hljs-number">0</span>].frames
indices = np.arange(<span class="hljs-number">0</span>, total_frames, total_frames / <span class="hljs-number">8</span>).astype(<span class="hljs-built_in">int</span>)
video = read_video_pyav(container, indices)

<span class="hljs-comment"># For videos we have to feed a &quot;video&quot; type instead of &quot;image&quot;</span>
conversation = [
    {

        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;video&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Why is this video funny?&quot;</span>},
            ],
    },
]

prompt = processor.apply_chat_template(conversation, add_generation_prompt=<span class="hljs-literal">True</span>)
inputs = processor(videos=<span class="hljs-built_in">list</span>(video), text=prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda:0&quot;</span>, torch.float16)

out = model.generate(**inputs, max_new_tokens=<span class="hljs-number">60</span>)
processor.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&quot;user\\n\\nWhy is this video funny?\\nassistant\\nThe video appears to be humorous because it shows a young child, who is wearing glasses and holding a book, seemingly reading with a serious and focused expression. The child&#x27;s glasses are a bit oversized for their face, which adds a comical touch, as it&#x27;s a common trope to see children wearing&quot;</span>]`,wrap:!1}}),ge=new J({props:{title:"Model optimization",local:"model-optimization",headingTag:"h2"}}),ue=new J({props:{title:"Quantization using Bitsandbytes",local:"quantization-using-bitsandbytes",headingTag:"h3"}}),Me=new A({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYXZhT25ldmlzaW9uRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBJTIzJTIwc3BlY2lmeSUyMGhvdyUyMHRvJTIwcXVhbnRpemUlMjB0aGUlMjBtb2RlbCUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X3F1YW50X3R5cGUlM0QlMjJuZjQlMjIlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9jb21wdXRlX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSklMEElMEFtb2RlbCUyMCUzRCUyMExsYXZhT25ldmlzaW9uRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudGl6YXRpb25fY29uZmlnJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlavaOnevisionForConditionalGeneration, BitsAndBytesConfig

<span class="hljs-comment"># specify how to quantize the model</span>
quantization_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
    bnb_4bit_compute_dtype=torch.float16,
)

model = LlavaOnevisionForConditionalGeneration.from_pretrained(model_id, quantization_config=quantization_config, device_map=<span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),ye=new J({props:{title:"Use Flash-Attention 2 to further speed-up generation",local:"use-flash-attention-2-to-further-speed-up-generation",headingTag:"h3"}}),_e=new A({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYXZhT25ldmlzaW9uRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBJTBBbW9kZWwlMjAlM0QlMjBMbGF2YU9uZXZpc2lvbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMjAlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjAlMEElMjAlMjAlMjAlMjBsb3dfY3B1X21lbV91c2FnZSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjB1c2VfZmxhc2hfYXR0ZW50aW9uXzIlM0RUcnVlJTBBKS50bygwKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlavaOnevisionForConditionalGeneration

model = LlavaOnevisionForConditionalGeneration.from_pretrained(
    model_id, 
    torch_dtype=torch.float16, 
    low_cpu_mem_usage=<span class="hljs-literal">True</span>,
    use_flash_attention_2=<span class="hljs-literal">True</span>
).to(<span class="hljs-number">0</span>)`,wrap:!1}}),Ue=new J({props:{title:"LlavaOnevisionConfig",local:"transformers.LlavaOnevisionConfig",headingTag:"h2"}}),be=new B({props:{name:"class transformers.LlavaOnevisionConfig",anchor:"transformers.LlavaOnevisionConfig",parameters:[{name:"vision_config",val:" = None"},{name:"text_config",val:" = None"},{name:"image_token_index",val:" = 151646"},{name:"video_token_index",val:" = 151647"},{name:"projector_hidden_act",val:" = 'gelu'"},{name:"vision_feature_select_strategy",val:" = 'full'"},{name:"vision_feature_layer",val:" = -1"},{name:"vision_aspect_ratio",val:" = 'anyres_max_9'"},{name:"image_grid_pinpoints",val:" = None"},{name:"tie_word_embeddings",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlavaOnevisionConfig.vision_config",description:`<strong>vision_config</strong> (<code>Union[AutoConfig, dict]</code>,  <em>optional</em>, defaults to <code>SiglipVisionConfig</code>) &#x2014;
The config object or dictionary of the vision backbone.`,name:"vision_config"},{anchor:"transformers.LlavaOnevisionConfig.text_config",description:`<strong>text_config</strong> (<code>Union[AutoConfig, dict]</code>, <em>optional</em>, defaults to <code>Qwen2Config</code>) &#x2014;
The config object or dictionary of the text backbone.`,name:"text_config"},{anchor:"transformers.LlavaOnevisionConfig.image_token_index",description:`<strong>image_token_index</strong> (<code>int</code>, <em>optional</em>, defaults to 151646) &#x2014;
The image token index to encode the image prompt.`,name:"image_token_index"},{anchor:"transformers.LlavaOnevisionConfig.video_token_index",description:`<strong>video_token_index</strong> (<code>int</code>, <em>optional</em>, defaults to 151647) &#x2014;
The video token index to encode the video prompt.`,name:"video_token_index"},{anchor:"transformers.LlavaOnevisionConfig.projector_hidden_act",description:`<strong>projector_hidden_act</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The activation function used by the multimodal projector.`,name:"projector_hidden_act"},{anchor:"transformers.LlavaOnevisionConfig.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;full&quot;</code>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Can be one of <code>&quot;default&quot;</code> or <code>&quot;full&quot;</code>. If <code>&quot;default&quot;</code>, the CLS token is removed from the vision features.
If <code>&quot;full&quot;</code>, the full vision features are used.`,name:"vision_feature_select_strategy"},{anchor:"transformers.LlavaOnevisionConfig.vision_feature_layer",description:`<strong>vision_feature_layer</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
The index of the layer to select the vision feature.`,name:"vision_feature_layer"},{anchor:"transformers.LlavaOnevisionConfig.vision_aspect_ratio",description:`<strong>vision_aspect_ratio</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;anyres_max_9&quot;</code>) &#x2014;
Aspect ratio used when processong image features. The default value is &#x201C;anyres_max_9&#x201D;.`,name:"vision_aspect_ratio"},{anchor:"transformers.LlavaOnevisionConfig.image_grid_pinpoints",description:`<strong>image_grid_pinpoints</strong> (<code>List</code>, <em>optional</em>) &#x2014;
A list of possible resolutions to use for processing high resolution images. Each item in the list should be a tuple or list
of the form <code>(height, width)</code>.`,name:"image_grid_pinpoints"},{anchor:"transformers.LlavaOnevisionConfig.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the model&#x2019;s input and output word embeddings should be tied.`,name:"tie_word_embeddings"}],source:"https://github.com/huggingface/transformers/blob/vr_30079/src/transformers/models/llava_onevision/configuration_llava_onevision.py#L27"}}),R=new Hn({props:{anchor:"transformers.LlavaOnevisionConfig.example",$$slots:{default:[ta]},$$scope:{ctx:W}}}),Te=new J({props:{title:"LlavaOnevisionProcessor",local:"transformers.LlavaOnevisionProcessor",headingTag:"h2"}}),we=new B({props:{name:"class transformers.LlavaOnevisionProcessor",anchor:"transformers.LlavaOnevisionProcessor",parameters:[{name:"image_processor",val:" = None"},{name:"tokenizer",val:" = None"},{name:"video_processor",val:" = None"},{name:"num_image_tokens",val:" = None"},{name:"vision_feature_select_strategy",val:" = None"},{name:"chat_template",val:" = None"},{name:"image_token",val:" = '<image>'"},{name:"video_token",val:" = '<video>'"},{name:"**kwargs",val:": Unpack"}],parametersDescription:[{anchor:"transformers.LlavaOnevisionProcessor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/pr_30079/en/model_doc/llava_next#transformers.LlavaNextImageProcessor">LlavaNextImageProcessor</a>, <em>optional</em>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.LlavaOnevisionProcessor.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/pr_30079/en/model_doc/llama#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>, <em>optional</em>) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"},{anchor:"transformers.LlavaOnevisionProcessor.video_processor",description:`<strong>video_processor</strong> (<a href="/docs/transformers/pr_30079/en/model_doc/llava_onevision#transformers.LlavaOnevisionVideoProcessor">LlavaOnevisionVideoProcessor</a>, <em>optional</em>) &#x2014;
The video processor is a required input.`,name:"video_processor"},{anchor:"transformers.LlavaOnevisionProcessor.num_image_tokens",description:`<strong>num_image_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of image tokens for one imagethat will be returned by vision tower.`,name:"num_image_tokens"},{anchor:"transformers.LlavaOnevisionProcessor.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Shoudl be same as in model&#x2019;s config`,name:"vision_feature_select_strategy"},{anchor:"transformers.LlavaOnevisionProcessor.chat_template",description:`<strong>chat_template</strong> (<code>str</code>, <em>optional</em>) &#x2014; A Jinja template which will be used to convert lists of messages
in a chat into a tokenizable string.`,name:"chat_template"},{anchor:"transformers.LlavaOnevisionProcessor.image_token",description:`<strong>image_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;image&gt;&quot;</code>) &#x2014;
Special token used to denote image location.`,name:"image_token"},{anchor:"transformers.LlavaOnevisionProcessor.video_token",description:`<strong>video_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;video&gt;&quot;</code>) &#x2014;
Special token used to denote video location.`,name:"video_token"}],source:"https://github.com/huggingface/transformers/blob/vr_30079/src/transformers/models/llava_onevision/processing_llava_onevision.py#L50"}}),je=new B({props:{name:"batch_decode",anchor:"transformers.LlavaOnevisionProcessor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30079/src/transformers/models/llava_onevision/processing_llava_onevision.py#L254"}}),Je=new B({props:{name:"decode",anchor:"transformers.LlavaOnevisionProcessor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30079/src/transformers/models/llava_onevision/processing_llava_onevision.py#L262"}}),Ce=new J({props:{title:"LlavaOnevisionImageProcessor",local:"transformers.LlavaOnevisionImageProcessor",headingTag:"h2"}}),Ie=new B({props:{name:"class transformers.LlavaOnevisionImageProcessor",anchor:"transformers.LlavaOnevisionImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": Dict = None"},{name:"image_grid_pinpoints",val:": List = None"},{name:"resample",val:": Resampling = <Resampling.BICUBIC: 3>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": Union = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"do_pad",val:": Optional = True"},{name:"do_convert_rgb",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlavaOnevisionImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by
<code>do_resize</code> in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.LlavaOnevisionImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;shortest_edge&quot; -- 224}</code>):
Size of the image after resizing. The shortest edge of the image is resized to size[&#x201C;shortest_edge&#x201D;], with
the longest edge resized to keep the input aspect ratio. Can be overridden by <code>size</code> in the <code>preprocess</code>
method.`,name:"size"},{anchor:"transformers.LlavaOnevisionImageProcessor.image_grid_pinpoints",description:`<strong>image_grid_pinpoints</strong> (<code>List</code> <em>optional</em>, defaults to <code>[[672, 336], [336, 672], [672, 672], [336, 1008], [1008, 336]]</code>) &#x2014;
A list of possible resolutions to use for processing high resolution images. The best resolution is selected
based on the original size of the image. Can be overridden by <code>image_grid_pinpoints</code> in the <code>preprocess</code>
method. Not used for processinf videos.`,name:"image_grid_pinpoints"},{anchor:"transformers.LlavaOnevisionImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BICUBIC</code>) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by <code>resample</code> in the <code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.LlavaOnevisionImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by <code>do_rescale</code> in
the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.LlavaOnevisionImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by <code>rescale_factor</code> in the <code>preprocess</code>
method.`,name:"rescale_factor"},{anchor:"transformers.LlavaOnevisionImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by <code>do_normalize</code> in the <code>preprocess</code> method.`,name:"do_normalize"},{anchor:"transformers.LlavaOnevisionImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>[0.48145466, 0.4578275, 0.40821073]</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.LlavaOnevisionImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>[0.26862954, 0.26130258, 0.27577711]</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.
Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.LlavaOnevisionImageProcessor.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to pad the image. If <code>True</code>, will pad the patch dimension of the images in the batch to the largest
number of patches in the batch. Padding will be applied to the bottom and right with zeros.`,name:"do_pad"},{anchor:"transformers.LlavaOnevisionImageProcessor.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"}],source:"https://github.com/huggingface/transformers/blob/vr_30079/src/transformers/models/llava_onevision/image_processing_llava_onevision.py#L144"}}),Ze=new B({props:{name:"get_image_patches",anchor:"transformers.LlavaOnevisionImageProcessor.get_image_patches",parameters:[{name:"image",val:": array"},{name:"grid_pinpoints",val:""},{name:"size",val:": tuple"},{name:"patch_size",val:": int"},{name:"resample",val:": Resampling"},{name:"data_format",val:": ChannelDimension"},{name:"input_data_format",val:": ChannelDimension"}],parametersDescription:[{anchor:"transformers.LlavaOnevisionImageProcessor.get_image_patches.image",description:`<strong>image</strong> (np.array) &#x2014;
The input image to be processed.`,name:"image"},{anchor:"transformers.LlavaOnevisionImageProcessor.get_image_patches.grid_pinpoints",description:`<strong>grid_pinpoints</strong> (List) &#x2014;
A string representation of a list of possible resolutions.`,name:"grid_pinpoints"},{anchor:"transformers.LlavaOnevisionImageProcessor.get_image_patches.size",description:`<strong>size</strong> (<code>tuple</code>) &#x2014;
Size to resize the original image to.`,name:"size"},{anchor:"transformers.LlavaOnevisionImageProcessor.get_image_patches.patch_size",description:`<strong>patch_size</strong> (<code>int</code>) &#x2014;
Size of the patches to divide the image into.`,name:"patch_size"},{anchor:"transformers.LlavaOnevisionImageProcessor.get_image_patches.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>) &#x2014;
Resampling filter to use if resizing the image.`,name:"resample"},{anchor:"transformers.LlavaOnevisionImageProcessor.get_image_patches.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>) &#x2014;
The channel dimension format for the output image.`,name:"data_format"},{anchor:"transformers.LlavaOnevisionImageProcessor.get_image_patches.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>) &#x2014;
The channel dimension format of the input image.`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/vr_30079/src/transformers/models/llava_onevision/image_processing_llava_onevision.py#L373",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of NumPy arrays containing the processed image patches.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List[np.array]</p>
`}}),xe=new B({props:{name:"pad",anchor:"transformers.LlavaOnevisionImageProcessor.pad",parameters:[{name:"image",val:": ndarray"},{name:"padding",val:": Union"},{name:"mode",val:": PaddingMode = <PaddingMode.CONSTANT: 'constant'>"},{name:"constant_values",val:": Union = 0.0"},{name:"data_format",val:": Union = None"},{name:"input_data_format",val:": Union = None"}],parametersDescription:[{anchor:"transformers.LlavaOnevisionImageProcessor.pad.image",description:`<strong>image</strong> (<code>np.ndarray</code>) &#x2014;
The image to pad.`,name:"image"},{anchor:"transformers.LlavaOnevisionImageProcessor.pad.padding",description:`<strong>padding</strong> (<code>int</code> or <code>Tuple[int, int]</code> or <code>Iterable[Tuple[int, int]]</code>) &#x2014;
Padding to apply to the edges of the height, width axes. Can be one of three formats:<ul>
<li><code>((before_height, after_height), (before_width, after_width))</code> unique pad widths for each axis.</li>
<li><code>((before, after),)</code> yields same before and after pad for height and width.</li>
<li><code>(pad,)</code> or int is a shortcut for before = after = pad width for all axes.</li>
</ul>`,name:"padding"},{anchor:"transformers.LlavaOnevisionImageProcessor.pad.mode",description:`<strong>mode</strong> (<code>PaddingMode</code>) &#x2014;
The padding mode to use. Can be one of:<ul>
<li><code>&quot;constant&quot;</code>: pads with a constant value.</li>
<li><code>&quot;reflect&quot;</code>: pads with the reflection of the vector mirrored on the first and last values of the
vector along each axis.</li>
<li><code>&quot;replicate&quot;</code>: pads with the replication of the last value on the edge of the array along each axis.</li>
<li><code>&quot;symmetric&quot;</code>: pads with the reflection of the vector mirrored along the edge of the array.</li>
</ul>`,name:"mode"},{anchor:"transformers.LlavaOnevisionImageProcessor.pad.constant_values",description:`<strong>constant_values</strong> (<code>float</code> or <code>Iterable[float]</code>, <em>optional</em>) &#x2014;
The value to use for the padding if <code>mode</code> is <code>&quot;constant&quot;</code>.`,name:"constant_values"},{anchor:"transformers.LlavaOnevisionImageProcessor.pad.data_format",description:`<strong>data_format</strong> (<code>str</code> or <code>ChannelDimension</code>, <em>optional</em>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.
If unset, will use same as the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.LlavaOnevisionImageProcessor.pad.input_data_format",description:`<strong>input_data_format</strong> (<code>str</code> or <code>ChannelDimension</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.
If unset, will use the inferred format of the input image.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/vr_30079/src/transformers/models/llava_onevision/image_processing_llava_onevision.py#L260",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The padded image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>np.ndarray</code></p>
`}}),Be=new B({props:{name:"preprocess",anchor:"transformers.LlavaOnevisionImageProcessor.preprocess",parameters:[{name:"images",val:": Union"},{name:"do_resize",val:": bool = None"},{name:"size",val:": Dict = None"},{name:"image_grid_pinpoints",val:": List = None"},{name:"resample",val:": Resampling = None"},{name:"do_rescale",val:": bool = None"},{name:"rescale_factor",val:": float = None"},{name:"do_normalize",val:": bool = None"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"do_pad",val:": Optional = None"},{name:"do_convert_rgb",val:": bool = None"},{name:"return_tensors",val:": Union = None"},{name:"data_format",val:": Optional = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": Union = None"}],parametersDescription:[{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>torch.Tensor</code>, <code>List[PIL.Image.Image]</code>, <code>List[np.ndarray]</code>, <code>List[torch.Tensor]</code>) &#x2014;
The image or batch of images to be prepared. Each image can be a PIL image, NumPy array or PyTorch
tensor. Both channels-first and channels-last formats are supported.`,name:"images"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after resizing. Shortest edge of the image is resized to size[&#x201C;shortest_edge&#x201D;], with
the longest edge resized to keep the input aspect ratio.`,name:"size"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.image_grid_pinpoints",description:`<strong>image_grid_pinpoints</strong> (<code>List</code> <em>optional</em>, defaults to <code>self.image_grid_pinpoints</code>) &#x2014;
A list of possible resolutions to use for processing high resolution images. The best resolution is
selected based on the original size of the image.`,name:"image_grid_pinpoints"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_pad</code>) &#x2014;
Whether to pad the image. If <code>True</code>, will pad the patch dimension of the images in the batch to the largest
number of patches in the batch. Padding will be applied to the bottom and right with zeros.`,name:"do_pad"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_convert_rgb</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/vr_30079/src/transformers/models/llava_onevision/image_processing_llava_onevision.py#L552"}}),ze=new J({props:{title:"LlavaOnevisionVideoProcessor",local:"transformers.LlavaOnevisionVideoProcessor",headingTag:"h2"}}),Ge=new B({props:{name:"class transformers.LlavaOnevisionVideoProcessor",anchor:"transformers.LlavaOnevisionVideoProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": Dict = None"},{name:"resample",val:": Resampling = <Resampling.BICUBIC: 3>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": Union = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"do_convert_rgb",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlavaOnevisionVideoProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by
<code>do_resize</code> in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.LlavaOnevisionVideoProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;shortest_edge&quot; -- 224}</code>):
Size of the image after resizing. The shortest edge of the image is resized to size[&#x201C;shortest_edge&#x201D;], with
the longest edge resized to keep the input aspect ratio. Can be overridden by <code>size</code> in the <code>preprocess</code>
method.`,name:"size"},{anchor:"transformers.LlavaOnevisionVideoProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BICUBIC</code>) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by <code>resample</code> in the <code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.LlavaOnevisionVideoProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by <code>do_rescale</code> in
the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.LlavaOnevisionVideoProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by <code>rescale_factor</code> in the <code>preprocess</code>
method.`,name:"rescale_factor"},{anchor:"transformers.LlavaOnevisionVideoProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by <code>do_normalize</code> in the <code>preprocess</code> method.`,name:"do_normalize"},{anchor:"transformers.LlavaOnevisionVideoProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>[0.48145466, 0.4578275, 0.40821073]</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.LlavaOnevisionVideoProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>[0.26862954, 0.26130258, 0.27577711]</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.
Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.LlavaOnevisionVideoProcessor.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"}],source:"https://github.com/huggingface/transformers/blob/vr_30079/src/transformers/models/llava_onevision/video_processing_llava_onevision.py#L65"}}),Le=new B({props:{name:"preprocess",anchor:"transformers.LlavaOnevisionVideoProcessor.preprocess",parameters:[{name:"videos",val:": Union"},{name:"do_resize",val:": bool = None"},{name:"size",val:": Dict = None"},{name:"resample",val:": Resampling = None"},{name:"do_rescale",val:": bool = None"},{name:"rescale_factor",val:": float = None"},{name:"do_normalize",val:": bool = None"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"do_convert_rgb",val:": bool = None"},{name:"return_tensors",val:": Union = None"},{name:"data_format",val:": Optional = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": Union = None"}],parametersDescription:[{anchor:"transformers.LlavaOnevisionVideoProcessor.preprocess.videos",description:`<strong>videos</strong> (<code>np.ndarray</code>, <code>torch.Tensor</code>, <code>List[np.ndarray]</code>, <code>List[torch.Tensor]</code>) &#x2014;
The image or batch of videos to be prepared. Each video can be a 4D NumPy array or PyTorch`,name:"videos"},{anchor:"transformers.LlavaOnevisionVideoProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.LlavaOnevisionVideoProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after resizing. Shortest edge of the image is resized to size[&#x201C;shortest_edge&#x201D;], with
the longest edge resized to keep the input aspect ratio.`,name:"size"},{anchor:"transformers.LlavaOnevisionVideoProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.LlavaOnevisionVideoProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.LlavaOnevisionVideoProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.LlavaOnevisionVideoProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.LlavaOnevisionVideoProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.LlavaOnevisionVideoProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.LlavaOnevisionVideoProcessor.preprocess.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_convert_rgb</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.LlavaOnevisionVideoProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.LlavaOnevisionVideoProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.LlavaOnevisionVideoProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/vr_30079/src/transformers/models/llava_onevision/video_processing_llava_onevision.py#L218"}}),We=new J({props:{title:"LlavaOnevisionForConditionalGeneration",local:"transformers.LlavaOnevisionForConditionalGeneration",headingTag:"h2"}}),ke=new B({props:{name:"class transformers.LlavaOnevisionForConditionalGeneration",anchor:"transformers.LlavaOnevisionForConditionalGeneration",parameters:[{name:"config",val:": LlavaOnevisionConfig"}],parametersDescription:[{anchor:"transformers.LlavaOnevisionForConditionalGeneration.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30079/en/model_doc/llava_next#transformers.LlavaNextConfig">LlavaNextConfig</a> or <code>LlavaNextVisionConfig</code>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/pr_30079/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30079/src/transformers/models/llava_onevision/modeling_llava_onevision.py#L349"}}),qe=new B({props:{name:"forward",anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"pixel_values",val:": FloatTensor = None"},{name:"image_sizes",val:": Optional = None"},{name:"pixel_values_videos",val:": FloatTensor = None"},{name:"image_sizes_videos",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"vision_feature_layer",val:": Optional = None"},{name:"vision_feature_select_strategy",val:": Optional = None"},{name:"vision_aspect_ratio",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"cache_position",val:": Optional = None"},{name:"num_logits_to_keep",val:": int = 0"}],parametersDescription:[{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30079/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30079/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30079/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape \`(batch_size, num_channels, image_size, image_size)) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<a href="/docs/transformers/pr_30079/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/pr_30079/en/model_doc/deit#transformers.DeiTFeatureExtractor.__call__">LlavaNextImageProcessor.<strong>call</strong>()</a> for details. <a href="/docs/transformers/pr_30079/en/model_doc/llava#transformers.LlavaProcessor">LlavaProcessor</a> uses
<a href="/docs/transformers/pr_30079/en/model_doc/llava_next#transformers.LlavaNextImageProcessor">LlavaNextImageProcessor</a> for processing images.`,name:"pixel_values"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.image_sizes",description:`<strong>image_sizes</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2)</code>, <em>optional</em>) &#x2014;
The sizes of the images in the batch, being (height, width) for each image.`,name:"image_sizes"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.pixel_values_videos",description:'<strong>pixel_values_videos</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, frames, num_channels, image_size, image_size)) -- The tensors corresponding to the input videos. Pixel values can be obtained using [LlavaNextVideoProcessor](/docs/transformers/pr_30079/en/model_doc/llava_next_video#transformers.LlavaNextVideoProcessor). See </code>LlavaNextVideoProcessor.<strong>call</strong>()` for details. <a href="/docs/transformers/pr_30079/en/model_doc/llava#transformers.LlavaProcessor">LlavaProcessor</a> uses\n<a href="/docs/transformers/pr_30079/en/model_doc/llava_next_video#transformers.LlavaNextVideoProcessor">LlavaNextVideoProcessor</a> for processing videos.',name:"pixel_values_videos"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.image_sizes_videos",description:`<strong>image_sizes_videos</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, frames, 2)</code>, <em>optional</em>) &#x2014;
The sizes of the videos in the batch, being (height, width) for each frame in the video.`,name:"image_sizes_videos"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30079/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30079/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30079/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>. <a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.vision_feature_layer",description:`<strong>vision_feature_layer</strong> (<code>int</code>, <em>optional</em>, defaults to -2) &#x2014;
The index of the layer to select the vision feature.`,name:"vision_feature_layer"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;default&quot;</code>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Can be one of <code>&quot;default&quot;</code> or <code>&quot;full&quot;</code>. If <code>&quot;default&quot;</code>, the CLS token is removed from the vision features.
If <code>&quot;full&quot;</code>, the full vision features are used.`,name:"vision_feature_select_strategy"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.vision_aspect_ratio",description:`<strong>vision_aspect_ratio</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;anyres_max_9&quot;</code>) &#x2014;
Aspect ratio used when processong image features. The default value is &#x201C;anyres_max_9&#x201D;.`,name:"vision_aspect_ratio"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30079/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.</p>
<p>Args &#x2014;
labels (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>):
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.</p>
<p>num_logits_to_keep (<code>int</code>, <em>optional</em>):
Calculate logits for the last <code>num_logits_to_keep</code> tokens. If <code>0</code>, calculate logits for all
<code>input_ids</code> (special case). Only last token logits are needed for generation, and calculating them only for that
token can save memory, which becomes pretty significant for long sequences or large vocabulary size.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/vr_30079/src/transformers/models/llava_onevision/modeling_llava_onevision.py#L478",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~LlavaOnevisionCausalLMOutputWithPast</code> (if <code>return_dict=True</code>) or a <code>tuple</code>.</p>
`}}),Y=new Hn({props:{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.example",$$slots:{default:[ra]},$$scope:{ctx:W}}}),Re=new aa({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/llava_onevision.md"}}),{c(){f=r("meta"),C=s(),v=r("p"),y=s(),c(_.$$.fragment),u=s(),c(b.$$.fragment),no=s(),E=r("p"),E.innerHTML=vn,ao=s(),S=r("p"),S.textContent=_n,so=s(),H=r("p"),H.textContent=Un,to=s(),P=r("p"),P.innerHTML=bn,ro=s(),k=r("img"),io=s(),O=r("small"),O.innerHTML=wn,lo=s(),D=r("p"),D.textContent=jn,co=s(),K=r("ul"),K.innerHTML=Jn,mo=s(),c(q.$$.fragment),po=s(),ee=r("ul"),ee.innerHTML=Cn,ho=s(),oe=r("p"),oe.innerHTML=In,go=s(),c(ne.$$.fragment),uo=s(),ae=r("p"),ae.innerHTML=Zn,fo=s(),c(se.$$.fragment),Mo=s(),c(te.$$.fragment),yo=s(),re=r("p"),re.innerHTML=xn,vo=s(),c(ie.$$.fragment),_o=s(),c(le.$$.fragment),Uo=s(),ce=r("p"),ce.textContent=Bn,bo=s(),c(de.$$.fragment),To=s(),c(me.$$.fragment),wo=s(),pe=r("p"),pe.textContent=zn,jo=s(),c(he.$$.fragment),Jo=s(),c(ge.$$.fragment),Co=s(),c(ue.$$.fragment),Io=s(),fe=r("p"),fe.innerHTML=Gn,Zo=s(),c(Me.$$.fragment),xo=s(),c(ye.$$.fragment),Bo=s(),ve=r("p"),ve.innerHTML=Ln,zo=s(),c(_e.$$.fragment),Go=s(),c(Ue.$$.fragment),Lo=s(),I=r("div"),c(be.$$.fragment),Po=s(),Ve=r("p"),Ve.innerHTML=Wn,Oo=s(),Xe=r("p"),Xe.innerHTML=kn,Do=s(),c(R.$$.fragment),Wo=s(),c(Te.$$.fragment),ko=s(),T=r("div"),c(we.$$.fragment),Ko=s(),$e=r("p"),$e.textContent=qn,en=s(),Qe=r("p"),Qe.innerHTML=Rn,on=s(),N=r("div"),c(je.$$.fragment),nn=s(),Ye=r("p"),Ye.innerHTML=Nn,an=s(),V=r("div"),c(Je.$$.fragment),sn=s(),Fe=r("p"),Fe.innerHTML=Vn,qo=s(),c(Ce.$$.fragment),Ro=s(),w=r("div"),c(Ie.$$.fragment),tn=s(),Ae=r("p"),Ae.innerHTML=Xn,rn=s(),X=r("div"),c(Ze.$$.fragment),ln=s(),Ee=r("p"),Ee.textContent=$n,cn=s(),$=r("div"),c(xe.$$.fragment),dn=s(),Se=r("p"),Se.innerHTML=Qn,mn=s(),He=r("div"),c(Be.$$.fragment),No=s(),c(ze.$$.fragment),Vo=s(),z=r("div"),c(Ge.$$.fragment),pn=s(),Pe=r("p"),Pe.innerHTML=Yn,hn=s(),Oe=r("div"),c(Le.$$.fragment),Xo=s(),c(We.$$.fragment),$o=s(),Z=r("div"),c(ke.$$.fragment),gn=s(),De=r("p"),De.innerHTML=Fn,un=s(),Ke=r("p"),Ke.innerHTML=An,fn=s(),Q=r("div"),c(qe.$$.fragment),Mn=s(),c(Y.$$.fragment),Qo=s(),c(Re.$$.fragment),Yo=s(),oo=r("p"),this.h()},l(e){const o=oa("svelte-u9bgzb",document.head);f=i(o,"META",{name:!0,content:!0}),o.forEach(n),C=t(e),v=i(e,"P",{}),j(v).forEach(n),y=t(e),d(_.$$.fragment,e),u=t(e),d(b.$$.fragment,e),no=t(e),E=i(e,"P",{"data-svelte-h":!0}),M(E)!=="svelte-1h0dj41"&&(E.innerHTML=vn),ao=t(e),S=i(e,"P",{"data-svelte-h":!0}),M(S)!=="svelte-1v5go9y"&&(S.textContent=_n),so=t(e),H=i(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-vfdo9a"&&(H.textContent=Un),to=t(e),P=i(e,"P",{"data-svelte-h":!0}),M(P)!=="svelte-e9kp7g"&&(P.innerHTML=bn),ro=t(e),k=i(e,"IMG",{src:!0,alt:!0,width:!0}),io=t(e),O=i(e,"SMALL",{"data-svelte-h":!0}),M(O)!=="svelte-i8yy3p"&&(O.innerHTML=wn),lo=t(e),D=i(e,"P",{"data-svelte-h":!0}),M(D)!=="svelte-axv494"&&(D.textContent=jn),co=t(e),K=i(e,"UL",{"data-svelte-h":!0}),M(K)!=="svelte-b32abk"&&(K.innerHTML=Jn),mo=t(e),d(q.$$.fragment,e),po=t(e),ee=i(e,"UL",{"data-svelte-h":!0}),M(ee)!=="svelte-1vjnybt"&&(ee.innerHTML=Cn),ho=t(e),oe=i(e,"P",{"data-svelte-h":!0}),M(oe)!=="svelte-1x1wp4w"&&(oe.innerHTML=In),go=t(e),d(ne.$$.fragment,e),uo=t(e),ae=i(e,"P",{"data-svelte-h":!0}),M(ae)!=="svelte-18dym15"&&(ae.innerHTML=Zn),fo=t(e),d(se.$$.fragment,e),Mo=t(e),d(te.$$.fragment,e),yo=t(e),re=i(e,"P",{"data-svelte-h":!0}),M(re)!=="svelte-19yw9ck"&&(re.innerHTML=xn),vo=t(e),d(ie.$$.fragment,e),_o=t(e),d(le.$$.fragment,e),Uo=t(e),ce=i(e,"P",{"data-svelte-h":!0}),M(ce)!=="svelte-137kflk"&&(ce.textContent=Bn),bo=t(e),d(de.$$.fragment,e),To=t(e),d(me.$$.fragment,e),wo=t(e),pe=i(e,"P",{"data-svelte-h":!0}),M(pe)!=="svelte-3p5p1a"&&(pe.textContent=zn),jo=t(e),d(he.$$.fragment,e),Jo=t(e),d(ge.$$.fragment,e),Co=t(e),d(ue.$$.fragment,e),Io=t(e),fe=i(e,"P",{"data-svelte-h":!0}),M(fe)!=="svelte-1ieu1in"&&(fe.innerHTML=Gn),Zo=t(e),d(Me.$$.fragment,e),xo=t(e),d(ye.$$.fragment,e),Bo=t(e),ve=i(e,"P",{"data-svelte-h":!0}),M(ve)!=="svelte-ujer0t"&&(ve.innerHTML=Ln),zo=t(e),d(_e.$$.fragment,e),Go=t(e),d(Ue.$$.fragment,e),Lo=t(e),I=i(e,"DIV",{class:!0});var G=j(I);d(be.$$.fragment,G),Po=t(G),Ve=i(G,"P",{"data-svelte-h":!0}),M(Ve)!=="svelte-3qeggl"&&(Ve.innerHTML=Wn),Oo=t(G),Xe=i(G,"P",{"data-svelte-h":!0}),M(Xe)!=="svelte-1sp6tj7"&&(Xe.innerHTML=kn),Do=t(G),d(R.$$.fragment,G),G.forEach(n),Wo=t(e),d(Te.$$.fragment,e),ko=t(e),T=i(e,"DIV",{class:!0});var x=j(T);d(we.$$.fragment,x),Ko=t(x),$e=i(x,"P",{"data-svelte-h":!0}),M($e)!=="svelte-13282x9"&&($e.textContent=qn),en=t(x),Qe=i(x,"P",{"data-svelte-h":!0}),M(Qe)!=="svelte-r35kan"&&(Qe.innerHTML=Rn),on=t(x),N=i(x,"DIV",{class:!0});var Ne=j(N);d(je.$$.fragment,Ne),nn=t(Ne),Ye=i(Ne,"P",{"data-svelte-h":!0}),M(Ye)!=="svelte-kmmmkj"&&(Ye.innerHTML=Nn),Ne.forEach(n),an=t(x),V=i(x,"DIV",{class:!0});var Ao=j(V);d(Je.$$.fragment,Ao),sn=t(Ao),Fe=i(Ao,"P",{"data-svelte-h":!0}),M(Fe)!=="svelte-tbcywx"&&(Fe.innerHTML=Vn),Ao.forEach(n),x.forEach(n),qo=t(e),d(Ce.$$.fragment,e),Ro=t(e),w=i(e,"DIV",{class:!0});var L=j(w);d(Ie.$$.fragment,L),tn=t(L),Ae=i(L,"P",{"data-svelte-h":!0}),M(Ae)!=="svelte-1k0e4xh"&&(Ae.innerHTML=Xn),rn=t(L),X=i(L,"DIV",{class:!0});var Eo=j(X);d(Ze.$$.fragment,Eo),ln=t(Eo),Ee=i(Eo,"P",{"data-svelte-h":!0}),M(Ee)!=="svelte-1ycjrv2"&&(Ee.textContent=$n),Eo.forEach(n),cn=t(L),$=i(L,"DIV",{class:!0});var So=j($);d(xe.$$.fragment,So),dn=t(So),Se=i(So,"P",{"data-svelte-h":!0}),M(Se)!=="svelte-1wucq2q"&&(Se.innerHTML=Qn),So.forEach(n),mn=t(L),He=i(L,"DIV",{class:!0});var En=j(He);d(Be.$$.fragment,En),En.forEach(n),L.forEach(n),No=t(e),d(ze.$$.fragment,e),Vo=t(e),z=i(e,"DIV",{class:!0});var eo=j(z);d(Ge.$$.fragment,eo),pn=t(eo),Pe=i(eo,"P",{"data-svelte-h":!0}),M(Pe)!=="svelte-1k0e4xh"&&(Pe.innerHTML=Yn),hn=t(eo),Oe=i(eo,"DIV",{class:!0});var Sn=j(Oe);d(Le.$$.fragment,Sn),Sn.forEach(n),eo.forEach(n),Xo=t(e),d(We.$$.fragment,e),$o=t(e),Z=i(e,"DIV",{class:!0});var F=j(Z);d(ke.$$.fragment,F),gn=t(F),De=i(F,"P",{"data-svelte-h":!0}),M(De)!=="svelte-1qxwgt5"&&(De.innerHTML=Fn),un=t(F),Ke=i(F,"P",{"data-svelte-h":!0}),M(Ke)!=="svelte-hswkmf"&&(Ke.innerHTML=An),fn=t(F),Q=i(F,"DIV",{class:!0});var Ho=j(Q);d(qe.$$.fragment,Ho),Mn=t(Ho),d(Y.$$.fragment,Ho),Ho.forEach(n),F.forEach(n),Qo=t(e),d(Re.$$.fragment,e),Yo=t(e),oo=i(e,"P",{}),j(oo).forEach(n),this.h()},h(){U(f,"name","hf:doc:metadata"),U(f,"content",la),On(k.src,Tn="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/llava-ov-acrhitecture.png")||U(k,"src",Tn),U(k,"alt","drawing"),U(k,"width","600"),U(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(He,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(Oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){l(document.head,f),a(e,C,o),a(e,v,o),a(e,y,o),m(_,e,o),a(e,u,o),m(b,e,o),a(e,no,o),a(e,E,o),a(e,ao,o),a(e,S,o),a(e,so,o),a(e,H,o),a(e,to,o),a(e,P,o),a(e,ro,o),a(e,k,o),a(e,io,o),a(e,O,o),a(e,lo,o),a(e,D,o),a(e,co,o),a(e,K,o),a(e,mo,o),m(q,e,o),a(e,po,o),a(e,ee,o),a(e,ho,o),a(e,oe,o),a(e,go,o),m(ne,e,o),a(e,uo,o),a(e,ae,o),a(e,fo,o),m(se,e,o),a(e,Mo,o),m(te,e,o),a(e,yo,o),a(e,re,o),a(e,vo,o),m(ie,e,o),a(e,_o,o),m(le,e,o),a(e,Uo,o),a(e,ce,o),a(e,bo,o),m(de,e,o),a(e,To,o),m(me,e,o),a(e,wo,o),a(e,pe,o),a(e,jo,o),m(he,e,o),a(e,Jo,o),m(ge,e,o),a(e,Co,o),m(ue,e,o),a(e,Io,o),a(e,fe,o),a(e,Zo,o),m(Me,e,o),a(e,xo,o),m(ye,e,o),a(e,Bo,o),a(e,ve,o),a(e,zo,o),m(_e,e,o),a(e,Go,o),m(Ue,e,o),a(e,Lo,o),a(e,I,o),m(be,I,null),l(I,Po),l(I,Ve),l(I,Oo),l(I,Xe),l(I,Do),m(R,I,null),a(e,Wo,o),m(Te,e,o),a(e,ko,o),a(e,T,o),m(we,T,null),l(T,Ko),l(T,$e),l(T,en),l(T,Qe),l(T,on),l(T,N),m(je,N,null),l(N,nn),l(N,Ye),l(T,an),l(T,V),m(Je,V,null),l(V,sn),l(V,Fe),a(e,qo,o),m(Ce,e,o),a(e,Ro,o),a(e,w,o),m(Ie,w,null),l(w,tn),l(w,Ae),l(w,rn),l(w,X),m(Ze,X,null),l(X,ln),l(X,Ee),l(w,cn),l(w,$),m(xe,$,null),l($,dn),l($,Se),l(w,mn),l(w,He),m(Be,He,null),a(e,No,o),m(ze,e,o),a(e,Vo,o),a(e,z,o),m(Ge,z,null),l(z,pn),l(z,Pe),l(z,hn),l(z,Oe),m(Le,Oe,null),a(e,Xo,o),m(We,e,o),a(e,$o,o),a(e,Z,o),m(ke,Z,null),l(Z,gn),l(Z,De),l(Z,un),l(Z,Ke),l(Z,fn),l(Z,Q),m(qe,Q,null),l(Q,Mn),m(Y,Q,null),a(e,Qo,o),m(Re,e,o),a(e,Yo,o),a(e,oo,o),Fo=!0},p(e,[o]){const G={};o&2&&(G.$$scope={dirty:o,ctx:e}),q.$set(G);const x={};o&2&&(x.$$scope={dirty:o,ctx:e}),R.$set(x);const Ne={};o&2&&(Ne.$$scope={dirty:o,ctx:e}),Y.$set(Ne)},i(e){Fo||(p(_.$$.fragment,e),p(b.$$.fragment,e),p(q.$$.fragment,e),p(ne.$$.fragment,e),p(se.$$.fragment,e),p(te.$$.fragment,e),p(ie.$$.fragment,e),p(le.$$.fragment,e),p(de.$$.fragment,e),p(me.$$.fragment,e),p(he.$$.fragment,e),p(ge.$$.fragment,e),p(ue.$$.fragment,e),p(Me.$$.fragment,e),p(ye.$$.fragment,e),p(_e.$$.fragment,e),p(Ue.$$.fragment,e),p(be.$$.fragment,e),p(R.$$.fragment,e),p(Te.$$.fragment,e),p(we.$$.fragment,e),p(je.$$.fragment,e),p(Je.$$.fragment,e),p(Ce.$$.fragment,e),p(Ie.$$.fragment,e),p(Ze.$$.fragment,e),p(xe.$$.fragment,e),p(Be.$$.fragment,e),p(ze.$$.fragment,e),p(Ge.$$.fragment,e),p(Le.$$.fragment,e),p(We.$$.fragment,e),p(ke.$$.fragment,e),p(qe.$$.fragment,e),p(Y.$$.fragment,e),p(Re.$$.fragment,e),Fo=!0)},o(e){h(_.$$.fragment,e),h(b.$$.fragment,e),h(q.$$.fragment,e),h(ne.$$.fragment,e),h(se.$$.fragment,e),h(te.$$.fragment,e),h(ie.$$.fragment,e),h(le.$$.fragment,e),h(de.$$.fragment,e),h(me.$$.fragment,e),h(he.$$.fragment,e),h(ge.$$.fragment,e),h(ue.$$.fragment,e),h(Me.$$.fragment,e),h(ye.$$.fragment,e),h(_e.$$.fragment,e),h(Ue.$$.fragment,e),h(be.$$.fragment,e),h(R.$$.fragment,e),h(Te.$$.fragment,e),h(we.$$.fragment,e),h(je.$$.fragment,e),h(Je.$$.fragment,e),h(Ce.$$.fragment,e),h(Ie.$$.fragment,e),h(Ze.$$.fragment,e),h(xe.$$.fragment,e),h(Be.$$.fragment,e),h(ze.$$.fragment,e),h(Ge.$$.fragment,e),h(Le.$$.fragment,e),h(We.$$.fragment,e),h(ke.$$.fragment,e),h(qe.$$.fragment,e),h(Y.$$.fragment,e),h(Re.$$.fragment,e),Fo=!1},d(e){e&&(n(C),n(v),n(y),n(u),n(no),n(E),n(ao),n(S),n(so),n(H),n(to),n(P),n(ro),n(k),n(io),n(O),n(lo),n(D),n(co),n(K),n(mo),n(po),n(ee),n(ho),n(oe),n(go),n(uo),n(ae),n(fo),n(Mo),n(yo),n(re),n(vo),n(_o),n(Uo),n(ce),n(bo),n(To),n(wo),n(pe),n(jo),n(Jo),n(Co),n(Io),n(fe),n(Zo),n(xo),n(Bo),n(ve),n(zo),n(Go),n(Lo),n(I),n(Wo),n(ko),n(T),n(qo),n(Ro),n(w),n(No),n(Vo),n(z),n(Xo),n($o),n(Z),n(Qo),n(Yo),n(oo)),n(f),g(_,e),g(b,e),g(q,e),g(ne,e),g(se,e),g(te,e),g(ie,e),g(le,e),g(de,e),g(me,e),g(he,e),g(ge,e),g(ue,e),g(Me,e),g(ye,e),g(_e,e),g(Ue,e),g(be),g(R),g(Te,e),g(we),g(je),g(Je),g(Ce,e),g(Ie),g(Ze),g(xe),g(Be),g(ze,e),g(Ge),g(Le),g(We,e),g(ke),g(qe),g(Y),g(Re,e)}}}const la='{"title":"LLaVA-Onevision","local":"llava-onevision","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage example","local":"usage-example","sections":[{"title":"Single image inference","local":"single-image-inference","sections":[],"depth":3},{"title":"Multi image inference","local":"multi-image-inference","sections":[],"depth":3},{"title":"Video inference","local":"video-inference","sections":[],"depth":3}],"depth":2},{"title":"Model optimization","local":"model-optimization","sections":[{"title":"Quantization using Bitsandbytes","local":"quantization-using-bitsandbytes","sections":[],"depth":3},{"title":"Use Flash-Attention 2 to further speed-up generation","local":"use-flash-attention-2-to-further-speed-up-generation","sections":[],"depth":3}],"depth":2},{"title":"LlavaOnevisionConfig","local":"transformers.LlavaOnevisionConfig","sections":[],"depth":2},{"title":"LlavaOnevisionProcessor","local":"transformers.LlavaOnevisionProcessor","sections":[],"depth":2},{"title":"LlavaOnevisionImageProcessor","local":"transformers.LlavaOnevisionImageProcessor","sections":[],"depth":2},{"title":"LlavaOnevisionVideoProcessor","local":"transformers.LlavaOnevisionVideoProcessor","sections":[],"depth":2},{"title":"LlavaOnevisionForConditionalGeneration","local":"transformers.LlavaOnevisionForConditionalGeneration","sections":[],"depth":2}],"depth":1}';function ca(W){return Dn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ma extends Kn{constructor(f){super(),ea(this,f,ca,ia,Pn,{})}}export{Ma as component};
