import{s as Is,o as gs,n as Ct}from"../chunks/scheduler.a2b4ca8e.js";import{S as Bs,i as Zs,g as i,s as a,r as M,A as Gs,h as o,f as t,c as n,j as Cs,u as m,x as p,k as bt,y as Ws,a as s,v as c,d as u,t as d,w as h}from"../chunks/index.d2f673cc.js";import{T as ft}from"../chunks/Tip.a902c250.js";import{C as w}from"../chunks/CodeBlock.792343a6.js";import{H as U}from"../chunks/Heading.675d4c1e.js";function ks(J){let r,j="While we will use <code>Llama-3 70B</code> in this tutorial, it is completely possible to use other models, simply by swtiching the <code>model_id</code>.";return{c(){r=i("p"),r.innerHTML=j},l(y){r=o(y,"P",{"data-svelte-h":!0}),p(r)!=="svelte-1pbcdba"&&(r.innerHTML=j)},m(y,T){s(y,r,T)},p:Ct,d(y){y&&t(r)}}}function _s(J){let r,j='If you want to know more about distributed training you can take a look at the <a href="https://huggingface.co/docs/optimum-neuron/guides/distributed_training" rel="nofollow">documentation</a>.';return{c(){r=i("p"),r.innerHTML=j},l(y){r=o(y,"P",{"data-svelte-h":!0}),p(r)!=="svelte-yp02re"&&(r.innerHTML=j)},m(y,T){s(y,r,T)},p:Ct,d(y){y&&t(r)}}}function vs(J){let r,j="Make sure to run this precompilation phase for around 10 training steps. It is usually enough to accumulate and compile all the graphs that will be needed during the actual training.";return{c(){r=i("p"),r.textContent=j},l(y){r=o(y,"P",{"data-svelte-h":!0}),p(r)!=="svelte-1k7qt99"&&(r.textContent=j)},m(y,T){s(y,r,T)},p:Ct,d(y){y&&t(r)}}}function Rs(J){let r,j,y,T,B,qe,Z,It="[[open-in-collab]]",Pe,G,gt='<em>Note: The complete script for this tutorial can be downloaded <a href="https://github.com/huggingface/optimum-neuron/blob/main/docs/source/training_tutorials/lora_finetune_llm.py" rel="nofollow">here</a>.</em>',De,W,Bt='This tutorial will teach you how to fine-tune open source LLMs like <a href="https://huggingface.co/meta-llama/Meta-Llama-3-70B" rel="nofollow">Llama 3</a> on AWS Trainium. In our example, we are going to leverage the <a href="https://huggingface.co/docs/optimum-neuron/index" rel="nofollow">Optimum Neuron</a>, <a href="https://huggingface.co/docs/transformers/index" rel="nofollow">Transformers</a> and <a href="https://huggingface.co/docs/datasets/index" rel="nofollow">Datasets</a> libraries.',Ke,k,Zt="You will learn how to:",Oe,_,Gt='<li><a href="#1-setup-aws-environment">Setup AWS Environment</a></li> <li><a href="#2-load-and-prepare-the-dataset">Load and process the dataset</a></li> <li><a href="#3-fine-tune-llama-using-lora-on-aws-trainium-with-the-neurontrainer">Fine-tune Llama using LoRA on AWS Trainium with the <code>NeuronTrainer</code></a></li> <li><a href="#4-launch-training">Launch Training</a></li> <li><a href="#5-evaluate-and-test-fine-tuned-llama-model">Evaluate and test fine-tuned Llama model</a></li>',el,b,ll,v,tl,R,Wt="Before starting this tutorial, you will need to setup your environment:",sl,X,kt='<li>Create an AWS Trainium instance. <strong>You will need a <code>trn1.32xlarge</code>, which contains 16 Neuron Devices.</strong> You can follow this <a href="https://huggingface.co/docs/optimum-neuron/guides/setup_aws_instance" rel="nofollow">guide</a> to create one.</li> <li>Make sure you are logged in on the Hugging Face Hub:</li>',al,A,nl,f,_t="<li>Check that you have access to the model. Some open source models are gated, meaning that users need to apply to the model owner to be able to use the model weights. Here we will be training Llama-3 70B, for which there are two possibilities:</li>",il,V,vt='<li>The official gated repo: <a href="https://huggingface.co/meta-llama/Meta-Llama-3-70B" rel="nofollow"><code>meta-llama/Meta-Llama-3-70B</code></a></li> <li>The non-official un-gated repo: <a href="https://huggingface.co/NousResearch/Meta-Llama-3-70B" rel="nofollow"><code>NousResearch/Meta-Llama-3-70B</code></a></li>',ol,C,Rt='<li>Clone the Optimum Neuron repository, <strong>which contains the <a href="https://github.com/huggingface/optimum-neuron/blob/main/docs/source/training_tutorials/lora_finetune_llm.py" rel="nofollow">complete script</a> described in this tutorial:</strong></li>',pl,x,rl,$,Ml,S,Xt='For this tutorial, we will use <a href="https://huggingface.co/datasets/databricks/databricks-dolly-15k" rel="nofollow">Dolly</a>, an open source dataset of instruction-following records on categories outlined in the <a href="https://arxiv.org/abs/2203.02155" rel="nofollow">InstructGPT paper</a>, including brainstorming, classification, closed QA, generation, information extraction, open QA, and summarization.',ml,H,At="Example:",cl,Q,ul,E,Vt="We can use the <code>load_dataset()</code> method from the 🤗 Datasets library to load the <code>dolly</code> dataset very easily.",dl,Y,hl,N,xt="To instruct tune our model we need to convert our structured examples into a collection of tasks described via instructions. We define a <code>format_dolly</code> that takes a raw sample and returns a string with our format instruction.",yl,z,wl,F,$t="In addition to formatting our samples, we also want to pack multiple samples to one sequence to have a more efficient training. In other words, we are stacking multiple samples to one sequence and split them with an EOS Token. Packing/stacking samples can be done during training or before.",jl,L,St="The following function <code>pack_dataset</code> takes a <code>dataset</code> and a <code>chunk_length</code> and returns a packed dataset:",Tl,q,Ul,P,Ht="To summarize to prepare our dataset we will:",Jl,D,Qt="<li>Format our samples using the template method and add an EOS token at the end of each sample</li> <li>Tokenize our dataset to convert it from text to tokens</li> <li>Pack our dataset to 2048 tokens</li>",bl,K,fl,O,Cl,ee,Et='Normally you would use the <strong><a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.Trainer" rel="nofollow">Trainer</a></strong> and <strong><a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">TrainingArguments</a></strong> classes to fine-tune PyTorch-based transformer models.',Il,le,Yt="But together with AWS, we have developed the [~<code>optimum.neuron.NeuronTrainer</code>] to improve performance, robustness, and ease-of-use when training on Trainium instances. It can be used as a 1-to-1 replacement for the <code>Trainer</code>.",gl,te,Nt=`Since Llama-3 70B is a big model it will not fit on a single Neuron device, even with distributed training. To actually fine-tune a 70B model using only one Trainium instance we need to use both LoRA and distributed training.
In Optimum Neuron we support:`,Bl,se,zt='<li><a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/frameworks/torch/torch-neuronx/tutorials/training/zero1_gpt2.html" rel="nofollow">ZeRO-1</a>: It is an optimization of data-parallelism which consists in sharding the optimizer state (which usually represents half or more of the memory needed on the device) over the data-parallel ranks.</li> <li><a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/libraries/neuronx-distributed/tensor_parallelism_overview.html" rel="nofollow">Tensor Parallelism</a>: It is a technique which consists in sharding each of your model matrix-multiplications along a given axis (row or column) on multiple devices. It also known as intra-layer model parallelism. The number of devices to shard your parameters on is called the <code>tensor_parallel_size</code>.</li> <li><a href="https://arxiv.org/pdf/2205.05198.pdf" rel="nofollow">Sequence parallelism</a>: It is an optimization over Tensor Parallelism which shards the activations on the sequence axis outside of the tensor parallel regions. It is useful because it saves memory by sharding the activations.</li> <li><a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/libraries/neuronx-distributed/pipeline_parallelism_overview.html" rel="nofollow">Pipeline Parallelism</a>: It consists in sharding the model block layers on multiple devices. It is also known as inter-layer model parallelism. The number of devices to shard your layers on is called the <code>pipeline_parallel_size</code>.</li>',Zl,I,Gl,ae,Ft=`Here, we will use Tensor Parallelism in conjuction with LoRA.
Our training code will look as follows:`,Wl,ne,kl,ie,Lt="The key points here are:",_l,oe,qt="<li>We use the <code>lazy_load_for_parallelism</code> context manager to lazily load the model. This will not load the full model weights on each worker, but instead only load the required weights (sharded or full). <strong>This is much more memory efficient, and often mandatory to use.</strong></li> <li>We inject the LoRA adapters using <code>optimum.neuron.utils.get_peft_model</code> by specifying both the model to transform and the LoRA config.</li> <li>We use the [~<code>optimum.neuron.NeuronTrainer</code>] to perform training. It will take the lazily loaded model, along with the <code>training_args</code>, which are an instance of [~<code>optimum.neuron.NeuronTrainingArguments</code>], and will handle all the parallelization and training on the Neuron cores.</li>",vl,pe,Rl,re,Pt='We prepared a script called <a href="https://github.com/huggingface/optimum-neuron/blob/main/docs/source/training_tutorials/lora_finetune_llm.py" rel="nofollow">lora_finetune_llm.py</a> summing up everything mentioned in this tutorial.',Xl,Me,Dt="PyTorch Neuron uses <code>torch_xla</code>. It evaluates operations lazily during execution of the training loops, which means it builds a symbolic graph in the background and the graph is executed on the hardware only when the tensor is printed, transfered to CPU, or <code>xm.mark_step()</code> is called. During execution, multiple graphs can be build depending on control-flow and it can take time to compile each graph sequentially. To alleviate that, the Neuron SDK provides <code>neuron_parallel_compile</code>, a tool which performs a fast trial run that builds all the graphs and compile them in parallel. This step is usually called precompilation.",Al,me,Vl,ce,Kt="When training models on AWS Trainium we first need to compile our model with our training arguments.",xl,ue,Ot='To overcome this, we added a <a href="https://huggingface.co/docs/optimum-neuron/guides/cache_system" rel="nofollow">model cache repository</a>, which allows us to use precompiled models from the Hugging Face Hub to skip the compilation step. But be careful: every change in the model configuration might lead to a new compilation, which could result in some cache misses.',$l,de,es='<em>Note: If your model configuration is not cached please open an issue on <a href="https://github.com/huggingface/optimum-neuron/issues" rel="nofollow">Github</a>, we are happy to include it.</em>',Sl,he,ls="The compilation command simply consists in calling your script as an input to the <code>neuron_parallel_compile</code> utility:",Hl,ye,Ql,g,El,we,ts="<em>Note: Compiling without a cache can take a while. It will also create dummy files in the <code>dolly_llama_sharded</code> during compilation you will have to remove them afterwards. We also need to add <code>MALLOC_ARENA_MAX=64</code> to limit the CPU allocation to avoid potential crashes, don’t remove it for now.</em>",Yl,je,Nl,Te,zl,Ue,ss="After compilation is done we can start our actual training with a similar command, we just need to remove the use of <code>neuron_parallel_compile</code>.",Fl,Je,as="We will use <code>torchrun</code> to launch our training script. <code>torchrun</code> is a tool that automatically distributes a PyTorch model across multiple accelerators. We can pass the number of accelerators as <code>nproc_per_node</code> arguments alongside our hyperparameters.",Ll,be,ns="The difference to the compilation command is that we changed from <code>max_steps=10</code> to <code>num_train_epochs=3</code>.",ql,fe,is="Launch the training, with the following command.",Pl,Ce,Dl,Ie,os="That’s it, we successfully trained Llama-3 70B on AWS Trainium!",Kl,ge,ps="But before we can share and test our model we need to consolidate our model. Since we used Tensor Parallelism during training, we saved sharded versions of the checkpoints. We need to consolidate them now.",Ol,Be,et,Ze,rs="The Optimum CLI provides a way of doing that very easily via the <code>optimum neuron consolidate [sharded_checkpoint] [output_dir]</code> command:",lt,Ge,tt,We,st,ke,Ms="TODO",at,_e,nt,ve,ms="As for training, to be able to run inference on AWS Trainium or AWS Inferentia2 we need to compile our model. In this case, we will use our Trainium instance for the inference test, but we recommend customer to switch to Inferentia2 for inference.",it,Re,cs="Optimum Neuron implements similar to Transformers AutoModel classes for easy inference use. We will use the <code>NeuronModelForCausalLM</code> class to load our vanilla transformers checkpoint and convert it to neuron.",ot,Xe,pt,Ae,us="<em>Note: Inference compilation can take ~25minutes. Luckily, you need to only run this onces. Since you can save the model afterwards. If you are going to run on Inferentia2 you need to recompile again. The compilation is parameter and hardware specific.</em>",rt,Ve,Mt,xe,ds="We can now test inference, but have to make sure we format our input to our prompt format we used for fine-tuning. Therefore we created a helper method, which accepts a <code>dict</code> with our <code>instruction</code> and optionally a <code>context</code>.",mt,$e,ct,Se,hs="Let’s test inference. First we test without a context.",ut,He,ys="<em>Note: Inference is not expected to be super fast on AWS Trainium using 2 cores. For Inference we recommend using Inferentia2.</em>",dt,Qe,ht,Ee,ws="<p>AWS stands for Amazon Web Services. AWS is a suite of remote computing services offered by Amazon. The most widely used of these include Amazon Elastic Compute Cloud (Amazon EC2), which provides resizable compute capacity in the cloud; Amazon Simple Storage Service (Amazon S3), which is an object storage service; and Amazon Elastic Block Store (Amazon EBS), which is designed to provide high performance, durable block storage volumes for use with AWS instances. AWS also provides other services, such as AWS Identity and Access Management (IAM), a service that enables organizations to control access to their AWS resources, and AWS Key Management Service (AWS KMS), which helps customers create and control the use of encryption keys.</p>",yt,Ye,js="That looks correct. Now, lets add some context, e.g. as you would do for RAG applications:",wt,Ne,jt,ze,Ts="<p>You can use the Optimum Neuron interface to train models on AWS Trainium.</p>",Tt,Fe,Us="Awesome, our model also correctly uses the provided context. We are done. Congrats on fine-tuning Llama on AWS Trainium.",Ut,Le,Jt;return B=new U({props:{title:"Fine-tune Llama 3 70B on one AWS Trainium instance with LoRA",local:"fine-tune-llama-3-70b-on-one-aws-trainium-instance-with-lora",headingTag:"h1"}}),b=new ft({props:{$$slots:{default:[ks]},$$scope:{ctx:J}}}),v=new U({props:{title:"1. Setup AWS Environment",local:"1-setup-aws-environment",headingTag:"h2"}}),A=new w({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4lMjAtLXRva2VuJTIwWU9VUl9UT0tFTg==",highlighted:"huggingface-cli login --token YOUR_TOKEN",wrap:!1}}),x=new w({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRm9wdGltdW0tbmV1cm9uLmdpdA==",highlighted:'git <span class="hljs-built_in">clone</span> https://github.com/huggingface/optimum-neuron.git',wrap:!1}}),$=new U({props:{title:"2. Load and prepare the dataset",local:"2-load-and-prepare-the-dataset",headingTag:"h2"}}),Q=new w({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5zdHJ1Y3Rpb24lMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjB3b3JsZCUyMG9mJTIwd2FyY3JhZnQlMjIlMkMlMEElMjAlMjAlMjJjb250ZXh0JTIyJTNBJTIwJTIyJTIyJTJDJTBBJTIwJTIwJTIycmVzcG9uc2UlMjIlM0ElMjAoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV29ybGQlMjBvZiUyMHdhcmNyYWZ0JTIwaXMlMjBhJTIwbWFzc2l2ZSUyMG9ubGluZSUyMG11bHRpJTIwcGxheWVyJTIwcm9sZSUyMHBsYXlpbmclMjBnYW1lLiUyMCUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkl0JTIwd2FzJTIwcmVsZWFzZWQlMjBpbiUyMDIwMDQlMjBieSUyMGJsaXphcnJlJTIwZW50ZXJ0YWlubWVudCUyMiUwQSUyMCUyMCUyMCUyMCklMEElN0Q=",highlighted:`{
  <span class="hljs-string">&quot;instruction&quot;</span>: <span class="hljs-string">&quot;What is world of warcraft&quot;</span>,
  <span class="hljs-string">&quot;context&quot;</span>: <span class="hljs-string">&quot;&quot;</span>,
  <span class="hljs-string">&quot;response&quot;</span>: (
        <span class="hljs-string">&quot;World of warcraft is a massive online multi player role playing game. &quot;</span>
        <span class="hljs-string">&quot;It was released in 2004 by blizarre entertainment&quot;</span>
    )
}`,wrap:!1}}),Y=new w({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHJhbmRvbSUyMGltcG9ydCUyMHJhbmRyYW5nZSUwQSUwQSUyMyUyMExvYWQlMjBkYXRhc2V0JTIwZnJvbSUyMHRoZSUyMGh1YiUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyZGF0YWJyaWNrcyUyRmRhdGFicmlja3MtZG9sbHktMTVrJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEElMEFwcmludChmJTIyZGF0YXNldCUyMHNpemUlM0ElMjAlN0JsZW4oZGF0YXNldCklN0QlMjIpJTBBcHJpbnQoZGF0YXNldCU1QnJhbmRyYW5nZShsZW4oZGF0YXNldCkpJTVEKSUwQSUyMyUyMGRhdGFzZXQlMjBzaXplJTNBJTIwMTUwMTE=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> random <span class="hljs-keyword">import</span> randrange

<span class="hljs-comment"># Load dataset from the hub</span>
dataset = load_dataset(<span class="hljs-string">&quot;databricks/databricks-dolly-15k&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;dataset size: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(dataset)}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(dataset[randrange(<span class="hljs-built_in">len</span>(dataset))])
<span class="hljs-comment"># dataset size: 15011</span>`,wrap:!1}}),z=new w({props:{code:"ZGVmJTIwZm9ybWF0X2RvbGx5KHNhbXBsZSklM0ElMEElMjAlMjAlMjAlMjBpbnN0cnVjdGlvbiUyMCUzRCUyMGYlMjIlMjMlMjMlMjMlMjBJbnN0cnVjdGlvbiU1Q24lN0JzYW1wbGUlNUInaW5zdHJ1Y3Rpb24nJTVEJTdEJTIyJTBBJTIwJTIwJTIwJTIwY29udGV4dCUyMCUzRCUyMGYlMjIlMjMlMjMlMjMlMjBDb250ZXh0JTVDbiU3QnNhbXBsZSU1Qidjb250ZXh0JyU1RCU3RCUyMiUyMGlmJTIwbGVuKHNhbXBsZSU1QiUyMmNvbnRleHQlMjIlNUQpJTIwJTNFJTIwMCUyMGVsc2UlMjBOb25lJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjBmJTIyJTIzJTIzJTIzJTIwQW5zd2VyJTVDbiU3QnNhbXBsZSU1QidyZXNwb25zZSclNUQlN0QlMjIlMEElMjAlMjAlMjAlMjAlMjMlMjBqb2luJTIwYWxsJTIwdGhlJTIwcGFydHMlMjB0b2dldGhlciUwQSUyMCUyMCUyMCUyMHByb21wdCUyMCUzRCUyMCUyMiU1Q24lNUNuJTIyLmpvaW4oJTVCaSUyMGZvciUyMGklMjBpbiUyMCU1Qmluc3RydWN0aW9uJTJDJTIwY29udGV4dCUyQyUyMHJlc3BvbnNlJTVEJTIwaWYlMjBpJTIwaXMlMjBub3QlMjBOb25lJTVEKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHByb21wdA==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">format_dolly</span>(<span class="hljs-params">sample</span>):
    instruction = <span class="hljs-string">f&quot;### Instruction\\n<span class="hljs-subst">{sample[<span class="hljs-string">&#x27;instruction&#x27;</span>]}</span>&quot;</span>
    context = <span class="hljs-string">f&quot;### Context\\n<span class="hljs-subst">{sample[<span class="hljs-string">&#x27;context&#x27;</span>]}</span>&quot;</span> <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(sample[<span class="hljs-string">&quot;context&quot;</span>]) &gt; <span class="hljs-number">0</span> <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>
    response = <span class="hljs-string">f&quot;### Answer\\n<span class="hljs-subst">{sample[<span class="hljs-string">&#x27;response&#x27;</span>]}</span>&quot;</span>
    <span class="hljs-comment"># join all the parts together</span>
    prompt = <span class="hljs-string">&quot;\\n\\n&quot;</span>.join([i <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> [instruction, context, response] <span class="hljs-keyword">if</span> i <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>])
    <span class="hljs-keyword">return</span> prompt`,wrap:!1}}),q=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> functools <span class="hljs-keyword">import</span> partial
<span class="hljs-keyword">from</span> itertools <span class="hljs-keyword">import</span> chain

<span class="hljs-comment"># empty list to save remainder from batches to use in next batch</span>
remainder = {<span class="hljs-string">&quot;input_ids&quot;</span>: [], <span class="hljs-string">&quot;attention_mask&quot;</span>: [], <span class="hljs-string">&quot;token_type_ids&quot;</span>: []}

<span class="hljs-keyword">def</span> <span class="hljs-title function_">pack_dataset</span>(<span class="hljs-params">dataset, chunk_length=<span class="hljs-number">2048</span></span>):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Chunking dataset into chunks of <span class="hljs-subst">{chunk_length}</span> tokens.&quot;</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">chunk</span>(<span class="hljs-params">sample, chunk_length=chunk_length</span>):
        <span class="hljs-comment"># define global remainder variable to save remainder from batches to use in next batch</span>
        <span class="hljs-keyword">global</span> remainder
        <span class="hljs-comment"># Concatenate all texts and add remainder from previous batch</span>
        concatenated_examples = {k: <span class="hljs-built_in">list</span>(chain(*sample[k])) <span class="hljs-keyword">for</span> k <span class="hljs-keyword">in</span> sample.keys()}
        concatenated_examples = {k: remainder[k] + concatenated_examples[k] <span class="hljs-keyword">for</span> k <span class="hljs-keyword">in</span> concatenated_examples.keys()}
        <span class="hljs-comment"># get total number of tokens for batch</span>
        batch_total_length = <span class="hljs-built_in">len</span>(concatenated_examples[<span class="hljs-built_in">list</span>(sample.keys())[<span class="hljs-number">0</span>]])

        <span class="hljs-comment"># get max number of chunks for batch</span>
        <span class="hljs-keyword">if</span> batch_total_length &gt;= chunk_length:
            batch_chunk_length = (batch_total_length // chunk_length) * chunk_length

        <span class="hljs-comment"># Split by chunks of max_len.</span>
        result = {
            k: [t[i : i + chunk_length] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, batch_chunk_length, chunk_length)]
            <span class="hljs-keyword">for</span> k, t <span class="hljs-keyword">in</span> concatenated_examples.items()
        }
        <span class="hljs-comment"># add remainder to global variable for next batch</span>
        remainder = {k: concatenated_examples[k][batch_chunk_length:] <span class="hljs-keyword">for</span> k <span class="hljs-keyword">in</span> concatenated_examples.keys()}
        <span class="hljs-comment"># prepare labels</span>
        result[<span class="hljs-string">&quot;labels&quot;</span>] = result[<span class="hljs-string">&quot;input_ids&quot;</span>].copy()
        <span class="hljs-keyword">return</span> result

    <span class="hljs-comment"># tokenize and chunk dataset</span>
    lm_dataset = dataset.<span class="hljs-built_in">map</span>(
        partial(chunk, chunk_length=chunk_length),
        batched=<span class="hljs-literal">True</span>,
    )
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Total number of samples: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(lm_dataset)}</span>&quot;</span>)
    <span class="hljs-keyword">return</span> lm_dataset`,wrap:!1}}),K=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwcmFuZG9tJTIwaW1wb3J0JTIwcmFuZGludCUwQSUwQSUyMyUyMEh1Z2dpbmclMjBGYWNlJTIwSHViJTIwbW9kZWwlMjBpZCUyMCUwQSUyMyUyMG1vZGVsX2lkJTIwJTNEJTIwJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy03MEIlMjIlMjAlMjMlMjBnYXRlZCUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyTm91c1Jlc2VhcmNoJTJGTWV0YS1MbGFtYS0zLTcwQiUyMiUyMCUyMyUyMHVuZ2F0ZWQlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEElMEElMjMlMjB0ZW1wbGF0ZSUyMGRhdGFzZXQlMjB0byUyMGFkZCUyMHByb21wdCUyMHRvJTIwZWFjaCUyMHNhbXBsZSUwQWRlZiUyMHRlbXBsYXRlX2RhdGFzZXQoc2FtcGxlKSUzQSUwQSUyMCUyMCUyMCUyMHNhbXBsZSU1QiUyMnRleHQlMjIlNUQlMjAlM0QlMjBmJTIyJTdCZm9ybWF0X2RvbGx5KHNhbXBsZSklN0QlN0J0b2tlbml6ZXIuZW9zX3Rva2VuJTdEJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc2FtcGxlJTBBJTBBJTIzJTIwYXBwbHklMjBwcm9tcHQlMjB0ZW1wbGF0ZSUyMHBlciUyMHNhbXBsZSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0Lm1hcCh0ZW1wbGF0ZV9kYXRhc2V0JTJDJTIwcmVtb3ZlX2NvbHVtbnMlM0RsaXN0KGRhdGFzZXQuZmVhdHVyZXMpKSUwQSUwQSUyMyUyMHByaW50JTIwcmFuZG9tJTIwc2FtcGxlJTBBcHJpbnQoZGF0YXNldCU1QnJhbmRpbnQoMCUyQyUyMGxlbihkYXRhc2V0KSklNUQlNUIlMjJ0ZXh0JTIyJTVEKSUwQSUwQSUyMyUyMHRva2VuaXplJTIwZGF0YXNldCUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0Lm1hcCglMEElMjAlMjAlMjAlMjBsYW1iZGElMjBzYW1wbGUlM0ElMjB0b2tlbml6ZXIoc2FtcGxlJTVCJTIydGV4dCUyMiU1RCklMkMlMjBiYXRjaGVkJTNEVHJ1ZSUyQyUyMHJlbW92ZV9jb2x1bW5zJTNEbGlzdChkYXRhc2V0LmZlYXR1cmVzKSUwQSklMEElMEElMjMlMjBjaHVuayUyMGRhdGFzZXQlMEFsbV9kYXRhc2V0JTIwJTNEJTIwcGFja19kYXRhc2V0KGRhdGFzZXQlMkMlMjBjaHVua19sZW5ndGglM0QyMDQ4KSUyMCUyMyUyMFdlJTIwdXNlJTIwMjA0OCUyMGFzJTIwdGhlJTIwbWF4aW11bSUyMGxlbmd0aCUyMGZvciUyMHBhY2tpbmc=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">from</span> random <span class="hljs-keyword">import</span> randint

<span class="hljs-comment"># Hugging Face Hub model id </span>
<span class="hljs-comment"># model_id = &quot;meta-llama/Meta-Llama-3-70B&quot; # gated</span>
model_id = <span class="hljs-string">&quot;NousResearch/Meta-Llama-3-70B&quot;</span> <span class="hljs-comment"># ungated</span>

tokenizer = AutoTokenizer.from_pretrained(model_id)

<span class="hljs-comment"># template dataset to add prompt to each sample</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">template_dataset</span>(<span class="hljs-params">sample</span>):
    sample[<span class="hljs-string">&quot;text&quot;</span>] = <span class="hljs-string">f&quot;<span class="hljs-subst">{format_dolly(sample)}</span><span class="hljs-subst">{tokenizer.eos_token}</span>&quot;</span>
    <span class="hljs-keyword">return</span> sample

<span class="hljs-comment"># apply prompt template per sample</span>
dataset = dataset.<span class="hljs-built_in">map</span>(template_dataset, remove_columns=<span class="hljs-built_in">list</span>(dataset.features))

<span class="hljs-comment"># print random sample</span>
<span class="hljs-built_in">print</span>(dataset[randint(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(dataset))][<span class="hljs-string">&quot;text&quot;</span>])

<span class="hljs-comment"># tokenize dataset</span>
dataset = dataset.<span class="hljs-built_in">map</span>(
    <span class="hljs-keyword">lambda</span> sample: tokenizer(sample[<span class="hljs-string">&quot;text&quot;</span>]), batched=<span class="hljs-literal">True</span>, remove_columns=<span class="hljs-built_in">list</span>(dataset.features)
)

<span class="hljs-comment"># chunk dataset</span>
lm_dataset = pack_dataset(dataset, chunk_length=<span class="hljs-number">2048</span>) <span class="hljs-comment"># We use 2048 as the maximum length for packing</span>`,wrap:!1}}),O=new U({props:{title:"3. Fine-tune Llama using LoRA on AWS Trainium with the NeuronTrainer",local:"3-fine-tune-llama-using-lora-on-aws-trainium-with-the-neurontrainer",headingTag:"h2"}}),I=new ft({props:{$$slots:{default:[_s]},$$scope:{ctx:J}}}),ne=new w({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uVHJhaW5lciUyMGFzJTIwVHJhaW5lciUwQWZyb20lMjBvcHRpbXVtLm5ldXJvbi5kaXN0cmlidXRlZCUyMGltcG9ydCUyMGxhenlfbG9hZF9mb3JfcGFyYWxsZWxpc20lMEFmcm9tJTIwb3B0aW11bS5uZXVyb24udXRpbHMlMjBpbXBvcnQlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQSUyMyUyMERlZmluZSUyMHRoZSUyMHRlbnNvcl9wYXJhbGxlbF9zaXplJTBBdGVuc29yX3BhcmFsbGVsX3NpemUlMjAlM0QlMjA4JTBBJTBBJTIzJTIwTG9hZCUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMEh1Z2dpbmclMjBmYWNlJTIwSHViJTIwJTBBd2l0aCUyMGxhenlfbG9hZF9mb3JfcGFyYWxsZWxpc20odGVuc29yX3BhcmFsbGVsX3NpemUlM0R0ZW5zb3JfcGFyYWxsZWxfc2l6ZSklM0ElMEElMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEElMEElMjMlMjBJbmplY3RpbmclMjB0aGUlMjBMb1JBJTIwYWRhcHRlcnMlMEFjb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0Q2NCUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0QxMjglMkMlMEElMjAlMjAlMjAlMjBsb3JhX2Ryb3BvdXQlM0QwLjAlMkMlMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMmVtYmVkX3Rva2VucyUyMiUyQyUyMCUyMmxtX2hlYWQlMjIlMkMlMjAlMjJxX3Byb2olMjIlMkMlMjAlMjJ2X3Byb2olMjIlNUQlMkMlMEElMjAlMjAlMjAlMjB0YXNrX3R5cGUlM0QlMjJDQVVTQUxfTE0lMjIlMkMlMEEpJTBBbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMGNvbmZpZyklMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0RkZWZhdWx0X2RhdGFfY29sbGF0b3IlMkMlMjAlMjAlMjMlMjBubyUyMHNwZWNpYWwlMjBjb2xsYXRvciUyMG5lZWRlZCUyMHNpbmNlJTIwd2UlMjBzdGFja2VkJTIwdGhlJTIwZGF0YXNldCUwQSklMEElMEElMjMlMjBTdGFydCUyMHRyYWluaW5nJTBBdHJhaW5lci50cmFpbigpJTBBJTBBdHJhaW5lci5zYXZlX21vZGVsKCklMjAlMjAlMjMlMjBzYXZlcyUyMHRoZSUyMHRva2VuaXplciUyMHRvbyUyMGZvciUyMGVhc3klMjB1cGxvYWQ=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronTrainer <span class="hljs-keyword">as</span> Trainer
<span class="hljs-keyword">from</span> optimum.neuron.distributed <span class="hljs-keyword">import</span> lazy_load_for_parallelism
<span class="hljs-keyword">from</span> optimum.neuron.utils <span class="hljs-keyword">import</span> get_peft_model

<span class="hljs-comment"># Define the tensor_parallel_size</span>
tensor_parallel_size = <span class="hljs-number">8</span>

<span class="hljs-comment"># Load model from the Hugging face Hub </span>
<span class="hljs-keyword">with</span> lazy_load_for_parallelism(tensor_parallel_size=tensor_parallel_size):
    model = AutoModelForCausalLM.from_pretrained(model_id)

<span class="hljs-comment"># Injecting the LoRA adapters</span>
config = LoraConfig(
    r=<span class="hljs-number">64</span>,
    lora_alpha=<span class="hljs-number">128</span>,
    lora_dropout=<span class="hljs-number">0.0</span>,
    target_modules=[<span class="hljs-string">&quot;embed_tokens&quot;</span>, <span class="hljs-string">&quot;lm_head&quot;</span>, <span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>],
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)
model = get_peft_model(model, config)

trainer = Trainer(
    model=model,
    tokenizer=tokenizer,
    args=training_args,
    train_dataset=dataset,
    data_collator=default_data_collator,  <span class="hljs-comment"># no special collator needed since we stacked the dataset</span>
)

<span class="hljs-comment"># Start training</span>
trainer.train()

trainer.save_model()  <span class="hljs-comment"># saves the tokenizer too for easy upload</span>`,wrap:!1}}),pe=new U({props:{title:"4. Launch Training",local:"4-launch-training",headingTag:"h2"}}),me=new U({props:{title:"Precompilation",local:"precompilation",headingTag:"h3"}}),ye=new w({props:{code:"TUFMTE9DX0FSRU5BX01BWCUzRDY0JTIwWExBX1VTRV9CRjE2JTNEMSUyMG5ldXJvbl9wYXJhbGxlbF9jb21waWxlJTIwdG9yY2hydW4lMjAtLW5wcm9jX3Blcl9ub2RlJTNEMzIlMjBsb3JhX2ZpbmV0dW5lX2xsbS5weSUyMCU1QyUwQSUyMC0tbW9kZWxfaWQlMjBtZXRhLWxsYW1hJTJGTWV0YS1MbGFtYS0zLTcwQiUyMCU1QyUwQSUyMC0tYmYxNiUyMFRydWUlMjAlNUMlMEElMjAtLWxlYXJuaW5nX3JhdGUlMjA1ZS01JTIwJTVDJTBBJTIwLS1vdXRwdXRfZGlyJTIwZG9sbHlfbGxhbWElMjAlNUMlMEElMjAtLW92ZXJ3cml0ZV9vdXRwdXRfZGlyJTIwVHJ1ZSUyMCU1QyUwQSUyMC0tcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTIwMSUyMCU1QyUwQSUyMC0tZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTIwMTYlMjAlNUMlMEElMjAtLWdyYWRpZW50X2NoZWNrcG9pbnRpbmclMjBUcnVlJTIwJTVDJTBBJTIwLS10ZW5zb3JfcGFyYWxsZWxfc2l6ZSUyMDglMjAlNUMlMEElMjAtLW1heF9zdGVwcyUyMDEwJTIwJTVDJTBBJTIwLS1sb2dnaW5nX3N0ZXBzJTIwMTA=",highlighted:`MALLOC_ARENA_MAX=64 XLA_USE_BF16=1 neuron_parallel_compile torchrun --nproc_per_node=32 lora_finetune_llm.py \\
 --model_id meta-llama/Meta-Llama-3-70B \\
 --bf16 True \\
 --learning_rate 5e-5 \\
 --output_dir dolly_llama \\
 --overwrite_output_dir True \\
 --per_device_train_batch_size 1 \\
 --gradient_accumulation_steps 16 \\
 --gradient_checkpointing True \\
 --tensor_parallel_size 8 \\
 --max_steps 10 \\
 --logging_steps 10`,wrap:!1}}),g=new ft({props:{$$slots:{default:[vs]},$$scope:{ctx:J}}}),je=new w({props:{code:"JTIzJTIwcmVtb3ZlJTIwZHVtbXklMjBhcnRpZmFjdHMlMjB3aGljaCUyMGFyZSUyMGNyZWF0ZWQlMjBieSUyMHRoZSUyMHByZWNvbXBpbGF0aW9uJTIwY29tbWFuZCUwQXJtJTIwLXJmJTIwZG9sbHlfbGxhbWE=",highlighted:`<span class="hljs-comment"># remove dummy artifacts which are created by the precompilation command</span>
<span class="hljs-built_in">rm</span> -rf dolly_llama`,wrap:!1}}),Te=new U({props:{title:"Actual Training",local:"actual-training",headingTag:"h3"}}),Ce=new w({props:{code:"TUFMTE9DX0FSRU5BX01BWCUzRDY0JTIwWExBX1VTRV9CRjE2JTNEMSUyMHRvcmNocnVuJTIwLS1ucHJvY19wZXJfbm9kZSUzRDMyJTIwbG9yYV9maW5ldHVuZV9sbG0ucHklMjAlNUMlMEElMjAtLW1vZGVsX2lkJTIwbWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy03MEIlMjAlNUMlMEElMjAtLWJmMTYlMjBUcnVlJTIwJTVDJTBBJTIwLS1sZWFybmluZ19yYXRlJTIwNWUtNSUyMCU1QyUwQSUyMC0tb3V0cHV0X2RpciUyMGRvbGx5X2xsYW1hJTIwJTVDJTBBJTIwLS1vdmVyd3JpdGVfb3V0cHV0X2RpciUyMFRydWUlMjAlNUMlMEElMjAtLXNraXBfY2FjaGVfcHVzaCUyMFRydWUlMjAlNUMlMEElMjAtLXBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUyMDElMjAlNUMlMEElMjAtLWdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUyMDE2JTIwJTVDJTBBJTIwLS1ncmFkaWVudF9jaGVja3BvaW50aW5nJTIwVHJ1ZSUyMCU1QyUwQSUyMC0tdGVuc29yX3BhcmFsbGVsX3NpemUlMjA4JTIwJTVDJTBBJTIwLS1udW1fdHJhaW5fZXBvY2hzJTIwMyUyMCU1QyUwQSUyMC0tbG9nZ2luZ19zdGVwcyUyMDEw",highlighted:`MALLOC_ARENA_MAX=64 XLA_USE_BF16=1 torchrun --nproc_per_node=32 lora_finetune_llm.py \\
 --model_id meta-llama/Meta-Llama-3-70B \\
 --bf16 True \\
 --learning_rate 5e-5 \\
 --output_dir dolly_llama \\
 --overwrite_output_dir True \\
 --skip_cache_push True \\
 --per_device_train_batch_size 1 \\
 --gradient_accumulation_steps 16 \\
 --gradient_checkpointing True \\
 --tensor_parallel_size 8 \\
 --num_train_epochs 3 \\
 --logging_steps 10`,wrap:!1}}),Be=new U({props:{title:"Consolidate the Checkpoint",local:"consolidate-the-checkpoint",headingTag:"h3"}}),Ge=new w({props:{code:"b3B0aW11bS1jbGklMjBuZXVyb24lMjBjb25zb2xpZGF0ZSUyMGRvbGx5X2xsYW1hJTIwZG9sbHlfbGxhbWE=",highlighted:"optimum-cli neuron consolidate dolly_llama dolly_llama",wrap:!1}}),We=new U({props:{title:"Merge the LoRA adapters",local:"merge-the-lora-adapters",headingTag:"h3"}}),_e=new U({props:{title:"5. Evaluate and test fine-tuned Llama model",local:"5-evaluate-and-test-fine-tuned-llama-model",headingTag:"h2"}}),Xe=new w({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uTW9kZWxGb3JDYXVzYWxMTSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvVG9rZW5pemVyJTBBJTBBY29tcGlsZXJfYXJncyUyMCUzRCUyMCU3QiUyMm51bV9jb3JlcyUyMiUzQSUyMDIlMkMlMjAlMjJhdXRvX2Nhc3RfdHlwZSUyMiUzQSUyMCdmcDE2JyU3RCUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyc2VxdWVuY2VfbGVuZ3RoJTIyJTNBJTIwMjA0OCU3RCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRvbGx5X2xsYW1hJTIyKSUwQW1vZGVsJTIwJTNEJTIwTmV1cm9uTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZG9sbHlfbGxhbWElMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBleHBvcnQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKipjb21waWxlcl9hcmdzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKippbnB1dF9zaGFwZXMp",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForCausalLM
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

compiler_args = {<span class="hljs-string">&quot;num_cores&quot;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&#x27;fp16&#x27;</span>}
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;sequence_length&quot;</span>: <span class="hljs-number">2048</span>}

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;dolly_llama&quot;</span>)
model = NeuronModelForCausalLM.from_pretrained(
        <span class="hljs-string">&quot;dolly_llama&quot;</span>,
        export=<span class="hljs-literal">True</span>,
        **compiler_args,
        **input_shapes)`,wrap:!1}}),Ve=new w({props:{code:"JTIzJTIwQ09NTUVOVCUyMElOJTIwaWYlMjB5b3UlMjB3YW50JTIwdG8lMjBzYXZlJTIwdGhlJTIwY29tcGlsZWQlMjBtb2RlbCUwQSUyMyUyMG1vZGVsLnNhdmVfcHJldHJhaW5lZCglMjJjb21waWxlZF9kb2xseV9sbGFtYSUyMik=",highlighted:`<span class="hljs-comment"># COMMENT IN if you want to save the compiled model</span>
<span class="hljs-comment"># model.save_pretrained(&quot;compiled_dolly_llama&quot;)</span>`,wrap:!1}}),$e=new w({props:{code:"ZGVmJTIwZm9ybWF0X2RvbGx5X2luZmVyZW5jZShzYW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwaW5zdHJ1Y3Rpb24lMjAlM0QlMjBmJTIyJTIzJTIzJTIzJTIwSW5zdHJ1Y3Rpb24lNUNuJTdCc2FtcGxlJTVCJ2luc3RydWN0aW9uJyU1RCU3RCUyMiUwQSUyMCUyMCUyMCUyMGNvbnRleHQlMjAlM0QlMjBmJTIyJTIzJTIzJTIzJTIwQ29udGV4dCU1Q24lN0JzYW1wbGUlNUInY29udGV4dCclNUQlN0QlMjIlMjBpZiUyMCUyMmNvbnRleHQlMjIlMjBpbiUyMHNhbXBsZSUyMGVsc2UlMjBOb25lJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjBmJTIyJTIzJTIzJTIzJTIwQW5zd2VyJTVDbiUyMiUwQSUyMCUyMCUyMCUyMHByb21wdCUyMCUzRCUyMCUyMiU1Q24lNUNuJTIyLmpvaW4oJTVCaSUyMGZvciUyMGklMjBpbiUyMCU1Qmluc3RydWN0aW9uJTJDJTIwY29udGV4dCUyQyUyMHJlc3BvbnNlJTVEJTIwaWYlMjBpJTIwaXMlMjBub3QlMjBOb25lJTVEKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHByb21wdCUwQSUwQSUwQWRlZiUyMGdlbmVyYXRlKHNhbXBsZSklM0ElMEElMjAlMjAlMjAlMjBwcm9tcHQlMjAlM0QlMjBmb3JtYXRfZG9sbHlfaW5mZXJlbmNlKHNhbXBsZSklMEElMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocHJvbXB0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKippbnB1dHMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDUxMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzRDAuOSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRvcF9rJTNENTAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0b3BfcCUzRDAuOSUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjB0b2tlbml6ZXIuZGVjb2RlKG91dHB1dHMlNUIwJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzREZhbHNlKSU1Qmxlbihwcm9tcHQpJTNBJTVE",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">format_dolly_inference</span>(<span class="hljs-params">sample</span>):
    instruction = <span class="hljs-string">f&quot;### Instruction\\n<span class="hljs-subst">{sample[<span class="hljs-string">&#x27;instruction&#x27;</span>]}</span>&quot;</span>
    context = <span class="hljs-string">f&quot;### Context\\n<span class="hljs-subst">{sample[<span class="hljs-string">&#x27;context&#x27;</span>]}</span>&quot;</span> <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;context&quot;</span> <span class="hljs-keyword">in</span> sample <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>
    response = <span class="hljs-string">f&quot;### Answer\\n&quot;</span>
    prompt = <span class="hljs-string">&quot;\\n\\n&quot;</span>.join([i <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> [instruction, context, response] <span class="hljs-keyword">if</span> i <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>])
    <span class="hljs-keyword">return</span> prompt


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate</span>(<span class="hljs-params">sample</span>):
    prompt = format_dolly_inference(sample)
    inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
    outputs = model.generate(
        **inputs,
        max_new_tokens=<span class="hljs-number">512</span>,
        do_sample=<span class="hljs-literal">True</span>,
        temperature=<span class="hljs-number">0.9</span>,
        top_k=<span class="hljs-number">50</span>,
        top_p=<span class="hljs-number">0.9</span>
    )
    <span class="hljs-keyword">return</span> tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">False</span>)[<span class="hljs-built_in">len</span>(prompt):]`,wrap:!1}}),Qe=new w({props:{code:"cHJvbXB0JTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIyaW5zdHJ1Y3Rpb24lMjIlM0ElMjAlMjJDYW4lMjB5b3UlMjB0ZWxsJTIwbWUlMjBzb21ldGhpbmclMjBhYm91dCUyMEFXUyUzRiUyMiUwQSU3RCUwQXJlcyUyMCUzRCUyMGdlbmVyYXRlKHByb21wdCklMEElMEFwcmludChyZXMp",highlighted:`prompt = {
  <span class="hljs-string">&quot;instruction&quot;</span>: <span class="hljs-string">&quot;Can you tell me something about AWS?&quot;</span>
}
res = generate(prompt)

<span class="hljs-built_in">print</span>(res)`,wrap:!1}}),Ne=new w({props:{code:"cHJvbXB0JTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIyaW5zdHJ1Y3Rpb24lMjIlM0ElMjAlMjJIb3clMjBjYW4lMjBJJTIwdHJhaW4lMjBtb2RlbHMlMjBvbiUyMEFXUyUyMFRyYWluaXVtJTNGJTIyJTJDJTBBJTIwJTIwJTIyY29udGV4dCUyMiUzQSUyMCUyMiVGMCU5RiVBNCU5NyUyME9wdGltdW0lMjBOZXVyb24lMjBpcyUyMHRoZSUyMGludGVyZmFjZSUyMGJldHdlZW4lMjB0aGUlMjAlRjAlOUYlQTQlOTclMjBUcmFuc2Zvcm1lcnMlMjBsaWJyYXJ5JTIwYW5kJTIwQVdTJTIwQWNjZWxlcmF0b3JzJTIwaW5jbHVkaW5nJTIwJTVCQVdTJTIwVHJhaW5pdW0lNUQoaHR0cHMlM0ElMkYlMkZhd3MuYW1hem9uLmNvbSUyRm1hY2hpbmUtbGVhcm5pbmclMkZ0cmFpbml1bSUyRiUzRm5jMSUzRGhfbHMpJTIwYW5kJTIwJTVCQVdTJTIwSW5mZXJlbnRpYSU1RChodHRwcyUzQSUyRiUyRmF3cy5hbWF6b24uY29tJTJGbWFjaGluZS1sZWFybmluZyUyRmluZmVyZW50aWElMkYlM0ZuYzElM0RoX2xzKS4lMjBJdCUyMHByb3ZpZGVzJTIwYSUyMHNldCUyMG9mJTIwdG9vbHMlMjBlbmFibGluZyUyMGVhc3klMjBtb2RlbCUyMGxvYWRpbmclMkMlMjB0cmFpbmluZyUyMGFuZCUyMGluZmVyZW5jZSUyMG9uJTIwc2luZ2xlLSUyMGFuZCUyMG11bHRpLUFjY2VsZXJhdG9yJTIwc2V0dGluZ3MlMjBmb3IlMjBkaWZmZXJlbnQlMjBkb3duc3RyZWFtJTIwdGFza3MuJTIyJTBBJTdEJTBBcmVzJTIwJTNEJTIwZ2VuZXJhdGUocHJvbXB0KSUwQSUwQXByaW50KHJlcyk=",highlighted:`prompt = {
  <span class="hljs-string">&quot;instruction&quot;</span>: <span class="hljs-string">&quot;How can I train models on AWS Trainium?&quot;</span>,
  <span class="hljs-string">&quot;context&quot;</span>: <span class="hljs-string">&quot;🤗 Optimum Neuron is the interface between the 🤗 Transformers library and AWS Accelerators including [AWS Trainium](https://aws.amazon.com/machine-learning/trainium/?nc1=h_ls) and [AWS Inferentia](https://aws.amazon.com/machine-learning/inferentia/?nc1=h_ls). It provides a set of tools enabling easy model loading, training and inference on single- and multi-Accelerator settings for different downstream tasks.&quot;</span>
}
res = generate(prompt)

<span class="hljs-built_in">print</span>(res)`,wrap:!1}}),{c(){r=i("meta"),j=a(),y=i("p"),T=a(),M(B.$$.fragment),qe=a(),Z=i("p"),Z.textContent=It,Pe=a(),G=i("p"),G.innerHTML=gt,De=a(),W=i("p"),W.innerHTML=Bt,Ke=a(),k=i("p"),k.textContent=Zt,Oe=a(),_=i("ol"),_.innerHTML=Gt,el=a(),M(b.$$.fragment),ll=a(),M(v.$$.fragment),tl=a(),R=i("p"),R.textContent=Wt,sl=a(),X=i("ol"),X.innerHTML=kt,al=a(),M(A.$$.fragment),nl=a(),f=i("ol"),f.innerHTML=_t,il=a(),V=i("ul"),V.innerHTML=vt,ol=a(),C=i("ol"),C.innerHTML=Rt,pl=a(),M(x.$$.fragment),rl=a(),M($.$$.fragment),Ml=a(),S=i("p"),S.innerHTML=Xt,ml=a(),H=i("p"),H.textContent=At,cl=a(),M(Q.$$.fragment),ul=a(),E=i("p"),E.innerHTML=Vt,dl=a(),M(Y.$$.fragment),hl=a(),N=i("p"),N.innerHTML=xt,yl=a(),M(z.$$.fragment),wl=a(),F=i("p"),F.textContent=$t,jl=a(),L=i("p"),L.innerHTML=St,Tl=a(),M(q.$$.fragment),Ul=a(),P=i("p"),P.textContent=Ht,Jl=a(),D=i("ol"),D.innerHTML=Qt,bl=a(),M(K.$$.fragment),fl=a(),M(O.$$.fragment),Cl=a(),ee=i("p"),ee.innerHTML=Et,Il=a(),le=i("p"),le.innerHTML=Yt,gl=a(),te=i("p"),te.textContent=Nt,Bl=a(),se=i("ol"),se.innerHTML=zt,Zl=a(),M(I.$$.fragment),Gl=a(),ae=i("p"),ae.textContent=Ft,Wl=a(),M(ne.$$.fragment),kl=a(),ie=i("p"),ie.textContent=Lt,_l=a(),oe=i("ul"),oe.innerHTML=qt,vl=a(),M(pe.$$.fragment),Rl=a(),re=i("p"),re.innerHTML=Pt,Xl=a(),Me=i("p"),Me.innerHTML=Dt,Al=a(),M(me.$$.fragment),Vl=a(),ce=i("p"),ce.textContent=Kt,xl=a(),ue=i("p"),ue.innerHTML=Ot,$l=a(),de=i("p"),de.innerHTML=es,Sl=a(),he=i("p"),he.innerHTML=ls,Hl=a(),M(ye.$$.fragment),Ql=a(),M(g.$$.fragment),El=a(),we=i("p"),we.innerHTML=ts,Yl=a(),M(je.$$.fragment),Nl=a(),M(Te.$$.fragment),zl=a(),Ue=i("p"),Ue.innerHTML=ss,Fl=a(),Je=i("p"),Je.innerHTML=as,Ll=a(),be=i("p"),be.innerHTML=ns,ql=a(),fe=i("p"),fe.textContent=is,Pl=a(),M(Ce.$$.fragment),Dl=a(),Ie=i("p"),Ie.textContent=os,Kl=a(),ge=i("p"),ge.textContent=ps,Ol=a(),M(Be.$$.fragment),et=a(),Ze=i("p"),Ze.innerHTML=rs,lt=a(),M(Ge.$$.fragment),tt=a(),M(We.$$.fragment),st=a(),ke=i("p"),ke.textContent=Ms,at=a(),M(_e.$$.fragment),nt=a(),ve=i("p"),ve.textContent=ms,it=a(),Re=i("p"),Re.innerHTML=cs,ot=a(),M(Xe.$$.fragment),pt=a(),Ae=i("p"),Ae.innerHTML=us,rt=a(),M(Ve.$$.fragment),Mt=a(),xe=i("p"),xe.innerHTML=ds,mt=a(),M($e.$$.fragment),ct=a(),Se=i("p"),Se.textContent=hs,ut=a(),He=i("p"),He.innerHTML=ys,dt=a(),M(Qe.$$.fragment),ht=a(),Ee=i("blockquote"),Ee.innerHTML=ws,yt=a(),Ye=i("p"),Ye.textContent=js,wt=a(),M(Ne.$$.fragment),jt=a(),ze=i("blockquote"),ze.innerHTML=Ts,Tt=a(),Fe=i("p"),Fe.textContent=Us,Ut=a(),Le=i("p"),this.h()},l(e){const l=Gs("svelte-u9bgzb",document.head);r=o(l,"META",{name:!0,content:!0}),l.forEach(t),j=n(e),y=o(e,"P",{}),Cs(y).forEach(t),T=n(e),m(B.$$.fragment,e),qe=n(e),Z=o(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-eibare"&&(Z.textContent=It),Pe=n(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-a8n5ns"&&(G.innerHTML=gt),De=n(e),W=o(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1nxren4"&&(W.innerHTML=Bt),Ke=n(e),k=o(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-1hahfn0"&&(k.textContent=Zt),Oe=n(e),_=o(e,"OL",{"data-svelte-h":!0}),p(_)!=="svelte-1cis6bf"&&(_.innerHTML=Gt),el=n(e),m(b.$$.fragment,e),ll=n(e),m(v.$$.fragment,e),tl=n(e),R=o(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-w52dpm"&&(R.textContent=Wt),sl=n(e),X=o(e,"OL",{"data-svelte-h":!0}),p(X)!=="svelte-15ega2l"&&(X.innerHTML=kt),al=n(e),m(A.$$.fragment,e),nl=n(e),f=o(e,"OL",{start:!0,"data-svelte-h":!0}),p(f)!=="svelte-w9kotu"&&(f.innerHTML=_t),il=n(e),V=o(e,"UL",{"data-svelte-h":!0}),p(V)!=="svelte-k05qsa"&&(V.innerHTML=vt),ol=n(e),C=o(e,"OL",{start:!0,"data-svelte-h":!0}),p(C)!=="svelte-1s9si7j"&&(C.innerHTML=Rt),pl=n(e),m(x.$$.fragment,e),rl=n(e),m($.$$.fragment,e),Ml=n(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-s6kf7j"&&(S.innerHTML=Xt),ml=n(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-11lpom8"&&(H.textContent=At),cl=n(e),m(Q.$$.fragment,e),ul=n(e),E=o(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1snwaj0"&&(E.innerHTML=Vt),dl=n(e),m(Y.$$.fragment,e),hl=n(e),N=o(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-voh434"&&(N.innerHTML=xt),yl=n(e),m(z.$$.fragment,e),wl=n(e),F=o(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-1qw7fs2"&&(F.textContent=$t),jl=n(e),L=o(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-1tlab3t"&&(L.innerHTML=St),Tl=n(e),m(q.$$.fragment,e),Ul=n(e),P=o(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-vnokz2"&&(P.textContent=Ht),Jl=n(e),D=o(e,"OL",{"data-svelte-h":!0}),p(D)!=="svelte-v6jbub"&&(D.innerHTML=Qt),bl=n(e),m(K.$$.fragment,e),fl=n(e),m(O.$$.fragment,e),Cl=n(e),ee=o(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-14g3or9"&&(ee.innerHTML=Et),Il=n(e),le=o(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-b4fdk9"&&(le.innerHTML=Yt),gl=n(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-f3wmm4"&&(te.textContent=Nt),Bl=n(e),se=o(e,"OL",{"data-svelte-h":!0}),p(se)!=="svelte-xm927i"&&(se.innerHTML=zt),Zl=n(e),m(I.$$.fragment,e),Gl=n(e),ae=o(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-qkcl0h"&&(ae.textContent=Ft),Wl=n(e),m(ne.$$.fragment,e),kl=n(e),ie=o(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-t16ze3"&&(ie.textContent=Lt),_l=n(e),oe=o(e,"UL",{"data-svelte-h":!0}),p(oe)!=="svelte-1q8imuy"&&(oe.innerHTML=qt),vl=n(e),m(pe.$$.fragment,e),Rl=n(e),re=o(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-u27vlf"&&(re.innerHTML=Pt),Xl=n(e),Me=o(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-bne5rp"&&(Me.innerHTML=Dt),Al=n(e),m(me.$$.fragment,e),Vl=n(e),ce=o(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-1u0hmu2"&&(ce.textContent=Kt),xl=n(e),ue=o(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-1gsk3gh"&&(ue.innerHTML=Ot),$l=n(e),de=o(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-jypm7b"&&(de.innerHTML=es),Sl=n(e),he=o(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-t9z3bd"&&(he.innerHTML=ls),Hl=n(e),m(ye.$$.fragment,e),Ql=n(e),m(g.$$.fragment,e),El=n(e),we=o(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-136s4kc"&&(we.innerHTML=ts),Yl=n(e),m(je.$$.fragment,e),Nl=n(e),m(Te.$$.fragment,e),zl=n(e),Ue=o(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-1yiqpri"&&(Ue.innerHTML=ss),Fl=n(e),Je=o(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-1anw499"&&(Je.innerHTML=as),Ll=n(e),be=o(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-ctfnvw"&&(be.innerHTML=ns),ql=n(e),fe=o(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-17lv8z9"&&(fe.textContent=is),Pl=n(e),m(Ce.$$.fragment,e),Dl=n(e),Ie=o(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-9y8mko"&&(Ie.textContent=os),Kl=n(e),ge=o(e,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-12iaeqv"&&(ge.textContent=ps),Ol=n(e),m(Be.$$.fragment,e),et=n(e),Ze=o(e,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-66io75"&&(Ze.innerHTML=rs),lt=n(e),m(Ge.$$.fragment,e),tt=n(e),m(We.$$.fragment,e),st=n(e),ke=o(e,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-1yyqpus"&&(ke.textContent=Ms),at=n(e),m(_e.$$.fragment,e),nt=n(e),ve=o(e,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-emhotm"&&(ve.textContent=ms),it=n(e),Re=o(e,"P",{"data-svelte-h":!0}),p(Re)!=="svelte-1pgrxrm"&&(Re.innerHTML=cs),ot=n(e),m(Xe.$$.fragment,e),pt=n(e),Ae=o(e,"P",{"data-svelte-h":!0}),p(Ae)!=="svelte-1sinvz7"&&(Ae.innerHTML=us),rt=n(e),m(Ve.$$.fragment,e),Mt=n(e),xe=o(e,"P",{"data-svelte-h":!0}),p(xe)!=="svelte-jx2yqv"&&(xe.innerHTML=ds),mt=n(e),m($e.$$.fragment,e),ct=n(e),Se=o(e,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-1ytr5g6"&&(Se.textContent=hs),ut=n(e),He=o(e,"P",{"data-svelte-h":!0}),p(He)!=="svelte-1j8w2o0"&&(He.innerHTML=ys),dt=n(e),m(Qe.$$.fragment,e),ht=n(e),Ee=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),p(Ee)!=="svelte-6l4k0q"&&(Ee.innerHTML=ws),yt=n(e),Ye=o(e,"P",{"data-svelte-h":!0}),p(Ye)!=="svelte-ovzcvi"&&(Ye.textContent=js),wt=n(e),m(Ne.$$.fragment,e),jt=n(e),ze=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),p(ze)!=="svelte-15xrtpx"&&(ze.innerHTML=Ts),Tt=n(e),Fe=o(e,"P",{"data-svelte-h":!0}),p(Fe)!=="svelte-q9f4rf"&&(Fe.textContent=Us),Ut=n(e),Le=o(e,"P",{}),Cs(Le).forEach(t),this.h()},h(){bt(r,"name","hf:doc:metadata"),bt(r,"content",Xs),bt(f,"start","3"),bt(C,"start","4")},m(e,l){Ws(document.head,r),s(e,j,l),s(e,y,l),s(e,T,l),c(B,e,l),s(e,qe,l),s(e,Z,l),s(e,Pe,l),s(e,G,l),s(e,De,l),s(e,W,l),s(e,Ke,l),s(e,k,l),s(e,Oe,l),s(e,_,l),s(e,el,l),c(b,e,l),s(e,ll,l),c(v,e,l),s(e,tl,l),s(e,R,l),s(e,sl,l),s(e,X,l),s(e,al,l),c(A,e,l),s(e,nl,l),s(e,f,l),s(e,il,l),s(e,V,l),s(e,ol,l),s(e,C,l),s(e,pl,l),c(x,e,l),s(e,rl,l),c($,e,l),s(e,Ml,l),s(e,S,l),s(e,ml,l),s(e,H,l),s(e,cl,l),c(Q,e,l),s(e,ul,l),s(e,E,l),s(e,dl,l),c(Y,e,l),s(e,hl,l),s(e,N,l),s(e,yl,l),c(z,e,l),s(e,wl,l),s(e,F,l),s(e,jl,l),s(e,L,l),s(e,Tl,l),c(q,e,l),s(e,Ul,l),s(e,P,l),s(e,Jl,l),s(e,D,l),s(e,bl,l),c(K,e,l),s(e,fl,l),c(O,e,l),s(e,Cl,l),s(e,ee,l),s(e,Il,l),s(e,le,l),s(e,gl,l),s(e,te,l),s(e,Bl,l),s(e,se,l),s(e,Zl,l),c(I,e,l),s(e,Gl,l),s(e,ae,l),s(e,Wl,l),c(ne,e,l),s(e,kl,l),s(e,ie,l),s(e,_l,l),s(e,oe,l),s(e,vl,l),c(pe,e,l),s(e,Rl,l),s(e,re,l),s(e,Xl,l),s(e,Me,l),s(e,Al,l),c(me,e,l),s(e,Vl,l),s(e,ce,l),s(e,xl,l),s(e,ue,l),s(e,$l,l),s(e,de,l),s(e,Sl,l),s(e,he,l),s(e,Hl,l),c(ye,e,l),s(e,Ql,l),c(g,e,l),s(e,El,l),s(e,we,l),s(e,Yl,l),c(je,e,l),s(e,Nl,l),c(Te,e,l),s(e,zl,l),s(e,Ue,l),s(e,Fl,l),s(e,Je,l),s(e,Ll,l),s(e,be,l),s(e,ql,l),s(e,fe,l),s(e,Pl,l),c(Ce,e,l),s(e,Dl,l),s(e,Ie,l),s(e,Kl,l),s(e,ge,l),s(e,Ol,l),c(Be,e,l),s(e,et,l),s(e,Ze,l),s(e,lt,l),c(Ge,e,l),s(e,tt,l),c(We,e,l),s(e,st,l),s(e,ke,l),s(e,at,l),c(_e,e,l),s(e,nt,l),s(e,ve,l),s(e,it,l),s(e,Re,l),s(e,ot,l),c(Xe,e,l),s(e,pt,l),s(e,Ae,l),s(e,rt,l),c(Ve,e,l),s(e,Mt,l),s(e,xe,l),s(e,mt,l),c($e,e,l),s(e,ct,l),s(e,Se,l),s(e,ut,l),s(e,He,l),s(e,dt,l),c(Qe,e,l),s(e,ht,l),s(e,Ee,l),s(e,yt,l),s(e,Ye,l),s(e,wt,l),c(Ne,e,l),s(e,jt,l),s(e,ze,l),s(e,Tt,l),s(e,Fe,l),s(e,Ut,l),s(e,Le,l),Jt=!0},p(e,[l]){const Js={};l&2&&(Js.$$scope={dirty:l,ctx:e}),b.$set(Js);const bs={};l&2&&(bs.$$scope={dirty:l,ctx:e}),I.$set(bs);const fs={};l&2&&(fs.$$scope={dirty:l,ctx:e}),g.$set(fs)},i(e){Jt||(u(B.$$.fragment,e),u(b.$$.fragment,e),u(v.$$.fragment,e),u(A.$$.fragment,e),u(x.$$.fragment,e),u($.$$.fragment,e),u(Q.$$.fragment,e),u(Y.$$.fragment,e),u(z.$$.fragment,e),u(q.$$.fragment,e),u(K.$$.fragment,e),u(O.$$.fragment,e),u(I.$$.fragment,e),u(ne.$$.fragment,e),u(pe.$$.fragment,e),u(me.$$.fragment,e),u(ye.$$.fragment,e),u(g.$$.fragment,e),u(je.$$.fragment,e),u(Te.$$.fragment,e),u(Ce.$$.fragment,e),u(Be.$$.fragment,e),u(Ge.$$.fragment,e),u(We.$$.fragment,e),u(_e.$$.fragment,e),u(Xe.$$.fragment,e),u(Ve.$$.fragment,e),u($e.$$.fragment,e),u(Qe.$$.fragment,e),u(Ne.$$.fragment,e),Jt=!0)},o(e){d(B.$$.fragment,e),d(b.$$.fragment,e),d(v.$$.fragment,e),d(A.$$.fragment,e),d(x.$$.fragment,e),d($.$$.fragment,e),d(Q.$$.fragment,e),d(Y.$$.fragment,e),d(z.$$.fragment,e),d(q.$$.fragment,e),d(K.$$.fragment,e),d(O.$$.fragment,e),d(I.$$.fragment,e),d(ne.$$.fragment,e),d(pe.$$.fragment,e),d(me.$$.fragment,e),d(ye.$$.fragment,e),d(g.$$.fragment,e),d(je.$$.fragment,e),d(Te.$$.fragment,e),d(Ce.$$.fragment,e),d(Be.$$.fragment,e),d(Ge.$$.fragment,e),d(We.$$.fragment,e),d(_e.$$.fragment,e),d(Xe.$$.fragment,e),d(Ve.$$.fragment,e),d($e.$$.fragment,e),d(Qe.$$.fragment,e),d(Ne.$$.fragment,e),Jt=!1},d(e){e&&(t(j),t(y),t(T),t(qe),t(Z),t(Pe),t(G),t(De),t(W),t(Ke),t(k),t(Oe),t(_),t(el),t(ll),t(tl),t(R),t(sl),t(X),t(al),t(nl),t(f),t(il),t(V),t(ol),t(C),t(pl),t(rl),t(Ml),t(S),t(ml),t(H),t(cl),t(ul),t(E),t(dl),t(hl),t(N),t(yl),t(wl),t(F),t(jl),t(L),t(Tl),t(Ul),t(P),t(Jl),t(D),t(bl),t(fl),t(Cl),t(ee),t(Il),t(le),t(gl),t(te),t(Bl),t(se),t(Zl),t(Gl),t(ae),t(Wl),t(kl),t(ie),t(_l),t(oe),t(vl),t(Rl),t(re),t(Xl),t(Me),t(Al),t(Vl),t(ce),t(xl),t(ue),t($l),t(de),t(Sl),t(he),t(Hl),t(Ql),t(El),t(we),t(Yl),t(Nl),t(zl),t(Ue),t(Fl),t(Je),t(Ll),t(be),t(ql),t(fe),t(Pl),t(Dl),t(Ie),t(Kl),t(ge),t(Ol),t(et),t(Ze),t(lt),t(tt),t(st),t(ke),t(at),t(nt),t(ve),t(it),t(Re),t(ot),t(pt),t(Ae),t(rt),t(Mt),t(xe),t(mt),t(ct),t(Se),t(ut),t(He),t(dt),t(ht),t(Ee),t(yt),t(Ye),t(wt),t(jt),t(ze),t(Tt),t(Fe),t(Ut),t(Le)),t(r),h(B,e),h(b,e),h(v,e),h(A,e),h(x,e),h($,e),h(Q,e),h(Y,e),h(z,e),h(q,e),h(K,e),h(O,e),h(I,e),h(ne,e),h(pe,e),h(me,e),h(ye,e),h(g,e),h(je,e),h(Te,e),h(Ce,e),h(Be,e),h(Ge,e),h(We,e),h(_e,e),h(Xe,e),h(Ve,e),h($e,e),h(Qe,e),h(Ne,e)}}}const Xs='{"title":"Fine-tune Llama 3 70B on one AWS Trainium instance with LoRA","local":"fine-tune-llama-3-70b-on-one-aws-trainium-instance-with-lora","sections":[{"title":"1. Setup AWS Environment","local":"1-setup-aws-environment","sections":[],"depth":2},{"title":"2. Load and prepare the dataset","local":"2-load-and-prepare-the-dataset","sections":[],"depth":2},{"title":"3. Fine-tune Llama using LoRA on AWS Trainium with the NeuronTrainer","local":"3-fine-tune-llama-using-lora-on-aws-trainium-with-the-neurontrainer","sections":[],"depth":2},{"title":"4. Launch Training","local":"4-launch-training","sections":[{"title":"Precompilation","local":"precompilation","sections":[],"depth":3},{"title":"Actual Training","local":"actual-training","sections":[],"depth":3},{"title":"Consolidate the Checkpoint","local":"consolidate-the-checkpoint","sections":[],"depth":3},{"title":"Merge the LoRA adapters","local":"merge-the-lora-adapters","sections":[],"depth":3}],"depth":2},{"title":"5. Evaluate and test fine-tuned Llama model","local":"5-evaluate-and-test-fine-tuned-llama-model","sections":[],"depth":2}],"depth":1}';function As(J){return gs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Qs extends Bs{constructor(r){super(),Zs(this,r,As,Rs,Is,{})}}export{Qs as component};
