import{s as Bo,o as Ao,n as Fe}from"../chunks/scheduler.25b97de1.js";import{S as Lo,i as Xo,g as d,s,r as h,m as Ho,A as So,h as c,f as o,c as a,j as J,u,x as p,n as qo,k as x,y as i,a as r,v as f,d as _,t as g,w as b}from"../chunks/index.d9030fc9.js";import{T as jt}from"../chunks/Tip.baa67368.js";import{D as R}from"../chunks/Docstring.e257edda.js";import{C as Ke}from"../chunks/CodeBlock.e6cd0d95.js";import{E as co}from"../chunks/ExampleCodeBlock.20db4b6e.js";import{P as Qo}from"../chunks/PipelineTag.5f100392.js";import{H as ot,E as Po}from"../chunks/EditOnGithub.91d95064.js";function Do(w){let n,T=`The checkpoints uploaded on the Hub use <code>torch_dtype = &#39;float16&#39;</code>, which will be
used by the <code>AutoModel</code> API to cast the checkpoints from <code>torch.float32</code> to <code>torch.float16</code>.`,l,y,U="The <code>dtype</code> of the online weights is mostly irrelevant unless you are using <code>torch_dtype=&quot;auto&quot;</code> when initializing a model using <code>model = AutoModelForCausalLM.from_pretrained(&quot;path&quot;, torch_dtype = &quot;auto&quot;)</code>. The reason is that the model will first be downloaded ( using the <code>dtype</code> of the checkpoints online), then it will be casted to the default <code>dtype</code> of <code>torch</code> (becomes <code>torch.float32</code>), and finally, if there is a <code>torch_dtype</code> provided in the config, it will be used.",k,C,Y="Training the model in <code>float16</code> is not recommended and is known to produce <code>nan</code>; as such, the model should be trained in <code>bfloat16</code>.";return{c(){n=d("p"),n.innerHTML=T,l=s(),y=d("p"),y.innerHTML=U,k=s(),C=d("p"),C.innerHTML=Y},l(v){n=c(v,"P",{"data-svelte-h":!0}),p(n)!=="svelte-6dqtgt"&&(n.innerHTML=T),l=a(v),y=c(v,"P",{"data-svelte-h":!0}),p(y)!=="svelte-17gt3kv"&&(y.innerHTML=U),k=a(v),C=c(v,"P",{"data-svelte-h":!0}),p(C)!=="svelte-wna3bo"&&(C.innerHTML=Y)},m(v,B){r(v,n,B),r(v,l,B),r(v,y,B),r(v,k,B),r(v,C,B)},p:Fe,d(v){v&&(o(n),o(l),o(y),o(k),o(C))}}}function Oo(w){let n,T;return n=new Ke({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENvaGVyZU1vZGVsJTJDJTIwQ29oZXJlQ29uZmlnJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMENvaGVyZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBDb2hlcmVDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBDb2hlcmUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBDb2hlcmVNb2RlbChjb25maWd1cmF0aW9uKSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CohereModel, CohereConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Cohere model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = CohereConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the Cohere configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = CohereModel(configuration)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){h(n.$$.fragment)},l(l){u(n.$$.fragment,l)},m(l,y){f(n,l,y),T=!0},p:Fe,i(l){T||(_(n.$$.fragment,l),T=!0)},o(l){g(n.$$.fragment,l),T=!1},d(l){b(n,l)}}}function Yo(w){let n,T;return n=new Ke({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJDb2hlcmVGb3JBSSUyRmM0YWktY29tbWFuZC1yLXYwMSUyMiklMEF0b2tlbml6ZXIuZW5jb2RlKCUyMkhlbGxvJTIwdGhpcyUyMGlzJTIwYSUyMHRlc3QlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;CohereForAI/c4ai-command-r-v01&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.encode(<span class="hljs-string">&quot;Hello this is a test&quot;</span>)
[<span class="hljs-number">5</span>, <span class="hljs-number">28339</span>, <span class="hljs-number">2075</span>, <span class="hljs-number">1801</span>, <span class="hljs-number">1671</span>, <span class="hljs-number">3282</span>]`,wrap:!1}}),{c(){h(n.$$.fragment)},l(l){u(n.$$.fragment,l)},m(l,y){f(n,l,y),T=!0},p:Fe,i(l){T||(_(n.$$.fragment,l),T=!0)},o(l){g(n.$$.fragment,l),T=!1},d(l){b(n,l)}}}function Ko(w){let n,T="When used with <code>is_split_into_words=True</code>, this tokenizer needs to be instantiated with <code>add_prefix_space=True</code>.";return{c(){n=d("p"),n.innerHTML=T},l(l){n=c(l,"P",{"data-svelte-h":!0}),p(n)!=="svelte-9gg91e"&&(n.innerHTML=T)},m(l,y){r(l,n,y)},p:Fe,d(l){l&&o(n)}}}function en(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=d("p"),n.innerHTML=T},l(l){n=c(l,"P",{"data-svelte-h":!0}),p(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(l,y){r(l,n,y)},p:Fe,d(l){l&&o(n)}}}function tn(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=d("p"),n.innerHTML=T},l(l){n=c(l,"P",{"data-svelte-h":!0}),p(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(l,y){r(l,n,y)},p:Fe,d(l){l&&o(n)}}}function on(w){let n,T="Example:",l,y,U;return y=new Ke({props:{code:"JTNFJTNFJTIwZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBDb2hlcmVGb3JDYXVzYWxMTSUwQSUwQSUzRSUzRSUyMG1vZGVsJTIwJTNEJTIwQ29oZXJlRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMkNvaGVyZUZvckFJJTJGYzRhaS1jb21tYW5kLXItdjAxJTIyKSUwQSUzRSUzRSUyMHRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMkNvaGVyZUZvckFJJTJGYzRhaS1jb21tYW5kLXItdjAxJTIyKSUwQSUwQSUzRSUzRSUyMHByb21wdCUyMCUzRCUyMCUyMkhleSUyQyUyMGFyZSUyMHlvdSUyMGNvbnNjaW91cyUzRiUyMENhbiUyMHlvdSUyMHRhbGslMjB0byUyMG1lJTNGJTIyJTBBJTNFJTNFJTIwaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTNFJTNFJTIwJTIzJTIwR2VuZXJhdGUlMEElM0UlM0UlMjBnZW5lcmF0ZV9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMuaW5wdXRfaWRzJTJDJTIwbWF4X2xlbmd0aCUzRDMwKSUwQSUzRSUzRSUyMHRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUlMkMlMjBjbGVhbl91cF90b2tlbml6YXRpb25fc3BhY2VzJTNERmFsc2UpJTVCMCU1RCUwQSUyMkhleSUyQyUyMGFyZSUyMHlvdSUyMGNvbnNjaW91cyUzRiUyMENhbiUyMHlvdSUyMHRhbGslMjB0byUyMG1lJTNGJTVDbkknbSUyMG5vdCUyMGNvbnNjaW91cyUyQyUyMGJ1dCUyMEklMjBjYW4lMjB0YWxrJTIwdG8lMjB5b3UuJTIy",highlighted:`&gt;&gt; <span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, CohereForCausalLM

&gt;&gt; model = CohereForCausalLM.from_pretrained(<span class="hljs-string">&quot;CohereForAI/c4ai-command-r-v01&quot;</span>)
&gt;&gt; tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;CohereForAI/c4ai-command-r-v01&quot;</span>)

&gt;&gt; prompt = <span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?&quot;</span>
&gt;&gt; inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

&gt;&gt; <span class="hljs-comment"># Generate</span>
&gt;&gt; generate_ids = model.generate(inputs.input_ids, max_length=<span class="hljs-number">30</span>)
&gt;&gt; tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?\\nI&#x27;m not conscious, but I can talk to you.&quot;</span>`,wrap:!1}}),{c(){n=d("p"),n.textContent=T,l=s(),h(y.$$.fragment)},l(k){n=c(k,"P",{"data-svelte-h":!0}),p(n)!=="svelte-11lpom8"&&(n.textContent=T),l=a(k),u(y.$$.fragment,k)},m(k,C){r(k,n,C),r(k,l,C),f(y,k,C),U=!0},p:Fe,i(k){U||(_(y.$$.fragment,k),U=!0)},o(k){g(y.$$.fragment,k),U=!1},d(k){k&&(o(n),o(l)),b(y,k)}}}function nn(w){let n,T,l,y,U,k,C,Y,v,B='The Cohere Command-R model was proposed in the blogpost <a href="https://txt.cohere.com/command-r/" rel="nofollow">Command-R: Retrieval Augmented Generation at Production Scale</a> by the Cohere Team.',nt,K,po="The abstract from the paper is the following:",st,ee,mo="<em>Command-R is a scalable generative model targeting RAG and Tool Use to enable production-scale AI for enterprise. Today, we are introducing Command-R, a new LLM aimed at large-scale production workloads. Command-R targets the emerging “scalable” category of models that balance high efficiency with strong accuracy, enabling companies to move beyond proof of concept, and into production.</em>",at,te,ho="*Command-R is a generative model optimized for long context tasks such as retrieval augmented generation (RAG) and using external APIs and tools. It is designed to work in concert with our industry-leading Embed and Rerank models to provide best-in-class integration for RAG applications and excel at enterprise use cases. As a model built for companies to implement at scale, Command-R boasts:",rt,oe,uo="<li>Strong accuracy on RAG and Tool Use</li> <li>Low latency, and high throughput</li> <li>Longer 128k context and lower pricing</li> <li>Strong capabilities across 10 key languages</li> <li>Model weights available on HuggingFace for research and evaluation</li>",it,ne,fo=`Checkout model checkpoints <a href="https://huggingface.co/CohereForAI/c4ai-command-r-v01" rel="nofollow">here</a>.
This model was contributed by <a href="https://huggingface.co/saurabhdash" rel="nofollow">Saurabh Dash</a> and <a href="https://huggingface.co/ahmetustun" rel="nofollow">Ahmet Üstün</a>. The code of the implementation in Hugging Face is based on GPT-NeoX <a href="https://github.com/EleutherAI/gpt-neox" rel="nofollow">here</a>.`,lt,se,dt,A,ct,ae,pt,re,_o="<li>When using Flash Attention 2 via <code>attn_implementation=&quot;flash_attention_2&quot;</code>, don’t pass <code>torch_dtype</code> to the <code>from_pretrained</code> class method and use Automatic Mixed-Precision training. When using <code>Trainer</code>, it is simply specifying either <code>fp16</code> or <code>bf16</code> to <code>True</code>. Otherwise, make sure you are using <code>torch.autocast</code>. This is required because the Flash Attention only support <code>fp16</code> and <code>bf16</code> data type.</li>",mt,ie,ht,le,go="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with Command-R. If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",ut,de,ft,ce,bo="Loading FP16 model",_t,pe,gt,me,yo="Loading bitsnbytes 4bit quantized model",bt,he,yt,ue,Tt,z,fe,Ft,Re,To=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_31224/en/model_doc/cohere#transformers.CohereModel">CohereModel</a>. It is used to instantiate an Cohere
model according to the specified arguments, defining the model architecture.`,Rt,We,Mo=`Configuration objects inherit from <a href="/docs/transformers/pr_31224/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_31224/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information. Instantiating a configuration
with the defaults will yield a similar configuration to that of the <a href="https://huggingface.co/CohereForAI/c4ai-command-r-v01" rel="nofollow">CohereForAI/c4ai-command-r-v01</a> model.`,Wt,L,Mt,_e,ko="## CohereTokenizerFast[[transformers.CohereTokenizerFast]]",kt,m,ge,Zt,Ze,vo="Construct a Cohere tokenizer. Based on byte-level Byte-Pair-Encoding.",It,Ie,Co="This uses notably ByteFallback and NFC normalization.",Vt,X,Nt,Ve,wo=`If you want to change the <code>bos_token</code> or the <code>eos_token</code>, make sure to specify them when initializing the model, or
call <code>tokenizer.update_post_processor()</code> to make sure that the post-processing is correctly done (otherwise the
values of the first token and final token of an encoded sequence will not be correct). For more details, checkout
[post-processors] (<a href="https://huggingface.co/docs/tokenizers/api/post-processors" rel="nofollow">https://huggingface.co/docs/tokenizers/api/post-processors</a>) documentation.`,Et,Ne,Uo=`You can get around that behavior by passing <code>add_prefix_space=True</code> when instantiating this tokenizer, but since
the model was not pretrained this way, it might yield a decrease in performance.`,Gt,H,Bt,Ee,$o=`This tokenizer inherits from <a href="/docs/transformers/pr_31224/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast">PreTrainedTokenizerFast</a> which contains most of the main methods. Users should
refer to this superclass for more information regarding those methods.`,At,Ge,be,Lt,S,ye,Xt,Be,zo=`Retrieves sequence ids from a token list that has no special tokens added. This method is called when adding
special tokens using the tokenizer <code>prepare_for_model</code> or <code>encode_plus</code> methods.`,Ht,W,Te,St,Ae,Jo=`Create the token type IDs corresponding to the sequences passed. <a href="../glossary#token-type-ids">What are token type
IDs?</a>`,qt,Le,xo="Should be overridden in a subclass if the model has a special way of building those.",Qt,q,Me,Pt,Xe,jo="Updates the underlying post processor with the current <code>bos_token</code> and <code>eos_token</code>.",Dt,Z,ke,Ot,He,Fo="Save only the vocabulary of the tokenizer (vocabulary + added tokens).",Yt,Se,Ro=`This method won’t save the configuration and special token mappings of the tokenizer. Use
<code>_save_pretrained()</code> to save the whole state of the tokenizer.`,vt,ve,Wo="## CohereModel[[transformers.CohereModel]]",Ct,$,Ce,Kt,qe,Zo=`The bare Cohere Model outputting raw hidden-states without any specific head on top.
This model inherits from <a href="/docs/transformers/pr_31224/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,eo,Qe,Io=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,to,Pe,Vo="Transformer decoder consisting of <em>config.num_hidden_layers</em> layers. Each layer is a <code>CohereDecoderLayer</code>",oo,I,we,no,De,No='The <a href="/docs/transformers/pr_31224/en/model_doc/cohere#transformers.CohereModel">CohereModel</a> forward method, overrides the <code>__call__</code> special method.',so,Q,wt,Ue,Eo="## CohereForCausalLM[[transformers.CohereForCausalLM]]",Ut,N,$e,ao,j,ze,ro,Oe,Go='The <a href="/docs/transformers/pr_31224/en/model_doc/cohere#transformers.CohereForCausalLM">CohereForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',io,P,lo,D,$t,Je,zt,et,Jt;return U=new ot({props:{title:"Cohere",local:"cohere",headingTag:"h1"}}),C=new ot({props:{title:"Overview",local:"overview",headingTag:"h2"}}),se=new ot({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),A=new jt({props:{warning:!0,$$slots:{default:[Do]},$$scope:{ctx:w}}}),ae=new Ke({props:{code:"JTIzJTIwcGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvVG9rZW5pemVyJTJDJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMkNvaGVyZUZvckFJJTJGYzRhaS1jb21tYW5kLXItdjAxJTIyJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBJTBBJTIzJTIwRm9ybWF0JTIwbWVzc2FnZSUyMHdpdGglMjB0aGUlMjBjb21tYW5kLXIlMjBjaGF0JTIwdGVtcGxhdGUlMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhlbGxvJTJDJTIwaG93JTIwYXJlJTIweW91JTNGJTIyJTdEJTVEJTBBaW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzRFRydWUlMkMlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMjMlMjMlMjAlM0NCT1NfVE9LRU4lM0UlM0MlN0NTVEFSVF9PRl9UVVJOX1RPS0VOJTdDJTNFJTNDJTdDVVNFUl9UT0tFTiU3QyUzRUhlbGxvJTJDJTIwaG93JTIwYXJlJTIweW91JTNGJTNDJTdDRU5EX09GX1RVUk5fVE9LRU4lN0MlM0UlM0MlN0NTVEFSVF9PRl9UVVJOX1RPS0VOJTdDJTNFJTNDJTdDQ0hBVEJPVF9UT0tFTiU3QyUzRSUwQSUwQWdlbl90b2tlbnMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjBpbnB1dF9pZHMlMkMlMjAlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDEwMCUyQyUyMCUwQSUyMCUyMCUyMCUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjAlMEElMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzRDAuMyUyQyUwQSUyMCUyMCUyMCUyMCklMEElMEFnZW5fdGV4dCUyMCUzRCUyMHRva2VuaXplci5kZWNvZGUoZ2VuX3Rva2VucyU1QjAlNUQpJTBBcHJpbnQoZ2VuX3RleHQp",highlighted:`<span class="hljs-comment"># pip install transformers</span>
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

model_id = <span class="hljs-string">&quot;CohereForAI/c4ai-command-r-v01&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_id)
model = AutoModelForCausalLM.from_pretrained(model_id)

<span class="hljs-comment"># Format message with the command-r chat template</span>
messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>}]
input_ids = tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">True</span>, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-comment">## &lt;BOS_TOKEN&gt;&lt;|START_OF_TURN_TOKEN|&gt;&lt;|USER_TOKEN|&gt;Hello, how are you?&lt;|END_OF_TURN_TOKEN|&gt;&lt;|START_OF_TURN_TOKEN|&gt;&lt;|CHATBOT_TOKEN|&gt;</span>

gen_tokens = model.generate(
    input_ids, 
    max_new_tokens=<span class="hljs-number">100</span>, 
    do_sample=<span class="hljs-literal">True</span>, 
    temperature=<span class="hljs-number">0.3</span>,
    )

gen_text = tokenizer.decode(gen_tokens[<span class="hljs-number">0</span>])
<span class="hljs-built_in">print</span>(gen_text)`,wrap:!1}}),ie=new ot({props:{title:"Resources",local:"resources",headingTag:"h2"}}),de=new Qo({props:{pipeline:"text-generation"}}),pe=new Ke({props:{code:"JTIzJTIwcGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvVG9rZW5pemVyJTJDJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMkNvaGVyZUZvckFJJTJGYzRhaS1jb21tYW5kLXItdjAxJTIyJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBJTBBJTIzJTIwRm9ybWF0JTIwbWVzc2FnZSUyMHdpdGglMjB0aGUlMjBjb21tYW5kLXIlMjBjaGF0JTIwdGVtcGxhdGUlMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhlbGxvJTJDJTIwaG93JTIwYXJlJTIweW91JTNGJTIyJTdEJTVEJTBBaW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzRFRydWUlMkMlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMjMlMjMlMjAlM0NCT1NfVE9LRU4lM0UlM0MlN0NTVEFSVF9PRl9UVVJOX1RPS0VOJTdDJTNFJTNDJTdDVVNFUl9UT0tFTiU3QyUzRUhlbGxvJTJDJTIwaG93JTIwYXJlJTIweW91JTNGJTNDJTdDRU5EX09GX1RVUk5fVE9LRU4lN0MlM0UlM0MlN0NTVEFSVF9PRl9UVVJOX1RPS0VOJTdDJTNFJTNDJTdDQ0hBVEJPVF9UT0tFTiU3QyUzRSUwQSUwQWdlbl90b2tlbnMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjBpbnB1dF9pZHMlMkMlMjAlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDEwMCUyQyUyMCUwQSUyMCUyMCUyMCUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjAlMEElMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzRDAuMyUyQyUwQSUyMCUyMCUyMCUyMCklMEElMEFnZW5fdGV4dCUyMCUzRCUyMHRva2VuaXplci5kZWNvZGUoZ2VuX3Rva2VucyU1QjAlNUQpJTBBcHJpbnQoZ2VuX3RleHQp",highlighted:`<span class="hljs-comment"># pip install transformers</span>
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

model_id = <span class="hljs-string">&quot;CohereForAI/c4ai-command-r-v01&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_id)
model = AutoModelForCausalLM.from_pretrained(model_id)

<span class="hljs-comment"># Format message with the command-r chat template</span>
messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>}]
input_ids = tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">True</span>, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-comment">## &lt;BOS_TOKEN&gt;&lt;|START_OF_TURN_TOKEN|&gt;&lt;|USER_TOKEN|&gt;Hello, how are you?&lt;|END_OF_TURN_TOKEN|&gt;&lt;|START_OF_TURN_TOKEN|&gt;&lt;|CHATBOT_TOKEN|&gt;</span>

gen_tokens = model.generate(
    input_ids, 
    max_new_tokens=<span class="hljs-number">100</span>, 
    do_sample=<span class="hljs-literal">True</span>, 
    temperature=<span class="hljs-number">0.3</span>,
    )

gen_text = tokenizer.decode(gen_tokens[<span class="hljs-number">0</span>])
<span class="hljs-built_in">print</span>(gen_text)`,wrap:!1}}),he=new Ke({props:{code:"JTIzJTIwcGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGJpdHNhbmRieXRlcyUyMGFjY2VsZXJhdGUlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBYm5iX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyhsb2FkX2luXzRiaXQlM0RUcnVlKSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyQ29oZXJlRm9yQUklMkZjNGFpLWNvbW1hbmQtci12MDElMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHF1YW50aXphdGlvbl9jb25maWclM0RibmJfY29uZmlnKSUwQSUwQWdlbl90b2tlbnMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjBpbnB1dF9pZHMlMkMlMjAlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDEwMCUyQyUyMCUwQSUyMCUyMCUyMCUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjAlMEElMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzRDAuMyUyQyUwQSUyMCUyMCUyMCUyMCklMEElMEFnZW5fdGV4dCUyMCUzRCUyMHRva2VuaXplci5kZWNvZGUoZ2VuX3Rva2VucyU1QjAlNUQpJTBBcHJpbnQoZ2VuX3RleHQp",highlighted:`<span class="hljs-comment"># pip install transformers bitsandbytes accelerate</span>
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, BitsAndBytesConfig

bnb_config = BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>)

model_id = <span class="hljs-string">&quot;CohereForAI/c4ai-command-r-v01&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_id)
model = AutoModelForCausalLM.from_pretrained(model_id, quantization_config=bnb_config)

gen_tokens = model.generate(
    input_ids, 
    max_new_tokens=<span class="hljs-number">100</span>, 
    do_sample=<span class="hljs-literal">True</span>, 
    temperature=<span class="hljs-number">0.3</span>,
    )

gen_text = tokenizer.decode(gen_tokens[<span class="hljs-number">0</span>])
<span class="hljs-built_in">print</span>(gen_text)`,wrap:!1}}),ue=new ot({props:{title:"CohereConfig",local:"transformers.CohereConfig",headingTag:"h2"}}),fe=new R({props:{name:"class transformers.CohereConfig",anchor:"transformers.CohereConfig",parameters:[{name:"vocab_size",val:" = 256000"},{name:"hidden_size",val:" = 8192"},{name:"intermediate_size",val:" = 22528"},{name:"logit_scale",val:" = 0.0625"},{name:"num_hidden_layers",val:" = 40"},{name:"num_attention_heads",val:" = 64"},{name:"num_key_value_heads",val:" = None"},{name:"hidden_act",val:" = 'silu'"},{name:"max_position_embeddings",val:" = 8192"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-05"},{name:"use_cache",val:" = True"},{name:"pad_token_id",val:" = 0"},{name:"bos_token_id",val:" = 5"},{name:"eos_token_id",val:" = 255001"},{name:"tie_word_embeddings",val:" = True"},{name:"rope_theta",val:" = 10000.0"},{name:"attention_bias",val:" = False"},{name:"attention_dropout",val:" = 0.0"},{name:"use_qk_norm",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.CohereConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256000) &#x2014;
Vocabulary size of the Cohere model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/pr_31224/en/model_doc/cohere#transformers.CohereModel">CohereModel</a>`,name:"vocab_size"},{anchor:"transformers.CohereConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 8192) &#x2014;
Dimension of the hidden representations.`,name:"hidden_size"},{anchor:"transformers.CohereConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 22528) &#x2014;
Dimension of the MLP representations.`,name:"intermediate_size"},{anchor:"transformers.CohereConfig.logit_scale",description:`<strong>logit_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0625) &#x2014;
The scaling factor for the output logits.`,name:"logit_scale"},{anchor:"transformers.CohereConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 40) &#x2014;
Number of hidden layers in the Transformer decoder.`,name:"num_hidden_layers"},{anchor:"transformers.CohereConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Number of attention heads for each attention layer in the Transformer decoder.`,name:"num_attention_heads"},{anchor:"transformers.CohereConfig.num_key_value_heads",description:`<strong>num_key_value_heads</strong> (<code>int</code>, <em>optional</em>) &#x2014;
This is the number of key_value heads that should be used to implement Grouped Query Attention. If
<code>num_key_value_heads=num_attention_heads</code>, the model will use Multi Head Attention (MHA), if
<code>num_key_value_heads=1 the model will use Multi Query Attention (MQA) otherwise GQA is used. When converting a multi-head checkpoint to a GQA checkpoint, each group key and value head should be constructed by meanpooling all the original heads within that group. For more details checkout [this paper](https://arxiv.org/pdf/2305.13245.pdf). If it is not specified, will default to </code>num_attention_heads\`.`,name:"num_key_value_heads"},{anchor:"transformers.CohereConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder.`,name:"hidden_act"},{anchor:"transformers.CohereConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 8192) &#x2014;
The maximum sequence length that this model might ever be used with.`,name:"max_position_embeddings"},{anchor:"transformers.CohereConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.CohereConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the layer normalization.`,name:"layer_norm_eps"},{anchor:"transformers.CohereConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.CohereConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Padding token id.`,name:"pad_token_id"},{anchor:"transformers.CohereConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 5) &#x2014;
Beginning of stream token id.`,name:"bos_token_id"},{anchor:"transformers.CohereConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 255001) &#x2014;
End of stream token id.`,name:"eos_token_id"},{anchor:"transformers.CohereConfig.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to tie weight embeddings`,name:"tie_word_embeddings"},{anchor:"transformers.CohereConfig.rope_theta",description:`<strong>rope_theta</strong> (<code>float</code>, <em>optional</em>, defaults to 10000.0) &#x2014;
The base period of the RoPE embeddings.`,name:"rope_theta"},{anchor:"transformers.CohereConfig.attention_bias",description:`<strong>attention_bias</strong> (<code>bool</code>, defaults to <code>False</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a bias in the query, key, value and output projection layers during self-attention.`,name:"attention_bias"},{anchor:"transformers.CohereConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.CohereConfig.use_qk_norm",description:`<strong>use_qk_norm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use query-key normalization in the attention`,name:"use_qk_norm"}],source:"https://github.com/huggingface/transformers/blob/vr_31224/src/transformers/models/cohere/configuration_cohere.py#L29"}}),L=new co({props:{anchor:"transformers.CohereConfig.example",$$slots:{default:[Oo]},$$scope:{ctx:w}}}),ge=new R({props:{name:"class transformers.CohereTokenizerFast",anchor:"transformers.CohereTokenizerFast",parameters:[{name:"vocab_file",val:" = None"},{name:"merges_file",val:" = None"},{name:"tokenizer_file",val:" = None"},{name:"clean_up_tokenization_spaces",val:" = False"},{name:"unk_token",val:" = '<UNK>'"},{name:"bos_token",val:" = '<BOS_TOKEN>'"},{name:"eos_token",val:" = '<|END_OF_TURN_TOKEN|>'"},{name:"add_bos_token",val:" = True"},{name:"add_eos_token",val:" = False"},{name:"use_default_system_prompt",val:" = False"},{name:"add_prefix_space",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.CohereTokenizerFast.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Path to the vocabulary file.`,name:"vocab_file"},{anchor:"transformers.CohereTokenizerFast.merges_file",description:`<strong>merges_file</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Path to the merges file.`,name:"merges_file"},{anchor:"transformers.CohereTokenizerFast.tokenizer_file",description:`<strong>tokenizer_file</strong> (<code>str</code>, <em>optional</em>) &#x2014;
<a href="https://github.com/huggingface/tokenizers" rel="nofollow">tokenizers</a> file (generally has a .json extension) that
contains everything needed to load the tokenizer.`,name:"tokenizer_file"},{anchor:"transformers.CohereTokenizerFast.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to cleanup spaces after decoding, cleanup consists in removing potential artifacts like
extra spaces.`,name:"clean_up_tokenization_spaces"},{anchor:"transformers.CohereTokenizerFast.unk_token",description:`<strong>unk_token</strong> (<code>str</code> or <code>tokenizers.AddedToken</code>, <em>optional</em>, defaults to <code>&quot;&lt;UNK&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.CohereTokenizerFast.bos_token",description:`<strong>bos_token</strong> (<code>str</code> or <code>tokenizers.AddedToken</code>, <em>optional</em>, defaults to <code>&quot;&lt;BOS_TOKEN&gt;&quot;</code>) &#x2014;
The beginning of sequence token that was used during pretraining. Can be used a sequence classifier token.`,name:"bos_token"},{anchor:"transformers.CohereTokenizerFast.eos_token",description:`<strong>eos_token</strong> (<code>str</code> or <code>tokenizers.AddedToken</code>, <em>optional</em>, defaults to <code>&quot;&lt;|END_OF_TURN_TOKEN|&gt;&quot;</code>) &#x2014;
The end of sequence token.`,name:"eos_token"},{anchor:"transformers.CohereTokenizerFast.add_bos_token",description:`<strong>add_bos_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to add an <code>bos_token</code> at the start of sequences.`,name:"add_bos_token"},{anchor:"transformers.CohereTokenizerFast.add_eos_token",description:`<strong>add_eos_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to add an <code>eos_token</code> at the end of sequences.`,name:"add_eos_token"},{anchor:"transformers.CohereTokenizerFast.use_default_system_prompt",description:`<strong>use_default_system_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the default system prompt for Cohere tokenizer should be used.`,name:"use_default_system_prompt"},{anchor:"transformers.CohereTokenizerFast.add_prefix_space",description:`<strong>add_prefix_space</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the tokenizer should automatically add a prefix space`,name:"add_prefix_space"}],source:"https://github.com/huggingface/transformers/blob/vr_31224/src/transformers/models/cohere/tokenization_cohere_fast.py#L51"}}),X=new co({props:{anchor:"transformers.CohereTokenizerFast.example",$$slots:{default:[Yo]},$$scope:{ctx:w}}}),H=new jt({props:{$$slots:{default:[Ko]},$$scope:{ctx:w}}}),be=new R({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.CohereTokenizerFast.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:""},{name:"token_ids_1",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/vr_31224/src/transformers/models/cohere/tokenization_cohere_fast.py#L686"}}),ye=new R({props:{name:"get_special_tokens_mask",anchor:"transformers.CohereTokenizerFast.get_special_tokens_mask",parameters:[{name:"token_ids_0",val:": List"},{name:"token_ids_1",val:": Optional = None"},{name:"already_has_special_tokens",val:": bool = False"}],parametersDescription:[{anchor:"transformers.CohereTokenizerFast.get_special_tokens_mask.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of ids of the first sequence.`,name:"token_ids_0"},{anchor:"transformers.CohereTokenizerFast.get_special_tokens_mask.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
List of ids of the second sequence.`,name:"token_ids_1"},{anchor:"transformers.CohereTokenizerFast.get_special_tokens_mask.already_has_special_tokens",description:`<strong>already_has_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the token list is already formatted with special tokens for the model.`,name:"already_has_special_tokens"}],source:"https://github.com/huggingface/transformers/blob/vr_31224/src/transformers/tokenization_utils_base.py#L3871",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>1 for a special token, 0 for a sequence token.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of integers in the range [0, 1]</p>
`}}),Te=new R({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.CohereTokenizerFast.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": List"},{name:"token_ids_1",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.CohereTokenizerFast.create_token_type_ids_from_sequences.token_ids_0",description:"<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014; The first tokenized sequence.",name:"token_ids_0"},{anchor:"transformers.CohereTokenizerFast.create_token_type_ids_from_sequences.token_ids_1",description:"<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014; The second tokenized sequence.",name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/vr_31224/src/transformers/tokenization_utils_base.py#L3401",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The token type ids.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),Me=new R({props:{name:"update_post_processor",anchor:"transformers.CohereTokenizerFast.update_post_processor",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_31224/src/transformers/models/cohere/tokenization_cohere_fast.py#L188"}}),ke=new R({props:{name:"save_vocabulary",anchor:"transformers.CohereTokenizerFast.save_vocabulary",parameters:[{name:"save_directory",val:": str"},{name:"filename_prefix",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.CohereTokenizerFast.save_vocabulary.save_directory",description:`<strong>save_directory</strong> (<code>str</code>) &#x2014;
The directory in which to save the vocabulary.`,name:"save_directory"},{anchor:"transformers.CohereTokenizerFast.save_vocabulary.filename_prefix",description:`<strong>filename_prefix</strong> (<code>str</code>, <em>optional</em>) &#x2014;
An optional prefix to add to the named of the saved files.`,name:"filename_prefix"}],source:"https://github.com/huggingface/transformers/blob/vr_31224/src/transformers/tokenization_utils_base.py#L2589",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Paths to the files saved.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Tuple(str)</code></p>
`}}),Ce=new R({props:{name:"class transformers.CohereModel",anchor:"transformers.CohereModel",parameters:[{name:"config",val:": CohereConfig"}],parametersDescription:[{anchor:"transformers.CohereModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_31224/en/model_doc/cohere#transformers.CohereConfig">CohereConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/pr_31224/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.
config &#x2014; CohereConfig`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_31224/src/transformers/models/cohere/modeling_cohere.py#L801"}}),we=new R({props:{name:"forward",anchor:"transformers.CohereModel.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"cache_position",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.CohereModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_31224/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_31224/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_31224/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.CohereModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_31224/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_31224/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_31224/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.CohereModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.CohereModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/pr_31224/en/internal/generation_utils#transformers.Cache">Cache</a> instance;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.CohereModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.CohereModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.CohereModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.CohereModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.CohereModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_31224/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_31224/src/transformers/models/cohere/modeling_cohere.py#L837"}}),Q=new jt({props:{$$slots:{default:[en]},$$scope:{ctx:w}}}),$e=new R({props:{name:"class transformers.CohereForCausalLM",anchor:"transformers.CohereForCausalLM",parameters:[{name:"config",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_31224/src/transformers/models/cohere/modeling_cohere.py#L1034"}}),ze=new R({props:{name:"forward",anchor:"transformers.CohereForCausalLM.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"cache_position",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.CohereForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_31224/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_31224/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_31224/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.CohereForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_31224/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_31224/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_31224/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.CohereForCausalLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.CohereForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/pr_31224/en/internal/generation_utils#transformers.Cache">Cache</a> instance;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.CohereForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.CohereForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.CohereForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.CohereForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.CohereForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_31224/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.</p>
<p>Args &#x2014;
labels (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>):
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_31224/src/transformers/models/cohere/modeling_cohere.py#L1067",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_31224/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_31224/en/model_doc/cohere#transformers.CohereConfig"
>CohereConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_31224/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),P=new jt({props:{$$slots:{default:[tn]},$$scope:{ctx:w}}}),D=new co({props:{anchor:"transformers.CohereForCausalLM.forward.example",$$slots:{default:[on]},$$scope:{ctx:w}}}),Je=new Po({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/cohere.md"}}),{c(){n=d("meta"),T=s(),l=d("p"),y=s(),h(U.$$.fragment),k=s(),h(C.$$.fragment),Y=s(),v=d("p"),v.innerHTML=B,nt=s(),K=d("p"),K.textContent=po,st=s(),ee=d("p"),ee.innerHTML=mo,at=s(),te=d("p"),te.textContent=ho,rt=s(),oe=d("ul"),oe.innerHTML=uo,it=s(),ne=d("p"),ne.innerHTML=fo,lt=s(),h(se.$$.fragment),dt=s(),h(A.$$.fragment),ct=Ho(`
The model and tokenizer can be loaded via:

	`),h(ae.$$.fragment),pt=s(),re=d("ul"),re.innerHTML=_o,mt=s(),h(ie.$$.fragment),ht=s(),le=d("p"),le.textContent=go,ut=s(),h(de.$$.fragment),ft=s(),ce=d("p"),ce.textContent=bo,_t=s(),h(pe.$$.fragment),gt=s(),me=d("p"),me.textContent=yo,bt=s(),h(he.$$.fragment),yt=s(),h(ue.$$.fragment),Tt=s(),z=d("div"),h(fe.$$.fragment),Ft=s(),Re=d("p"),Re.innerHTML=To,Rt=s(),We=d("p"),We.innerHTML=Mo,Wt=s(),h(L.$$.fragment),Mt=s(),_e=d("p"),_e.textContent=ko,kt=s(),m=d("div"),h(ge.$$.fragment),Zt=s(),Ze=d("p"),Ze.textContent=vo,It=s(),Ie=d("p"),Ie.textContent=Co,Vt=s(),h(X.$$.fragment),Nt=s(),Ve=d("p"),Ve.innerHTML=wo,Et=s(),Ne=d("p"),Ne.innerHTML=Uo,Gt=s(),h(H.$$.fragment),Bt=s(),Ee=d("p"),Ee.innerHTML=$o,At=s(),Ge=d("div"),h(be.$$.fragment),Lt=s(),S=d("div"),h(ye.$$.fragment),Xt=s(),Be=d("p"),Be.innerHTML=zo,Ht=s(),W=d("div"),h(Te.$$.fragment),St=s(),Ae=d("p"),Ae.innerHTML=Jo,qt=s(),Le=d("p"),Le.textContent=xo,Qt=s(),q=d("div"),h(Me.$$.fragment),Pt=s(),Xe=d("p"),Xe.innerHTML=jo,Dt=s(),Z=d("div"),h(ke.$$.fragment),Ot=s(),He=d("p"),He.textContent=Fo,Yt=s(),Se=d("p"),Se.innerHTML=Ro,vt=s(),ve=d("p"),ve.textContent=Wo,Ct=s(),$=d("div"),h(Ce.$$.fragment),Kt=s(),qe=d("p"),qe.innerHTML=Zo,eo=s(),Qe=d("p"),Qe.innerHTML=Io,to=s(),Pe=d("p"),Pe.innerHTML=Vo,oo=s(),I=d("div"),h(we.$$.fragment),no=s(),De=d("p"),De.innerHTML=No,so=s(),h(Q.$$.fragment),wt=s(),Ue=d("p"),Ue.textContent=Eo,Ut=s(),N=d("div"),h($e.$$.fragment),ao=s(),j=d("div"),h(ze.$$.fragment),ro=s(),Oe=d("p"),Oe.innerHTML=Go,io=s(),h(P.$$.fragment),lo=s(),h(D.$$.fragment),$t=s(),h(Je.$$.fragment),zt=s(),et=d("p"),this.h()},l(e){const t=So("svelte-u9bgzb",document.head);n=c(t,"META",{name:!0,content:!0}),t.forEach(o),T=a(e),l=c(e,"P",{}),J(l).forEach(o),y=a(e),u(U.$$.fragment,e),k=a(e),u(C.$$.fragment,e),Y=a(e),v=c(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-qmqaw7"&&(v.innerHTML=B),nt=a(e),K=c(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-vfdo9a"&&(K.textContent=po),st=a(e),ee=c(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-1mchbk3"&&(ee.innerHTML=mo),at=a(e),te=c(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-pi58xl"&&(te.textContent=ho),rt=a(e),oe=c(e,"UL",{"data-svelte-h":!0}),p(oe)!=="svelte-6wa26d"&&(oe.innerHTML=uo),it=a(e),ne=c(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-1wss9bv"&&(ne.innerHTML=fo),lt=a(e),u(se.$$.fragment,e),dt=a(e),u(A.$$.fragment,e),ct=qo(e,`
The model and tokenizer can be loaded via:

	`),u(ae.$$.fragment,e),pt=a(e),re=c(e,"UL",{"data-svelte-h":!0}),p(re)!=="svelte-1dgndgd"&&(re.innerHTML=_o),mt=a(e),u(ie.$$.fragment,e),ht=a(e),le=c(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-y0d6kj"&&(le.textContent=go),ut=a(e),u(de.$$.fragment,e),ft=a(e),ce=c(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-1mvfpvk"&&(ce.textContent=bo),_t=a(e),u(pe.$$.fragment,e),gt=a(e),me=c(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-1r13vww"&&(me.textContent=yo),bt=a(e),u(he.$$.fragment,e),yt=a(e),u(ue.$$.fragment,e),Tt=a(e),z=c(e,"DIV",{class:!0});var F=J(z);u(fe.$$.fragment,F),Ft=a(F),Re=c(F,"P",{"data-svelte-h":!0}),p(Re)!=="svelte-188kfa3"&&(Re.innerHTML=To),Rt=a(F),We=c(F,"P",{"data-svelte-h":!0}),p(We)!=="svelte-1e5012n"&&(We.innerHTML=Mo),Wt=a(F),u(L.$$.fragment,F),F.forEach(o),Mt=a(e),_e=c(e,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-1jy0560"&&(_e.textContent=ko),kt=a(e),m=c(e,"DIV",{class:!0});var M=J(m);u(ge.$$.fragment,M),Zt=a(M),Ze=c(M,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-xb0zhn"&&(Ze.textContent=vo),It=a(M),Ie=c(M,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-8f5ey4"&&(Ie.textContent=Co),Vt=a(M),u(X.$$.fragment,M),Nt=a(M),Ve=c(M,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-cnb6q1"&&(Ve.innerHTML=wo),Et=a(M),Ne=c(M,"P",{"data-svelte-h":!0}),p(Ne)!=="svelte-1afeqmz"&&(Ne.innerHTML=Uo),Gt=a(M),u(H.$$.fragment,M),Bt=a(M),Ee=c(M,"P",{"data-svelte-h":!0}),p(Ee)!=="svelte-802gbk"&&(Ee.innerHTML=$o),At=a(M),Ge=c(M,"DIV",{class:!0});var tt=J(Ge);u(be.$$.fragment,tt),tt.forEach(o),Lt=a(M),S=c(M,"DIV",{class:!0});var xe=J(S);u(ye.$$.fragment,xe),Xt=a(xe),Be=c(xe,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-1wmjg8a"&&(Be.innerHTML=zo),xe.forEach(o),Ht=a(M),W=c(M,"DIV",{class:!0});var E=J(W);u(Te.$$.fragment,E),St=a(E),Ae=c(E,"P",{"data-svelte-h":!0}),p(Ae)!=="svelte-1rw5jlb"&&(Ae.innerHTML=Jo),qt=a(E),Le=c(E,"P",{"data-svelte-h":!0}),p(Le)!=="svelte-9vptpw"&&(Le.textContent=xo),E.forEach(o),Qt=a(M),q=c(M,"DIV",{class:!0});var je=J(q);u(Me.$$.fragment,je),Pt=a(je),Xe=c(je,"P",{"data-svelte-h":!0}),p(Xe)!=="svelte-nfci2w"&&(Xe.innerHTML=jo),je.forEach(o),Dt=a(M),Z=c(M,"DIV",{class:!0});var G=J(Z);u(ke.$$.fragment,G),Ot=a(G),He=c(G,"P",{"data-svelte-h":!0}),p(He)!=="svelte-rx0wq1"&&(He.textContent=Fo),Yt=a(G),Se=c(G,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-c9295b"&&(Se.innerHTML=Ro),G.forEach(o),M.forEach(o),vt=a(e),ve=c(e,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-80ajqc"&&(ve.textContent=Wo),Ct=a(e),$=c(e,"DIV",{class:!0});var V=J($);u(Ce.$$.fragment,V),Kt=a(V),qe=c(V,"P",{"data-svelte-h":!0}),p(qe)!=="svelte-ltu7r4"&&(qe.innerHTML=Zo),eo=a(V),Qe=c(V,"P",{"data-svelte-h":!0}),p(Qe)!=="svelte-1ydu1el"&&(Qe.innerHTML=Io),to=a(V),Pe=c(V,"P",{"data-svelte-h":!0}),p(Pe)!=="svelte-cmvrvj"&&(Pe.innerHTML=Vo),oo=a(V),I=c(V,"DIV",{class:!0});var Ye=J(I);u(we.$$.fragment,Ye),no=a(Ye),De=c(Ye,"P",{"data-svelte-h":!0}),p(De)!=="svelte-1s5d8ml"&&(De.innerHTML=No),so=a(Ye),u(Q.$$.fragment,Ye),Ye.forEach(o),V.forEach(o),wt=a(e),Ue=c(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-1yjz33k"&&(Ue.textContent=Eo),Ut=a(e),N=c(e,"DIV",{class:!0});var xt=J(N);u($e.$$.fragment,xt),ao=a(xt),j=c(xt,"DIV",{class:!0});var O=J(j);u(ze.$$.fragment,O),ro=a(O),Oe=c(O,"P",{"data-svelte-h":!0}),p(Oe)!=="svelte-19hf209"&&(Oe.innerHTML=Go),io=a(O),u(P.$$.fragment,O),lo=a(O),u(D.$$.fragment,O),O.forEach(o),xt.forEach(o),$t=a(e),u(Je.$$.fragment,e),zt=a(e),et=c(e,"P",{}),J(et).forEach(o),this.h()},h(){x(n,"name","hf:doc:metadata"),x(n,"content",sn),x(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(m,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){i(document.head,n),r(e,T,t),r(e,l,t),r(e,y,t),f(U,e,t),r(e,k,t),f(C,e,t),r(e,Y,t),r(e,v,t),r(e,nt,t),r(e,K,t),r(e,st,t),r(e,ee,t),r(e,at,t),r(e,te,t),r(e,rt,t),r(e,oe,t),r(e,it,t),r(e,ne,t),r(e,lt,t),f(se,e,t),r(e,dt,t),f(A,e,t),r(e,ct,t),f(ae,e,t),r(e,pt,t),r(e,re,t),r(e,mt,t),f(ie,e,t),r(e,ht,t),r(e,le,t),r(e,ut,t),f(de,e,t),r(e,ft,t),r(e,ce,t),r(e,_t,t),f(pe,e,t),r(e,gt,t),r(e,me,t),r(e,bt,t),f(he,e,t),r(e,yt,t),f(ue,e,t),r(e,Tt,t),r(e,z,t),f(fe,z,null),i(z,Ft),i(z,Re),i(z,Rt),i(z,We),i(z,Wt),f(L,z,null),r(e,Mt,t),r(e,_e,t),r(e,kt,t),r(e,m,t),f(ge,m,null),i(m,Zt),i(m,Ze),i(m,It),i(m,Ie),i(m,Vt),f(X,m,null),i(m,Nt),i(m,Ve),i(m,Et),i(m,Ne),i(m,Gt),f(H,m,null),i(m,Bt),i(m,Ee),i(m,At),i(m,Ge),f(be,Ge,null),i(m,Lt),i(m,S),f(ye,S,null),i(S,Xt),i(S,Be),i(m,Ht),i(m,W),f(Te,W,null),i(W,St),i(W,Ae),i(W,qt),i(W,Le),i(m,Qt),i(m,q),f(Me,q,null),i(q,Pt),i(q,Xe),i(m,Dt),i(m,Z),f(ke,Z,null),i(Z,Ot),i(Z,He),i(Z,Yt),i(Z,Se),r(e,vt,t),r(e,ve,t),r(e,Ct,t),r(e,$,t),f(Ce,$,null),i($,Kt),i($,qe),i($,eo),i($,Qe),i($,to),i($,Pe),i($,oo),i($,I),f(we,I,null),i(I,no),i(I,De),i(I,so),f(Q,I,null),r(e,wt,t),r(e,Ue,t),r(e,Ut,t),r(e,N,t),f($e,N,null),i(N,ao),i(N,j),f(ze,j,null),i(j,ro),i(j,Oe),i(j,io),f(P,j,null),i(j,lo),f(D,j,null),r(e,$t,t),f(Je,e,t),r(e,zt,t),r(e,et,t),Jt=!0},p(e,[t]){const F={};t&2&&(F.$$scope={dirty:t,ctx:e}),A.$set(F);const M={};t&2&&(M.$$scope={dirty:t,ctx:e}),L.$set(M);const tt={};t&2&&(tt.$$scope={dirty:t,ctx:e}),X.$set(tt);const xe={};t&2&&(xe.$$scope={dirty:t,ctx:e}),H.$set(xe);const E={};t&2&&(E.$$scope={dirty:t,ctx:e}),Q.$set(E);const je={};t&2&&(je.$$scope={dirty:t,ctx:e}),P.$set(je);const G={};t&2&&(G.$$scope={dirty:t,ctx:e}),D.$set(G)},i(e){Jt||(_(U.$$.fragment,e),_(C.$$.fragment,e),_(se.$$.fragment,e),_(A.$$.fragment,e),_(ae.$$.fragment,e),_(ie.$$.fragment,e),_(de.$$.fragment,e),_(pe.$$.fragment,e),_(he.$$.fragment,e),_(ue.$$.fragment,e),_(fe.$$.fragment,e),_(L.$$.fragment,e),_(ge.$$.fragment,e),_(X.$$.fragment,e),_(H.$$.fragment,e),_(be.$$.fragment,e),_(ye.$$.fragment,e),_(Te.$$.fragment,e),_(Me.$$.fragment,e),_(ke.$$.fragment,e),_(Ce.$$.fragment,e),_(we.$$.fragment,e),_(Q.$$.fragment,e),_($e.$$.fragment,e),_(ze.$$.fragment,e),_(P.$$.fragment,e),_(D.$$.fragment,e),_(Je.$$.fragment,e),Jt=!0)},o(e){g(U.$$.fragment,e),g(C.$$.fragment,e),g(se.$$.fragment,e),g(A.$$.fragment,e),g(ae.$$.fragment,e),g(ie.$$.fragment,e),g(de.$$.fragment,e),g(pe.$$.fragment,e),g(he.$$.fragment,e),g(ue.$$.fragment,e),g(fe.$$.fragment,e),g(L.$$.fragment,e),g(ge.$$.fragment,e),g(X.$$.fragment,e),g(H.$$.fragment,e),g(be.$$.fragment,e),g(ye.$$.fragment,e),g(Te.$$.fragment,e),g(Me.$$.fragment,e),g(ke.$$.fragment,e),g(Ce.$$.fragment,e),g(we.$$.fragment,e),g(Q.$$.fragment,e),g($e.$$.fragment,e),g(ze.$$.fragment,e),g(P.$$.fragment,e),g(D.$$.fragment,e),g(Je.$$.fragment,e),Jt=!1},d(e){e&&(o(T),o(l),o(y),o(k),o(Y),o(v),o(nt),o(K),o(st),o(ee),o(at),o(te),o(rt),o(oe),o(it),o(ne),o(lt),o(dt),o(ct),o(pt),o(re),o(mt),o(ht),o(le),o(ut),o(ft),o(ce),o(_t),o(gt),o(me),o(bt),o(yt),o(Tt),o(z),o(Mt),o(_e),o(kt),o(m),o(vt),o(ve),o(Ct),o($),o(wt),o(Ue),o(Ut),o(N),o($t),o(zt),o(et)),o(n),b(U,e),b(C,e),b(se,e),b(A,e),b(ae,e),b(ie,e),b(de,e),b(pe,e),b(he,e),b(ue,e),b(fe),b(L),b(ge),b(X),b(H),b(be),b(ye),b(Te),b(Me),b(ke),b(Ce),b(we),b(Q),b($e),b(ze),b(P),b(D),b(Je,e)}}}const sn='{"title":"Cohere","local":"cohere","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"CohereConfig","local":"transformers.CohereConfig","sections":[],"depth":2}],"depth":1}';function an(w){return Ao(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class fn extends Lo{constructor(n){super(),Xo(this,n,an,nn,Bo,{})}}export{fn as component};
