import{s as ha,n as ua,o as ga}from"../chunks/scheduler.25b97de1.js";import{S as da,i as ya,g as i,s as n,r as o,A as ja,h as p,f as e,c as l,j as _s,u as c,x as r,k as ma,y as f,a,v as m,d as h,t as u,w as g}from"../chunks/index.d9030fc9.js";import{C as y}from"../chunks/CodeBlock.e6cd0d95.js";import{H as d,E as Ma}from"../chunks/EditOnGithub.91d95064.js";function fa(Je){let j,Fs,Es,Ls,b,As,J,xe="🤗 Transformers is a library of pretrained state-of-the-art models for natural language processing (NLP), computer vision, and audio and speech processing tasks. Not only does the library contain Transformer models, but it also has non-Transformer models like modern convolutional networks for computer vision tasks. If you look at some of the most popular consumer products today, like smartphones, apps, and televisions, odds are that some kind of deep learning technology is behind it. Want to remove a background object from a picture taken by your smartphone? This is an example of a panoptic segmentation task (don’t worry if you don’t know what this means yet, we’ll describe it in the following sections!).",Ps,x,we="This page provides an overview of the different speech and audio, computer vision, and NLP tasks that can be solved with the 🤗 Transformers library in just three lines of code!",Ds,w,Ks,T,Te="Audio and speech processing tasks are a little different from the other modalities mainly because audio as an input is a continuous signal. Unlike text, a raw audio waveform can’t be neatly split into discrete chunks the way a sentence can be divided into words. To get around this, the raw audio signal is typically sampled at regular intervals. If you take more samples within an interval, the sampling rate is higher, and the audio more closely resembles the original audio source.",Os,U,Ue="Previous approaches preprocessed the audio to extract useful features from it. It is now more common to start audio and speech processing tasks by directly feeding the raw audio waveform to a feature encoder to extract an audio representation. This simplifies the preprocessing step and allows the model to learn the most essential features.",st,k,tt,C,ke="Audio classification is a task that labels audio data from a predefined set of classes. It is a broad category with many specific applications, some of which include:",et,I,Ce="<li>acoustic scene classification: label audio with a scene label (“office”, “beach”, “stadium”)</li> <li>acoustic event detection: label audio with a sound event label (“car horn”, “whale calling”, “glass breaking”)</li> <li>tagging: label audio containing multiple sounds (birdsongs, speaker identification in a meeting)</li> <li>music classification: label music with a genre label (“metal”, “hip-hop”, “country”)</li>",at,Z,nt,v,lt,$,Ie="Automatic speech recognition (ASR) transcribes speech into text. It is one of the most common audio tasks due partly to speech being such a natural form of human communication. Today, ASR systems are embedded in “smart” technology products like speakers, phones, and cars. We can ask our virtual assistants to play music, set reminders, and tell us the weather.",it,B,Ze="But one of the key challenges Transformer architectures have helped with is in low-resource languages. By pretraining on large amounts of speech data, finetuning the model on only one hour of labeled speech data in a low-resource language can still produce high-quality results compared to previous ASR systems trained on 100x more labeled data.",pt,W,rt,q,ot,G,ve='One of the first and earliest successful computer vision tasks was recognizing images of zip code numbers using a <a href="glossary#convolution">convolutional neural network (CNN)</a>. An image is composed of pixels, and each pixel has a numerical value. This makes it easy to represent an image as a matrix of pixel values. Each particular combination of pixel values describes the colors of an image.',ct,H,$e="Two general ways computer vision tasks can be solved are:",mt,V,Be="<li>Use convolutions to learn the hierarchical features of an image from low-level features to high-level abstract things.</li> <li>Split an image into patches and use a Transformer to gradually learn how each image patch is related to each other to form an image. Unlike the bottom-up approach favored by a CNN, this is kind of like starting out with a blurry image and then gradually bringing it into focus.</li>",ht,N,ut,R,We="Image classification labels an entire image from a predefined set of classes. Like most classification tasks, there are many practical use cases for image classification, some of which include:",gt,z,qe="<li>healthcare: label medical images to detect disease or monitor patient health</li> <li>environment: label satellite images to monitor deforestation, inform wildland management or detect wildfires</li> <li>agriculture: label images of crops to monitor plant health or satellite images for land use monitoring</li> <li>ecology: label images of animal or plant species to monitor wildlife populations or track endangered species</li>",dt,Q,yt,Y,jt,X,Ge="Unlike image classification, object detection identifies multiple objects within an image and the objects’ positions in an image (defined by the bounding box). Some example applications of object detection include:",Mt,E,He="<li>self-driving vehicles: detect everyday traffic objects such as other vehicles, pedestrians, and traffic lights</li> <li>remote sensing: disaster monitoring, urban planning, and weather forecasting</li> <li>defect detection: detect cracks or structural damage in buildings, and manufacturing defects</li>",ft,S,bt,_,Jt,F,Ve="Image segmentation is a pixel-level task that assigns every pixel in an image to a class. It differs from object detection, which uses bounding boxes to label and predict objects in an image because segmentation is more granular. Segmentation can detect objects at a pixel-level. There are several types of image segmentation:",xt,L,Ne="<li>instance segmentation: in addition to labeling the class of an object, it also labels each distinct instance of an object (“dog-1”, “dog-2”)</li> <li>panoptic segmentation: a combination of semantic and instance segmentation; it labels each pixel with a semantic class <strong>and</strong> each distinct instance of an object</li>",wt,A,Re="Segmentation tasks are helpful in self-driving vehicles to create a pixel-level map of the world around them so they can navigate safely around pedestrians and other vehicles. It is also useful for medical imaging, where the task’s finer granularity can help identify abnormal cells or organ features. Image segmentation can also be used in ecommerce to virtually try on clothes or create augmented reality experiences by overlaying objects in the real world through your camera.",Tt,P,Ut,D,kt,K,ze="Depth estimation predicts the distance of each pixel in an image from the camera. This computer vision task is especially important for scene understanding and reconstruction. For example, in self-driving cars, vehicles need to understand how far objects like pedestrians, traffic signs, and other vehicles are to avoid obstacles and collisions. Depth information is also helpful for constructing 3D representations from 2D images and can be used to create high-quality 3D representations of biological structures or buildings.",Ct,O,Qe="There are two approaches to depth estimation:",It,ss,Ye="<li>stereo: depths are estimated by comparing two images of the same image from slightly different angles</li> <li>monocular: depths are estimated from a single image</li>",Zt,ts,vt,es,$t,as,Xe="NLP tasks are among the most common types of tasks because text is such a natural way for us to communicate. To get text into a format recognized by a model, it needs to be tokenized. This means dividing a sequence of text into separate words or subwords (tokens) and then converting these tokens into numbers. As a result, you can represent a sequence of text as a sequence of numbers, and once you have a sequence of numbers, it can be input into a model to solve all sorts of NLP tasks!",Bt,ns,Wt,ls,Ee="Like classification tasks in any modality, text classification labels a sequence of text (it can be sentence-level, a paragraph, or a document) from a predefined set of classes. There are many practical applications for text classification, some of which include:",qt,is,Se="<li>sentiment analysis: label text according to some polarity like <code>positive</code> or <code>negative</code> which can inform and support decision-making in fields like politics, finance, and marketing</li> <li>content classification: label text according to some topic to help organize and filter information in news and social media feeds (<code>weather</code>, <code>sports</code>, <code>finance</code>, etc.)</li>",Gt,ps,Ht,rs,Vt,os,_e='In any NLP task, text is preprocessed by separating the sequence of text into individual words or subwords. These are known as <a href="glossary#token">tokens</a>. Token classification assigns each token a label from a predefined set of classes.',Nt,cs,Fe="Two common types of token classification are:",Rt,ms,Le="<li>named entity recognition (NER): label a token according to an entity category like organization, person, location or date. NER is especially popular in biomedical settings, where it can label genes, proteins, and drug names.</li> <li>part-of-speech tagging (POS): label a token according to its part-of-speech like noun, verb, or adjective. POS is useful for helping translation systems understand how two identical words are grammatically different (bank as a noun versus bank as a verb).</li>",zt,hs,Qt,us,Yt,gs,Ae="Question answering is another token-level task that returns an answer to a question, sometimes with context (open-domain) and other times without context (closed-domain). This task happens whenever we ask a virtual assistant something like whether a restaurant is open. It can also provide customer or technical support and help search engines retrieve the relevant information you’re asking for.",Xt,ds,Pe="There are two common types of question answering:",Et,ys,De='<li>extractive: given a question and some context, the answer is a span of text from the context the model must extract</li> <li>abstractive: given a question and some context, the answer is generated from the context; this approach is handled by the <a href="/docs/transformers/pr_31224/en/main_classes/pipelines#transformers.Text2TextGenerationPipeline">Text2TextGenerationPipeline</a> instead of the <a href="/docs/transformers/pr_31224/en/main_classes/pipelines#transformers.QuestionAnsweringPipeline">QuestionAnsweringPipeline</a> shown below</li>',St,js,_t,Ms,Ft,fs,Ke="Summarization creates a shorter version of a text from a longer one while trying to preserve most of the meaning of the original document. Summarization is a sequence-to-sequence task; it outputs a shorter text sequence than the input. There are a lot of long-form documents that can be summarized to help readers quickly understand the main points. Legislative bills, legal and financial documents, patents, and scientific papers are a few examples of documents that could be summarized to save readers time and serve as a reading aid.",Lt,bs,Oe="Like question answering, there are two types of summarization:",At,Js,sa='<li>extractive: identify and extract the most important sentences from the original text</li> <li>abstractive: generate the target summary (which may include new words not in the input document) from the original text; the <a href="/docs/transformers/pr_31224/en/main_classes/pipelines#transformers.SummarizationPipeline">SummarizationPipeline</a> uses the abstractive approach</li>',Pt,xs,Dt,ws,Kt,Ts,ta="Translation converts a sequence of text in one language to another. It is important in helping people from different backgrounds communicate with each other, help translate content to reach wider audiences, and even be a learning tool to help people learn a new language. Along with summarization, translation is a sequence-to-sequence task, meaning the model receives an input sequence and returns a target output sequence.",Ot,Us,ea="In the early days, translation models were mostly monolingual, but recently, there has been increasing interest in multilingual models that can translate between many pairs of languages.",se,ks,te,Cs,ee,Is,aa="Language modeling is a task that predicts a word in a sequence of text. It has become a very popular NLP task because a pretrained language model can be finetuned for many other downstream tasks. Lately, there has been a lot of interest in large language models (LLMs) which demonstrate zero- or few-shot learning. This means the model can solve tasks it wasn’t explicitly trained to do! Language models can be used to generate fluent and convincing text, though you need to be careful since the text may not always be accurate.",ae,Zs,na="There are two types of language modeling:",ne,M,vs,Ys,la="causal: the model’s objective is to predict the next token in a sequence, and future tokens are masked",Me,$s,fe,Bs,Xs,ia="masked: the model’s objective is to predict a masked token in a sequence with full access to the tokens in the sequence",be,Ws,le,qs,ie,Gs,pa="Multimodal tasks require a model to process multiple data modalities (text, image, audio, video) to solve a particular problem. Image captioning is an example of a multimodal task where the model takes an image as input and outputs a sequence of text describing the image or some properties of the image.",pe,Hs,ra="Although multimodal models work with different data types or modalities, internally, the preprocessing steps help the model convert all the data types into embeddings (vectors or list of numbers that holds meaningful information about the data). For a task like image captioning, the model learns relationships between image embeddings and text embeddings.",re,Vs,oe,Ns,oa="Document question answering is a task that answers natural language questions from a document. Unlike a token-level question answering task which takes text as input, document question answering takes an image of a document as input along with a question about the document and returns an answer. Document question answering can be used to parse structured documents and extract key information from it. In the example below, the total amount and change due can be extracted from a receipt.",ce,Rs,me,zs,ca='Hopefully, this page has given you some more background information about all the types of tasks in each modality and the practical importance of each one. In the next <a href="tasks_explained">section</a>, you’ll learn <strong>how</strong> 🤗 Transformers work to solve these tasks.',he,Qs,ue,Ss,ge;return b=new d({props:{title:"What 🤗 Transformers can do",local:"what--transformers-can-do",headingTag:"h1"}}),w=new d({props:{title:"Audio",local:"audio",headingTag:"h2"}}),k=new d({props:{title:"Audio classification",local:"audio-classification",headingTag:"h3"}}),Z=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJhdWRpby1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyc3VwZXJiJTJGaHViZXJ0LWJhc2Utc3VwZXJiLWVyJTIyKSUwQXByZWRzJTIwJTNEJTIwY2xhc3NpZmllciglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZOYXJzaWwlMkZhc3JfZHVtbXklMkZyZXNvbHZlJTJGbWFpbiUyRm1say5mbGFjJTIyKSUwQXByZWRzJTIwJTNEJTIwJTVCJTdCJTIyc2NvcmUlMjIlM0ElMjByb3VuZChwcmVkJTVCJTIyc2NvcmUlMjIlNUQlMkMlMjA0KSUyQyUyMCUyMmxhYmVsJTIyJTNBJTIwcHJlZCU1QiUyMmxhYmVsJTIyJTVEJTdEJTIwZm9yJTIwcHJlZCUyMGluJTIwcHJlZHMlNUQlMEFwcmVkcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>classifier = pipeline(task=<span class="hljs-string">&quot;audio-classification&quot;</span>, model=<span class="hljs-string">&quot;superb/hubert-base-superb-er&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = classifier(<span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.4532</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;hap&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.3622</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;sad&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0943</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;neu&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0903</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;ang&#x27;</span>}]`,wrap:!1}}),v=new d({props:{title:"Automatic speech recognition",local:"automatic-speech-recognition",headingTag:"h3"}}),W=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyb3BlbmFpJTJGd2hpc3Blci1zbWFsbCUyMiklMEF0cmFuc2NyaWJlciglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZOYXJzaWwlMkZhc3JfZHVtbXklMkZyZXNvbHZlJTJGbWFpbiUyRm1say5mbGFjJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber = pipeline(task=<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber(<span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&quot;</span>)
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27; I have a dream that one day this nation will rise up and live out the true meaning of its creed.&#x27;</span>}`,wrap:!1}}),q=new d({props:{title:"Computer vision",local:"computer-vision",headingTag:"h2"}}),N=new d({props:{title:"Image classification",local:"image-classification",headingTag:"h3"}}),Q=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJpbWFnZS1jbGFzc2lmaWNhdGlvbiUyMiklMEFwcmVkcyUyMCUzRCUyMGNsYXNzaWZpZXIoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGcGlwZWxpbmUtY2F0LWNob25rLmpwZWclMjIlMEEpJTBBcHJlZHMlMjAlM0QlMjAlNUIlN0IlMjJzY29yZSUyMiUzQSUyMHJvdW5kKHByZWQlNUIlMjJzY29yZSUyMiU1RCUyQyUyMDQpJTJDJTIwJTIybGFiZWwlMjIlM0ElMjBwcmVkJTVCJTIybGFiZWwlMjIlNUQlN0QlMjBmb3IlMjBwcmVkJTIwaW4lMjBwcmVkcyU1RCUwQXByaW50KCpwcmVkcyUyQyUyMHNlcCUzRCUyMiU1Q24lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>classifier = pipeline(task=<span class="hljs-string">&quot;image-classification&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = classifier(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(*preds, sep=<span class="hljs-string">&quot;\\n&quot;</span>)
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.4335</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;lynx, catamount&#x27;</span>}
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0348</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;cougar, puma, catamount, mountain lion, painter, panther, Felis concolor&#x27;</span>}
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0324</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;snow leopard, ounce, Panthera uncia&#x27;</span>}
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0239</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;Egyptian cat&#x27;</span>}
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0229</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;tiger cat&#x27;</span>}`,wrap:!1}}),Y=new d({props:{title:"Object detection",local:"object-detection",headingTag:"h3"}}),S=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZGV0ZWN0b3IlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIyb2JqZWN0LWRldGVjdGlvbiUyMiklMEFwcmVkcyUyMCUzRCUyMGRldGVjdG9yKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnBpcGVsaW5lLWNhdC1jaG9uay5qcGVnJTIyJTBBKSUwQXByZWRzJTIwJTNEJTIwJTVCJTdCJTIyc2NvcmUlMjIlM0ElMjByb3VuZChwcmVkJTVCJTIyc2NvcmUlMjIlNUQlMkMlMjA0KSUyQyUyMCUyMmxhYmVsJTIyJTNBJTIwcHJlZCU1QiUyMmxhYmVsJTIyJTVEJTJDJTIwJTIyYm94JTIyJTNBJTIwcHJlZCU1QiUyMmJveCUyMiU1RCU3RCUyMGZvciUyMHByZWQlMjBpbiUyMHByZWRzJTVEJTBBcHJlZHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>detector = pipeline(task=<span class="hljs-string">&quot;object-detection&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = detector(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>], <span class="hljs-string">&quot;box&quot;</span>: pred[<span class="hljs-string">&quot;box&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9865</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;cat&#x27;</span>,
  <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">178</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">154</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">882</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">598</span>}}]`,wrap:!1}}),_=new d({props:{title:"Image segmentation",local:"image-segmentation",headingTag:"h3"}}),P=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBc2VnbWVudGVyJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMmltYWdlLXNlZ21lbnRhdGlvbiUyMiklMEFwcmVkcyUyMCUzRCUyMHNlZ21lbnRlciglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZwaXBlbGluZS1jYXQtY2hvbmsuanBlZyUyMiUwQSklMEFwcmVkcyUyMCUzRCUyMCU1QiU3QiUyMnNjb3JlJTIyJTNBJTIwcm91bmQocHJlZCU1QiUyMnNjb3JlJTIyJTVEJTJDJTIwNCklMkMlMjAlMjJsYWJlbCUyMiUzQSUyMHByZWQlNUIlMjJsYWJlbCUyMiU1RCU3RCUyMGZvciUyMHByZWQlMjBpbiUyMHByZWRzJTVEJTBBcHJpbnQoKnByZWRzJTJDJTIwc2VwJTNEJTIyJTVDbiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>segmenter = pipeline(task=<span class="hljs-string">&quot;image-segmentation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = segmenter(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(*preds, sep=<span class="hljs-string">&quot;\\n&quot;</span>)
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9879</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;LABEL_184&#x27;</span>}
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9973</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;snow&#x27;</span>}
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9972</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;cat&#x27;</span>}`,wrap:!1}}),D=new d({props:{title:"Depth estimation",local:"depth-estimation",headingTag:"h3"}}),ts=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZGVwdGhfZXN0aW1hdG9yJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMmRlcHRoLWVzdGltYXRpb24lMjIpJTBBcHJlZHMlMjAlM0QlMjBkZXB0aF9lc3RpbWF0b3IoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGcGlwZWxpbmUtY2F0LWNob25rLmpwZWclMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>depth_estimator = pipeline(task=<span class="hljs-string">&quot;depth-estimation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = depth_estimator(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),es=new d({props:{title:"Natural language processing",local:"natural-language-processing",headingTag:"h2"}}),ns=new d({props:{title:"Text classification",local:"text-classification",headingTag:"h3"}}),ps=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJzZW50aW1lbnQtYW5hbHlzaXMlMjIpJTBBcHJlZHMlMjAlM0QlMjBjbGFzc2lmaWVyKCUyMkh1Z2dpbmclMjBGYWNlJTIwaXMlMjB0aGUlMjBiZXN0JTIwdGhpbmclMjBzaW5jZSUyMHNsaWNlZCUyMGJyZWFkISUyMiklMEFwcmVkcyUyMCUzRCUyMCU1QiU3QiUyMnNjb3JlJTIyJTNBJTIwcm91bmQocHJlZCU1QiUyMnNjb3JlJTIyJTVEJTJDJTIwNCklMkMlMjAlMjJsYWJlbCUyMiUzQSUyMHByZWQlNUIlMjJsYWJlbCUyMiU1RCU3RCUyMGZvciUyMHByZWQlMjBpbiUyMHByZWRzJTVEJTBBcHJlZHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>classifier = pipeline(task=<span class="hljs-string">&quot;sentiment-analysis&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = classifier(<span class="hljs-string">&quot;Hugging Face is the best thing since sliced bread!&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9991</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;POSITIVE&#x27;</span>}]`,wrap:!1}}),rs=new d({props:{title:"Token classification",local:"token-classification",headingTag:"h3"}}),hs=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJuZXIlMjIpJTBBcHJlZHMlMjAlM0QlMjBjbGFzc2lmaWVyKCUyMkh1Z2dpbmclMjBGYWNlJTIwaXMlMjBhJTIwRnJlbmNoJTIwY29tcGFueSUyMGJhc2VkJTIwaW4lMjBOZXclMjBZb3JrJTIwQ2l0eS4lMjIpJTBBcHJlZHMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbnRpdHklMjIlM0ElMjBwcmVkJTVCJTIyZW50aXR5JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2NvcmUlMjIlM0ElMjByb3VuZChwcmVkJTVCJTIyc2NvcmUlMjIlNUQlMkMlMjA0KSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmluZGV4JTIyJTNBJTIwcHJlZCU1QiUyMmluZGV4JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyd29yZCUyMiUzQSUyMHByZWQlNUIlMjJ3b3JkJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3RhcnQlMjIlM0ElMjBwcmVkJTVCJTIyc3RhcnQlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbmQlMjIlM0ElMjBwcmVkJTVCJTIyZW5kJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwZm9yJTIwcHJlZCUyMGluJTIwcHJlZHMlMEElNUQlMEFwcmludCgqcHJlZHMlMkMlMjBzZXAlM0QlMjIlNUNuJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>classifier = pipeline(task=<span class="hljs-string">&quot;ner&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = classifier(<span class="hljs-string">&quot;Hugging Face is a French company based in New York City.&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;entity&quot;</span>: pred[<span class="hljs-string">&quot;entity&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>),
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;index&quot;</span>: pred[<span class="hljs-string">&quot;index&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;word&quot;</span>: pred[<span class="hljs-string">&quot;word&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;start&quot;</span>: pred[<span class="hljs-string">&quot;start&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;end&quot;</span>: pred[<span class="hljs-string">&quot;end&quot;</span>],
<span class="hljs-meta">... </span>    }
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(*preds, sep=<span class="hljs-string">&quot;\\n&quot;</span>)
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-ORG&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9968</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;Hu&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">2</span>}
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-ORG&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9293</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;##gging&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">7</span>}
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-ORG&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9763</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;Face&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">8</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">12</span>}
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-MISC&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9983</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">6</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;French&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">18</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">24</span>}
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-LOC&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.999</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">10</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;New&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">42</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">45</span>}
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-LOC&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9987</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">11</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;York&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">46</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">50</span>}
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-LOC&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9992</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">12</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;City&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">51</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">55</span>}`,wrap:!1}}),us=new d({props:{title:"Question answering",local:"question-answering",headingTag:"h3"}}),js=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcXVlc3Rpb25fYW5zd2VyZXIlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIycXVlc3Rpb24tYW5zd2VyaW5nJTIyKSUwQXByZWRzJTIwJTNEJTIwcXVlc3Rpb25fYW5zd2VyZXIoJTBBJTIwJTIwJTIwJTIwcXVlc3Rpb24lM0QlMjJXaGF0JTIwaXMlMjB0aGUlMjBuYW1lJTIwb2YlMjB0aGUlMjByZXBvc2l0b3J5JTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwY29udGV4dCUzRCUyMlRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMHJlcG9zaXRvcnklMjBpcyUyMGh1Z2dpbmdmYWNlJTJGdHJhbnNmb3JtZXJzJTIyJTJDJTBBKSUwQXByaW50KCUwQSUyMCUyMCUyMCUyMGYlMjJzY29yZSUzQSUyMCU3QnJvdW5kKHByZWRzJTVCJ3Njb3JlJyU1RCUyQyUyMDQpJTdEJTJDJTIwc3RhcnQlM0ElMjAlN0JwcmVkcyU1QidzdGFydCclNUQlN0QlMkMlMjBlbmQlM0ElMjAlN0JwcmVkcyU1QidlbmQnJTVEJTdEJTJDJTIwYW5zd2VyJTNBJTIwJTdCcHJlZHMlNUInYW5zd2VyJyU1RCU3RCUyMiUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>question_answerer = pipeline(task=<span class="hljs-string">&quot;question-answering&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = question_answerer(
<span class="hljs-meta">... </span>    question=<span class="hljs-string">&quot;What is the name of the repository?&quot;</span>,
<span class="hljs-meta">... </span>    context=<span class="hljs-string">&quot;The name of the repository is huggingface/transformers&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>    <span class="hljs-string">f&quot;score: <span class="hljs-subst">{<span class="hljs-built_in">round</span>(preds[<span class="hljs-string">&#x27;score&#x27;</span>], <span class="hljs-number">4</span>)}</span>, start: <span class="hljs-subst">{preds[<span class="hljs-string">&#x27;start&#x27;</span>]}</span>, end: <span class="hljs-subst">{preds[<span class="hljs-string">&#x27;end&#x27;</span>]}</span>, answer: <span class="hljs-subst">{preds[<span class="hljs-string">&#x27;answer&#x27;</span>]}</span>&quot;</span>
<span class="hljs-meta">... </span>)
score: <span class="hljs-number">0.9327</span>, start: <span class="hljs-number">30</span>, end: <span class="hljs-number">54</span>, answer: huggingface/transformers`,wrap:!1}}),Ms=new d({props:{title:"Summarization",local:"summarization",headingTag:"h3"}}),xs=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBc3VtbWFyaXplciUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJzdW1tYXJpemF0aW9uJTIyKSUwQXN1bW1hcml6ZXIoJTBBJTIwJTIwJTIwJTIwJTIySW4lMjB0aGlzJTIwd29yayUyQyUyMHdlJTIwcHJlc2VudGVkJTIwdGhlJTIwVHJhbnNmb3JtZXIlMkMlMjB0aGUlMjBmaXJzdCUyMHNlcXVlbmNlJTIwdHJhbnNkdWN0aW9uJTIwbW9kZWwlMjBiYXNlZCUyMGVudGlyZWx5JTIwb24lMjBhdHRlbnRpb24lMkMlMjByZXBsYWNpbmclMjB0aGUlMjByZWN1cnJlbnQlMjBsYXllcnMlMjBtb3N0JTIwY29tbW9ubHklMjB1c2VkJTIwaW4lMjBlbmNvZGVyLWRlY29kZXIlMjBhcmNoaXRlY3R1cmVzJTIwd2l0aCUyMG11bHRpLWhlYWRlZCUyMHNlbGYtYXR0ZW50aW9uLiUyMEZvciUyMHRyYW5zbGF0aW9uJTIwdGFza3MlMkMlMjB0aGUlMjBUcmFuc2Zvcm1lciUyMGNhbiUyMGJlJTIwdHJhaW5lZCUyMHNpZ25pZmljYW50bHklMjBmYXN0ZXIlMjB0aGFuJTIwYXJjaGl0ZWN0dXJlcyUyMGJhc2VkJTIwb24lMjByZWN1cnJlbnQlMjBvciUyMGNvbnZvbHV0aW9uYWwlMjBsYXllcnMuJTIwT24lMjBib3RoJTIwV01UJTIwMjAxNCUyMEVuZ2xpc2gtdG8tR2VybWFuJTIwYW5kJTIwV01UJTIwMjAxNCUyMEVuZ2xpc2gtdG8tRnJlbmNoJTIwdHJhbnNsYXRpb24lMjB0YXNrcyUyQyUyMHdlJTIwYWNoaWV2ZSUyMGElMjBuZXclMjBzdGF0ZSUyMG9mJTIwdGhlJTIwYXJ0LiUyMEluJTIwdGhlJTIwZm9ybWVyJTIwdGFzayUyMG91ciUyMGJlc3QlMjBtb2RlbCUyMG91dHBlcmZvcm1zJTIwZXZlbiUyMGFsbCUyMHByZXZpb3VzbHklMjByZXBvcnRlZCUyMGVuc2VtYmxlcy4lMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>summarizer = pipeline(task=<span class="hljs-string">&quot;summarization&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>summarizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;In this work, we presented the Transformer, the first sequence transduction model based entirely on attention, replacing the recurrent layers most commonly used in encoder-decoder architectures with multi-headed self-attention. For translation tasks, the Transformer can be trained significantly faster than architectures based on recurrent or convolutional layers. On both WMT 2014 English-to-German and WMT 2014 English-to-French translation tasks, we achieve a new state of the art. In the former task our best model outperforms even all previously reported ensembles.&quot;</span>
<span class="hljs-meta">... </span>)
[{<span class="hljs-string">&#x27;summary_text&#x27;</span>: <span class="hljs-string">&#x27; The Transformer is the first sequence transduction model based entirely on attention . It replaces the recurrent layers most commonly used in encoder-decoder architectures with multi-headed self-attention . For translation tasks, the Transformer can be trained significantly faster than architectures based on recurrent or convolutional layers .&#x27;</span>}]`,wrap:!1}}),ws=new d({props:{title:"Translation",local:"translation",headingTag:"h3"}}),ks=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdGV4dCUyMCUzRCUyMCUyMnRyYW5zbGF0ZSUyMEVuZ2xpc2glMjB0byUyMEZyZW5jaCUzQSUyMEh1Z2dpbmclMjBGYWNlJTIwaXMlMjBhJTIwY29tbXVuaXR5LWJhc2VkJTIwb3Blbi1zb3VyY2UlMjBwbGF0Zm9ybSUyMGZvciUyMG1hY2hpbmUlMjBsZWFybmluZy4lMjIlMEF0cmFuc2xhdG9yJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMnRyYW5zbGF0aW9uJTIyJTJDJTIwbW9kZWwlM0QlMjJnb29nbGUtdDUlMkZ0NS1zbWFsbCUyMiklMEF0cmFuc2xhdG9yKHRleHQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;translate English to French: Hugging Face is a community-based open-source platform for machine learning.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>translator = pipeline(task=<span class="hljs-string">&quot;translation&quot;</span>, model=<span class="hljs-string">&quot;google-t5/t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>translator(text)
[{<span class="hljs-string">&#x27;translation_text&#x27;</span>: <span class="hljs-string">&quot;Hugging Face est une tribune communautaire de l&#x27;apprentissage des machines.&quot;</span>}]`,wrap:!1}}),Cs=new d({props:{title:"Language modeling",local:"language-modeling",headingTag:"h3"}}),$s=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIySHVnZ2luZyUyMEZhY2UlMjBpcyUyMGElMjBjb21tdW5pdHktYmFzZWQlMjBvcGVuLXNvdXJjZSUyMHBsYXRmb3JtJTIwZm9yJTIwbWFjaGluZSUyMGxlYXJuaW5nLiUyMiUwQWdlbmVyYXRvciUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJ0ZXh0LWdlbmVyYXRpb24lMjIpJTBBZ2VuZXJhdG9yKHByb21wdCklMjAlMjAlMjMlMjBkb2N0ZXN0JTNBJTIwJTJCU0tJUA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Hugging Face is a community-based open-source platform for machine learning.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generator = pipeline(task=<span class="hljs-string">&quot;text-generation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generator(prompt)  <span class="hljs-comment"># doctest: +SKIP</span>`,wrap:!1}}),Ws=new y({props:{code:"dGV4dCUyMCUzRCUyMCUyMkh1Z2dpbmclMjBGYWNlJTIwaXMlMjBhJTIwY29tbXVuaXR5LWJhc2VkJTIwb3Blbi1zb3VyY2UlMjAlM0NtYXNrJTNFJTIwZm9yJTIwbWFjaGluZSUyMGxlYXJuaW5nLiUyMiUwQWZpbGxfbWFzayUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJmaWxsLW1hc2slMjIpJTBBcHJlZHMlMjAlM0QlMjBmaWxsX21hc2sodGV4dCUyQyUyMHRvcF9rJTNEMSklMEFwcmVkcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnNjb3JlJTIyJTNBJTIwcm91bmQocHJlZCU1QiUyMnNjb3JlJTIyJTVEJTJDJTIwNCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0b2tlbiUyMiUzQSUyMHByZWQlNUIlMjJ0b2tlbiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRva2VuX3N0ciUyMiUzQSUyMHByZWQlNUIlMjJ0b2tlbl9zdHIlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzZXF1ZW5jZSUyMiUzQSUyMHByZWQlNUIlMjJzZXF1ZW5jZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMGZvciUyMHByZWQlMjBpbiUyMHByZWRzJTBBJTVEJTBBcHJlZHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;Hugging Face is a community-based open-source &lt;mask&gt; for machine learning.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fill_mask = pipeline(task=<span class="hljs-string">&quot;fill-mask&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = fill_mask(text, top_k=<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>),
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;token&quot;</span>: pred[<span class="hljs-string">&quot;token&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;token_str&quot;</span>: pred[<span class="hljs-string">&quot;token_str&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;sequence&quot;</span>: pred[<span class="hljs-string">&quot;sequence&quot;</span>],
<span class="hljs-meta">... </span>    }
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.2236</span>,
  <span class="hljs-string">&#x27;token&#x27;</span>: <span class="hljs-number">1761</span>,
  <span class="hljs-string">&#x27;token_str&#x27;</span>: <span class="hljs-string">&#x27; platform&#x27;</span>,
  <span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;Hugging Face is a community-based open-source platform for machine learning.&#x27;</span>}]`,wrap:!1}}),qs=new d({props:{title:"Multimodal",local:"multimodal",headingTag:"h2"}}),Vs=new d({props:{title:"Document question answering",local:"document-question-answering",headingTag:"h3"}}),Rs=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZXhhbXBsZS1kb2N1bWVudHMlMkZyZXNvbHZlJTJGbWFpbiUyRmpwZWdfaW1hZ2VzJTJGMi5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFkb2NfcXVlc3Rpb25fYW5zd2VyZXIlMjAlM0QlMjBwaXBlbGluZSglMjJkb2N1bWVudC1xdWVzdGlvbi1hbnN3ZXJpbmclMjIlMkMlMjBtb2RlbCUzRCUyMm1hZ29yc2h1bm92JTJGbGF5b3V0bG0taW52b2ljZXMlMjIpJTBBcHJlZHMlMjAlM0QlMjBkb2NfcXVlc3Rpb25fYW5zd2VyZXIoJTBBJTIwJTIwJTIwJTIwcXVlc3Rpb24lM0QlMjJXaGF0JTIwaXMlMjB0aGUlMjB0b3RhbCUyMGFtb3VudCUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMGltYWdlJTNEaW1hZ2UlMkMlMEEpJTBBcHJlZHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/example-documents/resolve/main/jpeg_images/2.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>doc_question_answerer = pipeline(<span class="hljs-string">&quot;document-question-answering&quot;</span>, model=<span class="hljs-string">&quot;magorshunov/layoutlm-invoices&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = doc_question_answerer(
<span class="hljs-meta">... </span>    question=<span class="hljs-string">&quot;What is the total amount?&quot;</span>,
<span class="hljs-meta">... </span>    image=image,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.8531</span>, <span class="hljs-string">&#x27;answer&#x27;</span>: <span class="hljs-string">&#x27;17,000&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">4</span>}]`,wrap:!1}}),Qs=new Ma({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/task_summary.md"}}),{c(){j=i("meta"),Fs=n(),Es=i("p"),Ls=n(),o(b.$$.fragment),As=n(),J=i("p"),J.textContent=xe,Ps=n(),x=i("p"),x.textContent=we,Ds=n(),o(w.$$.fragment),Ks=n(),T=i("p"),T.textContent=Te,Os=n(),U=i("p"),U.textContent=Ue,st=n(),o(k.$$.fragment),tt=n(),C=i("p"),C.textContent=ke,et=n(),I=i("ul"),I.innerHTML=Ce,at=n(),o(Z.$$.fragment),nt=n(),o(v.$$.fragment),lt=n(),$=i("p"),$.textContent=Ie,it=n(),B=i("p"),B.textContent=Ze,pt=n(),o(W.$$.fragment),rt=n(),o(q.$$.fragment),ot=n(),G=i("p"),G.innerHTML=ve,ct=n(),H=i("p"),H.textContent=$e,mt=n(),V=i("ol"),V.innerHTML=Be,ht=n(),o(N.$$.fragment),ut=n(),R=i("p"),R.textContent=We,gt=n(),z=i("ul"),z.innerHTML=qe,dt=n(),o(Q.$$.fragment),yt=n(),o(Y.$$.fragment),jt=n(),X=i("p"),X.textContent=Ge,Mt=n(),E=i("ul"),E.innerHTML=He,ft=n(),o(S.$$.fragment),bt=n(),o(_.$$.fragment),Jt=n(),F=i("p"),F.textContent=Ve,xt=n(),L=i("ul"),L.innerHTML=Ne,wt=n(),A=i("p"),A.textContent=Re,Tt=n(),o(P.$$.fragment),Ut=n(),o(D.$$.fragment),kt=n(),K=i("p"),K.textContent=ze,Ct=n(),O=i("p"),O.textContent=Qe,It=n(),ss=i("ul"),ss.innerHTML=Ye,Zt=n(),o(ts.$$.fragment),vt=n(),o(es.$$.fragment),$t=n(),as=i("p"),as.textContent=Xe,Bt=n(),o(ns.$$.fragment),Wt=n(),ls=i("p"),ls.textContent=Ee,qt=n(),is=i("ul"),is.innerHTML=Se,Gt=n(),o(ps.$$.fragment),Ht=n(),o(rs.$$.fragment),Vt=n(),os=i("p"),os.innerHTML=_e,Nt=n(),cs=i("p"),cs.textContent=Fe,Rt=n(),ms=i("ul"),ms.innerHTML=Le,zt=n(),o(hs.$$.fragment),Qt=n(),o(us.$$.fragment),Yt=n(),gs=i("p"),gs.textContent=Ae,Xt=n(),ds=i("p"),ds.textContent=Pe,Et=n(),ys=i("ul"),ys.innerHTML=De,St=n(),o(js.$$.fragment),_t=n(),o(Ms.$$.fragment),Ft=n(),fs=i("p"),fs.textContent=Ke,Lt=n(),bs=i("p"),bs.textContent=Oe,At=n(),Js=i("ul"),Js.innerHTML=sa,Pt=n(),o(xs.$$.fragment),Dt=n(),o(ws.$$.fragment),Kt=n(),Ts=i("p"),Ts.textContent=ta,Ot=n(),Us=i("p"),Us.textContent=ea,se=n(),o(ks.$$.fragment),te=n(),o(Cs.$$.fragment),ee=n(),Is=i("p"),Is.textContent=aa,ae=n(),Zs=i("p"),Zs.textContent=na,ne=n(),M=i("ul"),vs=i("li"),Ys=i("p"),Ys.textContent=la,Me=n(),o($s.$$.fragment),fe=n(),Bs=i("li"),Xs=i("p"),Xs.textContent=ia,be=n(),o(Ws.$$.fragment),le=n(),o(qs.$$.fragment),ie=n(),Gs=i("p"),Gs.textContent=pa,pe=n(),Hs=i("p"),Hs.textContent=ra,re=n(),o(Vs.$$.fragment),oe=n(),Ns=i("p"),Ns.textContent=oa,ce=n(),o(Rs.$$.fragment),me=n(),zs=i("p"),zs.innerHTML=ca,he=n(),o(Qs.$$.fragment),ue=n(),Ss=i("p"),this.h()},l(s){const t=ja("svelte-u9bgzb",document.head);j=p(t,"META",{name:!0,content:!0}),t.forEach(e),Fs=l(s),Es=p(s,"P",{}),_s(Es).forEach(e),Ls=l(s),c(b.$$.fragment,s),As=l(s),J=p(s,"P",{"data-svelte-h":!0}),r(J)!=="svelte-16honzi"&&(J.textContent=xe),Ps=l(s),x=p(s,"P",{"data-svelte-h":!0}),r(x)!=="svelte-co1bd8"&&(x.textContent=we),Ds=l(s),c(w.$$.fragment,s),Ks=l(s),T=p(s,"P",{"data-svelte-h":!0}),r(T)!=="svelte-y5bzkk"&&(T.textContent=Te),Os=l(s),U=p(s,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1buqhp9"&&(U.textContent=Ue),st=l(s),c(k.$$.fragment,s),tt=l(s),C=p(s,"P",{"data-svelte-h":!0}),r(C)!=="svelte-wenpsc"&&(C.textContent=ke),et=l(s),I=p(s,"UL",{"data-svelte-h":!0}),r(I)!=="svelte-ii0fya"&&(I.innerHTML=Ce),at=l(s),c(Z.$$.fragment,s),nt=l(s),c(v.$$.fragment,s),lt=l(s),$=p(s,"P",{"data-svelte-h":!0}),r($)!=="svelte-1uioxjn"&&($.textContent=Ie),it=l(s),B=p(s,"P",{"data-svelte-h":!0}),r(B)!=="svelte-13nabhb"&&(B.textContent=Ze),pt=l(s),c(W.$$.fragment,s),rt=l(s),c(q.$$.fragment,s),ot=l(s),G=p(s,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1iprewp"&&(G.innerHTML=ve),ct=l(s),H=p(s,"P",{"data-svelte-h":!0}),r(H)!=="svelte-9en3oh"&&(H.textContent=$e),mt=l(s),V=p(s,"OL",{"data-svelte-h":!0}),r(V)!=="svelte-1n2rw1y"&&(V.innerHTML=Be),ht=l(s),c(N.$$.fragment,s),ut=l(s),R=p(s,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1xnawqn"&&(R.textContent=We),gt=l(s),z=p(s,"UL",{"data-svelte-h":!0}),r(z)!=="svelte-hzwblv"&&(z.innerHTML=qe),dt=l(s),c(Q.$$.fragment,s),yt=l(s),c(Y.$$.fragment,s),jt=l(s),X=p(s,"P",{"data-svelte-h":!0}),r(X)!=="svelte-rzixgf"&&(X.textContent=Ge),Mt=l(s),E=p(s,"UL",{"data-svelte-h":!0}),r(E)!=="svelte-11ca9ev"&&(E.innerHTML=He),ft=l(s),c(S.$$.fragment,s),bt=l(s),c(_.$$.fragment,s),Jt=l(s),F=p(s,"P",{"data-svelte-h":!0}),r(F)!=="svelte-z5ffax"&&(F.textContent=Ve),xt=l(s),L=p(s,"UL",{"data-svelte-h":!0}),r(L)!=="svelte-1uq2lxo"&&(L.innerHTML=Ne),wt=l(s),A=p(s,"P",{"data-svelte-h":!0}),r(A)!=="svelte-fhukdm"&&(A.textContent=Re),Tt=l(s),c(P.$$.fragment,s),Ut=l(s),c(D.$$.fragment,s),kt=l(s),K=p(s,"P",{"data-svelte-h":!0}),r(K)!=="svelte-ee4yo2"&&(K.textContent=ze),Ct=l(s),O=p(s,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1tcdxbt"&&(O.textContent=Qe),It=l(s),ss=p(s,"UL",{"data-svelte-h":!0}),r(ss)!=="svelte-1h9rsal"&&(ss.innerHTML=Ye),Zt=l(s),c(ts.$$.fragment,s),vt=l(s),c(es.$$.fragment,s),$t=l(s),as=p(s,"P",{"data-svelte-h":!0}),r(as)!=="svelte-p86gd4"&&(as.textContent=Xe),Bt=l(s),c(ns.$$.fragment,s),Wt=l(s),ls=p(s,"P",{"data-svelte-h":!0}),r(ls)!=="svelte-xkrisb"&&(ls.textContent=Ee),qt=l(s),is=p(s,"UL",{"data-svelte-h":!0}),r(is)!=="svelte-1785q2k"&&(is.innerHTML=Se),Gt=l(s),c(ps.$$.fragment,s),Ht=l(s),c(rs.$$.fragment,s),Vt=l(s),os=p(s,"P",{"data-svelte-h":!0}),r(os)!=="svelte-1ybu6t8"&&(os.innerHTML=_e),Nt=l(s),cs=p(s,"P",{"data-svelte-h":!0}),r(cs)!=="svelte-1tgdzja"&&(cs.textContent=Fe),Rt=l(s),ms=p(s,"UL",{"data-svelte-h":!0}),r(ms)!=="svelte-3b1070"&&(ms.innerHTML=Le),zt=l(s),c(hs.$$.fragment,s),Qt=l(s),c(us.$$.fragment,s),Yt=l(s),gs=p(s,"P",{"data-svelte-h":!0}),r(gs)!=="svelte-jggqzr"&&(gs.textContent=Ae),Xt=l(s),ds=p(s,"P",{"data-svelte-h":!0}),r(ds)!=="svelte-16zyksn"&&(ds.textContent=Pe),Et=l(s),ys=p(s,"UL",{"data-svelte-h":!0}),r(ys)!=="svelte-1df0yzc"&&(ys.innerHTML=De),St=l(s),c(js.$$.fragment,s),_t=l(s),c(Ms.$$.fragment,s),Ft=l(s),fs=p(s,"P",{"data-svelte-h":!0}),r(fs)!=="svelte-4carp"&&(fs.textContent=Ke),Lt=l(s),bs=p(s,"P",{"data-svelte-h":!0}),r(bs)!=="svelte-1s0vpsm"&&(bs.textContent=Oe),At=l(s),Js=p(s,"UL",{"data-svelte-h":!0}),r(Js)!=="svelte-1ev5pp5"&&(Js.innerHTML=sa),Pt=l(s),c(xs.$$.fragment,s),Dt=l(s),c(ws.$$.fragment,s),Kt=l(s),Ts=p(s,"P",{"data-svelte-h":!0}),r(Ts)!=="svelte-1oa82bc"&&(Ts.textContent=ta),Ot=l(s),Us=p(s,"P",{"data-svelte-h":!0}),r(Us)!=="svelte-l2a5jq"&&(Us.textContent=ea),se=l(s),c(ks.$$.fragment,s),te=l(s),c(Cs.$$.fragment,s),ee=l(s),Is=p(s,"P",{"data-svelte-h":!0}),r(Is)!=="svelte-1hrjdjs"&&(Is.textContent=aa),ae=l(s),Zs=p(s,"P",{"data-svelte-h":!0}),r(Zs)!=="svelte-128qp3h"&&(Zs.textContent=na),ne=l(s),M=p(s,"UL",{});var de=_s(M);vs=p(de,"LI",{});var ye=_s(vs);Ys=p(ye,"P",{"data-svelte-h":!0}),r(Ys)!=="svelte-cojn0n"&&(Ys.textContent=la),Me=l(ye),c($s.$$.fragment,ye),ye.forEach(e),fe=l(de),Bs=p(de,"LI",{});var je=_s(Bs);Xs=p(je,"P",{"data-svelte-h":!0}),r(Xs)!=="svelte-b2em4k"&&(Xs.textContent=ia),be=l(je),c(Ws.$$.fragment,je),je.forEach(e),de.forEach(e),le=l(s),c(qs.$$.fragment,s),ie=l(s),Gs=p(s,"P",{"data-svelte-h":!0}),r(Gs)!=="svelte-1wn2c65"&&(Gs.textContent=pa),pe=l(s),Hs=p(s,"P",{"data-svelte-h":!0}),r(Hs)!=="svelte-1ax7w6c"&&(Hs.textContent=ra),re=l(s),c(Vs.$$.fragment,s),oe=l(s),Ns=p(s,"P",{"data-svelte-h":!0}),r(Ns)!=="svelte-1sl6ve4"&&(Ns.textContent=oa),ce=l(s),c(Rs.$$.fragment,s),me=l(s),zs=p(s,"P",{"data-svelte-h":!0}),r(zs)!=="svelte-14177uf"&&(zs.innerHTML=ca),he=l(s),c(Qs.$$.fragment,s),ue=l(s),Ss=p(s,"P",{}),_s(Ss).forEach(e),this.h()},h(){ma(j,"name","hf:doc:metadata"),ma(j,"content",ba)},m(s,t){f(document.head,j),a(s,Fs,t),a(s,Es,t),a(s,Ls,t),m(b,s,t),a(s,As,t),a(s,J,t),a(s,Ps,t),a(s,x,t),a(s,Ds,t),m(w,s,t),a(s,Ks,t),a(s,T,t),a(s,Os,t),a(s,U,t),a(s,st,t),m(k,s,t),a(s,tt,t),a(s,C,t),a(s,et,t),a(s,I,t),a(s,at,t),m(Z,s,t),a(s,nt,t),m(v,s,t),a(s,lt,t),a(s,$,t),a(s,it,t),a(s,B,t),a(s,pt,t),m(W,s,t),a(s,rt,t),m(q,s,t),a(s,ot,t),a(s,G,t),a(s,ct,t),a(s,H,t),a(s,mt,t),a(s,V,t),a(s,ht,t),m(N,s,t),a(s,ut,t),a(s,R,t),a(s,gt,t),a(s,z,t),a(s,dt,t),m(Q,s,t),a(s,yt,t),m(Y,s,t),a(s,jt,t),a(s,X,t),a(s,Mt,t),a(s,E,t),a(s,ft,t),m(S,s,t),a(s,bt,t),m(_,s,t),a(s,Jt,t),a(s,F,t),a(s,xt,t),a(s,L,t),a(s,wt,t),a(s,A,t),a(s,Tt,t),m(P,s,t),a(s,Ut,t),m(D,s,t),a(s,kt,t),a(s,K,t),a(s,Ct,t),a(s,O,t),a(s,It,t),a(s,ss,t),a(s,Zt,t),m(ts,s,t),a(s,vt,t),m(es,s,t),a(s,$t,t),a(s,as,t),a(s,Bt,t),m(ns,s,t),a(s,Wt,t),a(s,ls,t),a(s,qt,t),a(s,is,t),a(s,Gt,t),m(ps,s,t),a(s,Ht,t),m(rs,s,t),a(s,Vt,t),a(s,os,t),a(s,Nt,t),a(s,cs,t),a(s,Rt,t),a(s,ms,t),a(s,zt,t),m(hs,s,t),a(s,Qt,t),m(us,s,t),a(s,Yt,t),a(s,gs,t),a(s,Xt,t),a(s,ds,t),a(s,Et,t),a(s,ys,t),a(s,St,t),m(js,s,t),a(s,_t,t),m(Ms,s,t),a(s,Ft,t),a(s,fs,t),a(s,Lt,t),a(s,bs,t),a(s,At,t),a(s,Js,t),a(s,Pt,t),m(xs,s,t),a(s,Dt,t),m(ws,s,t),a(s,Kt,t),a(s,Ts,t),a(s,Ot,t),a(s,Us,t),a(s,se,t),m(ks,s,t),a(s,te,t),m(Cs,s,t),a(s,ee,t),a(s,Is,t),a(s,ae,t),a(s,Zs,t),a(s,ne,t),a(s,M,t),f(M,vs),f(vs,Ys),f(vs,Me),m($s,vs,null),f(M,fe),f(M,Bs),f(Bs,Xs),f(Bs,be),m(Ws,Bs,null),a(s,le,t),m(qs,s,t),a(s,ie,t),a(s,Gs,t),a(s,pe,t),a(s,Hs,t),a(s,re,t),m(Vs,s,t),a(s,oe,t),a(s,Ns,t),a(s,ce,t),m(Rs,s,t),a(s,me,t),a(s,zs,t),a(s,he,t),m(Qs,s,t),a(s,ue,t),a(s,Ss,t),ge=!0},p:ua,i(s){ge||(h(b.$$.fragment,s),h(w.$$.fragment,s),h(k.$$.fragment,s),h(Z.$$.fragment,s),h(v.$$.fragment,s),h(W.$$.fragment,s),h(q.$$.fragment,s),h(N.$$.fragment,s),h(Q.$$.fragment,s),h(Y.$$.fragment,s),h(S.$$.fragment,s),h(_.$$.fragment,s),h(P.$$.fragment,s),h(D.$$.fragment,s),h(ts.$$.fragment,s),h(es.$$.fragment,s),h(ns.$$.fragment,s),h(ps.$$.fragment,s),h(rs.$$.fragment,s),h(hs.$$.fragment,s),h(us.$$.fragment,s),h(js.$$.fragment,s),h(Ms.$$.fragment,s),h(xs.$$.fragment,s),h(ws.$$.fragment,s),h(ks.$$.fragment,s),h(Cs.$$.fragment,s),h($s.$$.fragment,s),h(Ws.$$.fragment,s),h(qs.$$.fragment,s),h(Vs.$$.fragment,s),h(Rs.$$.fragment,s),h(Qs.$$.fragment,s),ge=!0)},o(s){u(b.$$.fragment,s),u(w.$$.fragment,s),u(k.$$.fragment,s),u(Z.$$.fragment,s),u(v.$$.fragment,s),u(W.$$.fragment,s),u(q.$$.fragment,s),u(N.$$.fragment,s),u(Q.$$.fragment,s),u(Y.$$.fragment,s),u(S.$$.fragment,s),u(_.$$.fragment,s),u(P.$$.fragment,s),u(D.$$.fragment,s),u(ts.$$.fragment,s),u(es.$$.fragment,s),u(ns.$$.fragment,s),u(ps.$$.fragment,s),u(rs.$$.fragment,s),u(hs.$$.fragment,s),u(us.$$.fragment,s),u(js.$$.fragment,s),u(Ms.$$.fragment,s),u(xs.$$.fragment,s),u(ws.$$.fragment,s),u(ks.$$.fragment,s),u(Cs.$$.fragment,s),u($s.$$.fragment,s),u(Ws.$$.fragment,s),u(qs.$$.fragment,s),u(Vs.$$.fragment,s),u(Rs.$$.fragment,s),u(Qs.$$.fragment,s),ge=!1},d(s){s&&(e(Fs),e(Es),e(Ls),e(As),e(J),e(Ps),e(x),e(Ds),e(Ks),e(T),e(Os),e(U),e(st),e(tt),e(C),e(et),e(I),e(at),e(nt),e(lt),e($),e(it),e(B),e(pt),e(rt),e(ot),e(G),e(ct),e(H),e(mt),e(V),e(ht),e(ut),e(R),e(gt),e(z),e(dt),e(yt),e(jt),e(X),e(Mt),e(E),e(ft),e(bt),e(Jt),e(F),e(xt),e(L),e(wt),e(A),e(Tt),e(Ut),e(kt),e(K),e(Ct),e(O),e(It),e(ss),e(Zt),e(vt),e($t),e(as),e(Bt),e(Wt),e(ls),e(qt),e(is),e(Gt),e(Ht),e(Vt),e(os),e(Nt),e(cs),e(Rt),e(ms),e(zt),e(Qt),e(Yt),e(gs),e(Xt),e(ds),e(Et),e(ys),e(St),e(_t),e(Ft),e(fs),e(Lt),e(bs),e(At),e(Js),e(Pt),e(Dt),e(Kt),e(Ts),e(Ot),e(Us),e(se),e(te),e(ee),e(Is),e(ae),e(Zs),e(ne),e(M),e(le),e(ie),e(Gs),e(pe),e(Hs),e(re),e(oe),e(Ns),e(ce),e(me),e(zs),e(he),e(ue),e(Ss)),e(j),g(b,s),g(w,s),g(k,s),g(Z,s),g(v,s),g(W,s),g(q,s),g(N,s),g(Q,s),g(Y,s),g(S,s),g(_,s),g(P,s),g(D,s),g(ts,s),g(es,s),g(ns,s),g(ps,s),g(rs,s),g(hs,s),g(us,s),g(js,s),g(Ms,s),g(xs,s),g(ws,s),g(ks,s),g(Cs,s),g($s),g(Ws),g(qs,s),g(Vs,s),g(Rs,s),g(Qs,s)}}}const ba='{"title":"What 🤗 Transformers can do","local":"what--transformers-can-do","sections":[{"title":"Audio","local":"audio","sections":[{"title":"Audio classification","local":"audio-classification","sections":[],"depth":3},{"title":"Automatic speech recognition","local":"automatic-speech-recognition","sections":[],"depth":3}],"depth":2},{"title":"Computer vision","local":"computer-vision","sections":[{"title":"Image classification","local":"image-classification","sections":[],"depth":3},{"title":"Object detection","local":"object-detection","sections":[],"depth":3},{"title":"Image segmentation","local":"image-segmentation","sections":[],"depth":3},{"title":"Depth estimation","local":"depth-estimation","sections":[],"depth":3}],"depth":2},{"title":"Natural language processing","local":"natural-language-processing","sections":[{"title":"Text classification","local":"text-classification","sections":[],"depth":3},{"title":"Token classification","local":"token-classification","sections":[],"depth":3},{"title":"Question answering","local":"question-answering","sections":[],"depth":3},{"title":"Summarization","local":"summarization","sections":[],"depth":3},{"title":"Translation","local":"translation","sections":[],"depth":3},{"title":"Language modeling","local":"language-modeling","sections":[],"depth":3}],"depth":2},{"title":"Multimodal","local":"multimodal","sections":[{"title":"Document question answering","local":"document-question-answering","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ja(Je){return ga(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ka extends da{constructor(j){super(),ya(this,j,Ja,fa,ha,{})}}export{ka as component};
