import{s as $a,o as Ua,n as Ja}from"../chunks/scheduler.25b97de1.js";import{S as va,i as Ia,g as i,s as l,r as o,A as Za,h as p,f as t,c as n,j as ba,u as c,x as r,k as vt,y as ka,a,v as m,d as h,t as u,w as d,m as xa,n as Ga}from"../chunks/index.d9030fc9.js";import{T as It}from"../chunks/Tip.baa67368.js";import{C as y}from"../chunks/CodeBlock.e6cd0d95.js";import{H as j,E as Ba}from"../chunks/EditOnGithub.91d95064.js";function Wa($){let f,M='Take a look at the <a href="/docs/transformers/pr_31224/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> documentation for a complete list of supported tasks and available parameters.';return{c(){f=i("p"),f.innerHTML=M},l(w){f=p(w,"P",{"data-svelte-h":!0}),r(f)!=="svelte-1ezcxfm"&&(f.innerHTML=M)},m(w,T){a(w,f,T)},p:Ja,d(w){w&&t(f)}}}function Ca($){let f;return{c(){f=xa(`Creating an inference engine is a complex topic which deserves it's own
page.`)},l(M){f=Ga(M,`Creating an inference engine is a complex topic which deserves it's own
page.`)},m(M,w){a(M,f,w)},d(M){M&&t(f)}}}function _a($){let f,M='To run the example above you need to have <a href="https://pypi.org/project/pytesseract/" rel="nofollow"><code>pytesseract</code></a> installed in addition to 🤗 Transformers:',w,T,b;return T=new y({props:{code:"c3VkbyUyMGFwdCUyMGluc3RhbGwlMjAteSUyMHRlc3NlcmFjdC1vY3IlMEFwaXAlMjBpbnN0YWxsJTIwcHl0ZXNzZXJhY3Q=",highlighted:`sudo apt install -y tesseract-ocr
pip install pytesseract`,wrap:!1}}),{c(){f=i("p"),f.innerHTML=M,w=l(),o(T.$$.fragment)},l(g){f=p(g,"P",{"data-svelte-h":!0}),r(f)!=="svelte-z3k1tk"&&(f.innerHTML=M),w=n(g),c(T.$$.fragment,g)},m(g,J){a(g,f,J),a(g,w,J),m(T,g,J),b=!0},p:Ja,i(g){b||(h(T.$$.fragment,g),b=!0)},o(g){u(T.$$.fragment,g),b=!1},d(g){g&&(t(f),t(w)),d(T,g)}}}function Xa($){let f,M,w,T,b,g,J,Zt='The <a href="/docs/transformers/pr_31224/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> makes it simple to use any model from the <a href="https://huggingface.co/models" rel="nofollow">Hub</a> for inference on any language, computer vision, speech, and multimodal tasks. Even if you don’t have experience with a specific modality or aren’t familiar with the underlying code behind the models, you can still use them for inference with the <a href="/docs/transformers/pr_31224/en/main_classes/pipelines#transformers.pipeline">pipeline()</a>! This tutorial will teach you to:',Ke,k,kt='<li>Use a <a href="/docs/transformers/pr_31224/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> for inference.</li> <li>Use a specific tokenizer or model.</li> <li>Use a <a href="/docs/transformers/pr_31224/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> for audio, vision, and multimodal tasks.</li>',Oe,U,es,x,ss,G,xt=`While each task has an associated <a href="/docs/transformers/pr_31224/en/main_classes/pipelines#transformers.pipeline">pipeline()</a>, it is simpler to use the general <a href="/docs/transformers/pr_31224/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> abstraction which contains
all the task-specific pipelines. The <a href="/docs/transformers/pr_31224/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> automatically loads a default model and a preprocessing class capable
of inference for your task. Let’s take the example of using the <a href="/docs/transformers/pr_31224/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> for automatic speech recognition (ASR), or
speech-to-text.`,ts,B,Gt='<li>Start by creating a <a href="/docs/transformers/pr_31224/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> and specify the inference task:</li>',as,W,ls,v,Bt='<li>Pass your input to the <a href="/docs/transformers/pr_31224/en/main_classes/pipelines#transformers.pipeline">pipeline()</a>. In the case of speech recognition, this is an audio input file:</li>',ns,C,is,_,Wt=`Not the result you had in mind? Check out some of the <a href="https://huggingface.co/models?pipeline_tag=automatic-speech-recognition&amp;sort=trending" rel="nofollow">most downloaded automatic speech recognition models</a>
on the Hub to see if you can get a better transcription.`,ps,X,Ct=`Let’s try the <a href="https://huggingface.co/openai/whisper-large" rel="nofollow">Whisper large-v2</a> model from OpenAI. Whisper was released
2 years later than Wav2Vec2, and was trained on close to 10x more data. As such, it beats Wav2Vec2 on most downstream
benchmarks. It also has the added benefit of predicting punctuation and casing, neither of which are possible with<br/>
Wav2Vec2.`,rs,H,_t="Let’s give it a try here to see how it performs:",os,R,cs,Y,Xt=`Now this result looks more accurate! For a deep-dive comparison on Wav2Vec2 vs Whisper, refer to the <a href="https://huggingface.co/learn/audio-course/chapter5/asr_models" rel="nofollow">Audio Transformers Course</a>.
We really encourage you to check out the Hub for models in different languages, models specialized in your field, and more.
You can check out and compare model results directly from your browser on the Hub to see if it fits or
handles corner cases better than other ones.
And if you don’t find a model for your use case, you can always start <a href="training">training</a> your own!`,ms,N,Ht="If you have several inputs, you can pass your input as a list:",hs,q,us,V,Rt=`Pipelines are great for experimentation as switching from one model to another is trivial; however, there are some ways to optimize them for larger workloads than experimentation. See the following guides that dive into iterating over whole datasets or using pipelines in a webserver:
of the docs:`,ds,z,Yt='<li><a href="#using-pipelines-on-a-dataset">Using pipelines on a dataset</a></li> <li><a href="./pipeline_webserver">Using pipelines for a webserver</a></li>',fs,S,ys,L,Nt=`<a href="/docs/transformers/pr_31224/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> supports many parameters; some are task specific, and some are general to all pipelines.
In general, you can specify parameters anywhere you want:`,gs,F,ws,Q,qt="Let’s check out 3 important ones:",Ms,E,Ts,P,Vt=`If you use <code>device=n</code>, the pipeline automatically puts the model on the specified device.
This will work regardless of whether you are using PyTorch or Tensorflow.`,js,A,bs,D,zt=`If the model is too large for a single GPU and you are using PyTorch, you can set <code>device_map=&quot;auto&quot;</code> to automatically
determine how to load and store the model weights. Using the <code>device_map</code> argument requires the 🤗 <a href="https://huggingface.co/docs/accelerate" rel="nofollow">Accelerate</a>
package:`,Js,K,$s,O,St="The following code automatically loads and stores model weights across devices:",Us,ee,vs,se,Lt="Note that if  <code>device_map=&quot;auto&quot;</code> is passed, there is no need to add the argument <code>device=device</code> when instantiating your <code>pipeline</code> as you may encounter some unexpected behavior!",Is,te,Zs,ae,Ft='By default, pipelines will not batch inference for reasons explained in detail <a href="https://huggingface.co/docs/transformers/main_classes/pipelines#pipeline-batching" rel="nofollow">here</a>. The reason is that batching is not necessarily faster, and can actually be quite slower in some cases.',ks,le,Qt="But if it works in your use case, you can use:",xs,ne,Gs,ie,Et=`This runs the pipeline on the 4 provided audio files, but it will pass them in batches of 2
to the model (which is on a GPU, where batching is more likely to help) without requiring any further code from you.
The output should always match what you would have received without batching. It is only meant as a way to help you get more speed out of a pipeline.`,Bs,pe,Pt='Pipelines can also alleviate some of the complexities of batching because, for some pipelines, a single item (like a long audio file) needs to be chunked into multiple parts to be processed by a model. The pipeline performs this <a href="./main_classes/pipelines#pipeline-chunk-batching"><em>chunk batching</em></a> for you.',Ws,re,Cs,oe,At=`All tasks provide task specific parameters which allow for additional flexibility and options to help you get your job done.
For instance, the <a href="/docs/transformers/pr_31224/en/main_classes/pipelines#transformers.AutomaticSpeechRecognitionPipeline.__call__">transformers.AutomaticSpeechRecognitionPipeline.<strong>call</strong>()</a> method has a <code>return_timestamps</code> parameter which sounds promising for subtitling videos:`,_s,ce,Xs,me,Dt="As you can see, the model inferred the text and also outputted <strong>when</strong> the various sentences were pronounced.",Hs,he,Kt=`There are many parameters available for each task, so check out each task’s API reference to see what you can tinker with!
For instance, the <a href="/docs/transformers/pr_31224/en/main_classes/pipelines#transformers.AutomaticSpeechRecognitionPipeline">AutomaticSpeechRecognitionPipeline</a> has a <code>chunk_length_s</code> parameter which is helpful
for working on really long audio files (for example, subtitling entire movies or hour-long videos) that a model typically
cannot handle on its own:`,Rs,ue,Ys,de,Ot='If you can’t find a parameter that would really help you out, feel free to <a href="https://github.com/huggingface/transformers/issues/new?assignees=&amp;labels=feature&amp;template=feature-request.yml" rel="nofollow">request it</a>!',Ns,fe,qs,ye,ea="The pipeline can also run inference on a large dataset. The easiest way we recommend doing this is by using an iterator:",Vs,ge,zs,we,sa=`The iterator <code>data()</code> yields each result, and the pipeline automatically
recognizes the input is iterable and will start fetching the data while
it continues to process it on the GPU (this uses <a href="https://pytorch.org/docs/stable/data.html#torch.utils.data.DataLoader" rel="nofollow">DataLoader</a> under the hood).
This is important because you don’t have to allocate memory for the whole dataset
and you can feed the GPU as fast as possible.`,Ss,Me,ta="Since batching could speed things up, it may be useful to try tuning the <code>batch_size</code> parameter here.",Ls,Te,aa='The simplest way to iterate over a dataset is to just load one from 🤗 <a href="https://github.com/huggingface/datasets/" rel="nofollow">Datasets</a>:',Fs,je,Qs,be,Es,I,Ps,Je,la='<a href="./pipeline_webserver">Link</a>',As,$e,Ds,Ue,na='Using a <a href="/docs/transformers/pr_31224/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> for vision tasks is practically identical.',Ks,ve,ia="Specify your task and pass your image to the classifier. The image can be a link, a local path or a base64-encoded image. For example, what species of cat is shown below?",Os,Ie,pa='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg" alt="pipeline-cat-chonk"/>',et,Ze,st,ke,tt,xe,ra='Using a <a href="/docs/transformers/pr_31224/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> for NLP tasks is practically identical.',at,Ge,lt,Be,nt,We,oa='The <a href="/docs/transformers/pr_31224/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> supports more than one modality. For example, a visual question answering (VQA) task combines text and image. Feel free to use any image link you like and a question you want to ask about the image. The image can be a URL or a local path to the image.',it,Ce,ca='For example, if you use this <a href="https://huggingface.co/spaces/impira/docquery/resolve/2359223c1837a7587402bda0f2643382a6eefeab/invoice.png" rel="nofollow">invoice image</a>:',pt,_e,rt,Z,ot,Xe,ct,He,ma="You can easily run <code>pipeline</code> on large models using 🤗 <code>accelerate</code>! First make sure you have installed <code>accelerate</code> with <code>pip install accelerate</code>.",mt,Re,ha="First load your model using <code>device_map=&quot;auto&quot;</code>! We will use <code>facebook/opt-1.3b</code> for our example.",ht,Ye,ut,Ne,ua="You can also pass 8-bit loaded models if you install <code>bitsandbytes</code> and add the argument <code>load_in_8bit=True</code>",dt,qe,ft,Ve,da="Note that you can replace the checkpoint with any Hugging Face model that supports large model loading, such as BLOOM.",yt,ze,gt,Se,fa='Pipelines are automatically supported in <a href="https://github.com/gradio-app/gradio/" rel="nofollow">Gradio</a>, a library that makes creating beautiful and user-friendly machine learning apps on the web a breeze. First, make sure you have Gradio installed:',wt,Le,Mt,Fe,ya='Then, you can create a web demo around an image classification pipeline (or any other pipeline) in a single line of code by calling Gradio’s <a href="https://www.gradio.app/docs/interface#interface-from-pipeline" rel="nofollow"><code>Interface.from_pipeline</code></a> function to launch the pipeline. This creates an intuitive drag-and-drop interface in your browser:',Tt,Qe,jt,Ee,ga='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/panda-classification.png"/>',bt,Pe,wa=`By default, the web demo runs on a local server. If you’d like to share it with others, you can generate a temporary public
link by setting <code>share=True</code> in <code>launch()</code>. You can also host your demo on <a href="https://huggingface.co/spaces" rel="nofollow">Hugging Face Spaces</a> for a permanent link.`,Jt,Ae,$t,De,Ut;return b=new j({props:{title:"Pipelines for inference",local:"pipelines-for-inference",headingTag:"h1"}}),U=new It({props:{$$slots:{default:[Wa]},$$scope:{ctx:$}}}),x=new j({props:{title:"Pipeline usage",local:"pipeline-usage",headingTag:"h2"}}),W=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber = pipeline(task=<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>)`,wrap:!1}}),C=new y({props:{code:"dHJhbnNjcmliZXIoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGTmFyc2lsJTJGYXNyX2R1bW15JTJGcmVzb2x2ZSUyRm1haW4lMkZtbGsuZmxhYyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber(<span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&quot;</span>)
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;I HAVE A DREAM BUT ONE DAY THIS NATION WILL RISE UP LIVE UP THE TRUE MEANING OF ITS TREES&#x27;</span>}`,wrap:!1}}),R=new y({props:{code:"dHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMm9wZW5haSUyRndoaXNwZXItbGFyZ2UtdjIlMjIpJTBBdHJhbnNjcmliZXIoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGTmFyc2lsJTJGYXNyX2R1bW15JTJGcmVzb2x2ZSUyRm1haW4lMkZtbGsuZmxhYyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber(<span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&quot;</span>)
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27; I have a dream that one day this nation will rise up and live out the true meaning of its creed.&#x27;</span>}`,wrap:!1}}),q=new y({props:{code:"dHJhbnNjcmliZXIoJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGTmFyc2lsJTJGYXNyX2R1bW15JTJGcmVzb2x2ZSUyRm1haW4lMkZtbGsuZmxhYyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRk5hcnNpbCUyRmFzcl9kdW1teSUyRnJlc29sdmUlMkZtYWluJTJGMS5mbGFjJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTBBKQ==",highlighted:`transcriber(
    [
        <span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&quot;</span>,
        <span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/1.flac&quot;</span>,
    ]
)`,wrap:!1}}),S=new j({props:{title:"Parameters",local:"parameters",headingTag:"h2"}}),F=new y({props:{code:"dHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMm9wZW5haSUyRndoaXNwZXItbGFyZ2UtdjIlMjIlMkMlMjBteV9wYXJhbWV0ZXIlM0QxKSUwQSUwQW91dCUyMCUzRCUyMHRyYW5zY3JpYmVyKC4uLiklMjAlMjAlMjMlMjBUaGlzJTIwd2lsbCUyMHVzZSUyMCU2MG15X3BhcmFtZXRlciUzRDElNjAuJTBBb3V0JTIwJTNEJTIwdHJhbnNjcmliZXIoLi4uJTJDJTIwbXlfcGFyYW1ldGVyJTNEMiklMjAlMjAlMjMlMjBUaGlzJTIwd2lsbCUyMG92ZXJyaWRlJTIwYW5kJTIwdXNlJTIwJTYwbXlfcGFyYW1ldGVyJTNEMiU2MC4lMEFvdXQlMjAlM0QlMjB0cmFuc2NyaWJlciguLi4pJTIwJTIwJTIzJTIwVGhpcyUyMHdpbGwlMjBnbyUyMGJhY2slMjB0byUyMHVzaW5nJTIwJTYwbXlfcGFyYW1ldGVyJTNEMSU2MC4=",highlighted:'transcriber = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large-v2&quot;</span>, my_parameter=<span class="hljs-number">1</span>)\n\nout = transcriber(...)  <span class="hljs-comment"># This will use `my_parameter=1`.</span>\nout = transcriber(..., my_parameter=<span class="hljs-number">2</span>)  <span class="hljs-comment"># This will override and use `my_parameter=2`.</span>\nout = transcriber(...)  <span class="hljs-comment"># This will go back to using `my_parameter=1`.</span>',wrap:!1}}),E=new j({props:{title:"Device",local:"device",headingTag:"h3"}}),A=new y({props:{code:"dHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMm9wZW5haSUyRndoaXNwZXItbGFyZ2UtdjIlMjIlMkMlMjBkZXZpY2UlM0QwKQ==",highlighted:'transcriber = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large-v2&quot;</span>, device=<span class="hljs-number">0</span>)',wrap:!1}}),K=new y({props:{code:"cGlwJTIwaW5zdGFsbCUyMC0tdXBncmFkZSUyMGFjY2VsZXJhdGU=",highlighted:"pip install --upgrade accelerate",wrap:!1}}),ee=new y({props:{code:"dHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMm9wZW5haSUyRndoaXNwZXItbGFyZ2UtdjIlMjIlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMik=",highlighted:'transcriber = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large-v2&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)',wrap:!1}}),te=new j({props:{title:"Batch size",local:"batch-size",headingTag:"h3"}}),ne=new y({props:{code:"dHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMm9wZW5haSUyRndoaXNwZXItbGFyZ2UtdjIlMjIlMkMlMjBkZXZpY2UlM0QwJTJDJTIwYmF0Y2hfc2l6ZSUzRDIpJTBBYXVkaW9fZmlsZW5hbWVzJTIwJTNEJTIwJTVCZiUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRk5hcnNpbCUyRmFzcl9kdW1teSUyRnJlc29sdmUlMkZtYWluJTJGJTdCaSU3RC5mbGFjJTIyJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoMSUyQyUyMDUpJTVEJTBBdGV4dHMlMjAlM0QlMjB0cmFuc2NyaWJlcihhdWRpb19maWxlbmFtZXMp",highlighted:`transcriber = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large-v2&quot;</span>, device=<span class="hljs-number">0</span>, batch_size=<span class="hljs-number">2</span>)
audio_filenames = [<span class="hljs-string">f&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/<span class="hljs-subst">{i}</span>.flac&quot;</span> <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1</span>, <span class="hljs-number">5</span>)]
texts = transcriber(audio_filenames)`,wrap:!1}}),re=new j({props:{title:"Task specific parameters",local:"task-specific-parameters",headingTag:"h3"}}),ce=new y({props:{code:"dHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMm9wZW5haSUyRndoaXNwZXItbGFyZ2UtdjIlMjIlMkMlMjByZXR1cm5fdGltZXN0YW1wcyUzRFRydWUpJTBBdHJhbnNjcmliZXIoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGTmFyc2lsJTJGYXNyX2R1bW15JTJGcmVzb2x2ZSUyRm1haW4lMkZtbGsuZmxhYyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large-v2&quot;</span>, return_timestamps=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber(<span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&quot;</span>)
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27; I have a dream that one day this nation will rise up and live out the true meaning of its creed.&#x27;</span>, <span class="hljs-string">&#x27;chunks&#x27;</span>: [{<span class="hljs-string">&#x27;timestamp&#x27;</span>: (<span class="hljs-number">0.0</span>, <span class="hljs-number">11.88</span>), <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27; I have a dream that one day this nation will rise up and live out the true meaning of its&#x27;</span>}, {<span class="hljs-string">&#x27;timestamp&#x27;</span>: (<span class="hljs-number">11.88</span>, <span class="hljs-number">12.38</span>), <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27; creed.&#x27;</span>}]}`,wrap:!1}}),ue=new y({props:{code:"dHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMm9wZW5haSUyRndoaXNwZXItbGFyZ2UtdjIlMjIlMkMlMjBjaHVua19sZW5ndGhfcyUzRDMwKSUwQXRyYW5zY3JpYmVyKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRnJlYWNoLXZiJTJGcmFuZG9tLWF1ZGlvcyUyRnJlc29sdmUlMkZtYWluJTJGdGVkXzYwLndhdiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large-v2&quot;</span>, chunk_length_s=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber(<span class="hljs-string">&quot;https://huggingface.co/datasets/reach-vb/random-audios/resolve/main/ted_60.wav&quot;</span>)
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&quot; So in college, I was a government major, which means I had to write a lot of papers. Now, when a normal student writes a paper, they might spread the work out a little like this. So, you know. You get started maybe a little slowly, but you get enough done in the first week that with some heavier days later on, everything gets done and things stay civil. And I would want to do that like that. That would be the plan. I would have it all ready to go, but then actually the paper would come along, and then I would kind of do this. And that would happen every single paper. But then came my 90-page senior thesis, a paper you&#x27;re supposed to spend a year on. I knew for a paper like that, my normal workflow was not an option, it was way too big a project. So I planned things out and I decided I kind of had to go something like this. This is how the year would go. So I&#x27;d start off light and I&#x27;d bump it up&quot;</span>}`,wrap:!1}}),fe=new j({props:{title:"Using pipelines on a dataset",local:"using-pipelines-on-a-dataset",headingTag:"h2"}}),ge=new y({props:{code:"ZGVmJTIwZGF0YSgpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoMTAwMCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB5aWVsZCUyMGYlMjJNeSUyMGV4YW1wbGUlMjAlN0JpJTdEJTIyJTBBJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIlMkMlMjBkZXZpY2UlM0QwKSUwQWdlbmVyYXRlZF9jaGFyYWN0ZXJzJTIwJTNEJTIwMCUwQWZvciUyMG91dCUyMGluJTIwcGlwZShkYXRhKCkpJTNBJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGVkX2NoYXJhY3RlcnMlMjAlMkIlM0QlMjBsZW4ob3V0JTVCMCU1RCU1QiUyMmdlbmVyYXRlZF90ZXh0JTIyJTVEKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">data</span>():
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>):
        <span class="hljs-keyword">yield</span> <span class="hljs-string">f&quot;My example <span class="hljs-subst">{i}</span>&quot;</span>


pipe = pipeline(model=<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>, device=<span class="hljs-number">0</span>)
generated_characters = <span class="hljs-number">0</span>
<span class="hljs-keyword">for</span> out <span class="hljs-keyword">in</span> pipe(data()):
    generated_characters += <span class="hljs-built_in">len</span>(out[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>])`,wrap:!1}}),je=new y({props:{code:"JTIzJTIwS2V5RGF0YXNldCUyMGlzJTIwYSUyMHV0aWwlMjB0aGF0JTIwd2lsbCUyMGp1c3QlMjBvdXRwdXQlMjB0aGUlMjBpdGVtJTIwd2UncmUlMjBpbnRlcmVzdGVkJTIwaW4uJTBBZnJvbSUyMHRyYW5zZm9ybWVycy5waXBlbGluZXMucHRfdXRpbHMlMjBpbXBvcnQlMjBLZXlEYXRhc2V0JTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRnRpbnktcmFuZG9tLXdhdjJ2ZWMyJTIyJTJDJTIwZGV2aWNlJTNEMCklMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiU1QiUzQTEwJTVEJTIyKSUwQSUwQWZvciUyMG91dCUyMGluJTIwcGlwZShLZXlEYXRhc2V0KGRhdGFzZXQlMkMlMjAlMjJhdWRpbyUyMikpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQob3V0KQ==",highlighted:`<span class="hljs-comment"># KeyDataset is a util that will just output the item we&#x27;re interested in.</span>
<span class="hljs-keyword">from</span> transformers.pipelines.pt_utils <span class="hljs-keyword">import</span> KeyDataset
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

pipe = pipeline(model=<span class="hljs-string">&quot;hf-internal-testing/tiny-random-wav2vec2&quot;</span>, device=<span class="hljs-number">0</span>)
dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation[:10]&quot;</span>)

<span class="hljs-keyword">for</span> out <span class="hljs-keyword">in</span> pipe(KeyDataset(dataset, <span class="hljs-string">&quot;audio&quot;</span>)):
    <span class="hljs-built_in">print</span>(out)`,wrap:!1}}),be=new j({props:{title:"Using pipelines for a webserver",local:"using-pipelines-for-a-webserver",headingTag:"h2"}}),I=new It({props:{$$slots:{default:[Ca]},$$scope:{ctx:$}}}),$e=new j({props:{title:"Vision pipeline",local:"vision-pipeline",headingTag:"h2"}}),Ze=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdmlzaW9uX2NsYXNzaWZpZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMmdvb2dsZSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0JTIyKSUwQXByZWRzJTIwJTNEJTIwdmlzaW9uX2NsYXNzaWZpZXIoJTBBJTIwJTIwJTIwJTIwaW1hZ2VzJTNEJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGcGlwZWxpbmUtY2F0LWNob25rLmpwZWclMjIlMEEpJTBBcHJlZHMlMjAlM0QlMjAlNUIlN0IlMjJzY29yZSUyMiUzQSUyMHJvdW5kKHByZWQlNUIlMjJzY29yZSUyMiU1RCUyQyUyMDQpJTJDJTIwJTIybGFiZWwlMjIlM0ElMjBwcmVkJTVCJTIybGFiZWwlMjIlNUQlN0QlMjBmb3IlMjBwcmVkJTIwaW4lMjBwcmVkcyU1RCUwQXByZWRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>vision_classifier = pipeline(model=<span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = vision_classifier(
<span class="hljs-meta">... </span>    images=<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.4335</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;lynx, catamount&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0348</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;cougar, puma, catamount, mountain lion, painter, panther, Felis concolor&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0324</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;snow leopard, ounce, Panthera uncia&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0239</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;Egyptian cat&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0229</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;tiger cat&#x27;</span>}]`,wrap:!1}}),ke=new j({props:{title:"Text pipeline",local:"text-pipeline",headingTag:"h2"}}),Ge=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBJTIzJTIwVGhpcyUyMG1vZGVsJTIwaXMlMjBhJTIwJTYwemVyby1zaG90LWNsYXNzaWZpY2F0aW9uJTYwJTIwbW9kZWwuJTBBJTIzJTIwSXQlMjB3aWxsJTIwY2xhc3NpZnklMjB0ZXh0JTJDJTIwZXhjZXB0JTIweW91JTIwYXJlJTIwZnJlZSUyMHRvJTIwY2hvb3NlJTIwYW55JTIwbGFiZWwlMjB5b3UlMjBtaWdodCUyMGltYWdpbmUlMEFjbGFzc2lmaWVyJTIwJTNEJTIwcGlwZWxpbmUobW9kZWwlM0QlMjJmYWNlYm9vayUyRmJhcnQtbGFyZ2UtbW5saSUyMiklMEFjbGFzc2lmaWVyKCUwQSUyMCUyMCUyMCUyMCUyMkklMjBoYXZlJTIwYSUyMHByb2JsZW0lMjB3aXRoJTIwbXklMjBpcGhvbmUlMjB0aGF0JTIwbmVlZHMlMjB0byUyMGJlJTIwcmVzb2x2ZWQlMjBhc2FwISElMjIlMkMlMEElMjAlMjAlMjAlMjBjYW5kaWRhdGVfbGFiZWxzJTNEJTVCJTIydXJnZW50JTIyJTJDJTIwJTIybm90JTIwdXJnZW50JTIyJTJDJTIwJTIycGhvbmUlMjIlMkMlMjAlMjJ0YWJsZXQlMjIlMkMlMjAlMjJjb21wdXRlciUyMiU1RCUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This model is a \`zero-shot-classification\` model.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># It will classify text, except you are free to choose any label you might imagine</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>classifier = pipeline(model=<span class="hljs-string">&quot;facebook/bart-large-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>classifier(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;I have a problem with my iphone that needs to be resolved asap!!&quot;</span>,
<span class="hljs-meta">... </span>    candidate_labels=[<span class="hljs-string">&quot;urgent&quot;</span>, <span class="hljs-string">&quot;not urgent&quot;</span>, <span class="hljs-string">&quot;phone&quot;</span>, <span class="hljs-string">&quot;tablet&quot;</span>, <span class="hljs-string">&quot;computer&quot;</span>],
<span class="hljs-meta">... </span>)
{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;I have a problem with my iphone that needs to be resolved asap!!&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>: [<span class="hljs-string">&#x27;urgent&#x27;</span>, <span class="hljs-string">&#x27;phone&#x27;</span>, <span class="hljs-string">&#x27;computer&#x27;</span>, <span class="hljs-string">&#x27;not urgent&#x27;</span>, <span class="hljs-string">&#x27;tablet&#x27;</span>], <span class="hljs-string">&#x27;scores&#x27;</span>: [<span class="hljs-number">0.504</span>, <span class="hljs-number">0.479</span>, <span class="hljs-number">0.013</span>, <span class="hljs-number">0.003</span>, <span class="hljs-number">0.002</span>]}`,wrap:!1}}),Be=new j({props:{title:"Multimodal pipeline",local:"multimodal-pipeline",headingTag:"h2"}}),_e=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdnFhJTIwJTNEJTIwcGlwZWxpbmUobW9kZWwlM0QlMjJpbXBpcmElMkZsYXlvdXRsbS1kb2N1bWVudC1xYSUyMiklMEFvdXRwdXQlMjAlM0QlMjB2cWEoJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0QlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc3BhY2VzJTJGaW1waXJhJTJGZG9jcXVlcnklMkZyZXNvbHZlJTJGMjM1OTIyM2MxODM3YTc1ODc0MDJiZGEwZjI2NDMzODJhNmVlZmVhYiUyRmludm9pY2UucG5nJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVlc3Rpb24lM0QlMjJXaGF0JTIwaXMlMjB0aGUlMjBpbnZvaWNlJTIwbnVtYmVyJTNGJTIyJTJDJTBBKSUwQW91dHB1dCU1QjAlNUQlNUIlMjJzY29yZSUyMiU1RCUyMCUzRCUyMHJvdW5kKG91dHB1dCU1QjAlNUQlNUIlMjJzY29yZSUyMiU1RCUyQyUyMDMpJTBBb3V0cHV0",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>vqa = pipeline(model=<span class="hljs-string">&quot;impira/layoutlm-document-qa&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output = vqa(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;https://huggingface.co/spaces/impira/docquery/resolve/2359223c1837a7587402bda0f2643382a6eefeab/invoice.png&quot;</span>,
<span class="hljs-meta">... </span>    question=<span class="hljs-string">&quot;What is the invoice number?&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;score&quot;</span>] = <span class="hljs-built_in">round</span>(output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">3</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.425</span>, <span class="hljs-string">&#x27;answer&#x27;</span>: <span class="hljs-string">&#x27;us-001&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">16</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">16</span>}]`,wrap:!1}}),Z=new It({props:{$$slots:{default:[_a]},$$scope:{ctx:$}}}),Xe=new j({props:{title:"Using pipeline on large models with 🤗 accelerate :",local:"using-pipeline-on-large-models-with--accelerate-",headingTag:"h2"}}),Ye=new y({props:{code:"JTIzJTIwcGlwJTIwaW5zdGFsbCUyMGFjY2VsZXJhdGUlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBwaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMmZhY2Vib29rJTJGb3B0LTEuM2IlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIpJTBBb3V0cHV0JTIwJTNEJTIwcGlwZSglMjJUaGlzJTIwaXMlMjBhJTIwY29vbCUyMGV4YW1wbGUhJTIyJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUyMHRvcF9wJTNEMC45NSk=",highlighted:`<span class="hljs-comment"># pip install accelerate</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(model=<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
output = pipe(<span class="hljs-string">&quot;This is a cool example!&quot;</span>, do_sample=<span class="hljs-literal">True</span>, top_p=<span class="hljs-number">0.95</span>)`,wrap:!1}}),qe=new y({props:{code:"JTIzJTIwcGlwJTIwaW5zdGFsbCUyMGFjY2VsZXJhdGUlMjBiaXRzYW5kYnl0ZXMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBwaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMmZhY2Vib29rJTJGb3B0LTEuM2IlMjIlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUyQyUyMG1vZGVsX2t3YXJncyUzRCU3QiUyMmxvYWRfaW5fOGJpdCUyMiUzQSUyMFRydWUlN0QpJTBBb3V0cHV0JTIwJTNEJTIwcGlwZSglMjJUaGlzJTIwaXMlMjBhJTIwY29vbCUyMGV4YW1wbGUhJTIyJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUyMHRvcF9wJTNEMC45NSk=",highlighted:`<span class="hljs-comment"># pip install accelerate bitsandbytes</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(model=<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, model_kwargs={<span class="hljs-string">&quot;load_in_8bit&quot;</span>: <span class="hljs-literal">True</span>})
output = pipe(<span class="hljs-string">&quot;This is a cool example!&quot;</span>, do_sample=<span class="hljs-literal">True</span>, top_p=<span class="hljs-number">0.95</span>)`,wrap:!1}}),ze=new j({props:{title:"Creating web demos from pipelines with gradio",local:"creating-web-demos-from-pipelines-with-gradio",headingTag:"h2"}}),Le=new y({props:{code:"cGlwJTIwaW5zdGFsbCUyMGdyYWRpbw==",highlighted:'pip <span class="hljs-keyword">install</span> gradio',wrap:!1}}),Qe=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZSglMjJpbWFnZS1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyZ29vZ2xlJTJGdml0LWJhc2UtcGF0Y2gxNi0yMjQlMjIpJTBBJTBBZ3IuSW50ZXJmYWNlLmZyb21fcGlwZWxpbmUocGlwZSkubGF1bmNoKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

pipe = pipeline(<span class="hljs-string">&quot;image-classification&quot;</span>, model=<span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>)

gr.Interface.from_pipeline(pipe).launch()`,wrap:!1}}),Ae=new Ba({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/pipeline_tutorial.md"}}),{c(){f=i("meta"),M=l(),w=i("p"),T=l(),o(b.$$.fragment),g=l(),J=i("p"),J.innerHTML=Zt,Ke=l(),k=i("ul"),k.innerHTML=kt,Oe=l(),o(U.$$.fragment),es=l(),o(x.$$.fragment),ss=l(),G=i("p"),G.innerHTML=xt,ts=l(),B=i("ol"),B.innerHTML=Gt,as=l(),o(W.$$.fragment),ls=l(),v=i("ol"),v.innerHTML=Bt,ns=l(),o(C.$$.fragment),is=l(),_=i("p"),_.innerHTML=Wt,ps=l(),X=i("p"),X.innerHTML=Ct,rs=l(),H=i("p"),H.textContent=_t,os=l(),o(R.$$.fragment),cs=l(),Y=i("p"),Y.innerHTML=Xt,ms=l(),N=i("p"),N.textContent=Ht,hs=l(),o(q.$$.fragment),us=l(),V=i("p"),V.textContent=Rt,ds=l(),z=i("ul"),z.innerHTML=Yt,fs=l(),o(S.$$.fragment),ys=l(),L=i("p"),L.innerHTML=Nt,gs=l(),o(F.$$.fragment),ws=l(),Q=i("p"),Q.textContent=qt,Ms=l(),o(E.$$.fragment),Ts=l(),P=i("p"),P.innerHTML=Vt,js=l(),o(A.$$.fragment),bs=l(),D=i("p"),D.innerHTML=zt,Js=l(),o(K.$$.fragment),$s=l(),O=i("p"),O.textContent=St,Us=l(),o(ee.$$.fragment),vs=l(),se=i("p"),se.innerHTML=Lt,Is=l(),o(te.$$.fragment),Zs=l(),ae=i("p"),ae.innerHTML=Ft,ks=l(),le=i("p"),le.textContent=Qt,xs=l(),o(ne.$$.fragment),Gs=l(),ie=i("p"),ie.textContent=Et,Bs=l(),pe=i("p"),pe.innerHTML=Pt,Ws=l(),o(re.$$.fragment),Cs=l(),oe=i("p"),oe.innerHTML=At,_s=l(),o(ce.$$.fragment),Xs=l(),me=i("p"),me.innerHTML=Dt,Hs=l(),he=i("p"),he.innerHTML=Kt,Rs=l(),o(ue.$$.fragment),Ys=l(),de=i("p"),de.innerHTML=Ot,Ns=l(),o(fe.$$.fragment),qs=l(),ye=i("p"),ye.textContent=ea,Vs=l(),o(ge.$$.fragment),zs=l(),we=i("p"),we.innerHTML=sa,Ss=l(),Me=i("p"),Me.innerHTML=ta,Ls=l(),Te=i("p"),Te.innerHTML=aa,Fs=l(),o(je.$$.fragment),Qs=l(),o(be.$$.fragment),Es=l(),o(I.$$.fragment),Ps=l(),Je=i("p"),Je.innerHTML=la,As=l(),o($e.$$.fragment),Ds=l(),Ue=i("p"),Ue.innerHTML=na,Ks=l(),ve=i("p"),ve.textContent=ia,Os=l(),Ie=i("p"),Ie.innerHTML=pa,et=l(),o(Ze.$$.fragment),st=l(),o(ke.$$.fragment),tt=l(),xe=i("p"),xe.innerHTML=ra,at=l(),o(Ge.$$.fragment),lt=l(),o(Be.$$.fragment),nt=l(),We=i("p"),We.innerHTML=oa,it=l(),Ce=i("p"),Ce.innerHTML=ca,pt=l(),o(_e.$$.fragment),rt=l(),o(Z.$$.fragment),ot=l(),o(Xe.$$.fragment),ct=l(),He=i("p"),He.innerHTML=ma,mt=l(),Re=i("p"),Re.innerHTML=ha,ht=l(),o(Ye.$$.fragment),ut=l(),Ne=i("p"),Ne.innerHTML=ua,dt=l(),o(qe.$$.fragment),ft=l(),Ve=i("p"),Ve.textContent=da,yt=l(),o(ze.$$.fragment),gt=l(),Se=i("p"),Se.innerHTML=fa,wt=l(),o(Le.$$.fragment),Mt=l(),Fe=i("p"),Fe.innerHTML=ya,Tt=l(),o(Qe.$$.fragment),jt=l(),Ee=i("p"),Ee.innerHTML=ga,bt=l(),Pe=i("p"),Pe.innerHTML=wa,Jt=l(),o(Ae.$$.fragment),$t=l(),De=i("p"),this.h()},l(e){const s=Za("svelte-u9bgzb",document.head);f=p(s,"META",{name:!0,content:!0}),s.forEach(t),M=n(e),w=p(e,"P",{}),ba(w).forEach(t),T=n(e),c(b.$$.fragment,e),g=n(e),J=p(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-12rl1xs"&&(J.innerHTML=Zt),Ke=n(e),k=p(e,"UL",{"data-svelte-h":!0}),r(k)!=="svelte-1esgds8"&&(k.innerHTML=kt),Oe=n(e),c(U.$$.fragment,e),es=n(e),c(x.$$.fragment,e),ss=n(e),G=p(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1jwp57q"&&(G.innerHTML=xt),ts=n(e),B=p(e,"OL",{"data-svelte-h":!0}),r(B)!=="svelte-2x4cuo"&&(B.innerHTML=Gt),as=n(e),c(W.$$.fragment,e),ls=n(e),v=p(e,"OL",{start:!0,"data-svelte-h":!0}),r(v)!=="svelte-1ejxr00"&&(v.innerHTML=Bt),ns=n(e),c(C.$$.fragment,e),is=n(e),_=p(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-jt3v05"&&(_.innerHTML=Wt),ps=n(e),X=p(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1sbs9t3"&&(X.innerHTML=Ct),rs=n(e),H=p(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-5gg07s"&&(H.textContent=_t),os=n(e),c(R.$$.fragment,e),cs=n(e),Y=p(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1yjypga"&&(Y.innerHTML=Xt),ms=n(e),N=p(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1udq0dv"&&(N.textContent=Ht),hs=n(e),c(q.$$.fragment,e),us=n(e),V=p(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1y2bxsh"&&(V.textContent=Rt),ds=n(e),z=p(e,"UL",{"data-svelte-h":!0}),r(z)!=="svelte-boqb6q"&&(z.innerHTML=Yt),fs=n(e),c(S.$$.fragment,e),ys=n(e),L=p(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-zxe579"&&(L.innerHTML=Nt),gs=n(e),c(F.$$.fragment,e),ws=n(e),Q=p(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-e9485z"&&(Q.textContent=qt),Ms=n(e),c(E.$$.fragment,e),Ts=n(e),P=p(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-sob7ne"&&(P.innerHTML=Vt),js=n(e),c(A.$$.fragment,e),bs=n(e),D=p(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1tfx7co"&&(D.innerHTML=zt),Js=n(e),c(K.$$.fragment,e),$s=n(e),O=p(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-6riuku"&&(O.textContent=St),Us=n(e),c(ee.$$.fragment,e),vs=n(e),se=p(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1otna9r"&&(se.innerHTML=Lt),Is=n(e),c(te.$$.fragment,e),Zs=n(e),ae=p(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-v1mumi"&&(ae.innerHTML=Ft),ks=n(e),le=p(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1jutax8"&&(le.textContent=Qt),xs=n(e),c(ne.$$.fragment,e),Gs=n(e),ie=p(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-n3ouik"&&(ie.textContent=Et),Bs=n(e),pe=p(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-sq1wry"&&(pe.innerHTML=Pt),Ws=n(e),c(re.$$.fragment,e),Cs=n(e),oe=p(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-e4p3n0"&&(oe.innerHTML=At),_s=n(e),c(ce.$$.fragment,e),Xs=n(e),me=p(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1ad1wem"&&(me.innerHTML=Dt),Hs=n(e),he=p(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-14pptdg"&&(he.innerHTML=Kt),Rs=n(e),c(ue.$$.fragment,e),Ys=n(e),de=p(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1nowgzq"&&(de.innerHTML=Ot),Ns=n(e),c(fe.$$.fragment,e),qs=n(e),ye=p(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1sh6mg6"&&(ye.textContent=ea),Vs=n(e),c(ge.$$.fragment,e),zs=n(e),we=p(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1rrzg9"&&(we.innerHTML=sa),Ss=n(e),Me=p(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1litpj1"&&(Me.innerHTML=ta),Ls=n(e),Te=p(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1pgxdbs"&&(Te.innerHTML=aa),Fs=n(e),c(je.$$.fragment,e),Qs=n(e),c(be.$$.fragment,e),Es=n(e),c(I.$$.fragment,e),Ps=n(e),Je=p(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-52dmam"&&(Je.innerHTML=la),As=n(e),c($e.$$.fragment,e),Ds=n(e),Ue=p(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-qj1b8a"&&(Ue.innerHTML=na),Ks=n(e),ve=p(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-ip2z2f"&&(ve.textContent=ia),Os=n(e),Ie=p(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-1bks2jw"&&(Ie.innerHTML=pa),et=n(e),c(Ze.$$.fragment,e),st=n(e),c(ke.$$.fragment,e),tt=n(e),xe=p(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-1mwkyhe"&&(xe.innerHTML=ra),at=n(e),c(Ge.$$.fragment,e),lt=n(e),c(Be.$$.fragment,e),nt=n(e),We=p(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-1wyhtg1"&&(We.innerHTML=oa),it=n(e),Ce=p(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-4s0csr"&&(Ce.innerHTML=ca),pt=n(e),c(_e.$$.fragment,e),rt=n(e),c(Z.$$.fragment,e),ot=n(e),c(Xe.$$.fragment,e),ct=n(e),He=p(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-32c7q2"&&(He.innerHTML=ma),mt=n(e),Re=p(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-1yg483v"&&(Re.innerHTML=ha),ht=n(e),c(Ye.$$.fragment,e),ut=n(e),Ne=p(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-1c9ycn6"&&(Ne.innerHTML=ua),dt=n(e),c(qe.$$.fragment,e),ft=n(e),Ve=p(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-frv3wv"&&(Ve.textContent=da),yt=n(e),c(ze.$$.fragment,e),gt=n(e),Se=p(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-hf8ov5"&&(Se.innerHTML=fa),wt=n(e),c(Le.$$.fragment,e),Mt=n(e),Fe=p(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-191d3mo"&&(Fe.innerHTML=ya),Tt=n(e),c(Qe.$$.fragment,e),jt=n(e),Ee=p(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-rjj5jb"&&(Ee.innerHTML=ga),bt=n(e),Pe=p(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-efanlv"&&(Pe.innerHTML=wa),Jt=n(e),c(Ae.$$.fragment,e),$t=n(e),De=p(e,"P",{}),ba(De).forEach(t),this.h()},h(){vt(f,"name","hf:doc:metadata"),vt(f,"content",Ha),vt(v,"start","2")},m(e,s){ka(document.head,f),a(e,M,s),a(e,w,s),a(e,T,s),m(b,e,s),a(e,g,s),a(e,J,s),a(e,Ke,s),a(e,k,s),a(e,Oe,s),m(U,e,s),a(e,es,s),m(x,e,s),a(e,ss,s),a(e,G,s),a(e,ts,s),a(e,B,s),a(e,as,s),m(W,e,s),a(e,ls,s),a(e,v,s),a(e,ns,s),m(C,e,s),a(e,is,s),a(e,_,s),a(e,ps,s),a(e,X,s),a(e,rs,s),a(e,H,s),a(e,os,s),m(R,e,s),a(e,cs,s),a(e,Y,s),a(e,ms,s),a(e,N,s),a(e,hs,s),m(q,e,s),a(e,us,s),a(e,V,s),a(e,ds,s),a(e,z,s),a(e,fs,s),m(S,e,s),a(e,ys,s),a(e,L,s),a(e,gs,s),m(F,e,s),a(e,ws,s),a(e,Q,s),a(e,Ms,s),m(E,e,s),a(e,Ts,s),a(e,P,s),a(e,js,s),m(A,e,s),a(e,bs,s),a(e,D,s),a(e,Js,s),m(K,e,s),a(e,$s,s),a(e,O,s),a(e,Us,s),m(ee,e,s),a(e,vs,s),a(e,se,s),a(e,Is,s),m(te,e,s),a(e,Zs,s),a(e,ae,s),a(e,ks,s),a(e,le,s),a(e,xs,s),m(ne,e,s),a(e,Gs,s),a(e,ie,s),a(e,Bs,s),a(e,pe,s),a(e,Ws,s),m(re,e,s),a(e,Cs,s),a(e,oe,s),a(e,_s,s),m(ce,e,s),a(e,Xs,s),a(e,me,s),a(e,Hs,s),a(e,he,s),a(e,Rs,s),m(ue,e,s),a(e,Ys,s),a(e,de,s),a(e,Ns,s),m(fe,e,s),a(e,qs,s),a(e,ye,s),a(e,Vs,s),m(ge,e,s),a(e,zs,s),a(e,we,s),a(e,Ss,s),a(e,Me,s),a(e,Ls,s),a(e,Te,s),a(e,Fs,s),m(je,e,s),a(e,Qs,s),m(be,e,s),a(e,Es,s),m(I,e,s),a(e,Ps,s),a(e,Je,s),a(e,As,s),m($e,e,s),a(e,Ds,s),a(e,Ue,s),a(e,Ks,s),a(e,ve,s),a(e,Os,s),a(e,Ie,s),a(e,et,s),m(Ze,e,s),a(e,st,s),m(ke,e,s),a(e,tt,s),a(e,xe,s),a(e,at,s),m(Ge,e,s),a(e,lt,s),m(Be,e,s),a(e,nt,s),a(e,We,s),a(e,it,s),a(e,Ce,s),a(e,pt,s),m(_e,e,s),a(e,rt,s),m(Z,e,s),a(e,ot,s),m(Xe,e,s),a(e,ct,s),a(e,He,s),a(e,mt,s),a(e,Re,s),a(e,ht,s),m(Ye,e,s),a(e,ut,s),a(e,Ne,s),a(e,dt,s),m(qe,e,s),a(e,ft,s),a(e,Ve,s),a(e,yt,s),m(ze,e,s),a(e,gt,s),a(e,Se,s),a(e,wt,s),m(Le,e,s),a(e,Mt,s),a(e,Fe,s),a(e,Tt,s),m(Qe,e,s),a(e,jt,s),a(e,Ee,s),a(e,bt,s),a(e,Pe,s),a(e,Jt,s),m(Ae,e,s),a(e,$t,s),a(e,De,s),Ut=!0},p(e,[s]){const Ma={};s&2&&(Ma.$$scope={dirty:s,ctx:e}),U.$set(Ma);const Ta={};s&2&&(Ta.$$scope={dirty:s,ctx:e}),I.$set(Ta);const ja={};s&2&&(ja.$$scope={dirty:s,ctx:e}),Z.$set(ja)},i(e){Ut||(h(b.$$.fragment,e),h(U.$$.fragment,e),h(x.$$.fragment,e),h(W.$$.fragment,e),h(C.$$.fragment,e),h(R.$$.fragment,e),h(q.$$.fragment,e),h(S.$$.fragment,e),h(F.$$.fragment,e),h(E.$$.fragment,e),h(A.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),h(te.$$.fragment,e),h(ne.$$.fragment,e),h(re.$$.fragment,e),h(ce.$$.fragment,e),h(ue.$$.fragment,e),h(fe.$$.fragment,e),h(ge.$$.fragment,e),h(je.$$.fragment,e),h(be.$$.fragment,e),h(I.$$.fragment,e),h($e.$$.fragment,e),h(Ze.$$.fragment,e),h(ke.$$.fragment,e),h(Ge.$$.fragment,e),h(Be.$$.fragment,e),h(_e.$$.fragment,e),h(Z.$$.fragment,e),h(Xe.$$.fragment,e),h(Ye.$$.fragment,e),h(qe.$$.fragment,e),h(ze.$$.fragment,e),h(Le.$$.fragment,e),h(Qe.$$.fragment,e),h(Ae.$$.fragment,e),Ut=!0)},o(e){u(b.$$.fragment,e),u(U.$$.fragment,e),u(x.$$.fragment,e),u(W.$$.fragment,e),u(C.$$.fragment,e),u(R.$$.fragment,e),u(q.$$.fragment,e),u(S.$$.fragment,e),u(F.$$.fragment,e),u(E.$$.fragment,e),u(A.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),u(te.$$.fragment,e),u(ne.$$.fragment,e),u(re.$$.fragment,e),u(ce.$$.fragment,e),u(ue.$$.fragment,e),u(fe.$$.fragment,e),u(ge.$$.fragment,e),u(je.$$.fragment,e),u(be.$$.fragment,e),u(I.$$.fragment,e),u($e.$$.fragment,e),u(Ze.$$.fragment,e),u(ke.$$.fragment,e),u(Ge.$$.fragment,e),u(Be.$$.fragment,e),u(_e.$$.fragment,e),u(Z.$$.fragment,e),u(Xe.$$.fragment,e),u(Ye.$$.fragment,e),u(qe.$$.fragment,e),u(ze.$$.fragment,e),u(Le.$$.fragment,e),u(Qe.$$.fragment,e),u(Ae.$$.fragment,e),Ut=!1},d(e){e&&(t(M),t(w),t(T),t(g),t(J),t(Ke),t(k),t(Oe),t(es),t(ss),t(G),t(ts),t(B),t(as),t(ls),t(v),t(ns),t(is),t(_),t(ps),t(X),t(rs),t(H),t(os),t(cs),t(Y),t(ms),t(N),t(hs),t(us),t(V),t(ds),t(z),t(fs),t(ys),t(L),t(gs),t(ws),t(Q),t(Ms),t(Ts),t(P),t(js),t(bs),t(D),t(Js),t($s),t(O),t(Us),t(vs),t(se),t(Is),t(Zs),t(ae),t(ks),t(le),t(xs),t(Gs),t(ie),t(Bs),t(pe),t(Ws),t(Cs),t(oe),t(_s),t(Xs),t(me),t(Hs),t(he),t(Rs),t(Ys),t(de),t(Ns),t(qs),t(ye),t(Vs),t(zs),t(we),t(Ss),t(Me),t(Ls),t(Te),t(Fs),t(Qs),t(Es),t(Ps),t(Je),t(As),t(Ds),t(Ue),t(Ks),t(ve),t(Os),t(Ie),t(et),t(st),t(tt),t(xe),t(at),t(lt),t(nt),t(We),t(it),t(Ce),t(pt),t(rt),t(ot),t(ct),t(He),t(mt),t(Re),t(ht),t(ut),t(Ne),t(dt),t(ft),t(Ve),t(yt),t(gt),t(Se),t(wt),t(Mt),t(Fe),t(Tt),t(jt),t(Ee),t(bt),t(Pe),t(Jt),t($t),t(De)),t(f),d(b,e),d(U,e),d(x,e),d(W,e),d(C,e),d(R,e),d(q,e),d(S,e),d(F,e),d(E,e),d(A,e),d(K,e),d(ee,e),d(te,e),d(ne,e),d(re,e),d(ce,e),d(ue,e),d(fe,e),d(ge,e),d(je,e),d(be,e),d(I,e),d($e,e),d(Ze,e),d(ke,e),d(Ge,e),d(Be,e),d(_e,e),d(Z,e),d(Xe,e),d(Ye,e),d(qe,e),d(ze,e),d(Le,e),d(Qe,e),d(Ae,e)}}}const Ha='{"title":"Pipelines for inference","local":"pipelines-for-inference","sections":[{"title":"Pipeline usage","local":"pipeline-usage","sections":[],"depth":2},{"title":"Parameters","local":"parameters","sections":[{"title":"Device","local":"device","sections":[],"depth":3},{"title":"Batch size","local":"batch-size","sections":[],"depth":3},{"title":"Task specific parameters","local":"task-specific-parameters","sections":[],"depth":3}],"depth":2},{"title":"Using pipelines on a dataset","local":"using-pipelines-on-a-dataset","sections":[],"depth":2},{"title":"Using pipelines for a webserver","local":"using-pipelines-for-a-webserver","sections":[],"depth":2},{"title":"Vision pipeline","local":"vision-pipeline","sections":[],"depth":2},{"title":"Text pipeline","local":"text-pipeline","sections":[],"depth":2},{"title":"Multimodal pipeline","local":"multimodal-pipeline","sections":[],"depth":2},{"title":"Using pipeline on large models with 🤗 accelerate :","local":"using-pipeline-on-large-models-with--accelerate-","sections":[],"depth":2},{"title":"Creating web demos from pipelines with gradio","local":"creating-web-demos-from-pipelines-with-gradio","sections":[],"depth":2}],"depth":1}';function Ra($){return Ua(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Sa extends va{constructor(f){super(),Ia(this,f,Ra,Xa,$a,{})}}export{Sa as component};
