import{s as Ah,o as Zh,n as x}from"../chunks/scheduler.6062bdaf.js";import{S as Nh,i as Wh,g as u,s as r,r as h,A as Gh,h as g,f as p,c as i,j as w,u as d,x as T,k as J,y as l,a as _,v as f,d as y,t as b,w as M}from"../chunks/index.4bca734e.js";import{T as A}from"../chunks/Tip.b9ac1f03.js";import{D as k}from"../chunks/Docstring.d7918b6d.js";import{C as q}from"../chunks/CodeBlock.fa01571c.js";import{E}from"../chunks/ExampleCodeBlock.d27cbfa4.js";import{H as it,E as Bh}from"../chunks/EditOnGithub.74ab2baa.js";function Qh(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmF1ZGlvX2NsYXNzaWZpY2F0aW9uKCUyMmF1ZGlvLmZsYWMlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.audio_classification(<span class="hljs-string">&quot;audio.flac&quot;</span>)
[
    AudioClassificationOutputElement(score=<span class="hljs-number">0.4976358711719513</span>, label=<span class="hljs-string">&#x27;hap&#x27;</span>),
    AudioClassificationOutputElement(score=<span class="hljs-number">0.3677836060523987</span>, label=<span class="hljs-string">&#x27;neu&#x27;</span>),
    ...
]`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Vh(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBYXVkaW9fb3V0cHV0JTIwJTNEJTIwY2xpZW50LmF1ZGlvX3RvX2F1ZGlvKCUyMmF1ZGlvLmZsYWMlMjIpJTBBZm9yJTIwaSUyQyUyMGl0ZW0lMjBpbiUyMGVudW1lcmF0ZShhdWRpb19vdXRwdXQpJTNBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMG9wZW4oZiUyMm91dHB1dF8lN0JpJTdELmZsYWMlMjIlMkMlMjAlMjJ3YiUyMiklMjBhcyUyMGYlM0E=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_output = client.audio_to_audio(<span class="hljs-string">&quot;audio.flac&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, item <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(audio_output):
<span class="hljs-meta">&gt;&gt;&gt; </span>    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">f&quot;output_<span class="hljs-subst">{i}</span>.flac&quot;</span>, <span class="hljs-string">&quot;wb&quot;</span>) <span class="hljs-keyword">as</span> f:
            f.write(item.blob)`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Yh(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmF1dG9tYXRpY19zcGVlY2hfcmVjb2duaXRpb24oJTIyaGVsbG9fd29ybGQuZmxhYyUyMikudGV4dA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.automatic_speech_recognition(<span class="hljs-string">&quot;hello_world.flac&quot;</span>).text
<span class="hljs-string">&quot;hello world&quot;</span>`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Sh(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"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",highlighted:`<span class="hljs-comment"># Chat example</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>}]
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.chat_completion(messages, max_tokens=<span class="hljs-number">100</span>)
ChatCompletionOutput(
    choices=[
        ChatCompletionOutputComplete(
            finish_reason=<span class="hljs-string">&#x27;eos_token&#x27;</span>,
            index=<span class="hljs-number">0</span>,
            message=ChatCompletionOutputMessage(
                role=<span class="hljs-string">&#x27;assistant&#x27;</span>,
                content=<span class="hljs-string">&#x27;The capital of France is Paris.&#x27;</span>,
                name=<span class="hljs-literal">None</span>,
                tool_calls=<span class="hljs-literal">None</span>
            ),
            logprobs=<span class="hljs-literal">None</span>
        )
    ],
    created=<span class="hljs-number">1719907176</span>,
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&#x27;&#x27;</span>,
    model=<span class="hljs-string">&#x27;meta-llama/Meta-Llama-3-8B-Instruct&#x27;</span>,
    <span class="hljs-built_in">object</span>=<span class="hljs-string">&#x27;text_completion&#x27;</span>,
    system_fingerprint=<span class="hljs-string">&#x27;2.0.4-sha-f426a33&#x27;</span>,
    usage=ChatCompletionOutputUsage(
        completion_tokens=<span class="hljs-number">8</span>,
        prompt_tokens=<span class="hljs-number">17</span>,
        total_tokens=<span class="hljs-number">25</span>
    )
)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> client.chat_completion(messages, max_tokens=<span class="hljs-number">10</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(token)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=<span class="hljs-string">&#x27;The&#x27;</span>, role=<span class="hljs-string">&#x27;assistant&#x27;</span>), index=<span class="hljs-number">0</span>, finish_reason=<span class="hljs-literal">None</span>)], created=<span class="hljs-number">1710498504</span>)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=<span class="hljs-string">&#x27; capital&#x27;</span>, role=<span class="hljs-string">&#x27;assistant&#x27;</span>), index=<span class="hljs-number">0</span>, finish_reason=<span class="hljs-literal">None</span>)], created=<span class="hljs-number">1710498504</span>)
(...)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=<span class="hljs-string">&#x27; may&#x27;</span>, role=<span class="hljs-string">&#x27;assistant&#x27;</span>), index=<span class="hljs-number">0</span>, finish_reason=<span class="hljs-literal">None</span>)], created=<span class="hljs-number">1710498504</span>)

<span class="hljs-comment"># Chat example with tools</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Don&#x27;t make assumptions about what values to plug into functions. Ask for clarification if a user request is ambiguous.&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What&#x27;s the weather like the next 3 days in San Francisco, CA?&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>tools = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;function&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_weather&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get the current weather&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;parameters&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;location&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The city and state, e.g. San Francisco, CA&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;format&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;enum&quot;</span>: [<span class="hljs-string">&quot;celsius&quot;</span>, <span class="hljs-string">&quot;fahrenheit&quot;</span>],
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The temperature unit to use. Infer this from the users location.&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;format&quot;</span>],
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;function&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_n_day_weather_forecast&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get an N-day weather forecast&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;parameters&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;location&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The city and state, e.g. San Francisco, CA&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;format&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;enum&quot;</span>: [<span class="hljs-string">&quot;celsius&quot;</span>, <span class="hljs-string">&quot;fahrenheit&quot;</span>],
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The temperature unit to use. Infer this from the users location.&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;num_days&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The number of days to forecast&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;format&quot;</span>, <span class="hljs-string">&quot;num_days&quot;</span>],
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>response = client.chat_completion(
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>,
<span class="hljs-meta">... </span>    messages=messages,
<span class="hljs-meta">... </span>    tools=tools,
<span class="hljs-meta">... </span>    tool_choice=<span class="hljs-string">&quot;auto&quot;</span>,
<span class="hljs-meta">... </span>    max_tokens=<span class="hljs-number">500</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.choices[<span class="hljs-number">0</span>].message.tool_calls[<span class="hljs-number">0</span>].function
ChatCompletionOutputFunctionDefinition(
    arguments={
        <span class="hljs-string">&#x27;location&#x27;</span>: <span class="hljs-string">&#x27;San Francisco, CA&#x27;</span>,
        <span class="hljs-string">&#x27;format&#x27;</span>: <span class="hljs-string">&#x27;fahrenheit&#x27;</span>,
        <span class="hljs-string">&#x27;num_days&#x27;</span>: <span class="hljs-number">3</span>
    },
    name=<span class="hljs-string">&#x27;get_n_day_weather_forecast&#x27;</span>,
    description=<span class="hljs-literal">None</span>
)`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Rh(I){let n,m=`<a href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceClient.conversational">InferenceClient.conversational()</a> API is deprecated and will be removed in a future release. Please use
<a href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceClient.chat_completion">InferenceClient.chat_completion()</a> instead.`;return{c(){n=u("p"),n.innerHTML=m},l(a){n=g(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1wqrwgc"&&(n.innerHTML=m)},m(a,t){_(a,n,t)},p:x,d(a){a&&p(n)}}}function Dh(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBb3V0cHV0JTIwJTNEJTIwY2xpZW50LmNvbnZlcnNhdGlvbmFsKCUyMkhpJTJDJTIwd2hvJTIwYXJlJTIweW91JTNGJTIyKSUwQW91dHB1dCUwQWNsaWVudC5jb252ZXJzYXRpb25hbCglMEElMjAlMjAlMjAlMjAlMjJXb3clMkMlMjB0aGF0J3MlMjBzY2FyeSElMjIlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0ZWRfcmVzcG9uc2VzJTNEb3V0cHV0JTVCJTIyY29udmVyc2F0aW9uJTIyJTVEJTVCJTIyZ2VuZXJhdGVkX3Jlc3BvbnNlcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHBhc3RfdXNlcl9pbnB1dHMlM0RvdXRwdXQlNUIlMjJjb252ZXJzYXRpb24lMjIlNUQlNUIlMjJwYXN0X3VzZXJfaW5wdXRzJTIyJTVEJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>output = client.conversational(<span class="hljs-string">&quot;Hi, who are you?&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output
{<span class="hljs-string">&#x27;generated_text&#x27;</span>: <span class="hljs-string">&#x27;I am the one who knocks.&#x27;</span>, <span class="hljs-string">&#x27;conversation&#x27;</span>: {<span class="hljs-string">&#x27;generated_responses&#x27;</span>: [<span class="hljs-string">&#x27;I am the one who knocks.&#x27;</span>], <span class="hljs-string">&#x27;past_user_inputs&#x27;</span>: [<span class="hljs-string">&#x27;Hi, who are you?&#x27;</span>]}, <span class="hljs-string">&#x27;warnings&#x27;</span>: [<span class="hljs-string">&#x27;Setting \`pad_token_id\` to \`eos_token_id\`:50256 for open-end generation.&#x27;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>client.conversational(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Wow, that&#x27;s scary!&quot;</span>,
<span class="hljs-meta">... </span>    generated_responses=output[<span class="hljs-string">&quot;conversation&quot;</span>][<span class="hljs-string">&quot;generated_responses&quot;</span>],
<span class="hljs-meta">... </span>    past_user_inputs=output[<span class="hljs-string">&quot;conversation&quot;</span>][<span class="hljs-string">&quot;past_user_inputs&quot;</span>],
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Xh(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmRvY3VtZW50X3F1ZXN0aW9uX2Fuc3dlcmluZyhpbWFnZSUzRCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZzcGFjZXMlMkZpbXBpcmElMkZkb2NxdWVyeSUyRnJlc29sdmUlMkYyMzU5MjIzYzE4MzdhNzU4NzQwMmJkYTBmMjY0MzM4MmE2ZWVmZWFiJTJGaW52b2ljZS5wbmclMjIlMkMlMjBxdWVzdGlvbiUzRCUyMldoYXQlMjBpcyUyMHRoZSUyMGludm9pY2UlMjBudW1iZXIlM0YlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.document_question_answering(image=<span class="hljs-string">&quot;https://huggingface.co/spaces/impira/docquery/resolve/2359223c1837a7587402bda0f2643382a6eefeab/invoice.png&quot;</span>, question=<span class="hljs-string">&quot;What is the invoice number?&quot;</span>)
[DocumentQuestionAnsweringOutputElement(score=<span class="hljs-number">0.42515629529953003</span>, answer=<span class="hljs-string">&#x27;us-001&#x27;</span>, start=<span class="hljs-number">16</span>, end=<span class="hljs-number">16</span>)]`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Hh(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmZlYXR1cmVfZXh0cmFjdGlvbiglMjJIaSUyQyUyMHdobyUyMGFyZSUyMHlvdSUzRiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.feature_extraction(<span class="hljs-string">&quot;Hi, who are you?&quot;</span>)
array([[ <span class="hljs-number">2.424802</span>  ,  <span class="hljs-number">2.93384</span>   ,  <span class="hljs-number">1.1750331</span> , ...,  <span class="hljs-number">1.240499</span>, -<span class="hljs-number">0.13776633</span>, -<span class="hljs-number">0.7889173</span> ],
[-<span class="hljs-number">0.42943227</span>, -<span class="hljs-number">0.6364878</span> , -<span class="hljs-number">1.693462</span>  , ...,  <span class="hljs-number">0.41978157</span>, -<span class="hljs-number">2.4336355</span> ,  <span class="hljs-number">0.6162071</span> ],
...,
[ <span class="hljs-number">0.28552425</span>, -<span class="hljs-number">0.928395</span>  , -<span class="hljs-number">1.2077185</span> , ...,  <span class="hljs-number">0.76810825</span>, -<span class="hljs-number">2.1069427</span> ,  <span class="hljs-number">0.6236161</span> ]], dtype=float32)`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function zh(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmZpbGxfbWFzayglMjJUaGUlMjBnb2FsJTIwb2YlMjBsaWZlJTIwaXMlMjAlM0NtYXNrJTNFLiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.fill_mask(<span class="hljs-string">&quot;The goal of life is &lt;mask&gt;.&quot;</span>)
[
    FillMaskOutputElement(score=<span class="hljs-number">0.06897063553333282</span>, token=<span class="hljs-number">11098</span>, token_str=<span class="hljs-string">&#x27; happiness&#x27;</span>, sequence=<span class="hljs-string">&#x27;The goal of life is happiness.&#x27;</span>),
    FillMaskOutputElement(score=<span class="hljs-number">0.06554922461509705</span>, token=<span class="hljs-number">45075</span>, token_str=<span class="hljs-string">&#x27; immortality&#x27;</span>, sequence=<span class="hljs-string">&#x27;The goal of life is immortality.&#x27;</span>)
]`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Fh(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMjJtZXRhLWxsYW1hJTJGTWV0YS1MbGFtYS0zLTcwQi1JbnN0cnVjdCUyMiklMEFjbGllbnQuZ2V0X2VuZHBvaW50X2luZm8oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.get_endpoint_info()
{
    <span class="hljs-string">&#x27;model_id&#x27;</span>: <span class="hljs-string">&#x27;meta-llama/Meta-Llama-3-70B-Instruct&#x27;</span>,
    <span class="hljs-string">&#x27;model_sha&#x27;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&#x27;model_dtype&#x27;</span>: <span class="hljs-string">&#x27;torch.float16&#x27;</span>,
    <span class="hljs-string">&#x27;model_device_type&#x27;</span>: <span class="hljs-string">&#x27;cuda&#x27;</span>,
    <span class="hljs-string">&#x27;model_pipeline_tag&#x27;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&#x27;max_concurrent_requests&#x27;</span>: <span class="hljs-number">128</span>,
    <span class="hljs-string">&#x27;max_best_of&#x27;</span>: <span class="hljs-number">2</span>,
    <span class="hljs-string">&#x27;max_stop_sequences&#x27;</span>: <span class="hljs-number">4</span>,
    <span class="hljs-string">&#x27;max_input_length&#x27;</span>: <span class="hljs-number">8191</span>,
    <span class="hljs-string">&#x27;max_total_tokens&#x27;</span>: <span class="hljs-number">8192</span>,
    <span class="hljs-string">&#x27;waiting_served_ratio&#x27;</span>: <span class="hljs-number">0.3</span>,
    <span class="hljs-string">&#x27;max_batch_total_tokens&#x27;</span>: <span class="hljs-number">1259392</span>,
    <span class="hljs-string">&#x27;max_waiting_tokens&#x27;</span>: <span class="hljs-number">20</span>,
    <span class="hljs-string">&#x27;max_batch_size&#x27;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&#x27;validation_workers&#x27;</span>: <span class="hljs-number">32</span>,
    <span class="hljs-string">&#x27;max_client_batch_size&#x27;</span>: <span class="hljs-number">4</span>,
    <span class="hljs-string">&#x27;version&#x27;</span>: <span class="hljs-string">&#x27;2.0.2&#x27;</span>,
    <span class="hljs-string">&#x27;sha&#x27;</span>: <span class="hljs-string">&#x27;dccab72549635c7eb5ddb17f43f0b7cdff07c214&#x27;</span>,
    <span class="hljs-string">&#x27;docker_label&#x27;</span>: <span class="hljs-string">&#x27;sha-dccab72&#x27;</span>
}`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Lh(I){let n,m=`This endpoint is mostly useful when you already know which model you want to use and want to check its
availability. If you want to discover already deployed models, you should rather use <a href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceClient.list_deployed_models">list_deployed_models()</a>.`;return{c(){n=u("p"),n.innerHTML=m},l(a){n=g(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-lzhzod"&&(n.innerHTML=m)},m(a,t){_(a,n,t)},p:x,d(a){a&&p(n)}}}function Oh(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmdldF9tb2RlbF9zdGF0dXMoJTIyYmlnY29kZSUyRnN0YXJjb2RlciUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.get_model_status(<span class="hljs-string">&quot;bigcode/starcoder&quot;</span>)
ModelStatus(loaded=<span class="hljs-literal">True</span>, state=<span class="hljs-string">&#x27;Loaded&#x27;</span>, compute_type=<span class="hljs-string">&#x27;gpu&#x27;</span>, framework=<span class="hljs-string">&#x27;text-generation-inference&#x27;</span>)`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Ph(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMjJodHRwcyUzQSUyRiUyRmp6Z3UwYnVlaTUudXMtZWFzdC0xLmF3cy5lbmRwb2ludHMuaHVnZ2luZ2ZhY2UuY2xvdWQlMjIpJTBBY2xpZW50LmhlYWx0aF9jaGVjaygp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(<span class="hljs-string">&quot;https://jzgu0buei5.us-east-1.aws.endpoints.huggingface.cloud&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.health_check()
<span class="hljs-literal">True</span>`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Kh(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmltYWdlX2NsYXNzaWZpY2F0aW9uKCUyMmh0dHBzJTNBJTJGJTJGdXBsb2FkLndpa2ltZWRpYS5vcmclMkZ3aWtpcGVkaWElMkZjb21tb25zJTJGdGh1bWIlMkY0JTJGNDMlMkZDdXRlX2RvZy5qcGclMkYzMjBweC1DdXRlX2RvZy5qcGclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.image_classification(<span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>)
[ImageClassificationOutputElement(score=<span class="hljs-number">0.9779096841812134</span>, label=<span class="hljs-string">&#x27;Blenheim spaniel&#x27;</span>), ...]`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function ed(I){let n,m="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=u("p"),n.innerHTML=m},l(a){n=g(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-s2e3n9"&&(n.innerHTML=m)},m(a,t){_(a,n,t)},p:x,d(a){a&&p(n)}}}function nd(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmltYWdlX3NlZ21lbnRhdGlvbiglMjJjYXQuanBnJTIyKSUzQQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.image_segmentation(<span class="hljs-string">&quot;cat.jpg&quot;</span>):
[ImageSegmentationOutputElement(score=<span class="hljs-number">0.989008</span>, label=<span class="hljs-string">&#x27;LABEL_184&#x27;</span>, mask=&lt;PIL.PngImagePlugin.PngImageFile image mode=L size=400x300 at <span class="hljs-number">0x7FDD2B129CC0</span>&gt;), ...]`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function td(I){let n,m="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=u("p"),n.innerHTML=m},l(a){n=g(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-s2e3n9"&&(n.innerHTML=m)},m(a,t){_(a,n,t)},p:x,d(a){a&&p(n)}}}function sd(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBaW1hZ2UlMjAlM0QlMjBjbGllbnQuaW1hZ2VfdG9faW1hZ2UoJTIyY2F0LmpwZyUyMiUyQyUyMHByb21wdCUzRCUyMnR1cm4lMjB0aGUlMjBjYXQlMjBpbnRvJTIwYSUyMHRpZ2VyJTIyKSUwQWltYWdlLnNhdmUoJTIydGlnZXIuanBnJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.image_to_image(<span class="hljs-string">&quot;cat.jpg&quot;</span>, prompt=<span class="hljs-string">&quot;turn the cat into a tiger&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;tiger.jpg&quot;</span>)`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function ad(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmltYWdlX3RvX3RleHQoJTIyY2F0LmpwZyUyMiklMEFjbGllbnQuaW1hZ2VfdG9fdGV4dCglMjJodHRwcyUzQSUyRiUyRnVwbG9hZC53aWtpbWVkaWEub3JnJTJGd2lraXBlZGlhJTJGY29tbW9ucyUyRnRodW1iJTJGNCUyRjQzJTJGQ3V0ZV9kb2cuanBnJTJGMzIwcHgtQ3V0ZV9kb2cuanBnJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.image_to_text(<span class="hljs-string">&quot;cat.jpg&quot;</span>)
<span class="hljs-string">&#x27;a cat standing in a grassy field &#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client.image_to_text(<span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>)
<span class="hljs-string">&#x27;a dog laying on the grass next to a flower pot &#x27;</span>`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function ld(I){let n,m=`This endpoint method does not return a live list of all models available for the Serverless Inference API service.
It searches over a cached list of models that were recently available and the list may not be up to date.
If you want to know the live status of a specific model, use <a href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceClient.get_model_status">get_model_status()</a>.`;return{c(){n=u("p"),n.innerHTML=m},l(a){n=g(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1vkbl5b"&&(n.innerHTML=m)},m(a,t){_(a,n,t)},p:x,d(a){a&&p(n)}}}function od(I){let n,m=`This endpoint method is mostly useful for discoverability. If you already know which model you want to use and want to
check its availability, you can directly use <a href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceClient.get_model_status">get_model_status()</a>.`;return{c(){n=u("p"),n.innerHTML=m},l(a){n=g(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1wivmlw"&&(n.innerHTML=m)},m(a,t){_(a,n,t)},p:x,d(a){a&&p(n)}}}function rd(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBJTBBbW9kZWxzJTIwJTNEJTIwY2xpZW50Lmxpc3RfZGVwbG95ZWRfbW9kZWxzKCklMEFtb2RlbHMlNUIlMjJ6ZXJvLXNob3QtY2xhc3NpZmljYXRpb24lMjIlNUQlMEElMEFjbGllbnQubGlzdF9kZXBsb3llZF9tb2RlbHMoJTIydGV4dC1nZW5lcmF0aW9uLWluZmVyZW5jZSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()

<span class="hljs-comment"># Discover zero-shot-classification models currently deployed</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>models = client.list_deployed_models()
<span class="hljs-meta">&gt;&gt;&gt; </span>models[<span class="hljs-string">&quot;zero-shot-classification&quot;</span>]
[<span class="hljs-string">&#x27;Narsil/deberta-large-mnli-zero-cls&#x27;</span>, <span class="hljs-string">&#x27;facebook/bart-large-mnli&#x27;</span>, ...]

<span class="hljs-comment"># List from only 1 framework</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client.list_deployed_models(<span class="hljs-string">&quot;text-generation-inference&quot;</span>)
{<span class="hljs-string">&#x27;text-generation&#x27;</span>: [<span class="hljs-string">&#x27;bigcode/starcoder&#x27;</span>, <span class="hljs-string">&#x27;meta-llama/Llama-2-70b-chat-hf&#x27;</span>, ...], ...}`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function id(I){let n,m="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=u("p"),n.innerHTML=m},l(a){n=g(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-s2e3n9"&&(n.innerHTML=m)},m(a,t){_(a,n,t)},p:x,d(a){a&&p(n)}}}function cd(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50Lm9iamVjdF9kZXRlY3Rpb24oJTIycGVvcGxlLmpwZyUyMiklM0E=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.object_detection(<span class="hljs-string">&quot;people.jpg&quot;</span>):
[ObjectDetectionOutputElement(score=<span class="hljs-number">0.9486683011054993</span>, label=<span class="hljs-string">&#x27;person&#x27;</span>, box=ObjectDetectionBoundingBox(xmin=<span class="hljs-number">59</span>, ymin=<span class="hljs-number">39</span>, xmax=<span class="hljs-number">420</span>, ymax=<span class="hljs-number">510</span>)), ...]`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function pd(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnF1ZXN0aW9uX2Fuc3dlcmluZyhxdWVzdGlvbiUzRCUyMldoYXQncyUyMG15JTIwbmFtZSUzRiUyMiUyQyUyMGNvbnRleHQlM0QlMjJNeSUyMG5hbWUlMjBpcyUyMENsYXJhJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyMEJlcmtlbGV5LiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.question_answering(question=<span class="hljs-string">&quot;What&#x27;s my name?&quot;</span>, context=<span class="hljs-string">&quot;My name is Clara and I live in Berkeley.&quot;</span>)
QuestionAnsweringOutputElement(score=<span class="hljs-number">0.9326562285423279</span>, start=<span class="hljs-number">11</span>, end=<span class="hljs-number">16</span>, answer=<span class="hljs-string">&#x27;Clara&#x27;</span>)`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function ud(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnNlbnRlbmNlX3NpbWlsYXJpdHkoJTBBJTIwJTIwJTIwJTIwJTIyTWFjaGluZSUyMGxlYXJuaW5nJTIwaXMlMjBzbyUyMGVhc3kuJTIyJTJDJTBBJTIwJTIwJTIwJTIwb3RoZXJfc2VudGVuY2VzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyRGVlcCUyMGxlYXJuaW5nJTIwaXMlMjBzbyUyMHN0cmFpZ2h0Zm9yd2FyZC4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJUaGlzJTIwaXMlMjBzbyUyMGRpZmZpY3VsdCUyQyUyMGxpa2UlMjByb2NrZXQlMjBzY2llbmNlLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkklMjBjYW4ndCUyMGJlbGlldmUlMjBob3clMjBtdWNoJTIwSSUyMHN0cnVnZ2xlZCUyMHdpdGglMjB0aGlzLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.sentence_similarity(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Machine learning is so easy.&quot;</span>,
<span class="hljs-meta">... </span>    other_sentences=[
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;Deep learning is so straightforward.&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;This is so difficult, like rocket science.&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;I can&#x27;t believe how much I struggled with this.&quot;</span>,
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>)
[<span class="hljs-number">0.7785726189613342</span>, <span class="hljs-number">0.45876261591911316</span>, <span class="hljs-number">0.2906220555305481</span>]`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function gd(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnN1bW1hcml6YXRpb24oJTIyVGhlJTIwRWlmZmVsJTIwdG93ZXIuLi4lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.summarization(<span class="hljs-string">&quot;The Eiffel tower...&quot;</span>)
SummarizationOutput(generated_text=<span class="hljs-string">&quot;The Eiffel tower is one of the most famous landmarks in the world....&quot;</span>)`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function md(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBcXVlcnklMjAlM0QlMjAlMjJIb3clMjBtYW55JTIwc3RhcnMlMjBkb2VzJTIwdGhlJTIwdHJhbnNmb3JtZXJzJTIwcmVwb3NpdG9yeSUyMGhhdmUlM0YlMjIlMEF0YWJsZSUyMCUzRCUyMCU3QiUyMlJlcG9zaXRvcnklMjIlM0ElMjAlNUIlMjJUcmFuc2Zvcm1lcnMlMjIlMkMlMjAlMjJEYXRhc2V0cyUyMiUyQyUyMCUyMlRva2VuaXplcnMlMjIlNUQlMkMlMjAlMjJTdGFycyUyMiUzQSUyMCU1QiUyMjM2NTQyJTIyJTJDJTIwJTIyNDUxMiUyMiUyQyUyMCUyMjM5MzQlMjIlNUQlN0QlMEFjbGllbnQudGFibGVfcXVlc3Rpb25fYW5zd2VyaW5nKHRhYmxlJTJDJTIwcXVlcnklMkMlMjBtb2RlbCUzRCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UtZmluZXR1bmVkLXd0cSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>query = <span class="hljs-string">&quot;How many stars does the transformers repository have?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {<span class="hljs-string">&quot;Repository&quot;</span>: [<span class="hljs-string">&quot;Transformers&quot;</span>, <span class="hljs-string">&quot;Datasets&quot;</span>, <span class="hljs-string">&quot;Tokenizers&quot;</span>], <span class="hljs-string">&quot;Stars&quot;</span>: [<span class="hljs-string">&quot;36542&quot;</span>, <span class="hljs-string">&quot;4512&quot;</span>, <span class="hljs-string">&quot;3934&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>client.table_question_answering(table, query, model=<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)
TableQuestionAnsweringOutputElement(answer=<span class="hljs-string">&#x27;36542&#x27;</span>, coordinates=[[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>]], cells=[<span class="hljs-string">&#x27;36542&#x27;</span>], aggregator=<span class="hljs-string">&#x27;AVERAGE&#x27;</span>)`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function hd(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBdGFibGUlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJmaXhlZF9hY2lkaXR5JTIyJTNBJTIwJTVCJTIyNy40JTIyJTJDJTIwJTIyNy44JTIyJTJDJTIwJTIyMTAuMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnZvbGF0aWxlX2FjaWRpdHklMjIlM0ElMjAlNUIlMjIwLjclMjIlMkMlMjAlMjIwLjg4JTIyJTJDJTIwJTIyMC4zMiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNpdHJpY19hY2lkJTIyJTNBJTIwJTVCJTIyMCUyMiUyQyUyMCUyMjAlMjIlMkMlMjAlMjIwLjQ1JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIycmVzaWR1YWxfc3VnYXIlMjIlM0ElMjAlNUIlMjIxLjklMjIlMkMlMjAlMjIyLjYlMjIlMkMlMjAlMjI2LjQlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJjaGxvcmlkZXMlMjIlM0ElMjAlNUIlMjIwLjA3NiUyMiUyQyUyMCUyMjAuMDk4JTIyJTJDJTIwJTIyMC4wNzMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJmcmVlX3N1bGZ1cl9kaW94aWRlJTIyJTNBJTIwJTVCJTIyMTElMjIlMkMlMjAlMjIyNSUyMiUyQyUyMCUyMjUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJ0b3RhbF9zdWxmdXJfZGlveGlkZSUyMiUzQSUyMCU1QiUyMjM0JTIyJTJDJTIwJTIyNjclMjIlMkMlMjAlMjIxMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmRlbnNpdHklMjIlM0ElMjAlNUIlMjIwLjk5NzglMjIlMkMlMjAlMjIwLjk5NjglMjIlMkMlMjAlMjIwLjk5NzYlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJwSCUyMiUzQSUyMCU1QiUyMjMuNTElMjIlMkMlMjAlMjIzLjIlMjIlMkMlMjAlMjIzLjIzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyc3VscGhhdGVzJTIyJTNBJTIwJTVCJTIyMC41NiUyMiUyQyUyMCUyMjAuNjglMjIlMkMlMjAlMjIwLjgyJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyYWxjb2hvbCUyMiUzQSUyMCU1QiUyMjkuNCUyMiUyQyUyMCUyMjkuOCUyMiUyQyUyMCUyMjEyLjYlMjIlNUQlMkMlMEElN0QlMEFjbGllbnQudGFidWxhcl9jbGFzc2lmaWNhdGlvbih0YWJsZSUzRHRhYmxlJTJDJTIwbW9kZWwlM0QlMjJqdWxpZW4tYyUyRndpbmUtcXVhbGl0eSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;fixed_acidity&quot;</span>: [<span class="hljs-string">&quot;7.4&quot;</span>, <span class="hljs-string">&quot;7.8&quot;</span>, <span class="hljs-string">&quot;10.3&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;volatile_acidity&quot;</span>: [<span class="hljs-string">&quot;0.7&quot;</span>, <span class="hljs-string">&quot;0.88&quot;</span>, <span class="hljs-string">&quot;0.32&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;citric_acid&quot;</span>: [<span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0.45&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;residual_sugar&quot;</span>: [<span class="hljs-string">&quot;1.9&quot;</span>, <span class="hljs-string">&quot;2.6&quot;</span>, <span class="hljs-string">&quot;6.4&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;chlorides&quot;</span>: [<span class="hljs-string">&quot;0.076&quot;</span>, <span class="hljs-string">&quot;0.098&quot;</span>, <span class="hljs-string">&quot;0.073&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;free_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;11&quot;</span>, <span class="hljs-string">&quot;25&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;total_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;34&quot;</span>, <span class="hljs-string">&quot;67&quot;</span>, <span class="hljs-string">&quot;13&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;density&quot;</span>: [<span class="hljs-string">&quot;0.9978&quot;</span>, <span class="hljs-string">&quot;0.9968&quot;</span>, <span class="hljs-string">&quot;0.9976&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;pH&quot;</span>: [<span class="hljs-string">&quot;3.51&quot;</span>, <span class="hljs-string">&quot;3.2&quot;</span>, <span class="hljs-string">&quot;3.23&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;sulphates&quot;</span>: [<span class="hljs-string">&quot;0.56&quot;</span>, <span class="hljs-string">&quot;0.68&quot;</span>, <span class="hljs-string">&quot;0.82&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;alcohol&quot;</span>: [<span class="hljs-string">&quot;9.4&quot;</span>, <span class="hljs-string">&quot;9.8&quot;</span>, <span class="hljs-string">&quot;12.6&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>client.tabular_classification(table=table, model=<span class="hljs-string">&quot;julien-c/wine-quality&quot;</span>)
[<span class="hljs-string">&quot;5&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>]`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function dd(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBdGFibGUlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJIZWlnaHQlMjIlM0ElMjAlNUIlMjIxMS41MiUyMiUyQyUyMCUyMjEyLjQ4JTIyJTJDJTIwJTIyMTIuMzc3OCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMkxlbmd0aDElMjIlM0ElMjAlNUIlMjIyMy4yJTIyJTJDJTIwJTIyMjQlMjIlMkMlMjAlMjIyMy45JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyTGVuZ3RoMiUyMiUzQSUyMCU1QiUyMjI1LjQlMjIlMkMlMjAlMjIyNi4zJTIyJTJDJTIwJTIyMjYuNSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMkxlbmd0aDMlMjIlM0ElMjAlNUIlMjIzMCUyMiUyQyUyMCUyMjMxLjIlMjIlMkMlMjAlMjIzMS4xJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyU3BlY2llcyUyMiUzQSUyMCU1QiUyMkJyZWFtJTIyJTJDJTIwJTIyQnJlYW0lMjIlMkMlMjAlMjJCcmVhbSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMldpZHRoJTIyJTNBJTIwJTVCJTIyNC4wMiUyMiUyQyUyMCUyMjQuMzA1NiUyMiUyQyUyMCUyMjQuNjk2MSUyMiU1RCUyQyUwQSU3RCUwQWNsaWVudC50YWJ1bGFyX3JlZ3Jlc3Npb24odGFibGUlMkMlMjBtb2RlbCUzRCUyMnNjaWtpdC1sZWFybiUyRkZpc2gtV2VpZ2h0JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Height&quot;</span>: [<span class="hljs-string">&quot;11.52&quot;</span>, <span class="hljs-string">&quot;12.48&quot;</span>, <span class="hljs-string">&quot;12.3778&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length1&quot;</span>: [<span class="hljs-string">&quot;23.2&quot;</span>, <span class="hljs-string">&quot;24&quot;</span>, <span class="hljs-string">&quot;23.9&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length2&quot;</span>: [<span class="hljs-string">&quot;25.4&quot;</span>, <span class="hljs-string">&quot;26.3&quot;</span>, <span class="hljs-string">&quot;26.5&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length3&quot;</span>: [<span class="hljs-string">&quot;30&quot;</span>, <span class="hljs-string">&quot;31.2&quot;</span>, <span class="hljs-string">&quot;31.1&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Species&quot;</span>: [<span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Width&quot;</span>: [<span class="hljs-string">&quot;4.02&quot;</span>, <span class="hljs-string">&quot;4.3056&quot;</span>, <span class="hljs-string">&quot;4.6961&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>client.tabular_regression(table, model=<span class="hljs-string">&quot;scikit-learn/Fish-Weight&quot;</span>)
[<span class="hljs-number">110</span>, <span class="hljs-number">120</span>, <span class="hljs-number">130</span>]`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function fd(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnRleHRfY2xhc3NpZmljYXRpb24oJTIySSUyMGxpa2UlMjB5b3UlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_classification(<span class="hljs-string">&quot;I like you&quot;</span>)
[
    TextClassificationOutputElement(label=<span class="hljs-string">&#x27;POSITIVE&#x27;</span>, score=<span class="hljs-number">0.9998695850372314</span>),
    TextClassificationOutputElement(label=<span class="hljs-string">&#x27;NEGATIVE&#x27;</span>, score=<span class="hljs-number">0.0001304351753788069</span>),
]`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function yd(I){let n,m=`If you want to generate a response from chat messages, you should use the <a href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceClient.chat_completion">InferenceClient.chat_completion()</a> method.
It accepts a list of messages instead of a single text prompt and handles the chat templating for you.`;return{c(){n=u("p"),n.innerHTML=m},l(a){n=g(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1eat4j1"&&(n.innerHTML=m)},m(a,t){_(a,n,t)},p:x,d(a){a&&p(n)}}}function bd(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()

<span class="hljs-comment"># Case 1: generate text</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>)
<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>

<span class="hljs-comment"># Case 2: iterate over the generated tokens. Useful for large generation.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(token)
<span class="hljs-number">100</span>
%
<span class="hljs-built_in">open</span>
source
<span class="hljs-keyword">and</span>
built
to
be
easy
to
use
.

<span class="hljs-comment"># Case 3: get more details about the generation process.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, details=<span class="hljs-literal">True</span>)
TextGenerationOutput(
    generated_text=<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>,
    details=TextGenerationDetails(
        finish_reason=<span class="hljs-string">&#x27;length&#x27;</span>,
        generated_tokens=<span class="hljs-number">12</span>,
        seed=<span class="hljs-literal">None</span>,
        prefill=[
            TextGenerationPrefillOutputToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">487</span>, text=<span class="hljs-string">&#x27;The&#x27;</span>, logprob=<span class="hljs-literal">None</span>),
            TextGenerationPrefillOutputToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">53789</span>, text=<span class="hljs-string">&#x27; hugging&#x27;</span>, logprob=-<span class="hljs-number">13.171875</span>),
            (...)
            TextGenerationPrefillOutputToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">204</span>, text=<span class="hljs-string">&#x27; &#x27;</span>, logprob=-<span class="hljs-number">7.0390625</span>)
        ],
        tokens=[
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1425</span>, text=<span class="hljs-string">&#x27;100&#x27;</span>, logprob=-<span class="hljs-number">1.0175781</span>, special=<span class="hljs-literal">False</span>),
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">16</span>, text=<span class="hljs-string">&#x27;%&#x27;</span>, logprob=-<span class="hljs-number">0.0463562</span>, special=<span class="hljs-literal">False</span>),
            (...)
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">25</span>, text=<span class="hljs-string">&#x27;.&#x27;</span>, logprob=-<span class="hljs-number">0.5703125</span>, special=<span class="hljs-literal">False</span>)
        ],
        best_of_sequences=<span class="hljs-literal">None</span>
    )
)

<span class="hljs-comment"># Case 4: iterate over the generated tokens with more details.</span>
<span class="hljs-comment"># Last object is more complete, containing the full generated text and the finish reason.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> details <span class="hljs-keyword">in</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, details=<span class="hljs-literal">True</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(details)
...
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1425</span>, text=<span class="hljs-string">&#x27;100&#x27;</span>, logprob=-<span class="hljs-number">1.0175781</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">16</span>, text=<span class="hljs-string">&#x27;%&#x27;</span>, logprob=-<span class="hljs-number">0.0463562</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1314</span>, text=<span class="hljs-string">&#x27; open&#x27;</span>, logprob=-<span class="hljs-number">1.3359375</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">3178</span>, text=<span class="hljs-string">&#x27; source&#x27;</span>, logprob=-<span class="hljs-number">0.28100586</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">273</span>, text=<span class="hljs-string">&#x27; and&#x27;</span>, logprob=-<span class="hljs-number">0.5961914</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">3426</span>, text=<span class="hljs-string">&#x27; built&#x27;</span>, logprob=-<span class="hljs-number">1.9423828</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">271</span>, text=<span class="hljs-string">&#x27; to&#x27;</span>, logprob=-<span class="hljs-number">1.4121094</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">314</span>, text=<span class="hljs-string">&#x27; be&#x27;</span>, logprob=-<span class="hljs-number">1.5224609</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1833</span>, text=<span class="hljs-string">&#x27; easy&#x27;</span>, logprob=-<span class="hljs-number">2.1132812</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">271</span>, text=<span class="hljs-string">&#x27; to&#x27;</span>, logprob=-<span class="hljs-number">0.08520508</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">745</span>, text=<span class="hljs-string">&#x27; use&#x27;</span>, logprob=-<span class="hljs-number">0.39453125</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(
    <span class="hljs-built_in">id</span>=<span class="hljs-number">25</span>,
    text=<span class="hljs-string">&#x27;.&#x27;</span>,
    logprob=-<span class="hljs-number">0.5703125</span>,
    special=<span class="hljs-literal">False</span>),
    generated_text=<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>,
    details=TextGenerationStreamOutputStreamDetails(finish_reason=<span class="hljs-string">&#x27;length&#x27;</span>, generated_tokens=<span class="hljs-number">12</span>, seed=<span class="hljs-literal">None</span>)
)

<span class="hljs-comment"># Case 5: generate constrained output using grammar</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>response = client.text_generation(
<span class="hljs-meta">... </span>    prompt=<span class="hljs-string">&quot;I saw a puppy a cat and a raccoon during my bike ride in the park&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;HuggingFaceH4/zephyr-orpo-141b-A35b-v0.1&quot;</span>,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    repetition_penalty=<span class="hljs-number">1.3</span>,
<span class="hljs-meta">... </span>    grammar={
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;json&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;value&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;activity&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;animals_seen&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>, <span class="hljs-string">&quot;minimum&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;maximum&quot;</span>: <span class="hljs-number">5</span>},
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;animals&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;array&quot;</span>, <span class="hljs-string">&quot;items&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}},
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;activity&quot;</span>, <span class="hljs-string">&quot;animals_seen&quot;</span>, <span class="hljs-string">&quot;animals&quot;</span>],
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>json.loads(response)
{
    <span class="hljs-string">&quot;activity&quot;</span>: <span class="hljs-string">&quot;bike riding&quot;</span>,
    <span class="hljs-string">&quot;animals&quot;</span>: [<span class="hljs-string">&quot;puppy&quot;</span>, <span class="hljs-string">&quot;cat&quot;</span>, <span class="hljs-string">&quot;raccoon&quot;</span>],
    <span class="hljs-string">&quot;animals_seen&quot;</span>: <span class="hljs-number">3</span>,
    <span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;park&quot;</span>
}`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Md(I){let n,m="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=u("p"),n.innerHTML=m},l(a){n=g(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-s2e3n9"&&(n.innerHTML=m)},m(a,t){_(a,n,t)},p:x,d(a){a&&p(n)}}}function jd(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBJTBBaW1hZ2UlMjAlM0QlMjBjbGllbnQudGV4dF90b19pbWFnZSglMjJBbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwdGhlJTIwbW9vbi4lMjIpJTBBaW1hZ2Uuc2F2ZSglMjJhc3Ryb25hdXQucG5nJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwY2xpZW50LnRleHRfdG9faW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyQW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyMHRoZSUyMG1vb24uJTIyJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEJTIybG93JTIwcmVzb2x1dGlvbiUyQyUyMGJsdXJyeSUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUwQSklMEFpbWFnZS5zYXZlKCUyMmJldHRlcl9hc3Ryb25hdXQucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.text_to_image(<span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;astronaut.png&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.text_to_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>,
<span class="hljs-meta">... </span>    negative_prompt=<span class="hljs-string">&quot;low resolution, blurry&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;better_astronaut.png&quot;</span>)`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function _d(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBJTBBYXVkaW8lMjAlM0QlMjBjbGllbnQudGV4dF90b19zcGVlY2goJTIySGVsbG8lMjB3b3JsZCUyMiklMEFQYXRoKCUyMmhlbGxvX3dvcmxkLmZsYWMlMjIpLndyaXRlX2J5dGVzKGF1ZGlvKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>audio = client.text_to_speech(<span class="hljs-string">&quot;Hello world&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>Path(<span class="hljs-string">&quot;hello_world.flac&quot;</span>).write_bytes(audio)`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Td(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnRva2VuX2NsYXNzaWZpY2F0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwU2FyYWglMjBKZXNzaWNhJTIwUGFya2VyJTIwYnV0JTIweW91JTIwY2FuJTIwY2FsbCUyMG1lJTIwSmVzc2ljYSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.token_classification(<span class="hljs-string">&quot;My name is Sarah Jessica Parker but you can call me Jessica&quot;</span>)
[
    TokenClassificationOutputElement(
        entity_group=<span class="hljs-string">&#x27;PER&#x27;</span>,
        score=<span class="hljs-number">0.9971321225166321</span>,
        word=<span class="hljs-string">&#x27;Sarah Jessica Parker&#x27;</span>,
        start=<span class="hljs-number">11</span>,
        end=<span class="hljs-number">31</span>,
    ),
    TokenClassificationOutputElement(
        entity_group=<span class="hljs-string">&#x27;PER&#x27;</span>,
        score=<span class="hljs-number">0.9773476123809814</span>,
        word=<span class="hljs-string">&#x27;Jessica&#x27;</span>,
        start=<span class="hljs-number">52</span>,
        end=<span class="hljs-number">59</span>,
    )
]`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Id(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnRyYW5zbGF0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwV29sZmdhbmclMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwQmVybGluJTIyKSUwQWNsaWVudC50cmFuc2xhdGlvbiglMjJNeSUyMG5hbWUlMjBpcyUyMFdvbGZnYW5nJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyMEJlcmxpbiUyMiUyQyUyMG1vZGVsJTNEJTIySGVsc2lua2ktTkxQJTJGb3B1cy1tdC1lbi1mciUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.translation(<span class="hljs-string">&quot;My name is Wolfgang and I live in Berlin&quot;</span>)
<span class="hljs-string">&#x27;Mein Name ist Wolfgang und ich lebe in Berlin.&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client.translation(<span class="hljs-string">&quot;My name is Wolfgang and I live in Berlin&quot;</span>, model=<span class="hljs-string">&quot;Helsinki-NLP/opus-mt-en-fr&quot;</span>)
TranslationOutput(translation_text=<span class="hljs-string">&#x27;Je m&#x27;</span>appelle Wolfgang et je vis à Berlin.<span class="hljs-string">&#x27;)</span>`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function xd(I){let n,m="Specifying languages:",a,t,o;return t=new q({props:{code:"Y2xpZW50LnRyYW5zbGF0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwU2FyYWglMjBKZXNzaWNhJTIwUGFya2VyJTIwYnV0JTIweW91JTIwY2FuJTIwY2FsbCUyMG1lJTIwSmVzc2ljYSUyMiUyQyUyMG1vZGVsJTNEJTIyZmFjZWJvb2slMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JTIyJTJDJTIwc3JjX2xhbmclM0QlMjJlbl9YWCUyMiUyQyUyMHRndF9sYW5nJTNEJTIyZnJfWFglMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>client.translation(<span class="hljs-string">&quot;My name is Sarah Jessica Parker but you can call me Jessica&quot;</span>, model=<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-many-mmt&quot;</span>, src_lang=<span class="hljs-string">&quot;en_XX&quot;</span>, tgt_lang=<span class="hljs-string">&quot;fr_XX&quot;</span>)
<span class="hljs-string">&quot;Mon nom est Sarah Jessica Parker mais vous pouvez m&#x27;appeler Jessica&quot;</span>`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-mhcj6c"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Cd(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnZpc3VhbF9xdWVzdGlvbl9hbnN3ZXJpbmcoJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0QlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZtaXNoaWclMkZzYW1wbGVfaW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0aWdlci5qcGclMjIlMkMlMEElMjAlMjAlMjAlMjBxdWVzdGlvbiUzRCUyMldoYXQlMjBpcyUyMHRoZSUyMGFuaW1hbCUyMGRvaW5nJTNGJTIyJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.visual_question_answering(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;https://huggingface.co/datasets/mishig/sample_images/resolve/main/tiger.jpg&quot;</span>,
<span class="hljs-meta">... </span>    question=<span class="hljs-string">&quot;What is the animal doing?&quot;</span>
<span class="hljs-meta">... </span>)
[
    VisualQuestionAnsweringOutputElement(score=<span class="hljs-number">0.778609573841095</span>, answer=<span class="hljs-string">&#x27;laying down&#x27;</span>),
    VisualQuestionAnsweringOutputElement(score=<span class="hljs-number">0.6957435607910156</span>, answer=<span class="hljs-string">&#x27;sitting&#x27;</span>),
]`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Ud(I){let n,m="Example with <code>multi_label=False</code>:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBdGV4dCUyMCUzRCUyMCglMEElMjAlMjAlMjAlMjAlMjJBJTIwbmV3JTIwbW9kZWwlMjBvZmZlcnMlMjBhbiUyMGV4cGxhbmF0aW9uJTIwZm9yJTIwaG93JTIwdGhlJTIwR2FsaWxlYW4lMjBzYXRlbGxpdGVzJTIwZm9ybWVkJTIwYXJvdW5kJTIwdGhlJTIwc29sYXIlMjBzeXN0ZW0ncyUyMiUwQSUyMCUyMCUyMCUyMCUyMmxhcmdlc3QlMjB3b3JsZC4lMjBLb25zdGFudGluJTIwQmF0eWdpbiUyMGRpZCUyMG5vdCUyMHNldCUyMG91dCUyMHRvJTIwc29sdmUlMjBvbmUlMjBvZiUyMHRoZSUyMHNvbGFyJTIwc3lzdGVtJ3MlMjBtb3N0JTIwcHV6emxpbmclMjIlMEElMjAlMjAlMjAlMjAlMjIlMjBteXN0ZXJpZXMlMjB3aGVuJTIwaGUlMjB3ZW50JTIwZm9yJTIwYSUyMHJ1biUyMHVwJTIwYSUyMGhpbGwlMjBpbiUyME5pY2UlMkMlMjBGcmFuY2UuJTIyJTBBKSUwQWxhYmVscyUyMCUzRCUyMCU1QiUyMnNwYWNlJTIwJTI2JTIwY29zbW9zJTIyJTJDJTIwJTIyc2NpZW50aWZpYyUyMGRpc2NvdmVyeSUyMiUyQyUyMCUyMm1pY3JvYmlvbG9neSUyMiUyQyUyMCUyMnJvYm90cyUyMiUyQyUyMCUyMmFyY2hlb2xvZ3klMjIlNUQlMEFjbGllbnQuemVyb19zaG90X2NsYXNzaWZpY2F0aW9uKHRleHQlMkMlMjBsYWJlbHMpJTBBY2xpZW50Lnplcm9fc2hvdF9jbGFzc2lmaWNhdGlvbih0ZXh0JTJDJTIwbGFiZWxzJTJDJTIwbXVsdGlfbGFiZWwlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>text = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A new model offers an explanation for how the Galilean satellites formed around the solar system&#x27;s&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;largest world. Konstantin Batygin did not set out to solve one of the solar system&#x27;s most puzzling&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot; mysteries when he went for a run up a hill in Nice, France.&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = [<span class="hljs-string">&quot;space &amp; cosmos&quot;</span>, <span class="hljs-string">&quot;scientific discovery&quot;</span>, <span class="hljs-string">&quot;microbiology&quot;</span>, <span class="hljs-string">&quot;robots&quot;</span>, <span class="hljs-string">&quot;archeology&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>client.zero_shot_classification(text, labels)
[
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;scientific discovery&#x27;</span>, score=<span class="hljs-number">0.7961668968200684</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;space &amp; cosmos&#x27;</span>, score=<span class="hljs-number">0.18570658564567566</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;microbiology&#x27;</span>, score=<span class="hljs-number">0.00730885099619627</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;archeology&#x27;</span>, score=<span class="hljs-number">0.006258360575884581</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;robots&#x27;</span>, score=<span class="hljs-number">0.004559356719255447</span>),
]
<span class="hljs-meta">&gt;&gt;&gt; </span>client.zero_shot_classification(text, labels, multi_label=<span class="hljs-literal">True</span>)
[
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;scientific discovery&#x27;</span>, score=<span class="hljs-number">0.9829297661781311</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;space &amp; cosmos&#x27;</span>, score=<span class="hljs-number">0.755190908908844</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;microbiology&#x27;</span>, score=<span class="hljs-number">0.0005462635890580714</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;archeology&#x27;</span>, score=<span class="hljs-number">0.00047131875180639327</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;robots&#x27;</span>, score=<span class="hljs-number">0.00030448526376858354</span>),
]`,wrap:!1}}),{c(){n=u("p"),n.innerHTML=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-90ztrp"&&(n.innerHTML=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function wd(I){let n,m="Example with <code>multi_label=True</code> and a custom <code>hypothesis_template</code>:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50Lnplcm9fc2hvdF9jbGFzc2lmaWNhdGlvbiglMEElMjAlMjAlMjB0ZXh0JTNEJTIySSUyMHJlYWxseSUyMGxpa2UlMjBvdXIlMjBkaW5uZXIlMjBhbmQlMjBJJ20lMjB2ZXJ5JTIwaGFwcHkuJTIwSSUyMGRvbid0JTIwbGlrZSUyMHRoZSUyMHdlYXRoZXIlMjB0aG91Z2guJTIyJTJDJTBBJTIwJTIwJTIwbGFiZWxzJTNEJTVCJTIycG9zaXRpdmUlMjIlMkMlMjAlMjJuZWdhdGl2ZSUyMiUyQyUyMCUyMnBlc3NpbWlzdGljJTIyJTJDJTIwJTIyb3B0aW1pc3RpYyUyMiU1RCUyQyUwQSUyMCUyMCUyMG11bHRpX2xhYmVsJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMGh5cG90aGVzaXNfdGVtcGxhdGUlM0QlMjJUaGlzJTIwdGV4dCUyMGlzJTIwJTdCJTdEJTIwdG93YXJkcyUyMHRoZSUyMHdlYXRoZXIlMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.zero_shot_classification(
<span class="hljs-meta">... </span>   text=<span class="hljs-string">&quot;I really like our dinner and I&#x27;m very happy. I don&#x27;t like the weather though.&quot;</span>,
<span class="hljs-meta">... </span>   labels=[<span class="hljs-string">&quot;positive&quot;</span>, <span class="hljs-string">&quot;negative&quot;</span>, <span class="hljs-string">&quot;pessimistic&quot;</span>, <span class="hljs-string">&quot;optimistic&quot;</span>],
<span class="hljs-meta">... </span>   multi_label=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>   hypothesis_template=<span class="hljs-string">&quot;This text is {} towards the weather&quot;</span>
<span class="hljs-meta">... </span>)
[
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;negative&#x27;</span>, score=<span class="hljs-number">0.9231801629066467</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;pessimistic&#x27;</span>, score=<span class="hljs-number">0.8760990500450134</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;optimistic&#x27;</span>, score=<span class="hljs-number">0.0008674879791215062</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;positive&#x27;</span>, score=<span class="hljs-number">0.0005250611575320363</span>)
]`,wrap:!1}}),{c(){n=u("p"),n.innerHTML=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1qklg9x"&&(n.innerHTML=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Jd(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBJTBBY2xpZW50Lnplcm9fc2hvdF9pbWFnZV9jbGFzc2lmaWNhdGlvbiglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRnVwbG9hZC53aWtpbWVkaWEub3JnJTJGd2lraXBlZGlhJTJGY29tbW9ucyUyRnRodW1iJTJGNCUyRjQzJTJGQ3V0ZV9kb2cuanBnJTJGMzIwcHgtQ3V0ZV9kb2cuanBnJTIyJTJDJTBBJTIwJTIwJTIwJTIwbGFiZWxzJTNEJTVCJTIyZG9nJTIyJTJDJTIwJTIyY2F0JTIyJTJDJTIwJTIyaG9yc2UlMjIlNUQlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>client.zero_shot_image_classification(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>,
<span class="hljs-meta">... </span>    labels=[<span class="hljs-string">&quot;dog&quot;</span>, <span class="hljs-string">&quot;cat&quot;</span>, <span class="hljs-string">&quot;horse&quot;</span>],
<span class="hljs-meta">... </span>)
[ZeroShotImageClassificationOutputElement(label=<span class="hljs-string">&#x27;dog&#x27;</span>, score=<span class="hljs-number">0.956</span>),...]`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function $d(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmF1ZGlvX2NsYXNzaWZpY2F0aW9uKCUyMmF1ZGlvLmZsYWMlMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.audio_classification(<span class="hljs-string">&quot;audio.flac&quot;</span>)
[
    AudioClassificationOutputElement(score=<span class="hljs-number">0.4976358711719513</span>, label=<span class="hljs-string">&#x27;hap&#x27;</span>),
    AudioClassificationOutputElement(score=<span class="hljs-number">0.3677836060523987</span>, label=<span class="hljs-string">&#x27;neu&#x27;</span>),
    ...
]`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function vd(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF1ZGlvX291dHB1dCUyMCUzRCUyMGF3YWl0JTIwY2xpZW50LmF1ZGlvX3RvX2F1ZGlvKCUyMmF1ZGlvLmZsYWMlMjIpJTBBYXN5bmMlMjBmb3IlMjBpJTJDJTIwaXRlbSUyMGluJTIwZW51bWVyYXRlKGF1ZGlvX291dHB1dCklM0ElMEElMjAlMjAlMjAlMjB3aXRoJTIwb3BlbihmJTIyb3V0cHV0XyU3QmklN0QuZmxhYyUyMiUyQyUyMCUyMndiJTIyKSUyMGFzJTIwZiUzQQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_output = <span class="hljs-keyword">await</span> client.audio_to_audio(<span class="hljs-string">&quot;audio.flac&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> i, item <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(audio_output):
<span class="hljs-meta">&gt;&gt;&gt; </span>    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">f&quot;output_<span class="hljs-subst">{i}</span>.flac&quot;</span>, <span class="hljs-string">&quot;wb&quot;</span>) <span class="hljs-keyword">as</span> f:
            f.write(item.blob)`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function kd(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmF1dG9tYXRpY19zcGVlY2hfcmVjb2duaXRpb24oJTIyaGVsbG9fd29ybGQuZmxhYyUyMikudGV4dA==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.automatic_speech_recognition(<span class="hljs-string">&quot;hello_world.flac&quot;</span>).text
<span class="hljs-string">&quot;hello world&quot;</span>`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function qd(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"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",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-comment"># Chat example</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>}]
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.chat_completion(messages, max_tokens=<span class="hljs-number">100</span>)
ChatCompletionOutput(
    choices=[
        ChatCompletionOutputComplete(
            finish_reason=<span class="hljs-string">&#x27;eos_token&#x27;</span>,
            index=<span class="hljs-number">0</span>,
            message=ChatCompletionOutputMessage(
                role=<span class="hljs-string">&#x27;assistant&#x27;</span>,
                content=<span class="hljs-string">&#x27;The capital of France is Paris.&#x27;</span>,
                name=<span class="hljs-literal">None</span>,
                tool_calls=<span class="hljs-literal">None</span>
            ),
            logprobs=<span class="hljs-literal">None</span>
        )
    ],
    created=<span class="hljs-number">1719907176</span>,
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&#x27;&#x27;</span>,
    model=<span class="hljs-string">&#x27;meta-llama/Meta-Llama-3-8B-Instruct&#x27;</span>,
    <span class="hljs-built_in">object</span>=<span class="hljs-string">&#x27;text_completion&#x27;</span>,
    system_fingerprint=<span class="hljs-string">&#x27;2.0.4-sha-f426a33&#x27;</span>,
    usage=ChatCompletionOutputUsage(
        completion_tokens=<span class="hljs-number">8</span>,
        prompt_tokens=<span class="hljs-number">17</span>,
        total_tokens=<span class="hljs-number">25</span>
    )
)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> <span class="hljs-keyword">await</span> client.chat_completion(messages, max_tokens=<span class="hljs-number">10</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(token)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=<span class="hljs-string">&#x27;The&#x27;</span>, role=<span class="hljs-string">&#x27;assistant&#x27;</span>), index=<span class="hljs-number">0</span>, finish_reason=<span class="hljs-literal">None</span>)], created=<span class="hljs-number">1710498504</span>)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=<span class="hljs-string">&#x27; capital&#x27;</span>, role=<span class="hljs-string">&#x27;assistant&#x27;</span>), index=<span class="hljs-number">0</span>, finish_reason=<span class="hljs-literal">None</span>)], created=<span class="hljs-number">1710498504</span>)
(...)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=<span class="hljs-string">&#x27; may&#x27;</span>, role=<span class="hljs-string">&#x27;assistant&#x27;</span>), index=<span class="hljs-number">0</span>, finish_reason=<span class="hljs-literal">None</span>)], created=<span class="hljs-number">1710498504</span>)

<span class="hljs-comment"># Chat example with tools</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Don&#x27;t make assumptions about what values to plug into functions. Ask for clarification if a user request is ambiguous.&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What&#x27;s the weather like the next 3 days in San Francisco, CA?&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>tools = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;function&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_weather&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get the current weather&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;parameters&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;location&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The city and state, e.g. San Francisco, CA&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;format&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;enum&quot;</span>: [<span class="hljs-string">&quot;celsius&quot;</span>, <span class="hljs-string">&quot;fahrenheit&quot;</span>],
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The temperature unit to use. Infer this from the users location.&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;format&quot;</span>],
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;function&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_n_day_weather_forecast&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get an N-day weather forecast&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;parameters&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;location&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The city and state, e.g. San Francisco, CA&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;format&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;enum&quot;</span>: [<span class="hljs-string">&quot;celsius&quot;</span>, <span class="hljs-string">&quot;fahrenheit&quot;</span>],
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The temperature unit to use. Infer this from the users location.&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;num_days&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The number of days to forecast&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;format&quot;</span>, <span class="hljs-string">&quot;num_days&quot;</span>],
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>response = <span class="hljs-keyword">await</span> client.chat_completion(
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>,
<span class="hljs-meta">... </span>    messages=messages,
<span class="hljs-meta">... </span>    tools=tools,
<span class="hljs-meta">... </span>    tool_choice=<span class="hljs-string">&quot;auto&quot;</span>,
<span class="hljs-meta">... </span>    max_tokens=<span class="hljs-number">500</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.choices[<span class="hljs-number">0</span>].message.tool_calls[<span class="hljs-number">0</span>].function
ChatCompletionOutputFunctionDefinition(
    arguments={
        <span class="hljs-string">&#x27;location&#x27;</span>: <span class="hljs-string">&#x27;San Francisco, CA&#x27;</span>,
        <span class="hljs-string">&#x27;format&#x27;</span>: <span class="hljs-string">&#x27;fahrenheit&#x27;</span>,
        <span class="hljs-string">&#x27;num_days&#x27;</span>: <span class="hljs-number">3</span>
    },
    name=<span class="hljs-string">&#x27;get_n_day_weather_forecast&#x27;</span>,
    description=<span class="hljs-literal">None</span>
)`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Ed(I){let n,m=`<a href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceClient.conversational">InferenceClient.conversational()</a> API is deprecated and will be removed in a future release. Please use
<a href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceClient.chat_completion">InferenceClient.chat_completion()</a> instead.`;return{c(){n=u("p"),n.innerHTML=m},l(a){n=g(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1wqrwgc"&&(n.innerHTML=m)},m(a,t){_(a,n,t)},p:x,d(a){a&&p(n)}}}function Ad(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQW91dHB1dCUyMCUzRCUyMGF3YWl0JTIwY2xpZW50LmNvbnZlcnNhdGlvbmFsKCUyMkhpJTJDJTIwd2hvJTIwYXJlJTIweW91JTNGJTIyKSUwQW91dHB1dCUwQWF3YWl0JTIwY2xpZW50LmNvbnZlcnNhdGlvbmFsKCUwQSUyMCUyMCUyMCUyMCUyMldvdyUyQyUyMHRoYXQncyUyMHNjYXJ5ISUyMiUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRlZF9yZXNwb25zZXMlM0RvdXRwdXQlNUIlMjJjb252ZXJzYXRpb24lMjIlNUQlNUIlMjJnZW5lcmF0ZWRfcmVzcG9uc2VzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwcGFzdF91c2VyX2lucHV0cyUzRG91dHB1dCU1QiUyMmNvbnZlcnNhdGlvbiUyMiU1RCU1QiUyMnBhc3RfdXNlcl9pbnB1dHMlMjIlNUQlMkMlMEEp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>output = <span class="hljs-keyword">await</span> client.conversational(<span class="hljs-string">&quot;Hi, who are you?&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output
{<span class="hljs-string">&#x27;generated_text&#x27;</span>: <span class="hljs-string">&#x27;I am the one who knocks.&#x27;</span>, <span class="hljs-string">&#x27;conversation&#x27;</span>: {<span class="hljs-string">&#x27;generated_responses&#x27;</span>: [<span class="hljs-string">&#x27;I am the one who knocks.&#x27;</span>], <span class="hljs-string">&#x27;past_user_inputs&#x27;</span>: [<span class="hljs-string">&#x27;Hi, who are you?&#x27;</span>]}, <span class="hljs-string">&#x27;warnings&#x27;</span>: [<span class="hljs-string">&#x27;Setting \`pad_token_id\` to \`eos_token_id\`:50256 for open-end generation.&#x27;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.conversational(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Wow, that&#x27;s scary!&quot;</span>,
<span class="hljs-meta">... </span>    generated_responses=output[<span class="hljs-string">&quot;conversation&quot;</span>][<span class="hljs-string">&quot;generated_responses&quot;</span>],
<span class="hljs-meta">... </span>    past_user_inputs=output[<span class="hljs-string">&quot;conversation&quot;</span>][<span class="hljs-string">&quot;past_user_inputs&quot;</span>],
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Zd(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmRvY3VtZW50X3F1ZXN0aW9uX2Fuc3dlcmluZyhpbWFnZSUzRCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZzcGFjZXMlMkZpbXBpcmElMkZkb2NxdWVyeSUyRnJlc29sdmUlMkYyMzU5MjIzYzE4MzdhNzU4NzQwMmJkYTBmMjY0MzM4MmE2ZWVmZWFiJTJGaW52b2ljZS5wbmclMjIlMkMlMjBxdWVzdGlvbiUzRCUyMldoYXQlMjBpcyUyMHRoZSUyMGludm9pY2UlMjBudW1iZXIlM0YlMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.document_question_answering(image=<span class="hljs-string">&quot;https://huggingface.co/spaces/impira/docquery/resolve/2359223c1837a7587402bda0f2643382a6eefeab/invoice.png&quot;</span>, question=<span class="hljs-string">&quot;What is the invoice number?&quot;</span>)
[DocumentQuestionAnsweringOutputElement(score=<span class="hljs-number">0.42515629529953003</span>, answer=<span class="hljs-string">&#x27;us-001&#x27;</span>, start=<span class="hljs-number">16</span>, end=<span class="hljs-number">16</span>)]`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Nd(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmZlYXR1cmVfZXh0cmFjdGlvbiglMjJIaSUyQyUyMHdobyUyMGFyZSUyMHlvdSUzRiUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.feature_extraction(<span class="hljs-string">&quot;Hi, who are you?&quot;</span>)
array([[ <span class="hljs-number">2.424802</span>  ,  <span class="hljs-number">2.93384</span>   ,  <span class="hljs-number">1.1750331</span> , ...,  <span class="hljs-number">1.240499</span>, -<span class="hljs-number">0.13776633</span>, -<span class="hljs-number">0.7889173</span> ],
[-<span class="hljs-number">0.42943227</span>, -<span class="hljs-number">0.6364878</span> , -<span class="hljs-number">1.693462</span>  , ...,  <span class="hljs-number">0.41978157</span>, -<span class="hljs-number">2.4336355</span> ,  <span class="hljs-number">0.6162071</span> ],
...,
[ <span class="hljs-number">0.28552425</span>, -<span class="hljs-number">0.928395</span>  , -<span class="hljs-number">1.2077185</span> , ...,  <span class="hljs-number">0.76810825</span>, -<span class="hljs-number">2.1069427</span> ,  <span class="hljs-number">0.6236161</span> ]], dtype=float32)`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Wd(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmZpbGxfbWFzayglMjJUaGUlMjBnb2FsJTIwb2YlMjBsaWZlJTIwaXMlMjAlM0NtYXNrJTNFLiUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.fill_mask(<span class="hljs-string">&quot;The goal of life is &lt;mask&gt;.&quot;</span>)
[
    FillMaskOutputElement(score=<span class="hljs-number">0.06897063553333282</span>, token=<span class="hljs-number">11098</span>, token_str=<span class="hljs-string">&#x27; happiness&#x27;</span>, sequence=<span class="hljs-string">&#x27;The goal of life is happiness.&#x27;</span>),
    FillMaskOutputElement(score=<span class="hljs-number">0.06554922461509705</span>, token=<span class="hljs-number">45075</span>, token_str=<span class="hljs-string">&#x27; immortality&#x27;</span>, sequence=<span class="hljs-string">&#x27;The goal of life is immortality.&#x27;</span>)
]`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Gd(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy03MEItSW5zdHJ1Y3QlMjIpJTBBYXdhaXQlMjBjbGllbnQuZ2V0X2VuZHBvaW50X2luZm8oKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.get_endpoint_info()
{
    <span class="hljs-string">&#x27;model_id&#x27;</span>: <span class="hljs-string">&#x27;meta-llama/Meta-Llama-3-70B-Instruct&#x27;</span>,
    <span class="hljs-string">&#x27;model_sha&#x27;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&#x27;model_dtype&#x27;</span>: <span class="hljs-string">&#x27;torch.float16&#x27;</span>,
    <span class="hljs-string">&#x27;model_device_type&#x27;</span>: <span class="hljs-string">&#x27;cuda&#x27;</span>,
    <span class="hljs-string">&#x27;model_pipeline_tag&#x27;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&#x27;max_concurrent_requests&#x27;</span>: <span class="hljs-number">128</span>,
    <span class="hljs-string">&#x27;max_best_of&#x27;</span>: <span class="hljs-number">2</span>,
    <span class="hljs-string">&#x27;max_stop_sequences&#x27;</span>: <span class="hljs-number">4</span>,
    <span class="hljs-string">&#x27;max_input_length&#x27;</span>: <span class="hljs-number">8191</span>,
    <span class="hljs-string">&#x27;max_total_tokens&#x27;</span>: <span class="hljs-number">8192</span>,
    <span class="hljs-string">&#x27;waiting_served_ratio&#x27;</span>: <span class="hljs-number">0.3</span>,
    <span class="hljs-string">&#x27;max_batch_total_tokens&#x27;</span>: <span class="hljs-number">1259392</span>,
    <span class="hljs-string">&#x27;max_waiting_tokens&#x27;</span>: <span class="hljs-number">20</span>,
    <span class="hljs-string">&#x27;max_batch_size&#x27;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&#x27;validation_workers&#x27;</span>: <span class="hljs-number">32</span>,
    <span class="hljs-string">&#x27;max_client_batch_size&#x27;</span>: <span class="hljs-number">4</span>,
    <span class="hljs-string">&#x27;version&#x27;</span>: <span class="hljs-string">&#x27;2.0.2&#x27;</span>,
    <span class="hljs-string">&#x27;sha&#x27;</span>: <span class="hljs-string">&#x27;dccab72549635c7eb5ddb17f43f0b7cdff07c214&#x27;</span>,
    <span class="hljs-string">&#x27;docker_label&#x27;</span>: <span class="hljs-string">&#x27;sha-dccab72&#x27;</span>
}`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Bd(I){let n,m=`This endpoint is mostly useful when you already know which model you want to use and want to check its
availability. If you want to discover already deployed models, you should rather use <a href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceClient.list_deployed_models">list_deployed_models()</a>.`;return{c(){n=u("p"),n.innerHTML=m},l(a){n=g(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-lzhzod"&&(n.innerHTML=m)},m(a,t){_(a,n,t)},p:x,d(a){a&&p(n)}}}function Qd(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmdldF9tb2RlbF9zdGF0dXMoJTIyYmlnY29kZSUyRnN0YXJjb2RlciUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.get_model_status(<span class="hljs-string">&quot;bigcode/starcoder&quot;</span>)
ModelStatus(loaded=<span class="hljs-literal">True</span>, state=<span class="hljs-string">&#x27;Loaded&#x27;</span>, compute_type=<span class="hljs-string">&#x27;gpu&#x27;</span>, framework=<span class="hljs-string">&#x27;text-generation-inference&#x27;</span>)`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Vd(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoJTIyaHR0cHMlM0ElMkYlMkZqemd1MGJ1ZWk1LnVzLWVhc3QtMS5hd3MuZW5kcG9pbnRzLmh1Z2dpbmdmYWNlLmNsb3VkJTIyKSUwQWF3YWl0JTIwY2xpZW50LmhlYWx0aF9jaGVjaygp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient(<span class="hljs-string">&quot;https://jzgu0buei5.us-east-1.aws.endpoints.huggingface.cloud&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.health_check()
<span class="hljs-literal">True</span>`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Yd(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmltYWdlX2NsYXNzaWZpY2F0aW9uKCUyMmh0dHBzJTNBJTJGJTJGdXBsb2FkLndpa2ltZWRpYS5vcmclMkZ3aWtpcGVkaWElMkZjb21tb25zJTJGdGh1bWIlMkY0JTJGNDMlMkZDdXRlX2RvZy5qcGclMkYzMjBweC1DdXRlX2RvZy5qcGclMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.image_classification(<span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>)
[ImageClassificationOutputElement(score=<span class="hljs-number">0.9779096841812134</span>, label=<span class="hljs-string">&#x27;Blenheim spaniel&#x27;</span>), ...]`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Sd(I){let n,m="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=u("p"),n.innerHTML=m},l(a){n=g(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-s2e3n9"&&(n.innerHTML=m)},m(a,t){_(a,n,t)},p:x,d(a){a&&p(n)}}}function Rd(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmltYWdlX3NlZ21lbnRhdGlvbiglMjJjYXQuanBnJTIyKSUzQQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.image_segmentation(<span class="hljs-string">&quot;cat.jpg&quot;</span>):
[ImageSegmentationOutputElement(score=<span class="hljs-number">0.989008</span>, label=<span class="hljs-string">&#x27;LABEL_184&#x27;</span>, mask=&lt;PIL.PngImagePlugin.PngImageFile image mode=L size=400x300 at <span class="hljs-number">0x7FDD2B129CC0</span>&gt;), ...]`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Dd(I){let n,m="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=u("p"),n.innerHTML=m},l(a){n=g(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-s2e3n9"&&(n.innerHTML=m)},m(a,t){_(a,n,t)},p:x,d(a){a&&p(n)}}}function Xd(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWltYWdlJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQuaW1hZ2VfdG9faW1hZ2UoJTIyY2F0LmpwZyUyMiUyQyUyMHByb21wdCUzRCUyMnR1cm4lMjB0aGUlMjBjYXQlMjBpbnRvJTIwYSUyMHRpZ2VyJTIyKSUwQWltYWdlLnNhdmUoJTIydGlnZXIuanBnJTIyKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-keyword">await</span> client.image_to_image(<span class="hljs-string">&quot;cat.jpg&quot;</span>, prompt=<span class="hljs-string">&quot;turn the cat into a tiger&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;tiger.jpg&quot;</span>)`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Hd(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmltYWdlX3RvX3RleHQoJTIyY2F0LmpwZyUyMiklMEFhd2FpdCUyMGNsaWVudC5pbWFnZV90b190ZXh0KCUyMmh0dHBzJTNBJTJGJTJGdXBsb2FkLndpa2ltZWRpYS5vcmclMkZ3aWtpcGVkaWElMkZjb21tb25zJTJGdGh1bWIlMkY0JTJGNDMlMkZDdXRlX2RvZy5qcGclMkYzMjBweC1DdXRlX2RvZy5qcGclMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.image_to_text(<span class="hljs-string">&quot;cat.jpg&quot;</span>)
<span class="hljs-string">&#x27;a cat standing in a grassy field &#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.image_to_text(<span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>)
<span class="hljs-string">&#x27;a dog laying on the grass next to a flower pot &#x27;</span>`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function zd(I){let n,m=`This endpoint method does not return a live list of all models available for the Serverless Inference API service.
It searches over a cached list of models that were recently available and the list may not be up to date.
If you want to know the live status of a specific model, use <a href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceClient.get_model_status">get_model_status()</a>.`;return{c(){n=u("p"),n.innerHTML=m},l(a){n=g(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1vkbl5b"&&(n.innerHTML=m)},m(a,t){_(a,n,t)},p:x,d(a){a&&p(n)}}}function Fd(I){let n,m=`This endpoint method is mostly useful for discoverability. If you already know which model you want to use and want to
check its availability, you can directly use <a href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceClient.get_model_status">get_model_status()</a>.`;return{c(){n=u("p"),n.innerHTML=m},l(a){n=g(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1wivmlw"&&(n.innerHTML=m)},m(a,t){_(a,n,t)},p:x,d(a){a&&p(n)}}}function Ld(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQSUwQW1vZGVscyUyMCUzRCUyMGF3YWl0JTIwY2xpZW50Lmxpc3RfZGVwbG95ZWRfbW9kZWxzKCklMEFtb2RlbHMlNUIlMjJ6ZXJvLXNob3QtY2xhc3NpZmljYXRpb24lMjIlNUQlMEElMEFhd2FpdCUyMGNsaWVudC5saXN0X2RlcGxveWVkX21vZGVscyglMjJ0ZXh0LWdlbmVyYXRpb24taW5mZXJlbmNlJTIyKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async contextthon</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-comment"># Discover zero-shot-classification models currently deployed</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>models = <span class="hljs-keyword">await</span> client.list_deployed_models()
<span class="hljs-meta">&gt;&gt;&gt; </span>models[<span class="hljs-string">&quot;zero-shot-classification&quot;</span>]
[<span class="hljs-string">&#x27;Narsil/deberta-large-mnli-zero-cls&#x27;</span>, <span class="hljs-string">&#x27;facebook/bart-large-mnli&#x27;</span>, ...]

<span class="hljs-comment"># List from only 1 framework</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.list_deployed_models(<span class="hljs-string">&quot;text-generation-inference&quot;</span>)
{<span class="hljs-string">&#x27;text-generation&#x27;</span>: [<span class="hljs-string">&#x27;bigcode/starcoder&#x27;</span>, <span class="hljs-string">&#x27;meta-llama/Llama-2-70b-chat-hf&#x27;</span>, ...], ...}`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Od(I){let n,m="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=u("p"),n.innerHTML=m},l(a){n=g(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-s2e3n9"&&(n.innerHTML=m)},m(a,t){_(a,n,t)},p:x,d(a){a&&p(n)}}}function Pd(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50Lm9iamVjdF9kZXRlY3Rpb24oJTIycGVvcGxlLmpwZyUyMiklM0E=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.object_detection(<span class="hljs-string">&quot;people.jpg&quot;</span>):
[ObjectDetectionOutputElement(score=<span class="hljs-number">0.9486683011054993</span>, label=<span class="hljs-string">&#x27;person&#x27;</span>, box=ObjectDetectionBoundingBox(xmin=<span class="hljs-number">59</span>, ymin=<span class="hljs-number">39</span>, xmax=<span class="hljs-number">420</span>, ymax=<span class="hljs-number">510</span>)), ...]`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Kd(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnF1ZXN0aW9uX2Fuc3dlcmluZyhxdWVzdGlvbiUzRCUyMldoYXQncyUyMG15JTIwbmFtZSUzRiUyMiUyQyUyMGNvbnRleHQlM0QlMjJNeSUyMG5hbWUlMjBpcyUyMENsYXJhJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyMEJlcmtlbGV5LiUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.question_answering(question=<span class="hljs-string">&quot;What&#x27;s my name?&quot;</span>, context=<span class="hljs-string">&quot;My name is Clara and I live in Berkeley.&quot;</span>)
QuestionAnsweringOutputElement(score=<span class="hljs-number">0.9326562285423279</span>, start=<span class="hljs-number">11</span>, end=<span class="hljs-number">16</span>, answer=<span class="hljs-string">&#x27;Clara&#x27;</span>)`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function ef(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnNlbnRlbmNlX3NpbWlsYXJpdHkoJTBBJTIwJTIwJTIwJTIwJTIyTWFjaGluZSUyMGxlYXJuaW5nJTIwaXMlMjBzbyUyMGVhc3kuJTIyJTJDJTBBJTIwJTIwJTIwJTIwb3RoZXJfc2VudGVuY2VzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyRGVlcCUyMGxlYXJuaW5nJTIwaXMlMjBzbyUyMHN0cmFpZ2h0Zm9yd2FyZC4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJUaGlzJTIwaXMlMjBzbyUyMGRpZmZpY3VsdCUyQyUyMGxpa2UlMjByb2NrZXQlMjBzY2llbmNlLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkklMjBjYW4ndCUyMGJlbGlldmUlMjBob3clMjBtdWNoJTIwSSUyMHN0cnVnZ2xlZCUyMHdpdGglMjB0aGlzLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSk=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.sentence_similarity(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Machine learning is so easy.&quot;</span>,
<span class="hljs-meta">... </span>    other_sentences=[
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;Deep learning is so straightforward.&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;This is so difficult, like rocket science.&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;I can&#x27;t believe how much I struggled with this.&quot;</span>,
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>)
[<span class="hljs-number">0.7785726189613342</span>, <span class="hljs-number">0.45876261591911316</span>, <span class="hljs-number">0.2906220555305481</span>]`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function nf(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnN1bW1hcml6YXRpb24oJTIyVGhlJTIwRWlmZmVsJTIwdG93ZXIuLi4lMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.summarization(<span class="hljs-string">&quot;The Eiffel tower...&quot;</span>)
SummarizationOutput(generated_text=<span class="hljs-string">&quot;The Eiffel tower is one of the most famous landmarks in the world....&quot;</span>)`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function tf(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQXF1ZXJ5JTIwJTNEJTIwJTIySG93JTIwbWFueSUyMHN0YXJzJTIwZG9lcyUyMHRoZSUyMHRyYW5zZm9ybWVycyUyMHJlcG9zaXRvcnklMjBoYXZlJTNGJTIyJTBBdGFibGUlMjAlM0QlMjAlN0IlMjJSZXBvc2l0b3J5JTIyJTNBJTIwJTVCJTIyVHJhbnNmb3JtZXJzJTIyJTJDJTIwJTIyRGF0YXNldHMlMjIlMkMlMjAlMjJUb2tlbml6ZXJzJTIyJTVEJTJDJTIwJTIyU3RhcnMlMjIlM0ElMjAlNUIlMjIzNjU0MiUyMiUyQyUyMCUyMjQ1MTIlMjIlMkMlMjAlMjIzOTM0JTIyJTVEJTdEJTBBYXdhaXQlMjBjbGllbnQudGFibGVfcXVlc3Rpb25fYW5zd2VyaW5nKHRhYmxlJTJDJTIwcXVlcnklMkMlMjBtb2RlbCUzRCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UtZmluZXR1bmVkLXd0cSUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>query = <span class="hljs-string">&quot;How many stars does the transformers repository have?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {<span class="hljs-string">&quot;Repository&quot;</span>: [<span class="hljs-string">&quot;Transformers&quot;</span>, <span class="hljs-string">&quot;Datasets&quot;</span>, <span class="hljs-string">&quot;Tokenizers&quot;</span>], <span class="hljs-string">&quot;Stars&quot;</span>: [<span class="hljs-string">&quot;36542&quot;</span>, <span class="hljs-string">&quot;4512&quot;</span>, <span class="hljs-string">&quot;3934&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.table_question_answering(table, query, model=<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)
TableQuestionAnsweringOutputElement(answer=<span class="hljs-string">&#x27;36542&#x27;</span>, coordinates=[[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>]], cells=[<span class="hljs-string">&#x27;36542&#x27;</span>], aggregator=<span class="hljs-string">&#x27;AVERAGE&#x27;</span>)`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function sf(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQXRhYmxlJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyZml4ZWRfYWNpZGl0eSUyMiUzQSUyMCU1QiUyMjcuNCUyMiUyQyUyMCUyMjcuOCUyMiUyQyUyMCUyMjEwLjMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJ2b2xhdGlsZV9hY2lkaXR5JTIyJTNBJTIwJTVCJTIyMC43JTIyJTJDJTIwJTIyMC44OCUyMiUyQyUyMCUyMjAuMzIlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJjaXRyaWNfYWNpZCUyMiUzQSUyMCU1QiUyMjAlMjIlMkMlMjAlMjIwJTIyJTJDJTIwJTIyMC40NSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnJlc2lkdWFsX3N1Z2FyJTIyJTNBJTIwJTVCJTIyMS45JTIyJTJDJTIwJTIyMi42JTIyJTJDJTIwJTIyNi40JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyY2hsb3JpZGVzJTIyJTNBJTIwJTVCJTIyMC4wNzYlMjIlMkMlMjAlMjIwLjA5OCUyMiUyQyUyMCUyMjAuMDczJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyZnJlZV9zdWxmdXJfZGlveGlkZSUyMiUzQSUyMCU1QiUyMjExJTIyJTJDJTIwJTIyMjUlMjIlMkMlMjAlMjI1JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIydG90YWxfc3VsZnVyX2Rpb3hpZGUlMjIlM0ElMjAlNUIlMjIzNCUyMiUyQyUyMCUyMjY3JTIyJTJDJTIwJTIyMTMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJkZW5zaXR5JTIyJTNBJTIwJTVCJTIyMC45OTc4JTIyJTJDJTIwJTIyMC45OTY4JTIyJTJDJTIwJTIyMC45OTc2JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIycEglMjIlM0ElMjAlNUIlMjIzLjUxJTIyJTJDJTIwJTIyMy4yJTIyJTJDJTIwJTIyMy4yMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnN1bHBoYXRlcyUyMiUzQSUyMCU1QiUyMjAuNTYlMjIlMkMlMjAlMjIwLjY4JTIyJTJDJTIwJTIyMC44MiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmFsY29ob2wlMjIlM0ElMjAlNUIlMjI5LjQlMjIlMkMlMjAlMjI5LjglMjIlMkMlMjAlMjIxMi42JTIyJTVEJTJDJTBBJTdEJTBBYXdhaXQlMjBjbGllbnQudGFidWxhcl9jbGFzc2lmaWNhdGlvbih0YWJsZSUzRHRhYmxlJTJDJTIwbW9kZWwlM0QlMjJqdWxpZW4tYyUyRndpbmUtcXVhbGl0eSUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;fixed_acidity&quot;</span>: [<span class="hljs-string">&quot;7.4&quot;</span>, <span class="hljs-string">&quot;7.8&quot;</span>, <span class="hljs-string">&quot;10.3&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;volatile_acidity&quot;</span>: [<span class="hljs-string">&quot;0.7&quot;</span>, <span class="hljs-string">&quot;0.88&quot;</span>, <span class="hljs-string">&quot;0.32&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;citric_acid&quot;</span>: [<span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0.45&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;residual_sugar&quot;</span>: [<span class="hljs-string">&quot;1.9&quot;</span>, <span class="hljs-string">&quot;2.6&quot;</span>, <span class="hljs-string">&quot;6.4&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;chlorides&quot;</span>: [<span class="hljs-string">&quot;0.076&quot;</span>, <span class="hljs-string">&quot;0.098&quot;</span>, <span class="hljs-string">&quot;0.073&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;free_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;11&quot;</span>, <span class="hljs-string">&quot;25&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;total_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;34&quot;</span>, <span class="hljs-string">&quot;67&quot;</span>, <span class="hljs-string">&quot;13&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;density&quot;</span>: [<span class="hljs-string">&quot;0.9978&quot;</span>, <span class="hljs-string">&quot;0.9968&quot;</span>, <span class="hljs-string">&quot;0.9976&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;pH&quot;</span>: [<span class="hljs-string">&quot;3.51&quot;</span>, <span class="hljs-string">&quot;3.2&quot;</span>, <span class="hljs-string">&quot;3.23&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;sulphates&quot;</span>: [<span class="hljs-string">&quot;0.56&quot;</span>, <span class="hljs-string">&quot;0.68&quot;</span>, <span class="hljs-string">&quot;0.82&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;alcohol&quot;</span>: [<span class="hljs-string">&quot;9.4&quot;</span>, <span class="hljs-string">&quot;9.8&quot;</span>, <span class="hljs-string">&quot;12.6&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.tabular_classification(table=table, model=<span class="hljs-string">&quot;julien-c/wine-quality&quot;</span>)
[<span class="hljs-string">&quot;5&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>]`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function af(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQXRhYmxlJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIySGVpZ2h0JTIyJTNBJTIwJTVCJTIyMTEuNTIlMjIlMkMlMjAlMjIxMi40OCUyMiUyQyUyMCUyMjEyLjM3NzglMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJMZW5ndGgxJTIyJTNBJTIwJTVCJTIyMjMuMiUyMiUyQyUyMCUyMjI0JTIyJTJDJTIwJTIyMjMuOSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMkxlbmd0aDIlMjIlM0ElMjAlNUIlMjIyNS40JTIyJTJDJTIwJTIyMjYuMyUyMiUyQyUyMCUyMjI2LjUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJMZW5ndGgzJTIyJTNBJTIwJTVCJTIyMzAlMjIlMkMlMjAlMjIzMS4yJTIyJTJDJTIwJTIyMzEuMSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMlNwZWNpZXMlMjIlM0ElMjAlNUIlMjJCcmVhbSUyMiUyQyUyMCUyMkJyZWFtJTIyJTJDJTIwJTIyQnJlYW0lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJXaWR0aCUyMiUzQSUyMCU1QiUyMjQuMDIlMjIlMkMlMjAlMjI0LjMwNTYlMjIlMkMlMjAlMjI0LjY5NjElMjIlNUQlMkMlMEElN0QlMEFhd2FpdCUyMGNsaWVudC50YWJ1bGFyX3JlZ3Jlc3Npb24odGFibGUlMkMlMjBtb2RlbCUzRCUyMnNjaWtpdC1sZWFybiUyRkZpc2gtV2VpZ2h0JTIyKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Height&quot;</span>: [<span class="hljs-string">&quot;11.52&quot;</span>, <span class="hljs-string">&quot;12.48&quot;</span>, <span class="hljs-string">&quot;12.3778&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length1&quot;</span>: [<span class="hljs-string">&quot;23.2&quot;</span>, <span class="hljs-string">&quot;24&quot;</span>, <span class="hljs-string">&quot;23.9&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length2&quot;</span>: [<span class="hljs-string">&quot;25.4&quot;</span>, <span class="hljs-string">&quot;26.3&quot;</span>, <span class="hljs-string">&quot;26.5&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length3&quot;</span>: [<span class="hljs-string">&quot;30&quot;</span>, <span class="hljs-string">&quot;31.2&quot;</span>, <span class="hljs-string">&quot;31.1&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Species&quot;</span>: [<span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Width&quot;</span>: [<span class="hljs-string">&quot;4.02&quot;</span>, <span class="hljs-string">&quot;4.3056&quot;</span>, <span class="hljs-string">&quot;4.6961&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.tabular_regression(table, model=<span class="hljs-string">&quot;scikit-learn/Fish-Weight&quot;</span>)
[<span class="hljs-number">110</span>, <span class="hljs-number">120</span>, <span class="hljs-number">130</span>]`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function lf(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnRleHRfY2xhc3NpZmljYXRpb24oJTIySSUyMGxpa2UlMjB5b3UlMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.text_classification(<span class="hljs-string">&quot;I like you&quot;</span>)
[
    TextClassificationOutputElement(label=<span class="hljs-string">&#x27;POSITIVE&#x27;</span>, score=<span class="hljs-number">0.9998695850372314</span>),
    TextClassificationOutputElement(label=<span class="hljs-string">&#x27;NEGATIVE&#x27;</span>, score=<span class="hljs-number">0.0001304351753788069</span>),
]`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function of(I){let n,m=`If you want to generate a response from chat messages, you should use the <a href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceClient.chat_completion">InferenceClient.chat_completion()</a> method.
It accepts a list of messages instead of a single text prompt and handles the chat templating for you.`;return{c(){n=u("p"),n.innerHTML=m},l(a){n=g(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1eat4j1"&&(n.innerHTML=m)},m(a,t){_(a,n,t)},p:x,d(a){a&&p(n)}}}function rf(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"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",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-comment"># Case 1: generate text</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>)
<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>

<span class="hljs-comment"># Case 2: iterate over the generated tokens. Useful for large generation.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> <span class="hljs-keyword">await</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(token)
<span class="hljs-number">100</span>
%
<span class="hljs-built_in">open</span>
source
<span class="hljs-keyword">and</span>
built
to
be
easy
to
use
.

<span class="hljs-comment"># Case 3: get more details about the generation process.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, details=<span class="hljs-literal">True</span>)
TextGenerationOutput(
    generated_text=<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>,
    details=TextGenerationDetails(
        finish_reason=<span class="hljs-string">&#x27;length&#x27;</span>,
        generated_tokens=<span class="hljs-number">12</span>,
        seed=<span class="hljs-literal">None</span>,
        prefill=[
            TextGenerationPrefillOutputToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">487</span>, text=<span class="hljs-string">&#x27;The&#x27;</span>, logprob=<span class="hljs-literal">None</span>),
            TextGenerationPrefillOutputToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">53789</span>, text=<span class="hljs-string">&#x27; hugging&#x27;</span>, logprob=-<span class="hljs-number">13.171875</span>),
            (...)
            TextGenerationPrefillOutputToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">204</span>, text=<span class="hljs-string">&#x27; &#x27;</span>, logprob=-<span class="hljs-number">7.0390625</span>)
        ],
        tokens=[
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1425</span>, text=<span class="hljs-string">&#x27;100&#x27;</span>, logprob=-<span class="hljs-number">1.0175781</span>, special=<span class="hljs-literal">False</span>),
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">16</span>, text=<span class="hljs-string">&#x27;%&#x27;</span>, logprob=-<span class="hljs-number">0.0463562</span>, special=<span class="hljs-literal">False</span>),
            (...)
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">25</span>, text=<span class="hljs-string">&#x27;.&#x27;</span>, logprob=-<span class="hljs-number">0.5703125</span>, special=<span class="hljs-literal">False</span>)
        ],
        best_of_sequences=<span class="hljs-literal">None</span>
    )
)

<span class="hljs-comment"># Case 4: iterate over the generated tokens with more details.</span>
<span class="hljs-comment"># Last object is more complete, containing the full generated text and the finish reason.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> details <span class="hljs-keyword">in</span> <span class="hljs-keyword">await</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, details=<span class="hljs-literal">True</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(details)
...
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1425</span>, text=<span class="hljs-string">&#x27;100&#x27;</span>, logprob=-<span class="hljs-number">1.0175781</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">16</span>, text=<span class="hljs-string">&#x27;%&#x27;</span>, logprob=-<span class="hljs-number">0.0463562</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1314</span>, text=<span class="hljs-string">&#x27; open&#x27;</span>, logprob=-<span class="hljs-number">1.3359375</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">3178</span>, text=<span class="hljs-string">&#x27; source&#x27;</span>, logprob=-<span class="hljs-number">0.28100586</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">273</span>, text=<span class="hljs-string">&#x27; and&#x27;</span>, logprob=-<span class="hljs-number">0.5961914</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">3426</span>, text=<span class="hljs-string">&#x27; built&#x27;</span>, logprob=-<span class="hljs-number">1.9423828</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">271</span>, text=<span class="hljs-string">&#x27; to&#x27;</span>, logprob=-<span class="hljs-number">1.4121094</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">314</span>, text=<span class="hljs-string">&#x27; be&#x27;</span>, logprob=-<span class="hljs-number">1.5224609</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1833</span>, text=<span class="hljs-string">&#x27; easy&#x27;</span>, logprob=-<span class="hljs-number">2.1132812</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">271</span>, text=<span class="hljs-string">&#x27; to&#x27;</span>, logprob=-<span class="hljs-number">0.08520508</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">745</span>, text=<span class="hljs-string">&#x27; use&#x27;</span>, logprob=-<span class="hljs-number">0.39453125</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(
    <span class="hljs-built_in">id</span>=<span class="hljs-number">25</span>,
    text=<span class="hljs-string">&#x27;.&#x27;</span>,
    logprob=-<span class="hljs-number">0.5703125</span>,
    special=<span class="hljs-literal">False</span>),
    generated_text=<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>,
    details=TextGenerationStreamOutputStreamDetails(finish_reason=<span class="hljs-string">&#x27;length&#x27;</span>, generated_tokens=<span class="hljs-number">12</span>, seed=<span class="hljs-literal">None</span>)
)

<span class="hljs-comment"># Case 5: generate constrained output using grammar</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>response = <span class="hljs-keyword">await</span> client.text_generation(
<span class="hljs-meta">... </span>    prompt=<span class="hljs-string">&quot;I saw a puppy a cat and a raccoon during my bike ride in the park&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;HuggingFaceH4/zephyr-orpo-141b-A35b-v0.1&quot;</span>,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    repetition_penalty=<span class="hljs-number">1.3</span>,
<span class="hljs-meta">... </span>    grammar={
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;json&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;value&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;activity&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;animals_seen&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>, <span class="hljs-string">&quot;minimum&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;maximum&quot;</span>: <span class="hljs-number">5</span>},
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;animals&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;array&quot;</span>, <span class="hljs-string">&quot;items&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}},
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;activity&quot;</span>, <span class="hljs-string">&quot;animals_seen&quot;</span>, <span class="hljs-string">&quot;animals&quot;</span>],
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>json.loads(response)
{
    <span class="hljs-string">&quot;activity&quot;</span>: <span class="hljs-string">&quot;bike riding&quot;</span>,
    <span class="hljs-string">&quot;animals&quot;</span>: [<span class="hljs-string">&quot;puppy&quot;</span>, <span class="hljs-string">&quot;cat&quot;</span>, <span class="hljs-string">&quot;raccoon&quot;</span>],
    <span class="hljs-string">&quot;animals_seen&quot;</span>: <span class="hljs-number">3</span>,
    <span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;park&quot;</span>
}`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function cf(I){let n,m="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=u("p"),n.innerHTML=m},l(a){n=g(a,"P",{"data-svelte-h":!0}),T(n)!=="svelte-s2e3n9"&&(n.innerHTML=m)},m(a,t){_(a,n,t)},p:x,d(a){a&&p(n)}}}function pf(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQSUwQWltYWdlJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQudGV4dF90b19pbWFnZSglMjJBbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwdGhlJTIwbW9vbi4lMjIpJTBBaW1hZ2Uuc2F2ZSglMjJhc3Ryb25hdXQucG5nJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQudGV4dF90b19pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJBbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwdGhlJTIwbW9vbi4lMjIlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0QlMjJsb3clMjByZXNvbHV0aW9uJTJDJTIwYmx1cnJ5JTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMi0xJTIyJTJDJTBBKSUwQWltYWdlLnNhdmUoJTIyYmV0dGVyX2FzdHJvbmF1dC5wbmclMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-keyword">await</span> client.text_to_image(<span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;astronaut.png&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-keyword">await</span> client.text_to_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>,
<span class="hljs-meta">... </span>    negative_prompt=<span class="hljs-string">&quot;low resolution, blurry&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;better_astronaut.png&quot;</span>)`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function uf(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQSUwQWF1ZGlvJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQudGV4dF90b19zcGVlY2goJTIySGVsbG8lMjB3b3JsZCUyMiklMEFQYXRoKCUyMmhlbGxvX3dvcmxkLmZsYWMlMjIpLndyaXRlX2J5dGVzKGF1ZGlvKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>audio = <span class="hljs-keyword">await</span> client.text_to_speech(<span class="hljs-string">&quot;Hello world&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>Path(<span class="hljs-string">&quot;hello_world.flac&quot;</span>).write_bytes(audio)`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function gf(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnRva2VuX2NsYXNzaWZpY2F0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwU2FyYWglMjBKZXNzaWNhJTIwUGFya2VyJTIwYnV0JTIweW91JTIwY2FuJTIwY2FsbCUyMG1lJTIwSmVzc2ljYSUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.token_classification(<span class="hljs-string">&quot;My name is Sarah Jessica Parker but you can call me Jessica&quot;</span>)
[
    TokenClassificationOutputElement(
        entity_group=<span class="hljs-string">&#x27;PER&#x27;</span>,
        score=<span class="hljs-number">0.9971321225166321</span>,
        word=<span class="hljs-string">&#x27;Sarah Jessica Parker&#x27;</span>,
        start=<span class="hljs-number">11</span>,
        end=<span class="hljs-number">31</span>,
    ),
    TokenClassificationOutputElement(
        entity_group=<span class="hljs-string">&#x27;PER&#x27;</span>,
        score=<span class="hljs-number">0.9773476123809814</span>,
        word=<span class="hljs-string">&#x27;Jessica&#x27;</span>,
        start=<span class="hljs-number">52</span>,
        end=<span class="hljs-number">59</span>,
    )
]`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function mf(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnRyYW5zbGF0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwV29sZmdhbmclMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwQmVybGluJTIyKSUwQWF3YWl0JTIwY2xpZW50LnRyYW5zbGF0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwV29sZmdhbmclMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwQmVybGluJTIyJTJDJTIwbW9kZWwlM0QlMjJIZWxzaW5raS1OTFAlMkZvcHVzLW10LWVuLWZyJTIyKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.translation(<span class="hljs-string">&quot;My name is Wolfgang and I live in Berlin&quot;</span>)
<span class="hljs-string">&#x27;Mein Name ist Wolfgang und ich lebe in Berlin.&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.translation(<span class="hljs-string">&quot;My name is Wolfgang and I live in Berlin&quot;</span>, model=<span class="hljs-string">&quot;Helsinki-NLP/opus-mt-en-fr&quot;</span>)
TranslationOutput(translation_text=<span class="hljs-string">&#x27;Je m&#x27;</span>appelle Wolfgang et je vis à Berlin.<span class="hljs-string">&#x27;)</span>`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function hf(I){let n,m="Specifying languages:",a,t,o;return t=new q({props:{code:"Y2xpZW50LnRyYW5zbGF0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwU2FyYWglMjBKZXNzaWNhJTIwUGFya2VyJTIwYnV0JTIweW91JTIwY2FuJTIwY2FsbCUyMG1lJTIwSmVzc2ljYSUyMiUyQyUyMG1vZGVsJTNEJTIyZmFjZWJvb2slMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JTIyJTJDJTIwc3JjX2xhbmclM0QlMjJlbl9YWCUyMiUyQyUyMHRndF9sYW5nJTNEJTIyZnJfWFglMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>client.translation(<span class="hljs-string">&quot;My name is Sarah Jessica Parker but you can call me Jessica&quot;</span>, model=<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-many-mmt&quot;</span>, src_lang=<span class="hljs-string">&quot;en_XX&quot;</span>, tgt_lang=<span class="hljs-string">&quot;fr_XX&quot;</span>)
<span class="hljs-string">&quot;Mon nom est Sarah Jessica Parker mais vous pouvez m&#x27;appeler Jessica&quot;</span>`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-mhcj6c"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function df(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnZpc3VhbF9xdWVzdGlvbl9hbnN3ZXJpbmcoJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0QlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZtaXNoaWclMkZzYW1wbGVfaW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0aWdlci5qcGclMjIlMkMlMEElMjAlMjAlMjAlMjBxdWVzdGlvbiUzRCUyMldoYXQlMjBpcyUyMHRoZSUyMGFuaW1hbCUyMGRvaW5nJTNGJTIyJTBBKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.visual_question_answering(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;https://huggingface.co/datasets/mishig/sample_images/resolve/main/tiger.jpg&quot;</span>,
<span class="hljs-meta">... </span>    question=<span class="hljs-string">&quot;What is the animal doing?&quot;</span>
<span class="hljs-meta">... </span>)
[
    VisualQuestionAnsweringOutputElement(score=<span class="hljs-number">0.778609573841095</span>, answer=<span class="hljs-string">&#x27;laying down&#x27;</span>),
    VisualQuestionAnsweringOutputElement(score=<span class="hljs-number">0.6957435607910156</span>, answer=<span class="hljs-string">&#x27;sitting&#x27;</span>),
]`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function ff(I){let n,m="Example with <code>multi_label=False</code>:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQXRleHQlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwJTIyQSUyMG5ldyUyMG1vZGVsJTIwb2ZmZXJzJTIwYW4lMjBleHBsYW5hdGlvbiUyMGZvciUyMGhvdyUyMHRoZSUyMEdhbGlsZWFuJTIwc2F0ZWxsaXRlcyUyMGZvcm1lZCUyMGFyb3VuZCUyMHRoZSUyMHNvbGFyJTIwc3lzdGVtJ3MlMjIlMEElMjAlMjAlMjAlMjAlMjJsYXJnZXN0JTIwd29ybGQuJTIwS29uc3RhbnRpbiUyMEJhdHlnaW4lMjBkaWQlMjBub3QlMjBzZXQlMjBvdXQlMjB0byUyMHNvbHZlJTIwb25lJTIwb2YlMjB0aGUlMjBzb2xhciUyMHN5c3RlbSdzJTIwbW9zdCUyMHB1enpsaW5nJTIyJTBBJTIwJTIwJTIwJTIwJTIyJTIwbXlzdGVyaWVzJTIwd2hlbiUyMGhlJTIwd2VudCUyMGZvciUyMGElMjBydW4lMjB1cCUyMGElMjBoaWxsJTIwaW4lMjBOaWNlJTJDJTIwRnJhbmNlLiUyMiUwQSklMEFsYWJlbHMlMjAlM0QlMjAlNUIlMjJzcGFjZSUyMCUyNiUyMGNvc21vcyUyMiUyQyUyMCUyMnNjaWVudGlmaWMlMjBkaXNjb3ZlcnklMjIlMkMlMjAlMjJtaWNyb2Jpb2xvZ3klMjIlMkMlMjAlMjJyb2JvdHMlMjIlMkMlMjAlMjJhcmNoZW9sb2d5JTIyJTVEJTBBYXdhaXQlMjBjbGllbnQuemVyb19zaG90X2NsYXNzaWZpY2F0aW9uKHRleHQlMkMlMjBsYWJlbHMpJTBBYXdhaXQlMjBjbGllbnQuemVyb19zaG90X2NsYXNzaWZpY2F0aW9uKHRleHQlMkMlMjBsYWJlbHMlMkMlMjBtdWx0aV9sYWJlbCUzRFRydWUp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>text = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A new model offers an explanation for how the Galilean satellites formed around the solar system&#x27;s&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;largest world. Konstantin Batygin did not set out to solve one of the solar system&#x27;s most puzzling&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot; mysteries when he went for a run up a hill in Nice, France.&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = [<span class="hljs-string">&quot;space &amp; cosmos&quot;</span>, <span class="hljs-string">&quot;scientific discovery&quot;</span>, <span class="hljs-string">&quot;microbiology&quot;</span>, <span class="hljs-string">&quot;robots&quot;</span>, <span class="hljs-string">&quot;archeology&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.zero_shot_classification(text, labels)
[
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;scientific discovery&#x27;</span>, score=<span class="hljs-number">0.7961668968200684</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;space &amp; cosmos&#x27;</span>, score=<span class="hljs-number">0.18570658564567566</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;microbiology&#x27;</span>, score=<span class="hljs-number">0.00730885099619627</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;archeology&#x27;</span>, score=<span class="hljs-number">0.006258360575884581</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;robots&#x27;</span>, score=<span class="hljs-number">0.004559356719255447</span>),
]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.zero_shot_classification(text, labels, multi_label=<span class="hljs-literal">True</span>)
[
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;scientific discovery&#x27;</span>, score=<span class="hljs-number">0.9829297661781311</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;space &amp; cosmos&#x27;</span>, score=<span class="hljs-number">0.755190908908844</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;microbiology&#x27;</span>, score=<span class="hljs-number">0.0005462635890580714</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;archeology&#x27;</span>, score=<span class="hljs-number">0.00047131875180639327</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;robots&#x27;</span>, score=<span class="hljs-number">0.00030448526376858354</span>),
]`,wrap:!1}}),{c(){n=u("p"),n.innerHTML=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-90ztrp"&&(n.innerHTML=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function yf(I){let n,m="Example with <code>multi_label=True</code> and a custom <code>hypothesis_template</code>:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50Lnplcm9fc2hvdF9jbGFzc2lmaWNhdGlvbiglMEElMjAlMjAlMjB0ZXh0JTNEJTIySSUyMHJlYWxseSUyMGxpa2UlMjBvdXIlMjBkaW5uZXIlMjBhbmQlMjBJJ20lMjB2ZXJ5JTIwaGFwcHkuJTIwSSUyMGRvbid0JTIwbGlrZSUyMHRoZSUyMHdlYXRoZXIlMjB0aG91Z2guJTIyJTJDJTBBJTIwJTIwJTIwbGFiZWxzJTNEJTVCJTIycG9zaXRpdmUlMjIlMkMlMjAlMjJuZWdhdGl2ZSUyMiUyQyUyMCUyMnBlc3NpbWlzdGljJTIyJTJDJTIwJTIyb3B0aW1pc3RpYyUyMiU1RCUyQyUwQSUyMCUyMCUyMG11bHRpX2xhYmVsJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMGh5cG90aGVzaXNfdGVtcGxhdGUlM0QlMjJUaGlzJTIwdGV4dCUyMGlzJTIwJTdCJTdEJTIwdG93YXJkcyUyMHRoZSUyMHdlYXRoZXIlMjIlMEEp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.zero_shot_classification(
<span class="hljs-meta">... </span>   text=<span class="hljs-string">&quot;I really like our dinner and I&#x27;m very happy. I don&#x27;t like the weather though.&quot;</span>,
<span class="hljs-meta">... </span>   labels=[<span class="hljs-string">&quot;positive&quot;</span>, <span class="hljs-string">&quot;negative&quot;</span>, <span class="hljs-string">&quot;pessimistic&quot;</span>, <span class="hljs-string">&quot;optimistic&quot;</span>],
<span class="hljs-meta">... </span>   multi_label=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>   hypothesis_template=<span class="hljs-string">&quot;This text is {} towards the weather&quot;</span>
<span class="hljs-meta">... </span>)
[
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;negative&#x27;</span>, score=<span class="hljs-number">0.9231801629066467</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;pessimistic&#x27;</span>, score=<span class="hljs-number">0.8760990500450134</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;optimistic&#x27;</span>, score=<span class="hljs-number">0.0008674879791215062</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;positive&#x27;</span>, score=<span class="hljs-number">0.0005250611575320363</span>)
]`,wrap:!1}}),{c(){n=u("p"),n.innerHTML=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1qklg9x"&&(n.innerHTML=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function bf(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQSUwQWF3YWl0JTIwY2xpZW50Lnplcm9fc2hvdF9pbWFnZV9jbGFzc2lmaWNhdGlvbiglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRnVwbG9hZC53aWtpbWVkaWEub3JnJTJGd2lraXBlZGlhJTJGY29tbW9ucyUyRnRodW1iJTJGNCUyRjQzJTJGQ3V0ZV9kb2cuanBnJTJGMzIwcHgtQ3V0ZV9kb2cuanBnJTIyJTJDJTBBJTIwJTIwJTIwJTIwbGFiZWxzJTNEJTVCJTIyZG9nJTIyJTJDJTIwJTIyY2F0JTIyJTJDJTIwJTIyaG9yc2UlMjIlNUQlMkMlMEEp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.zero_shot_image_classification(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>,
<span class="hljs-meta">... </span>    labels=[<span class="hljs-string">&quot;dog&quot;</span>, <span class="hljs-string">&quot;cat&quot;</span>, <span class="hljs-string">&quot;horse&quot;</span>],
<span class="hljs-meta">... </span>)
[ZeroShotImageClassificationOutputElement(label=<span class="hljs-string">&#x27;dog&#x27;</span>, score=<span class="hljs-number">0.956</span>),...]`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function Mf(I){let n,m="Example:",a,t,o;return t=new q({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub.inference_api <span class="hljs-keyword">import</span> InferenceApi

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Mask-fill example</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(inputs=<span class="hljs-string">&quot;The goal of life is [MASK].&quot;</span>)
[{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;the goal of life is life.&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.10933292657136917</span>, <span class="hljs-string">&#x27;token&#x27;</span>: <span class="hljs-number">2166</span>, <span class="hljs-string">&#x27;token_str&#x27;</span>: <span class="hljs-string">&#x27;life&#x27;</span>}]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Question Answering example</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;deepset/roberta-base-squad2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;question&quot;</span>: <span class="hljs-string">&quot;What&#x27;s my name?&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;context&quot;</span>: <span class="hljs-string">&quot;My name is Clara and I live in Berkeley.&quot;</span>,
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(inputs)
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9326569437980652</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">11</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">16</span>, <span class="hljs-string">&#x27;answer&#x27;</span>: <span class="hljs-string">&#x27;Clara&#x27;</span>}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Zero-shot example</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;typeform/distilbert-base-uncased-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = <span class="hljs-string">&quot;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>params = {<span class="hljs-string">&quot;candidate_labels&quot;</span>: [<span class="hljs-string">&quot;refund&quot;</span>, <span class="hljs-string">&quot;legal&quot;</span>, <span class="hljs-string">&quot;faq&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(inputs, params)
{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>: [<span class="hljs-string">&#x27;refund&#x27;</span>, <span class="hljs-string">&#x27;faq&#x27;</span>, <span class="hljs-string">&#x27;legal&#x27;</span>], <span class="hljs-string">&#x27;scores&#x27;</span>: [<span class="hljs-number">0.9378499388694763</span>, <span class="hljs-number">0.04914155602455139</span>, <span class="hljs-number">0.013008488342165947</span>]}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Overriding configured task</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>, task=<span class="hljs-string">&quot;feature-extraction&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Text-to-image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(<span class="hljs-string">&quot;cat&quot;</span>)
&lt;PIL.PngImagePlugin.PngImageFile image (...)&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Return as raw response to parse the output yourself</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;mio/amadeus&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response = inference(<span class="hljs-string">&quot;hello world&quot;</span>, raw_response=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.headers
{<span class="hljs-string">&quot;Content-Type&quot;</span>: <span class="hljs-string">&quot;audio/flac&quot;</span>, ...}
<span class="hljs-meta">&gt;&gt;&gt; </span>response.content <span class="hljs-comment"># raw bytes from server</span>
<span class="hljs-string">b&#x27;(...)&#x27;</span>`,wrap:!1}}),{c(){n=u("p"),n.textContent=m,a=r(),h(t.$$.fragment)},l(e){n=g(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=m),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:x,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){b(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),M(t,e)}}}function jf(I){let n,m,a,t,o,e,c,Eg="추론은 학습된 모델을 사용하여 새로운 데이터를 예측하는 과정입니다. 이 과정은 계산량이 많을 수 있기 때문에, 전용 서버에서 실행하는 것이 흥미로운 옵션이 될 수 있습니다. <code>huggingface_hub</code> 라이브러리는 호스팅된 모델에 대한 추론을 실행하는 간단한 방법을 제공합니다. 연결할 수 있는 서비스는 여러가지가 있습니다:",$r,zs,Ag='<li><a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">추론 API</a>: Hugging Face의 인프라에서 가속화된 추론을 무료로 실행할 수 있는 서비스입니다. 이 서비스는 시작하기 위한 빠른 방법이며, 다양한 모델을 테스트하고 AI 제품을 프로토타입화하는 데에도 유용합니다.</li> <li><a href="https://huggingface.co/inference-endpoints" rel="nofollow">추론 엔드포인트</a>: 모델을 쉽게 운영 환경으로 배포할 수 있는 제품입니다. 추론은 여러분이 선택한 클라우드 제공업체의 전용 및 완전히 관리되는 인프라에서 Hugging Face에 의해 실행됩니다.</li>',vr,Fs,Zg='이러한 서비스는 <a href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> 객체를 사용하여 호출할 수 있습니다. 자세한 사용 방법에 대해서는 <a href="../guides/inference">이 가이드</a>를 참조해주세요.',kr,Ls,qr,C,Os,Kr,Yl,Ng="Initialize a new Inference Client.",ei,Sl,Wg=`<a href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> aims to provide a unified experience to perform inference. The client can be used
seamlessly with either the (free) Inference API or self-hosted Inference Endpoints.`,ni,Ze,Ps,ti,Rl,Gg="Perform audio classification on the provided audio content.",si,ct,ai,Ne,Ks,li,Dl,Bg="Performs multiple tasks related to audio-to-audio depending on the model (eg: speech enhancement, source separation).",oi,pt,ri,We,ea,ii,Xl,Qg="Perform automatic speech recognition (ASR or audio-to-text) on the given audio content.",ci,ut,pi,Ge,na,ui,Hl,Vg="A method for completing conversations using a specified language model.",gi,gt,mi,F,ta,hi,zl,Yg="Generate conversational responses based on the given input text (i.e. chat with the API).",di,mt,fi,ht,yi,Be,sa,bi,Fl,Sg="Answer questions on document images.",Mi,dt,ji,Qe,aa,_i,Ll,Rg="Generate embeddings for a given text.",Ti,ft,Ii,Ve,la,xi,Ol,Dg="Fill in a hole with a missing word (token to be precise).",Ci,yt,Ui,L,oa,wi,Pl,Xg="Get information about the deployed endpoint.",Ji,Kl,Hg=`This endpoint is only available on endpoints powered by Text-Generation-Inference (TGI) or Text-Embedding-Inference (TEI).
Endpoints powered by <code>transformers</code> return an empty payload.`,$i,bt,vi,O,ra,ki,eo,zg="Get the status of a model hosted on the Inference API.",qi,Mt,Ei,jt,Ai,_t,ia,Zi,no,Fg="Get the model Hugging Face recommends for the input task.",Ni,P,ca,Wi,to,Lg="Check the health of the deployed endpoint.",Gi,so,Og=`Health check is only available with Inference Endpoints powered by Text-Generation-Inference (TGI) or Text-Embedding-Inference (TEI).
For Inference API, please use <a href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceClient.get_model_status">InferenceClient.get_model_status()</a> instead.`,Bi,Tt,Qi,Ye,pa,Vi,ao,Pg="Perform image classification on the given image using the specified model.",Yi,It,Si,K,ua,Ri,lo,Kg="Perform image segmentation on the given image using the specified model.",Di,xt,Xi,Ct,Hi,ee,ga,zi,oo,em="Perform image-to-image translation using a specified model.",Fi,Ut,Li,wt,Oi,ne,ma,Pi,ro,nm="Takes an input image and return text.",Ki,io,tm=`Models can have very different outputs depending on your use case (image captioning, optical character recognition
(OCR), Pix2Struct, etc). Please have a look to the model card to learn more about a model’s specificities.`,ec,Jt,nc,Z,ha,tc,co,sm="List models deployed on the Serverless Inference API service.",sc,po,am=`This helper checks deployed models framework by framework. By default, it will check the 4 main frameworks that
are supported and account for 95% of the hosted models. However, if you want a complete list of models you can
specify <code>frameworks=&quot;all&quot;</code> as input. Alternatively, if you know before-hand which framework you are interested
in, you can also restrict to search to this one (e.g. <code>frameworks=&quot;text-generation-inference&quot;</code>). The more
frameworks are checked, the more time it will take.`,ac,$t,lc,vt,oc,kt,rc,te,da,ic,uo,lm="Perform object detection on the given image using the specified model.",cc,qt,pc,Et,uc,At,fa,gc,go,om="Make a POST request to the inference server.",mc,Se,ya,hc,mo,rm="Retrieve the answer to a question from a given text.",dc,Zt,fc,Re,ba,yc,ho,im="Compute the semantic similarity between a sentence and a list of other sentences by comparing their embeddings.",bc,Nt,Mc,De,Ma,jc,fo,cm="Generate a summary of a given text using a specified model.",_c,Wt,Tc,Xe,ja,Ic,yo,pm="Retrieve the answer to a question from information given in a table.",xc,Gt,Cc,He,_a,Uc,bo,um="Classifying a target category (a group) based on a set of attributes.",wc,Bt,Jc,ze,Ta,$c,Mo,gm="Predicting a numerical target value given a set of attributes/features in a table.",vc,Qt,kc,Fe,Ia,qc,jo,mm="Perform text classification (e.g. sentiment-analysis) on the given text.",Ec,Vt,Ac,N,xa,Zc,_o,hm="Given a prompt, generate the following text.",Nc,To,dm=`API endpoint is supposed to run with the <code>text-generation-inference</code> backend (TGI). This backend is the
go-to solution to run large language models at scale. However, for some smaller models (e.g. “gpt2”) the
default <code>transformers</code> + <code>api-inference</code> solution is still in use. Both approaches have very similar APIs, but
not exactly the same. This method is compatible with both approaches but some parameters are only available for
<code>text-generation-inference</code>. If some parameters are ignored, a warning message is triggered but the process
continues correctly.`,Wc,Io,fm='To learn more about the TGI project, please refer to <a href="https://github.com/huggingface/text-generation-inference" rel="nofollow">https://github.com/huggingface/text-generation-inference</a>.',Gc,Yt,Bc,St,Qc,se,Ca,Vc,xo,ym="Generate an image based on a given text using a specified model.",Yc,Rt,Sc,Dt,Rc,Le,Ua,Dc,Co,bm="Synthesize an audio of a voice pronouncing a given text.",Xc,Xt,Hc,Oe,wa,zc,Uo,Mm=`Perform token classification on the given text.
Usually used for sentence parsing, either grammatical, or Named Entity Recognition (NER) to understand keywords contained within text.`,Fc,Ht,Lc,R,Ja,Oc,wo,jm="Convert text from one language to another.",Pc,Jo,_m=`Check out <a href="https://huggingface.co/tasks/translation" rel="nofollow">https://huggingface.co/tasks/translation</a> for more information on how to choose the best model for
your specific use case. Source and target languages usually depend on the model.
However, it is possible to specify source and target languages for certain models. If you are working with one of these models,
you can use <code>src_lang</code> and <code>tgt_lang</code> arguments to pass the relevant information.
You can find this information in the model card.`,Kc,zt,ep,Ft,np,Pe,$a,tp,$o,Tm="Answering open-ended questions based on an image.",sp,Lt,ap,ae,va,lp,vo,Im="Provide as input a text and a set of candidate labels to classify the input text.",op,Ot,rp,Pt,ip,Ke,ka,cp,ko,xm="Provide input image and text labels to predict text labels for the image.",pp,Kt,Er,qa,Ar,Ea,Cm=`비동기 버전의 클라이언트도 제공되며, 이는 <code>asyncio</code>와 <code>aiohttp</code>를 기반으로 작동합니다.
이를 사용하려면 <code>aiohttp</code>를 직접 설치하거나 <code>[inference]</code> 추가 기능을 사용할 수 있습니다:`,Zr,Aa,Nr,U,Za,up,qo,Um="Initialize a new Inference Client.",gp,Eo,wm=`<a href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> aims to provide a unified experience to perform inference. The client can be used
seamlessly with either the (free) Inference API or self-hosted Inference Endpoints.`,mp,en,Na,hp,Ao,Jm="Perform audio classification on the provided audio content.",dp,es,fp,nn,Wa,yp,Zo,$m="Performs multiple tasks related to audio-to-audio depending on the model (eg: speech enhancement, source separation).",bp,ns,Mp,tn,Ga,jp,No,vm="Perform automatic speech recognition (ASR or audio-to-text) on the given audio content.",_p,ts,Tp,sn,Ba,Ip,Wo,km="A method for completing conversations using a specified language model.",xp,ss,Cp,le,Qa,Up,Go,qm="Generate conversational responses based on the given input text (i.e. chat with the API).",wp,as,Jp,ls,$p,an,Va,vp,Bo,Em="Answer questions on document images.",kp,os,qp,ln,Ya,Ep,Qo,Am="Generate embeddings for a given text.",Ap,rs,Zp,on,Sa,Np,Vo,Zm="Fill in a hole with a missing word (token to be precise).",Wp,is,Gp,oe,Ra,Bp,Yo,Nm="Get information about the deployed endpoint.",Qp,So,Wm=`This endpoint is only available on endpoints powered by Text-Generation-Inference (TGI) or Text-Embedding-Inference (TEI).
Endpoints powered by <code>transformers</code> return an empty payload.`,Vp,cs,Yp,re,Da,Sp,Ro,Gm="Get the status of a model hosted on the Inference API.",Rp,ps,Dp,us,Xp,gs,Xa,Hp,Do,Bm="Get the model Hugging Face recommends for the input task.",zp,ie,Ha,Fp,Xo,Qm="Check the health of the deployed endpoint.",Lp,Ho,Vm=`Health check is only available with Inference Endpoints powered by Text-Generation-Inference (TGI) or Text-Embedding-Inference (TEI).
For Inference API, please use <a href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceClient.get_model_status">InferenceClient.get_model_status()</a> instead.`,Op,ms,Pp,rn,za,Kp,zo,Ym="Perform image classification on the given image using the specified model.",eu,hs,nu,ce,Fa,tu,Fo,Sm="Perform image segmentation on the given image using the specified model.",su,ds,au,fs,lu,pe,La,ou,Lo,Rm="Perform image-to-image translation using a specified model.",ru,ys,iu,bs,cu,ue,Oa,pu,Oo,Dm="Takes an input image and return text.",uu,Po,Xm=`Models can have very different outputs depending on your use case (image captioning, optical character recognition
(OCR), Pix2Struct, etc). Please have a look to the model card to learn more about a model’s specificities.`,gu,Ms,mu,W,Pa,hu,Ko,Hm="List models deployed on the Serverless Inference API service.",du,er,zm=`This helper checks deployed models framework by framework. By default, it will check the 4 main frameworks that
are supported and account for 95% of the hosted models. However, if you want a complete list of models you can
specify <code>frameworks=&quot;all&quot;</code> as input. Alternatively, if you know before-hand which framework you are interested
in, you can also restrict to search to this one (e.g. <code>frameworks=&quot;text-generation-inference&quot;</code>). The more
frameworks are checked, the more time it will take.`,fu,js,yu,_s,bu,Ts,Mu,ge,Ka,ju,nr,Fm="Perform object detection on the given image using the specified model.",_u,Is,Tu,xs,Iu,Cs,el,xu,tr,Lm="Make a POST request to the inference server.",Cu,cn,nl,Uu,sr,Om="Retrieve the answer to a question from a given text.",wu,Us,Ju,pn,tl,$u,ar,Pm="Compute the semantic similarity between a sentence and a list of other sentences by comparing their embeddings.",vu,ws,ku,un,sl,qu,lr,Km="Generate a summary of a given text using a specified model.",Eu,Js,Au,gn,al,Zu,or,eh="Retrieve the answer to a question from information given in a table.",Nu,$s,Wu,mn,ll,Gu,rr,nh="Classifying a target category (a group) based on a set of attributes.",Bu,vs,Qu,hn,ol,Vu,ir,th="Predicting a numerical target value given a set of attributes/features in a table.",Yu,ks,Su,dn,rl,Ru,cr,sh="Perform text classification (e.g. sentiment-analysis) on the given text.",Du,qs,Xu,G,il,Hu,pr,ah="Given a prompt, generate the following text.",zu,ur,lh=`API endpoint is supposed to run with the <code>text-generation-inference</code> backend (TGI). This backend is the
go-to solution to run large language models at scale. However, for some smaller models (e.g. “gpt2”) the
default <code>transformers</code> + <code>api-inference</code> solution is still in use. Both approaches have very similar APIs, but
not exactly the same. This method is compatible with both approaches but some parameters are only available for
<code>text-generation-inference</code>. If some parameters are ignored, a warning message is triggered but the process
continues correctly.`,Fu,gr,oh='To learn more about the TGI project, please refer to <a href="https://github.com/huggingface/text-generation-inference" rel="nofollow">https://github.com/huggingface/text-generation-inference</a>.',Lu,Es,Ou,As,Pu,me,cl,Ku,mr,rh="Generate an image based on a given text using a specified model.",eg,Zs,ng,Ns,tg,fn,pl,sg,hr,ih="Synthesize an audio of a voice pronouncing a given text.",ag,Ws,lg,yn,ul,og,dr,ch=`Perform token classification on the given text.
Usually used for sentence parsing, either grammatical, or Named Entity Recognition (NER) to understand keywords contained within text.`,rg,Gs,ig,D,gl,cg,fr,ph="Convert text from one language to another.",pg,yr,uh=`Check out <a href="https://huggingface.co/tasks/translation" rel="nofollow">https://huggingface.co/tasks/translation</a> for more information on how to choose the best model for
your specific use case. Source and target languages usually depend on the model.
However, it is possible to specify source and target languages for certain models. If you are working with one of these models,
you can use <code>src_lang</code> and <code>tgt_lang</code> arguments to pass the relevant information.
You can find this information in the model card.`,ug,Bs,gg,Qs,mg,bn,ml,hg,br,gh="Answering open-ended questions based on an image.",dg,Vs,fg,he,hl,yg,Mr,mh="Provide as input a text and a set of candidate labels to classify the input text.",bg,Ys,Mg,Ss,jg,Mn,dl,_g,jr,hh="Provide input image and text labels to predict text labels for the image.",Tg,Rs,Wr,fl,Gr,jn,yl,Ig,_r,dh="Error raised when a model is unavailable or the request times out.",Br,bl,Qr,Ml,fh="대부분의 작업에 대해, 반환 값은 내장된 유형(string, list, image…)을 갖습니다. 보다 복잡한 유형을 위한 목록은 다음과 같습니다.",Vr,jl,Yr,_n,_l,xg,Tr,yh='Dictionary containing the “conversation” part of a <a href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceClient.conversational">conversational()</a> task.',Sr,Tl,Rr,Tn,Il,Cg,Ir,bh='Dictionary containing the output of a  <a href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceClient.conversational">conversational()</a> task.',Dr,xl,Xr,In,Cl,Ug,xr,Mh="This Dataclass represents the the model status in the Hugging Face Inference API.",Hr,Ul,zr,wl,jh='<code>InferenceAPI</code>는 추론 API를 호출하는 레거시 방식입니다. 이 인터페이스는 더 간단하며 각 작업의 입력 매개변수와 출력 형식을 알아야 합니다. 또한 추론 엔드포인트나 AWS SageMaker와 같은 다른 서비스에 연결할 수 있는 기능이 없습니다. <code>InferenceAPI</code>는 곧 폐지될 예정이므로 가능한 경우 <a href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>를 사용하는 것을 권장합니다. 스크립트에서 <code>InferenceAPI</code>를 <a href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>로 전환하는 방법에 대해 알아보려면 <a href="../guides/inference#legacy-inferenceapi-client">이 가이드</a>를 참조하세요.',Fr,B,Jl,wg,Cr,_h="Client to configure requests and make calls to the HuggingFace Inference API.",Jg,Ds,$g,Xs,$l,vg,Ur,Th="Inits headers and API call information.",kg,Hs,vl,qg,wr,Ih="Make a call to the Inference API.",Lr,kl,Or,Jr,Pr;return o=new it({props:{title:"추론",local:"inference",headingTag:"h1"}}),Ls=new it({props:{title:"추론 클라이언트",local:"huggingface_hub.InferenceClient ][ huggingface_hub.InferenceClient",headingTag:"h2"}}),Os=new k({props:{name:"class huggingface_hub.InferenceClient",anchor:"huggingface_hub.InferenceClient",parameters:[{name:"model",val:": Optional = None"},{name:"token",val:": Union = None"},{name:"timeout",val:": Optional = None"},{name:"headers",val:": Optional = None"},{name:"cookies",val:": Optional = None"},{name:"proxies",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.model",description:`<strong>model</strong> (<code>str</code>, <code>optional</code>) &#x2014;
The model to run inference with. Can be a model id hosted on the Hugging Face Hub, e.g. <code>bigcode/starcoder</code>
or a URL to a deployed Inference Endpoint. Defaults to None, in which case a recommended model is
automatically selected for the task.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.token",description:`<strong>token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
Hugging Face token. Will default to the locally saved token if not provided.
Pass <code>token=False</code> if you don&#x2019;t want to send your token to the server.`,name:"token"},{anchor:"huggingface_hub.InferenceClient.timeout",description:`<strong>timeout</strong> (<code>float</code>, <code>optional</code>) &#x2014;
The maximum number of seconds to wait for a response from the server. Loading a new model in Inference
API can take up to several minutes. Defaults to None, meaning it will loop until the server is available.`,name:"timeout"},{anchor:"huggingface_hub.InferenceClient.headers",description:`<strong>headers</strong> (<code>Dict[str, str]</code>, <code>optional</code>) &#x2014;
Additional headers to send to the server. By default only the authorization and user-agent headers are sent.
Values in this dictionary will override the default values.`,name:"headers"},{anchor:"huggingface_hub.InferenceClient.cookies",description:`<strong>cookies</strong> (<code>Dict[str, str]</code>, <code>optional</code>) &#x2014;
Additional cookies to send to the server.`,name:"cookies"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_client.py#L128"}}),Ps=new k({props:{name:"audio_classification",anchor:"huggingface_hub.InferenceClient.audio_classification",parameters:[{name:"audio",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.audio_classification.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The audio content to classify. It can be raw audio bytes, a local audio file, or a URL pointing to an
audio file.`,name:"audio"},{anchor:"huggingface_hub.InferenceClient.audio_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for audio classification. Can be a model ID hosted on the Hugging Face Hub
or a URL to a deployed Inference Endpoint. If not provided, the default recommended model for
audio classification will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_client.py#L302",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.AudioClassificationOutputElement"
>AudioClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[AudioClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),ct=new E({props:{anchor:"huggingface_hub.InferenceClient.audio_classification.example",$$slots:{default:[Qh]},$$scope:{ctx:I}}}),Ks=new k({props:{name:"audio_to_audio",anchor:"huggingface_hub.InferenceClient.audio_to_audio",parameters:[{name:"audio",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.audio_to_audio.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The audio content for the model. It can be raw audio bytes, a local audio file, or a URL pointing to an
audio file.`,name:"audio"},{anchor:"huggingface_hub.InferenceClient.audio_to_audio.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model can be any model which takes an audio file and returns another audio file. Can be a model ID hosted on the Hugging Face Hub
or a URL to a deployed Inference Endpoint. If not provided, the default recommended model for
audio_to_audio will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_client.py#L344",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.AudioToAudioOutputElement"
>AudioToAudioOutputElement</a> items containing audios label, content-type, and audio content in blob.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[AudioToAudioOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>InferenceTimeoutError</code> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>InferenceTimeoutError</code> or <code>HTTPError</code></p>
`}}),pt=new E({props:{anchor:"huggingface_hub.InferenceClient.audio_to_audio.example",$$slots:{default:[Vh]},$$scope:{ctx:I}}}),ea=new k({props:{name:"automatic_speech_recognition",anchor:"huggingface_hub.InferenceClient.automatic_speech_recognition",parameters:[{name:"audio",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.automatic_speech_recognition.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The content to transcribe. It can be raw audio bytes, local audio file, or a URL to an audio file.`,name:"audio"},{anchor:"huggingface_hub.InferenceClient.automatic_speech_recognition.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for ASR. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended model for ASR will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_client.py#L387",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An item containing the transcribed text and optionally the timestamp chunks.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.AutomaticSpeechRecognitionOutput"
>AutomaticSpeechRecognitionOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),ut=new E({props:{anchor:"huggingface_hub.InferenceClient.automatic_speech_recognition.example",$$slots:{default:[Yh]},$$scope:{ctx:I}}}),na=new k({props:{name:"chat_completion",anchor:"huggingface_hub.InferenceClient.chat_completion",parameters:[{name:"messages",val:": List"},{name:"model",val:": Optional = None"},{name:"stream",val:": bool = False"},{name:"frequency_penalty",val:": Optional = None"},{name:"logit_bias",val:": Optional = None"},{name:"logprobs",val:": Optional = None"},{name:"max_tokens",val:": Optional = None"},{name:"n",val:": Optional = None"},{name:"presence_penalty",val:": Optional = None"},{name:"seed",val:": Optional = None"},{name:"stop",val:": Optional = None"},{name:"temperature",val:": Optional = None"},{name:"tool_choice",val:": Union = None"},{name:"tool_prompt",val:": Optional = None"},{name:"tools",val:": Optional = None"},{name:"top_logprobs",val:": Optional = None"},{name:"top_p",val:": Optional = None"},{name:"model_id",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.chat_completion.messages",description:`<strong>messages</strong> (List[Union[<code>SystemMessage</code>, <code>UserMessage</code>, <code>AssistantMessage</code>]]) &#x2014;
Conversation history consisting of roles and content pairs.`,name:"messages"},{anchor:"huggingface_hub.InferenceClient.chat_completion.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for chat-completion. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended model for chat-based text-generation will be used.
See <a href="https://huggingface.co/tasks/text-generation" rel="nofollow">https://huggingface.co/tasks/text-generation</a> for more details.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.chat_completion.frequency_penalty",description:`<strong>frequency_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Penalizes new tokens based on their existing frequency
in the text so far. Range: [-2.0, 2.0]. Defaults to 0.0.`,name:"frequency_penalty"},{anchor:"huggingface_hub.InferenceClient.chat_completion.logit_bias",description:`<strong>logit_bias</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Modify the likelihood of specified tokens appearing in the completion. Accepts a JSON object that maps tokens
(specified by their token ID in the tokenizer) to an associated bias value from -100 to 100. Mathematically,
the bias is added to the logits generated by the model prior to sampling. The exact effect will vary per model,
but values between -1 and 1 should decrease or increase likelihood of selection; values like -100 or 100 should
result in a ban or exclusive selection of the relevant token. Defaults to None.`,name:"logit_bias"},{anchor:"huggingface_hub.InferenceClient.chat_completion.logprobs",description:`<strong>logprobs</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to return log probabilities of the output tokens or not. If true, returns the log
probabilities of each output token returned in the content of message.`,name:"logprobs"},{anchor:"huggingface_hub.InferenceClient.chat_completion.max_tokens",description:`<strong>max_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum number of tokens allowed in the response. Defaults to 20.`,name:"max_tokens"},{anchor:"huggingface_hub.InferenceClient.chat_completion.n",description:`<strong>n</strong> (<code>int</code>, <em>optional</em>) &#x2014;
UNUSED.`,name:"n"},{anchor:"huggingface_hub.InferenceClient.chat_completion.presence_penalty",description:`<strong>presence_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the
text so far, increasing the model&#x2019;s likelihood to talk about new topics.`,name:"presence_penalty"},{anchor:"huggingface_hub.InferenceClient.chat_completion.seed",description:`<strong>seed</strong> (Optional<code>int</code>, <em>optional</em>) &#x2014;
Seed for reproducible control flow. Defaults to None.`,name:"seed"},{anchor:"huggingface_hub.InferenceClient.chat_completion.stop",description:`<strong>stop</strong> (Optional<code>str</code>, <em>optional</em>) &#x2014;
Up to four strings which trigger the end of the response.
Defaults to None.`,name:"stop"},{anchor:"huggingface_hub.InferenceClient.chat_completion.stream",description:`<strong>stream</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Enable realtime streaming of responses. Defaults to False.`,name:"stream"},{anchor:"huggingface_hub.InferenceClient.chat_completion.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Controls randomness of the generations. Lower values ensure
less random completions. Range: [0, 2]. Defaults to 1.0.`,name:"temperature"},{anchor:"huggingface_hub.InferenceClient.chat_completion.top_logprobs",description:`<strong>top_logprobs</strong> (<code>int</code>, <em>optional</em>) &#x2014;
An integer between 0 and 5 specifying the number of most likely tokens to return at each token
position, each with an associated log probability. logprobs must be set to true if this parameter is
used.`,name:"top_logprobs"},{anchor:"huggingface_hub.InferenceClient.chat_completion.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Fraction of the most likely next words to sample from.
Must be between 0 and 1. Defaults to 1.0.`,name:"top_p"},{anchor:"huggingface_hub.InferenceClient.chat_completion.tool_choice",description:`<strong>tool_choice</strong> (<a href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.ChatCompletionInputToolTypeClass">ChatCompletionInputToolTypeClass</a> or <code>ChatCompletionInputToolTypeEnum</code>, <em>optional</em>) &#x2014;
The tool to use for the completion. Defaults to &#x201C;auto&#x201D;.`,name:"tool_choice"},{anchor:"huggingface_hub.InferenceClient.chat_completion.tool_prompt",description:`<strong>tool_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A prompt to be appended before the tools.`,name:"tool_prompt"},{anchor:"huggingface_hub.InferenceClient.chat_completion.tools",description:`<strong>tools</strong> (List of <a href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.ChatCompletionInputTool">ChatCompletionInputTool</a>, <em>optional</em>) &#x2014;
A list of tools the model may call. Currently, only functions are supported as a tool. Use this to
provide a list of functions the model may generate JSON inputs for.`,name:"tools"},{anchor:"huggingface_hub.InferenceClient.chat_completion.model_id",description:`<strong>model_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model ID to use for chat-completion. Only used when <code>model</code> is a URL to a deployed Text Generation Inference server.
It is passed to the server as the <code>model</code> parameter. This parameter has no impact on the URL that will be used to
send the request.`,name:"model_id"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_client.py#L495",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Generated text returned from the server:</p>
<ul>
<li>if <code>stream=False</code>, the generated text is returned as a <a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.ChatCompletionOutput"
>ChatCompletionOutput</a> (default).</li>
<li>if <code>stream=True</code>, the generated text is returned token by token as a sequence of <a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.ChatCompletionStreamOutput"
>ChatCompletionStreamOutput</a>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.ChatCompletionOutput"
>ChatCompletionOutput</a> or Iterable of <a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.ChatCompletionStreamOutput"
>ChatCompletionStreamOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),gt=new E({props:{anchor:"huggingface_hub.InferenceClient.chat_completion.example",$$slots:{default:[Sh]},$$scope:{ctx:I}}}),ta=new k({props:{name:"conversational",anchor:"huggingface_hub.InferenceClient.conversational",parameters:[{name:"text",val:": str"},{name:"generated_responses",val:": Optional = None"},{name:"past_user_inputs",val:": Optional = None"},{name:"parameters",val:": Optional = None"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.conversational.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The last input from the user in the conversation.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.conversational.generated_responses",description:`<strong>generated_responses</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of strings corresponding to the earlier replies from the model. Defaults to None.`,name:"generated_responses"},{anchor:"huggingface_hub.InferenceClient.conversational.past_user_inputs",description:`<strong>past_user_inputs</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of strings corresponding to the earlier replies from the user. Should be the same length as
<code>generated_responses</code>. Defaults to None.`,name:"past_user_inputs"},{anchor:"huggingface_hub.InferenceClient.conversational.parameters",description:`<strong>parameters</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional parameters for the conversational task. Defaults to None. For more details about the available
parameters, please refer to <a href="https://huggingface.co/docs/api-inference/detailed_parameters#conversational-task" rel="nofollow">this page</a>`,name:"parameters"},{anchor:"huggingface_hub.InferenceClient.conversational.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the conversational task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended conversational model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_client.py#L827",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated conversational output.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),mt=new A({props:{warning:!0,$$slots:{default:[Rh]},$$scope:{ctx:I}}}),ht=new E({props:{anchor:"huggingface_hub.InferenceClient.conversational.example",$$slots:{default:[Dh]},$$scope:{ctx:I}}}),sa=new k({props:{name:"document_question_answering",anchor:"huggingface_hub.InferenceClient.document_question_answering",parameters:[{name:"image",val:": Union"},{name:"question",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.document_question_answering.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image for the context. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the document question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended document question answering model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_client.py#L900",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.DocumentQuestionAnsweringOutputElement"
>DocumentQuestionAnsweringOutputElement</a> items containing the predicted label, associated probability, word ids, and page number.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[DocumentQuestionAnsweringOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),dt=new E({props:{anchor:"huggingface_hub.InferenceClient.document_question_answering.example",$$slots:{default:[Xh]},$$scope:{ctx:I}}}),aa=new k({props:{name:"feature_extraction",anchor:"huggingface_hub.InferenceClient.feature_extraction",parameters:[{name:"text",val:": str"},{name:"normalize",val:": Optional = None"},{name:"prompt_name",val:": Optional = None"},{name:"truncate",val:": Optional = None"},{name:"truncation_direction",val:": Optional = None"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.feature_extraction.text",description:`<strong>text</strong> (<em>str</em>) &#x2014;
The text to embed.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.feature_extraction.model",description:`<strong>model</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The model to use for the conversational task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended conversational model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.feature_extraction.normalize",description:`<strong>normalize</strong> (<em>bool</em>, <em>optional</em>) &#x2014;
Whether to normalize the embeddings or not. Defaults to None.
Only available on server powered by Text-Embedding-Inference.`,name:"normalize"},{anchor:"huggingface_hub.InferenceClient.feature_extraction.prompt_name",description:`<strong>prompt_name</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The name of the prompt that should be used by for encoding. If not set, no prompt will be applied.
Must be a key in the <em>Sentence Transformers</em> configuration <em>prompts</em> dictionary.
For example if <code>prompt_name</code> is &#x201C;query&#x201D; and the <code>prompts</code> is {&#x201C;query&#x201D;: &#x201C;query: &#x201D;,&#x2026;},
then the sentence &#x201C;What is the capital of France?&#x201D; will be encoded as &#x201C;query: What is the capital of France?&#x201D;
because the prompt text will be prepended before any text to encode.`,name:"prompt_name"},{anchor:"huggingface_hub.InferenceClient.feature_extraction.truncate",description:`<strong>truncate</strong> (<em>bool</em>, <em>optional</em>) &#x2014;
Whether to truncate the embeddings or not. Defaults to None.
Only available on server powered by Text-Embedding-Inference.`,name:"truncate"},{anchor:"huggingface_hub.InferenceClient.feature_extraction.truncation_direction",description:`<strong>truncation_direction</strong> (<em>Literal[&#x201C;Left&#x201D;, &#x201C;Right&#x201D;]</em>, <em>optional</em>) &#x2014;
Which side of the input should be truncated when <em>truncate=True</em> is passed.`,name:"truncation_direction"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_client.py#L941",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The embedding representing the input text as a float32 numpy array.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><em>np.ndarray</em></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>[<em>InferenceTimeoutError</em>] —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>[<em>InferenceTimeoutError</em>] or <code>HTTPError</code></p>
`}}),ft=new E({props:{anchor:"huggingface_hub.InferenceClient.feature_extraction.example",$$slots:{default:[Hh]},$$scope:{ctx:I}}}),la=new k({props:{name:"fill_mask",anchor:"huggingface_hub.InferenceClient.fill_mask",parameters:[{name:"text",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.fill_mask.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
a string to be filled from, must contain the [MASK] token (check model card for exact name of the mask).`,name:"text"},{anchor:"huggingface_hub.InferenceClient.fill_mask.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the fill mask task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended fill mask model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_client.py#L1009",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.FillMaskOutputElement"
>FillMaskOutputElement</a> items containing the predicted label, associated
probability, token reference, and completed text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[FillMaskOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),yt=new E({props:{anchor:"huggingface_hub.InferenceClient.fill_mask.example",$$slots:{default:[zh]},$$scope:{ctx:I}}}),oa=new k({props:{name:"get_endpoint_info",anchor:"huggingface_hub.InferenceClient.get_endpoint_info",parameters:[{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.get_endpoint_info.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_client.py#L2618",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Information about the endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, Any]</code></p>
`}}),bt=new E({props:{anchor:"huggingface_hub.InferenceClient.get_endpoint_info.example",$$slots:{default:[Fh]},$$scope:{ctx:I}}}),ra=new k({props:{name:"get_model_status",anchor:"huggingface_hub.InferenceClient.get_model_status",parameters:[{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.get_model_status.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Identifier of the model for witch the status gonna be checked. If model is not provided,
the model associated with this instance of <a href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> will be used. Only InferenceAPI service can be checked so the
identifier cannot be a URL.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_client.py#L2707",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of ModelStatus dataclass, containing information,
about the state of the model: load, state, compute type and framework.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ModelStatus</code></p>
`}}),Mt=new A({props:{$$slots:{default:[Lh]},$$scope:{ctx:I}}}),jt=new E({props:{anchor:"huggingface_hub.InferenceClient.get_model_status.example",$$slots:{default:[Oh]},$$scope:{ctx:I}}}),ia=new k({props:{name:"get_recommended_model",anchor:"huggingface_hub.InferenceClient.get_recommended_model",parameters:[{name:"task",val:": str"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.get_recommended_model.task",description:`<strong>task</strong> (<code>str</code>) &#x2014;
The Hugging Face task to get which model Hugging Face recommends.
All available tasks can be found <a href="https://huggingface.co/tasks" rel="nofollow">here</a>.`,name:"task"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_client.py#L2594",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Name of the model recommended for the input task.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValueError</code> — If Hugging Face has no recommendation for the input task.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),ca=new k({props:{name:"health_check",anchor:"huggingface_hub.InferenceClient.health_check",parameters:[{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.health_check.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
URL of the Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_client.py#L2673",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>True if everything is working fine.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code></p>
`}}),Tt=new E({props:{anchor:"huggingface_hub.InferenceClient.health_check.example",$$slots:{default:[Ph]},$$scope:{ctx:I}}}),pa=new k({props:{name:"image_classification",anchor:"huggingface_hub.InferenceClient.image_classification",parameters:[{name:"image",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.image_classification.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The image to classify. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.image_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for image classification. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for image classification will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_client.py#L1045",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.ImageClassificationOutputElement"
>ImageClassificationOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ImageClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),It=new E({props:{anchor:"huggingface_hub.InferenceClient.image_classification.example",$$slots:{default:[Kh]},$$scope:{ctx:I}}}),ua=new k({props:{name:"image_segmentation",anchor:"huggingface_hub.InferenceClient.image_segmentation",parameters:[{name:"image",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.image_segmentation.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The image to segment. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.image_segmentation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for image segmentation. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for image segmentation will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_client.py#L1081",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.ImageSegmentationOutputElement"
>ImageSegmentationOutputElement</a> items containing the segmented masks and associated attributes.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ImageSegmentationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),xt=new A({props:{warning:!0,$$slots:{default:[ed]},$$scope:{ctx:I}}}),Ct=new E({props:{anchor:"huggingface_hub.InferenceClient.image_segmentation.example",$$slots:{default:[nd]},$$scope:{ctx:I}}}),ga=new k({props:{name:"image_to_image",anchor:"huggingface_hub.InferenceClient.image_to_image",parameters:[{name:"image",val:": Union"},{name:"prompt",val:": Optional = None"},{name:"negative_prompt",val:": Optional = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": Optional = None"},{name:"guidance_scale",val:": Optional = None"},{name:"model",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.image_to_image.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image for translation. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.image_to_image.prompt",description:`<strong>prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The text prompt to guide the image generation.`,name:"prompt"},{anchor:"huggingface_hub.InferenceClient.image_to_image.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A negative prompt to guide the translation process.`,name:"negative_prompt"},{anchor:"huggingface_hub.InferenceClient.image_to_image.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"huggingface_hub.InferenceClient.image_to_image.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"huggingface_hub.InferenceClient.image_to_image.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"huggingface_hub.InferenceClient.image_to_image.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"huggingface_hub.InferenceClient.image_to_image.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_client.py#L1126",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The translated image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Image</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Ut=new A({props:{warning:!0,$$slots:{default:[td]},$$scope:{ctx:I}}}),wt=new E({props:{anchor:"huggingface_hub.InferenceClient.image_to_image.example",$$slots:{default:[sd]},$$scope:{ctx:I}}}),ma=new k({props:{name:"image_to_text",anchor:"huggingface_hub.InferenceClient.image_to_text",parameters:[{name:"image",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.image_to_text.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image to caption. It can be raw bytes, an image file, or a URL to an online image..`,name:"image"},{anchor:"huggingface_hub.InferenceClient.image_to_text.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_client.py#L1210",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.ImageToTextOutput"
>ImageToTextOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Jt=new E({props:{anchor:"huggingface_hub.InferenceClient.image_to_text.example",$$slots:{default:[ad]},$$scope:{ctx:I}}}),ha=new k({props:{name:"list_deployed_models",anchor:"huggingface_hub.InferenceClient.list_deployed_models",parameters:[{name:"frameworks",val:": Union = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.list_deployed_models.frameworks",description:`<strong>frameworks</strong> (<code>Literal[&quot;all&quot;]</code> or <code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
The frameworks to filter on. By default only a subset of the available frameworks are tested. If set to
&#x201C;all&#x201D;, all available frameworks will be tested. It is also possible to provide a single framework or a
custom set of frameworks to check.`,name:"frameworks"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_client.py#L1247",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary mapping task names to a sorted list of model IDs.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, List[str]]</code></p>
`}}),$t=new A({props:{warning:!0,$$slots:{default:[ld]},$$scope:{ctx:I}}}),vt=new A({props:{$$slots:{default:[od]},$$scope:{ctx:I}}}),kt=new E({props:{anchor:"huggingface_hub.InferenceClient.list_deployed_models.example",$$slots:{default:[rd]},$$scope:{ctx:I}}}),da=new k({props:{name:"object_detection",anchor:"huggingface_hub.InferenceClient.object_detection",parameters:[{name:"image",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.object_detection.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The image to detect objects on. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.object_detection.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for object detection. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for object detection (DETR) will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_client.py#L1330",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.ObjectDetectionOutputElement"
>ObjectDetectionOutputElement</a> items containing the bounding boxes and associated attributes.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ObjectDetectionOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
<li><code>ValueError</code> —
If the request output is not a List.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code> or <code>ValueError</code></p>
`}}),qt=new A({props:{warning:!0,$$slots:{default:[id]},$$scope:{ctx:I}}}),Et=new E({props:{anchor:"huggingface_hub.InferenceClient.object_detection.example",$$slots:{default:[cd]},$$scope:{ctx:I}}}),fa=new k({props:{name:"post",anchor:"huggingface_hub.InferenceClient.post",parameters:[{name:"json",val:": Union = None"},{name:"data",val:": Union = None"},{name:"model",val:": Optional = None"},{name:"task",val:": Optional = None"},{name:"stream",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.post.json",description:`<strong>json</strong> (<code>Union[str, Dict, List]</code>, <em>optional</em>) &#x2014;
The JSON data to send in the request body, specific to each task. Defaults to None.`,name:"json"},{anchor:"huggingface_hub.InferenceClient.post.data",description:`<strong>data</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>, <em>optional</em>) &#x2014;
The content to send in the request body, specific to each task.
It can be raw bytes, a pointer to an opened file, a local file path,
or a URL to an online resource (image, audio file,&#x2026;). If both <code>json</code> and <code>data</code> are passed,
<code>data</code> will take precedence. At least <code>json</code> or <code>data</code> must be provided. Defaults to None.`,name:"data"},{anchor:"huggingface_hub.InferenceClient.post.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. Will override the model defined at the instance level. Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.post.task",description:`<strong>task</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The task to perform on the inference. All available tasks can be found
<a href="https://huggingface.co/tasks" rel="nofollow">here</a>. Used only to default to a recommended model if <code>model</code> is not
provided. At least <code>model</code> or <code>task</code> must be provided. Defaults to None.`,name:"task"},{anchor:"huggingface_hub.InferenceClient.post.stream",description:`<strong>stream</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to iterate over streaming APIs.`,name:"stream"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_client.py#L207",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The raw bytes returned by the server.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>bytes</p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),ya=new k({props:{name:"question_answering",anchor:"huggingface_hub.InferenceClient.question_answering",parameters:[{name:"question",val:": str"},{name:"context",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.InferenceClient.question_answering.context",description:`<strong>context</strong> (<code>str</code>) &#x2014;
The context of the question.`,name:"context"},{anchor:"huggingface_hub.InferenceClient.question_answering.model",description:`<strong>model</strong> (<code>str</code>) &#x2014;
The model to use for the question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_client.py#L1375",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>an question answering output containing the score, start index, end index, and answer.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.QuestionAnsweringOutputElement"
>QuestionAnsweringOutputElement</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Zt=new E({props:{anchor:"huggingface_hub.InferenceClient.question_answering.example",$$slots:{default:[pd]},$$scope:{ctx:I}}}),ba=new k({props:{name:"sentence_similarity",anchor:"huggingface_hub.InferenceClient.sentence_similarity",parameters:[{name:"sentence",val:": str"},{name:"other_sentences",val:": List"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.sentence_similarity.sentence",description:`<strong>sentence</strong> (<code>str</code>) &#x2014;
The main sentence to compare to others.`,name:"sentence"},{anchor:"huggingface_hub.InferenceClient.sentence_similarity.other_sentences",description:`<strong>other_sentences</strong> (<code>List[str]</code>) &#x2014;
The list of sentences to compare to.`,name:"other_sentences"},{anchor:"huggingface_hub.InferenceClient.sentence_similarity.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the conversational task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended conversational model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_client.py#L1416",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The embedding representing the input text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[float]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Nt=new E({props:{anchor:"huggingface_hub.InferenceClient.sentence_similarity.example",$$slots:{default:[ud]},$$scope:{ctx:I}}}),Ma=new k({props:{name:"summarization",anchor:"huggingface_hub.InferenceClient.summarization",parameters:[{name:"text",val:": str"},{name:"parameters",val:": Optional = None"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.summarization.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The input text to summarize.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.summarization.parameters",description:`<strong>parameters</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional parameters for summarization. Check out this <a href="https://huggingface.co/docs/api-inference/detailed_parameters#summarization-task" rel="nofollow">page</a>
for more details.`,name:"parameters"},{anchor:"huggingface_hub.InferenceClient.summarization.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_client.py#L1463",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated summary text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.SummarizationOutput"
>SummarizationOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Wt=new E({props:{anchor:"huggingface_hub.InferenceClient.summarization.example",$$slots:{default:[gd]},$$scope:{ctx:I}}}),ja=new k({props:{name:"table_question_answering",anchor:"huggingface_hub.InferenceClient.table_question_answering",parameters:[{name:"table",val:": Dict"},{name:"query",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.table_question_answering.table",description:`<strong>table</strong> (<code>str</code>) &#x2014;
A table of data represented as a dict of lists where entries are headers and the lists are all the
values, all lists must have the same size.`,name:"table"},{anchor:"huggingface_hub.InferenceClient.table_question_answering.query",description:`<strong>query</strong> (<code>str</code>) &#x2014;
The query in plain text that you want to ask the table.`,name:"query"},{anchor:"huggingface_hub.InferenceClient.table_question_answering.model",description:`<strong>model</strong> (<code>str</code>) &#x2014;
The model to use for the table-question-answering task. Can be a model ID hosted on the Hugging Face
Hub or a URL to a deployed Inference Endpoint.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_client.py#L1506",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a table question answering output containing the answer, coordinates, cells and the aggregator used.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.TableQuestionAnsweringOutputElement"
>TableQuestionAnsweringOutputElement</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Gt=new E({props:{anchor:"huggingface_hub.InferenceClient.table_question_answering.example",$$slots:{default:[md]},$$scope:{ctx:I}}}),_a=new k({props:{name:"tabular_classification",anchor:"huggingface_hub.InferenceClient.tabular_classification",parameters:[{name:"table",val:": Dict"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.tabular_classification.table",description:`<strong>table</strong> (<code>Dict[str, Any]</code>) &#x2014;
Set of attributes to classify.`,name:"table"},{anchor:"huggingface_hub.InferenceClient.tabular_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the tabular classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended tabular classification model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_client.py#L1551",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of labels, one per row in the initial table.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Bt=new E({props:{anchor:"huggingface_hub.InferenceClient.tabular_classification.example",$$slots:{default:[hd]},$$scope:{ctx:I}}}),Ta=new k({props:{name:"tabular_regression",anchor:"huggingface_hub.InferenceClient.tabular_regression",parameters:[{name:"table",val:": Dict"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.tabular_regression.table",description:`<strong>table</strong> (<code>Dict[str, Any]</code>) &#x2014;
Set of attributes stored in a table. The attributes used to predict the target can be both numerical and categorical.`,name:"table"},{anchor:"huggingface_hub.InferenceClient.tabular_regression.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the tabular regression task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended tabular regression model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_client.py#L1596",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of predicted numerical target values.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Qt=new E({props:{anchor:"huggingface_hub.InferenceClient.tabular_regression.example",$$slots:{default:[dd]},$$scope:{ctx:I}}}),Ia=new k({props:{name:"text_classification",anchor:"huggingface_hub.InferenceClient.text_classification",parameters:[{name:"text",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.text_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be classified.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.text_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the text classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended text classification model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_client.py#L1636",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.TextClassificationOutputElement"
>TextClassificationOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[TextClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Vt=new E({props:{anchor:"huggingface_hub.InferenceClient.text_classification.example",$$slots:{default:[fd]},$$scope:{ctx:I}}}),xa=new k({props:{name:"text_generation",anchor:"huggingface_hub.InferenceClient.text_generation",parameters:[{name:"prompt",val:": str"},{name:"details",val:": bool = False"},{name:"stream",val:": bool = False"},{name:"model",val:": Optional = None"},{name:"best_of",val:": Optional = None"},{name:"decoder_input_details",val:": Optional = None"},{name:"do_sample",val:": Optional = False"},{name:"frequency_penalty",val:": Optional = None"},{name:"grammar",val:": Optional = None"},{name:"max_new_tokens",val:": Optional = None"},{name:"repetition_penalty",val:": Optional = None"},{name:"return_full_text",val:": Optional = False"},{name:"seed",val:": Optional = None"},{name:"stop_sequences",val:": Optional = None"},{name:"temperature",val:": Optional = None"},{name:"top_k",val:": Optional = None"},{name:"top_n_tokens",val:": Optional = None"},{name:"top_p",val:": Optional = None"},{name:"truncate",val:": Optional = None"},{name:"typical_p",val:": Optional = None"},{name:"watermark",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.text_generation.prompt",description:`<strong>prompt</strong> (<code>str</code>) &#x2014;
Input text.`,name:"prompt"},{anchor:"huggingface_hub.InferenceClient.text_generation.details",description:`<strong>details</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
By default, text_generation returns a string. Pass <code>details=True</code> if you want a detailed output (tokens,
probabilities, seed, finish reason, etc.). Only available for models running on with the
<code>text-generation-inference</code> backend.`,name:"details"},{anchor:"huggingface_hub.InferenceClient.text_generation.stream",description:`<strong>stream</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
By default, text_generation returns the full generated text. Pass <code>stream=True</code> if you want a stream of
tokens to be returned. Only available for models running on with the <code>text-generation-inference</code>
backend.`,name:"stream"},{anchor:"huggingface_hub.InferenceClient.text_generation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.text_generation.best_of",description:`<strong>best_of</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Generate best_of sequences and return the one if the highest token logprobs.`,name:"best_of"},{anchor:"huggingface_hub.InferenceClient.text_generation.decoder_input_details",description:`<strong>decoder_input_details</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Return the decoder input token logprobs and ids. You must set <code>details=True</code> as well for it to be taken
into account. Defaults to <code>False</code>.`,name:"decoder_input_details"},{anchor:"huggingface_hub.InferenceClient.text_generation.do_sample",description:`<strong>do_sample</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Activate logits sampling`,name:"do_sample"},{anchor:"huggingface_hub.InferenceClient.text_generation.frequency_penalty",description:`<strong>frequency_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in
the text so far, decreasing the model&#x2019;s likelihood to repeat the same line verbatim.`,name:"frequency_penalty"},{anchor:"huggingface_hub.InferenceClient.text_generation.grammar",description:`<strong>grammar</strong> (<a href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.TextGenerationInputGrammarType">TextGenerationInputGrammarType</a>, <em>optional</em>) &#x2014;
Grammar constraints. Can be either a JSONSchema or a regex.`,name:"grammar"},{anchor:"huggingface_hub.InferenceClient.text_generation.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum number of generated tokens`,name:"max_new_tokens"},{anchor:"huggingface_hub.InferenceClient.text_generation.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">this
paper</a> for more details.`,name:"repetition_penalty"},{anchor:"huggingface_hub.InferenceClient.text_generation.return_full_text",description:`<strong>return_full_text</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to prepend the prompt to the generated text`,name:"return_full_text"},{anchor:"huggingface_hub.InferenceClient.text_generation.seed",description:`<strong>seed</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Random sampling seed`,name:"seed"},{anchor:"huggingface_hub.InferenceClient.text_generation.stop_sequences",description:`<strong>stop_sequences</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Stop generating tokens if a member of <code>stop_sequences</code> is generated`,name:"stop_sequences"},{anchor:"huggingface_hub.InferenceClient.text_generation.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The value used to module the logits distribution.`,name:"temperature"},{anchor:"huggingface_hub.InferenceClient.text_generation.top_n_tokens",description:`<strong>top_n_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Return information about the <code>top_n_tokens</code> most likely tokens at each generation step, instead of
just the sampled token.`,name:"top_n_tokens"},{anchor:"huggingface_hub.InferenceClient.text_generation.top_k",description:"<strong>top_k</strong> (<code>int</code>, *optional`) &#x2014;\nThe number of highest probability vocabulary tokens to keep for top-k-filtering.",name:"top_k"},{anchor:"huggingface_hub.InferenceClient.text_generation.top_p",description:"<strong>top_p</strong> (<code>float</code>, *optional<code>) -- If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to </code>top_p` or\nhigher are kept for generation.",name:"top_p"},{anchor:"huggingface_hub.InferenceClient.text_generation.truncate",description:"<strong>truncate</strong> (<code>int</code>, *optional`) &#x2014;\nTruncate inputs tokens to the given size.",name:"truncate"},{anchor:"huggingface_hub.InferenceClient.text_generation.typical_p",description:`<strong>typical_p</strong> (<code>float</code>, *optional\`) &#x2014;
Typical Decoding mass
See <a href="https://arxiv.org/abs/2202.00666" rel="nofollow">Typical Decoding for Natural Language Generation</a> for more information`,name:"typical_p"},{anchor:"huggingface_hub.InferenceClient.text_generation.watermark",description:'<strong>watermark</strong> (<code>bool</code>, *optional`) &#x2014;\nWatermarking with <a href="https://arxiv.org/abs/2301.10226" rel="nofollow">A Watermark for Large Language Models</a>',name:"watermark"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_client.py#L1811",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Generated text returned from the server:</p>
<ul>
<li>if <code>stream=False</code> and <code>details=False</code>, the generated text is returned as a <code>str</code> (default)</li>
<li>if <code>stream=True</code> and <code>details=False</code>, the generated text is returned token by token as a <code>Iterable[str]</code></li>
<li>if <code>stream=False</code> and <code>details=True</code>, the generated text is returned with more details as a <a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.TextGenerationOutput"
>TextGenerationOutput</a></li>
<li>if <code>details=True</code> and <code>stream=True</code>, the generated text is returned token by token as a iterable of <a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.TextGenerationStreamOutput"
>TextGenerationStreamOutput</a></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Union[str, TextGenerationOutput, Iterable[str], Iterable[TextGenerationStreamOutput]]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValidationError</code> —
If input values are not valid. No HTTP call is made to the server.</li>
<li><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValidationError</code> or <a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Yt=new A({props:{$$slots:{default:[yd]},$$scope:{ctx:I}}}),St=new E({props:{anchor:"huggingface_hub.InferenceClient.text_generation.example",$$slots:{default:[bd]},$$scope:{ctx:I}}}),Ca=new k({props:{name:"text_to_image",anchor:"huggingface_hub.InferenceClient.text_to_image",parameters:[{name:"prompt",val:": str"},{name:"negative_prompt",val:": Optional = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": Optional = None"},{name:"guidance_scale",val:": Optional = None"},{name:"model",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.text_to_image.prompt",description:`<strong>prompt</strong> (<code>str</code>) &#x2014;
The prompt to generate an image from.`,name:"prompt"},{anchor:"huggingface_hub.InferenceClient.text_to_image.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
An optional negative prompt for the image generation.`,name:"negative_prompt"},{anchor:"huggingface_hub.InferenceClient.text_to_image.height",description:`<strong>height</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The height in pixels of the image to generate.`,name:"height"},{anchor:"huggingface_hub.InferenceClient.text_to_image.width",description:`<strong>width</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The width in pixels of the image to generate.`,name:"width"},{anchor:"huggingface_hub.InferenceClient.text_to_image.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"huggingface_hub.InferenceClient.text_to_image.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"huggingface_hub.InferenceClient.text_to_image.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_client.py#L2135",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Image</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Rt=new A({props:{warning:!0,$$slots:{default:[Md]},$$scope:{ctx:I}}}),Dt=new E({props:{anchor:"huggingface_hub.InferenceClient.text_to_image.example",$$slots:{default:[jd]},$$scope:{ctx:I}}}),Ua=new k({props:{name:"text_to_speech",anchor:"huggingface_hub.InferenceClient.text_to_speech",parameters:[{name:"text",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.text_to_speech.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The text to synthesize.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_client.py#L2215",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated audio.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bytes</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Xt=new E({props:{anchor:"huggingface_hub.InferenceClient.text_to_speech.example",$$slots:{default:[_d]},$$scope:{ctx:I}}}),wa=new k({props:{name:"token_classification",anchor:"huggingface_hub.InferenceClient.token_classification",parameters:[{name:"text",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.token_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be classified.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.token_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the token classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended token classification model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_client.py#L2247",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.TokenClassificationOutputElement"
>TokenClassificationOutputElement</a> items containing the entity group, confidence score, word, start and end index.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[TokenClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Ht=new E({props:{anchor:"huggingface_hub.InferenceClient.token_classification.example",$$slots:{default:[Td]},$$scope:{ctx:I}}}),Ja=new k({props:{name:"translation",anchor:"huggingface_hub.InferenceClient.translation",parameters:[{name:"text",val:": str"},{name:"model",val:": Optional = None"},{name:"src_lang",val:": Optional = None"},{name:"tgt_lang",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.translation.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be translated.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.translation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the translation task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended translation model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.translation.src_lang",description:`<strong>src_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Source language of the translation task, i.e. input language. Cannot be passed without <code>tgt_lang</code>.`,name:"src_lang"},{anchor:"huggingface_hub.InferenceClient.translation.tgt_lang",description:`<strong>tgt_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Target language of the translation task, i.e. output language. Cannot be passed without <code>src_lang</code>.`,name:"tgt_lang"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_client.py#L2302",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated translated text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.TranslationOutput"
>TranslationOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
<li><code>ValueError</code> —
If only one of the <code>src_lang</code> and <code>tgt_lang</code> arguments are provided.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code> or <code>ValueError</code></p>
`}}),zt=new E({props:{anchor:"huggingface_hub.InferenceClient.translation.example",$$slots:{default:[Id]},$$scope:{ctx:I}}}),Ft=new E({props:{anchor:"huggingface_hub.InferenceClient.translation.example-2",$$slots:{default:[xd]},$$scope:{ctx:I}}}),$a=new k({props:{name:"visual_question_answering",anchor:"huggingface_hub.InferenceClient.visual_question_answering",parameters:[{name:"image",val:": Union"},{name:"question",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.visual_question_answering.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image for the context. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.visual_question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.InferenceClient.visual_question_answering.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the visual question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended visual question answering model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_client.py#L2367",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.VisualQuestionAnsweringOutputElement"
>VisualQuestionAnsweringOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[VisualQuestionAnsweringOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>InferenceTimeoutError</code> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>InferenceTimeoutError</code> or <code>HTTPError</code></p>
`}}),Lt=new E({props:{anchor:"huggingface_hub.InferenceClient.visual_question_answering.example",$$slots:{default:[Cd]},$$scope:{ctx:I}}}),va=new k({props:{name:"zero_shot_classification",anchor:"huggingface_hub.InferenceClient.zero_shot_classification",parameters:[{name:"text",val:": str"},{name:"labels",val:": List"},{name:"multi_label",val:": bool = False"},{name:"hypothesis_template",val:": Optional = None"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The input text to classify.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.labels",description:`<strong>labels</strong> (<code>List[str]</code>) &#x2014;
List of strings. Each string is the verbalization of a possible label for the input text.`,name:"labels"},{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.multi_label",description:`<strong>multi_label</strong> (<code>bool</code>) &#x2014;
Boolean. If True, the probability for each label is evaluated independently and multiple labels can have a probability close to 1 simultaneously or all probabilities can be close to 0.
If False, the labels are considered mutually exclusive and the probability over all labels always sums to 1. Defaults to False.`,name:"multi_label"},{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.hypothesis_template",description:`<strong>hypothesis_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A template sentence string with curly brackets to which the label strings are added. The label strings are added at the position of the curly brackets &#x201D;{}&#x201C;.
Zero-shot classifiers are based on NLI models, which evaluate if a hypothesis is entailed in another text or not.
For example, with hypothesis_template=&#x201C;This text is about {}.&#x201D; and labels=[&#x201C;economics&#x201D;, &#x201C;politics&#x201D;], the system internally creates the two hypotheses &#x201C;This text is about economics.&#x201D; and &#x201C;This text is about politics.&#x201D;.
The model then evaluates for both hypotheses if they are entailed in the provided <code>text</code> or not.`,name:"hypothesis_template"},{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_client.py#L2414",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.ZeroShotClassificationOutputElement"
>ZeroShotClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ZeroShotClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Ot=new E({props:{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.example",$$slots:{default:[Ud]},$$scope:{ctx:I}}}),Pt=new E({props:{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.example-2",$$slots:{default:[wd]},$$scope:{ctx:I}}}),ka=new k({props:{name:"zero_shot_image_classification",anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification",parameters:[{name:"image",val:": Union"},{name:"labels",val:": List"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image to caption. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification.labels",description:`<strong>labels</strong> (<code>List[str]</code>) &#x2014;
List of string possible labels. There must be at least 2 labels.`,name:"labels"},{anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_client.py#L2517",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.ZeroShotImageClassificationOutputElement"
>ZeroShotImageClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ZeroShotImageClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Kt=new E({props:{anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification.example",$$slots:{default:[Jd]},$$scope:{ctx:I}}}),qa=new it({props:{title:"비동기 추론 클라이언트",local:"huggingface_hub.AsyncInferenceClient ][ huggingface_hub.AsyncInferenceClient",headingTag:"h2"}}),Aa=new q({props:{code:"cGlwJTIwaW5zdGFsbCUyMC0tdXBncmFkZSUyMGh1Z2dpbmdmYWNlX2h1YiU1QmluZmVyZW5jZSU1RCUwQSUyMyUyMCVFQiU5OCU5MCVFQiU4QSU5NCUwQSUyMyUyMHBpcCUyMGluc3RhbGwlMjBhaW9odHRw",highlighted:`pip install --upgrade huggingface_hub[inference]
<span class="hljs-comment"># 또는</span>
<span class="hljs-comment"># pip install aiohttp</span>`,wrap:!1}}),Za=new k({props:{name:"class huggingface_hub.AsyncInferenceClient",anchor:"huggingface_hub.AsyncInferenceClient",parameters:[{name:"model",val:": Optional = None"},{name:"token",val:": Union = None"},{name:"timeout",val:": Optional = None"},{name:"headers",val:": Optional = None"},{name:"cookies",val:": Optional = None"},{name:"proxies",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.model",description:`<strong>model</strong> (<code>str</code>, <code>optional</code>) &#x2014;
The model to run inference with. Can be a model id hosted on the Hugging Face Hub, e.g. <code>bigcode/starcoder</code>
or a URL to a deployed Inference Endpoint. Defaults to None, in which case a recommended model is
automatically selected for the task.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.token",description:`<strong>token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
Hugging Face token. Will default to the locally saved token if not provided.
Pass <code>token=False</code> if you don&#x2019;t want to send your token to the server.`,name:"token"},{anchor:"huggingface_hub.AsyncInferenceClient.timeout",description:`<strong>timeout</strong> (<code>float</code>, <code>optional</code>) &#x2014;
The maximum number of seconds to wait for a response from the server. Loading a new model in Inference
API can take up to several minutes. Defaults to None, meaning it will loop until the server is available.`,name:"timeout"},{anchor:"huggingface_hub.AsyncInferenceClient.headers",description:`<strong>headers</strong> (<code>Dict[str, str]</code>, <code>optional</code>) &#x2014;
Additional headers to send to the server. By default only the authorization and user-agent headers are sent.
Values in this dictionary will override the default values.`,name:"headers"},{anchor:"huggingface_hub.AsyncInferenceClient.cookies",description:`<strong>cookies</strong> (<code>Dict[str, str]</code>, <code>optional</code>) &#x2014;
Additional cookies to send to the server.`,name:"cookies"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_generated/_async_client.py#L113"}}),Na=new k({props:{name:"audio_classification",anchor:"huggingface_hub.AsyncInferenceClient.audio_classification",parameters:[{name:"audio",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.audio_classification.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The audio content to classify. It can be raw audio bytes, a local audio file, or a URL pointing to an
audio file.`,name:"audio"},{anchor:"huggingface_hub.AsyncInferenceClient.audio_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for audio classification. Can be a model ID hosted on the Hugging Face Hub
or a URL to a deployed Inference Endpoint. If not provided, the default recommended model for
audio classification will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_generated/_async_client.py#L300",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.AudioClassificationOutputElement"
>AudioClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[AudioClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),es=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.audio_classification.example",$$slots:{default:[$d]},$$scope:{ctx:I}}}),Wa=new k({props:{name:"audio_to_audio",anchor:"huggingface_hub.AsyncInferenceClient.audio_to_audio",parameters:[{name:"audio",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.audio_to_audio.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The audio content for the model. It can be raw audio bytes, a local audio file, or a URL pointing to an
audio file.`,name:"audio"},{anchor:"huggingface_hub.AsyncInferenceClient.audio_to_audio.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model can be any model which takes an audio file and returns another audio file. Can be a model ID hosted on the Hugging Face Hub
or a URL to a deployed Inference Endpoint. If not provided, the default recommended model for
audio_to_audio will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_generated/_async_client.py#L343",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.AudioToAudioOutputElement"
>AudioToAudioOutputElement</a> items containing audios label, content-type, and audio content in blob.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[AudioToAudioOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>InferenceTimeoutError</code> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>InferenceTimeoutError</code> or <code>aiohttp.ClientResponseError</code></p>
`}}),ns=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.audio_to_audio.example",$$slots:{default:[vd]},$$scope:{ctx:I}}}),Ga=new k({props:{name:"automatic_speech_recognition",anchor:"huggingface_hub.AsyncInferenceClient.automatic_speech_recognition",parameters:[{name:"audio",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.automatic_speech_recognition.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The content to transcribe. It can be raw audio bytes, local audio file, or a URL to an audio file.`,name:"audio"},{anchor:"huggingface_hub.AsyncInferenceClient.automatic_speech_recognition.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for ASR. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended model for ASR will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_generated/_async_client.py#L387",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An item containing the transcribed text and optionally the timestamp chunks.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.AutomaticSpeechRecognitionOutput"
>AutomaticSpeechRecognitionOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),ts=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.automatic_speech_recognition.example",$$slots:{default:[kd]},$$scope:{ctx:I}}}),Ba=new k({props:{name:"chat_completion",anchor:"huggingface_hub.AsyncInferenceClient.chat_completion",parameters:[{name:"messages",val:": List"},{name:"model",val:": Optional = None"},{name:"stream",val:": bool = False"},{name:"frequency_penalty",val:": Optional = None"},{name:"logit_bias",val:": Optional = None"},{name:"logprobs",val:": Optional = None"},{name:"max_tokens",val:": Optional = None"},{name:"n",val:": Optional = None"},{name:"presence_penalty",val:": Optional = None"},{name:"seed",val:": Optional = None"},{name:"stop",val:": Optional = None"},{name:"temperature",val:": Optional = None"},{name:"tool_choice",val:": Union = None"},{name:"tool_prompt",val:": Optional = None"},{name:"tools",val:": Optional = None"},{name:"top_logprobs",val:": Optional = None"},{name:"top_p",val:": Optional = None"},{name:"model_id",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.messages",description:`<strong>messages</strong> (List[Union[<code>SystemMessage</code>, <code>UserMessage</code>, <code>AssistantMessage</code>]]) &#x2014;
Conversation history consisting of roles and content pairs.`,name:"messages"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for chat-completion. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended model for chat-based text-generation will be used.
See <a href="https://huggingface.co/tasks/text-generation" rel="nofollow">https://huggingface.co/tasks/text-generation</a> for more details.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.frequency_penalty",description:`<strong>frequency_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Penalizes new tokens based on their existing frequency
in the text so far. Range: [-2.0, 2.0]. Defaults to 0.0.`,name:"frequency_penalty"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.logit_bias",description:`<strong>logit_bias</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Modify the likelihood of specified tokens appearing in the completion. Accepts a JSON object that maps tokens
(specified by their token ID in the tokenizer) to an associated bias value from -100 to 100. Mathematically,
the bias is added to the logits generated by the model prior to sampling. The exact effect will vary per model,
but values between -1 and 1 should decrease or increase likelihood of selection; values like -100 or 100 should
result in a ban or exclusive selection of the relevant token. Defaults to None.`,name:"logit_bias"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.logprobs",description:`<strong>logprobs</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to return log probabilities of the output tokens or not. If true, returns the log
probabilities of each output token returned in the content of message.`,name:"logprobs"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.max_tokens",description:`<strong>max_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum number of tokens allowed in the response. Defaults to 20.`,name:"max_tokens"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.n",description:`<strong>n</strong> (<code>int</code>, <em>optional</em>) &#x2014;
UNUSED.`,name:"n"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.presence_penalty",description:`<strong>presence_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the
text so far, increasing the model&#x2019;s likelihood to talk about new topics.`,name:"presence_penalty"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.seed",description:`<strong>seed</strong> (Optional<code>int</code>, <em>optional</em>) &#x2014;
Seed for reproducible control flow. Defaults to None.`,name:"seed"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.stop",description:`<strong>stop</strong> (Optional<code>str</code>, <em>optional</em>) &#x2014;
Up to four strings which trigger the end of the response.
Defaults to None.`,name:"stop"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.stream",description:`<strong>stream</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Enable realtime streaming of responses. Defaults to False.`,name:"stream"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Controls randomness of the generations. Lower values ensure
less random completions. Range: [0, 2]. Defaults to 1.0.`,name:"temperature"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.top_logprobs",description:`<strong>top_logprobs</strong> (<code>int</code>, <em>optional</em>) &#x2014;
An integer between 0 and 5 specifying the number of most likely tokens to return at each token
position, each with an associated log probability. logprobs must be set to true if this parameter is
used.`,name:"top_logprobs"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Fraction of the most likely next words to sample from.
Must be between 0 and 1. Defaults to 1.0.`,name:"top_p"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.tool_choice",description:`<strong>tool_choice</strong> (<a href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.ChatCompletionInputToolTypeClass">ChatCompletionInputToolTypeClass</a> or <code>ChatCompletionInputToolTypeEnum</code>, <em>optional</em>) &#x2014;
The tool to use for the completion. Defaults to &#x201C;auto&#x201D;.`,name:"tool_choice"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.tool_prompt",description:`<strong>tool_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A prompt to be appended before the tools.`,name:"tool_prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.tools",description:`<strong>tools</strong> (List of <a href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.ChatCompletionInputTool">ChatCompletionInputTool</a>, <em>optional</em>) &#x2014;
A list of tools the model may call. Currently, only functions are supported as a tool. Use this to
provide a list of functions the model may generate JSON inputs for.`,name:"tools"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.model_id",description:`<strong>model_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model ID to use for chat-completion. Only used when <code>model</code> is a URL to a deployed Text Generation Inference server.
It is passed to the server as the <code>model</code> parameter. This parameter has no impact on the URL that will be used to
send the request.`,name:"model_id"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_generated/_async_client.py#L496",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Generated text returned from the server:</p>
<ul>
<li>if <code>stream=False</code>, the generated text is returned as a <a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.ChatCompletionOutput"
>ChatCompletionOutput</a> (default).</li>
<li>if <code>stream=True</code>, the generated text is returned token by token as a sequence of <a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.ChatCompletionStreamOutput"
>ChatCompletionStreamOutput</a>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.ChatCompletionOutput"
>ChatCompletionOutput</a> or Iterable of <a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.ChatCompletionStreamOutput"
>ChatCompletionStreamOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),ss=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.example",$$slots:{default:[qd]},$$scope:{ctx:I}}}),Qa=new k({props:{name:"conversational",anchor:"huggingface_hub.AsyncInferenceClient.conversational",parameters:[{name:"text",val:": str"},{name:"generated_responses",val:": Optional = None"},{name:"past_user_inputs",val:": Optional = None"},{name:"parameters",val:": Optional = None"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.conversational.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The last input from the user in the conversation.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.conversational.generated_responses",description:`<strong>generated_responses</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of strings corresponding to the earlier replies from the model. Defaults to None.`,name:"generated_responses"},{anchor:"huggingface_hub.AsyncInferenceClient.conversational.past_user_inputs",description:`<strong>past_user_inputs</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of strings corresponding to the earlier replies from the user. Should be the same length as
<code>generated_responses</code>. Defaults to None.`,name:"past_user_inputs"},{anchor:"huggingface_hub.AsyncInferenceClient.conversational.parameters",description:`<strong>parameters</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional parameters for the conversational task. Defaults to None. For more details about the available
parameters, please refer to <a href="https://huggingface.co/docs/api-inference/detailed_parameters#conversational-task" rel="nofollow">this page</a>`,name:"parameters"},{anchor:"huggingface_hub.AsyncInferenceClient.conversational.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the conversational task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended conversational model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_generated/_async_client.py#L829",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated conversational output.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),as=new A({props:{warning:!0,$$slots:{default:[Ed]},$$scope:{ctx:I}}}),ls=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.conversational.example",$$slots:{default:[Ad]},$$scope:{ctx:I}}}),Va=new k({props:{name:"document_question_answering",anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering",parameters:[{name:"image",val:": Union"},{name:"question",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image for the context. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the document question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended document question answering model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_generated/_async_client.py#L903",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.DocumentQuestionAnsweringOutputElement"
>DocumentQuestionAnsweringOutputElement</a> items containing the predicted label, associated probability, word ids, and page number.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[DocumentQuestionAnsweringOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),os=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.example",$$slots:{default:[Zd]},$$scope:{ctx:I}}}),Ya=new k({props:{name:"feature_extraction",anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction",parameters:[{name:"text",val:": str"},{name:"normalize",val:": Optional = None"},{name:"prompt_name",val:": Optional = None"},{name:"truncate",val:": Optional = None"},{name:"truncation_direction",val:": Optional = None"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.text",description:`<strong>text</strong> (<em>str</em>) &#x2014;
The text to embed.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.model",description:`<strong>model</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The model to use for the conversational task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended conversational model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.normalize",description:`<strong>normalize</strong> (<em>bool</em>, <em>optional</em>) &#x2014;
Whether to normalize the embeddings or not. Defaults to None.
Only available on server powered by Text-Embedding-Inference.`,name:"normalize"},{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.prompt_name",description:`<strong>prompt_name</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The name of the prompt that should be used by for encoding. If not set, no prompt will be applied.
Must be a key in the <em>Sentence Transformers</em> configuration <em>prompts</em> dictionary.
For example if <code>prompt_name</code> is &#x201C;query&#x201D; and the <code>prompts</code> is {&#x201C;query&#x201D;: &#x201C;query: &#x201D;,&#x2026;},
then the sentence &#x201C;What is the capital of France?&#x201D; will be encoded as &#x201C;query: What is the capital of France?&#x201D;
because the prompt text will be prepended before any text to encode.`,name:"prompt_name"},{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.truncate",description:`<strong>truncate</strong> (<em>bool</em>, <em>optional</em>) &#x2014;
Whether to truncate the embeddings or not. Defaults to None.
Only available on server powered by Text-Embedding-Inference.`,name:"truncate"},{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.truncation_direction",description:`<strong>truncation_direction</strong> (<em>Literal[&#x201C;Left&#x201D;, &#x201C;Right&#x201D;]</em>, <em>optional</em>) &#x2014;
Which side of the input should be truncated when <em>truncate=True</em> is passed.`,name:"truncation_direction"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_generated/_async_client.py#L945",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The embedding representing the input text as a float32 numpy array.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><em>np.ndarray</em></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>[<em>InferenceTimeoutError</em>] —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>[<em>InferenceTimeoutError</em>] or <code>aiohttp.ClientResponseError</code></p>
`}}),rs=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.example",$$slots:{default:[Nd]},$$scope:{ctx:I}}}),Sa=new k({props:{name:"fill_mask",anchor:"huggingface_hub.AsyncInferenceClient.fill_mask",parameters:[{name:"text",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.fill_mask.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
a string to be filled from, must contain the [MASK] token (check model card for exact name of the mask).`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.fill_mask.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the fill mask task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended fill mask model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_generated/_async_client.py#L1014",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.FillMaskOutputElement"
>FillMaskOutputElement</a> items containing the predicted label, associated
probability, token reference, and completed text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[FillMaskOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),is=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.fill_mask.example",$$slots:{default:[Wd]},$$scope:{ctx:I}}}),Ra=new k({props:{name:"get_endpoint_info",anchor:"huggingface_hub.AsyncInferenceClient.get_endpoint_info",parameters:[{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.get_endpoint_info.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_generated/_async_client.py#L2653",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Information about the endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, Any]</code></p>
`}}),cs=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.get_endpoint_info.example",$$slots:{default:[Gd]},$$scope:{ctx:I}}}),Da=new k({props:{name:"get_model_status",anchor:"huggingface_hub.AsyncInferenceClient.get_model_status",parameters:[{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.get_model_status.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Identifier of the model for witch the status gonna be checked. If model is not provided,
the model associated with this instance of <a href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> will be used. Only InferenceAPI service can be checked so the
identifier cannot be a URL.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_generated/_async_client.py#L2746",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of ModelStatus dataclass, containing information,
about the state of the model: load, state, compute type and framework.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ModelStatus</code></p>
`}}),ps=new A({props:{$$slots:{default:[Bd]},$$scope:{ctx:I}}}),us=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.get_model_status.example",$$slots:{default:[Qd]},$$scope:{ctx:I}}}),Xa=new k({props:{name:"get_recommended_model",anchor:"huggingface_hub.AsyncInferenceClient.get_recommended_model",parameters:[{name:"task",val:": str"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.get_recommended_model.task",description:`<strong>task</strong> (<code>str</code>) &#x2014;
The Hugging Face task to get which model Hugging Face recommends.
All available tasks can be found <a href="https://huggingface.co/tasks" rel="nofollow">here</a>.`,name:"task"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_generated/_async_client.py#L2629",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Name of the model recommended for the input task.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValueError</code> — If Hugging Face has no recommendation for the input task.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),Ha=new k({props:{name:"health_check",anchor:"huggingface_hub.AsyncInferenceClient.health_check",parameters:[{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.health_check.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
URL of the Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_generated/_async_client.py#L2710",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>True if everything is working fine.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code></p>
`}}),ms=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.health_check.example",$$slots:{default:[Vd]},$$scope:{ctx:I}}}),za=new k({props:{name:"image_classification",anchor:"huggingface_hub.AsyncInferenceClient.image_classification",parameters:[{name:"image",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.image_classification.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The image to classify. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.image_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for image classification. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for image classification will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_generated/_async_client.py#L1051",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.ImageClassificationOutputElement"
>ImageClassificationOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ImageClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),hs=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.image_classification.example",$$slots:{default:[Yd]},$$scope:{ctx:I}}}),Fa=new k({props:{name:"image_segmentation",anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation",parameters:[{name:"image",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The image to segment. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for image segmentation. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for image segmentation will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_generated/_async_client.py#L1088",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.ImageSegmentationOutputElement"
>ImageSegmentationOutputElement</a> items containing the segmented masks and associated attributes.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ImageSegmentationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),ds=new A({props:{warning:!0,$$slots:{default:[Sd]},$$scope:{ctx:I}}}),fs=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation.example",$$slots:{default:[Rd]},$$scope:{ctx:I}}}),La=new k({props:{name:"image_to_image",anchor:"huggingface_hub.AsyncInferenceClient.image_to_image",parameters:[{name:"image",val:": Union"},{name:"prompt",val:": Optional = None"},{name:"negative_prompt",val:": Optional = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": Optional = None"},{name:"guidance_scale",val:": Optional = None"},{name:"model",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image for translation. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.prompt",description:`<strong>prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The text prompt to guide the image generation.`,name:"prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A negative prompt to guide the translation process.`,name:"negative_prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_generated/_async_client.py#L1134",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The translated image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Image</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),ys=new A({props:{warning:!0,$$slots:{default:[Dd]},$$scope:{ctx:I}}}),bs=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.example",$$slots:{default:[Xd]},$$scope:{ctx:I}}}),Oa=new k({props:{name:"image_to_text",anchor:"huggingface_hub.AsyncInferenceClient.image_to_text",parameters:[{name:"image",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.image_to_text.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image to caption. It can be raw bytes, an image file, or a URL to an online image..`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_text.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_generated/_async_client.py#L1219",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.ImageToTextOutput"
>ImageToTextOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Ms=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.image_to_text.example",$$slots:{default:[Hd]},$$scope:{ctx:I}}}),Pa=new k({props:{name:"list_deployed_models",anchor:"huggingface_hub.AsyncInferenceClient.list_deployed_models",parameters:[{name:"frameworks",val:": Union = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.list_deployed_models.frameworks",description:`<strong>frameworks</strong> (<code>Literal[&quot;all&quot;]</code> or <code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
The frameworks to filter on. By default only a subset of the available frameworks are tested. If set to
&#x201C;all&#x201D;, all available frameworks will be tested. It is also possible to provide a single framework or a
custom set of frameworks to check.`,name:"frameworks"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_generated/_async_client.py#L1257",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary mapping task names to a sorted list of model IDs.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, List[str]]</code></p>
`}}),js=new A({props:{warning:!0,$$slots:{default:[zd]},$$scope:{ctx:I}}}),_s=new A({props:{$$slots:{default:[Fd]},$$scope:{ctx:I}}}),Ts=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.list_deployed_models.example",$$slots:{default:[Ld]},$$scope:{ctx:I}}}),Ka=new k({props:{name:"object_detection",anchor:"huggingface_hub.AsyncInferenceClient.object_detection",parameters:[{name:"image",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.object_detection.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The image to detect objects on. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.object_detection.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for object detection. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for object detection (DETR) will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_generated/_async_client.py#L1346",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.ObjectDetectionOutputElement"
>ObjectDetectionOutputElement</a> items containing the bounding boxes and associated attributes.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ObjectDetectionOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
<li><code>ValueError</code> —
If the request output is not a List.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code> or <code>ValueError</code></p>
`}}),Is=new A({props:{warning:!0,$$slots:{default:[Od]},$$scope:{ctx:I}}}),xs=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.object_detection.example",$$slots:{default:[Pd]},$$scope:{ctx:I}}}),el=new k({props:{name:"post",anchor:"huggingface_hub.AsyncInferenceClient.post",parameters:[{name:"json",val:": Union = None"},{name:"data",val:": Union = None"},{name:"model",val:": Optional = None"},{name:"task",val:": Optional = None"},{name:"stream",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.post.json",description:`<strong>json</strong> (<code>Union[str, Dict, List]</code>, <em>optional</em>) &#x2014;
The JSON data to send in the request body, specific to each task. Defaults to None.`,name:"json"},{anchor:"huggingface_hub.AsyncInferenceClient.post.data",description:`<strong>data</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>, <em>optional</em>) &#x2014;
The content to send in the request body, specific to each task.
It can be raw bytes, a pointer to an opened file, a local file path,
or a URL to an online resource (image, audio file,&#x2026;). If both <code>json</code> and <code>data</code> are passed,
<code>data</code> will take precedence. At least <code>json</code> or <code>data</code> must be provided. Defaults to None.`,name:"data"},{anchor:"huggingface_hub.AsyncInferenceClient.post.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. Will override the model defined at the instance level. Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.post.task",description:`<strong>task</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The task to perform on the inference. All available tasks can be found
<a href="https://huggingface.co/tasks" rel="nofollow">here</a>. Used only to default to a recommended model if <code>model</code> is not
provided. At least <code>model</code> or <code>task</code> must be provided. Defaults to None.`,name:"task"},{anchor:"huggingface_hub.AsyncInferenceClient.post.stream",description:`<strong>stream</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to iterate over streaming APIs.`,name:"stream"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_generated/_async_client.py#L192",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The raw bytes returned by the server.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>bytes</p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),nl=new k({props:{name:"question_answering",anchor:"huggingface_hub.AsyncInferenceClient.question_answering",parameters:[{name:"question",val:": str"},{name:"context",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.context",description:`<strong>context</strong> (<code>str</code>) &#x2014;
The context of the question.`,name:"context"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.model",description:`<strong>model</strong> (<code>str</code>) &#x2014;
The model to use for the question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_generated/_async_client.py#L1392",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>an question answering output containing the score, start index, end index, and answer.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.QuestionAnsweringOutputElement"
>QuestionAnsweringOutputElement</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Us=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.example",$$slots:{default:[Kd]},$$scope:{ctx:I}}}),tl=new k({props:{name:"sentence_similarity",anchor:"huggingface_hub.AsyncInferenceClient.sentence_similarity",parameters:[{name:"sentence",val:": str"},{name:"other_sentences",val:": List"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.sentence_similarity.sentence",description:`<strong>sentence</strong> (<code>str</code>) &#x2014;
The main sentence to compare to others.`,name:"sentence"},{anchor:"huggingface_hub.AsyncInferenceClient.sentence_similarity.other_sentences",description:`<strong>other_sentences</strong> (<code>List[str]</code>) &#x2014;
The list of sentences to compare to.`,name:"other_sentences"},{anchor:"huggingface_hub.AsyncInferenceClient.sentence_similarity.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the conversational task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended conversational model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_generated/_async_client.py#L1434",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The embedding representing the input text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[float]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),ws=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.sentence_similarity.example",$$slots:{default:[ef]},$$scope:{ctx:I}}}),sl=new k({props:{name:"summarization",anchor:"huggingface_hub.AsyncInferenceClient.summarization",parameters:[{name:"text",val:": str"},{name:"parameters",val:": Optional = None"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.summarization.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The input text to summarize.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.summarization.parameters",description:`<strong>parameters</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional parameters for summarization. Check out this <a href="https://huggingface.co/docs/api-inference/detailed_parameters#summarization-task" rel="nofollow">page</a>
for more details.`,name:"parameters"},{anchor:"huggingface_hub.AsyncInferenceClient.summarization.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_generated/_async_client.py#L1482",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated summary text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.SummarizationOutput"
>SummarizationOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Js=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.summarization.example",$$slots:{default:[nf]},$$scope:{ctx:I}}}),al=new k({props:{name:"table_question_answering",anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering",parameters:[{name:"table",val:": Dict"},{name:"query",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering.table",description:`<strong>table</strong> (<code>str</code>) &#x2014;
A table of data represented as a dict of lists where entries are headers and the lists are all the
values, all lists must have the same size.`,name:"table"},{anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering.query",description:`<strong>query</strong> (<code>str</code>) &#x2014;
The query in plain text that you want to ask the table.`,name:"query"},{anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering.model",description:`<strong>model</strong> (<code>str</code>) &#x2014;
The model to use for the table-question-answering task. Can be a model ID hosted on the Hugging Face
Hub or a URL to a deployed Inference Endpoint.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_generated/_async_client.py#L1526",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a table question answering output containing the answer, coordinates, cells and the aggregator used.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.TableQuestionAnsweringOutputElement"
>TableQuestionAnsweringOutputElement</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),$s=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering.example",$$slots:{default:[tf]},$$scope:{ctx:I}}}),ll=new k({props:{name:"tabular_classification",anchor:"huggingface_hub.AsyncInferenceClient.tabular_classification",parameters:[{name:"table",val:": Dict"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.tabular_classification.table",description:`<strong>table</strong> (<code>Dict[str, Any]</code>) &#x2014;
Set of attributes to classify.`,name:"table"},{anchor:"huggingface_hub.AsyncInferenceClient.tabular_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the tabular classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended tabular classification model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_generated/_async_client.py#L1572",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of labels, one per row in the initial table.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),vs=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.tabular_classification.example",$$slots:{default:[sf]},$$scope:{ctx:I}}}),ol=new k({props:{name:"tabular_regression",anchor:"huggingface_hub.AsyncInferenceClient.tabular_regression",parameters:[{name:"table",val:": Dict"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.tabular_regression.table",description:`<strong>table</strong> (<code>Dict[str, Any]</code>) &#x2014;
Set of attributes stored in a table. The attributes used to predict the target can be both numerical and categorical.`,name:"table"},{anchor:"huggingface_hub.AsyncInferenceClient.tabular_regression.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the tabular regression task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended tabular regression model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_generated/_async_client.py#L1618",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of predicted numerical target values.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),ks=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.tabular_regression.example",$$slots:{default:[af]},$$scope:{ctx:I}}}),rl=new k({props:{name:"text_classification",anchor:"huggingface_hub.AsyncInferenceClient.text_classification",parameters:[{name:"text",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.text_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be classified.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.text_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the text classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended text classification model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_generated/_async_client.py#L1659",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.TextClassificationOutputElement"
>TextClassificationOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[TextClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),qs=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_classification.example",$$slots:{default:[lf]},$$scope:{ctx:I}}}),il=new k({props:{name:"text_generation",anchor:"huggingface_hub.AsyncInferenceClient.text_generation",parameters:[{name:"prompt",val:": str"},{name:"details",val:": bool = False"},{name:"stream",val:": bool = False"},{name:"model",val:": Optional = None"},{name:"best_of",val:": Optional = None"},{name:"decoder_input_details",val:": Optional = None"},{name:"do_sample",val:": Optional = False"},{name:"frequency_penalty",val:": Optional = None"},{name:"grammar",val:": Optional = None"},{name:"max_new_tokens",val:": Optional = None"},{name:"repetition_penalty",val:": Optional = None"},{name:"return_full_text",val:": Optional = False"},{name:"seed",val:": Optional = None"},{name:"stop_sequences",val:": Optional = None"},{name:"temperature",val:": Optional = None"},{name:"top_k",val:": Optional = None"},{name:"top_n_tokens",val:": Optional = None"},{name:"top_p",val:": Optional = None"},{name:"truncate",val:": Optional = None"},{name:"typical_p",val:": Optional = None"},{name:"watermark",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.prompt",description:`<strong>prompt</strong> (<code>str</code>) &#x2014;
Input text.`,name:"prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.details",description:`<strong>details</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
By default, text_generation returns a string. Pass <code>details=True</code> if you want a detailed output (tokens,
probabilities, seed, finish reason, etc.). Only available for models running on with the
<code>text-generation-inference</code> backend.`,name:"details"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.stream",description:`<strong>stream</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
By default, text_generation returns the full generated text. Pass <code>stream=True</code> if you want a stream of
tokens to be returned. Only available for models running on with the <code>text-generation-inference</code>
backend.`,name:"stream"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.best_of",description:`<strong>best_of</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Generate best_of sequences and return the one if the highest token logprobs.`,name:"best_of"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.decoder_input_details",description:`<strong>decoder_input_details</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Return the decoder input token logprobs and ids. You must set <code>details=True</code> as well for it to be taken
into account. Defaults to <code>False</code>.`,name:"decoder_input_details"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.do_sample",description:`<strong>do_sample</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Activate logits sampling`,name:"do_sample"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.frequency_penalty",description:`<strong>frequency_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in
the text so far, decreasing the model&#x2019;s likelihood to repeat the same line verbatim.`,name:"frequency_penalty"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.grammar",description:`<strong>grammar</strong> (<a href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.TextGenerationInputGrammarType">TextGenerationInputGrammarType</a>, <em>optional</em>) &#x2014;
Grammar constraints. Can be either a JSONSchema or a regex.`,name:"grammar"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum number of generated tokens`,name:"max_new_tokens"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">this
paper</a> for more details.`,name:"repetition_penalty"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.return_full_text",description:`<strong>return_full_text</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to prepend the prompt to the generated text`,name:"return_full_text"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.seed",description:`<strong>seed</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Random sampling seed`,name:"seed"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.stop_sequences",description:`<strong>stop_sequences</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Stop generating tokens if a member of <code>stop_sequences</code> is generated`,name:"stop_sequences"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The value used to module the logits distribution.`,name:"temperature"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.top_n_tokens",description:`<strong>top_n_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Return information about the <code>top_n_tokens</code> most likely tokens at each generation step, instead of
just the sampled token.`,name:"top_n_tokens"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.top_k",description:"<strong>top_k</strong> (<code>int</code>, *optional`) &#x2014;\nThe number of highest probability vocabulary tokens to keep for top-k-filtering.",name:"top_k"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.top_p",description:"<strong>top_p</strong> (<code>float</code>, *optional<code>) -- If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to </code>top_p` or\nhigher are kept for generation.",name:"top_p"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.truncate",description:"<strong>truncate</strong> (<code>int</code>, *optional`) &#x2014;\nTruncate inputs tokens to the given size.",name:"truncate"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.typical_p",description:`<strong>typical_p</strong> (<code>float</code>, *optional\`) &#x2014;
Typical Decoding mass
See <a href="https://arxiv.org/abs/2202.00666" rel="nofollow">Typical Decoding for Natural Language Generation</a> for more information`,name:"typical_p"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.watermark",description:'<strong>watermark</strong> (<code>bool</code>, *optional`) &#x2014;\nWatermarking with <a href="https://arxiv.org/abs/2301.10226" rel="nofollow">A Watermark for Large Language Models</a>',name:"watermark"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_generated/_async_client.py#L1837",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Generated text returned from the server:</p>
<ul>
<li>if <code>stream=False</code> and <code>details=False</code>, the generated text is returned as a <code>str</code> (default)</li>
<li>if <code>stream=True</code> and <code>details=False</code>, the generated text is returned token by token as a <code>Iterable[str]</code></li>
<li>if <code>stream=False</code> and <code>details=True</code>, the generated text is returned with more details as a <a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.TextGenerationOutput"
>TextGenerationOutput</a></li>
<li>if <code>details=True</code> and <code>stream=True</code>, the generated text is returned token by token as a iterable of <a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.TextGenerationStreamOutput"
>TextGenerationStreamOutput</a></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Union[str, TextGenerationOutput, Iterable[str], Iterable[TextGenerationStreamOutput]]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValidationError</code> —
If input values are not valid. No HTTP call is made to the server.</li>
<li><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValidationError</code> or <a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Es=new A({props:{$$slots:{default:[of]},$$scope:{ctx:I}}}),As=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.example",$$slots:{default:[rf]},$$scope:{ctx:I}}}),cl=new k({props:{name:"text_to_image",anchor:"huggingface_hub.AsyncInferenceClient.text_to_image",parameters:[{name:"prompt",val:": str"},{name:"negative_prompt",val:": Optional = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": Optional = None"},{name:"guidance_scale",val:": Optional = None"},{name:"model",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.prompt",description:`<strong>prompt</strong> (<code>str</code>) &#x2014;
The prompt to generate an image from.`,name:"prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
An optional negative prompt for the image generation.`,name:"negative_prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.height",description:`<strong>height</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The height in pixels of the image to generate.`,name:"height"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.width",description:`<strong>width</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The width in pixels of the image to generate.`,name:"width"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_generated/_async_client.py#L2162",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Image</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Zs=new A({props:{warning:!0,$$slots:{default:[cf]},$$scope:{ctx:I}}}),Ns=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.example",$$slots:{default:[pf]},$$scope:{ctx:I}}}),pl=new k({props:{name:"text_to_speech",anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech",parameters:[{name:"text",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The text to synthesize.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_generated/_async_client.py#L2243",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated audio.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bytes</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Ws=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.example",$$slots:{default:[uf]},$$scope:{ctx:I}}}),ul=new k({props:{name:"token_classification",anchor:"huggingface_hub.AsyncInferenceClient.token_classification",parameters:[{name:"text",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.token_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be classified.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.token_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the token classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended token classification model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_generated/_async_client.py#L2276",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.TokenClassificationOutputElement"
>TokenClassificationOutputElement</a> items containing the entity group, confidence score, word, start and end index.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[TokenClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Gs=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.token_classification.example",$$slots:{default:[gf]},$$scope:{ctx:I}}}),gl=new k({props:{name:"translation",anchor:"huggingface_hub.AsyncInferenceClient.translation",parameters:[{name:"text",val:": str"},{name:"model",val:": Optional = None"},{name:"src_lang",val:": Optional = None"},{name:"tgt_lang",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.translation.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be translated.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.translation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the translation task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended translation model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.translation.src_lang",description:`<strong>src_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Source language of the translation task, i.e. input language. Cannot be passed without <code>tgt_lang</code>.`,name:"src_lang"},{anchor:"huggingface_hub.AsyncInferenceClient.translation.tgt_lang",description:`<strong>tgt_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Target language of the translation task, i.e. output language. Cannot be passed without <code>src_lang</code>.`,name:"tgt_lang"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_generated/_async_client.py#L2332",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated translated text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.TranslationOutput"
>TranslationOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
<li><code>ValueError</code> —
If only one of the <code>src_lang</code> and <code>tgt_lang</code> arguments are provided.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code> or <code>ValueError</code></p>
`}}),Bs=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.translation.example",$$slots:{default:[mf]},$$scope:{ctx:I}}}),Qs=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.translation.example-2",$$slots:{default:[hf]},$$scope:{ctx:I}}}),ml=new k({props:{name:"visual_question_answering",anchor:"huggingface_hub.AsyncInferenceClient.visual_question_answering",parameters:[{name:"image",val:": Union"},{name:"question",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.visual_question_answering.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image for the context. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.visual_question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.AsyncInferenceClient.visual_question_answering.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the visual question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended visual question answering model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_generated/_async_client.py#L2398",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.VisualQuestionAnsweringOutputElement"
>VisualQuestionAnsweringOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[VisualQuestionAnsweringOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>InferenceTimeoutError</code> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>InferenceTimeoutError</code> or <code>aiohttp.ClientResponseError</code></p>
`}}),Vs=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.visual_question_answering.example",$$slots:{default:[df]},$$scope:{ctx:I}}}),hl=new k({props:{name:"zero_shot_classification",anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification",parameters:[{name:"text",val:": str"},{name:"labels",val:": List"},{name:"multi_label",val:": bool = False"},{name:"hypothesis_template",val:": Optional = None"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The input text to classify.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.labels",description:`<strong>labels</strong> (<code>List[str]</code>) &#x2014;
List of strings. Each string is the verbalization of a possible label for the input text.`,name:"labels"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.multi_label",description:`<strong>multi_label</strong> (<code>bool</code>) &#x2014;
Boolean. If True, the probability for each label is evaluated independently and multiple labels can have a probability close to 1 simultaneously or all probabilities can be close to 0.
If False, the labels are considered mutually exclusive and the probability over all labels always sums to 1. Defaults to False.`,name:"multi_label"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.hypothesis_template",description:`<strong>hypothesis_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A template sentence string with curly brackets to which the label strings are added. The label strings are added at the position of the curly brackets &#x201D;{}&#x201C;.
Zero-shot classifiers are based on NLI models, which evaluate if a hypothesis is entailed in another text or not.
For example, with hypothesis_template=&#x201C;This text is about {}.&#x201D; and labels=[&#x201C;economics&#x201D;, &#x201C;politics&#x201D;], the system internally creates the two hypotheses &#x201C;This text is about economics.&#x201D; and &#x201C;This text is about politics.&#x201D;.
The model then evaluates for both hypotheses if they are entailed in the provided <code>text</code> or not.`,name:"hypothesis_template"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_generated/_async_client.py#L2446",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.ZeroShotClassificationOutputElement"
>ZeroShotClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ZeroShotClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Ys=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.example",$$slots:{default:[ff]},$$scope:{ctx:I}}}),Ss=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.example-2",$$slots:{default:[yf]},$$scope:{ctx:I}}}),dl=new k({props:{name:"zero_shot_image_classification",anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification",parameters:[{name:"image",val:": Union"},{name:"labels",val:": List"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image to caption. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification.labels",description:`<strong>labels</strong> (<code>List[str]</code>) &#x2014;
List of string possible labels. There must be at least 2 labels.`,name:"labels"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_generated/_async_client.py#L2551",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_types#huggingface_hub.ZeroShotImageClassificationOutputElement"
>ZeroShotImageClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ZeroShotImageClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2386/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Rs=new E({props:{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification.example",$$slots:{default:[bf]},$$scope:{ctx:I}}}),fl=new it({props:{title:"추론 시간 초과 오류",local:"huggingface_hub.InferenceTimeoutError ][ huggingface_hub.InferenceTimeoutError",headingTag:"h2"}}),yl=new k({props:{name:"class huggingface_hub.InferenceTimeoutError",anchor:"huggingface_hub.InferenceTimeoutError",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/errors.py#L23"}}),bl=new it({props:{title:"반환 유형",local:"return-types",headingTag:"h2"}}),jl=new it({props:{title:"대화형 출력 대화",local:"huggingface_hub.inference._types.ConversationalOutputConversation ][ huggingface_hub.inference._types.ConversationalOutputConversation",headingTag:"h3"}}),_l=new k({props:{name:"class huggingface_hub.inference._types.ConversationalOutputConversation",anchor:"huggingface_hub.inference._types.ConversationalOutputConversation",parameters:"",parametersDescription:[{anchor:"huggingface_hub.inference._types.ConversationalOutputConversation.generated_responses",description:`<strong>generated_responses</strong> (<code>List[str]</code>) &#x2014;
A list of the responses from the model.`,name:"generated_responses"},{anchor:"huggingface_hub.inference._types.ConversationalOutputConversation.past_user_inputs",description:`<strong>past_user_inputs</strong> (<code>List[str]</code>) &#x2014;
A list of the inputs from the user. Must be the same length as <code>generated_responses</code>.`,name:"past_user_inputs"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_types.py#L24"}}),Tl=new it({props:{title:"대화형 출력",local:"huggingface_hub.inference._types.ConversationalOutput ][ huggingface_hub.inference._types.ConversationalOutput",headingTag:"h3"}}),Il=new k({props:{name:"class huggingface_hub.inference._types.ConversationalOutput",anchor:"huggingface_hub.inference._types.ConversationalOutput",parameters:"",parametersDescription:[{anchor:"huggingface_hub.inference._types.ConversationalOutput.generated_text",description:`<strong>generated_text</strong> (<code>str</code>) &#x2014;
The last response from the model.`,name:"generated_text"},{anchor:"huggingface_hub.inference._types.ConversationalOutput.conversation",description:`<strong>conversation</strong> (<code>ConversationalOutputConversation</code>) &#x2014;
The past conversation.`,name:"conversation"},{anchor:"huggingface_hub.inference._types.ConversationalOutput.warnings",description:`<strong>warnings</strong> (<code>List[str]</code>) &#x2014;
A list of warnings associated with the process.`,name:"warnings"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_types.py#L38"}}),xl=new it({props:{title:"모델 상태",local:"huggingface_hub.inference._common.ModelStatus ][ huggingface_hub.inference._common.ModelStatus",headingTag:"h3"}}),Cl=new k({props:{name:"class huggingface_hub.inference._common.ModelStatus",anchor:"huggingface_hub.inference._common.ModelStatus",parameters:[{name:"loaded",val:": bool"},{name:"state",val:": str"},{name:"compute_type",val:": Dict"},{name:"framework",val:": str"}],parametersDescription:[{anchor:"huggingface_hub.inference._common.ModelStatus.loaded",description:`<strong>loaded</strong> (<code>bool</code>) &#x2014;
If the model is currently loaded into Hugging Face&#x2019;s InferenceAPI. Models
are loaded on-demand, leading to the user&#x2019;s first request taking longer.
If a model is loaded, you can be assured that it is in a healthy state.`,name:"loaded"},{anchor:"huggingface_hub.inference._common.ModelStatus.state",description:`<strong>state</strong> (<code>str</code>) &#x2014;
The current state of the model. This can be &#x2018;Loaded&#x2019;, &#x2018;Loadable&#x2019;, &#x2018;TooBig&#x2019;.
If a model&#x2019;s state is &#x2018;Loadable&#x2019;, it&#x2019;s not too big and has a supported
backend. Loadable models are automatically loaded when the user first
requests inference on the endpoint. This means it is transparent for the
user to load a model, except that the first call takes longer to complete.`,name:"state"},{anchor:"huggingface_hub.inference._common.ModelStatus.compute_type",description:`<strong>compute_type</strong> (<code>Dict</code>) &#x2014;
Information about the compute resource the model is using or will use, such as &#x2018;gpu&#x2019; type and number of
replicas.`,name:"compute_type"},{anchor:"huggingface_hub.inference._common.ModelStatus.framework",description:`<strong>framework</strong> (<code>str</code>) &#x2014;
The name of the framework that the model was built with, such as &#x2018;transformers&#x2019;
or &#x2018;text-generation-inference&#x2019;.`,name:"framework"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference/_common.py#L87"}}),Ul=new it({props:{title:"추론 API",local:"huggingface_hub.InferenceApi ][ huggingface_hub.InferenceApi",headingTag:"h2"}}),Jl=new k({props:{name:"class huggingface_hub.InferenceApi",anchor:"huggingface_hub.InferenceApi",parameters:[{name:"repo_id",val:": str"},{name:"task",val:": Optional = None"},{name:"token",val:": Optional = None"},{name:"gpu",val:": bool = False"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference_api.py#L46"}}),Ds=new E({props:{anchor:"huggingface_hub.InferenceApi.example",$$slots:{default:[Mf]},$$scope:{ctx:I}}}),$l=new k({props:{name:"__init__",anchor:"huggingface_hub.InferenceApi.__init__",parameters:[{name:"repo_id",val:": str"},{name:"task",val:": Optional = None"},{name:"token",val:": Optional = None"},{name:"gpu",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.InferenceApi.__init__.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
Id of repository (e.g. <em>user/bert-base-uncased</em>).`,name:"repo_id"},{anchor:"huggingface_hub.InferenceApi.__init__.task",description:`<strong>task</strong> (<code>str</code>, <em>optional</em>, defaults <code>None</code>) &#x2014;
Whether to force a task instead of using task specified in the
repository.`,name:"task"},{anchor:"huggingface_hub.InferenceApi.__init__.token",description:`<strong>token</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The API token to use as HTTP bearer authorization. This is not
the authentication token. You can find the token in
<a href="https://huggingface.co/settings/token" rel="nofollow">https://huggingface.co/settings/token</a>. Alternatively, you can
find both your organizations and personal API tokens using
<em>HfApi().whoami(token)</em>.`,name:"token"},{anchor:"huggingface_hub.InferenceApi.__init__.gpu",description:`<strong>gpu</strong> (<em>bool</em>, <em>optional</em>, defaults <em>False</em>) &#x2014;
Whether to use GPU instead of CPU for inference(requires Startup
plan at least).`,name:"gpu"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference_api.py#L93"}}),vl=new k({props:{name:"__call__",anchor:"huggingface_hub.InferenceApi.__call__",parameters:[{name:"inputs",val:": Union = None"},{name:"params",val:": Optional = None"},{name:"data",val:": Optional = None"},{name:"raw_response",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.InferenceApi.__call__.inputs",description:`<strong>inputs</strong> (<code>str</code> or <code>Dict</code> or <code>List[str]</code> or <code>List[List[str]]</code>, <em>optional</em>) &#x2014;
Inputs for the prediction.`,name:"inputs"},{anchor:"huggingface_hub.InferenceApi.__call__.params",description:`<strong>params</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Additional parameters for the models. Will be sent as <code>parameters</code> in the
payload.`,name:"params"},{anchor:"huggingface_hub.InferenceApi.__call__.data",description:`<strong>data</strong> (<code>bytes</code>, <em>optional</em>) &#x2014;
Bytes content of the request. In this case, leave <code>inputs</code> and <code>params</code> empty.`,name:"data"},{anchor:"huggingface_hub.InferenceApi.__call__.raw_response",description:`<strong>raw_response</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, the raw <code>Response</code> object is returned. You can parse its content
as preferred. By default, the content is parsed into a more practical format
(json dictionary or PIL Image for example).`,name:"raw_response"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2386/src/huggingface_hub/inference_api.py#L158"}}),kl=new Bh({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/ko/package_reference/inference_client.md"}}),{c(){n=u("meta"),m=r(),a=u("p"),t=r(),h(o.$$.fragment),e=r(),c=u("p"),c.innerHTML=Eg,$r=r(),zs=u("ul"),zs.innerHTML=Ag,vr=r(),Fs=u("p"),Fs.innerHTML=Zg,kr=r(),h(Ls.$$.fragment),qr=r(),C=u("div"),h(Os.$$.fragment),Kr=r(),Yl=u("p"),Yl.textContent=Ng,ei=r(),Sl=u("p"),Sl.innerHTML=Wg,ni=r(),Ze=u("div"),h(Ps.$$.fragment),ti=r(),Rl=u("p"),Rl.textContent=Gg,si=r(),h(ct.$$.fragment),ai=r(),Ne=u("div"),h(Ks.$$.fragment),li=r(),Dl=u("p"),Dl.textContent=Bg,oi=r(),h(pt.$$.fragment),ri=r(),We=u("div"),h(ea.$$.fragment),ii=r(),Xl=u("p"),Xl.textContent=Qg,ci=r(),h(ut.$$.fragment),pi=r(),Ge=u("div"),h(na.$$.fragment),ui=r(),Hl=u("p"),Hl.textContent=Vg,gi=r(),h(gt.$$.fragment),mi=r(),F=u("div"),h(ta.$$.fragment),hi=r(),zl=u("p"),zl.textContent=Yg,di=r(),h(mt.$$.fragment),fi=r(),h(ht.$$.fragment),yi=r(),Be=u("div"),h(sa.$$.fragment),bi=r(),Fl=u("p"),Fl.textContent=Sg,Mi=r(),h(dt.$$.fragment),ji=r(),Qe=u("div"),h(aa.$$.fragment),_i=r(),Ll=u("p"),Ll.textContent=Rg,Ti=r(),h(ft.$$.fragment),Ii=r(),Ve=u("div"),h(la.$$.fragment),xi=r(),Ol=u("p"),Ol.textContent=Dg,Ci=r(),h(yt.$$.fragment),Ui=r(),L=u("div"),h(oa.$$.fragment),wi=r(),Pl=u("p"),Pl.textContent=Xg,Ji=r(),Kl=u("p"),Kl.innerHTML=Hg,$i=r(),h(bt.$$.fragment),vi=r(),O=u("div"),h(ra.$$.fragment),ki=r(),eo=u("p"),eo.textContent=zg,qi=r(),h(Mt.$$.fragment),Ei=r(),h(jt.$$.fragment),Ai=r(),_t=u("div"),h(ia.$$.fragment),Zi=r(),no=u("p"),no.textContent=Fg,Ni=r(),P=u("div"),h(ca.$$.fragment),Wi=r(),to=u("p"),to.textContent=Lg,Gi=r(),so=u("p"),so.innerHTML=Og,Bi=r(),h(Tt.$$.fragment),Qi=r(),Ye=u("div"),h(pa.$$.fragment),Vi=r(),ao=u("p"),ao.textContent=Pg,Yi=r(),h(It.$$.fragment),Si=r(),K=u("div"),h(ua.$$.fragment),Ri=r(),lo=u("p"),lo.textContent=Kg,Di=r(),h(xt.$$.fragment),Xi=r(),h(Ct.$$.fragment),Hi=r(),ee=u("div"),h(ga.$$.fragment),zi=r(),oo=u("p"),oo.textContent=em,Fi=r(),h(Ut.$$.fragment),Li=r(),h(wt.$$.fragment),Oi=r(),ne=u("div"),h(ma.$$.fragment),Pi=r(),ro=u("p"),ro.textContent=nm,Ki=r(),io=u("p"),io.textContent=tm,ec=r(),h(Jt.$$.fragment),nc=r(),Z=u("div"),h(ha.$$.fragment),tc=r(),co=u("p"),co.textContent=sm,sc=r(),po=u("p"),po.innerHTML=am,ac=r(),h($t.$$.fragment),lc=r(),h(vt.$$.fragment),oc=r(),h(kt.$$.fragment),rc=r(),te=u("div"),h(da.$$.fragment),ic=r(),uo=u("p"),uo.textContent=lm,cc=r(),h(qt.$$.fragment),pc=r(),h(Et.$$.fragment),uc=r(),At=u("div"),h(fa.$$.fragment),gc=r(),go=u("p"),go.textContent=om,mc=r(),Se=u("div"),h(ya.$$.fragment),hc=r(),mo=u("p"),mo.textContent=rm,dc=r(),h(Zt.$$.fragment),fc=r(),Re=u("div"),h(ba.$$.fragment),yc=r(),ho=u("p"),ho.textContent=im,bc=r(),h(Nt.$$.fragment),Mc=r(),De=u("div"),h(Ma.$$.fragment),jc=r(),fo=u("p"),fo.textContent=cm,_c=r(),h(Wt.$$.fragment),Tc=r(),Xe=u("div"),h(ja.$$.fragment),Ic=r(),yo=u("p"),yo.textContent=pm,xc=r(),h(Gt.$$.fragment),Cc=r(),He=u("div"),h(_a.$$.fragment),Uc=r(),bo=u("p"),bo.textContent=um,wc=r(),h(Bt.$$.fragment),Jc=r(),ze=u("div"),h(Ta.$$.fragment),$c=r(),Mo=u("p"),Mo.textContent=gm,vc=r(),h(Qt.$$.fragment),kc=r(),Fe=u("div"),h(Ia.$$.fragment),qc=r(),jo=u("p"),jo.textContent=mm,Ec=r(),h(Vt.$$.fragment),Ac=r(),N=u("div"),h(xa.$$.fragment),Zc=r(),_o=u("p"),_o.textContent=hm,Nc=r(),To=u("p"),To.innerHTML=dm,Wc=r(),Io=u("p"),Io.innerHTML=fm,Gc=r(),h(Yt.$$.fragment),Bc=r(),h(St.$$.fragment),Qc=r(),se=u("div"),h(Ca.$$.fragment),Vc=r(),xo=u("p"),xo.textContent=ym,Yc=r(),h(Rt.$$.fragment),Sc=r(),h(Dt.$$.fragment),Rc=r(),Le=u("div"),h(Ua.$$.fragment),Dc=r(),Co=u("p"),Co.textContent=bm,Xc=r(),h(Xt.$$.fragment),Hc=r(),Oe=u("div"),h(wa.$$.fragment),zc=r(),Uo=u("p"),Uo.textContent=Mm,Fc=r(),h(Ht.$$.fragment),Lc=r(),R=u("div"),h(Ja.$$.fragment),Oc=r(),wo=u("p"),wo.textContent=jm,Pc=r(),Jo=u("p"),Jo.innerHTML=_m,Kc=r(),h(zt.$$.fragment),ep=r(),h(Ft.$$.fragment),np=r(),Pe=u("div"),h($a.$$.fragment),tp=r(),$o=u("p"),$o.textContent=Tm,sp=r(),h(Lt.$$.fragment),ap=r(),ae=u("div"),h(va.$$.fragment),lp=r(),vo=u("p"),vo.textContent=Im,op=r(),h(Ot.$$.fragment),rp=r(),h(Pt.$$.fragment),ip=r(),Ke=u("div"),h(ka.$$.fragment),cp=r(),ko=u("p"),ko.textContent=xm,pp=r(),h(Kt.$$.fragment),Er=r(),h(qa.$$.fragment),Ar=r(),Ea=u("p"),Ea.innerHTML=Cm,Zr=r(),h(Aa.$$.fragment),Nr=r(),U=u("div"),h(Za.$$.fragment),up=r(),qo=u("p"),qo.textContent=Um,gp=r(),Eo=u("p"),Eo.innerHTML=wm,mp=r(),en=u("div"),h(Na.$$.fragment),hp=r(),Ao=u("p"),Ao.textContent=Jm,dp=r(),h(es.$$.fragment),fp=r(),nn=u("div"),h(Wa.$$.fragment),yp=r(),Zo=u("p"),Zo.textContent=$m,bp=r(),h(ns.$$.fragment),Mp=r(),tn=u("div"),h(Ga.$$.fragment),jp=r(),No=u("p"),No.textContent=vm,_p=r(),h(ts.$$.fragment),Tp=r(),sn=u("div"),h(Ba.$$.fragment),Ip=r(),Wo=u("p"),Wo.textContent=km,xp=r(),h(ss.$$.fragment),Cp=r(),le=u("div"),h(Qa.$$.fragment),Up=r(),Go=u("p"),Go.textContent=qm,wp=r(),h(as.$$.fragment),Jp=r(),h(ls.$$.fragment),$p=r(),an=u("div"),h(Va.$$.fragment),vp=r(),Bo=u("p"),Bo.textContent=Em,kp=r(),h(os.$$.fragment),qp=r(),ln=u("div"),h(Ya.$$.fragment),Ep=r(),Qo=u("p"),Qo.textContent=Am,Ap=r(),h(rs.$$.fragment),Zp=r(),on=u("div"),h(Sa.$$.fragment),Np=r(),Vo=u("p"),Vo.textContent=Zm,Wp=r(),h(is.$$.fragment),Gp=r(),oe=u("div"),h(Ra.$$.fragment),Bp=r(),Yo=u("p"),Yo.textContent=Nm,Qp=r(),So=u("p"),So.innerHTML=Wm,Vp=r(),h(cs.$$.fragment),Yp=r(),re=u("div"),h(Da.$$.fragment),Sp=r(),Ro=u("p"),Ro.textContent=Gm,Rp=r(),h(ps.$$.fragment),Dp=r(),h(us.$$.fragment),Xp=r(),gs=u("div"),h(Xa.$$.fragment),Hp=r(),Do=u("p"),Do.textContent=Bm,zp=r(),ie=u("div"),h(Ha.$$.fragment),Fp=r(),Xo=u("p"),Xo.textContent=Qm,Lp=r(),Ho=u("p"),Ho.innerHTML=Vm,Op=r(),h(ms.$$.fragment),Pp=r(),rn=u("div"),h(za.$$.fragment),Kp=r(),zo=u("p"),zo.textContent=Ym,eu=r(),h(hs.$$.fragment),nu=r(),ce=u("div"),h(Fa.$$.fragment),tu=r(),Fo=u("p"),Fo.textContent=Sm,su=r(),h(ds.$$.fragment),au=r(),h(fs.$$.fragment),lu=r(),pe=u("div"),h(La.$$.fragment),ou=r(),Lo=u("p"),Lo.textContent=Rm,ru=r(),h(ys.$$.fragment),iu=r(),h(bs.$$.fragment),cu=r(),ue=u("div"),h(Oa.$$.fragment),pu=r(),Oo=u("p"),Oo.textContent=Dm,uu=r(),Po=u("p"),Po.textContent=Xm,gu=r(),h(Ms.$$.fragment),mu=r(),W=u("div"),h(Pa.$$.fragment),hu=r(),Ko=u("p"),Ko.textContent=Hm,du=r(),er=u("p"),er.innerHTML=zm,fu=r(),h(js.$$.fragment),yu=r(),h(_s.$$.fragment),bu=r(),h(Ts.$$.fragment),Mu=r(),ge=u("div"),h(Ka.$$.fragment),ju=r(),nr=u("p"),nr.textContent=Fm,_u=r(),h(Is.$$.fragment),Tu=r(),h(xs.$$.fragment),Iu=r(),Cs=u("div"),h(el.$$.fragment),xu=r(),tr=u("p"),tr.textContent=Lm,Cu=r(),cn=u("div"),h(nl.$$.fragment),Uu=r(),sr=u("p"),sr.textContent=Om,wu=r(),h(Us.$$.fragment),Ju=r(),pn=u("div"),h(tl.$$.fragment),$u=r(),ar=u("p"),ar.textContent=Pm,vu=r(),h(ws.$$.fragment),ku=r(),un=u("div"),h(sl.$$.fragment),qu=r(),lr=u("p"),lr.textContent=Km,Eu=r(),h(Js.$$.fragment),Au=r(),gn=u("div"),h(al.$$.fragment),Zu=r(),or=u("p"),or.textContent=eh,Nu=r(),h($s.$$.fragment),Wu=r(),mn=u("div"),h(ll.$$.fragment),Gu=r(),rr=u("p"),rr.textContent=nh,Bu=r(),h(vs.$$.fragment),Qu=r(),hn=u("div"),h(ol.$$.fragment),Vu=r(),ir=u("p"),ir.textContent=th,Yu=r(),h(ks.$$.fragment),Su=r(),dn=u("div"),h(rl.$$.fragment),Ru=r(),cr=u("p"),cr.textContent=sh,Du=r(),h(qs.$$.fragment),Xu=r(),G=u("div"),h(il.$$.fragment),Hu=r(),pr=u("p"),pr.textContent=ah,zu=r(),ur=u("p"),ur.innerHTML=lh,Fu=r(),gr=u("p"),gr.innerHTML=oh,Lu=r(),h(Es.$$.fragment),Ou=r(),h(As.$$.fragment),Pu=r(),me=u("div"),h(cl.$$.fragment),Ku=r(),mr=u("p"),mr.textContent=rh,eg=r(),h(Zs.$$.fragment),ng=r(),h(Ns.$$.fragment),tg=r(),fn=u("div"),h(pl.$$.fragment),sg=r(),hr=u("p"),hr.textContent=ih,ag=r(),h(Ws.$$.fragment),lg=r(),yn=u("div"),h(ul.$$.fragment),og=r(),dr=u("p"),dr.textContent=ch,rg=r(),h(Gs.$$.fragment),ig=r(),D=u("div"),h(gl.$$.fragment),cg=r(),fr=u("p"),fr.textContent=ph,pg=r(),yr=u("p"),yr.innerHTML=uh,ug=r(),h(Bs.$$.fragment),gg=r(),h(Qs.$$.fragment),mg=r(),bn=u("div"),h(ml.$$.fragment),hg=r(),br=u("p"),br.textContent=gh,dg=r(),h(Vs.$$.fragment),fg=r(),he=u("div"),h(hl.$$.fragment),yg=r(),Mr=u("p"),Mr.textContent=mh,bg=r(),h(Ys.$$.fragment),Mg=r(),h(Ss.$$.fragment),jg=r(),Mn=u("div"),h(dl.$$.fragment),_g=r(),jr=u("p"),jr.textContent=hh,Tg=r(),h(Rs.$$.fragment),Wr=r(),h(fl.$$.fragment),Gr=r(),jn=u("div"),h(yl.$$.fragment),Ig=r(),_r=u("p"),_r.textContent=dh,Br=r(),h(bl.$$.fragment),Qr=r(),Ml=u("p"),Ml.textContent=fh,Vr=r(),h(jl.$$.fragment),Yr=r(),_n=u("div"),h(_l.$$.fragment),xg=r(),Tr=u("p"),Tr.innerHTML=yh,Sr=r(),h(Tl.$$.fragment),Rr=r(),Tn=u("div"),h(Il.$$.fragment),Cg=r(),Ir=u("p"),Ir.innerHTML=bh,Dr=r(),h(xl.$$.fragment),Xr=r(),In=u("div"),h(Cl.$$.fragment),Ug=r(),xr=u("p"),xr.textContent=Mh,Hr=r(),h(Ul.$$.fragment),zr=r(),wl=u("p"),wl.innerHTML=jh,Fr=r(),B=u("div"),h(Jl.$$.fragment),wg=r(),Cr=u("p"),Cr.textContent=_h,Jg=r(),h(Ds.$$.fragment),$g=r(),Xs=u("div"),h($l.$$.fragment),vg=r(),Ur=u("p"),Ur.textContent=Th,kg=r(),Hs=u("div"),h(vl.$$.fragment),qg=r(),wr=u("p"),wr.textContent=Ih,Lr=r(),h(kl.$$.fragment),Or=r(),Jr=u("p"),this.h()},l(s){const j=Gh("svelte-u9bgzb",document.head);n=g(j,"META",{name:!0,content:!0}),j.forEach(p),m=i(s),a=g(s,"P",{}),w(a).forEach(p),t=i(s),d(o.$$.fragment,s),e=i(s),c=g(s,"P",{"data-svelte-h":!0}),T(c)!=="svelte-10zkjtm"&&(c.innerHTML=Eg),$r=i(s),zs=g(s,"UL",{"data-svelte-h":!0}),T(zs)!=="svelte-5iysbw"&&(zs.innerHTML=Ag),vr=i(s),Fs=g(s,"P",{"data-svelte-h":!0}),T(Fs)!=="svelte-22m14t"&&(Fs.innerHTML=Zg),kr=i(s),d(Ls.$$.fragment,s),qr=i(s),C=g(s,"DIV",{class:!0});var $=w(C);d(Os.$$.fragment,$),Kr=i($),Yl=g($,"P",{"data-svelte-h":!0}),T(Yl)!=="svelte-1p4u01l"&&(Yl.textContent=Ng),ei=i($),Sl=g($,"P",{"data-svelte-h":!0}),T(Sl)!=="svelte-1uhixc4"&&(Sl.innerHTML=Wg),ni=i($),Ze=g($,"DIV",{class:!0});var xn=w(Ze);d(Ps.$$.fragment,xn),ti=i(xn),Rl=g(xn,"P",{"data-svelte-h":!0}),T(Rl)!=="svelte-1hs5qib"&&(Rl.textContent=Gg),si=i(xn),d(ct.$$.fragment,xn),xn.forEach(p),ai=i($),Ne=g($,"DIV",{class:!0});var Cn=w(Ne);d(Ks.$$.fragment,Cn),li=i(Cn),Dl=g(Cn,"P",{"data-svelte-h":!0}),T(Dl)!=="svelte-z9e742"&&(Dl.textContent=Bg),oi=i(Cn),d(pt.$$.fragment,Cn),Cn.forEach(p),ri=i($),We=g($,"DIV",{class:!0});var Un=w(We);d(ea.$$.fragment,Un),ii=i(Un),Xl=g(Un,"P",{"data-svelte-h":!0}),T(Xl)!=="svelte-lahnll"&&(Xl.textContent=Qg),ci=i(Un),d(ut.$$.fragment,Un),Un.forEach(p),pi=i($),Ge=g($,"DIV",{class:!0});var wn=w(Ge);d(na.$$.fragment,wn),ui=i(wn),Hl=g(wn,"P",{"data-svelte-h":!0}),T(Hl)!=="svelte-5o70yf"&&(Hl.textContent=Vg),gi=i(wn),d(gt.$$.fragment,wn),wn.forEach(p),mi=i($),F=g($,"DIV",{class:!0});var de=w(F);d(ta.$$.fragment,de),hi=i(de),zl=g(de,"P",{"data-svelte-h":!0}),T(zl)!=="svelte-2dk21c"&&(zl.textContent=Yg),di=i(de),d(mt.$$.fragment,de),fi=i(de),d(ht.$$.fragment,de),de.forEach(p),yi=i($),Be=g($,"DIV",{class:!0});var Jn=w(Be);d(sa.$$.fragment,Jn),bi=i(Jn),Fl=g(Jn,"P",{"data-svelte-h":!0}),T(Fl)!=="svelte-qs8cmr"&&(Fl.textContent=Sg),Mi=i(Jn),d(dt.$$.fragment,Jn),Jn.forEach(p),ji=i($),Qe=g($,"DIV",{class:!0});var $n=w(Qe);d(aa.$$.fragment,$n),_i=i($n),Ll=g($n,"P",{"data-svelte-h":!0}),T(Ll)!=="svelte-1axtrg9"&&(Ll.textContent=Rg),Ti=i($n),d(ft.$$.fragment,$n),$n.forEach(p),Ii=i($),Ve=g($,"DIV",{class:!0});var vn=w(Ve);d(la.$$.fragment,vn),xi=i(vn),Ol=g(vn,"P",{"data-svelte-h":!0}),T(Ol)!=="svelte-1lnjtsz"&&(Ol.textContent=Dg),Ci=i(vn),d(yt.$$.fragment,vn),vn.forEach(p),Ui=i($),L=g($,"DIV",{class:!0});var fe=w(L);d(oa.$$.fragment,fe),wi=i(fe),Pl=g(fe,"P",{"data-svelte-h":!0}),T(Pl)!=="svelte-s2la9t"&&(Pl.textContent=Xg),Ji=i(fe),Kl=g(fe,"P",{"data-svelte-h":!0}),T(Kl)!=="svelte-1xhka28"&&(Kl.innerHTML=Hg),$i=i(fe),d(bt.$$.fragment,fe),fe.forEach(p),vi=i($),O=g($,"DIV",{class:!0});var ye=w(O);d(ra.$$.fragment,ye),ki=i(ye),eo=g(ye,"P",{"data-svelte-h":!0}),T(eo)!=="svelte-1htupoc"&&(eo.textContent=zg),qi=i(ye),d(Mt.$$.fragment,ye),Ei=i(ye),d(jt.$$.fragment,ye),ye.forEach(p),Ai=i($),_t=g($,"DIV",{class:!0});var ql=w(_t);d(ia.$$.fragment,ql),Zi=i(ql),no=g(ql,"P",{"data-svelte-h":!0}),T(no)!=="svelte-1qi4mtg"&&(no.textContent=Fg),ql.forEach(p),Ni=i($),P=g($,"DIV",{class:!0});var be=w(P);d(ca.$$.fragment,be),Wi=i(be),to=g(be,"P",{"data-svelte-h":!0}),T(to)!=="svelte-1m9sgvu"&&(to.textContent=Lg),Gi=i(be),so=g(be,"P",{"data-svelte-h":!0}),T(so)!=="svelte-1cwkych"&&(so.innerHTML=Og),Bi=i(be),d(Tt.$$.fragment,be),be.forEach(p),Qi=i($),Ye=g($,"DIV",{class:!0});var kn=w(Ye);d(pa.$$.fragment,kn),Vi=i(kn),ao=g(kn,"P",{"data-svelte-h":!0}),T(ao)!=="svelte-u63854"&&(ao.textContent=Pg),Yi=i(kn),d(It.$$.fragment,kn),kn.forEach(p),Si=i($),K=g($,"DIV",{class:!0});var Me=w(K);d(ua.$$.fragment,Me),Ri=i(Me),lo=g(Me,"P",{"data-svelte-h":!0}),T(lo)!=="svelte-k6f11e"&&(lo.textContent=Kg),Di=i(Me),d(xt.$$.fragment,Me),Xi=i(Me),d(Ct.$$.fragment,Me),Me.forEach(p),Hi=i($),ee=g($,"DIV",{class:!0});var je=w(ee);d(ga.$$.fragment,je),zi=i(je),oo=g(je,"P",{"data-svelte-h":!0}),T(oo)!=="svelte-7cx5l1"&&(oo.textContent=em),Fi=i(je),d(Ut.$$.fragment,je),Li=i(je),d(wt.$$.fragment,je),je.forEach(p),Oi=i($),ne=g($,"DIV",{class:!0});var _e=w(ne);d(ma.$$.fragment,_e),Pi=i(_e),ro=g(_e,"P",{"data-svelte-h":!0}),T(ro)!=="svelte-1tnfouk"&&(ro.textContent=nm),Ki=i(_e),io=g(_e,"P",{"data-svelte-h":!0}),T(io)!=="svelte-qrqo93"&&(io.textContent=tm),ec=i(_e),d(Jt.$$.fragment,_e),_e.forEach(p),nc=i($),Z=g($,"DIV",{class:!0});var Q=w(Z);d(ha.$$.fragment,Q),tc=i(Q),co=g(Q,"P",{"data-svelte-h":!0}),T(co)!=="svelte-71vo6e"&&(co.textContent=sm),sc=i(Q),po=g(Q,"P",{"data-svelte-h":!0}),T(po)!=="svelte-1k36r1q"&&(po.innerHTML=am),ac=i(Q),d($t.$$.fragment,Q),lc=i(Q),d(vt.$$.fragment,Q),oc=i(Q),d(kt.$$.fragment,Q),Q.forEach(p),rc=i($),te=g($,"DIV",{class:!0});var Te=w(te);d(da.$$.fragment,Te),ic=i(Te),uo=g(Te,"P",{"data-svelte-h":!0}),T(uo)!=="svelte-fzfwfh"&&(uo.textContent=lm),cc=i(Te),d(qt.$$.fragment,Te),pc=i(Te),d(Et.$$.fragment,Te),Te.forEach(p),uc=i($),At=g($,"DIV",{class:!0});var El=w(At);d(fa.$$.fragment,El),gc=i(El),go=g(El,"P",{"data-svelte-h":!0}),T(go)!=="svelte-14tnsya"&&(go.textContent=om),El.forEach(p),mc=i($),Se=g($,"DIV",{class:!0});var qn=w(Se);d(ya.$$.fragment,qn),hc=i(qn),mo=g(qn,"P",{"data-svelte-h":!0}),T(mo)!=="svelte-1mibg86"&&(mo.textContent=rm),dc=i(qn),d(Zt.$$.fragment,qn),qn.forEach(p),fc=i($),Re=g($,"DIV",{class:!0});var En=w(Re);d(ba.$$.fragment,En),yc=i(En),ho=g(En,"P",{"data-svelte-h":!0}),T(ho)!=="svelte-1nuhgbh"&&(ho.textContent=im),bc=i(En),d(Nt.$$.fragment,En),En.forEach(p),Mc=i($),De=g($,"DIV",{class:!0});var An=w(De);d(Ma.$$.fragment,An),jc=i(An),fo=g(An,"P",{"data-svelte-h":!0}),T(fo)!=="svelte-1uepm2o"&&(fo.textContent=cm),_c=i(An),d(Wt.$$.fragment,An),An.forEach(p),Tc=i($),Xe=g($,"DIV",{class:!0});var Zn=w(Xe);d(ja.$$.fragment,Zn),Ic=i(Zn),yo=g(Zn,"P",{"data-svelte-h":!0}),T(yo)!=="svelte-77a94i"&&(yo.textContent=pm),xc=i(Zn),d(Gt.$$.fragment,Zn),Zn.forEach(p),Cc=i($),He=g($,"DIV",{class:!0});var Nn=w(He);d(_a.$$.fragment,Nn),Uc=i(Nn),bo=g(Nn,"P",{"data-svelte-h":!0}),T(bo)!=="svelte-61sxmo"&&(bo.textContent=um),wc=i(Nn),d(Bt.$$.fragment,Nn),Nn.forEach(p),Jc=i($),ze=g($,"DIV",{class:!0});var Wn=w(ze);d(Ta.$$.fragment,Wn),$c=i(Wn),Mo=g(Wn,"P",{"data-svelte-h":!0}),T(Mo)!=="svelte-hzldyu"&&(Mo.textContent=gm),vc=i(Wn),d(Qt.$$.fragment,Wn),Wn.forEach(p),kc=i($),Fe=g($,"DIV",{class:!0});var Gn=w(Fe);d(Ia.$$.fragment,Gn),qc=i(Gn),jo=g(Gn,"P",{"data-svelte-h":!0}),T(jo)!=="svelte-b4yzyj"&&(jo.textContent=mm),Ec=i(Gn),d(Vt.$$.fragment,Gn),Gn.forEach(p),Ac=i($),N=g($,"DIV",{class:!0});var V=w(N);d(xa.$$.fragment,V),Zc=i(V),_o=g(V,"P",{"data-svelte-h":!0}),T(_o)!=="svelte-qakvx8"&&(_o.textContent=hm),Nc=i(V),To=g(V,"P",{"data-svelte-h":!0}),T(To)!=="svelte-1irx2op"&&(To.innerHTML=dm),Wc=i(V),Io=g(V,"P",{"data-svelte-h":!0}),T(Io)!=="svelte-140zl9b"&&(Io.innerHTML=fm),Gc=i(V),d(Yt.$$.fragment,V),Bc=i(V),d(St.$$.fragment,V),V.forEach(p),Qc=i($),se=g($,"DIV",{class:!0});var Ie=w(se);d(Ca.$$.fragment,Ie),Vc=i(Ie),xo=g(Ie,"P",{"data-svelte-h":!0}),T(xo)!=="svelte-9lmcnw"&&(xo.textContent=ym),Yc=i(Ie),d(Rt.$$.fragment,Ie),Sc=i(Ie),d(Dt.$$.fragment,Ie),Ie.forEach(p),Rc=i($),Le=g($,"DIV",{class:!0});var Bn=w(Le);d(Ua.$$.fragment,Bn),Dc=i(Bn),Co=g(Bn,"P",{"data-svelte-h":!0}),T(Co)!=="svelte-12mjzdy"&&(Co.textContent=bm),Xc=i(Bn),d(Xt.$$.fragment,Bn),Bn.forEach(p),Hc=i($),Oe=g($,"DIV",{class:!0});var Qn=w(Oe);d(wa.$$.fragment,Qn),zc=i(Qn),Uo=g(Qn,"P",{"data-svelte-h":!0}),T(Uo)!=="svelte-1araal"&&(Uo.textContent=Mm),Fc=i(Qn),d(Ht.$$.fragment,Qn),Qn.forEach(p),Lc=i($),R=g($,"DIV",{class:!0});var X=w(R);d(Ja.$$.fragment,X),Oc=i(X),wo=g(X,"P",{"data-svelte-h":!0}),T(wo)!=="svelte-1v3lqck"&&(wo.textContent=jm),Pc=i(X),Jo=g(X,"P",{"data-svelte-h":!0}),T(Jo)!=="svelte-19inetw"&&(Jo.innerHTML=_m),Kc=i(X),d(zt.$$.fragment,X),ep=i(X),d(Ft.$$.fragment,X),X.forEach(p),np=i($),Pe=g($,"DIV",{class:!0});var Vn=w(Pe);d($a.$$.fragment,Vn),tp=i(Vn),$o=g(Vn,"P",{"data-svelte-h":!0}),T($o)!=="svelte-1jbp6ey"&&($o.textContent=Tm),sp=i(Vn),d(Lt.$$.fragment,Vn),Vn.forEach(p),ap=i($),ae=g($,"DIV",{class:!0});var xe=w(ae);d(va.$$.fragment,xe),lp=i(xe),vo=g(xe,"P",{"data-svelte-h":!0}),T(vo)!=="svelte-1c9xuqj"&&(vo.textContent=Im),op=i(xe),d(Ot.$$.fragment,xe),rp=i(xe),d(Pt.$$.fragment,xe),xe.forEach(p),ip=i($),Ke=g($,"DIV",{class:!0});var Yn=w(Ke);d(ka.$$.fragment,Yn),cp=i(Yn),ko=g(Yn,"P",{"data-svelte-h":!0}),T(ko)!=="svelte-108ipf8"&&(ko.textContent=xm),pp=i(Yn),d(Kt.$$.fragment,Yn),Yn.forEach(p),$.forEach(p),Er=i(s),d(qa.$$.fragment,s),Ar=i(s),Ea=g(s,"P",{"data-svelte-h":!0}),T(Ea)!=="svelte-1vkrv9k"&&(Ea.innerHTML=Cm),Zr=i(s),d(Aa.$$.fragment,s),Nr=i(s),U=g(s,"DIV",{class:!0});var v=w(U);d(Za.$$.fragment,v),up=i(v),qo=g(v,"P",{"data-svelte-h":!0}),T(qo)!=="svelte-1p4u01l"&&(qo.textContent=Um),gp=i(v),Eo=g(v,"P",{"data-svelte-h":!0}),T(Eo)!=="svelte-1uhixc4"&&(Eo.innerHTML=wm),mp=i(v),en=g(v,"DIV",{class:!0});var Sn=w(en);d(Na.$$.fragment,Sn),hp=i(Sn),Ao=g(Sn,"P",{"data-svelte-h":!0}),T(Ao)!=="svelte-1hs5qib"&&(Ao.textContent=Jm),dp=i(Sn),d(es.$$.fragment,Sn),Sn.forEach(p),fp=i(v),nn=g(v,"DIV",{class:!0});var Rn=w(nn);d(Wa.$$.fragment,Rn),yp=i(Rn),Zo=g(Rn,"P",{"data-svelte-h":!0}),T(Zo)!=="svelte-z9e742"&&(Zo.textContent=$m),bp=i(Rn),d(ns.$$.fragment,Rn),Rn.forEach(p),Mp=i(v),tn=g(v,"DIV",{class:!0});var Dn=w(tn);d(Ga.$$.fragment,Dn),jp=i(Dn),No=g(Dn,"P",{"data-svelte-h":!0}),T(No)!=="svelte-lahnll"&&(No.textContent=vm),_p=i(Dn),d(ts.$$.fragment,Dn),Dn.forEach(p),Tp=i(v),sn=g(v,"DIV",{class:!0});var Xn=w(sn);d(Ba.$$.fragment,Xn),Ip=i(Xn),Wo=g(Xn,"P",{"data-svelte-h":!0}),T(Wo)!=="svelte-5o70yf"&&(Wo.textContent=km),xp=i(Xn),d(ss.$$.fragment,Xn),Xn.forEach(p),Cp=i(v),le=g(v,"DIV",{class:!0});var Ce=w(le);d(Qa.$$.fragment,Ce),Up=i(Ce),Go=g(Ce,"P",{"data-svelte-h":!0}),T(Go)!=="svelte-2dk21c"&&(Go.textContent=qm),wp=i(Ce),d(as.$$.fragment,Ce),Jp=i(Ce),d(ls.$$.fragment,Ce),Ce.forEach(p),$p=i(v),an=g(v,"DIV",{class:!0});var Hn=w(an);d(Va.$$.fragment,Hn),vp=i(Hn),Bo=g(Hn,"P",{"data-svelte-h":!0}),T(Bo)!=="svelte-qs8cmr"&&(Bo.textContent=Em),kp=i(Hn),d(os.$$.fragment,Hn),Hn.forEach(p),qp=i(v),ln=g(v,"DIV",{class:!0});var zn=w(ln);d(Ya.$$.fragment,zn),Ep=i(zn),Qo=g(zn,"P",{"data-svelte-h":!0}),T(Qo)!=="svelte-1axtrg9"&&(Qo.textContent=Am),Ap=i(zn),d(rs.$$.fragment,zn),zn.forEach(p),Zp=i(v),on=g(v,"DIV",{class:!0});var Fn=w(on);d(Sa.$$.fragment,Fn),Np=i(Fn),Vo=g(Fn,"P",{"data-svelte-h":!0}),T(Vo)!=="svelte-1lnjtsz"&&(Vo.textContent=Zm),Wp=i(Fn),d(is.$$.fragment,Fn),Fn.forEach(p),Gp=i(v),oe=g(v,"DIV",{class:!0});var Ue=w(oe);d(Ra.$$.fragment,Ue),Bp=i(Ue),Yo=g(Ue,"P",{"data-svelte-h":!0}),T(Yo)!=="svelte-s2la9t"&&(Yo.textContent=Nm),Qp=i(Ue),So=g(Ue,"P",{"data-svelte-h":!0}),T(So)!=="svelte-1xhka28"&&(So.innerHTML=Wm),Vp=i(Ue),d(cs.$$.fragment,Ue),Ue.forEach(p),Yp=i(v),re=g(v,"DIV",{class:!0});var we=w(re);d(Da.$$.fragment,we),Sp=i(we),Ro=g(we,"P",{"data-svelte-h":!0}),T(Ro)!=="svelte-1htupoc"&&(Ro.textContent=Gm),Rp=i(we),d(ps.$$.fragment,we),Dp=i(we),d(us.$$.fragment,we),we.forEach(p),Xp=i(v),gs=g(v,"DIV",{class:!0});var Al=w(gs);d(Xa.$$.fragment,Al),Hp=i(Al),Do=g(Al,"P",{"data-svelte-h":!0}),T(Do)!=="svelte-1qi4mtg"&&(Do.textContent=Bm),Al.forEach(p),zp=i(v),ie=g(v,"DIV",{class:!0});var Je=w(ie);d(Ha.$$.fragment,Je),Fp=i(Je),Xo=g(Je,"P",{"data-svelte-h":!0}),T(Xo)!=="svelte-1m9sgvu"&&(Xo.textContent=Qm),Lp=i(Je),Ho=g(Je,"P",{"data-svelte-h":!0}),T(Ho)!=="svelte-1cwkych"&&(Ho.innerHTML=Vm),Op=i(Je),d(ms.$$.fragment,Je),Je.forEach(p),Pp=i(v),rn=g(v,"DIV",{class:!0});var Ln=w(rn);d(za.$$.fragment,Ln),Kp=i(Ln),zo=g(Ln,"P",{"data-svelte-h":!0}),T(zo)!=="svelte-u63854"&&(zo.textContent=Ym),eu=i(Ln),d(hs.$$.fragment,Ln),Ln.forEach(p),nu=i(v),ce=g(v,"DIV",{class:!0});var $e=w(ce);d(Fa.$$.fragment,$e),tu=i($e),Fo=g($e,"P",{"data-svelte-h":!0}),T(Fo)!=="svelte-k6f11e"&&(Fo.textContent=Sm),su=i($e),d(ds.$$.fragment,$e),au=i($e),d(fs.$$.fragment,$e),$e.forEach(p),lu=i(v),pe=g(v,"DIV",{class:!0});var ve=w(pe);d(La.$$.fragment,ve),ou=i(ve),Lo=g(ve,"P",{"data-svelte-h":!0}),T(Lo)!=="svelte-7cx5l1"&&(Lo.textContent=Rm),ru=i(ve),d(ys.$$.fragment,ve),iu=i(ve),d(bs.$$.fragment,ve),ve.forEach(p),cu=i(v),ue=g(v,"DIV",{class:!0});var ke=w(ue);d(Oa.$$.fragment,ke),pu=i(ke),Oo=g(ke,"P",{"data-svelte-h":!0}),T(Oo)!=="svelte-1tnfouk"&&(Oo.textContent=Dm),uu=i(ke),Po=g(ke,"P",{"data-svelte-h":!0}),T(Po)!=="svelte-qrqo93"&&(Po.textContent=Xm),gu=i(ke),d(Ms.$$.fragment,ke),ke.forEach(p),mu=i(v),W=g(v,"DIV",{class:!0});var Y=w(W);d(Pa.$$.fragment,Y),hu=i(Y),Ko=g(Y,"P",{"data-svelte-h":!0}),T(Ko)!=="svelte-71vo6e"&&(Ko.textContent=Hm),du=i(Y),er=g(Y,"P",{"data-svelte-h":!0}),T(er)!=="svelte-1k36r1q"&&(er.innerHTML=zm),fu=i(Y),d(js.$$.fragment,Y),yu=i(Y),d(_s.$$.fragment,Y),bu=i(Y),d(Ts.$$.fragment,Y),Y.forEach(p),Mu=i(v),ge=g(v,"DIV",{class:!0});var qe=w(ge);d(Ka.$$.fragment,qe),ju=i(qe),nr=g(qe,"P",{"data-svelte-h":!0}),T(nr)!=="svelte-fzfwfh"&&(nr.textContent=Fm),_u=i(qe),d(Is.$$.fragment,qe),Tu=i(qe),d(xs.$$.fragment,qe),qe.forEach(p),Iu=i(v),Cs=g(v,"DIV",{class:!0});var Zl=w(Cs);d(el.$$.fragment,Zl),xu=i(Zl),tr=g(Zl,"P",{"data-svelte-h":!0}),T(tr)!=="svelte-14tnsya"&&(tr.textContent=Lm),Zl.forEach(p),Cu=i(v),cn=g(v,"DIV",{class:!0});var On=w(cn);d(nl.$$.fragment,On),Uu=i(On),sr=g(On,"P",{"data-svelte-h":!0}),T(sr)!=="svelte-1mibg86"&&(sr.textContent=Om),wu=i(On),d(Us.$$.fragment,On),On.forEach(p),Ju=i(v),pn=g(v,"DIV",{class:!0});var Pn=w(pn);d(tl.$$.fragment,Pn),$u=i(Pn),ar=g(Pn,"P",{"data-svelte-h":!0}),T(ar)!=="svelte-1nuhgbh"&&(ar.textContent=Pm),vu=i(Pn),d(ws.$$.fragment,Pn),Pn.forEach(p),ku=i(v),un=g(v,"DIV",{class:!0});var Kn=w(un);d(sl.$$.fragment,Kn),qu=i(Kn),lr=g(Kn,"P",{"data-svelte-h":!0}),T(lr)!=="svelte-1uepm2o"&&(lr.textContent=Km),Eu=i(Kn),d(Js.$$.fragment,Kn),Kn.forEach(p),Au=i(v),gn=g(v,"DIV",{class:!0});var et=w(gn);d(al.$$.fragment,et),Zu=i(et),or=g(et,"P",{"data-svelte-h":!0}),T(or)!=="svelte-77a94i"&&(or.textContent=eh),Nu=i(et),d($s.$$.fragment,et),et.forEach(p),Wu=i(v),mn=g(v,"DIV",{class:!0});var nt=w(mn);d(ll.$$.fragment,nt),Gu=i(nt),rr=g(nt,"P",{"data-svelte-h":!0}),T(rr)!=="svelte-61sxmo"&&(rr.textContent=nh),Bu=i(nt),d(vs.$$.fragment,nt),nt.forEach(p),Qu=i(v),hn=g(v,"DIV",{class:!0});var tt=w(hn);d(ol.$$.fragment,tt),Vu=i(tt),ir=g(tt,"P",{"data-svelte-h":!0}),T(ir)!=="svelte-hzldyu"&&(ir.textContent=th),Yu=i(tt),d(ks.$$.fragment,tt),tt.forEach(p),Su=i(v),dn=g(v,"DIV",{class:!0});var st=w(dn);d(rl.$$.fragment,st),Ru=i(st),cr=g(st,"P",{"data-svelte-h":!0}),T(cr)!=="svelte-b4yzyj"&&(cr.textContent=sh),Du=i(st),d(qs.$$.fragment,st),st.forEach(p),Xu=i(v),G=g(v,"DIV",{class:!0});var S=w(G);d(il.$$.fragment,S),Hu=i(S),pr=g(S,"P",{"data-svelte-h":!0}),T(pr)!=="svelte-qakvx8"&&(pr.textContent=ah),zu=i(S),ur=g(S,"P",{"data-svelte-h":!0}),T(ur)!=="svelte-1irx2op"&&(ur.innerHTML=lh),Fu=i(S),gr=g(S,"P",{"data-svelte-h":!0}),T(gr)!=="svelte-140zl9b"&&(gr.innerHTML=oh),Lu=i(S),d(Es.$$.fragment,S),Ou=i(S),d(As.$$.fragment,S),S.forEach(p),Pu=i(v),me=g(v,"DIV",{class:!0});var Ee=w(me);d(cl.$$.fragment,Ee),Ku=i(Ee),mr=g(Ee,"P",{"data-svelte-h":!0}),T(mr)!=="svelte-9lmcnw"&&(mr.textContent=rh),eg=i(Ee),d(Zs.$$.fragment,Ee),ng=i(Ee),d(Ns.$$.fragment,Ee),Ee.forEach(p),tg=i(v),fn=g(v,"DIV",{class:!0});var at=w(fn);d(pl.$$.fragment,at),sg=i(at),hr=g(at,"P",{"data-svelte-h":!0}),T(hr)!=="svelte-12mjzdy"&&(hr.textContent=ih),ag=i(at),d(Ws.$$.fragment,at),at.forEach(p),lg=i(v),yn=g(v,"DIV",{class:!0});var lt=w(yn);d(ul.$$.fragment,lt),og=i(lt),dr=g(lt,"P",{"data-svelte-h":!0}),T(dr)!=="svelte-1araal"&&(dr.textContent=ch),rg=i(lt),d(Gs.$$.fragment,lt),lt.forEach(p),ig=i(v),D=g(v,"DIV",{class:!0});var H=w(D);d(gl.$$.fragment,H),cg=i(H),fr=g(H,"P",{"data-svelte-h":!0}),T(fr)!=="svelte-1v3lqck"&&(fr.textContent=ph),pg=i(H),yr=g(H,"P",{"data-svelte-h":!0}),T(yr)!=="svelte-19inetw"&&(yr.innerHTML=uh),ug=i(H),d(Bs.$$.fragment,H),gg=i(H),d(Qs.$$.fragment,H),H.forEach(p),mg=i(v),bn=g(v,"DIV",{class:!0});var ot=w(bn);d(ml.$$.fragment,ot),hg=i(ot),br=g(ot,"P",{"data-svelte-h":!0}),T(br)!=="svelte-1jbp6ey"&&(br.textContent=gh),dg=i(ot),d(Vs.$$.fragment,ot),ot.forEach(p),fg=i(v),he=g(v,"DIV",{class:!0});var Ae=w(he);d(hl.$$.fragment,Ae),yg=i(Ae),Mr=g(Ae,"P",{"data-svelte-h":!0}),T(Mr)!=="svelte-1c9xuqj"&&(Mr.textContent=mh),bg=i(Ae),d(Ys.$$.fragment,Ae),Mg=i(Ae),d(Ss.$$.fragment,Ae),Ae.forEach(p),jg=i(v),Mn=g(v,"DIV",{class:!0});var rt=w(Mn);d(dl.$$.fragment,rt),_g=i(rt),jr=g(rt,"P",{"data-svelte-h":!0}),T(jr)!=="svelte-108ipf8"&&(jr.textContent=hh),Tg=i(rt),d(Rs.$$.fragment,rt),rt.forEach(p),v.forEach(p),Wr=i(s),d(fl.$$.fragment,s),Gr=i(s),jn=g(s,"DIV",{class:!0});var Nl=w(jn);d(yl.$$.fragment,Nl),Ig=i(Nl),_r=g(Nl,"P",{"data-svelte-h":!0}),T(_r)!=="svelte-2793d9"&&(_r.textContent=dh),Nl.forEach(p),Br=i(s),d(bl.$$.fragment,s),Qr=i(s),Ml=g(s,"P",{"data-svelte-h":!0}),T(Ml)!=="svelte-1lzrumh"&&(Ml.textContent=fh),Vr=i(s),d(jl.$$.fragment,s),Yr=i(s),_n=g(s,"DIV",{class:!0});var Wl=w(_n);d(_l.$$.fragment,Wl),xg=i(Wl),Tr=g(Wl,"P",{"data-svelte-h":!0}),T(Tr)!=="svelte-1llkiu4"&&(Tr.innerHTML=yh),Wl.forEach(p),Sr=i(s),d(Tl.$$.fragment,s),Rr=i(s),Tn=g(s,"DIV",{class:!0});var Gl=w(Tn);d(Il.$$.fragment,Gl),Cg=i(Gl),Ir=g(Gl,"P",{"data-svelte-h":!0}),T(Ir)!=="svelte-eg1ixw"&&(Ir.innerHTML=bh),Gl.forEach(p),Dr=i(s),d(xl.$$.fragment,s),Xr=i(s),In=g(s,"DIV",{class:!0});var Bl=w(In);d(Cl.$$.fragment,Bl),Ug=i(Bl),xr=g(Bl,"P",{"data-svelte-h":!0}),T(xr)!=="svelte-18ffdgx"&&(xr.textContent=Mh),Bl.forEach(p),Hr=i(s),d(Ul.$$.fragment,s),zr=i(s),wl=g(s,"P",{"data-svelte-h":!0}),T(wl)!=="svelte-1f4wgoq"&&(wl.innerHTML=jh),Fr=i(s),B=g(s,"DIV",{class:!0});var z=w(B);d(Jl.$$.fragment,z),wg=i(z),Cr=g(z,"P",{"data-svelte-h":!0}),T(Cr)!=="svelte-xkrgz1"&&(Cr.textContent=_h),Jg=i(z),d(Ds.$$.fragment,z),$g=i(z),Xs=g(z,"DIV",{class:!0});var Ql=w(Xs);d($l.$$.fragment,Ql),vg=i(Ql),Ur=g(Ql,"P",{"data-svelte-h":!0}),T(Ur)!=="svelte-1ruvvxs"&&(Ur.textContent=Th),Ql.forEach(p),kg=i(z),Hs=g(z,"DIV",{class:!0});var Vl=w(Hs);d(vl.$$.fragment,Vl),qg=i(Vl),wr=g(Vl,"P",{"data-svelte-h":!0}),T(wr)!=="svelte-ss15d2"&&(wr.textContent=Ih),Vl.forEach(p),z.forEach(p),Lr=i(s),d(kl.$$.fragment,s),Or=i(s),Jr=g(s,"P",{}),w(Jr).forEach(p),this.h()},h(){J(n,"name","hf:doc:metadata"),J(n,"content",_f),J(Ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(We,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(_t,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(At,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(De,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(He,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(en,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(nn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(tn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(sn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(an,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(ln,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(on,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(gs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(rn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Cs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(cn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(pn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(un,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(gn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(mn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(hn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(dn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(fn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(yn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(bn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Mn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(jn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(_n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Tn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(In,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Xs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Hs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(s,j){l(document.head,n),_(s,m,j),_(s,a,j),_(s,t,j),f(o,s,j),_(s,e,j),_(s,c,j),_(s,$r,j),_(s,zs,j),_(s,vr,j),_(s,Fs,j),_(s,kr,j),f(Ls,s,j),_(s,qr,j),_(s,C,j),f(Os,C,null),l(C,Kr),l(C,Yl),l(C,ei),l(C,Sl),l(C,ni),l(C,Ze),f(Ps,Ze,null),l(Ze,ti),l(Ze,Rl),l(Ze,si),f(ct,Ze,null),l(C,ai),l(C,Ne),f(Ks,Ne,null),l(Ne,li),l(Ne,Dl),l(Ne,oi),f(pt,Ne,null),l(C,ri),l(C,We),f(ea,We,null),l(We,ii),l(We,Xl),l(We,ci),f(ut,We,null),l(C,pi),l(C,Ge),f(na,Ge,null),l(Ge,ui),l(Ge,Hl),l(Ge,gi),f(gt,Ge,null),l(C,mi),l(C,F),f(ta,F,null),l(F,hi),l(F,zl),l(F,di),f(mt,F,null),l(F,fi),f(ht,F,null),l(C,yi),l(C,Be),f(sa,Be,null),l(Be,bi),l(Be,Fl),l(Be,Mi),f(dt,Be,null),l(C,ji),l(C,Qe),f(aa,Qe,null),l(Qe,_i),l(Qe,Ll),l(Qe,Ti),f(ft,Qe,null),l(C,Ii),l(C,Ve),f(la,Ve,null),l(Ve,xi),l(Ve,Ol),l(Ve,Ci),f(yt,Ve,null),l(C,Ui),l(C,L),f(oa,L,null),l(L,wi),l(L,Pl),l(L,Ji),l(L,Kl),l(L,$i),f(bt,L,null),l(C,vi),l(C,O),f(ra,O,null),l(O,ki),l(O,eo),l(O,qi),f(Mt,O,null),l(O,Ei),f(jt,O,null),l(C,Ai),l(C,_t),f(ia,_t,null),l(_t,Zi),l(_t,no),l(C,Ni),l(C,P),f(ca,P,null),l(P,Wi),l(P,to),l(P,Gi),l(P,so),l(P,Bi),f(Tt,P,null),l(C,Qi),l(C,Ye),f(pa,Ye,null),l(Ye,Vi),l(Ye,ao),l(Ye,Yi),f(It,Ye,null),l(C,Si),l(C,K),f(ua,K,null),l(K,Ri),l(K,lo),l(K,Di),f(xt,K,null),l(K,Xi),f(Ct,K,null),l(C,Hi),l(C,ee),f(ga,ee,null),l(ee,zi),l(ee,oo),l(ee,Fi),f(Ut,ee,null),l(ee,Li),f(wt,ee,null),l(C,Oi),l(C,ne),f(ma,ne,null),l(ne,Pi),l(ne,ro),l(ne,Ki),l(ne,io),l(ne,ec),f(Jt,ne,null),l(C,nc),l(C,Z),f(ha,Z,null),l(Z,tc),l(Z,co),l(Z,sc),l(Z,po),l(Z,ac),f($t,Z,null),l(Z,lc),f(vt,Z,null),l(Z,oc),f(kt,Z,null),l(C,rc),l(C,te),f(da,te,null),l(te,ic),l(te,uo),l(te,cc),f(qt,te,null),l(te,pc),f(Et,te,null),l(C,uc),l(C,At),f(fa,At,null),l(At,gc),l(At,go),l(C,mc),l(C,Se),f(ya,Se,null),l(Se,hc),l(Se,mo),l(Se,dc),f(Zt,Se,null),l(C,fc),l(C,Re),f(ba,Re,null),l(Re,yc),l(Re,ho),l(Re,bc),f(Nt,Re,null),l(C,Mc),l(C,De),f(Ma,De,null),l(De,jc),l(De,fo),l(De,_c),f(Wt,De,null),l(C,Tc),l(C,Xe),f(ja,Xe,null),l(Xe,Ic),l(Xe,yo),l(Xe,xc),f(Gt,Xe,null),l(C,Cc),l(C,He),f(_a,He,null),l(He,Uc),l(He,bo),l(He,wc),f(Bt,He,null),l(C,Jc),l(C,ze),f(Ta,ze,null),l(ze,$c),l(ze,Mo),l(ze,vc),f(Qt,ze,null),l(C,kc),l(C,Fe),f(Ia,Fe,null),l(Fe,qc),l(Fe,jo),l(Fe,Ec),f(Vt,Fe,null),l(C,Ac),l(C,N),f(xa,N,null),l(N,Zc),l(N,_o),l(N,Nc),l(N,To),l(N,Wc),l(N,Io),l(N,Gc),f(Yt,N,null),l(N,Bc),f(St,N,null),l(C,Qc),l(C,se),f(Ca,se,null),l(se,Vc),l(se,xo),l(se,Yc),f(Rt,se,null),l(se,Sc),f(Dt,se,null),l(C,Rc),l(C,Le),f(Ua,Le,null),l(Le,Dc),l(Le,Co),l(Le,Xc),f(Xt,Le,null),l(C,Hc),l(C,Oe),f(wa,Oe,null),l(Oe,zc),l(Oe,Uo),l(Oe,Fc),f(Ht,Oe,null),l(C,Lc),l(C,R),f(Ja,R,null),l(R,Oc),l(R,wo),l(R,Pc),l(R,Jo),l(R,Kc),f(zt,R,null),l(R,ep),f(Ft,R,null),l(C,np),l(C,Pe),f($a,Pe,null),l(Pe,tp),l(Pe,$o),l(Pe,sp),f(Lt,Pe,null),l(C,ap),l(C,ae),f(va,ae,null),l(ae,lp),l(ae,vo),l(ae,op),f(Ot,ae,null),l(ae,rp),f(Pt,ae,null),l(C,ip),l(C,Ke),f(ka,Ke,null),l(Ke,cp),l(Ke,ko),l(Ke,pp),f(Kt,Ke,null),_(s,Er,j),f(qa,s,j),_(s,Ar,j),_(s,Ea,j),_(s,Zr,j),f(Aa,s,j),_(s,Nr,j),_(s,U,j),f(Za,U,null),l(U,up),l(U,qo),l(U,gp),l(U,Eo),l(U,mp),l(U,en),f(Na,en,null),l(en,hp),l(en,Ao),l(en,dp),f(es,en,null),l(U,fp),l(U,nn),f(Wa,nn,null),l(nn,yp),l(nn,Zo),l(nn,bp),f(ns,nn,null),l(U,Mp),l(U,tn),f(Ga,tn,null),l(tn,jp),l(tn,No),l(tn,_p),f(ts,tn,null),l(U,Tp),l(U,sn),f(Ba,sn,null),l(sn,Ip),l(sn,Wo),l(sn,xp),f(ss,sn,null),l(U,Cp),l(U,le),f(Qa,le,null),l(le,Up),l(le,Go),l(le,wp),f(as,le,null),l(le,Jp),f(ls,le,null),l(U,$p),l(U,an),f(Va,an,null),l(an,vp),l(an,Bo),l(an,kp),f(os,an,null),l(U,qp),l(U,ln),f(Ya,ln,null),l(ln,Ep),l(ln,Qo),l(ln,Ap),f(rs,ln,null),l(U,Zp),l(U,on),f(Sa,on,null),l(on,Np),l(on,Vo),l(on,Wp),f(is,on,null),l(U,Gp),l(U,oe),f(Ra,oe,null),l(oe,Bp),l(oe,Yo),l(oe,Qp),l(oe,So),l(oe,Vp),f(cs,oe,null),l(U,Yp),l(U,re),f(Da,re,null),l(re,Sp),l(re,Ro),l(re,Rp),f(ps,re,null),l(re,Dp),f(us,re,null),l(U,Xp),l(U,gs),f(Xa,gs,null),l(gs,Hp),l(gs,Do),l(U,zp),l(U,ie),f(Ha,ie,null),l(ie,Fp),l(ie,Xo),l(ie,Lp),l(ie,Ho),l(ie,Op),f(ms,ie,null),l(U,Pp),l(U,rn),f(za,rn,null),l(rn,Kp),l(rn,zo),l(rn,eu),f(hs,rn,null),l(U,nu),l(U,ce),f(Fa,ce,null),l(ce,tu),l(ce,Fo),l(ce,su),f(ds,ce,null),l(ce,au),f(fs,ce,null),l(U,lu),l(U,pe),f(La,pe,null),l(pe,ou),l(pe,Lo),l(pe,ru),f(ys,pe,null),l(pe,iu),f(bs,pe,null),l(U,cu),l(U,ue),f(Oa,ue,null),l(ue,pu),l(ue,Oo),l(ue,uu),l(ue,Po),l(ue,gu),f(Ms,ue,null),l(U,mu),l(U,W),f(Pa,W,null),l(W,hu),l(W,Ko),l(W,du),l(W,er),l(W,fu),f(js,W,null),l(W,yu),f(_s,W,null),l(W,bu),f(Ts,W,null),l(U,Mu),l(U,ge),f(Ka,ge,null),l(ge,ju),l(ge,nr),l(ge,_u),f(Is,ge,null),l(ge,Tu),f(xs,ge,null),l(U,Iu),l(U,Cs),f(el,Cs,null),l(Cs,xu),l(Cs,tr),l(U,Cu),l(U,cn),f(nl,cn,null),l(cn,Uu),l(cn,sr),l(cn,wu),f(Us,cn,null),l(U,Ju),l(U,pn),f(tl,pn,null),l(pn,$u),l(pn,ar),l(pn,vu),f(ws,pn,null),l(U,ku),l(U,un),f(sl,un,null),l(un,qu),l(un,lr),l(un,Eu),f(Js,un,null),l(U,Au),l(U,gn),f(al,gn,null),l(gn,Zu),l(gn,or),l(gn,Nu),f($s,gn,null),l(U,Wu),l(U,mn),f(ll,mn,null),l(mn,Gu),l(mn,rr),l(mn,Bu),f(vs,mn,null),l(U,Qu),l(U,hn),f(ol,hn,null),l(hn,Vu),l(hn,ir),l(hn,Yu),f(ks,hn,null),l(U,Su),l(U,dn),f(rl,dn,null),l(dn,Ru),l(dn,cr),l(dn,Du),f(qs,dn,null),l(U,Xu),l(U,G),f(il,G,null),l(G,Hu),l(G,pr),l(G,zu),l(G,ur),l(G,Fu),l(G,gr),l(G,Lu),f(Es,G,null),l(G,Ou),f(As,G,null),l(U,Pu),l(U,me),f(cl,me,null),l(me,Ku),l(me,mr),l(me,eg),f(Zs,me,null),l(me,ng),f(Ns,me,null),l(U,tg),l(U,fn),f(pl,fn,null),l(fn,sg),l(fn,hr),l(fn,ag),f(Ws,fn,null),l(U,lg),l(U,yn),f(ul,yn,null),l(yn,og),l(yn,dr),l(yn,rg),f(Gs,yn,null),l(U,ig),l(U,D),f(gl,D,null),l(D,cg),l(D,fr),l(D,pg),l(D,yr),l(D,ug),f(Bs,D,null),l(D,gg),f(Qs,D,null),l(U,mg),l(U,bn),f(ml,bn,null),l(bn,hg),l(bn,br),l(bn,dg),f(Vs,bn,null),l(U,fg),l(U,he),f(hl,he,null),l(he,yg),l(he,Mr),l(he,bg),f(Ys,he,null),l(he,Mg),f(Ss,he,null),l(U,jg),l(U,Mn),f(dl,Mn,null),l(Mn,_g),l(Mn,jr),l(Mn,Tg),f(Rs,Mn,null),_(s,Wr,j),f(fl,s,j),_(s,Gr,j),_(s,jn,j),f(yl,jn,null),l(jn,Ig),l(jn,_r),_(s,Br,j),f(bl,s,j),_(s,Qr,j),_(s,Ml,j),_(s,Vr,j),f(jl,s,j),_(s,Yr,j),_(s,_n,j),f(_l,_n,null),l(_n,xg),l(_n,Tr),_(s,Sr,j),f(Tl,s,j),_(s,Rr,j),_(s,Tn,j),f(Il,Tn,null),l(Tn,Cg),l(Tn,Ir),_(s,Dr,j),f(xl,s,j),_(s,Xr,j),_(s,In,j),f(Cl,In,null),l(In,Ug),l(In,xr),_(s,Hr,j),f(Ul,s,j),_(s,zr,j),_(s,wl,j),_(s,Fr,j),_(s,B,j),f(Jl,B,null),l(B,wg),l(B,Cr),l(B,Jg),f(Ds,B,null),l(B,$g),l(B,Xs),f($l,Xs,null),l(Xs,vg),l(Xs,Ur),l(B,kg),l(B,Hs),f(vl,Hs,null),l(Hs,qg),l(Hs,wr),_(s,Lr,j),f(kl,s,j),_(s,Or,j),_(s,Jr,j),Pr=!0},p(s,[j]){const $={};j&2&&($.$$scope={dirty:j,ctx:s}),ct.$set($);const xn={};j&2&&(xn.$$scope={dirty:j,ctx:s}),pt.$set(xn);const Cn={};j&2&&(Cn.$$scope={dirty:j,ctx:s}),ut.$set(Cn);const Un={};j&2&&(Un.$$scope={dirty:j,ctx:s}),gt.$set(Un);const wn={};j&2&&(wn.$$scope={dirty:j,ctx:s}),mt.$set(wn);const de={};j&2&&(de.$$scope={dirty:j,ctx:s}),ht.$set(de);const Jn={};j&2&&(Jn.$$scope={dirty:j,ctx:s}),dt.$set(Jn);const $n={};j&2&&($n.$$scope={dirty:j,ctx:s}),ft.$set($n);const vn={};j&2&&(vn.$$scope={dirty:j,ctx:s}),yt.$set(vn);const fe={};j&2&&(fe.$$scope={dirty:j,ctx:s}),bt.$set(fe);const ye={};j&2&&(ye.$$scope={dirty:j,ctx:s}),Mt.$set(ye);const ql={};j&2&&(ql.$$scope={dirty:j,ctx:s}),jt.$set(ql);const be={};j&2&&(be.$$scope={dirty:j,ctx:s}),Tt.$set(be);const kn={};j&2&&(kn.$$scope={dirty:j,ctx:s}),It.$set(kn);const Me={};j&2&&(Me.$$scope={dirty:j,ctx:s}),xt.$set(Me);const je={};j&2&&(je.$$scope={dirty:j,ctx:s}),Ct.$set(je);const _e={};j&2&&(_e.$$scope={dirty:j,ctx:s}),Ut.$set(_e);const Q={};j&2&&(Q.$$scope={dirty:j,ctx:s}),wt.$set(Q);const Te={};j&2&&(Te.$$scope={dirty:j,ctx:s}),Jt.$set(Te);const El={};j&2&&(El.$$scope={dirty:j,ctx:s}),$t.$set(El);const qn={};j&2&&(qn.$$scope={dirty:j,ctx:s}),vt.$set(qn);const En={};j&2&&(En.$$scope={dirty:j,ctx:s}),kt.$set(En);const An={};j&2&&(An.$$scope={dirty:j,ctx:s}),qt.$set(An);const Zn={};j&2&&(Zn.$$scope={dirty:j,ctx:s}),Et.$set(Zn);const Nn={};j&2&&(Nn.$$scope={dirty:j,ctx:s}),Zt.$set(Nn);const Wn={};j&2&&(Wn.$$scope={dirty:j,ctx:s}),Nt.$set(Wn);const Gn={};j&2&&(Gn.$$scope={dirty:j,ctx:s}),Wt.$set(Gn);const V={};j&2&&(V.$$scope={dirty:j,ctx:s}),Gt.$set(V);const Ie={};j&2&&(Ie.$$scope={dirty:j,ctx:s}),Bt.$set(Ie);const Bn={};j&2&&(Bn.$$scope={dirty:j,ctx:s}),Qt.$set(Bn);const Qn={};j&2&&(Qn.$$scope={dirty:j,ctx:s}),Vt.$set(Qn);const X={};j&2&&(X.$$scope={dirty:j,ctx:s}),Yt.$set(X);const Vn={};j&2&&(Vn.$$scope={dirty:j,ctx:s}),St.$set(Vn);const xe={};j&2&&(xe.$$scope={dirty:j,ctx:s}),Rt.$set(xe);const Yn={};j&2&&(Yn.$$scope={dirty:j,ctx:s}),Dt.$set(Yn);const v={};j&2&&(v.$$scope={dirty:j,ctx:s}),Xt.$set(v);const Sn={};j&2&&(Sn.$$scope={dirty:j,ctx:s}),Ht.$set(Sn);const Rn={};j&2&&(Rn.$$scope={dirty:j,ctx:s}),zt.$set(Rn);const Dn={};j&2&&(Dn.$$scope={dirty:j,ctx:s}),Ft.$set(Dn);const Xn={};j&2&&(Xn.$$scope={dirty:j,ctx:s}),Lt.$set(Xn);const Ce={};j&2&&(Ce.$$scope={dirty:j,ctx:s}),Ot.$set(Ce);const Hn={};j&2&&(Hn.$$scope={dirty:j,ctx:s}),Pt.$set(Hn);const zn={};j&2&&(zn.$$scope={dirty:j,ctx:s}),Kt.$set(zn);const Fn={};j&2&&(Fn.$$scope={dirty:j,ctx:s}),es.$set(Fn);const Ue={};j&2&&(Ue.$$scope={dirty:j,ctx:s}),ns.$set(Ue);const we={};j&2&&(we.$$scope={dirty:j,ctx:s}),ts.$set(we);const Al={};j&2&&(Al.$$scope={dirty:j,ctx:s}),ss.$set(Al);const Je={};j&2&&(Je.$$scope={dirty:j,ctx:s}),as.$set(Je);const Ln={};j&2&&(Ln.$$scope={dirty:j,ctx:s}),ls.$set(Ln);const $e={};j&2&&($e.$$scope={dirty:j,ctx:s}),os.$set($e);const ve={};j&2&&(ve.$$scope={dirty:j,ctx:s}),rs.$set(ve);const ke={};j&2&&(ke.$$scope={dirty:j,ctx:s}),is.$set(ke);const Y={};j&2&&(Y.$$scope={dirty:j,ctx:s}),cs.$set(Y);const qe={};j&2&&(qe.$$scope={dirty:j,ctx:s}),ps.$set(qe);const Zl={};j&2&&(Zl.$$scope={dirty:j,ctx:s}),us.$set(Zl);const On={};j&2&&(On.$$scope={dirty:j,ctx:s}),ms.$set(On);const Pn={};j&2&&(Pn.$$scope={dirty:j,ctx:s}),hs.$set(Pn);const Kn={};j&2&&(Kn.$$scope={dirty:j,ctx:s}),ds.$set(Kn);const et={};j&2&&(et.$$scope={dirty:j,ctx:s}),fs.$set(et);const nt={};j&2&&(nt.$$scope={dirty:j,ctx:s}),ys.$set(nt);const tt={};j&2&&(tt.$$scope={dirty:j,ctx:s}),bs.$set(tt);const st={};j&2&&(st.$$scope={dirty:j,ctx:s}),Ms.$set(st);const S={};j&2&&(S.$$scope={dirty:j,ctx:s}),js.$set(S);const Ee={};j&2&&(Ee.$$scope={dirty:j,ctx:s}),_s.$set(Ee);const at={};j&2&&(at.$$scope={dirty:j,ctx:s}),Ts.$set(at);const lt={};j&2&&(lt.$$scope={dirty:j,ctx:s}),Is.$set(lt);const H={};j&2&&(H.$$scope={dirty:j,ctx:s}),xs.$set(H);const ot={};j&2&&(ot.$$scope={dirty:j,ctx:s}),Us.$set(ot);const Ae={};j&2&&(Ae.$$scope={dirty:j,ctx:s}),ws.$set(Ae);const rt={};j&2&&(rt.$$scope={dirty:j,ctx:s}),Js.$set(rt);const Nl={};j&2&&(Nl.$$scope={dirty:j,ctx:s}),$s.$set(Nl);const Wl={};j&2&&(Wl.$$scope={dirty:j,ctx:s}),vs.$set(Wl);const Gl={};j&2&&(Gl.$$scope={dirty:j,ctx:s}),ks.$set(Gl);const Bl={};j&2&&(Bl.$$scope={dirty:j,ctx:s}),qs.$set(Bl);const z={};j&2&&(z.$$scope={dirty:j,ctx:s}),Es.$set(z);const Ql={};j&2&&(Ql.$$scope={dirty:j,ctx:s}),As.$set(Ql);const Vl={};j&2&&(Vl.$$scope={dirty:j,ctx:s}),Zs.$set(Vl);const xh={};j&2&&(xh.$$scope={dirty:j,ctx:s}),Ns.$set(xh);const Ch={};j&2&&(Ch.$$scope={dirty:j,ctx:s}),Ws.$set(Ch);const Uh={};j&2&&(Uh.$$scope={dirty:j,ctx:s}),Gs.$set(Uh);const wh={};j&2&&(wh.$$scope={dirty:j,ctx:s}),Bs.$set(wh);const Jh={};j&2&&(Jh.$$scope={dirty:j,ctx:s}),Qs.$set(Jh);const $h={};j&2&&($h.$$scope={dirty:j,ctx:s}),Vs.$set($h);const vh={};j&2&&(vh.$$scope={dirty:j,ctx:s}),Ys.$set(vh);const kh={};j&2&&(kh.$$scope={dirty:j,ctx:s}),Ss.$set(kh);const qh={};j&2&&(qh.$$scope={dirty:j,ctx:s}),Rs.$set(qh);const Eh={};j&2&&(Eh.$$scope={dirty:j,ctx:s}),Ds.$set(Eh)},i(s){Pr||(y(o.$$.fragment,s),y(Ls.$$.fragment,s),y(Os.$$.fragment,s),y(Ps.$$.fragment,s),y(ct.$$.fragment,s),y(Ks.$$.fragment,s),y(pt.$$.fragment,s),y(ea.$$.fragment,s),y(ut.$$.fragment,s),y(na.$$.fragment,s),y(gt.$$.fragment,s),y(ta.$$.fragment,s),y(mt.$$.fragment,s),y(ht.$$.fragment,s),y(sa.$$.fragment,s),y(dt.$$.fragment,s),y(aa.$$.fragment,s),y(ft.$$.fragment,s),y(la.$$.fragment,s),y(yt.$$.fragment,s),y(oa.$$.fragment,s),y(bt.$$.fragment,s),y(ra.$$.fragment,s),y(Mt.$$.fragment,s),y(jt.$$.fragment,s),y(ia.$$.fragment,s),y(ca.$$.fragment,s),y(Tt.$$.fragment,s),y(pa.$$.fragment,s),y(It.$$.fragment,s),y(ua.$$.fragment,s),y(xt.$$.fragment,s),y(Ct.$$.fragment,s),y(ga.$$.fragment,s),y(Ut.$$.fragment,s),y(wt.$$.fragment,s),y(ma.$$.fragment,s),y(Jt.$$.fragment,s),y(ha.$$.fragment,s),y($t.$$.fragment,s),y(vt.$$.fragment,s),y(kt.$$.fragment,s),y(da.$$.fragment,s),y(qt.$$.fragment,s),y(Et.$$.fragment,s),y(fa.$$.fragment,s),y(ya.$$.fragment,s),y(Zt.$$.fragment,s),y(ba.$$.fragment,s),y(Nt.$$.fragment,s),y(Ma.$$.fragment,s),y(Wt.$$.fragment,s),y(ja.$$.fragment,s),y(Gt.$$.fragment,s),y(_a.$$.fragment,s),y(Bt.$$.fragment,s),y(Ta.$$.fragment,s),y(Qt.$$.fragment,s),y(Ia.$$.fragment,s),y(Vt.$$.fragment,s),y(xa.$$.fragment,s),y(Yt.$$.fragment,s),y(St.$$.fragment,s),y(Ca.$$.fragment,s),y(Rt.$$.fragment,s),y(Dt.$$.fragment,s),y(Ua.$$.fragment,s),y(Xt.$$.fragment,s),y(wa.$$.fragment,s),y(Ht.$$.fragment,s),y(Ja.$$.fragment,s),y(zt.$$.fragment,s),y(Ft.$$.fragment,s),y($a.$$.fragment,s),y(Lt.$$.fragment,s),y(va.$$.fragment,s),y(Ot.$$.fragment,s),y(Pt.$$.fragment,s),y(ka.$$.fragment,s),y(Kt.$$.fragment,s),y(qa.$$.fragment,s),y(Aa.$$.fragment,s),y(Za.$$.fragment,s),y(Na.$$.fragment,s),y(es.$$.fragment,s),y(Wa.$$.fragment,s),y(ns.$$.fragment,s),y(Ga.$$.fragment,s),y(ts.$$.fragment,s),y(Ba.$$.fragment,s),y(ss.$$.fragment,s),y(Qa.$$.fragment,s),y(as.$$.fragment,s),y(ls.$$.fragment,s),y(Va.$$.fragment,s),y(os.$$.fragment,s),y(Ya.$$.fragment,s),y(rs.$$.fragment,s),y(Sa.$$.fragment,s),y(is.$$.fragment,s),y(Ra.$$.fragment,s),y(cs.$$.fragment,s),y(Da.$$.fragment,s),y(ps.$$.fragment,s),y(us.$$.fragment,s),y(Xa.$$.fragment,s),y(Ha.$$.fragment,s),y(ms.$$.fragment,s),y(za.$$.fragment,s),y(hs.$$.fragment,s),y(Fa.$$.fragment,s),y(ds.$$.fragment,s),y(fs.$$.fragment,s),y(La.$$.fragment,s),y(ys.$$.fragment,s),y(bs.$$.fragment,s),y(Oa.$$.fragment,s),y(Ms.$$.fragment,s),y(Pa.$$.fragment,s),y(js.$$.fragment,s),y(_s.$$.fragment,s),y(Ts.$$.fragment,s),y(Ka.$$.fragment,s),y(Is.$$.fragment,s),y(xs.$$.fragment,s),y(el.$$.fragment,s),y(nl.$$.fragment,s),y(Us.$$.fragment,s),y(tl.$$.fragment,s),y(ws.$$.fragment,s),y(sl.$$.fragment,s),y(Js.$$.fragment,s),y(al.$$.fragment,s),y($s.$$.fragment,s),y(ll.$$.fragment,s),y(vs.$$.fragment,s),y(ol.$$.fragment,s),y(ks.$$.fragment,s),y(rl.$$.fragment,s),y(qs.$$.fragment,s),y(il.$$.fragment,s),y(Es.$$.fragment,s),y(As.$$.fragment,s),y(cl.$$.fragment,s),y(Zs.$$.fragment,s),y(Ns.$$.fragment,s),y(pl.$$.fragment,s),y(Ws.$$.fragment,s),y(ul.$$.fragment,s),y(Gs.$$.fragment,s),y(gl.$$.fragment,s),y(Bs.$$.fragment,s),y(Qs.$$.fragment,s),y(ml.$$.fragment,s),y(Vs.$$.fragment,s),y(hl.$$.fragment,s),y(Ys.$$.fragment,s),y(Ss.$$.fragment,s),y(dl.$$.fragment,s),y(Rs.$$.fragment,s),y(fl.$$.fragment,s),y(yl.$$.fragment,s),y(bl.$$.fragment,s),y(jl.$$.fragment,s),y(_l.$$.fragment,s),y(Tl.$$.fragment,s),y(Il.$$.fragment,s),y(xl.$$.fragment,s),y(Cl.$$.fragment,s),y(Ul.$$.fragment,s),y(Jl.$$.fragment,s),y(Ds.$$.fragment,s),y($l.$$.fragment,s),y(vl.$$.fragment,s),y(kl.$$.fragment,s),Pr=!0)},o(s){b(o.$$.fragment,s),b(Ls.$$.fragment,s),b(Os.$$.fragment,s),b(Ps.$$.fragment,s),b(ct.$$.fragment,s),b(Ks.$$.fragment,s),b(pt.$$.fragment,s),b(ea.$$.fragment,s),b(ut.$$.fragment,s),b(na.$$.fragment,s),b(gt.$$.fragment,s),b(ta.$$.fragment,s),b(mt.$$.fragment,s),b(ht.$$.fragment,s),b(sa.$$.fragment,s),b(dt.$$.fragment,s),b(aa.$$.fragment,s),b(ft.$$.fragment,s),b(la.$$.fragment,s),b(yt.$$.fragment,s),b(oa.$$.fragment,s),b(bt.$$.fragment,s),b(ra.$$.fragment,s),b(Mt.$$.fragment,s),b(jt.$$.fragment,s),b(ia.$$.fragment,s),b(ca.$$.fragment,s),b(Tt.$$.fragment,s),b(pa.$$.fragment,s),b(It.$$.fragment,s),b(ua.$$.fragment,s),b(xt.$$.fragment,s),b(Ct.$$.fragment,s),b(ga.$$.fragment,s),b(Ut.$$.fragment,s),b(wt.$$.fragment,s),b(ma.$$.fragment,s),b(Jt.$$.fragment,s),b(ha.$$.fragment,s),b($t.$$.fragment,s),b(vt.$$.fragment,s),b(kt.$$.fragment,s),b(da.$$.fragment,s),b(qt.$$.fragment,s),b(Et.$$.fragment,s),b(fa.$$.fragment,s),b(ya.$$.fragment,s),b(Zt.$$.fragment,s),b(ba.$$.fragment,s),b(Nt.$$.fragment,s),b(Ma.$$.fragment,s),b(Wt.$$.fragment,s),b(ja.$$.fragment,s),b(Gt.$$.fragment,s),b(_a.$$.fragment,s),b(Bt.$$.fragment,s),b(Ta.$$.fragment,s),b(Qt.$$.fragment,s),b(Ia.$$.fragment,s),b(Vt.$$.fragment,s),b(xa.$$.fragment,s),b(Yt.$$.fragment,s),b(St.$$.fragment,s),b(Ca.$$.fragment,s),b(Rt.$$.fragment,s),b(Dt.$$.fragment,s),b(Ua.$$.fragment,s),b(Xt.$$.fragment,s),b(wa.$$.fragment,s),b(Ht.$$.fragment,s),b(Ja.$$.fragment,s),b(zt.$$.fragment,s),b(Ft.$$.fragment,s),b($a.$$.fragment,s),b(Lt.$$.fragment,s),b(va.$$.fragment,s),b(Ot.$$.fragment,s),b(Pt.$$.fragment,s),b(ka.$$.fragment,s),b(Kt.$$.fragment,s),b(qa.$$.fragment,s),b(Aa.$$.fragment,s),b(Za.$$.fragment,s),b(Na.$$.fragment,s),b(es.$$.fragment,s),b(Wa.$$.fragment,s),b(ns.$$.fragment,s),b(Ga.$$.fragment,s),b(ts.$$.fragment,s),b(Ba.$$.fragment,s),b(ss.$$.fragment,s),b(Qa.$$.fragment,s),b(as.$$.fragment,s),b(ls.$$.fragment,s),b(Va.$$.fragment,s),b(os.$$.fragment,s),b(Ya.$$.fragment,s),b(rs.$$.fragment,s),b(Sa.$$.fragment,s),b(is.$$.fragment,s),b(Ra.$$.fragment,s),b(cs.$$.fragment,s),b(Da.$$.fragment,s),b(ps.$$.fragment,s),b(us.$$.fragment,s),b(Xa.$$.fragment,s),b(Ha.$$.fragment,s),b(ms.$$.fragment,s),b(za.$$.fragment,s),b(hs.$$.fragment,s),b(Fa.$$.fragment,s),b(ds.$$.fragment,s),b(fs.$$.fragment,s),b(La.$$.fragment,s),b(ys.$$.fragment,s),b(bs.$$.fragment,s),b(Oa.$$.fragment,s),b(Ms.$$.fragment,s),b(Pa.$$.fragment,s),b(js.$$.fragment,s),b(_s.$$.fragment,s),b(Ts.$$.fragment,s),b(Ka.$$.fragment,s),b(Is.$$.fragment,s),b(xs.$$.fragment,s),b(el.$$.fragment,s),b(nl.$$.fragment,s),b(Us.$$.fragment,s),b(tl.$$.fragment,s),b(ws.$$.fragment,s),b(sl.$$.fragment,s),b(Js.$$.fragment,s),b(al.$$.fragment,s),b($s.$$.fragment,s),b(ll.$$.fragment,s),b(vs.$$.fragment,s),b(ol.$$.fragment,s),b(ks.$$.fragment,s),b(rl.$$.fragment,s),b(qs.$$.fragment,s),b(il.$$.fragment,s),b(Es.$$.fragment,s),b(As.$$.fragment,s),b(cl.$$.fragment,s),b(Zs.$$.fragment,s),b(Ns.$$.fragment,s),b(pl.$$.fragment,s),b(Ws.$$.fragment,s),b(ul.$$.fragment,s),b(Gs.$$.fragment,s),b(gl.$$.fragment,s),b(Bs.$$.fragment,s),b(Qs.$$.fragment,s),b(ml.$$.fragment,s),b(Vs.$$.fragment,s),b(hl.$$.fragment,s),b(Ys.$$.fragment,s),b(Ss.$$.fragment,s),b(dl.$$.fragment,s),b(Rs.$$.fragment,s),b(fl.$$.fragment,s),b(yl.$$.fragment,s),b(bl.$$.fragment,s),b(jl.$$.fragment,s),b(_l.$$.fragment,s),b(Tl.$$.fragment,s),b(Il.$$.fragment,s),b(xl.$$.fragment,s),b(Cl.$$.fragment,s),b(Ul.$$.fragment,s),b(Jl.$$.fragment,s),b(Ds.$$.fragment,s),b($l.$$.fragment,s),b(vl.$$.fragment,s),b(kl.$$.fragment,s),Pr=!1},d(s){s&&(p(m),p(a),p(t),p(e),p(c),p($r),p(zs),p(vr),p(Fs),p(kr),p(qr),p(C),p(Er),p(Ar),p(Ea),p(Zr),p(Nr),p(U),p(Wr),p(Gr),p(jn),p(Br),p(Qr),p(Ml),p(Vr),p(Yr),p(_n),p(Sr),p(Rr),p(Tn),p(Dr),p(Xr),p(In),p(Hr),p(zr),p(wl),p(Fr),p(B),p(Lr),p(Or),p(Jr)),p(n),M(o,s),M(Ls,s),M(Os),M(Ps),M(ct),M(Ks),M(pt),M(ea),M(ut),M(na),M(gt),M(ta),M(mt),M(ht),M(sa),M(dt),M(aa),M(ft),M(la),M(yt),M(oa),M(bt),M(ra),M(Mt),M(jt),M(ia),M(ca),M(Tt),M(pa),M(It),M(ua),M(xt),M(Ct),M(ga),M(Ut),M(wt),M(ma),M(Jt),M(ha),M($t),M(vt),M(kt),M(da),M(qt),M(Et),M(fa),M(ya),M(Zt),M(ba),M(Nt),M(Ma),M(Wt),M(ja),M(Gt),M(_a),M(Bt),M(Ta),M(Qt),M(Ia),M(Vt),M(xa),M(Yt),M(St),M(Ca),M(Rt),M(Dt),M(Ua),M(Xt),M(wa),M(Ht),M(Ja),M(zt),M(Ft),M($a),M(Lt),M(va),M(Ot),M(Pt),M(ka),M(Kt),M(qa,s),M(Aa,s),M(Za),M(Na),M(es),M(Wa),M(ns),M(Ga),M(ts),M(Ba),M(ss),M(Qa),M(as),M(ls),M(Va),M(os),M(Ya),M(rs),M(Sa),M(is),M(Ra),M(cs),M(Da),M(ps),M(us),M(Xa),M(Ha),M(ms),M(za),M(hs),M(Fa),M(ds),M(fs),M(La),M(ys),M(bs),M(Oa),M(Ms),M(Pa),M(js),M(_s),M(Ts),M(Ka),M(Is),M(xs),M(el),M(nl),M(Us),M(tl),M(ws),M(sl),M(Js),M(al),M($s),M(ll),M(vs),M(ol),M(ks),M(rl),M(qs),M(il),M(Es),M(As),M(cl),M(Zs),M(Ns),M(pl),M(Ws),M(ul),M(Gs),M(gl),M(Bs),M(Qs),M(ml),M(Vs),M(hl),M(Ys),M(Ss),M(dl),M(Rs),M(fl,s),M(yl),M(bl,s),M(jl,s),M(_l),M(Tl,s),M(Il),M(xl,s),M(Cl),M(Ul,s),M(Jl),M(Ds),M($l),M(vl),M(kl,s)}}}const _f='{"title":"추론","local":"inference","sections":[{"title":"추론 클라이언트","local":"huggingface_hub.InferenceClient ][ huggingface_hub.InferenceClient","sections":[],"depth":2},{"title":"비동기 추론 클라이언트","local":"huggingface_hub.AsyncInferenceClient ][ huggingface_hub.AsyncInferenceClient","sections":[],"depth":2},{"title":"추론 시간 초과 오류","local":"huggingface_hub.InferenceTimeoutError ][ huggingface_hub.InferenceTimeoutError","sections":[],"depth":2},{"title":"반환 유형","local":"return-types","sections":[{"title":"대화형 출력 대화","local":"huggingface_hub.inference._types.ConversationalOutputConversation ][ huggingface_hub.inference._types.ConversationalOutputConversation","sections":[],"depth":3},{"title":"대화형 출력","local":"huggingface_hub.inference._types.ConversationalOutput ][ huggingface_hub.inference._types.ConversationalOutput","sections":[],"depth":3},{"title":"모델 상태","local":"huggingface_hub.inference._common.ModelStatus ][ huggingface_hub.inference._common.ModelStatus","sections":[],"depth":3}],"depth":2},{"title":"추론 API","local":"huggingface_hub.InferenceApi ][ huggingface_hub.InferenceApi","sections":[],"depth":2}],"depth":1}';function Tf(I){return Zh(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class vf extends Nh{constructor(n){super(),Wh(this,n,Tf,jf,Ah,{})}}export{vf as component};
