import{s as ns,o as ss,n as Un}from"../chunks/scheduler.6062bdaf.js";import{S as ts,i as as,g as i,s as a,r as o,A as ls,h as c,f as s,c as l,j as On,u as r,x as d,k as es,y as ps,a as t,v as g,d as u,t as h,w as f}from"../chunks/index.4bca734e.js";import{T as $n}from"../chunks/Tip.b9ac1f03.js";import{C as y}from"../chunks/CodeBlock.fa01571c.js";import{H as M,E as is}from"../chunks/EditOnGithub.74ab2baa.js";function cs(b){let p,j='In this section, we will see methods like <a href="/docs/huggingface_hub/pr_2386/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.pause">pause()</a>, <a href="/docs/huggingface_hub/pr_2386/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.resume">resume()</a>, <a href="/docs/huggingface_hub/pr_2386/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.scale_to_zero">scale_to_zero()</a>, <a href="/docs/huggingface_hub/pr_2386/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.update">update()</a> and <a href="/docs/huggingface_hub/pr_2386/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.delete">delete()</a>. All of those methods are aliases added to <a href="/docs/huggingface_hub/pr_2386/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a> for convenience. If you prefer, you can also use the generic methods defined in <code>HfApi</code>: <a href="/docs/huggingface_hub/pr_2386/en/package_reference/hf_api#huggingface_hub.HfApi.pause_inference_endpoint">pause_inference_endpoint()</a>, <a href="/docs/huggingface_hub/pr_2386/en/package_reference/hf_api#huggingface_hub.HfApi.resume_inference_endpoint">resume_inference_endpoint()</a>, <a href="/docs/huggingface_hub/pr_2386/en/package_reference/hf_api#huggingface_hub.HfApi.scale_to_zero_inference_endpoint">scale_to_zero_inference_endpoint()</a>, <a href="/docs/huggingface_hub/pr_2386/en/package_reference/hf_api#huggingface_hub.HfApi.update_inference_endpoint">update_inference_endpoint()</a>, and <a href="/docs/huggingface_hub/pr_2386/en/package_reference/hf_api#huggingface_hub.HfApi.delete_inference_endpoint">delete_inference_endpoint()</a>.';return{c(){p=i("p"),p.innerHTML=j},l(m){p=c(m,"P",{"data-svelte-h":!0}),d(p)!=="svelte-1a2e0e9"&&(p.innerHTML=j)},m(m,_){t(m,p,_)},p:Un,d(m){m&&s(p)}}}function os(b){let p,j='An Inference Endpoint that is <em>paused</em> or <em>scaled to zero</em> doesn’t cost anything. The difference between those two is that a <em>paused</em> endpoint needs to be explicitly <em>resumed</em> using <a href="/docs/huggingface_hub/pr_2386/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.resume">resume()</a>. On the contrary, a <em>scaled to zero</em> endpoint will automatically start if an inference call is made to it, with an additional cold start delay. An Inference Endpoint can also be configured to scale to zero automatically after a certain period of inactivity.';return{c(){p=i("p"),p.innerHTML=j},l(m){p=c(m,"P",{"data-svelte-h":!0}),d(p)!=="svelte-hb6ezu"&&(p.innerHTML=j)},m(m,_){t(m,p,_)},p:Un,d(m){m&&s(p)}}}function rs(b){let p,j="This is a non-revertible action that will completely remove the endpoint, including its configuration, logs and usage metrics. You cannot restore a deleted Inference Endpoint.";return{c(){p=i("p"),p.textContent=j},l(m){p=c(m,"P",{"data-svelte-h":!0}),d(p)!=="svelte-lscf4f"&&(p.textContent=j)},m(m,_){t(m,p,_)},p:Un,d(m){m&&s(p)}}}function gs(b){let p,j,m,_,x,we,I,xn=`Inference Endpoints provides a secure production solution to easily deploy any <code>transformers</code>, <code>sentence-transformers</code>, and <code>diffusers</code> models on a dedicated and autoscaling infrastructure managed by Hugging Face. An Inference Endpoint is built from a model from the <a href="https://huggingface.co/models" rel="nofollow">Hub</a>.
In this guide, we will learn how to programmatically manage Inference Endpoints with <code>huggingface_hub</code>. For more information about the Inference Endpoints product itself, check out its <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">official documentation</a>.`,$e,T,In='This guide assumes <code>huggingface_hub</code> is correctly installed and that your machine is logged in. Check out the <a href="https://huggingface.co/docs/huggingface_hub/quick-start#quickstart" rel="nofollow">Quick Start guide</a> if that’s not the case yet. The minimal version supporting Inference Endpoints API is <code>v0.19.0</code>.',Ue,E,xe,C,Tn='The first step is to create an Inference Endpoint using <a href="/docs/huggingface_hub/pr_2386/en/package_reference/hf_api#huggingface_hub.HfApi.create_inference_endpoint">create_inference_endpoint()</a>:',Ie,k,Te,J,En='In this example, we created a <code>protected</code> Inference Endpoint named <code>&quot;my-endpoint-name&quot;</code>, to serve <a href="https://huggingface.co/gpt2" rel="nofollow">gpt2</a> for <code>text-generation</code>. A <code>protected</code> Inference Endpoint means your token is required to access the API. We also need to provide additional information to configure the hardware requirements, such as vendor, region, accelerator, instance type, and size. You can check out the list of available resources <a href="https://api.endpoints.huggingface.cloud/#/v2%3A%3Aprovider/list_vendors" rel="nofollow">here</a>. Alternatively, you can create an Inference Endpoint manually using the <a href="https://ui.endpoints.huggingface.co/new" rel="nofollow">Web interface</a> for convenience. Refer to this <a href="https://huggingface.co/docs/inference-endpoints/guides/advanced" rel="nofollow">guide</a> for details on advanced settings and their usage.',Ee,v,Cn='The value returned by <a href="/docs/huggingface_hub/pr_2386/en/package_reference/hf_api#huggingface_hub.HfApi.create_inference_endpoint">create_inference_endpoint()</a> is an <a href="/docs/huggingface_hub/pr_2386/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a> object:',Ce,W,ke,Z,kn="It’s a dataclass that holds information about the endpoint. You can access important attributes such as <code>name</code>, <code>repository</code>, <code>status</code>, <code>task</code>, <code>created_at</code>, <code>updated_at</code>, etc. If you need it, you can also access the raw response from the server with <code>endpoint.raw</code>.",Je,q,Jn='Once your Inference Endpoint is created, you can find it on your <a href="https://ui.endpoints.huggingface.co/" rel="nofollow">personal dashboard</a>.',ve,A,vn='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/huggingface_hub/inference_endpoints_created.png"/>',We,H,Ze,Q,Wn='By default the Inference Endpoint is built from a docker image provided by Hugging Face. However, it is possible to specify any docker image using the <code>custom_image</code> parameter. A common use case is to run LLMs using the <a href="https://github.com/huggingface/text-generation-inference" rel="nofollow">text-generation-inference</a> framework. This can be done like this:',qe,B,Ae,V,Zn='The value to pass as <code>custom_image</code> is a dictionary containing a url to the docker container and configuration to run it. For more details about it, checkout the <a href="https://api.endpoints.huggingface.cloud/#/v2%3A%3Aendpoint/create_endpoint" rel="nofollow">Swagger documentation</a>.',He,G,Qe,L,qn='In some cases, you might need to manage Inference Endpoints you created previously. If you know the name, you can fetch it using <a href="/docs/huggingface_hub/pr_2386/en/package_reference/hf_api#huggingface_hub.HfApi.get_inference_endpoint">get_inference_endpoint()</a>, which returns an <a href="/docs/huggingface_hub/pr_2386/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a> object. Alternatively, you can use <a href="/docs/huggingface_hub/pr_2386/en/package_reference/hf_api#huggingface_hub.HfApi.list_inference_endpoints">list_inference_endpoints()</a> to retrieve a list of all Inference Endpoints. Both methods accept an optional <code>namespace</code> parameter. You can set the <code>namespace</code> to any organization you are a part of. Otherwise, it defaults to your username.',Be,X,Ve,Y,Ge,N,An='In the rest of this guide, we will assume that we have a <a href="/docs/huggingface_hub/pr_2386/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a> object called <code>endpoint</code>. You might have noticed that the endpoint has a <code>status</code> attribute of type <a href="/docs/huggingface_hub/pr_2386/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpointStatus">InferenceEndpointStatus</a>. When the Inference Endpoint is deployed and accessible, the status should be <code>&quot;running&quot;</code> and the <code>url</code> attribute is set:',Le,R,Xe,z,Hn='Before reaching a <code>&quot;running&quot;</code> state, the Inference Endpoint typically goes through an <code>&quot;initializing&quot;</code> or <code>&quot;pending&quot;</code> phase. You can fetch the new state of the endpoint by running <a href="/docs/huggingface_hub/pr_2386/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.fetch">fetch()</a>. Like every other method from <a href="/docs/huggingface_hub/pr_2386/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a> that makes a request to the server, the internal attributes of <code>endpoint</code> are mutated in place:',Ye,S,Ne,F,Qn='Instead of fetching the Inference Endpoint status while waiting for it to run, you can directly call <a href="/docs/huggingface_hub/pr_2386/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.wait">wait()</a>. This helper takes as input a <code>timeout</code> and a <code>fetch_every</code> parameter (in seconds) and will block the thread until the Inference Endpoint is deployed. Default values are respectively <code>None</code> (no timeout) and <code>5</code> seconds.',Re,P,ze,K,Bn="If <code>timeout</code> is set and the Inference Endpoint takes too much time to load, a <code>InferenceEndpointTimeoutError</code> timeout error is raised.",Se,D,Fe,O,Vn="Once your Inference Endpoint is up and running, you can finally run inference on it!",Pe,ee,Gn='<a href="/docs/huggingface_hub/pr_2386/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a> has two properties <code>client</code> and <code>async_client</code> returning respectively an <a href="/docs/huggingface_hub/pr_2386/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> and an <a href="/docs/huggingface_hub/pr_2386/en/package_reference/inference_client#huggingface_hub.AsyncInferenceClient">AsyncInferenceClient</a> objects.',Ke,ne,De,se,Ln='If the Inference Endpoint is not running, an <a href="/docs/huggingface_hub/pr_2386/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpointError">InferenceEndpointError</a> exception is raised:',Oe,te,en,ae,Xn='For more details about how to use the <a href="/docs/huggingface_hub/pr_2386/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>, check out the <a href="../guides/inference">Inference guide</a>.',nn,le,sn,pe,Yn="Now that we saw how to create an Inference Endpoint and run inference on it, let’s see how to manage its lifecycle.",tn,w,an,ie,ln,ce,Nn='To reduce costs when your Inference Endpoint is not in use, you can choose to either pause it using <a href="/docs/huggingface_hub/pr_2386/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.pause">pause()</a> or scale it to zero using <a href="/docs/huggingface_hub/pr_2386/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.scale_to_zero">scale_to_zero()</a>.',pn,$,cn,oe,on,re,rn,ge,Rn='In some cases, you might also want to update your Inference Endpoint without creating a new one. You can either update the hosted model or the hardware requirements to run the model. You can do this using <a href="/docs/huggingface_hub/pr_2386/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.update">update()</a>:',gn,ue,un,he,hn,fe,zn="Finally if you won’t use the Inference Endpoint anymore, you can simply call <code>~InferenceEndpoint.delete()</code>.",fn,U,dn,de,mn,me,Sn="A typical use case of Inference Endpoints is to process a batch of jobs at once to limit the infrastructure costs. You can automate this process using what we saw in this guide:",jn,je,yn,ye,Fn="Or if your Inference Endpoint already exists and is paused:",Mn,Me,_n,_e,bn,be,wn;return x=new M({props:{title:"Inference Endpoints",local:"inference-endpoints",headingTag:"h1"}}),E=new M({props:{title:"Create an Inference Endpoint",local:"create-an-inference-endpoint",headingTag:"h2"}}),k=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQlMEElMEFlbmRwb2ludCUyMCUzRCUyMGNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQoJTBBJTIwJTIwJTIwJTIwJTIybXktZW5kcG9pbnQtbmFtZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlcG9zaXRvcnklM0QlMjJncHQyJTIyJTJDJTBBJTIwJTIwJTIwJTIwZnJhbWV3b3JrJTNEJTIycHl0b3JjaCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvciUzRCUyMmNwdSUyMiUyQyUwQSUyMCUyMCUyMCUyMHZlbmRvciUzRCUyMmF3cyUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlZ2lvbiUzRCUyMnVzLWVhc3QtMSUyMiUyQyUwQSUyMCUyMCUyMCUyMHR5cGUlM0QlMjJwcm90ZWN0ZWQlMjIlMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV9zaXplJTNEJTIyeDIlMjIlMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV90eXBlJTNEJTIyaW50ZWwtaWNsJTIyJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_inference_endpoint

<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = create_inference_endpoint(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;my-endpoint-name&quot;</span>,
<span class="hljs-meta">... </span>    repository=<span class="hljs-string">&quot;gpt2&quot;</span>,
<span class="hljs-meta">... </span>    framework=<span class="hljs-string">&quot;pytorch&quot;</span>,
<span class="hljs-meta">... </span>    task=<span class="hljs-string">&quot;text-generation&quot;</span>,
<span class="hljs-meta">... </span>    accelerator=<span class="hljs-string">&quot;cpu&quot;</span>,
<span class="hljs-meta">... </span>    vendor=<span class="hljs-string">&quot;aws&quot;</span>,
<span class="hljs-meta">... </span>    region=<span class="hljs-string">&quot;us-east-1&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;protected&quot;</span>,
<span class="hljs-meta">... </span>    instance_size=<span class="hljs-string">&quot;x2&quot;</span>,
<span class="hljs-meta">... </span>    instance_type=<span class="hljs-string">&quot;intel-icl&quot;</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),W=new y({props:{code:"ZW5kcG9pbnQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)`,wrap:!1}}),H=new M({props:{title:"Using a custom image",local:"using-a-custom-image",headingTag:"h4"}}),B=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQlMEFlbmRwb2ludCUyMCUzRCUyMGNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQoJTBBJTIwJTIwJTIwJTIwJTIyYXdzLXplcGh5ci03Yi1iZXRhLTA0ODYlMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvc2l0b3J5JTNEJTIySHVnZ2luZ0ZhY2VINCUyRnplcGh5ci03Yi1iZXRhJTIyJTJDJTBBJTIwJTIwJTIwJTIwZnJhbWV3b3JrJTNEJTIycHl0b3JjaCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvciUzRCUyMmdwdSUyMiUyQyUwQSUyMCUyMCUyMCUyMHZlbmRvciUzRCUyMmF3cyUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlZ2lvbiUzRCUyMnVzLWVhc3QtMSUyMiUyQyUwQSUyMCUyMCUyMCUyMHR5cGUlM0QlMjJwcm90ZWN0ZWQlMjIlMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV9zaXplJTNEJTIyeDElMjIlMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV90eXBlJTNEJTIybnZpZGlhLWExMGclMjIlMkMlMEElMjAlMjAlMjAlMjBjdXN0b21faW1hZ2UlM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJoZWFsdGhfcm91dGUlMjIlM0ElMjAlMjIlMkZoZWFsdGglMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbnYlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNQVhfQkFUQ0hfUFJFRklMTF9UT0tFTlMlMjIlM0ElMjAlMjIyMDQ4JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyTUFYX0lOUFVUX0xFTkdUSCUyMiUzQSUyMCUyMjEwMjQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNQVhfVE9UQUxfVE9LRU5TJTIyJTNBJTIwJTIyMTUxMiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMk1PREVMX0lEJTIyJTNBJTIwJTIyJTJGcmVwb3NpdG9yeSUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnVybCUyMiUzQSUyMCUyMmdoY3IuaW8lMkZodWdnaW5nZmFjZSUyRnRleHQtZ2VuZXJhdGlvbi1pbmZlcmVuY2UlM0ExLjEuMCUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSk=",highlighted:`<span class="hljs-comment"># Start an Inference Endpoint running Zephyr-7b-beta on TGI</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_inference_endpoint
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = create_inference_endpoint(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;aws-zephyr-7b-beta-0486&quot;</span>,
<span class="hljs-meta">... </span>    repository=<span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>,
<span class="hljs-meta">... </span>    framework=<span class="hljs-string">&quot;pytorch&quot;</span>,
<span class="hljs-meta">... </span>    task=<span class="hljs-string">&quot;text-generation&quot;</span>,
<span class="hljs-meta">... </span>    accelerator=<span class="hljs-string">&quot;gpu&quot;</span>,
<span class="hljs-meta">... </span>    vendor=<span class="hljs-string">&quot;aws&quot;</span>,
<span class="hljs-meta">... </span>    region=<span class="hljs-string">&quot;us-east-1&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;protected&quot;</span>,
<span class="hljs-meta">... </span>    instance_size=<span class="hljs-string">&quot;x1&quot;</span>,
<span class="hljs-meta">... </span>    instance_type=<span class="hljs-string">&quot;nvidia-a10g&quot;</span>,
<span class="hljs-meta">... </span>    custom_image={
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;health_route&quot;</span>: <span class="hljs-string">&quot;/health&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;env&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;MAX_BATCH_PREFILL_TOKENS&quot;</span>: <span class="hljs-string">&quot;2048&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;MAX_INPUT_LENGTH&quot;</span>: <span class="hljs-string">&quot;1024&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;MAX_TOTAL_TOKENS&quot;</span>: <span class="hljs-string">&quot;1512&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;MODEL_ID&quot;</span>: <span class="hljs-string">&quot;/repository&quot;</span>
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;ghcr.io/huggingface/text-generation-inference:1.1.0&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>)`,wrap:!1}}),G=new M({props:{title:"Get or list existing Inference Endpoints",local:"get-or-list-existing-inference-endpoints",headingTag:"h3"}}),X=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9pbmZlcmVuY2VfZW5kcG9pbnQlMkMlMjBsaXN0X2luZmVyZW5jZV9lbmRwb2ludHMlMEElMEFnZXRfaW5mZXJlbmNlX2VuZHBvaW50KCUyMm15LWVuZHBvaW50LW5hbWUlMjIpJTBBJTBBbGlzdF9pbmZlcmVuY2VfZW5kcG9pbnRzKG5hbWVzcGFjZSUzRCUyMmh1Z2dpbmdmYWNlJTIyKSUwQSUwQWxpc3RfaW5mZXJlbmNlX2VuZHBvaW50cyhuYW1lc3BhY2UlM0QlMjIqJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_inference_endpoint, list_inference_endpoints

<span class="hljs-comment"># Get one</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>get_inference_endpoint(<span class="hljs-string">&quot;my-endpoint-name&quot;</span>)
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)

<span class="hljs-comment"># List all endpoints from an organization</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>list_inference_endpoints(namespace=<span class="hljs-string">&quot;huggingface&quot;</span>)
[InferenceEndpoint(name=<span class="hljs-string">&#x27;aws-starchat-beta&#x27;</span>, namespace=<span class="hljs-string">&#x27;huggingface&#x27;</span>, repository=<span class="hljs-string">&#x27;HuggingFaceH4/starchat-beta&#x27;</span>, status=<span class="hljs-string">&#x27;paused&#x27;</span>, url=<span class="hljs-literal">None</span>), ...]

<span class="hljs-comment"># List all endpoints from all organizations the user belongs to</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>list_inference_endpoints(namespace=<span class="hljs-string">&quot;*&quot;</span>)
[InferenceEndpoint(name=<span class="hljs-string">&#x27;aws-starchat-beta&#x27;</span>, namespace=<span class="hljs-string">&#x27;huggingface&#x27;</span>, repository=<span class="hljs-string">&#x27;HuggingFaceH4/starchat-beta&#x27;</span>, status=<span class="hljs-string">&#x27;paused&#x27;</span>, url=<span class="hljs-literal">None</span>), ...]`,wrap:!1}}),Y=new M({props:{title:"Check deployment status",local:"check-deployment-status",headingTag:"h2"}}),R=new y({props:{code:"ZW5kcG9pbnQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;running&#x27;</span>, url=<span class="hljs-string">&#x27;https://jpj7k2q4j805b727.us-east-1.aws.endpoints.huggingface.cloud&#x27;</span>)`,wrap:!1}}),S=new y({props:{code:"ZW5kcG9pbnQuZmV0Y2goKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.fetch()
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)`,wrap:!1}}),P=new y({props:{code:"ZW5kcG9pbnQlMEElMEFlbmRwb2ludC53YWl0KHRpbWVvdXQlM0QxMCklMEElMEFlbmRwb2ludC53YWl0KCk=",highlighted:`<span class="hljs-comment"># Pending endpoint</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)

<span class="hljs-comment"># Wait 10s =&gt; raises a InferenceEndpointTimeoutError</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.wait(timeout=<span class="hljs-number">10</span>)
    <span class="hljs-keyword">raise</span> InferenceEndpointTimeoutError(<span class="hljs-string">&quot;Timeout while waiting for Inference Endpoint to be deployed.&quot;</span>)
huggingface_hub._inference_endpoints.InferenceEndpointTimeoutError: Timeout <span class="hljs-keyword">while</span> waiting <span class="hljs-keyword">for</span> Inference Endpoint to be deployed.

<span class="hljs-comment"># Wait more</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.wait()
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;running&#x27;</span>, url=<span class="hljs-string">&#x27;https://jpj7k2q4j805b727.us-east-1.aws.endpoints.huggingface.cloud&#x27;</span>)`,wrap:!1}}),D=new M({props:{title:"Run inference",local:"run-inference",headingTag:"h2"}}),ne=new y({props:{code:"ZW5kcG9pbnQuY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMjJJJTIwYW0lMjIpJTBBJTBBYXdhaXQlMjBlbmRwb2ludC5hc3luY19jbGllbnQudGV4dF9nZW5lcmF0aW9uKCUyMkklMjBhbSUyMik=",highlighted:`<span class="hljs-comment"># Run text_generation task:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.client.text_generation(<span class="hljs-string">&quot;I am&quot;</span>)
<span class="hljs-string">&#x27; not a fan of the idea of a &quot;big-budget&quot; movie. I think it\\&#x27;s a&#x27;</span>

<span class="hljs-comment"># Or in an asyncio context:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> endpoint.async_client.text_generation(<span class="hljs-string">&quot;I am&quot;</span>)`,wrap:!1}}),te=new y({props:{code:"ZW5kcG9pbnQuY2xpZW50",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.client\nhuggingface_hub._inference_endpoints.InferenceEndpointError: Cannot create a client <span class="hljs-keyword">for</span> this Inference Endpoint <span class="hljs-keyword">as</span> it <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> yet deployed. Please wait <span class="hljs-keyword">for</span> the Inference Endpoint to be deployed using `endpoint.wait()` <span class="hljs-keyword">and</span> <span class="hljs-keyword">try</span> again.',wrap:!1}}),le=new M({props:{title:"Manage lifecycle",local:"manage-lifecycle",headingTag:"h2"}}),w=new $n({props:{$$slots:{default:[cs]},$$scope:{ctx:b}}}),ie=new M({props:{title:"Pause or scale to zero",local:"pause-or-scale-to-zero",headingTag:"h3"}}),$=new $n({props:{$$slots:{default:[os]},$$scope:{ctx:b}}}),oe=new y({props:{code:"ZW5kcG9pbnQucGF1c2UoKSUwQWVuZHBvaW50LnJlc3VtZSgpJTBBZW5kcG9pbnQud2FpdCgpLmNsaWVudC50ZXh0X2dlbmVyYXRpb24oLi4uKSUwQSUwQWVuZHBvaW50LnNjYWxlX3RvX3plcm8oKQ==",highlighted:`<span class="hljs-comment"># Pause and resume endpoint</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.pause()
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;paused&#x27;</span>, url=<span class="hljs-literal">None</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.resume()
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.wait().client.text_generation(...)
...

<span class="hljs-comment"># Scale to zero</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.scale_to_zero()
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;scaledToZero&#x27;</span>, url=<span class="hljs-string">&#x27;https://jpj7k2q4j805b727.us-east-1.aws.endpoints.huggingface.cloud&#x27;</span>)
<span class="hljs-comment"># Endpoint is not &#x27;running&#x27; but still has a URL and will restart on first call.</span>`,wrap:!1}}),re=new M({props:{title:"Update model or hardware requirements",local:"update-model-or-hardware-requirements",headingTag:"h3"}}),ue=new y({props:{code:"ZW5kcG9pbnQudXBkYXRlKHJlcG9zaXRvcnklM0QlMjJncHQyLWxhcmdlJTIyKSUwQSUwQWVuZHBvaW50LnVwZGF0ZShtaW5fcmVwbGljYSUzRDIlMkMlMjBtYXhfcmVwbGljYSUzRDYpJTBBJTBBZW5kcG9pbnQudXBkYXRlKGFjY2VsZXJhdG9yJTNEJTIyY3B1JTIyJTJDJTIwaW5zdGFuY2Vfc2l6ZSUzRCUyMng0JTIyJTJDJTIwaW5zdGFuY2VfdHlwZSUzRCUyMmludGVsLWljbCUyMik=",highlighted:`<span class="hljs-comment"># Change target model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.update(repository=<span class="hljs-string">&quot;gpt2-large&quot;</span>)
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2-large&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)

<span class="hljs-comment"># Update number of replicas</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.update(min_replica=<span class="hljs-number">2</span>, max_replica=<span class="hljs-number">6</span>)
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2-large&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)

<span class="hljs-comment"># Update to larger instance</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.update(accelerator=<span class="hljs-string">&quot;cpu&quot;</span>, instance_size=<span class="hljs-string">&quot;x4&quot;</span>, instance_type=<span class="hljs-string">&quot;intel-icl&quot;</span>)
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2-large&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)`,wrap:!1}}),he=new M({props:{title:"Delete the endpoint",local:"delete-the-endpoint",headingTag:"h3"}}),U=new $n({props:{warning:!0,$$slots:{default:[rs]},$$scope:{ctx:b}}}),de=new M({props:{title:"An end-to-end example",local:"an-end-to-end-example",headingTag:"h2"}}),je=new y({props:{code:"aW1wb3J0JTIwYXN5bmNpbyUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBjcmVhdGVfaW5mZXJlbmNlX2VuZHBvaW50JTBBJTBBZW5kcG9pbnQlMjAlM0QlMjBjcmVhdGVfaW5mZXJlbmNlX2VuZHBvaW50KG5hbWUlM0QlMjJiYXRjaC1lbmRwb2ludCUyMiUyQy4uLikud2FpdCgpJTBBJTBBY2xpZW50JTIwJTNEJTIwZW5kcG9pbnQuY2xpZW50JTBBcmVzdWx0cyUyMCUzRCUyMCU1QmNsaWVudC50ZXh0X2dlbmVyYXRpb24oLi4uKSUyMGZvciUyMGpvYiUyMGluJTIwam9icyU1RCUwQSUwQWFzeW5jX2NsaWVudCUyMCUzRCUyMGVuZHBvaW50LmFzeW5jX2NsaWVudCUwQXJlc3VsdHMlMjAlM0QlMjBhc3luY2lvLmdhdGhlcigqJTVCYXN5bmNfY2xpZW50LnRleHRfZ2VuZXJhdGlvbiguLi4pJTIwZm9yJTIwam9iJTIwaW4lMjBqb2JzJTVEKSUwQSUwQWVuZHBvaW50LnBhdXNlKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> asyncio
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_inference_endpoint

<span class="hljs-comment"># Start endpoint + wait until initialized</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = create_inference_endpoint(name=<span class="hljs-string">&quot;batch-endpoint&quot;</span>,...).wait()

<span class="hljs-comment"># Run inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = endpoint.client
<span class="hljs-meta">&gt;&gt;&gt; </span>results = [client.text_generation(...) <span class="hljs-keyword">for</span> job <span class="hljs-keyword">in</span> jobs]

<span class="hljs-comment"># Or with asyncio</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>async_client = endpoint.async_client
<span class="hljs-meta">&gt;&gt;&gt; </span>results = asyncio.gather(*[async_client.text_generation(...) <span class="hljs-keyword">for</span> job <span class="hljs-keyword">in</span> jobs])

<span class="hljs-comment"># Pause endpoint</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.pause()`,wrap:!1}}),Me=new y({props:{code:"aW1wb3J0JTIwYXN5bmNpbyUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBnZXRfaW5mZXJlbmNlX2VuZHBvaW50JTBBJTBBZW5kcG9pbnQlMjAlM0QlMjBnZXRfaW5mZXJlbmNlX2VuZHBvaW50KCUyMmJhdGNoLWVuZHBvaW50JTIyKS5yZXN1bWUoKS53YWl0KCklMEElMEFhc3luY19jbGllbnQlMjAlM0QlMjBlbmRwb2ludC5hc3luY19jbGllbnQlMEFyZXN1bHRzJTIwJTNEJTIwYXN5bmNpby5nYXRoZXIoKiU1QmFzeW5jX2NsaWVudC50ZXh0X2dlbmVyYXRpb24oLi4uKSUyMGZvciUyMGpvYiUyMGluJTIwam9icyU1RCklMEElMEFlbmRwb2ludC5wYXVzZSgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> asyncio
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_inference_endpoint

<span class="hljs-comment"># Get endpoint + wait until initialized</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = get_inference_endpoint(<span class="hljs-string">&quot;batch-endpoint&quot;</span>).resume().wait()

<span class="hljs-comment"># Run inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>async_client = endpoint.async_client
<span class="hljs-meta">&gt;&gt;&gt; </span>results = asyncio.gather(*[async_client.text_generation(...) <span class="hljs-keyword">for</span> job <span class="hljs-keyword">in</span> jobs])

<span class="hljs-comment"># Pause endpoint</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.pause()`,wrap:!1}}),_e=new is({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/guides/inference_endpoints.md"}}),{c(){p=i("meta"),j=a(),m=i("p"),_=a(),o(x.$$.fragment),we=a(),I=i("p"),I.innerHTML=xn,$e=a(),T=i("p"),T.innerHTML=In,Ue=a(),o(E.$$.fragment),xe=a(),C=i("p"),C.innerHTML=Tn,Ie=a(),o(k.$$.fragment),Te=a(),J=i("p"),J.innerHTML=En,Ee=a(),v=i("p"),v.innerHTML=Cn,Ce=a(),o(W.$$.fragment),ke=a(),Z=i("p"),Z.innerHTML=kn,Je=a(),q=i("p"),q.innerHTML=Jn,ve=a(),A=i("p"),A.innerHTML=vn,We=a(),o(H.$$.fragment),Ze=a(),Q=i("p"),Q.innerHTML=Wn,qe=a(),o(B.$$.fragment),Ae=a(),V=i("p"),V.innerHTML=Zn,He=a(),o(G.$$.fragment),Qe=a(),L=i("p"),L.innerHTML=qn,Be=a(),o(X.$$.fragment),Ve=a(),o(Y.$$.fragment),Ge=a(),N=i("p"),N.innerHTML=An,Le=a(),o(R.$$.fragment),Xe=a(),z=i("p"),z.innerHTML=Hn,Ye=a(),o(S.$$.fragment),Ne=a(),F=i("p"),F.innerHTML=Qn,Re=a(),o(P.$$.fragment),ze=a(),K=i("p"),K.innerHTML=Bn,Se=a(),o(D.$$.fragment),Fe=a(),O=i("p"),O.textContent=Vn,Pe=a(),ee=i("p"),ee.innerHTML=Gn,Ke=a(),o(ne.$$.fragment),De=a(),se=i("p"),se.innerHTML=Ln,Oe=a(),o(te.$$.fragment),en=a(),ae=i("p"),ae.innerHTML=Xn,nn=a(),o(le.$$.fragment),sn=a(),pe=i("p"),pe.textContent=Yn,tn=a(),o(w.$$.fragment),an=a(),o(ie.$$.fragment),ln=a(),ce=i("p"),ce.innerHTML=Nn,pn=a(),o($.$$.fragment),cn=a(),o(oe.$$.fragment),on=a(),o(re.$$.fragment),rn=a(),ge=i("p"),ge.innerHTML=Rn,gn=a(),o(ue.$$.fragment),un=a(),o(he.$$.fragment),hn=a(),fe=i("p"),fe.innerHTML=zn,fn=a(),o(U.$$.fragment),dn=a(),o(de.$$.fragment),mn=a(),me=i("p"),me.textContent=Sn,jn=a(),o(je.$$.fragment),yn=a(),ye=i("p"),ye.textContent=Fn,Mn=a(),o(Me.$$.fragment),_n=a(),o(_e.$$.fragment),bn=a(),be=i("p"),this.h()},l(e){const n=ls("svelte-u9bgzb",document.head);p=c(n,"META",{name:!0,content:!0}),n.forEach(s),j=l(e),m=c(e,"P",{}),On(m).forEach(s),_=l(e),r(x.$$.fragment,e),we=l(e),I=c(e,"P",{"data-svelte-h":!0}),d(I)!=="svelte-188e6gz"&&(I.innerHTML=xn),$e=l(e),T=c(e,"P",{"data-svelte-h":!0}),d(T)!=="svelte-1ds3okp"&&(T.innerHTML=In),Ue=l(e),r(E.$$.fragment,e),xe=l(e),C=c(e,"P",{"data-svelte-h":!0}),d(C)!=="svelte-1s8vrrz"&&(C.innerHTML=Tn),Ie=l(e),r(k.$$.fragment,e),Te=l(e),J=c(e,"P",{"data-svelte-h":!0}),d(J)!=="svelte-1stw0yf"&&(J.innerHTML=En),Ee=l(e),v=c(e,"P",{"data-svelte-h":!0}),d(v)!=="svelte-1173j38"&&(v.innerHTML=Cn),Ce=l(e),r(W.$$.fragment,e),ke=l(e),Z=c(e,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-dxdc75"&&(Z.innerHTML=kn),Je=l(e),q=c(e,"P",{"data-svelte-h":!0}),d(q)!=="svelte-1tjw294"&&(q.innerHTML=Jn),ve=l(e),A=c(e,"P",{"data-svelte-h":!0}),d(A)!=="svelte-1tajtyl"&&(A.innerHTML=vn),We=l(e),r(H.$$.fragment,e),Ze=l(e),Q=c(e,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-j6tvxe"&&(Q.innerHTML=Wn),qe=l(e),r(B.$$.fragment,e),Ae=l(e),V=c(e,"P",{"data-svelte-h":!0}),d(V)!=="svelte-33b9op"&&(V.innerHTML=Zn),He=l(e),r(G.$$.fragment,e),Qe=l(e),L=c(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-d8fyw8"&&(L.innerHTML=qn),Be=l(e),r(X.$$.fragment,e),Ve=l(e),r(Y.$$.fragment,e),Ge=l(e),N=c(e,"P",{"data-svelte-h":!0}),d(N)!=="svelte-z802ka"&&(N.innerHTML=An),Le=l(e),r(R.$$.fragment,e),Xe=l(e),z=c(e,"P",{"data-svelte-h":!0}),d(z)!=="svelte-1y31zol"&&(z.innerHTML=Hn),Ye=l(e),r(S.$$.fragment,e),Ne=l(e),F=c(e,"P",{"data-svelte-h":!0}),d(F)!=="svelte-1xgdq2y"&&(F.innerHTML=Qn),Re=l(e),r(P.$$.fragment,e),ze=l(e),K=c(e,"P",{"data-svelte-h":!0}),d(K)!=="svelte-1g2lxsg"&&(K.innerHTML=Bn),Se=l(e),r(D.$$.fragment,e),Fe=l(e),O=c(e,"P",{"data-svelte-h":!0}),d(O)!=="svelte-un9pgy"&&(O.textContent=Vn),Pe=l(e),ee=c(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-1pratgr"&&(ee.innerHTML=Gn),Ke=l(e),r(ne.$$.fragment,e),De=l(e),se=c(e,"P",{"data-svelte-h":!0}),d(se)!=="svelte-o3uxw8"&&(se.innerHTML=Ln),Oe=l(e),r(te.$$.fragment,e),en=l(e),ae=c(e,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-of4hqu"&&(ae.innerHTML=Xn),nn=l(e),r(le.$$.fragment,e),sn=l(e),pe=c(e,"P",{"data-svelte-h":!0}),d(pe)!=="svelte-16mqpnz"&&(pe.textContent=Yn),tn=l(e),r(w.$$.fragment,e),an=l(e),r(ie.$$.fragment,e),ln=l(e),ce=c(e,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-1h5dz61"&&(ce.innerHTML=Nn),pn=l(e),r($.$$.fragment,e),cn=l(e),r(oe.$$.fragment,e),on=l(e),r(re.$$.fragment,e),rn=l(e),ge=c(e,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-1jvnpb5"&&(ge.innerHTML=Rn),gn=l(e),r(ue.$$.fragment,e),un=l(e),r(he.$$.fragment,e),hn=l(e),fe=c(e,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-1j2n6pp"&&(fe.innerHTML=zn),fn=l(e),r(U.$$.fragment,e),dn=l(e),r(de.$$.fragment,e),mn=l(e),me=c(e,"P",{"data-svelte-h":!0}),d(me)!=="svelte-r11tzs"&&(me.textContent=Sn),jn=l(e),r(je.$$.fragment,e),yn=l(e),ye=c(e,"P",{"data-svelte-h":!0}),d(ye)!=="svelte-u5cd5i"&&(ye.textContent=Fn),Mn=l(e),r(Me.$$.fragment,e),_n=l(e),r(_e.$$.fragment,e),bn=l(e),be=c(e,"P",{}),On(be).forEach(s),this.h()},h(){es(p,"name","hf:doc:metadata"),es(p,"content",us)},m(e,n){ps(document.head,p),t(e,j,n),t(e,m,n),t(e,_,n),g(x,e,n),t(e,we,n),t(e,I,n),t(e,$e,n),t(e,T,n),t(e,Ue,n),g(E,e,n),t(e,xe,n),t(e,C,n),t(e,Ie,n),g(k,e,n),t(e,Te,n),t(e,J,n),t(e,Ee,n),t(e,v,n),t(e,Ce,n),g(W,e,n),t(e,ke,n),t(e,Z,n),t(e,Je,n),t(e,q,n),t(e,ve,n),t(e,A,n),t(e,We,n),g(H,e,n),t(e,Ze,n),t(e,Q,n),t(e,qe,n),g(B,e,n),t(e,Ae,n),t(e,V,n),t(e,He,n),g(G,e,n),t(e,Qe,n),t(e,L,n),t(e,Be,n),g(X,e,n),t(e,Ve,n),g(Y,e,n),t(e,Ge,n),t(e,N,n),t(e,Le,n),g(R,e,n),t(e,Xe,n),t(e,z,n),t(e,Ye,n),g(S,e,n),t(e,Ne,n),t(e,F,n),t(e,Re,n),g(P,e,n),t(e,ze,n),t(e,K,n),t(e,Se,n),g(D,e,n),t(e,Fe,n),t(e,O,n),t(e,Pe,n),t(e,ee,n),t(e,Ke,n),g(ne,e,n),t(e,De,n),t(e,se,n),t(e,Oe,n),g(te,e,n),t(e,en,n),t(e,ae,n),t(e,nn,n),g(le,e,n),t(e,sn,n),t(e,pe,n),t(e,tn,n),g(w,e,n),t(e,an,n),g(ie,e,n),t(e,ln,n),t(e,ce,n),t(e,pn,n),g($,e,n),t(e,cn,n),g(oe,e,n),t(e,on,n),g(re,e,n),t(e,rn,n),t(e,ge,n),t(e,gn,n),g(ue,e,n),t(e,un,n),g(he,e,n),t(e,hn,n),t(e,fe,n),t(e,fn,n),g(U,e,n),t(e,dn,n),g(de,e,n),t(e,mn,n),t(e,me,n),t(e,jn,n),g(je,e,n),t(e,yn,n),t(e,ye,n),t(e,Mn,n),g(Me,e,n),t(e,_n,n),g(_e,e,n),t(e,bn,n),t(e,be,n),wn=!0},p(e,[n]){const Pn={};n&2&&(Pn.$$scope={dirty:n,ctx:e}),w.$set(Pn);const Kn={};n&2&&(Kn.$$scope={dirty:n,ctx:e}),$.$set(Kn);const Dn={};n&2&&(Dn.$$scope={dirty:n,ctx:e}),U.$set(Dn)},i(e){wn||(u(x.$$.fragment,e),u(E.$$.fragment,e),u(k.$$.fragment,e),u(W.$$.fragment,e),u(H.$$.fragment,e),u(B.$$.fragment,e),u(G.$$.fragment,e),u(X.$$.fragment,e),u(Y.$$.fragment,e),u(R.$$.fragment,e),u(S.$$.fragment,e),u(P.$$.fragment,e),u(D.$$.fragment,e),u(ne.$$.fragment,e),u(te.$$.fragment,e),u(le.$$.fragment,e),u(w.$$.fragment,e),u(ie.$$.fragment,e),u($.$$.fragment,e),u(oe.$$.fragment,e),u(re.$$.fragment,e),u(ue.$$.fragment,e),u(he.$$.fragment,e),u(U.$$.fragment,e),u(de.$$.fragment,e),u(je.$$.fragment,e),u(Me.$$.fragment,e),u(_e.$$.fragment,e),wn=!0)},o(e){h(x.$$.fragment,e),h(E.$$.fragment,e),h(k.$$.fragment,e),h(W.$$.fragment,e),h(H.$$.fragment,e),h(B.$$.fragment,e),h(G.$$.fragment,e),h(X.$$.fragment,e),h(Y.$$.fragment,e),h(R.$$.fragment,e),h(S.$$.fragment,e),h(P.$$.fragment,e),h(D.$$.fragment,e),h(ne.$$.fragment,e),h(te.$$.fragment,e),h(le.$$.fragment,e),h(w.$$.fragment,e),h(ie.$$.fragment,e),h($.$$.fragment,e),h(oe.$$.fragment,e),h(re.$$.fragment,e),h(ue.$$.fragment,e),h(he.$$.fragment,e),h(U.$$.fragment,e),h(de.$$.fragment,e),h(je.$$.fragment,e),h(Me.$$.fragment,e),h(_e.$$.fragment,e),wn=!1},d(e){e&&(s(j),s(m),s(_),s(we),s(I),s($e),s(T),s(Ue),s(xe),s(C),s(Ie),s(Te),s(J),s(Ee),s(v),s(Ce),s(ke),s(Z),s(Je),s(q),s(ve),s(A),s(We),s(Ze),s(Q),s(qe),s(Ae),s(V),s(He),s(Qe),s(L),s(Be),s(Ve),s(Ge),s(N),s(Le),s(Xe),s(z),s(Ye),s(Ne),s(F),s(Re),s(ze),s(K),s(Se),s(Fe),s(O),s(Pe),s(ee),s(Ke),s(De),s(se),s(Oe),s(en),s(ae),s(nn),s(sn),s(pe),s(tn),s(an),s(ln),s(ce),s(pn),s(cn),s(on),s(rn),s(ge),s(gn),s(un),s(hn),s(fe),s(fn),s(dn),s(mn),s(me),s(jn),s(yn),s(ye),s(Mn),s(_n),s(bn),s(be)),s(p),f(x,e),f(E,e),f(k,e),f(W,e),f(H,e),f(B,e),f(G,e),f(X,e),f(Y,e),f(R,e),f(S,e),f(P,e),f(D,e),f(ne,e),f(te,e),f(le,e),f(w,e),f(ie,e),f($,e),f(oe,e),f(re,e),f(ue,e),f(he,e),f(U,e),f(de,e),f(je,e),f(Me,e),f(_e,e)}}}const us='{"title":"Inference Endpoints","local":"inference-endpoints","sections":[{"title":"Create an Inference Endpoint","local":"create-an-inference-endpoint","sections":[{"title":"Using a custom image","local":"using-a-custom-image","sections":[],"depth":4},{"title":"Get or list existing Inference Endpoints","local":"get-or-list-existing-inference-endpoints","sections":[],"depth":3}],"depth":2},{"title":"Check deployment status","local":"check-deployment-status","sections":[],"depth":2},{"title":"Run inference","local":"run-inference","sections":[],"depth":2},{"title":"Manage lifecycle","local":"manage-lifecycle","sections":[{"title":"Pause or scale to zero","local":"pause-or-scale-to-zero","sections":[],"depth":3},{"title":"Update model or hardware requirements","local":"update-model-or-hardware-requirements","sections":[],"depth":3},{"title":"Delete the endpoint","local":"delete-the-endpoint","sections":[],"depth":3}],"depth":2},{"title":"An end-to-end example","local":"an-end-to-end-example","sections":[],"depth":2}],"depth":1}';function hs(b){return ss(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ms extends ts{constructor(p){super(),as(this,p,hs,gs,ns,{})}}export{Ms as component};
