import{s as qo,o as No,n as Go}from"../chunks/scheduler.f6b352c8.js";import{S as Ro,i as Qo,g as i,s as n,r,m as So,A as Xo,h as o,f as l,c as a,j as B,u as c,x as p,n as zo,k as w,y as f,a as s,v as u,d as M,t as m,w as h}from"../chunks/index.b90df637.js";import{T as Vo}from"../chunks/Tip.366d2e6e.js";import{C as d}from"../chunks/CodeBlock.e5718f9d.js";import{H as j,E as Yo}from"../chunks/getInferenceSnippets.ff8f18ec.js";function Po(_l){let y,E='If you have any questions or need help, please reach out on <a href="https://discord.com/invite/s3KuuzsPFb" rel="nofollow">Discord</a>.';return{c(){y=i("p"),y.innerHTML=E},l(J){y=o(J,"P",{"data-svelte-h":!0}),p(y)!=="svelte-aht5b3"&&(y.innerHTML=E)},m(J,Tl){s(J,y,Tl)},p:Go,d(J){J&&l(y)}}}function Fo(_l){let y,E,J,Tl,W,xl,q,Aa="In this tutorial you will go through the full Human-in-the-Loop Sample-Efficient Reinforcement Learning (HIL-SERL) workflow using LeRobot. You will master training a policy with RL on a real robot in just a few hours.",$l,N,La="HIL-SERL is a sample-efficient reinforcement learning algorithm that combines human demonstrations with online learning and human interventions. The approach starts from a small set of human demonstrations, uses them to train a reward classifier, and then employs an actor-learner architecture where humans can intervene during policy execution to guide exploration and correct unsafe behaviors. In this tutorial, you’ll use a gamepad to provide interventions and control the robot during the learning process.",Al,G,Za="It combines three key ingredients: 1. <strong>Offline demonstrations &amp; reward classifier:</strong> a handful of human-teleop episodes plus a vision-based success detector give the policy a shaped starting point. 2. <strong>On-robot actor / learner loop with human interventions:</strong> a distributed Soft Actor Critic (SAC) learner updates the policy while an actor explores on the physical robot; the human can jump in at any time to correct dangerous or unproductive behaviour. 3. <strong>Safety &amp; efficiency tools:</strong> joint/end-effector (EE) bounds, crop region of interest (ROI) preprocessing and WandB monitoring keep the data useful and the hardware safe.",Ll,R,ka="Together these elements let HIL-SERL reach near-perfect task success and faster cycle times than imitation-only baselines.",Zl,U,Ha='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/lerobot/hilserl-main-figure.png" alt="HIL-SERL workflow" title="HIL-SERL workflow" width="100%"/>',kl,v,Ba="<i>HIL-SERL workflow, Luo et al. 2024</i>",Hl,Q,Ea="This guide provides step-by-step instructions for training a robot policy using LeRobot’s HilSerl implementation to train on a real robot.",Bl,S,El,X,Wa="<li>A gamepad (recommended) or keyboard to control the robot</li> <li>A Nvidia GPU</li> <li>A real robot with a follower and leader arm (optional if you use the keyboard or the gamepad)</li> <li>A URDF file for the robot for the kinematics package (check <code>lerobot/common/model/kinematics.py</code>)</li>",Wl,z,ql,V,qa="One can use HIL-SERL to train on a variety of manipulation tasks. Some recommendations:",Nl,Y,Na="<li>Start with a simple task to understand how the system works.<ul><li>Push cube to a goal region</li> <li>Pick and lift cube with the gripper</li></ul></li> <li>Avoid extremely long horizon tasks. Focus on tasks that can be completed in 5-10 seconds.</li> <li>Once you have a good idea of how the system works, you can try more complex tasks and longer horizons.<ul><li>Pick and place cube</li> <li>Bimanual tasks to pick objects with two arms</li> <li>Hand-over tasks to transfer objects from one arm to another</li> <li>Go crazy!</li></ul></li>",Gl,P,Rl,F,Ga="To install LeRobot with HIL-SERL, you need to install the <code>hilserl</code> extra.",Ql,D,Sl,O,Xl,K,zl,tt,Ra="The training process begins with proper configuration for the HILSerl environment. The configuration class of interest is <code>HILSerlRobotEnvConfig</code> in <code>lerobot/envs/configs.py</code>. Which is defined as:",Vl,et,Yl,lt,Pl,st,Qa="Before collecting demonstrations, you need to determine the appropriate operational bounds for your robot.",Fl,nt,Sa="This helps simplify the problem of learning on the real robot in two ways: 1) by limiting the robot’s operational space to a specific region that solves the task and avoids unnecessary or unsafe exploration, and 2) by allowing training in end-effector space rather than joint space. Empirically, learning in joint space for reinforcement learning in manipulation is often a harder problem - some tasks are nearly impossible to learn in joint space but become learnable when the action space is transformed to end-effector coordinates.",Dl,at,Xa="<strong>Using find_joint_limits.py</strong>",Ol,it,za=`This script helps you find the safe operational bounds for your robot’s end-effector. Given that you have a follower and leader arm, you can use the script to find the bounds for the follower arm that will be applied during training.
Bounding the action space will reduce the redundant exploration of the agent and guarantees safety.`,Kl,ot,ts,pt,Va="<strong>Workflow</strong>",es,g,wl,Ya="Run the script and move the robot through the space that solves the task",Ja,Jl,ga,rt,ba,gl,Pa="Use these values in the configuration of your teleoperation device (TeleoperatorConfig) under the <code>end_effector_bounds</code> field",ls,ct,Fa="<strong>Example Configuration</strong>",ss,ut,ns,Mt,as,mt,Da="With the bounds defined, you can safely collect demonstrations for training. Training RL with off-policy algorithm allows us to use offline datasets collected in order to improve the efficiency of the learning process.",is,ht,Oa="<strong>Setting Up Record Mode</strong>",os,dt,Ka='Create a configuration file for recording demonstrations (or edit an existing one like <a href="https://huggingface.co/datasets/aractingi/lerobot-example-config-files/blob/main/env_config_so100.json" rel="nofollow">env_config_so100.json</a>):',ps,ft,ti="<li>Set <code>mode</code> to <code>&quot;record&quot;</code></li> <li>Specify a unique <code>repo_id</code> for your dataset (e.g., “username/task_name”)</li> <li>Set <code>num_episodes</code> to the number of demonstrations you want to collect</li> <li>Set <code>crop_params_dict</code> to <code>null</code> initially (we’ll determine crops later)</li> <li>Configure <code>robot</code>, <code>cameras</code>, and other hardware settings</li>",rs,yt,ei="Example configuration section:",cs,jt,us,Tt,Ms,wt,li=`Along with your robot, you will need a teleoperation device to control it in order to collect datasets of your task and perform interventions during the online training.
We support using a gamepad or a keyboard or the leader arm of the robot.`,ms,Jt,si="HIL-Serl learns actions in the end-effector space of the robot. Therefore, the teleoperation will control the end-effector’s x,y,z displacements.",hs,gt,ni="For that we need to define a version of the robot that takes actions in the end-effector space. Check the robot class <code>SO100FollowerEndEffector</code> and its configuration <code>SO100FollowerEndEffectorConfig</code> for the default parameters related to the end-effector space.",ds,bt,fs,Ut,ai="The <code>Teleoperator</code> defines the teleoperation device. You can check the list of available teleoperators in <code>lerobot/teleoperators</code>.",ys,vt,ii="<strong>Setting up the Gamepad</strong>",js,Ct,oi="The gamepad provides a very convenient way to control the robot and the episode state.",Ts,It,pi="To setup the gamepad, you need to set the <code>control_mode</code> to <code>&quot;gamepad&quot;</code> and define the <code>teleop</code> section in the configuration file.",ws,_t,Js,C,ri='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/lerobot/gamepad_guide.jpg?raw=true" alt="Figure shows the control mappings on a Logitech gamepad." title="Gamepad Control Mapping" width="100%"/>',gs,I,ci="<i>Gamepad button mapping for robot control and episode management</i>",bs,xt,ui="<strong>Setting up the SO101 leader</strong>",Us,$t,Mi="The SO101 leader arm has reduced gears that allows it to move and track the follower arm during exploration. Therefore, taking over is much smoother than the gearless SO100.",vs,At,mi="To setup the SO101 leader, you need to set the <code>control_mode</code> to <code>&quot;leader&quot;</code> and define the <code>teleop</code> section in the configuration file.",Cs,Lt,Is,Zt,hi=`In order to annotate the success/failure of the episode, <strong>you will need</strong> to use a keyboard to press <code>s</code> for success, <code>esc</code> for failure.
During the online training, press <code>space</code> to take over the policy and <code>space</code> again to give the control back to the policy.`,_s,kt,di='<summary><strong>Video: SO101 leader teleoperation</strong></summary> <div class="video-container"><video controls="" width="600"><source src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/lerobot/so101_leader_tutorial.mp4" type="video/mp4"/></video></div> <p align="center"><i>SO101 leader teleoperation example, the leader tracks the follower, press `space` to intervene</i></p>',xs,Ht,fi="<strong>Recording Demonstrations</strong>",$s,Bt,yi='Start the recording process, an example of the config file can be found <a href="https://huggingface.co/datasets/aractingi/lerobot-example-config-files/blob/main/env_config_so100.json" rel="nofollow">here</a>:',As,Et,Ls,Wt,ji="During recording:",Zs,qt,Ti="<li>The robot will reset to the initial position defined in the configuration file <code>fixed_reset_joint_positions</code></li> <li>Complete the task successfully</li> <li>The episode ends with a reward of 1 when you press the “success” button</li> <li>If the time limit is reached, or the fail button is pressed, the episode ends with a reward of 0</li> <li>You can rerecord an episode by pressing the “rerecord” button</li> <li>The process automatically continues to the next episode</li> <li>After recording all episodes, the dataset is pushed to the Hugging Face Hub (optional) and saved locally</li>",ks,Nt,Hs,Gt,wi=`After collecting demonstrations, process them to determine optimal camera crops.
Reinforcement learning is sensitive to background distractions, so it is important to crop the images to the relevant workspace area.`,Bs,Rt,Ji="Visual RL algorithms learn directly from pixel inputs, making them vulnerable to irrelevant visual information. Background elements like changing lighting, shadows, people moving, or objects outside the workspace can confuse the learning process. Good ROI selection should:",Es,Qt,gi="<li>Include only the essential workspace where the task happens</li> <li>Capture the robot’s end-effector and all objects involved in the task</li> <li>Exclude unnecessary background elements and distractions</li>",Ws,St,bi="Note: If you already know the crop parameters, you can skip this step and just set the <code>crop_params_dict</code> in the configuration file during recording.",qs,Xt,Ui="<strong>Determining Crop Parameters</strong>",Ns,zt,vi="Use the <code>crop_dataset_roi.py</code> script to interactively select regions of interest in your camera images:",Gs,Vt,Rs,Yt,Ci="<li>For each camera view, the script will display the first frame</li> <li>Draw a rectangle around the relevant workspace area</li> <li>Press ‘c’ to confirm the selection</li> <li>Repeat for all camera views</li> <li>The script outputs cropping parameters and creates a new cropped dataset</li>",Qs,Pt,Ii="Example output:",Ss,Ft,Xs,_,_i='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/lerobot/crop_dataset.gif" width="600"/>',zs,x,xi="<i>Interactive cropping tool for selecting regions of interest</i>",Vs,Dt,$i="<strong>Updating Configuration</strong>",Ys,Ot,Ai="Add these crop parameters to your training configuration:",Ps,Kt,Fs,te,Li="<strong>Recommended image resolution</strong>",Ds,ee,Zi="Most vision-based policies have been validated on square inputs of either <strong>128×128</strong> (default) or <strong>64×64</strong> pixels. We therefore advise setting the resize_size parameter to [128, 128] – or [64, 64] if you need to save GPU memory and bandwidth. Other resolutions are possible but have not been extensively tested.",Os,le,Ks,se,ki="The reward classifier plays an important role in the HIL-SERL workflow by automating reward assignment and automatically detecting episode success. Instead of manually defining reward functions or relying on human feedback for every timestep, the reward classifier learns to predict success/failure from visual observations. This enables the RL algorithm to learn efficiently by providing consistent and automated reward signals based on the robot’s camera inputs.",tn,ne,Hi="This guide explains how to train a reward classifier for human-in-the-loop reinforcement learning implementation of LeRobot. Reward classifiers learn to predict the reward value given a state which can be used in an RL setup to train a policy.",en,ae,Bi="<strong>Note</strong>: Training a reward classifier is optional. You can start the first round of RL experiments by annotating the success manually with your gamepad or keyboard device.",ln,ie,Ei="The reward classifier implementation in <code>modeling_classifier.py</code> uses a pretrained vision model to process the images. It can output either a single value for binary rewards to predict success/fail cases or multiple values for multi-class settings.",sn,oe,Wi="<strong>Collecting a Dataset for the reward classifier</strong>",nn,pe,qi="Before training, you need to collect a dataset with labeled examples. The <code>record_dataset</code> function in <code>gym_manipulator.py</code> enables the process of collecting a dataset of observations, actions, and rewards.",an,re,Ni="To collect a dataset, you need to modify some parameters in the environment configuration based on HILSerlRobotEnvConfig.",on,ce,pn,ue,Gi="<strong>Key Parameters for Data Collection</strong>",rn,Me,Ri="<li><strong>mode</strong>: set it to <code>&quot;record&quot;</code> to collect a dataset</li> <li><strong>repo_id</strong>: <code>&quot;hf_username/dataset_name&quot;</code>, name of the dataset and repo on the hub</li> <li><strong>num_episodes</strong>: Number of episodes to record</li> <li><strong>number_of_steps_after_success</strong>: Number of additional frames to record after a success (reward=1) is detected</li> <li><strong>fps</strong>: Number of frames per second to record</li> <li><strong>push_to_hub</strong>: Whether to push the dataset to the hub</li>",cn,me,Qi="The <code>number_of_steps_after_success</code> parameter is crucial as it allows you to collect more positive examples. When a success is detected, the system will continue recording for the specified number of steps while maintaining the reward=1 label. Otherwise, there won’t be enough states in the dataset labeled to 1 to train a good classifier.",un,he,Si="Example configuration section for data collection:",Mn,de,mn,fe,Xi="<strong>Reward Classifier Configuration</strong>",hn,ye,zi="The reward classifier is configured using <code>configuration_classifier.py</code>. Here are the key parameters:",dn,je,Vi="<li><strong>model_name</strong>: Base model architecture (e.g., we mainly use <code>&quot;helper2424/resnet10&quot;</code>)</li> <li><strong>model_type</strong>: <code>&quot;cnn&quot;</code> or <code>&quot;transformer&quot;</code></li> <li><strong>num_cameras</strong>: Number of camera inputs</li> <li><strong>num_classes</strong>: Number of output classes (typically 2 for binary success/failure)</li> <li><strong>hidden_dim</strong>: Size of hidden representation</li> <li><strong>dropout_rate</strong>: Regularization parameter</li> <li><strong>learning_rate</strong>: Learning rate for optimizer</li>",fn,Te,Yi='Example configuration for training the <a href="https://huggingface.co/datasets/aractingi/lerobot-example-config-files/blob/main/reward_classifier_train_config.json" rel="nofollow">reward classifier</a>:',yn,we,jn,Je,Pi="<strong>Training the Classifier</strong>",Tn,ge,Fi="To train the classifier, use the <code>train.py</code> script with your configuration:",wn,be,Jn,Ue,Di="<strong>Deploying and Testing the Model</strong>",gn,ve,Oi="To use your trained reward classifier, configure the <code>HILSerlRobotEnvConfig</code> to use your model:",bn,Ce,Un,Ie,Ki="or set the argument in the json config file.",vn,_e,Cn,xe,to="Run <code>gym_manipulator.py</code> to test the model.",In,$e,_n,Ae,eo="The reward classifier will automatically provide rewards based on the visual input from the robot’s cameras.",xn,Le,lo="<strong>Example Workflow for training the reward classifier</strong>",$n,T,bl,so=`<p><strong>Create the configuration files</strong>:
Create the necessary json configuration files for the reward classifier and the environment. Check the examples <a href="https://huggingface.co/datasets/aractingi/lerobot-example-config-files/tree/main" rel="nofollow">here</a>.</p>`,Ua,Ze,Ul,no="<strong>Collect a dataset</strong>:",va,ke,Ca,He,vl,ao="<strong>Train the classifier</strong>:",Ia,Be,_a,Ee,Cl,io="<strong>Test the classifier</strong>:",xa,We,An,qe,Ln,Ne,oo="The LeRobot system uses a distributed actor-learner architecture for training. This architecture decouples robot interactions from the learning process, allowing them to run concurrently without blocking each other. The actor server handles robot observations and actions, sending interaction data to the learner server. The learner server performs gradient descent and periodically updates the actor’s policy weights. You will need to start two processes: a learner and an actor.",Zn,Ge,po="<strong>Configuration Setup</strong>",kn,Re,ro='Create a training configuration file (example available <a href="https://huggingface.co/datasets/aractingi/lerobot-example-config-files/blob/main/train_config_hilserl_so100.json" rel="nofollow">here</a>). The training config is based on the main <code>TrainRLServerPipelineConfig</code> class in <code>lerobot/configs/train.py</code>.',Hn,Qe,co='<li>Configure the policy settings (<code>type=&quot;sac&quot;</code>, <code>device</code>, etc.)</li> <li>Set <code>dataset</code> to your cropped dataset</li> <li>Configure environment settings with crop parameters</li> <li>Check the other parameters related to SAC in <a href="https://github.com/huggingface/lerobot/blob/19bb621a7d0a31c20cd3cc08b1dbab68d3031454/lerobot/policies/sac/configuration_sac.py#L79" rel="nofollow">configuration_sac.py</a>.</li> <li>Verify that the <code>policy</code> config is correct with the right <code>input_features</code> and <code>output_features</code> for your task.</li>',Bn,Se,uo="<strong>Starting the Learner</strong>",En,Xe,Mo="First, start the learner server process:",Wn,ze,qn,Ve,mo="The learner:",Nn,Ye,ho="<li>Initializes the policy network</li> <li>Prepares replay buffers</li> <li>Opens a <code>gRPC</code> server to communicate with actors</li> <li>Processes transitions and updates the policy</li>",Gn,Pe,fo="<strong>Starting the Actor</strong>",Rn,Fe,yo="In a separate terminal, start the actor process with the same configuration:",Qn,De,Sn,Oe,jo="The actor:",Xn,Ke,To="<li>Connects to the learner via <code>gRPC</code></li> <li>Initializes the environment</li> <li>Execute rollouts of the policy to collect experience</li> <li>Sends transitions to the learner</li> <li>Receives updated policy parameters</li>",zn,tl,wo="<strong>Training Flow</strong>",Vn,el,Jo="The training proceeds automatically:",Yn,ll,go="<li>The actor executes the policy in the environment</li> <li>Transitions are collected and sent to the learner</li> <li>The learner updates the policy based on these transitions</li> <li>Updated policy parameters are sent back to the actor</li> <li>The process continues until the specified step limit is reached</li>",Pn,sl,bo="<strong>Human in the Loop</strong>",Fn,nl,Uo="<li>The key to learning efficiently is to have human interventions to provide corrective feedback and completing the task to aide the policy learning and exploration.</li> <li>To perform human interventions, you can press the upper right trigger button on the gamepad (or the <code>space</code> key on the keyboard). This will pause the policy actions and allow you to take over.</li> <li>A successful experiment is one where the human has to intervene at the start but then reduces the amount of interventions as the policy improves. You can monitor the intervention rate in the <code>wandb</code> dashboard.</li>",Dn,$,vo='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/lerobot/hil_effect.png?raw=true" alt="Figure shows the control mappings on a Logitech gamepad." title="Gamepad Control Mapping" width="100%"/>',On,A,Co="<i>Example showing how human interventions help guide policy learning over time</i>",Kn,al,Io="<li>The figure shows the plot of the episodic reward over interaction step. The figure shows the effect of human interventions on the policy learning.</li> <li>The orange curve is an experiment without any human interventions. While the pink and blue curves are experiments with human interventions.</li> <li>We can observe that the number of steps where the policy starts achieving the maximum reward is cut by a quarter when human interventions are present.</li>",ta,il,_o="<strong>Monitoring and Debugging</strong>",ea,ol,xo='If you have <code>wandb.enable</code> set to <code>true</code> in your configuration, you can monitor training progress in real-time through the <a href="https://wandb.ai/site/" rel="nofollow">Weights &amp; Biases</a> dashboard.',la,pl,sa,rl,$o="The learning process is very sensitive to the intervention strategy. It will takes a few runs to understand how to intervene effectively. Some tips and hints:",na,cl,Ao="<li>Allow the policy to explore for a few episodes at the start of training.</li> <li>Avoid intervening for long periods of time. Try to intervene in situation to correct the robot’s behaviour when it goes off track.</li> <li>Once the policy starts achieving the task, even if its not perfect, you can limit your interventions to simple quick actions like a simple grasping commands.</li>",aa,ul,Lo="The ideal behaviour is that your intervention rate should drop gradually during training as shown in the figure below.",ia,L,Zo='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/lerobot/intervention_rate_tutorial_rl.png?raw=true" alt="Intervention rate" title="Intervention rate during training" width="100%"/>',oa,Z,ko=`<i>Plot of the intervention rate during a training run on a pick and lift cube
    task</i>`,pa,Ml,ra,ml,Ho="Some configuration values have a disproportionate impact on training stability and speed:",ca,hl,Bo="<li><strong><code>temperature_init</code></strong> (<code>policy.temperature_init</code>) – initial entropy temperature in SAC. Higher values encourage more exploration; lower values make the policy more deterministic early on. A good starting point is <code>1e-2</code>. We observed that setting it too high can make human interventions ineffective and slow down learning.</li> <li><strong><code>policy_parameters_push_frequency</code></strong> (<code>policy.actor_learner_config.policy_parameters_push_frequency</code>) – interval in <em>seconds</em> between two weight pushes from the learner to the actor. The default is <code>4 s</code>. Decrease to <strong>1-2 s</strong> to provide fresher weights (at the cost of more network traffic); increase only if your connection is slow, as this will reduce sample efficiency.</li> <li><strong><code>storage_device</code></strong> (<code>policy.storage_device</code>) – device on which the learner keeps the policy parameters. If you have spare GPU memory, set this to <code>&quot;cuda&quot;</code> (instead of the default <code>&quot;cpu&quot;</code>). Keeping the weights on-GPU removes CPU→GPU transfer overhead and can significantly increase the number of learner updates per second.</li>",ua,dl,Eo="Congrats 🎉, you have finished this tutorial!",Ma,k,ma,fl,Wo="Paper citation:",ha,yl,da,jl,fa,Il,ya;return W=new j({props:{title:"HIL-SERL Real Robot Training Workflow Guide",local:"hil-serl-real-robot-training-workflow-guide",headingTag:"h1"}}),S=new j({props:{title:"What do I need?",local:"what-do-i-need",headingTag:"h2"}}),z=new j({props:{title:"What kind of tasks can I train?",local:"what-kind-of-tasks-can-i-train",headingTag:"h2"}}),P=new j({props:{title:"Install LeRobot with HIL-SERL",local:"install-lerobot-with-hil-serl",headingTag:"h2"}}),D=new d({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1lJTIwJTIyLiU1QmhpbHNlcmwlNUQlMjI=",highlighted:'pip install -e <span class="hljs-string">&quot;.[hilserl]&quot;</span>',wrap:!1}}),O=new j({props:{title:"Real Robot Training Workflow",local:"real-robot-training-workflow",headingTag:"h2"}}),K=new j({props:{title:"Understanding Configuration",local:"understanding-configuration",headingTag:"h3"}}),et=new d({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">HILSerlRobotEnvConfig</span>(<span class="hljs-title class_ inherited__">EnvConfig</span>):
    robot: RobotConfig | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># Main robot agent (defined in \`lerobot/robots\`)</span>
    teleop: TeleoperatorConfig | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># Teleoperator agent, e.g., gamepad or leader arm, (defined in \`lerobot/teleoperators\`)</span>
    wrapper: EnvTransformConfig | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># Environment wrapper settings; check \`lerobot/scripts/server/gym_manipulator.py\`</span>
    fps: <span class="hljs-built_in">int</span> = <span class="hljs-number">10</span>    <span class="hljs-comment"># Control frequency</span>
    name: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;real_robot&quot;</span>    <span class="hljs-comment"># Environment name</span>
    mode: <span class="hljs-built_in">str</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># &quot;record&quot;, &quot;replay&quot;, or None (for training)</span>
    repo_id: <span class="hljs-built_in">str</span> | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># LeRobot dataset repository ID</span>
    dataset_root: <span class="hljs-built_in">str</span> | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># Local dataset root (optional)</span>
    task: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;&quot;</span>    <span class="hljs-comment"># Task identifier</span>
    num_episodes: <span class="hljs-built_in">int</span> = <span class="hljs-number">10</span>    <span class="hljs-comment"># Number of episodes for recording</span>
    episode: <span class="hljs-built_in">int</span> = <span class="hljs-number">0</span>    <span class="hljs-comment"># episode index for replay</span>
    device: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;cuda&quot;</span>    <span class="hljs-comment"># Compute device</span>
    push_to_hub: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">True</span>    <span class="hljs-comment"># Whether to push the recorded datasets to Hub</span>
    pretrained_policy_name_or_path: <span class="hljs-built_in">str</span> | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># For policy loading</span>
    reward_classifier_pretrained_path: <span class="hljs-built_in">str</span> | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># For reward model</span>
    number_of_steps_after_success: <span class="hljs-built_in">int</span> = <span class="hljs-number">0</span>    <span class="hljs-comment"># For reward classifier, collect more positive examples after a success to train a classifier</span>`,wrap:!1}}),lt=new j({props:{title:"Finding Robot Workspace Bounds",local:"finding-robot-workspace-bounds",headingTag:"h3"}}),ot=new d({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnNjcmlwdHMuZmluZF9qb2ludF9saW1pdHMlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXJvYm90LnR5cGUlM0RzbzEwMF9mb2xsb3dlciUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcm9ib3QucG9ydCUzRCUyRmRldiUyRnR0eS51c2Jtb2RlbTU4NzYwNDMxNTQxJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1yb2JvdC5pZCUzRGJsYWNrJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS10ZWxlb3AudHlwZSUzRHNvMTAwX2xlYWRlciUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tdGVsZW9wLnBvcnQlM0QlMkZkZXYlMkZ0dHkudXNibW9kZW01ODc2MDQzMTU1MSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tdGVsZW9wLmlkJTNEYmx1ZQ==",highlighted:`python -m lerobot.scripts.find_joint_limits \\
    --robot.type=so100_follower \\
    --robot.port=/dev/tty.usbmodem58760431541 \\
    --robot.id=black \\
    --teleop.type=so100_leader \\
    --teleop.port=/dev/tty.usbmodem58760431551 \\
    --teleop.id=blue`,wrap:!1}}),rt=new d({props:{code:"TWF4JTIwZWUlMjBwb3NpdGlvbiUyMCU1QjAuMjQxNyUyMDAuMjAxMiUyMDAuMTAyNyU1RCUwQU1pbiUyMGVlJTIwcG9zaXRpb24lMjAlNUIwLjE2NjMlMjAtMC4wODIzJTIwMC4wMzM2JTVEJTBBTWF4JTIwam9pbnQlMjBwb3NpdGlvbnMlMjAlNUItMjAuMCUyQyUyMC0yMC4wJTJDJTIwLTIwLjAlMkMlMjAtMjAuMCUyQyUyMC0yMC4wJTJDJTIwLTIwLjAlNUQlMEFNaW4lMjBqb2ludCUyMHBvc2l0aW9ucyUyMCU1QjUwLjAlMkMlMjA1MC4wJTJDJTIwNTAuMCUyQyUyMDUwLjAlMkMlMjA1MC4wJTJDJTIwNTAuMCU1RA==",highlighted:`Max ee position [0.2417 0.2012 0.1027]
Min ee position [0.1663 <span class="hljs-string">-0</span>.0823 0.0336]
Max joint positions [<span class="hljs-string">-20</span>.0, <span class="hljs-string">-20</span>.0, <span class="hljs-string">-20</span>.0, <span class="hljs-string">-20</span>.0, <span class="hljs-string">-20</span>.0, <span class="hljs-string">-20</span>.0]
Min joint positions [50.0, 50.0, 50.0, 50.0, 50.0, 50.0]`,wrap:!1}}),ut=new d({props:{code:"JTIyZW5kX2VmZmVjdG9yX2JvdW5kcyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMm1heCUyMiUzQSUyMCU1QjAuMjQlMkMlMjAwLjIwJTJDJTIwMC4xMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMm1pbiUyMiUzQSUyMCU1QjAuMTYlMkMlMjAtMC4wOCUyQyUyMDAuMDMlNUQlMEElN0Q=",highlighted:`<span class="hljs-attr">&quot;end_effector_bounds&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;max&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">0.24</span><span class="hljs-punctuation">,</span> <span class="hljs-number">0.20</span><span class="hljs-punctuation">,</span> <span class="hljs-number">0.10</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;min&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">0.16</span><span class="hljs-punctuation">,</span> <span class="hljs-number">-0.08</span><span class="hljs-punctuation">,</span> <span class="hljs-number">0.03</span><span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Mt=new j({props:{title:"Collecting Demonstrations",local:"collecting-demonstrations",headingTag:"h3"}}),jt=new d({props:{code:"JTIybW9kZSUyMiUzQSUyMCUyMnJlY29yZCUyMiUyQyUwQSUyMnJlcG9faWQlMjIlM0ElMjAlMjJ1c2VybmFtZSUyRnBpY2tfbGlmdF9jdWJlJTIyJTJDJTBBJTIyZGF0YXNldF9yb290JTIyJTNBJTIwbnVsbCUyQyUwQSUyMnRhc2slMjIlM0ElMjAlMjJwaWNrX2FuZF9saWZ0JTIyJTJDJTBBJTIybnVtX2VwaXNvZGVzJTIyJTNBJTIwMTUlMkMlMEElMjJlcGlzb2RlJTIyJTNBJTIwMCUyQyUwQSUyMnB1c2hfdG9faHViJTIyJTNBJTIwdHJ1ZQ==",highlighted:`<span class="hljs-attr">&quot;mode&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;record&quot;</span><span class="hljs-punctuation">,</span>
<span class="hljs-attr">&quot;repo_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;username/pick_lift_cube&quot;</span><span class="hljs-punctuation">,</span>
<span class="hljs-attr">&quot;dataset_root&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
<span class="hljs-attr">&quot;task&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;pick_and_lift&quot;</span><span class="hljs-punctuation">,</span>
<span class="hljs-attr">&quot;num_episodes&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">15</span><span class="hljs-punctuation">,</span>
<span class="hljs-attr">&quot;episode&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
<span class="hljs-attr">&quot;push_to_hub&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>`,wrap:!1}}),Tt=new j({props:{title:"Using a Teleoperation Device",local:"using-a-teleoperation-device",headingTag:"h3"}}),bt=new d({props:{code:"Y2xhc3MlMjBTTzEwMEZvbGxvd2VyRW5kRWZmZWN0b3JDb25maWcoU08xMDBGb2xsb3dlckNvbmZpZyklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJDb25maWd1cmF0aW9uJTIwZm9yJTIwdGhlJTIwU08xMDBGb2xsb3dlckVuZEVmZmVjdG9yJTIwcm9ib3QuJTIyJTIyJTIyJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwRGVmYXVsdCUyMGJvdW5kcyUyMGZvciUyMHRoZSUyMGVuZC1lZmZlY3RvciUyMHBvc2l0aW9uJTIwKGluJTIwbWV0ZXJzKSUwQSUyMCUyMCUyMCUyMGVuZF9lZmZlY3Rvcl9ib3VuZHMlM0ElMjBkaWN0JTVCc3RyJTJDJTIwbGlzdCU1QmZsb2F0JTVEJTVEJTIwJTNEJTIwZmllbGQoJTIwJTIzJTIwYm91bmRzJTIwZm9yJTIwdGhlJTIwZW5kLWVmZmVjdG9yJTIwaW4lMjB4JTJDeSUyQ3olMjBkaXJlY3Rpb24lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkZWZhdWx0X2ZhY3RvcnklM0RsYW1iZGElM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtaW4lMjIlM0ElMjAlNUItMS4wJTJDJTIwLTEuMCUyQyUyMC0xLjAlNUQlMkMlMjAlMjAlMjMlMjBtaW4lMjB4JTJDJTIweSUyQyUyMHolMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtYXglMjIlM0ElMjAlNUIxLjAlMkMlMjAxLjAlMkMlMjAxLjAlNUQlMkMlMjAlMjAlMjMlMjBtYXglMjB4JTJDJTIweSUyQyUyMHolMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwbWF4X2dyaXBwZXJfcG9zJTNBJTIwZmxvYXQlMjAlM0QlMjA1MCUyMCUyMyUyMG1heGltdW0lMjBncmlwcGVyJTIwcG9zaXRpb24lMjB0aGF0JTIwdGhlJTIwZ3JpcHBlciUyMHdpbGwlMjBiZSUyMG9wZW4lMjBhdCUwQSUwQSUyMCUyMCUyMCUyMGVuZF9lZmZlY3Rvcl9zdGVwX3NpemVzJTNBJTIwZGljdCU1QnN0ciUyQyUyMGZsb2F0JTVEJTIwJTNEJTIwZmllbGQoJTIwJTIzJTIwbWF4aW11bSUyMHN0ZXAlMjBzaXplJTIwZm9yJTIwdGhlJTIwZW5kLWVmZmVjdG9yJTIwaW4lMjB4JTJDeSUyQ3olMjBkaXJlY3Rpb24lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkZWZhdWx0X2ZhY3RvcnklM0RsYW1iZGElM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ4JTIyJTNBJTIwMC4wMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnklMjIlM0ElMjAwLjAyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyeiUyMiUzQSUyMDAuMDIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAp",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">SO100FollowerEndEffectorConfig</span>(<span class="hljs-title class_ inherited__">SO100FollowerConfig</span>):
    <span class="hljs-string">&quot;&quot;&quot;Configuration for the SO100FollowerEndEffector robot.&quot;&quot;&quot;</span>

    <span class="hljs-comment"># Default bounds for the end-effector position (in meters)</span>
    end_effector_bounds: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">list</span>[<span class="hljs-built_in">float</span>]] = field( <span class="hljs-comment"># bounds for the end-effector in x,y,z direction</span>
        default_factory=<span class="hljs-keyword">lambda</span>: {
            <span class="hljs-string">&quot;min&quot;</span>: [-<span class="hljs-number">1.0</span>, -<span class="hljs-number">1.0</span>, -<span class="hljs-number">1.0</span>],  <span class="hljs-comment"># min x, y, z</span>
            <span class="hljs-string">&quot;max&quot;</span>: [<span class="hljs-number">1.0</span>, <span class="hljs-number">1.0</span>, <span class="hljs-number">1.0</span>],  <span class="hljs-comment"># max x, y, z</span>
        }
    )

    max_gripper_pos: <span class="hljs-built_in">float</span> = <span class="hljs-number">50</span> <span class="hljs-comment"># maximum gripper position that the gripper will be open at</span>

    end_effector_step_sizes: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">float</span>] = field( <span class="hljs-comment"># maximum step size for the end-effector in x,y,z direction</span>
        default_factory=<span class="hljs-keyword">lambda</span>: {
            <span class="hljs-string">&quot;x&quot;</span>: <span class="hljs-number">0.02</span>,
            <span class="hljs-string">&quot;y&quot;</span>: <span class="hljs-number">0.02</span>,
            <span class="hljs-string">&quot;z&quot;</span>: <span class="hljs-number">0.02</span>,
        }
    )`,wrap:!1}}),_t=new d({props:{code:"JTIwJTIwJTIwJTIwJTIydGVsZW9wJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMmdhbWVwYWQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ1c2VfZ3JpcHBlciUyMiUzQSUyMHRydWUlMEElMjAlMjAlMjAlMjAlN0QlMkM=",highlighted:`    <span class="hljs-attr">&quot;teleop&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;gamepad&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;use_gripper&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>`,wrap:!1}}),Lt=new d({props:{code:"JTIwJTIwJTIwJTIwJTIydGVsZW9wJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMnNvMTAxX2xlYWRlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBvcnQlMjIlM0ElMjAlMjIlMkZkZXYlMkZ0dHkudXNibW9kZW01ODVBMDA3NzkyMSUyMiUyQyUyMCUyMyUyMGNoZWNrJTIweW91ciUyMHBvcnQlMjBudW1iZXIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ1c2VfZGVncmVlcyUyMiUzQSUyMHRydWUlMEElMjAlMjAlMjAlMjAlN0QlMkM=",highlighted:`    <span class="hljs-attr">&quot;teleop&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;so101_leader&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;port&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;/dev/tty.usbmodem585A0077921&quot;</span><span class="hljs-punctuation">,</span> # check your port number
        <span class="hljs-attr">&quot;use_degrees&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>`,wrap:!1}}),Et=new d({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnNjcmlwdHMucmwuZ3ltX21hbmlwdWxhdG9yJTIwLS1jb25maWdfcGF0aCUyMHNyYyUyRmxlcm9ib3QlMkZjb25maWdzJTJGZW52X2NvbmZpZ19zbzEwMC5qc29u",highlighted:"python -m lerobot.scripts.rl.gym_manipulator --config_path src/lerobot/configs/env_config_so100.json",wrap:!1}}),Nt=new j({props:{title:"Processing the Dataset",local:"processing-the-dataset",headingTag:"h3"}}),Vt=new d({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnNjcmlwdHMucmwuY3JvcF9kYXRhc2V0X3JvaSUyMC0tcmVwby1pZCUyMHVzZXJuYW1lJTJGcGlja19saWZ0X2N1YmU=",highlighted:"python -m lerobot.scripts.rl.crop_dataset_roi --repo-id username/pick_lift_cube",wrap:!1}}),Ft=new d({props:{code:"U2VsZWN0ZWQlMjBSZWN0YW5ndWxhciUyMFJlZ2lvbnMlMjBvZiUyMEludGVyZXN0JTIwKHRvcCUyQyUyMGxlZnQlMkMlMjBoZWlnaHQlMkMlMjB3aWR0aCklM0ElMEFvYnNlcnZhdGlvbi5pbWFnZXMuc2lkZSUzQSUyMCU1QjE4MCUyQyUyMDIwNyUyQyUyMDE4MCUyQyUyMDIwMCU1RCUwQW9ic2VydmF0aW9uLmltYWdlcy5mcm9udCUzQSUyMCU1QjE4MCUyQyUyMDI1MCUyQyUyMDEyMCUyQyUyMDE1MCU1RA==",highlighted:`Selected Rectangular Regions of Interest (<span class="hljs-attribute">top</span>, left, height, width):
observation<span class="hljs-selector-class">.images</span><span class="hljs-selector-class">.side</span>: <span class="hljs-selector-attr">[180, 207, 180, 200]</span>
observation<span class="hljs-selector-class">.images</span><span class="hljs-selector-class">.front</span>: <span class="hljs-selector-attr">[180, 250, 120, 150]</span>`,wrap:!1}}),Kt=new d({props:{code:"JTIyY3JvcF9wYXJhbXNfZGljdCUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMm9ic2VydmF0aW9uLmltYWdlcy5zaWRlJTIyJTNBJTIwJTVCMTgwJTJDJTIwMjA3JTJDJTIwMTgwJTJDJTIwMjAwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyb2JzZXJ2YXRpb24uaW1hZ2VzLmZyb250JTIyJTNBJTIwJTVCMTgwJTJDJTIwMjUwJTJDJTIwMTIwJTJDJTIwMTUwJTVEJTBBJTdEJTJDJTBBJTIycmVzaXplX3NpemUlMjIlM0ElMjAlNUIxMjglMkMlMjAxMjglNUQ=",highlighted:`<span class="hljs-attr">&quot;crop_params_dict&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;observation.images.side&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">180</span><span class="hljs-punctuation">,</span> <span class="hljs-number">207</span><span class="hljs-punctuation">,</span> <span class="hljs-number">180</span><span class="hljs-punctuation">,</span> <span class="hljs-number">200</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;observation.images.front&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">180</span><span class="hljs-punctuation">,</span> <span class="hljs-number">250</span><span class="hljs-punctuation">,</span> <span class="hljs-number">120</span><span class="hljs-punctuation">,</span> <span class="hljs-number">150</span><span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
<span class="hljs-attr">&quot;resize_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">128</span><span class="hljs-punctuation">,</span> <span class="hljs-number">128</span><span class="hljs-punctuation">]</span>`,wrap:!1}}),le=new j({props:{title:"Training a Reward Classifier",local:"training-a-reward-classifier",headingTag:"h3"}}),ce=new d({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnNjcmlwdHMucmwuZ3ltX21hbmlwdWxhdG9yJTIwLS1jb25maWdfcGF0aCUyMHNyYyUyRmxlcm9ib3QlMkZjb25maWdzJTJGcmV3YXJkX2NsYXNzaWZpZXJfdHJhaW5fY29uZmlnLmpzb24=",highlighted:"python -m lerobot.scripts.rl.gym_manipulator --config_path src/lerobot/configs/reward_classifier_train_config.json",wrap:!1}}),de=new d({props:{code:"JTdCJTBBJTIwJTIwJTIybW9kZSUyMiUzQSUyMCUyMnJlY29yZCUyMiUyQyUwQSUyMCUyMCUyMnJlcG9faWQlMjIlM0ElMjAlMjJoZl91c2VybmFtZSUyRmRhdGFzZXRfbmFtZSUyMiUyQyUwQSUyMCUyMCUyMmRhdGFzZXRfcm9vdCUyMiUzQSUyMCUyMmRhdGElMkZ5b3VyX2RhdGFzZXQlMjIlMkMlMEElMjAlMjAlMjJudW1fZXBpc29kZXMlMjIlM0ElMjAyMCUyQyUwQSUyMCUyMCUyMnB1c2hfdG9faHViJTIyJTNBJTIwdHJ1ZSUyQyUwQSUyMCUyMCUyMmZwcyUyMiUzQSUyMDEwJTJDJTBBJTIwJTIwJTIybnVtYmVyX29mX3N0ZXBzX2FmdGVyX3N1Y2Nlc3MlMjIlM0ElMjAxNSUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;mode&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;record&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;repo_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;hf_username/dataset_name&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;dataset_root&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;data/your_dataset&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;num_episodes&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">20</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;push_to_hub&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;fps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">10</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;number_of_steps_after_success&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">15</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),we=new d({props:{code:"JTdCJTBBJTIwJTIwJTIycG9saWN5JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMnJld2FyZF9jbGFzc2lmaWVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIybW9kZWxfbmFtZSUyMiUzQSUyMCUyMmhlbHBlcjI0MjQlMkZyZXNuZXQxMCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMm1vZGVsX3R5cGUlMjIlM0ElMjAlMjJjbm4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJudW1fY2FtZXJhcyUyMiUzQSUyMDIlMkMlMEElMjAlMjAlMjAlMjAlMjJudW1fY2xhc3NlcyUyMiUzQSUyMDIlMkMlMEElMjAlMjAlMjAlMjAlMjJoaWRkZW5fZGltJTIyJTNBJTIwMjU2JTJDJTBBJTIwJTIwJTIwJTIwJTIyZHJvcG91dF9yYXRlJTIyJTNBJTIwMC4xJTJDJTBBJTIwJTIwJTIwJTIwJTIybGVhcm5pbmdfcmF0ZSUyMiUzQSUyMDFlLTQlMkMlMEElMjAlMjAlMjAlMjAlMjJkZXZpY2UlMjIlM0ElMjAlMjJjdWRhJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydXNlX2FtcCUyMiUzQSUyMHRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjJpbnB1dF9mZWF0dXJlcyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMm9ic2VydmF0aW9uLmltYWdlcy5mcm9udCUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJWSVNVQUwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzaGFwZSUyMiUzQSUyMCU1QjMlMkMlMjAxMjglMkMlMjAxMjglNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJvYnNlcnZhdGlvbi5pbWFnZXMuc2lkZSUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJWSVNVQUwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzaGFwZSUyMiUzQSUyMCU1QjMlMkMlMjAxMjglMkMlMjAxMjglNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;policy&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;reward_classifier&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;model_name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;helper2424/resnet10&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;model_type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cnn&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;num_cameras&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;num_classes&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;hidden_dim&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">256</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;dropout_rate&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.1</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;learning_rate&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e-4</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cuda&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;use_amp&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;input_features&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;observation.images.front&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;VISUAL&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;shape&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">3</span><span class="hljs-punctuation">,</span> <span class="hljs-number">128</span><span class="hljs-punctuation">,</span> <span class="hljs-number">128</span><span class="hljs-punctuation">]</span>
      <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;observation.images.side&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;VISUAL&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;shape&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">3</span><span class="hljs-punctuation">,</span> <span class="hljs-number">128</span><span class="hljs-punctuation">,</span> <span class="hljs-number">128</span><span class="hljs-punctuation">]</span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),be=new d({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnNjcmlwdHMudHJhaW4lMjAtLWNvbmZpZ19wYXRoJTIwcGF0aCUyRnRvJTJGcmV3YXJkX2NsYXNzaWZpZXJfdHJhaW5fY29uZmlnLmpzb24=",highlighted:"python -m lerobot.scripts.train --config_path path/to/reward_classifier_train_config.json",wrap:!1}}),Ce=new d({props:{code:"ZW52X2NvbmZpZyUyMCUzRCUyMEhJTFNlcmxSb2JvdEVudkNvbmZpZyglMEElMjAlMjAlMjAlMjByZXdhcmRfY2xhc3NpZmllcl9wcmV0cmFpbmVkX3BhdGglM0QlMjJwYXRoX3RvX3lvdXJfcHJldHJhaW5lZF90cmFpbmVkX21vZGVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIzJTIwT3RoZXIlMjBlbnZpcm9ubWVudCUyMHBhcmFtZXRlcnMlMEEp",highlighted:`env_config = HILSerlRobotEnvConfig(
    reward_classifier_pretrained_path=<span class="hljs-string">&quot;path_to_your_pretrained_trained_model&quot;</span>,
    <span class="hljs-comment"># Other environment parameters</span>
)`,wrap:!1}}),_e=new d({props:{code:"JTdCJTBBJTIwJTIwJTIycmV3YXJkX2NsYXNzaWZpZXJfcHJldHJhaW5lZF9wYXRoJTIyJTNBJTIwJTIycGF0aF90b195b3VyX3ByZXRyYWluZWRfbW9kZWwlMjIlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;reward_classifier_pretrained_path&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;path_to_your_pretrained_model&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),$e=new d({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnNjcmlwdHMucmwuZ3ltX21hbmlwdWxhdG9yJTIwLS1jb25maWdfcGF0aCUyMHBhdGglMkZ0byUyRmVudl9jb25maWcuanNvbg==",highlighted:"python -m lerobot.scripts.rl.gym_manipulator --config_path path/to/env_config.json",wrap:!1}}),ke=new d({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnNjcmlwdHMucmwuZ3ltX21hbmlwdWxhdG9yJTIwLS1jb25maWdfcGF0aCUyMHNyYyUyRmxlcm9ib3QlMkZjb25maWdzJTJGZW52X2NvbmZpZy5qc29u",highlighted:"python -m lerobot.scripts.rl.gym_manipulator --config_path src/lerobot/configs/env_config.json",wrap:!1}}),Be=new d({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnNjcmlwdHMudHJhaW4lMjAtLWNvbmZpZ19wYXRoJTIwc3JjJTJGbGVyb2JvdCUyRmNvbmZpZ3MlMkZyZXdhcmRfY2xhc3NpZmllcl90cmFpbl9jb25maWcuanNvbg==",highlighted:"python -m lerobot.scripts.train --config_path src/lerobot/configs/reward_classifier_train_config.json",wrap:!1}}),We=new d({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnNjcmlwdHMucmwuZ3ltX21hbmlwdWxhdG9yJTIwLS1jb25maWdfcGF0aCUyMHNyYyUyRmxlcm9ib3QlMkZjb25maWdzJTJGZW52X2NvbmZpZy5qc29u",highlighted:"python -m lerobot.scripts.rl.gym_manipulator --config_path src/lerobot/configs/env_config.json",wrap:!1}}),qe=new j({props:{title:"Training with Actor-Learner",local:"training-with-actor-learner",headingTag:"h3"}}),ze=new d({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnNjcmlwdHMucmwubGVhcm5lciUyMC0tY29uZmlnX3BhdGglMjBzcmMlMkZsZXJvYm90JTJGY29uZmlncyUyRnRyYWluX2NvbmZpZ19oaWxzZXJsX3NvMTAwLmpzb24=",highlighted:"python -m lerobot.scripts.rl.learner --config_path src/lerobot/configs/train_config_hilserl_so100.json",wrap:!1}}),De=new d({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnNjcmlwdHMucmwuYWN0b3IlMjAtLWNvbmZpZ19wYXRoJTIwc3JjJTJGbGVyb2JvdCUyRmNvbmZpZ3MlMkZ0cmFpbl9jb25maWdfaGlsc2VybF9zbzEwMC5qc29u",highlighted:"python -m lerobot.scripts.rl.actor --config_path src/lerobot/configs/train_config_hilserl_so100.json",wrap:!1}}),pl=new j({props:{title:"Guide to Human Interventions",local:"guide-to-human-interventions",headingTag:"h3"}}),Ml=new j({props:{title:"Key hyperparameters to tune",local:"key-hyperparameters-to-tune",headingTag:"h3"}}),k=new Vo({props:{warning:!1,$$slots:{default:[Po]},$$scope:{ctx:_l}}}),yl=new d({props:{code:"JTQwYXJ0aWNsZSU3Qmx1bzIwMjRwcmVjaXNlJTJDJTBBJTIwJTIwdGl0bGUlM0QlN0JQcmVjaXNlJTIwYW5kJTIwRGV4dGVyb3VzJTIwUm9ib3RpYyUyME1hbmlwdWxhdGlvbiUyMHZpYSUyMEh1bWFuLWluLXRoZS1Mb29wJTIwUmVpbmZvcmNlbWVudCUyMExlYXJuaW5nJTdEJTJDJTBBJTIwJTIwYXV0aG9yJTNEJTdCTHVvJTJDJTIwSmlhbmxhbiUyMGFuZCUyMFh1JTJDJTIwQ2hhcmxlcyUyMGFuZCUyMFd1JTJDJTIwSmVmZnJleSUyMGFuZCUyMExldmluZSUyQyUyMFNlcmdleSU3RCUyQyUwQSUyMCUyMGpvdXJuYWwlM0QlN0JhclhpdiUyMHByZXByaW50JTIwYXJYaXYlM0EyNDEwLjIxODQ1JTdEJTJDJTBBJTIwJTIweWVhciUzRCU3QjIwMjQlN0QlMEElN0Q=",highlighted:`@article{luo2024precise,
  title={Precise <span class="hljs-keyword">and </span>Dexterous Robotic Manipulation via Human-in-the-Loop Reinforcement Learning},
  author={Luo, <span class="hljs-keyword">Jianlan </span><span class="hljs-keyword">and </span>Xu, Charles <span class="hljs-keyword">and </span>Wu, <span class="hljs-keyword">Jeffrey </span><span class="hljs-keyword">and </span>Levine, Sergey},
  <span class="hljs-keyword">journal={arXiv </span>preprint arXiv:<span class="hljs-number">2410</span>.<span class="hljs-number">21845</span>},
  year={<span class="hljs-number">2024</span>}
}`,wrap:!1}}),jl=new Yo({props:{source:"https://github.com/huggingface/lerobot/blob/main/docs/source/hilserl.mdx"}}),{c(){y=i("meta"),E=n(),J=i("p"),Tl=n(),r(W.$$.fragment),xl=n(),q=i("p"),q.textContent=Aa,$l=n(),N=i("p"),N.textContent=La,Al=n(),G=i("p"),G.innerHTML=Za,Ll=n(),R=i("p"),R.textContent=ka,Zl=n(),U=i("p"),U.innerHTML=Ha,kl=n(),v=i("p"),v.innerHTML=Ba,Hl=n(),Q=i("p"),Q.textContent=Ea,Bl=n(),r(S.$$.fragment),El=n(),X=i("ul"),X.innerHTML=Wa,Wl=n(),r(z.$$.fragment),ql=n(),V=i("p"),V.textContent=qa,Nl=n(),Y=i("ul"),Y.innerHTML=Na,Gl=n(),r(P.$$.fragment),Rl=n(),F=i("p"),F.innerHTML=Ga,Ql=n(),r(D.$$.fragment),Sl=n(),r(O.$$.fragment),Xl=n(),r(K.$$.fragment),zl=n(),tt=i("p"),tt.innerHTML=Ra,Vl=n(),r(et.$$.fragment),Yl=n(),r(lt.$$.fragment),Pl=n(),st=i("p"),st.textContent=Qa,Fl=n(),nt=i("p"),nt.textContent=Sa,Dl=n(),at=i("p"),at.innerHTML=Xa,Ol=n(),it=i("p"),it.textContent=za,Kl=n(),r(ot.$$.fragment),ts=n(),pt=i("p"),pt.innerHTML=Va,es=n(),g=i("ol"),wl=i("li"),wl.textContent=Ya,Ja=n(),Jl=i("li"),ga=So(`The script will record the minimum and maximum end-effector positions and the joint angles and prints them to the console, for example:
	`),r(rt.$$.fragment),ba=n(),gl=i("li"),gl.innerHTML=Pa,ls=n(),ct=i("p"),ct.innerHTML=Fa,ss=n(),r(ut.$$.fragment),ns=n(),r(Mt.$$.fragment),as=n(),mt=i("p"),mt.textContent=Da,is=n(),ht=i("p"),ht.innerHTML=Oa,os=n(),dt=i("p"),dt.innerHTML=Ka,ps=n(),ft=i("ol"),ft.innerHTML=ti,rs=n(),yt=i("p"),yt.textContent=ei,cs=n(),r(jt.$$.fragment),us=n(),r(Tt.$$.fragment),Ms=n(),wt=i("p"),wt.textContent=li,ms=n(),Jt=i("p"),Jt.textContent=si,hs=n(),gt=i("p"),gt.innerHTML=ni,ds=n(),r(bt.$$.fragment),fs=n(),Ut=i("p"),Ut.innerHTML=ai,ys=n(),vt=i("p"),vt.innerHTML=ii,js=n(),Ct=i("p"),Ct.textContent=oi,Ts=n(),It=i("p"),It.innerHTML=pi,ws=n(),r(_t.$$.fragment),Js=n(),C=i("p"),C.innerHTML=ri,gs=n(),I=i("p"),I.innerHTML=ci,bs=n(),xt=i("p"),xt.innerHTML=ui,Us=n(),$t=i("p"),$t.textContent=Mi,vs=n(),At=i("p"),At.innerHTML=mi,Cs=n(),r(Lt.$$.fragment),Is=n(),Zt=i("p"),Zt.innerHTML=hi,_s=n(),kt=i("details"),kt.innerHTML=di,xs=n(),Ht=i("p"),Ht.innerHTML=fi,$s=n(),Bt=i("p"),Bt.innerHTML=yi,As=n(),r(Et.$$.fragment),Ls=n(),Wt=i("p"),Wt.textContent=ji,Zs=n(),qt=i("ol"),qt.innerHTML=Ti,ks=n(),r(Nt.$$.fragment),Hs=n(),Gt=i("p"),Gt.textContent=wi,Bs=n(),Rt=i("p"),Rt.textContent=Ji,Es=n(),Qt=i("ul"),Qt.innerHTML=gi,Ws=n(),St=i("p"),St.innerHTML=bi,qs=n(),Xt=i("p"),Xt.innerHTML=Ui,Ns=n(),zt=i("p"),zt.innerHTML=vi,Gs=n(),r(Vt.$$.fragment),Rs=n(),Yt=i("ol"),Yt.innerHTML=Ci,Qs=n(),Pt=i("p"),Pt.textContent=Ii,Ss=n(),r(Ft.$$.fragment),Xs=n(),_=i("p"),_.innerHTML=_i,zs=n(),x=i("p"),x.innerHTML=xi,Vs=n(),Dt=i("p"),Dt.innerHTML=$i,Ys=n(),Ot=i("p"),Ot.textContent=Ai,Ps=n(),r(Kt.$$.fragment),Fs=n(),te=i("p"),te.innerHTML=Li,Ds=n(),ee=i("p"),ee.innerHTML=Zi,Os=n(),r(le.$$.fragment),Ks=n(),se=i("p"),se.textContent=ki,tn=n(),ne=i("p"),ne.textContent=Hi,en=n(),ae=i("p"),ae.innerHTML=Bi,ln=n(),ie=i("p"),ie.innerHTML=Ei,sn=n(),oe=i("p"),oe.innerHTML=Wi,nn=n(),pe=i("p"),pe.innerHTML=qi,an=n(),re=i("p"),re.textContent=Ni,on=n(),r(ce.$$.fragment),pn=n(),ue=i("p"),ue.innerHTML=Gi,rn=n(),Me=i("ul"),Me.innerHTML=Ri,cn=n(),me=i("p"),me.innerHTML=Qi,un=n(),he=i("p"),he.textContent=Si,Mn=n(),r(de.$$.fragment),mn=n(),fe=i("p"),fe.innerHTML=Xi,hn=n(),ye=i("p"),ye.innerHTML=zi,dn=n(),je=i("ul"),je.innerHTML=Vi,fn=n(),Te=i("p"),Te.innerHTML=Yi,yn=n(),r(we.$$.fragment),jn=n(),Je=i("p"),Je.innerHTML=Pi,Tn=n(),ge=i("p"),ge.innerHTML=Fi,wn=n(),r(be.$$.fragment),Jn=n(),Ue=i("p"),Ue.innerHTML=Di,gn=n(),ve=i("p"),ve.innerHTML=Oi,bn=n(),r(Ce.$$.fragment),Un=n(),Ie=i("p"),Ie.textContent=Ki,vn=n(),r(_e.$$.fragment),Cn=n(),xe=i("p"),xe.innerHTML=to,In=n(),r($e.$$.fragment),_n=n(),Ae=i("p"),Ae.textContent=eo,xn=n(),Le=i("p"),Le.innerHTML=lo,$n=n(),T=i("ol"),bl=i("li"),bl.innerHTML=so,Ua=n(),Ze=i("li"),Ul=i("p"),Ul.innerHTML=no,va=n(),r(ke.$$.fragment),Ca=n(),He=i("li"),vl=i("p"),vl.innerHTML=ao,Ia=n(),r(Be.$$.fragment),_a=n(),Ee=i("li"),Cl=i("p"),Cl.innerHTML=io,xa=n(),r(We.$$.fragment),An=n(),r(qe.$$.fragment),Ln=n(),Ne=i("p"),Ne.textContent=oo,Zn=n(),Ge=i("p"),Ge.innerHTML=po,kn=n(),Re=i("p"),Re.innerHTML=ro,Hn=n(),Qe=i("ol"),Qe.innerHTML=co,Bn=n(),Se=i("p"),Se.innerHTML=uo,En=n(),Xe=i("p"),Xe.textContent=Mo,Wn=n(),r(ze.$$.fragment),qn=n(),Ve=i("p"),Ve.textContent=mo,Nn=n(),Ye=i("ul"),Ye.innerHTML=ho,Gn=n(),Pe=i("p"),Pe.innerHTML=fo,Rn=n(),Fe=i("p"),Fe.textContent=yo,Qn=n(),r(De.$$.fragment),Sn=n(),Oe=i("p"),Oe.textContent=jo,Xn=n(),Ke=i("ul"),Ke.innerHTML=To,zn=n(),tl=i("p"),tl.innerHTML=wo,Vn=n(),el=i("p"),el.textContent=Jo,Yn=n(),ll=i("ol"),ll.innerHTML=go,Pn=n(),sl=i("p"),sl.innerHTML=bo,Fn=n(),nl=i("ul"),nl.innerHTML=Uo,Dn=n(),$=i("p"),$.innerHTML=vo,On=n(),A=i("p"),A.innerHTML=Co,Kn=n(),al=i("ul"),al.innerHTML=Io,ta=n(),il=i("p"),il.innerHTML=_o,ea=n(),ol=i("p"),ol.innerHTML=xo,la=n(),r(pl.$$.fragment),sa=n(),rl=i("p"),rl.textContent=$o,na=n(),cl=i("ul"),cl.innerHTML=Ao,aa=n(),ul=i("p"),ul.textContent=Lo,ia=n(),L=i("p"),L.innerHTML=Zo,oa=n(),Z=i("p"),Z.innerHTML=ko,pa=n(),r(Ml.$$.fragment),ra=n(),ml=i("p"),ml.textContent=Ho,ca=n(),hl=i("ul"),hl.innerHTML=Bo,ua=n(),dl=i("p"),dl.textContent=Eo,Ma=n(),r(k.$$.fragment),ma=n(),fl=i("p"),fl.textContent=Wo,ha=n(),r(yl.$$.fragment),da=n(),r(jl.$$.fragment),fa=n(),Il=i("p"),this.h()},l(t){const e=Xo("svelte-u9bgzb",document.head);y=o(e,"META",{name:!0,content:!0}),e.forEach(l),E=a(t),J=o(t,"P",{}),B(J).forEach(l),Tl=a(t),c(W.$$.fragment,t),xl=a(t),q=o(t,"P",{"data-svelte-h":!0}),p(q)!=="svelte-tip1wc"&&(q.textContent=Aa),$l=a(t),N=o(t,"P",{"data-svelte-h":!0}),p(N)!=="svelte-85x4lc"&&(N.textContent=La),Al=a(t),G=o(t,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1axnr08"&&(G.innerHTML=Za),Ll=a(t),R=o(t,"P",{"data-svelte-h":!0}),p(R)!=="svelte-6ttl9o"&&(R.textContent=ka),Zl=a(t),U=o(t,"P",{align:!0,"data-svelte-h":!0}),p(U)!=="svelte-2ozfa6"&&(U.innerHTML=Ha),kl=a(t),v=o(t,"P",{align:!0,"data-svelte-h":!0}),p(v)!=="svelte-agh7op"&&(v.innerHTML=Ba),Hl=a(t),Q=o(t,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-kh48rx"&&(Q.textContent=Ea),Bl=a(t),c(S.$$.fragment,t),El=a(t),X=o(t,"UL",{"data-svelte-h":!0}),p(X)!=="svelte-11vqhin"&&(X.innerHTML=Wa),Wl=a(t),c(z.$$.fragment,t),ql=a(t),V=o(t,"P",{"data-svelte-h":!0}),p(V)!=="svelte-12wjggm"&&(V.textContent=qa),Nl=a(t),Y=o(t,"UL",{"data-svelte-h":!0}),p(Y)!=="svelte-1xew5vn"&&(Y.innerHTML=Na),Gl=a(t),c(P.$$.fragment,t),Rl=a(t),F=o(t,"P",{"data-svelte-h":!0}),p(F)!=="svelte-punxaj"&&(F.innerHTML=Ga),Ql=a(t),c(D.$$.fragment,t),Sl=a(t),c(O.$$.fragment,t),Xl=a(t),c(K.$$.fragment,t),zl=a(t),tt=o(t,"P",{"data-svelte-h":!0}),p(tt)!=="svelte-7y6aek"&&(tt.innerHTML=Ra),Vl=a(t),c(et.$$.fragment,t),Yl=a(t),c(lt.$$.fragment,t),Pl=a(t),st=o(t,"P",{"data-svelte-h":!0}),p(st)!=="svelte-qhx7nb"&&(st.textContent=Qa),Fl=a(t),nt=o(t,"P",{"data-svelte-h":!0}),p(nt)!=="svelte-13zpkl7"&&(nt.textContent=Sa),Dl=a(t),at=o(t,"P",{"data-svelte-h":!0}),p(at)!=="svelte-1xbrdof"&&(at.innerHTML=Xa),Ol=a(t),it=o(t,"P",{"data-svelte-h":!0}),p(it)!=="svelte-12g0x8n"&&(it.textContent=za),Kl=a(t),c(ot.$$.fragment,t),ts=a(t),pt=o(t,"P",{"data-svelte-h":!0}),p(pt)!=="svelte-133252y"&&(pt.innerHTML=Va),es=a(t),g=o(t,"OL",{});var b=B(g);wl=o(b,"LI",{"data-svelte-h":!0}),p(wl)!=="svelte-jwhws7"&&(wl.textContent=Ya),Ja=a(b),Jl=o(b,"LI",{});var $a=B(Jl);ga=zo($a,`The script will record the minimum and maximum end-effector positions and the joint angles and prints them to the console, for example:
	`),c(rt.$$.fragment,$a),$a.forEach(l),ba=a(b),gl=o(b,"LI",{"data-svelte-h":!0}),p(gl)!=="svelte-1o9aezs"&&(gl.innerHTML=Pa),b.forEach(l),ls=a(t),ct=o(t,"P",{"data-svelte-h":!0}),p(ct)!=="svelte-9e4z7l"&&(ct.innerHTML=Fa),ss=a(t),c(ut.$$.fragment,t),ns=a(t),c(Mt.$$.fragment,t),as=a(t),mt=o(t,"P",{"data-svelte-h":!0}),p(mt)!=="svelte-1xayq1k"&&(mt.textContent=Da),is=a(t),ht=o(t,"P",{"data-svelte-h":!0}),p(ht)!=="svelte-1b1oyiu"&&(ht.innerHTML=Oa),os=a(t),dt=o(t,"P",{"data-svelte-h":!0}),p(dt)!=="svelte-1fm14qo"&&(dt.innerHTML=Ka),ps=a(t),ft=o(t,"OL",{"data-svelte-h":!0}),p(ft)!=="svelte-1x0dl0v"&&(ft.innerHTML=ti),rs=a(t),yt=o(t,"P",{"data-svelte-h":!0}),p(yt)!=="svelte-gur1fh"&&(yt.textContent=ei),cs=a(t),c(jt.$$.fragment,t),us=a(t),c(Tt.$$.fragment,t),Ms=a(t),wt=o(t,"P",{"data-svelte-h":!0}),p(wt)!=="svelte-1k55eio"&&(wt.textContent=li),ms=a(t),Jt=o(t,"P",{"data-svelte-h":!0}),p(Jt)!=="svelte-1gu8vct"&&(Jt.textContent=si),hs=a(t),gt=o(t,"P",{"data-svelte-h":!0}),p(gt)!=="svelte-lkgt27"&&(gt.innerHTML=ni),ds=a(t),c(bt.$$.fragment,t),fs=a(t),Ut=o(t,"P",{"data-svelte-h":!0}),p(Ut)!=="svelte-12kabho"&&(Ut.innerHTML=ai),ys=a(t),vt=o(t,"P",{"data-svelte-h":!0}),p(vt)!=="svelte-123qamy"&&(vt.innerHTML=ii),js=a(t),Ct=o(t,"P",{"data-svelte-h":!0}),p(Ct)!=="svelte-q27m3q"&&(Ct.textContent=oi),Ts=a(t),It=o(t,"P",{"data-svelte-h":!0}),p(It)!=="svelte-1458spy"&&(It.innerHTML=pi),ws=a(t),c(_t.$$.fragment,t),Js=a(t),C=o(t,"P",{align:!0,"data-svelte-h":!0}),p(C)!=="svelte-l7xw97"&&(C.innerHTML=ri),gs=a(t),I=o(t,"P",{align:!0,"data-svelte-h":!0}),p(I)!=="svelte-i8xgvo"&&(I.innerHTML=ci),bs=a(t),xt=o(t,"P",{"data-svelte-h":!0}),p(xt)!=="svelte-17w4vys"&&(xt.innerHTML=ui),Us=a(t),$t=o(t,"P",{"data-svelte-h":!0}),p($t)!=="svelte-1n513na"&&($t.textContent=Mi),vs=a(t),At=o(t,"P",{"data-svelte-h":!0}),p(At)!=="svelte-fnzfno"&&(At.innerHTML=mi),Cs=a(t),c(Lt.$$.fragment,t),Is=a(t),Zt=o(t,"P",{"data-svelte-h":!0}),p(Zt)!=="svelte-u9lwpw"&&(Zt.innerHTML=hi),_s=a(t),kt=o(t,"DETAILS",{"data-svelte-h":!0}),p(kt)!=="svelte-1raqgp9"&&(kt.innerHTML=di),xs=a(t),Ht=o(t,"P",{"data-svelte-h":!0}),p(Ht)!=="svelte-1lumdn2"&&(Ht.innerHTML=fi),$s=a(t),Bt=o(t,"P",{"data-svelte-h":!0}),p(Bt)!=="svelte-303oat"&&(Bt.innerHTML=yi),As=a(t),c(Et.$$.fragment,t),Ls=a(t),Wt=o(t,"P",{"data-svelte-h":!0}),p(Wt)!=="svelte-1e9jl8o"&&(Wt.textContent=ji),Zs=a(t),qt=o(t,"OL",{"data-svelte-h":!0}),p(qt)!=="svelte-uss0aq"&&(qt.innerHTML=Ti),ks=a(t),c(Nt.$$.fragment,t),Hs=a(t),Gt=o(t,"P",{"data-svelte-h":!0}),p(Gt)!=="svelte-1muq6i8"&&(Gt.textContent=wi),Bs=a(t),Rt=o(t,"P",{"data-svelte-h":!0}),p(Rt)!=="svelte-1q8tlhb"&&(Rt.textContent=Ji),Es=a(t),Qt=o(t,"UL",{"data-svelte-h":!0}),p(Qt)!=="svelte-b0vrwx"&&(Qt.innerHTML=gi),Ws=a(t),St=o(t,"P",{"data-svelte-h":!0}),p(St)!=="svelte-tevvdp"&&(St.innerHTML=bi),qs=a(t),Xt=o(t,"P",{"data-svelte-h":!0}),p(Xt)!=="svelte-98970x"&&(Xt.innerHTML=Ui),Ns=a(t),zt=o(t,"P",{"data-svelte-h":!0}),p(zt)!=="svelte-1eej4ha"&&(zt.innerHTML=vi),Gs=a(t),c(Vt.$$.fragment,t),Rs=a(t),Yt=o(t,"OL",{"data-svelte-h":!0}),p(Yt)!=="svelte-xydyib"&&(Yt.innerHTML=Ci),Qs=a(t),Pt=o(t,"P",{"data-svelte-h":!0}),p(Pt)!=="svelte-c9hbnf"&&(Pt.textContent=Ii),Ss=a(t),c(Ft.$$.fragment,t),Xs=a(t),_=o(t,"P",{align:!0,"data-svelte-h":!0}),p(_)!=="svelte-1kgsj1n"&&(_.innerHTML=_i),zs=a(t),x=o(t,"P",{align:!0,"data-svelte-h":!0}),p(x)!=="svelte-m2u5tt"&&(x.innerHTML=xi),Vs=a(t),Dt=o(t,"P",{"data-svelte-h":!0}),p(Dt)!=="svelte-1fvonll"&&(Dt.innerHTML=$i),Ys=a(t),Ot=o(t,"P",{"data-svelte-h":!0}),p(Ot)!=="svelte-1u063o4"&&(Ot.textContent=Ai),Ps=a(t),c(Kt.$$.fragment,t),Fs=a(t),te=o(t,"P",{"data-svelte-h":!0}),p(te)!=="svelte-gm91yt"&&(te.innerHTML=Li),Ds=a(t),ee=o(t,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-1xu368l"&&(ee.innerHTML=Zi),Os=a(t),c(le.$$.fragment,t),Ks=a(t),se=o(t,"P",{"data-svelte-h":!0}),p(se)!=="svelte-1s4360z"&&(se.textContent=ki),tn=a(t),ne=o(t,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-1gn06z5"&&(ne.textContent=Hi),en=a(t),ae=o(t,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-a5qxyo"&&(ae.innerHTML=Bi),ln=a(t),ie=o(t,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-d4pith"&&(ie.innerHTML=Ei),sn=a(t),oe=o(t,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-1v0tk6u"&&(oe.innerHTML=Wi),nn=a(t),pe=o(t,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-972ybh"&&(pe.innerHTML=qi),an=a(t),re=o(t,"P",{"data-svelte-h":!0}),p(re)!=="svelte-1najbyj"&&(re.textContent=Ni),on=a(t),c(ce.$$.fragment,t),pn=a(t),ue=o(t,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-6lst9n"&&(ue.innerHTML=Gi),rn=a(t),Me=o(t,"UL",{"data-svelte-h":!0}),p(Me)!=="svelte-6p95q7"&&(Me.innerHTML=Ri),cn=a(t),me=o(t,"P",{"data-svelte-h":!0}),p(me)!=="svelte-1kvwe1k"&&(me.innerHTML=Qi),un=a(t),he=o(t,"P",{"data-svelte-h":!0}),p(he)!=="svelte-17ipf62"&&(he.textContent=Si),Mn=a(t),c(de.$$.fragment,t),mn=a(t),fe=o(t,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-1g8qm4r"&&(fe.innerHTML=Xi),hn=a(t),ye=o(t,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-1k00g85"&&(ye.innerHTML=zi),dn=a(t),je=o(t,"UL",{"data-svelte-h":!0}),p(je)!=="svelte-299w4m"&&(je.innerHTML=Vi),fn=a(t),Te=o(t,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-164cgkl"&&(Te.innerHTML=Yi),yn=a(t),c(we.$$.fragment,t),jn=a(t),Je=o(t,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-gncodb"&&(Je.innerHTML=Pi),Tn=a(t),ge=o(t,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-1i92i25"&&(ge.innerHTML=Fi),wn=a(t),c(be.$$.fragment,t),Jn=a(t),Ue=o(t,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-t7wvp3"&&(Ue.innerHTML=Di),gn=a(t),ve=o(t,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-1373v1s"&&(ve.innerHTML=Oi),bn=a(t),c(Ce.$$.fragment,t),Un=a(t),Ie=o(t,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-1dg5zv5"&&(Ie.textContent=Ki),vn=a(t),c(_e.$$.fragment,t),Cn=a(t),xe=o(t,"P",{"data-svelte-h":!0}),p(xe)!=="svelte-ufcypw"&&(xe.innerHTML=to),In=a(t),c($e.$$.fragment,t),_n=a(t),Ae=o(t,"P",{"data-svelte-h":!0}),p(Ae)!=="svelte-kwp5x9"&&(Ae.textContent=eo),xn=a(t),Le=o(t,"P",{"data-svelte-h":!0}),p(Le)!=="svelte-164odnw"&&(Le.innerHTML=lo),$n=a(t),T=o(t,"OL",{});var H=B(T);bl=o(H,"LI",{"data-svelte-h":!0}),p(bl)!=="svelte-1ea113g"&&(bl.innerHTML=so),Ua=a(H),Ze=o(H,"LI",{});var ja=B(Ze);Ul=o(ja,"P",{"data-svelte-h":!0}),p(Ul)!=="svelte-uug10y"&&(Ul.innerHTML=no),va=a(ja),c(ke.$$.fragment,ja),ja.forEach(l),Ca=a(H),He=o(H,"LI",{});var Ta=B(He);vl=o(Ta,"P",{"data-svelte-h":!0}),p(vl)!=="svelte-1bu8h49"&&(vl.innerHTML=ao),Ia=a(Ta),c(Be.$$.fragment,Ta),Ta.forEach(l),_a=a(H),Ee=o(H,"LI",{});var wa=B(Ee);Cl=o(wa,"P",{"data-svelte-h":!0}),p(Cl)!=="svelte-9fejhf"&&(Cl.innerHTML=io),xa=a(wa),c(We.$$.fragment,wa),wa.forEach(l),H.forEach(l),An=a(t),c(qe.$$.fragment,t),Ln=a(t),Ne=o(t,"P",{"data-svelte-h":!0}),p(Ne)!=="svelte-ielnui"&&(Ne.textContent=oo),Zn=a(t),Ge=o(t,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-1nzvpp6"&&(Ge.innerHTML=po),kn=a(t),Re=o(t,"P",{"data-svelte-h":!0}),p(Re)!=="svelte-itmw1a"&&(Re.innerHTML=ro),Hn=a(t),Qe=o(t,"OL",{"data-svelte-h":!0}),p(Qe)!=="svelte-1kayg47"&&(Qe.innerHTML=co),Bn=a(t),Se=o(t,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-a4qqfr"&&(Se.innerHTML=uo),En=a(t),Xe=o(t,"P",{"data-svelte-h":!0}),p(Xe)!=="svelte-3hlmw"&&(Xe.textContent=Mo),Wn=a(t),c(ze.$$.fragment,t),qn=a(t),Ve=o(t,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-1j61g44"&&(Ve.textContent=mo),Nn=a(t),Ye=o(t,"UL",{"data-svelte-h":!0}),p(Ye)!=="svelte-1a6gefp"&&(Ye.innerHTML=ho),Gn=a(t),Pe=o(t,"P",{"data-svelte-h":!0}),p(Pe)!=="svelte-mqduir"&&(Pe.innerHTML=fo),Rn=a(t),Fe=o(t,"P",{"data-svelte-h":!0}),p(Fe)!=="svelte-1fri2t1"&&(Fe.textContent=yo),Qn=a(t),c(De.$$.fragment,t),Sn=a(t),Oe=o(t,"P",{"data-svelte-h":!0}),p(Oe)!=="svelte-1pg0b4o"&&(Oe.textContent=jo),Xn=a(t),Ke=o(t,"UL",{"data-svelte-h":!0}),p(Ke)!=="svelte-1a3rfwc"&&(Ke.innerHTML=To),zn=a(t),tl=o(t,"P",{"data-svelte-h":!0}),p(tl)!=="svelte-1gfkg27"&&(tl.innerHTML=wo),Vn=a(t),el=o(t,"P",{"data-svelte-h":!0}),p(el)!=="svelte-16xa10t"&&(el.textContent=Jo),Yn=a(t),ll=o(t,"OL",{"data-svelte-h":!0}),p(ll)!=="svelte-xvk7zd"&&(ll.innerHTML=go),Pn=a(t),sl=o(t,"P",{"data-svelte-h":!0}),p(sl)!=="svelte-1t6xdcm"&&(sl.innerHTML=bo),Fn=a(t),nl=o(t,"UL",{"data-svelte-h":!0}),p(nl)!=="svelte-1lrs7nq"&&(nl.innerHTML=Uo),Dn=a(t),$=o(t,"P",{align:!0,"data-svelte-h":!0}),p($)!=="svelte-gebtxy"&&($.innerHTML=vo),On=a(t),A=o(t,"P",{align:!0,"data-svelte-h":!0}),p(A)!=="svelte-1nilrco"&&(A.innerHTML=Co),Kn=a(t),al=o(t,"UL",{"data-svelte-h":!0}),p(al)!=="svelte-ya9pqf"&&(al.innerHTML=Io),ta=a(t),il=o(t,"P",{"data-svelte-h":!0}),p(il)!=="svelte-5yw35g"&&(il.innerHTML=_o),ea=a(t),ol=o(t,"P",{"data-svelte-h":!0}),p(ol)!=="svelte-67cyg"&&(ol.innerHTML=xo),la=a(t),c(pl.$$.fragment,t),sa=a(t),rl=o(t,"P",{"data-svelte-h":!0}),p(rl)!=="svelte-rqagvd"&&(rl.textContent=$o),na=a(t),cl=o(t,"UL",{"data-svelte-h":!0}),p(cl)!=="svelte-sb7wdj"&&(cl.innerHTML=Ao),aa=a(t),ul=o(t,"P",{"data-svelte-h":!0}),p(ul)!=="svelte-1ezclbk"&&(ul.textContent=Lo),ia=a(t),L=o(t,"P",{align:!0,"data-svelte-h":!0}),p(L)!=="svelte-mocte1"&&(L.innerHTML=Zo),oa=a(t),Z=o(t,"P",{align:!0,"data-svelte-h":!0}),p(Z)!=="svelte-15kockq"&&(Z.innerHTML=ko),pa=a(t),c(Ml.$$.fragment,t),ra=a(t),ml=o(t,"P",{"data-svelte-h":!0}),p(ml)!=="svelte-1h575sh"&&(ml.textContent=Ho),ca=a(t),hl=o(t,"UL",{"data-svelte-h":!0}),p(hl)!=="svelte-1t7hhz6"&&(hl.innerHTML=Bo),ua=a(t),dl=o(t,"P",{"data-svelte-h":!0}),p(dl)!=="svelte-kg8fpw"&&(dl.textContent=Eo),Ma=a(t),c(k.$$.fragment,t),ma=a(t),fl=o(t,"P",{"data-svelte-h":!0}),p(fl)!=="svelte-k8021v"&&(fl.textContent=Wo),ha=a(t),c(yl.$$.fragment,t),da=a(t),c(jl.$$.fragment,t),fa=a(t),Il=o(t,"P",{}),B(Il).forEach(l),this.h()},h(){w(y,"name","hf:doc:metadata"),w(y,"content",Do),w(U,"align","center"),w(v,"align","center"),w(C,"align","center"),w(I,"align","center"),w(_,"align","center"),w(x,"align","center"),w($,"align","center"),w(A,"align","center"),w(L,"align","center"),w(Z,"align","center")},m(t,e){f(document.head,y),s(t,E,e),s(t,J,e),s(t,Tl,e),u(W,t,e),s(t,xl,e),s(t,q,e),s(t,$l,e),s(t,N,e),s(t,Al,e),s(t,G,e),s(t,Ll,e),s(t,R,e),s(t,Zl,e),s(t,U,e),s(t,kl,e),s(t,v,e),s(t,Hl,e),s(t,Q,e),s(t,Bl,e),u(S,t,e),s(t,El,e),s(t,X,e),s(t,Wl,e),u(z,t,e),s(t,ql,e),s(t,V,e),s(t,Nl,e),s(t,Y,e),s(t,Gl,e),u(P,t,e),s(t,Rl,e),s(t,F,e),s(t,Ql,e),u(D,t,e),s(t,Sl,e),u(O,t,e),s(t,Xl,e),u(K,t,e),s(t,zl,e),s(t,tt,e),s(t,Vl,e),u(et,t,e),s(t,Yl,e),u(lt,t,e),s(t,Pl,e),s(t,st,e),s(t,Fl,e),s(t,nt,e),s(t,Dl,e),s(t,at,e),s(t,Ol,e),s(t,it,e),s(t,Kl,e),u(ot,t,e),s(t,ts,e),s(t,pt,e),s(t,es,e),s(t,g,e),f(g,wl),f(g,Ja),f(g,Jl),f(Jl,ga),u(rt,Jl,null),f(g,ba),f(g,gl),s(t,ls,e),s(t,ct,e),s(t,ss,e),u(ut,t,e),s(t,ns,e),u(Mt,t,e),s(t,as,e),s(t,mt,e),s(t,is,e),s(t,ht,e),s(t,os,e),s(t,dt,e),s(t,ps,e),s(t,ft,e),s(t,rs,e),s(t,yt,e),s(t,cs,e),u(jt,t,e),s(t,us,e),u(Tt,t,e),s(t,Ms,e),s(t,wt,e),s(t,ms,e),s(t,Jt,e),s(t,hs,e),s(t,gt,e),s(t,ds,e),u(bt,t,e),s(t,fs,e),s(t,Ut,e),s(t,ys,e),s(t,vt,e),s(t,js,e),s(t,Ct,e),s(t,Ts,e),s(t,It,e),s(t,ws,e),u(_t,t,e),s(t,Js,e),s(t,C,e),s(t,gs,e),s(t,I,e),s(t,bs,e),s(t,xt,e),s(t,Us,e),s(t,$t,e),s(t,vs,e),s(t,At,e),s(t,Cs,e),u(Lt,t,e),s(t,Is,e),s(t,Zt,e),s(t,_s,e),s(t,kt,e),s(t,xs,e),s(t,Ht,e),s(t,$s,e),s(t,Bt,e),s(t,As,e),u(Et,t,e),s(t,Ls,e),s(t,Wt,e),s(t,Zs,e),s(t,qt,e),s(t,ks,e),u(Nt,t,e),s(t,Hs,e),s(t,Gt,e),s(t,Bs,e),s(t,Rt,e),s(t,Es,e),s(t,Qt,e),s(t,Ws,e),s(t,St,e),s(t,qs,e),s(t,Xt,e),s(t,Ns,e),s(t,zt,e),s(t,Gs,e),u(Vt,t,e),s(t,Rs,e),s(t,Yt,e),s(t,Qs,e),s(t,Pt,e),s(t,Ss,e),u(Ft,t,e),s(t,Xs,e),s(t,_,e),s(t,zs,e),s(t,x,e),s(t,Vs,e),s(t,Dt,e),s(t,Ys,e),s(t,Ot,e),s(t,Ps,e),u(Kt,t,e),s(t,Fs,e),s(t,te,e),s(t,Ds,e),s(t,ee,e),s(t,Os,e),u(le,t,e),s(t,Ks,e),s(t,se,e),s(t,tn,e),s(t,ne,e),s(t,en,e),s(t,ae,e),s(t,ln,e),s(t,ie,e),s(t,sn,e),s(t,oe,e),s(t,nn,e),s(t,pe,e),s(t,an,e),s(t,re,e),s(t,on,e),u(ce,t,e),s(t,pn,e),s(t,ue,e),s(t,rn,e),s(t,Me,e),s(t,cn,e),s(t,me,e),s(t,un,e),s(t,he,e),s(t,Mn,e),u(de,t,e),s(t,mn,e),s(t,fe,e),s(t,hn,e),s(t,ye,e),s(t,dn,e),s(t,je,e),s(t,fn,e),s(t,Te,e),s(t,yn,e),u(we,t,e),s(t,jn,e),s(t,Je,e),s(t,Tn,e),s(t,ge,e),s(t,wn,e),u(be,t,e),s(t,Jn,e),s(t,Ue,e),s(t,gn,e),s(t,ve,e),s(t,bn,e),u(Ce,t,e),s(t,Un,e),s(t,Ie,e),s(t,vn,e),u(_e,t,e),s(t,Cn,e),s(t,xe,e),s(t,In,e),u($e,t,e),s(t,_n,e),s(t,Ae,e),s(t,xn,e),s(t,Le,e),s(t,$n,e),s(t,T,e),f(T,bl),f(T,Ua),f(T,Ze),f(Ze,Ul),f(Ze,va),u(ke,Ze,null),f(T,Ca),f(T,He),f(He,vl),f(He,Ia),u(Be,He,null),f(T,_a),f(T,Ee),f(Ee,Cl),f(Ee,xa),u(We,Ee,null),s(t,An,e),u(qe,t,e),s(t,Ln,e),s(t,Ne,e),s(t,Zn,e),s(t,Ge,e),s(t,kn,e),s(t,Re,e),s(t,Hn,e),s(t,Qe,e),s(t,Bn,e),s(t,Se,e),s(t,En,e),s(t,Xe,e),s(t,Wn,e),u(ze,t,e),s(t,qn,e),s(t,Ve,e),s(t,Nn,e),s(t,Ye,e),s(t,Gn,e),s(t,Pe,e),s(t,Rn,e),s(t,Fe,e),s(t,Qn,e),u(De,t,e),s(t,Sn,e),s(t,Oe,e),s(t,Xn,e),s(t,Ke,e),s(t,zn,e),s(t,tl,e),s(t,Vn,e),s(t,el,e),s(t,Yn,e),s(t,ll,e),s(t,Pn,e),s(t,sl,e),s(t,Fn,e),s(t,nl,e),s(t,Dn,e),s(t,$,e),s(t,On,e),s(t,A,e),s(t,Kn,e),s(t,al,e),s(t,ta,e),s(t,il,e),s(t,ea,e),s(t,ol,e),s(t,la,e),u(pl,t,e),s(t,sa,e),s(t,rl,e),s(t,na,e),s(t,cl,e),s(t,aa,e),s(t,ul,e),s(t,ia,e),s(t,L,e),s(t,oa,e),s(t,Z,e),s(t,pa,e),u(Ml,t,e),s(t,ra,e),s(t,ml,e),s(t,ca,e),s(t,hl,e),s(t,ua,e),s(t,dl,e),s(t,Ma,e),u(k,t,e),s(t,ma,e),s(t,fl,e),s(t,ha,e),u(yl,t,e),s(t,da,e),u(jl,t,e),s(t,fa,e),s(t,Il,e),ya=!0},p(t,[e]){const b={};e&2&&(b.$$scope={dirty:e,ctx:t}),k.$set(b)},i(t){ya||(M(W.$$.fragment,t),M(S.$$.fragment,t),M(z.$$.fragment,t),M(P.$$.fragment,t),M(D.$$.fragment,t),M(O.$$.fragment,t),M(K.$$.fragment,t),M(et.$$.fragment,t),M(lt.$$.fragment,t),M(ot.$$.fragment,t),M(rt.$$.fragment,t),M(ut.$$.fragment,t),M(Mt.$$.fragment,t),M(jt.$$.fragment,t),M(Tt.$$.fragment,t),M(bt.$$.fragment,t),M(_t.$$.fragment,t),M(Lt.$$.fragment,t),M(Et.$$.fragment,t),M(Nt.$$.fragment,t),M(Vt.$$.fragment,t),M(Ft.$$.fragment,t),M(Kt.$$.fragment,t),M(le.$$.fragment,t),M(ce.$$.fragment,t),M(de.$$.fragment,t),M(we.$$.fragment,t),M(be.$$.fragment,t),M(Ce.$$.fragment,t),M(_e.$$.fragment,t),M($e.$$.fragment,t),M(ke.$$.fragment,t),M(Be.$$.fragment,t),M(We.$$.fragment,t),M(qe.$$.fragment,t),M(ze.$$.fragment,t),M(De.$$.fragment,t),M(pl.$$.fragment,t),M(Ml.$$.fragment,t),M(k.$$.fragment,t),M(yl.$$.fragment,t),M(jl.$$.fragment,t),ya=!0)},o(t){m(W.$$.fragment,t),m(S.$$.fragment,t),m(z.$$.fragment,t),m(P.$$.fragment,t),m(D.$$.fragment,t),m(O.$$.fragment,t),m(K.$$.fragment,t),m(et.$$.fragment,t),m(lt.$$.fragment,t),m(ot.$$.fragment,t),m(rt.$$.fragment,t),m(ut.$$.fragment,t),m(Mt.$$.fragment,t),m(jt.$$.fragment,t),m(Tt.$$.fragment,t),m(bt.$$.fragment,t),m(_t.$$.fragment,t),m(Lt.$$.fragment,t),m(Et.$$.fragment,t),m(Nt.$$.fragment,t),m(Vt.$$.fragment,t),m(Ft.$$.fragment,t),m(Kt.$$.fragment,t),m(le.$$.fragment,t),m(ce.$$.fragment,t),m(de.$$.fragment,t),m(we.$$.fragment,t),m(be.$$.fragment,t),m(Ce.$$.fragment,t),m(_e.$$.fragment,t),m($e.$$.fragment,t),m(ke.$$.fragment,t),m(Be.$$.fragment,t),m(We.$$.fragment,t),m(qe.$$.fragment,t),m(ze.$$.fragment,t),m(De.$$.fragment,t),m(pl.$$.fragment,t),m(Ml.$$.fragment,t),m(k.$$.fragment,t),m(yl.$$.fragment,t),m(jl.$$.fragment,t),ya=!1},d(t){t&&(l(E),l(J),l(Tl),l(xl),l(q),l($l),l(N),l(Al),l(G),l(Ll),l(R),l(Zl),l(U),l(kl),l(v),l(Hl),l(Q),l(Bl),l(El),l(X),l(Wl),l(ql),l(V),l(Nl),l(Y),l(Gl),l(Rl),l(F),l(Ql),l(Sl),l(Xl),l(zl),l(tt),l(Vl),l(Yl),l(Pl),l(st),l(Fl),l(nt),l(Dl),l(at),l(Ol),l(it),l(Kl),l(ts),l(pt),l(es),l(g),l(ls),l(ct),l(ss),l(ns),l(as),l(mt),l(is),l(ht),l(os),l(dt),l(ps),l(ft),l(rs),l(yt),l(cs),l(us),l(Ms),l(wt),l(ms),l(Jt),l(hs),l(gt),l(ds),l(fs),l(Ut),l(ys),l(vt),l(js),l(Ct),l(Ts),l(It),l(ws),l(Js),l(C),l(gs),l(I),l(bs),l(xt),l(Us),l($t),l(vs),l(At),l(Cs),l(Is),l(Zt),l(_s),l(kt),l(xs),l(Ht),l($s),l(Bt),l(As),l(Ls),l(Wt),l(Zs),l(qt),l(ks),l(Hs),l(Gt),l(Bs),l(Rt),l(Es),l(Qt),l(Ws),l(St),l(qs),l(Xt),l(Ns),l(zt),l(Gs),l(Rs),l(Yt),l(Qs),l(Pt),l(Ss),l(Xs),l(_),l(zs),l(x),l(Vs),l(Dt),l(Ys),l(Ot),l(Ps),l(Fs),l(te),l(Ds),l(ee),l(Os),l(Ks),l(se),l(tn),l(ne),l(en),l(ae),l(ln),l(ie),l(sn),l(oe),l(nn),l(pe),l(an),l(re),l(on),l(pn),l(ue),l(rn),l(Me),l(cn),l(me),l(un),l(he),l(Mn),l(mn),l(fe),l(hn),l(ye),l(dn),l(je),l(fn),l(Te),l(yn),l(jn),l(Je),l(Tn),l(ge),l(wn),l(Jn),l(Ue),l(gn),l(ve),l(bn),l(Un),l(Ie),l(vn),l(Cn),l(xe),l(In),l(_n),l(Ae),l(xn),l(Le),l($n),l(T),l(An),l(Ln),l(Ne),l(Zn),l(Ge),l(kn),l(Re),l(Hn),l(Qe),l(Bn),l(Se),l(En),l(Xe),l(Wn),l(qn),l(Ve),l(Nn),l(Ye),l(Gn),l(Pe),l(Rn),l(Fe),l(Qn),l(Sn),l(Oe),l(Xn),l(Ke),l(zn),l(tl),l(Vn),l(el),l(Yn),l(ll),l(Pn),l(sl),l(Fn),l(nl),l(Dn),l($),l(On),l(A),l(Kn),l(al),l(ta),l(il),l(ea),l(ol),l(la),l(sa),l(rl),l(na),l(cl),l(aa),l(ul),l(ia),l(L),l(oa),l(Z),l(pa),l(ra),l(ml),l(ca),l(hl),l(ua),l(dl),l(Ma),l(ma),l(fl),l(ha),l(da),l(fa),l(Il)),l(y),h(W,t),h(S,t),h(z,t),h(P,t),h(D,t),h(O,t),h(K,t),h(et,t),h(lt,t),h(ot,t),h(rt),h(ut,t),h(Mt,t),h(jt,t),h(Tt,t),h(bt,t),h(_t,t),h(Lt,t),h(Et,t),h(Nt,t),h(Vt,t),h(Ft,t),h(Kt,t),h(le,t),h(ce,t),h(de,t),h(we,t),h(be,t),h(Ce,t),h(_e,t),h($e,t),h(ke),h(Be),h(We),h(qe,t),h(ze,t),h(De,t),h(pl,t),h(Ml,t),h(k,t),h(yl,t),h(jl,t)}}}const Do='{"title":"HIL-SERL Real Robot Training Workflow Guide","local":"hil-serl-real-robot-training-workflow-guide","sections":[{"title":"What do I need?","local":"what-do-i-need","sections":[],"depth":2},{"title":"What kind of tasks can I train?","local":"what-kind-of-tasks-can-i-train","sections":[],"depth":2},{"title":"Install LeRobot with HIL-SERL","local":"install-lerobot-with-hil-serl","sections":[],"depth":2},{"title":"Real Robot Training Workflow","local":"real-robot-training-workflow","sections":[{"title":"Understanding Configuration","local":"understanding-configuration","sections":[],"depth":3},{"title":"Finding Robot Workspace Bounds","local":"finding-robot-workspace-bounds","sections":[],"depth":3},{"title":"Collecting Demonstrations","local":"collecting-demonstrations","sections":[],"depth":3},{"title":"Using a Teleoperation Device","local":"using-a-teleoperation-device","sections":[],"depth":3},{"title":"Processing the Dataset","local":"processing-the-dataset","sections":[],"depth":3},{"title":"Training a Reward Classifier","local":"training-a-reward-classifier","sections":[],"depth":3},{"title":"Training with Actor-Learner","local":"training-with-actor-learner","sections":[],"depth":3},{"title":"Guide to Human Interventions","local":"guide-to-human-interventions","sections":[],"depth":3},{"title":"Key hyperparameters to tune","local":"key-hyperparameters-to-tune","sections":[],"depth":3}],"depth":2}],"depth":1}';function Oo(_l){return No(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class np extends Ro{constructor(y){super(),Qo(this,y,Oo,Fo,qo,{})}}export{np as component};
