import{s as _J,f as $J,o as zJ,n as LJ}from"../chunks/scheduler.889ebb13.js";import{S as qJ,i as KJ,g as y,s as U,r as e,A as PJ,h as t,f as J,c as w,j as YJ,u as j,x as I,k as Zl,l as lT,y as MT,a as T,v as s,d as A,t as a,w as n,m as XJ,n as HJ}from"../chunks/index.ca18042b.js";import{T as JT}from"../chunks/Tip.b8116e3c.js";import{C as i}from"../chunks/CodeBlock.1db71023.js";import{C as TT}from"../chunks/CourseFloatingBanner.bff79cca.js";import{H as Ql}from"../chunks/Heading.3daa581c.js";import{E as UT}from"../chunks/EditOnGithub.2e95618d.js";function wT(Wl){let o,p,r="this notebook",g;return{c(){o=XJ("You can follow the code in "),p=y("a"),p.textContent=r,g=XJ(" that you can run using Google Colab."),this.h()},l(C){o=HJ(C,"You can follow the code in "),p=t(C,"A",{href:!0,target:!0,"data-svelte-h":!0}),I(p)!=="svelte-z33b9j"&&(p.textContent=r),g=HJ(C," that you can run using Google Colab."),this.h()},h(){Zl(p,"href","https://huggingface.co/agents-course/notebooks/blob/main/unit2/smolagents/multiagent_notebook.ipynb"),Zl(p,"target","_blank")},m(C,m){T(C,o,m),T(C,p,m),T(C,g,m)},p:LJ,d(C){C&&(J(o),J(p),J(g))}}}function yT(Wl){let o,p,r,g,C,m,d,vl,k,MJ="Multi-agent systems enable <strong>specialized agents to collaborate on complex tasks</strong>, improving modularity, scalability, and robustness. Instead of relying on a single agent, tasks are distributed among agents with distinct capabilities.",Ol,h,JJ="In <strong>smolagents</strong>, different agents can be combined to generate Python code, call external tools, perform web searches, and more. By orchestrating these agents, we can create powerful workflows.",Dl,u,TJ="A typical setup might include:",El,b,UJ="<li>A <strong>Manager Agent</strong> for task delegation</li> <li>A <strong>Code Interpreter Agent</strong> for code execution</li> <li>A <strong>Web Search Agent</strong> for information retrieval</li>",Yl,B,wJ="The diagram below illustrates a simple multi-agent architecture where a <strong>Manager Agent</strong> coordinates a <strong>Code Interpreter Tool</strong> and a <strong>Web Search Agent</strong>, which in turn utilizes tools like the <code>DuckDuckGoSearchTool</code> and <code>VisitWebpageTool</code> to gather relevant information.",Xl,N,yJ,Hl,V,_l,S,tJ="A multi-agent system consists of multiple specialized agents working together under the coordination of an <strong>Orchestrator Agent</strong>. This approach enables complex workflows by distributing tasks among agents with distinct roles.",$l,F,IJ="For example, a <strong>Multi-Agent RAG system</strong> can integrate:",zl,x,eJ="<li>A <strong>Web Agent</strong> for browsing the internet.</li> <li>A <strong>Retriever Agent</strong> for fetching information from knowledge bases.</li> <li>An <strong>Image Generation Agent</strong> for producing visuals.</li>",Ll,G,jJ="All of these agents operate under an orchestrator that manages task delegation and interaction.",ql,f,Kl,c,Pl,Q,sJ="The reception is approaching! With your help, Alfred is now nearly finished with the preparations.",lM,R,AJ="But now there’s a problem: the Batmobile has disappeared. Alfred needs to find a replacement, and find it quickly.",MM,Z,aJ="Fortunately, a few biopics have been done on Bruce Wayne’s life, so maybe Alfred could get a car left behind on one of the movie sets, and re-engineer it up to modern standards, which certainly would include a full self-driving option.",JM,W,nJ="But this could be anywhere in the filming locations around the world - which could be numerous.",TM,v,CJ="So Alfred wants your help. Could you build an agent able to solve this task?",UM,O,iJ="<p>👉 Find all Batman filming locations in the world, calculate the time to transfer via boat to there, and represent them on a map, with a color varying by boat transfer time. Also represent some supercar factories with the same boat transfer time.</p>",wM,D,oJ="Let’s build this!",yM,E,pJ="This example needs some additional packages, so let’s install them first:",tM,Y,IM,X,eM,H,jM,_,sM,$,gJ='For the model provider, we use Together AI, one of the new <a href="https://huggingface.co/blog/inference-providers" rel="nofollow">inference providers on the Hub</a>!',AM,z,rJ='The GoogleSearchTool uses the <a href="https://serper.dev" rel="nofollow">Serper API</a> to search the web, so this requires either having setup env variable <code>SERPAPI_API_KEY</code> and passing <code>provider=&quot;serpapi&quot;</code> or having <code>SERPER_API_KEY</code> and passing <code>provider=serper</code>.',aM,L,mJ="If you don’t have any Serp API provider setup, you can use <code>DuckDuckGoSearchTool</code> but beware that it has a rate limit.",nM,q,CM,K,cJ="We can start by creating a simple agent as a baseline to give us a simple report.",iM,P,oM,ll,pM,Ml,gM,Jl,rM,Tl,dJ="In our case, it generates this output:",mM,Ul,cM,wl,kJ="We could already improve this a bit by throwing in some dedicated planning steps, and adding more prompting.",dM,yl,hJ="Planning steps allow the agent to think ahead and plan its next steps, which can be useful for more complex tasks.",kM,tl,hM,Il,uM,el,uJ="In our case, it generates this output:",bM,jl,BM,sl,bJ="Thanks to these quick changes, we obtained a much more concise report by simply providing our agent a detailed prompt, and giving it planning capabilities!",NM,Al,BJ="The model’s context window is quickly filling up. So <strong>if we ask our agent to combine the results of detailed search with another, it will be slower and quickly ramp up tokens and costs</strong>.",VM,al,NJ="➡️ We need to improve the structure of our system.",SM,nl,FM,Cl,VJ="Multi-agent structures allow to separate memories between different sub-tasks, with two great benefits:",xM,il,SJ="<li>Each agent is more focused on its core task, thus more performant</li> <li>Separating memories reduces the count of input tokens at each step, thus reducing latency and cost.</li>",GM,ol,FJ="Let’s create a team with a dedicated web search agent, managed by another agent.",fM,pl,xJ="The manager agent should have plotting capabilities to write its final report: so let us give it access to additional imports, including <code>matplotlib</code>, and <code>geopandas</code> + <code>shapely</code> for spatial plotting.",QM,gl,RM,rl,GJ="The manager agent will need to do some mental heavy lifting.",ZM,ml,fJ='So we give it the stronger model <a href="https://huggingface.co/deepseek-ai/DeepSeek-R1" rel="nofollow">DeepSeek-R1</a>, and add a <code>planning_interval</code> to the mix.',WM,cl,vM,dl,QJ="Let us inspect what this team looks like:",OM,kl,DM,hl,RJ="This will generate something like this, helping us understand the structure and relationship between agents and tools used:",EM,ul,YM,bl,XM,Bl,ZJ="I don’t know how that went in your run, but in mine, the manager agent skilfully divided tasks given to the web agent in <code>1. Search for Batman filming locations</code>, then <code>2. Find supercar factories</code>, before aggregating the lists and plotting the map.",HM,Nl,WJ="Let’s see what the map looks like by inspecting it directly from the agent state:",_M,Vl,$M,Sl,vJ="This will output the map:",zM,Fl,OJ='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/smolagents/output_map.png" alt="Multiagent system example output map"/>',LM,xl,qM,Gl,DJ='<li><a href="https://huggingface.co/docs/smolagents/main/en/examples/multiagents" rel="nofollow">Multi-Agent Systems</a> – Overview of multi-agent systems.</li> <li><a href="https://weaviate.io/blog/what-is-agentic-rag" rel="nofollow">What is Agentic RAG?</a> – Introduction to Agentic RAG.</li> <li><a href="https://huggingface.co/learn/cookbook/multiagent_rag_system" rel="nofollow">Multi-Agent RAG System 🤖🤝🤖 Recipe</a> – Step-by-step guide to building a multi-agent RAG system.</li>',KM,fl,PM,Rl,lJ;return C=new TT({props:{chapter:2,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/agents-course/blob/main/notebooks/unit2/smolagents/multiagent_notebook.ipynb"}]}}),d=new Ql({props:{title:"Multi-Agent Systems",local:"multi-agent-systems",headingTag:"h1"}}),V=new Ql({props:{title:"Multi-Agent Systems in Action",local:"multi-agent-systems-in-action",headingTag:"h2"}}),f=new Ql({props:{title:"Solving a complex task with a multi-agent hierarchy",local:"solving-a-complex-task-with-a-multi-agent-hierarchy",headingTag:"h2"}}),c=new JT({props:{$$slots:{default:[wT]},$$scope:{ctx:Wl}}}),Y=new i({props:{code:"cGlwJTIwaW5zdGFsbCUyMCdzbW9sYWdlbnRzJTVCbGl0ZWxsbSU1RCclMjBtYXRwbG90bGliJTIwZ2VvcGFuZGFzJTIwc2hhcGVseSUyMGthbGVpZG8lMjAtcQ==",highlighted:'pip install <span class="hljs-string">&#x27;smolagents[litellm]&#x27;</span> matplotlib geopandas shapely kaleido -q',wrap:!1}}),X=new Ql({props:{title:"We first make a tool to get the cargo plane transfer time.",local:"we-first-make-a-tool-to-get-the-cargo-plane-transfer-time",headingTag:"h3"}}),H=new i({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> math
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Optional</span>, <span class="hljs-type">Tuple</span>

<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> tool


<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculate_cargo_travel_time</span>(<span class="hljs-params">
    origin_coords: <span class="hljs-type">Tuple</span>[<span class="hljs-built_in">float</span>, <span class="hljs-built_in">float</span>],
    destination_coords: <span class="hljs-type">Tuple</span>[<span class="hljs-built_in">float</span>, <span class="hljs-built_in">float</span>],
    cruising_speed_kmh: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">float</span>] = <span class="hljs-number">750.0</span>,  <span class="hljs-comment"># Average speed for cargo planes</span>
</span>) -&gt; <span class="hljs-built_in">float</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Calculate the travel time for a cargo plane between two points on Earth using great-circle distance.

    Args:
        origin_coords: Tuple of (latitude, longitude) for the starting point
        destination_coords: Tuple of (latitude, longitude) for the destination
        cruising_speed_kmh: Optional cruising speed in km/h (defaults to 750 km/h for typical cargo planes)

    Returns:
        float: The estimated travel time in hours

    Example:
        &gt;&gt;&gt; # Chicago (41.8781° N, 87.6298° W) to Sydney (33.8688° S, 151.2093° E)
        &gt;&gt;&gt; result = calculate_cargo_travel_time((41.8781, -87.6298), (-33.8688, 151.2093))
    &quot;&quot;&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">to_radians</span>(<span class="hljs-params">degrees: <span class="hljs-built_in">float</span></span>) -&gt; <span class="hljs-built_in">float</span>:
        <span class="hljs-keyword">return</span> degrees * (math.pi / <span class="hljs-number">180</span>)

    <span class="hljs-comment"># Extract coordinates</span>
    lat1, lon1 = <span class="hljs-built_in">map</span>(to_radians, origin_coords)
    lat2, lon2 = <span class="hljs-built_in">map</span>(to_radians, destination_coords)

    <span class="hljs-comment"># Earth&#x27;s radius in kilometers</span>
    EARTH_RADIUS_KM = <span class="hljs-number">6371.0</span>

    <span class="hljs-comment"># Calculate great-circle distance using the haversine formula</span>
    dlon = lon2 - lon1
    dlat = lat2 - lat1

    a = (
        math.sin(dlat / <span class="hljs-number">2</span>) ** <span class="hljs-number">2</span>
        + math.cos(lat1) * math.cos(lat2) * math.sin(dlon / <span class="hljs-number">2</span>) ** <span class="hljs-number">2</span>
    )
    c = <span class="hljs-number">2</span> * math.asin(math.sqrt(a))
    distance = EARTH_RADIUS_KM * c

    <span class="hljs-comment"># Add 10% to account for non-direct routes and air traffic controls</span>
    actual_distance = distance * <span class="hljs-number">1.1</span>

    <span class="hljs-comment"># Calculate flight time</span>
    <span class="hljs-comment"># Add 1 hour for takeoff and landing procedures</span>
    flight_time = (actual_distance / cruising_speed_kmh) + <span class="hljs-number">1.0</span>

    <span class="hljs-comment"># Format the results</span>
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">round</span>(flight_time, <span class="hljs-number">2</span>)


<span class="hljs-built_in">print</span>(calculate_cargo_travel_time((<span class="hljs-number">41.8781</span>, -<span class="hljs-number">87.6298</span>), (-<span class="hljs-number">33.8688</span>, <span class="hljs-number">151.2093</span>)))`,wrap:!1}}),_=new Ql({props:{title:"Setting up the agent",local:"setting-up-the-agent",headingTag:"h3"}}),q=new i({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwc21vbGFnZW50cyUyMGltcG9ydCUyMENvZGVBZ2VudCUyQyUyMEdvb2dsZVNlYXJjaFRvb2wlMkMlMjBIZkFwaU1vZGVsJTJDJTIwVmlzaXRXZWJwYWdlVG9vbCUwQSUwQW1vZGVsJTIwJTNEJTIwSGZBcGlNb2RlbChtb2RlbF9pZCUzRCUyMlF3ZW4lMkZRd2VuMi41LUNvZGVyLTMyQi1JbnN0cnVjdCUyMiUyQyUyMHByb3ZpZGVyJTNEJTIydG9nZXRoZXIlMjIp",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, GoogleSearchTool, HfApiModel, VisitWebpageTool

model = HfApiModel(model_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>, provider=<span class="hljs-string">&quot;together&quot;</span>)`,wrap:!1}}),P=new i({props:{code:"dGFzayUyMCUzRCUyMCUyMiUyMiUyMkZpbmQlMjBhbGwlMjBCYXRtYW4lMjBmaWxtaW5nJTIwbG9jYXRpb25zJTIwaW4lMjB0aGUlMjB3b3JsZCUyQyUyMGNhbGN1bGF0ZSUyMHRoZSUyMHRpbWUlMjB0byUyMHRyYW5zZmVyJTIwdmlhJTIwY2FyZ28lMjBwbGFuZSUyMHRvJTIwaGVyZSUyMCh3ZSdyZSUyMGluJTIwR290aGFtJTJDJTIwNDAuNzEyOCVDMiVCMCUyME4lMkMlMjA3NC4wMDYwJUMyJUIwJTIwVyklMkMlMjBhbmQlMjByZXR1cm4lMjB0aGVtJTIwdG8lMjBtZSUyMGFzJTIwYSUyMHBhbmRhcyUyMGRhdGFmcmFtZS4lMEFBbHNvJTIwZ2l2ZSUyMG1lJTIwc29tZSUyMHN1cGVyY2FyJTIwZmFjdG9yaWVzJTIwd2l0aCUyMHRoZSUyMHNhbWUlMjBjYXJnbyUyMHBsYW5lJTIwdHJhbnNmZXIlMjB0aW1lLiUyMiUyMiUyMg==",highlighted:`task = <span class="hljs-string">&quot;&quot;&quot;Find all Batman filming locations in the world, calculate the time to transfer via cargo plane to here (we&#x27;re in Gotham, 40.7128° N, 74.0060° W), and return them to me as a pandas dataframe.
Also give me some supercar factories with the same cargo plane transfer time.&quot;&quot;&quot;</span>`,wrap:!1}}),ll=new i({props:{code:"YWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCR29vZ2xlU2VhcmNoVG9vbCglMjJzZXJwZXIlMjIpJTJDJTIwVmlzaXRXZWJwYWdlVG9vbCgpJTJDJTIwY2FsY3VsYXRlX2NhcmdvX3RyYXZlbF90aW1lJTVEJTJDJTBBJTIwJTIwJTIwJTIwYWRkaXRpb25hbF9hdXRob3JpemVkX2ltcG9ydHMlM0QlNUIlMjJwYW5kYXMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBtYXhfc3RlcHMlM0QyMCUyQyUwQSk=",highlighted:`agent = CodeAgent(
    model=model,
    tools=[GoogleSearchTool(<span class="hljs-string">&quot;serper&quot;</span>), VisitWebpageTool(), calculate_cargo_travel_time],
    additional_authorized_imports=[<span class="hljs-string">&quot;pandas&quot;</span>],
    max_steps=<span class="hljs-number">20</span>,
)`,wrap:!1}}),Ml=new i({props:{code:"cmVzdWx0JTIwJTNEJTIwYWdlbnQucnVuKHRhc2sp",highlighted:"result = agent.run(task)",wrap:!1}}),Jl=new i({props:{code:"cmVzdWx0",highlighted:"result",wrap:!1}}),Ul=new i({props:{code:"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",highlighted:`|  | Location                                             | Travel Time to Gotham (hours) |
|--|------------------------------------------------------|------------------------------|
| <span class="hljs-number">0</span>  | Necropolis Cemetery, Glasgow, Scotland, UK         | <span class="hljs-number">8.60</span>                         |
| <span class="hljs-number">1</span>  | St. George<span class="hljs-string">&#x27;s Hall, Liverpool, England, UK         | 8.81                         |
| 2  | Two Temple Place, London, England, UK             | 9.17                         |
| 3  | Wollaton Hall, Nottingham, England, UK           | 9.00                         |
| 4  | Knebworth House, Knebworth, Hertfordshire, UK    | 9.15                         |
| 5  | Acton Lane Power Station, Acton Lane, Acton, UK  | 9.16                         |
| 6  | Queensboro Bridge, New York City, USA            | 1.01                         |
| 7  | Wall Street, New York City, USA                  | 1.00                         |
| 8  | Mehrangarh Fort, Jodhpur, Rajasthan, India       | 18.34                        |
| 9  | Turda Gorge, Turda, Romania                      | 11.89                        |
| 10 | Chicago, USA                                     | 2.68                         |
| 11 | Hong Kong, China                                 | 19.99                        |
| 12 | Cardington Studios, Northamptonshire, UK        | 9.10                         |
| 13 | Warner Bros. Leavesden Studios, Hertfordshire, UK | 9.13                         |
| 14 | Westwood, Los Angeles, CA, USA                  | 6.79                         |
| 15 | Woking, UK (McLaren)                             | 9.13                         |</span>`,wrap:!1}}),tl=new i({props:{code:"YWdlbnQucGxhbm5pbmdfaW50ZXJ2YWwlMjAlM0QlMjA0JTBBJTBBZGV0YWlsZWRfcmVwb3J0JTIwJTNEJTIwYWdlbnQucnVuKGYlMjIlMjIlMjIlMEFZb3UncmUlMjBhbiUyMGV4cGVydCUyMGFuYWx5c3QuJTIwWW91JTIwbWFrZSUyMGNvbXByZWhlbnNpdmUlMjByZXBvcnRzJTIwYWZ0ZXIlMjB2aXNpdGluZyUyMG1hbnklMjB3ZWJzaXRlcy4lMEFEb24ndCUyMGhlc2l0YXRlJTIwdG8lMjBzZWFyY2glMjBmb3IlMjBtYW55JTIwcXVlcmllcyUyMGF0JTIwb25jZSUyMGluJTIwYSUyMGZvciUyMGxvb3AuJTBBRm9yJTIwZWFjaCUyMGRhdGElMjBwb2ludCUyMHRoYXQlMjB5b3UlMjBmaW5kJTJDJTIwdmlzaXQlMjB0aGUlMjBzb3VyY2UlMjB1cmwlMjB0byUyMGNvbmZpcm0lMjBudW1iZXJzLiUwQSUwQSU3QnRhc2slN0QlMEElMjIlMjIlMjIpJTBBJTBBcHJpbnQoZGV0YWlsZWRfcmVwb3J0KQ==",highlighted:`agent.planning_interval = <span class="hljs-number">4</span>

detailed_report = agent.run(<span class="hljs-string">f&quot;&quot;&quot;
You&#x27;re an expert analyst. You make comprehensive reports after visiting many websites.
Don&#x27;t hesitate to search for many queries at once in a for loop.
For each data point that you find, visit the source url to confirm numbers.

<span class="hljs-subst">{task}</span>
&quot;&quot;&quot;</span>)

<span class="hljs-built_in">print</span>(detailed_report)`,wrap:!1}}),Il=new i({props:{code:"ZGV0YWlsZWRfcmVwb3J0",highlighted:"detailed_report",wrap:!1}}),jl=new i({props:{code:"JTdDJTIwJTIwJTdDJTIwTG9jYXRpb24lMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjBUcmF2ZWwlMjBUaW1lJTIwKGhvdXJzKSUyMCU3QyUwQSU3Qy0tJTdDLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0lN0MtLS0tLS0tLS0tLS0tLS0tLS0tLS0lN0MlMEElN0MlMjAwJTIwJTIwJTdDJTIwQnJpZGdlJTIwb2YlMjBTaWdocyUyQyUyMEdsYXNnb3clMjBOZWNyb3BvbGlzJTJDJTIwR2xhc2dvdyUyQyUyMFVLJTIwJTdDJTIwOC42JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTBBJTdDJTIwMSUyMCUyMCU3QyUyMFdpc2hhcnQlMjBTdHJlZXQlMkMlMjBHbGFzZ293JTJDJTIwU2NvdGxhbmQlMkMlMjBVSyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMDguNiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3Qw==",highlighted:`|  | Location                                         | Travel Time (hours) |
|--|--------------------------------------------------|---------------------|
| <span class="hljs-number">0</span>  | Bridge of Sighs, Glasgow Necropolis, Glasgow, UK | <span class="hljs-number">8.6</span>                 |
| <span class="hljs-number">1</span>  | Wishart Street, Glasgow, Scotland, UK         | <span class="hljs-number">8.6</span>                 |`,wrap:!1}}),nl=new Ql({props:{title:"✌️ Splitting the task between two agents",local:"-splitting-the-task-between-two-agents",headingTag:"h3"}}),gl=new i({props:{code:"bW9kZWwlMjAlM0QlMjBIZkFwaU1vZGVsKCUwQSUyMCUyMCUyMCUyMCUyMlF3ZW4lMkZRd2VuMi41LUNvZGVyLTMyQi1JbnN0cnVjdCUyMiUyQyUyMHByb3ZpZGVyJTNEJTIydG9nZXRoZXIlMjIlMkMlMjBtYXhfdG9rZW5zJTNEODA5NiUwQSklMEElMEF3ZWJfYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwR29vZ2xlU2VhcmNoVG9vbChwcm92aWRlciUzRCUyMnNlcnBlciUyMiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBWaXNpdFdlYnBhZ2VUb29sKCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjYWxjdWxhdGVfY2FyZ29fdHJhdmVsX3RpbWUlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIyd2ViX2FnZW50JTIyJTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0QlMjJCcm93c2VzJTIwdGhlJTIwd2ViJTIwdG8lMjBmaW5kJTIwaW5mb3JtYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjB2ZXJib3NpdHlfbGV2ZWwlM0QwJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3N0ZXBzJTNEMTAlMkMlMEEp",highlighted:`model = HfApiModel(
    <span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>, provider=<span class="hljs-string">&quot;together&quot;</span>, max_tokens=<span class="hljs-number">8096</span>
)

web_agent = CodeAgent(
    model=model,
    tools=[
        GoogleSearchTool(provider=<span class="hljs-string">&quot;serper&quot;</span>),
        VisitWebpageTool(),
        calculate_cargo_travel_time,
    ],
    name=<span class="hljs-string">&quot;web_agent&quot;</span>,
    description=<span class="hljs-string">&quot;Browses the web to find information&quot;</span>,
    verbosity_level=<span class="hljs-number">0</span>,
    max_steps=<span class="hljs-number">10</span>,
)`,wrap:!1}}),cl=new i({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents.utils <span class="hljs-keyword">import</span> encode_image_base64, make_image_url
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> OpenAIServerModel


<span class="hljs-keyword">def</span> <span class="hljs-title function_">check_reasoning_and_plot</span>(<span class="hljs-params">final_answer, agent_memory</span>):
    final_answer
    multimodal_model = OpenAIServerModel(<span class="hljs-string">&quot;gpt-4o&quot;</span>, max_tokens=<span class="hljs-number">8096</span>)
    filepath = <span class="hljs-string">&quot;saved_map.png&quot;</span>
    <span class="hljs-keyword">assert</span> os.path.exists(filepath), <span class="hljs-string">&quot;Make sure to save the plot under saved_map.png!&quot;</span>
    image = Image.<span class="hljs-built_in">open</span>(filepath)
    prompt = (
        <span class="hljs-string">f&quot;Here is a user-given task and the agent steps: <span class="hljs-subst">{agent_memory.get_succinct_steps()}</span>. Now here is the plot that was made.&quot;</span>
        <span class="hljs-string">&quot;Please check that the reasoning process and plot are correct: do they correctly answer the given task?&quot;</span>
        <span class="hljs-string">&quot;First list reasons why yes/no, then write your final decision: PASS in caps lock if it is satisfactory, FAIL if it is not.&quot;</span>
        <span class="hljs-string">&quot;Don&#x27;t be harsh: if the plot mostly solves the task, it should pass.&quot;</span>
        <span class="hljs-string">&quot;To pass, a plot should be made using px.scatter_map and not any other method (scatter_map looks nicer).&quot;</span>
    )
    messages = [
        {
            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
            <span class="hljs-string">&quot;content&quot;</span>: [
                {
                    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
                    <span class="hljs-string">&quot;text&quot;</span>: prompt,
                },
                {
                    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image_url&quot;</span>,
                    <span class="hljs-string">&quot;image_url&quot;</span>: {<span class="hljs-string">&quot;url&quot;</span>: make_image_url(encode_image_base64(image))},
                },
            ],
        }
    ]
    output = multimodal_model(messages).content
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Feedback: &quot;</span>, output)
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;FAIL&quot;</span> <span class="hljs-keyword">in</span> output:
        <span class="hljs-keyword">raise</span> Exception(output)
    <span class="hljs-keyword">return</span> <span class="hljs-literal">True</span>


manager_agent = CodeAgent(
    model=HfApiModel(<span class="hljs-string">&quot;deepseek-ai/DeepSeek-R1&quot;</span>, provider=<span class="hljs-string">&quot;together&quot;</span>, max_tokens=<span class="hljs-number">8096</span>),
    tools=[calculate_cargo_travel_time],
    managed_agents=[web_agent],
    additional_authorized_imports=[
        <span class="hljs-string">&quot;geopandas&quot;</span>,
        <span class="hljs-string">&quot;plotly&quot;</span>,
        <span class="hljs-string">&quot;shapely&quot;</span>,
        <span class="hljs-string">&quot;json&quot;</span>,
        <span class="hljs-string">&quot;pandas&quot;</span>,
        <span class="hljs-string">&quot;numpy&quot;</span>,
    ],
    planning_interval=<span class="hljs-number">5</span>,
    verbosity_level=<span class="hljs-number">2</span>,
    final_answer_checks=[check_reasoning_and_plot],
    max_steps=<span class="hljs-number">15</span>,
)`,wrap:!1}}),kl=new i({props:{code:"bWFuYWdlcl9hZ2VudC52aXN1YWxpemUoKQ==",highlighted:"manager_agent.visualize()",wrap:!1}}),ul=new i({props:{code:"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",highlighted:`CodeAgent | deepseek-ai/DeepSeek-R1
├── ✅ Authorized imports: [<span class="hljs-string">&#x27;geopandas&#x27;</span>, <span class="hljs-string">&#x27;plotly&#x27;</span>, <span class="hljs-string">&#x27;shapely&#x27;</span>, <span class="hljs-string">&#x27;json&#x27;</span>, <span class="hljs-string">&#x27;pandas&#x27;</span>, <span class="hljs-string">&#x27;numpy&#x27;</span>]
├── 🛠️ Tools:
│   ┏━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓
│   ┃ Name                        ┃ Description                           ┃ Arguments                             ┃
│   ┡━━━━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┩
│   │ calculate_cargo_travel_time │ Calculate the travel time <span class="hljs-keyword">for</span> a cargo │ origin_coords (\`array\`): <span class="hljs-type">Tuple</span> of     │
│   │                             │ plane between two points on Earth     │ (latitude, longitude) <span class="hljs-keyword">for</span> the         │
│   │                             │ using great-circle distance.          │ starting point                        │
│   │                             │                                       │ destination_coords (\`array\`): <span class="hljs-type">Tuple</span>   │
│   │                             │                                       │ of (latitude, longitude) <span class="hljs-keyword">for</span> the      │
│   │                             │                                       │ destination                           │
│   │                             │                                       │ cruising_speed_kmh (\`number\`):        │
│   │                             │                                       │ <span class="hljs-type">Optional</span> cruising speed <span class="hljs-keyword">in</span> km/h       │
│   │                             │                                       │ (defaults to <span class="hljs-number">750</span> km/h <span class="hljs-keyword">for</span> typical     │
│   │                             │                                       │ cargo planes)                         │
│   │ final_answer                │ Provides a final answer to the given  │ answer (\`<span class="hljs-built_in">any</span>\`): The final answer to   │
│   │                             │ problem.                              │ the problem                           │
│   └─────────────────────────────┴───────────────────────────────────────┴───────────────────────────────────────┘
└── 🤖 Managed agents:
    └── web_agent | CodeAgent | Qwen/Qwen2<span class="hljs-number">.5</span>-Coder-32B-Instruct
        ├── ✅ Authorized imports: []
        ├── 📝 Description: Browses the web to find information
        └── 🛠️ Tools:
            ┏━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓
            ┃ Name                        ┃ Description                       ┃ Arguments                         ┃
            ┡━━━━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┩
            │ web_search                  │ Performs a google web search <span class="hljs-keyword">for</span>  │ query (\`string\`): The search      │
            │                             │ your query then returns a string  │ query to perform.                 │
            │                             │ of the top search results.        │ filter_year (\`integer\`):          │
            │                             │                                   │ Optionally restrict results to a  │
            │                             │                                   │ certain year                      │
            │ visit_webpage               │ Visits a webpage at the given url │ url (\`string\`): The url of the    │
            │                             │ <span class="hljs-keyword">and</span> reads its content <span class="hljs-keyword">as</span> a        │ webpage to visit.                 │
            │                             │ markdown string. Use this to      │                                   │
            │                             │ browse webpages.                  │                                   │
            │ calculate_cargo_travel_time │ Calculate the travel time <span class="hljs-keyword">for</span> a   │ origin_coords (\`array\`): <span class="hljs-type">Tuple</span> of │
            │                             │ cargo plane between two points on │ (latitude, longitude) <span class="hljs-keyword">for</span> the     │
            │                             │ Earth using great-circle          │ starting point                    │
            │                             │ distance.                         │ destination_coords (\`array\`):     │
            │                             │                                   │ <span class="hljs-type">Tuple</span> of (latitude, longitude)    │
            │                             │                                   │ <span class="hljs-keyword">for</span> the destination               │
            │                             │                                   │ cruising_speed_kmh (\`number\`):    │
            │                             │                                   │ <span class="hljs-type">Optional</span> cruising speed <span class="hljs-keyword">in</span> km/h   │
            │                             │                                   │ (defaults to <span class="hljs-number">750</span> km/h <span class="hljs-keyword">for</span> typical │
            │                             │                                   │ cargo planes)                     │
            │ final_answer                │ Provides a final answer to the    │ answer (\`<span class="hljs-built_in">any</span>\`): The final answer  │
            │                             │ given problem.                    │ to the problem                    │
            └─────────────────────────────┴───────────────────────────────────┴───────────────────────────────────┘`,wrap:!1}}),bl=new i({props:{code:"bWFuYWdlcl9hZ2VudC5ydW4oJTIyJTIyJTIyJTBBRmluZCUyMGFsbCUyMEJhdG1hbiUyMGZpbG1pbmclMjBsb2NhdGlvbnMlMjBpbiUyMHRoZSUyMHdvcmxkJTJDJTIwY2FsY3VsYXRlJTIwdGhlJTIwdGltZSUyMHRvJTIwdHJhbnNmZXIlMjB2aWElMjBjYXJnbyUyMHBsYW5lJTIwdG8lMjBoZXJlJTIwKHdlJ3JlJTIwaW4lMjBHb3RoYW0lMkMlMjA0MC43MTI4JUMyJUIwJTIwTiUyQyUyMDc0LjAwNjAlQzIlQjAlMjBXKS4lMEFBbHNvJTIwZ2l2ZSUyMG1lJTIwc29tZSUyMHN1cGVyY2FyJTIwZmFjdG9yaWVzJTIwd2l0aCUyMHRoZSUyMHNhbWUlMjBjYXJnbyUyMHBsYW5lJTIwdHJhbnNmZXIlMjB0aW1lLiUyMFlvdSUyMG5lZWQlMjBhdCUyMGxlYXN0JTIwNiUyMHBvaW50cyUyMGluJTIwdG90YWwuJTBBUmVwcmVzZW50JTIwdGhpcyUyMGFzJTIwc3BhdGlhbCUyMG1hcCUyMG9mJTIwdGhlJTIwd29ybGQlMkMlMjB3aXRoJTIwdGhlJTIwbG9jYXRpb25zJTIwcmVwcmVzZW50ZWQlMjBhcyUyMHNjYXR0ZXIlMjBwb2ludHMlMjB3aXRoJTIwYSUyMGNvbG9yJTIwdGhhdCUyMGRlcGVuZHMlMjBvbiUyMHRoZSUyMHRyYXZlbCUyMHRpbWUlMkMlMjBhbmQlMjBzYXZlJTIwaXQlMjB0byUyMHNhdmVkX21hcC5wbmchJTBBJTBBSGVyZSdzJTIwYW4lMjBleGFtcGxlJTIwb2YlMjBob3clMjB0byUyMHBsb3QlMjBhbmQlMjByZXR1cm4lMjBhJTIwbWFwJTNBJTBBaW1wb3J0JTIwcGxvdGx5LmV4cHJlc3MlMjBhcyUyMHB4JTBBZGYlMjAlM0QlMjBweC5kYXRhLmNhcnNoYXJlKCklMEFmaWclMjAlM0QlMjBweC5zY2F0dGVyX21hcChkZiUyQyUyMGxhdCUzRCUyMmNlbnRyb2lkX2xhdCUyMiUyQyUyMGxvbiUzRCUyMmNlbnRyb2lkX2xvbiUyMiUyQyUyMHRleHQlM0QlMjJuYW1lJTIyJTJDJTIwY29sb3IlM0QlMjJwZWFrX2hvdXIlMjIlMkMlMjBzaXplJTNEMTAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwY29sb3JfY29udGludW91c19zY2FsZSUzRHB4LmNvbG9ycy5zZXF1ZW50aWFsLk1hZ21hJTJDJTIwc2l6ZV9tYXglM0QxNSUyQyUyMHpvb20lM0QxKSUwQWZpZy5zaG93KCklMEFmaWcud3JpdGVfaW1hZ2UoJTIyc2F2ZWRfaW1hZ2UucG5nJTIyKSUwQWZpbmFsX2Fuc3dlcihmaWcpJTBBJTBBTmV2ZXIlMjB0cnklMjB0byUyMHByb2Nlc3MlMjBzdHJpbmdzJTIwdXNpbmclMjBjb2RlJTNBJTIwd2hlbiUyMHlvdSUyMGhhdmUlMjBhJTIwc3RyaW5nJTIwdG8lMjByZWFkJTJDJTIwanVzdCUyMHByaW50JTIwaXQlMjBhbmQlMjB5b3UnbGwlMjBzZWUlMjBpdC4lMEElMjIlMjIlMjIp",highlighted:`manager_agent.run(<span class="hljs-string">&quot;&quot;&quot;
Find all Batman filming locations in the world, calculate the time to transfer via cargo plane to here (we&#x27;re in Gotham, 40.7128° N, 74.0060° W).
Also give me some supercar factories with the same cargo plane transfer time. You need at least 6 points in total.
Represent this as spatial map of the world, with the locations represented as scatter points with a color that depends on the travel time, and save it to saved_map.png!

Here&#x27;s an example of how to plot and return a map:
import plotly.express as px
df = px.data.carshare()
fig = px.scatter_map(df, lat=&quot;centroid_lat&quot;, lon=&quot;centroid_lon&quot;, text=&quot;name&quot;, color=&quot;peak_hour&quot;, size=100,
     color_continuous_scale=px.colors.sequential.Magma, size_max=15, zoom=1)
fig.show()
fig.write_image(&quot;saved_image.png&quot;)
final_answer(fig)

Never try to process strings using code: when you have a string to read, just print it and you&#x27;ll see it.
&quot;&quot;&quot;</span>)`,wrap:!1}}),Vl=new i({props:{code:"bWFuYWdlcl9hZ2VudC5weXRob25fZXhlY3V0b3Iuc3RhdGUlNUIlMjJmaWclMjIlNUQ=",highlighted:'manager_agent.python_executor.state[<span class="hljs-string">&quot;fig&quot;</span>]',wrap:!1}}),xl=new Ql({props:{title:"Resources",local:"resources",headingTag:"h2"}}),fl=new UT({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit2/smolagents/multi_agent_systems.mdx"}}),{c(){o=y("meta"),p=U(),r=y("p"),g=U(),e(C.$$.fragment),m=U(),e(d.$$.fragment),vl=U(),k=y("p"),k.innerHTML=MJ,Ol=U(),h=y("p"),h.innerHTML=JJ,Dl=U(),u=y("p"),u.textContent=TJ,El=U(),b=y("ul"),b.innerHTML=UJ,Yl=U(),B=y("p"),B.innerHTML=wJ,Xl=U(),N=y("img"),Hl=U(),e(V.$$.fragment),_l=U(),S=y("p"),S.innerHTML=tJ,$l=U(),F=y("p"),F.innerHTML=IJ,zl=U(),x=y("ul"),x.innerHTML=eJ,Ll=U(),G=y("p"),G.textContent=jJ,ql=U(),e(f.$$.fragment),Kl=U(),e(c.$$.fragment),Pl=U(),Q=y("p"),Q.textContent=sJ,lM=U(),R=y("p"),R.textContent=AJ,MM=U(),Z=y("p"),Z.textContent=aJ,JM=U(),W=y("p"),W.textContent=nJ,TM=U(),v=y("p"),v.textContent=CJ,UM=U(),O=y("blockquote"),O.innerHTML=iJ,wM=U(),D=y("p"),D.textContent=oJ,yM=U(),E=y("p"),E.textContent=pJ,tM=U(),e(Y.$$.fragment),IM=U(),e(X.$$.fragment),eM=U(),e(H.$$.fragment),jM=U(),e(_.$$.fragment),sM=U(),$=y("p"),$.innerHTML=gJ,AM=U(),z=y("p"),z.innerHTML=rJ,aM=U(),L=y("p"),L.innerHTML=mJ,nM=U(),e(q.$$.fragment),CM=U(),K=y("p"),K.textContent=cJ,iM=U(),e(P.$$.fragment),oM=U(),e(ll.$$.fragment),pM=U(),e(Ml.$$.fragment),gM=U(),e(Jl.$$.fragment),rM=U(),Tl=y("p"),Tl.textContent=dJ,mM=U(),e(Ul.$$.fragment),cM=U(),wl=y("p"),wl.textContent=kJ,dM=U(),yl=y("p"),yl.textContent=hJ,kM=U(),e(tl.$$.fragment),hM=U(),e(Il.$$.fragment),uM=U(),el=y("p"),el.textContent=uJ,bM=U(),e(jl.$$.fragment),BM=U(),sl=y("p"),sl.textContent=bJ,NM=U(),Al=y("p"),Al.innerHTML=BJ,VM=U(),al=y("p"),al.textContent=NJ,SM=U(),e(nl.$$.fragment),FM=U(),Cl=y("p"),Cl.textContent=VJ,xM=U(),il=y("ul"),il.innerHTML=SJ,GM=U(),ol=y("p"),ol.textContent=FJ,fM=U(),pl=y("p"),pl.innerHTML=xJ,QM=U(),e(gl.$$.fragment),RM=U(),rl=y("p"),rl.textContent=GJ,ZM=U(),ml=y("p"),ml.innerHTML=fJ,WM=U(),e(cl.$$.fragment),vM=U(),dl=y("p"),dl.textContent=QJ,OM=U(),e(kl.$$.fragment),DM=U(),hl=y("p"),hl.textContent=RJ,EM=U(),e(ul.$$.fragment),YM=U(),e(bl.$$.fragment),XM=U(),Bl=y("p"),Bl.innerHTML=ZJ,HM=U(),Nl=y("p"),Nl.textContent=WJ,_M=U(),e(Vl.$$.fragment),$M=U(),Sl=y("p"),Sl.textContent=vJ,zM=U(),Fl=y("p"),Fl.innerHTML=OJ,LM=U(),e(xl.$$.fragment),qM=U(),Gl=y("ul"),Gl.innerHTML=DJ,KM=U(),e(fl.$$.fragment),PM=U(),Rl=y("p"),this.h()},l(l){const M=PJ("svelte-u9bgzb",document.head);o=t(M,"META",{name:!0,content:!0}),M.forEach(J),p=w(l),r=t(l,"P",{}),YJ(r).forEach(J),g=w(l),j(C.$$.fragment,l),m=w(l),j(d.$$.fragment,l),vl=w(l),k=t(l,"P",{"data-svelte-h":!0}),I(k)!=="svelte-1utk6uq"&&(k.innerHTML=MJ),Ol=w(l),h=t(l,"P",{"data-svelte-h":!0}),I(h)!=="svelte-495kbr"&&(h.innerHTML=JJ),Dl=w(l),u=t(l,"P",{"data-svelte-h":!0}),I(u)!=="svelte-7rzbsb"&&(u.textContent=TJ),El=w(l),b=t(l,"UL",{"data-svelte-h":!0}),I(b)!=="svelte-4g0mr"&&(b.innerHTML=UJ),Yl=w(l),B=t(l,"P",{"data-svelte-h":!0}),I(B)!=="svelte-1w7g1oo"&&(B.innerHTML=wJ),Xl=w(l),N=t(l,"IMG",{src:!0,style:!0}),Hl=w(l),j(V.$$.fragment,l),_l=w(l),S=t(l,"P",{"data-svelte-h":!0}),I(S)!=="svelte-1y9d32a"&&(S.innerHTML=tJ),$l=w(l),F=t(l,"P",{"data-svelte-h":!0}),I(F)!=="svelte-5zisae"&&(F.innerHTML=IJ),zl=w(l),x=t(l,"UL",{"data-svelte-h":!0}),I(x)!=="svelte-1yhsihd"&&(x.innerHTML=eJ),Ll=w(l),G=t(l,"P",{"data-svelte-h":!0}),I(G)!=="svelte-1rcqnot"&&(G.textContent=jJ),ql=w(l),j(f.$$.fragment,l),Kl=w(l),j(c.$$.fragment,l),Pl=w(l),Q=t(l,"P",{"data-svelte-h":!0}),I(Q)!=="svelte-5kqcy3"&&(Q.textContent=sJ),lM=w(l),R=t(l,"P",{"data-svelte-h":!0}),I(R)!=="svelte-beftqy"&&(R.textContent=AJ),MM=w(l),Z=t(l,"P",{"data-svelte-h":!0}),I(Z)!=="svelte-e3wlek"&&(Z.textContent=aJ),JM=w(l),W=t(l,"P",{"data-svelte-h":!0}),I(W)!=="svelte-vokbk8"&&(W.textContent=nJ),TM=w(l),v=t(l,"P",{"data-svelte-h":!0}),I(v)!=="svelte-s6dymp"&&(v.textContent=CJ),UM=w(l),O=t(l,"BLOCKQUOTE",{"data-svelte-h":!0}),I(O)!=="svelte-dczmp8"&&(O.innerHTML=iJ),wM=w(l),D=t(l,"P",{"data-svelte-h":!0}),I(D)!=="svelte-1nbo15e"&&(D.textContent=oJ),yM=w(l),E=t(l,"P",{"data-svelte-h":!0}),I(E)!=="svelte-1k3qpbd"&&(E.textContent=pJ),tM=w(l),j(Y.$$.fragment,l),IM=w(l),j(X.$$.fragment,l),eM=w(l),j(H.$$.fragment,l),jM=w(l),j(_.$$.fragment,l),sM=w(l),$=t(l,"P",{"data-svelte-h":!0}),I($)!=="svelte-patzp8"&&($.innerHTML=gJ),AM=w(l),z=t(l,"P",{"data-svelte-h":!0}),I(z)!=="svelte-f8fqei"&&(z.innerHTML=rJ),aM=w(l),L=t(l,"P",{"data-svelte-h":!0}),I(L)!=="svelte-1vx2pje"&&(L.innerHTML=mJ),nM=w(l),j(q.$$.fragment,l),CM=w(l),K=t(l,"P",{"data-svelte-h":!0}),I(K)!=="svelte-1ix25jf"&&(K.textContent=cJ),iM=w(l),j(P.$$.fragment,l),oM=w(l),j(ll.$$.fragment,l),pM=w(l),j(Ml.$$.fragment,l),gM=w(l),j(Jl.$$.fragment,l),rM=w(l),Tl=t(l,"P",{"data-svelte-h":!0}),I(Tl)!=="svelte-xzrd3x"&&(Tl.textContent=dJ),mM=w(l),j(Ul.$$.fragment,l),cM=w(l),wl=t(l,"P",{"data-svelte-h":!0}),I(wl)!=="svelte-1ii1il1"&&(wl.textContent=kJ),dM=w(l),yl=t(l,"P",{"data-svelte-h":!0}),I(yl)!=="svelte-korqsh"&&(yl.textContent=hJ),kM=w(l),j(tl.$$.fragment,l),hM=w(l),j(Il.$$.fragment,l),uM=w(l),el=t(l,"P",{"data-svelte-h":!0}),I(el)!=="svelte-xzrd3x"&&(el.textContent=uJ),bM=w(l),j(jl.$$.fragment,l),BM=w(l),sl=t(l,"P",{"data-svelte-h":!0}),I(sl)!=="svelte-8nkvul"&&(sl.textContent=bJ),NM=w(l),Al=t(l,"P",{"data-svelte-h":!0}),I(Al)!=="svelte-1gyvx6b"&&(Al.innerHTML=BJ),VM=w(l),al=t(l,"P",{"data-svelte-h":!0}),I(al)!=="svelte-vkmihl"&&(al.textContent=NJ),SM=w(l),j(nl.$$.fragment,l),FM=w(l),Cl=t(l,"P",{"data-svelte-h":!0}),I(Cl)!=="svelte-9zsog"&&(Cl.textContent=VJ),xM=w(l),il=t(l,"UL",{"data-svelte-h":!0}),I(il)!=="svelte-gafqe4"&&(il.innerHTML=SJ),GM=w(l),ol=t(l,"P",{"data-svelte-h":!0}),I(ol)!=="svelte-hh9or6"&&(ol.textContent=FJ),fM=w(l),pl=t(l,"P",{"data-svelte-h":!0}),I(pl)!=="svelte-k4jxva"&&(pl.innerHTML=xJ),QM=w(l),j(gl.$$.fragment,l),RM=w(l),rl=t(l,"P",{"data-svelte-h":!0}),I(rl)!=="svelte-kidlug"&&(rl.textContent=GJ),ZM=w(l),ml=t(l,"P",{"data-svelte-h":!0}),I(ml)!=="svelte-5b9vd4"&&(ml.innerHTML=fJ),WM=w(l),j(cl.$$.fragment,l),vM=w(l),dl=t(l,"P",{"data-svelte-h":!0}),I(dl)!=="svelte-x8evmd"&&(dl.textContent=QJ),OM=w(l),j(kl.$$.fragment,l),DM=w(l),hl=t(l,"P",{"data-svelte-h":!0}),I(hl)!=="svelte-1m5hm05"&&(hl.textContent=RJ),EM=w(l),j(ul.$$.fragment,l),YM=w(l),j(bl.$$.fragment,l),XM=w(l),Bl=t(l,"P",{"data-svelte-h":!0}),I(Bl)!=="svelte-1wpsn6f"&&(Bl.innerHTML=ZJ),HM=w(l),Nl=t(l,"P",{"data-svelte-h":!0}),I(Nl)!=="svelte-1djejr1"&&(Nl.textContent=WJ),_M=w(l),j(Vl.$$.fragment,l),$M=w(l),Sl=t(l,"P",{"data-svelte-h":!0}),I(Sl)!=="svelte-1slbqua"&&(Sl.textContent=vJ),zM=w(l),Fl=t(l,"P",{"data-svelte-h":!0}),I(Fl)!=="svelte-z627a9"&&(Fl.innerHTML=OJ),LM=w(l),j(xl.$$.fragment,l),qM=w(l),Gl=t(l,"UL",{"data-svelte-h":!0}),I(Gl)!=="svelte-sve9y7"&&(Gl.innerHTML=DJ),KM=w(l),j(fl.$$.fragment,l),PM=w(l),Rl=t(l,"P",{}),YJ(Rl).forEach(J),this.h()},h(){Zl(o,"name","hf:doc:metadata"),Zl(o,"content",tT),$J(N.src,yJ="https://mermaid.ink/img/pako:eNp1kc1qhTAQRl9FUiQb8wIpdNO76eKubrmFks1oRg3VSYgjpYjv3lFL_2hnMWQOJwn5sqgmelRWleUSKLAtFs09jqhtoWuYUFfFAa6QA9QDTnpzamheuhxn8pt40-6l13UtS0ddhtQXj6dbR4XUGQg6zEYasTF393KjeSDGnDJKNxzj8I_7hLW5IOSmP9CH9hv_NL-d94d4DVNg84p1EnK4qlIj5hGClySWbadT-6OdsrL02MI8sFOOVkciw8zx8kaNspxnrJQE0fXKtjBMMs3JA-MpgOQwftIE9Bzj14w-cMznI_39E9Z3p0uFoA?type=png")||Zl(N,"src",yJ),lT(N,"background","white")},m(l,M){MT(document.head,o),T(l,p,M),T(l,r,M),T(l,g,M),s(C,l,M),T(l,m,M),s(d,l,M),T(l,vl,M),T(l,k,M),T(l,Ol,M),T(l,h,M),T(l,Dl,M),T(l,u,M),T(l,El,M),T(l,b,M),T(l,Yl,M),T(l,B,M),T(l,Xl,M),T(l,N,M),T(l,Hl,M),s(V,l,M),T(l,_l,M),T(l,S,M),T(l,$l,M),T(l,F,M),T(l,zl,M),T(l,x,M),T(l,Ll,M),T(l,G,M),T(l,ql,M),s(f,l,M),T(l,Kl,M),s(c,l,M),T(l,Pl,M),T(l,Q,M),T(l,lM,M),T(l,R,M),T(l,MM,M),T(l,Z,M),T(l,JM,M),T(l,W,M),T(l,TM,M),T(l,v,M),T(l,UM,M),T(l,O,M),T(l,wM,M),T(l,D,M),T(l,yM,M),T(l,E,M),T(l,tM,M),s(Y,l,M),T(l,IM,M),s(X,l,M),T(l,eM,M),s(H,l,M),T(l,jM,M),s(_,l,M),T(l,sM,M),T(l,$,M),T(l,AM,M),T(l,z,M),T(l,aM,M),T(l,L,M),T(l,nM,M),s(q,l,M),T(l,CM,M),T(l,K,M),T(l,iM,M),s(P,l,M),T(l,oM,M),s(ll,l,M),T(l,pM,M),s(Ml,l,M),T(l,gM,M),s(Jl,l,M),T(l,rM,M),T(l,Tl,M),T(l,mM,M),s(Ul,l,M),T(l,cM,M),T(l,wl,M),T(l,dM,M),T(l,yl,M),T(l,kM,M),s(tl,l,M),T(l,hM,M),s(Il,l,M),T(l,uM,M),T(l,el,M),T(l,bM,M),s(jl,l,M),T(l,BM,M),T(l,sl,M),T(l,NM,M),T(l,Al,M),T(l,VM,M),T(l,al,M),T(l,SM,M),s(nl,l,M),T(l,FM,M),T(l,Cl,M),T(l,xM,M),T(l,il,M),T(l,GM,M),T(l,ol,M),T(l,fM,M),T(l,pl,M),T(l,QM,M),s(gl,l,M),T(l,RM,M),T(l,rl,M),T(l,ZM,M),T(l,ml,M),T(l,WM,M),s(cl,l,M),T(l,vM,M),T(l,dl,M),T(l,OM,M),s(kl,l,M),T(l,DM,M),T(l,hl,M),T(l,EM,M),s(ul,l,M),T(l,YM,M),s(bl,l,M),T(l,XM,M),T(l,Bl,M),T(l,HM,M),T(l,Nl,M),T(l,_M,M),s(Vl,l,M),T(l,$M,M),T(l,Sl,M),T(l,zM,M),T(l,Fl,M),T(l,LM,M),s(xl,l,M),T(l,qM,M),T(l,Gl,M),T(l,KM,M),s(fl,l,M),T(l,PM,M),T(l,Rl,M),lJ=!0},p(l,[M]){const EJ={};M&2&&(EJ.$$scope={dirty:M,ctx:l}),c.$set(EJ)},i(l){lJ||(A(C.$$.fragment,l),A(d.$$.fragment,l),A(V.$$.fragment,l),A(f.$$.fragment,l),A(c.$$.fragment,l),A(Y.$$.fragment,l),A(X.$$.fragment,l),A(H.$$.fragment,l),A(_.$$.fragment,l),A(q.$$.fragment,l),A(P.$$.fragment,l),A(ll.$$.fragment,l),A(Ml.$$.fragment,l),A(Jl.$$.fragment,l),A(Ul.$$.fragment,l),A(tl.$$.fragment,l),A(Il.$$.fragment,l),A(jl.$$.fragment,l),A(nl.$$.fragment,l),A(gl.$$.fragment,l),A(cl.$$.fragment,l),A(kl.$$.fragment,l),A(ul.$$.fragment,l),A(bl.$$.fragment,l),A(Vl.$$.fragment,l),A(xl.$$.fragment,l),A(fl.$$.fragment,l),lJ=!0)},o(l){a(C.$$.fragment,l),a(d.$$.fragment,l),a(V.$$.fragment,l),a(f.$$.fragment,l),a(c.$$.fragment,l),a(Y.$$.fragment,l),a(X.$$.fragment,l),a(H.$$.fragment,l),a(_.$$.fragment,l),a(q.$$.fragment,l),a(P.$$.fragment,l),a(ll.$$.fragment,l),a(Ml.$$.fragment,l),a(Jl.$$.fragment,l),a(Ul.$$.fragment,l),a(tl.$$.fragment,l),a(Il.$$.fragment,l),a(jl.$$.fragment,l),a(nl.$$.fragment,l),a(gl.$$.fragment,l),a(cl.$$.fragment,l),a(kl.$$.fragment,l),a(ul.$$.fragment,l),a(bl.$$.fragment,l),a(Vl.$$.fragment,l),a(xl.$$.fragment,l),a(fl.$$.fragment,l),lJ=!1},d(l){l&&(J(p),J(r),J(g),J(m),J(vl),J(k),J(Ol),J(h),J(Dl),J(u),J(El),J(b),J(Yl),J(B),J(Xl),J(N),J(Hl),J(_l),J(S),J($l),J(F),J(zl),J(x),J(Ll),J(G),J(ql),J(Kl),J(Pl),J(Q),J(lM),J(R),J(MM),J(Z),J(JM),J(W),J(TM),J(v),J(UM),J(O),J(wM),J(D),J(yM),J(E),J(tM),J(IM),J(eM),J(jM),J(sM),J($),J(AM),J(z),J(aM),J(L),J(nM),J(CM),J(K),J(iM),J(oM),J(pM),J(gM),J(rM),J(Tl),J(mM),J(cM),J(wl),J(dM),J(yl),J(kM),J(hM),J(uM),J(el),J(bM),J(BM),J(sl),J(NM),J(Al),J(VM),J(al),J(SM),J(FM),J(Cl),J(xM),J(il),J(GM),J(ol),J(fM),J(pl),J(QM),J(RM),J(rl),J(ZM),J(ml),J(WM),J(vM),J(dl),J(OM),J(DM),J(hl),J(EM),J(YM),J(XM),J(Bl),J(HM),J(Nl),J(_M),J($M),J(Sl),J(zM),J(Fl),J(LM),J(qM),J(Gl),J(KM),J(PM),J(Rl)),J(o),n(C,l),n(d,l),n(V,l),n(f,l),n(c,l),n(Y,l),n(X,l),n(H,l),n(_,l),n(q,l),n(P,l),n(ll,l),n(Ml,l),n(Jl,l),n(Ul,l),n(tl,l),n(Il,l),n(jl,l),n(nl,l),n(gl,l),n(cl,l),n(kl,l),n(ul,l),n(bl,l),n(Vl,l),n(xl,l),n(fl,l)}}}const tT='{"title":"Multi-Agent Systems","local":"multi-agent-systems","sections":[{"title":"Multi-Agent Systems in Action","local":"multi-agent-systems-in-action","sections":[],"depth":2},{"title":"Solving a complex task with a multi-agent hierarchy","local":"solving-a-complex-task-with-a-multi-agent-hierarchy","sections":[{"title":"We first make a tool to get the cargo plane transfer time.","local":"we-first-make-a-tool-to-get-the-cargo-plane-transfer-time","sections":[],"depth":3},{"title":"Setting up the agent","local":"setting-up-the-agent","sections":[],"depth":3},{"title":"✌️ Splitting the task between two agents","local":"-splitting-the-task-between-two-agents","sections":[],"depth":3}],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function IT(Wl){return zJ(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class iT extends qJ{constructor(o){super(),KJ(this,o,IT,yT,_J,{})}}export{iT as component};
