import{s as qt,f as Bt,n as Wt,o as Qt}from"../chunks/scheduler.389d799c.js";import{S as Zt,i as Gt,g as i,s,r as p,A as Nt,h as o,f as a,c as n,j as vt,u as m,x as r,k as h,y as Et,a as l,v as u,d as M,t as y,w as d}from"../chunks/index.8f81d18f.js";import{C as ct}from"../chunks/CodeBlock.c0898180.js";import{H as _,E as At}from"../chunks/getInferenceSnippets.24ddde2c.js";function _t(gt){let c,F,x,V,w,X,f,R,J,Ut='Amazon SageMaker JumpStart lets you deploy the most-popular open Hugging Face models with one click—inside your own AWS account. JumpStart offers a curated <a href="https://aws.amazon.com/sagemaker-ai/jumpstart/getting-started/?sagemaker-jumpstart-cards.sort-by=item.additionalFields.model-name&amp;sagemaker-jumpstart-cards.sort-order=asc&amp;awsf.sagemaker-jumpstart-filter-product-type=*all&amp;awsf.sagemaker-jumpstart-filter-text=*all&amp;awsf.sagemaker-jumpstart-filter-vision=*all&amp;awsf.sagemaker-jumpstart-filter-tabular=*all&amp;awsf.sagemaker-jumpstart-filter-audio-tasks=*all&amp;awsf.sagemaker-jumpstart-filter-multimodal=*all&amp;awsf.sagemaker-jumpstart-filter-RL=*all&amp;awsm.page-sagemaker-jumpstart-cards=1&amp;sagemaker-jumpstart-cards.q=qwen&amp;sagemaker-jumpstart-cards.q_operator=AND" rel="nofollow">selection</a> of model checkpoints for various tasks, including text generation, embeddings, vision, audio, and more. Most models are deployed using the official <a href="https://huggingface.co/docs/sagemaker/main/en/dlcs/introduction" rel="nofollow">Hugging Face Deep Learning Containers</a> with a sensible default instance type, so you can move from idea to production in minutes.',Y,j,ht='In this quickstart guide, we will deploy <a href="https://huggingface.co/Qwen/Qwen2.5-14B-Instruct" rel="nofollow">Qwen/Qwen2.5-14B-Instruct</a>.',z,C,L,T,wt='<thead><tr><th></th> <th>Requirement</th></tr></thead> <tbody><tr><td>AWS account with SageMaker enabled</td> <td>An AWS account that will contain all your AWS resources.</td></tr> <tr><td>An IAM role to access SageMaker AI</td> <td>Learn more about how IAM works with SageMaker AI in this <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/security-iam.html" rel="nofollow">guide</a>.</td></tr> <tr><td>SageMaker Studio domain and user profile</td> <td>We recommend using SageMaker Studio for straightforward deployment and inference. Follow this <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/onboard-quick-start.html" rel="nofollow">guide</a>.</td></tr> <tr><td>Service quotas</td> <td>Most LLMs need GPU instances (e.g. ml.g5). Verify you have quota for <code>ml.g5.24xlarge</code> or <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/canvas-requesting-quota-increases.html" rel="nofollow">request it</a>.</td></tr></tbody>',P,k,D,b,ft="Let’s explain how you would deploy a Hugging Face model to SageMaker browsing through the Jumpstart catalog:",O,I,Jt="<li>Open SageMaker → JumpStart.</li> <li>Filter “Hugging Face” or search for your model (e.g. Qwen2.5-14B).</li> <li>Click Deploy → (optional) adjust instance size / count → Deploy.</li> <li>Wait until Endpoints shows In service.</li> <li>Copy the Endpoint name (or ARN) for later use.</li>",K,g,jt,tt,$,Ct="Alternatively, you can also browse through the Hugging Face Model Hub:",et,S,Tt="<li>Open the model page → Click Deploy → SageMaker → Jumpstart tab if model is available.</li> <li>Copy the code snippet and use it from a SageMaker Notebook instance.</li>",at,U,kt,lt,B,st,v,bt="The endpoint creation can take several minutes, depending on the size of the model.",nt,q,it,W,It="If you deployed through the console, you need to grab the endpoint ARN and reuse in your code.",ot,Q,rt,Z,$t="The endpoint support the Open AI API specification.",pt,G,mt,N,St="To avoid incurring unnecessary costs, when you’re done, delete the SageMaker endpoints in the Deployments → Endpoints console or using the following code snippets:",ut,E,Mt,A,yt,H,dt;return w=new _({props:{title:"Quickstart - Deploy Hugging Face Models with SageMaker Jumpstart",local:"quickstart---deploy-hugging-face-models-with-sagemaker-jumpstart",headingTag:"h1"}}),f=new _({props:{title:"Why use SageMaker JumpStart for Hugging Face models?",local:"why-use-sagemaker-jumpstart-for-hugging-face-models",headingTag:"h2"}}),C=new _({props:{title:"1. Prerequisites",local:"1-prerequisites",headingTag:"h2"}}),k=new _({props:{title:"2· Endpoint deployment",local:"2-endpoint-deployment",headingTag:"h2"}}),B=new ct({props:{code:"JTIzJTIwU2FnZU1ha2VyJTIwSnVtcFN0YXJ0JTIwcHJvdmlkZXMlMjBBUElzJTIwYXMlMjBwYXJ0JTIwb2YlMjBTYWdlTWFrZXIlMjBTREslMjB0aGF0JTIwYWxsb3clMjB5b3UlMjB0byUyMGRlcGxveSUyMGFuZCUyMGZpbmUtdHVuZSUyMG1vZGVscyUyMGluJTIwbmV0d29yayUyMGlzb2xhdGlvbiUyMHVzaW5nJTIwc2NyaXB0cyUyMHRoYXQlMjBTYWdlTWFrZXIlMjBtYWludGFpbnMuJTBBJTBBZnJvbSUyMHNhZ2VtYWtlci5qdW1wc3RhcnQubW9kZWwlMjBpbXBvcnQlMjBKdW1wU3RhcnRNb2RlbCUwQSUwQSUwQW1vZGVsJTIwJTNEJTIwSnVtcFN0YXJ0TW9kZWwobW9kZWxfaWQlM0QlMjJodWdnaW5nZmFjZS1sbG0tcXdlbjItNS0xNGItaW5zdHJ1Y3QlMjIpJTBBZXhhbXBsZV9wYXlsb2FkcyUyMCUzRCUyMG1vZGVsLnJldHJpZXZlX2FsbF9leGFtcGxlcygpJTBBJTBBcHJlZGljdG9yJTIwJTNEJTIwbW9kZWwuZGVwbG95KCklMEElMEFmb3IlMjBwYXlsb2FkJTIwaW4lMjBleGFtcGxlX3BheWxvYWRzJTNBJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjBwcmVkaWN0b3IucHJlZGljdChwYXlsb2FkLmJvZHkpJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIySW5wdXQlM0ElNUNuJTIyJTJDJTIwcGF5bG9hZC5ib2R5JTVCcGF5bG9hZC5wcm9tcHRfa2V5JTVEKSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMk91dHB1dCUzQSU1Q24lMjIlMkMlMjByZXNwb25zZSU1QjAlNUQlNUIlMjJnZW5lcmF0ZWRfdGV4dCUyMiU1RCUyQyUyMCUyMiU1Q24lNUNuJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTVDbiUyMik=",highlighted:`<span class="hljs-comment"># SageMaker JumpStart provides APIs as part of SageMaker SDK that allow you to deploy and fine-tune models in network isolation using scripts that SageMaker maintains.</span>

<span class="hljs-keyword">from</span> sagemaker.jumpstart.model <span class="hljs-keyword">import</span> JumpStartModel


model = JumpStartModel(model_id=<span class="hljs-string">&quot;huggingface-llm-qwen2-5-14b-instruct&quot;</span>)
example_payloads = model.retrieve_all_examples()

predictor = model.deploy()

<span class="hljs-keyword">for</span> payload <span class="hljs-keyword">in</span> example_payloads:
    response = predictor.predict(payload.body)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Input:\\n&quot;</span>, payload.body[payload.prompt_key])
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Output:\\n&quot;</span>, response[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>], <span class="hljs-string">&quot;\\n\\n===============\\n&quot;</span>)`,wrap:!1}}),q=new _({props:{title:"3. Test interactively",local:"3-test-interactively",headingTag:"h2"}}),Q=new ct({props:{code:"ZnJvbSUyMHNhZ2VtYWtlci5wcmVkaWN0b3IlMjBpbXBvcnQlMjByZXRyaWV2ZV9kZWZhdWx0JTBBZW5kcG9pbnRfbmFtZSUyMCUzRCUyMCUyMk1ZJTIwRU5EUE9JTlQlMjBOQU1FJTIyJTBBcHJlZGljdG9yJTIwJTNEJTIwcmV0cmlldmVfZGVmYXVsdChlbmRwb2ludF9uYW1lKSUwQXBheWxvYWQlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJtZXNzYWdlcyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMHBhc3Npb25hdGUlMjBkYXRhJTIwc2NpZW50aXN0LiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMndoYXQlMjBpcyUyMG1hY2hpbmUlMjBsZWFybmluZyUzRiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMm1heF90b2tlbnMlMjIlM0ElMjAyMDQ4JTJDJTBBJTIwJTIwJTIwJTIwJTIydGVtcGVyYXR1cmUlMjIlM0ElMjAwLjclMkMlMEElMjAlMjAlMjAlMjAlMjJ0b3BfcCUyMiUzQSUyMDAuOSUyQyUwQSUyMCUyMCUyMCUyMCUyMnN0cmVhbSUyMiUzQSUyMEZhbHNlJTBBJTdEJTBBJTBBcmVzcG9uc2UlMjAlM0QlMjBwcmVkaWN0b3IucHJlZGljdChwYXlsb2FkKSUwQXByaW50KHJlc3BvbnNlKQ==",highlighted:`<span class="hljs-keyword">from</span> sagemaker.predictor <span class="hljs-keyword">import</span> retrieve_default
endpoint_name = <span class="hljs-string">&quot;MY ENDPOINT NAME&quot;</span>
predictor = retrieve_default(endpoint_name)
payload = {
    <span class="hljs-string">&quot;messages&quot;</span>: [
        {
            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
            <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a passionate data scientist.&quot;</span>
        },
        {
            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
            <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;what is machine learning?&quot;</span>
        }
    ],
    <span class="hljs-string">&quot;max_tokens&quot;</span>: <span class="hljs-number">2048</span>,
    <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.7</span>,
    <span class="hljs-string">&quot;top_p&quot;</span>: <span class="hljs-number">0.9</span>,
    <span class="hljs-string">&quot;stream&quot;</span>: <span class="hljs-literal">False</span>
}

response = predictor.predict(payload)
<span class="hljs-built_in">print</span>(response)`,wrap:!1}}),G=new _({props:{title:"4. Clean‑up",local:"4-cleanup",headingTag:"h2"}}),E=new ct({props:{code:"cHJlZGljdG9yLmRlbGV0ZV9tb2RlbCgpJTBBcHJlZGljdG9yLmRlbGV0ZV9lbmRwb2ludCgp",highlighted:`predictor.delete_model()
predictor.delete_endpoint()`,wrap:!1}}),A=new At({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/sagemaker/source/tutorials/jumpstart/jumpstart-quickstart.md"}}),{c(){c=i("meta"),F=s(),x=i("p"),V=s(),p(w.$$.fragment),X=s(),p(f.$$.fragment),R=s(),J=i("p"),J.innerHTML=Ut,Y=s(),j=i("p"),j.innerHTML=ht,z=s(),p(C.$$.fragment),L=s(),T=i("table"),T.innerHTML=wt,P=s(),p(k.$$.fragment),D=s(),b=i("p"),b.textContent=ft,O=s(),I=i("ol"),I.innerHTML=Jt,K=s(),g=i("img"),tt=s(),$=i("p"),$.textContent=Ct,et=s(),S=i("ol"),S.innerHTML=Tt,at=s(),U=i("img"),lt=s(),p(B.$$.fragment),st=s(),v=i("p"),v.textContent=bt,nt=s(),p(q.$$.fragment),it=s(),W=i("p"),W.textContent=It,ot=s(),p(Q.$$.fragment),rt=s(),Z=i("p"),Z.textContent=$t,pt=s(),p(G.$$.fragment),mt=s(),N=i("p"),N.textContent=St,ut=s(),p(E.$$.fragment),Mt=s(),p(A.$$.fragment),yt=s(),H=i("p"),this.h()},l(t){const e=Nt("svelte-u9bgzb",document.head);c=o(e,"META",{name:!0,content:!0}),e.forEach(a),F=n(t),x=o(t,"P",{}),vt(x).forEach(a),V=n(t),m(w.$$.fragment,t),X=n(t),m(f.$$.fragment,t),R=n(t),J=o(t,"P",{"data-svelte-h":!0}),r(J)!=="svelte-c323bq"&&(J.innerHTML=Ut),Y=n(t),j=o(t,"P",{"data-svelte-h":!0}),r(j)!=="svelte-glhkwk"&&(j.innerHTML=ht),z=n(t),m(C.$$.fragment,t),L=n(t),T=o(t,"TABLE",{"data-svelte-h":!0}),r(T)!=="svelte-170vxk4"&&(T.innerHTML=wt),P=n(t),m(k.$$.fragment,t),D=n(t),b=o(t,"P",{"data-svelte-h":!0}),r(b)!=="svelte-el0n8y"&&(b.textContent=ft),O=n(t),I=o(t,"OL",{"data-svelte-h":!0}),r(I)!=="svelte-7ng80t"&&(I.innerHTML=Jt),K=n(t),g=o(t,"IMG",{src:!0,alt:!0,width:!0}),tt=n(t),$=o(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-1lzsyqk"&&($.textContent=Ct),et=n(t),S=o(t,"OL",{"data-svelte-h":!0}),r(S)!=="svelte-vh08fk"&&(S.innerHTML=Tt),at=n(t),U=o(t,"IMG",{src:!0,alt:!0,width:!0}),lt=n(t),m(B.$$.fragment,t),st=n(t),v=o(t,"P",{"data-svelte-h":!0}),r(v)!=="svelte-knhstf"&&(v.textContent=bt),nt=n(t),m(q.$$.fragment,t),it=n(t),W=o(t,"P",{"data-svelte-h":!0}),r(W)!=="svelte-v65zqa"&&(W.textContent=It),ot=n(t),m(Q.$$.fragment,t),rt=n(t),Z=o(t,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-r63eq3"&&(Z.textContent=$t),pt=n(t),m(G.$$.fragment,t),mt=n(t),N=o(t,"P",{"data-svelte-h":!0}),r(N)!=="svelte-t814jl"&&(N.textContent=St),ut=n(t),m(E.$$.fragment,t),Mt=n(t),m(A.$$.fragment,t),yt=n(t),H=o(t,"P",{}),vt(H).forEach(a),this.h()},h(){h(c,"name","hf:doc:metadata"),h(c,"content",xt),Bt(g.src,jt="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/sagemaker/jumpstart-deployment.gif")||h(g,"src",jt),h(g,"alt","JumpStart deployment demo"),h(g,"width","500"),Bt(U.src,kt="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/sagemaker/hf-jumpstart-deployment.gif")||h(U,"src",kt),h(U,"alt","JumpStart deployment demo"),h(U,"width","500")},m(t,e){Et(document.head,c),l(t,F,e),l(t,x,e),l(t,V,e),u(w,t,e),l(t,X,e),u(f,t,e),l(t,R,e),l(t,J,e),l(t,Y,e),l(t,j,e),l(t,z,e),u(C,t,e),l(t,L,e),l(t,T,e),l(t,P,e),u(k,t,e),l(t,D,e),l(t,b,e),l(t,O,e),l(t,I,e),l(t,K,e),l(t,g,e),l(t,tt,e),l(t,$,e),l(t,et,e),l(t,S,e),l(t,at,e),l(t,U,e),l(t,lt,e),u(B,t,e),l(t,st,e),l(t,v,e),l(t,nt,e),u(q,t,e),l(t,it,e),l(t,W,e),l(t,ot,e),u(Q,t,e),l(t,rt,e),l(t,Z,e),l(t,pt,e),u(G,t,e),l(t,mt,e),l(t,N,e),l(t,ut,e),u(E,t,e),l(t,Mt,e),u(A,t,e),l(t,yt,e),l(t,H,e),dt=!0},p:Wt,i(t){dt||(M(w.$$.fragment,t),M(f.$$.fragment,t),M(C.$$.fragment,t),M(k.$$.fragment,t),M(B.$$.fragment,t),M(q.$$.fragment,t),M(Q.$$.fragment,t),M(G.$$.fragment,t),M(E.$$.fragment,t),M(A.$$.fragment,t),dt=!0)},o(t){y(w.$$.fragment,t),y(f.$$.fragment,t),y(C.$$.fragment,t),y(k.$$.fragment,t),y(B.$$.fragment,t),y(q.$$.fragment,t),y(Q.$$.fragment,t),y(G.$$.fragment,t),y(E.$$.fragment,t),y(A.$$.fragment,t),dt=!1},d(t){t&&(a(F),a(x),a(V),a(X),a(R),a(J),a(Y),a(j),a(z),a(L),a(T),a(P),a(D),a(b),a(O),a(I),a(K),a(g),a(tt),a($),a(et),a(S),a(at),a(U),a(lt),a(st),a(v),a(nt),a(it),a(W),a(ot),a(rt),a(Z),a(pt),a(mt),a(N),a(ut),a(Mt),a(yt),a(H)),a(c),d(w,t),d(f,t),d(C,t),d(k,t),d(B,t),d(q,t),d(Q,t),d(G,t),d(E,t),d(A,t)}}}const xt='{"title":"Quickstart - Deploy Hugging Face Models with SageMaker Jumpstart","local":"quickstart---deploy-hugging-face-models-with-sagemaker-jumpstart","sections":[{"title":"Why use SageMaker JumpStart for Hugging Face models?","local":"why-use-sagemaker-jumpstart-for-hugging-face-models","sections":[],"depth":2},{"title":"1. Prerequisites","local":"1-prerequisites","sections":[],"depth":2},{"title":"2· Endpoint deployment","local":"2-endpoint-deployment","sections":[],"depth":2},{"title":"3. Test interactively","local":"3-test-interactively","sections":[],"depth":2},{"title":"4. Clean‑up","local":"4-cleanup","sections":[],"depth":2}],"depth":1}';function Ht(gt){return Qt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Yt extends Zt{constructor(c){super(),Gt(this,c,Ht,_t,qt,{})}}export{Yt as component};
