import{s as bs,n as fs,o as xs}from"../chunks/scheduler.7da89386.js";import{S as Js,i as Ms,g as p,s as n,r as m,A as Ts,h as i,f as e,c as t,j as ws,u as c,x as u,k as is,y as Ws,a as l,v as r,d as o,t as g,w as h}from"../chunks/index.0b7befd3.js";import{C as X}from"../chunks/CodeBlock.ce33a881.js";import{H as _}from"../chunks/Heading.8a936589.js";function Is(ms){let d,E,R,F,y,Q,w,cs='The <a href="https://huggingface.co/docs/transformers/en/main_classes/pipelines" rel="nofollow">pipelines</a> are a great and easy way to use models for inference. These pipelines are objects that abstract most of the complex code from the library, offering a simple API dedicated to several tasks.',H,b,rs="Currently the supported tasks are:",V,f,os='<li><code>image-classification</code></li> <li><code>object-detection</code> (Supported model types - <a href="https://huggingface.co/models?other=RyzenAI&amp;sort=trending&amp;search=amd%2Fyolo" rel="nofollow">yolox, yolov3, yolov5, yolov8</a>)</li> <li><code>image-segmentation</code> (Supported model types - <a href="https://huggingface.co/models?other=RyzenAI" rel="nofollow">hrnet, semantic_fpn</a>)</li>',N,x,C,J,gs="The pipeline abstraction is a wrapper around all the available pipelines for specific tasks. The pipeline() function automatically loads a default model and tokenizer/feature-extractor capable of performing inference for your task.",q,M,hs="<li>Start by creating a pipeline by specifying an inference task:</li>",Y,T,L,j,ds="<li>Pass your input text/image to the <code>~pipelines.pipeline</code> function:</li>",A,W,D,I,P,U,us='The <a href="/docs/optimum.amd/pr_150/en/ryzenai/package_reference/pipelines#optimum.amd.ryzenai.pipeline">pipeline()</a> function can load Ryzen AI supported models from the <a href="https://huggingface.co/models?other=RyzenAI" rel="nofollow">Hugging Face Hub</a>. Once you have picked an appropriate model, you can create the <a href="/docs/optimum.amd/pr_150/en/ryzenai/package_reference/pipelines#optimum.amd.ryzenai.pipeline">pipeline()</a> by specifying the model repository:',K,Z,O,$,ss,k,js="It is also possible to load the model with the <code>RyzenModelForXXX</code> class. For example, here is how you can load the <code>~ryzenai.RyzenModelForImageClassification</code> class for image classification:",as,G,es,B,ls,v,ys="For some models, <code>model_type</code> and/or <code>image_preprocessor</code> has to be provided in addition to the model_id for inference. For example, here is how you can run inference using <code>yolox</code>:",ns,z,ts,S,ps;return y=new _({props:{title:"Ryzen Inference pipelines",local:"ryzen-inference-pipelines",headingTag:"h1"}}),x=new _({props:{title:"The pipeline abstraction",local:"the-pipeline-abstraction",headingTag:"h2"}}),T=new X({props:{code:"ZnJvbSUyMG9wdGltdW0uYW1kLnJ5emVuYWklMjBpbXBvcnQlMjBwaXBlbGluZSUwQSUwQWRldGVjdG9yJTIwJTNEJTIwcGlwZWxpbmUoJTIyb2JqZWN0LWRldGVjdGlvbiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.amd.ryzenai <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>detector = pipeline(<span class="hljs-string">&quot;object-detection&quot;</span>)`,wrap:!1}}),W=new X({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBZGV0ZWN0b3IoaW1hZ2Up",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>detector(image)
[   {   <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">325</span>, <span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">465</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">50</span>},
        <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">15.0</span>,
        <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.7081549763679504</span>},
    {   <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">630</span>, <span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">347</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">381</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">16</span>},
        <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">15.0</span>,
        <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.6494212746620178</span>},
    {   <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">369</span>, <span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">335</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">187</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">76</span>},
        <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">65.0</span>,
        <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.6064183115959167</span>},
    {   <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">645</span>, <span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">475</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">4</span>},
        <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">57.0</span>,
        <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.599224865436554</span>},
    {   <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">174</span>, <span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">40</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">116</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">73</span>},
        <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">65.0</span>,
        <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.408765971660614</span>}]`,wrap:!1}}),I=new _({props:{title:"Inference with RyzenAI models from the Hugging Face Hub",local:"inference-with-ryzenai-models-from-the-hugging-face-hub",headingTag:"h2"}}),Z=new X({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEElMEFmcm9tJTIwb3B0aW11bS5hbWQucnl6ZW5haSUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQSUyMyUyMEh1Z2dpbmclMjBGYWNlJTIwaHViJTIwbW9kZWwtaWQlMjB3aXRoJTIwdGhlJTIwcXVhbnRpemVkJTIwT05OWCUyMG1vZGVsJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJtb2hpdHNoYSUyRnRpbW0tcmVzbmV0MTgtb25ueC1xdWFudGl6ZWQtcnl6ZW4lMjIlMEElMEFwaXBlJTIwJTNEJTIwcGlwZWxpbmUoJTIyaW1hZ2UtY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsX2lkKSUwQXByaW50KHBpcGUoaW1hZ2UpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.amd.ryzenai <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Hugging Face hub model-id with the quantized ONNX model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;mohitsha/timm-resnet18-onnx-quantized-ryzen&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(<span class="hljs-string">&quot;image-classification&quot;</span>, model=model_id)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(pipe(image))`,wrap:!1}}),$=new _({props:{title:"Using RyzenModelForXXX class",local:"using-ryzenmodelforxxx-class",headingTag:"h3"}}),G=new X({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEElMEFmcm9tJTIwb3B0aW11bS5hbWQucnl6ZW5haSUyMGltcG9ydCUyMFJ5emVuQUlNb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwb3B0aW11bS5hbWQucnl6ZW5haSUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQSUyMyUyMEh1Z2dpbmclMjBGYWNlJTIwaHViJTIwbW9kZWwtaWQlMjB3aXRoJTIwdGhlJTIwcXVhbnRpemVkJTIwT05OWCUyMG1vZGVsJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJtb2hpdHNoYSUyRnRpbW0tcmVzbmV0MTgtb25ueC1xdWFudGl6ZWQtcnl6ZW4lMjIlMEFtb2RlbCUyMCUzRCUyMFJ5emVuQUlNb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZSglMjJpbWFnZS1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBcHJpbnQocGlwZShpbWFnZSkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.amd.ryzenai <span class="hljs-keyword">import</span> RyzenAIModelForImageClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.amd.ryzenai <span class="hljs-keyword">import</span> pipeline


<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Hugging Face hub model-id with the quantized ONNX model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;mohitsha/timm-resnet18-onnx-quantized-ryzen&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = RyzenAIModelForImageClassification.from_pretrained(model_id)

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(<span class="hljs-string">&quot;image-classification&quot;</span>, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(pipe(image))`,wrap:!1}}),B=new _({props:{title:"Using model_type argument",local:"using-modeltype-argument",headingTag:"h3"}}),z=new X({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEElMEFmcm9tJTIwb3B0aW11bS5hbWQucnl6ZW5haSUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyYW1kJTJGeW9sb3gtcyUyMiUwQSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZSglMjJvYmplY3QtZGV0ZWN0aW9uJTIyJTJDJTIwbW9kZWwlM0Rtb2RlbF9pZCUyQyUyMG1vZGVsX3R5cGUlM0QlMjJ5b2xveCUyMiklMEFwcmludChwaXBlKGltYWdlKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.amd.ryzenai <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;amd/yolox-s&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(<span class="hljs-string">&quot;object-detection&quot;</span>, model=model_id, model_type=<span class="hljs-string">&quot;yolox&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(pipe(image))`,wrap:!1}}),{c(){d=p("meta"),E=n(),R=p("p"),F=n(),m(y.$$.fragment),Q=n(),w=p("p"),w.innerHTML=cs,H=n(),b=p("p"),b.textContent=rs,V=n(),f=p("ul"),f.innerHTML=os,N=n(),m(x.$$.fragment),C=n(),J=p("p"),J.textContent=gs,q=n(),M=p("ol"),M.innerHTML=hs,Y=n(),m(T.$$.fragment),L=n(),j=p("ol"),j.innerHTML=ds,A=n(),m(W.$$.fragment),D=n(),m(I.$$.fragment),P=n(),U=p("p"),U.innerHTML=us,K=n(),m(Z.$$.fragment),O=n(),m($.$$.fragment),ss=n(),k=p("p"),k.innerHTML=js,as=n(),m(G.$$.fragment),es=n(),m(B.$$.fragment),ls=n(),v=p("p"),v.innerHTML=ys,ns=n(),m(z.$$.fragment),ts=n(),S=p("p"),this.h()},l(s){const a=Ts("svelte-u9bgzb",document.head);d=i(a,"META",{name:!0,content:!0}),a.forEach(e),E=t(s),R=i(s,"P",{}),ws(R).forEach(e),F=t(s),c(y.$$.fragment,s),Q=t(s),w=i(s,"P",{"data-svelte-h":!0}),u(w)!=="svelte-19mckc"&&(w.innerHTML=cs),H=t(s),b=i(s,"P",{"data-svelte-h":!0}),u(b)!=="svelte-1rl24tl"&&(b.textContent=rs),V=t(s),f=i(s,"UL",{"data-svelte-h":!0}),u(f)!=="svelte-1o3sjnu"&&(f.innerHTML=os),N=t(s),c(x.$$.fragment,s),C=t(s),J=i(s,"P",{"data-svelte-h":!0}),u(J)!=="svelte-xxdb4o"&&(J.textContent=gs),q=t(s),M=i(s,"OL",{"data-svelte-h":!0}),u(M)!=="svelte-khfcvb"&&(M.innerHTML=hs),Y=t(s),c(T.$$.fragment,s),L=t(s),j=i(s,"OL",{start:!0,"data-svelte-h":!0}),u(j)!=="svelte-1c3g7an"&&(j.innerHTML=ds),A=t(s),c(W.$$.fragment,s),D=t(s),c(I.$$.fragment,s),P=t(s),U=i(s,"P",{"data-svelte-h":!0}),u(U)!=="svelte-182uc9d"&&(U.innerHTML=us),K=t(s),c(Z.$$.fragment,s),O=t(s),c($.$$.fragment,s),ss=t(s),k=i(s,"P",{"data-svelte-h":!0}),u(k)!=="svelte-owp4m1"&&(k.innerHTML=js),as=t(s),c(G.$$.fragment,s),es=t(s),c(B.$$.fragment,s),ls=t(s),v=i(s,"P",{"data-svelte-h":!0}),u(v)!=="svelte-1dj8fvk"&&(v.innerHTML=ys),ns=t(s),c(z.$$.fragment,s),ts=t(s),S=i(s,"P",{}),ws(S).forEach(e),this.h()},h(){is(d,"name","hf:doc:metadata"),is(d,"content",Us),is(j,"start","2")},m(s,a){Ws(document.head,d),l(s,E,a),l(s,R,a),l(s,F,a),r(y,s,a),l(s,Q,a),l(s,w,a),l(s,H,a),l(s,b,a),l(s,V,a),l(s,f,a),l(s,N,a),r(x,s,a),l(s,C,a),l(s,J,a),l(s,q,a),l(s,M,a),l(s,Y,a),r(T,s,a),l(s,L,a),l(s,j,a),l(s,A,a),r(W,s,a),l(s,D,a),r(I,s,a),l(s,P,a),l(s,U,a),l(s,K,a),r(Z,s,a),l(s,O,a),r($,s,a),l(s,ss,a),l(s,k,a),l(s,as,a),r(G,s,a),l(s,es,a),r(B,s,a),l(s,ls,a),l(s,v,a),l(s,ns,a),r(z,s,a),l(s,ts,a),l(s,S,a),ps=!0},p:fs,i(s){ps||(o(y.$$.fragment,s),o(x.$$.fragment,s),o(T.$$.fragment,s),o(W.$$.fragment,s),o(I.$$.fragment,s),o(Z.$$.fragment,s),o($.$$.fragment,s),o(G.$$.fragment,s),o(B.$$.fragment,s),o(z.$$.fragment,s),ps=!0)},o(s){g(y.$$.fragment,s),g(x.$$.fragment,s),g(T.$$.fragment,s),g(W.$$.fragment,s),g(I.$$.fragment,s),g(Z.$$.fragment,s),g($.$$.fragment,s),g(G.$$.fragment,s),g(B.$$.fragment,s),g(z.$$.fragment,s),ps=!1},d(s){s&&(e(E),e(R),e(F),e(Q),e(w),e(H),e(b),e(V),e(f),e(N),e(C),e(J),e(q),e(M),e(Y),e(L),e(j),e(A),e(D),e(P),e(U),e(K),e(O),e(ss),e(k),e(as),e(es),e(ls),e(v),e(ns),e(ts),e(S)),e(d),h(y,s),h(x,s),h(T,s),h(W,s),h(I,s),h(Z,s),h($,s),h(G,s),h(B,s),h(z,s)}}}const Us='{"title":"Ryzen Inference pipelines","local":"ryzen-inference-pipelines","sections":[{"title":"The pipeline abstraction","local":"the-pipeline-abstraction","sections":[],"depth":2},{"title":"Inference with RyzenAI models from the Hugging Face Hub","local":"inference-with-ryzenai-models-from-the-hugging-face-hub","sections":[{"title":"Using RyzenModelForXXX class","local":"using-ryzenmodelforxxx-class","sections":[],"depth":3},{"title":"Using model_type argument","local":"using-modeltype-argument","sections":[],"depth":3}],"depth":2}],"depth":1}';function Zs(ms){return xs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class vs extends Js{constructor(d){super(),Ms(this,d,Zs,Is,bs,{})}}export{vs as component};
