import{s as Kt,o as Ot,n as es}from"../chunks/scheduler.f6b352c8.js";import{S as ls,i as ts,g as o,s as a,r as M,m as ss,A as as,h as i,f as t,c as n,j as Dt,u as r,x as p,n as ns,k as Pt,y as os,a as s,v as c,d as m,t as y,w}from"../chunks/index.b90df637.js";import{T as is}from"../chunks/Tip.366d2e6e.js";import{C as T}from"../chunks/CodeBlock.e5718f9d.js";import{H as j,E as ps}from"../chunks/getInferenceSnippets.1d040d5d.js";function Ms(Se){let J,b="Note that these properties must be callable even if the robot is not yet connected, so avoid relying on runtime hardware state to define them.";return{c(){J=o("p"),J.textContent=b},l(d){J=i(d,"P",{"data-svelte-h":!0}),p(J)!=="svelte-12r8tyg"&&(J.textContent=b)},m(d,Re){s(d,J,Re)},p:es,d(d){d&&t(J)}}}function rs(Se){let J,b,d,Re,h,Xe,f,pt="This tutorial will explain how to integrate your own robot design into the LeRobot ecosystem and have it access all of our tools (data collection, control pipelines, policy training and inference).",Qe,U,Mt='To that end, we provide the <a href="https://github.com/huggingface/lerobot/blob/main/src/lerobot/robots/robot.py" rel="nofollow"><code>Robot</code></a> base class in the LeRobot which specifies a standard interface for physical robot integration. Let’s see how to implement it.',Ve,I,ze,C,rt='<li>Your own robot which exposes a communication interface (e.g. serial, CAN, TCP)</li> <li>A way to read sensor data and send motor commands programmatically, e.g. manufacturer’s SDK or API, or your own protocol implementation.</li> <li>LeRobot installed in your environment. Follow our <a href="./installation.mdx">Installation Guide</a>.</li>',He,v,Fe,g,ct="If you’re using Feetech or Dynamixel motors, LeRobot provides built-in bus interfaces:",Le,B,mt='<li><a href="https://github.com/huggingface/lerobot/blob/main/src/lerobot/motors/feetech/feetech.py" rel="nofollow"><code>FeetechMotorsBus</code></a> – for controlling Feetech servos</li> <li><a href="https://github.com/huggingface/lerobot/blob/main/src/lerobot/motors/dynamixel/dynamixel.py" rel="nofollow"><code>DynamixelMotorsBus</code></a> – for controlling Dynamixel servos</li>',qe,A,yt=`Please refer to the <a href="https://github.com/huggingface/lerobot/blob/main/src/lerobot/motors/motors_bus.py" rel="nofollow"><code>MotorsBus</code></a> abstract class to learn about its API.
For a good example of how it can be used, you can have a look at our own <a href="https://github.com/huggingface/lerobot/blob/main/src/lerobot/robots/so101_follower/so101_follower.py" rel="nofollow">SO101 follower implementation</a>`,De,$,wt="Use these if compatible. Otherwise, you’ll need to find or write a Python interface (not covered in this tutorial):",Pe,_,jt="<li>Find an existing SDK in Python (or use bindings to C/C++)</li> <li>Or implement a basic communication wrapper (e.g., via pyserial, socket, or CANopen)</li>",Ke,Z,Jt="You’re not alone—many community contributions use custom boards or firmware!",Oe,k,Tt="For Feetech and Dynamixel, we currently support these servos: - Feetech: - STS &amp; SMS series (protocol 0): <code>sts3215</code>, <code>sts3250</code>, <code>sm8512bl</code> - SCS series (protocol 1): <code>scs0009</code> - Dynamixel (protocol 2.0 only): <code>xl330-m077</code>, <code>xl330-m288</code>, <code>xl430-w250</code>, <code>xm430-w350</code>, <code>xm540-w270</code>, <code>xc430-w150</code>",el,G,dt='If you are using Feetech or Dynamixel servos that are not in this list, you can add those in the <a href="https://github.com/huggingface/lerobot/blob/main/src/lerobot/motors/feetech/tables.py" rel="nofollow">Feetech table</a> or <a href="https://github.com/huggingface/lerobot/blob/main/src/lerobot/motors/dynamixel/tables.py" rel="nofollow">Dynamixel table</a>. Depending on the model, this will require you to add model-specific information. In most cases though, there shouldn’t be a lot of additions to do.',ll,W,ut="In the next sections, we’ll use a <code>FeetechMotorsBus</code> as the motors interface for the examples. Replace it and adapt to your motors if necessary.",tl,Y,sl,N,bt="You’ll first need to specify the config class and a string identifier (<code>name</code>) for your robot. If your robot has special needs that you’d like to be able to change easily, it should go here (e.g. port/address, baudrate).",al,E,ht="Here, we’ll add the port name and one camera by default for our robot:",nl,R,ol,x,ft='<a href="./cameras.mdx">Cameras tutorial</a> to understand how to detect and add your camera.',il,S,Ut="Next, we’ll create our actual robot class which inherits from <code>Robot</code>. This abstract class defines a contract you must follow for your robot to be usable with the rest of the LeRobot tools.",pl,X,It="Here we’ll create a simple 5-DoF robot with one camera. It could be a simple arm but notice that the <code>Robot</code> abstract class does not assume anything on your robot’s form factor. You can let you imagination run wild when designing new robots!",Ml,Q,rl,V,cl,z,Ct="These two properties define the <em>interface contract</em> between your robot and tools that consume it (such as data collection or learning pipelines).",ml,u,yl,H,wl,F,vt="This property should return a dictionary describing the structure of sensor outputs from your robot. The keys match what <code>get_observation()</code> returns, and the values describe either the shape (for arrays/images) or the type (for simple values).",jl,L,gt="Example for our 5-DoF arm with one camera:",Jl,q,Tl,D,Bt="In this case, observations consist of a simple dict storing each motor’s position and a camera image.",dl,P,ul,K,At="This property describes the commands your robot expects via <code>send_action()</code>. Again, keys must match the expected input format, and values define the shape/type of each command.",bl,O,$t="Here, we simply use the same joints proprioceptive features (<code>self._motors_ft</code>) as with <code>observation_features</code>: the action sent will simply the goal position for each motor.",hl,ee,fl,le,Ul,te,_t="These methods should handle opening and closing communication with your hardware (e.g. serial ports, CAN interfaces, USB devices, cameras).",Il,se,Cl,ae,Zt="This property should simply reflect that communication with the robot’s hardware is established. When this property is <code>True</code>, it should be possible to read and write to the hardware using <code>get_observation()</code> and <code>send_action()</code>.",vl,ne,gl,oe,Bl,ie,kt="This method should establish communication with the hardware. Moreover, if your robot needs calibration and is not calibrated, it should start a calibration procedure by default. If your robot needs some specific configuration, this should also be called here.",Al,pe,$l,Me,_l,re,Gt="This method should gracefully terminate communication with the hardware: free any related resources (threads or processes), close ports, etc.",Zl,ce,Wt="Here, we already handle this in our <code>MotorsBus</code> and <code>Camera</code> classes so we just need to call their own <code>disconnect()</code> methods:",kl,me,Gl,ye,Wl,we,Yt="LeRobot supports saving and loading calibration data automatically. This is useful for joint offsets, zero positions, or sensor alignment.",Yl,je,Nt="<p>Note that depending on your hardware, this may not apply. If that’s the case, you can simply leave these methods as no-ops:</p>",Nl,Je,El,Te,Et=`@property
def is_calibrated(self) -> bool:
return self.bus.is_calibrated`,Rl,de,xl,ue,Sl,be,Rt="Use this to set up any configuration for your hardware (servos control modes, controller gains, etc.). This should usually be run at connection time and be idempotent.",Xl,he,Ql,fe,Vl,Ue,xt="These are the most important runtime functions: the core I/O loop.",zl,Ie,Hl,Ce,St="Returns a dictionary of sensor values from the robot. These typically include motor states, camera frames, various sensors, etc. In the LeRobot framework, these observations are what will be fed to a policy in order to predict the actions to take. The dictionary keys and structure must match <code>observation_features</code>.",Fl,ve,Ll,ge,ql,Be,Xt="Takes a dictionary that matches <code>action_features</code>, and sends it to your hardware. You can add safety limits (clipping, smoothing) and return what was actually sent.",Dl,Ae,Qt="For simplicity, we won’t be adding any modification of the actions in our example here.",Pl,$e,Kl,_e,Ol,Ze,Vt='For implementing teleoperation devices, we also provide a <a href="https://github.com/huggingface/lerobot/blob/main/src/lerobot/teleoperators/teleoperator.py" rel="nofollow"><code>Teleoperator</code></a> base class. This class is very similar to the <code>Robot</code> base class and also doesn’t assume anything on form factor.',et,ke,zt="The main differences are in the I/O functions: a teleoperator allows you to produce action via <code>get_action</code> and can receive feedback actions via <code>send_feedback</code>. Feedback could be anything controllable on the teleoperation device that could help the person controlling it understand the consequences of the actions sent. Think motion/force feedback on a leader arm, vibrations on a gamepad controller for example. To implement a teleoperator, you can follow this same tutorial and adapt it for these two methods.",lt,Ge,tt,We,Ht="Once your robot class is complete, you can leverage the LeRobot ecosystem:",st,Ye,Ft="<li>Control your robot with available teleoperators or integrate directly your teleoperating device</li> <li>Record training data and visualize it</li> <li>Integrate it into RL or imitation learning pipelines</li>",at,Ne,Lt='Don’t hesitate to reach out to the community for help on our <a href="https://discord.gg/s3KuuzsPFb" rel="nofollow">Discord</a> 🤗',nt,Ee,ot,xe,it;return h=new j({props:{title:"Bring Your Own Hardware",local:"bring-your-own-hardware",headingTag:"h1"}}),I=new j({props:{title:"Prerequisites",local:"prerequisites",headingTag:"h2"}}),v=new j({props:{title:"Choose your motors",local:"choose-your-motors",headingTag:"h2"}}),Y=new j({props:{title:"Step 1: Subclass the Robot Interface",local:"step-1-subclass-the-robot-interface",headingTag:"h2"}}),R=new T({props:{code:"ZnJvbSUyMGRhdGFjbGFzc2VzJTIwaW1wb3J0JTIwZGF0YWNsYXNzJTJDJTIwZmllbGQlMEElMEFmcm9tJTIwbGVyb2JvdC5jYW1lcmFzJTIwaW1wb3J0JTIwQ2FtZXJhQ29uZmlnJTBBZnJvbSUyMGxlcm9ib3QuY2FtZXJhcy5vcGVuY3YlMjBpbXBvcnQlMjBPcGVuQ1ZDYW1lcmFDb25maWclMEFmcm9tJTIwbGVyb2JvdC5yb2JvdHMlMjBpbXBvcnQlMjBSb2JvdENvbmZpZyUwQSUwQSUwQSU0MFJvYm90Q29uZmlnLnJlZ2lzdGVyX3N1YmNsYXNzKCUyMm15X2Nvb2xfcm9ib3QlMjIpJTBBJTQwZGF0YWNsYXNzJTBBY2xhc3MlMjBNeUNvb2xSb2JvdENvbmZpZyhSb2JvdENvbmZpZyklM0ElMEElMjAlMjAlMjAlMjBwb3J0JTNBJTIwc3RyJTBBJTIwJTIwJTIwJTIwY2FtZXJhcyUzQSUyMGRpY3QlNUJzdHIlMkMlMjBDYW1lcmFDb25maWclNUQlMjAlM0QlMjBmaWVsZCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkZWZhdWx0X2ZhY3RvcnklM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjYW1fMSUyMiUzQSUyME9wZW5DVkNhbWVyYUNvbmZpZyglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbmRleF9vcl9wYXRoJTNEMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZwcyUzRDMwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd2lkdGglM0Q0ODAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBoZWlnaHQlM0Q2NDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwKQ==",highlighted:`<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass, field

<span class="hljs-keyword">from</span> lerobot.cameras <span class="hljs-keyword">import</span> CameraConfig
<span class="hljs-keyword">from</span> lerobot.cameras.opencv <span class="hljs-keyword">import</span> OpenCVCameraConfig
<span class="hljs-keyword">from</span> lerobot.robots <span class="hljs-keyword">import</span> RobotConfig


<span class="hljs-meta">@RobotConfig.register_subclass(<span class="hljs-params"><span class="hljs-string">&quot;my_cool_robot&quot;</span></span>)</span>
<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyCoolRobotConfig</span>(<span class="hljs-title class_ inherited__">RobotConfig</span>):
    port: <span class="hljs-built_in">str</span>
    cameras: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, CameraConfig] = field(
        default_factory={
            <span class="hljs-string">&quot;cam_1&quot;</span>: OpenCVCameraConfig(
                index_or_path=<span class="hljs-number">2</span>,
                fps=<span class="hljs-number">30</span>,
                width=<span class="hljs-number">480</span>,
                height=<span class="hljs-number">640</span>,
            ),
        }
    )`,wrap:!1}}),Q=new T({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> lerobot.cameras <span class="hljs-keyword">import</span> make_cameras_from_configs
<span class="hljs-keyword">from</span> lerobot.motors <span class="hljs-keyword">import</span> Motor, MotorNormMode
<span class="hljs-keyword">from</span> lerobot.motors.feetech <span class="hljs-keyword">import</span> FeetechMotorsBus
<span class="hljs-keyword">from</span> lerobot.robots <span class="hljs-keyword">import</span> Robot

<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyCoolRobot</span>(<span class="hljs-title class_ inherited__">Robot</span>):
    config_class = MyCoolRobotConfig
    name = <span class="hljs-string">&quot;my_cool_robot&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config: MyCoolRobotConfig</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        self.bus = FeetechMotorsBus(
            port=self.config.port,
            motors={
                <span class="hljs-string">&quot;joint_1&quot;</span>: Motor(<span class="hljs-number">1</span>, <span class="hljs-string">&quot;sts3250&quot;</span>, MotorNormMode.RANGE_M100_100),
                <span class="hljs-string">&quot;joint_2&quot;</span>: Motor(<span class="hljs-number">2</span>, <span class="hljs-string">&quot;sts3215&quot;</span>, MotorNormMode.RANGE_M100_100),
                <span class="hljs-string">&quot;joint_3&quot;</span>: Motor(<span class="hljs-number">3</span>, <span class="hljs-string">&quot;sts3215&quot;</span>, MotorNormMode.RANGE_M100_100),
                <span class="hljs-string">&quot;joint_4&quot;</span>: Motor(<span class="hljs-number">4</span>, <span class="hljs-string">&quot;sts3215&quot;</span>, MotorNormMode.RANGE_M100_100),
                <span class="hljs-string">&quot;joint_5&quot;</span>: Motor(<span class="hljs-number">5</span>, <span class="hljs-string">&quot;sts3215&quot;</span>, MotorNormMode.RANGE_M100_100),
            },
            calibration=self.calibration,
        )
        self.cameras = make_cameras_from_configs(config.cameras)`,wrap:!1}}),V=new j({props:{title:"Step 2: Define Observation and Action Features",local:"step-2-define-observation-and-action-features",headingTag:"h2"}}),u=new is({props:{warning:!0,$$slots:{default:[Ms]},$$scope:{ctx:Se}}}),H=new j({props:{title:"observation_features",local:"observationfeatures",headingTag:"h3"}}),q=new T({props:{code:"JTQwcHJvcGVydHklMEFkZWYlMjBfbW90b3JzX2Z0KHNlbGYpJTIwLSUzRSUyMGRpY3QlNUJzdHIlMkMlMjB0eXBlJTVEJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyam9pbnRfMS5wb3MlMjIlM0ElMjBmbG9hdCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmpvaW50XzIucG9zJTIyJTNBJTIwZmxvYXQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJqb2ludF8zLnBvcyUyMiUzQSUyMGZsb2F0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyam9pbnRfNC5wb3MlMjIlM0ElMjBmbG9hdCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmpvaW50XzUucG9zJTIyJTNBJTIwZmxvYXQlMkMlMEElMjAlMjAlMjAlMjAlN0QlMEElMEElNDBwcm9wZXJ0eSUwQWRlZiUyMF9jYW1lcmFzX2Z0KHNlbGYpJTIwLSUzRSUyMGRpY3QlNUJzdHIlMkMlMjB0dXBsZSU1RCUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhbSUzQSUyMChzZWxmLmNhbWVyYXMlNUJjYW0lNUQuaGVpZ2h0JTJDJTIwc2VsZi5jYW1lcmFzJTVCY2FtJTVELndpZHRoJTJDJTIwMyklMjBmb3IlMjBjYW0lMjBpbiUyMHNlbGYuY2FtZXJhcyUwQSUyMCUyMCUyMCUyMCU3RCUwQSUwQSU0MHByb3BlcnR5JTBBZGVmJTIwb2JzZXJ2YXRpb25fZmVhdHVyZXMoc2VsZiklMjAtJTNFJTIwZGljdCUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3Qioqc2VsZi5fbW90b3JzX2Z0JTJDJTIwKipzZWxmLl9jYW1lcmFzX2Z0JTdE",highlighted:`<span class="hljs-meta">@property</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">_motors_ft</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">type</span>]:
    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;joint_1.pos&quot;</span>: <span class="hljs-built_in">float</span>,
        <span class="hljs-string">&quot;joint_2.pos&quot;</span>: <span class="hljs-built_in">float</span>,
        <span class="hljs-string">&quot;joint_3.pos&quot;</span>: <span class="hljs-built_in">float</span>,
        <span class="hljs-string">&quot;joint_4.pos&quot;</span>: <span class="hljs-built_in">float</span>,
        <span class="hljs-string">&quot;joint_5.pos&quot;</span>: <span class="hljs-built_in">float</span>,
    }

<span class="hljs-meta">@property</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">_cameras_ft</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">tuple</span>]:
    <span class="hljs-keyword">return</span> {
        cam: (self.cameras[cam].height, self.cameras[cam].width, <span class="hljs-number">3</span>) <span class="hljs-keyword">for</span> cam <span class="hljs-keyword">in</span> self.cameras
    }

<span class="hljs-meta">@property</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">observation_features</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">dict</span>:
    <span class="hljs-keyword">return</span> {**self._motors_ft, **self._cameras_ft}`,wrap:!1}}),P=new j({props:{title:"action_features",local:"actionfeatures",headingTag:"h3"}}),ee=new T({props:{code:"ZGVmJTIwYWN0aW9uX2ZlYXR1cmVzKHNlbGYpJTIwLSUzRSUyMGRpY3QlM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBzZWxmLl9tb3RvcnNfZnQ=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">action_features</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">dict</span>:
    <span class="hljs-keyword">return</span> self._motors_ft`,wrap:!1}}),le=new j({props:{title:"Step 3: Handle Connection and Disconnection",local:"step-3-handle-connection-and-disconnection",headingTag:"h2"}}),se=new j({props:{title:"is_connected",local:"isconnected",headingTag:"h3"}}),ne=new T({props:{code:"JTQwcHJvcGVydHklMEFkZWYlMjBpc19jb25uZWN0ZWQoc2VsZiklMjAtJTNFJTIwYm9vbCUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHNlbGYuYnVzLmlzX2Nvbm5lY3RlZCUyMGFuZCUyMGFsbChjYW0uaXNfY29ubmVjdGVkJTIwZm9yJTIwY2FtJTIwaW4lMjBzZWxmLmNhbWVyYXMudmFsdWVzKCkp",highlighted:`<span class="hljs-meta">@property</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">is_connected</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">bool</span>:
    <span class="hljs-keyword">return</span> self.bus.is_connected <span class="hljs-keyword">and</span> <span class="hljs-built_in">all</span>(cam.is_connected <span class="hljs-keyword">for</span> cam <span class="hljs-keyword">in</span> self.cameras.values())`,wrap:!1}}),oe=new j({props:{title:"connect()",local:"connect",headingTag:"h3"}}),pe=new T({props:{code:"ZGVmJTIwY29ubmVjdChzZWxmJTJDJTIwY2FsaWJyYXRlJTNBJTIwYm9vbCUyMCUzRCUyMFRydWUpJTIwLSUzRSUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjBzZWxmLmJ1cy5jb25uZWN0KCklMEElMjAlMjAlMjAlMjBpZiUyMG5vdCUyMHNlbGYuaXNfY2FsaWJyYXRlZCUyMGFuZCUyMGNhbGlicmF0ZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuY2FsaWJyYXRlKCklMEElMEElMjAlMjAlMjAlMjBmb3IlMjBjYW0lMjBpbiUyMHNlbGYuY2FtZXJhcy52YWx1ZXMoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhbS5jb25uZWN0KCklMEElMEElMjAlMjAlMjAlMjBzZWxmLmNvbmZpZ3VyZSgp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">connect</span>(<span class="hljs-params">self, calibrate: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">True</span></span>) -&gt; <span class="hljs-literal">None</span>:
    self.bus.connect()
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> self.is_calibrated <span class="hljs-keyword">and</span> calibrate:
        self.calibrate()

    <span class="hljs-keyword">for</span> cam <span class="hljs-keyword">in</span> self.cameras.values():
        cam.connect()

    self.configure()`,wrap:!1}}),Me=new j({props:{title:"disconnect()",local:"disconnect",headingTag:"h3"}}),me=new T({props:{code:"ZGVmJTIwZGlzY29ubmVjdChzZWxmKSUyMC0lM0UlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwc2VsZi5idXMuZGlzY29ubmVjdCgpJTBBJTIwJTIwJTIwJTIwZm9yJTIwY2FtJTIwaW4lMjBzZWxmLmNhbWVyYXMudmFsdWVzKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjYW0uZGlzY29ubmVjdCgp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">disconnect</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-literal">None</span>:
    self.bus.disconnect()
    <span class="hljs-keyword">for</span> cam <span class="hljs-keyword">in</span> self.cameras.values():
        cam.disconnect()`,wrap:!1}}),ye=new j({props:{title:"Step 4: Support Calibration and Configuration",local:"step-4-support-calibration-and-configuration",headingTag:"h2"}}),Je=new T({props:{code:"JTNFJTIwJTQwcHJvcGVydHklMEElM0UlMjBkZWYlMjBpc19jYWxpYnJhdGVkKHNlbGYpJTIwLSUzRSUyMGJvb2wlM0ElMEElM0UlMjAlMjAlMjAlMjByZXR1cm4lMjBUcnVlJTBBJTNFJTBBJTNFJTIwZGVmJTIwY2FsaWJyYXRlKHNlbGYpJTIwLSUzRSUyME5vbmUlM0ElMEElM0UlMjAlMjAlMjAlMjBwYXNzJTBBJTNFJTIwJTYwJTYwJTYwJTBBJTBBJTIzJTIzJTIzJTIwJTYwaXNfY2FsaWJyYXRlZCU2MCUwQSUwQVRoaXMlMjBzaG91bGQlMjByZWZsZWN0JTIwd2hldGhlciUyMHlvdXIlMjByb2JvdCUyMGhhcyUyMHRoZSUyMHJlcXVpcmVkJTIwY2FsaWJyYXRpb24lMjBsb2FkZWQuJTBB",highlighted:`&gt; @<span class="hljs-built_in">property</span>
&gt; <span class="hljs-keyword">def</span> <span class="hljs-title function_">is_calibrated</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">bool</span>:
&gt;    <span class="hljs-keyword">return</span> <span class="hljs-literal">True</span>
&gt;
&gt; <span class="hljs-keyword">def</span> <span class="hljs-title function_">calibrate</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-literal">None</span>:
&gt;    <span class="hljs-keyword">pass</span>
&gt; \`\`\`

<span class="hljs-comment">### \`is_calibrated\`</span>

This should reflect whether your robot has the required calibration loaded.
`,wrap:!1}}),de=new T({props:{code:"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",highlighted:`
<span class="hljs-comment">### \`calibrate()\`</span>

The goal of the calibration <span class="hljs-keyword">is</span> twofold:
    - Know the physical <span class="hljs-built_in">range</span> of motion of each motors <span class="hljs-keyword">in</span> order to only send commands within this <span class="hljs-built_in">range</span>.
    - Normalize raw motors positions to sensible continuous values (e.g. percentages, degrees) instead of arbitrary discrete value dependant on the specific motor used that will <span class="hljs-keyword">not</span> replicate elsewhere.

It should implement the logic <span class="hljs-keyword">for</span> calibration (<span class="hljs-keyword">if</span> relevant) <span class="hljs-keyword">and</span> update the \`self.calibration\` dictionary. If you are using Feetech <span class="hljs-keyword">or</span> Dynamixel motors, our bus interfaces already include methods to <span class="hljs-built_in">help</span> <span class="hljs-keyword">with</span> this.


&lt;!-- prettier-ignore-start --&gt;
\`\`\`python
<span class="hljs-keyword">def</span> <span class="hljs-title function_">calibrate</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-literal">None</span>:
    self.bus.disable_torque()
    <span class="hljs-keyword">for</span> motor <span class="hljs-keyword">in</span> self.bus.motors:
        self.bus.write(<span class="hljs-string">&quot;Operating_Mode&quot;</span>, motor, OperatingMode.POSITION.value)

    <span class="hljs-built_in">input</span>(<span class="hljs-string">f&quot;Move <span class="hljs-subst">{self}</span> to the middle of its range of motion and press ENTER....&quot;</span>)
    homing_offsets = self.bus.set_half_turn_homings()

    <span class="hljs-built_in">print</span>(
        <span class="hljs-string">&quot;Move all joints sequentially through their entire ranges &quot;</span>
        <span class="hljs-string">&quot;of motion.\\nRecording positions. Press ENTER to stop...&quot;</span>
    )
    range_mins, range_maxes = self.bus.record_ranges_of_motion()

    self.calibration = {}
    <span class="hljs-keyword">for</span> motor, m <span class="hljs-keyword">in</span> self.bus.motors.items():
        self.calibration[motor] = MotorCalibration(
            <span class="hljs-built_in">id</span>=m.<span class="hljs-built_in">id</span>,
            drive_mode=<span class="hljs-number">0</span>,
            homing_offset=homing_offsets[motor],
            range_min=range_mins[motor],
            range_max=range_maxes[motor],
        )

    self.bus.write_calibration(self.calibration)
    self._save_calibration()
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Calibration saved to&quot;</span>, self.calibration_fpath)`,wrap:!1}}),ue=new j({props:{title:"configure()",local:"configure",headingTag:"h3"}}),he=new T({props:{code:"ZGVmJTIwY29uZmlndXJlKHNlbGYpJTIwLSUzRSUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjB3aXRoJTIwc2VsZi5idXMudG9ycXVlX2Rpc2FibGVkKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmJ1cy5jb25maWd1cmVfbW90b3JzKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBtb3RvciUyMGluJTIwc2VsZi5idXMubW90b3JzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5idXMud3JpdGUoJTIyT3BlcmF0aW5nX01vZGUlMjIlMkMlMjBtb3RvciUyQyUyME9wZXJhdGluZ01vZGUuUE9TSVRJT04udmFsdWUpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5idXMud3JpdGUoJTIyUF9Db2VmZmljaWVudCUyMiUyQyUyMG1vdG9yJTJDJTIwMTYpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5idXMud3JpdGUoJTIySV9Db2VmZmljaWVudCUyMiUyQyUyMG1vdG9yJTJDJTIwMCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmJ1cy53cml0ZSglMjJEX0NvZWZmaWNpZW50JTIyJTJDJTIwbW90b3IlMkMlMjAzMik=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">configure</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-literal">None</span>:
    <span class="hljs-keyword">with</span> self.bus.torque_disabled():
        self.bus.configure_motors()
        <span class="hljs-keyword">for</span> motor <span class="hljs-keyword">in</span> self.bus.motors:
            self.bus.write(<span class="hljs-string">&quot;Operating_Mode&quot;</span>, motor, OperatingMode.POSITION.value)
            self.bus.write(<span class="hljs-string">&quot;P_Coefficient&quot;</span>, motor, <span class="hljs-number">16</span>)
            self.bus.write(<span class="hljs-string">&quot;I_Coefficient&quot;</span>, motor, <span class="hljs-number">0</span>)
            self.bus.write(<span class="hljs-string">&quot;D_Coefficient&quot;</span>, motor, <span class="hljs-number">32</span>)`,wrap:!1}}),fe=new j({props:{title:"Step 5: Implement Sensors Reading and Action Sending",local:"step-5-implement-sensors-reading-and-action-sending",headingTag:"h2"}}),Ie=new j({props:{title:"get_observation()",local:"getobservation",headingTag:"h3"}}),ve=new T({props:{code:"ZGVmJTIwZ2V0X29ic2VydmF0aW9uKHNlbGYpJTIwLSUzRSUyMGRpY3QlNUJzdHIlMkMlMjBBbnklNUQlM0ElMEElMjAlMjAlMjAlMjBpZiUyMG5vdCUyMHNlbGYuaXNfY29ubmVjdGVkJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmFpc2UlMjBDb25uZWN0aW9uRXJyb3IoZiUyMiU3QnNlbGYlN0QlMjBpcyUyMG5vdCUyMGNvbm5lY3RlZC4lMjIpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwUmVhZCUyMGFybSUyMHBvc2l0aW9uJTBBJTIwJTIwJTIwJTIwb2JzX2RpY3QlMjAlM0QlMjBzZWxmLmJ1cy5zeW5jX3JlYWQoJTIyUHJlc2VudF9Qb3NpdGlvbiUyMiklMEElMjAlMjAlMjAlMjBvYnNfZGljdCUyMCUzRCUyMCU3QmYlMjIlN0Jtb3RvciU3RC5wb3MlMjIlM0ElMjB2YWwlMjBmb3IlMjBtb3RvciUyQyUyMHZhbCUyMGluJTIwb2JzX2RpY3QuaXRlbXMoKSU3RCUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMENhcHR1cmUlMjBpbWFnZXMlMjBmcm9tJTIwY2FtZXJhcyUwQSUyMCUyMCUyMCUyMGZvciUyMGNhbV9rZXklMkMlMjBjYW0lMjBpbiUyMHNlbGYuY2FtZXJhcy5pdGVtcygpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb2JzX2RpY3QlNUJjYW1fa2V5JTVEJTIwJTNEJTIwY2FtLmFzeW5jX3JlYWQoKSUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG9ic19kaWN0",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_observation</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]:
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> self.is_connected:
        <span class="hljs-keyword">raise</span> ConnectionError(<span class="hljs-string">f&quot;<span class="hljs-subst">{self}</span> is not connected.&quot;</span>)

    <span class="hljs-comment"># Read arm position</span>
    obs_dict = self.bus.sync_read(<span class="hljs-string">&quot;Present_Position&quot;</span>)
    obs_dict = {<span class="hljs-string">f&quot;<span class="hljs-subst">{motor}</span>.pos&quot;</span>: val <span class="hljs-keyword">for</span> motor, val <span class="hljs-keyword">in</span> obs_dict.items()}

    <span class="hljs-comment"># Capture images from cameras</span>
    <span class="hljs-keyword">for</span> cam_key, cam <span class="hljs-keyword">in</span> self.cameras.items():
        obs_dict[cam_key] = cam.async_read()

    <span class="hljs-keyword">return</span> obs_dict`,wrap:!1}}),ge=new j({props:{title:"send_action()",local:"sendaction",headingTag:"h3"}}),$e=new T({props:{code:"ZGVmJTIwc2VuZF9hY3Rpb24oc2VsZiUyQyUyMGFjdGlvbiUzQSUyMGRpY3QlNUJzdHIlMkMlMjBBbnklNUQpJTIwLSUzRSUyMGRpY3QlNUJzdHIlMkMlMjBBbnklNUQlM0ElMEElMjAlMjAlMjAlMjBnb2FsX3BvcyUyMCUzRCUyMCU3QmtleS5yZW1vdmVzdWZmaXgoJTIyLnBvcyUyMiklM0ElMjB2YWwlMjBmb3IlMjBrZXklMkMlMjB2YWwlMjBpbiUyMGFjdGlvbi5pdGVtcygpJTdEJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwU2VuZCUyMGdvYWwlMjBwb3NpdGlvbiUyMHRvJTIwdGhlJTIwYXJtJTBBJTIwJTIwJTIwJTIwc2VsZi5idXMuc3luY193cml0ZSglMjJHb2FsX1Bvc2l0aW9uJTIyJTJDJTIwZ29hbF9wb3MpJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYWN0aW9u",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">send_action</span>(<span class="hljs-params">self, action: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]</span>) -&gt; <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]:
    goal_pos = {key.removesuffix(<span class="hljs-string">&quot;.pos&quot;</span>): val <span class="hljs-keyword">for</span> key, val <span class="hljs-keyword">in</span> action.items()}

    <span class="hljs-comment"># Send goal position to the arm</span>
    self.bus.sync_write(<span class="hljs-string">&quot;Goal_Position&quot;</span>, goal_pos)

    <span class="hljs-keyword">return</span> action`,wrap:!1}}),_e=new j({props:{title:"Adding a Teleoperator",local:"adding-a-teleoperator",headingTag:"h2"}}),Ge=new j({props:{title:"Wrapping Up",local:"wrapping-up",headingTag:"h2"}}),Ee=new ps({props:{source:"https://github.com/huggingface/lerobot/blob/main/docs/source/integrate_hardware.mdx"}}),{c(){J=o("meta"),b=a(),d=o("p"),Re=a(),M(h.$$.fragment),Xe=a(),f=o("p"),f.textContent=pt,Qe=a(),U=o("p"),U.innerHTML=Mt,Ve=a(),M(I.$$.fragment),ze=a(),C=o("ul"),C.innerHTML=rt,He=a(),M(v.$$.fragment),Fe=a(),g=o("p"),g.textContent=ct,Le=a(),B=o("ul"),B.innerHTML=mt,qe=a(),A=o("p"),A.innerHTML=yt,De=a(),$=o("p"),$.textContent=wt,Pe=a(),_=o("ul"),_.innerHTML=jt,Ke=a(),Z=o("p"),Z.textContent=Jt,Oe=a(),k=o("p"),k.innerHTML=Tt,el=a(),G=o("p"),G.innerHTML=dt,ll=a(),W=o("p"),W.innerHTML=ut,tl=a(),M(Y.$$.fragment),sl=a(),N=o("p"),N.innerHTML=bt,al=a(),E=o("p"),E.textContent=ht,nl=a(),M(R.$$.fragment),ol=a(),x=o("p"),x.innerHTML=ft,il=a(),S=o("p"),S.innerHTML=Ut,pl=a(),X=o("p"),X.innerHTML=It,Ml=a(),M(Q.$$.fragment),rl=a(),M(V.$$.fragment),cl=a(),z=o("p"),z.innerHTML=Ct,ml=a(),M(u.$$.fragment),yl=a(),M(H.$$.fragment),wl=a(),F=o("p"),F.innerHTML=vt,jl=a(),L=o("p"),L.textContent=gt,Jl=a(),M(q.$$.fragment),Tl=a(),D=o("p"),D.textContent=Bt,dl=a(),M(P.$$.fragment),ul=a(),K=o("p"),K.innerHTML=At,bl=a(),O=o("p"),O.innerHTML=$t,hl=a(),M(ee.$$.fragment),fl=a(),M(le.$$.fragment),Ul=a(),te=o("p"),te.textContent=_t,Il=a(),M(se.$$.fragment),Cl=a(),ae=o("p"),ae.innerHTML=Zt,vl=a(),M(ne.$$.fragment),gl=a(),M(oe.$$.fragment),Bl=a(),ie=o("p"),ie.textContent=kt,Al=a(),M(pe.$$.fragment),$l=a(),M(Me.$$.fragment),_l=a(),re=o("p"),re.textContent=Gt,Zl=a(),ce=o("p"),ce.innerHTML=Wt,kl=a(),M(me.$$.fragment),Gl=a(),M(ye.$$.fragment),Wl=a(),we=o("p"),we.textContent=Yt,Yl=a(),je=o("blockquote"),je.innerHTML=Nt,Nl=a(),M(Je.$$.fragment),El=ss(`
python
`),Te=o("p"),Te.textContent=Et,Rl=a(),M(de.$$.fragment),xl=a(),M(ue.$$.fragment),Sl=a(),be=o("p"),be.textContent=Rt,Xl=a(),M(he.$$.fragment),Ql=a(),M(fe.$$.fragment),Vl=a(),Ue=o("p"),Ue.textContent=xt,zl=a(),M(Ie.$$.fragment),Hl=a(),Ce=o("p"),Ce.innerHTML=St,Fl=a(),M(ve.$$.fragment),Ll=a(),M(ge.$$.fragment),ql=a(),Be=o("p"),Be.innerHTML=Xt,Dl=a(),Ae=o("p"),Ae.textContent=Qt,Pl=a(),M($e.$$.fragment),Kl=a(),M(_e.$$.fragment),Ol=a(),Ze=o("p"),Ze.innerHTML=Vt,et=a(),ke=o("p"),ke.innerHTML=zt,lt=a(),M(Ge.$$.fragment),tt=a(),We=o("p"),We.textContent=Ht,st=a(),Ye=o("ul"),Ye.innerHTML=Ft,at=a(),Ne=o("p"),Ne.innerHTML=Lt,nt=a(),M(Ee.$$.fragment),ot=a(),xe=o("p"),this.h()},l(e){const l=as("svelte-u9bgzb",document.head);J=i(l,"META",{name:!0,content:!0}),l.forEach(t),b=n(e),d=i(e,"P",{}),Dt(d).forEach(t),Re=n(e),r(h.$$.fragment,e),Xe=n(e),f=i(e,"P",{"data-svelte-h":!0}),p(f)!=="svelte-sl443g"&&(f.textContent=pt),Qe=n(e),U=i(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-yp6pog"&&(U.innerHTML=Mt),Ve=n(e),r(I.$$.fragment,e),ze=n(e),C=i(e,"UL",{"data-svelte-h":!0}),p(C)!=="svelte-1dkkhxt"&&(C.innerHTML=rt),He=n(e),r(v.$$.fragment,e),Fe=n(e),g=i(e,"P",{"data-svelte-h":!0}),p(g)!=="svelte-9dsyh9"&&(g.textContent=ct),Le=n(e),B=i(e,"UL",{"data-svelte-h":!0}),p(B)!=="svelte-1cfhvoe"&&(B.innerHTML=mt),qe=n(e),A=i(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-169ujvt"&&(A.innerHTML=yt),De=n(e),$=i(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-12o83v0"&&($.textContent=wt),Pe=n(e),_=i(e,"UL",{"data-svelte-h":!0}),p(_)!=="svelte-1d5xfjp"&&(_.innerHTML=jt),Ke=n(e),Z=i(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-1e113uy"&&(Z.textContent=Jt),Oe=n(e),k=i(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-145ejj4"&&(k.innerHTML=Tt),el=n(e),G=i(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-wbam8h"&&(G.innerHTML=dt),ll=n(e),W=i(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-tm2a0s"&&(W.innerHTML=ut),tl=n(e),r(Y.$$.fragment,e),sl=n(e),N=i(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-rc24jv"&&(N.innerHTML=bt),al=n(e),E=i(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1p0w0g0"&&(E.textContent=ht),nl=n(e),r(R.$$.fragment,e),ol=n(e),x=i(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-12tjci0"&&(x.innerHTML=ft),il=n(e),S=i(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-dxku0t"&&(S.innerHTML=Ut),pl=n(e),X=i(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-nb93rz"&&(X.innerHTML=It),Ml=n(e),r(Q.$$.fragment,e),rl=n(e),r(V.$$.fragment,e),cl=n(e),z=i(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-l9j1d3"&&(z.innerHTML=Ct),ml=n(e),r(u.$$.fragment,e),yl=n(e),r(H.$$.fragment,e),wl=n(e),F=i(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-u7pcb4"&&(F.innerHTML=vt),jl=n(e),L=i(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-1t42iyr"&&(L.textContent=gt),Jl=n(e),r(q.$$.fragment,e),Tl=n(e),D=i(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1rkp57y"&&(D.textContent=Bt),dl=n(e),r(P.$$.fragment,e),ul=n(e),K=i(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-12yyl6o"&&(K.innerHTML=At),bl=n(e),O=i(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-1h5avx7"&&(O.innerHTML=$t),hl=n(e),r(ee.$$.fragment,e),fl=n(e),r(le.$$.fragment,e),Ul=n(e),te=i(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-h4v7d7"&&(te.textContent=_t),Il=n(e),r(se.$$.fragment,e),Cl=n(e),ae=i(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-1gpnath"&&(ae.innerHTML=Zt),vl=n(e),r(ne.$$.fragment,e),gl=n(e),r(oe.$$.fragment,e),Bl=n(e),ie=i(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-1iphpc4"&&(ie.textContent=kt),Al=n(e),r(pe.$$.fragment,e),$l=n(e),r(Me.$$.fragment,e),_l=n(e),re=i(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-lfuhuo"&&(re.textContent=Gt),Zl=n(e),ce=i(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-1seywak"&&(ce.innerHTML=Wt),kl=n(e),r(me.$$.fragment,e),Gl=n(e),r(ye.$$.fragment,e),Wl=n(e),we=i(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-1e7cuec"&&(we.textContent=Yt),Yl=n(e),je=i(e,"BLOCKQUOTE",{"data-svelte-h":!0}),p(je)!=="svelte-9w4yye"&&(je.innerHTML=Nt),Nl=n(e),r(Je.$$.fragment,e),El=ns(e,`
python
`),Te=i(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-1ufctnq"&&(Te.textContent=Et),Rl=n(e),r(de.$$.fragment,e),xl=n(e),r(ue.$$.fragment,e),Sl=n(e),be=i(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-1gxojkw"&&(be.textContent=Rt),Xl=n(e),r(he.$$.fragment,e),Ql=n(e),r(fe.$$.fragment,e),Vl=n(e),Ue=i(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-1qfd9tp"&&(Ue.textContent=xt),zl=n(e),r(Ie.$$.fragment,e),Hl=n(e),Ce=i(e,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-adteeq"&&(Ce.innerHTML=St),Fl=n(e),r(ve.$$.fragment,e),Ll=n(e),r(ge.$$.fragment,e),ql=n(e),Be=i(e,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-1elar01"&&(Be.innerHTML=Xt),Dl=n(e),Ae=i(e,"P",{"data-svelte-h":!0}),p(Ae)!=="svelte-xmm0bj"&&(Ae.textContent=Qt),Pl=n(e),r($e.$$.fragment,e),Kl=n(e),r(_e.$$.fragment,e),Ol=n(e),Ze=i(e,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-1s7uvme"&&(Ze.innerHTML=Vt),et=n(e),ke=i(e,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-19bs1hk"&&(ke.innerHTML=zt),lt=n(e),r(Ge.$$.fragment,e),tt=n(e),We=i(e,"P",{"data-svelte-h":!0}),p(We)!=="svelte-ta7vyn"&&(We.textContent=Ht),st=n(e),Ye=i(e,"UL",{"data-svelte-h":!0}),p(Ye)!=="svelte-16m8r0w"&&(Ye.innerHTML=Ft),at=n(e),Ne=i(e,"P",{"data-svelte-h":!0}),p(Ne)!=="svelte-o90m39"&&(Ne.innerHTML=Lt),nt=n(e),r(Ee.$$.fragment,e),ot=n(e),xe=i(e,"P",{}),Dt(xe).forEach(t),this.h()},h(){Pt(J,"name","hf:doc:metadata"),Pt(J,"content",cs)},m(e,l){os(document.head,J),s(e,b,l),s(e,d,l),s(e,Re,l),c(h,e,l),s(e,Xe,l),s(e,f,l),s(e,Qe,l),s(e,U,l),s(e,Ve,l),c(I,e,l),s(e,ze,l),s(e,C,l),s(e,He,l),c(v,e,l),s(e,Fe,l),s(e,g,l),s(e,Le,l),s(e,B,l),s(e,qe,l),s(e,A,l),s(e,De,l),s(e,$,l),s(e,Pe,l),s(e,_,l),s(e,Ke,l),s(e,Z,l),s(e,Oe,l),s(e,k,l),s(e,el,l),s(e,G,l),s(e,ll,l),s(e,W,l),s(e,tl,l),c(Y,e,l),s(e,sl,l),s(e,N,l),s(e,al,l),s(e,E,l),s(e,nl,l),c(R,e,l),s(e,ol,l),s(e,x,l),s(e,il,l),s(e,S,l),s(e,pl,l),s(e,X,l),s(e,Ml,l),c(Q,e,l),s(e,rl,l),c(V,e,l),s(e,cl,l),s(e,z,l),s(e,ml,l),c(u,e,l),s(e,yl,l),c(H,e,l),s(e,wl,l),s(e,F,l),s(e,jl,l),s(e,L,l),s(e,Jl,l),c(q,e,l),s(e,Tl,l),s(e,D,l),s(e,dl,l),c(P,e,l),s(e,ul,l),s(e,K,l),s(e,bl,l),s(e,O,l),s(e,hl,l),c(ee,e,l),s(e,fl,l),c(le,e,l),s(e,Ul,l),s(e,te,l),s(e,Il,l),c(se,e,l),s(e,Cl,l),s(e,ae,l),s(e,vl,l),c(ne,e,l),s(e,gl,l),c(oe,e,l),s(e,Bl,l),s(e,ie,l),s(e,Al,l),c(pe,e,l),s(e,$l,l),c(Me,e,l),s(e,_l,l),s(e,re,l),s(e,Zl,l),s(e,ce,l),s(e,kl,l),c(me,e,l),s(e,Gl,l),c(ye,e,l),s(e,Wl,l),s(e,we,l),s(e,Yl,l),s(e,je,l),s(e,Nl,l),c(Je,e,l),s(e,El,l),s(e,Te,l),s(e,Rl,l),c(de,e,l),s(e,xl,l),c(ue,e,l),s(e,Sl,l),s(e,be,l),s(e,Xl,l),c(he,e,l),s(e,Ql,l),c(fe,e,l),s(e,Vl,l),s(e,Ue,l),s(e,zl,l),c(Ie,e,l),s(e,Hl,l),s(e,Ce,l),s(e,Fl,l),c(ve,e,l),s(e,Ll,l),c(ge,e,l),s(e,ql,l),s(e,Be,l),s(e,Dl,l),s(e,Ae,l),s(e,Pl,l),c($e,e,l),s(e,Kl,l),c(_e,e,l),s(e,Ol,l),s(e,Ze,l),s(e,et,l),s(e,ke,l),s(e,lt,l),c(Ge,e,l),s(e,tt,l),s(e,We,l),s(e,st,l),s(e,Ye,l),s(e,at,l),s(e,Ne,l),s(e,nt,l),c(Ee,e,l),s(e,ot,l),s(e,xe,l),it=!0},p(e,[l]){const qt={};l&2&&(qt.$$scope={dirty:l,ctx:e}),u.$set(qt)},i(e){it||(m(h.$$.fragment,e),m(I.$$.fragment,e),m(v.$$.fragment,e),m(Y.$$.fragment,e),m(R.$$.fragment,e),m(Q.$$.fragment,e),m(V.$$.fragment,e),m(u.$$.fragment,e),m(H.$$.fragment,e),m(q.$$.fragment,e),m(P.$$.fragment,e),m(ee.$$.fragment,e),m(le.$$.fragment,e),m(se.$$.fragment,e),m(ne.$$.fragment,e),m(oe.$$.fragment,e),m(pe.$$.fragment,e),m(Me.$$.fragment,e),m(me.$$.fragment,e),m(ye.$$.fragment,e),m(Je.$$.fragment,e),m(de.$$.fragment,e),m(ue.$$.fragment,e),m(he.$$.fragment,e),m(fe.$$.fragment,e),m(Ie.$$.fragment,e),m(ve.$$.fragment,e),m(ge.$$.fragment,e),m($e.$$.fragment,e),m(_e.$$.fragment,e),m(Ge.$$.fragment,e),m(Ee.$$.fragment,e),it=!0)},o(e){y(h.$$.fragment,e),y(I.$$.fragment,e),y(v.$$.fragment,e),y(Y.$$.fragment,e),y(R.$$.fragment,e),y(Q.$$.fragment,e),y(V.$$.fragment,e),y(u.$$.fragment,e),y(H.$$.fragment,e),y(q.$$.fragment,e),y(P.$$.fragment,e),y(ee.$$.fragment,e),y(le.$$.fragment,e),y(se.$$.fragment,e),y(ne.$$.fragment,e),y(oe.$$.fragment,e),y(pe.$$.fragment,e),y(Me.$$.fragment,e),y(me.$$.fragment,e),y(ye.$$.fragment,e),y(Je.$$.fragment,e),y(de.$$.fragment,e),y(ue.$$.fragment,e),y(he.$$.fragment,e),y(fe.$$.fragment,e),y(Ie.$$.fragment,e),y(ve.$$.fragment,e),y(ge.$$.fragment,e),y($e.$$.fragment,e),y(_e.$$.fragment,e),y(Ge.$$.fragment,e),y(Ee.$$.fragment,e),it=!1},d(e){e&&(t(b),t(d),t(Re),t(Xe),t(f),t(Qe),t(U),t(Ve),t(ze),t(C),t(He),t(Fe),t(g),t(Le),t(B),t(qe),t(A),t(De),t($),t(Pe),t(_),t(Ke),t(Z),t(Oe),t(k),t(el),t(G),t(ll),t(W),t(tl),t(sl),t(N),t(al),t(E),t(nl),t(ol),t(x),t(il),t(S),t(pl),t(X),t(Ml),t(rl),t(cl),t(z),t(ml),t(yl),t(wl),t(F),t(jl),t(L),t(Jl),t(Tl),t(D),t(dl),t(ul),t(K),t(bl),t(O),t(hl),t(fl),t(Ul),t(te),t(Il),t(Cl),t(ae),t(vl),t(gl),t(Bl),t(ie),t(Al),t($l),t(_l),t(re),t(Zl),t(ce),t(kl),t(Gl),t(Wl),t(we),t(Yl),t(je),t(Nl),t(El),t(Te),t(Rl),t(xl),t(Sl),t(be),t(Xl),t(Ql),t(Vl),t(Ue),t(zl),t(Hl),t(Ce),t(Fl),t(Ll),t(ql),t(Be),t(Dl),t(Ae),t(Pl),t(Kl),t(Ol),t(Ze),t(et),t(ke),t(lt),t(tt),t(We),t(st),t(Ye),t(at),t(Ne),t(nt),t(ot),t(xe)),t(J),w(h,e),w(I,e),w(v,e),w(Y,e),w(R,e),w(Q,e),w(V,e),w(u,e),w(H,e),w(q,e),w(P,e),w(ee,e),w(le,e),w(se,e),w(ne,e),w(oe,e),w(pe,e),w(Me,e),w(me,e),w(ye,e),w(Je,e),w(de,e),w(ue,e),w(he,e),w(fe,e),w(Ie,e),w(ve,e),w(ge,e),w($e,e),w(_e,e),w(Ge,e),w(Ee,e)}}}const cs='{"title":"Bring Your Own Hardware","local":"bring-your-own-hardware","sections":[{"title":"Prerequisites","local":"prerequisites","sections":[],"depth":2},{"title":"Choose your motors","local":"choose-your-motors","sections":[],"depth":2},{"title":"Step 1: Subclass the Robot Interface","local":"step-1-subclass-the-robot-interface","sections":[],"depth":2},{"title":"Step 2: Define Observation and Action Features","local":"step-2-define-observation-and-action-features","sections":[{"title":"observation_features","local":"observationfeatures","sections":[],"depth":3},{"title":"action_features","local":"actionfeatures","sections":[],"depth":3}],"depth":2},{"title":"Step 3: Handle Connection and Disconnection","local":"step-3-handle-connection-and-disconnection","sections":[{"title":"is_connected","local":"isconnected","sections":[],"depth":3},{"title":"connect()","local":"connect","sections":[],"depth":3},{"title":"disconnect()","local":"disconnect","sections":[],"depth":3}],"depth":2},{"title":"Step 4: Support Calibration and Configuration","local":"step-4-support-calibration-and-configuration","sections":[{"title":"configure()","local":"configure","sections":[],"depth":3}],"depth":2},{"title":"Step 5: Implement Sensors Reading and Action Sending","local":"step-5-implement-sensors-reading-and-action-sending","sections":[{"title":"get_observation()","local":"getobservation","sections":[],"depth":3},{"title":"send_action()","local":"sendaction","sections":[],"depth":3}],"depth":2},{"title":"Adding a Teleoperator","local":"adding-a-teleoperator","sections":[],"depth":2},{"title":"Wrapping Up","local":"wrapping-up","sections":[],"depth":2}],"depth":1}';function ms(Se){return Ot(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ds extends ls{constructor(J){super(),ts(this,J,ms,rs,Kt,{})}}export{ds as component};
