import{s as xe,n as Ce,o as He}from"../chunks/scheduler.7bc62968.js";import{S as Ze,i as Ge,g as o,s as l,r as f,A as We,h as i,f as a,c as n,j as ke,u as c,x as r,k as fe,y as Be,a as s,v as u,d as g,t as h,w as y}from"../chunks/index.66556066.js";import{H as V,g as ze}from"../chunks/Heading.8f17e89c.js";import{C as ce}from"../chunks/CodeBlock.a759539a.js";function Le(ue){let m,X,L,q,w,P,b,ge="🤗 <code>transformers</code> is a library maintained by Hugging Face and the community, for state-of-the-art Machine Learning for Pytorch, TensorFlow and JAX. It provides thousands of pretrained models to perform tasks on different modalities such as text, vision, and audio. We are a bit biased, but we really like 🤗 <code>transformers</code>!",F,M,N,T,he='There are over 25,000 <code>transformers</code> models in the Hub which you can find by filtering at the left of <a href="https://huggingface.co/models?library=transformers&amp;sort=downloads" rel="nofollow">the models page</a>.',Q,J,ye="You can find models for many different tasks:",R,v,we='<li>Extracting the answer from a context (<a href="https://huggingface.co/models?library=transformers&amp;pipeline_tag=question-answering&amp;sort=downloads" rel="nofollow">question-answering</a>).</li> <li>Creating summaries from a large text (<a href="https://huggingface.co/models?library=transformers&amp;pipeline_tag=summarization&amp;sort=downloads" rel="nofollow">summarization</a>).</li> <li>Classify text (e.g. as spam or not spam, <a href="https://huggingface.co/models?library=transformers&amp;pipeline_tag=text-classification&amp;sort=downloads" rel="nofollow">text-classification</a>).</li> <li>Generate a new text with models such as GPT (<a href="https://huggingface.co/models?library=transformers&amp;pipeline_tag=text-generation&amp;sort=downloads" rel="nofollow">text-generation</a>).</li> <li>Identify parts of speech (verb, subject, etc.) or entities (country, organization, etc.) in a sentence (<a href="https://huggingface.co/models?library=transformers&amp;pipeline_tag=token-classification&amp;sort=downloads" rel="nofollow">token-classification</a>).</li> <li>Transcribe audio files to text (<a href="https://huggingface.co/models?library=transformers&amp;pipeline_tag=automatic-speech-recognition&amp;sort=downloads" rel="nofollow">automatic-speech-recognition</a>).</li> <li>Classify the speaker or language in an audio file (<a href="https://huggingface.co/models?library=transformers&amp;pipeline_tag=audio-classification&amp;sort=downloads" rel="nofollow">audio-classification</a>).</li> <li>Detect objects in an image (<a href="https://huggingface.co/models?library=transformers&amp;pipeline_tag=object-detection&amp;sort=downloads" rel="nofollow">object-detection</a>).</li> <li>Segment an image (<a href="https://huggingface.co/models?library=transformers&amp;pipeline_tag=image-segmentation&amp;sort=downloads" rel="nofollow">image-segmentation</a>).</li> <li>Do Reinforcement Learning (<a href="https://huggingface.co/models?library=transformers&amp;pipeline_tag=reinforcement-learning&amp;sort=downloads" rel="nofollow">reinforcement-learning</a>)!</li>',S,$,be="You can try out the models directly in the browser if you want to test them out without downloading them thanks to the in-browser widgets!",Y,p,Me='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/libraries-transformers_widget.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/libraries-transformers_widget-dark.png"/>',A,U,D,I,Te="All <code>transformer</code> models are a line away from being used! Depending on how you want to use them, you can use the high-level API using the <code>pipeline</code> function or you can use <code>AutoModel</code> for more control.",K,_,O,j,Je="You can also load a model from a specific version (based on commit hash, tag name, or branch) as follows:",ee,k,te,x,ve="If you want to see how to load a specific model, you can click <code>Use in Transformers</code> and you will be given a working snippet that you can load it! If you need further information about the model architecture, you can also click the “Read model documentation” at the bottom of the snippet.",ae,d,$e='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/libraries-transformers_snippet.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/libraries-transformers_snippet-dark.png"/>',se,C,le,H,Ue='To read all about sharing models with <code>transformers</code>, please head out to the <a href="https://huggingface.co/docs/transformers/model_sharing" rel="nofollow">Share a model</a> guide in the official documentation.',ne,Z,Ie="Many classes in <code>transformers</code>, such as the models and tokenizers, have a <code>push_to_hub</code> method that allows to easily upload the files to a repository.",oe,G,ie,W,_e='There is much more you can do, so we suggest to review the <a href="https://huggingface.co/docs/transformers/model_sharing" rel="nofollow">Share a model</a> guide.',re,B,me,z,je='<li>Transformers <a href="https://github.com/huggingface/transformers" rel="nofollow">library</a>.</li> <li>Transformers <a href="https://huggingface.co/docs/transformers/index" rel="nofollow">docs</a>.</li> <li>Share a model <a href="https://huggingface.co/docs/transformers/model_sharing" rel="nofollow">guide</a>.</li>',pe,E,de;return w=new V({props:{title:"Using 🤗 transformers at Hugging Face",local:"using--transformers-at-hugging-face",headingTag:"h1"}}),M=new V({props:{title:"Exploring 🤗 transformers in the Hub",local:"exploring--transformers-in-the-hub",headingTag:"h2"}}),U=new V({props:{title:"Using existing models",local:"using-existing-models",headingTag:"h2"}}),_=new ce({props:{code:"JTIzJTIwV2l0aCUyMHBpcGVsaW5lJTJDJTIwanVzdCUyMHNwZWNpZnklMjB0aGUlMjB0YXNrJTIwYW5kJTIwdGhlJTIwbW9kZWwlMjBpZCUyMGZyb20lMjB0aGUlMjBIdWIuJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnRleHQtZ2VuZXJhdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyZGlzdGlsZ3B0MiUyMiklMEElMEElMjMlMjBJZiUyMHlvdSUyMHdhbnQlMjBtb3JlJTIwY29udHJvbCUyQyUyMHlvdSUyMHdpbGwlMjBuZWVkJTIwdG8lMjBkZWZpbmUlMjB0aGUlMjB0b2tlbml6ZXIlMjBhbmQlMjBtb2RlbC4lMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZGlzdGlsZ3B0MiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxncHQyJTIyKQ==",highlighted:`<span class="hljs-comment"># With pipeline, just specify the task and the model id from the Hub.</span>
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
pipe = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, model=<span class="hljs-string">&quot;distilgpt2&quot;</span>)

<span class="hljs-comment"># If you want more control, you will need to define the tokenizer and model.</span>
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)`,wrap:!1}}),k=new ce({props:{code:"bW9kZWwlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmp1bGllbi1jJTJGRXNwZXJCRVJUby1zbWFsbCUyMiUyQyUyMHJldmlzaW9uJTNEJTIydjIuMC4xJTIyJTIwJTIwJTIzJTIwdGFnJTIwbmFtZSUyQyUyMG9yJTIwYnJhbmNoJTIwbmFtZSUyQyUyMG9yJTIwY29tbWl0JTIwaGFzaCUwQSk=",highlighted:`model = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;julien-c/EsperBERTo-small&quot;</span>, revision=<span class="hljs-string">&quot;v2.0.1&quot;</span>  <span class="hljs-comment"># tag name, or branch name, or commit hash</span>
)`,wrap:!1}}),C=new V({props:{title:"Sharing your models",local:"sharing-your-models",headingTag:"h2"}}),G=new ce({props:{code:"JTIzJTIwUHVzaGluZyUyMG1vZGVsJTIwdG8lMjB5b3VyJTIwb3duJTIwYWNjb3VudCUwQW1vZGVsLnB1c2hfdG9faHViKCUyMm15LWF3ZXNvbWUtbW9kZWwlMjIpJTBBJTBBJTIzJTIwUHVzaGluZyUyMHlvdXIlMjB0b2tlbml6ZXIlMEF0b2tlbml6ZXIucHVzaF90b19odWIoJTIybXktYXdlc29tZS1tb2RlbCUyMiklMEElMEElMjMlMjBQdXNoaW5nJTIwYWxsJTIwdGhpbmdzJTIwYWZ0ZXIlMjB0cmFpbmluZyUwQXRyYWluZXIucHVzaF90b19odWIoKQ==",highlighted:`<span class="hljs-comment"># Pushing model to your own account</span>
model.push_to_hub(<span class="hljs-string">&quot;my-awesome-model&quot;</span>)

<span class="hljs-comment"># Pushing your tokenizer</span>
tokenizer.push_to_hub(<span class="hljs-string">&quot;my-awesome-model&quot;</span>)

<span class="hljs-comment"># Pushing all things after training</span>
trainer.push_to_hub()`,wrap:!1}}),B=new V({props:{title:"Additional resources",local:"additional-resources",headingTag:"h2"}}),{c(){m=o("meta"),X=l(),L=o("p"),q=l(),f(w.$$.fragment),P=l(),b=o("p"),b.innerHTML=ge,F=l(),f(M.$$.fragment),N=l(),T=o("p"),T.innerHTML=he,Q=l(),J=o("p"),J.textContent=ye,R=l(),v=o("ul"),v.innerHTML=we,S=l(),$=o("p"),$.textContent=be,Y=l(),p=o("div"),p.innerHTML=Me,A=l(),f(U.$$.fragment),D=l(),I=o("p"),I.innerHTML=Te,K=l(),f(_.$$.fragment),O=l(),j=o("p"),j.textContent=Je,ee=l(),f(k.$$.fragment),te=l(),x=o("p"),x.innerHTML=ve,ae=l(),d=o("div"),d.innerHTML=$e,se=l(),f(C.$$.fragment),le=l(),H=o("p"),H.innerHTML=Ue,ne=l(),Z=o("p"),Z.innerHTML=Ie,oe=l(),f(G.$$.fragment),ie=l(),W=o("p"),W.innerHTML=_e,re=l(),f(B.$$.fragment),me=l(),z=o("ul"),z.innerHTML=je,pe=l(),E=o("p"),this.h()},l(e){const t=We("svelte-u9bgzb",document.head);m=i(t,"META",{name:!0,content:!0}),t.forEach(a),X=n(e),L=i(e,"P",{}),ke(L).forEach(a),q=n(e),c(w.$$.fragment,e),P=n(e),b=i(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-rpg67t"&&(b.innerHTML=ge),F=n(e),c(M.$$.fragment,e),N=n(e),T=i(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-o4uiyf"&&(T.innerHTML=he),Q=n(e),J=i(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-qpj6j"&&(J.textContent=ye),R=n(e),v=i(e,"UL",{"data-svelte-h":!0}),r(v)!=="svelte-qjs9xt"&&(v.innerHTML=we),S=n(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-apziil"&&($.textContent=be),Y=n(e),p=i(e,"DIV",{class:!0,"data-svelte-h":!0}),r(p)!=="svelte-435q1z"&&(p.innerHTML=Me),A=n(e),c(U.$$.fragment,e),D=n(e),I=i(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1gtg5ls"&&(I.innerHTML=Te),K=n(e),c(_.$$.fragment,e),O=n(e),j=i(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-3407pd"&&(j.textContent=Je),ee=n(e),c(k.$$.fragment,e),te=n(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1quwgdt"&&(x.innerHTML=ve),ae=n(e),d=i(e,"DIV",{class:!0,"data-svelte-h":!0}),r(d)!=="svelte-125odup"&&(d.innerHTML=$e),se=n(e),c(C.$$.fragment,e),le=n(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1qw74m4"&&(H.innerHTML=Ue),ne=n(e),Z=i(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1e42a6j"&&(Z.innerHTML=Ie),oe=n(e),c(G.$$.fragment,e),ie=n(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-t0bbcx"&&(W.innerHTML=_e),re=n(e),c(B.$$.fragment,e),me=n(e),z=i(e,"UL",{"data-svelte-h":!0}),r(z)!=="svelte-1n31o8y"&&(z.innerHTML=je),pe=n(e),E=i(e,"P",{}),ke(E).forEach(a),this.h()},h(){fe(m,"name","hf:doc:metadata"),fe(m,"content",Ee),fe(p,"class","flex justify-center"),fe(d,"class","flex justify-center")},m(e,t){Be(document.head,m),s(e,X,t),s(e,L,t),s(e,q,t),u(w,e,t),s(e,P,t),s(e,b,t),s(e,F,t),u(M,e,t),s(e,N,t),s(e,T,t),s(e,Q,t),s(e,J,t),s(e,R,t),s(e,v,t),s(e,S,t),s(e,$,t),s(e,Y,t),s(e,p,t),s(e,A,t),u(U,e,t),s(e,D,t),s(e,I,t),s(e,K,t),u(_,e,t),s(e,O,t),s(e,j,t),s(e,ee,t),u(k,e,t),s(e,te,t),s(e,x,t),s(e,ae,t),s(e,d,t),s(e,se,t),u(C,e,t),s(e,le,t),s(e,H,t),s(e,ne,t),s(e,Z,t),s(e,oe,t),u(G,e,t),s(e,ie,t),s(e,W,t),s(e,re,t),u(B,e,t),s(e,me,t),s(e,z,t),s(e,pe,t),s(e,E,t),de=!0},p:Ce,i(e){de||(g(w.$$.fragment,e),g(M.$$.fragment,e),g(U.$$.fragment,e),g(_.$$.fragment,e),g(k.$$.fragment,e),g(C.$$.fragment,e),g(G.$$.fragment,e),g(B.$$.fragment,e),de=!0)},o(e){h(w.$$.fragment,e),h(M.$$.fragment,e),h(U.$$.fragment,e),h(_.$$.fragment,e),h(k.$$.fragment,e),h(C.$$.fragment,e),h(G.$$.fragment,e),h(B.$$.fragment,e),de=!1},d(e){e&&(a(X),a(L),a(q),a(P),a(b),a(F),a(N),a(T),a(Q),a(J),a(R),a(v),a(S),a($),a(Y),a(p),a(A),a(D),a(I),a(K),a(O),a(j),a(ee),a(te),a(x),a(ae),a(d),a(se),a(le),a(H),a(ne),a(Z),a(oe),a(ie),a(W),a(re),a(me),a(z),a(pe),a(E)),a(m),y(w,e),y(M,e),y(U,e),y(_,e),y(k,e),y(C,e),y(G,e),y(B,e)}}}const Ee='{"title":"Using 🤗 transformers at Hugging Face","local":"using--transformers-at-hugging-face","sections":[{"title":"Exploring 🤗 transformers in the Hub","local":"exploring--transformers-in-the-hub","sections":[],"depth":2},{"title":"Using existing models","local":"using-existing-models","sections":[],"depth":2},{"title":"Sharing your models","local":"sharing-your-models","sections":[],"depth":2},{"title":"Additional resources","local":"additional-resources","sections":[],"depth":2}],"depth":1}';function Ve(ue){return He(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=ze}),[]}class Ne extends Ze{constructor(m){super(),Ge(this,m,Ve,Le,xe,{})}}export{Ne as component};
