import{s as OM,n as ls,o as Ms}from"../chunks/scheduler.7bc62968.js";import{S as ss,i as es,g as n,s as t,r as U,A as ts,h as y,f as s,c as a,j as PM,u as T,x as i,k as rl,y as as,a as e,v as o,d as J,t as w,w as C}from"../chunks/index.2f8492b0.js";import{C as Cl}from"../chunks/CodeBlock.bb61a5a9.js";import{H as r,E as ns}from"../chunks/getInferenceSnippets.6109a300.js";function ys(IM){let j,Il,jl,cl,h,dl,m,cM='In this section, we will be doing a deep dive into Convolutional Vision Transformer (CvT) which is a variant of Vision Transformer (ViT)<a href="#vision-transformer">[1]</a> and extensively used for the Image Classification task in Computer Vision.',hl,A,ml,u,dM="Before going into CvT, let’s have a small recap on ViT architecture covered in the previous sections to better appreciate the CvT architecture. ViT decomposes each image into a sequence of tokens (i.e. non-overlapping patches) with a fixed length and then applies multiple standard Transformer layers, consisting of Multi-head Self Attention and Position-wise Feed-forward module (FFN) to model global relations for classification.",Al,f,ul,b,hM='Convolutional Vision Transformer (CvT) model was proposed in CvT: Introducing Convolutions to Vision Transformers <a href="#cvt">[2]</a> by Haiping Wu, Bin Xiao, Noel Codella, Mengchen Liu, Xiyang Dai, Lu Yuan and Lei Zhang. CvT employs all the benefits of CNNs: <em>local receptive fields</em>, <em>shared weights</em>, and <em>spatial subsampling</em> along with <em>shift</em>, <em>scale</em>, <em>distortion invariance</em> while keeping merits of Transformers: <em>dynamic attention</em>, <em>global context fusion</em>, and <em>better generalization</em>. CvT achieves superior performance while maintaining computational efficiency compared to ViT. Furthermore, due to built-in local context structure introduced by convolutions, CvT no longer requires a position embedding, giving it a potential advantage for adaption to a wide range of vision tasks requiring variable input resolution.',fl,g,bl,B,mM='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/cvt_architecture.png" alt="CvT Architecture"/> <em>(a) Overall architecture, showing the hierarchical multi-stage structure facilitated by the Convolutional Token Embedding layer. (b) Details of the Convolutional Transformer Block, which contains the convolutional projection as the first layer. <a href="#cvt">[2]</a></em>',gl,k,AM="The above image of CvT architecture illustrates the main steps of 3-stage pipeline. At its core, CvT blends two convolution-based operations into the Vision Transformer architecture:",Bl,v,uM="<li><strong>Convolutional Token Embedding</strong>: Imagine splitting the input image into overlapping patches, reshaping them into tokens, and then feeding them to a convolution layer. This reduces the number of tokens (like pixels in a downsampled image) while boosting their feature richness, similar to traditional CNNs. Unlike other Transformers, we skip adding pre-defined position information to the tokens, relying solely on convolutional operations to capture spatial relationships.</li>",kl,E,fM='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/cvt_conv_proj.png" alt="Projection Layer"/> <em>(a) Linear Projection in ViT. (b) Convolutional Projection. (c) Squeezed Convolutional Projection (Default in CvT). <a href="#cvt">[2]</a></em>',vl,_,bM="<li><strong>Convolutional Transformer Blocks</strong>: Each stage in CvT contains a stack of these blocks. Here, instead of the usual linear projections in ViT, we use depth-wise separable convolutions (Convolutional Projection) to process the “query,” “key,” and “value” components of the self-attention module as shown in the above image. This maintains the benefits of Transformers while improving efficiency. Note that the “classification token” (used for final prediction) is only added in the last stage. Finally, a standard fully-connected layer analyzes the final classification token to predict the image class.</li>",El,Q,_l,Z,gM="The below table shows the key differences in terms of the necessity of positional encodings, type of token embedding, type of projection, and Transformer structure in the backbone, between the above representative concurrent works and CvT.",Ql,R,BM='<thead><tr><th>Model</th> <th>Needs Position Encoding (PE)</th> <th>Token Embedding</th> <th>Projection for Attention</th> <th>Hierarchical Transformers</th></tr></thead> <tbody><tr><td>ViT<a href="#vision-transformer">[1]</a>, DeiT <a href="#deit">[3]</a></td> <td>Yes</td> <td>Non-overlapping</td> <td>Linear</td> <td>No</td></tr> <tr><td>CPVT<a href="#cpvt">[4]</a></td> <td>No (w/PE Generator)</td> <td>Non-Overlapping</td> <td>Linear</td> <td>No</td></tr> <tr><td>TNT<a href="#tnt">[5]</a></td> <td>Yes</td> <td>Non-overlapping (Patch + Pixel)</td> <td>Linear</td> <td>No</td></tr> <tr><td>T2T<a href="#t2t">[6]</a></td> <td>Yes</td> <td>Overlapping (Concatenate)</td> <td>Linear</td> <td>Partial (Tokenization)</td></tr> <tr><td>PVT<a href="#pvt">[7]</a></td> <td>Yes</td> <td>Non-overlapping</td> <td>Spatial Reduction</td> <td>Yes</td></tr> <tr><td><em>CvT</em><a href="#cvt">[2]</a></td> <td><em>No</em></td> <td><em>Overlapping (Convolution)</em></td> <td><em>Convolution</em></td> <td><em>Yes</em></td></tr></tbody>',Zl,V,Rl,N,kM="The four main highlights of CvT that helped achieve superior performance and computational efficiency are the following:",Vl,G,vM="<li><strong>Hierarchy of Transformers</strong> containing a new <strong>Convolutional token embedding</strong>.</li> <li>Convolutional Transformer block leveraging a <strong>Convolutional Projection</strong>.</li> <li><strong>Removal of Positional Encoding</strong> due to built-in local context structure introduced by convolutions.</li> <li>Fewer <strong>Parameters</strong> and lower <strong>FLOPs</strong> (Floating Point Operations per second) compared to other vision transformer architectures.</li>",Nl,S,Gl,W,EM='Time to get hands-on! Let’s explore how to code each major blocks of the CvT architecture in PyTorch shown in the official implementation <a href="#cvt-imp">[8]</a>.',Sl,z,_M="<li>Importing required libraries</li>",Wl,H,zl,p,QM="<li>Implementation of <strong>Convolutional Projection</strong></li>",Hl,x,xl,X,ZM="The method takes several parameters related to a convolutional layer (such as input and output dimensions, kernel size, padding, stride, and method) and returns a projection block based on the specified method.",Xl,Y,RM="<li><p>If the method is <code>dw_bn</code> (depthwise separable with batch normalization), it creates a Sequential block consisting of a depthwise separable convolutional layer followed by batch normalization and rearranges the dimensions.</p></li> <li><p>If the method is <code>avg</code> (average pooling), it creates a Sequential block with an average pooling layer followed by rearranging the dimensions.</p></li> <li><p>If the method is <code>linear</code>, it returns None, indicating that no projection is applied.</p></li>",Yl,q,VM="The rearrangement of dimensions is performed using the <code>Rearrange</code> operation, which reshapes the input tensor. The resulting projection block is then returned.",ql,I,NM="<li>Implementation of <strong>Convolutional Token Embedding</strong></li>",Fl,F,$l,$,GM="This code defines a ConvEmbed module that performs patch-wise embedding on an input image.",Ll,L,SM="<li><p>The <code>__init__</code> method initializes the module with parameters such as <code>patch_size</code> (size of the image patches), <code>in_chans</code> (number of input channels), <code>embed_dim</code> (dimensionality of the embedded patches), <code>stride</code> (stride for the convolution operation), <code>padding</code> (padding for the convolution operation), and <code>norm_layer</code> (a normalization layer, which is optional).</p></li> <li><p>In the constructor, a 2D convolutional layer (<code>nn.Conv2d</code>) is created with specified parameters, including the patch size, input channels, embedding dimension, stride, and padding. This convolutional layer is assigned to <code>self.proj</code>.</p></li> <li><p>If a normalization layer is provided, an instance of the normalization layer is created with embed_dim channels, and it is assigned to <code>self.norm</code>.</p></li> <li><p>The forward method takes an input tensor x and applies the convolution operation using <code>self.proj</code>. The output is reshaped using the rearrange function to flatten the spatial dimensions. If a normalization layer is present, it is applied to the flattened representation. Finally, the tensor is reshaped back to the original spatial dimensions and returned.</p></li>",Dl,D,WM="In summary, this module is designed for patch-wise embedding of images, where each patch is processed independently through a convolutional layer, and optional normalization is applied to the embedded features.",Kl,c,zM="<li>Implementation of <strong>Vision Transformer</strong> Block</li>",Pl,K,Ol,P,HM="This code defines a Vision Transformer module. Here’s a brief overview of the code:",lM,O,xM="<li><p><strong>Initialization:</strong> The <code>VisionTransformer</code> class is initialized with various parameters that define the model architecture, such as patch size, embedding dimensions, number of layers, number of attention heads, dropout rates, etc.</p></li> <li><p><strong>Patch Embedding:</strong> The model includes a patch embedding layer (`patch_embed), which processes the input image by dividing it into non-overlapping patches and embedding them using Convolutions.</p></li> <li><p><strong>Transformer Blocks:</strong> The model consists of a stack of transformer blocks (<code>Block</code>). The number of blocks is determined by the depth parameter. Each block contains multi-head self-attention mechanisms and a feedforward neural network.</p></li> <li><p><strong>Classification Token:</strong> Optionally, the model can include a learnable classification token (<code>cls_token</code>) appended to the input sequence. This token is used for classification tasks.</p></li> <li><p><strong>Stochastic Depth:</strong> Stochastic depth is applied to the transformer blocks, where a random subset of blocks is skipped during training to improve regularization. This is controlled by the <code>drop_path_rate</code> parameter.</p></li> <li><p><strong>Initialization of Weights:</strong> The model weights are initialized using either truncated normal distribution (<code>trunc_norm</code>) or Xavier initialization (<code>xavier</code>).</p></li> <li><p><strong>Forward Method:</strong> The forward method processes the input through the patch embedding, rearranges the dimensions, adds the classification token if present, applies dropout, and then passes the data through the stack of transformer blocks. Finally, the output is rearranged back to the original shape, and the classification token (if present) is separated from the rest of the sequence before returning the output.</p></li>",MM,d,XM="<li>Implementation of Convolutional Vision Transformer Block (<strong>Hierarchy of Transformers</strong>)</li>",sM,ll,eM,Ml,YM="This code defines a PyTorch module called <code>ConvolutionalVisionTransformer</code>.",tM,sl,qM="<li>The model consists of multiple stages, each represented by an instance of the <code>VisionTransformer</code> class.</li> <li>Each stage has different configurations such as patch size, stride, depth, number of heads, etc., specified in the spec dictionary.</li> <li>The <code>forward_features</code> method processes the input x through all the stages, and it aggregates the final representation.</li> <li>The class has a classifier head that performs a linear transformation to produce the final output.</li> <li>The <code>forward</code> method calls <code>forward_features</code> and then passes the result through the classifier head.</li> <li>The vision transformer stages are sequentially named as stage0, stage1, etc., and each stage is an instance of the <code>VisionTransformer</code> class forming a hierarchy of transformers.</li>",aM,el,FM='Congratulations! Now you know how to implement CvT architecture in PyTorch. You can view complete code of the CvT architecture <a href="https://github.com/microsoft/CvT/blob/main/lib/models/cls_cvt.py" rel="nofollow">here</a>.',nM,tl,yM,al,$M="If you’re looking to use CvT without getting into the complex details of its PyTorch implementation, you can easily do so by leveraging the Hugging Face <code>transformers</code> library. Here’s how:",iM,nl,UM,yl,LM='You can find the documentation for CvT model <a href="https://huggingface.co/docs/transformers/model_doc/cvt#overview" rel="nofollow">here</a>.',TM,il,oM,Ul,DM="Here is how to use CvT model to classify an image of the COCO 2017 dataset into one of the 1,000 ImageNet classes:",JM,Tl,wM,ol,CM,Jl,KM='<li><a href="https://arxiv.org/abs/2010.11929" rel="nofollow">An Image is Worth 16x16 Words: Transformers for Image Recognition at Scale</a> <a id="vision-transformer"></a></li> <li><a href="https://arxiv.org/abs/2103.15808" rel="nofollow">CvT: Introducing Convolutions to Vision Transformers</a> <a id="cvt"></a></li> <li><a href="https://arxiv.org/abs/2012.12877" rel="nofollow">Training data-efficient image transformers &amp; distillation through attention</a> <a id="deit"></a></li> <li><a href="https://arxiv.org/abs/2102.10882" rel="nofollow">Conditional Positional Encodings for Vision Transformers</a> <a id="cpvt"></a></li> <li><a href="https://arxiv.org/abs/2103.00112v3" rel="nofollow">Transformer in Transformer</a><a id="tnt"></a></li> <li><a href="https://arxiv.org/abs/2101.11986" rel="nofollow">Tokens-to-Token ViT: Training Vision Transformers from Scratch on ImageNet</a> <a id="t2t"></a></li> <li><a href="https://arxiv.org/abs/2102.12122" rel="nofollow">Pyramid Vision Transformer: A Versatile Backbone for Dense Prediction without Convolutions</a> <a id="pvt"></a></li> <li><a href="https://github.com/microsoft/CvT/tree/main" rel="nofollow">Implementation of CvT</a> <a id="cvt-imp"></a></li>',rM,wl,jM,pl,pM;return h=new r({props:{title:"Convolutional Vision Transformer (CvT)",local:"convolutional-vision-transformer-cvt",headingTag:"h1"}}),A=new r({props:{title:"Recap",local:"recap",headingTag:"h2"}}),f=new r({props:{title:"Overview",local:"overview",headingTag:"h2"}}),g=new r({props:{title:"Architecture",local:"architecture",headingTag:"h2"}}),Q=new r({props:{title:"Comparision of CvT Architecture with other Vision Transformers",local:"comparision-of-cvt-architecture-with-other-vision-transformers",headingTag:"h3"}}),V=new r({props:{title:"Main Highlights",local:"main-highlights",headingTag:"h3"}}),S=new r({props:{title:"PyTorch Implementation",local:"pytorch-implementation",headingTag:"h2"}}),H=new Cl({props:{code:"ZnJvbSUyMGNvbGxlY3Rpb25zJTIwaW1wb3J0JTIwT3JkZXJlZERpY3QlMEFpbXBvcnQlMjB0b3JjaCUwQWltcG9ydCUyMHRvcmNoLm5uJTIwYXMlMjBubiUwQWltcG9ydCUyMHRvcmNoLm5uLmZ1bmN0aW9uYWwlMjBhcyUyMEYlMEFmcm9tJTIwZWlub3BzJTIwaW1wb3J0JTIwcmVhcnJhbmdlJTBBZnJvbSUyMGVpbm9wcy5sYXllcnMudG9yY2glMjBpbXBvcnQlMjBSZWFycmFuZ2U=",highlighted:`<span class="hljs-keyword">from</span> collections <span class="hljs-keyword">import</span> OrderedDict
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-keyword">import</span> torch.nn.functional <span class="hljs-keyword">as</span> F
<span class="hljs-keyword">from</span> einops <span class="hljs-keyword">import</span> rearrange
<span class="hljs-keyword">from</span> einops.layers.torch <span class="hljs-keyword">import</span> Rearrange`,wrap:!1}}),x=new Cl({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">_build_projection</span>(<span class="hljs-params">self, dim_in, dim_out, kernel_size, padding, stride, method</span>):
    <span class="hljs-keyword">if</span> method == <span class="hljs-string">&quot;dw_bn&quot;</span>:
        proj = nn.Sequential(
            OrderedDict(
                [
                    (
                        <span class="hljs-string">&quot;conv&quot;</span>,
                        nn.Conv2d(
                            dim_in,
                            dim_in,
                            kernel_size=kernel_size,
                            padding=padding,
                            stride=stride,
                            bias=<span class="hljs-literal">False</span>,
                            groups=dim_in,
                        ),
                    ),
                    (<span class="hljs-string">&quot;bn&quot;</span>, nn.BatchNorm2d(dim_in)),
                    (<span class="hljs-string">&quot;rearrage&quot;</span>, Rearrange(<span class="hljs-string">&quot;b c h w -&gt; b (h w) c&quot;</span>)),
                ]
            )
        )
    <span class="hljs-keyword">elif</span> method == <span class="hljs-string">&quot;avg&quot;</span>:
        proj = nn.Sequential(
            OrderedDict(
                [
                    (
                        <span class="hljs-string">&quot;avg&quot;</span>,
                        nn.AvgPool2d(
                            kernel_size=kernel_size,
                            padding=padding,
                            stride=stride,
                            ceil_mode=<span class="hljs-literal">True</span>,
                        ),
                    ),
                    (<span class="hljs-string">&quot;rearrage&quot;</span>, Rearrange(<span class="hljs-string">&quot;b c h w -&gt; b (h w) c&quot;</span>)),
                ]
            )
        )
    <span class="hljs-keyword">elif</span> method == <span class="hljs-string">&quot;linear&quot;</span>:
        proj = <span class="hljs-literal">None</span>
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">&quot;Unknown method ({})&quot;</span>.<span class="hljs-built_in">format</span>(method))

    <span class="hljs-keyword">return</span> proj`,wrap:!1}}),F=new Cl({props:{code:"Y2xhc3MlMjBDb252RW1iZWQobm4uTW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYlMkMlMjBwYXRjaF9zaXplJTNENyUyQyUyMGluX2NoYW5zJTNEMyUyQyUyMGVtYmVkX2RpbSUzRDY0JTJDJTIwc3RyaWRlJTNENCUyQyUyMHBhZGRpbmclM0QyJTJDJTIwbm9ybV9sYXllciUzRE5vbmUlMEElMjAlMjAlMjAlMjApJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoKS5fX2luaXRfXygpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGF0Y2hfc2l6ZSUyMCUzRCUyMHRvXzJ0dXBsZShwYXRjaF9zaXplKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYucGF0Y2hfc2l6ZSUyMCUzRCUyMHBhdGNoX3NpemUlMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLnByb2olMjAlM0QlMjBubi5Db252MmQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5fY2hhbnMlMkMlMjBlbWJlZF9kaW0lMkMlMjBrZXJuZWxfc2l6ZSUzRHBhdGNoX3NpemUlMkMlMjBzdHJpZGUlM0RzdHJpZGUlMkMlMjBwYWRkaW5nJTNEcGFkZGluZyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLm5vcm0lMjAlM0QlMjBub3JtX2xheWVyKGVtYmVkX2RpbSklMjBpZiUyMG5vcm1fbGF5ZXIlMjBlbHNlJTIwTm9uZSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweCUyMCUzRCUyMHNlbGYucHJvaih4KSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEIlMkMlMjBDJTJDJTIwSCUyQyUyMFclMjAlM0QlMjB4LnNoYXBlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweCUyMCUzRCUyMHJlYXJyYW5nZSh4JTJDJTIwJTIyYiUyMGMlMjBoJTIwdyUyMC0lM0UlMjBiJTIwKGglMjB3KSUyMGMlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBzZWxmLm5vcm0lM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB4JTIwJTNEJTIwc2VsZi5ub3JtKHgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweCUyMCUzRCUyMHJlYXJyYW5nZSh4JTJDJTIwJTIyYiUyMChoJTIwdyklMjBjJTIwLSUzRSUyMGIlMjBjJTIwaCUyMHclMjIlMkMlMjBoJTNESCUyQyUyMHclM0RXKSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHg=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">ConvEmbed</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">
        self, patch_size=<span class="hljs-number">7</span>, in_chans=<span class="hljs-number">3</span>, embed_dim=<span class="hljs-number">64</span>, stride=<span class="hljs-number">4</span>, padding=<span class="hljs-number">2</span>, norm_layer=<span class="hljs-literal">None</span>
    </span>):
        <span class="hljs-built_in">super</span>().__init__()
        patch_size = to_2tuple(patch_size)
        self.patch_size = patch_size

        self.proj = nn.Conv2d(
            in_chans, embed_dim, kernel_size=patch_size, stride=stride, padding=padding
        )
        self.norm = norm_layer(embed_dim) <span class="hljs-keyword">if</span> norm_layer <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        x = self.proj(x)

        B, C, H, W = x.shape
        x = rearrange(x, <span class="hljs-string">&quot;b c h w -&gt; b (h w) c&quot;</span>)
        <span class="hljs-keyword">if</span> self.norm:
            x = self.norm(x)
        x = rearrange(x, <span class="hljs-string">&quot;b (h w) c -&gt; b c h w&quot;</span>, h=H, w=W)

        <span class="hljs-keyword">return</span> x`,wrap:!1}}),K=new Cl({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">VisionTransformer</span>(nn.Module):
    <span class="hljs-string">&quot;&quot;&quot;Vision Transformer with support for patch or hybrid CNN input stage&quot;&quot;&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">
        self,
        patch_size=<span class="hljs-number">16</span>,
        patch_stride=<span class="hljs-number">16</span>,
        patch_padding=<span class="hljs-number">0</span>,
        in_chans=<span class="hljs-number">3</span>,
        embed_dim=<span class="hljs-number">768</span>,
        depth=<span class="hljs-number">12</span>,
        num_heads=<span class="hljs-number">12</span>,
        mlp_ratio=<span class="hljs-number">4.0</span>,
        qkv_bias=<span class="hljs-literal">False</span>,
        drop_rate=<span class="hljs-number">0.0</span>,
        attn_drop_rate=<span class="hljs-number">0.0</span>,
        drop_path_rate=<span class="hljs-number">0.0</span>,
        act_layer=nn.GELU,
        norm_layer=nn.LayerNorm,
        init=<span class="hljs-string">&quot;trunc_norm&quot;</span>,
        **kwargs,
    </span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.num_features = self.embed_dim = embed_dim

        self.rearrage = <span class="hljs-literal">None</span>

        self.patch_embed = ConvEmbed(
            patch_size=patch_size,
            in_chans=in_chans,
            stride=patch_stride,
            padding=patch_padding,
            embed_dim=embed_dim,
            norm_layer=norm_layer,
        )

        with_cls_token = kwargs[<span class="hljs-string">&quot;with_cls_token&quot;</span>]
        <span class="hljs-keyword">if</span> with_cls_token:
            self.cls_token = nn.Parameter(torch.zeros(<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, embed_dim))
        <span class="hljs-keyword">else</span>:
            self.cls_token = <span class="hljs-literal">None</span>

        self.pos_drop = nn.Dropout(p=drop_rate)
        dpr = [
            x.item() <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> torch.linspace(<span class="hljs-number">0</span>, drop_path_rate, depth)
        ]  <span class="hljs-comment"># stochastic depth decay rule</span>

        blocks = []
        <span class="hljs-keyword">for</span> j <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(depth):
            blocks.append(
                Block(
                    dim_in=embed_dim,
                    dim_out=embed_dim,
                    num_heads=num_heads,
                    mlp_ratio=mlp_ratio,
                    qkv_bias=qkv_bias,
                    drop=drop_rate,
                    attn_drop=attn_drop_rate,
                    drop_path=dpr[j],
                    act_layer=act_layer,
                    norm_layer=norm_layer,
                    **kwargs,
                )
            )
        self.blocks = nn.ModuleList(blocks)

        <span class="hljs-keyword">if</span> self.cls_token <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            trunc_normal_(self.cls_token, std=<span class="hljs-number">0.02</span>)

        <span class="hljs-keyword">if</span> init == <span class="hljs-string">&quot;xavier&quot;</span>:
            self.apply(self._init_weights_xavier)
        <span class="hljs-keyword">else</span>:
            self.apply(self._init_weights_trunc_normal)

        <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
            x = self.patch_embed(x)
            B, C, H, W = x.size()

            x = rearrange(x, <span class="hljs-string">&quot;b c h w -&gt; b (h w) c&quot;</span>)

            cls_tokens = <span class="hljs-literal">None</span>
            <span class="hljs-keyword">if</span> self.cls_token <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
                cls_tokens = self.cls_token.expand(B, -<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>)
                x = torch.cat((cls_tokens, x), dim=<span class="hljs-number">1</span>)

            x = self.pos_drop(x)

            <span class="hljs-keyword">for</span> i, blk <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(self.blocks):
                x = blk(x, H, W)

            <span class="hljs-keyword">if</span> self.cls_token <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
                cls_tokens, x = torch.split(x, [<span class="hljs-number">1</span>, H * W], <span class="hljs-number">1</span>)
            x = rearrange(x, <span class="hljs-string">&quot;b (h w) c -&gt; b c h w&quot;</span>, h=H, w=W)

            <span class="hljs-keyword">return</span> x, cls_tokens`,wrap:!1}}),ll=new Cl({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">ConvolutionalVisionTransformer</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">
        self,
        in_chans=<span class="hljs-number">3</span>,
        num_classes=<span class="hljs-number">1000</span>,
        act_layer=nn.GELU,
        norm_layer=nn.LayerNorm,
        init=<span class="hljs-string">&quot;trunc_norm&quot;</span>,
        spec=<span class="hljs-literal">None</span>,
    </span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.num_classes = num_classes

        self.num_stages = spec[<span class="hljs-string">&quot;NUM_STAGES&quot;</span>]
        <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(self.num_stages):
            kwargs = {
                <span class="hljs-string">&quot;patch_size&quot;</span>: spec[<span class="hljs-string">&quot;PATCH_SIZE&quot;</span>][i],
                <span class="hljs-string">&quot;patch_stride&quot;</span>: spec[<span class="hljs-string">&quot;PATCH_STRIDE&quot;</span>][i],
                <span class="hljs-string">&quot;patch_padding&quot;</span>: spec[<span class="hljs-string">&quot;PATCH_PADDING&quot;</span>][i],
                <span class="hljs-string">&quot;embed_dim&quot;</span>: spec[<span class="hljs-string">&quot;DIM_EMBED&quot;</span>][i],
                <span class="hljs-string">&quot;depth&quot;</span>: spec[<span class="hljs-string">&quot;DEPTH&quot;</span>][i],
                <span class="hljs-string">&quot;num_heads&quot;</span>: spec[<span class="hljs-string">&quot;NUM_HEADS&quot;</span>][i],
                <span class="hljs-string">&quot;mlp_ratio&quot;</span>: spec[<span class="hljs-string">&quot;MLP_RATIO&quot;</span>][i],
                <span class="hljs-string">&quot;qkv_bias&quot;</span>: spec[<span class="hljs-string">&quot;QKV_BIAS&quot;</span>][i],
                <span class="hljs-string">&quot;drop_rate&quot;</span>: spec[<span class="hljs-string">&quot;DROP_RATE&quot;</span>][i],
                <span class="hljs-string">&quot;attn_drop_rate&quot;</span>: spec[<span class="hljs-string">&quot;ATTN_DROP_RATE&quot;</span>][i],
                <span class="hljs-string">&quot;drop_path_rate&quot;</span>: spec[<span class="hljs-string">&quot;DROP_PATH_RATE&quot;</span>][i],
                <span class="hljs-string">&quot;with_cls_token&quot;</span>: spec[<span class="hljs-string">&quot;CLS_TOKEN&quot;</span>][i],
                <span class="hljs-string">&quot;method&quot;</span>: spec[<span class="hljs-string">&quot;QKV_PROJ_METHOD&quot;</span>][i],
                <span class="hljs-string">&quot;kernel_size&quot;</span>: spec[<span class="hljs-string">&quot;KERNEL_QKV&quot;</span>][i],
                <span class="hljs-string">&quot;padding_q&quot;</span>: spec[<span class="hljs-string">&quot;PADDING_Q&quot;</span>][i],
                <span class="hljs-string">&quot;padding_kv&quot;</span>: spec[<span class="hljs-string">&quot;PADDING_KV&quot;</span>][i],
                <span class="hljs-string">&quot;stride_kv&quot;</span>: spec[<span class="hljs-string">&quot;STRIDE_KV&quot;</span>][i],
                <span class="hljs-string">&quot;stride_q&quot;</span>: spec[<span class="hljs-string">&quot;STRIDE_Q&quot;</span>][i],
            }

            stage = VisionTransformer(
                in_chans=in_chans,
                init=init,
                act_layer=act_layer,
                norm_layer=norm_layer,
                **kwargs,
            )
            <span class="hljs-built_in">setattr</span>(self, <span class="hljs-string">f&quot;stage<span class="hljs-subst">{i}</span>&quot;</span>, stage)

            in_chans = spec[<span class="hljs-string">&quot;DIM_EMBED&quot;</span>][i]

        dim_embed = spec[<span class="hljs-string">&quot;DIM_EMBED&quot;</span>][-<span class="hljs-number">1</span>]
        self.norm = norm_layer(dim_embed)
        self.cls_token = spec[<span class="hljs-string">&quot;CLS_TOKEN&quot;</span>][-<span class="hljs-number">1</span>]

        <span class="hljs-comment"># Classifier head</span>
        self.head = (
            nn.Linear(dim_embed, num_classes) <span class="hljs-keyword">if</span> num_classes &gt; <span class="hljs-number">0</span> <span class="hljs-keyword">else</span> nn.Identity()
        )
        trunc_normal_(self.head.weight, std=<span class="hljs-number">0.02</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward_features</span>(<span class="hljs-params">self, x</span>):
        <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(self.num_stages):
            x, cls_tokens = <span class="hljs-built_in">getattr</span>(self, <span class="hljs-string">f&quot;stage<span class="hljs-subst">{i}</span>&quot;</span>)(x)

        <span class="hljs-keyword">if</span> self.cls_token:
            x = self.norm(cls_tokens)
            x = torch.squeeze(x)
        <span class="hljs-keyword">else</span>:
            x = rearrange(x, <span class="hljs-string">&quot;b c h w -&gt; b (h w) c&quot;</span>)
            x = self.norm(x)
            x = torch.mean(x, dim=<span class="hljs-number">1</span>)

        <span class="hljs-keyword">return</span> x

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        x = self.forward_features(x)
        x = self.head(x)

        <span class="hljs-keyword">return</span> x`,wrap:!1}}),tl=new r({props:{title:"Try it out",local:"try-it-out",headingTag:"h2"}}),nl=new Cl({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycw==",highlighted:"pip install transformers",wrap:!1}}),il=new r({props:{title:"Usage",local:"usage",headingTag:"h3"}}),Tl=new Cl({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTJDJTIwQ3Z0Rm9ySW1hZ2VDbGFzc2lmaWNhdGlvbiUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWZlYXR1cmVfZXh0cmFjdG9yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRmN2dC0xMyUyMiklMEFtb2RlbCUyMCUzRCUyMEN2dEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRmN2dC0xMyUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBmZWF0dXJlX2V4dHJhY3RvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRzJTBBJTIzJTIwbW9kZWwlMjBwcmVkaWN0cyUyMG9uZSUyMG9mJTIwdGhlJTIwMTAwMCUyMEltYWdlTmV0JTIwY2xhc3NlcyUwQXByZWRpY3RlZF9jbGFzc19pZHglMjAlM0QlMjBsb2dpdHMuYXJnbWF4KC0xKS5pdGVtKCklMEFwcmludCglMjJQcmVkaWN0ZWQlMjBjbGFzcyUzQSUyMiUyQyUyMG1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QnByZWRpY3RlZF9jbGFzc19pZHglNUQp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor, CvtForImageClassification
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;microsoft/cvt-13&quot;</span>)
model = CvtForImageClassification.from_pretrained(<span class="hljs-string">&quot;microsoft/cvt-13&quot;</span>)

inputs = feature_extractor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
outputs = model(**inputs)
logits = outputs.logits
<span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
predicted_class_idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted class:&quot;</span>, model.config.id2label[predicted_class_idx])`,wrap:!1}}),ol=new r({props:{title:"References",local:"references",headingTag:"h2"}}),wl=new ns({props:{source:"https://github.com/huggingface/computer-vision-course/blob/main/chapters/en/unit3/vision-transformers/cvt.mdx"}}),{c(){j=n("meta"),Il=t(),jl=n("p"),cl=t(),U(h.$$.fragment),dl=t(),m=n("p"),m.innerHTML=cM,hl=t(),U(A.$$.fragment),ml=t(),u=n("p"),u.textContent=dM,Al=t(),U(f.$$.fragment),ul=t(),b=n("p"),b.innerHTML=hM,fl=t(),U(g.$$.fragment),bl=t(),B=n("p"),B.innerHTML=mM,gl=t(),k=n("p"),k.textContent=AM,Bl=t(),v=n("ul"),v.innerHTML=uM,kl=t(),E=n("p"),E.innerHTML=fM,vl=t(),_=n("ul"),_.innerHTML=bM,El=t(),U(Q.$$.fragment),_l=t(),Z=n("p"),Z.textContent=gM,Ql=t(),R=n("table"),R.innerHTML=BM,Zl=t(),U(V.$$.fragment),Rl=t(),N=n("p"),N.textContent=kM,Vl=t(),G=n("ul"),G.innerHTML=vM,Nl=t(),U(S.$$.fragment),Gl=t(),W=n("p"),W.innerHTML=EM,Sl=t(),z=n("ol"),z.innerHTML=_M,Wl=t(),U(H.$$.fragment),zl=t(),p=n("ol"),p.innerHTML=QM,Hl=t(),U(x.$$.fragment),xl=t(),X=n("p"),X.textContent=ZM,Xl=t(),Y=n("ul"),Y.innerHTML=RM,Yl=t(),q=n("p"),q.innerHTML=VM,ql=t(),I=n("ol"),I.innerHTML=NM,Fl=t(),U(F.$$.fragment),$l=t(),$=n("p"),$.textContent=GM,Ll=t(),L=n("ul"),L.innerHTML=SM,Dl=t(),D=n("p"),D.textContent=WM,Kl=t(),c=n("ol"),c.innerHTML=zM,Pl=t(),U(K.$$.fragment),Ol=t(),P=n("p"),P.textContent=HM,lM=t(),O=n("ul"),O.innerHTML=xM,MM=t(),d=n("ol"),d.innerHTML=XM,sM=t(),U(ll.$$.fragment),eM=t(),Ml=n("p"),Ml.innerHTML=YM,tM=t(),sl=n("ul"),sl.innerHTML=qM,aM=t(),el=n("p"),el.innerHTML=FM,nM=t(),U(tl.$$.fragment),yM=t(),al=n("p"),al.innerHTML=$M,iM=t(),U(nl.$$.fragment),UM=t(),yl=n("p"),yl.innerHTML=LM,TM=t(),U(il.$$.fragment),oM=t(),Ul=n("p"),Ul.textContent=DM,JM=t(),U(Tl.$$.fragment),wM=t(),U(ol.$$.fragment),CM=t(),Jl=n("ul"),Jl.innerHTML=KM,rM=t(),U(wl.$$.fragment),jM=t(),pl=n("p"),this.h()},l(l){const M=ts("svelte-u9bgzb",document.head);j=y(M,"META",{name:!0,content:!0}),M.forEach(s),Il=a(l),jl=y(l,"P",{}),PM(jl).forEach(s),cl=a(l),T(h.$$.fragment,l),dl=a(l),m=y(l,"P",{"data-svelte-h":!0}),i(m)!=="svelte-16sbh2z"&&(m.innerHTML=cM),hl=a(l),T(A.$$.fragment,l),ml=a(l),u=y(l,"P",{"data-svelte-h":!0}),i(u)!=="svelte-h8g8bs"&&(u.textContent=dM),Al=a(l),T(f.$$.fragment,l),ul=a(l),b=y(l,"P",{"data-svelte-h":!0}),i(b)!=="svelte-6zwop"&&(b.innerHTML=hM),fl=a(l),T(g.$$.fragment,l),bl=a(l),B=y(l,"P",{"data-svelte-h":!0}),i(B)!=="svelte-8qvbjw"&&(B.innerHTML=mM),gl=a(l),k=y(l,"P",{"data-svelte-h":!0}),i(k)!=="svelte-1hpmpi2"&&(k.textContent=AM),Bl=a(l),v=y(l,"UL",{"data-svelte-h":!0}),i(v)!=="svelte-8uqhj0"&&(v.innerHTML=uM),kl=a(l),E=y(l,"P",{"data-svelte-h":!0}),i(E)!=="svelte-19dxdy5"&&(E.innerHTML=fM),vl=a(l),_=y(l,"UL",{"data-svelte-h":!0}),i(_)!=="svelte-1dr5apn"&&(_.innerHTML=bM),El=a(l),T(Q.$$.fragment,l),_l=a(l),Z=y(l,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-rzznkl"&&(Z.textContent=gM),Ql=a(l),R=y(l,"TABLE",{"data-svelte-h":!0}),i(R)!=="svelte-d2nidq"&&(R.innerHTML=BM),Zl=a(l),T(V.$$.fragment,l),Rl=a(l),N=y(l,"P",{"data-svelte-h":!0}),i(N)!=="svelte-1cwmxe6"&&(N.textContent=kM),Vl=a(l),G=y(l,"UL",{"data-svelte-h":!0}),i(G)!=="svelte-18fic2x"&&(G.innerHTML=vM),Nl=a(l),T(S.$$.fragment,l),Gl=a(l),W=y(l,"P",{"data-svelte-h":!0}),i(W)!=="svelte-n5s215"&&(W.innerHTML=EM),Sl=a(l),z=y(l,"OL",{"data-svelte-h":!0}),i(z)!=="svelte-1iuw5nq"&&(z.innerHTML=_M),Wl=a(l),T(H.$$.fragment,l),zl=a(l),p=y(l,"OL",{start:!0,"data-svelte-h":!0}),i(p)!=="svelte-1nmeitm"&&(p.innerHTML=QM),Hl=a(l),T(x.$$.fragment,l),xl=a(l),X=y(l,"P",{"data-svelte-h":!0}),i(X)!=="svelte-16rc2tn"&&(X.textContent=ZM),Xl=a(l),Y=y(l,"UL",{"data-svelte-h":!0}),i(Y)!=="svelte-1cz11rv"&&(Y.innerHTML=RM),Yl=a(l),q=y(l,"P",{"data-svelte-h":!0}),i(q)!=="svelte-14plira"&&(q.innerHTML=VM),ql=a(l),I=y(l,"OL",{start:!0,"data-svelte-h":!0}),i(I)!=="svelte-wkbrt0"&&(I.innerHTML=NM),Fl=a(l),T(F.$$.fragment,l),$l=a(l),$=y(l,"P",{"data-svelte-h":!0}),i($)!=="svelte-1ecejkd"&&($.textContent=GM),Ll=a(l),L=y(l,"UL",{"data-svelte-h":!0}),i(L)!=="svelte-1f6lcgb"&&(L.innerHTML=SM),Dl=a(l),D=y(l,"P",{"data-svelte-h":!0}),i(D)!=="svelte-16mpu0t"&&(D.textContent=WM),Kl=a(l),c=y(l,"OL",{start:!0,"data-svelte-h":!0}),i(c)!=="svelte-71ryog"&&(c.innerHTML=zM),Pl=a(l),T(K.$$.fragment,l),Ol=a(l),P=y(l,"P",{"data-svelte-h":!0}),i(P)!=="svelte-g3l3ba"&&(P.textContent=HM),lM=a(l),O=y(l,"UL",{"data-svelte-h":!0}),i(O)!=="svelte-h46hn5"&&(O.innerHTML=xM),MM=a(l),d=y(l,"OL",{start:!0,"data-svelte-h":!0}),i(d)!=="svelte-6qayo5"&&(d.innerHTML=XM),sM=a(l),T(ll.$$.fragment,l),eM=a(l),Ml=y(l,"P",{"data-svelte-h":!0}),i(Ml)!=="svelte-pi1s51"&&(Ml.innerHTML=YM),tM=a(l),sl=y(l,"UL",{"data-svelte-h":!0}),i(sl)!=="svelte-5gyfbr"&&(sl.innerHTML=qM),aM=a(l),el=y(l,"P",{"data-svelte-h":!0}),i(el)!=="svelte-r9bolc"&&(el.innerHTML=FM),nM=a(l),T(tl.$$.fragment,l),yM=a(l),al=y(l,"P",{"data-svelte-h":!0}),i(al)!=="svelte-62j7m0"&&(al.innerHTML=$M),iM=a(l),T(nl.$$.fragment,l),UM=a(l),yl=y(l,"P",{"data-svelte-h":!0}),i(yl)!=="svelte-1ss8190"&&(yl.innerHTML=LM),TM=a(l),T(il.$$.fragment,l),oM=a(l),Ul=y(l,"P",{"data-svelte-h":!0}),i(Ul)!=="svelte-5w7pre"&&(Ul.textContent=DM),JM=a(l),T(Tl.$$.fragment,l),wM=a(l),T(ol.$$.fragment,l),CM=a(l),Jl=y(l,"UL",{"data-svelte-h":!0}),i(Jl)!=="svelte-1m285ue"&&(Jl.innerHTML=KM),rM=a(l),T(wl.$$.fragment,l),jM=a(l),pl=y(l,"P",{}),PM(pl).forEach(s),this.h()},h(){rl(j,"name","hf:doc:metadata"),rl(j,"content",is),rl(p,"start","2"),rl(I,"start","3"),rl(c,"start","4"),rl(d,"start","5")},m(l,M){as(document.head,j),e(l,Il,M),e(l,jl,M),e(l,cl,M),o(h,l,M),e(l,dl,M),e(l,m,M),e(l,hl,M),o(A,l,M),e(l,ml,M),e(l,u,M),e(l,Al,M),o(f,l,M),e(l,ul,M),e(l,b,M),e(l,fl,M),o(g,l,M),e(l,bl,M),e(l,B,M),e(l,gl,M),e(l,k,M),e(l,Bl,M),e(l,v,M),e(l,kl,M),e(l,E,M),e(l,vl,M),e(l,_,M),e(l,El,M),o(Q,l,M),e(l,_l,M),e(l,Z,M),e(l,Ql,M),e(l,R,M),e(l,Zl,M),o(V,l,M),e(l,Rl,M),e(l,N,M),e(l,Vl,M),e(l,G,M),e(l,Nl,M),o(S,l,M),e(l,Gl,M),e(l,W,M),e(l,Sl,M),e(l,z,M),e(l,Wl,M),o(H,l,M),e(l,zl,M),e(l,p,M),e(l,Hl,M),o(x,l,M),e(l,xl,M),e(l,X,M),e(l,Xl,M),e(l,Y,M),e(l,Yl,M),e(l,q,M),e(l,ql,M),e(l,I,M),e(l,Fl,M),o(F,l,M),e(l,$l,M),e(l,$,M),e(l,Ll,M),e(l,L,M),e(l,Dl,M),e(l,D,M),e(l,Kl,M),e(l,c,M),e(l,Pl,M),o(K,l,M),e(l,Ol,M),e(l,P,M),e(l,lM,M),e(l,O,M),e(l,MM,M),e(l,d,M),e(l,sM,M),o(ll,l,M),e(l,eM,M),e(l,Ml,M),e(l,tM,M),e(l,sl,M),e(l,aM,M),e(l,el,M),e(l,nM,M),o(tl,l,M),e(l,yM,M),e(l,al,M),e(l,iM,M),o(nl,l,M),e(l,UM,M),e(l,yl,M),e(l,TM,M),o(il,l,M),e(l,oM,M),e(l,Ul,M),e(l,JM,M),o(Tl,l,M),e(l,wM,M),o(ol,l,M),e(l,CM,M),e(l,Jl,M),e(l,rM,M),o(wl,l,M),e(l,jM,M),e(l,pl,M),pM=!0},p:ls,i(l){pM||(J(h.$$.fragment,l),J(A.$$.fragment,l),J(f.$$.fragment,l),J(g.$$.fragment,l),J(Q.$$.fragment,l),J(V.$$.fragment,l),J(S.$$.fragment,l),J(H.$$.fragment,l),J(x.$$.fragment,l),J(F.$$.fragment,l),J(K.$$.fragment,l),J(ll.$$.fragment,l),J(tl.$$.fragment,l),J(nl.$$.fragment,l),J(il.$$.fragment,l),J(Tl.$$.fragment,l),J(ol.$$.fragment,l),J(wl.$$.fragment,l),pM=!0)},o(l){w(h.$$.fragment,l),w(A.$$.fragment,l),w(f.$$.fragment,l),w(g.$$.fragment,l),w(Q.$$.fragment,l),w(V.$$.fragment,l),w(S.$$.fragment,l),w(H.$$.fragment,l),w(x.$$.fragment,l),w(F.$$.fragment,l),w(K.$$.fragment,l),w(ll.$$.fragment,l),w(tl.$$.fragment,l),w(nl.$$.fragment,l),w(il.$$.fragment,l),w(Tl.$$.fragment,l),w(ol.$$.fragment,l),w(wl.$$.fragment,l),pM=!1},d(l){l&&(s(Il),s(jl),s(cl),s(dl),s(m),s(hl),s(ml),s(u),s(Al),s(ul),s(b),s(fl),s(bl),s(B),s(gl),s(k),s(Bl),s(v),s(kl),s(E),s(vl),s(_),s(El),s(_l),s(Z),s(Ql),s(R),s(Zl),s(Rl),s(N),s(Vl),s(G),s(Nl),s(Gl),s(W),s(Sl),s(z),s(Wl),s(zl),s(p),s(Hl),s(xl),s(X),s(Xl),s(Y),s(Yl),s(q),s(ql),s(I),s(Fl),s($l),s($),s(Ll),s(L),s(Dl),s(D),s(Kl),s(c),s(Pl),s(Ol),s(P),s(lM),s(O),s(MM),s(d),s(sM),s(eM),s(Ml),s(tM),s(sl),s(aM),s(el),s(nM),s(yM),s(al),s(iM),s(UM),s(yl),s(TM),s(oM),s(Ul),s(JM),s(wM),s(CM),s(Jl),s(rM),s(jM),s(pl)),s(j),C(h,l),C(A,l),C(f,l),C(g,l),C(Q,l),C(V,l),C(S,l),C(H,l),C(x,l),C(F,l),C(K,l),C(ll,l),C(tl,l),C(nl,l),C(il,l),C(Tl,l),C(ol,l),C(wl,l)}}}const is='{"title":"Convolutional Vision Transformer (CvT)","local":"convolutional-vision-transformer-cvt","sections":[{"title":"Recap","local":"recap","sections":[],"depth":2},{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Architecture","local":"architecture","sections":[{"title":"Comparision of CvT Architecture with other Vision Transformers","local":"comparision-of-cvt-architecture-with-other-vision-transformers","sections":[],"depth":3},{"title":"Main Highlights","local":"main-highlights","sections":[],"depth":3}],"depth":2},{"title":"PyTorch Implementation","local":"pytorch-implementation","sections":[],"depth":2},{"title":"Try it out","local":"try-it-out","sections":[{"title":"Usage","local":"usage","sections":[],"depth":3}],"depth":2},{"title":"References","local":"references","sections":[],"depth":2}],"depth":1}';function Us(IM){return Ms(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Cs extends ss{constructor(j){super(),es(this,j,Us,ys,OM,{})}}export{Cs as component};
