import{s as as,n as ns,o as ps}from"../chunks/scheduler.cd324960.js";import{S as is,i as js,e as n,s as M,c as j,h as ys,a as p,d as t,b as a,f as Ms,g as y,j as i,k as Ql,l as os,m as e,n as o,t as m,o as u,p as c}from"../chunks/index.d5c3adcc.js";import{C as ms,H as us,E as cs}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.87c38818.js";import{C as U}from"../chunks/CodeBlock.2ff0aef1.js";function Us(Wl){let r,O,P,ll,d,sl,T,tl,w,xl="本节中我们将会使用🤗 Datasets来获取音频数据集。🤗 Datasets是一个下载和准备数据集的开源工具，包含了音频在内的各种模态数据。该工具集为Hugging Face Hub上公开的机器学习数据集提供了易用的接口。此外，🤗 Datasets还提供了专门为音频数据集而设的多种特性，帮助研究者和机器学习实践者更轻松地使用这些数据集。",el,h,ql="首先，我们要确认已经安装了🤗 Datasets库：",Ml,A,al,f,Rl="🤗 Datasets的其中一个重磅功能是可以使用<code>load_dataset()</code>函数达到仅用一行代码下载和准备数据集。",nl,C,Fl='这里我们来加载和探索<a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">MINDS-14</a>这一音频数据集。该数据集的内容是人们向某个网银系统提问的录音，包含了多种语言和方言。',pl,b,Yl="为了加载MINDS-14数据集，我们需要复制该数据集在Hugging Face Hub上的identifier（<code>PolyAI/minds14</code>），并向<code>load_dataset()</code>函数传入该参数。这里我们只选取该数据集的澳大利亚子集（<code>en-AU</code>）的训练分集：",il,I,jl,g,Hl="<strong>输出：</strong>",yl,$,ol,G,Nl="该数据集包含了654个音频文件，每个都有对应的转录文字和其英语翻译，以及一个代表询问人目的的标签。“audio”列则包含了原始的音频数据。我们来仔细看看其中的一个样本：",ml,k,ul,Z,Sl="<strong>输出</strong>",cl,v,Ul,E,zl="你可能注意到了”audio”列包含了好几个特征，它们分别是：",rl,B,Xl="<li><code>path</code>：音频文件的路径（这里为<code>*.wav</code>）。</li> <li><code>array</code>：解码后的音频文件，以1维NumPy数组表示。</li> <li><code>sampling_rate</code>：音频文件的采样率（该样本为8000赫兹）。</li>",Jl,_,Vl="<code>intent_class</code>则是分类的具体类别。我们可以使用<code>int2str()</code>方法将该数字转换为有意义的字符串：",dl,Q,Tl,W,Ll="<strong>输出：</strong>",wl,x,hl,q,Dl="在该样本的转录文字中，我们可以看到该音频的内容确实是某人在提一个关于账单的问题。",Al,R,Pl="如果你只是想用该子集训练一个音频分类器，你可能不需要使用所有的特征。举个例子，<code>lang_id</code>标签在该子集中全部为同样的值；<code>english_transcription</code>标签和<code>transcription</code>几乎完全含有相同的内容，因此我们也可以舍弃该标签。",fl,F,Kl="你可以使用🤗 Datasets的<code>remove_columns()</code>方法轻松地移除所有不相关的标签：",Cl,Y,bl,H,Ol="<strong>输出：</strong>",Il,N,gl,S,ls="现在我们已经加载并检验了数据集的原始内容，让我们来听几个例子吧！我们可以使用<code>Gradio</code>中的<code>Blocks</code>功能和<code>Audio</code>功能从数据集中解码几个样本：",$l,z,Gl,X,ss="你也可以可视化你想要的样本。这里我们试着绘制第一个样本的波形图：",kl,V,Zl,J,ts='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/waveform_unit1.png" alt="Waveform plot"/>',vl,L,es='动手试试吧！试着下载MINDS-14数据集中其他语言或方言的子集，聆听并可视化其中的一些样本，感受整个数据集的多样性。你可以在<a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">这里</a>找到语言和方言的全部列表（仅英文）。',El,D,Bl,K,_l;return d=new ms({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),T=new us({props:{title:"加载音频数据集",local:"加载音频数据集",headingTag:"h1"}}),A=new U({props:{code:"cGlwJTIwaW5zdGFsbCUyMGRhdGFzZXRzJTVCYXVkaW8lNUQ=",highlighted:"pip install datasets[audio]",wrap:!1}}),I=new U({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBbWluZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyUG9seUFJJTJGbWluZHMxNCUyMiUyQyUyMG5hbWUlM0QlMjJlbi1BVSUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBbWluZHM=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

minds = load_dataset(<span class="hljs-string">&quot;PolyAI/minds14&quot;</span>, name=<span class="hljs-string">&quot;en-AU&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
minds`,wrap:!1}}),$=new U({props:{code:"RGF0YXNldCglMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbmdsaXNoX3RyYW5zY3JpcHRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJpbnRlbnRfY2xhc3MlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsYW5nX2lkJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX3Jvd3MlM0ElMjA2NTQlMkMlMEElMjAlMjAlMjAlMjAlN0QlMEEp",highlighted:`Dataset(
    <span class="hljs-punctuation">{</span>
<span class="hljs-symbol">        features:</span> [
            <span class="hljs-string">&quot;path&quot;</span>,
            <span class="hljs-string">&quot;audio&quot;</span>,
            <span class="hljs-string">&quot;transcription&quot;</span>,
            <span class="hljs-string">&quot;english_transcription&quot;</span>,
            <span class="hljs-string">&quot;intent_class&quot;</span>,
            <span class="hljs-string">&quot;lang_id&quot;</span>,
        ],
<span class="hljs-symbol">        num_rows:</span> <span class="hljs-number">654</span>,
    <span class="hljs-punctuation">}</span>
)`,wrap:!1}}),k=new U({props:{code:"ZXhhbXBsZSUyMCUzRCUyMG1pbmRzJTVCMCU1RCUwQWV4YW1wbGU=",highlighted:`example = minds[<span class="hljs-number">0</span>]
example`,wrap:!1}}),v=new U({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIycGF0aCUyMiUzQSUyMCUyMiUyRnJvb3QlMkYuY2FjaGUlMkZodWdnaW5nZmFjZSUyRmRhdGFzZXRzJTJGZG93bmxvYWRzJTJGZXh0cmFjdGVkJTJGZjE0OTQ4ZTBlODRiZTYzOGRkNzk0M2FjMzY1MThhNGNmMzMyNGU4YjdhYTMzMWM1YWIxMTU0MTUxOGU5MzY4YyUyRmVuLUFVflBBWV9CSUxMJTJGcmVzcG9uc2VfNC53YXYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlM0ElMjAlMjIlMkZyb290JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZkYXRhc2V0cyUyRmRvd25sb2FkcyUyRmV4dHJhY3RlZCUyRmYxNDk0OGUwZTg0YmU2MzhkZDc5NDNhYzM2NTE4YTRjZjMzMjRlOGI3YWEzMzFjNWFiMTE1NDE1MThlOTM2OGMlMkZlbi1BVX5QQVlfQklMTCUyRnJlc3BvbnNlXzQud2F2JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXJyYXklMjIlM0ElMjBhcnJheSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIwLjAlMkMlMjAwLjAwMDI0NDE0JTJDJTIwLTAuMDAwMjQ0MTQlMkMlMjAuLi4lMkMlMjAtMC4wMDAyNDQxNCUyQyUyMDAuMDAwMjQ0MTQlMkMlMjAwLjAwMTIyMDclNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkdHlwZSUzRGZsb2F0MzIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2FtcGxpbmdfcmF0ZSUyMiUzQSUyMDgwMDAlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2NyaXB0aW9uJTIyJTNBJTIwJTIySSUyMHdvdWxkJTIwbGlrZSUyMHRvJTIwcGF5JTIwbXklMjBlbGVjdHJpY2l0eSUyMGJpbGwlMjB1c2luZyUyMG15JTIwY2FyZCUyMGNhbiUyMHlvdSUyMHBsZWFzZSUyMGFzc2lzdCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmVuZ2xpc2hfdHJhbnNjcmlwdGlvbiUyMiUzQSUyMCUyMkklMjB3b3VsZCUyMGxpa2UlMjB0byUyMHBheSUyMG15JTIwZWxlY3RyaWNpdHklMjBiaWxsJTIwdXNpbmclMjBteSUyMGNhcmQlMjBjYW4lMjB5b3UlMjBwbGVhc2UlMjBhc3Npc3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJpbnRlbnRfY2xhc3MlMjIlM0ElMjAxMyUyQyUwQSUyMCUyMCUyMCUyMCUyMmxhbmdfaWQlMjIlM0ElMjAyJTJDJTBBJTdE",highlighted:`{
    <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
    <span class="hljs-comment">&quot;audio&quot;</span>: {
        <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
        <span class="hljs-comment">&quot;array&quot;</span>: array(
            [<span class="hljs-number">0.0</span>, <span class="hljs-number">0.00024414</span>, <span class="hljs-number">-0.00024414</span>, ..., <span class="hljs-number">-0.00024414</span>, <span class="hljs-number">0.00024414</span>, <span class="hljs-number">0.0012207</span>],
            dtype=float32,
        ),
        <span class="hljs-comment">&quot;sampling_rate&quot;</span>: <span class="hljs-number">8000</span>,
    },
    <span class="hljs-comment">&quot;transcription&quot;</span>: <span class="hljs-comment">&quot;I would like to pay my electricity bill using my card can you please assist&quot;</span>,
    <span class="hljs-comment">&quot;english_transcription&quot;</span>: <span class="hljs-comment">&quot;I would like to pay my electricity bill using my card can you please assist&quot;</span>,
    <span class="hljs-comment">&quot;intent_class&quot;</span>: <span class="hljs-number">13</span>,
    <span class="hljs-comment">&quot;lang_id&quot;</span>: <span class="hljs-number">2</span>,
}`,wrap:!1}}),Q=new U({props:{code:"aWQybGFiZWwlMjAlM0QlMjBtaW5kcy5mZWF0dXJlcyU1QiUyMmludGVudF9jbGFzcyUyMiU1RC5pbnQyc3RyJTBBaWQybGFiZWwoZXhhbXBsZSU1QiUyMmludGVudF9jbGFzcyUyMiU1RCk=",highlighted:`id2label = minds.features[<span class="hljs-string">&quot;intent_class&quot;</span>].int2str
id2label(example[<span class="hljs-string">&quot;intent_class&quot;</span>])`,wrap:!1}}),x=new U({props:{code:"JTIycGF5X2JpbGwlMjI=",highlighted:'<span class="hljs-string">&quot;pay_bill&quot;</span>',wrap:!1}}),Y=new U({props:{code:"Y29sdW1uc190b19yZW1vdmUlMjAlM0QlMjAlNUIlMjJsYW5nX2lkJTIyJTJDJTIwJTIyZW5nbGlzaF90cmFuc2NyaXB0aW9uJTIyJTVEJTBBbWluZHMlMjAlM0QlMjBtaW5kcy5yZW1vdmVfY29sdW1ucyhjb2x1bW5zX3RvX3JlbW92ZSklMEFtaW5kcw==",highlighted:`columns_to_remove = [<span class="hljs-string">&quot;lang_id&quot;</span>, <span class="hljs-string">&quot;english_transcription&quot;</span>]
minds = minds.remove_columns(columns_to_remove)
minds`,wrap:!1}}),N=new U({props:{code:"RGF0YXNldCglN0JmZWF0dXJlcyUzQSUyMCU1QiUyMnBhdGglMjIlMkMlMjAlMjJhdWRpbyUyMiUyQyUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMjAlMjJpbnRlbnRfY2xhc3MlMjIlNUQlMkMlMjBudW1fcm93cyUzQSUyMDY1NCU3RCk=",highlighted:'<span class="hljs-constructor">Dataset({<span class="hljs-params">features</span>: [<span class="hljs-string">&quot;path&quot;</span>, <span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;transcription&quot;</span>, <span class="hljs-string">&quot;intent_class&quot;</span>], <span class="hljs-params">num_rows</span>: 654})</span>',wrap:!1}}),z=new U({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQSUwQWRlZiUyMGdlbmVyYXRlX2F1ZGlvKCklM0ElMEElMjAlMjAlMjAlMjBleGFtcGxlJTIwJTNEJTIwbWluZHMuc2h1ZmZsZSgpJTVCMCU1RCUwQSUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwZXhhbXBsZSU1QiUyMmF1ZGlvJTIyJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTVCJTIyc2FtcGxpbmdfcmF0ZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTVCJTIyYXJyYXklMjIlNUQlMkMlMEElMjAlMjAlMjAlMjApJTJDJTIwaWQybGFiZWwoZXhhbXBsZSU1QiUyMmludGVudF9jbGFzcyUyMiU1RCklMEElMEElMEF3aXRoJTIwZ3IuQmxvY2tzKCklMjBhcyUyMGRlbW8lM0ElMEElMjAlMjAlMjAlMjB3aXRoJTIwZ3IuQ29sdW1uKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBfJTIwaW4lMjByYW5nZSg0KSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTJDJTIwbGFiZWwlMjAlM0QlMjBnZW5lcmF0ZV9hdWRpbygpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0JTIwJTNEJTIwZ3IuQXVkaW8oYXVkaW8lMkMlMjBsYWJlbCUzRGxhYmVsKSUwQSUwQWRlbW8ubGF1bmNoKGRlYnVnJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_audio</span>():
    example = minds.shuffle()[<span class="hljs-number">0</span>]
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]
    <span class="hljs-keyword">return</span> (
        audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
        audio[<span class="hljs-string">&quot;array&quot;</span>],
    ), id2label(example[<span class="hljs-string">&quot;intent_class&quot;</span>])


<span class="hljs-keyword">with</span> gr.Blocks() <span class="hljs-keyword">as</span> demo:
    <span class="hljs-keyword">with</span> gr.Column():
        <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">4</span>):
            audio, label = generate_audio()
            output = gr.Audio(audio, label=label)

demo.launch(debug=<span class="hljs-literal">True</span>)`,wrap:!1}}),V=new U({props:{code:"aW1wb3J0JTIwbGlicm9zYSUwQWltcG9ydCUyMG1hdHBsb3RsaWIucHlwbG90JTIwYXMlMjBwbHQlMEFpbXBvcnQlMjBsaWJyb3NhLmRpc3BsYXklMEElMEFhcnJheSUyMCUzRCUyMGV4YW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTBBc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMGV4YW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMEElMEFwbHQuZmlndXJlKCkuc2V0X2ZpZ3dpZHRoKDEyKSUwQWxpYnJvc2EuZGlzcGxheS53YXZlc2hvdyhhcnJheSUyQyUyMHNyJTNEc2FtcGxpbmdfcmF0ZSk=",highlighted:`<span class="hljs-keyword">import</span> librosa
<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-keyword">import</span> librosa.display

array = example[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>]
sampling_rate = example[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>]

plt.figure().set_figwidth(<span class="hljs-number">12</span>)
librosa.display.waveshow(array, sr=sampling_rate)`,wrap:!1}}),D=new cs({props:{source:"https://github.com/huggingface/audio-transformers-course/blob/main/chapters/zh-CN/chapter1/load_and_explore.mdx"}}),{c(){r=n("meta"),O=M(),P=n("p"),ll=M(),j(d.$$.fragment),sl=M(),j(T.$$.fragment),tl=M(),w=n("p"),w.textContent=xl,el=M(),h=n("p"),h.textContent=ql,Ml=M(),j(A.$$.fragment),al=M(),f=n("p"),f.innerHTML=Rl,nl=M(),C=n("p"),C.innerHTML=Fl,pl=M(),b=n("p"),b.innerHTML=Yl,il=M(),j(I.$$.fragment),jl=M(),g=n("p"),g.innerHTML=Hl,yl=M(),j($.$$.fragment),ol=M(),G=n("p"),G.textContent=Nl,ml=M(),j(k.$$.fragment),ul=M(),Z=n("p"),Z.innerHTML=Sl,cl=M(),j(v.$$.fragment),Ul=M(),E=n("p"),E.textContent=zl,rl=M(),B=n("ul"),B.innerHTML=Xl,Jl=M(),_=n("p"),_.innerHTML=Vl,dl=M(),j(Q.$$.fragment),Tl=M(),W=n("p"),W.innerHTML=Ll,wl=M(),j(x.$$.fragment),hl=M(),q=n("p"),q.textContent=Dl,Al=M(),R=n("p"),R.innerHTML=Pl,fl=M(),F=n("p"),F.innerHTML=Kl,Cl=M(),j(Y.$$.fragment),bl=M(),H=n("p"),H.innerHTML=Ol,Il=M(),j(N.$$.fragment),gl=M(),S=n("p"),S.innerHTML=ls,$l=M(),j(z.$$.fragment),Gl=M(),X=n("p"),X.textContent=ss,kl=M(),j(V.$$.fragment),Zl=M(),J=n("div"),J.innerHTML=ts,vl=M(),L=n("p"),L.innerHTML=es,El=M(),j(D.$$.fragment),Bl=M(),K=n("p"),this.h()},l(l){const s=ys("svelte-u9bgzb",document.head);r=p(s,"META",{name:!0,content:!0}),s.forEach(t),O=a(l),P=p(l,"P",{}),Ms(P).forEach(t),ll=a(l),y(d.$$.fragment,l),sl=a(l),y(T.$$.fragment,l),tl=a(l),w=p(l,"P",{"data-svelte-h":!0}),i(w)!=="svelte-1y8bvn2"&&(w.textContent=xl),el=a(l),h=p(l,"P",{"data-svelte-h":!0}),i(h)!=="svelte-1h89fri"&&(h.textContent=ql),Ml=a(l),y(A.$$.fragment,l),al=a(l),f=p(l,"P",{"data-svelte-h":!0}),i(f)!=="svelte-g669h9"&&(f.innerHTML=Rl),nl=a(l),C=p(l,"P",{"data-svelte-h":!0}),i(C)!=="svelte-rjua1f"&&(C.innerHTML=Fl),pl=a(l),b=p(l,"P",{"data-svelte-h":!0}),i(b)!=="svelte-1ojkc6z"&&(b.innerHTML=Yl),il=a(l),y(I.$$.fragment,l),jl=a(l),g=p(l,"P",{"data-svelte-h":!0}),i(g)!=="svelte-1yevus4"&&(g.innerHTML=Hl),yl=a(l),y($.$$.fragment,l),ol=a(l),G=p(l,"P",{"data-svelte-h":!0}),i(G)!=="svelte-1rccdlg"&&(G.textContent=Nl),ml=a(l),y(k.$$.fragment,l),ul=a(l),Z=p(l,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-1n6w44y"&&(Z.innerHTML=Sl),cl=a(l),y(v.$$.fragment,l),Ul=a(l),E=p(l,"P",{"data-svelte-h":!0}),i(E)!=="svelte-c9o52i"&&(E.textContent=zl),rl=a(l),B=p(l,"UL",{"data-svelte-h":!0}),i(B)!=="svelte-8f05cg"&&(B.innerHTML=Xl),Jl=a(l),_=p(l,"P",{"data-svelte-h":!0}),i(_)!=="svelte-utbio1"&&(_.innerHTML=Vl),dl=a(l),y(Q.$$.fragment,l),Tl=a(l),W=p(l,"P",{"data-svelte-h":!0}),i(W)!=="svelte-1yevus4"&&(W.innerHTML=Ll),wl=a(l),y(x.$$.fragment,l),hl=a(l),q=p(l,"P",{"data-svelte-h":!0}),i(q)!=="svelte-13mvlt6"&&(q.textContent=Dl),Al=a(l),R=p(l,"P",{"data-svelte-h":!0}),i(R)!=="svelte-1wbwj7h"&&(R.innerHTML=Pl),fl=a(l),F=p(l,"P",{"data-svelte-h":!0}),i(F)!=="svelte-g2lrqn"&&(F.innerHTML=Kl),Cl=a(l),y(Y.$$.fragment,l),bl=a(l),H=p(l,"P",{"data-svelte-h":!0}),i(H)!=="svelte-1yevus4"&&(H.innerHTML=Ol),Il=a(l),y(N.$$.fragment,l),gl=a(l),S=p(l,"P",{"data-svelte-h":!0}),i(S)!=="svelte-1o3kj99"&&(S.innerHTML=ls),$l=a(l),y(z.$$.fragment,l),Gl=a(l),X=p(l,"P",{"data-svelte-h":!0}),i(X)!=="svelte-13xtlhz"&&(X.textContent=ss),kl=a(l),y(V.$$.fragment,l),Zl=a(l),J=p(l,"DIV",{class:!0,"data-svelte-h":!0}),i(J)!=="svelte-1ym6zda"&&(J.innerHTML=ts),vl=a(l),L=p(l,"P",{"data-svelte-h":!0}),i(L)!=="svelte-s7mtwg"&&(L.innerHTML=es),El=a(l),y(D.$$.fragment,l),Bl=a(l),K=p(l,"P",{}),Ms(K).forEach(t),this.h()},h(){Ql(r,"name","hf:doc:metadata"),Ql(r,"content",rs),Ql(J,"class","flex justify-center")},m(l,s){os(document.head,r),e(l,O,s),e(l,P,s),e(l,ll,s),o(d,l,s),e(l,sl,s),o(T,l,s),e(l,tl,s),e(l,w,s),e(l,el,s),e(l,h,s),e(l,Ml,s),o(A,l,s),e(l,al,s),e(l,f,s),e(l,nl,s),e(l,C,s),e(l,pl,s),e(l,b,s),e(l,il,s),o(I,l,s),e(l,jl,s),e(l,g,s),e(l,yl,s),o($,l,s),e(l,ol,s),e(l,G,s),e(l,ml,s),o(k,l,s),e(l,ul,s),e(l,Z,s),e(l,cl,s),o(v,l,s),e(l,Ul,s),e(l,E,s),e(l,rl,s),e(l,B,s),e(l,Jl,s),e(l,_,s),e(l,dl,s),o(Q,l,s),e(l,Tl,s),e(l,W,s),e(l,wl,s),o(x,l,s),e(l,hl,s),e(l,q,s),e(l,Al,s),e(l,R,s),e(l,fl,s),e(l,F,s),e(l,Cl,s),o(Y,l,s),e(l,bl,s),e(l,H,s),e(l,Il,s),o(N,l,s),e(l,gl,s),e(l,S,s),e(l,$l,s),o(z,l,s),e(l,Gl,s),e(l,X,s),e(l,kl,s),o(V,l,s),e(l,Zl,s),e(l,J,s),e(l,vl,s),e(l,L,s),e(l,El,s),o(D,l,s),e(l,Bl,s),e(l,K,s),_l=!0},p:ns,i(l){_l||(m(d.$$.fragment,l),m(T.$$.fragment,l),m(A.$$.fragment,l),m(I.$$.fragment,l),m($.$$.fragment,l),m(k.$$.fragment,l),m(v.$$.fragment,l),m(Q.$$.fragment,l),m(x.$$.fragment,l),m(Y.$$.fragment,l),m(N.$$.fragment,l),m(z.$$.fragment,l),m(V.$$.fragment,l),m(D.$$.fragment,l),_l=!0)},o(l){u(d.$$.fragment,l),u(T.$$.fragment,l),u(A.$$.fragment,l),u(I.$$.fragment,l),u($.$$.fragment,l),u(k.$$.fragment,l),u(v.$$.fragment,l),u(Q.$$.fragment,l),u(x.$$.fragment,l),u(Y.$$.fragment,l),u(N.$$.fragment,l),u(z.$$.fragment,l),u(V.$$.fragment,l),u(D.$$.fragment,l),_l=!1},d(l){l&&(t(O),t(P),t(ll),t(sl),t(tl),t(w),t(el),t(h),t(Ml),t(al),t(f),t(nl),t(C),t(pl),t(b),t(il),t(jl),t(g),t(yl),t(ol),t(G),t(ml),t(ul),t(Z),t(cl),t(Ul),t(E),t(rl),t(B),t(Jl),t(_),t(dl),t(Tl),t(W),t(wl),t(hl),t(q),t(Al),t(R),t(fl),t(F),t(Cl),t(bl),t(H),t(Il),t(gl),t(S),t($l),t(Gl),t(X),t(kl),t(Zl),t(J),t(vl),t(L),t(El),t(Bl),t(K)),t(r),c(d,l),c(T,l),c(A,l),c(I,l),c($,l),c(k,l),c(v,l),c(Q,l),c(x,l),c(Y,l),c(N,l),c(z,l),c(V,l),c(D,l)}}}const rs='{"title":"加载音频数据集","local":"加载音频数据集","sections":[],"depth":1}';function Js(Wl){return ps(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class As extends is{constructor(r){super(),js(this,r,Js,Us,as,{})}}export{As as component};
