import{s as Va,n as ka,o as va}from"../chunks/scheduler.cd324960.js";import{S as Ga,i as xa,e as p,s as a,c as y,q as I,H as yt,h as $a,a as M,d as s,b as n,f as ht,g as T,j as i,r as b,u as Tt,k as Ue,l as c,m as t,n as U,t as r,o as m,p as o}from"../chunks/index.d5c3adcc.js";import{C as ga,H as re,E as Fa}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.87c38818.js";import{C as h}from"../chunks/CodeBlock.2ff0aef1.js";function Ha(wt){let j,me,ye,oe,f,he,C,we,S,Jt=`在本节中，我们将介绍如何使用 <code>pipeline()</code> 来使用预训练的语音识别模型。
在<a href="../chapter2/asr_pipeline">第 2 单元</a>中，我们介绍了 <code>pipeline()</code> 这种执行语音识别任务的简便方法，
所有的预处理和后处理都在幕后进行，而且它还可以灵活地快速实验 Hugging Face Hub 上的任何预训练检查点。
在本单元中，我们将更深入地探索语音识别模型的不同属性，以及利用它们来处理不同的任务的方法。`,Je,R,ct="如第 3 单元详细介绍的那样，语音识别模型大致分为两类：",ce,B,jt="<li>连接时序分类（Connectionist Temporal Classification, CTC）：仅编码器（encoder-only）的模型，顶部带有线性分类（CTC）头</li> <li>序列到序列（Sequence-to-sequence, Seq2Seq）：编码器-解码器（encoder-decoder）模型，编码器和解码器之间带有交叉注意力机制</li>",je,E,dt=`在 2022 年之前，CTC 是这两种架构中更受欢迎的一种，以 encoder-only 模型为主，例如 Wav2Vec2、HuBERT 和 XLSR 在语音的预训练/微调范式中取得了突破。
大公司如 Meta 和 Microsoft 在大量无标签音频数据上对编码器进行了多天甚至数周的预训练。
用户采用一个预训练的检查点，并在少至 <strong>10 分钟</strong> 的有标注的语音数据上进行微调，就可以在下游语音识别任务中取得强大的性能。`,de,V,ut="然而，CTC 模型也有其缺点。在编码器上附加一个简单的线性层可以得到一个小巧、快速的完整模型，但可能容易出现语音拼写错误。我们将用 Wav2Vec2 模型演示这一点。",ue,k,Ie,v,It='让我们加载 <a href="hf-internal-testing/librispeech_asr_dummy">LibriSpeech ASR</a> 数据集的一小部分，以展示 Wav2Vec2 的语音转写能力：',be,G,fe,x,bt="<strong>输出：</strong>",Ce,$,Se,g,ft="我们可以选择 73 个音频样本中的一个，检查音频样本及其转写：",Re,F,Be,H,Ct="<strong>输出：</strong>",Ee,W,Ve,N,St=`好的！圣诞节和烤牛肉，听起来很棒！🎄 选择了一个数据样本后，我们现在将一个微调过的检查点加载到 <code>pipeline()</code> 中。
为此，我们将使用官方在 100 小时 LibriSpeech 数据上微调的 <a href="facebook/wav2vec2-base-100h">Wav2Vec2 base</a> 检查点：`,ke,Z,ve,Y,Rt=`接下来，我们将从数据集中取一个示例，并将其数据传递给 pipeline。由于 <code>pipeline</code> 会 <em>消耗</em> 我们传入的字典（意味着它无法被多次读取），
我们将传递数据的副本。这样，我们可以安全地在以下示例中重复使用同一个音频样本：`,Ge,Q,xe,_,Bt="<strong>输出：</strong>",$e,L,ge,z,Et="我们可以看到 Wav2Vec2 模型在转写这个样本方面做得相当好——乍一看似乎是正确的。我们将目标和预测放在一起，突出两者的区别：",Fe,A,He,X,Vt="将目标文本与预测出的转写进行比较，我们可以看到所有单词 <em>听起来</em> 都是正确的，但有些拼写不准确。例如：",We,q,kt="<li><em>CHRISTMAUS</em> vs. <em>CHRISTMAS</em></li> <li><em>ROSE</em> vs. <em>ROAST</em></li> <li><em>SIMALYIS</em> vs. <em>SIMILES</em></li>",Ne,O,vt="这突显出了 CTC 模型的缺点。CTC 模型本质上是一个“仅声学”的模型：它由一个编码器组成，该编码器通过输入的音频计算出隐藏状态，并且由一个线性层将隐藏状态映射到字符：",Ze,P,Gt=`这意味着该系统几乎完全基于它的声学输入（音频中的语音部分）进行预测，因此倾向于以表音的方式进行转写（例如 <em>CHRISTMAUS</em>）。
它对上下文的语言建模重视程度较低，因此容易出现语音拼写错误。一个更智能的模型应该发现 <em>CHRISTMAUS</em> 不是英语中的有效单词，并在进行预测时将其纠正为 <em>CHRISTMAS</em>。
我们的预测还缺少两个重要特征——大小写和标点符号。这限制了该模型的转写的现实应用。`,Ye,D,Qe,K,xt=`Seq2Seq 模型来了！正如第 3 单元所概述的，Seq2Seq 模型由编码器和解码器通过交叉注意力机制相连构成。
编码器的作用与以前相同，负责计算音频输入的隐藏状态表示，而解码器的作用则是 <strong>语言模型</strong>。
解码器处理编码器计算出的整个隐藏状态表示序列，并生成相应的文本转写。它会通过语言建模，在推理时通过输入音频的全局上下文实时纠正拼写错误，避免语音预测的问题。`,_e,ll,$t="Seq2Seq 模型有两个缺点：",Le,el,gt="<li>解码较慢，因为解码过程是逐步进行的，而不是一次性完成的</li> <li>需要更多的训练数据才能收敛</li>",ze,sl,Ft=`实际上，大量的训练数据一直是语音领域 Seq2Seq 架构进步的瓶颈。带标注的语音数据很难找到，目前最大的带标注的数据集仅有 10,000 小时。
这一切都在 2022 年 <strong>Whisper</strong> 发布时发生了改变。Whisper 是由 OpenAI 的 Alec Radford 等作者在 <a href="https://openai.com/blog/whisper/" rel="nofollow">2022 年 9 月</a> 发布的用于语音识别的预训练模型。
与之前完全在 <strong>无标注</strong> 音频数据上预训练的 CTC 前辈不同，Whisper 是在大量 <strong>有标注</strong> 的音频-转写数据上预训练的，整整有 680,000 小时。`,Ae,tl,Ht=`这是比用于训练 Wav2Vec 2.0 的无标签音频数据（60,000 小时）多一个数量级的数据。更重要的是，这些预训练数据中有 117,000 小时是多语言（或“非英语”）数据。
这导致了预训练出的检查点可以应用于 96 种以上语言，其中包括许多 <em>低资源</em> 的语言，即这些语言缺乏适合训练的大型数据集。`,Xe,al,Wt=`当扩展到 680,000 小时有标注的预训练数据时，Whisper 模型显示出强大的泛化能力，适用于许多数据集和领域。
预训练检查点取得了能与最先进的语音识别系统相媲美的结果，在 LibriSpeech 的 test-clean 子集上实现了接近 3% 的词错误率（WER），
并在 TED-LIUM 上创造了新的最佳记录，WER 为 4.7%（参考 <a href="https://cdn.openai.com/papers/whisper.pdf" rel="nofollow">Whisper 论文</a> 中的表 8）。`,qe,nl,Nt="最重要的是 Whisper 能处理长音频样本、对输入噪声有鲁棒性，且能预测带大小写和标点符号的转写。这使其成为实际应用中可选的语音识别系统之一。",Oe,pl,Zt=`本节的剩余部分将向您展示如何使用 🤗 Transformers 中的预训练 Whisper 模型进行语音识别。
在许多情况下，预训练的 Whisper 检查点表现出色，我们建议在解决任何语音识别问题时第一步先考虑用它。
通过微调，预训练检查点可以针对特定数据集和语言进行调整，以进一步优化效果，我们将在接下来的 <a href="fine-tuning">微调</a> 小节中演示如何做到这一点。`,Pe,Ml,Yt=`Whisper 检查点有五种配置，每种配置的模型大小不同。最小的四个分别在仅英语和多语言数据集上训练，而最大的检查点仅有多语言。
一共九个预训练检查点都可以在 <a href="https://huggingface.co/models?search=openai/whisper" rel="nofollow">Hugging Face Hub</a> 上找到。
以下表格总结了这些检查点，并附有 Hub 上模型的链接。“VRAM”表示以最小批次大小（batch size）为 1 时运行模型所需的 GPU 内存。
“Rel Speed”是与最大型号相比的相对速度。根据这些信息，您可以选择最适合您硬件的检查点。`,De,il,Qt='<thead><tr><th>大小</th> <th>参数量</th> <th>VRAM / GB</th> <th>相对速度</th> <th>仅英语</th> <th>多语言</th></tr></thead> <tbody><tr><td>tiny</td> <td>39 M</td> <td>1.4</td> <td>32</td> <td><a href="https://huggingface.co/openai/whisper-tiny.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-tiny" rel="nofollow">✓</a></td></tr> <tr><td>base</td> <td>74 M</td> <td>1.5</td> <td>16</td> <td><a href="https://huggingface.co/openai/whisper-base.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-base" rel="nofollow">✓</a></td></tr> <tr><td>small</td> <td>244 M</td> <td>2.3</td> <td>6</td> <td><a href="https://huggingface.co/openai/whisper-small.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-small" rel="nofollow">✓</a></td></tr> <tr><td>mdeium</td> <td>769 M</td> <td>4.2</td> <td>2</td> <td><a href="https://huggingface.co/openai/whisper-medium.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-medium" rel="nofollow">✓</a></td></tr> <tr><td>large</td> <td>1550 M</td> <td>7.5</td> <td>1</td> <td>x</td> <td><a href="https://huggingface.co/openai/whisper-large-v2" rel="nofollow">✓</a></td></tr></tbody>',Ke,yl,_t=`让我们加载 <a href="https://huggingface.co/openai/whisper-base" rel="nofollow">Whisper Base</a> 检查点，它的大小与我们之前使用的 Wav2Vec2 检查点相当。
考虑到我们接下来会做多语言语音识别，我们将加载基础检查点的多语言变体。我们还将模型加载到 GPU（如果有）或 CPU 上，如有必要的话 <code>pipeline()</code> 随后会负责将所有输入/输出从 CPU 移动到 GPU：`,ls,Tl,es,Ul,Lt="好！现在让我们像之前一样转写音频。我们唯一改变的是传递一个额外的参数 <code>max_new_tokens</code>，它告诉模型在进行预测时生成的最大词元数：",ss,rl,ts,ml,zt="<strong>输出：</strong>",as,ol,ns,hl,At="轻松搞定！您首先注意到的是大小写和标点符号，这显然比 Wav2Vec2 不区分大小写也不含标点的转写更易读。让我们对比一下转写与目标输出：",ps,wl,Ms,Jl,Xt=`Whisper 很好地纠正了我们在 Wav2Vec2 那里看到的语音错误—— <em>Christmas</em> 和 <em>roast</em> 都拼写正确。我们看到模型在转写 <em>SIMILES</em> 时出了错，
误写为 <em>similarly</em>，但这次预测是英语中的有效单词。使用更大的 Whisper 检查点可以帮助进一步减少转写错误，但代价是需要更多的计算和更长的转写时间。`,is,cl,qt=`该模型应当有能力处理 96 种语言，所以现在让我们暂时离开英语语音识别，走向全球 🌎！
<a href="https://huggingface.co/datasets/facebook/multilingual_librispeech" rel="nofollow">Multilingual LibriSpeech</a> (MLS) 数据集是 LibriSpeech 数据集的多语言版本，
包含六种语言的带标注音频数据。我们将从 MLS 数据集的西班牙语子集中加载一个样本，使用 <em>流式</em>（streaming）模式，这样我们就不必下载整个数据集：`,ys,jl,Ts,dl,Ot="我们再次检查文本转写并试听音频片段：",Us,ul,rs,Il,Pt="<strong>输出：</strong>",ms,bl,os,fl,Dt=`这是我们希望通过 Whisper 转写出的目标文本，虽然我们现在知道我们预测的结果可能会比这更好，因为我们的模型还会预测标点和大小写，而参考中没有这些。
让我们将音频样本输入 pipeline 以获得文本预测。需要注意的是，pipeline 会 <em>消耗</em> 我们输入的音频输入字典，即字典不能被重复读取。
为了解决这个问题，我们将传递一个音频样本的 <em>副本</em>，这样我们就可以在后续代码示例中重复使用同一个音频样本：`,hs,Cl,ws,Sl,Kt="<strong>输出：</strong>",Js,Rl,cs,Bl,la=`太好了——这看起来与我们的参考文本非常相似（可以说更好，因为它有标点和大小写！）。您会注意到，我们以 <em>生成关键字参数</em>（generate kwarg）的形式传递了 <code>&quot;task&quot;</code>。
将 <code>&quot;task&quot;</code> 设置为 <code>&quot;transcribe&quot;</code> 会迫使 Whisper 执行 <em>语音识别</em> 任务，即转写的语言就是音频中使用的语音。
Whisper 还能够执行与之密切相关的 <em>语音翻译</em> 任务，西班牙语音频可以被翻译成英语文本。要实现这一点，我们将 <code>&quot;task&quot;</code> 设置为 <code>&quot;translate&quot;</code>：`,js,El,ds,Vl,ea="<strong>输出：</strong>",us,kl,Is,vl,sa=`现在我们知道可以在语音识别和语音翻译之间切换，我们可以根据需要选择任务。
要么我们从 X 语言的音频识别到同一语言 X 的文本（例如，西班牙语音频到西班牙语文本），要么我们从任何语言 X 的音频翻译到英文文本（例如，西班牙语音频到英文文本）。`,bs,Gl,ta='要了解更多关于如何使用 <code>&quot;task&quot;</code> 参数来控制生成文本的属性，请参阅 Whisper base 的 <a href="https://huggingface.co/openai/whisper-base#usage" rel="nofollow">模型卡片</a>。',fs,xl,Cs,$l,aa="到目前为止，我们一直专注于转写不到 30 秒的短音频样本。但我们也提到过 Whisper 的一个优势是可以处理长音频样本，我们将在这里处理这个任务！",Ss,gl,na=`让我们通过拼接 MLS 数据集中连续几条样本来创建一个长音频文件。因为 MLS 数据集是通过将长有声读物录音分割成较短片段来整理的，
所以拼接样本是重构较长有声读物段落的一种方法，拼接出的音频在各个样本间应该是连贯的。`,Rs,Fl,pa="我们将目标音频长度设为 5 分钟，并在达到这个值时停止拼接样本：",Bs,Hl,Es,Wl,Ma="<strong>输出：</strong>",Vs,Nl,ks,Zl,ia="好的！有 5 分钟 17 秒的音频要转写。直接将这个长音频样本输入给模型有两个问题：",vs,Yl,ya="<li>Whisper 被设计用于处理 30 秒的样本：少于 30 秒的任何内容都会用静音填充至 30 秒，超过 30 秒的任何内容都会通过切掉多余音频缩短至 30 秒，所以如果我们直接输入我们的音频，我们只会得到前 30 秒的转写</li> <li>Transformer 网络中的内存随序列长度平方增长：输入长度加倍会使内存需求增加四倍，所以传递超长音频文件会导致内存不足（out-of-memory, OOM）错误</li>",Gs,Ql,Ta=`在 🤗 Transformers 中进行长篇转写的方式是将输入音频 <em>分块</em>（chunking）为更小、更易管理的段落，每个段落与前一个段落有少量重叠。
这样，我们可以在段落边界处准确地将段落拼接在一起，因为我们可以找到段落之间的重叠并相应地合并转写：`,xs,d,Ua='<img src="https://huggingface.co/blog/assets/49_asr_chunking/Striding.png" alt="🤗 Transformers 分块算法。来源：https://huggingface.co/blog/asr-chunking。"/>',$s,w,Ut,gs,Sa='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi><mo>+</mo><mn>1</mn></mrow><annotation encoding="application/x-tex"> i + 1 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7429em;vertical-align:-0.0833em;"></span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">1</span></span></span></span>',Fs,Hs,Ra='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi></mrow><annotation encoding="application/x-tex"> i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6595em;"></span><span class="mord mathnormal">i</span></span></span></span>',Ws,Me,ra="无状态的",rt,Ns,Ba='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi><mo>+</mo><mn>1</mn></mrow><annotation encoding="application/x-tex"> i + 1 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7429em;vertical-align:-0.0833em;"></span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">1</span></span></span></span>',Zs,Ys,Ea='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi></mrow><annotation encoding="application/x-tex"> i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6595em;"></span><span class="mord mathnormal">i</span></span></span></span>',Qs,ie,ma="批量",mt,u,oa="博客",ot,_s,_l,ha="要使用长篇转写，我们在调用 pipeline 时需要添加一个额外参数。这个参数，<code>chunk_length_s</code>，控制分块段落的长度（以秒为单位）。对于 Whisper，30 秒的块是最佳的，因为这符合 Whisper 期望的输入长度。",Ls,Ll,wa="要使用批处理，我们需要将 <code>batch_size</code> 参数传递给 pipeline。将所有这些放在一起，我们可以像下面这样转写长音频样本，并进行分块和批处理：",zs,zl,As,Al,Ja="<strong>输出：</strong>",Xs,Xl,qs,ql,ca="由于输出相当长（总共 312 个词），我们在这里不会打印整个输出！在 16GB V100 GPU 上，预计上面的代码要运行 3.45 秒，对于 317 秒的音频样本来说相当不错。在 CPU 上，预期大约要跑 30 秒。",Os,Ol,ja=`Whisper 还能够预测音频数据的片段级 <em>时间戳</em>。这些时间戳指示音频的短片段的开始和结束时间，对于将转写与输入音频对齐特别有用。
比方说我们想为视频提供字幕（closed caption）——我们需要这些时间戳来知道转写的哪一部分对应于视频的某个段落，以便在那个时间显示正确的转写。`,Ps,Pl,da="启用时间戳预测很简单，我们只需设置参数 <code>return_timestamps=True</code>。时间戳与我们之前使用的分块和批处理方法兼容，所以我们可以直接将时间戳参数附加到我们之前的代码上：",Ds,Dl,Ks,Kl,ua="<strong>输出：</strong>",lt,le,et,ee,Ia="瞧！我们有了预测的文本以及相应的时间戳。",st,se,tt,te,ba=`Whisper 是一个强大的用于语音识别和翻译的预训练模型。与 Wav2Vec2 相比，它具有更高的转写准确性，输出包含标点和大小写。
它可用于转写英语和其他 96 种语言的语音，既能处理短音频片段又能通过 <em>分块</em> 处理的较长片段。这些属性使其可以直接用于许多语音识别和翻译任务，无需微调。
<code>pipeline()</code> 方法提供了一种使用一行 API 调用轻松运行推理的方法，还能对生成的预测进行控制。`,at,ae,fa=`尽管 Whisper 模型在许多高资源语言上表现极佳，但它对于低资源语言，即那些缺乏容易获得的训练数据的语言，转写和翻译准确性较低。
在某些语言的不同口音和方言，包括不同性别、种族、年龄或其他人口统计标准的发言者身上的表现也存在差异（参见 <a href="https://arxiv.org/pdf/2212.04356.pdf" rel="nofollow">Whisper 论文</a>）。`,nt,ne,Ca=`为了提高在低资源语言、口音或方言上的性能，我们可以将预训练的 Whisper 模型在一小部分适当选择的数据上继续训练，这个过程称为 <em>微调</em>。
我们将展示如何仅使用十小时的额外数据，就能将 Whisper 模型在低资源语言上的性能提高 100% 以上。在下一节中，我们将介绍选择微调数据集的过程。`,pt,pe,Mt,Te,it;return f=new ga({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),C=new re({props:{title:"语音识别的预训练模型",local:"语音识别的预训练模型",headingTag:"h1"}}),k=new re({props:{title:"探索 CTC 模型",local:"探索-ctc-模型",headingTag:"h2"}}),G=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMEElMjAlMjAlMjAlMjAlMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2R1bW15JTIyJTJDJTIwJTIyY2xlYW4lMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIlMEEpJTBBZGF0YXNldA==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(
    <span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>
)
dataset`,wrap:!1}}),$=new h({props:{code:"RGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QidmaWxlJyUyQyUyMCdhdWRpbyclMkMlMjAndGV4dCclMkMlMjAnc3BlYWtlcl9pZCclMkMlMjAnY2hhcHRlcl9pZCclMkMlMjAnaWQnJTVEJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3Jvd3MlM0ElMjA3MyUwQSU3RCk=",highlighted:`<span class="hljs-title function_ invoke__">Dataset</span>({
    <span class="hljs-attr">features</span>: [<span class="hljs-string">&#x27;file&#x27;</span>, <span class="hljs-string">&#x27;audio&#x27;</span>, <span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;speaker_id&#x27;</span>, <span class="hljs-string">&#x27;chapter_id&#x27;</span>, <span class="hljs-string">&#x27;id&#x27;</span>],
    <span class="hljs-attr">num_rows</span>: <span class="hljs-number">73</span>
})`,wrap:!1}}),F=new h({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBc2FtcGxlJTIwJTNEJTIwZGF0YXNldCU1QjIlNUQlMEElMEFwcmludChzYW1wbGUlNUIlMjJ0ZXh0JTIyJTVEKSUwQUF1ZGlvKHNhbXBsZSU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyYXJyYXklMjIlNUQlMkMlMjByYXRlJTNEc2FtcGxlJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJzYW1wbGluZ19yYXRlJTIyJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio

sample = dataset[<span class="hljs-number">2</span>]

<span class="hljs-built_in">print</span>(sample[<span class="hljs-string">&quot;text&quot;</span>])
Audio(sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], rate=sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>])`,wrap:!1}}),W=new h({props:{code:"SEUlMjBURUxMUyUyMFVTJTIwVEhBVCUyMEFUJTIwVEhJUyUyMEZFU1RJVkUlMjBTRUFTT04lMjBPRiUyMFRIRSUyMFlFQVIlMjBXSVRIJTIwQ0hSSVNUTUFTJTIwQU5EJTIwUk9BU1QlMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwU0lNSUxFUyUyMERSQVdOJTIwRlJPTSUyMEVBVElORyUyMEFORCUyMElUUyUyMFJFU1VMVFMlMjBPQ0NVUiUyME1PU1QlMjBSRUFESUxZJTIwVE8lMjBUSEUlMjBNSU5E",highlighted:'HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAS <span class="hljs-keyword">AND </span>ROAST <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US SIMILES DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND',wrap:!1}}),Z=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMmF1dG9tYXRpYy1zcGVlY2gtcmVjb2duaXRpb24lMjIlMkMlMjBtb2RlbCUzRCUyMmZhY2Vib29rJTJGd2F2MnZlYzItYmFzZS0xMDBoJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;facebook/wav2vec2-base-100h&quot;</span>)`,wrap:!1}}),Q=new h({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RC5jb3B5KCkp",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>].copy())',wrap:!1}}),L=new h({props:{code:"JTdCJTIydGV4dCUyMiUzQSUyMCUyMkhFJTIwVEVMTFMlMjBVUyUyMFRIQVQlMjBBVCUyMFRISVMlMjBGRVNUSVZFJTIwU0VBU09OJTIwT0YlMjBUSEUlMjBZRUFSJTIwV0lUSCUyMENIUklTVE1BVVMlMjBBTkQlMjBST1NFJTIwQkVFRiUyMExPT01JTkclMjBCRUZPUkUlMjBVUyUyMFNJTUFMWUlTJTIwRFJBV04lMjBGUk9NJTIwRUFUSU5HJTIwQU5EJTIwSVRTJTIwUkVTVUxUUyUyME9DQ1VSJTIwTU9TVCUyMFJFQURJTFklMjBUTyUyMFRIRSUyME1JTkQlMjIlN0Q=",highlighted:'<span class="hljs-comment">{&quot;text&quot;: &quot;HE TELLS US THAT AT THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAUS AND ROSE BEEF LOOMING BEFORE US SIMALYIS DRAWN FROM EATING AND ITS RESULTS OCCUR MOST READILY TO THE MIND&quot;}</span>',wrap:!1}}),A=new h({props:{code:"VGFyZ2V0JTNBJTIwJTIwJTIwJTIwJTIwJTIwSEUlMjBURUxMUyUyMFVTJTIwVEhBVCUyMEFUJTIwVEhJUyUyMEZFU1RJVkUlMjBTRUFTT04lMjBPRiUyMFRIRSUyMFlFQVIlMjBXSVRIJTIwQ0hSSVNUTUFTJTIwQU5EJTIwUk9BU1QlMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwU0lNSUxFUyUyMERSQVdOJTIwRlJPTSUyMEVBVElORyUyMEFORCUyMElUUyUyMFJFU1VMVFMlMjBPQ0NVUiUyME1PU1QlMjBSRUFESUxZJTIwVE8lMjBUSEUlMjBNSU5EJTBBUHJlZGljdGlvbiUzQSUyMCUyMEhFJTIwVEVMTFMlMjBVUyUyMFRIQVQlMjBBVCUyMFRISVMlMjBGRVNUSVZFJTIwU0VBU09OJTIwT0YlMjBUSEUlMjBZRUFSJTIwV0lUSCUyMCoqQ0hSSVNUTUFVUyoqJTIwQU5EJTIwKipST1NFKiolMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwKipTSU1BTFlJUyoqJTIwRFJBV04lMjBGUk9NJTIwRUFUSU5HJTIwQU5EJTIwSVRTJTIwUkVTVUxUUyUyME9DQ1VSJTIwTU9TVCUyMFJFQURJTFklMjBUTyUyMFRIRSUyME1JTkQ=",highlighted:`<span class="hljs-symbol">Target:</span>      HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAS <span class="hljs-keyword">AND </span>ROAST <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US SIMILES DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND
<span class="hljs-symbol">Prediction:</span>  HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH **CHRISTMAUS** <span class="hljs-keyword">AND </span>**ROSE** <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US **SIMALYIS** DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND`,wrap:!1}}),D=new re({props:{title:"过渡到 Seq2Seq",local:"过渡到-seq2seq",headingTag:"h2"}}),Tl=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMEElMEFkZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTNBMCUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEFwaXBlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyb3BlbmFpJTJGd2hpc3Blci1iYXNlJTIyJTJDJTIwZGV2aWNlJTNEZGV2aWNlJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

device = <span class="hljs-string">&quot;cuda:0&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
pipe = pipeline(
    <span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;openai/whisper-base&quot;</span>, device=device
)`,wrap:!1}}),rl=new h({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjU2KQ==",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>], max_new_tokens=<span class="hljs-number">256</span>)',wrap:!1}}),ol=new h({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMEhlJTIwdGVsbHMlMjB1cyUyMHRoYXQlMjBhdCUyMHRoaXMlMjBmZXN0aXZlJTIwc2Vhc29uJTIwb2YlMjB0aGUlMjB5ZWFyJTJDJTIwd2l0aCUyMENocmlzdG1hcyUyMGFuZCUyMHJvYXN0JTIwYmVlZiUyMGxvb21pbmclMjBiZWZvcmUlMjB1cyUyQyUyMHNpbWlsYXJseSUyMGlzJTIwZHJhd24lMjBmcm9tJTIwZWF0aW5nJTIwYW5kJTIwaXRzJTIwcmVzdWx0cyUyMG9jY3VyJTIwbW9zdCUyMHJlYWRpbHklMjB0byUyMHRoZSUyMG1pbmQuJyU3RA==",highlighted:'{&#x27;<span class="hljs-built_in">text</span>&#x27;: &#x27; He tells us <span class="hljs-keyword">that</span> <span class="hljs-keyword">at</span> this festive season <span class="hljs-keyword">of</span> <span class="hljs-keyword">the</span> <span class="hljs-built_in">year</span>, <span class="hljs-keyword">with</span> Christmas <span class="hljs-keyword">and</span> roast beef looming <span class="hljs-keyword">before</span> us, similarly <span class="hljs-keyword">is</span> drawn <span class="hljs-keyword">from</span> eating <span class="hljs-keyword">and</span> <span class="hljs-keyword">its</span> results occur most readily <span class="hljs-keyword">to</span> <span class="hljs-keyword">the</span> mind.&#x27;}',wrap:!1}}),wl=new h({props:{code:"VGFyZ2V0JTNBJTIwJTIwJTIwJTIwJTIwSEUlMjBURUxMUyUyMFVTJTIwVEhBVCUyMEFUJTIwVEhJUyUyMEZFU1RJVkUlMjBTRUFTT04lMjBPRiUyMFRIRSUyMFlFQVIlMjBXSVRIJTIwQ0hSSVNUTUFTJTIwQU5EJTIwUk9BU1QlMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwU0lNSUxFUyUyMERSQVdOJTIwRlJPTSUyMEVBVElORyUyMEFORCUyMElUUyUyMFJFU1VMVFMlMjBPQ0NVUiUyME1PU1QlMjBSRUFESUxZJTIwVE8lMjBUSEUlMjBNSU5EJTBBUHJlZGljdGlvbiUzQSUyMEhlJTIwdGVsbHMlMjB1cyUyMHRoYXQlMjBhdCUyMHRoaXMlMjBmZXN0aXZlJTIwc2Vhc29uJTIwb2YlMjB0aGUlMjB5ZWFyJTJDJTIwd2l0aCUyMCoqQ2hyaXN0bWFzKiolMjBhbmQlMjAqKnJvYXN0KiolMjBiZWVmJTIwbG9vbWluZyUyMGJlZm9yZSUyMHVzJTJDJTIwKipzaW1pbGFybHkqKiUyMGlzJTIwZHJhd24lMjBmcm9tJTIwZWF0aW5nJTIwYW5kJTIwaXRzJTIwcmVzdWx0cyUyMG9jY3VyJTIwbW9zdCUyMHJlYWRpbHklMjB0byUyMHRoZSUyMG1pbmQu",highlighted:`<span class="hljs-symbol">Target:</span>     HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAS <span class="hljs-keyword">AND </span>ROAST <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US SIMILES DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND
<span class="hljs-symbol">Prediction:</span> He tells us that <span class="hljs-built_in">at</span> this festive season of the year, with **Christmas** <span class="hljs-keyword">and </span>**roast** <span class="hljs-keyword">beef </span>looming <span class="hljs-keyword">before </span>us, **similarly** is drawn from eating <span class="hljs-keyword">and </span>its results occur most readily to the mind.`,wrap:!1}}),jl=new h({props:{code:"ZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMEElMjAlMjAlMjAlMjAlMjJmYWNlYm9vayUyRm11bHRpbGluZ3VhbF9saWJyaXNwZWVjaCUyMiUyQyUyMCUyMnNwYW5pc2glMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIlMkMlMjBzdHJlYW1pbmclM0RUcnVlJTBBKSUwQXNhbXBsZSUyMCUzRCUyMG5leHQoaXRlcihkYXRhc2V0KSk=",highlighted:`dataset = load_dataset(
    <span class="hljs-string">&quot;facebook/multilingual_librispeech&quot;</span>, <span class="hljs-string">&quot;spanish&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>, streaming=<span class="hljs-literal">True</span>
)
sample = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataset))`,wrap:!1}}),ul=new h({props:{code:"cHJpbnQoc2FtcGxlJTVCJTIydGV4dCUyMiU1RCklMEFBdWRpbyhzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwcmF0ZSUzRHNhbXBsZSU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyc2FtcGxpbmdfcmF0ZSUyMiU1RCk=",highlighted:`<span class="hljs-built_in">print</span>(sample[<span class="hljs-string">&quot;text&quot;</span>])
Audio(sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], rate=sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>])`,wrap:!1}}),bl=new h({props:{code:"ZW50b25jZXMlMjB0ZSUyMGRlbGVsaXRhciVDMyVBMXMlMjBlbiUyMGplaG92JUMzJUExJTIweSUyMHlvJTIwdGUlMjBoYXIlQzMlQTklMjBzdWJpciUyMHNvYnJlJTIwbGFzJTIwYWx0dXJhcyUyMGRlJTIwbGElMjB0aWVycmElMjB5JTIwdGUlMjBkYXIlQzMlQTklMjAlQzMlQTElMjBjb21lciUyMGxhJTIwaGVyZWRhZCUyMGRlJTIwamFjb2IlMjB0dSUyMHBhZHJlJTIwcG9ycXVlJTIwbGElMjBib2NhJTIwZGUlMjBqZWhvdiVDMyVBMSUyMGxvJTIwaGElMjBoYWJsYWRv",highlighted:'entonces <span class="hljs-keyword">te</span> delelitarás <span class="hljs-keyword">en</span> jehová y yo <span class="hljs-keyword">te</span> haré subir sobre las alturas <span class="hljs-keyword">de</span> <span class="hljs-keyword">la</span> tierra y <span class="hljs-keyword">te</span> daré á comer <span class="hljs-keyword">la</span> heredad <span class="hljs-keyword">de</span> jacob tu padre porque <span class="hljs-keyword">la</span> boca <span class="hljs-keyword">de</span> jehová lo ha hablado',wrap:!1}}),Cl=new h({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RC5jb3B5KCklMkMlMjBtYXhfbmV3X3Rva2VucyUzRDI1NiUyQyUyMGdlbmVyYXRlX2t3YXJncyUzRCU3QiUyMnRhc2slMjIlM0ElMjAlMjJ0cmFuc2NyaWJlJTIyJTdEKQ==",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>].copy(), max_new_tokens=<span class="hljs-number">256</span>, generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;transcribe&quot;</span>})',wrap:!1}}),Rl=new h({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMEVudG9uY2VzJTIwdGUlMjBkZWxlaXRhciVDMyVBMXMlMjBlbiUyMEplaG92JUMzJUExJTIweSUyMHlvJTIwdGUlMjBoYXIlQzMlQTklMjBzdWJpciUyMHNvYnJlJTIwbGFzJTIwYWx0dXJhcyUyMGRlJTIwbGElMjB0aWVycmElMjB5JTIwdGUlMjBkYXIlQzMlQTklMjBhJTIwY29tZXIlMjBsYSUyMGhlcmVkYWQlMjBkZSUyMEphY29iJTIwdHUlMjBwYWRyZSUyMHBvcnF1ZSUyMGxhJTIwYm9jYSUyMGRlJTIwSmVob3YlQzMlQTElMjBsbyUyMGhhJTIwaGFibGFkby4nJTdE",highlighted:'{&#x27;text&#x27;: &#x27; Entonces <span class="hljs-keyword">te</span> deleitarás <span class="hljs-keyword">en</span> Jehová y yo <span class="hljs-keyword">te</span> haré subir sobre las alturas <span class="hljs-keyword">de</span> <span class="hljs-keyword">la</span> tierra y <span class="hljs-keyword">te</span> daré a comer <span class="hljs-keyword">la</span> heredad <span class="hljs-keyword">de</span> Jacob tu padre porque <span class="hljs-keyword">la</span> boca <span class="hljs-keyword">de</span> Jehová lo ha hablado.&#x27;}',wrap:!1}}),El=new h({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjU2JTJDJTIwZ2VuZXJhdGVfa3dhcmdzJTNEJTdCJTIydGFzayUyMiUzQSUyMCUyMnRyYW5zbGF0ZSUyMiU3RCk=",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>], max_new_tokens=<span class="hljs-number">256</span>, generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;translate&quot;</span>})',wrap:!1}}),kl=new h({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMFNvJTIweW91JTIwd2lsbCUyMGNob29zZSUyMGluJTIwSmVob3ZhaCUyMGFuZCUyMEklMjB3aWxsJTIwcmFpc2UlMjB5b3UlMjBvbiUyMHRoZSUyMGhlaWdodHMlMjBvZiUyMHRoZSUyMGVhcnRoJTIwYW5kJTIwSSUyMHdpbGwlMjBnaXZlJTIweW91JTIwdGhlJTIwaG9ub3IlMjBvZiUyMEphY29iJTIwdG8lMjB5b3VyJTIwZmF0aGVyJTIwYmVjYXVzZSUyMHRoZSUyMHZvaWNlJTIwb2YlMjBKZWhvdmFoJTIwaGFzJTIwc3Bva2VuJTIwdG8lMjB5b3UuJyU3RA==",highlighted:'<span class="hljs-comment">{&#x27;text&#x27;: &#x27; So you will choose in Jehovah and I will raise you on the heights of the earth and I will give you the honor of Jacob to your father because the voice of Jehovah has spoken to you.&#x27;}</span>',wrap:!1}}),xl=new re({props:{title:"长篇转写和时间戳",local:"长篇转写和时间戳",headingTag:"h2"}}),Hl=new h({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBdGFyZ2V0X2xlbmd0aF9pbl9tJTIwJTNEJTIwNSUwQSUwQSUyMyUyMCVFNSVCMCU4NiVFNSU4OCU4NiVFOSU5MiU5RiVFNiU5NSVCMCVFOCVCRCVBQyVFNCVCOCVCQSVFNyVBNyU5MiVFNiU5NSVCMCVFRiVCQyU4OColMjA2MCVFRiVCQyU4OSVFRiVCQyU4QyVFNSU4NiU4RCVFOCVCRCVBQyVFNCVCOCVCQSVFOSU4NyU4NyVFNyU5NCVBOCVFNyU4MiVCOSVFNiU5NSVCMCVFRiVCQyU4OColMjBzYW1wbGluZyUyMHJhdGUlRUYlQkMlODklMEFzYW1wbGluZ19yYXRlJTIwJTNEJTIwcGlwZS5mZWF0dXJlX2V4dHJhY3Rvci5zYW1wbGluZ19yYXRlJTBBdGFyZ2V0X2xlbmd0aF9pbl9zYW1wbGVzJTIwJTNEJTIwdGFyZ2V0X2xlbmd0aF9pbl9tJTIwKiUyMDYwJTIwKiUyMHNhbXBsaW5nX3JhdGUlMEElMEElMjMlMjAlRTklODElOEQlRTUlOEUlODYlRTYlOTUlQjAlRTYlOEQlQUUlRTklOUIlODYlRUYlQkMlOEMlRTYlOEIlQkMlRTYlOEUlQTUlRTYlQTAlQjclRTYlOUMlQUMlRTclOUIlQjQlRTUlODglQjAlRTklOTUlQkYlRTUlQkElQTYlRTglQkUlQkUlRTUlODglQjAlRTclOUIlQUUlRTYlQTAlODclMEFsb25nX2F1ZGlvJTIwJTNEJTIwJTVCJTVEJTBBZm9yJTIwc2FtcGxlJTIwaW4lMjBkYXRhc2V0JTNBJTBBJTIwJTIwJTIwJTIwbG9uZ19hdWRpby5leHRlbmQoc2FtcGxlJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCklMEElMjAlMjAlMjAlMjBpZiUyMGxlbihsb25nX2F1ZGlvKSUyMCUzRSUyMHRhcmdldF9sZW5ndGhfaW5fc2FtcGxlcyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJyZWFrJTBBJTBBbG9uZ19hdWRpbyUyMCUzRCUyMG5wLmFzYXJyYXkobG9uZ19hdWRpbyklMEElMEElMjMlMjAlRTclQkIlOTMlRTYlOUUlOUMlRTUlQTYlODIlRTQlQkQlOTUlRUYlQkMlOUYlMEFzZWNvbmRzJTIwJTNEJTIwbGVuKGxvbmdfYXVkaW8pJTIwJTJGJTIwMTYwMDAlMEFtaW51dGVzJTJDJTIwc2Vjb25kcyUyMCUzRCUyMGRpdm1vZChzZWNvbmRzJTJDJTIwNjApJTBBcHJpbnQoZiUyMkxlbmd0aCUyMG9mJTIwYXVkaW8lMjBzYW1wbGUlMjBpcyUyMCU3Qm1pbnV0ZXMlN0QlMjBtaW51dGVzJTIwJTdCc2Vjb25kcyUzQS4yZiU3RCUyMHNlY29uZHMlMjIp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

target_length_in_m = <span class="hljs-number">5</span>

<span class="hljs-comment"># 将分钟数转为秒数（* 60），再转为采用点数（* sampling rate）</span>
sampling_rate = pipe.feature_extractor.sampling_rate
target_length_in_samples = target_length_in_m * <span class="hljs-number">60</span> * sampling_rate

<span class="hljs-comment"># 遍历数据集，拼接样本直到长度达到目标</span>
long_audio = []
<span class="hljs-keyword">for</span> sample <span class="hljs-keyword">in</span> dataset:
    long_audio.extend(sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>])
    <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(long_audio) &gt; target_length_in_samples:
        <span class="hljs-keyword">break</span>

long_audio = np.asarray(long_audio)

<span class="hljs-comment"># 结果如何？</span>
seconds = <span class="hljs-built_in">len</span>(long_audio) / <span class="hljs-number">16000</span>
minutes, seconds = <span class="hljs-built_in">divmod</span>(seconds, <span class="hljs-number">60</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Length of audio sample is <span class="hljs-subst">{minutes}</span> minutes <span class="hljs-subst">{seconds:<span class="hljs-number">.2</span>f}</span> seconds&quot;</span>)`,wrap:!1}}),Nl=new h({props:{code:"TGVuZ3RoJTIwb2YlMjBhdWRpbyUyMHNhbXBsZSUyMGlzJTIwNS4wJTIwbWludXRlcyUyMDE3LjIyJTIwc2Vjb25kcw==",highlighted:'<span class="hljs-attribute">Length</span> of audio sample is <span class="hljs-number">5</span>.<span class="hljs-number">0</span> minutes <span class="hljs-number">17</span>.<span class="hljs-number">22</span> seconds',wrap:!1}}),zl=new h({props:{code:"cGlwZSglMEElMjAlMjAlMjAlMjBsb25nX2F1ZGlvJTJDJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QyNTYlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0ZV9rd2FyZ3MlM0QlN0IlMjJ0YXNrJTIyJTNBJTIwJTIydHJhbnNjcmliZSUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMGNodW5rX2xlbmd0aF9zJTNEMzAlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEOCUyQyUwQSk=",highlighted:`pipe(
    long_audio,
    max_new_tokens=<span class="hljs-number">256</span>,
    generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;transcribe&quot;</span>},
    chunk_length_s=<span class="hljs-number">30</span>,
    batch_size=<span class="hljs-number">8</span>,
)`,wrap:!1}}),Xl=new h({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMEVudG9uY2VzJTIwdGUlMjBkZWxlaXRhciVDMyVBMXMlMjBlbiUyMEplaG92JUMzJUExJTJDJTIweSUyMHlvJTIwdGUlMjBoYXIlQzMlQTklMjBzdWJpciUyMHNvYnJlJTIwbGFzJTIwYWx0dXJhcyUyMGRlJTIwbGElMjB0aWVycmElMkMlMjB5JTIwdGUlMjBkYXIlQzMlQTklMjBhJTIwY29tZXIlMjBsYSUwQWhlcmVkYWQlMjBkZSUyMEphY29iJTIwdHUlMjBwYWRyZSUyQyUyMHBvcnF1ZSUyMGxhJTIwYm9jYSUyMGRlJTIwSmVob3YlQzMlQTElMjBsbyUyMGhhJTIwaGFibGFkby4lMjBub3NvdHJvcyUyMGN1cmFkb3MuJTIwVG9kb3MlMjBub3NvdHJvcyUyMG5vcyUyMGRlc2NhcnJpYW1vcyUwQWNvbW8lMjBiZWphcyUyQyUyMGNhZGElMjBjdWFsJTIwc2UlMjBhcGFydCVDMyVCMyUyMHBvciUyMHN1JTIwY2FtaW5vJTJDJTIwbWFzJTIwSmVob3YlQzMlQTElMjBjYXJnJUMzJUIzJTIwZW4lMjAlQzMlQTlsJTIwZWwlMjBwZWNhZG8lMjBkZSUyMHRvZG9zJTIwbm9zb3Ryb3MuLi4=",highlighted:`{&#x27;text&#x27;: &#x27; Entonces <span class="hljs-keyword">te</span> deleitarás <span class="hljs-keyword">en</span> Jehová, y yo <span class="hljs-keyword">te</span> haré subir sobre las alturas <span class="hljs-keyword">de</span> <span class="hljs-keyword">la</span> tierra, y <span class="hljs-keyword">te</span> daré a comer <span class="hljs-keyword">la</span>
heredad <span class="hljs-keyword">de</span> Jacob tu padre, porque <span class="hljs-keyword">la</span> boca <span class="hljs-keyword">de</span> Jehová lo ha hablado. nosotros curados. Todos nosotros nos descarriamos
como bejas, cada cual <span class="hljs-keyword">se</span> apartó por <span class="hljs-keyword">su</span> camino, mas Jehová cargó <span class="hljs-keyword">en</span> é<span class="hljs-keyword">l</span> el pecado <span class="hljs-keyword">de</span> todos nosotros...`,wrap:!1}}),Dl=new h({props:{code:"cGlwZSglMEElMjAlMjAlMjAlMjBsb25nX2F1ZGlvJTJDJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QyNTYlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0ZV9rd2FyZ3MlM0QlN0IlMjJ0YXNrJTIyJTNBJTIwJTIydHJhbnNjcmliZSUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMGNodW5rX2xlbmd0aF9zJTNEMzAlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEOCUyQyUwQSUyMCUyMCUyMCUyMHJldHVybl90aW1lc3RhbXBzJTNEVHJ1ZSUyQyUwQSklNUIlMjJjaHVua3MlMjIlNUQ=",highlighted:`pipe(
    long_audio,
    max_new_tokens=<span class="hljs-number">256</span>,
    generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;transcribe&quot;</span>},
    chunk_length_s=<span class="hljs-number">30</span>,
    batch_size=<span class="hljs-number">8</span>,
    return_timestamps=<span class="hljs-literal">True</span>,
)[<span class="hljs-string">&quot;chunks&quot;</span>]`,wrap:!1}}),le=new h({props:{code:"JTVCJTdCJ3RpbWVzdGFtcCclM0ElMjAoMC4wJTJDJTIwMjYuNCklMkMlMEElMjAlMjAndGV4dCclM0ElMjAnJTIwRW50b25jZXMlMjB0ZSUyMGRlbGVpdGFyJUMzJUExcyUyMGVuJTIwSmVob3YlQzMlQTElMkMlMjB5JTIweW8lMjB0ZSUyMGhhciVDMyVBOSUyMHN1YmlyJTIwc29icmUlMjBsYXMlMjBhbHR1cmFzJTIwZGUlMjBsYSUyMHRpZXJyYSUyQyUyMHklMjB0ZSUyMGRhciVDMyVBOSUyMGElMjBjb21lciUyMGxhJTIwaGVyZWRhZCUyMGRlJTIwSmFjb2IlMjB0dSUyMHBhZHJlJTJDJTIwcG9ycXVlJTIwbGElMjBib2NhJTIwZGUlMjBKZWhvdiVDMyVBMSUyMGxvJTIwaGElMjBoYWJsYWRvLiUyMG5vc290cm9zJTIwY3VyYWRvcy4lMjBUb2RvcyUyMG5vc290cm9zJTIwbm9zJTIwZGVzY2FycmlhbW9zJTIwY29tbyUyMGJlamFzJTJDJTIwY2FkYSUyMGN1YWwlMjBzZSUyMGFwYXJ0JUMzJUIzJTIwcG9yJTIwc3UlMjBjYW1pbm8lMkMnJTdEJTJDJTBBJTIwJTdCJ3RpbWVzdGFtcCclM0ElMjAoMjYuNCUyQyUyMDMyLjQ4KSUyQyUwQSUyMCUyMCd0ZXh0JyUzQSUyMCclMjBtYXMlMjBKZWhvdiVDMyVBMSUyMGNhcmclQzMlQjMlMjBlbiUyMCVDMyVBOWwlMjBlbCUyMHBlY2FkbyUyMGRlJTIwdG9kb3MlMjBub3NvdHJvcy4lMjBObyUyMGVzJTIwcXVlJTIwcGFydGFzJTIwdHUlMjBwYW4lMjBjb24lMjBlbCclN0QlMkMlMEElMjAlN0IndGltZXN0YW1wJyUzQSUyMCgzMi40OCUyQyUyMDM4LjQpJTJDJTBBJTIwJTIwJ3RleHQnJTNBJTIwJyUyMGhhbWJyaWVudG8lMjB5JTIwYSUyMGxvcyUyMGhvbWJyZXMlMjBoZXJyYW50ZXMlMjBtZXRhcyUyMGVuJTIwY2FzYSUyQyUyMHF1ZSUyMGN1YW5kbyUyMHZpZXJlcyUyMGFsJTIwZGVzbnVkbyUyMGxvJTIwY3VicmFzJTIweSUyMG5vJyU3RCUyQyUwQSUyMC4uLg==",highlighted:`[{<span class="hljs-symbol">&#x27;timestamp</span><span class="hljs-symbol">&#x27;:</span> (<span class="hljs-name">0.0</span>, <span class="hljs-number">26.4</span>),
  <span class="hljs-symbol">&#x27;text</span><span class="hljs-symbol">&#x27;:</span> &#x27; Entonces te deleitarás en Jehová, y yo te haré subir sobre las alturas de la tierra, y te daré a comer la heredad de Jacob tu padre, porque la boca de Jehová lo ha hablado. nosotros curados. Todos nosotros nos descarriamos como bejas, cada cual se apartó por su camino,&#x27;},
 {<span class="hljs-symbol">&#x27;timestamp</span><span class="hljs-symbol">&#x27;:</span> (<span class="hljs-name">26.4</span>, <span class="hljs-number">32.48</span>),
  <span class="hljs-symbol">&#x27;text</span><span class="hljs-symbol">&#x27;:</span> &#x27; mas Jehová cargó en él el pecado de todos nosotros. No es que partas tu pan con el&#x27;},
 {<span class="hljs-symbol">&#x27;timestamp</span><span class="hljs-symbol">&#x27;:</span> (<span class="hljs-name">32.48</span>, <span class="hljs-number">38.4</span>),
  <span class="hljs-symbol">&#x27;text</span><span class="hljs-symbol">&#x27;:</span> &#x27; hambriento y a los hombres herrantes metas en casa, que cuando vieres al desnudo lo cubras y no&#x27;},
 ...`,wrap:!1}}),se=new re({props:{title:"总结",local:"总结",headingTag:"h2"}}),pe=new Fa({props:{source:"https://github.com/huggingface/audio-transformers-course/blob/main/chapters/zh-CN/chapter5/asr_models.mdx"}}),{c(){j=p("meta"),me=a(),ye=p("p"),oe=a(),y(f.$$.fragment),he=a(),y(C.$$.fragment),we=a(),S=p("p"),S.innerHTML=Jt,Je=a(),R=p("p"),R.textContent=ct,ce=a(),B=p("ol"),B.innerHTML=jt,je=a(),E=p("p"),E.innerHTML=dt,de=a(),V=p("p"),V.textContent=ut,ue=a(),y(k.$$.fragment),Ie=a(),v=p("p"),v.innerHTML=It,be=a(),y(G.$$.fragment),fe=a(),x=p("p"),x.innerHTML=bt,Ce=a(),y($.$$.fragment),Se=a(),g=p("p"),g.textContent=ft,Re=a(),y(F.$$.fragment),Be=a(),H=p("p"),H.innerHTML=Ct,Ee=a(),y(W.$$.fragment),Ve=a(),N=p("p"),N.innerHTML=St,ke=a(),y(Z.$$.fragment),ve=a(),Y=p("p"),Y.innerHTML=Rt,Ge=a(),y(Q.$$.fragment),xe=a(),_=p("p"),_.innerHTML=Bt,$e=a(),y(L.$$.fragment),ge=a(),z=p("p"),z.textContent=Et,Fe=a(),y(A.$$.fragment),He=a(),X=p("p"),X.innerHTML=Vt,We=a(),q=p("ul"),q.innerHTML=kt,Ne=a(),O=p("p"),O.textContent=vt,Ze=a(),P=p("p"),P.innerHTML=Gt,Ye=a(),y(D.$$.fragment),Qe=a(),K=p("p"),K.innerHTML=xt,_e=a(),ll=p("p"),ll.textContent=$t,Le=a(),el=p("ol"),el.innerHTML=gt,ze=a(),sl=p("p"),sl.innerHTML=Ft,Ae=a(),tl=p("p"),tl.innerHTML=Ht,Xe=a(),al=p("p"),al.innerHTML=Wt,qe=a(),nl=p("p"),nl.textContent=Nt,Oe=a(),pl=p("p"),pl.innerHTML=Zt,Pe=a(),Ml=p("p"),Ml.innerHTML=Yt,De=a(),il=p("table"),il.innerHTML=Qt,Ke=a(),yl=p("p"),yl.innerHTML=_t,ls=a(),y(Tl.$$.fragment),es=a(),Ul=p("p"),Ul.innerHTML=Lt,ss=a(),y(rl.$$.fragment),ts=a(),ml=p("p"),ml.innerHTML=zt,as=a(),y(ol.$$.fragment),ns=a(),hl=p("p"),hl.textContent=At,ps=a(),y(wl.$$.fragment),Ms=a(),Jl=p("p"),Jl.innerHTML=Xt,is=a(),cl=p("p"),cl.innerHTML=qt,ys=a(),y(jl.$$.fragment),Ts=a(),dl=p("p"),dl.textContent=Ot,Us=a(),y(ul.$$.fragment),rs=a(),Il=p("p"),Il.innerHTML=Pt,ms=a(),y(bl.$$.fragment),os=a(),fl=p("p"),fl.innerHTML=Dt,hs=a(),y(Cl.$$.fragment),ws=a(),Sl=p("p"),Sl.innerHTML=Kt,Js=a(),y(Rl.$$.fragment),cs=a(),Bl=p("p"),Bl.innerHTML=la,js=a(),y(El.$$.fragment),ds=a(),Vl=p("p"),Vl.innerHTML=ea,us=a(),y(kl.$$.fragment),Is=a(),vl=p("p"),vl.textContent=sa,bs=a(),Gl=p("p"),Gl.innerHTML=ta,fs=a(),y(xl.$$.fragment),Cs=a(),$l=p("p"),$l.textContent=aa,Ss=a(),gl=p("p"),gl.textContent=na,Rs=a(),Fl=p("p"),Fl.textContent=pa,Bs=a(),y(Hl.$$.fragment),Es=a(),Wl=p("p"),Wl.innerHTML=Ma,Vs=a(),y(Nl.$$.fragment),ks=a(),Zl=p("p"),Zl.textContent=ia,vs=a(),Yl=p("ol"),Yl.innerHTML=ya,Gs=a(),Ql=p("p"),Ql.innerHTML=Ta,xs=a(),d=p("div"),d.innerHTML=Ua,$s=a(),w=p("p"),Ut=I("给样本分块的优势在于，转写后续的块"),gs=new yt(!1),Fs=I(" 不需要使用之前的块"),Hs=new yt(!1),Ws=I(` 的结果。拼接是在我们已经转写了所有块之后在块边界处进行的，所以转写的顺序并不重要。
该算法完全是 `),Me=p("strong"),Me.textContent=ra,rt=I("，所以我们甚至可以同时转写块"),Ns=new yt(!1),Zs=I(" 和块"),Ys=new yt(!1),Qs=I("！这允许我们 "),ie=p("em"),ie.textContent=ma,mt=I(` 处理块，并通过并行运行模型，与顺序转写相比大大提升计算速度。
要了解更多关于 🤗 Transformers 中分块的知识，请参阅这篇 `),u=p("a"),u.textContent=oa,ot=I("。"),_s=a(),_l=p("p"),_l.innerHTML=ha,Ls=a(),Ll=p("p"),Ll.innerHTML=wa,zs=a(),y(zl.$$.fragment),As=a(),Al=p("p"),Al.innerHTML=Ja,Xs=a(),y(Xl.$$.fragment),qs=a(),ql=p("p"),ql.textContent=ca,Os=a(),Ol=p("p"),Ol.innerHTML=ja,Ps=a(),Pl=p("p"),Pl.innerHTML=da,Ds=a(),y(Dl.$$.fragment),Ks=a(),Kl=p("p"),Kl.innerHTML=ua,lt=a(),y(le.$$.fragment),et=a(),ee=p("p"),ee.textContent=Ia,st=a(),y(se.$$.fragment),tt=a(),te=p("p"),te.innerHTML=ba,at=a(),ae=p("p"),ae.innerHTML=fa,nt=a(),ne=p("p"),ne.innerHTML=Ca,pt=a(),y(pe.$$.fragment),Mt=a(),Te=p("p"),this.h()},l(l){const e=$a("svelte-u9bgzb",document.head);j=M(e,"META",{name:!0,content:!0}),e.forEach(s),me=n(l),ye=M(l,"P",{}),ht(ye).forEach(s),oe=n(l),T(f.$$.fragment,l),he=n(l),T(C.$$.fragment,l),we=n(l),S=M(l,"P",{"data-svelte-h":!0}),i(S)!=="svelte-l77zkn"&&(S.innerHTML=Jt),Je=n(l),R=M(l,"P",{"data-svelte-h":!0}),i(R)!=="svelte-18w3ej0"&&(R.textContent=ct),ce=n(l),B=M(l,"OL",{"data-svelte-h":!0}),i(B)!=="svelte-1cd6na7"&&(B.innerHTML=jt),je=n(l),E=M(l,"P",{"data-svelte-h":!0}),i(E)!=="svelte-1vgescg"&&(E.innerHTML=dt),de=n(l),V=M(l,"P",{"data-svelte-h":!0}),i(V)!=="svelte-oc5eoz"&&(V.textContent=ut),ue=n(l),T(k.$$.fragment,l),Ie=n(l),v=M(l,"P",{"data-svelte-h":!0}),i(v)!=="svelte-1kyz6ci"&&(v.innerHTML=It),be=n(l),T(G.$$.fragment,l),fe=n(l),x=M(l,"P",{"data-svelte-h":!0}),i(x)!=="svelte-1yevus4"&&(x.innerHTML=bt),Ce=n(l),T($.$$.fragment,l),Se=n(l),g=M(l,"P",{"data-svelte-h":!0}),i(g)!=="svelte-1l57vam"&&(g.textContent=ft),Re=n(l),T(F.$$.fragment,l),Be=n(l),H=M(l,"P",{"data-svelte-h":!0}),i(H)!=="svelte-1yevus4"&&(H.innerHTML=Ct),Ee=n(l),T(W.$$.fragment,l),Ve=n(l),N=M(l,"P",{"data-svelte-h":!0}),i(N)!=="svelte-1sop84d"&&(N.innerHTML=St),ke=n(l),T(Z.$$.fragment,l),ve=n(l),Y=M(l,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-1wr4yvi"&&(Y.innerHTML=Rt),Ge=n(l),T(Q.$$.fragment,l),xe=n(l),_=M(l,"P",{"data-svelte-h":!0}),i(_)!=="svelte-1yevus4"&&(_.innerHTML=Bt),$e=n(l),T(L.$$.fragment,l),ge=n(l),z=M(l,"P",{"data-svelte-h":!0}),i(z)!=="svelte-10241y8"&&(z.textContent=Et),Fe=n(l),T(A.$$.fragment,l),He=n(l),X=M(l,"P",{"data-svelte-h":!0}),i(X)!=="svelte-dq07i6"&&(X.innerHTML=Vt),We=n(l),q=M(l,"UL",{"data-svelte-h":!0}),i(q)!=="svelte-11mc7qy"&&(q.innerHTML=kt),Ne=n(l),O=M(l,"P",{"data-svelte-h":!0}),i(O)!=="svelte-zbwrzy"&&(O.textContent=vt),Ze=n(l),P=M(l,"P",{"data-svelte-h":!0}),i(P)!=="svelte-14bdpsl"&&(P.innerHTML=Gt),Ye=n(l),T(D.$$.fragment,l),Qe=n(l),K=M(l,"P",{"data-svelte-h":!0}),i(K)!=="svelte-178f4vl"&&(K.innerHTML=xt),_e=n(l),ll=M(l,"P",{"data-svelte-h":!0}),i(ll)!=="svelte-iy3o08"&&(ll.textContent=$t),Le=n(l),el=M(l,"OL",{"data-svelte-h":!0}),i(el)!=="svelte-mdyuiu"&&(el.innerHTML=gt),ze=n(l),sl=M(l,"P",{"data-svelte-h":!0}),i(sl)!=="svelte-1a3hcqd"&&(sl.innerHTML=Ft),Ae=n(l),tl=M(l,"P",{"data-svelte-h":!0}),i(tl)!=="svelte-g70k6a"&&(tl.innerHTML=Ht),Xe=n(l),al=M(l,"P",{"data-svelte-h":!0}),i(al)!=="svelte-3w08dm"&&(al.innerHTML=Wt),qe=n(l),nl=M(l,"P",{"data-svelte-h":!0}),i(nl)!=="svelte-1tjwm2o"&&(nl.textContent=Nt),Oe=n(l),pl=M(l,"P",{"data-svelte-h":!0}),i(pl)!=="svelte-dislf8"&&(pl.innerHTML=Zt),Pe=n(l),Ml=M(l,"P",{"data-svelte-h":!0}),i(Ml)!=="svelte-s80prs"&&(Ml.innerHTML=Yt),De=n(l),il=M(l,"TABLE",{"data-svelte-h":!0}),i(il)!=="svelte-rlvhoh"&&(il.innerHTML=Qt),Ke=n(l),yl=M(l,"P",{"data-svelte-h":!0}),i(yl)!=="svelte-15yyvgv"&&(yl.innerHTML=_t),ls=n(l),T(Tl.$$.fragment,l),es=n(l),Ul=M(l,"P",{"data-svelte-h":!0}),i(Ul)!=="svelte-1igj5eb"&&(Ul.innerHTML=Lt),ss=n(l),T(rl.$$.fragment,l),ts=n(l),ml=M(l,"P",{"data-svelte-h":!0}),i(ml)!=="svelte-1yevus4"&&(ml.innerHTML=zt),as=n(l),T(ol.$$.fragment,l),ns=n(l),hl=M(l,"P",{"data-svelte-h":!0}),i(hl)!=="svelte-12godbg"&&(hl.textContent=At),ps=n(l),T(wl.$$.fragment,l),Ms=n(l),Jl=M(l,"P",{"data-svelte-h":!0}),i(Jl)!=="svelte-p732zr"&&(Jl.innerHTML=Xt),is=n(l),cl=M(l,"P",{"data-svelte-h":!0}),i(cl)!=="svelte-rmvkbx"&&(cl.innerHTML=qt),ys=n(l),T(jl.$$.fragment,l),Ts=n(l),dl=M(l,"P",{"data-svelte-h":!0}),i(dl)!=="svelte-1ntu5d"&&(dl.textContent=Ot),Us=n(l),T(ul.$$.fragment,l),rs=n(l),Il=M(l,"P",{"data-svelte-h":!0}),i(Il)!=="svelte-1yevus4"&&(Il.innerHTML=Pt),ms=n(l),T(bl.$$.fragment,l),os=n(l),fl=M(l,"P",{"data-svelte-h":!0}),i(fl)!=="svelte-wcnmmn"&&(fl.innerHTML=Dt),hs=n(l),T(Cl.$$.fragment,l),ws=n(l),Sl=M(l,"P",{"data-svelte-h":!0}),i(Sl)!=="svelte-1yevus4"&&(Sl.innerHTML=Kt),Js=n(l),T(Rl.$$.fragment,l),cs=n(l),Bl=M(l,"P",{"data-svelte-h":!0}),i(Bl)!=="svelte-v4nmdy"&&(Bl.innerHTML=la),js=n(l),T(El.$$.fragment,l),ds=n(l),Vl=M(l,"P",{"data-svelte-h":!0}),i(Vl)!=="svelte-1yevus4"&&(Vl.innerHTML=ea),us=n(l),T(kl.$$.fragment,l),Is=n(l),vl=M(l,"P",{"data-svelte-h":!0}),i(vl)!=="svelte-1arj9ah"&&(vl.textContent=sa),bs=n(l),Gl=M(l,"P",{"data-svelte-h":!0}),i(Gl)!=="svelte-15ggwxb"&&(Gl.innerHTML=ta),fs=n(l),T(xl.$$.fragment,l),Cs=n(l),$l=M(l,"P",{"data-svelte-h":!0}),i($l)!=="svelte-nsxua5"&&($l.textContent=aa),Ss=n(l),gl=M(l,"P",{"data-svelte-h":!0}),i(gl)!=="svelte-13w71ar"&&(gl.textContent=na),Rs=n(l),Fl=M(l,"P",{"data-svelte-h":!0}),i(Fl)!=="svelte-a53lns"&&(Fl.textContent=pa),Bs=n(l),T(Hl.$$.fragment,l),Es=n(l),Wl=M(l,"P",{"data-svelte-h":!0}),i(Wl)!=="svelte-1yevus4"&&(Wl.innerHTML=Ma),Vs=n(l),T(Nl.$$.fragment,l),ks=n(l),Zl=M(l,"P",{"data-svelte-h":!0}),i(Zl)!=="svelte-tu44bd"&&(Zl.textContent=ia),vs=n(l),Yl=M(l,"OL",{"data-svelte-h":!0}),i(Yl)!=="svelte-1ce01pg"&&(Yl.innerHTML=ya),Gs=n(l),Ql=M(l,"P",{"data-svelte-h":!0}),i(Ql)!=="svelte-1qotn65"&&(Ql.innerHTML=Ta),xs=n(l),d=M(l,"DIV",{class:!0,"data-svelte-h":!0}),i(d)!=="svelte-ra5fet"&&(d.innerHTML=Ua),$s=n(l),w=M(l,"P",{});var J=ht(w);Ut=b(J,"给样本分块的优势在于，转写后续的块"),gs=Tt(J,!1),Fs=b(J," 不需要使用之前的块"),Hs=Tt(J,!1),Ws=b(J,` 的结果。拼接是在我们已经转写了所有块之后在块边界处进行的，所以转写的顺序并不重要。
该算法完全是 `),Me=M(J,"STRONG",{"data-svelte-h":!0}),i(Me)!=="svelte-1o0wrcf"&&(Me.textContent=ra),rt=b(J,"，所以我们甚至可以同时转写块"),Ns=Tt(J,!1),Zs=b(J," 和块"),Ys=Tt(J,!1),Qs=b(J,"！这允许我们 "),ie=M(J,"EM",{"data-svelte-h":!0}),i(ie)!=="svelte-5now7i"&&(ie.textContent=ma),mt=b(J,` 处理块，并通过并行运行模型，与顺序转写相比大大提升计算速度。
要了解更多关于 🤗 Transformers 中分块的知识，请参阅这篇 `),u=M(J,"A",{href:!0,rel:!0,"data-svelte-h":!0}),i(u)!=="svelte-zt77qd"&&(u.textContent=oa),ot=b(J,"。"),J.forEach(s),_s=n(l),_l=M(l,"P",{"data-svelte-h":!0}),i(_l)!=="svelte-kbaar0"&&(_l.innerHTML=ha),Ls=n(l),Ll=M(l,"P",{"data-svelte-h":!0}),i(Ll)!=="svelte-1arg4g2"&&(Ll.innerHTML=wa),zs=n(l),T(zl.$$.fragment,l),As=n(l),Al=M(l,"P",{"data-svelte-h":!0}),i(Al)!=="svelte-1yevus4"&&(Al.innerHTML=Ja),Xs=n(l),T(Xl.$$.fragment,l),qs=n(l),ql=M(l,"P",{"data-svelte-h":!0}),i(ql)!=="svelte-7vinxh"&&(ql.textContent=ca),Os=n(l),Ol=M(l,"P",{"data-svelte-h":!0}),i(Ol)!=="svelte-r4z4lk"&&(Ol.innerHTML=ja),Ps=n(l),Pl=M(l,"P",{"data-svelte-h":!0}),i(Pl)!=="svelte-16ol9aw"&&(Pl.innerHTML=da),Ds=n(l),T(Dl.$$.fragment,l),Ks=n(l),Kl=M(l,"P",{"data-svelte-h":!0}),i(Kl)!=="svelte-1yevus4"&&(Kl.innerHTML=ua),lt=n(l),T(le.$$.fragment,l),et=n(l),ee=M(l,"P",{"data-svelte-h":!0}),i(ee)!=="svelte-evj3k0"&&(ee.textContent=Ia),st=n(l),T(se.$$.fragment,l),tt=n(l),te=M(l,"P",{"data-svelte-h":!0}),i(te)!=="svelte-1n65jng"&&(te.innerHTML=ba),at=n(l),ae=M(l,"P",{"data-svelte-h":!0}),i(ae)!=="svelte-1x9tk48"&&(ae.innerHTML=fa),nt=n(l),ne=M(l,"P",{"data-svelte-h":!0}),i(ne)!=="svelte-f54qd1"&&(ne.innerHTML=Ca),pt=n(l),T(pe.$$.fragment,l),Mt=n(l),Te=M(l,"P",{}),ht(Te).forEach(s),this.h()},h(){Ue(j,"name","hf:doc:metadata"),Ue(j,"content",Wa),Ue(d,"class","flex justify-center"),gs.a=Fs,Hs.a=Ws,Ns.a=Zs,Ys.a=Qs,Ue(u,"href","https://huggingface.co/blog/asr-chunking"),Ue(u,"rel","nofollow")},m(l,e){c(document.head,j),t(l,me,e),t(l,ye,e),t(l,oe,e),U(f,l,e),t(l,he,e),U(C,l,e),t(l,we,e),t(l,S,e),t(l,Je,e),t(l,R,e),t(l,ce,e),t(l,B,e),t(l,je,e),t(l,E,e),t(l,de,e),t(l,V,e),t(l,ue,e),U(k,l,e),t(l,Ie,e),t(l,v,e),t(l,be,e),U(G,l,e),t(l,fe,e),t(l,x,e),t(l,Ce,e),U($,l,e),t(l,Se,e),t(l,g,e),t(l,Re,e),U(F,l,e),t(l,Be,e),t(l,H,e),t(l,Ee,e),U(W,l,e),t(l,Ve,e),t(l,N,e),t(l,ke,e),U(Z,l,e),t(l,ve,e),t(l,Y,e),t(l,Ge,e),U(Q,l,e),t(l,xe,e),t(l,_,e),t(l,$e,e),U(L,l,e),t(l,ge,e),t(l,z,e),t(l,Fe,e),U(A,l,e),t(l,He,e),t(l,X,e),t(l,We,e),t(l,q,e),t(l,Ne,e),t(l,O,e),t(l,Ze,e),t(l,P,e),t(l,Ye,e),U(D,l,e),t(l,Qe,e),t(l,K,e),t(l,_e,e),t(l,ll,e),t(l,Le,e),t(l,el,e),t(l,ze,e),t(l,sl,e),t(l,Ae,e),t(l,tl,e),t(l,Xe,e),t(l,al,e),t(l,qe,e),t(l,nl,e),t(l,Oe,e),t(l,pl,e),t(l,Pe,e),t(l,Ml,e),t(l,De,e),t(l,il,e),t(l,Ke,e),t(l,yl,e),t(l,ls,e),U(Tl,l,e),t(l,es,e),t(l,Ul,e),t(l,ss,e),U(rl,l,e),t(l,ts,e),t(l,ml,e),t(l,as,e),U(ol,l,e),t(l,ns,e),t(l,hl,e),t(l,ps,e),U(wl,l,e),t(l,Ms,e),t(l,Jl,e),t(l,is,e),t(l,cl,e),t(l,ys,e),U(jl,l,e),t(l,Ts,e),t(l,dl,e),t(l,Us,e),U(ul,l,e),t(l,rs,e),t(l,Il,e),t(l,ms,e),U(bl,l,e),t(l,os,e),t(l,fl,e),t(l,hs,e),U(Cl,l,e),t(l,ws,e),t(l,Sl,e),t(l,Js,e),U(Rl,l,e),t(l,cs,e),t(l,Bl,e),t(l,js,e),U(El,l,e),t(l,ds,e),t(l,Vl,e),t(l,us,e),U(kl,l,e),t(l,Is,e),t(l,vl,e),t(l,bs,e),t(l,Gl,e),t(l,fs,e),U(xl,l,e),t(l,Cs,e),t(l,$l,e),t(l,Ss,e),t(l,gl,e),t(l,Rs,e),t(l,Fl,e),t(l,Bs,e),U(Hl,l,e),t(l,Es,e),t(l,Wl,e),t(l,Vs,e),U(Nl,l,e),t(l,ks,e),t(l,Zl,e),t(l,vs,e),t(l,Yl,e),t(l,Gs,e),t(l,Ql,e),t(l,xs,e),t(l,d,e),t(l,$s,e),t(l,w,e),c(w,Ut),gs.m(Sa,w),c(w,Fs),Hs.m(Ra,w),c(w,Ws),c(w,Me),c(w,rt),Ns.m(Ba,w),c(w,Zs),Ys.m(Ea,w),c(w,Qs),c(w,ie),c(w,mt),c(w,u),c(w,ot),t(l,_s,e),t(l,_l,e),t(l,Ls,e),t(l,Ll,e),t(l,zs,e),U(zl,l,e),t(l,As,e),t(l,Al,e),t(l,Xs,e),U(Xl,l,e),t(l,qs,e),t(l,ql,e),t(l,Os,e),t(l,Ol,e),t(l,Ps,e),t(l,Pl,e),t(l,Ds,e),U(Dl,l,e),t(l,Ks,e),t(l,Kl,e),t(l,lt,e),U(le,l,e),t(l,et,e),t(l,ee,e),t(l,st,e),U(se,l,e),t(l,tt,e),t(l,te,e),t(l,at,e),t(l,ae,e),t(l,nt,e),t(l,ne,e),t(l,pt,e),U(pe,l,e),t(l,Mt,e),t(l,Te,e),it=!0},p:ka,i(l){it||(r(f.$$.fragment,l),r(C.$$.fragment,l),r(k.$$.fragment,l),r(G.$$.fragment,l),r($.$$.fragment,l),r(F.$$.fragment,l),r(W.$$.fragment,l),r(Z.$$.fragment,l),r(Q.$$.fragment,l),r(L.$$.fragment,l),r(A.$$.fragment,l),r(D.$$.fragment,l),r(Tl.$$.fragment,l),r(rl.$$.fragment,l),r(ol.$$.fragment,l),r(wl.$$.fragment,l),r(jl.$$.fragment,l),r(ul.$$.fragment,l),r(bl.$$.fragment,l),r(Cl.$$.fragment,l),r(Rl.$$.fragment,l),r(El.$$.fragment,l),r(kl.$$.fragment,l),r(xl.$$.fragment,l),r(Hl.$$.fragment,l),r(Nl.$$.fragment,l),r(zl.$$.fragment,l),r(Xl.$$.fragment,l),r(Dl.$$.fragment,l),r(le.$$.fragment,l),r(se.$$.fragment,l),r(pe.$$.fragment,l),it=!0)},o(l){m(f.$$.fragment,l),m(C.$$.fragment,l),m(k.$$.fragment,l),m(G.$$.fragment,l),m($.$$.fragment,l),m(F.$$.fragment,l),m(W.$$.fragment,l),m(Z.$$.fragment,l),m(Q.$$.fragment,l),m(L.$$.fragment,l),m(A.$$.fragment,l),m(D.$$.fragment,l),m(Tl.$$.fragment,l),m(rl.$$.fragment,l),m(ol.$$.fragment,l),m(wl.$$.fragment,l),m(jl.$$.fragment,l),m(ul.$$.fragment,l),m(bl.$$.fragment,l),m(Cl.$$.fragment,l),m(Rl.$$.fragment,l),m(El.$$.fragment,l),m(kl.$$.fragment,l),m(xl.$$.fragment,l),m(Hl.$$.fragment,l),m(Nl.$$.fragment,l),m(zl.$$.fragment,l),m(Xl.$$.fragment,l),m(Dl.$$.fragment,l),m(le.$$.fragment,l),m(se.$$.fragment,l),m(pe.$$.fragment,l),it=!1},d(l){l&&(s(me),s(ye),s(oe),s(he),s(we),s(S),s(Je),s(R),s(ce),s(B),s(je),s(E),s(de),s(V),s(ue),s(Ie),s(v),s(be),s(fe),s(x),s(Ce),s(Se),s(g),s(Re),s(Be),s(H),s(Ee),s(Ve),s(N),s(ke),s(ve),s(Y),s(Ge),s(xe),s(_),s($e),s(ge),s(z),s(Fe),s(He),s(X),s(We),s(q),s(Ne),s(O),s(Ze),s(P),s(Ye),s(Qe),s(K),s(_e),s(ll),s(Le),s(el),s(ze),s(sl),s(Ae),s(tl),s(Xe),s(al),s(qe),s(nl),s(Oe),s(pl),s(Pe),s(Ml),s(De),s(il),s(Ke),s(yl),s(ls),s(es),s(Ul),s(ss),s(ts),s(ml),s(as),s(ns),s(hl),s(ps),s(Ms),s(Jl),s(is),s(cl),s(ys),s(Ts),s(dl),s(Us),s(rs),s(Il),s(ms),s(os),s(fl),s(hs),s(ws),s(Sl),s(Js),s(cs),s(Bl),s(js),s(ds),s(Vl),s(us),s(Is),s(vl),s(bs),s(Gl),s(fs),s(Cs),s($l),s(Ss),s(gl),s(Rs),s(Fl),s(Bs),s(Es),s(Wl),s(Vs),s(ks),s(Zl),s(vs),s(Yl),s(Gs),s(Ql),s(xs),s(d),s($s),s(w),s(_s),s(_l),s(Ls),s(Ll),s(zs),s(As),s(Al),s(Xs),s(qs),s(ql),s(Os),s(Ol),s(Ps),s(Pl),s(Ds),s(Ks),s(Kl),s(lt),s(et),s(ee),s(st),s(tt),s(te),s(at),s(ae),s(nt),s(ne),s(pt),s(Mt),s(Te)),s(j),o(f,l),o(C,l),o(k,l),o(G,l),o($,l),o(F,l),o(W,l),o(Z,l),o(Q,l),o(L,l),o(A,l),o(D,l),o(Tl,l),o(rl,l),o(ol,l),o(wl,l),o(jl,l),o(ul,l),o(bl,l),o(Cl,l),o(Rl,l),o(El,l),o(kl,l),o(xl,l),o(Hl,l),o(Nl,l),o(zl,l),o(Xl,l),o(Dl,l),o(le,l),o(se,l),o(pe,l)}}}const Wa='{"title":"语音识别的预训练模型","local":"语音识别的预训练模型","sections":[{"title":"探索 CTC 模型","local":"探索-ctc-模型","sections":[],"depth":2},{"title":"过渡到 Seq2Seq","local":"过渡到-seq2seq","sections":[],"depth":2},{"title":"长篇转写和时间戳","local":"长篇转写和时间戳","sections":[],"depth":2},{"title":"总结","local":"总结","sections":[],"depth":2}],"depth":1}';function Na(wt){return va(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class La extends Ga{constructor(j){super(),xa(this,j,Na,Ha,Va,{})}}export{La as component};
