# Kurs materyalini anladığınızı kontrol edin

### 1. Örnekleme hızı hangi birimlerle ölçülür?

<Question
	choices={[
		{
			text: "dB",
			explain: "Hayır, genlik desibel (dB) cinsinden ölçülür."
		},
		{
			text: "Hz",
			explain: "Örnekleme hızı, bir saniyede alınan örnek sayısıdır ve hertz (Hz) cinsinden ölçülür.",
			correct: true
		},
		{
			text: "bit",
			explain: "Bitler, bir ses sinyalinin her örneğini temsil etmek için kullanılan bilgi bitlerinin sayısını ifade eden bit derinliğini tanımlamak için kullanılır.",
		}
	]}
/>

### 2. Büyük bir ses veri kümesini aktarırken, onu ne kadar sürede kullanmaya başlayabilirsiniz?

<Question
	choices={[
		{
			text: "Veri kümesinin tamamı indirilir indirilmez.",
			explain: "Veri akışının amacı, bir veri kümesini tamamen indirmeye gerek kalmadan verilerle çalışabilmektir."
		},
		{
			text: "16 örnek indirilir indirilmez",
			explain: "Tekrar Dene!"
		},
		{
			text: "İlk örnek indirildiği anda.",
			explain: "",
			correct: true
		}
	]}
/>

### 3. Spektrogram nedir?

<Question
	choices={[
		{
			text: "İlk olarak bir mikrofon tarafından yakalanan sesi dijitalleştiren bir cihaz, ses dalgalarını elektriksel bir sinyale dönüştürür.",
			explain: "Böyle bir elektriksel sinyali dijitalleştirmek için kullanılan bir cihaza Analog-Dijital Dönüştürücü denir. Tekrar deneyin!"
		},
		{
			text: "Ses sinyalinin zaman içindeki genlik değişimini gösteren bir grafik. Ayrıca sesin zaman *etki alanı* temsili olarak da bilinir.",
			explain: "Yukarıdaki açıklama spektrograma değil dalga formuna atıfta bulunmaktadır."
		},
		{
			text: "Zamanla değişen bir sinyalin frekans spektrumunun görsel temsili.",
			explain: "",
			correct: true
		}
	]}
/>

### 4. Ham ses verilerini Whisper'ın beklediği log-mel spektrogramına dönüştürmenin en kolay yolu nedir?

A.
```python
librosa.feature.melspectrogram(audio["array"])
```

B.
```python
feature_extractor = WhisperFeatureExtractor.from_pretrained("openai/whisper-small")
feature_extractor(audio["array"])
```

C.
```python
dataset.feature(audio["array"], model="whisper")
```

<Question
	choices={[
		{
			text: "A",
			explain: "`librosa.feature.melspectrogram()` bir güç spektrogramı oluşturur."
		},
		{
			text: "B",
			explain: "",
			correct: true
		},
		{
			text: "C",
			explain: "Dataset, Transformer modelleri için özellik hazırlamaz, bu işlem modelin ön işlemcisi tarafından yapılır."
		}
	]}
/>

### 5. 🤗 Hub'dan veri kümesini nasıl yüklersiniz?

A.
```python
from datasets import load_dataset

dataset = load_dataset(DATASET_NAME_ON_HUB)
```

B.
```python
import librosa

dataset = librosa.load(PATH_TO_DATASET)
```

C.
```python
from transformers import load_dataset

dataset = load_dataset(DATASET_NAME_ON_HUB)
```

<Question
	choices={[
		{
			text: "A",
			explain: "En iyi yol 🤗 Veri Kümeleri kütüphanesini kullanmaktır.",
			correct: true
		},
		{
			text: "B",
			explain: "Librosa.load, tek bir ses dosyasını bir yoldan ses zaman serisi ve örnekleme hızına sahip bir tuple'a yüklemek için kullanışlıdır, ancak birçok örnek ve çoklu özellik içeren tüm veri kümesini yüklemez."
		},
		{
			text: "C",
			explain: "load_dataset yöntemi 🤗 Transformers'ta değil, 🤗 Veri Kümeleri kitaplığında gelir."
		}
	]}
/>

### 6. Özel veri kümeniz 32 kHz örnekleme hızına sahip yüksek kaliteli ses içerir. Ses örneklerinin 16 kHz örnekleme hızına sahip olmasını bekleyen bir konuşma tanıma modeli eğitmek istiyorsunuz. Ne yapmalısın?

<Question
	choices={[
		{
			text: "Örnekleri olduğu gibi kullanın; model kolaylıkla daha yüksek kaliteli ses örneklerine genelleştirilecektir.",
			explain: "Dikkat mekanizmalarına dayanılması nedeniyle modellerin örnekleme oranları arasında genelleme yapması zordur."
		},
		{
			text: "Özel veri kümesindeki örnekleri alt örneklemek için 🤗 Veri Kümeleri kitaplığından Ses modülünü kullanın",
			explain: "",
			correct: true
		},
		{
			text: "Diğer tüm numuneleri atarak 2 kat alt numune alın.",
			explain: "Bu, takma ad adı verilen sinyalde bozulmalar yaratacaktır. Yeniden örneklemeyi doğru bir şekilde yapmak zordur ve en iyisi librosa veya 🤗 Veri Kümeleri gibi iyi test edilmiş kitaplıklara bırakılmasıdır."
		}
	]}
/>

### 7. Makine öğrenimi modeli tarafından oluşturulan bir spektrogramı dalga biçimine nasıl dönüştürebilirsiniz?

<Question
	choices={[
		{
			text: "Spektrogramdan bir dalga biçimini yeniden oluşturmak için ses kodlayıcı adı verilen bir sinir ağını kullanabiliriz.",
			explain: "Bu durumda faz bilgisi eksik olduğundan, dalga biçimini yeniden oluşturmak için bir ses kodlayıcı veya klasik Griffin-Lim algoritmasını kullanmamız gerekir.",
			correct: true
		},
		{
			text: "Oluşturulan spektrogramı dalga biçimine dönüştürmek için ters STFT'yi kullanabiliriz.",
			explain: "Oluşturulan bir spektrogramda, ters STFT'yi kullanmak için gerekli olan faz bilgisi eksiktir."
		},
		{
			text: "Makine öğrenimi modeli tarafından oluşturulan bir spektrogramı dalga biçimine dönüştüremezsiniz.",
			explain: "Tekrar Dene!"
		}
	]}
/>


<EditOnGithub source="https://github.com/huggingface/audio-transformers-course/blob/main/chapters/tr/chapter1/quiz.mdx" />