# Архитектуры Seq2Seq

В моделях CTC, рассмотренных в предыдущем разделе, использовалась только энкодерная часть архитектуры трансформера. В случае, когда мы добавляем декодер для создания модели энкодер-декодер, это называется моделью **последовательность-в-последовательность (sequence-to-sequence)** или
сокращенно seq2seq. Модель сопоставляет последовательность данных одного вида с последовательностью данных другого вида.

В моделях трансформеров, использующих только энкодер, энкодер делал предсказание для каждого элемента входной последовательности. Поэтому и входная, и выходная последовательности всегда будут иметь одинаковую длину. В случае моделей CTC, таких как Wav2Vec2, входная форма сигнала сначала
подвергалась даунсемплингу, но все равно на каждые 20 мс звука приходилось одно предсказание.

В модели seq2seq такого соответствия один к одному нет, и входная и выходная последовательности могут иметь разную длину. Это делает модели seq2seq пригодными для решения задач NLP, таких как резюмирование текста или перевод с одного языка на другой, а также для решения аудио задач, таких
как распознавание речи.

Архитектура декодера очень похожа на архитектуру энкодера, и в обоих случаях используются схожие слои, главной особенностью которых является самовнимание. Однако декодер выполняет иную задачу, чем энкодер. Чтобы понять, как это работает, рассмотрим, как модель seq2seq может выполнять
автоматическое распознавание речи.

## Автоматическое распознавание речи

Архитектура **Whisper** выглядит следующим образом (рисунок любезно предоставлен [блогом OpenAI Whisper](https://openai.com/blog/whisper/)):

<div class="flex justify-center">
    <img src="https://huggingface.co/blog/assets/111_fine_tune_whisper/whisper_architecture.svg" alt="Whisper is a transformer encoder-decoder model">
</div>

Все это должно выглядеть довольно знакомо. Слева находится **энкодер трансформера**. В качестве входного сигнала принимается лог-мел спектрограмма, которая кодируется для формирования последовательности скрытых состояний энкодера, извлекающих важные признаки из произносимой речи.
Этот тензор скрытых состояний представляет входную последовательность как единое целое и эффективно кодирует "смысл" поступившей на вход речи.

<Tip>
💡 Обычно в таких seq2seq-моделях в качестве входных данных используются спектрограммы. Однако модель seq2seq может быть разработана и для работы непосредственно с формой волны звука.
</Tip>

Затем выход энкодера передается в **декодер трансформера**, показанный справа, с помощью механизма, называемого **перекрёстным вниманием (cross-attention)**. Это похоже на самовнимание (self-attention), но внимание направлено на выход энкодера. С этого момента энкодер больше не нужен.

Декодер предсказывает последовательность текстовых токенов **авторегрессивным** способом, по одному токену за раз, начиная с начальной последовательности, в которой есть только "стартовый" токен (`SOT` в случае Whisper). На каждом следующем временном интервале предыдущая выходная
последовательность подается обратно в декодер в качестве новой входной последовательности. Таким образом, декодер выдает по одному новому токену за раз, неуклонно наращивая выходную последовательность, пока не спрогнозирует "конечный" токен или не будет достигнуто максимальное количество
временных шагов.

Хотя архитектура декодера в основном идентична архитектуре кодера, есть два существенных отличия:

1. декодер имеет механизм перекрестного внимания, который позволяет ему просматривать представление энкодера о входной последовательности
2. внимание декодера является каузальным - декодер не имеет права заглядывать в будущее.

В этом случае декодер играет роль **языковой модели**, обрабатывая представления скрытых состояний, полученные от энкодера, и генерируя соответствующие текстовые транскрипции. Это более мощный подход, чем CTC, даже если модель CTC сочетается с внешней языковой моделью, так как система
seq2seq может быть обучена от начала до конца с использованием одних и тех же обучающих данных и функции потерь, что обеспечивает большую гибкость и в целом более высокую производительность.

<Tip>
💡 В то время как модель CTC выводит последовательность отдельных символов, токены, предсказываемые Whisper, представляют собой полные слова или фрагменты слов. Он использует токенизатор из GPT-2 и имеет 50k+ уникальных токенов. Поэтому модель seq2seq может выдать гораздо более короткую
последовательность, чем модель CTC для той же транскрипции.
</Tip>

Типичной функцией потерь для seq2seq ASR-модели является функция кросс-энтропии, поскольку последний слой модели предсказывает распределение вероятностей по возможным токенам. Обычно это сочетается с такими методами, как [лучевой поиск для генерации конечной последовательности](https://huggingface.co/blog/how-to-generate). Метрикой распознавания речи является WER или word error rate, которая измеряет, сколько замен, вставок и удалений необходимо для превращения предсказанного текста в целевой - чем меньше, тем лучше результат.

## Преобразование текста в речь (Text-to-speech, TTS)

Возможно, это вас не удивит: Модель seq2seq для TTS работает по сути так же, как и описанная выше, но входы и выходы поменяны местами! Энкодер трансформера принимает последовательность текстовых токенов и извлекает из нее последовательность скрытых состояний, которые представляют собой
входной текст. Декодер трансформера применяет перекрестное внимание к выходу энкодера и прогнозирует спектрограмму.

<Tip>
💡 Напомним, что спектрограмма создается путем взятия частотного спектра последовательных временных отрезков звуковой волны и их суммирования. Другими словами, спектрограмма - это последовательность, элементами которой являются (лог-мел) частотные спектры, по одному на каждый временной
интервал.
</Tip>

В ASR-модели декодер запускался с помощью последовательности, содержащей только специальный токен "start". Для модели TTS мы можем начать декодирование со спектрограммы длиной один, состоящей из одних нулей, которая выступает в качестве "стартового токена". Учитывая эту начальную
спектрограмму и перекрестное внимание к представлениям скрытых состояний энкодера, декодер предсказывает следующий временной интервал для этой спектрограммы, постепенно увеличивая спектрограмму на один временной интервал.

<div class="flex justify-center">
    <img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/speecht5_decoding.png" alt="The audio waveform gets mapped to a shorter sequence of hidden-states">
</div>

Но как декодер узнает, когда нужно остановиться? В модели **SpeechT5** это решается тем, что декодер предсказывает вторую последовательность. Она содержит вероятность того, что текущий временной шаг является последним. При генерации звука в момент инференса, если эта вероятность превышает
определенный порог (скажем, 0,5), декодер сигнализирует о том, что спектрограмма закончена и цикл генерации должен завершиться.

После завершения декодирования и получения выходной последовательности, содержащей спектрограмму, SpeechT5 использует так называемую **пост-сеть (post-net)**, состоящую из нескольких сверточных слоев, для уточнения спектрограммы.

При обучении модели TTS в качестве целей также используются спектрограммы, а в качестве потерь - L1 или MSE. Во время инференса мы хотим преобразовать выходную спектрограмму в форму звукового сигнала, чтобы ее можно было прослушать. Для этого используется внешняя модель - **вокодер
(vocoder)**. Этот вокодер не является частью архитектуры seq2seq и обучается отдельно.

Сложность TTS заключается в том, что это отображение "один-ко-многим". При преобразовании речи в текст существует только один правильный выходной текст, соответствующий входной речи, в то время как при преобразовании текста в речь входной текст может быть сопоставлен с множеством возможных
звуков речи. Например, разные дикторы могут выбирать для акцентирования внимания разные части предложения. Это затрудняет оценку моделей TTS. В связи с этим значение потерь L1 или MSE на самом деле не имеет большого смысла - существует множество способов представить один и тот же текст на
спектрограмме. Именно поэтому модели TTS обычно оцениваются слушателями, используя метрику, известную как MOS (mean opinion score) или cредняя экспертная оценка.

## Заключение

Подход seq2seq является более мощным, чем модель, основанная только на энкодере. Благодаря разделению входной последовательности энкодера и выходной последовательности декодера, выравнивание звука и текста становится менее проблематичным. <!-- Модель учится выполнять это выравнивание с
помощью механизма внимания. -->

Однако модель энкодер-декодер также является более медленной, поскольку процесс декодирования происходит по одному шагу за раз, а не все сразу. Чем длиннее последовательность, тем медленнее прогнозирование. Авторегрессивные модели также могут застревать на повторах или пропускать слова.
Такие методы, как лучевой поиск, позволяют улучшить качество прогнозов, но при этом еще больше замедляют декодирование.


<EditOnGithub source="https://github.com/huggingface/audio-transformers-course/blob/main/chapters/ru/chapter3/seq2seq.mdx" />