# Архитектуры классификации аудио

Цель классификации аудио - предсказать метку класса для входного аудиосигнала. Модель может предсказать одну метку класса, охватывающую всю входную последовательность, или предсказать метку для каждого звукового фрейма - обычно каждые 20 миллисекунд входного звука - в этом случае вывод
модели представляет собой последовательность вероятностей метки класса. Примером первого может служить определение того, какая птица издает тот или иной звук; примером второго - диаризация диктора, когда модель предсказывает, какой диктор говорит в тот или иной момент.

## Классификация с использованием спектрограмм

Один из самых простых способов классификации звука - представить, что это задача классификации изображения!

Напомним, что спектрограмма - это двумерный тензор формы `(частоты, длина последовательности)`. В [главе об аудио данных](../chapter1/audio_data) мы строили эти спектрограммы в виде изображений. Угадайте, что? Мы можем буквально рассматривать спектрограмму как изображение и передавать ее в
обычную модель классификатора CNN, например ResNet, и получать очень хорошие прогнозы. Еще лучше использовать модель трансформер для работы с изображениями, например ViT.

Именно это и делает **Трансформер Аудио Спектрограммы (Audio Spectrogram Transformer - AST)**. Он использует модель ViT или Vision Transformer и передает ему на вход спектрограммы вместо обычных изображений. Благодаря слоям самовнимания трансформера модель лучше улавливает глобальный контекст,
чем CNN.

Как и ViT, модель AST разбивает спектрограмму звука на последовательность частично перекрывающихся фрагментов изображений размером 16×16 пикселей. Затем эта последовательность фрагментов проецируется в последовательность эмбдингов, которые, как обычно, подаются на вход энкодера трансформера.
AST является моделью трансформера состоящей только из энкодера, поэтому на выходе получается последовательность скрытых состояний, по одному на каждый входной фрагмент 16×16. Сверху находится простой слой классификации с сигмоидальной активацией для отображения скрытых состояний в вероятности
классификации.

<div class="flex justify-center">
    <img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/ast.png" alt="The audio spectrogram transformer works on a sequence of patches taken from the spectrogram">
</div>

Изображение из статьи [AST: Трансформер аудио спектрограммы](https://arxiv.org/pdf/2104.01778.pdf)

<Tip>
💡 Хотя здесь мы делаем вид, что спектрограммы - это то же самое, что и изображения, есть существенные различия. Например, смещение содержимого изображения вверх или вниз, как правило, не меняет смысла того, что на нем изображено. Однако смещение спектрограммы вверх или вниз приводит к
изменению частот, присутствующих в звуке, и полностью меняет его характер. Изображения инвариантны при трансляции, а спектрограммы - нет. Обращение со спектрограммами как с изображениями может хорошо работать на практике, но следует помнить, что это не совсем одно и то же.
</Tip>

## Любой трансформер может быть классификатором

В [предыдущем материале](ctc) вы убедились, что CTC - это эффективная методика автоматического распознавания речи с использованием только трансформера состоящего только из  энкодера.  Такие CTC модели уже являются классификаторами, прогнозирующими вероятности для меток классов из словаря
токенизатора. Мы можем взять модель CTC и превратить ее в классификатор звука общего назначения, изменив метки и обучив ее с помощью обычной функции потерь кросс-энтропии вместо специальной функции потерь CTC.

Например, в HF Transformers есть модель `Wav2Vec2ForCTC`, `Wav2Vec2ForSequenceClassification` и `Wav2Vec2ForAudioFrameClassification`. Различия между архитектурами этих моделей заключаются только в размере слоя классификации и используемой функции потерь.

Фактически, любая модель аудио трансформера состоящая только из энкодера, может быть превращена в классификатор аудиосигнала путем добавления слоя классификации поверх последовательности слоёв формирующих скрытые состояния. (Классификаторы обычно не нуждаются в декодере трансформера.)

Для прогнозирования единой классификационной оценки для всей последовательности (`Wav2Vec2ForSequenceClassification`) модель берет среднее значение по скрытым состояниям и передает его в слой классификации. На выходе получается одно распределение вероятностей.

Чтобы сделать отдельную классификацию для каждого аудио фрейма (`Wav2Vec2ForAudioFrameClassification`), классификатор запускается на последовательности скрытых состояний, поэтому выходом классификатора также является последовательность.


<EditOnGithub source="https://github.com/huggingface/audio-transformers-course/blob/main/chapters/ru/chapter3/classification.mdx" />